# PySNMP SMI module. Autogenerated from smidump -f python RSVP-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:35 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( BitRate, BurstSize, MessageSize, Port, Protocol, QosService, SessionNumber, SessionType, intSrvFlowStatus, ) = mibBuilder.importSymbols("INTEGRATED-SERVICES-MIB", "BitRate", "BurstSize", "MessageSize", "Port", "Protocol", "QosService", "SessionNumber", "SessionType", "intSrvFlowStatus")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( RowStatus, TextualConvention, TestAndIncr, TimeInterval, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TestAndIncr", "TimeInterval", "TimeStamp", "TruthValue")

# Types

class RefreshInterval(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class RsvpEncapsulation(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,1,)
    namedValues = namedval.NamedValues(("ip", 1), ("udp", 2), ("both", 3), )
    pass


# Objects

rsvp = ModuleIdentity((1, 3, 6, 1, 2, 1, 51)).setRevisions(("1995-11-03 05:00",))
if mibBuilder.loadTexts: rsvp.setOrganization("IETF RSVP Working Group")
if mibBuilder.loadTexts: rsvp.setContactInfo("       Fred Baker\nPostal: Cisco Systems\n        519 Lado Drive\n        Santa Barbara, California 93111\nTel:    +1 805 681 0115\nE-Mail: fred@cisco.com\n        John Krawczyk\nPostal: ArrowPoint Communications\n        235 Littleton Road\n        Westford, Massachusetts 01886\nTel:    +1 508 692 5875\nE-Mail: jjk@tiac.net\n\n        Arun Sastry\nPostal: Cisco Systems\n        210 W. Tasman Drive\n        San Jose, California 95134\nTel:    +1 408 526 7685\nE-Mail: arun@cisco.com")
if mibBuilder.loadTexts: rsvp.setDescription("The MIB module to describe the RSVP Protocol")
rsvpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 1))
rsvpSessionTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 1))
if mibBuilder.loadTexts: rsvpSessionTable.setDescription("A table of all sessions seen by a  given  sys-\ntem.")
rsvpSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 1, 1)).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"))
if mibBuilder.loadTexts: rsvpSessionEntry.setDescription("A single session seen by a given system.")
rsvpSessionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 1), SessionNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rsvpSessionNumber.setDescription("The number of this session.  This is for  SNMP\nIndexing  purposes  only and has no relation to\nany protocol value.")
rsvpSessionType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 2), SessionType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionType.setDescription("The type of session (IP4, IP6, IP6  with  flow\ninformation, etc).")
rsvpSessionDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionDestAddr.setDescription("The destination address used by all senders in\nthis  session.   This object may not be changed\nwhen the value of the RowStatus object is  'ac-\ntive'.")
rsvpSessionDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionDestAddrLength.setDescription("The CIDR prefix length of the session address,\nwhich  is  32  for  IP4  host and multicast ad-\ndresses, and 128 for IP6 addresses.   This  ob-\nject  may  not be changed when the value of the\nRowStatus object is 'active'.")
rsvpSessionProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 5), Protocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionProtocol.setDescription("The IP Protocol used by  this  session.   This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpSessionPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 6), Port()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionPort.setDescription("The UDP or TCP port number used as a  destina-\ntion  port for all senders in this session.  If\nthe IP protocol in use, specified  by  rsvpSen-\nderProtocol,  is  50  (ESP)  or  51  (AH), this\nrepresents a virtual destination  port  number.\nA  value of zero indicates that the IP protocol\nin use does not have ports.   This  object  may\nnot  be changed when the value of the RowStatus\nobject is 'active'.")
rsvpSessionSenders = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionSenders.setDescription("The number of distinct senders currently known\nto be part of this session.")
rsvpSessionReceivers = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionReceivers.setDescription("The number of reservations being requested  of\nthis system for this session.")
rsvpSessionRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 1, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSessionRequests.setDescription("The number of reservation requests this system\nis sending upstream for this session.")
rsvpSenderTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 2))
if mibBuilder.loadTexts: rsvpSenderTable.setDescription("Information describing the  state  information\ndisplayed by senders in PATH messages.")
rsvpSenderEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 2, 1)).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpSenderNumber"))
if mibBuilder.loadTexts: rsvpSenderEntry.setDescription("Information describing the  state  information\ndisplayed by a single sender's PATH message.")
rsvpSenderNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 1), SessionNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rsvpSenderNumber.setDescription("The number of this sender.  This is  for  SNMP\nIndexing  purposes  only and has no relation to\nany protocol value.")
rsvpSenderType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 2), SessionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderType.setDescription("The type of session (IP4, IP6, IP6  with  flow\ninformation, etc).")
rsvpSenderDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderDestAddr.setDescription("The destination address used by all senders in\nthis  session.   This object may not be changed\nwhen the value of the RowStatus object is  'ac-\ntive'.")
rsvpSenderAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAddr.setDescription("The source address used by this sender in this\nsession.   This  object may not be changed when\nthe value of the RowStatus object is 'active'.")
rsvpSenderDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderDestAddrLength.setDescription("The length of the destination address in bits.\nThis  is  the CIDR Prefix Length, which for IP4\nhosts and multicast addresses is 32 bits.  This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpSenderAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAddrLength.setDescription("The length of the sender's  address  in  bits.\nThis  is  the CIDR Prefix Length, which for IP4\nhosts and multicast addresses is 32 bits.  This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpSenderProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 7), Protocol()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderProtocol.setDescription("The IP Protocol used by  this  session.   This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpSenderDestPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 8), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderDestPort.setDescription("The UDP or TCP port number used as a  destina-\ntion  port for all senders in this session.  If\nthe IP protocol in use, specified  by  rsvpSen-\nderProtocol,  is  50  (ESP)  or  51  (AH), this\nrepresents a virtual destination  port  number.\nA  value of zero indicates that the IP protocol\nin use does not have ports.   This  object  may\nnot  be changed when the value of the RowStatus\nobject is 'active'.")
rsvpSenderPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 9), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderPort.setDescription("The UDP or TCP port number used  as  a  source\nport  for  this sender in this session.  If the\nIP protocol in use, specified by rsvpSenderPro-\ntocol is 50 (ESP) or 51 (AH), this represents a\ngeneralized port identifier (GPI).  A value  of\nzero indicates that the IP protocol in use does\nnot have ports.  This object may not be changed\nwhen  the value of the RowStatus object is 'ac-\ntive'.")
rsvpSenderFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderFlowId.setDescription("The flow ID that  this  sender  is  using,  if\nthis  is  an IPv6 session.")
rsvpSenderHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 11), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderHopAddr.setDescription("The address used  by  the  previous  RSVP  hop\n(which may be the original sender).")
rsvpSenderHopLih = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 12), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderHopLih.setDescription("The Logical Interface Handle used by the  pre-\nvious  RSVP  hop  (which  may  be  the original\nsender).")
rsvpSenderInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 13), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderInterface.setDescription("The ifIndex value of the  interface  on  which\nthis PATH message was most recently received.")
rsvpSenderTSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 14), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecRate.setDescription("The Average Bit  Rate  of  the  sender's  data\nstream.   Within  a transmission burst, the ar-\nrival rate may be as fast  as  rsvpSenderTSpec-\nPeakRate  (if  supported by the service model);\nhowever, averaged across two or more burst  in-\ntervals,  the  rate  should not exceed rsvpSen-\nderTSpecRate.\n\nNote that this is a prediction, often based  on\nthe  general  capability  of a type of codec or\nparticular encoding; the measured average  rate\nmay be significantly lower.")
rsvpSenderTSpecPeakRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 15), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecPeakRate.setDescription("The Peak Bit Rate of the sender's data stream.\nTraffic  arrival is not expected to exceed this\nrate at any time, apart  from  the  effects  of\njitter in the network.  If not specified in the\nTSpec, this returns zero or noSuchValue.")
rsvpSenderTSpecBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 16), BurstSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecBurst.setDescription("The size of the largest  burst  expected  from\nthe sender at a time.")
rsvpSenderTSpecMinTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 17), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecMinTU.setDescription("The minimum message size for  this  flow.  The\npolicing  algorithm will treat smaller messages\nas though they are this size.")
rsvpSenderTSpecMaxTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 18), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderTSpecMaxTU.setDescription("The maximum message size for  this  flow.  The\nadmission  algorithm  will  reject TSpecs whose\nMaximum Transmission Unit, plus  the  interface\nheaders, exceed the interface MTU.")
rsvpSenderInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 19), RefreshInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderInterval.setDescription("The interval between refresh messages  as  ad-\nvertised by the Previous Hop.")
rsvpSenderRSVPHop = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 20), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderRSVPHop.setDescription("If TRUE, the node believes that  the  previous\nIP  hop is an RSVP hop.  If FALSE, the node be-\nlieves that the previous IP hop may not  be  an\nRSVP hop.")
rsvpSenderLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 21), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderLastChange.setDescription("The time of the last change in this PATH  mes-\nsage;  This is either the first time it was re-\nceived or the time of the most recent change in\nparameters.")
rsvpSenderPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 22), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderPolicy.setDescription("The contents of the policy  object,  displayed\nas an uninterpreted string of octets, including\nthe object header.  In the absence of  such  an\nobject, this should be of zero length.")
rsvpSenderAdspecBreak = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 23), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecBreak.setDescription("The global break bit general  characterization\nparameter  from  the ADSPEC.  If TRUE, at least\none non-IS hop was detected in  the  path.   If\nFALSE, no non-IS hops were detected.")
rsvpSenderAdspecHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 24), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecHopCount.setDescription("The hop count general characterization parame-\nter  from  the  ADSPEC.   A  return  of zero or\nnoSuchValue indicates one of the following con-\nditions:\n\n   the invalid bit was set\n   the parameter was not present")
rsvpSenderAdspecPathBw = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 25), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecPathBw.setDescription("The path bandwidth estimate general character-\nization parameter from the ADSPEC.  A return of\nzero or noSuchValue indicates one of  the  fol-\nlowing conditions:\n\n   the invalid bit was set\n   the parameter was not present")
rsvpSenderAdspecMinLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 26), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecMinLatency.setDescription("The minimum path latency general characteriza-\ntion  parameter  from  the ADSPEC.  A return of\nzero or noSuchValue indicates one of  the  fol-\nlowing conditions:\n\n   the invalid bit was set\n   the parameter was not present")
rsvpSenderAdspecMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 27), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecMtu.setDescription("The composed Maximum Transmission Unit general\ncharacterization  parameter from the ADSPEC.  A\nreturn of zero or noSuchValue indicates one  of\nthe following conditions:\n\n   the invalid bit was set\n   the parameter was not present")
rsvpSenderAdspecGuaranteedSvc = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 28), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedSvc.setDescription("If TRUE, the ADSPEC contains a Guaranteed Ser-\nvice  fragment.   If FALSE, the ADSPEC does not\ncontain a Guaranteed Service fragment.")
rsvpSenderAdspecGuaranteedBreak = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 29), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedBreak.setDescription("If TRUE, the Guaranteed Service  fragment  has\nits  'break'  bit  set,  indicating that one or\nmore nodes along the path do  not  support  the\nguaranteed  service.   If  FALSE,  and rsvpSen-\nderAdspecGuaranteedSvc is TRUE, the 'break' bit\nis not set.\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns FALSE or noSuchValue.")
rsvpSenderAdspecGuaranteedCtot = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 30), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedCtot.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis   the  end-to-end  composed  value  for  the\nguaranteed service 'C' parameter.  A return  of\nzero  or  noSuchValue indicates one of the fol-\nlowing conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedDtot = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 31), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedDtot.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis   the  end-to-end  composed  value  for  the\nguaranteed service 'D' parameter.  A return  of\nzero  or  noSuchValue indicates one of the fol-\nlowing conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedCsum = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 32), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedCsum.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis  the  composed value for the guaranteed ser-\nvice 'C' parameter  since  the  last  reshaping\npoint.   A  return of zero or noSuchValue indi-\ncates one of the following conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedDsum = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 33), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedDsum.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis  the  composed value for the guaranteed ser-\nvice 'D' parameter  since  the  last  reshaping\npoint.   A  return of zero or noSuchValue indi-\ncates one of the following conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 34), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedHopCount.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis  the  service-specific  override  of the hop\ncount general characterization  parameter  from\nthe  ADSPEC.   A  return of zero or noSuchValue\nindicates one of the following conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedPathBw = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 35), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedPathBw.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis  the  service-specific  override of the path\nbandwidth  estimate  general   characterization\nparameter from the ADSPEC.  A return of zero or\nnoSuchValue indicates one of the following con-\nditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedMinLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 36), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedMinLatency.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis the service-specific override of the minimum\npath latency general characterization parameter\nfrom  the  ADSPEC.  A return of zero or noSuch-\nValue indicates one  of  the  following  condi-\ntions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecGuaranteedMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 37), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecGuaranteedMtu.setDescription("If rsvpSenderAdspecGuaranteedSvc is TRUE, this\nis  the  service-specific  override of the com-\nposed Maximum Transmission Unit general charac-\nterization parameter from the ADSPEC.  A return\nof zero or noSuchValue  indicates  one  of  the\nfollowing conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecGuaranteedSvc is FALSE, this\nreturns zero or noSuchValue.")
rsvpSenderAdspecCtrlLoadSvc = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 38), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadSvc.setDescription("If TRUE, the ADSPEC contains a Controlled Load\nService  fragment.   If  FALSE, the ADSPEC does\nnot contain a  Controlled  Load  Service  frag-\nment.")
rsvpSenderAdspecCtrlLoadBreak = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 39), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadBreak.setDescription("If TRUE, the Controlled Load Service  fragment\nhas its 'break' bit set, indicating that one or\nmore nodes along the path do  not  support  the\ncontrolled   load   service.    If  FALSE,  and\nrsvpSenderAdspecCtrlLoadSvc   is   TRUE,    the\n'break' bit is not set.\n\nIf rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\nreturns FALSE or noSuchValue.")
rsvpSenderAdspecCtrlLoadHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 40), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadHopCount.setDescription("If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\nis  the  service-specific  override  of the hop\ncount general characterization  parameter  from\nthe  ADSPEC.   A  return of zero or noSuchValue\nindicates one of the following conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\nreturns zero or noSuchValue.")
rsvpSenderAdspecCtrlLoadPathBw = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 41), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadPathBw.setDescription("If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\nis  the  service-specific  override of the path\nbandwidth  estimate  general   characterization\nparameter from the ADSPEC.  A return of zero or\nnoSuchValue indicates one of the following con-\nditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\nreturns zero or noSuchValue.")
rsvpSenderAdspecCtrlLoadMinLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 42), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadMinLatency.setDescription("If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\nis the service-specific override of the minimum\npath latency general characterization parameter\nfrom  the  ADSPEC.  A return of zero or noSuch-\nValue indicates one  of  the  following  condi-\ntions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\nreturns zero or noSuchValue.")
rsvpSenderAdspecCtrlLoadMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 43), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderAdspecCtrlLoadMtu.setDescription("If rsvpSenderAdspecCtrlLoadSvc is  TRUE,  this\nis  the  service-specific  override of the com-\nposed Maximum Transmission Unit general charac-\nterization parameter from the ADSPEC.  A return\nof zero or noSuchValue  indicates  one  of  the\nfollowing conditions:\n\n   the invalid bit was set\n   the parameter was not present\n\nIf rsvpSenderAdspecCtrlLoadSvc is  FALSE,  this\nreturns zero or noSuchValue.")
rsvpSenderStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 44), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpSenderStatus.setDescription("'active' for all active PATH  messages.   This\nobject  may  be used to install static PATH in-\nformation or delete PATH information.")
rsvpSenderTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 2, 1, 45), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderTTL.setDescription("The TTL value in the RSVP header that was last\nreceived.")
rsvpSenderOutInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 3))
if mibBuilder.loadTexts: rsvpSenderOutInterfaceTable.setDescription("List of outgoing interfaces that PATH messages\nuse.  The  ifIndex  is the ifIndex value of the\negress interface.")
rsvpSenderOutInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 3, 1)).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpSenderNumber"), (0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: rsvpSenderOutInterfaceEntry.setDescription("List of outgoing interfaces that a  particular\nPATH message has.")
rsvpSenderOutInterfaceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 3, 1, 1), RowStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpSenderOutInterfaceStatus.setDescription("'active' for all active PATH messages.")
rsvpResvTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 4))
if mibBuilder.loadTexts: rsvpResvTable.setDescription("Information describing the  state  information\ndisplayed by receivers in RESV messages.")
rsvpResvEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 4, 1)).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpResvNumber"))
if mibBuilder.loadTexts: rsvpResvEntry.setDescription("Information describing the  state  information\ndisplayed  by  a single receiver's RESV message\nconcerning a single sender.")
rsvpResvNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 1), SessionNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rsvpResvNumber.setDescription("The number of this reservation request.   This\nis  for  SNMP Indexing purposes only and has no\nrelation to any protocol value.")
rsvpResvType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 2), SessionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvType.setDescription("The type of session (IP4, IP6, IP6  with  flow\ninformation, etc).")
rsvpResvDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvDestAddr.setDescription("The destination address used by all senders in\nthis  session.   This object may not be changed\nwhen the value of the RowStatus object is  'ac-\ntive'.")
rsvpResvSenderAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvSenderAddr.setDescription("The source address of the sender  selected  by\nthis  reservation.  The value of all zeroes in-\ndicates 'all senders'.  This object may not  be\nchanged  when the value of the RowStatus object\nis 'active'.")
rsvpResvDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvDestAddrLength.setDescription("The length of the destination address in bits.\nThis  is  the CIDR Prefix Length, which for IP4\nhosts and multicast addresses is 32 bits.  This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvSenderAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvSenderAddrLength.setDescription("The length of the sender's  address  in  bits.\nThis  is  the CIDR Prefix Length, which for IP4\nhosts and multicast addresses is 32 bits.  This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 7), Protocol()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvProtocol.setDescription("The IP Protocol used by  this  session.   This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvDestPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 8), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvDestPort.setDescription("The UDP or TCP port number used as a  destina-\ntion  port for all senders in this session.  If\nthe  IP   protocol   in   use,   specified   by\nrsvpResvProtocol,  is 50 (ESP) or 51 (AH), this\nrepresents a virtual destination  port  number.\nA  value of zero indicates that the IP protocol\nin use does not have ports.   This  object  may\nnot  be changed when the value of the RowStatus\nobject is 'active'.")
rsvpResvPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 9), Port()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvPort.setDescription("The UDP or TCP port number used  as  a  source\nport  for  this sender in this session.  If the\nIP protocol in use, specified by rsvpResvProto-\ncol  is  50 (ESP) or 51 (AH), this represents a\ngeneralized port identifier (GPI).  A value  of\nzero indicates that the IP protocol in use does\nnot have ports.  This object may not be changed\nwhen  the value of the RowStatus object is 'ac-\ntive'.")
rsvpResvHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 10), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvHopAddr.setDescription("The address used by the next RSVP  hop  (which\nmay be the ultimate receiver).")
rsvpResvHopLih = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 11), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvHopLih.setDescription("The Logical Interface Handle received from the\nprevious  RSVP  hop  (which may be the ultimate\nreceiver).")
rsvpResvInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 12), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvInterface.setDescription("The ifIndex value of the  interface  on  which\nthis RESV message was most recently received.")
rsvpResvService = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 13), QosService()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvService.setDescription("The QoS Service  classification  requested  by\nthe receiver.")
rsvpResvTSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 14), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecRate.setDescription("The Average Bit  Rate  of  the  sender's  data\nstream.   Within  a transmission burst, the ar-\nrival rate may be  as  fast  as  rsvpResvTSpec-\nPeakRate  (if  supported by the service model);\nhowever, averaged across two or more burst  in-\ntervals,    the    rate   should   not   exceed\nrsvpResvTSpecRate.\n\nNote that this is a prediction, often based  on\nthe  general  capability  of a type of codec or\nparticular encoding; the measured average  rate\nmay be significantly lower.")
rsvpResvTSpecPeakRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 15), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecPeakRate.setDescription("The Peak Bit Rate of the sender's data stream.\nTraffic  arrival is not expected to exceed this\nrate at any time, apart  from  the  effects  of\njitter in the network.  If not specified in the\nTSpec, this returns zero or noSuchValue.")
rsvpResvTSpecBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 16), BurstSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecBurst.setDescription("The size of the largest  burst  expected  from\nthe sender at a time.\n\nIf this is less than  the  sender's  advertised\nburst  size, the receiver is asking the network\nto provide flow pacing  beyond  what  would  be\nprovided  under normal circumstances. Such pac-\ning is at the network's option.")
rsvpResvTSpecMinTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 17), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecMinTU.setDescription("The minimum message size for  this  flow.  The\npolicing  algorithm will treat smaller messages\nas though they are this size.")
rsvpResvTSpecMaxTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 18), MessageSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvTSpecMaxTU.setDescription("The maximum message size for  this  flow.  The\nadmission  algorithm  will  reject TSpecs whose\nMaximum Transmission Unit, plus  the  interface\nheaders, exceed the interface MTU.")
rsvpResvRSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 19), BitRate()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvRSpecRate.setDescription("If the requested  service  is  Guaranteed,  as\nspecified   by  rsvpResvService,  this  is  the\nclearing rate that is being requested.   Other-\nwise,  it  is  zero,  or  the  agent may return\nnoSuchValue.")
rsvpResvRSpecSlack = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 20), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvRSpecSlack.setDescription("If the requested  service  is  Guaranteed,  as\nspecified by rsvpResvService, this is the delay\nslack.  Otherwise, it is zero, or the agent may\nreturn noSuchValue.")
rsvpResvInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 21), RefreshInterval()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvInterval.setDescription("The interval between refresh messages  as  ad-\nvertised by the Next Hop.")
rsvpResvScope = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 22), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvScope.setDescription("The contents of the scope object, displayed as\nan  uninterpreted  string  of octets, including\nthe object header.  In the absence of  such  an\nobject, this should be of zero length.\n\nIf the length  is  non-zero,  this  contains  a\nseries of IP4 or IP6 addresses.")
rsvpResvShared = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 23), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvShared.setDescription("If TRUE, a reservation shared among senders is\nrequested.  If FALSE, a reservation specific to\nthis sender is requested.")
rsvpResvExplicit = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 24), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvExplicit.setDescription("If TRUE, individual senders are  listed  using\nFilter  Specifications.   If FALSE, all senders\nare implicitly selected.  The Scope Object will\ncontain  a list of senders that need to receive\nthis reservation request  for  the  purpose  of\nrouting the RESV message.")
rsvpResvRSVPHop = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 25), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvRSVPHop.setDescription("If TRUE, the node believes that  the  previous\nIP  hop is an RSVP hop.  If FALSE, the node be-\nlieves that the previous IP hop may not  be  an\nRSVP hop.")
rsvpResvLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 26), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvLastChange.setDescription("The time of the last change in  this  reserva-\ntion  request; This is either the first time it\nwas received or the time  of  the  most  recent\nchange in parameters.")
rsvpResvPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 27), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvPolicy.setDescription("The contents of the policy  object,  displayed\nas an uninterpreted string of octets, including\nthe object header.  In the absence of  such  an\nobject, this should be of zero length.")
rsvpResvStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 28), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpResvStatus.setDescription("'active' for all active RESV  messages.   This\nobject  may  be used to install static RESV in-\nformation or delete RESV information.")
rsvpResvTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 29), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvTTL.setDescription("The TTL value in the RSVP header that was last\nreceived.")
rsvpResvFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 4, 1, 30), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFlowId.setDescription("The flow ID that this receiver  is  using,  if\nthis  is  an IPv6 session.")
rsvpResvFwdTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 5))
if mibBuilder.loadTexts: rsvpResvFwdTable.setDescription("Information describing the  state  information\ndisplayed upstream in RESV messages.")
rsvpResvFwdEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 5, 1)).setIndexNames((0, "RSVP-MIB", "rsvpSessionNumber"), (0, "RSVP-MIB", "rsvpResvFwdNumber"))
if mibBuilder.loadTexts: rsvpResvFwdEntry.setDescription("Information describing the  state  information\ndisplayed  upstream in an RESV message concern-\ning a single sender.")
rsvpResvFwdNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 1), SessionNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rsvpResvFwdNumber.setDescription("The number of this reservation request.   This\nis  for  SNMP Indexing purposes only and has no\nrelation to any protocol value.")
rsvpResvFwdType = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 2), SessionType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdType.setDescription("The type of session (IP4, IP6, IP6  with  flow\ninformation, etc).")
rsvpResvFwdDestAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdDestAddr.setDescription("The destination address used by all senders in\nthis  session.   This object may not be changed\nwhen the value of the RowStatus object is  'ac-\ntive'.")
rsvpResvFwdSenderAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdSenderAddr.setDescription("The source address of the sender  selected  by\nthis  reservation.  The value of all zeroes in-\ndicates 'all senders'.  This object may not  be\nchanged  when the value of the RowStatus object\nis 'active'.")
rsvpResvFwdDestAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdDestAddrLength.setDescription("The length of the destination address in bits.\nThis  is  the CIDR Prefix Length, which for IP4\nhosts and multicast addresses is 32 bits.  This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvFwdSenderAddrLength = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdSenderAddrLength.setDescription("The length of the sender's  address  in  bits.\nThis  is  the CIDR Prefix Length, which for IP4\nhosts and multicast addresses is 32 bits.  This\nobject may not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvFwdProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 7), Protocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdProtocol.setDescription("The IP Protocol used by a session. for  secure\nsessions, this indicates IP Security.  This ob-\nject may not be changed when the value  of  the\nRowStatus object is 'active'.")
rsvpResvFwdDestPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 8), Port()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdDestPort.setDescription("The UDP or TCP port number used as a  destina-\ntion  port for all senders in this session.  If\nthe  IP   protocol   in   use,   specified   by\nrsvpResvFwdProtocol,  is  50  (ESP) or 51 (AH),\nthis  represents  a  virtual  destination  port\nnumber.   A value of zero indicates that the IP\nprotocol in use does not have ports.  This  ob-\nject  may  not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvFwdPort = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 9), Port()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdPort.setDescription("The UDP or TCP port number used  as  a  source\nport  for  this sender in this session.  If the\nIP    protocol    in    use,    specified    by\nrsvpResvFwdProtocol  is  50  (ESP)  or 51 (AH),\nthis represents a generalized  port  identifier\n(GPI).   A  value of zero indicates that the IP\nprotocol in use does not have ports.  This  ob-\nject  may  not be changed when the value of the\nRowStatus object is 'active'.")
rsvpResvFwdHopAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 10), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdHopAddr.setDescription("The address of the (previous) RSVP  that  will\nreceive this message.")
rsvpResvFwdHopLih = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 11), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdHopLih.setDescription("The Logical Interface Handle sent to the (pre-\nvious) RSVP that will receive this message.")
rsvpResvFwdInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 12), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdInterface.setDescription("The ifIndex value of the  interface  on  which\nthis RESV message was most recently sent.")
rsvpResvFwdService = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 13), QosService()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdService.setDescription("The QoS Service classification requested.")
rsvpResvFwdTSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 14), BitRate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecRate.setDescription("The Average Bit  Rate  of  the  sender's  data\nstream.   Within  a transmission burst, the ar-\nrival rate may be as fast as  rsvpResvFwdTSpec-\nPeakRate  (if  supported by the service model);\nhowever, averaged across two or more burst  in-\ntervals,    the    rate   should   not   exceed\nrsvpResvFwdTSpecRate.\n\nNote that this is a prediction, often based  on\nthe  general  capability  of a type of codec or\nparticular encoding; the measured average  rate\nmay be significantly lower.")
rsvpResvFwdTSpecPeakRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 15), BitRate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecPeakRate.setDescription("The Peak Bit Rate of the sender's data  stream\nTraffic  arrival is not expected to exceed this\nrate at any time, apart  from  the  effects  of\njitter in the network.  If not specified in the\nTSpec, this returns zero or noSuchValue.")
rsvpResvFwdTSpecBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 16), BurstSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecBurst.setDescription("The size of the largest  burst  expected  from\nthe sender at a time.\n\nIf this is less than  the  sender's  advertised\nburst  size, the receiver is asking the network\nto provide flow pacing  beyond  what  would  be\nprovided  under normal circumstances. Such pac-\ning is at the network's option.")
rsvpResvFwdTSpecMinTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 17), MessageSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecMinTU.setDescription("The minimum message size for  this  flow.  The\npolicing  algorithm will treat smaller messages\nas though they are this size.")
rsvpResvFwdTSpecMaxTU = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 18), MessageSize()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTSpecMaxTU.setDescription("The maximum message size for  this  flow.  The\nadmission  algorithm  will  reject TSpecs whose\nMaximum Transmission Unit, plus  the  interface\nheaders, exceed the interface MTU.")
rsvpResvFwdRSpecRate = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 19), BitRate()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdRSpecRate.setDescription("If the requested  service  is  Guaranteed,  as\nspecified   by  rsvpResvService,  this  is  the\nclearing rate that is being requested.   Other-\nwise,  it  is  zero,  or  the  agent may return\nnoSuchValue.")
rsvpResvFwdRSpecSlack = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 20), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdRSpecSlack.setDescription("If the requested  service  is  Guaranteed,  as\nspecified by rsvpResvService, this is the delay\nslack.  Otherwise, it is zero, or the agent may\nreturn noSuchValue.")
rsvpResvFwdInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 21), RefreshInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdInterval.setDescription("The interval between refresh  messages  adver-\ntised to the Previous Hop.")
rsvpResvFwdScope = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 22), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdScope.setDescription("The contents of the scope object, displayed as\nan  uninterpreted  string  of octets, including\nthe object header.  In the absence of  such  an\nobject, this should be of zero length.")
rsvpResvFwdShared = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 23), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdShared.setDescription("If TRUE, a reservation shared among senders is\nrequested.  If FALSE, a reservation specific to\nthis sender is requested.")
rsvpResvFwdExplicit = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 24), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdExplicit.setDescription("If TRUE, individual senders are  listed  using\nFilter  Specifications.   If FALSE, all senders\nare implicitly selected.  The Scope Object will\ncontain  a list of senders that need to receive\nthis reservation request  for  the  purpose  of\nrouting the RESV message.")
rsvpResvFwdRSVPHop = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 25), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdRSVPHop.setDescription("If TRUE, the node believes that  the  next  IP\nhop  is  an  RSVP  hop.  If FALSE, the node be-\nlieves that the next IP hop may not be an  RSVP\nhop.")
rsvpResvFwdLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 26), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdLastChange.setDescription("The time of the last change in  this  request;\nThis  is  either  the first time it was sent or\nthe time of the most recent change  in  parame-\nters.")
rsvpResvFwdPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 27), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdPolicy.setDescription("The contents of the policy  object,  displayed\nas an uninterpreted string of octets, including\nthe object header.  In the absence of  such  an\nobject, this should be of zero length.")
rsvpResvFwdStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 28), RowStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpResvFwdStatus.setDescription("'active' for all active RESV  messages.   This\nobject may be used to delete RESV information.")
rsvpResvFwdTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 29), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdTTL.setDescription("The TTL value in the RSVP header that was last\nreceived.")
rsvpResvFwdFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 5, 1, 30), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpResvFwdFlowId.setDescription("The flow ID that this receiver  is  using,  if\nthis  is  an IPv6 session.")
rsvpIfTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 6))
if mibBuilder.loadTexts: rsvpIfTable.setDescription("The RSVP-specific attributes of  the  system's\ninterfaces.")
rsvpIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: rsvpIfEntry.setDescription("The RSVP-specific attributes of  the  a  given\ninterface.")
rsvpIfUdpNbrs = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpIfUdpNbrs.setDescription("The number of neighbors perceived to be  using\nonly the RSVP UDP Encapsulation.")
rsvpIfIpNbrs = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpIfIpNbrs.setDescription("The number of neighbors perceived to be  using\nonly the RSVP IP Encapsulation.")
rsvpIfNbrs = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpIfNbrs.setDescription("The number of neighbors  currently  perceived;\nthis  will  exceed rsvpIfIpNbrs + rsvpIfUdpNbrs\nby the number of neighbors using both  encapsu-\nlations.")
rsvpIfRefreshBlockadeMultiple = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65536)).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRefreshBlockadeMultiple.setDescription("The value of the RSVP value 'Kb', Which is the\nminimum   number   of  refresh  intervals  that\nblockade state will last once entered.")
rsvpIfRefreshMultiple = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65536)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRefreshMultiple.setDescription("The value of the RSVP value 'K', which is  the\nnumber  of  refresh intervals which must elapse\n(minimum) before a PATH or RESV  message  which\nis not being refreshed will be aged out.")
rsvpIfTTL = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfTTL.setDescription("The value of SEND_TTL used on  this  interface\nfor  messages  this node originates.  If set to\nzero, the node determines  the  TTL  via  other\nmeans.")
rsvpIfRefreshInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 7), TimeInterval().clone(3000)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRefreshInterval.setDescription("The value of the RSVP value 'R', which is  the\nminimum period between refresh transmissions of\na given PATH or RESV message on an interface.")
rsvpIfRouteDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 8), TimeInterval().clone(200)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfRouteDelay.setDescription("The approximate period from the time  a  route\nis  changed to the time a resulting message ap-\npears on the interface.")
rsvpIfEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 9), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfEnabled.setDescription("If TRUE, RSVP is enabled  on  this  Interface.\nIf  FALSE,  RSVP  is not enabled on this inter-\nface.")
rsvpIfUdpRequired = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 10), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfUdpRequired.setDescription("If TRUE, manual configuration forces  the  use\nof  UDP  encapsulation  on  the  interface.  If\nFALSE, UDP encapsulation is only used if rsvpI-\nfUdpNbrs is not zero.")
rsvpIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 6, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpIfStatus.setDescription("'active' on interfaces that are configured for\nRSVP.")
rsvpNbrTable = MibTable((1, 3, 6, 1, 2, 1, 51, 1, 7))
if mibBuilder.loadTexts: rsvpNbrTable.setDescription("Information describing  the  Neighbors  of  an\nRSVP system.")
rsvpNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 51, 1, 7, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "RSVP-MIB", "rsvpNbrAddress"))
if mibBuilder.loadTexts: rsvpNbrEntry.setDescription("Information describing a  single  RSVP  Neigh-\nbor.")
rsvpNbrAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 7, 1, 1), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 16))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rsvpNbrAddress.setDescription("The IP4 or IP6 Address used by this  neighbor.\nThis  object  may not be changed when the value\nof the RowStatus object is 'active'.")
rsvpNbrProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 7, 1, 2), RsvpEncapsulation()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpNbrProtocol.setDescription("The encapsulation being used  by  this  neigh-\nbor.")
rsvpNbrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 51, 1, 7, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: rsvpNbrStatus.setDescription("'active' for all neighbors.  This  object  may\nbe  used  to configure neighbors.  In the pres-\nence of configured neighbors,  the  implementa-\ntion may (but is not required to) limit the set\nof valid neighbors to those configured.")
rsvpGenObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 2))
rsvpBadPackets = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rsvpBadPackets.setDescription("This object keeps a count of the number of bad\nRSVP packets received.")
rsvpSenderNewIndex = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpSenderNewIndex.setDescription("This  object  is  used  to  assign  values  to\nrsvpSenderNumber  as described in 'Textual Con-\nventions  for  SNMPv2'.   The  network  manager\nreads  the  object,  and  then writes the value\nback in the SET that creates a new instance  of\nrsvpSenderEntry.   If  the  SET  fails with the\ncode 'inconsistentValue', then the process must\nbe  repeated; If the SET succeeds, then the ob-\nject is incremented, and the  new  instance  is\ncreated according to the manager's directions.")
rsvpResvNewIndex = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 3), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpResvNewIndex.setDescription("This  object  is  used  to  assign  values  to\nrsvpResvNumber as described in 'Textual Conven-\ntions for SNMPv2'.  The network  manager  reads\nthe  object,  and then writes the value back in\nthe  SET  that  creates  a  new   instance   of\nrsvpResvEntry.   If the SET fails with the code\n'inconsistentValue', then the process  must  be\nrepeated;  If the SET succeeds, then the object\nis incremented, and the new instance is created\naccording to the manager's directions.")
rsvpResvFwdNewIndex = MibScalar((1, 3, 6, 1, 2, 1, 51, 2, 4), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rsvpResvFwdNewIndex.setDescription("This  object  is  used  to  assign  values  to\nrsvpResvFwdNumber as described in 'Textual Con-\nventions  for  SNMPv2'.   The  network  manager\nreads  the  object,  and  then writes the value\nback in the SET that creates a new instance  of\nrsvpResvFwdEntry.   If  the  SET fails with the\ncode 'inconsistentValue', then the process must\nbe  repeated; If the SET succeeds, then the ob-\nject is incremented, and the  new  instance  is\ncreated according to the manager's directions.")
rsvpNotificationsPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 3))
rsvpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 3, 0))
rsvpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 4))
rsvpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 4, 1))
rsvpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 51, 4, 2))

# Augmentions

# Notifications

newFlow = NotificationType((1, 3, 6, 1, 2, 1, 51, 3, 0, 1)).setObjects(("RSVP-MIB", "rsvpResvFwdStatus"), ("RSVP-MIB", "rsvpSessionDestAddr"), ("INTEGRATED-SERVICES-MIB", "intSrvFlowStatus"), ("RSVP-MIB", "rsvpSenderStatus"), ("RSVP-MIB", "rsvpResvStatus"), )
lostFlow = NotificationType((1, 3, 6, 1, 2, 1, 51, 3, 0, 2)).setObjects(("RSVP-MIB", "rsvpResvFwdStatus"), ("RSVP-MIB", "rsvpSessionDestAddr"), ("INTEGRATED-SERVICES-MIB", "intSrvFlowStatus"), ("RSVP-MIB", "rsvpSenderStatus"), ("RSVP-MIB", "rsvpResvStatus"), )

# Groups

rsvpNbrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 7)).setObjects(("RSVP-MIB", "rsvpNbrProtocol"), ("RSVP-MIB", "rsvpNbrStatus"), )
rsvpNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 8)).setObjects(("RSVP-MIB", "newFlow"), ("RSVP-MIB", "lostFlow"), )
rsvpResvGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 3)).setObjects(("RSVP-MIB", "rsvpResvNewIndex"), ("RSVP-MIB", "rsvpResvStatus"), ("RSVP-MIB", "rsvpResvShared"), ("RSVP-MIB", "rsvpResvHopAddr"), ("RSVP-MIB", "rsvpResvDestPort"), ("RSVP-MIB", "rsvpResvPolicy"), ("RSVP-MIB", "rsvpResvService"), ("RSVP-MIB", "rsvpResvTSpecMaxTU"), ("RSVP-MIB", "rsvpResvInterval"), ("RSVP-MIB", "rsvpResvScope"), ("RSVP-MIB", "rsvpResvTSpecPeakRate"), ("RSVP-MIB", "rsvpResvProtocol"), ("RSVP-MIB", "rsvpResvTSpecMinTU"), ("RSVP-MIB", "rsvpResvRSpecRate"), ("RSVP-MIB", "rsvpResvType"), ("RSVP-MIB", "rsvpResvRSVPHop"), ("RSVP-MIB", "rsvpResvTSpecRate"), ("RSVP-MIB", "rsvpResvDestAddr"), ("RSVP-MIB", "rsvpResvSenderAddr"), ("RSVP-MIB", "rsvpResvRSpecSlack"), ("RSVP-MIB", "rsvpResvInterface"), ("RSVP-MIB", "rsvpResvTSpecBurst"), ("RSVP-MIB", "rsvpResvPort"), ("RSVP-MIB", "rsvpResvLastChange"), ("RSVP-MIB", "rsvpResvExplicit"), ("RSVP-MIB", "rsvpResvDestAddrLength"), ("RSVP-MIB", "rsvpResvSenderAddrLength"), ("RSVP-MIB", "rsvpResvHopLih"), )
rsvpSessionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 1)).setObjects(("RSVP-MIB", "rsvpSessionSenders"), ("RSVP-MIB", "rsvpSessionDestAddrLength"), ("RSVP-MIB", "rsvpSessionReceivers"), ("RSVP-MIB", "rsvpSessionDestAddr"), ("RSVP-MIB", "rsvpSessionType"), ("RSVP-MIB", "rsvpSessionPort"), ("RSVP-MIB", "rsvpSessionRequests"), ("RSVP-MIB", "rsvpSessionProtocol"), )
rsvpIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 6)).setObjects(("RSVP-MIB", "rsvpIfIpNbrs"), ("RSVP-MIB", "rsvpIfEnabled"), ("RSVP-MIB", "rsvpIfRefreshInterval"), ("RSVP-MIB", "rsvpIfTTL"), ("RSVP-MIB", "rsvpIfNbrs"), ("RSVP-MIB", "rsvpIfUdpNbrs"), ("RSVP-MIB", "rsvpIfUdpRequired"), ("RSVP-MIB", "rsvpIfRefreshBlockadeMultiple"), ("RSVP-MIB", "rsvpIfRefreshMultiple"), ("RSVP-MIB", "rsvpIfStatus"), ("RSVP-MIB", "rsvpIfRouteDelay"), )
rsvpResvFwdGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 4)).setObjects(("RSVP-MIB", "rsvpResvFwdExplicit"), ("RSVP-MIB", "rsvpResvFwdTSpecMaxTU"), ("RSVP-MIB", "rsvpResvFwdLastChange"), ("RSVP-MIB", "rsvpResvFwdTSpecRate"), ("RSVP-MIB", "rsvpResvFwdNewIndex"), ("RSVP-MIB", "rsvpResvFwdTSpecMinTU"), ("RSVP-MIB", "rsvpResvFwdHopLih"), ("RSVP-MIB", "rsvpResvFwdDestPort"), ("RSVP-MIB", "rsvpResvFwdRSpecRate"), ("RSVP-MIB", "rsvpResvFwdDestAddrLength"), ("RSVP-MIB", "rsvpResvFwdShared"), ("RSVP-MIB", "rsvpResvFwdStatus"), ("RSVP-MIB", "rsvpResvFwdSenderAddrLength"), ("RSVP-MIB", "rsvpResvFwdTSpecPeakRate"), ("RSVP-MIB", "rsvpResvFwdProtocol"), ("RSVP-MIB", "rsvpResvFwdScope"), ("RSVP-MIB", "rsvpResvFwdRSVPHop"), ("RSVP-MIB", "rsvpResvFwdSenderAddr"), ("RSVP-MIB", "rsvpResvFwdInterval"), ("RSVP-MIB", "rsvpResvFwdHopAddr"), ("RSVP-MIB", "rsvpResvFwdPort"), ("RSVP-MIB", "rsvpResvFwdPolicy"), ("RSVP-MIB", "rsvpResvFwdInterface"), ("RSVP-MIB", "rsvpResvFwdDestAddr"), ("RSVP-MIB", "rsvpResvFwdService"), ("RSVP-MIB", "rsvpResvFwdTSpecBurst"), ("RSVP-MIB", "rsvpResvFwdRSpecSlack"), ("RSVP-MIB", "rsvpResvFwdType"), )
rsvpSenderGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 51, 4, 1, 2)).setObjects(("RSVP-MIB", "rsvpSenderInterval"), ("RSVP-MIB", "rsvpSenderAdspecBreak"), ("RSVP-MIB", "rsvpSenderAdspecHopCount"), ("RSVP-MIB", "rsvpSenderHopAddr"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedMtu"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadMtu"), ("RSVP-MIB", "rsvpSenderInterface"), ("RSVP-MIB", "rsvpSenderTSpecMaxTU"), ("RSVP-MIB", "rsvpSenderAdspecPathBw"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedDsum"), ("RSVP-MIB", "rsvpSenderTSpecBurst"), ("RSVP-MIB", "rsvpSenderAddr"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadBreak"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedCtot"), ("RSVP-MIB", "rsvpSenderStatus"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadPathBw"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedDtot"), ("RSVP-MIB", "rsvpSenderAddrLength"), ("RSVP-MIB", "rsvpSenderAdspecMinLatency"), ("RSVP-MIB", "rsvpSenderTSpecRate"), ("RSVP-MIB", "rsvpSenderTSpecMinTU"), ("RSVP-MIB", "rsvpSenderDestPort"), ("RSVP-MIB", "rsvpSenderNewIndex"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedCsum"), ("RSVP-MIB", "rsvpSenderDestAddr"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadHopCount"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedBreak"), ("RSVP-MIB", "rsvpSenderPort"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedHopCount"), ("RSVP-MIB", "rsvpSenderAdspecMtu"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedMinLatency"), ("RSVP-MIB", "rsvpSenderDestAddrLength"), ("RSVP-MIB", "rsvpSenderHopLih"), ("RSVP-MIB", "rsvpSenderPolicy"), ("RSVP-MIB", "rsvpSenderType"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedPathBw"), ("RSVP-MIB", "rsvpSenderProtocol"), ("RSVP-MIB", "rsvpSenderTSpecPeakRate"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadMinLatency"), ("RSVP-MIB", "rsvpSenderLastChange"), ("RSVP-MIB", "rsvpSenderRSVPHop"), ("RSVP-MIB", "rsvpSenderAdspecCtrlLoadSvc"), ("RSVP-MIB", "rsvpSenderAdspecGuaranteedSvc"), )

# Exports

# Module identity
mibBuilder.exportSymbols("RSVP-MIB", PYSNMP_MODULE_ID=rsvp)

# Types
mibBuilder.exportSymbols("RSVP-MIB", RefreshInterval=RefreshInterval, RsvpEncapsulation=RsvpEncapsulation)

# Objects
mibBuilder.exportSymbols("RSVP-MIB", rsvp=rsvp, rsvpObjects=rsvpObjects, rsvpSessionTable=rsvpSessionTable, rsvpSessionEntry=rsvpSessionEntry, rsvpSessionNumber=rsvpSessionNumber, rsvpSessionType=rsvpSessionType, rsvpSessionDestAddr=rsvpSessionDestAddr, rsvpSessionDestAddrLength=rsvpSessionDestAddrLength, rsvpSessionProtocol=rsvpSessionProtocol, rsvpSessionPort=rsvpSessionPort, rsvpSessionSenders=rsvpSessionSenders, rsvpSessionReceivers=rsvpSessionReceivers, rsvpSessionRequests=rsvpSessionRequests, rsvpSenderTable=rsvpSenderTable, rsvpSenderEntry=rsvpSenderEntry, rsvpSenderNumber=rsvpSenderNumber, rsvpSenderType=rsvpSenderType, rsvpSenderDestAddr=rsvpSenderDestAddr, rsvpSenderAddr=rsvpSenderAddr, rsvpSenderDestAddrLength=rsvpSenderDestAddrLength, rsvpSenderAddrLength=rsvpSenderAddrLength, rsvpSenderProtocol=rsvpSenderProtocol, rsvpSenderDestPort=rsvpSenderDestPort, rsvpSenderPort=rsvpSenderPort, rsvpSenderFlowId=rsvpSenderFlowId, rsvpSenderHopAddr=rsvpSenderHopAddr, rsvpSenderHopLih=rsvpSenderHopLih, rsvpSenderInterface=rsvpSenderInterface, rsvpSenderTSpecRate=rsvpSenderTSpecRate, rsvpSenderTSpecPeakRate=rsvpSenderTSpecPeakRate, rsvpSenderTSpecBurst=rsvpSenderTSpecBurst, rsvpSenderTSpecMinTU=rsvpSenderTSpecMinTU, rsvpSenderTSpecMaxTU=rsvpSenderTSpecMaxTU, rsvpSenderInterval=rsvpSenderInterval, rsvpSenderRSVPHop=rsvpSenderRSVPHop, rsvpSenderLastChange=rsvpSenderLastChange, rsvpSenderPolicy=rsvpSenderPolicy, rsvpSenderAdspecBreak=rsvpSenderAdspecBreak, rsvpSenderAdspecHopCount=rsvpSenderAdspecHopCount, rsvpSenderAdspecPathBw=rsvpSenderAdspecPathBw, rsvpSenderAdspecMinLatency=rsvpSenderAdspecMinLatency, rsvpSenderAdspecMtu=rsvpSenderAdspecMtu, rsvpSenderAdspecGuaranteedSvc=rsvpSenderAdspecGuaranteedSvc, rsvpSenderAdspecGuaranteedBreak=rsvpSenderAdspecGuaranteedBreak, rsvpSenderAdspecGuaranteedCtot=rsvpSenderAdspecGuaranteedCtot, rsvpSenderAdspecGuaranteedDtot=rsvpSenderAdspecGuaranteedDtot, rsvpSenderAdspecGuaranteedCsum=rsvpSenderAdspecGuaranteedCsum, rsvpSenderAdspecGuaranteedDsum=rsvpSenderAdspecGuaranteedDsum, rsvpSenderAdspecGuaranteedHopCount=rsvpSenderAdspecGuaranteedHopCount, rsvpSenderAdspecGuaranteedPathBw=rsvpSenderAdspecGuaranteedPathBw, rsvpSenderAdspecGuaranteedMinLatency=rsvpSenderAdspecGuaranteedMinLatency, rsvpSenderAdspecGuaranteedMtu=rsvpSenderAdspecGuaranteedMtu, rsvpSenderAdspecCtrlLoadSvc=rsvpSenderAdspecCtrlLoadSvc, rsvpSenderAdspecCtrlLoadBreak=rsvpSenderAdspecCtrlLoadBreak, rsvpSenderAdspecCtrlLoadHopCount=rsvpSenderAdspecCtrlLoadHopCount, rsvpSenderAdspecCtrlLoadPathBw=rsvpSenderAdspecCtrlLoadPathBw, rsvpSenderAdspecCtrlLoadMinLatency=rsvpSenderAdspecCtrlLoadMinLatency, rsvpSenderAdspecCtrlLoadMtu=rsvpSenderAdspecCtrlLoadMtu, rsvpSenderStatus=rsvpSenderStatus, rsvpSenderTTL=rsvpSenderTTL, rsvpSenderOutInterfaceTable=rsvpSenderOutInterfaceTable, rsvpSenderOutInterfaceEntry=rsvpSenderOutInterfaceEntry, rsvpSenderOutInterfaceStatus=rsvpSenderOutInterfaceStatus, rsvpResvTable=rsvpResvTable, rsvpResvEntry=rsvpResvEntry, rsvpResvNumber=rsvpResvNumber, rsvpResvType=rsvpResvType, rsvpResvDestAddr=rsvpResvDestAddr, rsvpResvSenderAddr=rsvpResvSenderAddr, rsvpResvDestAddrLength=rsvpResvDestAddrLength, rsvpResvSenderAddrLength=rsvpResvSenderAddrLength, rsvpResvProtocol=rsvpResvProtocol, rsvpResvDestPort=rsvpResvDestPort, rsvpResvPort=rsvpResvPort, rsvpResvHopAddr=rsvpResvHopAddr, rsvpResvHopLih=rsvpResvHopLih, rsvpResvInterface=rsvpResvInterface, rsvpResvService=rsvpResvService, rsvpResvTSpecRate=rsvpResvTSpecRate, rsvpResvTSpecPeakRate=rsvpResvTSpecPeakRate, rsvpResvTSpecBurst=rsvpResvTSpecBurst, rsvpResvTSpecMinTU=rsvpResvTSpecMinTU, rsvpResvTSpecMaxTU=rsvpResvTSpecMaxTU, rsvpResvRSpecRate=rsvpResvRSpecRate, rsvpResvRSpecSlack=rsvpResvRSpecSlack, rsvpResvInterval=rsvpResvInterval, rsvpResvScope=rsvpResvScope, rsvpResvShared=rsvpResvShared, rsvpResvExplicit=rsvpResvExplicit, rsvpResvRSVPHop=rsvpResvRSVPHop, rsvpResvLastChange=rsvpResvLastChange, rsvpResvPolicy=rsvpResvPolicy, rsvpResvStatus=rsvpResvStatus, rsvpResvTTL=rsvpResvTTL, rsvpResvFlowId=rsvpResvFlowId, rsvpResvFwdTable=rsvpResvFwdTable, rsvpResvFwdEntry=rsvpResvFwdEntry, rsvpResvFwdNumber=rsvpResvFwdNumber, rsvpResvFwdType=rsvpResvFwdType, rsvpResvFwdDestAddr=rsvpResvFwdDestAddr, rsvpResvFwdSenderAddr=rsvpResvFwdSenderAddr, rsvpResvFwdDestAddrLength=rsvpResvFwdDestAddrLength, rsvpResvFwdSenderAddrLength=rsvpResvFwdSenderAddrLength, rsvpResvFwdProtocol=rsvpResvFwdProtocol, rsvpResvFwdDestPort=rsvpResvFwdDestPort, rsvpResvFwdPort=rsvpResvFwdPort, rsvpResvFwdHopAddr=rsvpResvFwdHopAddr, rsvpResvFwdHopLih=rsvpResvFwdHopLih, rsvpResvFwdInterface=rsvpResvFwdInterface, rsvpResvFwdService=rsvpResvFwdService, rsvpResvFwdTSpecRate=rsvpResvFwdTSpecRate, rsvpResvFwdTSpecPeakRate=rsvpResvFwdTSpecPeakRate, rsvpResvFwdTSpecBurst=rsvpResvFwdTSpecBurst, rsvpResvFwdTSpecMinTU=rsvpResvFwdTSpecMinTU, rsvpResvFwdTSpecMaxTU=rsvpResvFwdTSpecMaxTU, rsvpResvFwdRSpecRate=rsvpResvFwdRSpecRate, rsvpResvFwdRSpecSlack=rsvpResvFwdRSpecSlack, rsvpResvFwdInterval=rsvpResvFwdInterval, rsvpResvFwdScope=rsvpResvFwdScope, rsvpResvFwdShared=rsvpResvFwdShared, rsvpResvFwdExplicit=rsvpResvFwdExplicit, rsvpResvFwdRSVPHop=rsvpResvFwdRSVPHop, rsvpResvFwdLastChange=rsvpResvFwdLastChange, rsvpResvFwdPolicy=rsvpResvFwdPolicy, rsvpResvFwdStatus=rsvpResvFwdStatus, rsvpResvFwdTTL=rsvpResvFwdTTL)
mibBuilder.exportSymbols("RSVP-MIB", rsvpResvFwdFlowId=rsvpResvFwdFlowId, rsvpIfTable=rsvpIfTable, rsvpIfEntry=rsvpIfEntry, rsvpIfUdpNbrs=rsvpIfUdpNbrs, rsvpIfIpNbrs=rsvpIfIpNbrs, rsvpIfNbrs=rsvpIfNbrs, rsvpIfRefreshBlockadeMultiple=rsvpIfRefreshBlockadeMultiple, rsvpIfRefreshMultiple=rsvpIfRefreshMultiple, rsvpIfTTL=rsvpIfTTL, rsvpIfRefreshInterval=rsvpIfRefreshInterval, rsvpIfRouteDelay=rsvpIfRouteDelay, rsvpIfEnabled=rsvpIfEnabled, rsvpIfUdpRequired=rsvpIfUdpRequired, rsvpIfStatus=rsvpIfStatus, rsvpNbrTable=rsvpNbrTable, rsvpNbrEntry=rsvpNbrEntry, rsvpNbrAddress=rsvpNbrAddress, rsvpNbrProtocol=rsvpNbrProtocol, rsvpNbrStatus=rsvpNbrStatus, rsvpGenObjects=rsvpGenObjects, rsvpBadPackets=rsvpBadPackets, rsvpSenderNewIndex=rsvpSenderNewIndex, rsvpResvNewIndex=rsvpResvNewIndex, rsvpResvFwdNewIndex=rsvpResvFwdNewIndex, rsvpNotificationsPrefix=rsvpNotificationsPrefix, rsvpNotifications=rsvpNotifications, rsvpConformance=rsvpConformance, rsvpGroups=rsvpGroups, rsvpCompliances=rsvpCompliances)

# Notifications
mibBuilder.exportSymbols("RSVP-MIB", newFlow=newFlow, lostFlow=lostFlow)

# Groups
mibBuilder.exportSymbols("RSVP-MIB", rsvpNbrGroup=rsvpNbrGroup, rsvpNotificationGroup=rsvpNotificationGroup, rsvpResvGroup=rsvpResvGroup, rsvpSessionGroup=rsvpSessionGroup, rsvpIfGroup=rsvpIfGroup, rsvpResvFwdGroup=rsvpResvFwdGroup, rsvpSenderGroup=rsvpSenderGroup)
