# PySNMP SMI module. Autogenerated from smidump -f python SLAPM-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:36 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, experimental, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "experimental")
( DateAndTime, RowStatus, TextualConvention, TestAndIncr, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowStatus", "TextualConvention", "TestAndIncr")

# Types

class SlapmNameType(SnmpAdminString):
    subtypeSpec = SnmpAdminString.subtypeSpec+constraint.ValueSizeConstraint(0,32)
    pass

class SlapmPolicyRuleName(TextualConvention, OctetString):
    displayHint = "1024t"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,1024)
    pass

class SlapmStatus(Bits):
    namedValues = namedval.NamedValues(("slaMinInRateNotAchieved", 0), ("slaMaxInRateExceeded", 1), ("slaMaxDelayExceeded", 2), ("slaMinOutRateNotAchieved", 3), ("slaMaxOutRateExceeded", 4), ("monitorMinInRateNotAchieved", 5), ("monitorMaxInRateExceeded", 6), ("monitorMaxDelayExceeded", 7), ("monitorMinOutRateNotAchieved", 8), ("monitorMaxOutRateExceeded", 9), )
    pass


# Objects

slapmMIB = ModuleIdentity((1, 3, 6, 1, 3, 88)).setRevisions(("2000-01-24 00:00",))
if mibBuilder.loadTexts: slapmMIB.setOrganization("International Business Machines Corp.")
if mibBuilder.loadTexts: slapmMIB.setContactInfo("Kenneth White\n\nInternational Business Machines Corporation\nNetwork Computing Software Division\nResearch Triangle Park, NC, USA\n\nE-mail: wkenneth@us.ibm.com")
if mibBuilder.loadTexts: slapmMIB.setDescription("The Service Level Agreement Performance Monitoring MIB\n(SLAPM-MIB) provides data collection and monitoring\ncapabilities for Service Level Agreements (SLAs)\npolicy definitions.")
slapmNotifications = MibIdentifier((1, 3, 6, 1, 3, 88, 0))
slapmObjects = MibIdentifier((1, 3, 6, 1, 3, 88, 1))
slapmBaseObjects = MibIdentifier((1, 3, 6, 1, 3, 88, 1, 1))
slapmSpinLock = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 1), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: slapmSpinLock.setDescription("An advisory lock used to allow cooperating applications\nto coordinate their use of the contents of this MIB.  This\ntypically occurs when an application seeks to create an\nnew entry or alter an existing entry in\nslapmPRMonTable (or old slapmPolicyMonitorTable).  A\nmanagement implementation MAY utilize the slapmSpinLock to\nserialize its changes or additions.  This usage is not\nrequired.   However, slapmSpinLock MUST be supported by\nagent implementations.")
slapmPolicyCountQueries = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountQueries.setDescription("The total number of times that a policy lookup occurred\nwith respect to a policy agent.\nThis is the number of times that a reference was made to\na policy definition at a system and includes the number\nof times that a policy repository was accessed,\nslapmPolicyCountAccesses.  The object\nslapmPolicyCountAccesses should be less than\nslapmPolicyCountQueries when policy definitions are\ncached at a system.")
slapmPolicyCountAccesses = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountAccesses.setDescription("Total number of times that a policy repository was\naccessed with respect to a policy agent.\nThe value of this object should be less than\nslapmPolicyCountQueries, since typically policy entries\nare cached to minimize repository accesses.")
slapmPolicyCountSuccessAccesses = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountSuccessAccesses.setDescription("Total number of successful policy repository accesses\nwith respect to a policy agent.")
slapmPolicyCountNotFounds = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountNotFounds.setDescription("Total number of policy repository accesses,\nwith respect to a policy agent, that\nresulted in an entry not being located.")
slapmPolicyPurgeTime = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600)).clone(900)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: slapmPolicyPurgeTime.setDescription("The purpose of this object is to define the amount\nof time (in seconds) to wait before removing an\nslapmPolicyRuleStatsEntry (or old slapmPolicyStatsEntry)\nwhen a system detects that the associated policy\ndefinition has been deleted.  This gives any polling\nmanagement applications time to complete their last poll\nbefore an entry is removed.  An slapmPolicyRuleStatsEntry\n(or old slapmPolicyStatsEntry) enters the\ndeleteNeeded(3) state via slapmPolicyRuleStatsOperStatus\n(or old slapmPolicyStatsOperStatus) when a system first\ndetects that the entry needs to be removed.\n\nOnce slapmPolicyPurgeTime has expired for an entry in\ndeleteNeeded(3) state it is removed a long with any\ndependent slapmPRMonTable (or slapmPolicyMonitorTable)\nentries.\n\nA value of 0 for this option disables this function and\nresults in the automatic purging of slapmPRMonTable\n(or slapmPolicyTable) entries upon transition into\ndeleteNeeded(3) state.\n\nA slapmPolicyRuleDeleted (or slapmPolicyProfileDeleted)\nnotification is sent when an slapmPolicyRuleStatsEntry (or\nslapmPolicyStatsEntry) is removed.  Dependent\nslapmPRMonTable (or slapmPolicyMonitorTable)\ndeletion results in a slapmPolicyRuleMonDeleted (or\nslapmPolicyMonitorDeleted) notification being sent.\nThese notifications are suppressed if the value of\nslapmPolicyTrapEnable is disabled(2).")
slapmPolicyTrapEnable = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: slapmPolicyTrapEnable.setDescription("Indicates whether slapmPolicyRuleDeleted and\nslapmPolicyRuleMonDeleted (or slapmPolicyProfileDeleted\nand slapmPolicyMonitorDeleted) notifications should be\ngenerated by this system.")
slapmPolicyTrapFilter = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 64)).clone(3)).setMaxAccess("readwrite").setUnits("intervals")
if mibBuilder.loadTexts: slapmPolicyTrapFilter.setDescription("The purpose of this object is to suppress unnecessary\nslapmSubcMonitorNotOkay (or\nslapmSubcomponentMonitoredEventNotAchieved), for example,\nnotifications.  Basically, a monitored event has to\nnot meet its SLA requirement for the number of\nconsecutive intervals indicated by the value of this\nobject.")
slapmTableObjects = MibIdentifier((1, 3, 6, 1, 3, 88, 1, 2))
slapmPolicyStatsTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 1))
if mibBuilder.loadTexts: slapmPolicyStatsTable.setDescription("Provides statistics on all policies known at a\nsystem.\n\nThis table has been deprecated and replaced with\nthe slapmPolicyRuleStatsTable.  Older implementations of\nthis MIB are expected to continue their support of this\ntable.")
slapmPolicyStatsEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 1, 1)).setIndexNames((0, "SLAPM-MIB", "slapmPolicyStatsSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyStatsPolicyName"), (0, "SLAPM-MIB", "slapmPolicyStatsTrafficProfileName"))
if mibBuilder.loadTexts: slapmPolicyStatsEntry.setDescription("Defines an entry in the slapmPolicyStatsTable.  This table\ndefines a set of statistics that is kept on a per system,\npolicy and traffic profile basis.  A policy can be\ndefined to contain multiple traffic profiles that map to\na single action.\n\nEntries in this table are not created or deleted via SNMP\nbut reflect the set of policy definitions known at a system.")
slapmPolicyStatsSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 1), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyStatsSystemAddress.setDescription("Address of a system that an Policy definition relates to.\nA zero length octet string must be used to indicate that\nonly a single system is being represented.\nOtherwise, the length of the octet string must be\n4 for an ipv4 address or 16 for an ipv6 address.")
slapmPolicyStatsPolicyName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 2), SlapmNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyStatsPolicyName.setDescription("Policy name that this entry relates to.")
slapmPolicyStatsTrafficProfileName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 3), SlapmNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyStatsTrafficProfileName.setDescription("The name of a traffic profile that is associated with\na policy.")
slapmPolicyStatsOperStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), ("deleteNeeded", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOperStatus.setDescription("The state of a policy entry:\n\ninactive(1)      - An policy entry was either defined\n                   by local system definition or\n                   discovered via a directory search\n                   but has not been activated (not\n                   currently being used).\nactive(2)        - Policy entry is being used to affect\n                   traffic flows.\ndeleteNeeded(3)  - Either though local implementation\n                   dependent methods or by discovering\n                   that the directory entry corresponding\n                   to this table entry no longer\n                   exists and slapmPolicyPurgeTime needs\n                   to expire before attempting to remove\n                   the corresponding slapmPolicyStatsEntry\n                   and any dependent slapmPolicyMonitor\n                   table entries.\nNote: a policy traffic profile in a state other than\nactive(1) is not being used to affect traffic flows.")
slapmPolicyStatsActiveConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsActiveConns.setDescription("The number of active TCP connections that are\naffected by the corresponding policy entry.")
slapmPolicyStatsTotalConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsTotalConns.setDescription("The number of total TCP connections that are\naffected by the corresponding policy entry.")
slapmPolicyStatsFirstActivated = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 7), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsFirstActivated.setDescription("The timestamp for when the corresponding policy entry\nis activated.  The value of this object serves as\nthe discontinuity event indicator when polling entries\nin this table.  The value of this object is updated on\ntransition of slapmPolicyStatsOperStatus into the active(2)\nstate.")
slapmPolicyStatsLastMapping = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 8), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsLastMapping.setDescription("The timestamp for when the last time\nthat the associated policy entry was used.")
slapmPolicyStatsInOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInOctets.setDescription("The number of octets that was received by IP for an\nentity that map to this entry.")
slapmPolicyStatsOutOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutOctets.setDescription("The number of octets that was transmitted by IP for an\nentity that map to this entry.")
slapmPolicyStatsConnectionLimit = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 11), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsConnectionLimit.setDescription("The limit for the number of active TCP connections that\nare allowed for this policy definition.  A value of zero\nfor this object implies that a connection limit has not\nbeen specified.")
slapmPolicyStatsCountAccepts = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsCountAccepts.setDescription("This counter is incremented when a policy action's\nPermission value is set to Accept and a session\n(TCP connection) is accepted.")
slapmPolicyStatsCountDenies = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsCountDenies.setDescription("This counter is incremented when a policy action's\nPermission value is set to Deny and a session is denied,\nor when a session (TCP connection) is rejected due to a\npolicy's connection limit (slapmPolicyStatsConnectLimit)\nbeing reached.")
slapmPolicyStatsInDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInDiscards.setDescription("This counter counts the number of in octets discarded.\nThis occurs when an error is detected.  Examples of this\nare buffer overflow, checksum error, or bad packet\nformat.")
slapmPolicyStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutDiscards.setDescription("This counter counts the number of out octets discarded.\nExamples of this are buffer overflow, checksum error, or\nbad packet format.")
slapmPolicyStatsInPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInPackets.setDescription("This counter counts the number of in packets received\nthat relate to this policy entry from IP.")
slapmPolicyStatsOutPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutPackets.setDescription("This counter counts the number of out packets sent\nby IP that relate to this policy entry.")
slapmPolicyStatsInProfileOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInProfileOctets.setDescription("This counter counts the number of in octets that are\ndetermined to be within profile.")
slapmPolicyStatsOutProfileOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutProfileOctets.setDescription("This counter counts the number of out octets that are\ndetermined to be within profile.")
slapmPolicyStatsMinRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 20), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsMinRate.setDescription("The minimum transfer rate defined for this entry.")
slapmPolicyStatsMaxRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 21), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsMaxRate.setDescription("The maximum transfer rate defined for this entry.")
slapmPolicyStatsMaxDelay = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 22), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsMaxDelay.setDescription("The maximum delay defined for this entry.")
slapmPolicyMonitorTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 2))
if mibBuilder.loadTexts: slapmPolicyMonitorTable.setDescription("Provides a method of monitoring policies and their\neffect at a system.\n\nThis table has been deprecated and replaced with\nthe slapmPRMonTable.  Older implementations of\nthis MIB are expected to continue their support\nof this table.")
slapmPolicyMonitorEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 2, 1)).setIndexNames((0, "SLAPM-MIB", "slapmPolicyMonitorOwnerIndex"), (0, "SLAPM-MIB", "slapmPolicyMonitorSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyMonitorPolicyName"), (0, "SLAPM-MIB", "slapmPolicyMonitorTrafficProfileName"))
if mibBuilder.loadTexts: slapmPolicyMonitorEntry.setDescription("Defines an entry in the slapmPolicyMonitorTable. This\ntable defines which policies should be monitored on a\nper policy traffic profile basis.")
slapmPolicyMonitorOwnerIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 16))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyMonitorOwnerIndex.setDescription("To facilitate the provisioning of access control by a\nsecurity administrator using the View-Based Access\nControl Model (RFC 2575, VACM) for tables in which\nmultiple users may need to independently create or modify\nentries, the initial index is used as an 'owner index'.\nSuch an initial index has a syntax of SnmpAdminString,\nand can thus be trivially mapped to a securityName or\ngroupName as defined in VACM, in accordance with a\nsecurity policy.\n\nAll entries in that table belonging to a particular user\nwill have the same value for this initial index.  For a\ngiven user's entries in a particular table, the object\nidentifiers for the information in these entries will\nhave the same subidentifiers (except for the 'column'\nsubidentifier) up to the end of the encoded owner index.\nTo configure VACM to permit access to this portion of the\ntable, one would create vacmViewTreeFamilyTable entries\nwith the value of vacmViewTreeFamilySubtree including the\nowner index portion, and vacmViewTreeFamilyMask\n'wildcarding' the column subidentifier.  More elaborate\nconfigurations are possible.")
slapmPolicyMonitorSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 2), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyMonitorSystemAddress.setDescription("Address of a system that an Policy definition relates to.\nA zero length octet string can be used to indicate that\nonly a single system is being represented.\nOtherwise, the length of the octet string should be\n4 for an ipv4 address and 16 for an ipv6 address.")
slapmPolicyMonitorPolicyName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 3), SlapmNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyMonitorPolicyName.setDescription("Policy name that this entry relates to.")
slapmPolicyMonitorTrafficProfileName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 4), SlapmNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyMonitorTrafficProfileName.setDescription("The corresponding Traffic Profile name.")
slapmPolicyMonitorControl = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 5), Bits().subtype(namedValues=namedval.NamedValues(("monitorMinRate", 0), ("monitorMaxRate", 1), ("monitorMaxDelay", 2), ("enableAggregateTraps", 3), ("enableSubcomponentTraps", 4), ("monitorSubcomponents", 5), )).clone(("monitorMinRate","monitorMaxRate","monitorMaxDelay",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorControl.setDescription("The value of this object determines the type and level\nof monitoring that is applied to a policy/profile.  The\nvalue of this object can't be changed once the table\nentry that it is a part of is activated via a\nslapmPolicyMonitorRowStatus transition to active state.\n\n    monitorMinRate(0) - Monitor minimum transfer rate.\n    monitorMaxRate(1) - Monitor maximum transfer rate.\n    monitorMaxDelay(2) - Monitor maximum delay.\n    enableAggregateTraps(3) - The enableAggregateTraps(3)\n          BITS setting enables notification generation\n          when monitoring a policy traffic profile as an\n          aggregate using the values in the corresponding\n          slapmPolicyStatsEntry.  By default this function\n          is not enabled.\n    enableSubcomponentTraps(4) - This BITS setting enables\n          notification generation when monitoring all\n          subcomponents that are mapped to an corresponding\n          slapmPolicyStatsEntry.  By default this\n          function is not enabled.\n    monitorSubcomponents(5) - This BITS setting enables\n          monitoring of each subcomponent (typically a\n          TCP connection or UDP listener) individually.")
slapmPolicyMonitorStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 6), SlapmStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorStatus.setDescription("The value of this object indicates when a monitored\nvalue has not meet a threshold or isn't meeting the\ndefined service level.  The SlapmStatus TEXTUAL-CONVENTION\ndefines two levels of not meeting a threshold.  The first\nset:\n            slaMinInRateNotAchieved(0),\n            slaMaxInRateExceeded(1),\n            slaMaxDelayExceeded(2),\n            slaMinOutRateNotAchieved(3),\n            slaMaxOutRateExceeded(4)\n\nare used to indicate when the SLA as an aggregate is\nnot meeting a threshold while the second set:\n\n            monitorMinInRateNotAchieved(5),\n            monitorMaxInRateExceeded(6),\n            monitorMaxDelayExceeded(7),\n            monitorMinOutRateNotAchieved(8),\n            monitorMaxOutRateExceeded(9)\n\nindicate that at least one subcomponent is not meeting\na threshold.")
slapmPolicyMonitorInterval = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(15, 86400)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorInterval.setDescription("The number of seconds that defines the sample period.")
slapmPolicyMonitorIntTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 8), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorIntTime.setDescription("The timestamp for when the last interval ended.")
slapmPolicyMonitorCurrentInRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorCurrentInRate.setDescription("Using the value of the corresponding\nslapmPolicyMonitorInterval, slapmPolicyStatsInOctets\nis sampled and then divided by slapmPolicyMonitorInterval\nto determine the current in transfer rate.")
slapmPolicyMonitorCurrentOutRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorCurrentOutRate.setDescription("Using the value of the corresponding\nslapmPolicyMonitorInterval, slapmPolicyStatsOutOctets\nis sampled and then divided by slapmPolicyMonitorInterval\nto determine the current out transfer rate.")
slapmPolicyMonitorMinRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 11), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMinRateLow.setDescription("The threshold for generating a\nslapmMonitoredEventNotAchieved notification, signalling\nthat a monitored minimum transfer rate has not been meet.\n\nA slapmMonitoredEventNotAchieved notification is not\ngenerated again for an slapmPolicyMonitorEntry until\nthe minimum transfer rate\nexceeds slapmPolicyMonitorMinRateHigh (a\nslapmMonitoredEventOkay notification is then transmitted)\nand then fails below slapmPolicyMonitorMinRateLow.  This\nbehavior reduces the slapmMonitoredEventNotAchieved\nnotifications that are transmitted.\n\nA value of zero for this object is returned when the\nslapmPolicyMonitorControl monitorMinRate(0) is not\nenabled.  When enabled the default value for this object\nis the min rate value specified in the associated\naction definition minus 10%.  If the action definition\ndoesn't have a min rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMinRate(0)\nis selected.\n\nNote: The corresponding slapmPolicyMonitorControl\nBITS setting, enableAggregateTraps(3), MUST be selected in\norder for any notification relating to this entry to\npotentially be generated.")
slapmPolicyMonitorMinRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 12), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMinRateHigh.setDescription("The threshold for generating a slapmMonitoredEventOkay\nnotification, signalling that a monitored minimum\ntransfer rate has increased to an acceptable level.\n\nA value of zero for this object is returned when the\nslapmPolicyMonitorControl monitorMinRate(0) is not\nenabled.  When enabled the default value for this object\nis the min rate value specified in the associated\naction definition plus 10%.  If the action definition\ndoesn't have a min rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMinRate(0)\nis selected.\n\nNote: The corresponding slapmPolicyMonitorControl\nBITS setting, enableAggregateTraps(3), MUST be selected\nin order for any notification relating to this entry to\npotentially be generated.")
slapmPolicyMonitorMaxRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 13), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxRateHigh.setDescription("The threshold for generating a\nslapmMonitoredEventNotAchieved notification, signalling\nthat a monitored maximum transfer rate has been exceeded.\n\nA slapmMonitoredEventNotAchieved notification is not\ngenerated again for an slapmPolicyMonitorEntry until the\nmaximum transfer rate fails below\nslapmPolicyMonitorMaxRateLow (a slapmMonitoredEventOkay\nnotification is then transmitted) and then raises above\nslapmPolicyMonitorMaxRateHigh.  This behavior reduces the\nslapmMonitoredEventNotAchieved notifications that are\ntransmitted.\n\nA value of zero for this object is returned when the\nslapmPolicyMonitorControl monitorMaxRate(1) is not\nenabled.  When enabled the default value for this object\nis the max rate value specified in the associated\naction definition plus 10%.  If the action definition\ndoesn't have a max rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxRate(1)\nis selected.\n\nNote: The corresponding slapmPolicyMonitorControl\nBITS setting, enableAggregateTraps(3), MUST be selected in\norder for any notification relating to this entry to\npotentially be generated.")
slapmPolicyMonitorMaxRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 14), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxRateLow.setDescription("The threshold for generating a slapmMonitoredEventOkay\nnotification, signalling that a monitored maximum\ntransfer rate has fallen to an acceptable level.\n\nA value of zero for this object is returned when the\nslapmPolicyMonitorControl monitorMaxRate(1) is not\nenabled.  When enabled the default value for this object\nis the max rate value specified in the associated\naction definition minus 10%.  If the action definition\ndoesn't have a max rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxRate(1)\nis selected.\n\nNote: The corresponding slapmPolicyMonitorControl\nBITS setting, enableAggregateTraps(3), MUST be selected in\norder for any notification relating to this entry to\npotentially be generated.")
slapmPolicyMonitorMaxDelayHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 15), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxDelayHigh.setDescription("The threshold for generating a\nslapmMonitoredEventNotAchieved notification, signalling\nthat a monitored maximum delay rate has been exceeded.\n\nA slapmMonitoredEventNotAchieved notification is not\ngenerated again for an slapmPolicyMonitorEntry until\nthe maximum delay rate falls below\nslapmPolicyMonitorMaxDelayLow (a slapmMonitoredEventOkay\nnotification is then transmitted) and raises above\nslapmPolicyMonitorMaxDelayHigh.  This behavior reduces\nthe slapmMonitoredEventNotAchieved notifications that are\ntransmitted.\n\nA value of zero for this object is returned when the\nslapmPolicyMonitorControl monitorMaxDelay(4) is not\nenabled.  When enabled the default value for this object\nis the max delay value specified in the associated\naction definition plus 10%.  If the action definition\ndoesn't have a max delay defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxDelay(4)\nis selected.\n\nNote: The corresponding slapmPolicyMonitorControl\nBITS setting, enableAggregateTraps(3), MUST be selected\nin order for any notification relating to this entry to\npotentially be generated.")
slapmPolicyMonitorMaxDelayLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 16), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxDelayLow.setDescription("The threshold for generating a slapmMonitoredEventOkay\nnotification, signalling that a monitored maximum delay\nrate has fallen to an acceptable level.\n\nA value of zero for this object is returned when the\nslapmPolicyMonitorControl monitorMaxDelay(4) is not\nenabled.  When enabled the default value for this object\nis the max delay value specified in the associated\naction definition minus 10%.  If the action definition\ndoesn't have a max delay defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxDelay(4)\nis selected.\n\nNote: The corresponding slapmPolicyMonitorControl\nBITS setting, enableAggregateTraps(3), MUST be selected\nin order for any notification relating to this entry to\npotentially be generated.")
slapmPolicyMonitorMinInRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMinInRateNotAchieves.setDescription("The number of times that a minimum transfer in rate\nwas not achieved.")
slapmPolicyMonitorMaxInRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxInRateExceeds.setDescription("The number of times that a maximum transfer in rate\nwas exceeded.")
slapmPolicyMonitorMaxDelayExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxDelayExceeds.setDescription("The number of times that a maximum delay in rate\nwas exceeded.")
slapmPolicyMonitorMinOutRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMinOutRateNotAchieves.setDescription("The number of times that a minimum transfer out rate\nwas not achieved.")
slapmPolicyMonitorMaxOutRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxOutRateExceeds.setDescription("The number of times that a maximum transfer out rate\nwas exceeded.")
slapmPolicyMonitorCurrentDelayRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 22), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorCurrentDelayRate.setDescription("The current delay rate for this entry.  This is\ncalculated by taking the average of the TCP\nround trip times for all associating\nslapmSubcomponentTable entries within a interval.")
slapmPolicyMonitorRowStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 23), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorRowStatus.setDescription("This object allows entries to be created and deleted\nin the slapmPolicyMonitorTable.  An entry in this table\nis deleted by setting this object to destroy(6).\n\nRemoval of a corresponding (same policy and traffic profile\nnames) slapmPolicyStatsEntry has the side effect of the\nautomatic deletion an entry in this table.")
slapmSubcomponentTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 3))
if mibBuilder.loadTexts: slapmSubcomponentTable.setDescription("Defines a table to provide information on the\nindividually components that are mapped to\na policy rule (or old traffic profile).\n\nThe indexing for this table is designed to support\nthe use of an SNMP GET-NEXT operation using only\nthe remote address and remote port as a way for\na management station to retrieve the table entries\nrelating to a particular client.")
slapmSubcomponentEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 3, 1)).setIndexNames((0, "SLAPM-MIB", "slapmSubcomponentRemAddress"), (0, "SLAPM-MIB", "slapmSubcomponentRemPort"), (0, "SLAPM-MIB", "slapmSubcomponentLocalAddress"), (0, "SLAPM-MIB", "slapmSubcomponentLocalPort"))
if mibBuilder.loadTexts: slapmSubcomponentEntry.setDescription("Describes a particular subcomponent entry.  This\ntable does not have an OwnerIndex as\npart of its indexing since this table's contents\nis intended to span multiple users.")
slapmSubcomponentRemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 1), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmSubcomponentRemAddress.setDescription("Indicate the remote address of a subcomponent.\nA remote address can be either an ipv4 address in which\ncase 4 octets are required or as an ipv6 address that\nrequires 16 octets.  The value of this subidentifier\nis a zero length octet string when this entry relates\nto a UDP listener.")
slapmSubcomponentRemPort = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmSubcomponentRemPort.setDescription("Indicate the remote port of a subcomponent.\nThe value of this subidentifier\nis 0 when this entry relates to a UDP listener.")
slapmSubcomponentLocalAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 3), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmSubcomponentLocalAddress.setDescription("Indicate the local address of a subcomponent.\nA local address can be either an ipv4 address in which\ncase 4 octets are required or as an ipv6 address that\nrequires 16 octets.")
slapmSubcomponentLocalPort = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmSubcomponentLocalPort.setDescription("Indicate the local port of a subcomponent.")
slapmSubcomponentProtocol = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("udpListener", 1), ("tcpConnection", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentProtocol.setDescription("Indicate the protocol in use that identifies the\ntype of subcomponent.")
slapmSubcomponentSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 6), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentSystemAddress.setDescription("Address of a system that an Policy definition relates to.\nA zero length octet string can be used to indicate that\nonly a single system is being represented.\nOtherwise, the length of the octet string should be\n4 for an ipv4 address and 16 for an ipv6 address.")
slapmSubcomponentPolicyName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 7), SlapmNameType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentPolicyName.setDescription("Policy name that this entry relates to.\n\nThis object, along with slapmSubcomponentTrafficProfileName,\nhave been replaced with the use of an unsigned integer\nindex that is mapped to an slapmPolicyNameEntry to actually\nidentify policy naming.")
slapmSubcomponentTrafficProfileName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 8), SlapmNameType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTrafficProfileName.setDescription("The corresponding traffic profile name.\n\nThis object, along with slapmSubcomponentProfileName,\nhave been replaced with the use of an unsigned integer\nindex that is mapped to an slapmPolicyNameEntry to\nactually identify policy naming.")
slapmSubcomponentLastActivity = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 9), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentLastActivity.setDescription("The date and timestamp of when this entry was last used.")
slapmSubcomponentInOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentInOctets.setDescription("The number of octets received from IP for this\nconnection.")
slapmSubcomponentOutOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentOutOctets.setDescription("The number of octets sent to IP for this connection.")
slapmSubcomponentTcpOutBufferedOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpOutBufferedOctets.setDescription("Number of outgoing octets buffered.  The value\nof this object is zero when the entry is not\nfor a TCP connection.")
slapmSubcomponentTcpInBufferedOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpInBufferedOctets.setDescription("Number of incoming octets buffered.  The value\nof this object is zero when the entry is not\nfor a TCP connection.")
slapmSubcomponentTcpReXmts = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpReXmts.setDescription("Number of retransmissions.  The value\nof this object is zero when the entry is not\nfor a TCP connection.")
slapmSubcomponentTcpRoundTripTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 15), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpRoundTripTime.setDescription("The amount of time that has elapsed, measured in\nmilliseconds, from when the last TCP segment was\ntransmitted by the TCP Stack until the ACK was\nreceived.\n\nThe value of this object is zero when the entry is not\nfor a TCP connection.")
slapmSubcomponentTcpRoundTripVariance = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 16), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpRoundTripVariance.setDescription("Round trip time variance.\n\nThe value of this object is zero when the entry is not\nfor a TCP connection.")
slapmSubcomponentInPdus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentInPdus.setDescription("The number of protocol related data units transferred\ninbound:\n\n  slapmSubcomponentProtocol    PDU Type\n\n       udpListener(1)          UDP datagrams\n       tcpConnection(2)        TCP segments")
slapmSubcomponentOutPdus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentOutPdus.setDescription("The number of protocol related data units transferred\noutbound:\n\n  slapmSubcomponentProtocol    PDU Type\n\n       udpListener(1)          UDP datagrams\n       tcpConnection(2)        TCP segments")
slapmSubcomponentApplName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 19), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentApplName.setDescription("The application name associated with this entry if known,\notherwise a zero-length octet string is returned as the\nvalue of this object.")
slapmSubcomponentMonitorStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 20), SlapmStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorStatus.setDescription("The value of this object indicates when a monitored\nvalue has exceeded a threshold or isn't meeting the\ndefined service level.  Only the following SlapmStatus\nBITS setting can be reported here:\n\n            monitorMinInRateNotAchieved(5),\n            monitorMaxInRateExceeded(6),\n            monitorMaxDelayExceeded(7),\n            monitorMinOutRateNotAchieved(8),\n            monitorMaxOutRateExceeded(9)\n\nThis object only has meaning when an corresponding\nslapmPolicyMonitorEntry exists with the\nslapmPolicyMonitorControl BITS setting\nmonitorSubcomponents(5) enabled.")
slapmSubcomponentMonitorIntTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 21), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorIntTime.setDescription("The timestamp for when the last interval ended.\n\nThis object only has meaning when an corresponding\nslapmPRMonEntry (or old slapmPolicyMonitorEntry)\nexists with the slapmPRMonControl (or\nslapmPolicyMonitorControl) BITS setting\nmonitorSubcomponents(5) enabled.  All of the\noctets returned when monitoring is not in effect\nmust be zero.")
slapmSubcomponentMonitorCurrentInRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 22), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorCurrentInRate.setDescription("Using the value of the corresponding\nslapmPRMonInterval (or slapmPolicyMonitorInterval),\nslapmSubcomponentStatsInOctets\nis divided by slapmSubcomponentMonitorInterval to determine\nthe current in transfer rate.\n\nThis object only has meaning when an corresponding\nslapmPRMonEntry (or slapmPolicyMonitorEntry)\nexists with the slapmPRMonControl (or\nslapmPolicyMonitorControl) BITS setting\nmonitorSubcomponents(5) enabled.  The value of this\nobject is zero when monitoring is not in effect.")
slapmSubcomponentMonitorCurrentOutRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 23), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorCurrentOutRate.setDescription("Using the value of the corresponding slapmPRMonInterval (or\nslapmPolicyMonitorInterva)l, slapmSubcomponentStatsOutOctets\nis divided by slapmPRMonInterval (or\nslapmPolicyMonitorInterval) to determine the\ncurrent out transfer rate.\n\nThis object only has meaning when an corresponding\nslapmPRMonEntry (or slapmPolicyMonitorEntry) exists with\nthe slapmPRMonControl (or slapmPolicyMonitorControl)\nBITS setting monitorSubcomponents(5) enabled.  The value\nof this object is zero when monitoring is not in effect.")
slapmSubcomponentPolicyRuleIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 24), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295L))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentPolicyRuleIndex.setDescription("Points to an slapmPolicyNameEntry when combined with\nslapmSubcomponentSystemAddress to indicate the\npolicy naming that relates to this entry.\n\nA value of 0 for this object MUST be returned when\nthe corresponding slapmSubcomponentEntry has no\npolicy rule associated with it.")
slapmPolicyNameTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 4))
if mibBuilder.loadTexts: slapmPolicyNameTable.setDescription("Provides the mapping between a policy index as a\nunsigned 32 bit integer and the unique name associated\nwith a policy rule.")
slapmPolicyNameEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 4, 1)).setIndexNames((0, "SLAPM-MIB", "slapmPolicyNameSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyNameIndex"))
if mibBuilder.loadTexts: slapmPolicyNameEntry.setDescription("Defines an entry in the slapmPolicyNameTable.")
slapmPolicyNameSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 4, 1, 1), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyNameSystemAddress.setDescription("Address of a system that an Policy rule definition relates\nto.  A zero length octet string must be used to indicate\nthat only a single system is being represented.\nOtherwise, the length of the octet string must be\n4 for an ipv4 address or 16 for an ipv6 address.")
slapmPolicyNameIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295L))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPolicyNameIndex.setDescription("A locally arbitrary, but unique identifier associated\nwith this table entry.  This value is not expected to\nremain constant across reIPLs.")
slapmPolicyNameOfRule = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 4, 1, 3), SlapmPolicyRuleName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyNameOfRule.setDescription("The unique name that identifies a policy rule definition.")
slapmPolicyRuleStatsTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 5))
if mibBuilder.loadTexts: slapmPolicyRuleStatsTable.setDescription("Provides statistics on a per system and a per policy\nrule basis.")
slapmPolicyRuleStatsEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 5, 1)).setIndexNames((0, "SLAPM-MIB", "slapmPolicyNameSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyNameIndex"))
if mibBuilder.loadTexts: slapmPolicyRuleStatsEntry.setDescription("Defines an entry in the slapmPolicyRuleStatsTable.\nThis table defines a set of statistics that is kept\non a per system and per policy rule basis.\n\nEntries in this table are not created or deleted via SNMP\nbut reflect the set of policy rule definitions known\nat a system.")
slapmPolicyRuleStatsOperStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), ("deleteNeeded", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOperStatus.setDescription("The state of a policy entry:\n\ninactive(1)      - An policy entry was either defined\n                   by local system definition or\n                   discovered via\n                   a directory search but has not been\n                   activated (not currently being used).\nactive(2)        - Policy entry is being used to affect\n                   traffic flows.\ndeleteNeeded(3)  - Either though local implementation\n                   dependent methods or by discovering\n                   that the directory entry corresponding\n                   to this table entry no longer\n                   exists and slapmPolicyPurgeTime needs\n                   to expire before attempting to remove\n                   the corresponding slapmPolicyStatsEntry\n                   and any dependent slapmPolicyMonitor\n                   table entries.\nNote: a policy rule in a state other than\nactive(2) is not being used to affect traffic flows.")
slapmPolicyRuleStatsActiveConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsActiveConns.setDescription("The number of active TCP connections that are\naffected by the corresponding policy entry.")
slapmPolicyRuleStatsTotalConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsTotalConns.setDescription("The number of total TCP connections that are\naffected by the corresponding policy entry.")
slapmPolicyRuleStatsLActivated = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 4), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsLActivated.setDescription("The timestamp for when the corresponding policy entry\nwas last activated.  The value of this object serves as\nthe discontinuity event indicator when polling entries\nin this table.  The value of this object is updated on\ntransition of slapmPolicyRuleStatsOperStatus into the\nactive(2) state.")
slapmPolicyRuleStatsLastMapping = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 5), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsLastMapping.setDescription("The timestamp for when the last time\nthat the associated policy entry was used.")
slapmPolicyRuleStatsInOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInOctets.setDescription("The number of octets that was received by IP for an\nentity that map to this entry.")
slapmPolicyRuleStatsOutOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutOctets.setDescription("The number of octets that was transmitted by IP for an\nentity that map to this entry.")
slapmPolicyRuleStatsConnLimit = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsConnLimit.setDescription("The limit for the number of active TCP connections that\nare allowed for this policy definition.  A value of zero\nfor this object implies that a connection limit has not\nbeen specified.")
slapmPolicyRuleStatsCountAccepts = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsCountAccepts.setDescription("This counter is incremented when a policy action's\nPermission value is set to Accept and a session\n(TCP connection) is accepted.")
slapmPolicyRuleStatsCountDenies = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsCountDenies.setDescription("This counter is incremented when a policy action's\nPermission value is set to Deny and a session is denied,\nor when a session (TCP connection) is rejected due to a\npolicy's connection limit (slapmPolicyRuleStatsConnectLimit)\nbeing reached.")
slapmPolicyRuleStatsInDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInDiscards.setDescription("This counter counts the number of in octets discarded.\nThis occurs when an error is detected.  Examples of this\nare buffer overflow, checksum error, or bad packet\nformat.")
slapmPolicyRuleStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutDiscards.setDescription("This counter counts the number of out octets discarded.\nExamples of this are buffer overflow, checksum error, or\nbad packet format.")
slapmPolicyRuleStatsInPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInPackets.setDescription("This counter counts the number of in packets received\nthat relate to this policy entry from IP.")
slapmPolicyRuleStatsOutPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutPackets.setDescription("This counter counts the number of out packets sent\nby IP that relate to this policy entry.")
slapmPolicyRuleStatsInProOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInProOctets.setDescription("This counter counts the number of in octets that are\ndetermined to be within profile.")
slapmPolicyRuleStatsOutProOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutProOctets.setDescription("This counter counts the number of out octets that are\ndetermined to be within profile.")
slapmPolicyRuleStatsMinRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 17), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsMinRate.setDescription("The minimum transfer rate defined for this entry.")
slapmPolicyRuleStatsMaxRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 18), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsMaxRate.setDescription("The maximum transfer rate defined for this entry.")
slapmPolicyRuleStatsMaxDelay = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 19), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsMaxDelay.setDescription("The maximum delay defined for this entry.")
slapmPolicyRuleStatsTotalRsvpFlows = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsTotalRsvpFlows.setDescription("Total number of RSVP flows that have be activated.")
slapmPolicyRuleStatsActRsvpFlows = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsActRsvpFlows.setDescription("Current number of active RSVP flows.")
slapmPRMonTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 6))
if mibBuilder.loadTexts: slapmPRMonTable.setDescription("Provides a method of monitoring policies and their\neffect at a system.")
slapmPRMonEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 6, 1)).setIndexNames((0, "SLAPM-MIB", "slapmPRMonOwnerIndex"), (0, "SLAPM-MIB", "slapmPRMonSystemAddress"), (0, "SLAPM-MIB", "slapmPRMonIndex"))
if mibBuilder.loadTexts: slapmPRMonEntry.setDescription("Defines an entry in the slapmPRMonTable. This\ntable defines which policies should be monitored on a\nper policy rule basis.\n\nAn attempt to set any read-create object defined within an\nslapmPRMonEntry while the value of slapmPRMonRowStatus is\nactive(1) will result in an inconsistentValue error.")
slapmPRMonOwnerIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 16))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPRMonOwnerIndex.setDescription("To facilitate the provisioning of access control by a\nsecurity administrator using the View-Based Access\nControl Model (RFC 2575, VACM) for tables in which\nmultiple users may need to independently create or modify\nentries, the initial index is used as an 'owner index'.\nSuch an initial index has a syntax of SnmpAdminString,\nand can thus be trivially mapped to a securityName or\ngroupName as defined in VACM, in accordance with a\nsecurity policy.\n\nAll entries in that table belonging to a particular user\nwill have the same value for this initial index.  For a\ngiven user's entries in a particular table, the object\nidentifiers for the information in these entries will\nhave the same subidentifiers (except for the 'column'\nsubidentifier) up to the end of the encoded owner index.\nTo configure VACM to permit access to this portion of the\ntable, one would create vacmViewTreeFamilyTable entries\nwith the value of vacmViewTreeFamilySubtree including the\nowner index portion, and vacmViewTreeFamilyMask\n'wildcarding' the column subidentifier.  More elaborate\nconfigurations are possible.")
slapmPRMonSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 2), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(16,16),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPRMonSystemAddress.setDescription("Address of a system that an Policy definition relates to.\nA zero length octet string can be used to indicate that\nonly a single system is being represented.\nOtherwise, the length of the octet string should be\n4 for an ipv4 address and 16 for an ipv6 address.")
slapmPRMonIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 3), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: slapmPRMonIndex.setDescription("An slapmPolicyNameTable index, slapmPolicyNameIndex,\nthat points to the unique name associated with a\npolicy rule definition.")
slapmPRMonControl = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 4), Bits().subtype(namedValues=namedval.NamedValues(("monitorMinRate", 0), ("monitorMaxRate", 1), ("monitorMaxDelay", 2), ("enableAggregateTraps", 3), ("enableSubcomponentTraps", 4), ("monitorSubcomponents", 5), )).clone(("monitorMinRate","monitorMaxRate","monitorMaxDelay",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonControl.setDescription("The value of this object determines the type and level\nof monitoring that is applied to a policy rule.  The\nvalue of this object can't be changed once the table\nentry that it is a part of is activated via a\nslapmPRMonRowStatus transition to active state.\n\n    monitorMinRate(0) - Monitor minimum transfer rate.\n    monitorMaxRate(1) - Monitor maximum transfer rate.\n    monitorMaxDelay(2) - Monitor maximum delay.\n    enableAggregateTraps(3) - The enableAggregateTraps(3)\n          BITS setting enables notification generation\n          when monitoring a policy rule as an\n          aggregate using the values in the corresponding\n          slapmPRMonStatsEntry.  By default this function\n          is not enabled.\n    enableSubcomponentTraps(4) - This BITS setting enables\n          notification generation when monitoring all\n          subcomponents that are mapped to an corresponding\n          slapmPRMonStatsEntry.  By default this\n          function is not enabled.\n    monitorSubcomponents(5) - This BITS setting enables\n          monitoring of each subcomponent (typically a\n          TCP connection or UDP listener) individually.")
slapmPRMonStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 5), SlapmStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonStatus.setDescription("The value of this object indicates when a monitored\nvalue has not meet a threshold or isn't meeting the\ndefined service level.  The SlapmStatus TEXTUAL-CONVENTION\ndefines two levels of not meeting a threshold.  The first\nset:\n            slaMinInRateNotAchieved(0),\n            slaMaxInRateExceeded(1),\n            slaMaxDelayExceeded(2),\n            slaMinOutRateNotAchieved(3),\n            slaMaxOutRateExceeded(4)\n\nare used to indicate when the SLA as an aggregate is\nnot meeting a threshold while the second set:\n\n            monitorMinInRateNotAchieved(5),\n            monitorMaxInRateExceeded(6),\n            monitorMaxDelayExceeded(7),\n            monitorMinOutRateNotAchieved(8),\n            monitorMaxOutRateExceeded(9)\n\nindicate that at least one subcomponent is not meeting\na threshold.")
slapmPRMonInterval = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(15, 86400)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonInterval.setDescription("The number of seconds that defines the sample period.")
slapmPRMonIntTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 7), DateAndTime().clone('\x00\x00\x00\x00\x00\x00\x00\x00')).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonIntTime.setDescription("The timestamp for when the last interval ended.")
slapmPRMonCurrentInRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonCurrentInRate.setDescription("Using the value of the corresponding\nslapmPRMonInterval, slapmPolicyRuleStatsInOctets\nis sampled and then divided by slapmPRMonInterval\nto determine the current in transfer rate.")
slapmPRMonCurrentOutRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonCurrentOutRate.setDescription("Using the value of the corresponding\nslapmPolicyMonInterval, slapmPolicyRuleStatsOutOctets\nis sampled and then divided by slapmPRMonInterval\nto determine the current out transfer rate.")
slapmPRMonMinRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 10), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMinRateLow.setDescription("The threshold for generating a\nslapmPolicyRuleMonNotOkay notification, signalling\nthat a monitored minimum transfer rate has not been meet.\nA slapmPolicyRuleMonNotOkay notification is not\ngenerated again for an slapmPRMonEntry until\nthe minimum transfer rate\nexceeds slapmPRMonMinRateHigh (a\nslapmPolicyRuleMonOkay notification is then transmitted)\nand then fails below slapmPRMonMinRateLow.  This\nbehavior reduces the slapmPolicyRuleMonNotOkay\nnotifications that are transmitted.\n\nA value of zero for this object is returned when the\nslapmPRMonControl monitorMinRate(0) is not\nenabled.  When enabled the default value for this object\nis the min rate value specified in the associated\naction definition minus 10%.  If the action definition\ndoesn't have a min rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMinRate(0)\nis selected.\n\nNote: The corresponding slapmPRMonControl\nBITS setting, enableAggregateTraps(3), MUST be selected in\norder for any notification relating to this entry to\npotentially be generated.")
slapmPRMonMinRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 11), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMinRateHigh.setDescription("The threshold for generating a slapmPolicyRuleMonOkay\nnotification, signalling that a monitored minimum\ntransfer rate has increased to an acceptable level.\n\nA value of zero for this object is returned when the\nslapmPRMonControl monitorMinRate(0) is not\nenabled.  When enabled the default value for this object\nis the min rate value specified in the associated\naction definition plus 10%.  If the action definition\ndoesn't have a min rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMinRate(0)\nis selected.\n\nNote: The corresponding slapmPRMonControl\nBITS setting, enableAggregateTraps(3), MUST be selected\nin order for any notification relating to this entry to\npotentially be generated.")
slapmPRMonMaxRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 12), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxRateHigh.setDescription("The threshold for generating a\nslapmPolicyRuleMonNotOkay notification, signalling\nthat a monitored maximum transfer rate has been exceeded.\n\nA slapmPolicyRuleNotOkay notification is not\ngenerated again for an slapmPRMonEntry until the\nmaximum transfer rate fails below\nslapmPRMonMaxRateLow (a slapmPolicyRuleMonOkay\nnotification is then transmitted) and then raises above\nslapmPRMonMaxRateHigh.  This behavior reduces the\nslapmPolicyRuleMonNotOkay notifications that are\ntransmitted.\n\nA value of zero for this object is returned when the\nslapmPRMonControl monitorMaxRate(1) is not\nenabled.  When enabled the default value for this object\nis the max rate value specified in the associated\naction definition plus 10%.  If the action definition\ndoesn't have a max rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxRate(1)\nis selected.\n\nNote: The corresponding slapmPRMonControl\nBITS setting, enableAggregateTraps(3), MUST be selected in\norder for any notification relating to this entry to\npotentially be generated.")
slapmPRMonMaxRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 13), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxRateLow.setDescription("The threshold for generating a slapmPolicyRuleMonOkay\nnotification, signalling that a monitored maximum\ntransfer rate has fallen to an acceptable level.\nA value of zero for this object is returned when the\nslapmPRMonControl monitorMaxRate(1) is not\nenabled.  When enabled the default value for this object\nis the max rate value specified in the associated\naction definition minus 10%.  If the action definition\ndoesn't have a max rate defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxRate(1)\nis selected.\n\nNote: The corresponding slapmPRMonControl\nBITS setting, enableAggregateTraps(3), MUST be selected in\norder for any notification relating to this entry to\npotentially be generated.")
slapmPRMonMaxDelayHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 14), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxDelayHigh.setDescription("The threshold for generating a\nslapmPolicyRuleMonNotOkay notification, signalling\nthat a monitored maximum delay rate has been exceeded.\n\nA slapmPolicyRuleMonNotOkay notification is not\ngenerated again for an slapmPRMonEntry until\nthe maximum delay rate falls below\nslapmPRMonMaxDelayLow (a slapmPolicyRuleMonOkay\nnotification is then transmitted) and raises above\nslapmPRMonMaxDelayHigh.  This behavior reduces\nthe slapmPolicyRuleMonNotOkay notifications that are\ntransmitted.\n\nA value of zero for this object is returned when the\nslapmPRMonControl monitorMaxDelay(4) is not\nenabled.  When enabled the default value for this object\nis the max delay value specified in the associated\naction definition plus 10%.  If the action definition\ndoesn't have a max delay defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxDelay(4)\nis selected.\n\nNote: The corresponding slapmPRMonControl\nBITS setting, enableAggregateTraps(3), MUST be selected\nin order for any notification relating to this entry to\npotentially be generated.")
slapmPRMonMaxDelayLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 15), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxDelayLow.setDescription("The threshold for generating a slapmPolicyRuleMonOkay\nnotification, signalling that a monitored maximum delay\nrate has fallen to an acceptable level.\n\nA value of zero for this object is returned when the\nslapmPRMonControl monitorMaxDelay(4) is not\nenabled.  When enabled the default value for this object\nis the max delay value specified in the associated\naction definition minus 10%.  If the action definition\ndoesn't have a max delay defined then there is no\ndefault for this object and a value MUST be specified\nprior to activating this entry when monitorMaxDelay(4)\nis selected.\n\nNote: The corresponding slapmPRMonControl\nBITS setting, enableAggregateTraps(3), MUST be selected\nin order for any notification relating to this entry to\npotentially be generated.")
slapmPRMonMinInRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMinInRateNotAchieves.setDescription("The number of times that a minimum transfer in rate\nwas not achieved.")
slapmPRMonMaxInRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMaxInRateExceeds.setDescription("The number of times that a maximum transfer in rate\nwas exceeded.")
slapmPRMonMaxDelayExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMaxDelayExceeds.setDescription("The number of times that a maximum delay in rate\nwas exceeded.")
slapmPRMonMinOutRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMinOutRateNotAchieves.setDescription("The number of times that a minimum transfer out rate\nwas not achieved.")
slapmPRMonMaxOutRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMaxOutRateExceeds.setDescription("The number of times that a maximum transfer out rate\nwas exceeded.")
slapmPRMonCurrentDelayRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonCurrentDelayRate.setDescription("The current delay rate for this entry.  This is\ncalculated by taking the average of the TCP\nround trip times for all associating\nslapmSubcomponentTable entries within a interval.")
slapmPRMonRowStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 22), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonRowStatus.setDescription("This object allows entries to be created and deleted\nin the slapmPRMonTable.  An entry in this table\nis deleted by setting this object to destroy(6).\n\nRemoval of an corresponding (same policy index)\nslapmPolicyRuleStatsEntry has the side effect of the\nautomatic deletion an entry in this table.\n\nNote that an attempt to set any read-create object\ndefined within an slapmPRMonEntry while the value\nof slapmPRMonRowStatus is active(1) will result in\nan inconsistentValue error.")
slapmConformance = MibIdentifier((1, 3, 6, 1, 3, 88, 2))
slapmCompliances = MibIdentifier((1, 3, 6, 1, 3, 88, 2, 1))
slapmGroups = MibIdentifier((1, 3, 6, 1, 3, 88, 2, 2))

# Augmentions

# Notifications

slapmPolicyRuleMonOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 8)).setObjects(("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), )
slapmSubcomponentMonitoredEventNotAchieved = NotificationType((1, 3, 6, 1, 3, 88, 0, 5)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTrafficProfileName"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentPolicyName"), )
slapmSubcomponentMonitoredEventOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 6)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTrafficProfileName"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentPolicyName"), )
slapmPolicyRuleMonNotOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 7)).setObjects(("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), )
slapmSubcMonitorNotOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 11)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmSubcomponentPolicyRuleIndex"), )
slapmPolicyProfileDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 3)).setObjects(("SLAPM-MIB", "slapmPolicyStatsInPackets"), ("SLAPM-MIB", "slapmPolicyStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyStatsInProfileOctets"), ("SLAPM-MIB", "slapmPolicyStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyStatsFirstActivated"), ("SLAPM-MIB", "slapmPolicyStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyStatsInOctets"), ("SLAPM-MIB", "slapmPolicyStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyStatsMinRate"), ("SLAPM-MIB", "slapmPolicyStatsConnectionLimit"), ("SLAPM-MIB", "slapmPolicyStatsMaxDelay"), ("SLAPM-MIB", "slapmPolicyStatsOutProfileOctets"), )
slapmPolicyMonitorDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 4)).setObjects(("SLAPM-MIB", "slapmPolicyMonitorMaxDelayExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorInterval"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorMaxOutRateExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayHigh"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorMaxInRateExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayLow"), )
slapmPolicyRuleDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 9)).setObjects(("SLAPM-MIB", "slapmPolicyRuleStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyRuleStatsLActivated"), ("SLAPM-MIB", "slapmPolicyRuleStatsInProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsInPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsConnLimit"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyRuleStatsActRsvpFlows"), ("SLAPM-MIB", "slapmPolicyRuleStatsInOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalRsvpFlows"), ("SLAPM-MIB", "slapmPolicyRuleStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxDelay"), ("SLAPM-MIB", "slapmPolicyRuleStatsMinRate"), )
slapmPolicyRuleMonDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 10)).setObjects(("SLAPM-MIB", "slapmPRMonInterval"), ("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonMaxRateHigh"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonMaxDelayLow"), ("SLAPM-MIB", "slapmPRMonMaxOutRateExceeds"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonMaxDelayExceeds"), ("SLAPM-MIB", "slapmPRMonMinRateLow"), ("SLAPM-MIB", "slapmPRMonMaxRateLow"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), ("SLAPM-MIB", "slapmPRMonMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPRMonMaxDelayHigh"), ("SLAPM-MIB", "slapmPRMonMinRateHigh"), ("SLAPM-MIB", "slapmPRMonMaxInRateExceeds"), ("SLAPM-MIB", "slapmPRMonMinOutRateNotAchieves"), )
slapmMonitoredEventNotAchieved = NotificationType((1, 3, 6, 1, 3, 88, 0, 1)).setObjects(("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorControl"), ("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"), )
slapmSubcMonitorOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 12)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmSubcomponentPolicyRuleIndex"), )
slapmMonitoredEventOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 2)).setObjects(("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorControl"), ("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"), )

# Groups

slapmEndSystemGroup = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 3)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentPolicyName"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripVariance"), ("SLAPM-MIB", "slapmSubcomponentTcpReXmts"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentProtocol"), ("SLAPM-MIB", "slapmSubcomponentOutOctets"), ("SLAPM-MIB", "slapmSubcomponentApplName"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentLastActivity"), ("SLAPM-MIB", "slapmSubcomponentTcpOutBufferedOctets"), ("SLAPM-MIB", "slapmSubcomponentInOctets"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentTcpInBufferedOctets"), ("SLAPM-MIB", "slapmPolicyTrapFilter"), ("SLAPM-MIB", "slapmSubcomponentOutPdus"), ("SLAPM-MIB", "slapmSubcomponentTrafficProfileName"), ("SLAPM-MIB", "slapmSubcomponentInPdus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), )
slapmOptionalGroup = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 2)).setObjects(("SLAPM-MIB", "slapmPolicyStatsInProfileOctets"), ("SLAPM-MIB", "slapmPolicyStatsOutProfileOctets"), )
slapmEndSystemNotGroup2 = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 9)).setObjects(("SLAPM-MIB", "slapmSubcMonitorNotOkay"), ("SLAPM-MIB", "slapmSubcMonitorOkay"), )
slapmBaseGroup2 = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 6)).setObjects(("SLAPM-MIB", "slapmPolicyRuleStatsActiveConns"), ("SLAPM-MIB", "slapmPRMonMinRateHigh"), ("SLAPM-MIB", "slapmPolicyCountSuccessAccesses"), ("SLAPM-MIB", "slapmPolicyPurgeTime"), ("SLAPM-MIB", "slapmPolicyRuleStatsInDiscards"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonMaxDelayLow"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutDiscards"), ("SLAPM-MIB", "slapmPRMonMaxDelayExceeds"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalRsvpFlows"), ("SLAPM-MIB", "slapmPolicyRuleStatsOperStatus"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyNameOfRule"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutProOctets"), ("SLAPM-MIB", "slapmPRMonRowStatus"), ("SLAPM-MIB", "slapmPolicyRuleStatsInProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsConnLimit"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalConns"), ("SLAPM-MIB", "slapmPRMonMaxInRateExceeds"), ("SLAPM-MIB", "slapmPolicyTrapEnable"), ("SLAPM-MIB", "slapmPolicyCountQueries"), ("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPolicyRuleStatsInPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyRuleStatsLActivated"), ("SLAPM-MIB", "slapmPRMonMinInRateNotAchieves"), ("SLAPM-MIB", "slapmSpinLock"), ("SLAPM-MIB", "slapmPRMonMinRateLow"), ("SLAPM-MIB", "slapmPolicyRuleStatsActRsvpFlows"), ("SLAPM-MIB", "slapmPRMonMaxOutRateExceeds"), ("SLAPM-MIB", "slapmPolicyRuleStatsInOctets"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), ("SLAPM-MIB", "slapmPRMonMaxDelayHigh"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxDelay"), ("SLAPM-MIB", "slapmPRMonMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyRuleStatsMinRate"), ("SLAPM-MIB", "slapmPRMonInterval"), ("SLAPM-MIB", "slapmPRMonMaxRateHigh"), ("SLAPM-MIB", "slapmPolicyCountAccesses"), ("SLAPM-MIB", "slapmPRMonMaxRateLow"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPolicyCountNotFounds"), )
slapmNotGroup2 = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 8)).setObjects(("SLAPM-MIB", "slapmPolicyRuleDeleted"), ("SLAPM-MIB", "slapmPolicyRuleMonOkay"), ("SLAPM-MIB", "slapmPolicyRuleMonNotOkay"), ("SLAPM-MIB", "slapmPolicyRuleMonDeleted"), )
slapmEndSystemGroup2 = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 7)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripVariance"), ("SLAPM-MIB", "slapmSubcomponentTcpReXmts"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentProtocol"), ("SLAPM-MIB", "slapmSubcomponentOutOctets"), ("SLAPM-MIB", "slapmSubcomponentApplName"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentLastActivity"), ("SLAPM-MIB", "slapmSubcomponentTcpOutBufferedOctets"), ("SLAPM-MIB", "slapmSubcomponentInOctets"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentTcpInBufferedOctets"), ("SLAPM-MIB", "slapmPolicyTrapFilter"), ("SLAPM-MIB", "slapmSubcomponentOutPdus"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentInPdus"), ("SLAPM-MIB", "slapmSubcomponentPolicyRuleIndex"), )
slapmBaseGroup = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 1)).setObjects(("SLAPM-MIB", "slapmPolicyMonitorMaxRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorInterval"), ("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyCountSuccessAccesses"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayHigh"), ("SLAPM-MIB", "slapmPolicyPurgeTime"), ("SLAPM-MIB", "slapmPolicyStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyStatsInOctets"), ("SLAPM-MIB", "slapmPolicyStatsMaxDelay"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayLow"), ("SLAPM-MIB", "slapmPolicyStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyStatsOperStatus"), ("SLAPM-MIB", "slapmPolicyStatsMinRate"), ("SLAPM-MIB", "slapmPolicyStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyMonitorMaxOutRateExceeds"), ("SLAPM-MIB", "slapmPolicyTrapEnable"), ("SLAPM-MIB", "slapmPolicyCountQueries"), ("SLAPM-MIB", "slapmPolicyStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayExceeds"), ("SLAPM-MIB", "slapmPolicyStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateHigh"), ("SLAPM-MIB", "slapmSpinLock"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorRowStatus"), ("SLAPM-MIB", "slapmPolicyStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyStatsInPackets"), ("SLAPM-MIB", "slapmPolicyStatsConnectionLimit"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"), ("SLAPM-MIB", "slapmPolicyStatsFirstActivated"), ("SLAPM-MIB", "slapmPolicyCountAccesses"), ("SLAPM-MIB", "slapmPolicyStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyMonitorMaxInRateExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyCountNotFounds"), ("SLAPM-MIB", "slapmPolicyMonitorControl"), )
slapmNotGroup = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 4)).setObjects(("SLAPM-MIB", "slapmPolicyProfileDeleted"), ("SLAPM-MIB", "slapmMonitoredEventOkay"), ("SLAPM-MIB", "slapmPolicyMonitorDeleted"), ("SLAPM-MIB", "slapmMonitoredEventNotAchieved"), )
slapmEndSystemNotGroup = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 5)).setObjects(("SLAPM-MIB", "slapmSubcomponentMonitoredEventNotAchieved"), ("SLAPM-MIB", "slapmSubcomponentMonitoredEventOkay"), )

# Exports

# Module identity
mibBuilder.exportSymbols("SLAPM-MIB", PYSNMP_MODULE_ID=slapmMIB)

# Types
mibBuilder.exportSymbols("SLAPM-MIB", SlapmNameType=SlapmNameType, SlapmPolicyRuleName=SlapmPolicyRuleName, SlapmStatus=SlapmStatus)

# Objects
mibBuilder.exportSymbols("SLAPM-MIB", slapmMIB=slapmMIB, slapmNotifications=slapmNotifications, slapmObjects=slapmObjects, slapmBaseObjects=slapmBaseObjects, slapmSpinLock=slapmSpinLock, slapmPolicyCountQueries=slapmPolicyCountQueries, slapmPolicyCountAccesses=slapmPolicyCountAccesses, slapmPolicyCountSuccessAccesses=slapmPolicyCountSuccessAccesses, slapmPolicyCountNotFounds=slapmPolicyCountNotFounds, slapmPolicyPurgeTime=slapmPolicyPurgeTime, slapmPolicyTrapEnable=slapmPolicyTrapEnable, slapmPolicyTrapFilter=slapmPolicyTrapFilter, slapmTableObjects=slapmTableObjects, slapmPolicyStatsTable=slapmPolicyStatsTable, slapmPolicyStatsEntry=slapmPolicyStatsEntry, slapmPolicyStatsSystemAddress=slapmPolicyStatsSystemAddress, slapmPolicyStatsPolicyName=slapmPolicyStatsPolicyName, slapmPolicyStatsTrafficProfileName=slapmPolicyStatsTrafficProfileName, slapmPolicyStatsOperStatus=slapmPolicyStatsOperStatus, slapmPolicyStatsActiveConns=slapmPolicyStatsActiveConns, slapmPolicyStatsTotalConns=slapmPolicyStatsTotalConns, slapmPolicyStatsFirstActivated=slapmPolicyStatsFirstActivated, slapmPolicyStatsLastMapping=slapmPolicyStatsLastMapping, slapmPolicyStatsInOctets=slapmPolicyStatsInOctets, slapmPolicyStatsOutOctets=slapmPolicyStatsOutOctets, slapmPolicyStatsConnectionLimit=slapmPolicyStatsConnectionLimit, slapmPolicyStatsCountAccepts=slapmPolicyStatsCountAccepts, slapmPolicyStatsCountDenies=slapmPolicyStatsCountDenies, slapmPolicyStatsInDiscards=slapmPolicyStatsInDiscards, slapmPolicyStatsOutDiscards=slapmPolicyStatsOutDiscards, slapmPolicyStatsInPackets=slapmPolicyStatsInPackets, slapmPolicyStatsOutPackets=slapmPolicyStatsOutPackets, slapmPolicyStatsInProfileOctets=slapmPolicyStatsInProfileOctets, slapmPolicyStatsOutProfileOctets=slapmPolicyStatsOutProfileOctets, slapmPolicyStatsMinRate=slapmPolicyStatsMinRate, slapmPolicyStatsMaxRate=slapmPolicyStatsMaxRate, slapmPolicyStatsMaxDelay=slapmPolicyStatsMaxDelay, slapmPolicyMonitorTable=slapmPolicyMonitorTable, slapmPolicyMonitorEntry=slapmPolicyMonitorEntry, slapmPolicyMonitorOwnerIndex=slapmPolicyMonitorOwnerIndex, slapmPolicyMonitorSystemAddress=slapmPolicyMonitorSystemAddress, slapmPolicyMonitorPolicyName=slapmPolicyMonitorPolicyName, slapmPolicyMonitorTrafficProfileName=slapmPolicyMonitorTrafficProfileName, slapmPolicyMonitorControl=slapmPolicyMonitorControl, slapmPolicyMonitorStatus=slapmPolicyMonitorStatus, slapmPolicyMonitorInterval=slapmPolicyMonitorInterval, slapmPolicyMonitorIntTime=slapmPolicyMonitorIntTime, slapmPolicyMonitorCurrentInRate=slapmPolicyMonitorCurrentInRate, slapmPolicyMonitorCurrentOutRate=slapmPolicyMonitorCurrentOutRate, slapmPolicyMonitorMinRateLow=slapmPolicyMonitorMinRateLow, slapmPolicyMonitorMinRateHigh=slapmPolicyMonitorMinRateHigh, slapmPolicyMonitorMaxRateHigh=slapmPolicyMonitorMaxRateHigh, slapmPolicyMonitorMaxRateLow=slapmPolicyMonitorMaxRateLow, slapmPolicyMonitorMaxDelayHigh=slapmPolicyMonitorMaxDelayHigh, slapmPolicyMonitorMaxDelayLow=slapmPolicyMonitorMaxDelayLow, slapmPolicyMonitorMinInRateNotAchieves=slapmPolicyMonitorMinInRateNotAchieves, slapmPolicyMonitorMaxInRateExceeds=slapmPolicyMonitorMaxInRateExceeds, slapmPolicyMonitorMaxDelayExceeds=slapmPolicyMonitorMaxDelayExceeds, slapmPolicyMonitorMinOutRateNotAchieves=slapmPolicyMonitorMinOutRateNotAchieves, slapmPolicyMonitorMaxOutRateExceeds=slapmPolicyMonitorMaxOutRateExceeds, slapmPolicyMonitorCurrentDelayRate=slapmPolicyMonitorCurrentDelayRate, slapmPolicyMonitorRowStatus=slapmPolicyMonitorRowStatus, slapmSubcomponentTable=slapmSubcomponentTable, slapmSubcomponentEntry=slapmSubcomponentEntry, slapmSubcomponentRemAddress=slapmSubcomponentRemAddress, slapmSubcomponentRemPort=slapmSubcomponentRemPort, slapmSubcomponentLocalAddress=slapmSubcomponentLocalAddress, slapmSubcomponentLocalPort=slapmSubcomponentLocalPort, slapmSubcomponentProtocol=slapmSubcomponentProtocol, slapmSubcomponentSystemAddress=slapmSubcomponentSystemAddress, slapmSubcomponentPolicyName=slapmSubcomponentPolicyName, slapmSubcomponentTrafficProfileName=slapmSubcomponentTrafficProfileName, slapmSubcomponentLastActivity=slapmSubcomponentLastActivity, slapmSubcomponentInOctets=slapmSubcomponentInOctets, slapmSubcomponentOutOctets=slapmSubcomponentOutOctets, slapmSubcomponentTcpOutBufferedOctets=slapmSubcomponentTcpOutBufferedOctets, slapmSubcomponentTcpInBufferedOctets=slapmSubcomponentTcpInBufferedOctets, slapmSubcomponentTcpReXmts=slapmSubcomponentTcpReXmts, slapmSubcomponentTcpRoundTripTime=slapmSubcomponentTcpRoundTripTime, slapmSubcomponentTcpRoundTripVariance=slapmSubcomponentTcpRoundTripVariance, slapmSubcomponentInPdus=slapmSubcomponentInPdus, slapmSubcomponentOutPdus=slapmSubcomponentOutPdus, slapmSubcomponentApplName=slapmSubcomponentApplName, slapmSubcomponentMonitorStatus=slapmSubcomponentMonitorStatus, slapmSubcomponentMonitorIntTime=slapmSubcomponentMonitorIntTime, slapmSubcomponentMonitorCurrentInRate=slapmSubcomponentMonitorCurrentInRate, slapmSubcomponentMonitorCurrentOutRate=slapmSubcomponentMonitorCurrentOutRate, slapmSubcomponentPolicyRuleIndex=slapmSubcomponentPolicyRuleIndex, slapmPolicyNameTable=slapmPolicyNameTable, slapmPolicyNameEntry=slapmPolicyNameEntry, slapmPolicyNameSystemAddress=slapmPolicyNameSystemAddress, slapmPolicyNameIndex=slapmPolicyNameIndex, slapmPolicyNameOfRule=slapmPolicyNameOfRule, slapmPolicyRuleStatsTable=slapmPolicyRuleStatsTable, slapmPolicyRuleStatsEntry=slapmPolicyRuleStatsEntry, slapmPolicyRuleStatsOperStatus=slapmPolicyRuleStatsOperStatus, slapmPolicyRuleStatsActiveConns=slapmPolicyRuleStatsActiveConns, slapmPolicyRuleStatsTotalConns=slapmPolicyRuleStatsTotalConns, slapmPolicyRuleStatsLActivated=slapmPolicyRuleStatsLActivated, slapmPolicyRuleStatsLastMapping=slapmPolicyRuleStatsLastMapping, slapmPolicyRuleStatsInOctets=slapmPolicyRuleStatsInOctets, slapmPolicyRuleStatsOutOctets=slapmPolicyRuleStatsOutOctets, slapmPolicyRuleStatsConnLimit=slapmPolicyRuleStatsConnLimit, slapmPolicyRuleStatsCountAccepts=slapmPolicyRuleStatsCountAccepts, slapmPolicyRuleStatsCountDenies=slapmPolicyRuleStatsCountDenies, slapmPolicyRuleStatsInDiscards=slapmPolicyRuleStatsInDiscards, slapmPolicyRuleStatsOutDiscards=slapmPolicyRuleStatsOutDiscards, slapmPolicyRuleStatsInPackets=slapmPolicyRuleStatsInPackets, slapmPolicyRuleStatsOutPackets=slapmPolicyRuleStatsOutPackets, slapmPolicyRuleStatsInProOctets=slapmPolicyRuleStatsInProOctets, slapmPolicyRuleStatsOutProOctets=slapmPolicyRuleStatsOutProOctets, slapmPolicyRuleStatsMinRate=slapmPolicyRuleStatsMinRate, slapmPolicyRuleStatsMaxRate=slapmPolicyRuleStatsMaxRate, slapmPolicyRuleStatsMaxDelay=slapmPolicyRuleStatsMaxDelay, slapmPolicyRuleStatsTotalRsvpFlows=slapmPolicyRuleStatsTotalRsvpFlows, slapmPolicyRuleStatsActRsvpFlows=slapmPolicyRuleStatsActRsvpFlows, slapmPRMonTable=slapmPRMonTable, slapmPRMonEntry=slapmPRMonEntry, slapmPRMonOwnerIndex=slapmPRMonOwnerIndex, slapmPRMonSystemAddress=slapmPRMonSystemAddress, slapmPRMonIndex=slapmPRMonIndex, slapmPRMonControl=slapmPRMonControl, slapmPRMonStatus=slapmPRMonStatus, slapmPRMonInterval=slapmPRMonInterval, slapmPRMonIntTime=slapmPRMonIntTime, slapmPRMonCurrentInRate=slapmPRMonCurrentInRate)
mibBuilder.exportSymbols("SLAPM-MIB", slapmPRMonCurrentOutRate=slapmPRMonCurrentOutRate, slapmPRMonMinRateLow=slapmPRMonMinRateLow, slapmPRMonMinRateHigh=slapmPRMonMinRateHigh, slapmPRMonMaxRateHigh=slapmPRMonMaxRateHigh, slapmPRMonMaxRateLow=slapmPRMonMaxRateLow, slapmPRMonMaxDelayHigh=slapmPRMonMaxDelayHigh, slapmPRMonMaxDelayLow=slapmPRMonMaxDelayLow, slapmPRMonMinInRateNotAchieves=slapmPRMonMinInRateNotAchieves, slapmPRMonMaxInRateExceeds=slapmPRMonMaxInRateExceeds, slapmPRMonMaxDelayExceeds=slapmPRMonMaxDelayExceeds, slapmPRMonMinOutRateNotAchieves=slapmPRMonMinOutRateNotAchieves, slapmPRMonMaxOutRateExceeds=slapmPRMonMaxOutRateExceeds, slapmPRMonCurrentDelayRate=slapmPRMonCurrentDelayRate, slapmPRMonRowStatus=slapmPRMonRowStatus, slapmConformance=slapmConformance, slapmCompliances=slapmCompliances, slapmGroups=slapmGroups)

# Notifications
mibBuilder.exportSymbols("SLAPM-MIB", slapmPolicyRuleMonOkay=slapmPolicyRuleMonOkay, slapmSubcomponentMonitoredEventNotAchieved=slapmSubcomponentMonitoredEventNotAchieved, slapmSubcomponentMonitoredEventOkay=slapmSubcomponentMonitoredEventOkay, slapmPolicyRuleMonNotOkay=slapmPolicyRuleMonNotOkay, slapmSubcMonitorNotOkay=slapmSubcMonitorNotOkay, slapmPolicyProfileDeleted=slapmPolicyProfileDeleted, slapmPolicyMonitorDeleted=slapmPolicyMonitorDeleted, slapmPolicyRuleDeleted=slapmPolicyRuleDeleted, slapmPolicyRuleMonDeleted=slapmPolicyRuleMonDeleted, slapmMonitoredEventNotAchieved=slapmMonitoredEventNotAchieved, slapmSubcMonitorOkay=slapmSubcMonitorOkay, slapmMonitoredEventOkay=slapmMonitoredEventOkay)

# Groups
mibBuilder.exportSymbols("SLAPM-MIB", slapmEndSystemGroup=slapmEndSystemGroup, slapmOptionalGroup=slapmOptionalGroup, slapmEndSystemNotGroup2=slapmEndSystemNotGroup2, slapmBaseGroup2=slapmBaseGroup2, slapmNotGroup2=slapmNotGroup2, slapmEndSystemGroup2=slapmEndSystemGroup2, slapmBaseGroup=slapmBaseGroup, slapmNotGroup=slapmNotGroup, slapmEndSystemNotGroup=slapmEndSystemNotGroup)
