# PySNMP SMI module. Autogenerated from smidump -f python SNA-NAU-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:36 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( DisplayString, InstancePointer, RowStatus, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "InstancePointer", "RowStatus", "TimeStamp")

# Objects

snanauMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34)).setRevisions(("1994-05-12 09:00",))
if mibBuilder.loadTexts: snanauMIB.setOrganization("IETF SNA NAU MIB Working Group")
if mibBuilder.loadTexts: snanauMIB.setContactInfo("       Zbigniew Kielczewski\nEicon Technology Inc.\n2196 32nd Avenue\nLachine, Que  H8T 3H7\nCanada\nTel:    1 514 631 2592\nE-mail: zbig@eicon.qc.ca\n\nDeirdre Kostick\nBellcore\n331 Newman Springs Road\nRed Bank, NJ 07701\nTel:    1 908 758 2642\nE-mail: dck2@mail.bellcore.com\n\nKitty Shih (editor)\nNovell\n890 Ross Drive\nSunnyvale, CA 94089\nTel:   1 408 747 4305\nE-mail: kmshih@novell.com")
if mibBuilder.loadTexts: snanauMIB.setDescription("This is the MIB module for objects used to\nmanage SNA devices.")
snanauObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 1))
snaNode = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 1, 1))
snaNodeAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 1, 1))
if mibBuilder.loadTexts: snaNodeAdminTable.setDescription("This table contains objects which describe the\nconfiguration parameters for an SNA Node.  Link\nspecific configuration objects are contained in\na separate MIB module (e.g., SNA DLC MIB)\ncorresponding to the link type.\nThe table snaNodeAdminLinkTable contains objects\nwhich identify the relationship between node instances\nand link instances.\n\nThe entries (i.e., rows) in this table can be created\nby either an Agent or a Management Station.\nThe Management Station can do this through setting\nthe appropriate value in the snaNodeAdminRowStatus.\n\nThe snaNodeAdminRowStatus object describes the\nstatus of an entry and is used to change the status\nof an entry.  The entry is deleted by an Agent based\non the value of the snaNodeAdminRowStatus.\n\nThe snaNodeAdminState object describes the desired\noperational state of a Node and is used to change the\noperational state of a Node.  For example, such\ninformation may be obtained from a configuration file.\n\nHow an Agent or a Management Station obtains the\ninitial value of each object at creation time is an\nimplementation specific issue.\n\nFor each entry in this table, there is a corresponding\nentry in the snaNodeOperTable.\nWhile the objects in this table describe the desired\nor configured operational values of the SNA Node, the\nactual runtime values are contained in\nsnaNodeOperTable.")
snaNodeAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1)).setIndexNames((0, "SNA-NAU-MIB", "snaNodeAdminIndex"))
if mibBuilder.loadTexts: snaNodeAdminEntry.setDescription("An entry contains the configuration parameters for\none SNA Node instance. The objects in the entry\nhave read-create access.\nAn entry can be created, modified or deleted.  The\nobject snaNodeAdminRowStatus is used (i.e., set) to\ncreate or delete a row entry.")
snaNodeAdminIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: snaNodeAdminIndex.setDescription("Index used to uniquely identify each Node instance.\nIf an Agent creates the entry, then it will assign\nthis number otherwise a Management Station\ngenerates a random number when it reserves the\nentry for creation.")
snaNodeAdminName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 17))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminName.setDescription("The value indicates the desired name of the\nNode for use during Node activation.\nIn Type 2.1 networks, this is a fully-qualified name,\nmeaning that the Node name is preceded by the NetId (if\npresent) with a period as the delimiter.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaNodeOperName until the Node has\nbeen re-activated (e.g., after the next initialization\nof the SNA services).")
snaNodeAdminType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,6,2,1,5,4,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("pu10", 2), ("pu20", 3), ("t21len", 4), ("endNode", 5), ("networkNode", 6), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminType.setDescription("The value indicates the type of SNA Node.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaNodeOperType until the Node has\nbeen re-activated (e.g., after the next initialization\nof the SNA services).")
snaNodeAdminXidFormat = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("format0", 1), ("format1", 2), ("format3", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminXidFormat.setDescription("The value indicates the type of XID format used for\nthis Node.  Note that there is no format type 2.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaNodeOperAdminXidFormat until the Node has\nbeen re-activated (e.g., after the next initialization\nof the SNA services).")
snaNodeAdminBlockNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 5), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 3)).setFixedLength(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminBlockNum.setDescription("The value indicates the block number for this Node\ninstance.  It is the first 3 hexadecimal digits of the\nSNA Node id.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaNodeOperBlockNum until the Node has\nbeen re-activated (e.g., after the next initialization\nof the SNA services).")
snaNodeAdminIdNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 6), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(5, 5)).setFixedLength(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminIdNum.setDescription("The value indicates the ID number for this Node\ninstance.  This is the last 5 hexadecimal digits of\nthe SNA Node id.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaNodeOperIdNum until the Node has\nbeen re-activated (e.g., after the next initialization\nof the SNA services).")
snaNodeAdminEnablingMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("startup", 2), ("demand", 3), ("onlyMS", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminEnablingMethod.setDescription("The value indicates how the Node should be\nactivated for the first time.\nThe values have the following meanings:\n\nother (1)  - may be used for proprietary methods\n   not listed in this enumeration,\nstartup (2) - at SNA services' initialization time\n   (this is the default),\ndemand (3) - only when LU is requested by application,\n             or\nonlyMS (4) - by a Management Station only.\n\nA  write operation to this object may immediately\nchange the operational value reflected\nin snaNodeOperEnablingMethod depending\non the Agent implementation.  If the Agent\nimplementation accepts immediate changes, then the\nbehavior of the Node changes immediately and not only\nafter the next system startup of the SNA services.\nAn immediate change may only apply when the\ncurrent value 'demand (3)' is changed to 'onlyMS (4)'\nand vice versa.")
snaNodeAdminLuTermDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("unbind", 1), ("termself", 2), ("rshutd", 3), ("poweroff", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminLuTermDefault.setDescription("The value indicates the desired default method\nused to deactivate LUs for this Node\nFor LU6.2s, 'unbind(1)' is the only valid value.\n\nunbind(1) -   terminate the LU-LU session by sending\n        an SNA UNBIND request.\ntermself(2) - terminate the LU-LU session by sending\n        an SNA TERM-SELF (Terminate Self) request on\n        the SSCP-LU session. The SSCP will inform the\n        remote session LU partner to send an UNBIND\n        request to terminate the session.\nrshutd(3) -   terminate the LU-LU session by sending\n        an SNA RSHUTD (Request ShutDown) request to\n        the remote session LU partner. The remote LU\n        will then send an UNBIND request to terminate\n        the session.\npoweroff(4) - terminate the LU-LU session by sending\n        either an SNA LUSTAT (LU Status) request on\n        the LU-LU session or an SNA NOTIFY request on\n        the SSCP-LU session indicating that the LU has\n        been powered off. Sending both is also\n        acceptable. The result should be that the\n        remote session LU partner will send an UNBIND\n        to terminate the session.\n\nThe default behavior indicated by the value of this\nobject may be overridden for an LU instance. The\noverride is performed by setting the snaLuAdminTerm\nobject instance in the snaLuAdminTable to the desired\nvalue.\n\nA write operation to this object may immediately\nchange the operational value reflected\nin snaNodeOperLuTermDefault depending\non the Agent implementation.")
snaNodeAdminMaxLu = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 9), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminMaxLu.setDescription("The maximum number of LUs that may be\nactivated for this Node. For PU2.1, this object\nrefers to the number of dependent LUs.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaNodeOperMaxLu until the Node has\nbeen re-activated (e.g., after the next initialization\nof the SNA services).")
snaNodeAdminHostDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 10), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminHostDescription.setDescription("The value identifies the remote host associated\nwith this Node.\nSince SSCP Id's may not be unique\nacross hosts, the host description\nis required to uniquely identify the SSCP.\nThis object is only applicable to PU2.0 type\nNodes. If the remote host is unknown, then the\nvalue is the null string.\n\nA write operation to this object may immediately\nchange the operational value reflected\nin snaNodeOperHostDescription depending\non the Agent implementation.")
snaNodeAdminStopMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("normal", 2), ("immed", 3), ("force", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminStopMethod.setDescription("The value indicates the desired method to be used\nby the Agent to stop a Node (i.e., change the Node's\noperational state to inactive(1) ).\n\nThe values have the following meaning:\n\nother (1) - used for proprietary\n      methods not listed in this enumeration.\nnormal(2) - deactivate only when there is no more\n      activity on this Node (i.e., all data flows\n      have been completed and all sessions\n      have been terminated).\nimmed(3)  - deactivate immediately regardless of\n      current activities on this Node. Wait for\n      deactivation responses (from remote Node)\n      before changing the Node state to inactive.\nforce(4)  - deactivate immediately regardless of\n      current activities on this Node. Do not wait\n      for deactivation responses (from remote Node)\n      before changing the Node state to inactive.\n\nA write operation to this object may immediately\nchange the operational value reflected\nin snaNodeOperStopMethod depending\non the Agent implementation.")
snaNodeAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminState.setDescription("The value indicates the desired operational\nstate of the SNA Node. This object is used\nby the Management Station to\nactivate or deactivate the Node.\n\nIf the current value in snaNodeOperState is\n'active (2)', then setting this object to\n'inactive (1)' will initiate the Node shutdown\nprocess using the method indicated\nby snaNodeOperStopMethod.\n\nIf the current value in snaNodeOperState is\n'inactive (1)', then setting this object to\n'active (2)' will initiate the\nNode's activation.\n\nA Management Station can always set this object to\n'active (2)' irrespective of the value in the\nsnaOperEnablingMethod.")
snaNodeAdminRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 1, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeAdminRowStatus.setDescription("This object is used by a Management Station to\ncreate or delete the row entry in the\nsnaNodeAdminTable following\nthe RowStatus textual convention.\n\nUpon successful creation of\nthe row, an Agent automatically creates a\ncorresponding entry in the snaNodeOperTable with\nsnaNodeOperState equal to 'inactive (1)'.\n\nRow deletion can be Management Station or Agent\ninitiated:\n(a) The Management Station can set the value to\n'destroy (6)' only when the value of\nsnaNodeOperState of this Node instance is\n'inactive (1)'. The Agent will then delete the rows\ncorresponding to this Node instance from the\nsnaNodeAdminTable and the snaNodeOperTable.\n(b) The Agent detects that a row is in the\n'notReady (3)' state for greater than a\ndefault period of 5 minutes.\n(c) All rows with the snaNodeAdminRowStatus object's\nvalue of 'notReady (3)' will be removed upon the\nnext initialization of the SNA services.")
snaNodeAdminTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 34, 1, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeAdminTableLastChange.setDescription("The value indicates the timestamp\n(e.g., the Agent's sysUpTime value) of the last\nchange made to any object in the snaNodeAdminTable,\nincluding row deletions/additions (e.g., changes to\nsnaNodeAdminRowStatus values).\n\nThis object can be used to reduce frequent\nretrievals of the snaNodeAdminTable by a Management\nStation. It is expected that a Management Station\nwill periodically poll this object and compare its\ncurrent value with the previous one. A difference\nindicates that some Node configuration information\nhas been changed. Only then will the Management\nStation retrieve the entire table.")
snaNodeOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 1, 3))
if mibBuilder.loadTexts: snaNodeOperTable.setDescription("This table contains the dynamic parameters which\nhave read-only access. These objects reflect the\nactual status of the Node. The entries in this\ntable cannot be created or modified by a\nManagement Station.\nThis table augments the snaNodeAdminTable.")
snaNodeOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1))
if mibBuilder.loadTexts: snaNodeOperEntry.setDescription("The entry contains parameters which describe the\nstate of one Node. The entries are created by the\nAgent. They have read-only access.")
snaNodeOperName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperName.setDescription("The value identifies the current name of the Node.\nIn Type 2.1 networks, this\nis a fully-qualified name, meaning that the Node name\nis preceded by the NetId (if present) with a period\nas the delimiter.")
snaNodeOperType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,6,2,1,5,4,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("pu10", 2), ("pu20", 3), ("t21LEN", 4), ("endNode", 5), ("networkNode", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperType.setDescription("The value identifies the current type of the Node.")
snaNodeOperXidFormat = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("format0", 1), ("format1", 2), ("format3", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperXidFormat.setDescription("The value identifies the type of XID format currently\nused for this Node.\nNote that there is no format type 2.")
snaNodeOperBlockNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 3)).setFixedLength(3)).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperBlockNum.setDescription("The value identifies the block number for this Node\ninstance. It is the first 3 hexadecimal digits\nof the SNA Node id.")
snaNodeOperIdNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 5), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(5, 5)).setFixedLength(5)).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperIdNum.setDescription("The value identifies the ID number for this Node\ninstance.  This is the last 5 hexadecimal digits of\nthe SNA Node id.")
snaNodeOperEnablingMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("startup", 2), ("demand", 3), ("onlyMS", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperEnablingMethod.setDescription("The value indicates how the Node is activated for\nthe first time.\nThe values have the following meanings:\n   other (1)   - not at boot time, LU activation\n      or by a Management Station;\n   startup (2) - at SNA services' initialization\n      time (this is the default),\n   demand (3)  - only when LU is requested by\n      application,\n   onlyMS (4) - by a network Management Station\n      only.")
snaNodeOperLuTermDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("unbind", 1), ("termself", 2), ("rshutd", 3), ("poweroff", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperLuTermDefault.setDescription("The value identifies the default method used to\ndeactivate LUs for this Node.\nFor LU6.2s, 'unbind(1)' is the only valid value.\n\nunbind(1) -   terminate the LU-LU session by sending\n        an SNA UNBIND request.\ntermself(2) - terminate the LU-LU session by sending\n        an SNA TERM-SELF (Terminate Self) request on\n        the SSCP-LU session. The SSCP will inform the\n        remote session LU partner to send an UNBIND\n        request to terminate the session.\nrshutd(3) -   terminate the LU-LU session by sending\n        an SNA RSHUTD (Request ShutDown) request to\n        the remote session LU partner. The remote LU\n        will then send an UNBIND request to terminate\n        the session.\npoweroff(4) - terminate the LU-LU session by sending\n        either an SNA LUSTAT (LU Status) request on\n        the LU-LU session or an SNA NOTIFY request on\n        the SSCP-LU session indicating that the LU has\n        been powered off. Sending both is also\n        acceptable. The result should be that the\n        remote session LU partner will send an UNBIND\n        to terminate the session.\n\nThis object describes the default behavior for this\nNode; however, it is possible that for a specific LU\nthe behavior indicated by the snaLuOperTerm object is\ndifferent.")
snaNodeOperMaxLu = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperMaxLu.setDescription("This value identifies the current, maximum number\nof LUs that are activated for this Node. For PU2.1,\nthis object refers to the number of dependent LUs.")
snaNodeOperHostDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 9), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperHostDescription.setDescription("This value identifies the remote host currently\nassociated with this Node.\nSince SSCP Id's may not be unique\nacross hosts, the host description\nis required to uniquely identify the SSCP.")
snaNodeOperStopMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("normal", 2), ("immed", 3), ("force", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperStopMethod.setDescription("This value identifies the current Node shutdown\nmethod to be used by the Agent to stop the Node.\nWhen the Agent changes the Node's state to 'inactive\n(1)', the Agent must use the shutdown method\nindicated by this object.\n\nThe values have the following meaning:\n\nother (1) - proprietary method not listed in this\n            enumeration\nnormal(2) - deactivate only when there is no more\n      activity on this Node (i.e., all data flows\n      have been completed and all sessions have\n      been terminated).\nimmed(3)  - deactivate immediately regardless of\n      current activities on this Node. Wait for\n      deactivation responses (from remote Node)\n      before changing the Node state to inactive.\nforce(4)  - deactivate immediately regardless of\n      current activities on this Node. Do not wait\n      for deactivation responses (from remote Node)\n      before changing the Node state to inactive.\n\nNote that a write operation to\nsnaNodeAdminOperStopMethod may immediately change\nthe value of snaNodeOperStopMethod depending on\nthe Agent implementation.")
snaNodeOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,4,3,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), ("waiting", 3), ("stopping", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperState.setDescription("The current state of the Node.\nThe values have the following meanings:\n  inactive (1), a row representing the Node has\n      been created in the AdminTable\n      and, the Node is ready for activation -or-\n      an active Node has been stopped -or-\n      a waiting Node has returned to the inactive\n      state.\n  waiting (3), a request to have the Node activated\n      has been issued, and the Node is pending\n      activation.\n  active (2), the Node is ready and operating.\n  stopping (4), the request to stop the Node has\n      been issued while the StopMethod normal\n      or immediate is used.")
snaNodeOperHostSscpId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 12), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 6))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperHostSscpId.setDescription("This value identifies the current SSCP Id\nassociated with the Node. This object is only\napplicable to PU 2.0s. If the Node\nis not a PU 2.0 type, then this object contains a\nzero length string.")
snaNodeOperStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 13), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperStartTime.setDescription("The timestamp (e.g, the Agent's sysUpTime value)\nat the Node activation.")
snaNodeOperLastStateChange = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 14), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperLastStateChange.setDescription("The timestamp (e.g., the Agent's sysUpTime value)\nat the last state change of the Node.")
snaNodeOperActFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperActFailures.setDescription("This value identifies the number of failed Node\nactivation attempts.")
snaNodeOperActFailureReason = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 3, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,5,2,1,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("linkFailure", 2), ("noResources", 3), ("badConfiguration", 4), ("internalError", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperActFailureReason.setDescription("The value indicates the reason for the activation\nfailure.  The value 'other (1)' indicates a reason\nnot listed in the enumeration. This object\nwill be sent in the trap snaNodeActFailTrap.")
snaNodeOperTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 34, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeOperTableLastChange.setDescription("The timestamp (e.g., the Agent's sysUpTime value)\nat the last change made to any object in the\nsnaNodeOperTable, including row deletions/additions\nmade as a result of changes to the\nsnaNodeAdminRowStatus object.\n\nThis object can be used to reduce frequent\nretrievals of the snaNodeOperTable by a Management\nStation. It is expected that a Management Station\nwill periodically poll this object and compare its\ncurrent value with the previous one. A difference\nindicates that some Node operational information\nhas been changed. Only then will the Management\nStation retrieve the entire table.")
snaPu20StatsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 1, 5))
if mibBuilder.loadTexts: snaPu20StatsTable.setDescription("This table contains the dynamic parameters which\nhave read-only access. The entries in this table\ncorrespond to PU 2.0 entries in the snaNodeOperTable\nand cannot be created by a Management Station.")
snaPu20StatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1)).setIndexNames((0, "SNA-NAU-MIB", "snaNodeAdminIndex"))
if mibBuilder.loadTexts: snaPu20StatsEntry.setDescription("The entry contains parameters which describe the\nstatistics for one PU 2.0. They have read-only\naccess.\nThe counters represent traffic for all kinds\nof sessions: LU-LU, SSCP-PU, SSCP-LU.\n\nEach Node of PU Type 2.0 from the snaNodeAdminTable\nhas one entry in this table and the index used\nhere has the same value as snaNodeAdminIndex of\nthat PU.  The entry is created by the Agent.")
snaPu20StatsSentBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsSentBytes.setDescription("The number of bytes sent by this Node.")
snaPu20StatsReceivedBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsReceivedBytes.setDescription("The number of bytes received by this Node.")
snaPu20StatsSentPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsSentPius.setDescription("The number of PIUs sent by this Node.")
snaPu20StatsReceivedPius = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsReceivedPius.setDescription("The number of PIUs received by this Node.")
snaPu20StatsSentNegativeResps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsSentNegativeResps.setDescription("The number of negative responses sent\nby this Node.")
snaPu20StatsReceivedNegativeResps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsReceivedNegativeResps.setDescription("The number of negative responses received\nby this Node.")
snaPu20StatsActLus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsActLus.setDescription("The number of LUs on this PU which have\nreceived and responded to ACTLU from the host.")
snaPu20StatsInActLus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsInActLus.setDescription("The number of LUs on this PU which have\nnot received an ACTLU from the host.  This is\npossible if the number of configured LUs exceeds\nthat on the host.")
snaPu20StatsBindLus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 5, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaPu20StatsBindLus.setDescription("The number of LUs on this PU which have\nreceived and acknowledged a BIND request from the\nhost.")
snaNodeLinkAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 1, 6))
if mibBuilder.loadTexts: snaNodeLinkAdminTable.setDescription("This table contains the references to link\nspecific tables. If a Node is configured for\nmultiple links, then the Node will have\nmultiple entries in this table.\nThe entries in this table can be generated\ninitially, after initialization of SNA service,\nby the Agent which uses information from\nNode configuration file.\nSubsequent modifications of parameters,\ncreation of new Nodes link entries and deletion\nof entries is possible.\nThe modification to this table can be\nsaved in the Node configuration file for the\nnext initialization of SNA service, but the mechanism\nfor this function is not defined here.")
snaNodeLinkAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 1, 6, 1)).setIndexNames((0, "SNA-NAU-MIB", "snaNodeAdminIndex"), (0, "SNA-NAU-MIB", "snaNodeLinkAdminIndex"))
if mibBuilder.loadTexts: snaNodeLinkAdminEntry.setDescription("Entry contains the configuration information that\nassociates a Node instance to one link instance.\nThe objects in the entry have read-create access.\nEntry can be created, modified or deleted.\nThe object snaNodeLinkAdminRowStatus is used (set)\nto create or delete an entry.\nThe object snaNodeLinkAdminSpecific can be set\nlater, after the entry has been created.")
snaNodeLinkAdminIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 6, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: snaNodeLinkAdminIndex.setDescription("This value is used to index the instances of objects.\nIf an Agent creates the entry, then it will assign\nthis number otherwise a Management Station\ngenerates a random number when it reserves the\nentry for creation.")
snaNodeLinkAdminSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 6, 1, 2), InstancePointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeLinkAdminSpecific.setDescription("This value points to the row in the table\ncontaining information on the link instance.\n(e.g., the sdlcLSAdminTable of\nthe SNA DLC MIB module).")
snaNodeLinkAdminMaxPiu = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 6, 1, 3), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeLinkAdminMaxPiu.setDescription("This value identifies the maximum number of octets\nthat can be exchanged by this Node in one\nPath Information Unit (PIU).")
snaNodeLinkAdminRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 6, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaNodeLinkAdminRowStatus.setDescription("This object is used by a Management Station to\ncreate or delete the row entry in the\nsnaNodeLinkAdminTable.\nTo activate a row, a Management Station sets the value\nto 'active (1)' or 'notReady (3)'.  Upon successful\ncreation of the row, the Agent automatically creates\na corresponding entry in the snaNodeLinkOperTable.\n\nRow deletion can be Management Station or Agent\ninitiated:\n(a) The Management Station can set the value to\n'destroy (6)' only when the value of\nsnaNodeLinkOperState of this Link\ninstance is 'inactive (1)'. The Agent will then\ndelete the row corresponding to this Link\ninstance from snaNodeLinkOperTable and\nfrom snaNodeLinkAdminTable.\n(b) The Agent detects that a row is in the\n'notReady (3)' state for greater than a\ndefault period of 5 minutes.\n(c) The Agent will not include a row with RowStatus=\n'notReady (3)', after SNA system re-initialization\n (e.g., reboot).")
snaNodeLinkAdminTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 34, 1, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeLinkAdminTableLastChange.setDescription("The timestamp (e.g., the Agent's sysUpTime value)\nat the last\nchange made to any object in the snaNodeLinkAdminTable,\nincluding row deletions/additions (i.e., changes\nto the snaNodeLinkAdminRowStatus object).\n\nThis object can be used to reduce frequent\nretrievals of the snaNodeLinkAdminTable by a\nManagement Station. It is expected that a\nManagement Station will periodically poll this\nobject and compare its current value with the\nprevious one.\nA difference indicates that some Node operational\ninformation has been changed. Only then will the\nManagement Station retrieve the entire table.")
snaNodeLinkOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 1, 8))
if mibBuilder.loadTexts: snaNodeLinkOperTable.setDescription("This table contains all references to link\nspecific tables for operational parameters.\nIf a Node is configured for multiple links,\nthen the Node will have multiple entries in\nthis table. This table augments the\nsnaNodeLinkAdminTable.")
snaNodeLinkOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 1, 8, 1))
if mibBuilder.loadTexts: snaNodeLinkOperEntry.setDescription("Entry contains all current parameters for one\nNode link. The objects in the entry have\nread-only access.")
snaNodeLinkOperSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 8, 1, 1), InstancePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeLinkOperSpecific.setDescription("This value points to the row in the table\ncontaining information on the link instance.\n(e.g., the sdlcLSOperTable of\nthe SNA DLC MIB module).")
snaNodeLinkOperMaxPiu = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 1, 8, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeLinkOperMaxPiu.setDescription("Maximum number of octets that can\nbe exchanged by this Node in one Path\nInformation Unit (PIU).")
snaNodeLinkOperTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 34, 1, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaNodeLinkOperTableLastChange.setDescription("The timestamp of the last\nchange made to any object in the snaNodeLinkOperTable,\nincluding row deletions/additions.\n\nThis object can be used to reduce frequent\nretrievals of the snaNodeLinkOperTable by a\nManagement Station. It is expected that a\nManagement Station will periodically poll this\nobject and compare its current value with the\nprevious one.\nA difference indicates that some Node operational\ninformation has been changed. Only then will the\nManagement Station retrieve the entire table.")
snaNodeTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 1, 1, 10))
snaLu = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 1, 2))
snaLuAdminTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 2, 1))
if mibBuilder.loadTexts: snaLuAdminTable.setDescription("This table contains LU configuration information.\nThe rows in this table can be created and deleted\nby a Management Station.\nOnly objects which are common to all types of LUs\nare included in this table.")
snaLuAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1)).setIndexNames((0, "SNA-NAU-MIB", "snaNodeAdminIndex"), (0, "SNA-NAU-MIB", "snaLuAdminLuIndex"))
if mibBuilder.loadTexts: snaLuAdminEntry.setDescription("Contains configuration variables for an LU.")
snaLuAdminLuIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: snaLuAdminLuIndex.setDescription("This value identifies the unique index for an\nLU instance within a Node.")
snaLuAdminName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 48))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminName.setDescription("This value identifies the user configurable\nname for this LU. If a name is not assigned to the LU,\nthen this object contains a zero length string.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaLuOperName until the Node has\nbeen re-activated (e.g., after the next\ninitialization of the SNA services).")
snaLuAdminSnaName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 17))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminSnaName.setDescription("This value identifies the SNA LU name\nused in exchange of SNA data.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaLuOperSnaName until the Node has\nbeen re-activated (e.g., after the next\ninitialization of the SNA services).")
snaLuAdminType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,4,5,6,8,1,7,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("lu0", 2), ("lu1", 3), ("lu2", 4), ("lu3", 5), ("lu4", 6), ("lu62", 7), ("lu7", 8), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminType.setDescription("This value identifies the LU type.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaLuOperAdminType until the Node has\nbeen re-activated (e.g., after the next\ninitialization of the SNA services).")
snaLuAdminDepType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("dependent", 1), ("independent", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminDepType.setDescription("This value identifies whether the LU is\ndependent or independent.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaLuOperDepType until the Node has\nbeen re-activated (e.g., after the next\ninitialization of the SNA services).")
snaLuAdminLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 6), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminLocalAddress.setDescription("The local address for this LU is a byte with a value\nranging from 0 to 254.For dependent LUs, this value\nranges from 1 to 254 and for independent LUs this\nvalue is always 0.\n\nA write operation to this object will not change the\noperational value reflected in snaLuOperLocalAddress\nuntil the Node has been re-activated (e.g., after the\nnext initialization of the SNA services).")
snaLuAdminDisplayModel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,10,2,4,1,5,9,8,6,7,)).subtype(namedValues=namedval.NamedValues(("invalid", 1), ("dynamic", 10), ("model2A", 2), ("model2B", 3), ("model3A", 4), ("model3B", 5), ("model4A", 6), ("model4B", 7), ("model5A", 8), ("model5B", 9), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminDisplayModel.setDescription("The value of this object identifies the  model type\nand screen size of the terminal connected to the host.\nThis is only valid for LU Type 2.  The values have\nthe following meaning:\n\nmodel2A(2) - Model 2 (24 rows x 80 cols) with base\n        attributes\nmodel2B(3) - Model 2 (24 rows x 80 cols) with\n        extended attributes\nmodel3A(4) - Model 3 (32 rows x 80 cols) with base\n        attributes\nmodel3B(5) - Model 3 (32 rows x 80 cols) with extended\n        attributes\nmodel4A(6) - Model 4 (43 rows x 80 cols) with base\n        attributes\nmodel4B(7) - Model 4 (43 rows x 80 cols) with extended\n                                attributes\nmodel5A(8) - Model 5 (27 rows x 132 cols) with base\n        attributes\nmodel5B(9) - Model 5 (27 rows x 132 cols) with\n        extended attributes\ndynamic(10) - Screen size determine with BIND and Read\n                                Partition Query.\n\nIn case this LU is not Type 2, then this object\nshould contain the invalid(1) value.")
snaLuAdminTerm = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("unbind", 1), ("termself", 2), ("rshutd", 3), ("poweroff", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminTerm.setDescription("This value identifies the desired method for\ndeactivation of this LU. This value overrides the\ndefault method (snaNodeOperLuTermDefault) for this\nNode.  For LU 6.2, only the value 'unbind (1)'\napplies.\n\nunbind(1) -   terminate the LU-LU session by sending\n        an SNA UNBIND request.\ntermself(2) - terminate the LU-LU session by sending\n        an SNA TERM-SELF (Terminate Self) request on\n        the SSCP-LU session. The SSCP will inform the\n        remote session LU partner to send an UNBIND\n        request to terminate the session.\nrshutd(3) -   terminate the LU-LU session by sending\n        an SNA RSHUTD (Request ShutDown) request to\n        the remote session LU partner. The remote LU\n        will then send an UNBIND request to terminate\n        the session.\npoweroff(4) - terminate the LU-LU session by sending\n        either an SNA LUSTAT (LU Status) request on\n        the LU-LU session or an SNA NOTIFY request on\n        the SSCP-LU session indicating that the LU has\n        been powered off. Sending both is also\n        acceptable. The result should be that the\n        remote session LU partner will send an UNBIND\n        to terminate the session.\n\nA write operation to this object may immediately\nchange the operational value reflected\nin snaLuOperTerm depending\non the Agent implementation.")
snaLuAdminRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 1, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: snaLuAdminRowStatus.setDescription("This object is used by a Management Station to\ncreate or delete the row entry in the\nsnaLuAdminTable.\nTo activate a row, the Management Station sets the\nvalue to 'active (1)' or 'notReady (3)'.\nUpon successful creation of the row, the Agent\nautomatically creates a corresponding entry in the\nsnaLuOperTable with snaLuOperState equal to\n'inactive (1)'.\nRow deletion can be Management Station or Agent\ninitiated:\n(a) The Management Station can set the value to\n'destroy (6)' only when the value of snaLuOperState\nof this LU instance is 'inactive (1)'. The Agent will\nthen delete the row corresponding to this LU\ninstance from snaLuAdminTable and\nfrom snaLuOperTable.\n(b) The Agent detects that a row is in the\n'notReady (3)' state for greater than a\ndefault period of 5 minutes.\n(c) The Agent will not create a row with RowStatus\nequal to 'notReady (3)', after SNA system\nre-initialization (e.g., reboot).")
snaLuOperTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 2, 2))
if mibBuilder.loadTexts: snaLuOperTable.setDescription("This table contains dynamic runtime information and\ncontrol variables relating to LUs.\nOnly objects which are common to all types of LUs are\nincluded in this table. This table augments the\nsnaLuAdminTable.")
snaLuOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1))
if mibBuilder.loadTexts: snaLuOperEntry.setDescription("Contains objects reflecting current information\nfor an LU.\nEach entry is created by the Agent.  All entries\nhave read-only access.")
snaLuOperName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 48))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperName.setDescription("User configurable name for this LU. If a name\nis not assigned, then this object contains a\nzero length string.")
snaLuOperSnaName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperSnaName.setDescription("The value identifies the current SNA LU name.")
snaLuOperType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,4,5,6,8,1,7,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("lu0", 2), ("lu1", 3), ("lu2", 4), ("lu3", 5), ("lu4", 6), ("lu62", 7), ("lu7", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperType.setDescription("The value identifies the current LU type.")
snaLuOperDepType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("dependent", 1), ("independent", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperDepType.setDescription("The value identifies whether the LU is currently\ndependent or independent.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaLuOperDepType until the Node has\nbeen re-activated (e.g., after the next\ninitialization of the SNA services).")
snaLuOperLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 5), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperLocalAddress.setDescription("The local address for this LU is a byte with a value\nranging from 0 to 254. For dependent LUs, this value\nranges from 1 to 254; for independent LUs this value\nis always 0.\n\nA write operation to this object will\nnot change the operational value reflected\nin snaLuOperLocalAddress until the Node has\nbeen re-activated (e.g., after the next\ninitialization of the SNA services).")
snaLuOperDisplayModel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,10,2,4,1,5,9,8,6,7,)).subtype(namedValues=namedval.NamedValues(("invalid", 1), ("dynamic", 10), ("model2A", 2), ("model2B", 3), ("model3A", 4), ("model3B", 5), ("model4A", 6), ("model4B", 7), ("model5A", 8), ("model5B", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperDisplayModel.setDescription("The screen model type of the terminal connected to\nthe host. If this LU is not Type 2, then this\nobject should contain the 'invalid(1)' value.")
snaLuOperTerm = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("unbind", 1), ("termself", 2), ("rshutd", 3), ("poweroff", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperTerm.setDescription("The value identifies the current method for\ndeactivation of this LU. This value overrides the\ndefault method (snaNodeOperLuTermDefault) for this\nNode.  For LU 6.2, only the value 'unbind (1)'\napplies.\n\nunbind(1) -   terminate the LU-LU session by sending\n        an SNA UNBIND request.\ntermself(2) - terminate the LU-LU session by sending\n        an SNA TERM-SELF (Terminate Self) request on\n        the SSCP-LU session. The SSCP will inform the\n        remote session LU partner to send an UNBIND\n        request to terminate the session.\nrshutd(3) -   terminate the LU-LU session by sending\n        an SNA RSHUTD (Request ShutDown) request to\n        the remote session LU partner. The remote LU\n        will then send an UNBIND request to terminate\n        the session.\npoweroff(4) - terminate the LU-LU session by sending\n        either an SNA LUSTAT (LU Status) request on\n        the LU-LU session or an SNA NOTIFY request on\n        the SSCP-LU session indicating that the LU has\n        been powered off. Sending both is also\n        acceptable. The result should be that the\n        remote session LU partner will send an UNBIND\n        to terminate the session.")
snaLuOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperState.setDescription("The value identifies the current operational state of\nthis LU.\nIt has different meanings for dependent and independent\nLUs.\nFor dependent LUs the values indicate the following:\n  inactive (1) - LU didn't receive ACTLU, or\n        it received DACTLU, or received ACTLU and sent\n        negative response.\n  active (2) - LU received ACTLU and acknowledged\n        positively.\n\nFor independent LUs the values indicate the following:\n  active (2) - the LU is defined and is able to send\n        and receive BIND.\n  inactive (1) - the LU has a session count equal\n        to 0.")
snaLuOperSessnCount = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 2, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuOperSessnCount.setDescription("The number of currently active LU-LU sessions of\nthis LU.\nFor the independent LU, if this object has value 0,\nit indicates that LU is inactive.")
snaLuSessnTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 2, 3))
if mibBuilder.loadTexts: snaLuSessnTable.setDescription("This is a table containing objects which describe the\noperational state of LU sessions.  Only objects which\nare common to all types of LU sessions are included\nin this table.\n\nWhen a session's snaLuSessnOperState value changes to\n'pendingBind (2)', then the corresponding entry\nin the session table is created by the Agent.\n\nWhen the session's snaLuSessnOperState value changes to\n 'unbound (1)',  then the session will be removed from\nthe session table by the Agent.")
snaLuSessnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1)).setIndexNames((0, "SNA-NAU-MIB", "snaNodeAdminIndex"), (0, "SNA-NAU-MIB", "snaLuAdminLuIndex"), (0, "SNA-NAU-MIB", "snaLuSessnRluIndex"), (0, "SNA-NAU-MIB", "snaLuSessnIndex"))
if mibBuilder.loadTexts: snaLuSessnEntry.setDescription("An entry contains dynamic parameters for an LU-LU\nsession.\nThe indices identify the Node, local LU, and remote LU\nfor this session.")
snaLuSessnRluIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnRluIndex.setDescription("This value may be used to identify information about\nthe session partner LU in a table of information about\nremote LUs.  Such a table is not defined in this\ndocument.  If a table of remote LU information is not\nimplemented, or if the table is implemented but it does\nnot contain information about the partner LU for a\nparticular session (as for dependent LU-LU sessions)\nthen this object will have a value of zero.")
snaLuSessnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnIndex.setDescription("This value identifies the unique index of the session.\nIt is recommended that an Agent should not reuse the\nindex of a deactivated session for a significant\nperiod of time (e.g., one week).")
snaLuSessnLocalApplName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 48))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnLocalApplName.setDescription("The name of the local application using this LU.\nIf the local application is unknown, then this object\ncontains a zero length string.")
snaLuSessnRemoteLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 17))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnRemoteLuName.setDescription("For dependent LUs which are indicated by the\nsnaLuOperDepType object containing the value\n'dependent (1)', this object contains the Primary\nLU (PLU) name.  For independent LUs,\nthis object contains the fully-qualified remote LU\nname of this 6.2 session.\nA fully qualified name is an SNA NAU entity name\npreceded by the NetId and a period as the delimiter.")
snaLuSessnMaxSndRuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 8192))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnMaxSndRuSize.setDescription("The maximum RU size used on this session for sending\nRUs.")
snaLuSessnMaxRcvRuSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 8192))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnMaxRcvRuSize.setDescription("The maximum RU size used on this session for\nreceiving RUs.")
snaLuSessnSndPacingSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnSndPacingSize.setDescription("The size of the send pacing window on this session.")
snaLuSessnRcvPacingSize = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnRcvPacingSize.setDescription("The size of the receive pacing window on this\nsession.")
snaLuSessnActiveTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnActiveTime.setDescription("The timestamp (e.g., the Agent's sysUpTime value)\nwhen this session becomes active.")
snaLuSessnAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,)).subtype(namedValues=namedval.NamedValues(("unbound", 1), ("bound", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snaLuSessnAdminState.setDescription("The value indicates the desired operational state of\nthe session. This object is used to\nchange the operational state of the session.\nA Management Station can only change the operational\nstate of the session to 'unbound (1)'.\n\nSession deactivation:\n  If a session is in the operational state\n  'bound (3)' then setting the value of this\n  object to 'unbound (1)' will initiate the\n  session shutdown.\n\n  If a session is in the operational state\n  'pendingBind (2)' then setting the value of this\n  object to 'unbound (1)' will initiate the session\n  shutdown.\n  If a session is in the operational state\n  'pendingUnbind (4)' for an abnormally long period\n  of time (e.g., three minutes) then setting the value\n  of this object to 'unbound (1)' will change the\n  session operational state to 'unbound (1)'.\n\nNote: for dependent LUs, deactivating the session is\nthe same as deactivating the LU.")
snaLuSessnOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,2,1,3,)).subtype(namedValues=namedval.NamedValues(("unbound", 1), ("pendingBind", 2), ("bound", 3), ("pendingUnbind", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnOperState.setDescription("The value indicates the current operational state of\nthe session.\n\n  'unbound (1)' - session has been  unbound;\n        in this state it will be removed from the\n        session table by the Agent.\n\n  'pendingBind (2)' - this state has different\n        meanings for dependent and independent LUs;\n        for dependent LU - waiting for BIND from\n        the host, for independent LU - waiting for\n        BIND response.  When a session enters this\n        state, the corresponding entry in the\n        session table is created by the Agent.\n\n  'bound (3)' - session has been successfully bound.\n\n  'pendingUnbind (4)' - session enters this state\n        when an UNBIND is sent and before the\n        rsp(UNBIND) is received.")
snaLuSessnSenseData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 12), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnSenseData.setDescription("The value identifies the sense code when there is\na BIND failure. It is taken from the negative BIND\nresponse or UNBIND request.\nThis is displayed as 8 hexadecimal digits.")
snaLuSessnTerminationRu = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("bindFailure", 2), ("unbind", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnTerminationRu.setDescription("The value identifies the SNA RU that terminated the\nsession.\nIf the session is not in the unbound state, this object\nhas a value of  'other (1)'.")
snaLuSessnUnbindType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 14), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnUnbindType.setDescription("If the session is in the unbound state, and it was\nterminated by an UNBIND, then this object contains\nthe UNBIND type value (byte 1 of the UNBIND RU);\notherwise the string is null.")
snaLuSessnLinkIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 3, 1, 15), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnLinkIndex.setDescription("This value identifies the link over which the session\npasses.  It is an index into snaNodeLinkAdminTable.\nIf the index value is not known, the value of this\nobject shall be zero.")
snaLuSessnStatsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 2, 4))
if mibBuilder.loadTexts: snaLuSessnStatsTable.setDescription("This table contains dynamic statistics information\nrelating to LU sessions.\nThe entries in this table augment the entries in\nthe snaLuSessnTable and cannot be created by\na Management Station.")
snaLuSessnStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1))
if mibBuilder.loadTexts: snaLuSessnStatsEntry.setDescription("Contains statistics information for an LU session.\nEach entry is created by the Agent.\nObjects in this table have read-only access.\nEach session from snaLuSessnTable\nhas one entry in this table.")
snaLuSessnStatsSentBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnStatsSentBytes.setDescription("The number of bytes sent by the local LU.")
snaLuSessnStatsReceivedBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnStatsReceivedBytes.setDescription("The number of bytes received by the local LU.")
snaLuSessnStatsSentRus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnStatsSentRus.setDescription("The number of RUs sent by the local LU.")
snaLuSessnStatsReceivedRus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnStatsReceivedRus.setDescription("The number of RUs received by the local LU.")
snaLuSessnStatsSentNegativeResps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnStatsSentNegativeResps.setDescription("The number of negative responses sent by the\nlocal LU.")
snaLuSessnStatsReceivedNegativeResps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuSessnStatsReceivedNegativeResps.setDescription("The number of negative responses received by the\nlocal LU.")
snaLuTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 1, 2, 5))
snaMgtTools = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 1, 3))
snaLuRtmTable = MibTable((1, 3, 6, 1, 2, 1, 34, 1, 3, 1))
if mibBuilder.loadTexts: snaLuRtmTable.setDescription("This table contains Response Time Monitoring (RTM)\ninformation relating to an LU (Type 2). Each entry\ncorresponds to an LU 2 entry in\nsnaLuAdminTable.")
snaLuRtmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1)).setIndexNames((0, "SNA-NAU-MIB", "snaLuRtmPuIndex"), (0, "SNA-NAU-MIB", "snaLuRtmLuIndex"))
if mibBuilder.loadTexts: snaLuRtmEntry.setDescription("Contains RTM information for an LU (Type 2).\nEach entry is created by the Agent.")
snaLuRtmPuIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: snaLuRtmPuIndex.setDescription("The value identifies the PU 2.0 with which this LU is\nassociated.")
snaLuRtmLuIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 2), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: snaLuRtmLuIndex.setDescription("The value uniquely identifies an LU in a PU 2.0.")
snaLuRtmState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("off", 1), ("on", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmState.setDescription("The value indicates the current RTM state of an LU.")
snaLuRtmStateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmStateTime.setDescription("The timestamp (e.g., the Agent's sysUpTime value)\nwhen this session's RTM state (e.g., snaLuRtmState)\nchanges value.")
snaLuRtmDef = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("firstChar", 1), ("kb", 2), ("cdeb", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmDef.setDescription("The value indicates the mode of measurement for this\nRTM request.  The values have following meaning:\n  firstChar(1) - time to first character on screen\n  kb(2) - time to keyboard usable by operator\n  cdeb(3) - time to Change Direction/End Bracket.")
snaLuRtmBoundary1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmBoundary1.setDescription("This object contains the value of the first boundary\nin units of 1/10th of a second.")
snaLuRtmBoundary2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmBoundary2.setDescription("This object contains the value of the second boundary\nin units of 1/10th of a second.")
snaLuRtmBoundary3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmBoundary3.setDescription("This object contains the value of the third boundary\nin units of 1/10th of a second.")
snaLuRtmBoundary4 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmBoundary4.setDescription("This object contains the value of the fourth boundary\nin units of 1/10th of a second.")
snaLuRtmCounter1 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmCounter1.setDescription("This value indicates the number of transactions which\nfall in the range specified by the first boundary.")
snaLuRtmCounter2 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmCounter2.setDescription("This value indicates the number of transactions which\nfall in the range specified by the second boundary.")
snaLuRtmCounter3 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmCounter3.setDescription("This value indicates the number of transactions which\nfall in the range specified by the third boundary.")
snaLuRtmCounter4 = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmCounter4.setDescription("This value indicates the number of transactions which\nfall in the range specified by the fourth boundary.")
snaLuRtmOverFlows = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmOverFlows.setDescription("This value indicates the number of transactions which\nexceed the highest range specified by the\nboundaries.")
snaLuRtmObjPercent = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 15), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmObjPercent.setDescription("This value indicates the desired percentage of\ntransactions which should be under a designated\nboundary range indicated by snaLuRtmObjRange.")
snaLuRtmObjRange = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,2,1,6,5,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("range1", 2), ("range2", 3), ("range3", 4), ("range4", 5), ("range5", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmObjRange.setDescription("This value indicates the designated boundary range to\nwhich the snaLuRtmObject refers.\nThe values have the following meanings:\n  other(1)   - not specified\n  range1(2)  - less than boundary 1\n  range2(3)  - between boundary 1 and 2\n  range3(4)  - between boundary 2 and 3\n  range4(5)  - between boundary 3 and 4\n  range5(6)  - greater than boundary 4.")
snaLuRtmNumTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 17), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmNumTrans.setDescription("This value indicates the total number of transactions\nexecuted since the RTM monitoring began (i.e.,\nsnaLuRtmState changed to 'on(2)') for this LU.")
snaLuRtmLastRspTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 18), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmLastRspTime.setDescription("This value indicates the response time for the last\ntransaction in units of 1/10th of a second.")
snaLuRtmAvgRspTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 1, 3, 1, 1, 19), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snaLuRtmAvgRspTime.setDescription("This value indicates the average response time for all\ntransactions in units of 1/10th of a second.")
snanauConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 2))
snanauCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 2, 1))
snanauGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 2, 2))

# Augmentions
snaLuSessnEntry.registerAugmentions(("SNA-NAU-MIB", "snaLuSessnStatsEntry"))
apply(snaLuSessnStatsEntry.setIndexNames, snaLuSessnEntry.getIndexNames())
snaNodeLinkAdminEntry.registerAugmentions(("SNA-NAU-MIB", "snaNodeLinkOperEntry"))
apply(snaNodeLinkOperEntry.setIndexNames, snaNodeLinkAdminEntry.getIndexNames())
snaLuAdminEntry.registerAugmentions(("SNA-NAU-MIB", "snaLuOperEntry"))
apply(snaLuOperEntry.setIndexNames, snaLuAdminEntry.getIndexNames())
snaNodeAdminEntry.registerAugmentions(("SNA-NAU-MIB", "snaNodeOperEntry"))
apply(snaNodeOperEntry.setIndexNames, snaNodeAdminEntry.getIndexNames())

# Notifications

snaNodeStateChangeTrap = NotificationType((1, 3, 6, 1, 2, 1, 34, 1, 1, 10, 1)).setObjects(("SNA-NAU-MIB", "snaNodeOperName"), ("SNA-NAU-MIB", "snaNodeOperState"), )
snaLuSessnBindFailTrap = NotificationType((1, 3, 6, 1, 2, 1, 34, 1, 2, 5, 2)).setObjects(("SNA-NAU-MIB", "snaLuSessnSenseData"), ("SNA-NAU-MIB", "snaLuSessnOperState"), ("SNA-NAU-MIB", "snaLuSessnLocalApplName"), ("SNA-NAU-MIB", "snaLuSessnRemoteLuName"), )
snaNodeActFailTrap = NotificationType((1, 3, 6, 1, 2, 1, 34, 1, 1, 10, 2)).setObjects(("SNA-NAU-MIB", "snaNodeOperActFailureReason"), ("SNA-NAU-MIB", "snaNodeOperName"), ("SNA-NAU-MIB", "snaNodeOperState"), )
snaLuStateChangeTrap = NotificationType((1, 3, 6, 1, 2, 1, 34, 1, 2, 5, 1)).setObjects(("SNA-NAU-MIB", "snaLuOperName"), ("SNA-NAU-MIB", "snaLuOperSnaName"), ("SNA-NAU-MIB", "snaLuOperState"), )

# Groups

snaLuGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 2, 2, 2)).setObjects(("SNA-NAU-MIB", "snaLuOperName"), ("SNA-NAU-MIB", "snaLuOperSnaName"), ("SNA-NAU-MIB", "snaLuAdminType"), ("SNA-NAU-MIB", "snaLuOperState"), ("SNA-NAU-MIB", "snaLuAdminRowStatus"), ("SNA-NAU-MIB", "snaLuAdminDepType"), ("SNA-NAU-MIB", "snaLuAdminTerm"), ("SNA-NAU-MIB", "snaLuOperSessnCount"), ("SNA-NAU-MIB", "snaLuOperTerm"), ("SNA-NAU-MIB", "snaLuOperType"), ("SNA-NAU-MIB", "snaLuOperLocalAddress"), ("SNA-NAU-MIB", "snaLuAdminName"), ("SNA-NAU-MIB", "snaLuAdminDisplayModel"), ("SNA-NAU-MIB", "snaLuAdminLocalAddress"), ("SNA-NAU-MIB", "snaLuOperDepType"), ("SNA-NAU-MIB", "snaLuOperDisplayModel"), ("SNA-NAU-MIB", "snaLuAdminSnaName"), )
snaMgtToolsRtmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 2, 2, 5)).setObjects(("SNA-NAU-MIB", "snaLuRtmBoundary3"), ("SNA-NAU-MIB", "snaLuRtmBoundary2"), ("SNA-NAU-MIB", "snaLuRtmBoundary1"), ("SNA-NAU-MIB", "snaLuRtmCounter3"), ("SNA-NAU-MIB", "snaLuRtmCounter4"), ("SNA-NAU-MIB", "snaLuRtmCounter1"), ("SNA-NAU-MIB", "snaLuRtmBoundary4"), ("SNA-NAU-MIB", "snaLuRtmAvgRspTime"), ("SNA-NAU-MIB", "snaLuRtmStateTime"), ("SNA-NAU-MIB", "snaLuRtmDef"), ("SNA-NAU-MIB", "snaLuRtmLastRspTime"), ("SNA-NAU-MIB", "snaLuRtmCounter2"), ("SNA-NAU-MIB", "snaLuRtmObjPercent"), ("SNA-NAU-MIB", "snaLuRtmState"), ("SNA-NAU-MIB", "snaLuRtmOverFlows"), ("SNA-NAU-MIB", "snaLuRtmObjRange"), ("SNA-NAU-MIB", "snaLuRtmNumTrans"), )
snaPu20Group = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 2, 2, 4)).setObjects(("SNA-NAU-MIB", "snaPu20StatsReceivedBytes"), ("SNA-NAU-MIB", "snaPu20StatsBindLus"), ("SNA-NAU-MIB", "snaPu20StatsSentBytes"), ("SNA-NAU-MIB", "snaPu20StatsReceivedNegativeResps"), ("SNA-NAU-MIB", "snaPu20StatsReceivedPius"), ("SNA-NAU-MIB", "snaPu20StatsActLus"), ("SNA-NAU-MIB", "snaPu20StatsSentNegativeResps"), ("SNA-NAU-MIB", "snaPu20StatsSentPius"), ("SNA-NAU-MIB", "snaPu20StatsInActLus"), )
snaNodeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 2, 2, 1)).setObjects(("SNA-NAU-MIB", "snaNodeOperXidFormat"), ("SNA-NAU-MIB", "snaNodeAdminRowStatus"), ("SNA-NAU-MIB", "snaNodeOperType"), ("SNA-NAU-MIB", "snaNodeLinkOperMaxPiu"), ("SNA-NAU-MIB", "snaNodeAdminLuTermDefault"), ("SNA-NAU-MIB", "snaNodeOperLastStateChange"), ("SNA-NAU-MIB", "snaNodeLinkAdminRowStatus"), ("SNA-NAU-MIB", "snaNodeOperStartTime"), ("SNA-NAU-MIB", "snaNodeLinkAdminTableLastChange"), ("SNA-NAU-MIB", "snaNodeLinkOperSpecific"), ("SNA-NAU-MIB", "snaNodeOperEnablingMethod"), ("SNA-NAU-MIB", "snaNodeOperLuTermDefault"), ("SNA-NAU-MIB", "snaNodeLinkOperTableLastChange"), ("SNA-NAU-MIB", "snaNodeAdminIdNum"), ("SNA-NAU-MIB", "snaNodeOperState"), ("SNA-NAU-MIB", "snaNodeAdminHostDescription"), ("SNA-NAU-MIB", "snaNodeLinkAdminMaxPiu"), ("SNA-NAU-MIB", "snaNodeLinkAdminSpecific"), ("SNA-NAU-MIB", "snaNodeOperName"), ("SNA-NAU-MIB", "snaNodeAdminEnablingMethod"), ("SNA-NAU-MIB", "snaNodeAdminXidFormat"), ("SNA-NAU-MIB", "snaNodeAdminState"), ("SNA-NAU-MIB", "snaNodeOperStopMethod"), ("SNA-NAU-MIB", "snaNodeAdminTableLastChange"), ("SNA-NAU-MIB", "snaNodeOperActFailures"), ("SNA-NAU-MIB", "snaNodeOperBlockNum"), ("SNA-NAU-MIB", "snaNodeOperTableLastChange"), ("SNA-NAU-MIB", "snaNodeOperActFailureReason"), ("SNA-NAU-MIB", "snaNodeOperHostSscpId"), ("SNA-NAU-MIB", "snaNodeAdminMaxLu"), ("SNA-NAU-MIB", "snaNodeAdminStopMethod"), ("SNA-NAU-MIB", "snaNodeAdminType"), ("SNA-NAU-MIB", "snaNodeOperMaxLu"), ("SNA-NAU-MIB", "snaNodeOperHostDescription"), ("SNA-NAU-MIB", "snaNodeAdminBlockNum"), ("SNA-NAU-MIB", "snaNodeAdminName"), ("SNA-NAU-MIB", "snaNodeOperIdNum"), )
snaSessionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 2, 2, 3)).setObjects(("SNA-NAU-MIB", "snaLuSessnStatsReceivedBytes"), ("SNA-NAU-MIB", "snaLuSessnTerminationRu"), ("SNA-NAU-MIB", "snaLuSessnSndPacingSize"), ("SNA-NAU-MIB", "snaLuSessnStatsReceivedNegativeResps"), ("SNA-NAU-MIB", "snaLuSessnIndex"), ("SNA-NAU-MIB", "snaLuSessnAdminState"), ("SNA-NAU-MIB", "snaLuSessnStatsSentNegativeResps"), ("SNA-NAU-MIB", "snaLuSessnOperState"), ("SNA-NAU-MIB", "snaLuSessnStatsSentRus"), ("SNA-NAU-MIB", "snaLuSessnLocalApplName"), ("SNA-NAU-MIB", "snaLuSessnUnbindType"), ("SNA-NAU-MIB", "snaLuSessnSenseData"), ("SNA-NAU-MIB", "snaLuSessnRcvPacingSize"), ("SNA-NAU-MIB", "snaLuSessnStatsSentBytes"), ("SNA-NAU-MIB", "snaLuSessnActiveTime"), ("SNA-NAU-MIB", "snaLuSessnLinkIndex"), ("SNA-NAU-MIB", "snaLuSessnRluIndex"), ("SNA-NAU-MIB", "snaLuSessnMaxSndRuSize"), ("SNA-NAU-MIB", "snaLuSessnStatsReceivedRus"), ("SNA-NAU-MIB", "snaLuSessnMaxRcvRuSize"), ("SNA-NAU-MIB", "snaLuSessnRemoteLuName"), )

# Exports

# Module identity
mibBuilder.exportSymbols("SNA-NAU-MIB", PYSNMP_MODULE_ID=snanauMIB)

# Objects
mibBuilder.exportSymbols("SNA-NAU-MIB", snanauMIB=snanauMIB, snanauObjects=snanauObjects, snaNode=snaNode, snaNodeAdminTable=snaNodeAdminTable, snaNodeAdminEntry=snaNodeAdminEntry, snaNodeAdminIndex=snaNodeAdminIndex, snaNodeAdminName=snaNodeAdminName, snaNodeAdminType=snaNodeAdminType, snaNodeAdminXidFormat=snaNodeAdminXidFormat, snaNodeAdminBlockNum=snaNodeAdminBlockNum, snaNodeAdminIdNum=snaNodeAdminIdNum, snaNodeAdminEnablingMethod=snaNodeAdminEnablingMethod, snaNodeAdminLuTermDefault=snaNodeAdminLuTermDefault, snaNodeAdminMaxLu=snaNodeAdminMaxLu, snaNodeAdminHostDescription=snaNodeAdminHostDescription, snaNodeAdminStopMethod=snaNodeAdminStopMethod, snaNodeAdminState=snaNodeAdminState, snaNodeAdminRowStatus=snaNodeAdminRowStatus, snaNodeAdminTableLastChange=snaNodeAdminTableLastChange, snaNodeOperTable=snaNodeOperTable, snaNodeOperEntry=snaNodeOperEntry, snaNodeOperName=snaNodeOperName, snaNodeOperType=snaNodeOperType, snaNodeOperXidFormat=snaNodeOperXidFormat, snaNodeOperBlockNum=snaNodeOperBlockNum, snaNodeOperIdNum=snaNodeOperIdNum, snaNodeOperEnablingMethod=snaNodeOperEnablingMethod, snaNodeOperLuTermDefault=snaNodeOperLuTermDefault, snaNodeOperMaxLu=snaNodeOperMaxLu, snaNodeOperHostDescription=snaNodeOperHostDescription, snaNodeOperStopMethod=snaNodeOperStopMethod, snaNodeOperState=snaNodeOperState, snaNodeOperHostSscpId=snaNodeOperHostSscpId, snaNodeOperStartTime=snaNodeOperStartTime, snaNodeOperLastStateChange=snaNodeOperLastStateChange, snaNodeOperActFailures=snaNodeOperActFailures, snaNodeOperActFailureReason=snaNodeOperActFailureReason, snaNodeOperTableLastChange=snaNodeOperTableLastChange, snaPu20StatsTable=snaPu20StatsTable, snaPu20StatsEntry=snaPu20StatsEntry, snaPu20StatsSentBytes=snaPu20StatsSentBytes, snaPu20StatsReceivedBytes=snaPu20StatsReceivedBytes, snaPu20StatsSentPius=snaPu20StatsSentPius, snaPu20StatsReceivedPius=snaPu20StatsReceivedPius, snaPu20StatsSentNegativeResps=snaPu20StatsSentNegativeResps, snaPu20StatsReceivedNegativeResps=snaPu20StatsReceivedNegativeResps, snaPu20StatsActLus=snaPu20StatsActLus, snaPu20StatsInActLus=snaPu20StatsInActLus, snaPu20StatsBindLus=snaPu20StatsBindLus, snaNodeLinkAdminTable=snaNodeLinkAdminTable, snaNodeLinkAdminEntry=snaNodeLinkAdminEntry, snaNodeLinkAdminIndex=snaNodeLinkAdminIndex, snaNodeLinkAdminSpecific=snaNodeLinkAdminSpecific, snaNodeLinkAdminMaxPiu=snaNodeLinkAdminMaxPiu, snaNodeLinkAdminRowStatus=snaNodeLinkAdminRowStatus, snaNodeLinkAdminTableLastChange=snaNodeLinkAdminTableLastChange, snaNodeLinkOperTable=snaNodeLinkOperTable, snaNodeLinkOperEntry=snaNodeLinkOperEntry, snaNodeLinkOperSpecific=snaNodeLinkOperSpecific, snaNodeLinkOperMaxPiu=snaNodeLinkOperMaxPiu, snaNodeLinkOperTableLastChange=snaNodeLinkOperTableLastChange, snaNodeTraps=snaNodeTraps, snaLu=snaLu, snaLuAdminTable=snaLuAdminTable, snaLuAdminEntry=snaLuAdminEntry, snaLuAdminLuIndex=snaLuAdminLuIndex, snaLuAdminName=snaLuAdminName, snaLuAdminSnaName=snaLuAdminSnaName, snaLuAdminType=snaLuAdminType, snaLuAdminDepType=snaLuAdminDepType, snaLuAdminLocalAddress=snaLuAdminLocalAddress, snaLuAdminDisplayModel=snaLuAdminDisplayModel, snaLuAdminTerm=snaLuAdminTerm, snaLuAdminRowStatus=snaLuAdminRowStatus, snaLuOperTable=snaLuOperTable, snaLuOperEntry=snaLuOperEntry, snaLuOperName=snaLuOperName, snaLuOperSnaName=snaLuOperSnaName, snaLuOperType=snaLuOperType, snaLuOperDepType=snaLuOperDepType, snaLuOperLocalAddress=snaLuOperLocalAddress, snaLuOperDisplayModel=snaLuOperDisplayModel, snaLuOperTerm=snaLuOperTerm, snaLuOperState=snaLuOperState, snaLuOperSessnCount=snaLuOperSessnCount, snaLuSessnTable=snaLuSessnTable, snaLuSessnEntry=snaLuSessnEntry, snaLuSessnRluIndex=snaLuSessnRluIndex, snaLuSessnIndex=snaLuSessnIndex, snaLuSessnLocalApplName=snaLuSessnLocalApplName, snaLuSessnRemoteLuName=snaLuSessnRemoteLuName, snaLuSessnMaxSndRuSize=snaLuSessnMaxSndRuSize, snaLuSessnMaxRcvRuSize=snaLuSessnMaxRcvRuSize, snaLuSessnSndPacingSize=snaLuSessnSndPacingSize, snaLuSessnRcvPacingSize=snaLuSessnRcvPacingSize, snaLuSessnActiveTime=snaLuSessnActiveTime, snaLuSessnAdminState=snaLuSessnAdminState, snaLuSessnOperState=snaLuSessnOperState, snaLuSessnSenseData=snaLuSessnSenseData, snaLuSessnTerminationRu=snaLuSessnTerminationRu, snaLuSessnUnbindType=snaLuSessnUnbindType, snaLuSessnLinkIndex=snaLuSessnLinkIndex, snaLuSessnStatsTable=snaLuSessnStatsTable, snaLuSessnStatsEntry=snaLuSessnStatsEntry, snaLuSessnStatsSentBytes=snaLuSessnStatsSentBytes, snaLuSessnStatsReceivedBytes=snaLuSessnStatsReceivedBytes, snaLuSessnStatsSentRus=snaLuSessnStatsSentRus, snaLuSessnStatsReceivedRus=snaLuSessnStatsReceivedRus, snaLuSessnStatsSentNegativeResps=snaLuSessnStatsSentNegativeResps, snaLuSessnStatsReceivedNegativeResps=snaLuSessnStatsReceivedNegativeResps, snaLuTraps=snaLuTraps, snaMgtTools=snaMgtTools, snaLuRtmTable=snaLuRtmTable, snaLuRtmEntry=snaLuRtmEntry, snaLuRtmPuIndex=snaLuRtmPuIndex, snaLuRtmLuIndex=snaLuRtmLuIndex, snaLuRtmState=snaLuRtmState, snaLuRtmStateTime=snaLuRtmStateTime, snaLuRtmDef=snaLuRtmDef, snaLuRtmBoundary1=snaLuRtmBoundary1, snaLuRtmBoundary2=snaLuRtmBoundary2, snaLuRtmBoundary3=snaLuRtmBoundary3, snaLuRtmBoundary4=snaLuRtmBoundary4, snaLuRtmCounter1=snaLuRtmCounter1, snaLuRtmCounter2=snaLuRtmCounter2, snaLuRtmCounter3=snaLuRtmCounter3)
mibBuilder.exportSymbols("SNA-NAU-MIB", snaLuRtmCounter4=snaLuRtmCounter4, snaLuRtmOverFlows=snaLuRtmOverFlows, snaLuRtmObjPercent=snaLuRtmObjPercent, snaLuRtmObjRange=snaLuRtmObjRange, snaLuRtmNumTrans=snaLuRtmNumTrans, snaLuRtmLastRspTime=snaLuRtmLastRspTime, snaLuRtmAvgRspTime=snaLuRtmAvgRspTime, snanauConformance=snanauConformance, snanauCompliances=snanauCompliances, snanauGroups=snanauGroups)

# Notifications
mibBuilder.exportSymbols("SNA-NAU-MIB", snaNodeStateChangeTrap=snaNodeStateChangeTrap, snaLuSessnBindFailTrap=snaLuSessnBindFailTrap, snaNodeActFailTrap=snaNodeActFailTrap, snaLuStateChangeTrap=snaLuStateChangeTrap)

# Groups
mibBuilder.exportSymbols("SNA-NAU-MIB", snaLuGroup=snaLuGroup, snaMgtToolsRtmGroup=snaMgtToolsRtmGroup, snaPu20Group=snaPu20Group, snaNodeGroup=snaNodeGroup, snaSessionGroup=snaSessionGroup)
