# PySNMP SMI module. Autogenerated from smidump -f python UPS-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:39 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( AutonomousType, DisplayString, TextualConvention, TestAndIncr, TimeInterval, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "DisplayString", "TextualConvention", "TestAndIncr", "TimeInterval", "TimeStamp")

# Types

class NonNegativeInteger(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647L)
    pass

class PositiveInteger(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,2147483647L)
    pass


# Objects

upsMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 33)).setRevisions(("1994-02-23 00:00",))
if mibBuilder.loadTexts: upsMIB.setOrganization("IETF UPS MIB Working Group")
if mibBuilder.loadTexts: upsMIB.setContactInfo("        Jeffrey D. Case\n\nPostal: SNMP Research, Incorporated\n        3001 Kimberlin Heights Road\n        Knoxville, TN  37920\n        US\n\n   Tel: +1 615 573 1434\n   Fax: +1 615 573 9197\n\nE-mail: case@snmp.com")
if mibBuilder.loadTexts: upsMIB.setDescription("The MIB module to describe Uninterruptible Power\nSupplies.")
upsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1))
upsIdent = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 1))
upsIdentManufacturer = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentManufacturer.setDescription("The name of the UPS manufacturer.")
upsIdentModel = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentModel.setDescription("The UPS Model designation.")
upsIdentUPSSoftwareVersion = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentUPSSoftwareVersion.setDescription("The UPS firmware/software version(s).  This variable\nmay or may not have the same value as\nupsIdentAgentSoftwareVersion in some implementations.")
upsIdentAgentSoftwareVersion = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsIdentAgentSoftwareVersion.setDescription("The UPS agent software version.  This variable may or\nmay not have the same value as\nupsIdentUPSSoftwareVersion in some implementations.")
upsIdentName = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 5), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsIdentName.setDescription("A string identifying the UPS.  This object should be\nset by the administrator.")
upsIdentAttachedDevices = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 1, 6), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsIdentAttachedDevices.setDescription("A string identifying the devices attached to the\noutput(s) of the UPS.  This object should be set by\nthe administrator.")
upsBattery = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 2))
upsBatteryStatus = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("batteryNormal", 2), ("batteryLow", 3), ("batteryDepleted", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBatteryStatus.setDescription("The indication of the capacity remaining in the UPS\nsystem's batteries.   A value of batteryNormal\nindicates that the remaining run-time is greater than\nupsConfigLowBattTime.  A value of batteryLow indicates\nthat the remaining battery run-time is less than or\nequal to upsConfigLowBattTime.  A value of\nbatteryDepleted indicates that the UPS will be unable\nto sustain the present load when and if the utility\npower is lost (including the possibility that the\nutility power is currently absent and the UPS is\nunable to sustain the output).")
upsSecondsOnBattery = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 2), NonNegativeInteger()).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: upsSecondsOnBattery.setDescription("If the unit is on battery power, the elapsed time\nsince the UPS last switched to battery power, or the\ntime since the network management subsystem was last\nrestarted, whichever is less.  Zero shall be returned\nif the unit is not on battery power.")
upsEstimatedMinutesRemaining = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 3), PositiveInteger()).setMaxAccess("readonly").setUnits("minutes")
if mibBuilder.loadTexts: upsEstimatedMinutesRemaining.setDescription("An estimate of the time to battery charge depletion\nunder the present load conditions if the utility power\nis off and remains off, or if it were to be lost and\nremain off.")
upsEstimatedChargeRemaining = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100))).setMaxAccess("readonly").setUnits("percent")
if mibBuilder.loadTexts: upsEstimatedChargeRemaining.setDescription("An estimate of the battery charge remaining expressed\nas a percent of full charge.")
upsBatteryVoltage = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 5), NonNegativeInteger()).setMaxAccess("readonly").setUnits("0.1 Volt DC")
if mibBuilder.loadTexts: upsBatteryVoltage.setDescription("The magnitude of the present battery voltage.")
upsBatteryCurrent = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 6), Integer32()).setMaxAccess("readonly").setUnits("0.1 Amp DC")
if mibBuilder.loadTexts: upsBatteryCurrent.setDescription("The present battery current.")
upsBatteryTemperature = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 2, 7), Integer32()).setMaxAccess("readonly").setUnits("degrees Centigrade")
if mibBuilder.loadTexts: upsBatteryTemperature.setDescription("The ambient temperature at or near the UPS Battery\ncasing.")
upsInput = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 3))
upsInputLineBads = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 3, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputLineBads.setDescription("A count of the number of times the input entered an\nout-of-tolerance condition as defined by the\nmanufacturer.  This count is incremented by one each\ntime the input transitions from zero out-of-tolerance\nlines to one or more input lines out-of-tolerance.")
upsInputNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 3, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputNumLines.setDescription("The number of input lines utilized in this device.\nThis variable indicates the number of rows in the\ninput table.")
upsInputTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 3, 3))
if mibBuilder.loadTexts: upsInputTable.setDescription("A list of input table entries.  The number of entries\nis given by the value of upsInputNumLines.")
upsInputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1)).setIndexNames((0, "UPS-MIB", "upsInputLineIndex"))
if mibBuilder.loadTexts: upsInputEntry.setDescription("An entry containing information applicable to a\nparticular input line.")
upsInputLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 1), PositiveInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: upsInputLineIndex.setDescription("The input line identifier.")
upsInputFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputFrequency.setDescription("The present input frequency.")
upsInputVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 3), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputVoltage.setDescription("The magnitude of the present input voltage.")
upsInputCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 4), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputCurrent.setDescription("The magnitude of the present input current.")
upsInputTruePower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 3, 3, 1, 5), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsInputTruePower.setDescription("The magnitude of the present input true power.")
upsOutput = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 4))
upsOutputSource = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 4, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,7,3,5,1,4,6,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("none", 2), ("normal", 3), ("bypass", 4), ("battery", 5), ("booster", 6), ("reducer", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputSource.setDescription("The present source of output power.  The enumeration\nnone(2) indicates that there is no source of output\npower (and therefore no output power), for example,\nthe system has opened the output breaker.")
upsOutputFrequency = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 4, 2), NonNegativeInteger()).setMaxAccess("readonly").setUnits("0.1 Hertz")
if mibBuilder.loadTexts: upsOutputFrequency.setDescription("The present output frequency.")
upsOutputNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 4, 3), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputNumLines.setDescription("The number of output lines utilized in this device.\nThis variable indicates the number of rows in the\noutput table.")
upsOutputTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 4, 4))
if mibBuilder.loadTexts: upsOutputTable.setDescription("A list of output table entries.  The number of\nentries is given by the value of upsOutputNumLines.")
upsOutputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1)).setIndexNames((0, "UPS-MIB", "upsOutputLineIndex"))
if mibBuilder.loadTexts: upsOutputEntry.setDescription("An entry containing information applicable to a\nparticular output line.")
upsOutputLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 1), PositiveInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: upsOutputLineIndex.setDescription("The output line identifier.")
upsOutputVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputVoltage.setDescription("The present output voltage.")
upsOutputCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 3), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputCurrent.setDescription("The present output current.")
upsOutputPower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 4), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputPower.setDescription("The present output true power.")
upsOutputPercentLoad = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 4, 4, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 200))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsOutputPercentLoad.setDescription("The percentage of the UPS power capacity presently\nbeing used on this output line, i.e., the greater of\nthe percent load of true power capacity and the\npercent load of VA.")
upsBypass = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 5))
upsBypassFrequency = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 5, 1), NonNegativeInteger()).setMaxAccess("readonly").setUnits("0.1 Hertz")
if mibBuilder.loadTexts: upsBypassFrequency.setDescription("The present bypass frequency.")
upsBypassNumLines = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 5, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassNumLines.setDescription("The number of bypass lines utilized in this device.\nThis entry indicates the number of rows in the bypass\ntable.")
upsBypassTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 5, 3))
if mibBuilder.loadTexts: upsBypassTable.setDescription("A list of bypass table entries.  The number of\nentries is given by the value of upsBypassNumLines.")
upsBypassEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1)).setIndexNames((0, "UPS-MIB", "upsBypassLineIndex"))
if mibBuilder.loadTexts: upsBypassEntry.setDescription("An entry containing information applicable to a\nparticular bypass input.")
upsBypassLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 1), PositiveInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: upsBypassLineIndex.setDescription("The bypass line identifier.")
upsBypassVoltage = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 2), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassVoltage.setDescription("The present bypass voltage.")
upsBypassCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 3), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassCurrent.setDescription("The present bypass current.")
upsBypassPower = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 5, 3, 1, 4), NonNegativeInteger()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsBypassPower.setDescription("The present true power conveyed by the bypass.")
upsAlarm = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 6))
upsAlarmsPresent = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 6, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsAlarmsPresent.setDescription("The present number of active alarm conditions.")
upsAlarmTable = MibTable((1, 3, 6, 1, 2, 1, 33, 1, 6, 2))
if mibBuilder.loadTexts: upsAlarmTable.setDescription("A list of alarm table entries.  The table contains\nzero, one, or many rows at any moment, depending upon\nthe number of alarm conditions in effect.  The table\nis initially empty at agent startup.  The agent\ncreates a row in the table each time a condition is\ndetected and deletes that row when that condition no\nlonger pertains.  The agent creates the first row with\nupsAlarmId equal to 1, and increments the value of\nupsAlarmId each time a new row is created, wrapping to\nthe first free value greater than or equal to 1 when\nthe maximum value of upsAlarmId would otherwise be\nexceeded.  Consequently, after multiple operations,\nthe table may become sparse, e.g., containing entries\nfor rows 95, 100, 101, and 203 and the entries should\nnot be assumed to be in chronological order because\nupsAlarmId might have wrapped.\n\nAlarms are named by an AutonomousType (OBJECT\nIDENTIFIER), upsAlarmDescr, to allow a single table to\nreflect well known alarms plus alarms defined by a\nparticular implementation, i.e., as documented in the\nprivate enterprise MIB definition for the device.  No\ntwo rows will have the same value of upsAlarmDescr,\nsince alarms define conditions.  In order to meet this\nrequirement, care should be taken in the definition of\nalarm conditions to insure that a system cannot enter\nthe same condition multiple times simultaneously.\n\nThe number of rows in the table at any given time is\nreflected by the value of upsAlarmsPresent.")
upsAlarmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1)).setIndexNames((0, "UPS-MIB", "upsAlarmId"))
if mibBuilder.loadTexts: upsAlarmEntry.setDescription("An entry containing information applicable to a\nparticular alarm.")
upsAlarmId = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1, 1), PositiveInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: upsAlarmId.setDescription("A unique identifier for an alarm condition.  This\nvalue must remain constant.")
upsAlarmDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsAlarmDescr.setDescription("A reference to an alarm description object.  The\nobject referenced should not be accessible, but rather\nbe used to provide a unique description of the alarm\ncondition.")
upsAlarmTime = MibTableColumn((1, 3, 6, 1, 2, 1, 33, 1, 6, 2, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsAlarmTime.setDescription("The value of sysUpTime when the alarm condition was\ndetected.  If the alarm condition was detected at the\ntime of agent startup and presumably existed before\nagent startup, the value of upsAlarmTime shall equal\n0.")
upsWellKnownAlarms = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 6, 3))
upsAlarmBatteryBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 1))
if mibBuilder.loadTexts: upsAlarmBatteryBad.setDescription("One or more batteries have been determined to require\nreplacement.")
upsAlarmOnBattery = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 2))
if mibBuilder.loadTexts: upsAlarmOnBattery.setDescription("The UPS is drawing power from the batteries.")
upsAlarmLowBattery = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 3))
if mibBuilder.loadTexts: upsAlarmLowBattery.setDescription("The remaining battery run-time is less than or equal\nto upsConfigLowBattTime.")
upsAlarmDepletedBattery = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 4))
if mibBuilder.loadTexts: upsAlarmDepletedBattery.setDescription("The UPS will be unable to sustain the present load\nwhen and if the utility power is lost.")
upsAlarmTempBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 5))
if mibBuilder.loadTexts: upsAlarmTempBad.setDescription("A temperature is out of tolerance.")
upsAlarmInputBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 6))
if mibBuilder.loadTexts: upsAlarmInputBad.setDescription("An input condition is out of tolerance.")
upsAlarmOutputBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 7))
if mibBuilder.loadTexts: upsAlarmOutputBad.setDescription("An output condition (other than OutputOverload) is\nout of tolerance.")
upsAlarmOutputOverload = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 8))
if mibBuilder.loadTexts: upsAlarmOutputOverload.setDescription("The output load exceeds the UPS output capacity.")
upsAlarmOnBypass = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 9))
if mibBuilder.loadTexts: upsAlarmOnBypass.setDescription("The Bypass is presently engaged on the UPS.")
upsAlarmBypassBad = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 10))
if mibBuilder.loadTexts: upsAlarmBypassBad.setDescription("The Bypass is out of tolerance.")
upsAlarmOutputOffAsRequested = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 11))
if mibBuilder.loadTexts: upsAlarmOutputOffAsRequested.setDescription("The UPS has shutdown as requested, i.e., the output\nis off.")
upsAlarmUpsOffAsRequested = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 12))
if mibBuilder.loadTexts: upsAlarmUpsOffAsRequested.setDescription("The entire UPS has shutdown as commanded.")
upsAlarmChargerFailed = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 13))
if mibBuilder.loadTexts: upsAlarmChargerFailed.setDescription("An uncorrected problem has been detected within the\nUPS charger subsystem.")
upsAlarmUpsOutputOff = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 14))
if mibBuilder.loadTexts: upsAlarmUpsOutputOff.setDescription("The output of the UPS is in the off state.")
upsAlarmUpsSystemOff = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 15))
if mibBuilder.loadTexts: upsAlarmUpsSystemOff.setDescription("The UPS system is in the off state.")
upsAlarmFanFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 16))
if mibBuilder.loadTexts: upsAlarmFanFailure.setDescription("The failure of one or more fans in the UPS has been\ndetected.")
upsAlarmFuseFailure = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 17))
if mibBuilder.loadTexts: upsAlarmFuseFailure.setDescription("The failure of one or more fuses has been detected.")
upsAlarmGeneralFault = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 18))
if mibBuilder.loadTexts: upsAlarmGeneralFault.setDescription("A general fault in the UPS has been detected.")
upsAlarmDiagnosticTestFailed = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 19))
if mibBuilder.loadTexts: upsAlarmDiagnosticTestFailed.setDescription("The result of the last diagnostic test indicates a\nfailure.")
upsAlarmCommunicationsLost = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 20))
if mibBuilder.loadTexts: upsAlarmCommunicationsLost.setDescription("A problem has been encountered in the communications\nbetween the agent and the UPS.")
upsAlarmAwaitingPower = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 21))
if mibBuilder.loadTexts: upsAlarmAwaitingPower.setDescription("The UPS output is off and the UPS is awaiting the\nreturn of input power.")
upsAlarmShutdownPending = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 22))
if mibBuilder.loadTexts: upsAlarmShutdownPending.setDescription("A upsShutdownAfterDelay countdown is underway.")
upsAlarmShutdownImminent = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 23))
if mibBuilder.loadTexts: upsAlarmShutdownImminent.setDescription("The UPS will turn off power to the load in less than\n5 seconds; this may be either a timed shutdown or a\nlow battery shutdown.")
upsAlarmTestInProgress = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 6, 3, 24))
if mibBuilder.loadTexts: upsAlarmTestInProgress.setDescription("A test is in progress, as initiated and indicated by\nthe Test Group.  Tests initiated via other\nimplementation-specific mechanisms can indicate the\npresence of the testing in the alarm table, if\ndesired, via a OBJECT-IDENTITY macro in the MIB\ndocument specific to that implementation and are\noutside the scope of this OBJECT-IDENTITY.")
upsTest = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 7))
upsTestId = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 1), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsTestId.setDescription("The test is named by an OBJECT IDENTIFIER which\nallows a standard mechanism for the initiation of\ntests, including the well known tests identified in\nthis document as well as those introduced by a\nparticular implementation, i.e., as documented in the\nprivate enterprise MIB definition for the device.\n\nSetting this variable initiates the named test. Sets\nto this variable require the presence of\nupsTestSpinLock in the same SNMP message.\n\nThe set request will be rejected with an appropriate\nerror message if the requested test cannot be\nperformed, including attempts to start a test when\nanother test is already in progress.  The status of\nthe current or last test is maintained in\nupsTestResultsSummary. Tests in progress may be\naborted by setting the upsTestId variable to\nupsTestAbortTestInProgress.\n\nRead operations return the value of the name of the\ntest in progress if a test is in progress or the name\nof the last test performed if no test is in progress,\nunless no test has been run, in which case the well\nknown value upsTestNoTestsInitiated is returned.")
upsTestSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsTestSpinLock.setDescription("A spin lock on the test subsystem.  The spinlock is\nused as follows.\n\nBefore starting a test, a manager-station should make\nsure that a test is not in progress as follows:\n\n    try_again:\n      get (upsTestSpinLock)\n      while (upsTestResultsSummary == inProgress) {\n        /* loop while a test is running for another\nmanager */\n        short delay\n        get (upsTestSpinLock)\n      }\n      lock_value = upsTestSpinLock\n      /* no test in progress, start the test */\n      set (upsTestSpinLock = lock_value, upsTestId =\nrequested_test)\n      if (error_index == 1) { /* (upsTestSpinLock\nfailed) */\n        /* if problem is not access control, then\n            some other manager slipped in ahead of us\n*/\n        goto try_again\n      }\n      if (error_index == 2) { /* (upsTestId) */\n        /* cannot perform the test */\n        give up\n      }\n      /* test started ok */\n      /* wait for test completion by polling\nupsTestResultsSummary */\n      get (upsTestSpinLock, upsTestResultsSummary,\nupsTestResultsDetail)\n      while (upsTestResultsSummary == inProgress) {\n        short delay\n        get (upsTestSpinLock, upsTestResultsSummary,\nupsTestResultsDetail)\n      }\n      /* when test completes, retrieve any additional\ntest results */\n      /* if upsTestSpinLock == lock_value + 1, then\nthese are our test */\n      /* results (as opposed to another manager's */\n      The initial value of upsTestSpinLock at agent\ninitialization shall\n      be 1.")
upsTestResultsSummary = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,5,6,)).subtype(namedValues=namedval.NamedValues(("donePass", 1), ("doneWarning", 2), ("doneError", 3), ("aborted", 4), ("inProgress", 5), ("noTestsInitiated", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestResultsSummary.setDescription("The results of the current or last UPS diagnostics\ntest performed.  The values for donePass(1),\ndoneWarning(2), and doneError(3) indicate that the\ntest completed either successfully, with a warning, or\nwith an error, respectively.  The value aborted(4) is\nreturned for tests which are aborted by setting the\nvalue of upsTestId to upsTestAbortTestInProgress.\nTests which have not yet concluded are indicated by\ninProgress(5).  The value noTestsInitiated(6)\nindicates that no previous test results are available,\nsuch as is the case when no tests have been run since\nthe last reinitialization of the network management\nsubsystem and the system has no provision for non-\nvolatile storage of test results.")
upsTestResultsDetail = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestResultsDetail.setDescription("Additional information about upsTestResultsSummary.\nIf no additional information available, a zero length\nstring is returned.")
upsTestStartTime = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestStartTime.setDescription("The value of sysUpTime at the time the test in\nprogress was initiated, or, if no test is in progress,\nthe time the previous test was initiated.  If the\nvalue of upsTestResultsSummary is noTestsInitiated(6),\nupsTestStartTime has the value 0.")
upsTestElapsedTime = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 7, 6), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: upsTestElapsedTime.setDescription("The amount of time, in TimeTicks, since the test in\nprogress was initiated, or, if no test is in progress,\nthe previous test took to complete.  If the value of\nupsTestResultsSummary is noTestsInitiated(6),\nupsTestElapsedTime has the value 0.")
upsWellKnownTests = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 7, 7))
upsTestNoTestsInitiated = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 1))
if mibBuilder.loadTexts: upsTestNoTestsInitiated.setDescription("No tests have been initiated and no test is in\nprogress.")
upsTestAbortTestInProgress = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 2))
if mibBuilder.loadTexts: upsTestAbortTestInProgress.setDescription("The test in progress is to be aborted / the test in\nprogress was aborted.")
upsTestGeneralSystemsTest = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 3))
if mibBuilder.loadTexts: upsTestGeneralSystemsTest.setDescription("The manufacturer's standard test of UPS device\nsystems.")
upsTestQuickBatteryTest = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 4))
if mibBuilder.loadTexts: upsTestQuickBatteryTest.setDescription("A test that is sufficient to determine if the battery\nneeds replacement.")
upsTestDeepBatteryCalibration = ObjectIdentity((1, 3, 6, 1, 2, 1, 33, 1, 7, 7, 5))
if mibBuilder.loadTexts: upsTestDeepBatteryCalibration.setDescription("The system is placed on battery to a discharge level,\nset by the manufacturer, sufficient to determine\nbattery replacement and battery run-time with a high\ndegree of confidence.  WARNING:  this test will leave\nthe battery in a low charge state and will require\ntime for recharging to a level sufficient to provide\nnormal battery duration for the protected load.")
upsControl = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 8))
upsShutdownType = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("output", 1), ("system", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsShutdownType.setDescription("This object determines the nature of the action to be\ntaken at the time when the countdown of the\nupsShutdownAfterDelay and upsRebootWithDuration\nobjects reaches zero.\n\nSetting this object to output(1) indicates that\nshutdown requests should cause only the output of the\nUPS to turn off.  Setting this object to system(2)\nindicates that shutdown requests will cause the entire\nUPS system to turn off.")
upsShutdownAfterDelay = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 2147483647L))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: upsShutdownAfterDelay.setDescription("Setting this object will shutdown (i.e., turn off)\neither the UPS output or the UPS system (as determined\nby the value of upsShutdownType at the time of\nshutdown) after the indicated number of seconds, or\nless if the UPS batteries become depleted. Setting\nthis object to 0 will cause the shutdown to occur\nimmediately.  Setting this object to -1 will abort the\ncountdown.  If the system is already in the desired\nstate at the time the countdown reaches 0, then\nnothing will happen.  That is, there is no additional\naction at that time if upsShutdownType = system and\nthe system is already off.  Similarly, there is no\nadditional action at that time if upsShutdownType =\noutput and the output is already off.  When read,\nupsShutdownAfterDelay will return the number of\nseconds remaining until shutdown, or -1 if no shutdown\ncountdown is in effect.  On some systems, if the agent\nis restarted while a shutdown countdown is in effect,\nthe countdown may be aborted.  Sets to this object\noverride any upsShutdownAfterDelay already in effect.")
upsStartupAfterDelay = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 2147483647L))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: upsStartupAfterDelay.setDescription("Setting this object will start the output after the\nindicated number of seconds, including starting the\nUPS, if necessary.  Setting this object to 0 will\ncause the startup to occur immediately.  Setting this\nobject to -1 will abort the countdown.  If the output\nis already on at the time the countdown reaches 0,\nthen nothing will happen.  Sets to this object\noverride the effect of any upsStartupAfterDelay\ncountdown or upsRebootWithDuration countdown in\nprogress.  When read, upsStartupAfterDelay will return\nthe number of seconds until startup, or -1 if no\nstartup countdown is in effect.  If the countdown\nexpires during a utility failure, the startup shall\nnot occur until the utility power is restored.  On\nsome systems, if the agent is restarted while a\nstartup countdown is in effect, the countdown is\naborted.")
upsRebootWithDuration = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 300))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: upsRebootWithDuration.setDescription("Setting this object will immediately shutdown (i.e.,\nturn off) either the UPS output or the UPS system (as\ndetermined by the value of upsShutdownType at the time\nof shutdown) for a period equal to the indicated\nnumber of seconds, after which time the output will be\nstarted, including starting the UPS, if necessary.  If\nthe number of seconds required to perform the request\nis greater than the requested duration, then the\nrequested shutdown and startup cycle shall be\nperformed in the minimum time possible, but in no case\nshall this require more than the requested duration\nplus 60 seconds.  When read, upsRebootWithDuration\nshall return the number of seconds remaining in the\ncountdown, or -1 if no countdown is in progress.  If\nthe startup should occur during a utility failure, the\nstartup shall not occur until the utility power is\nrestored.")
upsAutoRestart = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 8, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("on", 1), ("off", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsAutoRestart.setDescription("Setting this object to 'on' will cause the UPS system\nto restart after a shutdown if the shutdown occurred\nduring a power loss as a result of either a\nupsShutdownAfterDelay or an internal battery depleted\ncondition.  Setting this object to 'off' will prevent\nthe UPS system from restarting after a shutdown until\nan operator manually or remotely explicitly restarts\nit.  If the UPS is in a startup or reboot countdown,\nthen the UPS will not restart until that delay has\nbeen satisfied.")
upsConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 1, 9))
upsConfigInputVoltage = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 1), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("RMS Volts")
if mibBuilder.loadTexts: upsConfigInputVoltage.setDescription("The magnitude of the nominal input voltage.  On those\nsystems which support read-write access to this\nobject, if there is an attempt to set this variable to\na value that is not supported, the request must be\nrejected and the agent shall respond with an\nappropriate error message, i.e., badValue for SNMPv1,\nor inconsistentValue for SNMPv2.")
upsConfigInputFreq = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 2), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("0.1 Hertz")
if mibBuilder.loadTexts: upsConfigInputFreq.setDescription("The nominal input frequency.  On those systems which\nsupport read-write access to this object, if there is\nan attempt to set this variable to a value that is not\nsupported, the request must be rejected and the agent\nshall respond with an appropriate error message, i.e.,\nbadValue for SNMPv1, or inconsistentValue for SNMPv2.")
upsConfigOutputVoltage = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 3), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("RMS Volts")
if mibBuilder.loadTexts: upsConfigOutputVoltage.setDescription("The magnitude of the nominal output voltage.  On\nthose systems which support read-write access to this\nobject, if there is an attempt to set this variable to\na value that is not supported, the request must be\nrejected and the agent shall respond with an\nappropriate error message, i.e., badValue for SNMPv1,\nor inconsistentValue for SNMPv2.")
upsConfigOutputFreq = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 4), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("0.1 Hertz")
if mibBuilder.loadTexts: upsConfigOutputFreq.setDescription("The nominal output frequency.  On those systems which\nsupport read-write access to this object, if there is\nan attempt to set this variable to a value that is not\nsupported, the request must be rejected and the agent\nshall respond with an appropriate error message, i.e.,\nbadValue for SNMPv1, or inconsistentValue for SNMPv2.")
upsConfigOutputVA = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 5), NonNegativeInteger()).setMaxAccess("readonly").setUnits("Volt-Amps")
if mibBuilder.loadTexts: upsConfigOutputVA.setDescription("The magnitude of the nominal Volt-Amp rating.")
upsConfigOutputPower = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 6), NonNegativeInteger()).setMaxAccess("readonly").setUnits("Watts")
if mibBuilder.loadTexts: upsConfigOutputPower.setDescription("The magnitude of the nominal true power rating.")
upsConfigLowBattTime = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 7), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("minutes")
if mibBuilder.loadTexts: upsConfigLowBattTime.setDescription("The value of upsEstimatedMinutesRemaining at which a\nlowBattery condition is declared.  For agents which\nsupport only discrete (discontinuous) values, then the\nagent shall round up to the next supported value.  If\nthe requested value is larger than the largest\nsupported value, then the largest supported value\nshall be selected.")
upsConfigAudibleStatus = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("enabled", 2), ("muted", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: upsConfigAudibleStatus.setDescription("The requested state of the audible alarm.  When in\nthe disabled state, the audible alarm should never\nsound.  The enabled state is self-describing.  Setting\nthis object to muted(3) when the audible alarm is\nsounding shall temporarily silence the alarm.  It will\nremain muted until it would normally stop sounding and\nthe value returned for read operations during this\nperiod shall equal muted(3).  At the end of this\nperiod, the value shall revert to enabled(2).  Writes\nof the value muted(3) when the audible alarm is not\nsounding shall be accepted but otherwise shall have no\neffect.")
upsConfigLowVoltageTransferPoint = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 9), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("RMS Volts")
if mibBuilder.loadTexts: upsConfigLowVoltageTransferPoint.setDescription("The minimum input line voltage allowed before the UPS\nsystem transfers to battery backup.")
upsConfigHighVoltageTransferPoint = MibScalar((1, 3, 6, 1, 2, 1, 33, 1, 9, 10), NonNegativeInteger()).setMaxAccess("readwrite").setUnits("RMS Volts")
if mibBuilder.loadTexts: upsConfigHighVoltageTransferPoint.setDescription("The maximum line voltage allowed before the UPS\nsystem transfers to battery backup.")
upsTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 2))
upsConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3))
upsCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 1))
upsGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2))
upsSubsetGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2, 1))
upsBasicGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2, 2))
upsFullGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 33, 3, 2, 3))

# Augmentions

# Notifications

upsTrapAlarmEntryAdded = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 3)).setObjects(("UPS-MIB", "upsAlarmId"), ("UPS-MIB", "upsAlarmDescr"), )
upsTrapOnBattery = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 1)).setObjects(("UPS-MIB", "upsEstimatedMinutesRemaining"), ("UPS-MIB", "upsSecondsOnBattery"), ("UPS-MIB", "upsConfigLowBattTime"), )
upsTrapAlarmEntryRemoved = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 4)).setObjects(("UPS-MIB", "upsAlarmId"), ("UPS-MIB", "upsAlarmDescr"), )
upsTrapTestCompleted = NotificationType((1, 3, 6, 1, 2, 1, 33, 2, 2)).setObjects(("UPS-MIB", "upsTestStartTime"), ("UPS-MIB", "upsTestElapsedTime"), ("UPS-MIB", "upsTestId"), ("UPS-MIB", "upsTestSpinLock"), ("UPS-MIB", "upsTestResultsSummary"), ("UPS-MIB", "upsTestResultsDetail"), )

# Groups

upsSubsetConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 9)).setObjects(("UPS-MIB", "upsConfigInputFreq"), ("UPS-MIB", "upsConfigOutputFreq"), ("UPS-MIB", "upsConfigOutputVA"), ("UPS-MIB", "upsConfigOutputVoltage"), ("UPS-MIB", "upsConfigOutputPower"), ("UPS-MIB", "upsConfigInputVoltage"), )
upsFullConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 9)).setObjects(("UPS-MIB", "upsConfigInputFreq"), ("UPS-MIB", "upsConfigLowBattTime"), ("UPS-MIB", "upsConfigOutputFreq"), ("UPS-MIB", "upsConfigOutputVA"), ("UPS-MIB", "upsConfigOutputVoltage"), ("UPS-MIB", "upsConfigOutputPower"), ("UPS-MIB", "upsConfigInputVoltage"), ("UPS-MIB", "upsConfigAudibleStatus"), )
upsBasicTestGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 7)).setObjects(("UPS-MIB", "upsTestStartTime"), ("UPS-MIB", "upsTestElapsedTime"), ("UPS-MIB", "upsTestId"), ("UPS-MIB", "upsTestSpinLock"), ("UPS-MIB", "upsTestResultsSummary"), ("UPS-MIB", "upsTestResultsDetail"), )
upsFullControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 8)).setObjects(("UPS-MIB", "upsRebootWithDuration"), ("UPS-MIB", "upsAutoRestart"), ("UPS-MIB", "upsShutdownType"), ("UPS-MIB", "upsStartupAfterDelay"), ("UPS-MIB", "upsShutdownAfterDelay"), )
upsSubsetBatteryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 2)).setObjects(("UPS-MIB", "upsSecondsOnBattery"), ("UPS-MIB", "upsBatteryStatus"), )
upsBasicIdentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 1)).setObjects(("UPS-MIB", "upsIdentAgentSoftwareVersion"), ("UPS-MIB", "upsIdentUPSSoftwareVersion"), ("UPS-MIB", "upsIdentManufacturer"), ("UPS-MIB", "upsIdentModel"), ("UPS-MIB", "upsIdentName"), )
upsBasicOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 4)).setObjects(("UPS-MIB", "upsOutputNumLines"), ("UPS-MIB", "upsOutputFrequency"), ("UPS-MIB", "upsOutputSource"), ("UPS-MIB", "upsOutputVoltage"), )
upsBasicInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 3)).setObjects(("UPS-MIB", "upsInputFrequency"), ("UPS-MIB", "upsInputVoltage"), ("UPS-MIB", "upsInputLineBads"), ("UPS-MIB", "upsInputNumLines"), )
upsSubsetOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 4)).setObjects(("UPS-MIB", "upsOutputSource"), )
upsBasicBypassGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 5)).setObjects(("UPS-MIB", "upsBypassFrequency"), ("UPS-MIB", "upsBypassVoltage"), ("UPS-MIB", "upsBypassNumLines"), )
upsFullBypassGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 5)).setObjects(("UPS-MIB", "upsBypassFrequency"), ("UPS-MIB", "upsBypassVoltage"), ("UPS-MIB", "upsBypassNumLines"), )
upsSubsetInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 3)).setObjects(("UPS-MIB", "upsInputLineBads"), )
upsBasicBatteryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 2)).setObjects(("UPS-MIB", "upsSecondsOnBattery"), ("UPS-MIB", "upsBatteryStatus"), )
upsBasicAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 6)).setObjects(("UPS-MIB", "upsAlarmsPresent"), ("UPS-MIB", "upsAlarmTime"), ("UPS-MIB", "upsAlarmDescr"), )
upsFullAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 6)).setObjects(("UPS-MIB", "upsAlarmsPresent"), ("UPS-MIB", "upsAlarmTime"), ("UPS-MIB", "upsAlarmDescr"), )
upsFullIdentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 1)).setObjects(("UPS-MIB", "upsIdentAgentSoftwareVersion"), ("UPS-MIB", "upsIdentName"), ("UPS-MIB", "upsIdentUPSSoftwareVersion"), ("UPS-MIB", "upsIdentManufacturer"), ("UPS-MIB", "upsIdentModel"), ("UPS-MIB", "upsIdentAttachedDevices"), )
upsSubsetControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 8)).setObjects(("UPS-MIB", "upsAutoRestart"), ("UPS-MIB", "upsShutdownType"), ("UPS-MIB", "upsShutdownAfterDelay"), )
upsFullBatteryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 2)).setObjects(("UPS-MIB", "upsEstimatedMinutesRemaining"), ("UPS-MIB", "upsSecondsOnBattery"), ("UPS-MIB", "upsEstimatedChargeRemaining"), ("UPS-MIB", "upsBatteryStatus"), )
upsBasicControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 8)).setObjects(("UPS-MIB", "upsRebootWithDuration"), ("UPS-MIB", "upsAutoRestart"), ("UPS-MIB", "upsShutdownType"), ("UPS-MIB", "upsStartupAfterDelay"), ("UPS-MIB", "upsShutdownAfterDelay"), )
upsSubsetAlarmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 6)).setObjects(("UPS-MIB", "upsAlarmsPresent"), ("UPS-MIB", "upsAlarmTime"), ("UPS-MIB", "upsAlarmDescr"), )
upsBasicConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 2, 9)).setObjects(("UPS-MIB", "upsConfigInputFreq"), ("UPS-MIB", "upsConfigLowBattTime"), ("UPS-MIB", "upsConfigOutputFreq"), ("UPS-MIB", "upsConfigOutputVA"), ("UPS-MIB", "upsConfigOutputVoltage"), ("UPS-MIB", "upsConfigOutputPower"), ("UPS-MIB", "upsConfigInputVoltage"), ("UPS-MIB", "upsConfigAudibleStatus"), )
upsFullInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 3)).setObjects(("UPS-MIB", "upsInputFrequency"), ("UPS-MIB", "upsInputVoltage"), ("UPS-MIB", "upsInputLineBads"), ("UPS-MIB", "upsInputNumLines"), )
upsSubsetIdentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 1, 1)).setObjects(("UPS-MIB", "upsIdentAgentSoftwareVersion"), ("UPS-MIB", "upsIdentName"), ("UPS-MIB", "upsIdentManufacturer"), ("UPS-MIB", "upsIdentAttachedDevices"), ("UPS-MIB", "upsIdentModel"), )
upsFullOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 4)).setObjects(("UPS-MIB", "upsOutputNumLines"), ("UPS-MIB", "upsOutputFrequency"), ("UPS-MIB", "upsOutputSource"), ("UPS-MIB", "upsOutputPercentLoad"), ("UPS-MIB", "upsOutputPower"), ("UPS-MIB", "upsOutputCurrent"), ("UPS-MIB", "upsOutputVoltage"), )
upsFullTestGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 33, 3, 2, 3, 7)).setObjects(("UPS-MIB", "upsTestStartTime"), ("UPS-MIB", "upsTestElapsedTime"), ("UPS-MIB", "upsTestId"), ("UPS-MIB", "upsTestSpinLock"), ("UPS-MIB", "upsTestResultsSummary"), ("UPS-MIB", "upsTestResultsDetail"), )

# Exports

# Module identity
mibBuilder.exportSymbols("UPS-MIB", PYSNMP_MODULE_ID=upsMIB)

# Types
mibBuilder.exportSymbols("UPS-MIB", NonNegativeInteger=NonNegativeInteger, PositiveInteger=PositiveInteger)

# Objects
mibBuilder.exportSymbols("UPS-MIB", upsMIB=upsMIB, upsObjects=upsObjects, upsIdent=upsIdent, upsIdentManufacturer=upsIdentManufacturer, upsIdentModel=upsIdentModel, upsIdentUPSSoftwareVersion=upsIdentUPSSoftwareVersion, upsIdentAgentSoftwareVersion=upsIdentAgentSoftwareVersion, upsIdentName=upsIdentName, upsIdentAttachedDevices=upsIdentAttachedDevices, upsBattery=upsBattery, upsBatteryStatus=upsBatteryStatus, upsSecondsOnBattery=upsSecondsOnBattery, upsEstimatedMinutesRemaining=upsEstimatedMinutesRemaining, upsEstimatedChargeRemaining=upsEstimatedChargeRemaining, upsBatteryVoltage=upsBatteryVoltage, upsBatteryCurrent=upsBatteryCurrent, upsBatteryTemperature=upsBatteryTemperature, upsInput=upsInput, upsInputLineBads=upsInputLineBads, upsInputNumLines=upsInputNumLines, upsInputTable=upsInputTable, upsInputEntry=upsInputEntry, upsInputLineIndex=upsInputLineIndex, upsInputFrequency=upsInputFrequency, upsInputVoltage=upsInputVoltage, upsInputCurrent=upsInputCurrent, upsInputTruePower=upsInputTruePower, upsOutput=upsOutput, upsOutputSource=upsOutputSource, upsOutputFrequency=upsOutputFrequency, upsOutputNumLines=upsOutputNumLines, upsOutputTable=upsOutputTable, upsOutputEntry=upsOutputEntry, upsOutputLineIndex=upsOutputLineIndex, upsOutputVoltage=upsOutputVoltage, upsOutputCurrent=upsOutputCurrent, upsOutputPower=upsOutputPower, upsOutputPercentLoad=upsOutputPercentLoad, upsBypass=upsBypass, upsBypassFrequency=upsBypassFrequency, upsBypassNumLines=upsBypassNumLines, upsBypassTable=upsBypassTable, upsBypassEntry=upsBypassEntry, upsBypassLineIndex=upsBypassLineIndex, upsBypassVoltage=upsBypassVoltage, upsBypassCurrent=upsBypassCurrent, upsBypassPower=upsBypassPower, upsAlarm=upsAlarm, upsAlarmsPresent=upsAlarmsPresent, upsAlarmTable=upsAlarmTable, upsAlarmEntry=upsAlarmEntry, upsAlarmId=upsAlarmId, upsAlarmDescr=upsAlarmDescr, upsAlarmTime=upsAlarmTime, upsWellKnownAlarms=upsWellKnownAlarms, upsAlarmBatteryBad=upsAlarmBatteryBad, upsAlarmOnBattery=upsAlarmOnBattery, upsAlarmLowBattery=upsAlarmLowBattery, upsAlarmDepletedBattery=upsAlarmDepletedBattery, upsAlarmTempBad=upsAlarmTempBad, upsAlarmInputBad=upsAlarmInputBad, upsAlarmOutputBad=upsAlarmOutputBad, upsAlarmOutputOverload=upsAlarmOutputOverload, upsAlarmOnBypass=upsAlarmOnBypass, upsAlarmBypassBad=upsAlarmBypassBad, upsAlarmOutputOffAsRequested=upsAlarmOutputOffAsRequested, upsAlarmUpsOffAsRequested=upsAlarmUpsOffAsRequested, upsAlarmChargerFailed=upsAlarmChargerFailed, upsAlarmUpsOutputOff=upsAlarmUpsOutputOff, upsAlarmUpsSystemOff=upsAlarmUpsSystemOff, upsAlarmFanFailure=upsAlarmFanFailure, upsAlarmFuseFailure=upsAlarmFuseFailure, upsAlarmGeneralFault=upsAlarmGeneralFault, upsAlarmDiagnosticTestFailed=upsAlarmDiagnosticTestFailed, upsAlarmCommunicationsLost=upsAlarmCommunicationsLost, upsAlarmAwaitingPower=upsAlarmAwaitingPower, upsAlarmShutdownPending=upsAlarmShutdownPending, upsAlarmShutdownImminent=upsAlarmShutdownImminent, upsAlarmTestInProgress=upsAlarmTestInProgress, upsTest=upsTest, upsTestId=upsTestId, upsTestSpinLock=upsTestSpinLock, upsTestResultsSummary=upsTestResultsSummary, upsTestResultsDetail=upsTestResultsDetail, upsTestStartTime=upsTestStartTime, upsTestElapsedTime=upsTestElapsedTime, upsWellKnownTests=upsWellKnownTests, upsTestNoTestsInitiated=upsTestNoTestsInitiated, upsTestAbortTestInProgress=upsTestAbortTestInProgress, upsTestGeneralSystemsTest=upsTestGeneralSystemsTest, upsTestQuickBatteryTest=upsTestQuickBatteryTest, upsTestDeepBatteryCalibration=upsTestDeepBatteryCalibration, upsControl=upsControl, upsShutdownType=upsShutdownType, upsShutdownAfterDelay=upsShutdownAfterDelay, upsStartupAfterDelay=upsStartupAfterDelay, upsRebootWithDuration=upsRebootWithDuration, upsAutoRestart=upsAutoRestart, upsConfig=upsConfig, upsConfigInputVoltage=upsConfigInputVoltage, upsConfigInputFreq=upsConfigInputFreq, upsConfigOutputVoltage=upsConfigOutputVoltage, upsConfigOutputFreq=upsConfigOutputFreq, upsConfigOutputVA=upsConfigOutputVA, upsConfigOutputPower=upsConfigOutputPower, upsConfigLowBattTime=upsConfigLowBattTime, upsConfigAudibleStatus=upsConfigAudibleStatus, upsConfigLowVoltageTransferPoint=upsConfigLowVoltageTransferPoint, upsConfigHighVoltageTransferPoint=upsConfigHighVoltageTransferPoint, upsTraps=upsTraps, upsConformance=upsConformance, upsCompliances=upsCompliances, upsGroups=upsGroups, upsSubsetGroups=upsSubsetGroups, upsBasicGroups=upsBasicGroups, upsFullGroups=upsFullGroups)

# Notifications
mibBuilder.exportSymbols("UPS-MIB", upsTrapAlarmEntryAdded=upsTrapAlarmEntryAdded, upsTrapOnBattery=upsTrapOnBattery, upsTrapAlarmEntryRemoved=upsTrapAlarmEntryRemoved, upsTrapTestCompleted=upsTrapTestCompleted)

# Groups
mibBuilder.exportSymbols("UPS-MIB", upsSubsetConfigGroup=upsSubsetConfigGroup, upsFullConfigGroup=upsFullConfigGroup, upsBasicTestGroup=upsBasicTestGroup, upsFullControlGroup=upsFullControlGroup, upsSubsetBatteryGroup=upsSubsetBatteryGroup, upsBasicIdentGroup=upsBasicIdentGroup, upsBasicOutputGroup=upsBasicOutputGroup, upsBasicInputGroup=upsBasicInputGroup, upsSubsetOutputGroup=upsSubsetOutputGroup, upsBasicBypassGroup=upsBasicBypassGroup, upsFullBypassGroup=upsFullBypassGroup, upsSubsetInputGroup=upsSubsetInputGroup, upsBasicBatteryGroup=upsBasicBatteryGroup, upsBasicAlarmGroup=upsBasicAlarmGroup, upsFullAlarmGroup=upsFullAlarmGroup, upsFullIdentGroup=upsFullIdentGroup, upsSubsetControlGroup=upsSubsetControlGroup, upsFullBatteryGroup=upsFullBatteryGroup, upsBasicControlGroup=upsBasicControlGroup, upsSubsetAlarmGroup=upsSubsetAlarmGroup, upsBasicConfigGroup=upsBasicConfigGroup, upsFullInputGroup=upsFullInputGroup, upsSubsetIdentGroup=upsSubsetIdentGroup, upsFullOutputGroup=upsFullOutputGroup, upsFullTestGroup=upsFullTestGroup)
