# PySNMP SMI module. Autogenerated from smidump -f python VDSL-LINE-MIB
# by libsmi2pysnmp-0.0.9-alpha at Thu Mar 26 19:36:39 2009,
# Python version (2, 4, 4, 'final', 0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( HCPerfCurrentCount, HCPerfIntervalCount, HCPerfIntervalThreshold, HCPerfInvalidIntervals, HCPerfTimeElapsed, HCPerfValidIntervals, ) = mibBuilder.importSymbols("HC-PerfHist-TC-MIB", "HCPerfCurrentCount", "HCPerfIntervalCount", "HCPerfIntervalThreshold", "HCPerfInvalidIntervals", "HCPerfTimeElapsed", "HCPerfValidIntervals")
( ZeroBasedCounter64, ) = mibBuilder.importSymbols("HCNUM-TC", "ZeroBasedCounter64")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "transmission")
( RowStatus, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TruthValue")

# Types

class VdslLineCodingType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,1,)
    namedValues = namedval.NamedValues(("other", 1), ("mcm", 2), ("scm", 3), )
    pass

class VdslLineEntity(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,)
    namedValues = namedval.NamedValues(("vtuc", 1), ("vtur", 2), )
    pass


# Objects

vdslMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 97)).setRevisions(("2004-02-19 00:00",))
if mibBuilder.loadTexts: vdslMIB.setOrganization("ADSLMIB Working Group")
if mibBuilder.loadTexts: vdslMIB.setContactInfo("WG-email:  adslmib@ietf.org\nInfo:      https://www1.ietf.org/mailman/listinfo/adslmib\n\nChair:     Mike Sneed\n           Sand Channel Systems\nPostal:    P.O.  Box 37324\n           Raleigh, NC 27627-7324\n           USA\nEmail:     sneedmike@hotmail.com\nPhone:     +1 206 600 7022\n\nCo-editor: Bob Ray\n           PESA Switching Systems, Inc.\nPostal:    330-A Wynn Drive\n           Huntsville, AL 35805\n           USA\nEmail:     rray@pesa.com\nPhone:     +1 256 726 9200 ext.  142\n\nCo-editor: Rajesh Abbi\n           Alcatel USA\nPostal:    2301 Sugar Bush Road\n           Raleigh, NC 27612-3339\n           USA\nEmail:     Rajesh.Abbi@alcatel.com\nPhone:     +1 919 850 6194")
if mibBuilder.loadTexts: vdslMIB.setDescription("The MIB module defining objects for the management of a pair\nof VDSL transceivers at each end of the VDSL line.  Each such\nline has an entry in an ifTable which may include multiple\ntransceiver lines.  An agent may reside at either end of the\nVDSL line.  However, the MIB is designed to require no\nmanagement communication between them beyond that inherent in\nthe low-level VDSL line protocol.  The agent may monitor and\ncontrol this protocol for its needs.\n\n\n\nVDSL lines may support optional Fast or Interleaved channels.\nIf these are supported, additional entries corresponding to the\nsupported channels must be created in the ifTable.  Thus a VDSL\nline that supports both channels will have three entries in the\nifTable, one for each physical, fast, and interleaved, whose\nifType values are equal to vdsl(97), fast(125), and\ninterleaved(124), respectively.  The ifStackTable is used to\nrepresent the relationship between the entries.\n\nNaming Conventions:\n    Vtuc -- (VTUC) transceiver at near (Central) end of line\n    Vtur -- (VTUR) transceiver at Remote end of line\n    Vtu  -- One of either Vtuc or Vtur\n    Curr -- Current\n    Prev -- Previous\n    Atn  -- Attenuation\n    ES   -- Errored Second.\n    SES  -- Severely Errored Second\n    UAS  -- Unavailable Second\n    LCS  -- Line Code Specific\n    Lof  -- Loss of Frame\n    Lol  -- Loss of Link\n    Los  -- Loss of Signal\n    Lpr  -- Loss of Power\n    xxxs -- Sum of Seconds in which xxx has occured\n            (e.g., xxx = Lof, Los, Lpr, Lol)\n    Max  -- Maximum\n    Mgn  -- Margin\n    Min  -- Minimum\n    Psd  -- Power Spectral Density\n    Snr  -- Signal to Noise Ratio\n    Tx   -- Transmit\n    Blks -- Blocks\n\nCopyright (C) The Internet Society (2004).  This version\nof this MIB module is part of RFC 3728: see the RFC\nitself for full legal notices.")
vdslLineMib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1))
vdslNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 0))
vdslMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 1))
vdslLineTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1))
if mibBuilder.loadTexts: vdslLineTable.setDescription("This table includes common attributes describing\nboth ends of the line.  It is required for all VDSL\nphysical interfaces.  VDSL physical interfaces are\nthose ifEntries where ifType is equal to vdsl(97).")
vdslLineEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: vdslLineEntry.setDescription("An entry in the vdslLineTable.")
vdslLineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 1), VdslLineCodingType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslLineCoding.setDescription("Specifies the VDSL coding type used on this line.")
vdslLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,5,)).subtype(namedValues=namedval.NamedValues(("noChannel", 1), ("fastOnly", 2), ("interleavedOnly", 3), ("fastOrInterleaved", 4), ("fastAndInterleaved", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslLineType.setDescription("Defines the type of VDSL physical line entity that exists,\nby defining whether and how the line is channelized.  If\n\n\n\n\n\n\n\n\n\nthe line is channelized,  the value will be other than\nnoChannel(1).  This object defines which channel type(s)\nare supported.  Defined values are:\n\nnoChannel(1)          -- no channels exist\nfastOnly(2)           -- only fast channel exists\ninterleavedOnly(3)    -- only interleaved channel exists\nfastOrInterleaved(4)  -- either fast or interleaved channel\n                      -- exist, but only one at a time\nfastAndInterleaved(5) -- both fast and interleaved channels\n                      -- exist\n\nNote that 'slow' and 'interleaved' refer to the same\nchannel.  In the case that the line is channelized, the\nmanager can use the ifStackTable to determine the ifIndex\nfor the associated channel(s).")
vdslLineConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 3), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32)).clone('DEFVAL')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vdslLineConfProfile.setDescription("The value of this object identifies the row in the VDSL\nLine Configuration Profile Table, vdslLineConfProfileTable,\nwhich applies for this VDSL line, and channels if\napplicable.\n\nThis object MUST be maintained in a persistent manner.")
vdslLineAlarmConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 1, 1, 4), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32)).clone('DEFVAL')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: vdslLineAlarmConfProfile.setDescription("The value of this object identifies the row in the VDSL\nLine Alarm Configuration Profile Table,\nvdslLineAlarmConfProfileTable, which applies to this\nVDSL line, and channels if applicable.\n\nThis object MUST be maintained in a persistent manner.")
vdslPhysTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2))
if mibBuilder.loadTexts: vdslPhysTable.setDescription("This table provides one row for each Vtu.  Each row\ncontains the Physical Layer Parameters table for that\nVtu.  VDSL physical interfaces are those ifEntries where\nifType is equal to vdsl(97).")
vdslPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslPhysEntry.setDescription("An entry in the vdslPhysTable.")
vdslPhysSide = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 1), VdslLineEntity()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslPhysSide.setDescription("Identifies whether the transceiver is the Vtuc or Vtur.")
vdslPhysInvSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysInvSerialNumber.setDescription("The vendor specific string that identifies the\n\n\n\nvendor equipment.")
vdslPhysInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 3), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysInvVendorID.setDescription("The vendor ID code is a copy of the binary vendor\nidentification field expressed as readable characters\nin hexadecimal notation.")
vdslPhysInvVersionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 4), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysInvVersionNumber.setDescription("The vendor specific version number sent by this Vtu\nas part of the initialization messages.  It is a copy\nof the binary version number field expressed as\nreadable characters in hexadecimal notation.")
vdslPhysCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrSnrMgn.setDescription("Noise Margin as seen by this Vtu with respect to its\nreceived signal in 0.25dB.  The effective range is\n-31.75 to +31.75 dB.")
vdslPhysCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 6), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrAtn.setDescription("Measured difference in the total power transmitted by\nthe peer Vtu and the total power received by this Vtu.\nThe effective range is 0 to +63.75 dB.")
vdslPhysCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 7), Bits().subtype(namedValues=namedval.NamedValues(("noDefect", 0), ("lossOfFraming", 1), ("lossOfSignal", 2), ("lossOfPower", 3), ("lossOfSignalQuality", 4), ("lossOfLink", 5), ("dataInitFailure", 6), ("configInitFailure", 7), ("protocolInitFailure", 8), ("noPeerVtuPresent", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrStatus.setDescription("Indicates current state of the Vtu line.  This is a\nbit-map of possible conditions.  The various bit\npositions are:\n\n0   noDefect             There are no defects on the line.\n\n1   lossOfFraming        Vtu failure due to not receiving\n                         a valid frame.\n\n2   lossOfSignal         Vtu failure due to not receiving\n                         signal.\n\n3   lossOfPower          Vtu failure due to loss of power.\n\n4   lossOfSignalQuality  Loss of Signal Quality is declared\n                         when the Noise Margin falls below\n                         the Minimum Noise Margin, or the\n                         bit-error-rate exceeds 10^-7.\n\n5   lossOfLink           Vtu failure due to inability to\n                         link with peer Vtu.  Set whenever\n                         the transceiver is in the 'Warm\n                         Start' state.\n\n6   dataInitFailure      Vtu failure during initialization\n                         due to bit errors corrupting\n                         startup exchange data.\n\n\n\n\n7   configInitFailure    Vtu failure during initialization\n                         due to peer Vtu not able to\n                         support requested configuration.\n\n8   protocolInitFailure  Vtu failure during initialization\n                         due to incompatible protocol used\n                         by the peer Vtu.\n\n9   noPeerVtuPresent     Vtu failure during initialization\n                         due to no activation sequence\n                         detected from peer Vtu.\n\nThis is intended to supplement ifOperStatus.")
vdslPhysCurrOutputPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 160))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrOutputPwr.setDescription("Measured total output power transmitted by this VTU.\nThis is the measurement that was reported during\nthe last activation sequence.")
vdslPhysCurrAttainableRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrAttainableRate.setDescription("Indicates the maximum currently attainable data rate\nin steps of 1000 bits/second by the Vtu.  This value\nwill be equal to or greater than vdslPhysCurrLineRate.\nNote that for SCM, the minimum and maximum data rates\nare equal.  Note: 1 kbps = 1000 bps.")
vdslPhysCurrLineRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 2, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPhysCurrLineRate.setDescription("Indicates the current data rate in steps of 1000\nbits/second by the Vtu.  This value will be less than\nor equal to vdslPhysCurrAttainableRate.  Note: 1 kbps =\n1000 bps.")
vdslChanTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3))
if mibBuilder.loadTexts: vdslChanTable.setDescription("This table provides one row for each Vtu channel.\nVDSL channel interfaces are those ifEntries where\nifType is equal to interleave(124) or fast(125).")
vdslChanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslChanEntry.setDescription("An entry in the vdslChanTable.")
vdslChanInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanInterleaveDelay.setDescription("Interleave Delay for this channel.\n\nInterleave delay applies only to the interleave\n(slow) channel and defines the mapping (relative\nspacing) between subsequent input bytes at the\n\n\n\ninterleaver input and their placement in the bit\nstream at the interleaver output.  Larger numbers\nprovide greater separation between consecutive\ninput bytes in the output bit stream allowing for\nimproved impulse noise immunity at the expense of\npayload latency.\n\nIn the case where the ifType is fast(125), return\na value of zero.")
vdslChanCrcBlockLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCrcBlockLength.setDescription("Indicates the length of the channel data-block\non which the CRC operates.")
vdslChanCurrTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurrTxRate.setDescription("Actual transmit data rate on this channel.  Note: 1\nkbps = 1000 bps.")
vdslChanCurrTxSlowBurstProtect = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 4), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1275))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurrTxSlowBurstProtect.setDescription("Actual level of impulse noise (burst) protection\nfor an interleaved (slow) channel.  This parameter is\nnot applicable to fast channels.  For fast channels,\na value of zero shall be returned.")
vdslChanCurrTxFastFec = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 3, 1, 5), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 50))).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurrTxFastFec.setDescription("Actual Forward Error Correction (FEC) redundancy\nrelated overhead for a fast channel.  This parameter\nis not applicable to an interleaved (slow) channel.\nFor interleaved channels, a value of zero shall be\nreturned.")
vdslPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4))
if mibBuilder.loadTexts: vdslPerfDataTable.setDescription("This table provides one row for each VDSL physical\ninterface.  VDSL physical interfaces are those ifEntries\nwhere ifType is equal to vdsl(97).")
vdslPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslPerfDataEntry.setDescription("An entry in the vdslPerfDataTable.")
vdslPerfDataValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 1), HCPerfValidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataValidIntervals.setDescription("Valid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslPerfDataInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 2), HCPerfInvalidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataInvalidIntervals.setDescription("Invalid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslPerfDataLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLofs.setDescription("Count of seconds since the unit was last reset that there\nwas Loss of Framing.")
vdslPerfDataLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLoss.setDescription("Count of seconds since the unit was last reset that there\nwas Loss of Signal.")
vdslPerfDataLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLprs.setDescription("Count of seconds since the unit was last reset that there\nwas Loss of Power.")
vdslPerfDataLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataLols.setDescription("Count of seconds since the unit was last reset that there\nwas Loss of Link.")
vdslPerfDataESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataESs.setDescription("Count of Errored Seconds since the unit was last reset.\nAn Errored Second is a one-second interval containing one\nor more CRC anomalies, or one or more LOS or LOF defects.")
vdslPerfDataSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataSESs.setDescription("Count of Severely Errored Seconds since the unit was last\nreset.")
vdslPerfDataUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataUASs.setDescription("Count of Unavailable Seconds since the unit was last\nreset.")
vdslPerfDataInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataInits.setDescription("Count of the line initialization attempts since the unit\nwas last reset.  This count includes both successful and\nfailed attempts.")
vdslPerfDataCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 11), HCPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinTimeElapsed.setDescription("Total elapsed seconds in this interval.")
vdslPerfDataCurr15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 12), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLofs.setDescription("Count of seconds during this interval that there\nwas Loss of Framing.")
vdslPerfDataCurr15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 13), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLoss.setDescription("Count of seconds during this interval that there\nwas Loss of Signal.")
vdslPerfDataCurr15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 14), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLprs.setDescription("Count of seconds during this interval that there\nwas Loss of Power.")
vdslPerfDataCurr15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 15), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinLols.setDescription("Count of seconds during this interval that there\nwas Loss of Link.")
vdslPerfDataCurr15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 16), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinESs.setDescription("Count of Errored Seconds during this interval.  An Errored\nSecond is a one-second interval containing one or more CRC\nanomalies, or one or more LOS or LOF defects.")
vdslPerfDataCurr15MinSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 17), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinSESs.setDescription("Count of Severely Errored Seconds during this interval.")
vdslPerfDataCurr15MinUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 18), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinUASs.setDescription("Count of Unavailable Seconds during this interval.")
vdslPerfDataCurr15MinInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 19), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr15MinInits.setDescription("Count of the line initialization attempts during this\ninterval.  This count includes both successful and\nfailed attempts.")
vdslPerfData1DayValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 20), HCPerfValidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfData1DayValidIntervals.setDescription("Valid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslPerfData1DayInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 21), HCPerfInvalidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfData1DayInvalidIntervals.setDescription("Invalid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslPerfDataCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 22), HCPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the beginning\nof the current 1-day interval.")
vdslPerfDataCurr1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 23), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLofs.setDescription("Count of Loss of Framing (LOF) Seconds since the\nbeginning of the current 1-day interval.")
vdslPerfDataCurr1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 24), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLoss.setDescription("Count of Loss of Signal (LOS) Seconds since the beginning\nof the current 1-day interval.")
vdslPerfDataCurr1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 25), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLprs.setDescription("Count of Loss of Power (LPR) Seconds since the beginning\nof the current 1-day interval.")
vdslPerfDataCurr1DayLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 26), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayLols.setDescription("Count of Loss of Link (LOL) Seconds since the beginning\nof the current 1-day interval.")
vdslPerfDataCurr1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 27), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayESs.setDescription("Count of Errored Seconds (ES) since the beginning\nof the current 1-day interval.")
vdslPerfDataCurr1DaySESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 28), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DaySESs.setDescription("Count of Severely Errored Seconds (SES) since the\nbeginning of the current 1-day interval.")
vdslPerfDataCurr1DayUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 29), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayUASs.setDescription("Count of Unavailable Seconds (UAS) since the beginning\nof the current 1-day interval.")
vdslPerfDataCurr1DayInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 4, 1, 30), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfDataCurr1DayInits.setDescription("Count of the line initialization attempts since the\nbeginning of the current 1-day interval.  This count\nincludes both successful and failed attempts.")
vdslPerfIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5))
if mibBuilder.loadTexts: vdslPerfIntervalTable.setDescription("This table provides one row for each Vtu performance\ndata collection interval.  VDSL physical interfaces are\n\n\n\nthose ifEntries where ifType is equal to vdsl(97).")
vdslPerfIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslPerfIntervalNumber"))
if mibBuilder.loadTexts: vdslPerfIntervalEntry.setDescription("An entry in the vdslPerfIntervalTable.")
vdslPerfIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslPerfIntervalNumber.setDescription("Performance Data Interval number 1 is the most recent\nprevious interval; interval 96 is 24 hours ago.\nIntervals 2 to 96 are optional.")
vdslPerfIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 2), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLofs.setDescription("Count of seconds in the interval when there was Loss\nof Framing.")
vdslPerfIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 3), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLoss.setDescription("Count of seconds in the interval when there was Loss\nof Signal.")
vdslPerfIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 4), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLprs.setDescription("Count of seconds in the interval when there was Loss\nof Power.")
vdslPerfIntervalLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 5), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalLols.setDescription("Count of seconds in the interval when there was Loss\nof Link.")
vdslPerfIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 6), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalESs.setDescription("Count of Errored Seconds (ES) in the interval.  An Errored\nSecond is a one-second interval containing one or more CRC\nanomalies, one or more LOS or LOF defects.")
vdslPerfIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 7), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalSESs.setDescription("Count of Severely Errored Seconds in the interval.")
vdslPerfIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 8), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalUASs.setDescription("Count of Unavailable Seconds in the interval.")
vdslPerfIntervalInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 5, 1, 9), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerfIntervalInits.setDescription("Count of the line initialization attempts during this\ninterval.  This count includes both successful and\nfailed attempts.")
vdslPerf1DayIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6))
if mibBuilder.loadTexts: vdslPerf1DayIntervalTable.setDescription("This table provides one row for each VDSL performance\ndata collection interval.  This table contains live data\nfrom equipment.  As such, it is NOT persistent.")
vdslPerf1DayIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslPerf1DayIntervalNumber"))
if mibBuilder.loadTexts: vdslPerf1DayIntervalEntry.setDescription("An entry in the vdslPerf1DayIntervalTable.")
vdslPerf1DayIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 30))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslPerf1DayIntervalNumber.setDescription("History Data Interval number.  Interval 1 is the most\nrecent previous day; interval 30 is 30 days ago.  Intervals\n2 to 30 are optional.")
vdslPerf1DayIntervalMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 2), HCPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalMoniSecs.setDescription("The amount of time in the 1-day interval over which the\nperformance monitoring information is actually counted.\nThis value will be the same as the interval duration except\nin a situation where performance monitoring data could not\nbe collected for any reason.")
vdslPerf1DayIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLofs.setDescription("Count of Loss of Frame (LOF) Seconds during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLoss.setDescription("Count of Loss of Signal (LOS) Seconds during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLprs.setDescription("Count of Loss of Power (LPR) Seconds during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalLols.setDescription("Count of Loss of Link (LOL) Seconds during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalESs.setDescription("Count of Errored Seconds (ES) during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalSESs.setDescription("Count of Severely Errored Seconds (SES) during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalUASs.setDescription("Count of Unavailable Seconds (UAS) during the 1-day\ninterval as measured by vdslPerf1DayIntervalMoniSecs.")
vdslPerf1DayIntervalInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 6, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslPerf1DayIntervalInits.setDescription("Count of the line initialization attempts during the\n1-day interval as measured by vdslPerf1DayIntervalMoniSecs.\nThis count includes both successful and failed attempts.")
vdslChanPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7))
if mibBuilder.loadTexts: vdslChanPerfDataTable.setDescription("This table provides one row for each Vtu channel.\nVDSL channel interfaces are those ifEntries where\nifType is equal to interleave(124) or fast(125).")
vdslChanPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"))
if mibBuilder.loadTexts: vdslChanPerfDataEntry.setDescription("An entry in the vdslChanPerfDataTable.")
vdslChanValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 1), HCPerfValidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanValidIntervals.setDescription("Valid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslChanInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 2), HCPerfInvalidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanInvalidIntervals.setDescription("Invalid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslChanFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 3), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanFixedOctets.setDescription("Count of corrected octets since the unit was last reset.")
vdslChanBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 4), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanBadBlks.setDescription("Count of uncorrectable blocks since the unit was last\nreset.")
vdslChanCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 5), HCPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr15MinTimeElapsed.setDescription("Total elapsed seconds in this interval.")
vdslChanCurr15MinFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 6), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr15MinFixedOctets.setDescription("Count of corrected octets in this interval.")
vdslChanCurr15MinBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 7), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr15MinBadBlks.setDescription("Count of uncorrectable blocks in this interval.")
vdslChan1DayValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 8), HCPerfValidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayValidIntervals.setDescription("Valid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslChan1DayInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 9), HCPerfInvalidIntervals()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayInvalidIntervals.setDescription("Invalid Intervals per definition found in\nHC-PerfHist-TC-MIB.")
vdslChanCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 10), HCPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the beginning\nof the current 1-day interval.")
vdslChanCurr1DayFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 11), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr1DayFixedOctets.setDescription("Count of corrected octets since the beginning of the\ncurrent 1-day interval.")
vdslChanCurr1DayBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 7, 1, 12), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanCurr1DayBadBlks.setDescription("Count of uncorrectable blocks since the beginning of the\ncurrent 1-day interval.")
vdslChanIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8))
if mibBuilder.loadTexts: vdslChanIntervalTable.setDescription("This table provides one row for each Vtu channel data\ncollection interval.  VDSL channel interfaces are those\nifEntries where ifType is equal to interleave(124) or\nfast(125).")
vdslChanIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslChanIntervalNumber"))
if mibBuilder.loadTexts: vdslChanIntervalEntry.setDescription("An entry in the vdslChanIntervalTable.")
vdslChanIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslChanIntervalNumber.setDescription("Performance Data Interval number 1 is the most recent\nprevious interval; interval 96 is 24 hours ago.\nIntervals 2 to 96 are optional.")
vdslChanIntervalFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1, 2), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanIntervalFixedOctets.setDescription("Count of corrected octets in this interval.")
vdslChanIntervalBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 8, 1, 3), HCPerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChanIntervalBadBlks.setDescription("Count of uncorrectable blocks in this interval.")
vdslChan1DayIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9))
if mibBuilder.loadTexts: vdslChan1DayIntervalTable.setDescription("This table provides one row for each VDSL performance\ndata collection interval.  This table contains live data\nfrom equipment.  As such, it is NOT persistent.")
vdslChan1DayIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "VDSL-LINE-MIB", "vdslPhysSide"), (0, "VDSL-LINE-MIB", "vdslChan1DayIntervalNumber"))
if mibBuilder.loadTexts: vdslChan1DayIntervalEntry.setDescription("An entry in the vdslChan1DayIntervalTable.")
vdslChan1DayIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 30))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslChan1DayIntervalNumber.setDescription("History Data Interval number.  Interval 1 is the most\nrecent previous day; interval 30 is 30 days ago.  Intervals\n2 to 30 are optional.")
vdslChan1DayIntervalMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 2), HCPerfTimeElapsed()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayIntervalMoniSecs.setDescription("The amount of time in the 1-day interval over which the\nperformance monitoring information is actually counted.\nThis value will be the same as the interval duration except\nin a situation where performance monitoring data could not\nbe collected for any reason.")
vdslChan1DayIntervalFixedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 3), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayIntervalFixedOctets.setDescription("Count of corrected octets in this interval.")
vdslChan1DayIntervalBadBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 9, 1, 4), HCPerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: vdslChan1DayIntervalBadBlks.setDescription("Count of uncorrectable blocks in this interval.")
vdslLineConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11))
if mibBuilder.loadTexts: vdslLineConfProfileTable.setDescription("This table contains information on the VDSL line\nconfiguration.  One entry in this table reflects a\nprofile defined by a manager which can be used to\nconfigure the VDSL line.\n\nEntries in this table MUST be maintained in a\npersistent manner.")
vdslLineConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1)).setIndexNames((0, "VDSL-LINE-MIB", "vdslLineConfProfileName"))
if mibBuilder.loadTexts: vdslLineConfProfileEntry.setDescription("Each entry consists of a list of parameters that\nrepresents the configuration of a VDSL line.\n\nA default profile with an index of 'DEFVAL', will\nalways exist and its parameters will be set to vendor\nspecific values, unless otherwise specified in this\ndocument.")
vdslLineConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslLineConfProfileName.setDescription("This object identifies a row in this table.\n\nA default profile with an index of 'DEFVAL', will\nalways exist and its parameters will be set to vendor\nspecific values, unless otherwise specified in this\ndocument.")
vdslLineConfDownRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("manual", 1), ("adaptAtInit", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownRateMode.setDescription("Specifies the rate selection behavior for the line\nin the downstream direction.\n\nmanual(1)       forces the rate to the configured rate\nadaptAtInit(2)  adapts the line based upon line quality.")
vdslLineConfUpRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("manual", 1), ("adaptAtInit", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpRateMode.setDescription("Specifies the rate selection behavior for the line\nin the upstream direction.\n\nmanual(1)       forces the rate to the configured rate\nadaptAtInit(2)  adapts the line based upon line quality.")
vdslLineConfDownMaxPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 58)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxPwr.setDescription("Specifies the maximum aggregate downstream power\nlevel in the range 0 to 14.5 dBm.")
vdslLineConfUpMaxPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 58)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxPwr.setDescription("Specifies the maximum aggregate upstream power\nlevel in the range 0 to 14.5 dBm.")
vdslLineConfDownMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxSnrMgn.setDescription("Specifies the maximum downstream Signal/Noise Margin\nin units of 0.25 dB, for a range of 0 to 31.75 dB.")
vdslLineConfDownMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMinSnrMgn.setDescription("Specifies the minimum downstream Signal/Noise Margin\nin units of 0.25 dB, for a range of 0 to 31.75 dB.")
vdslLineConfDownTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownTargetSnrMgn.setDescription("Specifies the target downstream Signal/Noise Margin\nin units of 0.25 dB, for a range of 0 to 31.75 dB.\nThis is the Noise Margin the transceivers must achieve\nwith a BER of 10^-7 or better to successfully complete\ninitialization.")
vdslLineConfUpMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxSnrMgn.setDescription("Specifies the maximum upstream Signal/Noise Margin\nin units of 0.25 dB, for a range of 0 to 31.75 dB.")
vdslLineConfUpMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMinSnrMgn.setDescription("Specifies the minimum upstream Signal/Noise Margin\nin units of 0.25 dB, for a range of 0 to 31.75 dB.")
vdslLineConfUpTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpTargetSnrMgn.setDescription("Specifies the target upstream Signal/Noise Margin in\nunits of 0.25 dB, for a range of 0 to 31.75 dB.  This\nis the Noise Margin the transceivers must achieve with\na BER of 10^-7 or better to successfully complete\ninitialization.")
vdslLineConfDownFastMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 12), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownFastMaxDataRate.setDescription("Specifies the maximum downstream fast channel\ndata rate in steps of 1000 bits/second.")
vdslLineConfDownFastMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 13), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownFastMinDataRate.setDescription("Specifies the minimum downstream fast channel\ndata rate in steps of 1000 bits/second.")
vdslLineConfDownSlowMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 14), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownSlowMaxDataRate.setDescription("Specifies the maximum downstream slow channel\ndata rate in steps of 1000 bits/second.\n\nThe maximum aggregate downstream transmit speed\nof the line can be derived from the sum of maximum\ndownstream fast and slow channel data rates.")
vdslLineConfDownSlowMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 15), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownSlowMinDataRate.setDescription("Specifies the minimum downstream slow channel\ndata rate in steps of 1000 bits/second.\n\nThe minimum aggregate downstream transmit speed\nof the line can be derived from the sum of minimum\ndownstream fast and slow channel data rates.")
vdslLineConfUpFastMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 16), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpFastMaxDataRate.setDescription("Specifies the maximum upstream fast channel\ndata rate in steps of 1000 bits/second.\n\nThe maximum aggregate upstream transmit speed\nof the line can be derived from the sum of maximum\nupstream fast and slow channel data rates.")
vdslLineConfUpFastMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 17), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpFastMinDataRate.setDescription("Specifies the minimum upstream fast channel\ndata rate in steps of 1000 bits/second.\n\n\n\nThe minimum aggregate upstream transmit speed\nof the line can be derived from the sum of minimum\nupstream fast and slow channel data rates.")
vdslLineConfUpSlowMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 18), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpSlowMaxDataRate.setDescription("Specifies the maximum upstream slow channel\ndata rate in steps of 1000 bits/second.")
vdslLineConfUpSlowMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 19), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpSlowMinDataRate.setDescription("Specifies the minimum upstream slow channel\ndata rate in steps of 1000 bits/second.")
vdslLineConfDownRateRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 20), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownRateRatio.setDescription("For dynamic rate adaptation at startup, the allocation\nof data rate in excess of the minimum data rate for each\nchannel is controlled by the object.  This object specifies\nthe ratio of the allocation of the excess data rate between\nthe fast and the slow channels.  This allocation represents\ndownstream Fast Channel Allocation / Slow Channel\nAllocation.")
vdslLineConfUpRateRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 21), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 100)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpRateRatio.setDescription("For dynamic rate adaptation at startup, the allocation\nof data rate in excess of the minimum data rate for each\nchannel is controlled by the object.  This object specifies\nthe ratio of the allocation of the excess data rate between\nthe fast and the slow channels.  This allocation represents\nupstream Fast Channel Allocation/Slow Channel Allocation.")
vdslLineConfDownMaxInterDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 22), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxInterDelay.setDescription("Specifies the maximum interleave delay for the\ndownstream slow channel.")
vdslLineConfUpMaxInterDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 23), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxInterDelay.setDescription("Specifies the maximum interleave delay for the\nupstream slow channel.")
vdslLineConfDownPboControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 24), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("auto", 2), ("manual", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownPboControl.setDescription("Downstream power backoff (PBO) control for this\nline.  For transceivers which do not support downstream\nPBO control, this object MUST be fixed at disabled(1).\nIf auto(2) is selected, the transceiver will automatically\nadjust the power backoff.  If manual(3) is selected,\n\n\n\nthen the transceiver will use the value from\nvdslLineConfDownPboLevel.")
vdslLineConfUpPboControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 25), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("auto", 2), ("manual", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpPboControl.setDescription("Upstream power backoff (PBO) control for this\nline.  For transceivers which do not support upstream\nPBO control, this object MUST be fixed at disabled(1).\nIf auto(2) is selected, the transceiver will automatically\nadjust the power backoff.  If manual(3) is selected,\nthen the transceiver will use the value from\nvdslLineConfUpPboLevel.")
vdslLineConfDownPboLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 26), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 160)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownPboLevel.setDescription("Specifies the downstream backoff level to be used\nwhen vdslLineConfDownPboControl = manual(3).")
vdslLineConfUpPboLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 27), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 160)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpPboLevel.setDescription("Specifies the upstream backoff level to be used\nwhen vdslLineConfUpPboControl = manual(3).")
vdslLineConfDeploymentScenario = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 28), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("fttCab", 1), ("fttEx", 2), ("other", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDeploymentScenario.setDescription("The VDSL line deployment scenario.  When using\nfttCab(1), the VTU-C is located in a street cabinet.\nWhen using fttEx(2), the VTU-C is located at the\ncentral office.  Changes to this value will have\nno effect on the transceiver.")
vdslLineConfAdslPresence = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 29), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("adslOverPots", 2), ("adslOverISDN", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfAdslPresence.setDescription("Indicates presence of ADSL service in the associated\ncable bundle/binder.\n\nnone(1)         indicates no ADSL service in the bundle\nadslOverPots(2) indicates ADSL service over POTS is\n                present in the bundle\nadslOverISDN(3) indicates ADSL service over ISDN is\n                present in the bundle")
vdslLineConfApplicableStandard = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 30), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("ansi", 1), ("etsi", 2), ("itu", 3), ("other", 4), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfApplicableStandard.setDescription("The VDSL standard to be used for the line.\n\nansi(1)      indicates ANSI standard\netsi(2)      indicates ETSI standard\nitu(3)       indicates ITU standard\nother(4)     indicates a standard other than the above.")
vdslLineConfBandPlan = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 31), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("bandPlan997", 1), ("bandPlan998", 2), ("bandPlanFx", 3), ("other", 4), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfBandPlan.setDescription("The VDSL band plan to be used for the line.\n\nbandPlan997(1) is to be used for\n     ITU-T G.993.1 Bandplan-B\n     ETSI Bandplan\n     ANSI Plan 997\n\nbandPlan998(2) is to be used for\n     ITU-T G.993.1 Bandplan-A\n     ANSI Plan 998\n\nbandPlanFx(3) is to be used for\n     ITU-T G.993.1 Bandplan-C.\n\nother(4) is to be used for\n     non-standard bandplans.\n\nIf this object is set to bandPlanFx(3), then the\nobject vdslLineConfBandPlanFx MUST also be set.")
vdslLineConfBandPlanFx = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 32), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(3750, 12000)).clone(3750)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfBandPlanFx.setDescription("The frequency limit between bands D2 and U2 when\nvdslLineConfBandPlan is set to bandPlanFx(3).")
vdslLineConfBandOptUsage = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 33), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("unused", 1), ("upstream", 2), ("downstream", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfBandOptUsage.setDescription("Defines the VDSL link use of the optional frequency\nrange [25kHz - 138kHz] (Opt).\n\nunused(1)     indicates Opt is unused\nupstream(2)   indicates Opt usage is for upstream\ndownstream(3) indicates Opt usage is for downstream.")
vdslLineConfUpPsdTemplate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 34), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("templateMask1", 1), ("templateMask2", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpPsdTemplate.setDescription("The upstream PSD template to be used for the line.\nHere, templateMask1(1) refers to a notched mask that\nlimits the transmitted PSD within the internationally\nstandardized HAM (Handheld Amateur Radio) radio bands,\nwhile templateMask2(2) refers to an unnotched mask.\n\nThe masks themselves depend upon the applicable\nstandard being used (vdslLineConfApplicableStandard).")
vdslLineConfDownPsdTemplate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 35), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("templateMask1", 1), ("templateMask2", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownPsdTemplate.setDescription("The downstream PSD template to be used for the line.\nHere, templateMask1(1) refers to a notched mask that\nlimits the transmitted PSD within the internationally\nstandardized HAM (Handheld Amateur Radio) radio bands,\nwhile templateMask2(2) refers to an unnotched mask.\n\nThe masks themselves depend upon the applicable\nstandard being used (vdslLineConfApplicableStandard).")
vdslLineConfHamBandMask = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 36), Bits().subtype(namedValues=namedval.NamedValues(("customNotch1", 0), ("customNotch2", 1), ("amateurBand30m", 2), ("amateurBand40m", 3), ("amateurBand80m", 4), ("amateurBand160m", 5), )).clone(())).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfHamBandMask.setDescription("The transmit power spectral density mask code, used\nto avoid interference with HAM (Handheld Amateur Radio)\nradio bands by introducing power control (notching) in one\nor more of these bands.\n\nAmateur radio band notching is defined in the VDSL\nspectrum as follows:\n\nBand  Start Frequency     Stop Frequency\n----  ------------------  --------------------------------\n30m   1810 kHz            2000 kHz\n40m   3500 kHz            3800 kHz (ETSI); 4000 kHz (ANSI)\n80m   7000 kHz            7100 kHz (ETSI); 7300 kHz (ANSI)\n160m  10100 kHz           10150 kHz\n\n\n\nNotching for each standard band can be enabled or disabled\nvia the bit mask.\n\nTwo custom notches may be specified.  If either of these\nare enabled via the bit mask, then the following objects\nMUST be specified:\n\nIf customNotch1 is enabled, then both\n    vdslLineConfCustomNotch1Start\n    vdslLineConfCustomNotch1Stop\nMUST be specified.\n\nIf customNotch2 is enabled, then both\n    vdslLineConfCustomNotch2Start\n    vdslLineConfCustomNotch2Stop\nMUST be specified.")
vdslLineConfCustomNotch1Start = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 37), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch1Start.setDescription("Specifies the start frequency of custom HAM (Handheld\nAmateur Radio) notch 1.  vdslLineConfCustomNotch1Start MUST\nbe less than or equal to vdslLineConfCustomNotch1Stop.")
vdslLineConfCustomNotch1Stop = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 38), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch1Stop.setDescription("Specifies the stop frequency of custom HAM (Handheld\nAmateur Radio) notch 1.  vdslLineConfCustomNotch1Stop MUST\nbe greater than or equal to vdslLineConfCustomNotch1Start.")
vdslLineConfCustomNotch2Start = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 39), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch2Start.setDescription("Specifies the start frequency of custom HAM (Handheld\nAmateur Radio) notch 2.  vdslLineConfCustomNotch2Start MUST\nbe less than or equal to vdslLineConfCustomNotch2Stop.")
vdslLineConfCustomNotch2Stop = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 40), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfCustomNotch2Stop.setDescription("Specifies the stop frequency of custom HAM (Handheld\nAmateur Radio) notch 2.  vdslLineConfCustomNotch2Stop MUST\nbe greater than or equal to vdslLineConfCustomNotch2Start.")
vdslLineConfDownTargetSlowBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 41), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1275)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownTargetSlowBurst.setDescription("Specifies the target level of impulse noise (burst)\nprotection for an interleaved (slow) channel.")
vdslLineConfUpTargetSlowBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 42), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1275)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpTargetSlowBurst.setDescription("Specifies the target level of impulse noise (burst)\nprotection for an interleaved (slow) channel.")
vdslLineConfDownMaxFastFec = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 43), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 50)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfDownMaxFastFec.setDescription("This parameter provisions the maximum level of Forward\nError Correction (FEC) redundancy related overhead to\nbe maintained for a fast channel.")
vdslLineConfUpMaxFastFec = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 44), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 50)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfUpMaxFastFec.setDescription("This parameter provisions the maximum level of Forward\nError Correction (FEC) redundancy related overhead to\nbe maintained for a fast channel.")
vdslLineConfLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 45), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,5,)).subtype(namedValues=namedval.NamedValues(("noChannel", 1), ("fastOnly", 2), ("interleavedOnly", 3), ("fastOrInterleaved", 4), ("fastAndInterleaved", 5), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfLineType.setDescription("This parameter provisions the VDSL physical entity at\nstart-up by defining whether and how the line will be\nchannelized, i.e., which channel type(s) are supported.\nIf the line is to be channelized, the value will be other\nthan noChannel(1).\n\nThis configuration can be activated only during start-up.\nAfterwards, the value of vdslLineType coincides with the\nvalue of vdslLineConfLineType.  Depending on this value,\nthe corresponding entries in the ifTable for the\ninterleaved and the fast channels are enabled or disabled\naccording to the value of their ifOperStatus.\n\nDefined values are:\n\n\n\nnoChannel(1)          -- no channels exist\nfastOnly(2)           -- only fast channel exists\ninterleavedOnly(3)    -- only interleaved channel exists\nfastOrInterleaved(4)  -- either fast or interleaved channel\n                      -- exists, but only one at a time\nfastAndInterleaved(5) -- both fast and interleaved channels\n                      -- exist\n\nNote that 'slow' and 'interleaved' refer to the same\nchannel.")
vdslLineConfProfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 11, 1, 46), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineConfProfRowStatus.setDescription("This object is used to create a new row or modify or\ndelete an existing row in this table.\n\nA profile activated by setting this object to 'active'.\nWhen 'active' is set, the system will validate the profile.\n\nBefore a profile can be deleted or taken out of service\n(by setting this object to 'destroy' or 'outOfService'),\nit must be first unreferenced from all associated lines.\n\nAn 'active' profile may be modified at any time.  Note\nthat some changes may require that any referenced lines be\nrestarted (e.g., vdslLineConfLineType).")
vdslLineAlarmConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20))
if mibBuilder.loadTexts: vdslLineAlarmConfProfileTable.setDescription("This table contains information on the VDSL line alarm\nconfiguration.  One entry in this table reflects a profile\ndefined by a manager which can be used to configure the\nVDSL line alarm thresholds.\n\n\n\n\nEntries in this table MUST be maintained in a\npersistent manner.")
vdslLineAlarmConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1)).setIndexNames((0, "VDSL-LINE-MIB", "vdslLineAlarmConfProfileName"))
if mibBuilder.loadTexts: vdslLineAlarmConfProfileEntry.setDescription("Each entry consists of a list of parameters that\nrepresents the configuration of a VDSL line alarm\nprofile.\n\nA default profile with an index of 'DEFVAL', will\nalways exist and its parameters will be set to vendor\nspecific values, unless otherwise specified in this\ndocument.")
vdslLineAlarmConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: vdslLineAlarmConfProfileName.setDescription("The name for this profile as specified by an\nadministrator.")
vdslLineAlarmConfThresh15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 2), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLofs.setDescription("This object configures the threshold for the number of\nloss of frame seconds (lofs) within any given 15-minute\nperformance data collection interval.  If the value of\nloss of frame seconds in a particular 15-minute collection\ninterval reaches/exceeds this value, a\nvdslPerfLofsThreshNotification notification will be\ngenerated.  No more than one notification will be sent\nper interval.")
vdslLineAlarmConfThresh15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 3), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLoss.setDescription("This object configures the threshold for the number of\nloss of signal seconds (loss) within any given 15-minute\nperformance data collection interval.  If the value of\nloss of signal seconds in a particular 15-minute\ncollection interval reaches/exceeds this value, a\nvdslPerfLossThreshNotification notification will be\ngenerated.  One notification will be sent per interval\nper endpoint.")
vdslLineAlarmConfThresh15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 4), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLprs.setDescription("This object configures the threshold for the number of\nloss of power seconds (lprs) within any given 15-minute\nperformance data collection interval.  If the value of\nloss of power seconds in a particular 15-minute collection\ninterval reaches/exceeds this value, a\nvdslPerfLprsThreshNotification notification will be\ngenerated.  No more than one notification will be sent\nper interval.")
vdslLineAlarmConfThresh15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 5), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinLols.setDescription("This object configures the threshold for the number of\nloss of link seconds (lols) within any given 15-minute\nperformance data collection interval.  If the value of\nloss of power seconds in a particular 15-minute collection\ninterval reaches/exceeds this value, a\nvdslPerfLolsThreshNotification notification will be\ngenerated.  No more than one notification will be sent\nper interval.")
vdslLineAlarmConfThresh15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 6), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinESs.setDescription("This object configures the threshold for the number of\nerrored seconds (ESs) within any given 15-minute\nperformance data collection interval.  If the value of\nerrored seconds in a particular 15-minute collection\ninterval reaches/exceeds this value, a\nvdslPerfESsThreshNotification notification will be\ngenerated.  No more than one notification will be sent\nper interval.")
vdslLineAlarmConfThresh15MinSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 7), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinSESs.setDescription("This object configures the threshold for the number of\nseverely errored seconds (SESs) within any given 15-minute\nperformance data collection interval.  If the value of\nseverely errored seconds in a particular 15-minute\ncollection interval reaches/exceeds this value, a\nvdslPerfSESsThreshNotification notification will be\ngenerated.  No more than one notification will be sent\nper interval.")
vdslLineAlarmConfThresh15MinUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 8), HCPerfIntervalThreshold().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfThresh15MinUASs.setDescription("This object configures the threshold for the number of\nunavailable seconds (UASs) within any given 15-minute\nperformance data collection interval.  If the value of\nunavailable seconds in a particular 15-minute collection\ninterval reaches/exceeds this value, a\nvdslPerfUASsThreshNotification notification will be\ngenerated.  No more than one notification will be sent\nper interval.")
vdslLineAlarmConfInitFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 9), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfInitFailure.setDescription("This object specifies if a vdslInitFailureNotification\nnotification will be generated if an initialization\nfailure occurs.")
vdslLineAlarmConfProfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 97, 1, 1, 20, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: vdslLineAlarmConfProfRowStatus.setDescription("This object is used to create a new row or modify or\ndelete an existing row in this table.\n\nA profile activated by setting this object to 'active'.\nWhen 'active' is set, the system will validate the profile.\n\nBefore a profile can be deleted or taken out of service,\n(by setting this object to 'destroy' or 'outOfService') it\nmust be first unreferenced from all associated lines.\n\nAn 'active' profile may be modified at any time.")
vdslConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 3))
vdslGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 1))
vdslCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 2))

# Augmentions

# Notifications

vdslUpMinSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 11)).setObjects(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"), )
vdslPerfLolsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 4)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLols"), )
vdslPerfUASsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 7)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinUASs"), )
vdslInitFailureNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 12)).setObjects(("VDSL-LINE-MIB", "vdslPhysCurrStatus"), )
vdslPerfESsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 5)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinESs"), )
vdslDownMaxSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 8)).setObjects(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"), )
vdslPerfSESsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 6)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinSESs"), )
vdslPerfLprsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 3)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLprs"), )
vdslPerfLofsThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 1)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLofs"), )
vdslUpMaxSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 10)).setObjects(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"), )
vdslPerfLossThreshNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 2)).setObjects(("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLoss"), )
vdslDownMinSnrMgnNotification = NotificationType((1, 3, 6, 1, 2, 1, 10, 97, 1, 0, 9)).setObjects(("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"), )

# Groups

vdslGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 1, 1)).setObjects(("VDSL-LINE-MIB", "vdslPerf1DayIntervalSESs"), ("VDSL-LINE-MIB", "vdslPerfData1DayInvalidIntervals"), ("VDSL-LINE-MIB", "vdslLineConfUpSlowMinDataRate"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLols"), ("VDSL-LINE-MIB", "vdslLineConfUpTargetSnrMgn"), ("VDSL-LINE-MIB", "vdslChan1DayIntervalFixedOctets"), ("VDSL-LINE-MIB", "vdslLineConfUpRateRatio"), ("VDSL-LINE-MIB", "vdslLineConfHamBandMask"), ("VDSL-LINE-MIB", "vdslPerfDataInits"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinSESs"), ("VDSL-LINE-MIB", "vdslLineConfDownPboControl"), ("VDSL-LINE-MIB", "vdslPerfIntervalLofs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfInitFailure"), ("VDSL-LINE-MIB", "vdslChan1DayValidIntervals"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLoss"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLoss"), ("VDSL-LINE-MIB", "vdslLineConfBandPlan"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch2Stop"), ("VDSL-LINE-MIB", "vdslLineConfDownRateRatio"), ("VDSL-LINE-MIB", "vdslLineConfDeploymentScenario"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLofs"), ("VDSL-LINE-MIB", "vdslPerfData1DayValidIntervals"), ("VDSL-LINE-MIB", "vdslPhysInvVersionNumber"), ("VDSL-LINE-MIB", "vdslChanInvalidIntervals"), ("VDSL-LINE-MIB", "vdslChan1DayInvalidIntervals"), ("VDSL-LINE-MIB", "vdslChan1DayIntervalBadBlks"), ("VDSL-LINE-MIB", "vdslLineAlarmConfProfRowStatus"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayInits"), ("VDSL-LINE-MIB", "vdslLineType"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLoss"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalESs"), ("VDSL-LINE-MIB", "vdslPhysInvVendorID"), ("VDSL-LINE-MIB", "vdslPerfDataInvalidIntervals"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinUASs"), ("VDSL-LINE-MIB", "vdslLineConfDownTargetSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfDownPboLevel"), ("VDSL-LINE-MIB", "vdslLineConfUpFastMaxDataRate"), ("VDSL-LINE-MIB", "vdslLineCoding"), ("VDSL-LINE-MIB", "vdslLineConfApplicableStandard"), ("VDSL-LINE-MIB", "vdslLineConfUpMinSnrMgn"), ("VDSL-LINE-MIB", "vdslChanCurr15MinBadBlks"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLofs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinInits"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinUASs"), ("VDSL-LINE-MIB", "vdslLineConfDownSlowMinDataRate"), ("VDSL-LINE-MIB", "vdslLineConfProfRowStatus"), ("VDSL-LINE-MIB", "vdslChanCurr1DayFixedOctets"), ("VDSL-LINE-MIB", "vdslPhysCurrSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxFastFec"), ("VDSL-LINE-MIB", "vdslPerfIntervalUASs"), ("VDSL-LINE-MIB", "vdslLineConfDownFastMinDataRate"), ("VDSL-LINE-MIB", "vdslChanCurr15MinFixedOctets"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch1Start"), ("VDSL-LINE-MIB", "vdslChanCurrTxFastFec"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxPwr"), ("VDSL-LINE-MIB", "vdslChanIntervalFixedOctets"), ("VDSL-LINE-MIB", "vdslPhysCurrOutputPwr"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalInits"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLprs"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxPwr"), ("VDSL-LINE-MIB", "vdslPerfDataLols"), ("VDSL-LINE-MIB", "vdslLineConfUpRateMode"), ("VDSL-LINE-MIB", "vdslLineConfDownRateMode"), ("VDSL-LINE-MIB", "vdslPhysCurrStatus"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayESs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLols"), ("VDSL-LINE-MIB", "vdslLineConfDownSlowMaxDataRate"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinTimeElapsed"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLprs"), ("VDSL-LINE-MIB", "vdslChanCurrTxSlowBurstProtect"), ("VDSL-LINE-MIB", "vdslLineConfUpPboLevel"), ("VDSL-LINE-MIB", "vdslPerfDataESs"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch2Start"), ("VDSL-LINE-MIB", "vdslLineAlarmConfProfile"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxFastFec"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLols"), ("VDSL-LINE-MIB", "vdslPhysCurrAttainableRate"), ("VDSL-LINE-MIB", "vdslChanCrcBlockLength"), ("VDSL-LINE-MIB", "vdslLineConfAdslPresence"), ("VDSL-LINE-MIB", "vdslPerfIntervalLprs"), ("VDSL-LINE-MIB", "vdslPhysCurrAtn"), ("VDSL-LINE-MIB", "vdslChanCurr1DayBadBlks"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalUASs"), ("VDSL-LINE-MIB", "vdslLineConfUpPsdTemplate"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DaySESs"), ("VDSL-LINE-MIB", "vdslChanCurr1DayTimeElapsed"), ("VDSL-LINE-MIB", "vdslLineConfBandPlanFx"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayLprs"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxSnrMgn"), ("VDSL-LINE-MIB", "vdslPerfIntervalESs"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinSESs"), ("VDSL-LINE-MIB", "vdslPerfDataValidIntervals"), ("VDSL-LINE-MIB", "vdslLineConfUpFastMinDataRate"), ("VDSL-LINE-MIB", "vdslLineConfDownFastMaxDataRate"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalLprs"), ("VDSL-LINE-MIB", "vdslPerfDataUASs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLols"), ("VDSL-LINE-MIB", "vdslLineConfUpTargetSlowBurst"), ("VDSL-LINE-MIB", "vdslChanFixedOctets"), ("VDSL-LINE-MIB", "vdslChanValidIntervals"), ("VDSL-LINE-MIB", "vdslLineConfDownTargetSlowBurst"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxInterDelay"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinESs"), ("VDSL-LINE-MIB", "vdslPerfDataLoss"), ("VDSL-LINE-MIB", "vdslChanBadBlks"), ("VDSL-LINE-MIB", "vdslPerfIntervalInits"), ("VDSL-LINE-MIB", "vdslLineConfDownPsdTemplate"), ("VDSL-LINE-MIB", "vdslChan1DayIntervalMoniSecs"), ("VDSL-LINE-MIB", "vdslPhysCurrLineRate"), ("VDSL-LINE-MIB", "vdslLineConfProfile"), ("VDSL-LINE-MIB", "vdslLineConfCustomNotch1Stop"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinESs"), ("VDSL-LINE-MIB", "vdslPhysInvSerialNumber"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayTimeElapsed"), ("VDSL-LINE-MIB", "vdslPerfDataLofs"), ("VDSL-LINE-MIB", "vdslChanCurr15MinTimeElapsed"), ("VDSL-LINE-MIB", "vdslChanIntervalBadBlks"), ("VDSL-LINE-MIB", "vdslLineConfUpSlowMaxDataRate"), ("VDSL-LINE-MIB", "vdslPerfDataLprs"), ("VDSL-LINE-MIB", "vdslPerfDataCurr1DayUASs"), ("VDSL-LINE-MIB", "vdslPerfIntervalLoss"), ("VDSL-LINE-MIB", "vdslChanInterleaveDelay"), ("VDSL-LINE-MIB", "vdslLineConfDownMinSnrMgn"), ("VDSL-LINE-MIB", "vdslLineConfDownMaxSnrMgn"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLoss"), ("VDSL-LINE-MIB", "vdslLineConfLineType"), ("VDSL-LINE-MIB", "vdslPerfIntervalLols"), ("VDSL-LINE-MIB", "vdslPerfDataCurr15MinLofs"), ("VDSL-LINE-MIB", "vdslChanCurrTxRate"), ("VDSL-LINE-MIB", "vdslLineConfUpPboControl"), ("VDSL-LINE-MIB", "vdslPerfDataSESs"), ("VDSL-LINE-MIB", "vdslPerf1DayIntervalMoniSecs"), ("VDSL-LINE-MIB", "vdslLineConfUpMaxInterDelay"), ("VDSL-LINE-MIB", "vdslLineAlarmConfThresh15MinLofs"), ("VDSL-LINE-MIB", "vdslPerfIntervalSESs"), ("VDSL-LINE-MIB", "vdslLineConfBandOptUsage"), )
vdslNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 97, 1, 3, 1, 2)).setObjects(("VDSL-LINE-MIB", "vdslUpMinSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslPerfLolsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfUASsThreshNotification"), ("VDSL-LINE-MIB", "vdslInitFailureNotification"), ("VDSL-LINE-MIB", "vdslPerfESsThreshNotification"), ("VDSL-LINE-MIB", "vdslDownMaxSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslPerfSESsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfLprsThreshNotification"), ("VDSL-LINE-MIB", "vdslPerfLofsThreshNotification"), ("VDSL-LINE-MIB", "vdslUpMaxSnrMgnNotification"), ("VDSL-LINE-MIB", "vdslPerfLossThreshNotification"), ("VDSL-LINE-MIB", "vdslDownMinSnrMgnNotification"), )

# Exports

# Module identity
mibBuilder.exportSymbols("VDSL-LINE-MIB", PYSNMP_MODULE_ID=vdslMIB)

# Types
mibBuilder.exportSymbols("VDSL-LINE-MIB", VdslLineCodingType=VdslLineCodingType, VdslLineEntity=VdslLineEntity)

# Objects
mibBuilder.exportSymbols("VDSL-LINE-MIB", vdslMIB=vdslMIB, vdslLineMib=vdslLineMib, vdslNotifications=vdslNotifications, vdslMibObjects=vdslMibObjects, vdslLineTable=vdslLineTable, vdslLineEntry=vdslLineEntry, vdslLineCoding=vdslLineCoding, vdslLineType=vdslLineType, vdslLineConfProfile=vdslLineConfProfile, vdslLineAlarmConfProfile=vdslLineAlarmConfProfile, vdslPhysTable=vdslPhysTable, vdslPhysEntry=vdslPhysEntry, vdslPhysSide=vdslPhysSide, vdslPhysInvSerialNumber=vdslPhysInvSerialNumber, vdslPhysInvVendorID=vdslPhysInvVendorID, vdslPhysInvVersionNumber=vdslPhysInvVersionNumber, vdslPhysCurrSnrMgn=vdslPhysCurrSnrMgn, vdslPhysCurrAtn=vdslPhysCurrAtn, vdslPhysCurrStatus=vdslPhysCurrStatus, vdslPhysCurrOutputPwr=vdslPhysCurrOutputPwr, vdslPhysCurrAttainableRate=vdslPhysCurrAttainableRate, vdslPhysCurrLineRate=vdslPhysCurrLineRate, vdslChanTable=vdslChanTable, vdslChanEntry=vdslChanEntry, vdslChanInterleaveDelay=vdslChanInterleaveDelay, vdslChanCrcBlockLength=vdslChanCrcBlockLength, vdslChanCurrTxRate=vdslChanCurrTxRate, vdslChanCurrTxSlowBurstProtect=vdslChanCurrTxSlowBurstProtect, vdslChanCurrTxFastFec=vdslChanCurrTxFastFec, vdslPerfDataTable=vdslPerfDataTable, vdslPerfDataEntry=vdslPerfDataEntry, vdslPerfDataValidIntervals=vdslPerfDataValidIntervals, vdslPerfDataInvalidIntervals=vdslPerfDataInvalidIntervals, vdslPerfDataLofs=vdslPerfDataLofs, vdslPerfDataLoss=vdslPerfDataLoss, vdslPerfDataLprs=vdslPerfDataLprs, vdslPerfDataLols=vdslPerfDataLols, vdslPerfDataESs=vdslPerfDataESs, vdslPerfDataSESs=vdslPerfDataSESs, vdslPerfDataUASs=vdslPerfDataUASs, vdslPerfDataInits=vdslPerfDataInits, vdslPerfDataCurr15MinTimeElapsed=vdslPerfDataCurr15MinTimeElapsed, vdslPerfDataCurr15MinLofs=vdslPerfDataCurr15MinLofs, vdslPerfDataCurr15MinLoss=vdslPerfDataCurr15MinLoss, vdslPerfDataCurr15MinLprs=vdslPerfDataCurr15MinLprs, vdslPerfDataCurr15MinLols=vdslPerfDataCurr15MinLols, vdslPerfDataCurr15MinESs=vdslPerfDataCurr15MinESs, vdslPerfDataCurr15MinSESs=vdslPerfDataCurr15MinSESs, vdslPerfDataCurr15MinUASs=vdslPerfDataCurr15MinUASs, vdslPerfDataCurr15MinInits=vdslPerfDataCurr15MinInits, vdslPerfData1DayValidIntervals=vdslPerfData1DayValidIntervals, vdslPerfData1DayInvalidIntervals=vdslPerfData1DayInvalidIntervals, vdslPerfDataCurr1DayTimeElapsed=vdslPerfDataCurr1DayTimeElapsed, vdslPerfDataCurr1DayLofs=vdslPerfDataCurr1DayLofs, vdslPerfDataCurr1DayLoss=vdslPerfDataCurr1DayLoss, vdslPerfDataCurr1DayLprs=vdslPerfDataCurr1DayLprs, vdslPerfDataCurr1DayLols=vdslPerfDataCurr1DayLols, vdslPerfDataCurr1DayESs=vdslPerfDataCurr1DayESs, vdslPerfDataCurr1DaySESs=vdslPerfDataCurr1DaySESs, vdslPerfDataCurr1DayUASs=vdslPerfDataCurr1DayUASs, vdslPerfDataCurr1DayInits=vdslPerfDataCurr1DayInits, vdslPerfIntervalTable=vdslPerfIntervalTable, vdslPerfIntervalEntry=vdslPerfIntervalEntry, vdslPerfIntervalNumber=vdslPerfIntervalNumber, vdslPerfIntervalLofs=vdslPerfIntervalLofs, vdslPerfIntervalLoss=vdslPerfIntervalLoss, vdslPerfIntervalLprs=vdslPerfIntervalLprs, vdslPerfIntervalLols=vdslPerfIntervalLols, vdslPerfIntervalESs=vdslPerfIntervalESs, vdslPerfIntervalSESs=vdslPerfIntervalSESs, vdslPerfIntervalUASs=vdslPerfIntervalUASs, vdslPerfIntervalInits=vdslPerfIntervalInits, vdslPerf1DayIntervalTable=vdslPerf1DayIntervalTable, vdslPerf1DayIntervalEntry=vdslPerf1DayIntervalEntry, vdslPerf1DayIntervalNumber=vdslPerf1DayIntervalNumber, vdslPerf1DayIntervalMoniSecs=vdslPerf1DayIntervalMoniSecs, vdslPerf1DayIntervalLofs=vdslPerf1DayIntervalLofs, vdslPerf1DayIntervalLoss=vdslPerf1DayIntervalLoss, vdslPerf1DayIntervalLprs=vdslPerf1DayIntervalLprs, vdslPerf1DayIntervalLols=vdslPerf1DayIntervalLols, vdslPerf1DayIntervalESs=vdslPerf1DayIntervalESs, vdslPerf1DayIntervalSESs=vdslPerf1DayIntervalSESs, vdslPerf1DayIntervalUASs=vdslPerf1DayIntervalUASs, vdslPerf1DayIntervalInits=vdslPerf1DayIntervalInits, vdslChanPerfDataTable=vdslChanPerfDataTable, vdslChanPerfDataEntry=vdslChanPerfDataEntry, vdslChanValidIntervals=vdslChanValidIntervals, vdslChanInvalidIntervals=vdslChanInvalidIntervals, vdslChanFixedOctets=vdslChanFixedOctets, vdslChanBadBlks=vdslChanBadBlks, vdslChanCurr15MinTimeElapsed=vdslChanCurr15MinTimeElapsed, vdslChanCurr15MinFixedOctets=vdslChanCurr15MinFixedOctets, vdslChanCurr15MinBadBlks=vdslChanCurr15MinBadBlks, vdslChan1DayValidIntervals=vdslChan1DayValidIntervals, vdslChan1DayInvalidIntervals=vdslChan1DayInvalidIntervals, vdslChanCurr1DayTimeElapsed=vdslChanCurr1DayTimeElapsed, vdslChanCurr1DayFixedOctets=vdslChanCurr1DayFixedOctets, vdslChanCurr1DayBadBlks=vdslChanCurr1DayBadBlks, vdslChanIntervalTable=vdslChanIntervalTable, vdslChanIntervalEntry=vdslChanIntervalEntry, vdslChanIntervalNumber=vdslChanIntervalNumber, vdslChanIntervalFixedOctets=vdslChanIntervalFixedOctets, vdslChanIntervalBadBlks=vdslChanIntervalBadBlks, vdslChan1DayIntervalTable=vdslChan1DayIntervalTable, vdslChan1DayIntervalEntry=vdslChan1DayIntervalEntry, vdslChan1DayIntervalNumber=vdslChan1DayIntervalNumber, vdslChan1DayIntervalMoniSecs=vdslChan1DayIntervalMoniSecs, vdslChan1DayIntervalFixedOctets=vdslChan1DayIntervalFixedOctets, vdslChan1DayIntervalBadBlks=vdslChan1DayIntervalBadBlks, vdslLineConfProfileTable=vdslLineConfProfileTable, vdslLineConfProfileEntry=vdslLineConfProfileEntry, vdslLineConfProfileName=vdslLineConfProfileName, vdslLineConfDownRateMode=vdslLineConfDownRateMode, vdslLineConfUpRateMode=vdslLineConfUpRateMode, vdslLineConfDownMaxPwr=vdslLineConfDownMaxPwr, vdslLineConfUpMaxPwr=vdslLineConfUpMaxPwr, vdslLineConfDownMaxSnrMgn=vdslLineConfDownMaxSnrMgn, vdslLineConfDownMinSnrMgn=vdslLineConfDownMinSnrMgn, vdslLineConfDownTargetSnrMgn=vdslLineConfDownTargetSnrMgn, vdslLineConfUpMaxSnrMgn=vdslLineConfUpMaxSnrMgn, vdslLineConfUpMinSnrMgn=vdslLineConfUpMinSnrMgn, vdslLineConfUpTargetSnrMgn=vdslLineConfUpTargetSnrMgn, vdslLineConfDownFastMaxDataRate=vdslLineConfDownFastMaxDataRate, vdslLineConfDownFastMinDataRate=vdslLineConfDownFastMinDataRate, vdslLineConfDownSlowMaxDataRate=vdslLineConfDownSlowMaxDataRate, vdslLineConfDownSlowMinDataRate=vdslLineConfDownSlowMinDataRate)
mibBuilder.exportSymbols("VDSL-LINE-MIB", vdslLineConfUpFastMaxDataRate=vdslLineConfUpFastMaxDataRate, vdslLineConfUpFastMinDataRate=vdslLineConfUpFastMinDataRate, vdslLineConfUpSlowMaxDataRate=vdslLineConfUpSlowMaxDataRate, vdslLineConfUpSlowMinDataRate=vdslLineConfUpSlowMinDataRate, vdslLineConfDownRateRatio=vdslLineConfDownRateRatio, vdslLineConfUpRateRatio=vdslLineConfUpRateRatio, vdslLineConfDownMaxInterDelay=vdslLineConfDownMaxInterDelay, vdslLineConfUpMaxInterDelay=vdslLineConfUpMaxInterDelay, vdslLineConfDownPboControl=vdslLineConfDownPboControl, vdslLineConfUpPboControl=vdslLineConfUpPboControl, vdslLineConfDownPboLevel=vdslLineConfDownPboLevel, vdslLineConfUpPboLevel=vdslLineConfUpPboLevel, vdslLineConfDeploymentScenario=vdslLineConfDeploymentScenario, vdslLineConfAdslPresence=vdslLineConfAdslPresence, vdslLineConfApplicableStandard=vdslLineConfApplicableStandard, vdslLineConfBandPlan=vdslLineConfBandPlan, vdslLineConfBandPlanFx=vdslLineConfBandPlanFx, vdslLineConfBandOptUsage=vdslLineConfBandOptUsage, vdslLineConfUpPsdTemplate=vdslLineConfUpPsdTemplate, vdslLineConfDownPsdTemplate=vdslLineConfDownPsdTemplate, vdslLineConfHamBandMask=vdslLineConfHamBandMask, vdslLineConfCustomNotch1Start=vdslLineConfCustomNotch1Start, vdslLineConfCustomNotch1Stop=vdslLineConfCustomNotch1Stop, vdslLineConfCustomNotch2Start=vdslLineConfCustomNotch2Start, vdslLineConfCustomNotch2Stop=vdslLineConfCustomNotch2Stop, vdslLineConfDownTargetSlowBurst=vdslLineConfDownTargetSlowBurst, vdslLineConfUpTargetSlowBurst=vdslLineConfUpTargetSlowBurst, vdslLineConfDownMaxFastFec=vdslLineConfDownMaxFastFec, vdslLineConfUpMaxFastFec=vdslLineConfUpMaxFastFec, vdslLineConfLineType=vdslLineConfLineType, vdslLineConfProfRowStatus=vdslLineConfProfRowStatus, vdslLineAlarmConfProfileTable=vdslLineAlarmConfProfileTable, vdslLineAlarmConfProfileEntry=vdslLineAlarmConfProfileEntry, vdslLineAlarmConfProfileName=vdslLineAlarmConfProfileName, vdslLineAlarmConfThresh15MinLofs=vdslLineAlarmConfThresh15MinLofs, vdslLineAlarmConfThresh15MinLoss=vdslLineAlarmConfThresh15MinLoss, vdslLineAlarmConfThresh15MinLprs=vdslLineAlarmConfThresh15MinLprs, vdslLineAlarmConfThresh15MinLols=vdslLineAlarmConfThresh15MinLols, vdslLineAlarmConfThresh15MinESs=vdslLineAlarmConfThresh15MinESs, vdslLineAlarmConfThresh15MinSESs=vdslLineAlarmConfThresh15MinSESs, vdslLineAlarmConfThresh15MinUASs=vdslLineAlarmConfThresh15MinUASs, vdslLineAlarmConfInitFailure=vdslLineAlarmConfInitFailure, vdslLineAlarmConfProfRowStatus=vdslLineAlarmConfProfRowStatus, vdslConformance=vdslConformance, vdslGroups=vdslGroups, vdslCompliances=vdslCompliances)

# Notifications
mibBuilder.exportSymbols("VDSL-LINE-MIB", vdslUpMinSnrMgnNotification=vdslUpMinSnrMgnNotification, vdslPerfLolsThreshNotification=vdslPerfLolsThreshNotification, vdslPerfUASsThreshNotification=vdslPerfUASsThreshNotification, vdslInitFailureNotification=vdslInitFailureNotification, vdslPerfESsThreshNotification=vdslPerfESsThreshNotification, vdslDownMaxSnrMgnNotification=vdslDownMaxSnrMgnNotification, vdslPerfSESsThreshNotification=vdslPerfSESsThreshNotification, vdslPerfLprsThreshNotification=vdslPerfLprsThreshNotification, vdslPerfLofsThreshNotification=vdslPerfLofsThreshNotification, vdslUpMaxSnrMgnNotification=vdslUpMaxSnrMgnNotification, vdslPerfLossThreshNotification=vdslPerfLossThreshNotification, vdslDownMinSnrMgnNotification=vdslDownMinSnrMgnNotification)

# Groups
mibBuilder.exportSymbols("VDSL-LINE-MIB", vdslGroup=vdslGroup, vdslNotificationGroup=vdslNotificationGroup)
