# PySNMP SMI module. Autogenerated from smidump -f python ATM-TC-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:10 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( Bits, Integer32, ModuleIdentity, MibIdentifier, ObjectIdentity, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "ObjectIdentity", "TimeTicks", "TimeTicks", "mib-2")
( TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention")

# Types

class AtmAddr(TextualConvention, OctetString):
    displayHint = "1x"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,40)
    
class AtmConnCastType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,1,)
    namedValues = namedval.NamedValues(("p2p", 1), ("p2mpRoot", 2), ("p2mpLeaf", 3), )
    
class AtmConnKind(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,4,2,5,3,)
    namedValues = namedval.NamedValues(("pvc", 1), ("svcIncoming", 2), ("svcOutgoing", 3), ("spvcInitiator", 4), ("spvcTarget", 5), )
    
class AtmIlmiNetworkPrefix(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ConstraintsUnion(constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(13,13),)
    
class AtmInterfaceType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(4,5,8,7,12,10,1,3,13,11,9,2,6,)
    namedValues = namedval.NamedValues(("other", 1), ("atmfPnni1Dot0", 10), ("atmfBici2Dot0", 11), ("atmfUniPvcOnly", 12), ("atmfNniPvcOnly", 13), ("autoConfig", 2), ("ituDss2", 3), ("atmfUni3Dot0", 4), ("atmfUni3Dot1", 5), ("atmfUni4Dot0", 6), ("atmfIispUni3Dot0", 7), ("atmfIispUni3Dot1", 8), ("atmfIispUni4Dot0", 9), )
    
class AtmServiceCategory(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,5,1,6,4,3,)
    namedValues = namedval.NamedValues(("other", 1), ("cbr", 2), ("rtVbr", 3), ("nrtVbr", 4), ("abr", 5), ("ubr", 6), )
    
class AtmSigDescrParamIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647)
    
class AtmTrafficDescrParamIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647)
    
class AtmVcIdentifier(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,65535)
    
class AtmVorXAdminStatus(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,)
    namedValues = namedval.NamedValues(("up", 1), ("down", 2), )
    
class AtmVorXLastChange(TimeTicks):
    pass

class AtmVorXOperStatus(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,1,2,)
    namedValues = namedval.NamedValues(("up", 1), ("down", 2), ("unknown", 3), )
    
class AtmVpIdentifier(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,4095)
    

# Objects

atmTrafficDescriptorTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 37, 1, 1))
atmNoTrafficDescriptor = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 1))
if mibBuilder.loadTexts: atmNoTrafficDescriptor.setDescription("This identifies the no ATM traffic\ndescriptor type.  Parameters 1, 2, 3, 4,\nand 5 are not used.  This traffic descriptor\ntype can be used for best effort traffic.")
atmNoClpNoScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 2))
if mibBuilder.loadTexts: atmNoClpNoScr.setDescription("This traffic descriptor type is for no CLP\nand no Sustained Cell Rate.  The use of the\nparameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: not used\nParameter 3: not used\nParameter 4: not used\nParameter 5: not used.")
atmClpNoTaggingNoScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 3))
if mibBuilder.loadTexts: atmClpNoTaggingNoScr.setDescription("This traffic descriptor is for CLP without\ntagging and no Sustained Cell Rate.  The use\nof the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: peak cell rate in cells/second\n             for CLP=0 traffic\nParameter 3: not used\nParameter 4: not used\nParameter 5: not used.")
atmClpTaggingNoScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 4))
if mibBuilder.loadTexts: atmClpTaggingNoScr.setDescription("This traffic descriptor is for CLP with\ntagging and no Sustained Cell Rate.  The use\nof the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: peak cell rate in cells/second\n             for CLP=0 traffic, excess\n             tagged as CLP=1\nParameter 3: not used\nParameter 4: not used\nParameter 5: not used.")
atmNoClpScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 5))
if mibBuilder.loadTexts: atmNoClpScr.setDescription("This traffic descriptor type is for no CLP\nwith Sustained Cell Rate.  The use of the\nparameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 3: maximum burst size in cells\nParameter 4: not used\nParameter 5: not used.")
atmClpNoTaggingScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 6))
if mibBuilder.loadTexts: atmClpNoTaggingScr.setDescription("This traffic descriptor type is for CLP with\nSustained Cell Rate and no tagging.  The use\nof the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0 traffic\nParameter 3: maximum burst size in cells\nParameter 4: not used\nParameter 5: not used.")
atmClpTaggingScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 7))
if mibBuilder.loadTexts: atmClpTaggingScr.setDescription("This traffic descriptor type is for CLP with\ntagging and Sustained Cell Rate.  The use of\nthe parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0 traffic, excess tagged as\n             CLP=1\nParameter 3: maximum burst size in cells\nParameter 4: not used\nParameter 5: not used.")
atmClpNoTaggingMcr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 8))
if mibBuilder.loadTexts: atmClpNoTaggingMcr.setDescription("This traffic descriptor type is for CLP with\nMinimum Cell Rate and no tagging.  The use of\nthe parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: CDVT in tenths of microseconds\nParameter 3: minimum cell rate in cells/second\nParameter 4: unused\nParameter 5: unused.")
atmClpTransparentNoScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 9))
if mibBuilder.loadTexts: atmClpTransparentNoScr.setDescription("This traffic descriptor type is for the CLP-\ntransparent model and no Sustained Cell Rate.\nThe use of the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: CDVT in tenths of microseconds\nParameter 3: not used\nParameter 4: not used\nParameter 5: not used.\n\nThis traffic descriptor type is applicable to\nconnections following the CBR.1 conformance\ndefinition.\n\nConnections specifying this traffic descriptor\ntype will be rejected at UNI 3.0 or UNI 3.1\ninterfaces.  For a similar traffic descriptor\ntype that can be accepted at UNI 3.0 and\nUNI 3.1 interfaces, see atmNoClpNoScr.")
atmClpTransparentScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 10))
if mibBuilder.loadTexts: atmClpTransparentScr.setDescription("This traffic descriptor type is for the CLP-\ntransparent model with Sustained Cell Rate.\nThe use of the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 3: maximum burst size in cells\nParameter 4: CDVT in tenths of microseconds\nParameter 5: not used.\n\nThis traffic descriptor type is applicable to\nconnections following the VBR.1 conformance\ndefinition.\nConnections specifying this traffic descriptor\ntype will be rejected at UNI 3.0 or UNI 3.1\ninterfaces.  For a similar traffic descriptor\ntype that can be accepted at UNI 3.0 and\nUNI 3.1 interfaces, see atmNoClpScr.")
atmNoClpTaggingNoScr = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 11))
if mibBuilder.loadTexts: atmNoClpTaggingNoScr.setDescription("This traffic descriptor type is for no CLP\nwith tagging and no Sustained Cell Rate.  The\nuse of the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: CDVT in tenths of microseconds\nParameter 3: not used\nParameter 4: not used\nParameter 5: not used.\n\nThis traffic descriptor type is applicable to\nconnections following the UBR.2 conformance\ndefinition .")
atmNoClpNoScrCdvt = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 12))
if mibBuilder.loadTexts: atmNoClpNoScrCdvt.setDescription("This traffic descriptor type is for no CLP\nand no Sustained Cell Rate.  The use of the\nparameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: CDVT in tenths of microseconds\nParameter 3: not used\nParameter 4: not used\nParameter 5: not used.\n\nThis traffic descriptor type is applicable to\nCBR connections following the UNI 3.0/3.1\nconformance definition for PCR CLP=0+1.\nThese CBR connections differ from CBR.1\nconnections in that the CLR objective\napplies only to the CLP=0 cell flow.\n\nThis traffic descriptor type is also\napplicable to connections following the UBR.1\nconformance definition.")
atmNoClpScrCdvt = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 13))
if mibBuilder.loadTexts: atmNoClpScrCdvt.setDescription("This traffic descriptor type is for no CLP\nwith Sustained Cell Rate.  The use of the\nparameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 3: maximum burst size in cells\nParameter 4: CDVT in tenths of microseconds\nParameter 5: not used.\n\nThis traffic descriptor type is applicable\nto VBR connections following the UNI 3.0/3.1\nconformance definition for PCR CLP=0+1 and\nSCR CLP=0+1.  These VBR connections\ndiffer from VBR.1 connections in that\nthe CLR objective applies only to the CLP=0\ncell flow.")
atmClpNoTaggingScrCdvt = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 14))
if mibBuilder.loadTexts: atmClpNoTaggingScrCdvt.setDescription("This traffic descriptor type is for CLP with\nSustained Cell Rate and no tagging.  The use\nof the parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0 traffic\nParameter 3: maximum burst size in cells\nParameter 4: CDVT in tenths of microseconds\nParameter 5: not used.\n\nThis traffic descriptor type is applicable to\nconnections following the VBR.2 conformance\ndefinition.")
atmClpTaggingScrCdvt = ObjectIdentity((1, 3, 6, 1, 2, 1, 37, 1, 1, 15))
if mibBuilder.loadTexts: atmClpTaggingScrCdvt.setDescription("This traffic descriptor type is for CLP with\ntagging and Sustained Cell Rate.  The use of\nthe parameter vector for this type:\nParameter 1: peak cell rate in cells/second\n             for CLP=0+1 traffic\nParameter 2: sustainable cell rate in cells/second\n             for CLP=0 traffic, excess tagged as\n             CLP=1\nParameter 3: maximum burst size in cells\nParameter 4: CDVT in tenths of microseconds\nParameter 5: not used.\n\nThis traffic descriptor type is applicable to\nconnections following the VBR.3 conformance\ndefinition.")
atmTCMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 37, 3)).setRevisions(("1998-10-19 02:00",))
if mibBuilder.loadTexts: atmTCMIB.setOrganization("IETF AToMMIB Working Group")
if mibBuilder.loadTexts: atmTCMIB.setContactInfo("          Michael Noto\nPostal:  3Com Corporation\n         5400 Bayfront Plaza, M/S 3109\n         Santa Clara, CA 95052\n         USA\nTel:     +1 408 326 2218\nE-mail:  mike_noto@3com.com\n\n         Ethan Mickey Spiegel\nPostal:  Cisco Systems\n         170 W. Tasman Dr.\n         San Jose, CA 95134\n         USA\nTel:     +1 408 526 6408\nE-mail:  mspiegel@cisco.com\n\n         Kaj Tesink\nPostal:  Bellcore\n         331 Newman Springs Road\n         Red Bank, NJ 07701\n         USA\nTel:     +1 732 758 5254\nFax:     +1 732 758 4177\nE-mail:  kaj@bellcore.com")
if mibBuilder.loadTexts: atmTCMIB.setDescription("This MIB Module provides Textual Conventions\nand OBJECT-IDENTITY Objects to be used by\nATM systems.")
atmObjectIdentities = MibIdentifier((1, 3, 6, 1, 2, 1, 37, 3, 1))

# Augmentions

# Exports

# Module identity
mibBuilder.exportSymbols("ATM-TC-MIB", PYSNMP_MODULE_ID=atmTCMIB)

# Types
mibBuilder.exportSymbols("ATM-TC-MIB", AtmAddr=AtmAddr, AtmConnCastType=AtmConnCastType, AtmConnKind=AtmConnKind, AtmIlmiNetworkPrefix=AtmIlmiNetworkPrefix, AtmInterfaceType=AtmInterfaceType, AtmServiceCategory=AtmServiceCategory, AtmSigDescrParamIndex=AtmSigDescrParamIndex, AtmTrafficDescrParamIndex=AtmTrafficDescrParamIndex, AtmVcIdentifier=AtmVcIdentifier, AtmVorXAdminStatus=AtmVorXAdminStatus, AtmVorXLastChange=AtmVorXLastChange, AtmVorXOperStatus=AtmVorXOperStatus, AtmVpIdentifier=AtmVpIdentifier)

# Objects
mibBuilder.exportSymbols("ATM-TC-MIB", atmTrafficDescriptorTypes=atmTrafficDescriptorTypes, atmNoTrafficDescriptor=atmNoTrafficDescriptor, atmNoClpNoScr=atmNoClpNoScr, atmClpNoTaggingNoScr=atmClpNoTaggingNoScr, atmClpTaggingNoScr=atmClpTaggingNoScr, atmNoClpScr=atmNoClpScr, atmClpNoTaggingScr=atmClpNoTaggingScr, atmClpTaggingScr=atmClpTaggingScr, atmClpNoTaggingMcr=atmClpNoTaggingMcr, atmClpTransparentNoScr=atmClpTransparentNoScr, atmClpTransparentScr=atmClpTransparentScr, atmNoClpTaggingNoScr=atmNoClpTaggingNoScr, atmNoClpNoScrCdvt=atmNoClpNoScrCdvt, atmNoClpScrCdvt=atmNoClpScrCdvt, atmClpNoTaggingScrCdvt=atmClpNoTaggingScrCdvt, atmClpTaggingScrCdvt=atmClpTaggingScrCdvt, atmTCMIB=atmTCMIB, atmObjectIdentities=atmObjectIdentities)

