# PySNMP SMI module. Autogenerated from smidump -f python DIAL-CONTROL-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:13 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( InterfaceIndex, InterfaceIndexOrZero, ifIndex, ifOperStatus, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "InterfaceIndexOrZero", "ifIndex", "ifOperStatus")
( transmission, ) = mibBuilder.importSymbols("RFC1213-MIB", "transmission")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32")
( DisplayString, RowStatus, TextualConvention, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowStatus", "TextualConvention", "TimeStamp")

# Types

class AbsoluteCounter32(Unsigned32):
    pass


# Objects

dialControlMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 21)).setRevisions(("1996-09-23 15:44",))
if mibBuilder.loadTexts: dialControlMib.setOrganization("IETF ISDN Working Group")
if mibBuilder.loadTexts: dialControlMib.setContactInfo("        Guenter Roeck\nPostal: cisco Systems\n        170 West Tasman Drive\n        San Jose, CA 95134\n        U.S.A.\nPhone:  +1 408 527 3143\nE-mail: groeck@cisco.com")
if mibBuilder.loadTexts: dialControlMib.setDescription("The MIB module to describe peer information for\ndemand access and possibly other kinds of interfaces.")
dialControlMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 1))
dialCtlConfiguration = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 1, 1))
dialCtlAcceptMode = MibScalar((1, 3, 6, 1, 2, 1, 10, 21, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("acceptNone", 1), ("acceptAll", 2), ("acceptKnown", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dialCtlAcceptMode.setDescription("The security level for acceptance of incoming calls.\nacceptNone(1)  - incoming calls will not be accepted\nacceptAll(2)   - incoming calls will be accepted,\n                 even if there is no matching entry\n                 in the dialCtlPeerCfgTable\nacceptKnown(3) - incoming calls will be accepted only\n                 if there is a matching entry in the\n                 dialCtlPeerCfgTable")
dialCtlTrapEnable = MibScalar((1, 3, 6, 1, 2, 1, 10, 21, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dialCtlTrapEnable.setDescription("This object indicates whether dialCtlPeerCallInformation\nand dialCtlPeerCallSetup traps should be generated for\nall peers. If the value of this object is enabled(1),\ntraps will be generated for all peers. If the value\nof this object is disabled(2), traps will be generated\nonly for peers having dialCtlPeerCfgTrapEnable set\nto enabled(1).")
dialCtlPeer = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 1, 2))
dialCtlPeerCfgTable = MibTable((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1))
if mibBuilder.loadTexts: dialCtlPeerCfgTable.setDescription("The list of peers from which the managed device\nwill accept calls or to which it will place them.")
dialCtlPeerCfgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1)).setIndexNames((0, "DIAL-CONTROL-MIB", "dialCtlPeerCfgId"), (0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dialCtlPeerCfgEntry.setDescription("Configuration data for a single Peer. This entry is\neffectively permanent, and contains information\nto identify the peer, how to connect to the peer,\nhow to identify the peer and its permissions.\nThe value of dialCtlPeerCfgOriginateAddress must be\nspecified before a new row in this table can become\nactive(1). Any writeable parameters in an existing entry\ncan be modified while the entry is active. The modification\nwill take effect when the peer in question will be\ncalled the next time.\nAn entry in this table can only be created if the\nassociated ifEntry already exists.")
dialCtlPeerCfgId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dialCtlPeerCfgId.setDescription("This object identifies a single peer. There may\nbe several entries in this table for one peer,\ndefining different ways of reaching this peer.\nThus, there may be several entries in this table\nwith the same value of dialCtlPeerCfgId.\nMultiple entries for one peer may be used to support\nmultilink as well as backup lines.\nA single peer will be identified by a unique value\nof this object. Several entries for one peer MUST\nhave the same value of dialCtlPeerCfgId, but different\nifEntries and thus different values of ifIndex.")
dialCtlPeerCfgIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 2), IANAifType().clone('other')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgIfType.setDescription("The interface type to be used for calling this peer.\nIn case of ISDN, the value of isdn(63) is to be used.")
dialCtlPeerCfgLowerIf = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 3), InterfaceIndexOrZero().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgLowerIf.setDescription("ifIndex value of an interface the peer will have to be\ncalled on. For example, on an ISDN interface, this can be\nthe ifIndex value of a D channel or the ifIndex value of a\nB channel, whatever is appropriate for a given peer.\nAs an example, for Basic Rate leased lines it will be\nnecessary to specify a B channel ifIndex, while for\nsemi-permanent connections the D channel ifIndex has\nto be specified.\nIf the interface can be dynamically assigned, this object\nhas a value of zero.")
dialCtlPeerCfgOriginateAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 4), DisplayString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgOriginateAddress.setDescription("Call Address at which the peer will be called.\nThink of this as the set of characters following 'ATDT '\nor the 'phone number' included in a D channel call request.\n\nThe structure of this information will be switch type\nspecific. If there is no address information required\nfor reaching the peer, i.e., for leased lines,\nthis object will be a zero length string.")
dialCtlPeerCfgAnswerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 5), DisplayString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgAnswerAddress.setDescription("Calling Party Number information element, as for example\npassed in an ISDN SETUP message by a PBX or switch,\nfor incoming calls.\nThis address can be used to identify the peer.\nIf this address is either unknown or identical\nto dialCtlPeerCfgOriginateAddress, this object will be\na zero length string.")
dialCtlPeerCfgSubAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 6), DisplayString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgSubAddress.setDescription("Subaddress at which the peer will be called.\nIf the subaddress is undefined for the given media or\nunused, this is a zero length string.")
dialCtlPeerCfgClosedUserGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 7), DisplayString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgClosedUserGroup.setDescription("Closed User Group at which the peer will be called.\nIf the Closed User Group is undefined for the given media\nor unused, this is a zero length string.")
dialCtlPeerCfgSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgSpeed.setDescription("The desired information transfer speed in bits/second\nwhen calling this peer.\nThe detailed media specific information, e.g. information\ntype and information transfer rate for ISDN circuits,\nhas to be extracted from this object.\nIf the transfer speed to be used is unknown or the default\nspeed for this type of interfaces, the value of this object\nmay be zero.")
dialCtlPeerCfgInfoType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10,7,8,3,4,5,6,1,2,9,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("fax", 10), ("speech", 2), ("unrestrictedDigital", 3), ("unrestrictedDigital56", 4), ("restrictedDigital", 5), ("audio31", 6), ("audio7", 7), ("video", 8), ("packetSwitched", 9), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgInfoType.setDescription("The Information Transfer Capability to be used when\ncalling this peer.\n\nspeech(2) refers to a non-data connection, whereas\naudio31(6) and audio7(7) refer to data mode\nconnections.")
dialCtlPeerCfgPermission = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,5,1,4,2,)).subtype(namedValues=namedval.NamedValues(("originate", 1), ("answer", 2), ("both", 3), ("callback", 4), ("none", 5), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgPermission.setDescription("Applicable permissions. callback(4) either rejects the\ncall and then calls back, or uses the 'Reverse charging'\ninformation element if it is available.\nNote that callback(4) is supposed to control charging, not\nsecurity, and applies to callback prior to accepting a\ncall. Callback for security reasons can be handled using\nPPP callback.")
dialCtlPeerCfgInactivityTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgInactivityTimer.setDescription("The connection will be automatically disconnected\nif no longer carrying useful data for a time\nperiod, in seconds, specified in this object.\nUseful data in this context refers to forwarding\npackets, including routing information; it\nexcludes the encapsulator maintenance frames.\nA value of zero means the connection will not be\nautomatically taken down due to inactivity,\nwhich implies that it is a dedicated circuit.")
dialCtlPeerCfgMinDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgMinDuration.setDescription("Minimum duration of a call in seconds, starting from the\ntime the call is connected until the call is disconnected.\nThis is to accomplish the fact that in most countries\ncharging applies to units of time, which should be matched\nas closely as possible.")
dialCtlPeerCfgMaxDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgMaxDuration.setDescription("Maximum call duration in seconds. Zero means 'unlimited'.")
dialCtlPeerCfgCarrierDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgCarrierDelay.setDescription("The call timeout time in seconds. The default value\nof zero means that the call timeout as specified for\nthe media in question will apply.")
dialCtlPeerCfgCallRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgCallRetries.setDescription("The number of calls to a non-responding address\nthat may be made. A retry count of zero means\nthere is no bound. The intent is to bound\nthe number of successive calls to an address\nwhich is inaccessible, or which refuses those calls.\n\nSome countries regulate the number of call retries\nto a given peer that can be made.")
dialCtlPeerCfgRetryDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgRetryDelay.setDescription("The time in seconds between call retries if a peer\ncannot be reached.\nA value of zero means that call retries may be done\nwithout any delay.")
dialCtlPeerCfgFailureDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 17), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgFailureDelay.setDescription("The time in seconds after which call attempts are\nto be placed again after a peer has been noticed\nto be unreachable, i.e. after dialCtlPeerCfgCallRetries\nunsuccessful call attempts.\nA value of zero means that a peer will not be called\nagain after dialCtlPeerCfgCallRetries unsuccessful call\nattempts.")
dialCtlPeerCfgTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 18), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgTrapEnable.setDescription("This object indicates whether dialCtlPeerCallInformation\nand dialCtlPeerCallSetup traps should be generated for\nthis peer.")
dialCtlPeerCfgStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 1, 1, 19), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dialCtlPeerCfgStatus.setDescription("Status of one row in this table.")
dialCtlPeerStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2))
if mibBuilder.loadTexts: dialCtlPeerStatsTable.setDescription("Statistics information for each peer entry.\nThere will be one entry in this table for each entry\nin the dialCtlPeerCfgTable.")
dialCtlPeerStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1))
if mibBuilder.loadTexts: dialCtlPeerStatsEntry.setDescription("Statistics information for a single Peer. This entry\nis effectively permanent, and contains information\ndescribing the last call attempt as well as supplying\nstatistical information.")
dialCtlPeerStatsConnectTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 1), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsConnectTime.setDescription("Accumulated connect time to the peer since system startup.\nThis is the total connect time, i.e. the connect time\nfor outgoing calls plus the time for incoming calls.")
dialCtlPeerStatsChargedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 2), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsChargedUnits.setDescription("The total number of charging units applying to this\npeer since system startup.\nOnly the charging units applying to the local interface,\ni.e. for originated calls or for calls with 'Reverse\ncharging' being active, will be counted here.")
dialCtlPeerStatsSuccessCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 3), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsSuccessCalls.setDescription("Number of completed calls to this peer.")
dialCtlPeerStatsFailCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 4), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsFailCalls.setDescription("Number of failed call attempts to this peer since system\nstartup.")
dialCtlPeerStatsAcceptCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 5), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsAcceptCalls.setDescription("Number of calls from this peer accepted since system\nstartup.")
dialCtlPeerStatsRefuseCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 6), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsRefuseCalls.setDescription("Number of calls from this peer refused since system\nstartup.")
dialCtlPeerStatsLastDisconnectCause = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 7), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 4))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsLastDisconnectCause.setDescription("The encoded network cause value associated with the last\ncall.\nThis object will be updated whenever a call is started\nor cleared.\nThe value of this object will depend on the interface type\nas well as on the protocol and protocol version being\nused on this interface. Some references for possible cause\nvalues are given below.")
dialCtlPeerStatsLastDisconnectText = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 8), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsLastDisconnectText.setDescription("ASCII text describing the reason for the last call\ntermination.\nThis object exists because it would be impossible for\na management station to store all possible cause values\nfor all types of interfaces. It should be used only if\na management station is unable to decode the value of\ndialCtlPeerStatsLastDisconnectCause.\n\nThis object will be updated whenever a call is started\nor cleared.")
dialCtlPeerStatsLastSetupTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 2, 2, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dialCtlPeerStatsLastSetupTime.setDescription("The value of sysUpTime when the last call to this peer\nwas started.\nFor ISDN media, this will be the time when the setup\nmessage was received from or sent to the network.\nThis object will be updated whenever a call is started\nor cleared.")
callActive = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 1, 3))
callActiveTable = MibTable((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1))
if mibBuilder.loadTexts: callActiveTable.setDescription("A table containing information about active\ncalls to a specific destination.")
callActiveEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1)).setIndexNames((0, "DIAL-CONTROL-MIB", "callActiveSetupTime"), (0, "DIAL-CONTROL-MIB", "callActiveIndex"))
if mibBuilder.loadTexts: callActiveEntry.setDescription("The information regarding a single active Connection.\nAn entry in this table will be created when a call is\nstarted. An entry in this table will be deleted when\nan active call clears.")
callActiveSetupTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 1), TimeStamp()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: callActiveSetupTime.setDescription("The value of sysUpTime when the call associated to this\nentry was started. This will be useful for an NMS to\nretrieve all calls after a specific time. Also, this object\ncan be useful in finding large delays between the time the\ncall was started and the time the call was connected.\nFor ISDN media, this will be the time when the setup\nmessage was received from or sent to the network.")
callActiveIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: callActiveIndex.setDescription("Small index variable to distinguish calls that start in\nthe same hundredth of a second.")
callActivePeerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActivePeerAddress.setDescription("The number this call is connected to. If the number is\nnot available, then it will have a length of zero.")
callActivePeerSubAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 4), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActivePeerSubAddress.setDescription("The subaddress this call is connected to. If the subaddress\nis undefined or not available, this will be a zero length\nstring.")
callActivePeerId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActivePeerId.setDescription("This is the Id value of the peer table entry\nto which this call was made. If a peer table entry\nfor this call does not exist or is unknown, the value\nof this object will be zero.")
callActivePeerIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActivePeerIfIndex.setDescription("This is the ifIndex value of the peer table entry\nto which this call was made. If a peer table entry\nfor this call does not exist or is unknown, the value\nof this object will be zero.")
callActiveLogicalIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 7), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveLogicalIfIndex.setDescription("This is the ifIndex value of the logical interface through\nwhich this call was made. For ISDN media, this would be\nthe ifIndex of the B channel which was used for this call.\nIf the ifIndex value is unknown, the value of this object\nwill be zero.")
callActiveConnectTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveConnectTime.setDescription("The value of sysUpTime when the call was connected.\nIf the call is not connected, this object will have a\nvalue of zero.")
callActiveCallState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,3,2,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("connecting", 2), ("connected", 3), ("active", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveCallState.setDescription("The current call state.\nunknown(1)     - The call state is unknown.\nconnecting(2)  - A connection attempt (outgoing call)\n                 is being made.\nconnected(3)   - An incoming call is in the process\n                 of validation.\nactive(4)      - The call is active.")
callActiveCallOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("originate", 1), ("answer", 2), ("callback", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveCallOrigin.setDescription("The call origin.")
callActiveChargedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 11), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveChargedUnits.setDescription("The number of charged units for this connection.\nFor incoming calls or if charging information is\nnot supplied by the switch, the value of this object\nwill be zero.")
callActiveInfoType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10,7,8,3,4,5,6,1,2,9,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("fax", 10), ("speech", 2), ("unrestrictedDigital", 3), ("unrestrictedDigital56", 4), ("restrictedDigital", 5), ("audio31", 6), ("audio7", 7), ("video", 8), ("packetSwitched", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveInfoType.setDescription("The information type for this call.")
callActiveTransmitPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 13), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveTransmitPackets.setDescription("The number of packets which were transmitted for this\ncall.")
callActiveTransmitBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 14), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveTransmitBytes.setDescription("The number of bytes which were transmitted for this\ncall.")
callActiveReceivePackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 15), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveReceivePackets.setDescription("The number of packets which were received for this\ncall.")
callActiveReceiveBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 3, 1, 1, 16), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callActiveReceiveBytes.setDescription("The number of bytes which were received for this call.")
callHistory = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 1, 4))
callHistoryTableMaxLength = MibScalar((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: callHistoryTableMaxLength.setDescription("The upper limit on the number of entries that the\ncallHistoryTable may contain.  A value of 0\nwill prevent any history from being retained. When\nthis table is full, the oldest entry will be deleted\nand the new one will be created.")
callHistoryRetainTimer = MibScalar((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite").setUnits("minutes")
if mibBuilder.loadTexts: callHistoryRetainTimer.setDescription("The minimum amount of time that an callHistoryEntry\nwill be maintained before being deleted. A value of\n0 will prevent any history from being retained in the\ncallHistoryTable, but will neither prevent callCompletion\ntraps being generated nor affect other tables.")
callHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3))
if mibBuilder.loadTexts: callHistoryTable.setDescription("A table containing information about specific\ncalls to a specific destination.")
callHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1)).setIndexNames((0, "DIAL-CONTROL-MIB", "callActiveSetupTime"), (0, "DIAL-CONTROL-MIB", "callActiveIndex"))
if mibBuilder.loadTexts: callHistoryEntry.setDescription("The information regarding a single Connection.")
callHistoryPeerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 1), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryPeerAddress.setDescription("The number this call was connected to. If the number is\nnot available, then it will have a length of zero.")
callHistoryPeerSubAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 2), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryPeerSubAddress.setDescription("The subaddress this call was connected to. If the subaddress\nis undefined or not available, this will be a zero length\nstring.")
callHistoryPeerId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryPeerId.setDescription("This is the Id value of the peer table entry\nto which this call was made. If a peer table entry\nfor this call does not exist, the value of this object\nwill be zero.")
callHistoryPeerIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryPeerIfIndex.setDescription("This is the ifIndex value of the peer table entry\nto which this call was made. If a peer table entry\nfor this call does not exist, the value of this object\nwill be zero.")
callHistoryLogicalIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 5), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryLogicalIfIndex.setDescription("This is the ifIndex value of the logical interface through\nwhich this call was made. For ISDN media, this would be\nthe ifIndex of the B channel which was used for this call.")
callHistoryDisconnectCause = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 6), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 4))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryDisconnectCause.setDescription("The encoded network cause value associated with this call.\n\nThe value of this object will depend on the interface type\nas well as on the protocol and protocol version being\nused on this interface. Some references for possible cause\nvalues are given below.")
callHistoryDisconnectText = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 7), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryDisconnectText.setDescription("ASCII text describing the reason for call termination.\n\nThis object exists because it would be impossible for\na management station to store all possible cause values\nfor all types of interfaces. It should be used only if\na management station is unable to decode the value of\ndialCtlPeerStatsLastDisconnectCause.")
callHistoryConnectTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryConnectTime.setDescription("The value of sysUpTime when the call was connected.")
callHistoryDisconnectTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryDisconnectTime.setDescription("The value of sysUpTime when the call was disconnected.")
callHistoryCallOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("originate", 1), ("answer", 2), ("callback", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryCallOrigin.setDescription("The call origin.")
callHistoryChargedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 11), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryChargedUnits.setDescription("The number of charged units for this connection.\nFor incoming calls or if charging information is\nnot supplied by the switch, the value of this object\nwill be zero.")
callHistoryInfoType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10,7,8,3,4,5,6,1,2,9,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("fax", 10), ("speech", 2), ("unrestrictedDigital", 3), ("unrestrictedDigital56", 4), ("restrictedDigital", 5), ("audio31", 6), ("audio7", 7), ("video", 8), ("packetSwitched", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryInfoType.setDescription("The information type for this call.")
callHistoryTransmitPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 13), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryTransmitPackets.setDescription("The number of packets which were transmitted while this\ncall was active.")
callHistoryTransmitBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 14), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryTransmitBytes.setDescription("The number of bytes which were transmitted while this\ncall was active.")
callHistoryReceivePackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 15), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryReceivePackets.setDescription("The number of packets which were received while this\ncall was active.")
callHistoryReceiveBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 21, 1, 4, 3, 1, 16), AbsoluteCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: callHistoryReceiveBytes.setDescription("The number of bytes which were received while this\ncall was active.")
dialControlMibTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 2))
dialControlMibTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 2, 0))
dialControlMibConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 3))
dialControlMibCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 3, 1))
dialControlMibGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 21, 3, 2))

# Augmentions
dialCtlPeerCfgEntry.registerAugmentions(("DIAL-CONTROL-MIB", "dialCtlPeerStatsEntry"))
dialCtlPeerStatsEntry.setIndexNames(*dialCtlPeerCfgEntry.getIndexNames())

# Notifications

dialCtlPeerCallInformation = NotificationType((1, 3, 6, 1, 2, 1, 10, 21, 2, 0, 1)).setObjects(("DIAL-CONTROL-MIB", "callHistoryDisconnectCause"), ("DIAL-CONTROL-MIB", "callHistoryPeerSubAddress"), ("DIAL-CONTROL-MIB", "callHistoryLogicalIfIndex"), ("DIAL-CONTROL-MIB", "callHistoryCallOrigin"), ("DIAL-CONTROL-MIB", "callHistoryPeerIfIndex"), ("DIAL-CONTROL-MIB", "callHistoryPeerAddress"), ("DIAL-CONTROL-MIB", "callHistoryDisconnectTime"), ("DIAL-CONTROL-MIB", "callHistoryPeerId"), ("DIAL-CONTROL-MIB", "callHistoryInfoType"), ("DIAL-CONTROL-MIB", "callHistoryConnectTime"), ("IF-MIB", "ifOperStatus"), )
if mibBuilder.loadTexts: dialCtlPeerCallInformation.setDescription("This trap/inform is sent to the manager whenever\na successful call clears, or a failed call attempt\nis determined to have ultimately failed. In the\nevent that call retry is active, then this is after\nall retry attempts have failed. However, only one such\ntrap is sent in between successful call attempts;\nsubsequent call attempts result in no trap.\nifOperStatus will return the operational status of the\nvirtual interface associated with the peer to whom\nthis call was made to.")
dialCtlPeerCallSetup = NotificationType((1, 3, 6, 1, 2, 1, 10, 21, 2, 0, 2)).setObjects(("DIAL-CONTROL-MIB", "callActivePeerSubAddress"), ("DIAL-CONTROL-MIB", "callActivePeerAddress"), ("DIAL-CONTROL-MIB", "callActivePeerIfIndex"), ("DIAL-CONTROL-MIB", "callActiveLogicalIfIndex"), ("DIAL-CONTROL-MIB", "callActiveInfoType"), ("DIAL-CONTROL-MIB", "callActiveCallOrigin"), ("DIAL-CONTROL-MIB", "callActivePeerId"), ("IF-MIB", "ifOperStatus"), )
if mibBuilder.loadTexts: dialCtlPeerCallSetup.setDescription("This trap/inform is sent to the manager whenever\na call setup message is received or sent.\nifOperStatus will return the operational status of the\nvirtual interface associated with the peer to whom\nthis call was made to.")

# Groups

dialControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 21, 3, 2, 1)).setObjects(("DIAL-CONTROL-MIB", "dialCtlPeerCfgIfType"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgPermission"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgClosedUserGroup"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgCarrierDelay"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgLowerIf"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgOriginateAddress"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgRetryDelay"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsLastDisconnectText"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgMaxDuration"), ("DIAL-CONTROL-MIB", "dialCtlTrapEnable"), ("DIAL-CONTROL-MIB", "dialCtlAcceptMode"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsConnectTime"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsAcceptCalls"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgSpeed"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsSuccessCalls"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsRefuseCalls"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgCallRetries"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsChargedUnits"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgStatus"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsLastSetupTime"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgMinDuration"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgSubAddress"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgAnswerAddress"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsFailCalls"), ("DIAL-CONTROL-MIB", "dialCtlPeerStatsLastDisconnectCause"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgInactivityTimer"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgTrapEnable"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgFailureDelay"), ("DIAL-CONTROL-MIB", "dialCtlPeerCfgInfoType"), )
if mibBuilder.loadTexts: dialControlGroup.setDescription("A collection of objects providing the DIAL CONTROL\ncapability.")
callActiveGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 21, 3, 2, 2)).setObjects(("DIAL-CONTROL-MIB", "callActiveReceivePackets"), ("DIAL-CONTROL-MIB", "callActivePeerAddress"), ("DIAL-CONTROL-MIB", "callActivePeerId"), ("DIAL-CONTROL-MIB", "callActivePeerSubAddress"), ("DIAL-CONTROL-MIB", "callActivePeerIfIndex"), ("DIAL-CONTROL-MIB", "callActiveTransmitBytes"), ("DIAL-CONTROL-MIB", "callActiveInfoType"), ("DIAL-CONTROL-MIB", "callActiveConnectTime"), ("DIAL-CONTROL-MIB", "callActiveCallState"), ("DIAL-CONTROL-MIB", "callActiveReceiveBytes"), ("DIAL-CONTROL-MIB", "callActiveTransmitPackets"), ("DIAL-CONTROL-MIB", "callActiveLogicalIfIndex"), ("DIAL-CONTROL-MIB", "callActiveChargedUnits"), ("DIAL-CONTROL-MIB", "callActiveCallOrigin"), )
if mibBuilder.loadTexts: callActiveGroup.setDescription("A collection of objects providing the active call\ncapability.")
callHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 21, 3, 2, 3)).setObjects(("DIAL-CONTROL-MIB", "callHistoryReceiveBytes"), ("DIAL-CONTROL-MIB", "callHistoryDisconnectCause"), ("DIAL-CONTROL-MIB", "callHistoryCallOrigin"), ("DIAL-CONTROL-MIB", "callHistoryReceivePackets"), ("DIAL-CONTROL-MIB", "callHistoryLogicalIfIndex"), ("DIAL-CONTROL-MIB", "callHistoryInfoType"), ("DIAL-CONTROL-MIB", "callHistoryTransmitPackets"), ("DIAL-CONTROL-MIB", "callHistoryDisconnectText"), ("DIAL-CONTROL-MIB", "callHistoryPeerSubAddress"), ("DIAL-CONTROL-MIB", "callHistoryPeerIfIndex"), ("DIAL-CONTROL-MIB", "callHistoryRetainTimer"), ("DIAL-CONTROL-MIB", "callHistoryPeerAddress"), ("DIAL-CONTROL-MIB", "callHistoryTableMaxLength"), ("DIAL-CONTROL-MIB", "callHistoryTransmitBytes"), ("DIAL-CONTROL-MIB", "callHistoryDisconnectTime"), ("DIAL-CONTROL-MIB", "callHistoryPeerId"), ("DIAL-CONTROL-MIB", "callHistoryConnectTime"), ("DIAL-CONTROL-MIB", "callHistoryChargedUnits"), )
if mibBuilder.loadTexts: callHistoryGroup.setDescription("A collection of objects providing the Call History\ncapability.")
callNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 21, 3, 2, 4)).setObjects(("DIAL-CONTROL-MIB", "dialCtlPeerCallSetup"), ("DIAL-CONTROL-MIB", "dialCtlPeerCallInformation"), )
if mibBuilder.loadTexts: callNotificationsGroup.setDescription("The notifications which a Dial Control MIB entity is\nrequired to implement.")

# Compliances

dialControlMibCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 21, 3, 1, 1)).setObjects(("DIAL-CONTROL-MIB", "callActiveGroup"), ("DIAL-CONTROL-MIB", "callHistoryGroup"), ("DIAL-CONTROL-MIB", "dialControlGroup"), ("DIAL-CONTROL-MIB", "callNotificationsGroup"), )
if mibBuilder.loadTexts: dialControlMibCompliance.setDescription("The compliance statement for entities which\nimplement the DIAL CONTROL MIB")

# Exports

# Module identity
mibBuilder.exportSymbols("DIAL-CONTROL-MIB", PYSNMP_MODULE_ID=dialControlMib)

# Types
mibBuilder.exportSymbols("DIAL-CONTROL-MIB", AbsoluteCounter32=AbsoluteCounter32)

# Objects
mibBuilder.exportSymbols("DIAL-CONTROL-MIB", dialControlMib=dialControlMib, dialControlMibObjects=dialControlMibObjects, dialCtlConfiguration=dialCtlConfiguration, dialCtlAcceptMode=dialCtlAcceptMode, dialCtlTrapEnable=dialCtlTrapEnable, dialCtlPeer=dialCtlPeer, dialCtlPeerCfgTable=dialCtlPeerCfgTable, dialCtlPeerCfgEntry=dialCtlPeerCfgEntry, dialCtlPeerCfgId=dialCtlPeerCfgId, dialCtlPeerCfgIfType=dialCtlPeerCfgIfType, dialCtlPeerCfgLowerIf=dialCtlPeerCfgLowerIf, dialCtlPeerCfgOriginateAddress=dialCtlPeerCfgOriginateAddress, dialCtlPeerCfgAnswerAddress=dialCtlPeerCfgAnswerAddress, dialCtlPeerCfgSubAddress=dialCtlPeerCfgSubAddress, dialCtlPeerCfgClosedUserGroup=dialCtlPeerCfgClosedUserGroup, dialCtlPeerCfgSpeed=dialCtlPeerCfgSpeed, dialCtlPeerCfgInfoType=dialCtlPeerCfgInfoType, dialCtlPeerCfgPermission=dialCtlPeerCfgPermission, dialCtlPeerCfgInactivityTimer=dialCtlPeerCfgInactivityTimer, dialCtlPeerCfgMinDuration=dialCtlPeerCfgMinDuration, dialCtlPeerCfgMaxDuration=dialCtlPeerCfgMaxDuration, dialCtlPeerCfgCarrierDelay=dialCtlPeerCfgCarrierDelay, dialCtlPeerCfgCallRetries=dialCtlPeerCfgCallRetries, dialCtlPeerCfgRetryDelay=dialCtlPeerCfgRetryDelay, dialCtlPeerCfgFailureDelay=dialCtlPeerCfgFailureDelay, dialCtlPeerCfgTrapEnable=dialCtlPeerCfgTrapEnable, dialCtlPeerCfgStatus=dialCtlPeerCfgStatus, dialCtlPeerStatsTable=dialCtlPeerStatsTable, dialCtlPeerStatsEntry=dialCtlPeerStatsEntry, dialCtlPeerStatsConnectTime=dialCtlPeerStatsConnectTime, dialCtlPeerStatsChargedUnits=dialCtlPeerStatsChargedUnits, dialCtlPeerStatsSuccessCalls=dialCtlPeerStatsSuccessCalls, dialCtlPeerStatsFailCalls=dialCtlPeerStatsFailCalls, dialCtlPeerStatsAcceptCalls=dialCtlPeerStatsAcceptCalls, dialCtlPeerStatsRefuseCalls=dialCtlPeerStatsRefuseCalls, dialCtlPeerStatsLastDisconnectCause=dialCtlPeerStatsLastDisconnectCause, dialCtlPeerStatsLastDisconnectText=dialCtlPeerStatsLastDisconnectText, dialCtlPeerStatsLastSetupTime=dialCtlPeerStatsLastSetupTime, callActive=callActive, callActiveTable=callActiveTable, callActiveEntry=callActiveEntry, callActiveSetupTime=callActiveSetupTime, callActiveIndex=callActiveIndex, callActivePeerAddress=callActivePeerAddress, callActivePeerSubAddress=callActivePeerSubAddress, callActivePeerId=callActivePeerId, callActivePeerIfIndex=callActivePeerIfIndex, callActiveLogicalIfIndex=callActiveLogicalIfIndex, callActiveConnectTime=callActiveConnectTime, callActiveCallState=callActiveCallState, callActiveCallOrigin=callActiveCallOrigin, callActiveChargedUnits=callActiveChargedUnits, callActiveInfoType=callActiveInfoType, callActiveTransmitPackets=callActiveTransmitPackets, callActiveTransmitBytes=callActiveTransmitBytes, callActiveReceivePackets=callActiveReceivePackets, callActiveReceiveBytes=callActiveReceiveBytes, callHistory=callHistory, callHistoryTableMaxLength=callHistoryTableMaxLength, callHistoryRetainTimer=callHistoryRetainTimer, callHistoryTable=callHistoryTable, callHistoryEntry=callHistoryEntry, callHistoryPeerAddress=callHistoryPeerAddress, callHistoryPeerSubAddress=callHistoryPeerSubAddress, callHistoryPeerId=callHistoryPeerId, callHistoryPeerIfIndex=callHistoryPeerIfIndex, callHistoryLogicalIfIndex=callHistoryLogicalIfIndex, callHistoryDisconnectCause=callHistoryDisconnectCause, callHistoryDisconnectText=callHistoryDisconnectText, callHistoryConnectTime=callHistoryConnectTime, callHistoryDisconnectTime=callHistoryDisconnectTime, callHistoryCallOrigin=callHistoryCallOrigin, callHistoryChargedUnits=callHistoryChargedUnits, callHistoryInfoType=callHistoryInfoType, callHistoryTransmitPackets=callHistoryTransmitPackets, callHistoryTransmitBytes=callHistoryTransmitBytes, callHistoryReceivePackets=callHistoryReceivePackets, callHistoryReceiveBytes=callHistoryReceiveBytes, dialControlMibTrapPrefix=dialControlMibTrapPrefix, dialControlMibTraps=dialControlMibTraps, dialControlMibConformance=dialControlMibConformance, dialControlMibCompliances=dialControlMibCompliances, dialControlMibGroups=dialControlMibGroups)

# Notifications
mibBuilder.exportSymbols("DIAL-CONTROL-MIB", dialCtlPeerCallInformation=dialCtlPeerCallInformation, dialCtlPeerCallSetup=dialCtlPeerCallSetup)

# Groups
mibBuilder.exportSymbols("DIAL-CONTROL-MIB", dialControlGroup=dialControlGroup, callActiveGroup=callActiveGroup, callHistoryGroup=callHistoryGroup, callNotificationsGroup=callNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("DIAL-CONTROL-MIB", dialControlMibCompliance=dialControlMibCompliance)
