# PySNMP SMI module. Autogenerated from smidump -f python DIFFSERV-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:14 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( Dscp, DscpOrAny, ) = mibBuilder.importSymbols("DIFFSERV-DSCP-TC", "Dscp", "DscpOrAny")
( InterfaceIndexOrZero, ifCounterDiscontinuityGroup, ifCounterDiscontinuityGroup, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifCounterDiscontinuityGroup", "ifCounterDiscontinuityGroup", "ifIndex")
( InetAddress, InetAddressPrefixLength, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressPrefixLength", "InetAddressType", "InetPortNumber")
( BurstSize, ) = mibBuilder.importSymbols("INTEGRATED-SERVICES-MIB", "BurstSize")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter64, Integer32, ModuleIdentity, MibIdentifier, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, zeroDotZero, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter64", "Integer32", "ModuleIdentity", "MibIdentifier", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2", "zeroDotZero")
( AutonomousType, RowPointer, RowStatus, StorageType, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "RowPointer", "RowStatus", "StorageType", "TextualConvention")

# Types

class IfDirection(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,)
    namedValues = namedval.NamedValues(("inbound", 1), ("outbound", 2), )
    
class IndexInteger(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(1,4294967295)
    
class IndexIntegerNextFree(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,4294967295)
    

# Objects

diffServMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 97)).setRevisions(("2002-02-07 00:00",))
if mibBuilder.loadTexts: diffServMib.setOrganization("IETF Differentiated Services WG")
if mibBuilder.loadTexts: diffServMib.setContactInfo("       Fred Baker\nCisco Systems\n1121 Via Del Rey\nSanta Barbara, CA 93117, USA\nE-mail: fred@cisco.com\n\nKwok Ho Chan\nNortel Networks\n600 Technology Park Drive\nBillerica, MA 01821, USA\nE-mail: khchan@nortelnetworks.com\n\nAndrew Smith\nHarbour Networks\nJiuling Building\n\n\n21 North Xisanhuan Ave.\nBeijing, 100089, PRC\nE-mail: ah_smith@acm.org\n\nDifferentiated Services Working Group:\ndiffserv@ietf.org")
if mibBuilder.loadTexts: diffServMib.setDescription("This MIB defines the objects necessary to manage a device that\nuses the Differentiated Services Architecture described in RFC\n2475. The Conceptual Model of a Differentiated Services Router\nprovides supporting information on how such a router is modeled.")
diffServMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1))
diffServDataPath = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 1))
diffServDataPathTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 1, 1))
if mibBuilder.loadTexts: diffServDataPathTable.setDescription("The data path table contains RowPointers indicating the start of\nthe functional data path for each interface and traffic direction\nin this device. These may merge, or be separated into parallel\ndata paths.")
diffServDataPathEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DIFFSERV-MIB", "diffServDataPathIfDirection"))
if mibBuilder.loadTexts: diffServDataPathEntry.setDescription("An entry in the data path table indicates the start of a single\nDifferentiated Services Functional Data Path in this device.\n\nThese are associated with individual interfaces, logical or\nphysical, and therefore are instantiated by ifIndex. Therefore,\nthe interface index must have been assigned, according to the\nprocedures applicable to that, before it can be meaningfully\nused. Generally, this means that the interface must exist.\n\nWhen diffServDataPathStorage is of type nonVolatile, however,\nthis may reflect the configuration for an interface whose ifIndex\nhas been assigned but for which the supporting implementation is\nnot currently present.")
diffServDataPathIfDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 1, 1, 1, 1), IfDirection()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServDataPathIfDirection.setDescription("IfDirection specifies whether the reception or transmission path\nfor this interface is in view.")
diffServDataPathStart = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 1, 1, 1, 2), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServDataPathStart.setDescription("This selects the first Differentiated Services Functional Data\nPath Element to handle traffic for this data path. This\nRowPointer should point to an instance of one of:\n  diffServClfrEntry\n  diffServMeterEntry\n  diffServActionEntry\n  diffServAlgDropEntry\n  diffServQEntry\n\nA value of zeroDotZero in this attribute indicates that no\nDifferentiated Services treatment is performed on traffic of this\ndata path. A pointer with the value zeroDotZero normally\nterminates a functional data path.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServDataPathStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 1, 1, 1, 3), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServDataPathStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServDataPathStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 1, 1, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServDataPathStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time.")
diffServClassifier = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 2))
diffServClfrNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 2, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServClfrNextFree.setDescription("This object contains an unused value for diffServClfrId, or a\nzero to indicate that none exist.")
diffServClfrTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 2, 2))
if mibBuilder.loadTexts: diffServClfrTable.setDescription("This table enumerates all the diffserv classifier functional\ndata path elements of this device.  The actual classification\ndefinitions are defined in diffServClfrElementTable entries\nbelonging to each classifier.\n\nAn entry in this table, pointed to by a RowPointer specifying an\ninstance of diffServClfrStatus, is frequently used as the name\nfor a set of classifier elements, which all use the index\ndiffServClfrId. Per the semantics of the classifier element\ntable, these entries constitute one or more unordered sets of\ntests which may be simultaneously applied to a message to\n\n\n\nclassify it.\n\nThe primary function of this table is to ensure that the value of\ndiffServClfrId is unique before attempting to use it in creating\na diffServClfrElementEntry. Therefore, the diffServClfrEntry must\nbe created on the same SET as the diffServClfrElementEntry, or\nbefore the diffServClfrElementEntry is created.")
diffServClfrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 2, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServClfrId"))
if mibBuilder.loadTexts: diffServClfrEntry.setDescription("An entry in the classifier table describes a single classifier.\nAll classifier elements belonging to the same classifier use the\nclassifier's diffServClfrId as part of their index.")
diffServClfrId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServClfrId.setDescription("An index that enumerates the classifier entries.  Managers\nshould obtain new values for row creation in this table by\nreading diffServClfrNextFree.")
diffServClfrStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 2, 1, 2), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServClfrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServClfrElementNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 2, 3), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServClfrElementNextFree.setDescription("This object contains an unused value for diffServClfrElementId,\nor a zero to indicate that none exist.")
diffServClfrElementTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 2, 4))
if mibBuilder.loadTexts: diffServClfrElementTable.setDescription("The classifier element table enumerates the relationship between\nclassification patterns and subsequent downstream Differentiated\nServices Functional Data Path elements.\ndiffServClfrElementSpecific points to a filter that specifies the\nclassification parameters. A classifier may use filter tables of\ndifferent types together.\n\nOne example of a filter table defined in this MIB is\ndiffServMultiFieldClfrTable, for IP Multi-Field Classifiers\n(MFCs). Such an entry might identify anything from a single\nmicro-flow (an identifiable sub-session packet stream directed\nfrom one sending transport to the receiving transport or\ntransports), or aggregates of those such as the traffic from a\nhost, traffic for an application, or traffic between two hosts\nusing an application and a given DSCP. The standard Behavior\nAggregate used in the Differentiated Services Architecture is\nencoded as a degenerate case of such an aggregate - the traffic\nusing a particular DSCP value.\n\nFilter tables for other filter types may be defined elsewhere.")
diffServClfrElementEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServClfrId"), (0, "DIFFSERV-MIB", "diffServClfrElementId"))
if mibBuilder.loadTexts: diffServClfrElementEntry.setDescription("An entry in the classifier element table describes a single\nelement of the classifier.")
diffServClfrElementId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServClfrElementId.setDescription("An index that enumerates the Classifier Element entries.\nManagers obtain new values for row creation in this table by\nreading diffServClfrElementNextFree.")
diffServClfrElementPrecedence = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrElementPrecedence.setDescription("The relative order in which classifier elements are applied:\nhigher numbers represent classifier element with higher\nprecedence.  Classifier elements with the same order must be\nunambiguous i.e. they must define non-overlapping patterns, and\nare considered to be applied simultaneously to the traffic\nstream. Classifier elements with different order may overlap in\ntheir filters:  the classifier element with the highest order\nthat matches is taken.\n\nOn a given interface, there must be a complete classifier in\nplace at all times in the ingress direction.  This means one or\nmore filters must match any possible pattern. There is no such\n\n\n\nrequirement in the egress direction.")
diffServClfrElementNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrElementNext.setDescription("This attribute provides one branch of the fan-out functionality\nof a classifier described in the Informal Differentiated Services\nModel section 4.1.\n\nThis selects the next Differentiated Services Functional Data\nPath Element to handle traffic for this data path. This\nRowPointer should point to an instance of one of:\n  diffServClfrEntry\n  diffServMeterEntry\n  diffServActionEntry\n  diffServAlgDropEntry\n  diffServQEntry\n\nA value of zeroDotZero in this attribute indicates no further\nDifferentiated Services treatment is performed on traffic of this\ndata path. The use of zeroDotZero is the normal usage for the\nlast functional data path element of the current data path.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServClfrElementSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1, 4), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrElementSpecific.setDescription("A pointer to a valid entry in another table, filter table, that\ndescribes the applicable classification parameters, e.g. an entry\nin diffServMultiFieldClfrTable.\n\nThe value zeroDotZero is interpreted to match anything not\nmatched by another classifier element - only one such entry may\nexist for each classifier.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\n\n\n\nbecomes inactive by other means, the element is ignored.")
diffServClfrElementStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrElementStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServClfrElementStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 4, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServClfrElementStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServMultiFieldClfrNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 2, 5), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServMultiFieldClfrNextFree.setDescription("This object contains an unused value for\ndiffServMultiFieldClfrId, or a zero to indicate that none exist.")
diffServMultiFieldClfrTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 2, 6))
if mibBuilder.loadTexts: diffServMultiFieldClfrTable.setDescription("A table of IP Multi-field Classifier filter entries that a\n\n\n\nsystem may use to identify IP traffic.")
diffServMultiFieldClfrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServMultiFieldClfrId"))
if mibBuilder.loadTexts: diffServMultiFieldClfrEntry.setDescription("An IP Multi-field Classifier entry describes a single filter.")
diffServMultiFieldClfrId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServMultiFieldClfrId.setDescription("An index that enumerates the MultiField Classifier filter\nentries.  Managers obtain new values for row creation in this\ntable by reading diffServMultiFieldClfrNextFree.")
diffServMultiFieldClfrAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 2), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrAddrType.setDescription("The type of IP address used by this classifier entry.  While\nother types of addresses are defined in the InetAddressType\n\n\n\ntextual convention, and DNS names, a classifier can only look at\npackets on the wire. Therefore, this object is limited to IPv4\nand IPv6 addresses.")
diffServMultiFieldClfrDstAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrDstAddr.setDescription("The IP address to match against the packet's destination IP\naddress. This may not be a DNS name, but may be an IPv4 or IPv6\nprefix.  diffServMultiFieldClfrDstPrefixLength indicates the\nnumber of bits that are relevant.")
diffServMultiFieldClfrDstPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 4), InetAddressPrefixLength().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrDstPrefixLength.setDescription("The length of the CIDR Prefix carried in\ndiffServMultiFieldClfrDstAddr. In IPv4 addresses, a length of 0\nindicates a match of any address; a length of 32 indicates a\nmatch of a single host address, and a length between 0 and 32\nindicates the use of a CIDR Prefix. IPv6 is similar, except that\nprefix lengths range from 0..128.")
diffServMultiFieldClfrSrcAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 5), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrSrcAddr.setDescription("The IP address to match against the packet's source IP address.\nThis may not be a DNS name, but may be an IPv4 or IPv6 prefix.\ndiffServMultiFieldClfrSrcPrefixLength indicates the number of\nbits that are relevant.")
diffServMultiFieldClfrSrcPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 6), InetAddressPrefixLength().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrSrcPrefixLength.setDescription("The length of the CIDR Prefix carried in\ndiffServMultiFieldClfrSrcAddr. In IPv4 addresses, a length of 0\nindicates a match of any address; a length of 32 indicates a\nmatch of a single host address, and a length between 0 and 32\nindicates the use of a CIDR Prefix. IPv6 is similar, except that\nprefix lengths range from 0..128.")
diffServMultiFieldClfrDscp = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 7), DscpOrAny().clone('-1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrDscp.setDescription("The value that the DSCP in the packet must have to match this\nentry. A value of -1 indicates that a specific DSCP value has not\nbeen defined and thus all DSCP values are considered a match.")
diffServMultiFieldClfrFlowId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1048575))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrFlowId.setDescription("The flow identifier in an IPv6 header.")
diffServMultiFieldClfrProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(255)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrProtocol.setDescription("The IP protocol to match against the IPv4 protocol number or the\nIPv6 Next- Header number in the packet. A value of 255 means\nmatch all.  Note the protocol number of 255 is reserved by IANA,\nand Next-Header number of 0 is used in IPv6.")
diffServMultiFieldClfrDstL4PortMin = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 10), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrDstL4PortMin.setDescription("The minimum value that the layer-4 destination port number in\nthe packet must have in order to match this classifier entry.")
diffServMultiFieldClfrDstL4PortMax = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 11), InetPortNumber().clone('65535')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrDstL4PortMax.setDescription("The maximum value that the layer-4 destination port number in\nthe packet must have in order to match this classifier entry.\nThis value must be equal to or greater than the value specified\nfor this entry in diffServMultiFieldClfrDstL4PortMin.")
diffServMultiFieldClfrSrcL4PortMin = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 12), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrSrcL4PortMin.setDescription("The minimum value that the layer-4 source port number in the\npacket must have in order to match this classifier entry.")
diffServMultiFieldClfrSrcL4PortMax = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 13), InetPortNumber().clone('65535')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrSrcL4PortMax.setDescription("The maximum value that the layer-4 source port number in the\npacket must have in order to match this classifier entry. This\nvalue must be equal to or greater than the value specified for\nthis entry in diffServMultiFieldClfrSrcL4PortMin.")
diffServMultiFieldClfrStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 14), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServMultiFieldClfrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 2, 6, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMultiFieldClfrStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServMeter = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 3))
diffServMeterNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 3, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServMeterNextFree.setDescription("This object contains an unused value for diffServMeterId, or a\nzero to indicate that none exist.")
diffServMeterTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 3, 2))
if mibBuilder.loadTexts: diffServMeterTable.setDescription("This table enumerates specific meters that a system may use to\npolice a stream of traffic. The traffic stream to be metered is\ndetermined by the Differentiated Services Functional Data Path\nElement(s) upstream of the meter i.e. by the object(s) that point\nto each entry in this table.  This may include all traffic on an\ninterface.\n\nSpecific meter details are to be found in table entry referenced\nby diffServMeterSpecific.")
diffServMeterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServMeterId"))
if mibBuilder.loadTexts: diffServMeterEntry.setDescription("An entry in the meter table describes a single conformance level\nof a meter.")
diffServMeterId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServMeterId.setDescription("An index that enumerates the Meter entries.  Managers obtain new\nvalues for row creation in this table by reading\ndiffServMeterNextFree.")
diffServMeterSucceedNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1, 2), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMeterSucceedNext.setDescription("If the traffic does conform, this selects the next\nDifferentiated Services Functional Data Path element to handle\ntraffic for this data path. This RowPointer should point to an\ninstance of one of:\n  diffServClfrEntry\n  diffServMeterEntry\n  diffServActionEntry\n  diffServAlgDropEntry\n  diffServQEntry\n\nA value of zeroDotZero in this attribute indicates that no\nfurther Differentiated Services treatment is performed on traffic\nof this data path. The use of zeroDotZero is the normal usage for\nthe last functional data path element of the current data path.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServMeterFailNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1, 3), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMeterFailNext.setDescription("If the traffic does not conform, this selects the next\nDifferentiated Services Functional Data Path element to handle\ntraffic for this data path. This RowPointer should point to an\ninstance of one of:\n  diffServClfrEntry\n  diffServMeterEntry\n\n\n\n  diffServActionEntry\n  diffServAlgDropEntry\n  diffServQEntry\n\nA value of zeroDotZero in this attribute indicates no further\nDifferentiated Services treatment is performed on traffic of this\ndata path. The use of zeroDotZero is the normal usage for the\nlast functional data path element of the current data path.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServMeterSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1, 4), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMeterSpecific.setDescription("This indicates the behavior of the meter by pointing to an entry\ncontaining detailed parameters. Note that entries in that\nspecific table must be managed explicitly.\n\nFor example, diffServMeterSpecific may point to an entry in\ndiffServTBParamTable, which contains an instance of a single set\nof Token Bucket parameters.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the meter always succeeds.")
diffServMeterStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMeterStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServMeterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 3, 2, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMeterStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServTBParam = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 4))
diffServTBParamNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 4, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServTBParamNextFree.setDescription("This object contains an unused value for diffServTBParamId, or a\nzero to indicate that none exist.")
diffServTBParamTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 4, 2))
if mibBuilder.loadTexts: diffServTBParamTable.setDescription("This table enumerates a single set of token bucket meter\nparameters that a system may use to police a stream of traffic.\nSuch meters are modeled here as having a single rate and a single\nburst size. Multiple entries are used when multiple rates/burst\nsizes are needed.")
diffServTBParamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServTBParamId"))
if mibBuilder.loadTexts: diffServTBParamEntry.setDescription("An entry that describes a single set of token bucket\nparameters.")
diffServTBParamId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServTBParamId.setDescription("An index that enumerates the Token Bucket Parameter entries.\nManagers obtain new values for row creation in this table by\nreading diffServTBParamNextFree.")
diffServTBParamType = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 2), AutonomousType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServTBParamType.setDescription("The Metering algorithm associated with the Token Bucket\nparameters.  zeroDotZero indicates this is unknown.\n\nStandard values for generic algorithms:\ndiffServTBParamSimpleTokenBucket, diffServTBParamAvgRate,\ndiffServTBParamSrTCMBlind, diffServTBParamSrTCMAware,\ndiffServTBParamTrTCMBlind, diffServTBParamTrTCMAware, and\ndiffServTBParamTswTCM are specified in this MIB as OBJECT-\nIDENTITYs; additional values may be further specified in other\nMIBs.")
diffServTBParamRate = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServTBParamRate.setDescription("The token-bucket rate, in kilobits per second (kbps). This\nattribute is used for:\n1. CIR in RFC 2697 for srTCM\n2. CIR and PIR in RFC 2698 for trTCM\n3. CTR and PTR in RFC 2859 for TSWTCM\n4. AverageRate in RFC 3290.")
diffServTBParamBurstSize = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 4), BurstSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServTBParamBurstSize.setDescription("The maximum number of bytes in a single transmission burst. This\nattribute is used for:\n1. CBS and EBS in RFC 2697 for srTCM\n2. CBS and PBS in RFC 2698 for trTCM\n3. Burst Size in RFC 3290.")
diffServTBParamInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServTBParamInterval.setDescription("The time interval used with the token bucket.  For:\n1. Average Rate Meter, the Informal Differentiated Services Model\n   section 5.2.1, - Delta.\n2. Simple Token Bucket Meter, the Informal Differentiated\n   Services Model section 5.1, - time interval t.\n3. RFC 2859 TSWTCM, - AVG_INTERVAL.\n4. RFC 2697 srTCM, RFC 2698 trTCM, - token bucket update time\n   interval.")
diffServTBParamStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServTBParamStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServTBParamStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 4, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServTBParamStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServAction = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 5))
diffServActionNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 5, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServActionNextFree.setDescription("This object contains an unused value for diffServActionId, or a\nzero to indicate that none exist.")
diffServActionTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 5, 2))
if mibBuilder.loadTexts: diffServActionTable.setDescription("The Action Table enumerates actions that can be performed to a\nstream of traffic. Multiple actions can be concatenated. For\nexample, traffic exiting from a meter may be counted, marked, and\npotentially dropped before entering a queue.\n\nSpecific actions are indicated by diffServActionSpecific which\npoints to an entry of a specific action type parameterizing the\naction in detail.")
diffServActionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServActionId"))
if mibBuilder.loadTexts: diffServActionEntry.setDescription("Each entry in the action table allows description of one\nspecific action to be applied to traffic.")
diffServActionId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServActionId.setDescription("An index that enumerates the Action entries.  Managers obtain\nnew values for row creation in this table by reading\ndiffServActionNextFree.")
diffServActionInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServActionInterface.setDescription("The interface index (value of ifIndex) that this action occurs\non. This may be derived from the diffServDataPathStartEntry's\nindex by extension through the various RowPointers. However, as\nthis may be difficult for a network management station, it is\nplaced here as well.  If this is indeterminate, the value is\nzero.\n\nThis is of especial relevance when reporting the counters which\nmay apply to traffic crossing an interface:\n   diffServCountActOctets,\n   diffServCountActPkts,\n   diffServAlgDropOctets,\n   diffServAlgDropPkts,\n   diffServAlgRandomDropOctets, and\n   diffServAlgRandomDropPkts.\n\nIt is also especially relevant to the queue and scheduler which\nmay be subsequently applied.")
diffServActionNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1, 3), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServActionNext.setDescription("This selects the next Differentiated Services Functional Data\nPath Element to handle traffic for this data path. This\nRowPointer should point to an instance of one of:\n  diffServClfrEntry\n  diffServMeterEntry\n  diffServActionEntry\n  diffServAlgDropEntry\n  diffServQEntry\n\nA value of zeroDotZero in this attribute indicates no further\nDifferentiated Services treatment is performed on traffic of this\ndata path. The use of zeroDotZero is the normal usage for the\nlast functional data path element of the current data path.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServActionSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1, 4), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServActionSpecific.setDescription("A pointer to an object instance providing additional information\nfor the type of action indicated by this action table entry.\n\nFor the standard actions defined by this MIB module, this should\npoint to either a diffServDscpMarkActEntry or a\ndiffServCountActEntry. For other actions, it may point to an\nobject instance defined in some other MIB.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the Meter should be treated as\nif it were not present.  This may lead to incorrect policy\nbehavior.")
diffServActionStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServActionStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServActionStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 2, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServActionStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServDscpMarkActTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 5, 3))
if mibBuilder.loadTexts: diffServDscpMarkActTable.setDescription("This table enumerates specific DSCPs used for marking or\nremarking the DSCP field of IP packets. The entries of this table\nmay be referenced by a diffServActionSpecific attribute.")
diffServDscpMarkActEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 5, 3, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServDscpMarkActDscp"))
if mibBuilder.loadTexts: diffServDscpMarkActEntry.setDescription("An entry in the DSCP mark action table that describes a single\nDSCP used for marking.")
diffServDscpMarkActDscp = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 3, 1, 1), Dscp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServDscpMarkActDscp.setDescription("The DSCP that this Action will store into the DSCP field of the\nsubject. It is quite possible that the only packets subject to\nthis Action are already marked with this DSCP. Note also that\nDifferentiated Services processing may result in packet being\nmarked on both ingress to a network and on egress from it, and\nthat ingress and egress can occur in the same router.")
diffServCountActNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 5, 4), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServCountActNextFree.setDescription("This object contains an unused value for\ndiffServCountActId, or a zero to indicate that none exist.")
diffServCountActTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 5, 5))
if mibBuilder.loadTexts: diffServCountActTable.setDescription("This table contains counters for all the traffic passing through\nan action element.")
diffServCountActEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 5, 5, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServCountActId"))
if mibBuilder.loadTexts: diffServCountActEntry.setDescription("An entry in the count action table describes a single set of\ntraffic counters.")
diffServCountActId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 5, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServCountActId.setDescription("An index that enumerates the Count Action entries.  Managers\nobtain new values for row creation in this table by reading\n\n\n\ndiffServCountActNextFree.")
diffServCountActOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 5, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServCountActOctets.setDescription("The number of octets at the Action data path element.\n\nDiscontinuities in the value of this counter can occur at re-\ninitialization of the management system and at other times as\nindicated by the value of ifCounterDiscontinuityTime on the\nrelevant interface.")
diffServCountActPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 5, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServCountActPkts.setDescription("The number of packets at the Action data path element.\n\nDiscontinuities in the value of this counter can occur at re-\ninitialization of the management system and at other times as\nindicated by the value of ifCounterDiscontinuityTime on the\nrelevant interface.")
diffServCountActStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 5, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServCountActStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServCountActStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 5, 5, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServCountActStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\n\n\n\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServAlgDrop = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 6))
diffServAlgDropNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 6, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServAlgDropNextFree.setDescription("This object contains an unused value for diffServAlgDropId, or a\nzero to indicate that none exist.")
diffServAlgDropTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 6, 2))
if mibBuilder.loadTexts: diffServAlgDropTable.setDescription("The algorithmic drop table contains entries describing an\nelement that drops packets according to some algorithm.")
diffServAlgDropEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServAlgDropId"))
if mibBuilder.loadTexts: diffServAlgDropEntry.setDescription("An entry describes a process that drops packets according to\nsome algorithm. Further details of the algorithm type are to be\nfound in diffServAlgDropType and with more detail parameter entry\npointed to by diffServAlgDropSpecific when necessary.")
diffServAlgDropId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServAlgDropId.setDescription("An index that enumerates the Algorithmic Dropper entries.\nManagers obtain new values for row creation in this table by\nreading diffServAlgDropNextFree.")
diffServAlgDropType = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,5,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("tailDrop", 2), ("headDrop", 3), ("randomDrop", 4), ("alwaysDrop", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropType.setDescription("The type of algorithm used by this dropper. The value other(1)\nrequires further specification in some other MIB module.\n\nIn the tailDrop(2) algorithm, diffServAlgDropQThreshold\nrepresents the maximum depth of the queue, pointed to by\ndiffServAlgDropQMeasure, beyond which all newly arriving packets\nwill be dropped.\n\nIn the headDrop(3) algorithm, if a packet arrives when the\ncurrent depth of the queue, pointed to by\ndiffServAlgDropQMeasure, is at diffServAlgDropQThreshold, packets\ncurrently at the head of the queue are dropped to make room for\nthe new packet to be enqueued at the tail of the queue.\n\nIn the randomDrop(4) algorithm, on packet arrival, an Active\nQueue Management algorithm is executed which may randomly drop a\npacket. This algorithm may be proprietary, and it may drop either\nthe arriving packet or another packet in the queue.\ndiffServAlgDropSpecific points to a diffServRandomDropEntry that\ndescribes the algorithm. For this algorithm,\n\n\n\ndiffServAlgDropQThreshold is understood to be the absolute\nmaximum size of the queue and additional parameters are described\nin diffServRandomDropTable.\n\nThe alwaysDrop(5) algorithm is as its name specifies; always\ndrop. In this case, the other configuration values in this Entry\nare not meaningful; There is no useful 'next' processing step,\nthere is no queue, and parameters describing the queue are not\nuseful. Therefore, diffServAlgDropNext, diffServAlgDropMeasure,\nand diffServAlgDropSpecific are all zeroDotZero.")
diffServAlgDropNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropNext.setDescription("This selects the next Differentiated Services Functional Data\nPath Element to handle traffic for this data path. This\nRowPointer should point to an instance of one of:\n  diffServClfrEntry\n  diffServMeterEntry\n  diffServActionEntry\n  diffServQEntry\n\nA value of zeroDotZero in this attribute indicates no further\nDifferentiated Services treatment is performed on traffic of this\ndata path. The use of zeroDotZero is the normal usage for the\nlast functional data path element of the current data path.\n\nWhen diffServAlgDropType is alwaysDrop(5), this object is\nignored.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServAlgDropQMeasure = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 4), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropQMeasure.setDescription("Points to an entry in the diffServQTable to indicate the queue\nthat a drop algorithm is to monitor when deciding whether to drop\na packet. If the row pointed to does not exist, the algorithmic\ndropper element is considered inactive.\n\n\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServAlgDropQThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropQThreshold.setDescription("A threshold on the depth in bytes of the queue being measured at\nwhich a trigger is generated to the dropping algorithm, unless\ndiffServAlgDropType is alwaysDrop(5) where this object is\nignored.\n\nFor the tailDrop(2) or headDrop(3) algorithms, this represents\nthe depth of the queue, pointed to by diffServAlgDropQMeasure, at\nwhich the drop action will take place. Other algorithms will need\nto define their own semantics for this threshold.")
diffServAlgDropSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 6), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropSpecific.setDescription("Points to a table entry that provides further detail regarding a\ndrop algorithm.\n\nEntries with diffServAlgDropType equal to other(1) may have this\npoint to a table defined in another MIB module.\n\nEntries with diffServAlgDropType equal to randomDrop(4) must have\nthis point to an entry in diffServRandomDropTable.\n\nFor all other algorithms specified in this MIB, this should take\nthe value zeroDotZero.\n\nThe diffServAlgDropType is authoritative for the type of the drop\nalgorithm and the specific parameters for the drop algorithm\nneeds to be evaluated based on the diffServAlgDropType.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServAlgDropOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServAlgDropOctets.setDescription("The number of octets that have been deterministically dropped by\nthis drop process.\n\nDiscontinuities in the value of this counter can occur at re-\ninitialization of the management system and at other times as\nindicated by the value of ifCounterDiscontinuityTime on the\nrelevant interface.")
diffServAlgDropPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServAlgDropPkts.setDescription("The number of packets that have been deterministically dropped\nby this drop process.\n\nDiscontinuities in the value of this counter can occur at re-\ninitialization of the management system and at other times as\nindicated by the value of ifCounterDiscontinuityTime on the\nrelevant interface.")
diffServAlgRandomDropOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServAlgRandomDropOctets.setDescription("The number of octets that have been randomly dropped by this\ndrop process.  This counter applies, therefore, only to random\ndroppers.\n\nDiscontinuities in the value of this counter can occur at re-\ninitialization of the management system and at other times as\nindicated by the value of ifCounterDiscontinuityTime on the\nrelevant interface.")
diffServAlgRandomDropPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServAlgRandomDropPkts.setDescription("The number of packets that have been randomly dropped by this\ndrop process. This counter applies, therefore, only to random\ndroppers.\n\nDiscontinuities in the value of this counter can occur at re-\ninitialization of the management system and at other times as\nindicated by the value of ifCounterDiscontinuityTime on the\nrelevant interface.")
diffServAlgDropStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServAlgDropStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 2, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServAlgDropStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServRandomDropNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 6, 3), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServRandomDropNextFree.setDescription("This object contains an unused value for diffServRandomDropId,\nor a zero to indicate that none exist.")
diffServRandomDropTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 6, 4))
if mibBuilder.loadTexts: diffServRandomDropTable.setDescription("The random drop table contains entries describing a process that\ndrops packets randomly. Entries in this table are pointed to by\ndiffServAlgDropSpecific.")
diffServRandomDropEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServRandomDropId"))
if mibBuilder.loadTexts: diffServRandomDropEntry.setDescription("An entry describes a process that drops packets according to a\nrandom algorithm.")
diffServRandomDropId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServRandomDropId.setDescription("An index that enumerates the Random Drop entries.  Managers\nobtain new values for row creation in this table by reading\ndiffServRandomDropNextFree.")
diffServRandomDropMinThreshBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropMinThreshBytes.setDescription("The average queue depth in bytes, beyond which traffic has a\nnon-zero probability of being dropped. Changes in this variable\nmay or may not be reflected in the reported value of\ndiffServRandomDropMinThreshPkts.")
diffServRandomDropMinThreshPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropMinThreshPkts.setDescription("The average queue depth in packets, beyond which traffic has a\nnon-zero probability of being dropped. Changes in this variable\nmay or may not be reflected in the reported value of\ndiffServRandomDropMinThreshBytes.")
diffServRandomDropMaxThreshBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropMaxThreshBytes.setDescription("The average queue depth beyond which traffic has a probability\nindicated by diffServRandomDropProbMax of being dropped or\nmarked. Note that this differs from the physical queue limit,\nwhich is stored in diffServAlgDropQThreshold. Changes in this\nvariable may or may not be reflected in the reported value of\ndiffServRandomDropMaxThreshPkts.")
diffServRandomDropMaxThreshPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropMaxThreshPkts.setDescription("The average queue depth beyond which traffic has a probability\nindicated by diffServRandomDropProbMax of being dropped or\nmarked. Note that this differs from the physical queue limit,\nwhich is stored in diffServAlgDropQThreshold. Changes in this\nvariable may or may not be reflected in the reported value of\ndiffServRandomDropMaxThreshBytes.")
diffServRandomDropProbMax = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1000))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropProbMax.setDescription("The worst case random drop probability, expressed in drops per\nthousand packets.\n\nFor example, if in the worst case every arriving packet may be\ndropped (100%) for a period, this has the value 1000.\nAlternatively, if in the worst case only one percent (1%) of\ntraffic may be dropped, it has the value 10.")
diffServRandomDropWeight = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65536))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropWeight.setDescription("The weighting of past history in affecting the Exponentially\nWeighted Moving Average function that calculates the current\naverage queue depth.  The equation uses\ndiffServRandomDropWeight/65536 as the coefficient for the new\nsample in the equation, and (65536 -\ndiffServRandomDropWeight)/65536 as the coefficient of the old\nvalue.\n\nImplementations may limit the values of diffServRandomDropWeight\nto a subset of the possible range of values, such as powers of\ntwo. Doing this would facilitate implementation of the\nExponentially Weighted Moving Average using shift instructions or\nregisters.")
diffServRandomDropSamplingRate = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1000000))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropSamplingRate.setDescription("The number of times per second the queue is sampled for queue\naverage calculation.  A value of zero is used to mean that the\nqueue is sampled approximately each time a packet is enqueued (or\ndequeued).")
diffServRandomDropStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 9), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServRandomDropStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 6, 4, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServRandomDropStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServQueue = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 7))
diffServQNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 7, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServQNextFree.setDescription("This object contains an unused value for diffServQId, or a zero\nto indicate that none exist.")
diffServQTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 7, 2))
if mibBuilder.loadTexts: diffServQTable.setDescription("The Queue Table enumerates the individual queues.  Note that the\nMIB models queuing systems as composed of individual queues, one\nper class of traffic, even though they may in fact be structured\nas classes of traffic scheduled using a common calendar queue, or\nin other ways.")
diffServQEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServQId"))
if mibBuilder.loadTexts: diffServQEntry.setDescription("An entry in the Queue Table describes a single queue or class of\ntraffic.")
diffServQId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServQId.setDescription("An index that enumerates the Queue entries.  Managers obtain new\nvalues for row creation in this table by reading\ndiffServQNextFree.")
diffServQNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1, 2), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServQNext.setDescription("This selects the next Differentiated Services Scheduler.  The\nRowPointer must point to a diffServSchedulerEntry.\n\nA value of zeroDotZero in this attribute indicates an incomplete\ndiffServQEntry instance. In such a case, the entry has no\noperational effect, since it has no parameters to give it\nmeaning.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServQMinRate = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServQMinRate.setDescription("This RowPointer indicates the diffServMinRateEntry that the\nscheduler, pointed to by diffServQNext, should use to service\nthis queue.\n\nIf the row pointed to is zeroDotZero, the minimum rate and\npriority is unspecified.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServQMaxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1, 4), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServQMaxRate.setDescription("This RowPointer indicates the diffServMaxRateEntry that the\nscheduler, pointed to by diffServQNext, should use to service\nthis queue.\n\nIf the row pointed to is zeroDotZero, the maximum rate is the\nline speed of the interface.\n\n\n\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServQStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServQStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServQStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 7, 2, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServQStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServScheduler = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 1, 8))
diffServSchedulerNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 8, 1), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServSchedulerNextFree.setDescription("This object contains an unused value for diffServSchedulerId, or\na zero to indicate that none exist.")
diffServSchedulerTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 8, 2))
if mibBuilder.loadTexts: diffServSchedulerTable.setDescription("The Scheduler Table enumerates packet schedulers. Multiple\nscheduling algorithms can be used on a given data path, with each\nalgorithm described by one diffServSchedulerEntry.")
diffServSchedulerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServSchedulerId"))
if mibBuilder.loadTexts: diffServSchedulerEntry.setDescription("An entry in the Scheduler Table describing a single instance of\na scheduling algorithm.")
diffServSchedulerId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServSchedulerId.setDescription("An index that enumerates the Scheduler entries.  Managers obtain\nnew values for row creation in this table by reading\ndiffServSchedulerNextFree.")
diffServSchedulerNext = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 2), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServSchedulerNext.setDescription("This selects the next Differentiated Services Functional Data\nPath Element to handle traffic for this data path. This normally\nis null (zeroDotZero), or points to a diffServSchedulerEntry or a\ndiffServQEntry.\n\nHowever, this RowPointer may also point to an instance of:\n  diffServClfrEntry,\n  diffServMeterEntry,\n  diffServActionEntry,\n  diffServAlgDropEntry.\n\nIt would point another diffServSchedulerEntry when implementing\nmultiple scheduler methods for the same data path, such as having\none set of queues scheduled by WRR and that group participating\nin a priority scheduling system in which other queues compete\nwith it in that way.  It might also point to a second scheduler\nin a hierarchical scheduling system.\n\nIf the row pointed to is zeroDotZero, no further Differentiated\nServices treatment is performed on traffic of this data path.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServSchedulerMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 3), AutonomousType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServSchedulerMethod.setDescription("The scheduling algorithm used by this Scheduler. zeroDotZero\nindicates that this is unknown.  Standard values for generic\nalgorithms: diffServSchedulerPriority, diffServSchedulerWRR, and\ndiffServSchedulerWFQ are specified in this MIB; additional values\n\n\n\nmay be further specified in other MIBs.")
diffServSchedulerMinRate = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 4), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServSchedulerMinRate.setDescription("This RowPointer indicates the entry in diffServMinRateTable\nwhich indicates the priority or minimum output rate from this\nscheduler. This attribute is used only when there is more than\none level of scheduler.\n\nWhen it has the value zeroDotZero, it indicates that no minimum\nrate or priority is imposed.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServSchedulerMaxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 5), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServSchedulerMaxRate.setDescription("This RowPointer indicates the entry in diffServMaxRateTable\nwhich indicates the maximum output rate from this scheduler.\nWhen more than one maximum rate applies (eg, when a multi-rate\nshaper is in view), it points to the first of those rate entries.\nThis attribute is used only when there is more than one level of\nscheduler.\n\nWhen it has the value zeroDotZero, it indicates that no maximum\nrate is imposed.\n\nSetting this to point to a target that does not exist results in\nan inconsistentValue error.  If the row pointed to is removed or\nbecomes inactive by other means, the treatment is as if this\nattribute contains a value of zeroDotZero.")
diffServSchedulerStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServSchedulerStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServSchedulerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServSchedulerStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServMinRateNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 8, 3), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServMinRateNextFree.setDescription("This object contains an unused value for diffServMinRateId, or a\nzero to indicate that none exist.")
diffServMinRateTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 8, 4))
if mibBuilder.loadTexts: diffServMinRateTable.setDescription("The Minimum Rate Parameters Table enumerates individual sets of\nscheduling parameter that can be used/reused by Queues and\nSchedulers.")
diffServMinRateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServMinRateId"))
if mibBuilder.loadTexts: diffServMinRateEntry.setDescription("An entry in the Minimum Rate Parameters Table describes a single\nset of scheduling parameters for use by one or more queues or\nschedulers.")
diffServMinRateId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServMinRateId.setDescription("An index that enumerates the Scheduler Parameter entries.\nManagers obtain new values for row creation in this table by\nreading diffServMinRateNextFree.")
diffServMinRatePriority = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMinRatePriority.setDescription("The priority of this input to the associated scheduler, relative\n\n\n\nto the scheduler's other inputs. A queue or scheduler with a\nlarger numeric value will be served before another with a smaller\nnumeric value.")
diffServMinRateAbsolute = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMinRateAbsolute.setDescription("The minimum absolute rate, in kilobits/sec, that a downstream\nscheduler element should allocate to this queue. If the value is\nzero, then there is effectively no minimum rate guarantee. If the\nvalue is non-zero, the scheduler will assure the servicing of\nthis queue to at least this rate.\n\nNote that this attribute value and that of\ndiffServMinRateRelative are coupled: changes to one will affect\nthe value of the other. They are linked by the following\nequation, in that setting one will change the other:\n\n  diffServMinRateRelative =\n          (diffServMinRateAbsolute*1000000)/ifSpeed\n\nor, if appropriate:\n\n  diffServMinRateRelative = diffServMinRateAbsolute/ifHighSpeed")
diffServMinRateRelative = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMinRateRelative.setDescription("The minimum rate that a downstream scheduler element should\nallocate to this queue, relative to the maximum rate of the\ninterface as reported by ifSpeed or ifHighSpeed, in units of\n1/1000 of 1. If the value is zero, then there is effectively no\nminimum rate guarantee. If the value is non-zero, the scheduler\nwill assure the servicing of this queue to at least this rate.\n\nNote that this attribute value and that of\ndiffServMinRateAbsolute are coupled: changes to one will affect\nthe value of the other. They are linked by the following\nequation, in that setting one will change the other:\n\n\n\n  diffServMinRateRelative =\n          (diffServMinRateAbsolute*1000000)/ifSpeed\n\nor, if appropriate:\n\n  diffServMinRateRelative = diffServMinRateAbsolute/ifHighSpeed")
diffServMinRateStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMinRateStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServMinRateStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 4, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMinRateStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServMaxRateNextFree = MibScalar((1, 3, 6, 1, 2, 1, 97, 1, 8, 5), IndexIntegerNextFree()).setMaxAccess("readonly")
if mibBuilder.loadTexts: diffServMaxRateNextFree.setDescription("This object contains an unused value for diffServMaxRateId, or a\nzero to indicate that none exist.")
diffServMaxRateTable = MibTable((1, 3, 6, 1, 2, 1, 97, 1, 8, 6))
if mibBuilder.loadTexts: diffServMaxRateTable.setDescription("The Maximum Rate Parameter Table enumerates individual sets of\nscheduling parameter that can be used/reused by Queues and\nSchedulers.")
diffServMaxRateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1)).setIndexNames((0, "DIFFSERV-MIB", "diffServMaxRateId"), (0, "DIFFSERV-MIB", "diffServMaxRateLevel"))
if mibBuilder.loadTexts: diffServMaxRateEntry.setDescription("An entry in the Maximum Rate Parameter Table describes a single\nset of scheduling parameters for use by one or more queues or\nschedulers.")
diffServMaxRateId = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 1), IndexInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServMaxRateId.setDescription("An index that enumerates the Maximum Rate Parameter entries.\nManagers obtain new values for row creation in this table by\nreading diffServMaxRateNextFree.")
diffServMaxRateLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: diffServMaxRateLevel.setDescription("An index that indicates which level of a multi-rate shaper is\nbeing given its parameters. A multi-rate shaper has some number\nof rate levels. Frame Relay's dual rate specification refers to a\n'committed' and an 'excess' rate; ATM's dual rate specification\nrefers to a 'mean' and a 'peak' rate. This table is generalized\nto support an arbitrary number of rates. The committed or mean\nrate is level 1, the peak rate (if any) is the highest level rate\nconfigured, and if there are other rates they are distributed in\nmonotonically increasing order between them.")
diffServMaxRateAbsolute = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMaxRateAbsolute.setDescription("The maximum rate in kilobits/sec that a downstream scheduler\nelement should allocate to this queue. If the value is zero, then\nthere is effectively no maximum rate limit and that the scheduler\nshould attempt to be work conserving for this queue. If the value\nis non-zero, the scheduler will limit the servicing of this queue\nto, at most, this rate in a non-work-conserving manner.\n\nNote that this attribute value and that of\ndiffServMaxRateRelative are coupled: changes to one will affect\nthe value of the other. They are linked by the following\n\n\n\nequation, in that setting one will change the other:\n\n  diffServMaxRateRelative =\n          (diffServMaxRateAbsolute*1000000)/ifSpeed\n\nor, if appropriate:\n\n  diffServMaxRateRelative = diffServMaxRateAbsolute/ifHighSpeed")
diffServMaxRateRelative = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMaxRateRelative.setDescription("The maximum rate that a downstream scheduler element should\nallocate to this queue, relative to the maximum rate of the\ninterface as reported by ifSpeed or ifHighSpeed, in units of\n1/1000 of 1. If the value is zero, then there is effectively no\nmaximum rate limit and the scheduler should attempt to be work\nconserving for this queue. If the value is non-zero, the\nscheduler will limit the servicing of this queue to, at most,\nthis rate in a non-work-conserving manner.\n\nNote that this attribute value and that of\ndiffServMaxRateAbsolute are coupled: changes to one will affect\nthe value of the other. They are linked by the following\nequation, in that setting one will change the other:\n\n  diffServMaxRateRelative =\n          (diffServMaxRateAbsolute*1000000)/ifSpeed\n\nor, if appropriate:\n\n  diffServMaxRateRelative = diffServMaxRateAbsolute/ifHighSpeed")
diffServMaxRateThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 5), BurstSize()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMaxRateThreshold.setDescription("The number of bytes of queue depth at which the rate of a\n\n\n\nmulti-rate scheduler will increase to the next output rate. In\nthe last conceptual row for such a shaper, this threshold is\nignored and by convention is zero.")
diffServMaxRateStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMaxRateStorage.setDescription("The storage type for this conceptual row.  Conceptual rows\nhaving the value 'permanent' need not allow write-access to any\ncolumnar objects in the row.")
diffServMaxRateStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 97, 1, 8, 6, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: diffServMaxRateStatus.setDescription("The status of this conceptual row. All writable objects in this\nrow may be modified at any time. Setting this variable to\n'destroy' when the MIB contains one or more RowPointers pointing\nto it results in destruction being delayed until the row is no\nlonger used.")
diffServMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 2))
diffServMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 2, 1))
diffServMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 2, 2))
diffServMIBAdmin = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 3))
diffServTBMeters = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 3, 1))
diffServTBParamSimpleTokenBucket = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 1))
if mibBuilder.loadTexts: diffServTBParamSimpleTokenBucket.setDescription("Two Parameter Token Bucket Meter as described in the Informal\nDifferentiated Services Model section 5.2.3.")
diffServTBParamAvgRate = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 2))
if mibBuilder.loadTexts: diffServTBParamAvgRate.setDescription("Average Rate Meter as described in the Informal Differentiated\nServices Model section 5.2.1.")
diffServTBParamSrTCMBlind = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 3))
if mibBuilder.loadTexts: diffServTBParamSrTCMBlind.setDescription("Single Rate Three Color Marker Metering as defined by RFC 2697,\nin the `Color Blind' mode as described by the RFC.")
diffServTBParamSrTCMAware = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 4))
if mibBuilder.loadTexts: diffServTBParamSrTCMAware.setDescription("Single Rate Three Color Marker Metering as defined by RFC 2697,\nin the `Color Aware' mode as described by the RFC.")
diffServTBParamTrTCMBlind = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 5))
if mibBuilder.loadTexts: diffServTBParamTrTCMBlind.setDescription("Two Rate Three Color Marker Metering as defined by RFC 2698, in\nthe `Color Blind' mode as described by the RFC.")
diffServTBParamTrTCMAware = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 6))
if mibBuilder.loadTexts: diffServTBParamTrTCMAware.setDescription("Two Rate Three Color Marker Metering as defined by RFC 2698, in\nthe `Color Aware' mode as described by the RFC.")
diffServTBParamTswTCM = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 1, 7))
if mibBuilder.loadTexts: diffServTBParamTswTCM.setDescription("Time Sliding Window Three Color Marker Metering as defined by\nRFC 2859.")
diffServSchedulers = MibIdentifier((1, 3, 6, 1, 2, 1, 97, 3, 2))
diffServSchedulerPriority = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 2, 1))
if mibBuilder.loadTexts: diffServSchedulerPriority.setDescription("For use with diffServSchedulerMethod to indicate the Priority\nscheduling method.  This is defined as an algorithm in which the\npresence of data in a queue or set of queues absolutely precludes\ndequeue from another queue or set of queues of lower priority.\nNote that attributes from diffServMinRateEntry of the\nqueues/schedulers feeding this scheduler are used when\ndetermining the next packet to schedule.")
diffServSchedulerWRR = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 2, 2))
if mibBuilder.loadTexts: diffServSchedulerWRR.setDescription("For use with diffServSchedulerMethod to indicate the Weighted\nRound Robin scheduling method, defined as any algorithm in which\na set of queues are visited in a fixed order, and varying amounts\nof traffic are removed from each queue in turn to implement an\naverage output rate by class. Notice attributes from\ndiffServMinRateEntry of the queues/schedulers feeding this\nscheduler are used when determining the next packet to schedule.")
diffServSchedulerWFQ = ObjectIdentity((1, 3, 6, 1, 2, 1, 97, 3, 2, 3))
if mibBuilder.loadTexts: diffServSchedulerWFQ.setDescription("For use with diffServSchedulerMethod to indicate the Weighted\nFair Queuing scheduling method, defined as any algorithm in which\na set of queues are conceptually visited in some order, to\nimplement an average output rate by class. Notice attributes from\ndiffServMinRateEntry of the queues/schedulers feeding this\nscheduler are used when determining the next packet to schedule.")

# Augmentions

# Groups

diffServMIBDataPathGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 1)).setObjects(("DIFFSERV-MIB", "diffServDataPathStatus"), ("DIFFSERV-MIB", "diffServDataPathStart"), ("DIFFSERV-MIB", "diffServDataPathStorage"), )
if mibBuilder.loadTexts: diffServMIBDataPathGroup.setDescription("The Data Path Group defines the MIB Objects that describe a\nfunctional data path.")
diffServMIBClfrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 2)).setObjects(("DIFFSERV-MIB", "diffServClfrStorage"), ("DIFFSERV-MIB", "diffServClfrNextFree"), ("DIFFSERV-MIB", "diffServClfrStatus"), )
if mibBuilder.loadTexts: diffServMIBClfrGroup.setDescription("The Classifier Group defines the MIB Objects that describe the\n\n\n\nlist the starts of individual classifiers.")
diffServMIBClfrElementGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 3)).setObjects(("DIFFSERV-MIB", "diffServClfrElementNext"), ("DIFFSERV-MIB", "diffServClfrElementNextFree"), ("DIFFSERV-MIB", "diffServClfrElementStorage"), ("DIFFSERV-MIB", "diffServClfrElementStatus"), ("DIFFSERV-MIB", "diffServClfrElementPrecedence"), ("DIFFSERV-MIB", "diffServClfrElementSpecific"), )
if mibBuilder.loadTexts: diffServMIBClfrElementGroup.setDescription("The Classifier Element Group defines the MIB Objects that\ndescribe the classifier elements that make up a generic\nclassifier.")
diffServMIBMultiFieldClfrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 4)).setObjects(("DIFFSERV-MIB", "diffServMultiFieldClfrDstAddr"), ("DIFFSERV-MIB", "diffServMultiFieldClfrStorage"), ("DIFFSERV-MIB", "diffServMultiFieldClfrSrcAddr"), ("DIFFSERV-MIB", "diffServMultiFieldClfrSrcL4PortMin"), ("DIFFSERV-MIB", "diffServMultiFieldClfrDstL4PortMax"), ("DIFFSERV-MIB", "diffServMultiFieldClfrAddrType"), ("DIFFSERV-MIB", "diffServMultiFieldClfrSrcL4PortMax"), ("DIFFSERV-MIB", "diffServMultiFieldClfrSrcPrefixLength"), ("DIFFSERV-MIB", "diffServMultiFieldClfrNextFree"), ("DIFFSERV-MIB", "diffServMultiFieldClfrFlowId"), ("DIFFSERV-MIB", "diffServMultiFieldClfrDstPrefixLength"), ("DIFFSERV-MIB", "diffServMultiFieldClfrDstL4PortMin"), ("DIFFSERV-MIB", "diffServMultiFieldClfrStatus"), ("DIFFSERV-MIB", "diffServMultiFieldClfrDscp"), ("DIFFSERV-MIB", "diffServMultiFieldClfrProtocol"), )
if mibBuilder.loadTexts: diffServMIBMultiFieldClfrGroup.setDescription("The Multi-field Classifier Group defines the MIB Objects that\ndescribe a classifier element for matching on various fields of\nan IP and upper-layer protocol header.")
diffServMIBMeterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 5)).setObjects(("DIFFSERV-MIB", "diffServMeterSucceedNext"), ("DIFFSERV-MIB", "diffServMeterNextFree"), ("DIFFSERV-MIB", "diffServMeterStorage"), ("DIFFSERV-MIB", "diffServMeterSpecific"), ("DIFFSERV-MIB", "diffServMeterFailNext"), ("DIFFSERV-MIB", "diffServMeterStatus"), )
if mibBuilder.loadTexts: diffServMIBMeterGroup.setDescription("The Meter Group defines the objects used in describing a generic\nmeter element.")
diffServMIBTBParamGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 6)).setObjects(("DIFFSERV-MIB", "diffServTBParamType"), ("DIFFSERV-MIB", "diffServTBParamBurstSize"), ("DIFFSERV-MIB", "diffServTBParamNextFree"), ("DIFFSERV-MIB", "diffServTBParamStatus"), ("DIFFSERV-MIB", "diffServTBParamRate"), ("DIFFSERV-MIB", "diffServTBParamInterval"), ("DIFFSERV-MIB", "diffServTBParamStorage"), )
if mibBuilder.loadTexts: diffServMIBTBParamGroup.setDescription("The Token-Bucket Meter Group defines the objects used in\ndescribing a token bucket meter element.")
diffServMIBActionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 7)).setObjects(("DIFFSERV-MIB", "diffServActionNext"), ("DIFFSERV-MIB", "diffServActionStatus"), ("DIFFSERV-MIB", "diffServActionNextFree"), ("DIFFSERV-MIB", "diffServActionSpecific"), ("DIFFSERV-MIB", "diffServActionStorage"), ("DIFFSERV-MIB", "diffServActionInterface"), )
if mibBuilder.loadTexts: diffServMIBActionGroup.setDescription("The Action Group defines the objects used in describing a\ngeneric action element.")
diffServMIBDscpMarkActGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 8)).setObjects(("DIFFSERV-MIB", "diffServDscpMarkActDscp"), )
if mibBuilder.loadTexts: diffServMIBDscpMarkActGroup.setDescription("The DSCP Mark Action Group defines the objects used in\ndescribing a DSCP Marking Action element.")
diffServMIBCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 9)).setObjects(("DIFFSERV-MIB", "diffServAlgRandomDropPkts"), ("DIFFSERV-MIB", "diffServCountActOctets"), ("DIFFSERV-MIB", "diffServAlgDropPkts"), ("DIFFSERV-MIB", "diffServCountActPkts"), ("DIFFSERV-MIB", "diffServAlgRandomDropOctets"), ("DIFFSERV-MIB", "diffServCountActStatus"), ("DIFFSERV-MIB", "diffServAlgDropOctets"), ("DIFFSERV-MIB", "diffServCountActStorage"), ("DIFFSERV-MIB", "diffServCountActNextFree"), )
if mibBuilder.loadTexts: diffServMIBCounterGroup.setDescription("A collection of objects providing information specific to\npacket-oriented network interfaces.")
diffServMIBAlgDropGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 10)).setObjects(("DIFFSERV-MIB", "diffServAlgDropNext"), ("DIFFSERV-MIB", "diffServAlgDropStatus"), ("DIFFSERV-MIB", "diffServAlgDropNextFree"), ("DIFFSERV-MIB", "diffServAlgDropSpecific"), ("DIFFSERV-MIB", "diffServAlgDropQThreshold"), ("DIFFSERV-MIB", "diffServAlgDropType"), ("DIFFSERV-MIB", "diffServAlgDropQMeasure"), ("DIFFSERV-MIB", "diffServAlgDropStorage"), )
if mibBuilder.loadTexts: diffServMIBAlgDropGroup.setDescription("The Algorithmic Drop Group contains the objects that describe\nalgorithmic dropper operation and configuration.")
diffServMIBRandomDropGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 11)).setObjects(("DIFFSERV-MIB", "diffServRandomDropMinThreshBytes"), ("DIFFSERV-MIB", "diffServRandomDropMaxThreshPkts"), ("DIFFSERV-MIB", "diffServRandomDropStorage"), ("DIFFSERV-MIB", "diffServRandomDropStatus"), ("DIFFSERV-MIB", "diffServRandomDropNextFree"), ("DIFFSERV-MIB", "diffServRandomDropProbMax"), ("DIFFSERV-MIB", "diffServRandomDropMinThreshPkts"), ("DIFFSERV-MIB", "diffServRandomDropWeight"), ("DIFFSERV-MIB", "diffServRandomDropMaxThreshBytes"), ("DIFFSERV-MIB", "diffServRandomDropSamplingRate"), )
if mibBuilder.loadTexts: diffServMIBRandomDropGroup.setDescription("The Random Drop Group augments the Algorithmic Drop Group for\nrandom dropper operation and configuration.")
diffServMIBQGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 12)).setObjects(("DIFFSERV-MIB", "diffServQNext"), ("DIFFSERV-MIB", "diffServQNextFree"), ("DIFFSERV-MIB", "diffServQMaxRate"), ("DIFFSERV-MIB", "diffServQStatus"), ("DIFFSERV-MIB", "diffServQMinRate"), ("DIFFSERV-MIB", "diffServQStorage"), )
if mibBuilder.loadTexts: diffServMIBQGroup.setDescription("The Queue Group contains the objects that describe an\n\n\n\ninterface's queues.")
diffServMIBSchedulerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 13)).setObjects(("DIFFSERV-MIB", "diffServSchedulerNextFree"), ("DIFFSERV-MIB", "diffServSchedulerMethod"), ("DIFFSERV-MIB", "diffServSchedulerNext"), ("DIFFSERV-MIB", "diffServSchedulerStatus"), ("DIFFSERV-MIB", "diffServSchedulerMinRate"), ("DIFFSERV-MIB", "diffServSchedulerMaxRate"), ("DIFFSERV-MIB", "diffServSchedulerStorage"), )
if mibBuilder.loadTexts: diffServMIBSchedulerGroup.setDescription("The Scheduler Group contains the objects that describe packet\nschedulers on interfaces.")
diffServMIBMinRateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 14)).setObjects(("DIFFSERV-MIB", "diffServMinRateStorage"), ("DIFFSERV-MIB", "diffServMinRateAbsolute"), ("DIFFSERV-MIB", "diffServMinRatePriority"), ("DIFFSERV-MIB", "diffServMinRateStatus"), ("DIFFSERV-MIB", "diffServMinRateNextFree"), ("DIFFSERV-MIB", "diffServMinRateRelative"), )
if mibBuilder.loadTexts: diffServMIBMinRateGroup.setDescription("The Minimum Rate Parameter Group contains the objects that\ndescribe packet schedulers' minimum rate or priority guarantees.")
diffServMIBMaxRateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 97, 2, 2, 15)).setObjects(("DIFFSERV-MIB", "diffServMaxRateStatus"), ("DIFFSERV-MIB", "diffServMaxRateAbsolute"), ("DIFFSERV-MIB", "diffServMaxRateThreshold"), ("DIFFSERV-MIB", "diffServMaxRateStorage"), ("DIFFSERV-MIB", "diffServMaxRateNextFree"), ("DIFFSERV-MIB", "diffServMaxRateRelative"), )
if mibBuilder.loadTexts: diffServMIBMaxRateGroup.setDescription("The Maximum Rate Parameter Group contains the objects that\ndescribe packet schedulers' maximum rate guarantees.")

# Compliances

diffServMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 97, 2, 1, 1)).setObjects(("DIFFSERV-MIB", "diffServMIBMaxRateGroup"), ("DIFFSERV-MIB", "diffServMIBMultiFieldClfrGroup"), ("DIFFSERV-MIB", "diffServMIBMinRateGroup"), ("DIFFSERV-MIB", "diffServMIBClfrElementGroup"), ("DIFFSERV-MIB", "diffServMIBSchedulerGroup"), ("DIFFSERV-MIB", "diffServMIBMeterGroup"), ("DIFFSERV-MIB", "diffServMIBDscpMarkActGroup"), ("DIFFSERV-MIB", "diffServMIBAlgDropGroup"), ("IF-MIB", "ifCounterDiscontinuityGroup"), ("DIFFSERV-MIB", "diffServMIBRandomDropGroup"), ("DIFFSERV-MIB", "diffServMIBClfrGroup"), ("DIFFSERV-MIB", "diffServMIBActionGroup"), ("DIFFSERV-MIB", "diffServMIBTBParamGroup"), ("DIFFSERV-MIB", "diffServMIBCounterGroup"), ("DIFFSERV-MIB", "diffServMIBQGroup"), ("DIFFSERV-MIB", "diffServMIBDataPathGroup"), )
if mibBuilder.loadTexts: diffServMIBFullCompliance.setDescription("When this MIB is implemented with support for read-create, then\nsuch an implementation can claim full compliance. Such devices\ncan then be both monitored and configured with this MIB.")
diffServMIBReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 97, 2, 1, 2)).setObjects(("DIFFSERV-MIB", "diffServMIBMaxRateGroup"), ("DIFFSERV-MIB", "diffServMIBMultiFieldClfrGroup"), ("DIFFSERV-MIB", "diffServMIBMinRateGroup"), ("DIFFSERV-MIB", "diffServMIBClfrElementGroup"), ("DIFFSERV-MIB", "diffServMIBSchedulerGroup"), ("DIFFSERV-MIB", "diffServMIBMeterGroup"), ("DIFFSERV-MIB", "diffServMIBDscpMarkActGroup"), ("DIFFSERV-MIB", "diffServMIBAlgDropGroup"), ("IF-MIB", "ifCounterDiscontinuityGroup"), ("DIFFSERV-MIB", "diffServMIBRandomDropGroup"), ("DIFFSERV-MIB", "diffServMIBClfrGroup"), ("DIFFSERV-MIB", "diffServMIBActionGroup"), ("DIFFSERV-MIB", "diffServMIBTBParamGroup"), ("DIFFSERV-MIB", "diffServMIBCounterGroup"), ("DIFFSERV-MIB", "diffServMIBQGroup"), ("DIFFSERV-MIB", "diffServMIBDataPathGroup"), )
if mibBuilder.loadTexts: diffServMIBReadOnlyCompliance.setDescription("When this MIB is implemented without support for read-create\n(i.e. in read-only mode), then such an implementation can claim\nread-only compliance. Such a device can then be monitored but can\nnot be configured with this MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("DIFFSERV-MIB", PYSNMP_MODULE_ID=diffServMib)

# Types
mibBuilder.exportSymbols("DIFFSERV-MIB", IfDirection=IfDirection, IndexInteger=IndexInteger, IndexIntegerNextFree=IndexIntegerNextFree)

# Objects
mibBuilder.exportSymbols("DIFFSERV-MIB", diffServMib=diffServMib, diffServMIBObjects=diffServMIBObjects, diffServDataPath=diffServDataPath, diffServDataPathTable=diffServDataPathTable, diffServDataPathEntry=diffServDataPathEntry, diffServDataPathIfDirection=diffServDataPathIfDirection, diffServDataPathStart=diffServDataPathStart, diffServDataPathStorage=diffServDataPathStorage, diffServDataPathStatus=diffServDataPathStatus, diffServClassifier=diffServClassifier, diffServClfrNextFree=diffServClfrNextFree, diffServClfrTable=diffServClfrTable, diffServClfrEntry=diffServClfrEntry, diffServClfrId=diffServClfrId, diffServClfrStorage=diffServClfrStorage, diffServClfrStatus=diffServClfrStatus, diffServClfrElementNextFree=diffServClfrElementNextFree, diffServClfrElementTable=diffServClfrElementTable, diffServClfrElementEntry=diffServClfrElementEntry, diffServClfrElementId=diffServClfrElementId, diffServClfrElementPrecedence=diffServClfrElementPrecedence, diffServClfrElementNext=diffServClfrElementNext, diffServClfrElementSpecific=diffServClfrElementSpecific, diffServClfrElementStorage=diffServClfrElementStorage, diffServClfrElementStatus=diffServClfrElementStatus, diffServMultiFieldClfrNextFree=diffServMultiFieldClfrNextFree, diffServMultiFieldClfrTable=diffServMultiFieldClfrTable, diffServMultiFieldClfrEntry=diffServMultiFieldClfrEntry, diffServMultiFieldClfrId=diffServMultiFieldClfrId, diffServMultiFieldClfrAddrType=diffServMultiFieldClfrAddrType, diffServMultiFieldClfrDstAddr=diffServMultiFieldClfrDstAddr, diffServMultiFieldClfrDstPrefixLength=diffServMultiFieldClfrDstPrefixLength, diffServMultiFieldClfrSrcAddr=diffServMultiFieldClfrSrcAddr, diffServMultiFieldClfrSrcPrefixLength=diffServMultiFieldClfrSrcPrefixLength, diffServMultiFieldClfrDscp=diffServMultiFieldClfrDscp, diffServMultiFieldClfrFlowId=diffServMultiFieldClfrFlowId, diffServMultiFieldClfrProtocol=diffServMultiFieldClfrProtocol, diffServMultiFieldClfrDstL4PortMin=diffServMultiFieldClfrDstL4PortMin, diffServMultiFieldClfrDstL4PortMax=diffServMultiFieldClfrDstL4PortMax, diffServMultiFieldClfrSrcL4PortMin=diffServMultiFieldClfrSrcL4PortMin, diffServMultiFieldClfrSrcL4PortMax=diffServMultiFieldClfrSrcL4PortMax, diffServMultiFieldClfrStorage=diffServMultiFieldClfrStorage, diffServMultiFieldClfrStatus=diffServMultiFieldClfrStatus, diffServMeter=diffServMeter, diffServMeterNextFree=diffServMeterNextFree, diffServMeterTable=diffServMeterTable, diffServMeterEntry=diffServMeterEntry, diffServMeterId=diffServMeterId, diffServMeterSucceedNext=diffServMeterSucceedNext, diffServMeterFailNext=diffServMeterFailNext, diffServMeterSpecific=diffServMeterSpecific, diffServMeterStorage=diffServMeterStorage, diffServMeterStatus=diffServMeterStatus, diffServTBParam=diffServTBParam, diffServTBParamNextFree=diffServTBParamNextFree, diffServTBParamTable=diffServTBParamTable, diffServTBParamEntry=diffServTBParamEntry, diffServTBParamId=diffServTBParamId, diffServTBParamType=diffServTBParamType, diffServTBParamRate=diffServTBParamRate, diffServTBParamBurstSize=diffServTBParamBurstSize, diffServTBParamInterval=diffServTBParamInterval, diffServTBParamStorage=diffServTBParamStorage, diffServTBParamStatus=diffServTBParamStatus, diffServAction=diffServAction, diffServActionNextFree=diffServActionNextFree, diffServActionTable=diffServActionTable, diffServActionEntry=diffServActionEntry, diffServActionId=diffServActionId, diffServActionInterface=diffServActionInterface, diffServActionNext=diffServActionNext, diffServActionSpecific=diffServActionSpecific, diffServActionStorage=diffServActionStorage, diffServActionStatus=diffServActionStatus, diffServDscpMarkActTable=diffServDscpMarkActTable, diffServDscpMarkActEntry=diffServDscpMarkActEntry, diffServDscpMarkActDscp=diffServDscpMarkActDscp, diffServCountActNextFree=diffServCountActNextFree, diffServCountActTable=diffServCountActTable, diffServCountActEntry=diffServCountActEntry, diffServCountActId=diffServCountActId, diffServCountActOctets=diffServCountActOctets, diffServCountActPkts=diffServCountActPkts, diffServCountActStorage=diffServCountActStorage, diffServCountActStatus=diffServCountActStatus, diffServAlgDrop=diffServAlgDrop, diffServAlgDropNextFree=diffServAlgDropNextFree, diffServAlgDropTable=diffServAlgDropTable, diffServAlgDropEntry=diffServAlgDropEntry, diffServAlgDropId=diffServAlgDropId, diffServAlgDropType=diffServAlgDropType, diffServAlgDropNext=diffServAlgDropNext, diffServAlgDropQMeasure=diffServAlgDropQMeasure, diffServAlgDropQThreshold=diffServAlgDropQThreshold, diffServAlgDropSpecific=diffServAlgDropSpecific, diffServAlgDropOctets=diffServAlgDropOctets, diffServAlgDropPkts=diffServAlgDropPkts, diffServAlgRandomDropOctets=diffServAlgRandomDropOctets, diffServAlgRandomDropPkts=diffServAlgRandomDropPkts, diffServAlgDropStorage=diffServAlgDropStorage, diffServAlgDropStatus=diffServAlgDropStatus, diffServRandomDropNextFree=diffServRandomDropNextFree, diffServRandomDropTable=diffServRandomDropTable, diffServRandomDropEntry=diffServRandomDropEntry, diffServRandomDropId=diffServRandomDropId, diffServRandomDropMinThreshBytes=diffServRandomDropMinThreshBytes, diffServRandomDropMinThreshPkts=diffServRandomDropMinThreshPkts, diffServRandomDropMaxThreshBytes=diffServRandomDropMaxThreshBytes, diffServRandomDropMaxThreshPkts=diffServRandomDropMaxThreshPkts, diffServRandomDropProbMax=diffServRandomDropProbMax, diffServRandomDropWeight=diffServRandomDropWeight, diffServRandomDropSamplingRate=diffServRandomDropSamplingRate, diffServRandomDropStorage=diffServRandomDropStorage, diffServRandomDropStatus=diffServRandomDropStatus, diffServQueue=diffServQueue, diffServQNextFree=diffServQNextFree, diffServQTable=diffServQTable, diffServQEntry=diffServQEntry, diffServQId=diffServQId, diffServQNext=diffServQNext, diffServQMinRate=diffServQMinRate, diffServQMaxRate=diffServQMaxRate, diffServQStorage=diffServQStorage, diffServQStatus=diffServQStatus, diffServScheduler=diffServScheduler, diffServSchedulerNextFree=diffServSchedulerNextFree)
mibBuilder.exportSymbols("DIFFSERV-MIB", diffServSchedulerTable=diffServSchedulerTable, diffServSchedulerEntry=diffServSchedulerEntry, diffServSchedulerId=diffServSchedulerId, diffServSchedulerNext=diffServSchedulerNext, diffServSchedulerMethod=diffServSchedulerMethod, diffServSchedulerMinRate=diffServSchedulerMinRate, diffServSchedulerMaxRate=diffServSchedulerMaxRate, diffServSchedulerStorage=diffServSchedulerStorage, diffServSchedulerStatus=diffServSchedulerStatus, diffServMinRateNextFree=diffServMinRateNextFree, diffServMinRateTable=diffServMinRateTable, diffServMinRateEntry=diffServMinRateEntry, diffServMinRateId=diffServMinRateId, diffServMinRatePriority=diffServMinRatePriority, diffServMinRateAbsolute=diffServMinRateAbsolute, diffServMinRateRelative=diffServMinRateRelative, diffServMinRateStorage=diffServMinRateStorage, diffServMinRateStatus=diffServMinRateStatus, diffServMaxRateNextFree=diffServMaxRateNextFree, diffServMaxRateTable=diffServMaxRateTable, diffServMaxRateEntry=diffServMaxRateEntry, diffServMaxRateId=diffServMaxRateId, diffServMaxRateLevel=diffServMaxRateLevel, diffServMaxRateAbsolute=diffServMaxRateAbsolute, diffServMaxRateRelative=diffServMaxRateRelative, diffServMaxRateThreshold=diffServMaxRateThreshold, diffServMaxRateStorage=diffServMaxRateStorage, diffServMaxRateStatus=diffServMaxRateStatus, diffServMIBConformance=diffServMIBConformance, diffServMIBCompliances=diffServMIBCompliances, diffServMIBGroups=diffServMIBGroups, diffServMIBAdmin=diffServMIBAdmin, diffServTBMeters=diffServTBMeters, diffServTBParamSimpleTokenBucket=diffServTBParamSimpleTokenBucket, diffServTBParamAvgRate=diffServTBParamAvgRate, diffServTBParamSrTCMBlind=diffServTBParamSrTCMBlind, diffServTBParamSrTCMAware=diffServTBParamSrTCMAware, diffServTBParamTrTCMBlind=diffServTBParamTrTCMBlind, diffServTBParamTrTCMAware=diffServTBParamTrTCMAware, diffServTBParamTswTCM=diffServTBParamTswTCM, diffServSchedulers=diffServSchedulers, diffServSchedulerPriority=diffServSchedulerPriority, diffServSchedulerWRR=diffServSchedulerWRR, diffServSchedulerWFQ=diffServSchedulerWFQ)

# Groups
mibBuilder.exportSymbols("DIFFSERV-MIB", diffServMIBDataPathGroup=diffServMIBDataPathGroup, diffServMIBClfrGroup=diffServMIBClfrGroup, diffServMIBClfrElementGroup=diffServMIBClfrElementGroup, diffServMIBMultiFieldClfrGroup=diffServMIBMultiFieldClfrGroup, diffServMIBMeterGroup=diffServMIBMeterGroup, diffServMIBTBParamGroup=diffServMIBTBParamGroup, diffServMIBActionGroup=diffServMIBActionGroup, diffServMIBDscpMarkActGroup=diffServMIBDscpMarkActGroup, diffServMIBCounterGroup=diffServMIBCounterGroup, diffServMIBAlgDropGroup=diffServMIBAlgDropGroup, diffServMIBRandomDropGroup=diffServMIBRandomDropGroup, diffServMIBQGroup=diffServMIBQGroup, diffServMIBSchedulerGroup=diffServMIBSchedulerGroup, diffServMIBMinRateGroup=diffServMIBMinRateGroup, diffServMIBMaxRateGroup=diffServMIBMaxRateGroup)

# Compliances
mibBuilder.exportSymbols("DIFFSERV-MIB", diffServMIBFullCompliance=diffServMIBFullCompliance, diffServMIBReadOnlyCompliance=diffServMIBReadOnlyCompliance)
