# PySNMP SMI module. Autogenerated from smidump -f python DS1-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:23 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( PerfCurrentCount, PerfIntervalCount, PerfTotalCount, ) = mibBuilder.importSymbols("PerfHist-TC-MIB", "PerfCurrentCount", "PerfIntervalCount", "PerfTotalCount")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( DisplayString, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeStamp", "TruthValue")

# Objects

ds1 = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 18)).setRevisions(("2007-03-05 00:00","2004-09-09 00:00","1998-08-01 18:30","1993-01-25 20:28",))
if mibBuilder.loadTexts: ds1.setOrganization("IETF AToM MIB Working Group")
if mibBuilder.loadTexts: ds1.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/atommib-charter.html\n\nMailing Lists:\n  General Discussion: atommib@research.telcordia.com\n  To Subscribe: atommib-request@research.telcordia.com\n\nEditor: Orly Nicklass\n\nPostal: RAD Data Communications, Ltd.\n        Ziv Tower, 24 Roul Walenberg\n        Tel Aviv, Israel, 69719\n\n        Tel: +9723 765 9969\nE-mail: orly_n@rad.com")
if mibBuilder.loadTexts: ds1.setDescription("The MIB module to describe DS1, J1, E1, DS2, and\nE2 interfaces objects.\n\nCopyright (c) The IETF Trust (2007).  This\nversion of this MIB module is part of RFC 4805;\nsee the RFC itself for full legal notices.")
dsx1ConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 6))
if mibBuilder.loadTexts: dsx1ConfigTable.setDescription("The DS1 Configuration table.")
dsx1ConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 6, 1)).setIndexNames((0, "DS1-MIB", "dsx1LineIndex"))
if mibBuilder.loadTexts: dsx1ConfigEntry.setDescription("An entry in the DS1 Configuration table.")
dsx1LineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1LineIndex.setDescription("This object should be made equal to ifIndex.  The\nnext paragraph describes its previous usage.\nMaking the object equal to ifIndex allows proper\nuse of the ifStackTable and ds0/ds0bundle MIBs.\n\nPreviously, this object was the identifier of a DS1\ninterface on a managed device.  If there is an\nifEntry that is directly associated with this and\nonly this DS1 interface, it should have the same\nvalue as ifIndex.  Otherwise, number the\ndsx1LineIndices with a unique identifier\nfollowing the rules of choosing a number that is\ngreater than ifNumber and numbering the inside\ninterfaces (e.g., equipment side) with even\nnumbers and outside interfaces (e.g., network\nside) with odd numbers.")
dsx1IfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IfIndex.setDescription("This value for this object is equal to the value\n\n\n\nof ifIndex from the Interfaces table (RFC 2863).")
dsx1TimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TimeElapsed.setDescription("The number of seconds that have elapsed since the\nbeginning of the near-end current error-\nmeasurement period.  If, for some reason, such as\nan adjustment in the system's time-of-day clock,\nthe current interval exceeds the maximum value,\nthe agent will return the maximum value.")
dsx1ValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1ValidIntervals.setDescription("The number of previous near-end intervals for\nwhich data was collected.  The value will be 96\nunless the interface was brought online within the\nlast 24 hours, in which case the value will be the\nnumber of complete 15-minute near-end intervals\nsince the interface has been online.  In the case\nwhere the agent is a proxy, it is possible that\nsome intervals are unavailable.  In this case,\nthis interval is the maximum interval number for\nwhich data is available.")
dsx1LineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(7,10,8,16,9,3,11,4,2,14,1,13,6,12,5,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("dsx1DS2M12", 10), ("dsx1E2", 11), ("dsx1E1Q50", 12), ("dsx1E1Q50CRC", 13), ("dsx1J1ESF", 14), ("dsx1J1Unframed", 16), ("dsx1ESF", 2), ("dsx1D4", 3), ("dsx1E1", 4), ("dsx1E1CRC", 5), ("dsx1E1MF", 6), ("dsx1E1CRCMF", 7), ("dsx1Unframed", 8), ("dsx1E1Unframed", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineType.setDescription("This variable indicates the variety of DS1\nLine implementing this circuit.  The type of\ncircuit affects the number of bits per second\nthat the circuit can reasonably carry, as well\nas the interpretation of the usage and error\nstatistics.  The values, in sequence, describe:\n\n      TITLE:          SPECIFICATION:\n      dsx1ESF         Extended SuperFrame DS1\n                             (T1.107)\n      dsx1D4          AT&T D4 format DS1 (T1.107)\n      dsx1E1          ITU-T G.704, (Table 5A)\n      dsx1E1-CRC      ITU-T G.704, (Table 5B)\n      dsxE1-MF        G.704 (Table 5A) with TS16\n                             multiframing enabled\n      dsx1E1-CRC-MF   G.704 (Table 5B) with TS16\n                             multiframing enabled\n      dsx1Unframed    DS1 with No Framing\n      dsx1E1Unframed  E1 with No Framing (G.703)\n      dsx1DS2M12      DS2 frame format (T1.107)\n      dsx1E2          E2 frame format (G.704)\n      dsx1E1Q50       TS16 bits 5,7,8 set to 101,\n                      [in all other cases it is set\n                      to 111.] (G.704, table 14)\n      dsx1E1Q50CRC    E1Q50 with CRC\n      dsx1J1ESF       J1 according to (JT-G704,\n                             JT-G706, and JT-I431)\n      dsx1J1Unframed  J1 with No Framing\n\nFor clarification, the capacity for each E1 type\nis as listed below:\ndsx1E1Unframed - E1, no framing = 32 x 64k = 2048k\ndsx1E1 or dsx1E1CRC - E1, with framing,\nno signalling = 31 x 64k = 1984k\ndsx1E1MF or dsx1E1CRCMF - E1, with framing,\nsignalling = 30 x 64k = 1920k")
dsx1LineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,6,2,7,5,3,1,)).subtype(namedValues=namedval.NamedValues(("dsx1JBZS", 1), ("dsx1B8ZS", 2), ("dsx1HDB3", 3), ("dsx1ZBTSI", 4), ("dsx1AMI", 5), ("other", 6), ("dsx1B6ZS", 7), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineCoding.setDescription("This variable describes the variety of Zero Code\nSuppression used on this interface, which in turn\naffects a number of its characteristics.\n\ndsx1JBZS refers the Jammed Bit Zero Suppression,\nin which the AT&T specification of at least one\npulse every 8-bit period is literally implemented\nby forcing a pulse in bit 8 of each channel.\nThus, only 7 bits per channel, or 1.344 Mbps,\nare available for data.\n\ndsx1B8ZS refers to the use of a specified pattern\nof normal bits and bipolar violations that are\nused to replace a sequence of 8 zero bits.\nANSI Clear Channels may use dsx1ZBTSI, or Zero\nByte Time Slot Interchange.\n\nE1 links, with or without CRC, use dsx1HDB3 or\ndsx1AMI.\n\ndsx1AMI refers to a mode wherein no Zero Code\nSuppression is present and the line encoding does\n\n\n\nnot solve the problem directly.  In this\napplication, the higher layer must provide data\nthat meets or exceeds the pulse density\nrequirements, such as inverting HDLC data.\n\ndsx1B6ZS refers to the user of a specified pattern\nof normal bits and bipolar violations that are\nused to replace a sequence of 6 zero bits.  Used\nfor DS2.\nFor more information about line coding see\n[ANSI-T1.102]")
dsx1SendCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,5,2,8,3,1,7,6,)).subtype(namedValues=namedval.NamedValues(("dsx1SendNoCode", 1), ("dsx1SendLineCode", 2), ("dsx1SendPayloadCode", 3), ("dsx1SendResetCode", 4), ("dsx1SendQRS", 5), ("dsx1Send511Pattern", 6), ("dsx1Send3in24Pattern", 7), ("dsx1SendOtherTestPattern", 8), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1SendCode.setDescription("This variable indicates what type of code is\nbeing sent across the DS1 interface by the device.\nSetting this variable causes the interface to send\nthe code requested.  The values mean the following:\n\ndsx1SendNoCode\nsending looped or normal data\n\ndsx1SendLineCode\nsending a request for a line loopback\n\ndsx1SendPayloadCode\nsending a request for a payload loopback\n\ndsx1SendResetCode\nsending a loopback termination request\n\ndsx1SendQRS\nsending a Quasi-Random Signal (QRS) test\npattern\n\n\n\n\ndsx1Send511Pattern\nsending a 511-bit fixed test pattern\n\ndsx1Send3in24Pattern\nsending a fixed test pattern of 3 bits set\nin 24\n\ndsx1SendOtherTestPattern\nsending a test pattern other than those\ndescribed by this object")
dsx1CircuitIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 8), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1CircuitIdentifier.setDescription("This variable contains the transmission vendor's\ncircuit identifier, for the purpose of\nfacilitating troubleshooting.")
dsx1LoopbackConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,1,6,2,3,4,)).subtype(namedValues=namedval.NamedValues(("dsx1NoLoop", 1), ("dsx1PayloadLoop", 2), ("dsx1LineLoop", 3), ("dsx1OtherLoop", 4), ("dsx1InwardLoop", 5), ("dsx1DualLoop", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LoopbackConfig.setDescription("This variable represents the desired loopback\nconfiguration of the DS1 interface.  Agents\nsupporting read/write access should return\ninconsistentValue in response to a requested\nloopback state that the interface does not\nsupport.  The values mean:\n\ndsx1NoLoop\nnot in the loopback state.  A device that is not\ncapable of performing a loopback on the interface\nshall always return this as its value.\n\ndsx1PayloadLoop\n\n\n\nthe received signal at this interface is looped\nthrough the device.  Typically, the received signal\nis looped back for retransmission after it has\npassed through the device's framing function.\n\ndsx1LineLoop\nthe received signal at this interface does not go\nthrough the device (minimum penetration) but is\nlooped back out.\n\ndsx1OtherLoop\nloopbacks that are not defined here.\n\ndsx1InwardLoop\nthe transmitted signal at this interface is\nlooped back and received by the same interface.\nWhat is transmitted onto the line is product\ndependent.\n\ndsx1DualLoop\nboth dsx1LineLoop and dsx1InwardLoop will be\nactive simultaneously.")
dsx1LineStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 131071))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1LineStatus.setDescription("This variable indicates the line status of the\ninterface.  It contains loopback, failure,\nreceived alarm and transmitted alarms\ninformation.\n\nThe dsx1LineStatus is a bitmap represented as a\nsum; therefore, it can represent multiple failures\n(alarms) and a LoopbackState simultaneously.\n\ndsx1NoAlarm must be set if and only if no other\nflag is set.\n\nIf the dsx1loopbackState bit is set, the loopback\nin effect can be determined from the\ndsx1loopbackConfig object.  The various bit\npositions are as follows:\n\n1     dsx1NoAlarm           No alarm present\n2     dsx1RcvFarEndLOF      Far end LOF (a.k.a.\n\n\n\n                      Yellow Alarm)\n4     dsx1XmtFarEndLOF      Near end sending LOF\n                      indication\n8     dsx1RcvAIS            Far end sending AIS\n16     dsx1XmtAIS            Near end sending AIS\n32     dsx1LossOfFrame       Near end LOF (a.k.a.\n                      Red Alarm)\n64     dsx1LossOfSignal      Near end Loss of Signal\n128     dsx1LoopbackState     Near end is looped\n256     dsx1T16AIS            E1 TS16 AIS\n512     dsx1RcvFarEndLOMF     Far end sending TS16 LOMF\n1024     dsx1XmtFarEndLOMF     Near end sending TS16 LOMF\n2048     dsx1RcvTestCode       Near end detects a test code\n4096     dsx1OtherFailure      Any line status not defined\n                      here\n8192     dsx1UnavailSigState   Near end in unavailable\n                      signal state\n16384     dsx1NetEquipOOS       Carrier equipment out of\n                      service\n32768     dsx1RcvPayloadAIS     DS2 payload AIS\n65536     dsx1Ds2PerfThreshold  DS2 performance threshold\n                      exceeded")
dsx1SignalMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,3,5,2,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("robbedBit", 2), ("bitOriented", 3), ("messageOriented", 4), ("other", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1SignalMode.setDescription("'none' indicates that no bits are reserved for\nsignaling on this channel.\n\n'robbedBit' indicates that DS1 Robbed Bit Signaling\nis in use.\n\n'bitOriented' indicates that E1 Channel Associated\nSignaling is in use.\n\n'messageOriented' indicates that Common Channel\nSignaling is in use on either channel 16 of\nan E1 link or channel 24 of a DS1.")
dsx1TransmitClockSource = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("loopTiming", 1), ("localTiming", 2), ("throughTiming", 3), ("adaptive", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1TransmitClockSource.setDescription("The source of transmit clock.\n\n'loopTiming' indicates that the recovered\nreceive clock is used as the transmit clock.\n\n'localTiming' indicates that a local clock\nsource is used or when an external clock is\nattached to the box containing the interface.\n\n'throughTiming' indicates that recovered\nreceive clock from another interface is used as\nthe transmit clock.\n\n'adaptive' indicates that the clock is recovered\nbased on the data flow and not based on the\nphysical layer")
dsx1Fdl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1Fdl.setDescription("This bitmap describes the use of the\nfacilities data link and is the sum of the\ncapabilities.  Set any bits that are appropriate:\n\nother(1),\ndsx1AnsiT1403(2),\ndsx1Att54016(4),\ndsx1FdlNone(8)\n\n 'other' indicates that a protocol other than\none of the following is used.\n\n 'dsx1AnsiT1403' refers to the FDL exchange\nrecommended by ANSI.\n\n\n\n\n 'dsx1Att54016' refers to ESF FDL exchanges.\n\n 'dsx1FdlNone' indicates that the device does\nnot use the FDL.")
dsx1InvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1InvalidIntervals.setDescription("The number of intervals in the range from 0 to\ndsx1ValidIntervals for which no data is available.\nThis object will typically be zero except in cases\nwhere the data for some intervals is not\navailable (e.g., in proxy situations).")
dsx1LineLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 64000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineLength.setDescription("The length of the DS1 line in meters.  This\nobject provides information for line build-out\ncircuitry.  This object is only useful if the\ninterface has configurable line build-out\ncircuitry.")
dsx1LineStatusLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 16), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1LineStatusLastChange.setDescription("The value of MIB II's sysUpTime object at the\ntime this DS1 entered its current line status\nstate.  If the current state was entered prior to\nthe last re-initialization of the proxy-agent,\nthen this object contains a zero value.")
dsx1LineStatusChangeTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineStatusChangeTrapEnable.setDescription("Indicates whether dsx1LineStatusChange traps\nshould be generated for this interface.")
dsx1LoopbackStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 18), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1LoopbackStatus.setDescription("This variable represents the current state of the\nloopback on the DS1 interface.  It contains\ninformation about loopbacks established by a\nmanager and remotely from the far end.\n\nThe dsx1LoopbackStatus is a bitmap represented as\na sum; therefore, it can represent multiple\nloopbacks simultaneously.\n\nThe various bit positions are as follows:\n 1  dsx1NoLoopback\n 2  dsx1NearEndPayloadLoopback\n 4  dsx1NearEndLineLoopback\n 8  dsx1NearEndOtherLoopback\n16  dsx1NearEndInwardLoopback\n32  dsx1FarEndPayloadLoopback\n64  dsx1FarEndLineLoopback")
dsx1Ds1ChannelNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 19), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 28))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1Ds1ChannelNumber.setDescription("This variable represents the channel number of\nthe DS1/E1 on its parent DS2/E2 or DS3/E3.  A\nvalue of 0 indicates that this DS1/E1 does not\nhave a parent DS3/E3.")
dsx1Channelization = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("enabledDs0", 2), ("enabledDs1", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1Channelization.setDescription("Indicates whether this DS1/E1 or DS2 is\nchannelized or unchannelized.\n\nThe value of enabledDs0(2) indicates that this is a\nDS1 channelized into DS0s.  Setting this value will\ncause the creation, and resetting it to disabled(1)\nwill cause the deletion of entries in the ifTable\nfor the DS0s that are within the DS1.\n\nThe value of enabledDs1(3) indicates that this is a\nDS2 channelized into DS1s.  Setting this value will\ncause the creation, and resetting it to disabled(1)\nwill cause the deletion of entries in the ifTable\nfor the DS1s that are within the DS2.")
dsx1LineMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("csu", 1), ("dsu", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineMode.setDescription("This setting puts the T1 framer into either\nlong-haul (CSU) mode or short-haul (DSU) mode.")
dsx1LineBuildOut = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 22), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,2,1,5,)).subtype(namedValues=namedval.NamedValues(("notApplicable", 1), ("neg75dB", 2), ("neg15dB", 3), ("neg225dB", 4), ("zerodB", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineBuildOut.setDescription("Attenuation setting for T1 framer in long haul\n(CSU) mode.  The optional values are -7.5dB,\n-15dB, -22.5dB, and 0dB.")
dsx1LineImpedance = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 6, 1, 23), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,4,)).subtype(namedValues=namedval.NamedValues(("notApplicable", 1), ("unbalanced75ohms", 2), ("balanced100ohms", 3), ("balanced120ohms", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1LineImpedance.setDescription("Nominal line impedance.  For T1 and J1 lines, the\nvalue is typically balanced100ohms(3).  For E1\nlines, the value is typically unbalanced75ohms(2)\nand balanced120ohms(4).  When this object does not\napply, or when the appropriate value is not known,\nthe value should be set to notApplicable(1).")
dsx1CurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 7))
if mibBuilder.loadTexts: dsx1CurrentTable.setDescription("The DS1 Current table contains various statistics\nbeing collected for the current 15-minute\ninterval.")
dsx1CurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 7, 1)).setIndexNames((0, "DS1-MIB", "dsx1CurrentIndex"))
if mibBuilder.loadTexts: dsx1CurrentEntry.setDescription("An entry in the DS1 Current table.")
dsx1CurrentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentIndex.setDescription("The index value that uniquely identifies the DS1\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is the same interface as identified by the\nsame value as a dsx1LineIndex object instance.")
dsx1CurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentESs.setDescription("The number of Errored Seconds.")
dsx1CurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentSESs.setDescription("The number of Severely Errored Seconds.")
dsx1CurrentSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentSEFSs.setDescription("The number of Severely Errored Framing Seconds.")
dsx1CurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentUASs.setDescription("The number of Unavailable Seconds.")
dsx1CurrentCSSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 6), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentCSSs.setDescription("The number of Controlled Slip Seconds.")
dsx1CurrentPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 7), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentPCVs.setDescription("The number of Path Coding Violations.")
dsx1CurrentLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentLESs.setDescription("The number of Line Errored Seconds.")
dsx1CurrentBESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentBESs.setDescription("The number of Bursty Errored Seconds.")
dsx1CurrentDMs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentDMs.setDescription("The number of Degraded Minutes.")
dsx1CurrentLCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 7, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1CurrentLCVs.setDescription("The number of Line Coding Violations (LCVs).")
dsx1IntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 8))
if mibBuilder.loadTexts: dsx1IntervalTable.setDescription("The DS1 Interval table contains various\nstatistics collected by each DS1 interface over\nthe previous 24 hours of operation.  The past 24\nhours are broken into 96 completed 15-minute\nintervals.  Each row in this table represents one\nsuch interval (identified by dsx1IntervalNumber)\nfor one specific instance (identified by\ndsx1IntervalIndex).")
dsx1IntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 8, 1)).setIndexNames((0, "DS1-MIB", "dsx1IntervalIndex"), (0, "DS1-MIB", "dsx1IntervalNumber"))
if mibBuilder.loadTexts: dsx1IntervalEntry.setDescription("An entry in the DS1 Interval table.")
dsx1IntervalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalIndex.setDescription("The index value that uniquely identifies the DS1\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is the same interface as identified by the\nsame value as a dsx1LineIndex object instance.")
dsx1IntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalNumber.setDescription("A number between 1 and 96, where 1 is the most\nrecently completed 15-minute interval and 96 is\nthe 15-minute interval completed 23 hours and 45\nminutes prior to interval 1.")
dsx1IntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalESs.setDescription("The number of Errored Seconds.")
dsx1IntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalSESs.setDescription("The number of Severely Errored Seconds.")
dsx1IntervalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalSEFSs.setDescription("The number of Severely Errored Framing Seconds.")
dsx1IntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 6), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalUASs.setDescription("The number of Unavailable Seconds.  This object\nmay decrease if the occurrence of unavailable\nseconds occurs across an interval boundary.")
dsx1IntervalCSSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 7), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalCSSs.setDescription("The number of Controlled Slip Seconds.")
dsx1IntervalPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 8), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalPCVs.setDescription("The number of Path Coding Violations.")
dsx1IntervalLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 9), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalLESs.setDescription("The number of Line Errored Seconds.")
dsx1IntervalBESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 10), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalBESs.setDescription("The number of Bursty Errored Seconds.")
dsx1IntervalDMs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 11), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalDMs.setDescription("The number of Degraded Minutes.")
dsx1IntervalLCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 12), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalLCVs.setDescription("The number of Line Coding Violations.")
dsx1IntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 8, 1, 13), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1IntervalValidData.setDescription("This variable indicates whether the data for this\ninterval is valid.")
dsx1TotalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 9))
if mibBuilder.loadTexts: dsx1TotalTable.setDescription("The DS1 Total table contains the cumulative sum\nof the various statistics for the 24-hour period\npreceding the current interval.")
dsx1TotalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 9, 1)).setIndexNames((0, "DS1-MIB", "dsx1TotalIndex"))
if mibBuilder.loadTexts: dsx1TotalEntry.setDescription("An entry in the DS1 Total table.")
dsx1TotalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalIndex.setDescription("The index value that uniquely identifies the DS1\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is the same interface as identified by the\nsame value as a dsx1LineIndex object instance.")
dsx1TotalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 2), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalESs.setDescription("The number of Errored Seconds encountered by a DS1\ninterface in the previous 24-hour interval.\nInvalid 15-minute intervals count as 0.")
dsx1TotalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 3), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalSESs.setDescription("The number of Severely Errored Seconds\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1TotalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 4), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalSEFSs.setDescription("The number of Severely Errored Framing Seconds\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1TotalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 5), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalUASs.setDescription("The number of Unavailable Seconds encountered by\na DS1 interface in the previous 24-hour interval.\nInvalid 15-minute intervals count as 0.")
dsx1TotalCSSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 6), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalCSSs.setDescription("The number of Controlled Slip Seconds encountered\nby a DS1 interface in the previous 24-hour\ninterval.  Invalid 15-minute intervals count as\n0.")
dsx1TotalPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 7), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalPCVs.setDescription("The number of Path Coding Violations encountered\nby a DS1 interface in the previous 24-hour\ninterval.  Invalid 15-minute intervals count as\n0.")
dsx1TotalLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 8), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalLESs.setDescription("The number of Line Errored Seconds encountered by\na DS1 interface in the previous 24-hour interval.\nInvalid 15-minute intervals count as 0.")
dsx1TotalBESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 9), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalBESs.setDescription("The number of Bursty Errored Seconds (BESs)\n\n\n\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals count\nas 0.")
dsx1TotalDMs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 10), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalDMs.setDescription("The number of Degraded Minutes (DMs) encountered\nby a DS1 interface in the previous 24-hour\ninterval.  Invalid 15-minute intervals count as\n0.")
dsx1TotalLCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 9, 1, 11), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1TotalLCVs.setDescription("The number of Line Coding Violations (LCVs)\nencountered by a DS1 interface in the current\n15-minute interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1FarEndCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 10))
if mibBuilder.loadTexts: dsx1FarEndCurrentTable.setDescription("The DS1 Far End Current table contains various\nstatistics being collected for the current\n15-minute interval.  The statistics are collected\n\n\n\nfrom the far-end messages on the Facilities Data\nLink.  The definitions are the same as described\nfor the near-end information.")
dsx1FarEndCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 10, 1)).setIndexNames((0, "DS1-MIB", "dsx1FarEndCurrentIndex"))
if mibBuilder.loadTexts: dsx1FarEndCurrentEntry.setDescription("An entry in the DS1 Far End Current table.")
dsx1FarEndCurrentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentIndex.setDescription("The index value that uniquely identifies the DS1\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is identical to the interface identified by\nthe same value of dsx1LineIndex.")
dsx1FarEndTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTimeElapsed.setDescription("The number of seconds that have elapsed since the\nbeginning of the far-end current error-measurement\nperiod.  If, for some reason, such as an adjustment\nin the system's time-of-day clock, the current\ninterval exceeds the maximum value, the agent will\nreturn the maximum value.")
dsx1FarEndValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndValidIntervals.setDescription("The number of previous far-end intervals for\nwhich data was collected.  The value will be 96\nunless the interface was brought online within the\nlast 24 hours, in which case the value will be the\nnumber of complete 15-minute far-end intervals\nsince the interface has been online.  In the case\nwhere the agent is a proxy, it is possible that\nsome intervals are unavailable.  In this case,\nthis interval is the maximum interval number for\nwhich data is available.")
dsx1FarEndCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentESs.setDescription("The number of Far End Errored Seconds.")
dsx1FarEndCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentSESs.setDescription("The number of Far End Severely Errored Seconds.")
dsx1FarEndCurrentSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 6), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentSEFSs.setDescription("The number of Far End Severely Errored Framing\n\n\n\nSeconds.")
dsx1FarEndCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 7), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentUASs.setDescription("The number of Unavailable Seconds.")
dsx1FarEndCurrentCSSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentCSSs.setDescription("The number of Far End Controlled Slip Seconds.")
dsx1FarEndCurrentLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentLESs.setDescription("The number of Far End Line Errored Seconds.")
dsx1FarEndCurrentPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentPCVs.setDescription("The number of Far End Path Coding Violations.")
dsx1FarEndCurrentBESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentBESs.setDescription("The number of Far End Bursty Errored Seconds.")
dsx1FarEndCurrentDMs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 12), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndCurrentDMs.setDescription("The number of Far End Degraded Minutes.")
dsx1FarEndInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 10, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndInvalidIntervals.setDescription("The number of intervals in the range from 0 to\ndsx1FarEndValidIntervals for which no data is\navailable.  This object will typically be zero\nexcept in cases where the data for some intervals\nis not available (e.g., in proxy situations).")
dsx1FarEndIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 11))
if mibBuilder.loadTexts: dsx1FarEndIntervalTable.setDescription("The DS1 Far End Interval table contains various\nstatistics collected by each DS1 interface over\nthe previous 24 hours of operation.  The past 24\nhours are broken into 96 completed 15-minute\nintervals.  Each row in this table represents one\nsuch interval (identified by\ndsx1FarEndIntervalNumber) for one specific\ninstance (identified by dsx1FarEndIntervalIndex).")
dsx1FarEndIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 11, 1)).setIndexNames((0, "DS1-MIB", "dsx1FarEndIntervalIndex"), (0, "DS1-MIB", "dsx1FarEndIntervalNumber"))
if mibBuilder.loadTexts: dsx1FarEndIntervalEntry.setDescription("An entry in the DS1 Far End Interval table.")
dsx1FarEndIntervalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalIndex.setDescription("The index value that uniquely identifies the DS1\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is identical to the interface identified by\nthe same value of dsx1LineIndex.")
dsx1FarEndIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalNumber.setDescription("A number between 1 and 96, where 1 is the most\nrecently completed 15-minute interval and 96 is\nthe 15 minutes interval completed 23 hours and 45\nminutes prior to interval 1.")
dsx1FarEndIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalESs.setDescription("The number of Far End Errored Seconds.")
dsx1FarEndIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalSESs.setDescription("The number of Far End Severely Errored Seconds.")
dsx1FarEndIntervalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalSEFSs.setDescription("The number of Far End Severely Errored Framing\nSeconds.")
dsx1FarEndIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 6), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalUASs.setDescription("The number of Unavailable Seconds.")
dsx1FarEndIntervalCSSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 7), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalCSSs.setDescription("The number of Far End Controlled Slip Seconds.")
dsx1FarEndIntervalLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 8), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalLESs.setDescription("The number of Far End Line Errored Seconds.")
dsx1FarEndIntervalPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 9), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalPCVs.setDescription("The number of Far End Path Coding Violations.")
dsx1FarEndIntervalBESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 10), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalBESs.setDescription("The number of Far End Bursty Errored Seconds.")
dsx1FarEndIntervalDMs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 11), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalDMs.setDescription("The number of Far End Degraded Minutes.")
dsx1FarEndIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 11, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndIntervalValidData.setDescription(" This variable indicates if the data for this\ninterval is valid.")
dsx1FarEndTotalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 12))
if mibBuilder.loadTexts: dsx1FarEndTotalTable.setDescription("The DS1 Far End Total table contains the\ncumulative sum of the various statistics for the\n24-hour period preceding the current interval.")
dsx1FarEndTotalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 12, 1)).setIndexNames((0, "DS1-MIB", "dsx1FarEndTotalIndex"))
if mibBuilder.loadTexts: dsx1FarEndTotalEntry.setDescription("An entry in the DS1 Far End Total table.")
dsx1FarEndTotalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalIndex.setDescription("The index value that uniquely identifies the DS1\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is identical to the interface identified by\nthe same value of dsx1LineIndex.")
dsx1FarEndTotalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 2), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalESs.setDescription("The number of Far End Errored Seconds encountered\nby a DS1 interface in the previous 24-hour\ninterval.  Invalid 15-minute intervals count as\n0.")
dsx1FarEndTotalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 3), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalSESs.setDescription("The number of Far End Severely Errored Seconds\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1FarEndTotalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 4), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalSEFSs.setDescription("The number of Far End Severely Errored Framing\nSeconds encountered by a DS1 interface in the\nprevious 24-hour interval.  Invalid 15-minute\nintervals count as 0.")
dsx1FarEndTotalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 5), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalUASs.setDescription("The number of Unavailable Seconds encountered by\na DS1 interface in the previous 24-hour interval.\nInvalid 15-minute intervals count as 0.")
dsx1FarEndTotalCSSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 6), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalCSSs.setDescription("The number of Far End Controlled Slip Seconds\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15 minute intervals\ncount as 0.")
dsx1FarEndTotalLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 7), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalLESs.setDescription("The number of Far End Line Errored Seconds\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1FarEndTotalPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 8), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalPCVs.setDescription("The number of Far End Path Coding Violations\nreported via the far end block error count\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1FarEndTotalBESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 9), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalBESs.setDescription("The number of Bursty Errored Seconds (BESs)\nencountered by a DS1 interface in the previous\n24-hour interval.  Invalid 15-minute intervals\ncount as 0.")
dsx1FarEndTotalDMs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 12, 1, 10), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FarEndTotalDMs.setDescription("The number of Degraded Minutes (DMs) encountered\nby a DS1 interface in the previous 24-hour\ninterval.  Invalid 15-minute intervals count as\n0.")
dsx1FracTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 13))
if mibBuilder.loadTexts: dsx1FracTable.setDescription("This table is deprecated in favor of using\nifStackTable.\n\nThe table was mandatory for systems dividing a DS1\ninto channels containing different data streams\nthat are of local interest.  Systems that are\nindifferent to data content, such as CSUs, need\nnot implement it.\n\nThe DS1 Fractional table identifies which DS1\nchannels associated with a CSU are being used to\nsupport a logical interface, i.e., an entry in the\ninterfaces table from the Internet-standard MIB.\n\nFor example, consider an application managing a\nNorth American ISDN Primary Rate link whose\ndivision is a 384-kbit/s H1 _B_ Channel for video,\n\n\n\na second H1 for data to a primary routing peer,\nand 12 64-kbit/s H0 _B_ Channels.  Consider that\nsome subset of the H0 channels is used for voice\nand the remainder are available for dynamic data\ncalls.\n\nWe count a total of 14 interfaces multiplexed onto\nthe DS1 interface.  Six DS1 channels (for the sake\nof the example, channels 1..6) are used for video,\nsix more (7..11 and 13) are used for data, and the\nremaining 12 are in channels 12 and 14..24.\n\nLet us further imagine that ifIndex 2 is of type\nDS1 and refers to the DS1 interface and that the\ninterfaces layered onto it are numbered 3..16.\n\nWe might describe the allocation of channels, in\nthe dsx1FracTable, as follows:\ndsx1FracIfIndex.2. 1 = 3  dsx1FracIfIndex.2.13 = 4\ndsx1FracIfIndex.2. 2 = 3  dsx1FracIfIndex.2.14 = 6\ndsx1FracIfIndex.2. 3 = 3  dsx1FracIfIndex.2.15 = 7\ndsx1FracIfIndex.2. 4 = 3  dsx1FracIfIndex.2.16 = 8\ndsx1FracIfIndex.2. 5 = 3  dsx1FracIfIndex.2.17 = 9\ndsx1FracIfIndex.2. 6 = 3  dsx1FracIfIndex.2.18 = 10\ndsx1FracIfIndex.2. 7 = 4  dsx1FracIfIndex.2.19 = 11\ndsx1FracIfIndex.2. 8 = 4  dsx1FracIfIndex.2.20 = 12\ndsx1FracIfIndex.2. 9 = 4  dsx1FracIfIndex.2.21 = 13\ndsx1FracIfIndex.2.10 = 4  dsx1FracIfIndex.2.22 = 14\ndsx1FracIfIndex.2.11 = 4  dsx1FracIfIndex.2.23 = 15\ndsx1FracIfIndex.2.12 = 5  dsx1FracIfIndex.2.24 = 16\n\nFor North American (DS1) interfaces, there are 24\nlegal channels, numbered 1 through 24.\n\nFor G.704 interfaces, there are 31 legal channels,\nnumbered 1 through 31.  The channels (1..31)\ncorrespond directly to the equivalently numbered\ntime-slots.")
dsx1FracEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 13, 1)).setIndexNames((0, "DS1-MIB", "dsx1FracIndex"), (0, "DS1-MIB", "dsx1FracNumber"))
if mibBuilder.loadTexts: dsx1FracEntry.setDescription("An entry in the DS1 Fractional table.")
dsx1FracIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 13, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FracIndex.setDescription("The index value that uniquely identifies the\nDS1 interface to which this entry is applicable.\nThe interface identified by a particular\nvalue of this index is the same interface as\nidentified by the same value as a dsx1LineIndex\nobject instance.")
dsx1FracNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 13, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1FracNumber.setDescription("The channel number for this entry.")
dsx1FracIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 13, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx1FracIfIndex.setDescription("An index value that uniquely identifies an\ninterface.  The interface identified by a particular\nvalue of this index is the same interface\nas identified by the same value as an ifIndex\nobject instance.  If no interface is currently using\na channel, the value should be zero.  If a\nsingle interface occupies more than one time-slot,\nthat ifIndex value will be found in multiple\ntime-slots.")
ds1Conformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 18, 14))
ds1Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 18, 14, 1))
ds1Compliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 18, 14, 2))
ds1Traps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 18, 15))
dsx1ChanMappingTable = MibTable((1, 3, 6, 1, 2, 1, 10, 18, 16))
if mibBuilder.loadTexts: dsx1ChanMappingTable.setDescription("The DS1 Channel Mapping table.  This table maps a\nDS1 channel number on a particular DS3 into an\nifIndex.  In the presence of DS2s, this table can\nbe used to map a DS2 channel number on a DS3 into\nan ifIndex, or used to map a DS1 channel number on\na DS2 into an ifIndex.")
dsx1ChanMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 18, 16, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DS1-MIB", "dsx1Ds1ChannelNumber"))
if mibBuilder.loadTexts: dsx1ChanMappingEntry.setDescription("An entry in the DS1 Channel Mapping table.  There\n\n\n\nis an entry in this table corresponding to each\nDS1 ifEntry within any interface that is\nchannelized to the individual DS1 ifEntry level.\n\nThis table is intended to facilitate mapping from\nchannelized interface / channel number to DS1\nifEntry (e.g., mapping (DS3 ifIndex, DS1 channel\nnumber) -> ifIndex).\n\nWhile this table provides information that can\nalso be found in the ifStackTable and\ndsx1ConfigTable, it provides this same information\nwith a single table lookup, rather than by walking\nthe ifStackTable to find the various constituent\nDS1 ifTable entries, and testing various\ndsx1ConfigTable entries to check for the entry\nwith the applicable DS1 channel number.")
dsx1ChanMappedIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 18, 16, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx1ChanMappedIfIndex.setDescription("This object indicates the ifIndex value assigned\nby the agent for the individual DS1 ifEntry that\ncorresponds to the given DS1 channel number\n(specified by the INDEX element\ndsx1Ds1ChannelNumber) of the given channelized\ninterface (specified by INDEX element ifIndex).")

# Augmentions

# Notifications

dsx1LineStatusChange = NotificationType((1, 3, 6, 1, 2, 1, 10, 18, 15, 0, 1)).setObjects(("DS1-MIB", "dsx1LineStatus"), ("DS1-MIB", "dsx1LineStatusLastChange"), )
if mibBuilder.loadTexts: dsx1LineStatusChange.setDescription("A dsx1LineStatusChange trap is sent when the\nvalue of an instance dsx1LineStatus changes.  It\ncan be utilized by an Network Management Station\n(NMS) to trigger polls.  When the line status\nchange results from a higher-level line status\nchange (i.e., DS3), then no traps for the DS1\nare sent.")

# Groups

ds1NearEndConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 1)).setObjects(("DS1-MIB", "dsx1LineStatus"), ("DS1-MIB", "dsx1LineIndex"), ("DS1-MIB", "dsx1LineLength"), ("DS1-MIB", "dsx1SendCode"), ("DS1-MIB", "dsx1LoopbackStatus"), ("DS1-MIB", "dsx1TransmitClockSource"), ("DS1-MIB", "dsx1ValidIntervals"), ("DS1-MIB", "dsx1TimeElapsed"), ("DS1-MIB", "dsx1InvalidIntervals"), ("DS1-MIB", "dsx1CircuitIdentifier"), ("DS1-MIB", "dsx1Channelization"), ("DS1-MIB", "dsx1LineCoding"), ("DS1-MIB", "dsx1SignalMode"), ("DS1-MIB", "dsx1Ds1ChannelNumber"), ("DS1-MIB", "dsx1LoopbackConfig"), ("DS1-MIB", "dsx1Fdl"), ("DS1-MIB", "dsx1LineType"), )
if mibBuilder.loadTexts: ds1NearEndConfigGroup.setDescription("A collection of objects providing configuration\ninformation applicable to all DS1 interfaces.")
ds1NearEndStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 2)).setObjects(("DS1-MIB", "dsx1TotalLCVs"), ("DS1-MIB", "dsx1TotalUASs"), ("DS1-MIB", "dsx1CurrentSEFSs"), ("DS1-MIB", "dsx1CurrentLESs"), ("DS1-MIB", "dsx1IntervalNumber"), ("DS1-MIB", "dsx1IntervalUASs"), ("DS1-MIB", "dsx1CurrentUASs"), ("DS1-MIB", "dsx1CurrentIndex"), ("DS1-MIB", "dsx1IntervalBESs"), ("DS1-MIB", "dsx1CurrentDMs"), ("DS1-MIB", "dsx1TotalCSSs"), ("DS1-MIB", "dsx1IntervalValidData"), ("DS1-MIB", "dsx1TotalSEFSs"), ("DS1-MIB", "dsx1IntervalSEFSs"), ("DS1-MIB", "dsx1CurrentBESs"), ("DS1-MIB", "dsx1IntervalLCVs"), ("DS1-MIB", "dsx1IntervalLESs"), ("DS1-MIB", "dsx1TotalPCVs"), ("DS1-MIB", "dsx1TotalESs"), ("DS1-MIB", "dsx1CurrentLCVs"), ("DS1-MIB", "dsx1TotalLESs"), ("DS1-MIB", "dsx1TotalDMs"), ("DS1-MIB", "dsx1TotalSESs"), ("DS1-MIB", "dsx1IntervalIndex"), ("DS1-MIB", "dsx1CurrentESs"), ("DS1-MIB", "dsx1IntervalDMs"), ("DS1-MIB", "dsx1TotalBESs"), ("DS1-MIB", "dsx1IntervalESs"), ("DS1-MIB", "dsx1CurrentPCVs"), ("DS1-MIB", "dsx1TotalIndex"), ("DS1-MIB", "dsx1CurrentSESs"), ("DS1-MIB", "dsx1IntervalCSSs"), ("DS1-MIB", "dsx1IntervalSESs"), ("DS1-MIB", "dsx1IntervalPCVs"), ("DS1-MIB", "dsx1CurrentCSSs"), )
if mibBuilder.loadTexts: ds1NearEndStatisticsGroup.setDescription("A collection of objects providing statistics\ninformation applicable to all DS1 interfaces.")
ds1FarEndGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 3)).setObjects(("DS1-MIB", "dsx1FarEndTotalESs"), ("DS1-MIB", "dsx1FarEndIntervalUASs"), ("DS1-MIB", "dsx1FarEndTotalSESs"), ("DS1-MIB", "dsx1FarEndIntervalNumber"), ("DS1-MIB", "dsx1FarEndCurrentLESs"), ("DS1-MIB", "dsx1FarEndTimeElapsed"), ("DS1-MIB", "dsx1FarEndTotalUASs"), ("DS1-MIB", "dsx1FarEndTotalPCVs"), ("DS1-MIB", "dsx1FarEndTotalDMs"), ("DS1-MIB", "dsx1FarEndCurrentCSSs"), ("DS1-MIB", "dsx1FarEndCurrentBESs"), ("DS1-MIB", "dsx1FarEndIntervalSESs"), ("DS1-MIB", "dsx1FarEndTotalIndex"), ("DS1-MIB", "dsx1FarEndCurrentIndex"), ("DS1-MIB", "dsx1FarEndIntervalSEFSs"), ("DS1-MIB", "dsx1FarEndIntervalLESs"), ("DS1-MIB", "dsx1FarEndCurrentSEFSs"), ("DS1-MIB", "dsx1FarEndIntervalValidData"), ("DS1-MIB", "dsx1FarEndIntervalPCVs"), ("DS1-MIB", "dsx1FarEndCurrentPCVs"), ("DS1-MIB", "dsx1FarEndTotalCSSs"), ("DS1-MIB", "dsx1FarEndCurrentDMs"), ("DS1-MIB", "dsx1FarEndValidIntervals"), ("DS1-MIB", "dsx1FarEndCurrentESs"), ("DS1-MIB", "dsx1FarEndIntervalBESs"), ("DS1-MIB", "dsx1FarEndIntervalIndex"), ("DS1-MIB", "dsx1FarEndInvalidIntervals"), ("DS1-MIB", "dsx1FarEndCurrentSESs"), ("DS1-MIB", "dsx1FarEndIntervalCSSs"), ("DS1-MIB", "dsx1FarEndTotalSEFSs"), ("DS1-MIB", "dsx1FarEndCurrentUASs"), ("DS1-MIB", "dsx1FarEndIntervalDMs"), ("DS1-MIB", "dsx1FarEndTotalBESs"), ("DS1-MIB", "dsx1FarEndTotalLESs"), ("DS1-MIB", "dsx1FarEndIntervalESs"), )
if mibBuilder.loadTexts: ds1FarEndGroup.setDescription("A collection of objects providing remote\nconfiguration and statistics information.")
ds1DeprecatedGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 4)).setObjects(("DS1-MIB", "dsx1IfIndex"), ("DS1-MIB", "dsx1FracIndex"), ("DS1-MIB", "dsx1FracIfIndex"), ("DS1-MIB", "dsx1FracNumber"), )
if mibBuilder.loadTexts: ds1DeprecatedGroup.setDescription("A collection of obsolete objects that may be\nimplemented for backwards compatibility.")
ds1NearEndOptionalConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 5)).setObjects(("DS1-MIB", "dsx1LineStatusChangeTrapEnable"), ("DS1-MIB", "dsx1LineStatusLastChange"), )
if mibBuilder.loadTexts: ds1NearEndOptionalConfigGroup.setDescription("A collection of objects that may be implemented\non DS1 and DS2 interfaces.")
ds1DS2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 6)).setObjects(("DS1-MIB", "dsx1LineStatus"), ("DS1-MIB", "dsx1LineIndex"), ("DS1-MIB", "dsx1SendCode"), ("DS1-MIB", "dsx1SignalMode"), ("DS1-MIB", "dsx1Channelization"), ("DS1-MIB", "dsx1TransmitClockSource"), ("DS1-MIB", "dsx1LineCoding"), ("DS1-MIB", "dsx1LineType"), )
if mibBuilder.loadTexts: ds1DS2Group.setDescription("A collection of objects providing information\nabout DS2 (6,312 kbps) and E2 (8,448 kbps)\nsystems.")
ds1TransStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 7)).setObjects(("DS1-MIB", "dsx1CurrentSESs"), ("DS1-MIB", "dsx1TotalUASs"), ("DS1-MIB", "dsx1IntervalSESs"), ("DS1-MIB", "dsx1CurrentESs"), ("DS1-MIB", "dsx1TotalSESs"), ("DS1-MIB", "dsx1IntervalUASs"), ("DS1-MIB", "dsx1CurrentUASs"), ("DS1-MIB", "dsx1IntervalESs"), ("DS1-MIB", "dsx1TotalESs"), )
if mibBuilder.loadTexts: ds1TransStatsGroup.setDescription("A collection of objects that are the\nstatistics that can be collected from a DS1\ninterface that is running transparent or unframed\nlineType.  Statistics not in this list should\nreturn noSuchInstance.")
ds1NearEndOptionalTrapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 8)).setObjects(("DS1-MIB", "dsx1LineStatusChange"), )
if mibBuilder.loadTexts: ds1NearEndOptionalTrapGroup.setDescription("A collection of notifications that may be\nimplemented on DS1 and DS2 interfaces.")
ds1ChanMappingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 9)).setObjects(("DS1-MIB", "dsx1ChanMappedIfIndex"), )
if mibBuilder.loadTexts: ds1ChanMappingGroup.setDescription("A collection of objects that give a mapping of\nDS3 Channel (dsx1Ds1ChannelNumber) to ifIndex.")
ds1NearEndConfigurationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 10)).setObjects(("DS1-MIB", "dsx1LineStatus"), ("DS1-MIB", "dsx1LineIndex"), ("DS1-MIB", "dsx1LineLength"), ("DS1-MIB", "dsx1SendCode"), ("DS1-MIB", "dsx1LoopbackStatus"), ("DS1-MIB", "dsx1TransmitClockSource"), ("DS1-MIB", "dsx1ValidIntervals"), ("DS1-MIB", "dsx1TimeElapsed"), ("DS1-MIB", "dsx1InvalidIntervals"), ("DS1-MIB", "dsx1CircuitIdentifier"), ("DS1-MIB", "dsx1Channelization"), ("DS1-MIB", "dsx1LineCoding"), ("DS1-MIB", "dsx1LineBuildOut"), ("DS1-MIB", "dsx1SignalMode"), ("DS1-MIB", "dsx1Ds1ChannelNumber"), ("DS1-MIB", "dsx1LoopbackConfig"), ("DS1-MIB", "dsx1Fdl"), ("DS1-MIB", "dsx1LineType"), ("DS1-MIB", "dsx1LineMode"), )
if mibBuilder.loadTexts: ds1NearEndConfigurationGroup.setDescription("A collection of objects providing configuration\ninformation applicable to all DS1 interfaces.")
ds1NearEndCfgGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 11)).setObjects(("DS1-MIB", "dsx1LineStatus"), ("DS1-MIB", "dsx1LineIndex"), ("DS1-MIB", "dsx1LineLength"), ("DS1-MIB", "dsx1SendCode"), ("DS1-MIB", "dsx1LoopbackStatus"), ("DS1-MIB", "dsx1TransmitClockSource"), ("DS1-MIB", "dsx1ValidIntervals"), ("DS1-MIB", "dsx1TimeElapsed"), ("DS1-MIB", "dsx1InvalidIntervals"), ("DS1-MIB", "dsx1CircuitIdentifier"), ("DS1-MIB", "dsx1Channelization"), ("DS1-MIB", "dsx1LineCoding"), ("DS1-MIB", "dsx1LineBuildOut"), ("DS1-MIB", "dsx1SignalMode"), ("DS1-MIB", "dsx1LineImpedance"), ("DS1-MIB", "dsx1Ds1ChannelNumber"), ("DS1-MIB", "dsx1LoopbackConfig"), ("DS1-MIB", "dsx1Fdl"), ("DS1-MIB", "dsx1LineType"), ("DS1-MIB", "dsx1LineMode"), )
if mibBuilder.loadTexts: ds1NearEndCfgGroup.setDescription("A collection of objects providing configuration\ninformation applicable to all DS1 interfaces.")
ds1NearEndStatGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 12)).setObjects(("DS1-MIB", "dsx1TotalUASs"), ("DS1-MIB", "dsx1CurrentSEFSs"), ("DS1-MIB", "dsx1CurrentLESs"), ("DS1-MIB", "dsx1IntervalNumber"), ("DS1-MIB", "dsx1IntervalUASs"), ("DS1-MIB", "dsx1CurrentUASs"), ("DS1-MIB", "dsx1CurrentIndex"), ("DS1-MIB", "dsx1IntervalBESs"), ("DS1-MIB", "dsx1TotalCSSs"), ("DS1-MIB", "dsx1TotalPCVs"), ("DS1-MIB", "dsx1IntervalValidData"), ("DS1-MIB", "dsx1TotalSEFSs"), ("DS1-MIB", "dsx1IntervalSEFSs"), ("DS1-MIB", "dsx1CurrentBESs"), ("DS1-MIB", "dsx1IntervalLCVs"), ("DS1-MIB", "dsx1IntervalLESs"), ("DS1-MIB", "dsx1TotalLCVs"), ("DS1-MIB", "dsx1TotalESs"), ("DS1-MIB", "dsx1CurrentLCVs"), ("DS1-MIB", "dsx1TotalLESs"), ("DS1-MIB", "dsx1TotalSESs"), ("DS1-MIB", "dsx1IntervalIndex"), ("DS1-MIB", "dsx1CurrentESs"), ("DS1-MIB", "dsx1TotalBESs"), ("DS1-MIB", "dsx1IntervalESs"), ("DS1-MIB", "dsx1CurrentPCVs"), ("DS1-MIB", "dsx1TotalIndex"), ("DS1-MIB", "dsx1CurrentSESs"), ("DS1-MIB", "dsx1IntervalCSSs"), ("DS1-MIB", "dsx1IntervalSESs"), ("DS1-MIB", "dsx1IntervalPCVs"), ("DS1-MIB", "dsx1CurrentCSSs"), )
if mibBuilder.loadTexts: ds1NearEndStatGroup.setDescription("A collection of objects providing statistics\ninformation applicable to all DS1 interfaces.")
ds1FarEndNGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 18, 14, 1, 13)).setObjects(("DS1-MIB", "dsx1FarEndTotalUASs"), ("DS1-MIB", "dsx1FarEndIntervalUASs"), ("DS1-MIB", "dsx1FarEndTotalSESs"), ("DS1-MIB", "dsx1FarEndIntervalNumber"), ("DS1-MIB", "dsx1FarEndCurrentLESs"), ("DS1-MIB", "dsx1FarEndTimeElapsed"), ("DS1-MIB", "dsx1FarEndTotalPCVs"), ("DS1-MIB", "dsx1FarEndCurrentCSSs"), ("DS1-MIB", "dsx1FarEndCurrentBESs"), ("DS1-MIB", "dsx1FarEndIntervalSESs"), ("DS1-MIB", "dsx1FarEndTotalIndex"), ("DS1-MIB", "dsx1FarEndCurrentIndex"), ("DS1-MIB", "dsx1FarEndIntervalSEFSs"), ("DS1-MIB", "dsx1FarEndIntervalLESs"), ("DS1-MIB", "dsx1FarEndCurrentSEFSs"), ("DS1-MIB", "dsx1FarEndIntervalValidData"), ("DS1-MIB", "dsx1FarEndIntervalPCVs"), ("DS1-MIB", "dsx1FarEndCurrentPCVs"), ("DS1-MIB", "dsx1FarEndTotalCSSs"), ("DS1-MIB", "dsx1FarEndTotalBESs"), ("DS1-MIB", "dsx1FarEndValidIntervals"), ("DS1-MIB", "dsx1FarEndCurrentESs"), ("DS1-MIB", "dsx1FarEndIntervalBESs"), ("DS1-MIB", "dsx1FarEndIntervalIndex"), ("DS1-MIB", "dsx1FarEndInvalidIntervals"), ("DS1-MIB", "dsx1FarEndCurrentSESs"), ("DS1-MIB", "dsx1FarEndIntervalCSSs"), ("DS1-MIB", "dsx1FarEndTotalSEFSs"), ("DS1-MIB", "dsx1FarEndCurrentUASs"), ("DS1-MIB", "dsx1FarEndTotalESs"), ("DS1-MIB", "dsx1FarEndTotalLESs"), ("DS1-MIB", "dsx1FarEndIntervalESs"), )
if mibBuilder.loadTexts: ds1FarEndNGroup.setDescription("A collection of objects providing remote\nconfiguration and statistics information.")

# Compliances

ds1Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 1)).setObjects(("DS1-MIB", "ds1FarEndGroup"), ("DS1-MIB", "ds1ChanMappingGroup"), ("DS1-MIB", "ds1NearEndStatisticsGroup"), ("DS1-MIB", "ds1DS2Group"), ("DS1-MIB", "ds1NearEndOptionalConfigGroup"), ("DS1-MIB", "ds1NearEndConfigGroup"), ("DS1-MIB", "ds1TransStatsGroup"), )
if mibBuilder.loadTexts: ds1Compliance.setDescription("The compliance statement for T1 and E1\ninterfaces.")
ds1MibT1PriCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 2)).setObjects(("DS1-MIB", "ds1NearEndStatisticsGroup"), ("DS1-MIB", "ds1NearEndConfigGroup"), )
if mibBuilder.loadTexts: ds1MibT1PriCompliance.setDescription("Compliance statement for using this MIB for ISDN\nPrimary Rate interfaces on T1 lines.")
ds1MibE1PriCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 3)).setObjects(("DS1-MIB", "ds1NearEndStatisticsGroup"), ("DS1-MIB", "ds1NearEndConfigGroup"), )
if mibBuilder.loadTexts: ds1MibE1PriCompliance.setDescription("Compliance statement for using this MIB for ISDN\nPrimary Rate interfaces on E1 lines.")
ds1Ds2Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 4)).setObjects(("DS1-MIB", "ds1DS2Group"), )
if mibBuilder.loadTexts: ds1Ds2Compliance.setDescription("Compliance statement for using this MIB for DS2\ninterfaces.")
ds1NCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 5)).setObjects(("DS1-MIB", "ds1NearEndStatisticsGroup"), ("DS1-MIB", "ds1FarEndGroup"), ("DS1-MIB", "ds1DS2Group"), ("DS1-MIB", "ds1ChanMappingGroup"), ("DS1-MIB", "ds1NearEndOptionalConfigGroup"), ("DS1-MIB", "ds1NearEndOptionalTrapGroup"), ("DS1-MIB", "ds1NearEndConfigurationGroup"), ("DS1-MIB", "ds1TransStatsGroup"), )
if mibBuilder.loadTexts: ds1NCompliance.setDescription("The compliance statement for T1 and E1\ninterfaces.")
ds1MibT1PriNCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 6)).setObjects(("DS1-MIB", "ds1NearEndStatisticsGroup"), ("DS1-MIB", "ds1NearEndConfigurationGroup"), )
if mibBuilder.loadTexts: ds1MibT1PriNCompliance.setDescription("Compliance statement for using this MIB for ISDN\nPrimary Rate interfaces on T1 lines.")
ds1MibE1PriNCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 7)).setObjects(("DS1-MIB", "ds1NearEndStatisticsGroup"), ("DS1-MIB", "ds1NearEndConfigurationGroup"), )
if mibBuilder.loadTexts: ds1MibE1PriNCompliance.setDescription("Compliance statement for using this MIB for ISDN\nPrimary Rate interfaces on E1 lines.")
ds1J1Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 8)).setObjects(("DS1-MIB", "ds1NearEndCfgGroup"), ("DS1-MIB", "ds1NearEndStatGroup"), ("DS1-MIB", "ds1DS2Group"), ("DS1-MIB", "ds1NearEndOptionalConfigGroup"), ("DS1-MIB", "ds1NearEndOptionalTrapGroup"), ("DS1-MIB", "ds1ChanMappingGroup"), ("DS1-MIB", "ds1FarEndNGroup"), ("DS1-MIB", "ds1TransStatsGroup"), )
if mibBuilder.loadTexts: ds1J1Compliance.setDescription("The compliance statement for T1, J1, and E1\ninterfaces.")
ds1NMibT1PriNCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 9)).setObjects(("DS1-MIB", "ds1NearEndCfgGroup"), ("DS1-MIB", "ds1NearEndStatGroup"), )
if mibBuilder.loadTexts: ds1NMibT1PriNCompliance.setDescription("Compliance statement for using this MIB for ISDN\nPrimary Rate interfaces on T1 lines.")
ds1NMibE1PriNCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 18, 14, 2, 10)).setObjects(("DS1-MIB", "ds1NearEndCfgGroup"), ("DS1-MIB", "ds1NearEndStatGroup"), )
if mibBuilder.loadTexts: ds1NMibE1PriNCompliance.setDescription("Compliance statement for using this MIB for ISDN\nPrimary Rate interfaces on E1 lines.")

# Exports

# Module identity
mibBuilder.exportSymbols("DS1-MIB", PYSNMP_MODULE_ID=ds1)

# Objects
mibBuilder.exportSymbols("DS1-MIB", ds1=ds1, dsx1ConfigTable=dsx1ConfigTable, dsx1ConfigEntry=dsx1ConfigEntry, dsx1LineIndex=dsx1LineIndex, dsx1IfIndex=dsx1IfIndex, dsx1TimeElapsed=dsx1TimeElapsed, dsx1ValidIntervals=dsx1ValidIntervals, dsx1LineType=dsx1LineType, dsx1LineCoding=dsx1LineCoding, dsx1SendCode=dsx1SendCode, dsx1CircuitIdentifier=dsx1CircuitIdentifier, dsx1LoopbackConfig=dsx1LoopbackConfig, dsx1LineStatus=dsx1LineStatus, dsx1SignalMode=dsx1SignalMode, dsx1TransmitClockSource=dsx1TransmitClockSource, dsx1Fdl=dsx1Fdl, dsx1InvalidIntervals=dsx1InvalidIntervals, dsx1LineLength=dsx1LineLength, dsx1LineStatusLastChange=dsx1LineStatusLastChange, dsx1LineStatusChangeTrapEnable=dsx1LineStatusChangeTrapEnable, dsx1LoopbackStatus=dsx1LoopbackStatus, dsx1Ds1ChannelNumber=dsx1Ds1ChannelNumber, dsx1Channelization=dsx1Channelization, dsx1LineMode=dsx1LineMode, dsx1LineBuildOut=dsx1LineBuildOut, dsx1LineImpedance=dsx1LineImpedance, dsx1CurrentTable=dsx1CurrentTable, dsx1CurrentEntry=dsx1CurrentEntry, dsx1CurrentIndex=dsx1CurrentIndex, dsx1CurrentESs=dsx1CurrentESs, dsx1CurrentSESs=dsx1CurrentSESs, dsx1CurrentSEFSs=dsx1CurrentSEFSs, dsx1CurrentUASs=dsx1CurrentUASs, dsx1CurrentCSSs=dsx1CurrentCSSs, dsx1CurrentPCVs=dsx1CurrentPCVs, dsx1CurrentLESs=dsx1CurrentLESs, dsx1CurrentBESs=dsx1CurrentBESs, dsx1CurrentDMs=dsx1CurrentDMs, dsx1CurrentLCVs=dsx1CurrentLCVs, dsx1IntervalTable=dsx1IntervalTable, dsx1IntervalEntry=dsx1IntervalEntry, dsx1IntervalIndex=dsx1IntervalIndex, dsx1IntervalNumber=dsx1IntervalNumber, dsx1IntervalESs=dsx1IntervalESs, dsx1IntervalSESs=dsx1IntervalSESs, dsx1IntervalSEFSs=dsx1IntervalSEFSs, dsx1IntervalUASs=dsx1IntervalUASs, dsx1IntervalCSSs=dsx1IntervalCSSs, dsx1IntervalPCVs=dsx1IntervalPCVs, dsx1IntervalLESs=dsx1IntervalLESs, dsx1IntervalBESs=dsx1IntervalBESs, dsx1IntervalDMs=dsx1IntervalDMs, dsx1IntervalLCVs=dsx1IntervalLCVs, dsx1IntervalValidData=dsx1IntervalValidData, dsx1TotalTable=dsx1TotalTable, dsx1TotalEntry=dsx1TotalEntry, dsx1TotalIndex=dsx1TotalIndex, dsx1TotalESs=dsx1TotalESs, dsx1TotalSESs=dsx1TotalSESs, dsx1TotalSEFSs=dsx1TotalSEFSs, dsx1TotalUASs=dsx1TotalUASs, dsx1TotalCSSs=dsx1TotalCSSs, dsx1TotalPCVs=dsx1TotalPCVs, dsx1TotalLESs=dsx1TotalLESs, dsx1TotalBESs=dsx1TotalBESs, dsx1TotalDMs=dsx1TotalDMs, dsx1TotalLCVs=dsx1TotalLCVs, dsx1FarEndCurrentTable=dsx1FarEndCurrentTable, dsx1FarEndCurrentEntry=dsx1FarEndCurrentEntry, dsx1FarEndCurrentIndex=dsx1FarEndCurrentIndex, dsx1FarEndTimeElapsed=dsx1FarEndTimeElapsed, dsx1FarEndValidIntervals=dsx1FarEndValidIntervals, dsx1FarEndCurrentESs=dsx1FarEndCurrentESs, dsx1FarEndCurrentSESs=dsx1FarEndCurrentSESs, dsx1FarEndCurrentSEFSs=dsx1FarEndCurrentSEFSs, dsx1FarEndCurrentUASs=dsx1FarEndCurrentUASs, dsx1FarEndCurrentCSSs=dsx1FarEndCurrentCSSs, dsx1FarEndCurrentLESs=dsx1FarEndCurrentLESs, dsx1FarEndCurrentPCVs=dsx1FarEndCurrentPCVs, dsx1FarEndCurrentBESs=dsx1FarEndCurrentBESs, dsx1FarEndCurrentDMs=dsx1FarEndCurrentDMs, dsx1FarEndInvalidIntervals=dsx1FarEndInvalidIntervals, dsx1FarEndIntervalTable=dsx1FarEndIntervalTable, dsx1FarEndIntervalEntry=dsx1FarEndIntervalEntry, dsx1FarEndIntervalIndex=dsx1FarEndIntervalIndex, dsx1FarEndIntervalNumber=dsx1FarEndIntervalNumber, dsx1FarEndIntervalESs=dsx1FarEndIntervalESs, dsx1FarEndIntervalSESs=dsx1FarEndIntervalSESs, dsx1FarEndIntervalSEFSs=dsx1FarEndIntervalSEFSs, dsx1FarEndIntervalUASs=dsx1FarEndIntervalUASs, dsx1FarEndIntervalCSSs=dsx1FarEndIntervalCSSs, dsx1FarEndIntervalLESs=dsx1FarEndIntervalLESs, dsx1FarEndIntervalPCVs=dsx1FarEndIntervalPCVs, dsx1FarEndIntervalBESs=dsx1FarEndIntervalBESs, dsx1FarEndIntervalDMs=dsx1FarEndIntervalDMs, dsx1FarEndIntervalValidData=dsx1FarEndIntervalValidData, dsx1FarEndTotalTable=dsx1FarEndTotalTable, dsx1FarEndTotalEntry=dsx1FarEndTotalEntry, dsx1FarEndTotalIndex=dsx1FarEndTotalIndex, dsx1FarEndTotalESs=dsx1FarEndTotalESs, dsx1FarEndTotalSESs=dsx1FarEndTotalSESs, dsx1FarEndTotalSEFSs=dsx1FarEndTotalSEFSs, dsx1FarEndTotalUASs=dsx1FarEndTotalUASs, dsx1FarEndTotalCSSs=dsx1FarEndTotalCSSs, dsx1FarEndTotalLESs=dsx1FarEndTotalLESs, dsx1FarEndTotalPCVs=dsx1FarEndTotalPCVs, dsx1FarEndTotalBESs=dsx1FarEndTotalBESs, dsx1FarEndTotalDMs=dsx1FarEndTotalDMs, dsx1FracTable=dsx1FracTable, dsx1FracEntry=dsx1FracEntry, dsx1FracIndex=dsx1FracIndex, dsx1FracNumber=dsx1FracNumber, dsx1FracIfIndex=dsx1FracIfIndex, ds1Conformance=ds1Conformance, ds1Groups=ds1Groups, ds1Compliances=ds1Compliances, ds1Traps=ds1Traps, dsx1ChanMappingTable=dsx1ChanMappingTable, dsx1ChanMappingEntry=dsx1ChanMappingEntry, dsx1ChanMappedIfIndex=dsx1ChanMappedIfIndex)

# Notifications
mibBuilder.exportSymbols("DS1-MIB", dsx1LineStatusChange=dsx1LineStatusChange)

# Groups
mibBuilder.exportSymbols("DS1-MIB", ds1NearEndConfigGroup=ds1NearEndConfigGroup, ds1NearEndStatisticsGroup=ds1NearEndStatisticsGroup, ds1FarEndGroup=ds1FarEndGroup, ds1DeprecatedGroup=ds1DeprecatedGroup, ds1NearEndOptionalConfigGroup=ds1NearEndOptionalConfigGroup, ds1DS2Group=ds1DS2Group, ds1TransStatsGroup=ds1TransStatsGroup, ds1NearEndOptionalTrapGroup=ds1NearEndOptionalTrapGroup, ds1ChanMappingGroup=ds1ChanMappingGroup, ds1NearEndConfigurationGroup=ds1NearEndConfigurationGroup, ds1NearEndCfgGroup=ds1NearEndCfgGroup, ds1NearEndStatGroup=ds1NearEndStatGroup, ds1FarEndNGroup=ds1FarEndNGroup)

# Compliances
mibBuilder.exportSymbols("DS1-MIB", ds1Compliance=ds1Compliance, ds1MibT1PriCompliance=ds1MibT1PriCompliance, ds1MibE1PriCompliance=ds1MibE1PriCompliance, ds1Ds2Compliance=ds1Ds2Compliance, ds1NCompliance=ds1NCompliance, ds1MibT1PriNCompliance=ds1MibT1PriNCompliance, ds1MibE1PriNCompliance=ds1MibE1PriNCompliance, ds1J1Compliance=ds1J1Compliance, ds1NMibT1PriNCompliance=ds1NMibT1PriNCompliance, ds1NMibE1PriNCompliance=ds1NMibE1PriNCompliance)
