# PySNMP SMI module. Autogenerated from smidump -f python DS3-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:23 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( PerfCurrentCount, PerfIntervalCount, PerfTotalCount, ) = mibBuilder.importSymbols("PerfHist-TC-MIB", "PerfCurrentCount", "PerfIntervalCount", "PerfTotalCount")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( DisplayString, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeStamp", "TruthValue")

# Objects

ds3 = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 30)).setRevisions(("2004-09-08 00:00","1998-08-01 21:30","1993-01-25 20:28",))
if mibBuilder.loadTexts: ds3.setOrganization("IETF AToM MIB Working Group")
if mibBuilder.loadTexts: ds3.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/atommib-charter.html\n\nMailing Lists:\nGeneral Discussion: atommib@research.telcordia.com\nTo Subscribe: atommib-request@research.telcordia.com\n\nEditor: Orly Nicklass\n\nPostal: RAD Data Communications, Ltd.\n      Ziv Tower, 24 Roul Walenberg\n      Tel Aviv, Israel, 69719\n\n      Tel: +9723 765 9969\nE-mail: orly_n@rad.com")
if mibBuilder.loadTexts: ds3.setDescription("The is the MIB module that describes\nDS3 and E3 interfaces objects.\n\nCopyright (c) The Internet Society (2004).  This\nversion of this MIB module is part of RFC 3896;\nsee the RFC itself for full legal notices.")
dsx3ConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 5))
if mibBuilder.loadTexts: dsx3ConfigTable.setDescription("The DS3/E3 Configuration table.")
dsx3ConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 5, 1)).setIndexNames((0, "DS3-MIB", "dsx3LineIndex"))
if mibBuilder.loadTexts: dsx3ConfigEntry.setDescription("An entry in the DS3/E3 Configuration table.")
dsx3LineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3LineIndex.setDescription("This object should be made equal to ifIndex.  The\nnext paragraph describes its previous usage.\nMaking the object equal to ifIndex allows proper\nuse of ifStackTable.\n\nPreviously, this object was the identifier of a\nDS3/E3 Interface on a managed device.  If there is\nan ifEntry that is directly associated with this\nand only this DS3/E3 interface, it should have the\nsame value as ifIndex.  Otherwise, number the\ndsx3LineIndices with an unique identifier\nfollowing the rules of choosing a number that is\ngreater than ifNumber and numbering the inside\ninterfaces (e.g., equipment side) with even\nnumbers and outside interfaces (e.g., network side)\nwith odd numbers.")
dsx3IfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IfIndex.setDescription("This value for this object is equal to the value\nof ifIndex from the Interfaces table of MIB II\n(RFC 1213).")
dsx3TimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TimeElapsed.setDescription("The number of seconds that have elapsed since the\n\n\n\nbeginning of the near end current error-\nmeasurement period. If, for some reason, such as\nan adjustment in the system's time-of-day clock,\nthe current interval exceeds the maximum value,\nthe agent will return the maximum value.")
dsx3ValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3ValidIntervals.setDescription("The number of previous near end intervals for\nwhich data was collected.  The value will be 96\nunless the interface was brought online within the\nlast 24 hours, in which case the value will be the\nnumber of complete 15 minute near end intervals\nsince the interface has been online.  In the case\nwhere the agent is a proxy, it is possible that\nsome intervals are unavailable.  In this case,\nthis interval is the maximum interval number for\nwhich data is available.")
dsx3LineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,6,9,8,4,3,1,7,2,)).subtype(namedValues=namedval.NamedValues(("dsx3other", 1), ("dsx3M23", 2), ("dsx3SYNTRAN", 3), ("dsx3CbitParity", 4), ("dsx3ClearChannel", 5), ("e3other", 6), ("e3Framed", 7), ("e3Plcp", 8), ("dsx3M13", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3LineType.setDescription("This variable indicates the variety of DS3 C-bit\nor E3 application implementing this interface. The\ntype of interface affects the interpretation of\nthe usage and error statistics.  The rate of DS3\nis 44.736 Mbps and E3 is 34.368 Mbps.  The\ndsx3ClearChannel value means that the C-bits are\nnot used except for sending/receiving AIS.  The\nvalues, in sequence, describe:\n\n\n\n\n               TITLE:          SPECIFICATION:\n               dsx3M23         ANSI T1.107-1988\n               dsx3SYNTRAN     ANSI T1.107-1988\n               dsx3CbitParity  ANSI T1.107a-1990\n               dsx3ClearChannel ANSI T1.102-1987\n               e3Framed        CCITT G.751\n               e3Plcp          ETSI T/NA(91)18\n               dsx3M13         ANSI T1.107a-1990.")
dsx3LineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("dsx3Other", 1), ("dsx3B3ZS", 2), ("e3HDB3", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3LineCoding.setDescription("This variable describes the variety of Zero Code\nSuppression used on this interface, which in turn\naffects a number of its characteristics.\ndsx3B3ZS and e3HDB3 refer to the use of specified\npatterns of normal bits and bipolar violations\nwhich are used to replace sequences of zero bits\nof a specified length.")
dsx3SendCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,6,3,4,5,1,)).subtype(namedValues=namedval.NamedValues(("dsx3SendNoCode", 1), ("dsx3SendLineCode", 2), ("dsx3SendPayloadCode", 3), ("dsx3SendResetCode", 4), ("dsx3SendDS1LoopCode", 5), ("dsx3SendTestPattern", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3SendCode.setDescription("This variable indicates what type of code is\nbeing sent across the DS3/E3 interface by the\ndevice.  (These are optional for E3 interfaces.)\nSetting this variable causes the interface to\nbegin sending the code requested.\nThe values mean:\n\n   dsx3SendNoCode\n       sending looped or normal data\n\n   dsx3SendLineCode\n       sending a request for a line loopback\n\n   dsx3SendPayloadCode\n       sending a request for a payload loopback\n       (i.e., all DS1/E1s in a DS3/E3 frame)\n\n   dsx3SendResetCode\n       sending a loopback deactivation request\n\n   dsx3SendDS1LoopCode\n       requesting to loopback a particular DS1/E1\n       within a DS3/E3 frame.  The DS1/E1 is\n       indicated in dsx3Ds1ForRemoteLoop.\n\n   dsx3SendTestPattern\n       sending a test pattern.")
dsx3CircuitIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 8), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3CircuitIdentifier.setDescription("This variable contains the transmission vendor's\ncircuit identifier, for the purpose of\nfacilitating troubleshooting.")
dsx3LoopbackConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,4,6,5,2,)).subtype(namedValues=namedval.NamedValues(("dsx3NoLoop", 1), ("dsx3PayloadLoop", 2), ("dsx3LineLoop", 3), ("dsx3OtherLoop", 4), ("dsx3InwardLoop", 5), ("dsx3DualLoop", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3LoopbackConfig.setDescription("This variable represents the desired loopback\nconfiguration of the DS3/E3 interface.\nThe values mean:\n\ndsx3NoLoop\n  Not in the loopback state.  A device that is\n  not capable of performing a loopback on\n  the interface shall always return this as\n  its value.\n\ndsx3PayloadLoop\n  The received signal at this interface is looped\n  through the device.  Typically the received signal\n  is looped back for retransmission after it has\n  passed through the device's framing function.\n\ndsx3LineLoop\n  The received signal at this interface does not\n  go through the device (minimum penetration) but\n  is looped back out.\n\ndsx3OtherLoop\n  Loopbacks that are not defined here.\n\ndsx3InwardLoop\n  The sent signal at this interface is looped back\n  through the device.\n\ndsx3DualLoop\n  Both dsx1LineLoop and dsx1InwardLoop will be\n  active simultaneously.")
dsx3LineStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4095))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3LineStatus.setDescription("This variable indicates the Line Status of the\ninterface.  It contains loopback state information\nand failure state information.  The dsx3LineStatus\nis a bit map represented as a sum, therefore, it\ncan represent multiple failures and a loopback\n(see dsx3LoopbackConfig object for the type of\nloopback) simultaneously.  The dsx3NoAlarm must be\nset if and only if no other flag is set.\n\nIf the dsx3loopbackState bit is set, the loopback\nin effect can be determined from the\ndsx3loopbackConfig object.\nThe various bit positions are:\n1     dsx3NoAlarm         No alarm present\n2     dsx3RcvRAIFailure   Receiving Yellow/Remote\n                      Alarm Indication\n4     dsx3XmitRAIAlarm    Transmitting Yellow/Remote\n                      Alarm Indication\n8     dsx3RcvAIS          Receiving AIS failure state\n16     dsx3XmitAIS         Transmitting AIS\n32     dsx3LOF             Receiving LOF failure state\n64     dsx3LOS             Receiving LOS failure state\n128     dsx3LoopbackState   Looping the received signal\n256     dsx3RcvTestCode     Receiving a Test Pattern\n512     dsx3OtherFailure    any line status not defined\n                      here\n1024     dsx3UnavailSigState Near End in Unavailable\n                      Signal State\n2048     dsx3NetEquipOOS     Carrier Equipment Out of\n                      Service")
dsx3TransmitClockSource = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("loopTiming", 1), ("localTiming", 2), ("throughTiming", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3TransmitClockSource.setDescription("The source of Transmit Clock.\n\n\n\n\nloopTiming indicates that the recovered receive\nclock is used as the transmit clock.\n\nlocalTiming indicates that a local clock source is\nused or that an external clock is attached to the\nbox containing the interface.\n\nthroughTiming indicates that transmit clock is\nderived from the recovered receive clock of\nanother DS3 interface.")
dsx3InvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3InvalidIntervals.setDescription(" The number of intervals in the range from 0 to\ndsx3ValidIntervals for which no data is available.\nThis object will typically be zero except in cases\nwhere the data for some intervals are not\navailable (e.g., in proxy situations).")
dsx3LineLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 64000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3LineLength.setDescription("The length of the ds3 line in meters.  This\nobject provides information for line build out\ncircuitry if it exists and can use this object to\nadjust the line build out.")
dsx3LineStatusLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 14), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3LineStatusLastChange.setDescription("The value of MIB II's sysUpTime object at the\ntime this DS3/E3 entered its current line status\nstate.  If the current state was entered prior to\nthe last re-initialization of the proxy-agent,\nthen this object contains a zero value.")
dsx3LineStatusChangeTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 15), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3LineStatusChangeTrapEnable.setDescription("Indicates whether dsx3LineStatusChange traps\nshould be generated for this interface.")
dsx3LoopbackStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3LoopbackStatus.setDescription("This variable represents the current state of the\nloopback on the DS3 interface.  It contains\ninformation about loopbacks established by a\nmanager and remotely from the far end.\n\nThe dsx3LoopbackStatus is a bit map represented as\na sum, therefore is can represent multiple\nloopbacks simultaneously.\n\nThe various bit positions are:\n 1  dsx3NoLoopback\n 2  dsx3NearEndPayloadLoopback\n 4  dsx3NearEndLineLoopback\n 8  dsx3NearEndOtherLoopback\n16  dsx3NearEndInwardLoopback\n32  dsx3FarEndPayloadLoopback\n64  dsx3FarEndLineLoopback")
dsx3Channelization = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("enabledDs1", 2), ("enabledDs2", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3Channelization.setDescription("Indicates whether this ds3/e3 is channelized or\nunchannelized.  The value of enabledDs1 indicates\n\n\n\nthat this is a DS3 channelized into DS1s.  The\nvalue of enabledDs3 indicated that this is a DS3\nchannelized into DS2s.  Setting this object will\ncause the creation or deletion of DS2 or DS1\nentries in the ifTable.  ")
dsx3Ds1ForRemoteLoop = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 5, 1, 18), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 29))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3Ds1ForRemoteLoop.setDescription("Indicates which DS1/E1 on this DS3/E3 will be\nindicated in the remote ds1 loopback request.  A\nvalue of 0 means no DS1 will be looped.  A value\nof 29 means all DS1s/E1s will be looped.")
dsx3CurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 6))
if mibBuilder.loadTexts: dsx3CurrentTable.setDescription("The DS3/E3 current table contains various\nstatistics being collected for the current 15\nminute interval.")
dsx3CurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 6, 1)).setIndexNames((0, "DS3-MIB", "dsx3CurrentIndex"))
if mibBuilder.loadTexts: dsx3CurrentEntry.setDescription("An entry in the DS3/E3 Current table.")
dsx3CurrentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentIndex.setDescription("The index value which uniquely identifies the\nDS3/E3 interface to which this entry is\napplicable.  The interface identified by a\nparticular value of this index is the same\ninterface as identified by the same value an\ndsx3LineIndex object instance.")
dsx3CurrentPESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentPESs.setDescription("The counter associated with the number of P-bit\nErrored Seconds.")
dsx3CurrentPSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentPSESs.setDescription("The counter associated with the number of P-bit\nSeverely Errored Seconds.")
dsx3CurrentSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentSEFSs.setDescription("The counter associated with the number of\nSeverely Errored Framing Seconds.")
dsx3CurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentUASs.setDescription("The counter associated with the number of\nUnavailable Seconds.")
dsx3CurrentLCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 6), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentLCVs.setDescription("The counter associated with the number of Line\nCoding Violations.")
dsx3CurrentPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 7), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentPCVs.setDescription("The counter associated with the number of P-bit\nCoding Violations.")
dsx3CurrentLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentLESs.setDescription("The number of Line Errored Seconds.")
dsx3CurrentCCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentCCVs.setDescription("The number of C-bit Coding Violations.")
dsx3CurrentCESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentCESs.setDescription("The number of C-bit Errored Seconds.")
dsx3CurrentCSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 6, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3CurrentCSESs.setDescription("The number of C-bit Severely Errored Seconds.")
dsx3IntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 7))
if mibBuilder.loadTexts: dsx3IntervalTable.setDescription("The DS3/E3 Interval Table contains various\nstatistics collected by each DS3/E3 Interface over\nthe previous 24 hours of operation.  The past 24\nhours are broken into 96 completed 15 minute\nintervals.  Each row in this table represents one\nsuch interval (identified by dsx3IntervalNumber)\nand for one specific interface (identified by\ndsx3IntervalIndex).")
dsx3IntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 7, 1)).setIndexNames((0, "DS3-MIB", "dsx3IntervalIndex"), (0, "DS3-MIB", "dsx3IntervalNumber"))
if mibBuilder.loadTexts: dsx3IntervalEntry.setDescription("An entry in the DS3/E3 Interval table.")
dsx3IntervalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalIndex.setDescription("The index value which uniquely identifies the\nDS3/E3 interface to which this entry is\napplicable.  The interface identified by a\nparticular value of this index is the same\ninterface as identified by the same value an\ndsx3LineIndex object instance.")
dsx3IntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalNumber.setDescription("A number between 1 and 96, where 1 is the most\nrecently completed 15 minute interval and 96 is\nthe 15 minutes interval completed 23 hours and 45\nminutes prior to interval 1.")
dsx3IntervalPESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalPESs.setDescription("The counter associated with the number of P-bit\nErrored Seconds.")
dsx3IntervalPSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalPSESs.setDescription("The counter associated with the number of P-bit\nSeverely Errored Seconds.")
dsx3IntervalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalSEFSs.setDescription("The counter associated with the number of\nSeverely Errored Framing Seconds.")
dsx3IntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 6), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalUASs.setDescription("The counter associated with the number of\nUnavailable Seconds.  This object may decrease if\nthe occurrence of unavailable seconds occurs across\nan interval boundary.")
dsx3IntervalLCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 7), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalLCVs.setDescription("The counter associated with the number of Line\nCoding Violations.")
dsx3IntervalPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 8), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalPCVs.setDescription("The counter associated with the number of P-bit\nCoding Violations.")
dsx3IntervalLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 9), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalLESs.setDescription("The number of Line Errored  Seconds  (BPVs  or\nillegal  zero  sequences).")
dsx3IntervalCCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 10), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalCCVs.setDescription("The number of C-bit Coding Violations.")
dsx3IntervalCESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 11), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalCESs.setDescription("The number of C-bit Errored Seconds.")
dsx3IntervalCSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 12), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalCSESs.setDescription("The number of C-bit Severely Errored Seconds.")
dsx3IntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 7, 1, 13), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3IntervalValidData.setDescription(" This variable indicates if the data for this\ninterval is valid.")
dsx3TotalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 8))
if mibBuilder.loadTexts: dsx3TotalTable.setDescription("The DS3/E3 Total Table contains the cumulative\nsum of the various statistics for the 24 hour\nperiod preceding the current interval.")
dsx3TotalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 8, 1)).setIndexNames((0, "DS3-MIB", "dsx3TotalIndex"))
if mibBuilder.loadTexts: dsx3TotalEntry.setDescription("An entry in the DS3/E3 Total table.")
dsx3TotalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalIndex.setDescription("The index value which uniquely identifies the\nDS3/E3 interface to which this entry is\napplicable.  The interface identified by a\nparticular value of this index is the same\ninterface as identified by the same value an\ndsx3LineIndex object instance.")
dsx3TotalPESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 2), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalPESs.setDescription("The counter associated with the number of P-bit\nErrored Seconds, encountered by a DS3 interface in\nthe previous 24 hour interval. Invalid 15 minute\nintervals count as 0.")
dsx3TotalPSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 3), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalPSESs.setDescription("The counter associated with the number of P-bit\nSeverely Errored Seconds, encountered by a DS3\ninterface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3TotalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 4), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalSEFSs.setDescription("The counter associated with the number of\nSeverely Errored Framing Seconds, encountered by a\nDS3/E3 interface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3TotalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 5), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalUASs.setDescription("The counter associated with the number of\nUnavailable Seconds, encountered by a DS3\ninterface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3TotalLCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 6), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalLCVs.setDescription("The counter associated with the number of Line\nCoding Violations encountered by a DS3/E3\ninterface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3TotalPCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 7), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalPCVs.setDescription("The counter associated with the number of P-bit\n\n\n\nCoding Violations, encountered by a DS3 interface\nin the previous 24 hour interval. Invalid 15\nminute intervals count as 0.")
dsx3TotalLESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 8), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalLESs.setDescription("The number of Line Errored  Seconds  (BPVs  or\nillegal  zero  sequences) encountered by a DS3/E3\ninterface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3TotalCCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 9), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalCCVs.setDescription("The number of C-bit Coding Violations encountered\nby a DS3 interface in the previous 24 hour\ninterval. Invalid 15 minute intervals count as 0.")
dsx3TotalCESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 10), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalCESs.setDescription("The number of C-bit Errored Seconds encountered\nby a DS3 interface in the previous 24 hour\ninterval. Invalid 15 minute intervals count as 0.")
dsx3TotalCSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 8, 1, 11), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3TotalCSESs.setDescription("The number of C-bit Severely Errored Seconds\nencountered by a DS3 interface in the previous 24\nhour interval. Invalid 15 minute intervals count\nas 0.")
dsx3FarEndConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 9))
if mibBuilder.loadTexts: dsx3FarEndConfigTable.setDescription("The DS3 Far End Configuration Table contains\nconfiguration information reported in the C-bits\nfrom the remote end.")
dsx3FarEndConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 9, 1)).setIndexNames((0, "DS3-MIB", "dsx3FarEndLineIndex"))
if mibBuilder.loadTexts: dsx3FarEndConfigEntry.setDescription("An entry in the DS3 Far End Configuration table.")
dsx3FarEndLineIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 9, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndLineIndex.setDescription("The index value which uniquely identifies the DS3\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\n\n\n\nindex is the same interface as identified by the\nsame value an dsx3LineIndex object instance.")
dsx3FarEndEquipCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 9, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3FarEndEquipCode.setDescription("This is the Far End Equipment Identification code\nthat describes the specific piece of equipment.\nIt is sent within the Path Identification\nMessage.")
dsx3FarEndLocationIDCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 9, 1, 3), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 11))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3FarEndLocationIDCode.setDescription("This is the Far End Location Identification code\nthat describes the specific location of the\nequipment.  It is sent within the Path\nIdentification Message.")
dsx3FarEndFrameIDCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 9, 1, 4), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3FarEndFrameIDCode.setDescription("This is the Far End Frame Identification code\nthat identifies where the equipment is located\nwithin a building at a given location.  It is sent\nwithin the Path Identification Message.")
dsx3FarEndUnitCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 9, 1, 5), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 6))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3FarEndUnitCode.setDescription("This is the Far End code that identifies the\nequipment location within a bay.  It is sent\nwithin the Path Identification Message.")
dsx3FarEndFacilityIDCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 9, 1, 6), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 38))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3FarEndFacilityIDCode.setDescription("This code identifies a specific Far End DS3 path.\nIt is sent within the Path Identification\nMessage.")
dsx3FarEndCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 10))
if mibBuilder.loadTexts: dsx3FarEndCurrentTable.setDescription("The DS3 Far End Current table contains various\nstatistics being collected for the current 15\nminute interval.  The statistics are collected\nfrom the far end block error code within the C-\nbits.")
dsx3FarEndCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 10, 1)).setIndexNames((0, "DS3-MIB", "dsx3FarEndCurrentIndex"))
if mibBuilder.loadTexts: dsx3FarEndCurrentEntry.setDescription("An entry in the DS3 Far End Current table.")
dsx3FarEndCurrentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndCurrentIndex.setDescription("The index value which uniquely identifies the DS3\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is identical to the interface identified by\nthe same value of dsx3LineIndex.")
dsx3FarEndTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndTimeElapsed.setDescription("The number of seconds that have elapsed since the\nbeginning of the far end current error-measurement\nperiod. If, for some reason, such as an adjustment\nin the system's time-of-day clock, the current\ninterval exceeds the maximum value, the agent will\nreturn the maximum value.")
dsx3FarEndValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndValidIntervals.setDescription("The number of previous far end intervals for\nwhich data was collected.  The value will be 96\nunless the interface was brought online within the\nlast 24 hours, in which case the value will be the\nnumber of complete 15 minute far end intervals\nsince the interface has been online. In the case\nwhere the agent is a proxy, it is possible that\nsome intervals are unavailable.  In this case,\nthis interval is the maximum interval number for\nwhich data is available.")
dsx3FarEndCurrentCESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndCurrentCESs.setDescription("The counter associated with the number of Far End\nC-bit Errored Seconds.")
dsx3FarEndCurrentCSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndCurrentCSESs.setDescription("The counter associated with the number of Far End\nC-bit Severely Errored Seconds.")
dsx3FarEndCurrentCCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 6), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndCurrentCCVs.setDescription("The counter associated with the number of Far End\nC-bit Coding Violations reported via the far end\nblock error count.")
dsx3FarEndCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 7), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndCurrentUASs.setDescription("The counter associated with the number of Far End\nunavailable seconds.")
dsx3FarEndInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 10, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndInvalidIntervals.setDescription(" The number of intervals in the range from 0 to\ndsx3FarEndValidIntervals for which no data is\navailable.  This object will typically be zero\nexcept in cases where the data for some intervals\nare not available (e.g., in proxy situations).")
dsx3FarEndIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 11))
if mibBuilder.loadTexts: dsx3FarEndIntervalTable.setDescription("The DS3 Far End Interval Table contains various\n\n\n\nstatistics collected by each DS3 interface over\nthe previous 24 hours of operation.  The past 24\nhours are broken into 96 completed 15 minute\nintervals.")
dsx3FarEndIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 11, 1)).setIndexNames((0, "DS3-MIB", "dsx3FarEndIntervalIndex"), (0, "DS3-MIB", "dsx3FarEndIntervalNumber"))
if mibBuilder.loadTexts: dsx3FarEndIntervalEntry.setDescription("An entry in the DS3 Far End Interval table.")
dsx3FarEndIntervalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalIndex.setDescription("The index value which uniquely identifies the DS3\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is identical to the interface identified by\nthe same value of dsx3LineIndex.")
dsx3FarEndIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalNumber.setDescription("A number between 1 and 96, where 1 is the most\nrecently completed 15 minute interval and 96 is\n\n\n\nthe 15 minutes interval completed 23 hours and 45\nminutes prior to interval 1.")
dsx3FarEndIntervalCESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalCESs.setDescription("The counter associated with the number of Far End\nC-bit Errored Seconds encountered by a DS3\ninterface in one of the previous 96, individual 15\nminute, intervals. In the case where the agent is\na proxy and data is not available, return\nnoSuchInstance.")
dsx3FarEndIntervalCSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalCSESs.setDescription("The counter associated with the number of Far End\nC-bit Severely Errored Seconds.")
dsx3FarEndIntervalCCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalCCVs.setDescription("The counter associated with the number of Far End\nC-bit Coding Violations reported via the far end\nblock error count.")
dsx3FarEndIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 6), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalUASs.setDescription("The counter associated with the number of Far End\nunavailable seconds.")
dsx3FarEndIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 11, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndIntervalValidData.setDescription(" This variable indicates if the data for this\ninterval is valid.")
dsx3FarEndTotalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 12))
if mibBuilder.loadTexts: dsx3FarEndTotalTable.setDescription("The DS3 Far End Total Table contains the\ncumulative sum of the various statistics for the\n24 hour period preceding the current interval.")
dsx3FarEndTotalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 12, 1)).setIndexNames((0, "DS3-MIB", "dsx3FarEndTotalIndex"))
if mibBuilder.loadTexts: dsx3FarEndTotalEntry.setDescription("An entry in the DS3 Far End Total table.")
dsx3FarEndTotalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 12, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndTotalIndex.setDescription("The index value which uniquely identifies the DS3\ninterface to which this entry is applicable.  The\ninterface identified by a particular value of this\nindex is identical to the interface identified by\nthe same value of dsx3LineIndex.")
dsx3FarEndTotalCESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 12, 1, 2), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndTotalCESs.setDescription("The counter associated with the number of Far End\nC-bit Errored Seconds encountered by a DS3\ninterface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3FarEndTotalCSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 12, 1, 3), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndTotalCSESs.setDescription("The counter associated with the number of Far End\nC-bit Severely Errored Seconds encountered by a\nDS3 interface in the previous 24 hour interval.\nInvalid 15 minute intervals count as 0.")
dsx3FarEndTotalCCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 12, 1, 4), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndTotalCCVs.setDescription("The counter associated with the number of Far End\nC-bit Coding Violations reported via the far end\nblock error count encountered by a DS3 interface\nin the previous 24 hour interval. Invalid 15\nminute intervals count as 0.")
dsx3FarEndTotalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 12, 1, 5), PerfTotalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FarEndTotalUASs.setDescription("The counter associated with the number of Far End\nunavailable seconds encountered by a DS3 interface\nin the previous 24 hour interval.  Invalid 15\nminute intervals count as 0.")
dsx3FracTable = MibTable((1, 3, 6, 1, 2, 1, 10, 30, 13))
if mibBuilder.loadTexts: dsx3FracTable.setDescription("This table is deprecated in favour of using\nifStackTable.\n\nImplementation of this table was optional.  It was\ndesigned for those systems dividing a DS3/E3 into\nchannels containing different data streams that\nare of local interest.\n\nThe DS3/E3 fractional table identifies which\nDS3/E3 channels associated with a CSU are being\nused to support a logical interface, i.e., an\nentry in the interfaces table from the Internet-\nstandard MIB.\n\nFor example, consider a DS3 device with 4 high\nspeed links carrying router traffic, a feed for\nvoice, a feed for video, and a synchronous channel\nfor a non-routed protocol.  We might describe the\nallocation of channels, in the dsx3FracTable, as\nfollows:\ndsx3FracIfIndex.2. 1 = 3  dsx3FracIfIndex.2.15 = 4\ndsx3FracIfIndex.2. 2 = 3  dsx3FracIfIndex.2.16 = 6\ndsx3FracIfIndex.2. 3 = 3  dsx3FracIfIndex.2.17 = 6\ndsx3FracIfIndex.2. 4 = 3  dsx3FracIfIndex.2.18 = 6\ndsx3FracIfIndex.2. 5 = 3  dsx3FracIfIndex.2.19 = 6\ndsx3FracIfIndex.2. 6 = 3  dsx3FracIfIndex.2.20 = 6\ndsx3FracIfIndex.2. 7 = 4  dsx3FracIfIndex.2.21 = 6\ndsx3FracIfIndex.2. 8 = 4  dsx3FracIfIndex.2.22 = 6\ndsx3FracIfIndex.2. 9 = 4  dsx3FracIfIndex.2.23 = 6\ndsx3FracIfIndex.2.10 = 4  dsx3FracIfIndex.2.24 = 6\ndsx3FracIfIndex.2.11 = 4  dsx3FracIfIndex.2.25 = 6\ndsx3FracIfIndex.2.12 = 5  dsx3FracIfIndex.2.26 = 6\ndsx3FracIfIndex.2.13 = 5  dsx3FracIfIndex.2.27 = 6\ndsx3FracIfIndex.2.14 = 5  dsx3FracIfIndex.2.28 = 6\nFor dsx3M23, dsx3 SYNTRAN, dsx3CbitParity, and\ndsx3ClearChannel  there are 28 legal channels,\nnumbered 1 through 28.\n\nFor e3Framed there are 16 legal channels, numbered\n1 through 16.  The channels (1..16) correspond\ndirectly to the equivalently numbered time-slots.")
dsx3FracEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 30, 13, 1)).setIndexNames((0, "DS3-MIB", "dsx3FracIndex"), (0, "DS3-MIB", "dsx3FracNumber"))
if mibBuilder.loadTexts: dsx3FracEntry.setDescription("An entry in the DS3 Fractional table.")
dsx3FracIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 13, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FracIndex.setDescription("The index value which uniquely identifies  the\nDS3  interface  to which this entry is applicable\nThe interface identified by a  particular value\nof  this  index is the same interface as\nidentified by the same value  an  dsx3LineIndex\nobject instance.")
dsx3FracNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 13, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsx3FracNumber.setDescription("The channel number for this entry.")
dsx3FracIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 30, 13, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsx3FracIfIndex.setDescription("An index value that uniquely identifies an\ninterface.  The interface identified by a\nparticular value of this index is the same\ninterface as  identified by the same value an\n\n\n\nifIndex object instance. If no interface is\ncurrently using a channel, the value should be\nzero.  If a single interface occupies more  than\none  time slot,  that ifIndex value will be found\nin multiple time slots.")
ds3Conformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 30, 14))
ds3Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 30, 14, 1))
ds3Compliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 30, 14, 2))
ds3Traps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 30, 15))

# Augmentions

# Notifications

dsx3LineStatusChange = NotificationType((1, 3, 6, 1, 2, 1, 10, 30, 15, 0, 1)).setObjects(("DS3-MIB", "dsx3LineStatusLastChange"), ("DS3-MIB", "dsx3LineStatus"), )
if mibBuilder.loadTexts: dsx3LineStatusChange.setDescription("A dsx3LineStatusChange trap is sent when the\nvalue of an instance of dsx3LineStatus changes. It\ncan be utilized by an NMS to trigger polls.  When\nthe line status change results in a lower level\nline status change (i.e., ds1), then no traps for\nthe lower level are sent.")

# Groups

ds3NearEndConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 30, 14, 1, 1)).setObjects(("DS3-MIB", "dsx3LineStatus"), ("DS3-MIB", "dsx3TransmitClockSource"), ("DS3-MIB", "dsx3Ds1ForRemoteLoop"), ("DS3-MIB", "dsx3LineIndex"), ("DS3-MIB", "dsx3TimeElapsed"), ("DS3-MIB", "dsx3CircuitIdentifier"), ("DS3-MIB", "dsx3LoopbackConfig"), ("DS3-MIB", "dsx3InvalidIntervals"), ("DS3-MIB", "dsx3ValidIntervals"), ("DS3-MIB", "dsx3LineLength"), ("DS3-MIB", "dsx3LineCoding"), ("DS3-MIB", "dsx3Channelization"), ("DS3-MIB", "dsx3SendCode"), ("DS3-MIB", "dsx3LoopbackStatus"), ("DS3-MIB", "dsx3LineType"), )
if mibBuilder.loadTexts: ds3NearEndConfigGroup.setDescription("A collection of objects providing configuration\ninformation applicable to all DS3/E3 interfaces.")
ds3NearEndStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 30, 14, 1, 2)).setObjects(("DS3-MIB", "dsx3TotalIndex"), ("DS3-MIB", "dsx3IntervalCESs"), ("DS3-MIB", "dsx3CurrentLCVs"), ("DS3-MIB", "dsx3IntervalUASs"), ("DS3-MIB", "dsx3TotalCCVs"), ("DS3-MIB", "dsx3CurrentPSESs"), ("DS3-MIB", "dsx3TotalSEFSs"), ("DS3-MIB", "dsx3IntervalNumber"), ("DS3-MIB", "dsx3TotalCSESs"), ("DS3-MIB", "dsx3TotalPCVs"), ("DS3-MIB", "dsx3CurrentLESs"), ("DS3-MIB", "dsx3IntervalLCVs"), ("DS3-MIB", "dsx3IntervalLESs"), ("DS3-MIB", "dsx3CurrentSEFSs"), ("DS3-MIB", "dsx3IntervalCSESs"), ("DS3-MIB", "dsx3CurrentIndex"), ("DS3-MIB", "dsx3TotalUASs"), ("DS3-MIB", "dsx3CurrentUASs"), ("DS3-MIB", "dsx3CurrentCESs"), ("DS3-MIB", "dsx3CurrentCSESs"), ("DS3-MIB", "dsx3IntervalPCVs"), ("DS3-MIB", "dsx3CurrentCCVs"), ("DS3-MIB", "dsx3IntervalIndex"), ("DS3-MIB", "dsx3TotalPESs"), ("DS3-MIB", "dsx3IntervalCCVs"), ("DS3-MIB", "dsx3TotalLCVs"), ("DS3-MIB", "dsx3IntervalValidData"), ("DS3-MIB", "dsx3TotalLESs"), ("DS3-MIB", "dsx3IntervalPSESs"), ("DS3-MIB", "dsx3IntervalPESs"), ("DS3-MIB", "dsx3TotalPSESs"), ("DS3-MIB", "dsx3TotalCESs"), ("DS3-MIB", "dsx3IntervalSEFSs"), ("DS3-MIB", "dsx3CurrentPCVs"), ("DS3-MIB", "dsx3CurrentPESs"), )
if mibBuilder.loadTexts: ds3NearEndStatisticsGroup.setDescription("A collection of objects providing statistics\ninformation applicable to all DS3/E3 interfaces.")
ds3FarEndGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 30, 14, 1, 3)).setObjects(("DS3-MIB", "dsx3FarEndFacilityIDCode"), ("DS3-MIB", "dsx3FarEndFrameIDCode"), ("DS3-MIB", "dsx3FarEndTotalCCVs"), ("DS3-MIB", "dsx3FarEndCurrentCESs"), ("DS3-MIB", "dsx3FarEndCurrentUASs"), ("DS3-MIB", "dsx3FarEndTotalUASs"), ("DS3-MIB", "dsx3FarEndIntervalNumber"), ("DS3-MIB", "dsx3FarEndCurrentCCVs"), ("DS3-MIB", "dsx3FarEndEquipCode"), ("DS3-MIB", "dsx3FarEndInvalidIntervals"), ("DS3-MIB", "dsx3FarEndTimeElapsed"), ("DS3-MIB", "dsx3FarEndTotalCESs"), ("DS3-MIB", "dsx3FarEndIntervalCCVs"), ("DS3-MIB", "dsx3FarEndLineIndex"), ("DS3-MIB", "dsx3FarEndIntervalIndex"), ("DS3-MIB", "dsx3FarEndUnitCode"), ("DS3-MIB", "dsx3FarEndValidIntervals"), ("DS3-MIB", "dsx3FarEndCurrentCSESs"), ("DS3-MIB", "dsx3FarEndLocationIDCode"), ("DS3-MIB", "dsx3FarEndIntervalUASs"), ("DS3-MIB", "dsx3FarEndTotalIndex"), ("DS3-MIB", "dsx3FarEndTotalCSESs"), ("DS3-MIB", "dsx3FarEndIntervalValidData"), ("DS3-MIB", "dsx3FarEndCurrentIndex"), ("DS3-MIB", "dsx3FarEndIntervalCESs"), ("DS3-MIB", "dsx3FarEndIntervalCSESs"), )
if mibBuilder.loadTexts: ds3FarEndGroup.setDescription("A collection of objects providing remote\nconfiguration and statistics information\napplicable to C-bit Parity and SYNTRAN DS3\ninterfaces.")
ds3DeprecatedGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 30, 14, 1, 4)).setObjects(("DS3-MIB", "dsx3IfIndex"), ("DS3-MIB", "dsx3FracNumber"), ("DS3-MIB", "dsx3FracIfIndex"), ("DS3-MIB", "dsx3FracIndex"), )
if mibBuilder.loadTexts: ds3DeprecatedGroup.setDescription("A collection of obsolete objects that may be\nimplemented for backwards compatibility.")
ds3NearEndOptionalConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 30, 14, 1, 5)).setObjects(("DS3-MIB", "dsx3LineStatusLastChange"), ("DS3-MIB", "dsx3LineStatusChangeTrapEnable"), )
if mibBuilder.loadTexts: ds3NearEndOptionalConfigGroup.setDescription("A collection of objects that may be implemented\non DS3/E3 interfaces.")
ds3NearEndOptionalTrapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 30, 14, 1, 6)).setObjects(("DS3-MIB", "dsx3LineStatusChange"), )
if mibBuilder.loadTexts: ds3NearEndOptionalTrapGroup.setDescription("A collection of notifications that may be\nimplemented on DS3/E3 interfaces.")

# Compliances

ds3Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 30, 14, 2, 1)).setObjects(("DS3-MIB", "ds3NearEndOptionalConfigGroup"), ("DS3-MIB", "ds3NearEndStatisticsGroup"), ("DS3-MIB", "ds3NearEndConfigGroup"), ("DS3-MIB", "ds3NearEndOptionalTrapGroup"), ("DS3-MIB", "ds3FarEndGroup"), )
if mibBuilder.loadTexts: ds3Compliance.setDescription("The compliance statement for DS3/E3 interfaces.")

# Exports

# Module identity
mibBuilder.exportSymbols("DS3-MIB", PYSNMP_MODULE_ID=ds3)

# Objects
mibBuilder.exportSymbols("DS3-MIB", ds3=ds3, dsx3ConfigTable=dsx3ConfigTable, dsx3ConfigEntry=dsx3ConfigEntry, dsx3LineIndex=dsx3LineIndex, dsx3IfIndex=dsx3IfIndex, dsx3TimeElapsed=dsx3TimeElapsed, dsx3ValidIntervals=dsx3ValidIntervals, dsx3LineType=dsx3LineType, dsx3LineCoding=dsx3LineCoding, dsx3SendCode=dsx3SendCode, dsx3CircuitIdentifier=dsx3CircuitIdentifier, dsx3LoopbackConfig=dsx3LoopbackConfig, dsx3LineStatus=dsx3LineStatus, dsx3TransmitClockSource=dsx3TransmitClockSource, dsx3InvalidIntervals=dsx3InvalidIntervals, dsx3LineLength=dsx3LineLength, dsx3LineStatusLastChange=dsx3LineStatusLastChange, dsx3LineStatusChangeTrapEnable=dsx3LineStatusChangeTrapEnable, dsx3LoopbackStatus=dsx3LoopbackStatus, dsx3Channelization=dsx3Channelization, dsx3Ds1ForRemoteLoop=dsx3Ds1ForRemoteLoop, dsx3CurrentTable=dsx3CurrentTable, dsx3CurrentEntry=dsx3CurrentEntry, dsx3CurrentIndex=dsx3CurrentIndex, dsx3CurrentPESs=dsx3CurrentPESs, dsx3CurrentPSESs=dsx3CurrentPSESs, dsx3CurrentSEFSs=dsx3CurrentSEFSs, dsx3CurrentUASs=dsx3CurrentUASs, dsx3CurrentLCVs=dsx3CurrentLCVs, dsx3CurrentPCVs=dsx3CurrentPCVs, dsx3CurrentLESs=dsx3CurrentLESs, dsx3CurrentCCVs=dsx3CurrentCCVs, dsx3CurrentCESs=dsx3CurrentCESs, dsx3CurrentCSESs=dsx3CurrentCSESs, dsx3IntervalTable=dsx3IntervalTable, dsx3IntervalEntry=dsx3IntervalEntry, dsx3IntervalIndex=dsx3IntervalIndex, dsx3IntervalNumber=dsx3IntervalNumber, dsx3IntervalPESs=dsx3IntervalPESs, dsx3IntervalPSESs=dsx3IntervalPSESs, dsx3IntervalSEFSs=dsx3IntervalSEFSs, dsx3IntervalUASs=dsx3IntervalUASs, dsx3IntervalLCVs=dsx3IntervalLCVs, dsx3IntervalPCVs=dsx3IntervalPCVs, dsx3IntervalLESs=dsx3IntervalLESs, dsx3IntervalCCVs=dsx3IntervalCCVs, dsx3IntervalCESs=dsx3IntervalCESs, dsx3IntervalCSESs=dsx3IntervalCSESs, dsx3IntervalValidData=dsx3IntervalValidData, dsx3TotalTable=dsx3TotalTable, dsx3TotalEntry=dsx3TotalEntry, dsx3TotalIndex=dsx3TotalIndex, dsx3TotalPESs=dsx3TotalPESs, dsx3TotalPSESs=dsx3TotalPSESs, dsx3TotalSEFSs=dsx3TotalSEFSs, dsx3TotalUASs=dsx3TotalUASs, dsx3TotalLCVs=dsx3TotalLCVs, dsx3TotalPCVs=dsx3TotalPCVs, dsx3TotalLESs=dsx3TotalLESs, dsx3TotalCCVs=dsx3TotalCCVs, dsx3TotalCESs=dsx3TotalCESs, dsx3TotalCSESs=dsx3TotalCSESs, dsx3FarEndConfigTable=dsx3FarEndConfigTable, dsx3FarEndConfigEntry=dsx3FarEndConfigEntry, dsx3FarEndLineIndex=dsx3FarEndLineIndex, dsx3FarEndEquipCode=dsx3FarEndEquipCode, dsx3FarEndLocationIDCode=dsx3FarEndLocationIDCode, dsx3FarEndFrameIDCode=dsx3FarEndFrameIDCode, dsx3FarEndUnitCode=dsx3FarEndUnitCode, dsx3FarEndFacilityIDCode=dsx3FarEndFacilityIDCode, dsx3FarEndCurrentTable=dsx3FarEndCurrentTable, dsx3FarEndCurrentEntry=dsx3FarEndCurrentEntry, dsx3FarEndCurrentIndex=dsx3FarEndCurrentIndex, dsx3FarEndTimeElapsed=dsx3FarEndTimeElapsed, dsx3FarEndValidIntervals=dsx3FarEndValidIntervals, dsx3FarEndCurrentCESs=dsx3FarEndCurrentCESs, dsx3FarEndCurrentCSESs=dsx3FarEndCurrentCSESs, dsx3FarEndCurrentCCVs=dsx3FarEndCurrentCCVs, dsx3FarEndCurrentUASs=dsx3FarEndCurrentUASs, dsx3FarEndInvalidIntervals=dsx3FarEndInvalidIntervals, dsx3FarEndIntervalTable=dsx3FarEndIntervalTable, dsx3FarEndIntervalEntry=dsx3FarEndIntervalEntry, dsx3FarEndIntervalIndex=dsx3FarEndIntervalIndex, dsx3FarEndIntervalNumber=dsx3FarEndIntervalNumber, dsx3FarEndIntervalCESs=dsx3FarEndIntervalCESs, dsx3FarEndIntervalCSESs=dsx3FarEndIntervalCSESs, dsx3FarEndIntervalCCVs=dsx3FarEndIntervalCCVs, dsx3FarEndIntervalUASs=dsx3FarEndIntervalUASs, dsx3FarEndIntervalValidData=dsx3FarEndIntervalValidData, dsx3FarEndTotalTable=dsx3FarEndTotalTable, dsx3FarEndTotalEntry=dsx3FarEndTotalEntry, dsx3FarEndTotalIndex=dsx3FarEndTotalIndex, dsx3FarEndTotalCESs=dsx3FarEndTotalCESs, dsx3FarEndTotalCSESs=dsx3FarEndTotalCSESs, dsx3FarEndTotalCCVs=dsx3FarEndTotalCCVs, dsx3FarEndTotalUASs=dsx3FarEndTotalUASs, dsx3FracTable=dsx3FracTable, dsx3FracEntry=dsx3FracEntry, dsx3FracIndex=dsx3FracIndex, dsx3FracNumber=dsx3FracNumber, dsx3FracIfIndex=dsx3FracIfIndex, ds3Conformance=ds3Conformance, ds3Groups=ds3Groups, ds3Compliances=ds3Compliances, ds3Traps=ds3Traps)

# Notifications
mibBuilder.exportSymbols("DS3-MIB", dsx3LineStatusChange=dsx3LineStatusChange)

# Groups
mibBuilder.exportSymbols("DS3-MIB", ds3NearEndConfigGroup=ds3NearEndConfigGroup, ds3NearEndStatisticsGroup=ds3NearEndStatisticsGroup, ds3FarEndGroup=ds3FarEndGroup, ds3DeprecatedGroup=ds3DeprecatedGroup, ds3NearEndOptionalConfigGroup=ds3NearEndOptionalConfigGroup, ds3NearEndOptionalTrapGroup=ds3NearEndOptionalTrapGroup)

# Compliances
mibBuilder.exportSymbols("DS3-MIB", ds3Compliance=ds3Compliance)
