# PySNMP SMI module. Autogenerated from smidump -f python DSMON-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:24 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( Dscp, ) = mibBuilder.importSymbols("DIFFSERV-DSCP-TC", "Dscp")
( CounterBasedGauge64, ZeroBasedCounter64, ) = mibBuilder.importSymbols("HCNUM-TC", "CounterBasedGauge64", "ZeroBasedCounter64")
( OwnerString, rmon, ) = mibBuilder.importSymbols("RMON-MIB", "OwnerString", "rmon")
( DataSource, LastCreateTime, TimeFilter, ZeroBasedCounter32, protocolDirLocalIndex, ) = mibBuilder.importSymbols("RMON2-MIB", "DataSource", "LastCreateTime", "TimeFilter", "ZeroBasedCounter32", "protocolDirLocalIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( RowStatus, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class DsmonCounterAggGroupIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483647)
    
class DsmonCounterAggProfileIndex(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,2147483647)
    

# Objects

dsmonMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 26)).setRevisions(("2002-05-31 00:00",))
if mibBuilder.loadTexts: dsmonMIB.setOrganization("IETF RMONMIB Working Group")
if mibBuilder.loadTexts: dsmonMIB.setContactInfo("        Andy Bierman\nCisco Systems, Inc.\nRMONMIB WG Chair and DSMON MIB Editor\n\nPostal: 170 West Tasman Drive\nSan Jose, CA USA 95134\nTel: +1 408 527-3711\nE-mail: abierman@cisco.com\n\nSend comments to <rmonmib@ietf.org>\nMailing list subscription info:\nhttp://www.ietf.org/mailman/listinfo/rmonmib ")
if mibBuilder.loadTexts: dsmonMIB.setDescription("This module defines Remote Monitoring MIB extensions for\nDifferentiated Services enabled networks.\n\n RMON DIFFSERV DSCP statistics\n  * Per Counter Aggregation Group\n  * Per Protocol Per Counter Aggregation Group\n  * Per Counter Aggregation Group Per Host\n\n\n\n  * Per Counter Aggregation Group Per Host-Pair\n\nIn order to maintain the RMON 'look-and-feel' and semantic\nconsistency, some of the text from the RMON-2 and HC-RMON\nMIBs by Steve Waldbusser has been adapted for use in this\nMIB.")
dsmonObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1))
dsmonAggObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1, 1))
dsmonMaxAggGroups = MibScalar((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(2, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMaxAggGroups.setDescription("The maximum number of counter aggregation groups that this\nagent can support.  The agent will allow this number of\ndistinct groups to be configured in the\ndsmonAggProfileTable, numbered from '0' to\n'dsmonMaxAggGroups - 1', for each counter aggregation\nprofile entry supported by the agent.\n\nThe agent MUST NOT lower this value during system operation,\nand SHOULD set this object to an appropriate value during\nsystem initialization.")
dsmonAggControlLocked = MibScalar((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsmonAggControlLocked.setDescription("Controls the setup of counter aggregation groups for this\nagent.\n\nIf this object contains the value 'true', then write access\nto the objects in the dsmonAggControlTable (except the\ndsmonAggControlOwner object), dsmonAggProfileTable, and\ndsmonAggGroupTable is not permitted, and data collection is\npossible.  This object only controls write access to these\nMIB objects.  The DSMON data collection control tables\n(e.g., dsmonHostCtlTable) can be configured at any time,\nregardless of the value of this object.\n\nIf this object contains the value 'false', write access to\nthe objects in the dsmonAggControlTable,\ndsmonAggProfileTable, and dsmonAggGroupTable is permitted,\nand data collection is not possible.  In addition, all\nobjects in all DSMON data tables (e.g., dsmonStatsTable)\nshall be deleted.\n\nAn agent is not required to process SNMP Set Requests for\nthis object in conjunction with other objects from this MIB.\nThis is intended to simplify the processing of Set Requests\nfor tables such as the dsmonAggProfileTable, by eliminating\nthe possibility that a single Set PDU will contain multiple\nvarbinds which are in conflict, such as a PDU which both\nmodifies the dsmonAggProfileTable and locks the\n\n\n\ndsmonAggProfileTable at the same time.\n\nNote that the agent is not required to validate the entire\ncounter aggregation configuration when an attempt is made to\ntransition an instance of this object from 'true' to\n'false'.  That validation is done if and when a DSMON data\ncollection is activated.\n\nAn agent is required to reactivate any suspended data\ncollections when this object transitions to 'true', Each\nactive data control entry (e.g., dsmonStatsControlEntry),\nwill be validated with respect to the new counter\naggregation configuration.  If the counter aggregation\nprofile referenced in the data collection is valid, then\nthat collection will be restarted.  Otherwise, the RowStatus\nobject (e.g., dsmonStatsControlStatus) will be set to\n'notReady' for that collection control entry.")
dsmonAggControlChanges = MibScalar((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonAggControlChanges.setDescription("This object counts the number of times the value of the\ndsmonAggControlLocked object has changed.  A management\nstation can use this object to detect if counters in the\nDSMON data tables (e.g., dsmonStatsEntry) have been deleted\nand recreated between polls.\n\nThis object shall be incremented by one each time the\ndsmonAggControlLocked object changes from 'false' to 'true',\nor from 'true' to 'false'.")
dsmonAggControlLastChangeTime = MibScalar((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonAggControlLastChangeTime.setDescription("This object identifies the value of sysUpTime at the moment\nthe dsmonAggControlLocked object was last modified.  A\nmanagement station can use this object to detect if counters\nin the DSMON data tables (e.g., dsmonStatsEntry) have been\ndeleted and recreated between polls.\n\nThis object shall be updated with the current value of\nsysUpTime, if the dsmonAggControlLocked object changes from\n\n\n\n'false' to 'true', or from 'true' to 'false'.\n\nUpon system initialization, this object shall contain the\nvalue zero.")
dsmonAggControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 5))
if mibBuilder.loadTexts: dsmonAggControlTable.setDescription("This table provides an overall description and control\npoint for all dsmonAggProfileEntries with the same\ndsmonAggControlIndex value.\n\nA management application SHOULD create a counter aggregation\nprofile by first creating and activating an entry in this\ntable.  This will cause the agent to create a set of 64\ndsmonAggProfileEntries on behalf of this control entry.  An\napplication can then set the individual counter aggregation\ngroup assignments for each of the 64 DSCP values,\n\nThis table MUST NOT be modified if the dsmonAggControlLocked\nobject is equal to 'true'.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table, and\n(independently) the number of counter aggregation profiles\nwhich may be applied to a particular data source.  In this\ncase, the agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.  Otherwise, each\npotential counter aggregation group description string\nSHOULD contain the empty string.")
dsmonAggControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 5, 1)).setIndexNames((0, "DSMON-MIB", "dsmonAggControlIndex"))
if mibBuilder.loadTexts: dsmonAggControlEntry.setDescription("A conceptual row in the dsmonAggControlTable.")
dsmonAggControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 5, 1, 1), DsmonCounterAggProfileIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonAggControlIndex.setDescription("An arbitrary integer index value used to identify the\ncounter aggregation profile specified by this control\nentry.")
dsmonAggControlDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 5, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonAggControlDescr.setDescription("An administratively assigned description of the counter\naggregation profile identified by this entry.\n\nUpon first creation of an instance of this object, the agent\nSHOULD set this object to the empty string.  If the agent\nsupports non-volatile storage, then this object SHOULD be\nre-initialized with its stored value after a system reboot.\n\nThis object MUST NOT be modified if the associated\ndsmonAggControlStatus object is equal to 'active', or the\ndsmonAggControlLocked object is equal to 'true'.")
dsmonAggControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 5, 1, 3), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonAggControlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonAggControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonAggControlStatus.setDescription("The status of this row.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nUpon setting this object to active(1), the agent will create\na complete set of 64 associated entries in the\ndsmonAggProfileTable.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonAggProfileTable shall be deleted.\n\nThis object MUST NOT be modified if the\ndsmonAggControlLocked object is equal to 'true'.")
dsmonAggProfileTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 6))
if mibBuilder.loadTexts: dsmonAggProfileTable.setDescription("Controls the setup of counter aggregation profiles for this\nagent.  For each such profile, every DSCP value MUST be\nconfigured into exactly one counter aggregation group.\n\nThis table MUST NOT be modified if the dsmonAggControlLocked\nobject is equal to 'true'.\n\nThe agent will create a set of 64 entries in this table\n(with the same dsmonAggControlIndex value) when the\nassociated dsmonAggControlEntry is activated.\n\nIf the agent supports non-volatile configuration of this\ntable, then upon system initialization, this table SHOULD be\ninitialized with the saved values.")
dsmonAggProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 6, 1)).setIndexNames((0, "DSMON-MIB", "dsmonAggControlIndex"), (0, "DSMON-MIB", "dsmonAggProfileDSCP"))
if mibBuilder.loadTexts: dsmonAggProfileEntry.setDescription("A conceptual row in the dsmonAggProfileTable.  The\ndsmonAggControlIndex value in the index identifies the\ndsmonAggControlEntry associated with each entry in this\ntable.")
dsmonAggProfileDSCP = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 6, 1, 1), Dscp()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonAggProfileDSCP.setDescription("The specific DSCP value for the DSCP counter which is\nconfigured in a counter aggregation group by this entry.")
dsmonAggGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 6, 1, 2), DsmonCounterAggGroupIndex().clone('0')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dsmonAggGroupIndex.setDescription("The counter aggregation group which contains this DSCP\nvalue.  Upon creation of a new sub-tree (set of 64 entries\nwith the same dsmonAggControlIndex value) in this table, the\nagent SHOULD initialize all related instances of this object\nto the value zero.\n\nThis object MUST NOT be modified if the\ndsmonAggControlLocked object is equal to 'true'.")
dsmonAggGroupTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 7))
if mibBuilder.loadTexts: dsmonAggGroupTable.setDescription("This table provides a description of each counter\naggregation group configured on this system.  Note that the\nsemantics of a particular counter aggregation group are only\nrelevant within the scope of a particular counter\naggregation profile.\n\nThis table MUST NOT be modified if the dsmonAggControlLocked\nobject is equal to 'true'.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table, and\n(independently) the number of counter aggregation profiles\nwhich may be applied to a particular data source.  In this\ncase, the agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].\n\nIf the agent supports non-volatile configuration of this\ntable, then upon system initialization, this table SHOULD be\ninitialized with the saved values.  Otherwise, each\npotential counter aggregation group description string\nSHOULD contain the empty string.\n\nAn agent SHOULD allow entries to be created or modified in\nthis table, even if the specified dsmonAggControlIndex value\ndoes not identify a valid dsmonAggControlEntry or a complete\nset of valid dsmonAggProfileEntries, to reduce row creation\norder dependencies.")
dsmonAggGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 7, 1)).setIndexNames((0, "DSMON-MIB", "dsmonAggControlIndex"), (0, "DSMON-MIB", "dsmonAggGroupIndex"))
if mibBuilder.loadTexts: dsmonAggGroupEntry.setDescription("A conceptual row in the dsmonAggGroupTable.  The\ndsmonAggGroupIndex value in the INDEX identifies the counter\naggregation group associated with each entry.\n\nThe dsmonAggControlIndex in the index identifies the counter\naggregation profile associated with each entry, identified\nby the dsmonAggControlEntry and dsmonAggProfileEntries with\nthe same index value.\n\n\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nThe dsmonAggGroupIndex in the index identifies the counter\naggregation group associated with each entry.  This object\nSHOULD be indexed from zero to 'N', where 'N' is less than\nthe value of the dsmonMaxAggGroups for this agent.")
dsmonAggGroupDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 7, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonAggGroupDescr.setDescription("An administratively assigned description of the counter\naggregation group identified by this entry.\n\nUpon first creation of an instance of this object, the agent\nSHOULD set this object to the empty string.\n\nThis object MUST NOT be modified if the associated\ndsmonAggGroupStatus object is equal to 'active', or the\ndsmonAggControlLocked object is equal to 'true'.")
dsmonAggGroupStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 1, 7, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonAggGroupStatus.setDescription("The status of this row.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nThis object MUST NOT be modified if the\ndsmonAggControlLocked object is equal to 'true'.")
dsmonStatsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1, 2))
dsmonStatsControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1))
if mibBuilder.loadTexts: dsmonStatsControlTable.setDescription("Controls the setup of per data source per counter\naggregation group distribution statistics.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonStatsControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1)).setIndexNames((0, "DSMON-MIB", "dsmonStatsControlIndex"))
if mibBuilder.loadTexts: dsmonStatsControlEntry.setDescription("A conceptual row in the dsmonStatsControlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonStatsControlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\nassociated dsmonStatsTable to be created and maintained by\nthe agent.")
dsmonStatsControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonStatsControlIndex.setDescription("An arbitrary and unique index for this\ndsmonStatsControlEntry.")
dsmonStatsControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonStatsControlDataSource.setDescription("The data source of this per protocol per counter\naggregation group distribution.\n\nNote that only packets that contain a network protocol\nencapsulation which contains a DS field [RFC2474] will be\ncounted in this table.\n\nThis object MUST NOT be modified if the associated\ndsmonStatsControlStatus object is equal to active(1).")
dsmonStatsControlAggProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 3), DsmonCounterAggProfileIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonStatsControlAggProfile.setDescription("The dsmonAggControlIndex value identifying the counter\naggregation profile which should be used on behalf of this\ndsmonStatsControlEntry.\n\nThe associated dsmonAggControlEntry and\ndsmonAggProfileEntries, identified by the same\ndsmonAggControlIndex index value, MUST be active in order\nfor this entry to remain active.  It is possible for the\ncounter aggregation configuration to change from a valid to\ninvalid state for this dsmonStats collection.  In this case,\n\n\n\nthe associated dsmonStatsControlStatus object will be\nchanged to the 'notReady' state, and data collection will\nnot occur on behalf of this control entry.\n\nNote that an agent MAY choose to limit the actual number of\ncounter aggregation profiles which may be applied to a\nparticular data source.\n\nThis object MUST NOT be modified if the associated\ndsmonStatsControlStatus object is equal to active(1).")
dsmonStatsControlDroppedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsControlDroppedFrames.setDescription("The total number of frames which were received by the probe\nand therefore not accounted for in the *StatsDropEvents, but\nfor which the probe chose not to count for this entry for\nwhatever reason.  Most often, this event occurs when the\nprobe is out of some resources and decides to shed load from\nthis collection.\n\nThis count does not include packets that were not counted\nbecause they had MAC-layer errors.\n\nNote that, unlike the dropEvents counter, this number is the\nexact number of frames dropped.")
dsmonStatsControlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 5), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsControlCreateTime.setDescription("The value of sysUpTime when this control entry was last\nactivated.  This can be used by the management station to\ndetect if the table has been deleted and recreated between\npolls.")
dsmonStatsControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 6), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonStatsControlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonStatsControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 1, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonStatsControlStatus.setDescription("The status of this row.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonStatsTable shall be deleted.")
dsmonStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2))
if mibBuilder.loadTexts: dsmonStatsTable.setDescription("A list of information on counter aggregation group usage\nfor each monitored data source.\n\nThe following table defines per counter aggregation group\nstatistics for full and/or half-duplex links as well as high\ncapacity links.\n\nFor half-duplex links, or full-duplex-capable links\noperating in half-duplex mode, the dsmonStatsIn* objects\nshall be used and the dsmonStatsOut* objects will not\nincrement.\n\nFor full-duplex links, the dsmonStatsOut* objects will be\npresent.  Whenever possible, the probe SHOULD count packets\nmoving away from the closest terminating equipment as output\npackets.  Failing that, the probe SHOULD count packets\nmoving away from the DTE as output packets.\n\nIf the dsmonAggControlLocked object is equal to 'false',\nthen all entries in this table will be deleted and the agent\nwill not process packets on behalf of any\n\n\n\ndsmonStatsControlEntry.")
dsmonStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1)).setIndexNames((0, "DSMON-MIB", "dsmonStatsControlIndex"), (0, "DSMON-MIB", "dsmonAggGroupIndex"))
if mibBuilder.loadTexts: dsmonStatsEntry.setDescription("A list of information on Differentiated Services DSCP\nusage, containing inbound and outbound packet and octet\ncounters for each counter aggregation group configured for\ncollection.\n\nThe dsmonStatsControlIndex value in the index identifies the\ndsmonStatsControlEntry on whose behalf this entry was\ncreated.\n\nThe dsmonAggGroupIndex value in the index is determined by\nexamining the DSCP value in each monitored packet, and the\ndsmonAggProfileTable entry for that DSCP value.\n\nNote that only packets that contain a network protocol\nencapsulation which contains a DS field [RFC2474] will be\ncounted in this table.\n\nAn example of the indexing of this entry is\ndsmonStatsOutPkts.1.16")
dsmonStatsInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 1), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsInPkts.setDescription("The number of packets using one of the DSCP values in the\nindicated counter aggregation group, received on a half-\nduplex link or on the inbound connection of a full-duplex\nlink.")
dsmonStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsInOctets.setDescription("The number of octets in packets, using one of the DSCP\nvalues in the indicated counter aggregation group, received\non a half-duplex link or on the inbound connection of a\nfull-duplex link.")
dsmonStatsInOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsInOvflPkts.setDescription("The number of times the associated dsmonStatsInPkts counter\nhas overflowed.  Note that this object will only be\ninstantiated if the associated dsmonStatsInHCPkts object is\nalso instantiated for a particular dataSource.")
dsmonStatsInOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsInOvflOctets.setDescription("The number of times the associated dsmonStatsInOctets\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonStatsInHCOctets object\nis also instantiated for a particular dataSource.")
dsmonStatsInHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 5), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsInHCPkts.setDescription("The 64-bit version of the dsmonStatsInPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonStatsInHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 6), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsInHCOctets.setDescription("The 64-bit version of the dsmonStatsInOctets object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonStatsOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 7), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsOutPkts.setDescription("The number of packets using one of the DSCP values in the\nindicated counter aggregation group, received on a full-\nduplex link in the direction of the network.")
dsmonStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 8), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsOutOctets.setDescription("The number of octets in packets, using one of the DSCP\nvalues in the indicated counter aggregation group, received\non a full-duplex link in the direction of the network.")
dsmonStatsOutOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 9), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsOutOvflPkts.setDescription("The number of times the associated dsmonStatsOutPkts\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonStatsOutHCPkts object is\nalso instantiated for a particular dataSource.")
dsmonStatsOutOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 10), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsOutOvflOctets.setDescription("The number of times the associated dsmonStatsOutOctets\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonStatsOutHCOctets object\nis also instantiated for a particular dataSource.")
dsmonStatsOutHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 11), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsOutHCPkts.setDescription("The 64-bit version of the dsmonStatsOutPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonStatsOutHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 2, 2, 1, 12), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonStatsOutHCOctets.setDescription("The 64-bit version of the dsmonStatsOutOctets object.\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonPdistObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1, 3))
dsmonPdistCtlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1))
if mibBuilder.loadTexts: dsmonPdistCtlTable.setDescription("Controls the setup of per application per counter\naggregation group distribution statistics.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonPdistCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1)).setIndexNames((0, "DSMON-MIB", "dsmonPdistCtlIndex"))
if mibBuilder.loadTexts: dsmonPdistCtlEntry.setDescription("A conceptual row in the dsmonPdistCtlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonPdistCtlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\nassociated dsmonPdistStatsTable to be created and maintained\nby the agent.")
dsmonPdistCtlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonPdistCtlIndex.setDescription("An arbitrary and unique index for this dsmonPdistCtlEntry.")
dsmonPdistCtlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistCtlDataSource.setDescription("The source of data for the this per protocol counter\naggregation group distribution.\n\nThis object MUST NOT be modified if the associated\ndsmonPdistCtlStatus object is equal to active(1).")
dsmonPdistCtlAggProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 3), DsmonCounterAggProfileIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistCtlAggProfile.setDescription("The dsmonAggControlIndex value identifying the counter\naggregation profile which should be used on behalf of this\ndsmonPdistCtlEntry.\n\nThe associated dsmonAggControlEntry and\ndsmonAggProfileEntries, identified by the same\ndsmonAggControlIndex index value, MUST be active in order\nfor this entry to remain active.  It is possible for the\ncounter aggregation configuration to change from a valid to\ninvalid state for this dsmonPdist collection.  In this case,\nthe associated dsmonPdistCtlStatus object will be changed to\nthe 'notReady' state, and data collection will not occur on\nbehalf of this control entry.\n\nNote that an agent MAY choose to limit the actual number of\ncounter aggregation profiles which may be applied to a\nparticular data source.\n\n\n\n\nThis object MUST NOT be modified if the associated\ndsmonPdistCtlStatus object is equal to active(1).")
dsmonPdistCtlMaxDesiredEntries = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-1,-1),constraint.ValueRangeConstraint(1,2147483647),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistCtlMaxDesiredEntries.setDescription("The maximum number of entries that are desired in the\ndsmonPdistStatsTable on behalf of this control entry.  The\nprobe will not create more than this number of associated\nentries in the table, but MAY choose to create fewer entries\nin this table for any reason including the lack of\nresources.\n\nIf this value is set to -1, the probe MAY create any number\nof entries in this table.\n\nThis object MUST NOT be modified if the associated\ndsmonPdistCtlStatus object is equal to active(1).")
dsmonPdistCtlDroppedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistCtlDroppedFrames.setDescription("The total number of frames which were received by the probe\nand therefore not accounted for in the *StatsDropEvents, but\nfor which the probe chose not to count for this entry for\nwhatever reason.  Most often, this event occurs when the\nprobe is out of some resources and decides to shed load from\nthis collection.\n\nThis count does not include packets that were not counted\nbecause they had MAC-layer errors.\n\nNote that, unlike the dropEvents counter, this number is the\nexact number of frames dropped.")
dsmonPdistCtlInserts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistCtlInserts.setDescription("The number of times a dsmonPdist entry has been inserted\ninto the dsmonPdistTable.  If an entry is inserted, then\ndeleted, and then inserted, this counter will be incremented\nby 2.\n\nTo allow for efficient implementation strategies, agents MAY\ndelay updating this object for short periods of time.  For\nexample, an implementation strategy may allow internal data\nstructures to differ from those visible via SNMP for short\nperiods of time.  This counter may reflect the internal data\nstructures for those short periods of time.\n\nNote that the table size can be determined by subtracting\ndsmonPdistCtlDeletes from dsmonPdistCtlInserts.")
dsmonPdistCtlDeletes = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistCtlDeletes.setDescription("The number of times a dsmonPdist entry has been deleted\nfrom the dsmonPdist table (for any reason).  If an entry is\ndeleted, then inserted, and then deleted, this counter will\nbe incremented by 2.\n\nTo allow for efficient implementation strategies, agents MAY\ndelay updating this object for short periods of time.  For\nexample, an implementation strategy may allow internal data\nstructures to differ from those visible via SNMP for short\nperiods of time.  This counter may reflect the internal data\nstructures for those short periods of time.\n\nNote that the table size can be determined by subtracting\ndsmonPdistCtlDeletes from dsmonPdistCtlInserts.")
dsmonPdistCtlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 8), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistCtlCreateTime.setDescription("The value of sysUpTime when this control entry was last\nactivated.  This can be used by the management station to\ndetect if the table has been deleted and recreated between\npolls.")
dsmonPdistCtlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 9), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistCtlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonPdistCtlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 1, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistCtlStatus.setDescription("The status of this row.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonPdistStatsTable shall be deleted.")
dsmonPdistStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2))
if mibBuilder.loadTexts: dsmonPdistStatsTable.setDescription("A list of information on a per protocol per counter\naggregation group usage.\n\nIf the dsmonAggControlLocked object is equal to 'false',\nthen all entries in this table will be deleted and the agent\nwill not process packets on behalf of any\ndsmonPdistCtlEntry.")
dsmonPdistStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1)).setIndexNames((0, "DSMON-MIB", "dsmonPdistCtlIndex"), (0, "DSMON-MIB", "dsmonPdistTimeMark"), (0, "DSMON-MIB", "dsmonAggGroupIndex"), (0, "RMON2-MIB", "protocolDirLocalIndex"))
if mibBuilder.loadTexts: dsmonPdistStatsEntry.setDescription("A list of information on Differentiated Services DSCP\nusage, containing packet and octet counters for each counter\naggregation group configured for collection, and each\nprotocol (as identified by the protocolDirLocalIndex for the\nprotocol) identified in each monitored packet.\n\nThe dsmonPdistCtlIndex value in the index identifies the\ndsmonPdistCtlEntry on whose behalf this entry was created.\n\nNote that only packets that contain a network protocol\nencapsulation which contains a DS field [RFC2474] will be\ncounted in this table.\n\nThe dsmonAggGroupIndex value in the index is determined by\nexamining the DSCP value in each monitored packet, and the\ndsmonAggProfileTable entry for that value.\n\nThe protocolDirLocalIndex in the index identifies the\nprotocolDirEntry for the protocol encapsulation of each\nmonitored packet.  The agent will include only application\nlayer protocols in the associated dsmonPdistStatsTable.  Any\n'terminal' protocol is considered to be an application\nprotocol.\n\nAn example of the indexing of this entry is\ndsmonPdistStatsPkts.9.29943.0.42.")
dsmonPdistTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 1), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonPdistTimeMark.setDescription("The Time Filter index for this table.  This object may be\nused by a management station to retrieve only rows which\nhave been created or modified since a particular time.  Note\nthat the current value for a row are always returned and the\nTimeFilter is not a historical data archiving mechanism.\nRefer to RFC 2021 [RFC2021] for a detailed description of\nTimeFilter operation.")
dsmonPdistStatsPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsPkts.setDescription("The number of packets, using one of the DSCP values in the\nindicated counter aggregation group, for the protocol\nidentified by the associated protocolDirLocalIndex value.")
dsmonPdistStatsOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsOctets.setDescription("The number of octets in packets, using one of the DSCP\nvalues in the indicated counter aggregation group, for the\nprotocol identified by the associated protocolDirLocalIndex\nvalue.\n\nNote that this object doesn't count just those octets in the\nparticular protocol frames, but includes the entire packet\nthat contained the protocol.")
dsmonPdistStatsOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsOvflPkts.setDescription("The number of times the associated dsmonPdistStatsPkts\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonPdistStatsHCPkts object\nis also instantiated for a particular dataSource.")
dsmonPdistStatsOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 5), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsOvflOctets.setDescription("The number of times the associated dsmonPdistStatsOctets\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonPdistStatsHCOctets\nobject is also instantiated for a particular dataSource.")
dsmonPdistStatsHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 6), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsHCPkts.setDescription("The 64-bit version of the dsmonPdistStatsPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonPdistStatsHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 7), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsHCOctets.setDescription("The 64-bit version of the dsmonPdistStatsOctets object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonPdistStatsCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 2, 1, 8), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistStatsCreateTime.setDescription("The value of sysUpTime when this dsmonPdistStats entry was\nlast instantiated by the agent.  This can be used by the\nmanagement station to detect if the entry has been deleted\nand recreated between polls.")
dsmonPdistTopNCtlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3))
if mibBuilder.loadTexts: dsmonPdistTopNCtlTable.setDescription("A set of parameters that control the creation of a report\nof the top N dsmonPdist entries according to a particular\nmetric.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonPdistTopNCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1)).setIndexNames((0, "DSMON-MIB", "dsmonPdistTopNCtlIndex"))
if mibBuilder.loadTexts: dsmonPdistTopNCtlEntry.setDescription("A conceptual row in the dsmonPdistTopNCtlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonPdistTopNCtlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\nassociated dsmonPdistTopNTable to be created and maintained\nby the agent.")
dsmonPdistTopNCtlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonPdistTopNCtlIndex.setDescription("An index that uniquely identifies an entry in the\ndsmonPdistTopNCtlTable, with the same dsmonPdistTopNCtlIndex\nvalue as this object.  Each entry in this table defines one\nTop N report prepared on behalf of the dsmonPdistStatsEntry\ncollection with the same dsmonPdistCtlIndex as this object.")
dsmonPdistTopNCtlPdistIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistTopNCtlPdistIndex.setDescription("The dsmonPdistTable for which a top N report will be\nprepared on behalf of this entry.  The dsmonPdistTable is\nidentified by the value of the dsmonPdistCtlIndex for that\ntable - that value is used here to identify the particular\ntable.\n\nThis object MUST NOT be modified if the associated\ndsmonPdistTopNCtlStatus object is equal to active(1).")
dsmonPdistTopNCtlRateBase = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,)).subtype(namedValues=namedval.NamedValues(("dsmonPdistTopNPkts", 1), ("dsmonPdistTopNOctets", 2), ("dsmonPdistTopNHCPkts", 3), ("dsmonPdistTopNHCOctets", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistTopNCtlRateBase.setDescription("The variable for each dsmonPdist that the\ndsmonPdistTopNRate and dsmonPdistTopNHCRate variables are\nbased upon.  Each dsmonPdistTopN report generated on behalf\nof this control entry will be ranked in descending order,\n\n\n\nbased on the associated dsmonPdistStatsTable counter,\nidentified by this object.\n\nThe following table identifies the dsmonPdistTable counter\nassociated with each enumeration:\n\nEnumeration              RateBase MIB Object\n-----------              -------------------\ndsmonPdistTopNPkts          dsmonPdistStatsPkts\ndsmonPdistTopNOctets        dsmonPdistStatsOctets\ndsmonPdistTopNHCPkts        dsmonPdistStatsHCPkts\ndsmonPdistTopNHCOctets      dsmonPdistStatsHCOctets\n\nNote that the dsmonPdistTopNHCPkts and\ndsmonPdistTopNHCOctets enumerations are only available if\nthe agent supports High Capacity monitoring.\n\nThis object MUST NOT be modified if the associated\ndsmonPdistTopNCtlStatus object is equal to active(1).")
dsmonPdistTopNCtlTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(1800)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistTopNCtlTimeRemaining.setDescription("The number of seconds left in the report currently being\ncollected.  When this object is modified by the management\nstation, a new collection is started, possibly aborting a\ncurrently running report.  The new value is used as the\nrequested duration of this report, and is immediately loaded\ninto the associated dsmonPdistTopNCtlDuration object.\n\nWhen the report finishes, the probe will automatically start\nanother collection with the same initial value of\ndsmonPdistTopNCtlTimeRemaining.  Thus the management station\nmay simply read the resulting reports repeatedly, checking\nthe startTime and duration each time to ensure that a report\nwas not missed or that the report parameters were not\nchanged.\n\nWhile the value of this object is non-zero, it decrements by\none per second until it reaches zero.  At the time that this\nobject decrements to zero, the report is made accessible in\nthe dsmonPdistTopNTable, overwriting any report that may be\nthere.\n\n\n\n\nWhen this object is modified by the management station, any\nassociated entries in the dsmonPdistTopNTable shall be\ndeleted.")
dsmonPdistTopNCtlGeneratedReprts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNCtlGeneratedReprts.setDescription("The number of reports that have been generated by this\nentry.")
dsmonPdistTopNCtlDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNCtlDuration.setDescription("The number of seconds that this report has collected during\nthe last sampling interval.\n\nWhen the associated dsmonPdistTopNCtlTimeRemaining object is\nset, this object shall be set by the probe to the same value\nand shall not be modified until the next time the\ndsmonPdistTopNCtlTimeRemaining is set.\n\nThis value shall be zero if no reports have been requested\nfor this dsmonPdistTopNCtlEntry.")
dsmonPdistTopNCtlRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(150)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistTopNCtlRequestedSize.setDescription("The maximum number of dsmonPdist entries requested for this\nreport.\n\nWhen this object is created or modified, the probe SHOULD\nset dsmonPdistTopNCtlGrantedSize as closely to this object\nas is possible for the particular probe implementation and\navailable resources.")
dsmonPdistTopNCtlGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNCtlGrantedSize.setDescription("The maximum number of dsmonPdist entries in this report.\n\nWhen the associated dsmonPdistTopNCtlRequestedSize object is\ncreated or modified, the probe SHOULD set this object as\nclosely to the requested value as is possible for the\nparticular implementation and available resources.  The\nprobe MUST NOT lower this value except as a result of a\nset to the associated dsmonPdistTopNCtlRequestedSize\nobject.\n\nProtocol entries with the highest value of\ndsmonPdistTopNRate or dsmonPdistTopNHCRate (depending on the\nvalue of the associated dsmonPdistTopNCtlRateBase object)\nshall be placed in this table in decreasing order of this\nrate until there is no more room or until there are no more\ndsmonPdist entries.")
dsmonPdistTopNCtlStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNCtlStartTime.setDescription("The value of sysUpTime when this top N report was last\nstarted.  In other words, this is the time that the\nassociated dsmonPdistTopNCtlTimeRemaining object was\nmodified to start the requested report or the time the\nreport was last automatically (re)started.\n\nThis object may be used by the management station to\ndetermine if a report was missed or not.")
dsmonPdistTopNCtlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 10), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistTopNCtlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonPdistTopNCtlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 3, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonPdistTopNCtlStatus.setDescription("The status of this dsmonPdistTopNCtlEntry.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonPdistTopNTable shall be deleted by the\nagent.")
dsmonPdistTopNTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4))
if mibBuilder.loadTexts: dsmonPdistTopNTable.setDescription("A set of statistics for those protocol distribution entries\nthat have counted the highest number of octets or packets.\n\nIf the dsmonAggControlLocked object is equal to 'false',\nthen all entries in this table SHALL be deleted, and the\nagent will not process TopN reports on behalf of any\ndsmonPdistTopNCtlEntry.\n\nWhen the dsmonAggControlLocked object is set to 'true', then\nparticular reports SHOULD be restarted from the beginning,\non behalf of all active rows in the dsmonPdistTopNCtlTable.\n\nNote that dsmonPdist entries which did not increment at all\nduring the report interval SHOULD NOT be included in\ndsmonPdistTopN reports.")
dsmonPdistTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1)).setIndexNames((0, "DSMON-MIB", "dsmonPdistTopNCtlIndex"), (0, "DSMON-MIB", "dsmonPdistTopNIndex"))
if mibBuilder.loadTexts: dsmonPdistTopNEntry.setDescription("A conceptual row in the dsmonPdistTopNTable.\n\nThe dsmonPdistTopNCtlIndex value in the index identifies the\ndsmonPdistTopNCtlEntry on whose behalf this entry was\ncreated.  Entries in this table are ordered from 1 to 'N',\nwhere lower numbers represent higher values of the rate base\nobject, over the report interval.")
dsmonPdistTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonPdistTopNIndex.setDescription("An index that uniquely identifies an entry in the\ndsmonPdistTopNTable among those in the same report.  This\nindex is between 1 and N, where N is the number of entries\nin this report.  Note that 'N' may change over time, and may\nalso be less than the dsmonPdistTopNCtlGrantedSize value\nassociated with this entry.")
dsmonPdistTopNPDLocalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNPDLocalIndex.setDescription("The protocolDirLocalIndex value which identifies the\nprotocol associated with this entry.\n\nIf the protocolDirEntry associated with the\nprotocolDirLocalIndex with the same value as this object is\nde-activated or deleted, then the agent MUST delete this\ndsmonPdistTopN entry.")
dsmonPdistTopNAggGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1, 3), DsmonCounterAggGroupIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNAggGroup.setDescription("The DSCP counter aggregation group index value associated\nwith protocol identified in this entry.  This object\nidentifies the dsmonAggGroupEntry with the same\ndsmonAggControlIndex value as the associated\ndsmonPdistCtlAggProfile object and the same\ndsmonAggGroupIndex value as this object.")
dsmonPdistTopNRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNRate.setDescription("The amount of change in the selected variable during this\nsampling interval.  The selected variable is this protocol's\ninstance of the object selected by\ndsmonPdistTopNCtlRateBase.\n\nIf the associated dsmonPdistTopNCtlRateBase is equal to\n'dsmonPdistTopNHCPkts' or 'dsmonPdistTopNHCOctets', then\nthis object will contain the the least significant 32 bits\nof the associated dsmonPdistTopNHCRate object.")
dsmonPdistTopNRateOvfl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNRateOvfl.setDescription("The most significant 32 bits of the associated\ndsmonPdistTopNHCRate object.\n\nIf the associated dsmonPdistTopNCtlRateBase is equal to\n'dsmonPdistTopNHCPkts' or 'dsmonPdistTopNHCOctets', then\nthis object will contain the upper 32 bits of the associated\ndsmonPdistTopNHCRate object.\n\nIf the associated dsmonPdistTopNCtlRateBase is equal to\n'dsmonPdistTopNPkts' or 'dsmonPdistTopNOctets', then this\nobject will contain the value zero.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonPdistTopNHCRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 3, 4, 1, 6), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonPdistTopNHCRate.setDescription("The amount of change in the selected variable during this\nsampling interval.  The selected variable is this protocol's\ninstance of the object selected by\ndsmonPdistTopNCtlRateBase.\n\nIf the associated dsmonPdistTopNCtlRateBase is equal to\n'dsmonPdistTopNPkts' or 'dsmonPdistTopNOctets', then this\nobject will contain the value zero, and the associated\ndsmonPdistTopNRate object will contain the change in the\nselected variable during the sampling interval.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonHostObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1, 4))
dsmonHostCtlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1))
if mibBuilder.loadTexts: dsmonHostCtlTable.setDescription("Controls setup of per counter aggregation group, per\nnetwork layer host distribution statistics.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonHostCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1)).setIndexNames((0, "DSMON-MIB", "dsmonHostCtlIndex"))
if mibBuilder.loadTexts: dsmonHostCtlEntry.setDescription("A conceptual row in the dsmonHostCtlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonHostCtlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\nassociated dsmonHostTable to be created and maintained by\nthe agent.")
dsmonHostCtlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonHostCtlIndex.setDescription("An arbitrary and unique index for this dsmonHostCtlEntry.")
dsmonHostCtlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlDataSource.setDescription("The source of data for the associated dsmonHostTable.\n\nNote that only packets that contain a network protocol\nencapsulation which contains a DS field [RFC2474] will be\ncounted in this table.\n\nThis object MUST NOT be modified if the associated\ndsmonHostCtlStatus object is equal to active(1).")
dsmonHostCtlAggProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 3), DsmonCounterAggProfileIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlAggProfile.setDescription("The dsmonAggControlIndex value identifying the counter\naggregation profile which should be used on behalf of this\ndsmonHostCtlEntry.\n\nThe associated dsmonAggControlEntry and\ndsmonAggProfileEntries, identified by the same\ndsmonAggControlIndex index value, MUST be active in order\nfor this entry to remain active.  It is possible for the\ncounter aggregation configuration to change from a valid to\ninvalid state for this dsmonHost collection.  In this case,\nthe associated dsmonHostCtlStatus object will be changed to\nthe 'notReady' state, and data collection will not occur on\nbehalf of this control entry.\n\nNote that an agent MAY choose to limit the actual number of\ncounter aggregation profiles which may be applied to a\nparticular data source.\n\nThis object MUST NOT be modified if the associated\ndsmonHostCtlStatus object is equal to active(1).")
dsmonHostCtlMaxDesiredEntries = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-1,-1),constraint.ValueRangeConstraint(1,2147483647),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlMaxDesiredEntries.setDescription("The maximum number of entries that are desired in the\ndsmonHostTable on behalf of this control entry.  The probe\nwill not create more than this number of associated entries\nin the table, but MAY choose to create fewer entries in this\ntable for any reason including the lack of resources.\n\n\n\nIf this value is set to -1, the probe MAY create any number\nof entries in this table.\n\nThis object MUST NOT be modified if the associated\ndsmonHostCtlStatus object is equal to active(1).")
dsmonHostCtlIPv4PrefixLen = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(8, 32)).clone(32)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlIPv4PrefixLen.setDescription("The number of 'leftmost' contiguous bits in the host\naddress field for encapsulations of IPv4, that should be\nmaintained in this collection.  This object controls how the\ndsmonHostAddress object is derived for packets which contain\nan encapsulation of IPv4.\n\nIf this object has a value less than 32, then 'm' rightmost\nbits, where 'm' is equal to '32 -\ndsmonHostCtlIPv4PrefixLen', will be cleared to zero for\ncounting purposes only.  The 'leftmost' bit is the most\nsignificant bit of the first network-byte-order octet of the\naddress.\n\nIf this object is equal to 32, then no bits are cleared in\neach dsmonHostAddress field.\n\nThis object MUST NOT be modified if the associated\ndsmonHostCtlStatus object is equal to active(1).")
dsmonHostCtlIPv6PrefixLen = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(8, 128)).clone(128)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlIPv6PrefixLen.setDescription("The number of 'leftmost' contiguous bits in the host\naddress field for encapsulations of IPv6, that should be\nmaintained in this collection.  This object controls how the\ndsmonHostAddress object is derived for packets which contain\nan encapsulation of IPv6.\n\nIf this object has a value less than 128, then 'm' rightmost\nbits, where 'm' is equal to '128 -\n\n\n\ndsmonHostCtlIPv6PrefixLen', will be cleared to zero for\ncounting purposes only.  The 'leftmost' bit is the most\nsignificant bit of the first network-byte-order octet of the\naddress.\n\nIf this object is equal to 128, then no bits are cleared in\neach dsmonHostAddress field.\n\nThis object MUST NOT be modified if the associated\ndsmonHostCtlStatus object is equal to active(1).")
dsmonHostCtlDroppedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostCtlDroppedFrames.setDescription("The total number of frames which were received by the probe\nand therefore not accounted for in the *StatsDropEvents, but\nfor which the probe chose not to count for the associated\ndsmonHost entries for whatever reason.  Most often, this\nevent occurs when the probe is out of some resources and\ndecides to shed load from this collection.\n\nThis count does not include packets that were not counted\nbecause they had MAC-layer errors.\n\nNote that if the dsmonHostTable is inactive because no\nappropriate protocols are enabled in the protocol directory,\nthis value SHOULD be 0.\n\nNote that, unlike the dropEvents counter, this number is the\nexact number of frames dropped.")
dsmonHostCtlInserts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostCtlInserts.setDescription("The number of times a dsmonHost entry has been inserted\ninto the dsmonHost table.  If an entry is inserted, then\ndeleted, and then inserted, this counter will be incremented\nby 2.\n\n\n\n\nTo allow for efficient implementation strategies, agents MAY\ndelay updating this object for short periods of time.  For\nexample, an implementation strategy may allow internal data\nstructures to differ from those visible via SNMP for short\nperiods of time.  This counter may reflect the internal data\nstructures for those short periods of time.\n\nNote that the table size can be determined by subtracting\ndsmonHostCtlDeletes from dsmonHostCtlInserts.")
dsmonHostCtlDeletes = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostCtlDeletes.setDescription("The number of times a dsmonHost entry has been deleted from\nthe dsmonHost table (for any reason).  If an entry is\ndeleted, then inserted, and then deleted, this counter will\nbe incremented by 2.\n\nTo allow for efficient implementation strategies, agents MAY\ndelay updating this object for short periods of time.  For\nexample, an implementation strategy may allow internal data\nstructures to differ from those visible via SNMP for short\nperiods of time.  This counter may reflect the internal data\nstructures for those short periods of time.\n\nNote that the table size can be determined by subtracting\ndsmonHostCtlDeletes from dsmonHostCtlInserts.")
dsmonHostCtlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 10), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostCtlCreateTime.setDescription("The value of sysUpTime when this control entry was last\nactivated.  This can be used by the management station to\ndetect if the table has been deleted and recreated between\npolls.")
dsmonHostCtlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 11), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonHostCtlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 1, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostCtlStatus.setDescription("The status of this dsmonHostCtlEntry.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonHostTable shall be deleted.")
dsmonHostTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2))
if mibBuilder.loadTexts: dsmonHostTable.setDescription("A collection of statistics for particular network protocols\nwhich contain a DS field, and that has been discovered on a\nparticular dataSource.\n\nThe probe will add to this table all appropriate network\nprotocols, for each network address seen as the source or\ndestination address in all packets with no MAC errors, and\nwill increment octet and packet counts in the table for all\npackets with no MAC errors.\n\nIf the dsmonAggControlLocked object is equal to 'false',\nthen all entries in this table will be deleted, and the\nagent will not process packets on behalf of any\ndsmonHostCtlEntry.")
dsmonHostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1)).setIndexNames((0, "DSMON-MIB", "dsmonHostCtlIndex"), (0, "DSMON-MIB", "dsmonHostTimeMark"), (0, "DSMON-MIB", "dsmonAggGroupIndex"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "DSMON-MIB", "dsmonHostAddress"))
if mibBuilder.loadTexts: dsmonHostEntry.setDescription("A list of information on Differentiated Services DSCP\nusage, containing packet and octet counters for each counter\naggregation group index configured for collection per host\naddress, as identified in the dsmonAggProfileTable.\n\nThe dsmonHostCtlIndex value in the index identifies the\ndsmonHostCtlEntry on whose behalf this entry was created.\n\nThe protocolDirLocalIndex value in the index identifies the\nspecific network layer protocol encapsulation associated\nwith each entry, and the network protocol type of the\ndsmonHostAddress object.  It MUST identify a\nprotocolDirEntry which contains a DS field (e.g., IPv4 or\nIPv6).  Note that if a protocol encapsulation with multiple\nnetwork layers is specified, then associated entries in this\ntable refer to the innermost network protocol layer host\naddress.\n\nThe dsmonAggGroupIndex value in the index is determined by\nexamining the DSCP value in each monitored packet, and the\ndsmonAggProfileTable entry configured for that value.\n\nAn example of the indexing of this entry is\ndsmonHostOutPkts.1.27273.3.200.4.171.69.120.0")
dsmonHostTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 1), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonHostTimeMark.setDescription("The Time Filter index for this table.  This object may be\nused by a management station to retrieve only rows which\nhave been created or modified since a particular time.  Note\nthat the current value for a row are always returned and the\nTimeFilter is not a historical data archiving mechanism.\nRefer to RFC 2021 [RFC2021] for a detailed description of\nTimeFilter operation.")
dsmonHostAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 110))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonHostAddress.setDescription("The network address for this dsmonHostEntry.\n\nThis object is encoded according to the protocol type\nindicated by the protocolDirLocalIndex value in the index.\n\nIn addition, this object may have some 'rightmost' bits\ncleared to zero for counting purposes, as indicated by the\nassociated dsmonHostCtlIPv4PrefixLen or\ndsmonHostCtlIPv6PrefixLen objects.")
dsmonHostInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostInPkts.setDescription("The number of packets without errors, using one of the DSCP\nvalues in the indicated counter aggregation group, and\ntransmitted to this address, since this entry was added to\nthe dsmonHostTable.  Note that this is the number of link-\nlayer packets, so if a single network-layer packet is\nfragmented into several link-layer frames, this counter is\nincremented several times.")
dsmonHostInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostInOctets.setDescription("The number of octets in all packets, transmitted to this\naddress and using one of the DSCP values in the indicated\ncounter aggregation group, since this entry was added to the\ndsmonHostTable (excluding framing bits but including FCS\noctets), excluding those octets in packets that contained\nerrors.\n\nNote this doesn't count just those octets in the particular\nprotocol frames, but includes the entire packet that\ncontained the protocol.")
dsmonHostInOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 5), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostInOvflPkts.setDescription("The number of times the associated dsmonHostInPkts counter\nhas overflowed.  Note that this object will only be\ninstantiated if the associated dsmonHostInHCPkts object is\nalso instantiated for a particular dataSource.")
dsmonHostInOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 6), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostInOvflOctets.setDescription("The number of times the associated dsmonHostInOctets\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonHostInHCOctets object is\nalso instantiated for a particular dataSource.")
dsmonHostInHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 7), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostInHCPkts.setDescription("The 64-bit version of the dsmonHostInPkts object.\n\nNote that this object will only be instantiated if the RMON\n\n\n\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonHostInHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 8), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostInHCOctets.setDescription("The 64-bit version of the dsmonHostInOctets object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonHostOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 9), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostOutPkts.setDescription("The number of packets without errors, using one of the DSCP\nvalues in the indicated counter aggregation group, and\ntransmitted by this address, since this entry was added to\nthe dsmonHostTable.  Note that this is the number of link-\nlayer packets, so if a single network-layer packet is\nfragmented into several link-layer frames, this counter is\nincremented several times.")
dsmonHostOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 10), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostOutOctets.setDescription("The number of octets, transmitted by this address and using\none of the DSCP values in the identified counter aggregation\ngroup, since this entry was added to the dsmonHostTable\n(excluding framing bits but including FCS octets), excluding\nthose octets in packets that contained errors.\n\nNote this doesn't count just those octets in the particular\nprotocol frames, but includes the entire packet that\ncontained the protocol.")
dsmonHostOutOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 11), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostOutOvflPkts.setDescription("The number of times the associated dsmonHostOutPkts counter\nhas overflowed.  Note that this object will only be\ninstantiated if the associated dsmonHostOutHCPkts object is\nalso instantiated for a particular dataSource.")
dsmonHostOutOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 12), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostOutOvflOctets.setDescription("The number of times the associated dsmonHostOutOctets\ncounter has overflowed.  Note that this object will only be\ninstantiated if the associated dsmonHostOutHCOctets object\nis also instantiated for a particular dataSource.")
dsmonHostOutHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 13), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostOutHCPkts.setDescription("The 64-bit version of the dsmonHostOutPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonHostOutHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 14), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostOutHCOctets.setDescription("The 64-bit version of the dsmonHostOutOctets object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonHostCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 2, 1, 15), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostCreateTime.setDescription("The value of sysUpTime when this dsmonHost entry was last\ninstantiated by the agent.  This can be used by the\nmanagement station to ensure that the entry has not been\ndeleted and recreated between polls.")
dsmonHostTopNCtlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3))
if mibBuilder.loadTexts: dsmonHostTopNCtlTable.setDescription("A set of parameters that control the creation of a report\nof the top N dsmonHost entries according to a selected\nmetric.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonHostTopNCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1)).setIndexNames((0, "DSMON-MIB", "dsmonHostTopNCtlIndex"))
if mibBuilder.loadTexts: dsmonHostTopNCtlEntry.setDescription("A conceptual row in the dsmonHostTopNCtlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonHostTopNCtlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\n\n\n\nassociated dsmonHostTopNTable to be created and maintained\nby the agent.")
dsmonHostTopNCtlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonHostTopNCtlIndex.setDescription("An index that uniquely identifies an entry in the\ndsmonHostTopNCtlTable.  Each such entry defines one Top N\nreport prepared for one RMON dataSource.")
dsmonHostTopNCtlHostIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostTopNCtlHostIndex.setDescription("The dsmonHostTable for which a top N report will be\nprepared on behalf of this entry.  The dsmonHostTable is\nidentified by the value of the dsmonHostCtlIndex for that\ntable - that value is used here to identify the particular\ntable.\n\nThis object MUST NOT be modified if the associated\ndsmonHostTopNCtlStatus object is equal to active(1).")
dsmonHostTopNCtlRateBase = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,9,6,3,7,8,12,1,11,2,4,10,)).subtype(namedValues=namedval.NamedValues(("dsmonHostTopNInPkts", 1), ("dsmonHostTopNOutHCOctets", 10), ("dsmonHostTopNTotalHCPkts", 11), ("dsmonHostTopNTotalHCOctets", 12), ("dsmonHostTopNInOctets", 2), ("dsmonHostTopNOutPkts", 3), ("dsmonHostTopNOutOctets", 4), ("dsmonHostTopNTotalPkts", 5), ("dsmonHostTopNTotalOctets", 6), ("dsmonHostTopNInHCPkts", 7), ("dsmonHostTopNInHCOctets", 8), ("dsmonHostTopNOutHCPkts", 9), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostTopNCtlRateBase.setDescription("The variable(s) for each dsmonHost that the\ndsmonHostTopNRate and dsmonHostTopNHCRate variables are\nbased upon.  Each dsmonHostTopN report generated on behalf\nof this control entry will be ranked in descending order,\nbased on the associated dsmonHostTable counter(s),\nidentified by this object.\n\nThe following table identifies the dsmonHostTable counters\nassociated with each enumeration:\n\nEnumeration              RateBase MIB Objects\n-----------              --------------------\ndsmonHostTopNInPkts         dsmonHostInPkts\ndsmonHostTopNInOctets       dsmonHostInOctets\ndsmonHostTopNOutPkts        dsmonHostOutPkts\ndsmonHostTopNOutOctets      dsmonHostOutOctets\ndsmonHostTopNTotalPkts      dsmonHostInPkts +\n                              dsmonHostOutPkts\ndsmonHostTopNTotalOctets    dsmonHostInOctets +\n                              dsmonHostOutOctets\ndsmonHostTopNInHCPkts       dsmonHostInHCPkts\ndsmonHostTopNInHCOctets     dsmonHostInHCOctets\ndsmonHostTopNOutHCPkts      dsmonHostOutHCPkts\ndsmonHostTopNOutHCOctets    dsmonHostOutHCPkts\ndsmonHostTopNTotalHCPkts    dsmonHostInHCPkts +\n                              dsmonHostOutHCPkts\ndsmonHostTopNTotalHCOctets  dsmonHostInHCOctets +\n                              dsmonHostOutHCOctets\n\nThe following enumerations are only available if the agent\nsupports High Capacity monitoring:\n\ndsmonHostTopNInHCPkts\ndsmonHostTopNInHCOctets\n\n\n\ndsmonHostTopNOutHCPkts\ndsmonHostTopNOutHCOctets\ndsmonHostTopNTotalHCPkts\ndsmonHostTopNTotalHCOctets\n\nIt is an implementation-specific matter whether an agent can\ndetect an overflow condition resulting from the addition of\ntwo counter delta values for the following enumerations:\n\ndsmonHostTopNTotalPkts\ndsmonHostTopNTotalOctets\ndsmonHostTopNTotalHCPkts\ndsmonHostTopNTotalHCOctets\n\nIn the event such an overflow condition can be detected by\nthe agent, the associated dsmonHostTopNRate,\ndsmonHostTopNRateOvfl, and/or dsmonHostTopNHCRate objects\nshould be set to their maximum value.\n\nThis object MUST NOT be modified if the associated\ndsmonHostTopNCtlStatus object is equal to active(1).")
dsmonHostTopNCtlTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(1800)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostTopNCtlTimeRemaining.setDescription("The number of seconds left in the report currently being\ncollected.  When this object is modified by the management\nstation, a new collection is started, possibly aborting a\ncurrently running report.  The new value is used as the\nrequested duration of this report, and is immediately loaded\ninto the associated dsmonHostTopNCtlDuration object.\n\nWhen the report finishes, the probe will automatically start\nanother collection with the same initial value of\ndsmonHostTopNCtlTimeRemaining.  Thus the management station\nmay simply read the resulting reports repeatedly, checking\nthe startTime and duration each time to ensure that a report\nwas not missed or that the report parameters were not\nchanged.\n\nWhile the value of this object is non-zero, it decrements by\none per second until it reaches zero.  At the time that this\nobject decrements to zero, the report is made accessible in\nthe dsmonHostTopNTable, overwriting any report that may be\n\n\n\nthere.\n\nWhen this object is modified by the management station, any\nassociated entries in the dsmonHostTopNTable shall be\ndeleted.")
dsmonHostTopNCtlGeneratedReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNCtlGeneratedReports.setDescription("The number of reports that have been generated by this\nentry.")
dsmonHostTopNCtlDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNCtlDuration.setDescription("The number of seconds that this report has collected during\nthe last sampling interval.\n\nWhen the associated dsmonHostTopNCtlTimeRemaining object is\nset, this object shall be set by the probe to the same value\nand shall not be modified until the next time the\ndsmonHostTopNCtlTimeRemaining is set.\n\nThis value shall be zero if no reports have been requested\nfor this dsmonHostTopNCtlEntry.")
dsmonHostTopNCtlRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(150)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostTopNCtlRequestedSize.setDescription("The maximum number of dsmonHost entries requested for this\nreport.\n\nWhen this object is created or modified, the probe SHOULD\nset dsmonHostTopNCtlGrantedSize as closely to this object as\nis possible for the particular probe implementation and\n\n\n\navailable resources.")
dsmonHostTopNCtlGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNCtlGrantedSize.setDescription("The maximum number of dsmonHost entries in this report.\n\nWhen the associated dsmonHostTopNCtlRequestedSize object is\ncreated or modified, the probe SHOULD set this object as\nclosely to the requested value as is possible for the\nparticular implementation and available resources.  The\nprobe MUST NOT lower this value except as a result of a\nset to the associated dsmonHostTopNCtlRequestedSize\nobject.\n\nProtocol entries with the highest value of dsmonHostTopNRate\nor dsmonHostTopNHCRate (depending on the value of the\nassociated dsmonHostTopNCtlRateBase object) shall be placed\nin this table in decreasing order of this rate until there\nis no more room or until there are no more dsmonHost\nentries.")
dsmonHostTopNCtlStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNCtlStartTime.setDescription("The value of sysUpTime when this top N report was last\nstarted.  In other words, this is the time that the\nassociated dsmonHostTopNCtlTimeRemaining object was modified\nto start the requested report or the time the report was\nlast automatically (re)started.\n\nThis object may be used by the management station to\ndetermine if a report was missed or not.")
dsmonHostTopNCtlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 10), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostTopNCtlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonHostTopNCtlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 3, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonHostTopNCtlStatus.setDescription("The status of this dsmonHostTopNCtlEntry.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonHostTopNTable shall be deleted by the\nagent.")
dsmonHostTopNTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4))
if mibBuilder.loadTexts: dsmonHostTopNTable.setDescription("A set of statistics for those dsmonHost entries that have\ncounted the highest number of octets or packets.\n\nIf the dsmonAggControlLocked object is equal to 'false',\nthen all entries in this table SHALL be deleted, and the\nagent will not process TopN reports on behalf of any\ndsmonHostTopNCtlEntry.\n\nWhen the dsmonAggControlLocked object is set to 'true', then\nparticular reports SHOULD be restarted from the beginning,\non behalf of all active rows in the dsmonHostTopNCtlTable.\n\nNote that dsmonHost entries which did not increment at all\nduring the report interval SHOULD NOT be included in\ndsmonHostTopN reports.")
dsmonHostTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1)).setIndexNames((0, "DSMON-MIB", "dsmonHostTopNCtlIndex"), (0, "DSMON-MIB", "dsmonHostTopNIndex"))
if mibBuilder.loadTexts: dsmonHostTopNEntry.setDescription("A conceptual row in the dsmonHostTopNTable.\n\nThe dsmonHostTopNCtlIndex value in the index identifies the\ndsmonHostTopNCtlEntry on whose behalf this entry was\ncreated.\n\nEntries in this table are ordered from 1 to 'N', where lower\nnumbers represent higher values of the rate base object,\nover the report interval.")
dsmonHostTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonHostTopNIndex.setDescription("An index that uniquely identifies an entry in the\ndsmonHostTopNTable among those in the same report.  This\nindex is between 1 and N, where N is the number of entries\nin this report.")
dsmonHostTopNPDLocalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNPDLocalIndex.setDescription("The protocolDirLocalIndex value which identifies the\nprotocol associated with the dsmonHostTopNAddress object in\nthis entry.\n\nIf the protocolDirEntry associated with the\nprotocolDirLocalIndex with the same value as this object is\nde-activated or deleted, then the agent MUST delete this\ndsmonHostTopN entry.")
dsmonHostTopNAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNAddress.setDescription("The dsmonHostAddress value for the network host identified\nin this entry.  The associated dsmonHostTopNPDLocalIndex\nobject identifies the network protocol type and the encoding\nrules for this object.")
dsmonHostTopNAggGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 4), DsmonCounterAggGroupIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNAggGroup.setDescription("The counter aggregation group index value associated with\nhost identified in this entry.  This object identifies the\ndsmonAggGroupEntry with the same dsmonAggControlIndex value\nas the associated dsmonHostCtlAggProfile object and the same\ndsmonAggGroupIndex value as this object.")
dsmonHostTopNRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNRate.setDescription("The amount of change in the selected variable during this\nsampling interval.  The selected variable is this host's\ninstance of the object selected by dsmonHostTopNCtlRateBase.\n\nIf the associated dsmonHostTopNCtlRateBase indicates a High\nCapacity monitoring enumeration, (e.g.\n'dsmonHostTopNInHCPkts'), then this object will contain the\nthe least significant 32 bits of the associated\ndsmonHostTopNHCRate object.")
dsmonHostTopNRateOvfl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNRateOvfl.setDescription("The most significant 32 bits of the associated\ndsmonHostTopNHCRate object.\n\n\n\nIf the associated dsmonHostTopNCtlRateBase is equal to any\nof the High Capacity monitoring enumerations (e.g.\n'dsmonHostTopNInHCPkts'), then this object will contain the\nupper 32 bits of the associated dsmonHostTopNHCRate object.\n\nIf the associated dsmonHostTopNCtlRateBase is not equal to\nany of High Capacity monitoring enumerations, then this\nobject will contain the value zero.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonHostTopNHCRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 4, 4, 1, 7), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonHostTopNHCRate.setDescription("The amount of change in the selected variable during this\nsampling interval.  The selected variable is this host's\ninstance of the object selected by dsmonHostTopNCtlRateBase.\n\nIf the associated dsmonHostTopNCtlRateBase is not equal to\nany of the High Capacity monitoring enumerations (e.g.,\n'dsmonHostTopNInPkts'), then this object will contain the\nvalue zero, and the associated dsmonHostTopNRate object will\ncontain the change in the selected variable during the\nsampling interval.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonCapsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1, 5))
dsmonCapabilities = MibScalar((1, 3, 6, 1, 2, 1, 16, 26, 1, 5, 1), Bits().subtype(namedValues=namedval.NamedValues(("dsmonCounterAggControl", 0), ("dsmonStats", 1), ("dsmonCaps", 10), ("dsmonMatrix", 11), ("dsmonMatrixOvfl", 12), ("dsmonMatrixHC", 13), ("dsmonStatsOvfl", 2), ("dsmonStatsHC", 3), ("dsmonPdist", 4), ("dsmonPdistOvfl", 5), ("dsmonPdistHC", 6), ("dsmonHost", 7), ("dsmonHostOvfl", 8), ("dsmonHostHC", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonCapabilities.setDescription("This object provides an indication of the DSMON groups\nsupported by the agent.  If a bit is set, then the agent\nimplements all of the objects in the DSMON object group,\nwhere bit 'n' represents the MIB group identified by the\nOBJECT IDENTIFIER value { dsmonGroups n+1 }.")
dsmonMatrixObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 1, 6))
dsmonMatrixCtlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1))
if mibBuilder.loadTexts: dsmonMatrixCtlTable.setDescription("Controls setup of per counter aggregation group, per host-\npair, application protocol distribution statistics.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonMatrixCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1)).setIndexNames((0, "DSMON-MIB", "dsmonMatrixCtlIndex"))
if mibBuilder.loadTexts: dsmonMatrixCtlEntry.setDescription("A conceptual row in the dsmonMatrixCtlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonMatrixCtlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\nassociated dsmonMatrixSDTable and dsmonMatrixDSTable to be\ncreated and maintained by the agent.")
dsmonMatrixCtlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixCtlIndex.setDescription("An arbitrary and unique index for this\ndsmonMatrixCtlEntry.")
dsmonMatrixCtlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 2), DataSource()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixCtlDataSource.setDescription("The source of data for the associated dsmonMatrixSDTable\nand dsmonMatrixDSTable.\n\nNote that only packets that contain a network protocol\nencapsulation which contains a DS field [RFC2474] will be\ncounted in this table.\n\nThis object MUST NOT be modified if the associated\ndsmonMatrixCtlStatus object is equal to active(1).")
dsmonMatrixCtlAggProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 3), DsmonCounterAggProfileIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixCtlAggProfile.setDescription("The dsmonAggControlIndex value identifying the counter\naggregation profile which should be used on behalf of this\ndsmonMatrixCtlEntry.\n\nThe associated dsmonAggControlEntry and\ndsmonAggProfileEntries, identified by the same\ndsmonAggControlIndex index value, MUST be active in order\nfor this entry to remain active.  It is possible for the\ncounter aggregation configuration to change from a valid to\ninvalid state for this dsmonMatrix collection.  In this\ncase, the associated dsmonMatrixCtlStatus object will be\nchanged to the 'notReady' state, and data collection will\nnot occur on behalf of this control entry.\n\nNote that an agent MAY choose to limit the actual number of\ncounter aggregation profiles which may be applied to a\nparticular data source.\n\nThis object MUST NOT be modified if the associated\ndsmonMatrixCtlStatus object is equal to active(1).")
dsmonMatrixCtlMaxDesiredEntries = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-1,-1),constraint.ValueRangeConstraint(1,2147483647),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixCtlMaxDesiredEntries.setDescription("The maximum number of entries that are desired in the\ndsmonMatrix tables on behalf of this control entry.  The\nprobe will not create more than this number of associated\nentries in these tables, but may choose to create fewer\nentries in this table for any reason including the lack of\nresources.\n\nIf this value is set to -1, the probe may create any number\nof entries in this table.\n\nThis object MUST NOT be modified if the associated\ndsmonMatrixCtlStatus object is equal to active(1).")
dsmonMatrixCtlDroppedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixCtlDroppedFrames.setDescription("The total number of frames which were received by the probe\nand therefore not accounted for in the *StatsDropEvents, but\nfor which the probe chose not to count for the associated\ndsmonMatrixSD and dsmonMatrixDS entries for whatever reason.\nMost often, this event occurs when the probe is out of some\nresources and decides to shed load from this collection.\n\nThis count does not include packets that were not counted\nbecause they had MAC-layer errors.\n\nNote that if the dsmonMatrix tables are inactive because no\nappropriate protocols are enabled in the protocol directory,\nthis value SHOULD be 0.\n\nNote that, unlike the dropEvents counter, this number is the\nexact number of frames dropped.")
dsmonMatrixCtlInserts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixCtlInserts.setDescription("The number of times a dsmonMatrix entry has been inserted\ninto the dsmonMatrix tables.  If an entry is inserted, then\ndeleted, and then inserted, this counter will be incremented\nby 2.  The addition of a conversation into both the\ndsmonMatrixSDTable and dsmonMatrixDSTable shall be counted\nas two insertions (even though every addition into one table\nmust be accompanied by an insertion into the other).\n\nTo allow for efficient implementation strategies, agents may\ndelay updating this object for short periods of time.  For\nexample, an implementation strategy may allow internal data\nstructures to differ from those visible via SNMP for short\nperiods of time.  This counter may reflect the internal data\nstructures for those short periods of time.  Note that the\nsum of the dsmonMatrixSDTable and dsmonMatrixDSTable sizes\ncan be determined by subtracting dsmonMatrixCtlDeletes from\ndsmonMatrixCtlInserts.")
dsmonMatrixCtlDeletes = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixCtlDeletes.setDescription("The number of times a dsmonMatrix entry has been deleted\nfrom the dsmonMatrix tables (for any reason).  If an entry\nis deleted, then inserted, and then deleted, this counter\nwill be incremented by 2.  The deletion of a conversation\nfrom both the dsmonMatrixSDTable and dsmonMatrixDSTable\nshall be counted as two deletions (even though every\ndeletion from one table must be accompanied by a deletion\nfrom the other).\n\nTo allow for efficient implementation strategies, agents MAY\ndelay updating this object for short periods of time.  For\nexample, an implementation strategy may allow internal data\nstructures to differ from those visible via SNMP for short\nperiods of time.  This counter may reflect the internal data\nstructures for those short periods of time.\n\nNote that the sum of the dsmonMatrixSDTable and\ndsmonMatrixDSTable sizes can be determined by subtracting\ndsmonMatrixCtlDeletes from dsmonMatrixCtlInserts.")
dsmonMatrixCtlCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 8), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixCtlCreateTime.setDescription("The value of sysUpTime when this control entry was last\nactivated.  This can be used by the management station to\ndetect if the table has been deleted and recreated between\npolls.")
dsmonMatrixCtlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 9), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixCtlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonMatrixCtlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 1, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixCtlStatus.setDescription("The status of this dsmonMatrixCtlEntry.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonMatrixSDTable and dsmonMatrixDSTable\nshall be deleted.")
dsmonMatrixSDTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2))
if mibBuilder.loadTexts: dsmonMatrixSDTable.setDescription("A list of application traffic matrix entries which collect\nstatistics for conversations of a particular application\nprotocol between two network-level addresses.  This table is\nindexed first by the source address and then by the\n\n\n\ndestination address to make it convenient to collect all\nstatistics from a particular address.\n\nThe probe will add to this table all pairs of addresses for\nall protocols seen in all packets with no MAC errors, and\nwill increment octet and packet counts in the table for all\npackets with no MAC errors.")
dsmonMatrixSDEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1)).setIndexNames((0, "DSMON-MIB", "dsmonMatrixCtlIndex"), (0, "DSMON-MIB", "dsmonMatrixTimeMark"), (0, "DSMON-MIB", "dsmonAggGroupIndex"), (0, "DSMON-MIB", "dsmonMatrixNLIndex"), (0, "DSMON-MIB", "dsmonMatrixSourceAddress"), (0, "DSMON-MIB", "dsmonMatrixDestAddress"), (0, "DSMON-MIB", "dsmonMatrixALIndex"))
if mibBuilder.loadTexts: dsmonMatrixSDEntry.setDescription("A conceptual row in the dsmonMatrixSDTable.\n\nThe dsmonMatrixCtlIndex value in the index identifies the\ndsmonMatrixCtlEntry on whose behalf this entry was created.\n\nThe dsmonAggGroupIndex value in the index is determined by\nexamining the DSCP value in each monitored packet, and the\ndsmonAggProfileTable entry configured for that value.")
dsmonMatrixTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 1), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixTimeMark.setDescription("The Time Filter index for this table.  This object may be\nused by a management station to retrieve only rows which\nhave been created or modified since a particular time.  Note\nthat the current value for a row are always returned and the\nTimeFilter is not a historical data archiving mechanism.\nRefer to RFC 2021 [RFC2021] for a detailed description of\nTimeFilter operation.")
dsmonMatrixNLIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixNLIndex.setDescription("The protocolDirLocalIndex value of a protocolDirEntry\nrepresenting the specific network layer protocol\nencapsulation associated with each entry, and the network\nprotocol type of the dsmonMatrixSourceAddress and\ndsmonMatrixDestAddress objects.")
dsmonMatrixSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 54))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixSourceAddress.setDescription("The network source address for this dsmonMatrix entry.\n\nThis is represented as an octet string with specific\nsemantics and length as identified by the dsmonMatrixNLIndex\ncomponent of the index.\n\nFor example, if the dsmonMatrixNLIndex indicates an\nencapsulation of IPv4, this object is encoded as a length\noctet of 4, followed by the 4 octets of the IPv4 address, in\nnetwork byte order.")
dsmonMatrixDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 54))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixDestAddress.setDescription("The network destination address for this dsmonMatrix entry.\n\n\n\nThis is represented as an octet string with specific\nsemantics and length as identified by the dsmonMatrixNLIndex\ncomponent of the index.\n\nFor example, if the dsmonMatrixNLIndex indicates an\nencapsulation of IPv4, this object is encoded as a length\noctet of 4, followed by the 4 octets of the IPv4 address, in\nnetwork byte order.")
dsmonMatrixALIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixALIndex.setDescription("The protocolDirLocalIndex value of the protocolDirEntry\nrepresenting the specific application layer protocol\nassociated with each entry.\n\nIt MUST identify an protocolDirEntry which is a direct or\nindirect descendant of the protocolDirEntry identified by\nthe associated dsmonMatrixNLIndex object.")
dsmonMatrixSDPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 6), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDPkts.setDescription("The number of packets of this protocol type (indicated by\nthe associated dsmonMatrixALIndex object) without errors\ntransmitted from the source address to the destination\naddress since this entry was added to the\ndsmonMatrixSDTable.  Note that this is the number of link-\nlayer packets, so if a single network-layer packet is\nfragmented into several link-layer frames, this counter is\nincremented several times.")
dsmonMatrixSDOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 7), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDOvflPkts.setDescription("The number of times the associated dsmonMatrixSDPkts\ncounter has overflowed, since this entry was added to the\ndsmonMatrixSDTable.")
dsmonMatrixSDHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 8), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDHCPkts.setDescription("The 64-bit version of the dsmonMatrixSDPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonMatrixSDOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 9), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDOctets.setDescription("The number of octets in packets of this protocol type\ntransmitted from the source address to the destination\naddress since this entry was added to the dsmonMatrixSDTable\n(excluding framing bits but including FCS octets), excluding\nthose octets in packets that contained errors.\n\nNote this doesn't count just those octets in the particular\nprotocol frames, but includes the entire packet that\ncontained the protocol.")
dsmonMatrixSDOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 10), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDOvflOctets.setDescription("The number of times the associated dsmonMatrixSDOctets\ncounter has overflowed, since this entry was added to the\ndsmonMatrixSDTable.")
dsmonMatrixSDHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 11), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDHCOctets.setDescription("The 64-bit version of the dsmonMatrixSDPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonMatrixSDCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 2, 1, 12), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixSDCreateTime.setDescription("The value of sysUpTime when this entry was last activated.\nThis can be used by the management station to ensure that\nthe entry has not been deleted and recreated between polls.")
dsmonMatrixDSTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3))
if mibBuilder.loadTexts: dsmonMatrixDSTable.setDescription("A list of application traffic matrix entries which collect\nstatistics for conversations of a particular application\nprotocol between two network-level addresses.  This table is\nindexed first by the destination address and then by the\nsource address to make it convenient to collect all\nstatistics from a particular address.\n\nThe probe will add to this table all pairs of addresses for\nall protocols seen in all packets with no MAC errors, and\nwill increment octet and packet counts in the table for all\npackets with no MAC errors.")
dsmonMatrixDSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1)).setIndexNames((0, "DSMON-MIB", "dsmonMatrixCtlIndex"), (0, "DSMON-MIB", "dsmonMatrixTimeMark"), (0, "DSMON-MIB", "dsmonAggGroupIndex"), (0, "DSMON-MIB", "dsmonMatrixNLIndex"), (0, "DSMON-MIB", "dsmonMatrixDestAddress"), (0, "DSMON-MIB", "dsmonMatrixSourceAddress"), (0, "DSMON-MIB", "dsmonMatrixALIndex"))
if mibBuilder.loadTexts: dsmonMatrixDSEntry.setDescription("A conceptual row in the dsmonMatrixDSTable.  Note that this\ntable is conceptually a re-ordered version of the\ndsmonMatrixSDTable.  Therefore, all of the index values from\n\n\n\nthat table are used by reference, and their semantics are\nexactly as described in the dsmonMatrixSDTable.\n\nThe dsmonMatrixCtlIndex value in the index identifies the\ndsmonMatrixCtlEntry on whose behalf this entry was created.\n\nThe dsmonMatrixTimeMark value in the index identifies the\nTime Filter index for this table.\n\nThe dsmonAggGroupIndex value in the index is determined by\nexamining the DSCP value in each monitored packet, and the\ndsmonAggProfileTable entry configured for that value.\n\nThe dsmonMatrixNLIndex value in the index identifies the\nprotocolDirLocalIndex value of a protocolDirEntry\nrepresenting the specific network layer protocol\nencapsulation associated with each entry, and the network\nprotocol type of the dsmonMatrixSourceAddress and\ndsmonMatrixDestAddress objects.\n\nThe dsmonMatrixDestAddress value in the index identifies the\nnetwork destination address for this dsmonMatrix entry.\n\nThe dsmonMatrixSourceAddress value in the index identifies\nthe network source address for this dsmonMatrix entry.\n\nThe dsmonMatrixALIndex value in the index identifies the\nprotocolDirLocalIndex value of the protocolDirEntry\nrepresenting the specific application layer protocol\nassociated with each entry.")
dsmonMatrixDSPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 1), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSPkts.setDescription("The number of packets of this protocol type (indicated by\nthe associated dsmonMatrixALIndex object) without errors\ntransmitted from the source address to the destination\naddress since this entry was added to the\ndsmonMatrixDSTable.  Note that this is the number of link-\nlayer packets, so if a single network-layer packet is\nfragmented into several link-layer frames, this counter is\nincremented several times.")
dsmonMatrixDSOvflPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSOvflPkts.setDescription("The number of times the associated dsmonMatrixDSPkts\ncounter has overflowed, since this entry was added to the\ndsmonMatrixDSTable.")
dsmonMatrixDSHCPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 3), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSHCPkts.setDescription("The 64-bit version of the dsmonMatrixDSPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonMatrixDSOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSOctets.setDescription("The number of octets in packets of this protocol type\n\n\n\ntransmitted from the source address to the destination\naddress since this entry was added to the dsmonMatrixDSTable\n(excluding framing bits but including FCS octets), excluding\nthose octets in packets that contained errors.\n\nNote this doesn't count just those octets in the particular\nprotocol frames, but includes the entire packet that\ncontained the protocol.")
dsmonMatrixDSOvflOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 5), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSOvflOctets.setDescription("The number of times the associated dsmonMatrixDSOctets\ncounter has overflowed, since this entry was added to the\ndsmonMatrixDSTable.")
dsmonMatrixDSHCOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 6), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSHCOctets.setDescription("The 64-bit version of the dsmonMatrixDSPkts object.\n\nNote that this object will only be instantiated if the RMON\nagent supports High Capacity monitoring for a particular\ndataSource.")
dsmonMatrixDSCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 3, 1, 7), LastCreateTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixDSCreateTime.setDescription("The value of sysUpTime when this entry was last activated.\nThis can be used by the management station to ensure that\nthe entry has not been deleted and recreated between polls.")
dsmonMatrixTopNCtlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4))
if mibBuilder.loadTexts: dsmonMatrixTopNCtlTable.setDescription("A set of parameters that control the creation of a report\nof the top N dsmonMatrix entries according to a selected\nmetric.\n\nNote that an agent MAY choose to limit the actual number of\nentries which may be created in this table.  In this case,\nthe agent SHOULD return an error-status of\n'resourceUnavailable(13)', as per section 4.2.5 of the\n'Protocol Operations for SNMPv2' specification [RFC1905].")
dsmonMatrixTopNCtlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1)).setIndexNames((0, "DSMON-MIB", "dsmonMatrixTopNCtlIndex"))
if mibBuilder.loadTexts: dsmonMatrixTopNCtlEntry.setDescription("A conceptual row in the dsmonMatrixTopNCtlTable.\n\nEntries are created and deleted from this table by\nmanagement action only, using the dsmonMatrixTopNCtlStatus\nRowStatus object.\n\nThe agent SHOULD support non-volatile configuration of this\ntable, and upon system initialization, the table SHOULD be\ninitialized with the saved values.\n\nActivation of a control row in this table will cause an\nassociated dsmonMatrixTopNTable to be created and maintained\nby the agent.")
dsmonMatrixTopNCtlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlIndex.setDescription("An index that uniquely identifies an entry in the\ndsmonMatrixTopNCtlTable.  Each such entry defines one Top N\nreport prepared for one RMON dataSource.")
dsmonMatrixTopNCtlMatrixIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlMatrixIndex.setDescription("The dsmonMatrixSDTable for which a top N report will be\nprepared on behalf of this entry.  The dsmonMatrixSDTable is\nidentified by the same value of the dsmonMatrixCtlIndex\nobject.\n\nThis object MUST NOT be modified if the associated\ndsmonMatrixTopNCtlStatus object is equal to active(1).")
dsmonMatrixTopNCtlRateBase = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,4,)).subtype(namedValues=namedval.NamedValues(("dsmonMatrixTopNPkts", 1), ("dsmonMatrixTopNOctets", 2), ("dsmonMatrixTopNHCPkts", 3), ("dsmonMatrixTopNHCOctets", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlRateBase.setDescription("The variable for each dsmonMatrixSD entry that the\ndsmonMatrixTopNRate and dsmonMatrixTopNHCRate variables are\nbased upon.  Each dsmonMatrixTopN report generated on behalf\nof this control entry will be ranked in descending order,\nbased on the associated dsmonMatrixSDTable counter,\nidentified by this object.\n\nThe following table identifies the dsmonMatrixSDTable\ncounters associated with each enumeration:\n\nEnumeration                 RateBase MIB Objects\n\n\n\n-----------                 --------------------\ndsmonMatrixTopNPkts         dsmonMatrixSDPkts\ndsmonMatrixTopNOctets       dsmonMatrixSDOctets\ndsmonMatrixTopNHCPkts       dsmonMatrixSDHCPkts\ndsmonMatrixTopNHCOctets     dsmonMatrixSDHCOctets\n\nThe following enumerations are only available if the agent\nsupports High Capacity monitoring:\n\ndsmonMatrixTopNHCPkts\ndsmonMatrixTopNHCOctets\n\nThis object MUST NOT be modified if the associated\ndsmonMatrixTopNCtlStatus object is equal to active(1).")
dsmonMatrixTopNCtlTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(1800)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlTimeRemaining.setDescription("The number of seconds left in the report currently being\ncollected.  When this object is modified by the management\nstation, a new collection is started, possibly aborting a\ncurrently running report.  The new value is used as the\nrequested duration of this report, and is immediately loaded\ninto the associated dsmonMatrixTopNCtlDuration object.\n\nWhen the report finishes, the probe will automatically start\nanother collection with the same initial value of\ndsmonMatrixTopNCtlTimeRemaining.  Thus the management\nstation may simply read the resulting reports repeatedly,\nchecking the startTime and duration each time to ensure that\na report was not missed or that the report parameters were\nnot changed.\n\nWhile the value of this object is non-zero, it decrements by\none per second until it reaches zero.  At the time that this\nobject decrements to zero, the report is made accessible in\nthe dsmonMatrixTopNTable, overwriting any report that may be\nthere.\n\nWhen this object is modified by the management station, any\nassociated entries in the dsmonMatrixTopNTable shall be\ndeleted.")
dsmonMatrixTopNCtlGeneratedRpts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlGeneratedRpts.setDescription("The number of reports that have been generated by this\nentry.")
dsmonMatrixTopNCtlDuration = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlDuration.setDescription("The number of seconds that this report has collected during\nthe last sampling interval.\n\nWhen the associated dsmonMatrixTopNCtlTimeRemaining object\nis set, this object shall be set by the probe to the same\nvalue and shall not be modified until the next time the\ndsmonMatrixTopNCtlTimeRemaining is set.\n\nThis value shall be zero if no reports have been requested\nfor this dsmonMatrixTopNCtlEntry.")
dsmonMatrixTopNCtlRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(150)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlRequestedSize.setDescription("The maximum number of dsmonMatrix entries requested for\nthis report.\n\nWhen this object is created or modified, the probe SHOULD\nset dsmonMatrixTopNCtlGrantedSize as closely to this object\nas is possible for the particular probe implementation and\navailable resources.")
dsmonMatrixTopNCtlGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlGrantedSize.setDescription("The maximum number of dsmonMatrix entries in this report.\n\nWhen the associated dsmonMatrixTopNCtlRequestedSize object\nis created or modified, the probe SHOULD set this object as\nclosely to the requested value as is possible for the\nparticular implementation and available resources.  The\nprobe MUST NOT lower this value except as a result of a\nset to the associated dsmonMatrixTopNCtlRequestedSize\nobject.\n\nProtocol entries with the highest value of\ndsmonMatrixTopNRate or dsmonMatrixTopNHCRate (depending on\nthe value of the associated dsmonMatrixTopNCtlRateBase\nobject) shall be placed in this table in decreasing order of\nthis rate until there is no more room or until there are no\nmore dsmonMatrix entries.")
dsmonMatrixTopNCtlStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlStartTime.setDescription("The value of sysUpTime when this top N report was last\nstarted.  In other words, this is the time that the\nassociated dsmonMatrixTopNCtlTimeRemaining object was\nmodified to start the requested report or the time the\nreport was last automatically (re)started.\n\nThis object may be used by the management station to\ndetermine if a report was missed or not.")
dsmonMatrixTopNCtlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 10), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlOwner.setDescription("The entity that configured this entry and is therefore\nusing the resources assigned to it.")
dsmonMatrixTopNCtlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 4, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dsmonMatrixTopNCtlStatus.setDescription("The status of this dsmonMatrixTopNCtlEntry.\n\nAn entry MUST NOT exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nIf this object is not equal to active(1), all associated\nentries in the dsmonMatrixTopNTable shall be deleted by the\nagent.")
dsmonMatrixTopNTable = MibTable((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5))
if mibBuilder.loadTexts: dsmonMatrixTopNTable.setDescription("A set of statistics for those dsmonMatrix entries that have\ncounted the highest number of octets or packets.\n\nIf the dsmonAggControlLocked object is equal to 'false',\nthen all entries in this table SHALL be deleted, and the\nagent will not process TopN reports on behalf of any\ndsmonMatrixTopNCtlEntry.\n\nWhen the dsmonAggControlLocked object is set to 'true', then\nparticular reports SHOULD be restarted from the beginning,\non behalf of all active rows in the dsmonMatrixTopNCtlTable.\n\nNote that dsmonMatrix entries which did not increment at all\nduring the report interval SHOULD NOT be included in\ndsmonMatrixTopN reports.")
dsmonMatrixTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1)).setIndexNames((0, "DSMON-MIB", "dsmonMatrixTopNCtlIndex"), (0, "DSMON-MIB", "dsmonMatrixTopNIndex"))
if mibBuilder.loadTexts: dsmonMatrixTopNEntry.setDescription("A conceptual row in the dsmonMatrixTopNTable.\n\nThe dsmonMatrixTopNCtlIndex value in the index identifies\nthe dsmonMatrixTopNCtlEntry on whose behalf this entry was\ncreated.\n\n\n\n\nEntries in this table are ordered from 1 to 'N', where lower\nnumbers represent higher values of the rate base object,\nover the report interval.")
dsmonMatrixTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dsmonMatrixTopNIndex.setDescription("An index that uniquely identifies an entry in the\ndsmonMatrixTopNTable among those in the same report.  This\nindex is between 1 and N, where N is the number of entries\nin this report.")
dsmonMatrixTopNAggGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 2), DsmonCounterAggGroupIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNAggGroup.setDescription("The counter aggregation group index value associated with\nhost identified in this entry.  This object identifies the\ndsmonAggGroupEntry with the same dsmonAggControlIndex value\nas the associated dsmonMatrixCtlAggProfile object and the\nsame dsmonAggGroupIndex value as this object.")
dsmonMatrixTopNNLIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNNLIndex.setDescription("The protocolDirLocalIndex value which identifies the\nprotocol associated with the dsmonMatrixTopNSourceAddress\nand dsmonMatrixTopNDestAddress objects in this entry.\n\nIf the protocolDirEntry associated with the\nprotocolDirLocalIndex with the same value as this object is\nde-activated or deleted, then the agent MUST delete this\ndsmonMatrixTopN entry.")
dsmonMatrixTopNSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 4), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNSourceAddress.setDescription("The dsmonMatrixSDSourceAddress value for the source network\nhost identified in this entry.  The associated\ndsmonMatrixTopNNLIndex object identifies the network\nprotocol type and the encoding rules for this object.")
dsmonMatrixTopNDestAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 5), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNDestAddress.setDescription("The dsmonMatrixSDDestAddress value for the destination\nnetwork host identified in this entry.  The associated\ndsmonMatrixTopNNLIndex object identifies the network\nprotocol type and the encoding rules for this object.")
dsmonMatrixTopNALIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNALIndex.setDescription("The protocolDirLocalIndex value which identifies the\napplication protocol associated with this entry.\n\nIf the protocolDirEntry associated with the\n\n\n\nprotocolDirLocalIndex with the same value as this object is\nde-activated or deleted, then the agent MUST delete this\ndsmonMatrixTopN entry.")
dsmonMatrixTopNPktRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNPktRate.setDescription("The number of packets seen of this protocol from the source\nhost to the destination host during this sampling interval,\ncounted using the rules for counting the dsmonMatrixSDPkts\nobject.\n\nIf the value of dsmonMatrixTopNCtlRateBase is\ndsmonMatrixTopNPkts, this variable will be used to sort this\nreport.\n\nIf the value of the dsmonMatrixTopNCtlRateBase is\ndsmonMatrixTopNHCPkts or dsmonMatrixTopNHCOctets, then this\nobject will contain the the least significant 32 bits of the\nassociated dsmonMatrixTopNHCPktRate object.")
dsmonMatrixTopNPktRateOvfl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNPktRateOvfl.setDescription("The most significant 32 bits of the associated\ndsmonMatrixTopNHCPktRate object.\n\nIf the associated dsmonMatrixTopNCtlRateBase is equal to\ndsmonMatrixTopNHCPkts or dsmonMatrixTopNHCOctets, then this\nobject will contain the most significant 32 bits of the\nassociated dsmonMatrixTopNHCPktRate object, otherwise this\nobject will contain the value zero.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNHCPktRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 9), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNHCPktRate.setDescription("The number of packets seen of this protocol from the source\nhost to the destination host during this sampling interval,\ncounted using the rules for counting the dsmonMatrixSDHCPkts\nobject.\n\nIf the value of dsmonMatrixTopNCtlRateBase is\ndsmonMatrixTopNHCPkts, this variable will be used to sort\nthis report.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNRevPktRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNRevPktRate.setDescription("The number of packets seen of this protocol from the\ndestination host to the source host during this sampling\ninterval, counted using the rules for counting the\ndsmonMatrixDSPkts object  (note that the corresponding\ndsmonMatrixSDPkts object selected is the one whose source\naddress is equal to dsmonMatrixTopNDestAddress and whose\ndestination address is equal to\ndsmonMatrixTopNSourceAddress.)")
dsmonMatrixTopNRevPktRateOvfl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNRevPktRateOvfl.setDescription("The most significant 32 bits of the associated\ndsmonMatrixTopNHCRevPktRate object.\n\nIf the associated dsmonMatrixTopNCtlRateBase is equal to\ndsmonMatrixTopNHCPkts or dsmonMatrixTopNHCOCtets, then this\nobject will contain the most significant 32 bits of the\nassociated dsmonMatrixTopNHCRevPktRate object, otherwise\nthis object will contain the value zero.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNHCRevPktRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 12), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNHCRevPktRate.setDescription("The number of packets seen of this protocol from the\ndestination host to the source host during this sampling\ninterval, counted using the rules for counting the\ndsmonMatrixDSHCPkts object  (note that the corresponding\ndsmonMatrixSDHCPkts object selected is the one whose source\naddress is equal to dsmonMatrixTopNDestAddress and whose\ndestination address is equal to\ndsmonMatrixTopNSourceAddress.)\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNOctetRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNOctetRate.setDescription("The number of octets seen of this protocol from the source\nhost to the destination host during this sampling interval,\ncounted using the rules for counting the dsmonMatrixSDOctets\nobject.\n\nIf the value of dsmonMatrixTopNCtlRateBase is\ndsmonMatrixTopNOctets, this variable will be used to sort\nthis report.\n\nIf the value of the dsmonMatrixTopNCtlRateBase is\ndsmonMatrixTopNHCPkts or dsmonMatrixTopNHCOctets, then this\nobject will contain the the least significant 32 bits of the\nassociated dsmonMatrixTopNHCPktRate object.")
dsmonMatrixTopNOctetRateOvfl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNOctetRateOvfl.setDescription("The most significant 32 bits of the associated\ndsmonMatrixTopNHCOctetRate object.\n\nIf the associated dsmonMatrixTopNCtlRateBase is equal to\ndsmonMatrixTopNHCPkts or dsmonMatrixTopNHCOctets, then this\nobject will contain the most significant 32 bits of the\nassociated dsmonMatrixTopNHCOctetRate object, otherwise this\n\n\n\nobject will contain the value zero.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNHCOctetRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 15), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNHCOctetRate.setDescription("The number of octets seen of this protocol from the source\nhost to the destination host during this sampling interval,\ncounted using the rules for counting the\ndsmonMatrixSDHCOctets object.\n\nIf the value of dsmonMatrixTopNCtlRateBase is\ndsmonMatrixTopNHCOctets, this variable will be used to sort\nthis report.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNRevOctetRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNRevOctetRate.setDescription("The number of octets seen of this protocol from the\ndestination host to the source host during this sampling\ninterval, counted using the rules for counting the\ndsmonMatrixDSOctets object  (note that the corresponding\ndsmonMatrixSDOctets object selected is the one whose source\naddress is equal to dsmonMatrixTopNDestAddress and whose\ndestination address is equal to\ndsmonMatrixTopNSourceAddress.)")
dsmonMatrixTopNRevOctetRateOvfl = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 17), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNRevOctetRateOvfl.setDescription("The most significant 32 bits of the associated\ndsmonMatrixTopNHCRevOctetRate object.\n\nIf the associated dsmonMatrixTopNCtlRateBase is equal to\n\n\n\ndsmonMatrixTopNHCPkts or dsmonMatrixTopNHCOCtets, then this\nobject will contain the most significant 32 bits of the\nassociated dsmonMatrixTopNHCRevPktRate object, otherwise\nthis object will contain the value zero.\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonMatrixTopNHCRevOctetRate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 26, 1, 6, 5, 1, 18), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dsmonMatrixTopNHCRevOctetRate.setDescription("The number of octets seen of this protocol from the\ndestination host to the source host during this sampling\ninterval, counted using the rules for counting the\ndsmonMatrixDSHCOctets object  (note that the corresponding\ndsmonMatrixSDHCOctets object selected is the one whose\nsource address is equal to dsmonMatrixTopNDestAddress and\nwhose destination address is equal to\ndsmonMatrixTopNSourceAddress.)\n\nThe agent MAY choose not to instantiate this object if High\nCapacity monitoring is not supported.")
dsmonNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 2))
dsmonConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 3))
dsmonCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 3, 1))
dsmonGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 26, 3, 2))

# Augmentions

# Groups

dsmonCounterAggControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 1)).setObjects(("DSMON-MIB", "dsmonAggControlChanges"), ("DSMON-MIB", "dsmonAggGroupIndex"), ("DSMON-MIB", "dsmonAggControlOwner"), ("DSMON-MIB", "dsmonAggControlDescr"), ("DSMON-MIB", "dsmonAggGroupStatus"), ("DSMON-MIB", "dsmonAggControlLocked"), ("DSMON-MIB", "dsmonAggControlLastChangeTime"), ("DSMON-MIB", "dsmonAggGroupDescr"), ("DSMON-MIB", "dsmonAggControlStatus"), ("DSMON-MIB", "dsmonMaxAggGroups"), )
if mibBuilder.loadTexts: dsmonCounterAggControlGroup.setDescription("A collection of objects used to configure and manage\ncounter aggregation groups for DSMON collection purposes.")
dsmonStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 2)).setObjects(("DSMON-MIB", "dsmonStatsOutPkts"), ("DSMON-MIB", "dsmonStatsControlOwner"), ("DSMON-MIB", "dsmonStatsControlDroppedFrames"), ("DSMON-MIB", "dsmonStatsControlAggProfile"), ("DSMON-MIB", "dsmonStatsControlCreateTime"), ("DSMON-MIB", "dsmonStatsInPkts"), ("DSMON-MIB", "dsmonStatsControlStatus"), ("DSMON-MIB", "dsmonStatsControlDataSource"), ("DSMON-MIB", "dsmonStatsOutOctets"), ("DSMON-MIB", "dsmonStatsInOctets"), )
if mibBuilder.loadTexts: dsmonStatsGroup.setDescription("A collection of objects providing per DSCP statistics.")
dsmonStatsOvflGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 3)).setObjects(("DSMON-MIB", "dsmonStatsInOvflPkts"), ("DSMON-MIB", "dsmonStatsOutOvflOctets"), ("DSMON-MIB", "dsmonStatsOutOvflPkts"), ("DSMON-MIB", "dsmonStatsInOvflOctets"), )
if mibBuilder.loadTexts: dsmonStatsOvflGroup.setDescription("A collection of objects providing per-DSCP overflow\ncounters for systems with high capacity data sources, but\nwithout support for the Counter64 data type.")
dsmonStatsHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 4)).setObjects(("DSMON-MIB", "dsmonStatsInHCPkts"), ("DSMON-MIB", "dsmonStatsOutHCPkts"), ("DSMON-MIB", "dsmonStatsOutHCOctets"), ("DSMON-MIB", "dsmonStatsInHCOctets"), )
if mibBuilder.loadTexts: dsmonStatsHCGroup.setDescription("A collection of objects providing per DSCP statistics for\nhigh capacity data sources.")
dsmonPdistGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 5)).setObjects(("DSMON-MIB", "dsmonPdistTopNCtlRequestedSize"), ("DSMON-MIB", "dsmonPdistStatsOctets"), ("DSMON-MIB", "dsmonPdistStatsCreateTime"), ("DSMON-MIB", "dsmonPdistCtlInserts"), ("DSMON-MIB", "dsmonPdistTopNCtlStartTime"), ("DSMON-MIB", "dsmonPdistTopNRate"), ("DSMON-MIB", "dsmonPdistCtlMaxDesiredEntries"), ("DSMON-MIB", "dsmonPdistCtlCreateTime"), ("DSMON-MIB", "dsmonPdistTopNCtlPdistIndex"), ("DSMON-MIB", "dsmonPdistTopNCtlTimeRemaining"), ("DSMON-MIB", "dsmonPdistStatsPkts"), ("DSMON-MIB", "dsmonPdistCtlOwner"), ("DSMON-MIB", "dsmonPdistTopNCtlOwner"), ("DSMON-MIB", "dsmonPdistTopNCtlDuration"), ("DSMON-MIB", "dsmonPdistTopNCtlRateBase"), ("DSMON-MIB", "dsmonPdistCtlDeletes"), ("DSMON-MIB", "dsmonPdistCtlStatus"), ("DSMON-MIB", "dsmonPdistCtlDataSource"), ("DSMON-MIB", "dsmonPdistCtlAggProfile"), ("DSMON-MIB", "dsmonPdistTopNCtlStatus"), ("DSMON-MIB", "dsmonPdistTopNCtlGeneratedReprts"), ("DSMON-MIB", "dsmonPdistCtlDroppedFrames"), ("DSMON-MIB", "dsmonPdistTopNPDLocalIndex"), ("DSMON-MIB", "dsmonPdistTopNAggGroup"), ("DSMON-MIB", "dsmonPdistTopNCtlGrantedSize"), )
if mibBuilder.loadTexts: dsmonPdistGroup.setDescription("A collection of objects providing per protocol DSCP\nmonitoring extensions to the RMON-2 MIB.")
dsmonPdistOvflGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 6)).setObjects(("DSMON-MIB", "dsmonPdistTopNRateOvfl"), ("DSMON-MIB", "dsmonPdistStatsOvflOctets"), ("DSMON-MIB", "dsmonPdistStatsOvflPkts"), )
if mibBuilder.loadTexts: dsmonPdistOvflGroup.setDescription("A collection of objects providing per-protocol DSCP\noverflow counters for systems with high capacity data\nsources, but without support for the Counter64 data type.")
dsmonPdistHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 7)).setObjects(("DSMON-MIB", "dsmonPdistStatsHCPkts"), ("DSMON-MIB", "dsmonPdistTopNHCRate"), ("DSMON-MIB", "dsmonPdistStatsHCOctets"), )
if mibBuilder.loadTexts: dsmonPdistHCGroup.setDescription("A collection of objects providing per protocol DSCP\nmonitoring extensions to the RMON-2 MIB for High Capacity\nnetworks.")
dsmonHostGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 8)).setObjects(("DSMON-MIB", "dsmonHostCtlAggProfile"), ("DSMON-MIB", "dsmonHostOutOctets"), ("DSMON-MIB", "dsmonHostInPkts"), ("DSMON-MIB", "dsmonHostCtlStatus"), ("DSMON-MIB", "dsmonHostCtlInserts"), ("DSMON-MIB", "dsmonHostOutPkts"), ("DSMON-MIB", "dsmonHostTopNCtlTimeRemaining"), ("DSMON-MIB", "dsmonHostTopNAggGroup"), ("DSMON-MIB", "dsmonHostCtlDataSource"), ("DSMON-MIB", "dsmonHostCtlMaxDesiredEntries"), ("DSMON-MIB", "dsmonHostCreateTime"), ("DSMON-MIB", "dsmonHostTopNCtlStartTime"), ("DSMON-MIB", "dsmonHostTopNCtlRateBase"), ("DSMON-MIB", "dsmonHostTopNCtlRequestedSize"), ("DSMON-MIB", "dsmonHostTopNAddress"), ("DSMON-MIB", "dsmonHostTopNCtlStatus"), ("DSMON-MIB", "dsmonHostTopNCtlDuration"), ("DSMON-MIB", "dsmonHostTopNCtlOwner"), ("DSMON-MIB", "dsmonHostTopNCtlGeneratedReports"), ("DSMON-MIB", "dsmonHostTopNPDLocalIndex"), ("DSMON-MIB", "dsmonHostInOctets"), ("DSMON-MIB", "dsmonHostTopNCtlGrantedSize"), ("DSMON-MIB", "dsmonHostCtlIPv6PrefixLen"), ("DSMON-MIB", "dsmonHostCtlDroppedFrames"), ("DSMON-MIB", "dsmonHostTopNCtlHostIndex"), ("DSMON-MIB", "dsmonHostTopNRate"), ("DSMON-MIB", "dsmonHostCtlIPv4PrefixLen"), ("DSMON-MIB", "dsmonHostCtlCreateTime"), ("DSMON-MIB", "dsmonHostCtlDeletes"), ("DSMON-MIB", "dsmonHostCtlOwner"), )
if mibBuilder.loadTexts: dsmonHostGroup.setDescription("A collection of objects providing per Host monitoring\n\n\n\nfunctions.")
dsmonHostOvflGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 9)).setObjects(("DSMON-MIB", "dsmonHostOutOvflOctets"), ("DSMON-MIB", "dsmonHostTopNRateOvfl"), ("DSMON-MIB", "dsmonHostInOvflOctets"), ("DSMON-MIB", "dsmonHostOutOvflPkts"), ("DSMON-MIB", "dsmonHostInOvflPkts"), )
if mibBuilder.loadTexts: dsmonHostOvflGroup.setDescription("A collection of objects providing per host DSCP overflow\ncounters for systems with high capacity data sources, but\nwithout support for the Counter64 data type.")
dsmonHostHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 10)).setObjects(("DSMON-MIB", "dsmonHostOutHCOctets"), ("DSMON-MIB", "dsmonHostOutHCPkts"), ("DSMON-MIB", "dsmonHostInHCOctets"), ("DSMON-MIB", "dsmonHostTopNHCRate"), ("DSMON-MIB", "dsmonHostInHCPkts"), )
if mibBuilder.loadTexts: dsmonHostHCGroup.setDescription("A collection of objects providing per Host monitoring\nfunctions for High Capacity networks.")
dsmonCapsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 11)).setObjects(("DSMON-MIB", "dsmonCapabilities"), )
if mibBuilder.loadTexts: dsmonCapsGroup.setDescription("A collection of objects providing an indication of the\nDSMON monitoring functions supported by the agent.")
dsmonMatrixGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 12)).setObjects(("DSMON-MIB", "dsmonMatrixCtlDeletes"), ("DSMON-MIB", "dsmonMatrixCtlCreateTime"), ("DSMON-MIB", "dsmonMatrixTopNCtlStatus"), ("DSMON-MIB", "dsmonMatrixTopNCtlRateBase"), ("DSMON-MIB", "dsmonMatrixTopNALIndex"), ("DSMON-MIB", "dsmonMatrixDSPkts"), ("DSMON-MIB", "dsmonMatrixTopNCtlDuration"), ("DSMON-MIB", "dsmonMatrixTopNCtlGrantedSize"), ("DSMON-MIB", "dsmonMatrixTopNAggGroup"), ("DSMON-MIB", "dsmonMatrixDSOctets"), ("DSMON-MIB", "dsmonMatrixTopNRevPktRate"), ("DSMON-MIB", "dsmonMatrixTopNCtlStartTime"), ("DSMON-MIB", "dsmonMatrixTopNRevOctetRate"), ("DSMON-MIB", "dsmonMatrixCtlDataSource"), ("DSMON-MIB", "dsmonMatrixSDOctets"), ("DSMON-MIB", "dsmonMatrixCtlAggProfile"), ("DSMON-MIB", "dsmonMatrixCtlDroppedFrames"), ("DSMON-MIB", "dsmonMatrixCtlStatus"), ("DSMON-MIB", "dsmonMatrixTopNPktRate"), ("DSMON-MIB", "dsmonMatrixTopNNLIndex"), ("DSMON-MIB", "dsmonMatrixTopNCtlRequestedSize"), ("DSMON-MIB", "dsmonMatrixTopNDestAddress"), ("DSMON-MIB", "dsmonMatrixCtlInserts"), ("DSMON-MIB", "dsmonMatrixCtlOwner"), ("DSMON-MIB", "dsmonMatrixTopNCtlGeneratedRpts"), ("DSMON-MIB", "dsmonMatrixTopNOctetRate"), ("DSMON-MIB", "dsmonMatrixTopNCtlTimeRemaining"), ("DSMON-MIB", "dsmonMatrixTopNCtlOwner"), ("DSMON-MIB", "dsmonMatrixSDPkts"), ("DSMON-MIB", "dsmonMatrixTopNSourceAddress"), ("DSMON-MIB", "dsmonMatrixDSCreateTime"), ("DSMON-MIB", "dsmonMatrixTopNCtlMatrixIndex"), ("DSMON-MIB", "dsmonMatrixSDCreateTime"), ("DSMON-MIB", "dsmonMatrixCtlMaxDesiredEntries"), )
if mibBuilder.loadTexts: dsmonMatrixGroup.setDescription("A collection of objects providing per conversation\nmonitoring functions.")
dsmonMatrixOvflGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 13)).setObjects(("DSMON-MIB", "dsmonMatrixSDOvflPkts"), ("DSMON-MIB", "dsmonMatrixTopNPktRateOvfl"), ("DSMON-MIB", "dsmonMatrixDSOvflOctets"), ("DSMON-MIB", "dsmonMatrixSDOvflOctets"), ("DSMON-MIB", "dsmonMatrixTopNOctetRateOvfl"), ("DSMON-MIB", "dsmonMatrixDSOvflPkts"), ("DSMON-MIB", "dsmonMatrixTopNRevPktRateOvfl"), ("DSMON-MIB", "dsmonMatrixTopNRevOctetRateOvfl"), )
if mibBuilder.loadTexts: dsmonMatrixOvflGroup.setDescription("A collection of objects providing per conversation\nmonitoring functions for systems with high capacity data\nsources, but without support for the Counter64 data type.")
dsmonMatrixHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 26, 3, 2, 14)).setObjects(("DSMON-MIB", "dsmonMatrixSDHCPkts"), ("DSMON-MIB", "dsmonMatrixTopNHCOctetRate"), ("DSMON-MIB", "dsmonMatrixDSHCPkts"), ("DSMON-MIB", "dsmonMatrixTopNHCRevOctetRate"), ("DSMON-MIB", "dsmonMatrixSDHCOctets"), ("DSMON-MIB", "dsmonMatrixDSHCOctets"), ("DSMON-MIB", "dsmonMatrixTopNHCPktRate"), ("DSMON-MIB", "dsmonMatrixTopNHCRevPktRate"), )
if mibBuilder.loadTexts: dsmonMatrixHCGroup.setDescription("A collection of objects providing per conversation\nmonitoring functions for High Capacity networks.")

# Compliances

dsmonCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 26, 3, 1, 1)).setObjects(("DSMON-MIB", "dsmonHostGroup"), ("DSMON-MIB", "dsmonStatsHCGroup"), ("DSMON-MIB", "dsmonHostHCGroup"), ("DSMON-MIB", "dsmonStatsGroup"), ("DSMON-MIB", "dsmonCounterAggControlGroup"), ("DSMON-MIB", "dsmonMatrixGroup"), ("DSMON-MIB", "dsmonPdistGroup"), ("DSMON-MIB", "dsmonPdistHCGroup"), ("DSMON-MIB", "dsmonCapsGroup"), ("DSMON-MIB", "dsmonMatrixHCGroup"), )
if mibBuilder.loadTexts: dsmonCompliance.setDescription("Describes the requirements for conformance to the\nDifferentiated Services Monitoring MIB.")
dsmonHCCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 26, 3, 1, 2)).setObjects(("DSMON-MIB", "dsmonHostGroup"), ("DSMON-MIB", "dsmonStatsHCGroup"), ("DSMON-MIB", "dsmonHostHCGroup"), ("DSMON-MIB", "dsmonStatsGroup"), ("DSMON-MIB", "dsmonCounterAggControlGroup"), ("DSMON-MIB", "dsmonMatrixGroup"), ("DSMON-MIB", "dsmonPdistGroup"), ("DSMON-MIB", "dsmonPdistHCGroup"), ("DSMON-MIB", "dsmonCapsGroup"), ("DSMON-MIB", "dsmonMatrixHCGroup"), )
if mibBuilder.loadTexts: dsmonHCCompliance.setDescription("Describes the requirements for conformance to the\nDifferentiated Services Monitoring MIB for agents which also\nsupport High Capacity monitoring and the Counter64 data\ntype.")
dsmonHCNoC64Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 26, 3, 1, 3)).setObjects(("DSMON-MIB", "dsmonHostGroup"), ("DSMON-MIB", "dsmonPdistGroup"), ("DSMON-MIB", "dsmonMatrixHCGroup"), ("DSMON-MIB", "dsmonStatsOvflGroup"), ("DSMON-MIB", "dsmonStatsHCGroup"), ("DSMON-MIB", "dsmonCounterAggControlGroup"), ("DSMON-MIB", "dsmonHostOvflGroup"), ("DSMON-MIB", "dsmonMatrixGroup"), ("DSMON-MIB", "dsmonHostHCGroup"), ("DSMON-MIB", "dsmonStatsGroup"), ("DSMON-MIB", "dsmonPdistHCGroup"), ("DSMON-MIB", "dsmonMatrixOvflGroup"), ("DSMON-MIB", "dsmonPdistOvflGroup"), ("DSMON-MIB", "dsmonCapsGroup"), )
if mibBuilder.loadTexts: dsmonHCNoC64Compliance.setDescription("Describes the requirements for conformance to the\nDifferentiated Services Monitoring MIB for an agent which\nsupports high capacity monitoring, but does not support the\nCounter64 data type (e.g., only supports the SNMPv1\nprotocol).")

# Exports

# Module identity
mibBuilder.exportSymbols("DSMON-MIB", PYSNMP_MODULE_ID=dsmonMIB)

# Types
mibBuilder.exportSymbols("DSMON-MIB", DsmonCounterAggGroupIndex=DsmonCounterAggGroupIndex, DsmonCounterAggProfileIndex=DsmonCounterAggProfileIndex)

# Objects
mibBuilder.exportSymbols("DSMON-MIB", dsmonMIB=dsmonMIB, dsmonObjects=dsmonObjects, dsmonAggObjects=dsmonAggObjects, dsmonMaxAggGroups=dsmonMaxAggGroups, dsmonAggControlLocked=dsmonAggControlLocked, dsmonAggControlChanges=dsmonAggControlChanges, dsmonAggControlLastChangeTime=dsmonAggControlLastChangeTime, dsmonAggControlTable=dsmonAggControlTable, dsmonAggControlEntry=dsmonAggControlEntry, dsmonAggControlIndex=dsmonAggControlIndex, dsmonAggControlDescr=dsmonAggControlDescr, dsmonAggControlOwner=dsmonAggControlOwner, dsmonAggControlStatus=dsmonAggControlStatus, dsmonAggProfileTable=dsmonAggProfileTable, dsmonAggProfileEntry=dsmonAggProfileEntry, dsmonAggProfileDSCP=dsmonAggProfileDSCP, dsmonAggGroupIndex=dsmonAggGroupIndex, dsmonAggGroupTable=dsmonAggGroupTable, dsmonAggGroupEntry=dsmonAggGroupEntry, dsmonAggGroupDescr=dsmonAggGroupDescr, dsmonAggGroupStatus=dsmonAggGroupStatus, dsmonStatsObjects=dsmonStatsObjects, dsmonStatsControlTable=dsmonStatsControlTable, dsmonStatsControlEntry=dsmonStatsControlEntry, dsmonStatsControlIndex=dsmonStatsControlIndex, dsmonStatsControlDataSource=dsmonStatsControlDataSource, dsmonStatsControlAggProfile=dsmonStatsControlAggProfile, dsmonStatsControlDroppedFrames=dsmonStatsControlDroppedFrames, dsmonStatsControlCreateTime=dsmonStatsControlCreateTime, dsmonStatsControlOwner=dsmonStatsControlOwner, dsmonStatsControlStatus=dsmonStatsControlStatus, dsmonStatsTable=dsmonStatsTable, dsmonStatsEntry=dsmonStatsEntry, dsmonStatsInPkts=dsmonStatsInPkts, dsmonStatsInOctets=dsmonStatsInOctets, dsmonStatsInOvflPkts=dsmonStatsInOvflPkts, dsmonStatsInOvflOctets=dsmonStatsInOvflOctets, dsmonStatsInHCPkts=dsmonStatsInHCPkts, dsmonStatsInHCOctets=dsmonStatsInHCOctets, dsmonStatsOutPkts=dsmonStatsOutPkts, dsmonStatsOutOctets=dsmonStatsOutOctets, dsmonStatsOutOvflPkts=dsmonStatsOutOvflPkts, dsmonStatsOutOvflOctets=dsmonStatsOutOvflOctets, dsmonStatsOutHCPkts=dsmonStatsOutHCPkts, dsmonStatsOutHCOctets=dsmonStatsOutHCOctets, dsmonPdistObjects=dsmonPdistObjects, dsmonPdistCtlTable=dsmonPdistCtlTable, dsmonPdistCtlEntry=dsmonPdistCtlEntry, dsmonPdistCtlIndex=dsmonPdistCtlIndex, dsmonPdistCtlDataSource=dsmonPdistCtlDataSource, dsmonPdistCtlAggProfile=dsmonPdistCtlAggProfile, dsmonPdistCtlMaxDesiredEntries=dsmonPdistCtlMaxDesiredEntries, dsmonPdistCtlDroppedFrames=dsmonPdistCtlDroppedFrames, dsmonPdistCtlInserts=dsmonPdistCtlInserts, dsmonPdistCtlDeletes=dsmonPdistCtlDeletes, dsmonPdistCtlCreateTime=dsmonPdistCtlCreateTime, dsmonPdistCtlOwner=dsmonPdistCtlOwner, dsmonPdistCtlStatus=dsmonPdistCtlStatus, dsmonPdistStatsTable=dsmonPdistStatsTable, dsmonPdistStatsEntry=dsmonPdistStatsEntry, dsmonPdistTimeMark=dsmonPdistTimeMark, dsmonPdistStatsPkts=dsmonPdistStatsPkts, dsmonPdistStatsOctets=dsmonPdistStatsOctets, dsmonPdistStatsOvflPkts=dsmonPdistStatsOvflPkts, dsmonPdistStatsOvflOctets=dsmonPdistStatsOvflOctets, dsmonPdistStatsHCPkts=dsmonPdistStatsHCPkts, dsmonPdistStatsHCOctets=dsmonPdistStatsHCOctets, dsmonPdistStatsCreateTime=dsmonPdistStatsCreateTime, dsmonPdistTopNCtlTable=dsmonPdistTopNCtlTable, dsmonPdistTopNCtlEntry=dsmonPdistTopNCtlEntry, dsmonPdistTopNCtlIndex=dsmonPdistTopNCtlIndex, dsmonPdistTopNCtlPdistIndex=dsmonPdistTopNCtlPdistIndex, dsmonPdistTopNCtlRateBase=dsmonPdistTopNCtlRateBase, dsmonPdistTopNCtlTimeRemaining=dsmonPdistTopNCtlTimeRemaining, dsmonPdistTopNCtlGeneratedReprts=dsmonPdistTopNCtlGeneratedReprts, dsmonPdistTopNCtlDuration=dsmonPdistTopNCtlDuration, dsmonPdistTopNCtlRequestedSize=dsmonPdistTopNCtlRequestedSize, dsmonPdistTopNCtlGrantedSize=dsmonPdistTopNCtlGrantedSize, dsmonPdistTopNCtlStartTime=dsmonPdistTopNCtlStartTime, dsmonPdistTopNCtlOwner=dsmonPdistTopNCtlOwner, dsmonPdistTopNCtlStatus=dsmonPdistTopNCtlStatus, dsmonPdistTopNTable=dsmonPdistTopNTable, dsmonPdistTopNEntry=dsmonPdistTopNEntry, dsmonPdistTopNIndex=dsmonPdistTopNIndex, dsmonPdistTopNPDLocalIndex=dsmonPdistTopNPDLocalIndex, dsmonPdistTopNAggGroup=dsmonPdistTopNAggGroup, dsmonPdistTopNRate=dsmonPdistTopNRate, dsmonPdistTopNRateOvfl=dsmonPdistTopNRateOvfl, dsmonPdistTopNHCRate=dsmonPdistTopNHCRate, dsmonHostObjects=dsmonHostObjects, dsmonHostCtlTable=dsmonHostCtlTable, dsmonHostCtlEntry=dsmonHostCtlEntry, dsmonHostCtlIndex=dsmonHostCtlIndex, dsmonHostCtlDataSource=dsmonHostCtlDataSource, dsmonHostCtlAggProfile=dsmonHostCtlAggProfile, dsmonHostCtlMaxDesiredEntries=dsmonHostCtlMaxDesiredEntries, dsmonHostCtlIPv4PrefixLen=dsmonHostCtlIPv4PrefixLen, dsmonHostCtlIPv6PrefixLen=dsmonHostCtlIPv6PrefixLen, dsmonHostCtlDroppedFrames=dsmonHostCtlDroppedFrames, dsmonHostCtlInserts=dsmonHostCtlInserts, dsmonHostCtlDeletes=dsmonHostCtlDeletes, dsmonHostCtlCreateTime=dsmonHostCtlCreateTime, dsmonHostCtlOwner=dsmonHostCtlOwner, dsmonHostCtlStatus=dsmonHostCtlStatus, dsmonHostTable=dsmonHostTable, dsmonHostEntry=dsmonHostEntry, dsmonHostTimeMark=dsmonHostTimeMark, dsmonHostAddress=dsmonHostAddress, dsmonHostInPkts=dsmonHostInPkts, dsmonHostInOctets=dsmonHostInOctets, dsmonHostInOvflPkts=dsmonHostInOvflPkts, dsmonHostInOvflOctets=dsmonHostInOvflOctets, dsmonHostInHCPkts=dsmonHostInHCPkts, dsmonHostInHCOctets=dsmonHostInHCOctets, dsmonHostOutPkts=dsmonHostOutPkts, dsmonHostOutOctets=dsmonHostOutOctets, dsmonHostOutOvflPkts=dsmonHostOutOvflPkts, dsmonHostOutOvflOctets=dsmonHostOutOvflOctets, dsmonHostOutHCPkts=dsmonHostOutHCPkts, dsmonHostOutHCOctets=dsmonHostOutHCOctets, dsmonHostCreateTime=dsmonHostCreateTime, dsmonHostTopNCtlTable=dsmonHostTopNCtlTable, dsmonHostTopNCtlEntry=dsmonHostTopNCtlEntry, dsmonHostTopNCtlIndex=dsmonHostTopNCtlIndex, dsmonHostTopNCtlHostIndex=dsmonHostTopNCtlHostIndex, dsmonHostTopNCtlRateBase=dsmonHostTopNCtlRateBase)
mibBuilder.exportSymbols("DSMON-MIB", dsmonHostTopNCtlTimeRemaining=dsmonHostTopNCtlTimeRemaining, dsmonHostTopNCtlGeneratedReports=dsmonHostTopNCtlGeneratedReports, dsmonHostTopNCtlDuration=dsmonHostTopNCtlDuration, dsmonHostTopNCtlRequestedSize=dsmonHostTopNCtlRequestedSize, dsmonHostTopNCtlGrantedSize=dsmonHostTopNCtlGrantedSize, dsmonHostTopNCtlStartTime=dsmonHostTopNCtlStartTime, dsmonHostTopNCtlOwner=dsmonHostTopNCtlOwner, dsmonHostTopNCtlStatus=dsmonHostTopNCtlStatus, dsmonHostTopNTable=dsmonHostTopNTable, dsmonHostTopNEntry=dsmonHostTopNEntry, dsmonHostTopNIndex=dsmonHostTopNIndex, dsmonHostTopNPDLocalIndex=dsmonHostTopNPDLocalIndex, dsmonHostTopNAddress=dsmonHostTopNAddress, dsmonHostTopNAggGroup=dsmonHostTopNAggGroup, dsmonHostTopNRate=dsmonHostTopNRate, dsmonHostTopNRateOvfl=dsmonHostTopNRateOvfl, dsmonHostTopNHCRate=dsmonHostTopNHCRate, dsmonCapsObjects=dsmonCapsObjects, dsmonCapabilities=dsmonCapabilities, dsmonMatrixObjects=dsmonMatrixObjects, dsmonMatrixCtlTable=dsmonMatrixCtlTable, dsmonMatrixCtlEntry=dsmonMatrixCtlEntry, dsmonMatrixCtlIndex=dsmonMatrixCtlIndex, dsmonMatrixCtlDataSource=dsmonMatrixCtlDataSource, dsmonMatrixCtlAggProfile=dsmonMatrixCtlAggProfile, dsmonMatrixCtlMaxDesiredEntries=dsmonMatrixCtlMaxDesiredEntries, dsmonMatrixCtlDroppedFrames=dsmonMatrixCtlDroppedFrames, dsmonMatrixCtlInserts=dsmonMatrixCtlInserts, dsmonMatrixCtlDeletes=dsmonMatrixCtlDeletes, dsmonMatrixCtlCreateTime=dsmonMatrixCtlCreateTime, dsmonMatrixCtlOwner=dsmonMatrixCtlOwner, dsmonMatrixCtlStatus=dsmonMatrixCtlStatus, dsmonMatrixSDTable=dsmonMatrixSDTable, dsmonMatrixSDEntry=dsmonMatrixSDEntry, dsmonMatrixTimeMark=dsmonMatrixTimeMark, dsmonMatrixNLIndex=dsmonMatrixNLIndex, dsmonMatrixSourceAddress=dsmonMatrixSourceAddress, dsmonMatrixDestAddress=dsmonMatrixDestAddress, dsmonMatrixALIndex=dsmonMatrixALIndex, dsmonMatrixSDPkts=dsmonMatrixSDPkts, dsmonMatrixSDOvflPkts=dsmonMatrixSDOvflPkts, dsmonMatrixSDHCPkts=dsmonMatrixSDHCPkts, dsmonMatrixSDOctets=dsmonMatrixSDOctets, dsmonMatrixSDOvflOctets=dsmonMatrixSDOvflOctets, dsmonMatrixSDHCOctets=dsmonMatrixSDHCOctets, dsmonMatrixSDCreateTime=dsmonMatrixSDCreateTime, dsmonMatrixDSTable=dsmonMatrixDSTable, dsmonMatrixDSEntry=dsmonMatrixDSEntry, dsmonMatrixDSPkts=dsmonMatrixDSPkts, dsmonMatrixDSOvflPkts=dsmonMatrixDSOvflPkts, dsmonMatrixDSHCPkts=dsmonMatrixDSHCPkts, dsmonMatrixDSOctets=dsmonMatrixDSOctets, dsmonMatrixDSOvflOctets=dsmonMatrixDSOvflOctets, dsmonMatrixDSHCOctets=dsmonMatrixDSHCOctets, dsmonMatrixDSCreateTime=dsmonMatrixDSCreateTime, dsmonMatrixTopNCtlTable=dsmonMatrixTopNCtlTable, dsmonMatrixTopNCtlEntry=dsmonMatrixTopNCtlEntry, dsmonMatrixTopNCtlIndex=dsmonMatrixTopNCtlIndex, dsmonMatrixTopNCtlMatrixIndex=dsmonMatrixTopNCtlMatrixIndex, dsmonMatrixTopNCtlRateBase=dsmonMatrixTopNCtlRateBase, dsmonMatrixTopNCtlTimeRemaining=dsmonMatrixTopNCtlTimeRemaining, dsmonMatrixTopNCtlGeneratedRpts=dsmonMatrixTopNCtlGeneratedRpts, dsmonMatrixTopNCtlDuration=dsmonMatrixTopNCtlDuration, dsmonMatrixTopNCtlRequestedSize=dsmonMatrixTopNCtlRequestedSize, dsmonMatrixTopNCtlGrantedSize=dsmonMatrixTopNCtlGrantedSize, dsmonMatrixTopNCtlStartTime=dsmonMatrixTopNCtlStartTime, dsmonMatrixTopNCtlOwner=dsmonMatrixTopNCtlOwner, dsmonMatrixTopNCtlStatus=dsmonMatrixTopNCtlStatus, dsmonMatrixTopNTable=dsmonMatrixTopNTable, dsmonMatrixTopNEntry=dsmonMatrixTopNEntry, dsmonMatrixTopNIndex=dsmonMatrixTopNIndex, dsmonMatrixTopNAggGroup=dsmonMatrixTopNAggGroup, dsmonMatrixTopNNLIndex=dsmonMatrixTopNNLIndex, dsmonMatrixTopNSourceAddress=dsmonMatrixTopNSourceAddress, dsmonMatrixTopNDestAddress=dsmonMatrixTopNDestAddress, dsmonMatrixTopNALIndex=dsmonMatrixTopNALIndex, dsmonMatrixTopNPktRate=dsmonMatrixTopNPktRate, dsmonMatrixTopNPktRateOvfl=dsmonMatrixTopNPktRateOvfl, dsmonMatrixTopNHCPktRate=dsmonMatrixTopNHCPktRate, dsmonMatrixTopNRevPktRate=dsmonMatrixTopNRevPktRate, dsmonMatrixTopNRevPktRateOvfl=dsmonMatrixTopNRevPktRateOvfl, dsmonMatrixTopNHCRevPktRate=dsmonMatrixTopNHCRevPktRate, dsmonMatrixTopNOctetRate=dsmonMatrixTopNOctetRate, dsmonMatrixTopNOctetRateOvfl=dsmonMatrixTopNOctetRateOvfl, dsmonMatrixTopNHCOctetRate=dsmonMatrixTopNHCOctetRate, dsmonMatrixTopNRevOctetRate=dsmonMatrixTopNRevOctetRate, dsmonMatrixTopNRevOctetRateOvfl=dsmonMatrixTopNRevOctetRateOvfl, dsmonMatrixTopNHCRevOctetRate=dsmonMatrixTopNHCRevOctetRate, dsmonNotifications=dsmonNotifications, dsmonConformance=dsmonConformance, dsmonCompliances=dsmonCompliances, dsmonGroups=dsmonGroups)

# Groups
mibBuilder.exportSymbols("DSMON-MIB", dsmonCounterAggControlGroup=dsmonCounterAggControlGroup, dsmonStatsGroup=dsmonStatsGroup, dsmonStatsOvflGroup=dsmonStatsOvflGroup, dsmonStatsHCGroup=dsmonStatsHCGroup, dsmonPdistGroup=dsmonPdistGroup, dsmonPdistOvflGroup=dsmonPdistOvflGroup, dsmonPdistHCGroup=dsmonPdistHCGroup, dsmonHostGroup=dsmonHostGroup, dsmonHostOvflGroup=dsmonHostOvflGroup, dsmonHostHCGroup=dsmonHostHCGroup, dsmonCapsGroup=dsmonCapsGroup, dsmonMatrixGroup=dsmonMatrixGroup, dsmonMatrixOvflGroup=dsmonMatrixOvflGroup, dsmonMatrixHCGroup=dsmonMatrixHCGroup)

# Compliances
mibBuilder.exportSymbols("DSMON-MIB", dsmonCompliance=dsmonCompliance, dsmonHCCompliance=dsmonHCCompliance, dsmonHCNoC64Compliance=dsmonHCNoC64Compliance)
