# PySNMP SMI module. Autogenerated from smidump -f python FCIP-MGMT-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:27 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( FcNameIdOrZero, ) = mibBuilder.importSymbols("FC-MGMT-MIB", "FcNameIdOrZero")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class FcipDomainIdInOctetForm(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,1)
    fixedLength = 1
    
class FcipEntityId(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(8,8)
    fixedLength = 8
    
class FcipEntityMode(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,)
    namedValues = namedval.NamedValues(("ePortMode", 1), ("bPortMode", 2), )
    

# Objects

fcipMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 224)).setRevisions(("2006-02-06 00:00",))
if mibBuilder.loadTexts: fcipMIB.setOrganization("IETF IPFC Working Group")
if mibBuilder.loadTexts: fcipMIB.setContactInfo("Anil Rijhsinghani\nAccton Technology Corporation\n5 Mount Royal Ave\nMarlboro, MA 01752 USA.\n\n\n\nRavi Natarajan\nF5 Networks\n2460 North First Street, Suite 100\nSan Jose, CA 95131 USA.")
if mibBuilder.loadTexts: fcipMIB.setDescription("The module defines management information specific to\nFCIP devices.\n\nCopyright(C) The Internet Society (2006).  This version\nof this MIB module is part of RFC 4404; see the RFC\nitself for full legal notices.")
fcipObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 224, 1))
fcipConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 224, 1, 1))
fcipDynIpConfType = MibScalar((1, 3, 6, 1, 2, 1, 224, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("slpv2", 1), ("none", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcipDynIpConfType.setDescription("The type of discovery protocol used to discover remote\nFCIP entities.  The value of this object is persistent\nacross system restarts.")
fcipDeviceWWN = MibScalar((1, 3, 6, 1, 2, 1, 224, 1, 1, 2), FcNameIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipDeviceWWN.setDescription("The World Wide Name of this FCIP device.")
fcipEntitySACKOption = MibScalar((1, 3, 6, 1, 2, 1, 224, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipEntitySACKOption.setDescription("Indication of whether the TCP Selective Acknowledgement\nOption is enabled at this FCIP device to let the receiver\nacknowledge multiple lost packets in a single ACK for faster\n\n\n\nrecovery.")
fcipEntityInstanceTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 4))
if mibBuilder.loadTexts: fcipEntityInstanceTable.setDescription("Information about this FCIP device's existing instances of\nFCIP entities.")
fcipEntityInstanceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"))
if mibBuilder.loadTexts: fcipEntityInstanceEntry.setDescription("A conceptual row of the FCIP entity table with information\nabout a particular FCIP entity.  Once a row has been\ncreated, it is non-volatile across agent restarts until it\nis deleted.")
fcipEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 1), FcipEntityId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipEntityId.setDescription("The FCIP entity identifier.")
fcipEntityName = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipEntityName.setDescription("An administratively-assigned name for this FCIP entity.")
fcipEntityAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 3), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipEntityAddressType.setDescription("The type of Internet address by which the entity is\nreachable.  Only address types IPv4 and IPv6 are supported.")
fcipEntityAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 4), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipEntityAddress.setDescription("The Internet address for the entity, if configured.  The\nformat of this address is determined by the value of the\nfcipEntityAddressType object.")
fcipEntityTcpConnPort = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 5), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipEntityTcpConnPort.setDescription("A TCP port other than the FCIP Well-Known port on which the\nFCIP entity listens for new TCP connection requests.  It\ncontains the value zero(0) if the FCIP Entity only listens\non the Well-Known port.")
fcipEntitySeqNumWrap = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipEntitySeqNumWrap.setDescription("An indication of whether the FCIP Entity supports protection\nagainst sequence number wrap.")
fcipEntityPHBSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipEntityPHBSupport.setDescription("An indication of whether the FCIP Entity supports PHB IP\nquality of service (QoS).")
fcipEntityStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 4, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipEntityStatus.setDescription("This object specifies the operational status of the row.\n\nWhen a management station sets the status to active(1), then\nthe values for the objects fcipEntityName,\nfcipEntityAddressType, and fcipEntityAddress should be\nsupplied as part of the set request.  The values of the\nobjects fcipEntityName, fcipEntityAddressType, and\nfcipEntityAddress can be changed if the row status is in\nactive state.  The object fcipEntityTcpConnPort takes the\ndefault value zero(0), if no value is supplied at the time\nof row creation.\n\nSetting the status to destroy(6) deletes the specified FCIP\nentity instance row from the table.  It also deletes all the\nrows corresponding to the specified FCIP entity from the\nfcipLinkTable and fcipTcpConnTable tables.")
fcipLinkTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 5))
if mibBuilder.loadTexts: fcipLinkTable.setDescription("Information about FCIP links that exist on this device.")
fcipLinkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"), (0, "FCIP-MGMT-MIB", "fcipLinkIndex"))
if mibBuilder.loadTexts: fcipLinkEntry.setDescription("A conceptual row of the FCIP link table containing\ninformation about a particular FCIP link.  The values of the\nread-create objects in this table are persistent across\nsystem restarts.")
fcipLinkIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipLinkIndex.setDescription("An arbitrary integer that uniquely identifies one FCIP link\nwithin an FCIP entity.")
fcipLinkIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkIfIndex.setDescription("The ifIndex value of the virtual interface corresponding to\nthe FCIP Link running over TCP/IP.")
fcipLinkCost = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 3), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkCost.setDescription("The FSPF cost associated with this FCIP Link.")
fcipLinkLocalFcipEntityMode = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 4), FcipEntityMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkLocalFcipEntityMode.setDescription("The mode of the local end of the FCIP link.")
fcipLinkLocalFcipEntityAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 5), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkLocalFcipEntityAddressType.setDescription("The type of Internet address contained in the corresponding\ninstance of fcipLinkLocalFcipEntityAddress.  Only address\ntypes IPv4 and IPv6 are supported.")
fcipLinkLocalFcipEntityAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 6), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkLocalFcipEntityAddress.setDescription("The Internet address for the local end of this FCIP Link.\nThe format of this object is determined by the value of the\nfcipLinkLocalFcipEntityAddressType object.")
fcipLinkRemFcipEntityWWN = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 7), FcNameIdOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkRemFcipEntityWWN.setDescription("The World Wide Name of the remote FC Fabric Entity.")
fcipLinkRemFcipEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 8), FcipEntityId()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkRemFcipEntityId.setDescription("The remote FCIP entity's identifier.")
fcipLinkRemFcipEntityAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 9), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkRemFcipEntityAddressType.setDescription("The type of Internet address contained in the corresponding\ninstance of fcipLinkRemFcipEntityAddress.  Only address\ntypes IPv4 and IPv6 are supported.")
fcipLinkRemFcipEntityAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 10), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkRemFcipEntityAddress.setDescription("The Internet address for the remote end of this FCIP Link.\nThe format of this object is determined by the value of the\nfcipLinkRemFcipEntityAddressType object.")
fcipLinkStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipLinkStatus.setDescription("This object specifies the operational status of the row.\n\nThe values of objects fcipLinkLocalFcipEntityAddressType,\nfcipLinkLocalFcipEntityAddress, fcipLinkRemFcipEntityWWN,\nfcipLinkRemFcipEntityId, fcipLinkRemFcipEntityAddressType,\n\n\n\nand fcipLinkRemFcipEntityAddress can be changed if the row\nis in active(1) state.  The object fcipLinkCost is set to\nthe value zero(0) if no value is supplied at the time of row\ncreation.\n\nSetting the status to destroy(6) deletes the specified FCIP\nlink from the table.  It also deletes all rows corresponding\nto the specified FCIP link from the fcipTcpConnTable table.")
fcipLinkCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 5, 1, 12), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkCreateTime.setDescription("The value of sysUpTime when this entry was last created.")
fcipTcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 6))
if mibBuilder.loadTexts: fcipTcpConnTable.setDescription("Information about existing TCP connections.  Each FCIP link\nwithin an FCIP entity manages one or more TCP connections.\nThe FCIP entity employs a Data Engine for each TCP\nconnection for handling FC frame encapsulation,\nde-encapsulation, and transmission of FCIP frames on the\nconnection.")
fcipTcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 6, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"), (0, "FCIP-MGMT-MIB", "fcipLinkIndex"), (0, "FCIP-MGMT-MIB", "fcipTcpConnLocalPort"), (0, "FCIP-MGMT-MIB", "fcipTcpConnRemPort"))
if mibBuilder.loadTexts: fcipTcpConnEntry.setDescription("A conceptual row of the FCIP TCP Connection table containing\ninformation about a particular TCP connection.")
fcipTcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 6, 1, 1), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipTcpConnLocalPort.setDescription("The local port number for this TCP connection.")
fcipTcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 6, 1, 2), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipTcpConnRemPort.setDescription("The remote port number for this TCP connection.")
fcipTcpConnRWSize = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 6, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipTcpConnRWSize.setDescription("The default maximum TCP Receiver Window size for this TCP\nconnection.")
fcipTcpConnMSS = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 6, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipTcpConnMSS.setDescription("The TCP Maximum Segment Size (MSS) for this TCP connection.")
fcipDynamicRouteTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 7))
if mibBuilder.loadTexts: fcipDynamicRouteTable.setDescription("Information about dynamically discovered routing\ninformation.  The FCIP device may use the SLPv2 protocol in\nconjunction with other protocols (say, FSPF) for dynamically\ndiscovering other FCIP entities and may populate this table\nwith FCIP link information for each Destination Address\nIdentifier.")
fcipDynamicRouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 7, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"), (0, "FCIP-MGMT-MIB", "fcipDynamicRouteDID"))
if mibBuilder.loadTexts: fcipDynamicRouteEntry.setDescription("A conceptual row of the FCIP Dynamic Route Table containing\ninformation about a particular FCIP route.")
fcipDynamicRouteDID = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 7, 1, 1), FcipDomainIdInOctetForm()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipDynamicRouteDID.setDescription("8-bit ID of a Fibre Channel Domain that is reachable from\nthis FCIP device.")
fcipDynamicRouteLinkIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 7, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipDynamicRouteLinkIndex.setDescription("The FCIP Link used to reach the domain specified by the\n\n\n\ncorresponding instance of fcipDynamicRouteDID.  The link\nidentified by a value of this object is the same FCIP link\nas identified by the same value of fcipLinkIndex for the\nsame FCIP entity.")
fcipStaticRouteTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 8))
if mibBuilder.loadTexts: fcipStaticRouteTable.setDescription("Information about static route entries configured by the\nNetwork Admin.  In the absence of dynamic discovery of\nremote FCIP entities, the Network Manager will figure out\nall remote FCIP devices that are reachable from this device\nand populate this table with FCIP link information for each\nDomain ID.  At any time, both static and dynamic routing\ncan be active, and an entry in the static route table for a\ngiven DID takes precedence over the entry in the dynamic\nroute table for the same Domain ID.")
fcipStaticRouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 8, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"), (0, "FCIP-MGMT-MIB", "fcipStaticRouteDID"))
if mibBuilder.loadTexts: fcipStaticRouteEntry.setDescription("A conceptual row of the FCIP Static Route Table containing\ninformation about a particular FCIP route.  The values of\nthe read-create objects in this table are persistent across\nsystem restarts.")
fcipStaticRouteDID = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 8, 1, 1), FcipDomainIdInOctetForm()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipStaticRouteDID.setDescription("8-bit ID of a Fibre Channel Domain that is reachable from\nthis FCIP device.")
fcipStaticRouteLinkIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 8, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipStaticRouteLinkIndex.setDescription("The FCIP Link used to reach the domain specified by the\ncorresponding instance of fcipStaticRouteDID.  The link\nidentified by a value of this object is the same FCIP link\nas identified by the same value of fcipLinkIndex for the\nsame FCIP entity.")
fcipStaticRouteStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 8, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: fcipStaticRouteStatus.setDescription("This object specifies the operational status of the row.\n\nWhen a management station sets the status to active(1),\nthe values for the object fcipStaticRouteLinkIndex should be\nsupplied as part of the set request.\n\nSetting the status to destroy(6) deletes the specified FCIP\nstatic route entry from the table.")
fcipDiscoveryDomainTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 9))
if mibBuilder.loadTexts: fcipDiscoveryDomainTable.setDescription("Information about FCIP Discovery Domains.  Each FCIP\nDiscovery Domain is associated with one or more FCIP\nentities.")
fcipDiscoveryDomainEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 9, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"), (0, "FCIP-MGMT-MIB", "fcipDiscoveryDomainIndex"))
if mibBuilder.loadTexts: fcipDiscoveryDomainEntry.setDescription("A conceptual row of the FCIP Discovery Domain Table\ncontaining information about a particular FCIP Discovery\nDomain that is associated with one or more FCIP entities.\nThe values of the read-write object fcipDiscoveryDomainName\nare persistent across system restarts.")
fcipDiscoveryDomainIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: fcipDiscoveryDomainIndex.setDescription("An integer that uniquely identifies an FCIP Discovery Domain\nassociated with this FCIP entity.")
fcipDiscoveryDomainName = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 9, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcipDiscoveryDomainName.setDescription("The name of this FCIP Discovery Domain.")
fcipLinkErrorsTable = MibTable((1, 3, 6, 1, 2, 1, 224, 1, 1, 10))
if mibBuilder.loadTexts: fcipLinkErrorsTable.setDescription("A list of error counters for FCIP Links.  Each counter\nrecords the number of times a particular error happened that\ncaused a TCP connection to close down.")
fcipLinkErrorsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1)).setIndexNames((0, "FCIP-MGMT-MIB", "fcipEntityId"), (0, "FCIP-MGMT-MIB", "fcipLinkIndex"))
if mibBuilder.loadTexts: fcipLinkErrorsEntry.setDescription("A conceptual row of the FCIP Link Errors Table containing\nerror counters for an FCIP Link.")
fcipLinkFcipLossofFcSynchs = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipLossofFcSynchs.setDescription("The number of times FC synchronization was lost on this FCIP\n\n\n\nLink.  The last discontinuity of this counter is indicated\nby fcipLinkCreateTime.")
fcipLinkFcipEncapErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipEncapErrors.setDescription("The number of FCIP frames received with encapsulation errors\nsuch as improper header, format, or length.  The last\ndiscontinuity of this counter is indicated by\nfcipLinkCreateTime.")
fcipLinkFcipNotReceivedSfResps = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipNotReceivedSfResps.setDescription("The number of times an FCIP Special Frame Response was\nexpected but not received on this FCIP Link.  The last\ndiscontinuity of this counter is indicated by\nfcipLinkCreateTime.")
fcipLinkFcipSfRespMismatches = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipSfRespMismatches.setDescription("The number of times FCIP Special Frame Bytes mismatch\nhappened on this FCIP Link.  The last discontinuity of this\ncounter is indicated by fcipLinkCreateTime.")
fcipLinkFcipSfInvalidNonces = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipSfInvalidNonces.setDescription("The number of times FCIP Special Frame Invalid Connection\nNonce happened on this FCIP Link.  The last discontinuity\nof this counter is indicated by fcipLinkCreateTime.")
fcipLinkFcipReceivedSfDuplicates = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipReceivedSfDuplicates.setDescription("The number of times duplicate FCIP Special Frames were\nreceived on this FCIP Link.  The last discontinuity of this\ncounter is indicated by fcipLinkCreateTime.")
fcipLinkFcipSfInvalidWWNs = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipSfInvalidWWNs.setDescription("The number of times FCIP Special Frames with invalid\ndestination FC Fabric Entity WWN were received on this FCIP\nLink.  The last discontinuity of this counter is indicated\nby fcipLinkCreateTime.")
fcipLinkFcipBB2LkaTimeOuts = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipBB2LkaTimeOuts.setDescription("The number of FC Keep Alive Time-outs that occurred on\nthis FCIP Link.  The last discontinuity of this counter\nis indicated by fcipLinkCreateTime.")
fcipLinkFcipSntpExpiredTimeStamps = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkFcipSntpExpiredTimeStamps.setDescription("The number of frames discarded due to an expired Simple\nNetwork Time Protocol (SNTP) timestamp on this FCIP Link.\nThe last discontinuity of this counter is indicated by\nfcipLinkCreateTime.")
fcipLinkTcpTooManyErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkTcpTooManyErrors.setDescription("The number of TCP connections that closed down on this\nFCIP Link due to too many errors on the connection.  The\nlast discontinuity of this counter is indicated by\n\n\n\nfcipLinkCreateTime.")
fcipLinkTcpExcessiveDroppedDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkTcpExcessiveDroppedDatagrams.setDescription("The number of TCP connections that closed down on this\nFCIP Link due to an excessive number of dropped FCIP\npackets.  The last discontinuity of this counter is\nindicated by fcipLinkCreateTime.")
fcipLinkTcpSaParamMismatches = MibTableColumn((1, 3, 6, 1, 2, 1, 224, 1, 1, 10, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcipLinkTcpSaParamMismatches.setDescription("The number of times TCP connections with Security\nAssociation parameter mismatches were closed down on this\nFCIP Link.  The last discontinuity of this counter is\nindicated by fcipLinkCreateTime.")
fcipConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 224, 2))
fcipCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 224, 2, 1))
fcipGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 224, 2, 2))

# Augmentions

# Groups

fcipEntityScalarGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 1)).setObjects(("FCIP-MGMT-MIB", "fcipDeviceWWN"), ("FCIP-MGMT-MIB", "fcipEntitySACKOption"), ("FCIP-MGMT-MIB", "fcipDynIpConfType"), )
if mibBuilder.loadTexts: fcipEntityScalarGroup.setDescription("Collection of scalar objects applicable to all FCIP\ninstances.")
fcipEntityInstanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 2)).setObjects(("FCIP-MGMT-MIB", "fcipEntitySeqNumWrap"), ("FCIP-MGMT-MIB", "fcipEntityAddress"), ("FCIP-MGMT-MIB", "fcipEntityAddressType"), ("FCIP-MGMT-MIB", "fcipEntityPHBSupport"), ("FCIP-MGMT-MIB", "fcipEntityTcpConnPort"), ("FCIP-MGMT-MIB", "fcipEntityName"), ("FCIP-MGMT-MIB", "fcipEntityStatus"), )
if mibBuilder.loadTexts: fcipEntityInstanceGroup.setDescription("A collection of objects providing information about FCIP\ninstances.")
fcipLinkGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 3)).setObjects(("FCIP-MGMT-MIB", "fcipLinkIfIndex"), ("FCIP-MGMT-MIB", "fcipLinkLocalFcipEntityAddressType"), ("FCIP-MGMT-MIB", "fcipLinkRemFcipEntityAddressType"), ("FCIP-MGMT-MIB", "fcipLinkCost"), ("FCIP-MGMT-MIB", "fcipLinkRemFcipEntityId"), ("FCIP-MGMT-MIB", "fcipLinkLocalFcipEntityAddress"), ("FCIP-MGMT-MIB", "fcipLinkCreateTime"), ("FCIP-MGMT-MIB", "fcipLinkStatus"), ("FCIP-MGMT-MIB", "fcipLinkLocalFcipEntityMode"), ("FCIP-MGMT-MIB", "fcipLinkRemFcipEntityWWN"), ("FCIP-MGMT-MIB", "fcipLinkRemFcipEntityAddress"), )
if mibBuilder.loadTexts: fcipLinkGroup.setDescription("A collection of objects providing information about FCIP\nLinks.")
fcipTcpConnGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 4)).setObjects(("FCIP-MGMT-MIB", "fcipTcpConnMSS"), ("FCIP-MGMT-MIB", "fcipTcpConnRWSize"), )
if mibBuilder.loadTexts: fcipTcpConnGroup.setDescription("A collection of objects providing information about FCIP\nTCP connections.")
fcipDiscoveryDomainGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 5)).setObjects(("FCIP-MGMT-MIB", "fcipDiscoveryDomainName"), )
if mibBuilder.loadTexts: fcipDiscoveryDomainGroup.setDescription("A collection of objects providing information about FCIP\nDiscovery Domains.")
fcipLinkErrorsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 6)).setObjects(("FCIP-MGMT-MIB", "fcipLinkFcipNotReceivedSfResps"), ("FCIP-MGMT-MIB", "fcipLinkFcipSntpExpiredTimeStamps"), ("FCIP-MGMT-MIB", "fcipLinkFcipBB2LkaTimeOuts"), ("FCIP-MGMT-MIB", "fcipLinkFcipLossofFcSynchs"), ("FCIP-MGMT-MIB", "fcipLinkFcipEncapErrors"), ("FCIP-MGMT-MIB", "fcipLinkFcipSfInvalidNonces"), ("FCIP-MGMT-MIB", "fcipLinkFcipSfInvalidWWNs"), ("FCIP-MGMT-MIB", "fcipLinkTcpTooManyErrors"), ("FCIP-MGMT-MIB", "fcipLinkTcpSaParamMismatches"), ("FCIP-MGMT-MIB", "fcipLinkTcpExcessiveDroppedDatagrams"), ("FCIP-MGMT-MIB", "fcipLinkFcipReceivedSfDuplicates"), ("FCIP-MGMT-MIB", "fcipLinkFcipSfRespMismatches"), )
if mibBuilder.loadTexts: fcipLinkErrorsGroup.setDescription("A collection of objects providing information about FCIP\nlink errors.")
fcipDynamicRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 7)).setObjects(("FCIP-MGMT-MIB", "fcipDynamicRouteLinkIndex"), )
if mibBuilder.loadTexts: fcipDynamicRouteGroup.setDescription("A collection of objects providing information about FCIP\ndynamic routes.")
fcipStaticRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 224, 2, 2, 8)).setObjects(("FCIP-MGMT-MIB", "fcipStaticRouteStatus"), ("FCIP-MGMT-MIB", "fcipStaticRouteLinkIndex"), )
if mibBuilder.loadTexts: fcipStaticRouteGroup.setDescription("A collection of objects providing information about FCIP\nstatic routes.")

# Compliances

fcipCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 224, 2, 1, 1)).setObjects(("FCIP-MGMT-MIB", "fcipDynamicRouteGroup"), ("FCIP-MGMT-MIB", "fcipDiscoveryDomainGroup"), ("FCIP-MGMT-MIB", "fcipEntityInstanceGroup"), ("FCIP-MGMT-MIB", "fcipEntityScalarGroup"), ("FCIP-MGMT-MIB", "fcipLinkErrorsGroup"), ("FCIP-MGMT-MIB", "fcipStaticRouteGroup"), ("FCIP-MGMT-MIB", "fcipLinkGroup"), ("FCIP-MGMT-MIB", "fcipTcpConnGroup"), )
if mibBuilder.loadTexts: fcipCompliance.setDescription("Compliance statement for FCIP MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("FCIP-MGMT-MIB", PYSNMP_MODULE_ID=fcipMIB)

# Types
mibBuilder.exportSymbols("FCIP-MGMT-MIB", FcipDomainIdInOctetForm=FcipDomainIdInOctetForm, FcipEntityId=FcipEntityId, FcipEntityMode=FcipEntityMode)

# Objects
mibBuilder.exportSymbols("FCIP-MGMT-MIB", fcipMIB=fcipMIB, fcipObjects=fcipObjects, fcipConfig=fcipConfig, fcipDynIpConfType=fcipDynIpConfType, fcipDeviceWWN=fcipDeviceWWN, fcipEntitySACKOption=fcipEntitySACKOption, fcipEntityInstanceTable=fcipEntityInstanceTable, fcipEntityInstanceEntry=fcipEntityInstanceEntry, fcipEntityId=fcipEntityId, fcipEntityName=fcipEntityName, fcipEntityAddressType=fcipEntityAddressType, fcipEntityAddress=fcipEntityAddress, fcipEntityTcpConnPort=fcipEntityTcpConnPort, fcipEntitySeqNumWrap=fcipEntitySeqNumWrap, fcipEntityPHBSupport=fcipEntityPHBSupport, fcipEntityStatus=fcipEntityStatus, fcipLinkTable=fcipLinkTable, fcipLinkEntry=fcipLinkEntry, fcipLinkIndex=fcipLinkIndex, fcipLinkIfIndex=fcipLinkIfIndex, fcipLinkCost=fcipLinkCost, fcipLinkLocalFcipEntityMode=fcipLinkLocalFcipEntityMode, fcipLinkLocalFcipEntityAddressType=fcipLinkLocalFcipEntityAddressType, fcipLinkLocalFcipEntityAddress=fcipLinkLocalFcipEntityAddress, fcipLinkRemFcipEntityWWN=fcipLinkRemFcipEntityWWN, fcipLinkRemFcipEntityId=fcipLinkRemFcipEntityId, fcipLinkRemFcipEntityAddressType=fcipLinkRemFcipEntityAddressType, fcipLinkRemFcipEntityAddress=fcipLinkRemFcipEntityAddress, fcipLinkStatus=fcipLinkStatus, fcipLinkCreateTime=fcipLinkCreateTime, fcipTcpConnTable=fcipTcpConnTable, fcipTcpConnEntry=fcipTcpConnEntry, fcipTcpConnLocalPort=fcipTcpConnLocalPort, fcipTcpConnRemPort=fcipTcpConnRemPort, fcipTcpConnRWSize=fcipTcpConnRWSize, fcipTcpConnMSS=fcipTcpConnMSS, fcipDynamicRouteTable=fcipDynamicRouteTable, fcipDynamicRouteEntry=fcipDynamicRouteEntry, fcipDynamicRouteDID=fcipDynamicRouteDID, fcipDynamicRouteLinkIndex=fcipDynamicRouteLinkIndex, fcipStaticRouteTable=fcipStaticRouteTable, fcipStaticRouteEntry=fcipStaticRouteEntry, fcipStaticRouteDID=fcipStaticRouteDID, fcipStaticRouteLinkIndex=fcipStaticRouteLinkIndex, fcipStaticRouteStatus=fcipStaticRouteStatus, fcipDiscoveryDomainTable=fcipDiscoveryDomainTable, fcipDiscoveryDomainEntry=fcipDiscoveryDomainEntry, fcipDiscoveryDomainIndex=fcipDiscoveryDomainIndex, fcipDiscoveryDomainName=fcipDiscoveryDomainName, fcipLinkErrorsTable=fcipLinkErrorsTable, fcipLinkErrorsEntry=fcipLinkErrorsEntry, fcipLinkFcipLossofFcSynchs=fcipLinkFcipLossofFcSynchs, fcipLinkFcipEncapErrors=fcipLinkFcipEncapErrors, fcipLinkFcipNotReceivedSfResps=fcipLinkFcipNotReceivedSfResps, fcipLinkFcipSfRespMismatches=fcipLinkFcipSfRespMismatches, fcipLinkFcipSfInvalidNonces=fcipLinkFcipSfInvalidNonces, fcipLinkFcipReceivedSfDuplicates=fcipLinkFcipReceivedSfDuplicates, fcipLinkFcipSfInvalidWWNs=fcipLinkFcipSfInvalidWWNs, fcipLinkFcipBB2LkaTimeOuts=fcipLinkFcipBB2LkaTimeOuts, fcipLinkFcipSntpExpiredTimeStamps=fcipLinkFcipSntpExpiredTimeStamps, fcipLinkTcpTooManyErrors=fcipLinkTcpTooManyErrors, fcipLinkTcpExcessiveDroppedDatagrams=fcipLinkTcpExcessiveDroppedDatagrams, fcipLinkTcpSaParamMismatches=fcipLinkTcpSaParamMismatches, fcipConformance=fcipConformance, fcipCompliances=fcipCompliances, fcipGroups=fcipGroups)

# Groups
mibBuilder.exportSymbols("FCIP-MGMT-MIB", fcipEntityScalarGroup=fcipEntityScalarGroup, fcipEntityInstanceGroup=fcipEntityInstanceGroup, fcipLinkGroup=fcipLinkGroup, fcipTcpConnGroup=fcipTcpConnGroup, fcipDiscoveryDomainGroup=fcipDiscoveryDomainGroup, fcipLinkErrorsGroup=fcipLinkErrorsGroup, fcipDynamicRouteGroup=fcipDynamicRouteGroup, fcipStaticRouteGroup=fcipStaticRouteGroup)

# Compliances
mibBuilder.exportSymbols("FCIP-MGMT-MIB", fcipCompliance=fcipCompliance)
