# PySNMP SMI module. Autogenerated from smidump -f python FRNETSERV-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:30 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( RowStatus, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TimeStamp")

# Objects

frnetservMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 44)).setRevisions(("2000-09-28 00:00","1993-11-16 12:00",))
if mibBuilder.loadTexts: frnetservMIB.setOrganization("IETF Frame Relay Service MIB Working Group")
if mibBuilder.loadTexts: frnetservMIB.setContactInfo("WG Charter:\nhttp://www.ietf.org/html.charters/frnetmib-charter\nWG-email:\nfrnetmib@sunroof.eng.sun.com\n\n\nSubscribe:\nfrnetmib-request@sunroof.eng.sun.com\nEmail Archive:\nftp://ftp.ietf.org/ietf-mail-archive/frnetmib\n\nChair:      Andy Malis\n          Vivace Networks, Inc.\nEmail:      Andy.Malis@vivacenetworks.com\n\nWG editor:  Kenneth Rehbehn\n          Megisto Systems, Inc.\nEmail:      krehbehn@megisto.com\n\nCo-author:  David Fowler\n          Syndesis Limited,\nEMail:      fowler@syndesis.com")
if mibBuilder.loadTexts: frnetservMIB.setDescription("The MIB module to describe generic objects for\nFrame Relay Network Service.")
frnetservObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 44, 1))
frLportTable = MibTable((1, 3, 6, 1, 2, 1, 10, 44, 1, 1))
if mibBuilder.loadTexts: frLportTable.setDescription("The Frame Relay Logical Port Information table is\nan interface-specific addendum to the generic\nifTable of the Interface MIB.")
frLportEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: frLportEntry.setDescription("An entry in the Frame Relay Logical Port\nInformation table.")
frLportNumPlan = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,2,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("e164", 2), ("x121", 3), ("none", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportNumPlan.setDescription("The value of this object identifies the network\naddress numbering plan for this UNI/NNI logical\nport. The network address is the object\nifPhysAddress. The value none(4) implies that\nthere is no ifPhysAddress.  The FRS agent will\nreturn an octet string of zero length for\nifPhysAddress.  The value other(1) means that an\naddress has been assigned to this interface, but\nthe numbering plan is not enumerated here.")
frLportContact = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportContact.setDescription("The value of this object identifies the network\ncontact for this UNI/NNI logical port.")
frLportLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportLocation.setDescription("The value of this object identifies the frame\nrelay network location for this UNI/NNI logical\nport.")
frLportType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("uni", 1), ("nni", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportType.setDescription("The value of this object identifies the type of\nnetwork interface for this logical port.")
frLportAddrDLCILen = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,2,5,3,)).subtype(namedValues=namedval.NamedValues(("twoOctets10Bits", 1), ("threeOctets10Bits", 2), ("threeOctets16Bits", 3), ("fourOctets17Bits", 4), ("fourOctets23Bits", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportAddrDLCILen.setDescription("The value of this object identifies the Q.922\nAddress field length and DLCI length for this\nUNI/NNI logical port.")
frLportVCSigProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,5,2,4,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("lmi", 2), ("ansiT1617D", 3), ("ansiT1617B", 4), ("ccittQ933A", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportVCSigProtocol.setDescription("The value of this object identifies the Local\nIn-Channel Signaling Protocol that is used for\nthis frame relay UNI/NNI logical port.\n\nnone(1):        Interface does not use a PVC\n                signaling protocol\n\nlmi(2):         Interface operates the Stratacom/\n                Nortel/DEC Local Management\n                Interface Specification protocol\n\nansiT1617D(3):  Interface operates the ANSI T1.617\n                Annex D PVC status protocol\n\n\n  ansiT1617B(4):  Interface operates the ANSI\nT1.617\n                  Annex B procedures\n\n  ccittQ933A(5):  Interface operates the ITU Q.933\n                  Annex A PVC status protocol")
frLportVCSigPointer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 7), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportVCSigPointer.setDescription("The value of this object is used as a pointer to\nthe table that contains the Local In-Channel\nSignaling Protocol parameters and errors for this\nUNI/NNI logical port.\n\nThis object has been deprecated to reflect the\nfact that the local in-channel signaling\nparameters are accessed from a single table\n(frMgtVCSigTable) that includes parameters for all\npossible signaling protocols.  Early design\nanticipated multiple tables, one for each\nsignaling protocol.")
frLportDLCIIndexValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(16, 4194303))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frLportDLCIIndexValue.setDescription("This object contains a hint to be used for\nfrPVCEndptDLCIIndex when creating entries in the\nfrPVCEndptTable.  The SYNTAX of this object\nmatches the SYNTAX of the frPVCEndptDLCIIndex - an\nobject that is restricted to legal Q.922 DLCI\nvalues for the size of the address field.\n\nThe value 0 indicates that no unassigned entries\nare available.\n\nTo obtain the frPVCEndptDLCIIndex value for a new\nentry, the manager issues a management protocol\nretrieval operation to obtain the current value of\n\n\nthis object.  After each retrieval, the agent must\nmodify the value to the next unassigned index to\nprevent assignment of the same value to multiple\nmanagement systems.\n\nA management system should repeat the read to\nobtain a new value should an attempt to create the\nnew row using the previously returned hint fail.")
frLportTypeAdmin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("uni", 1), ("nni", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frLportTypeAdmin.setDescription("The value of this object desired identifies the\ntype of network interface for this logical port.")
frLportVCSigProtocolAdmin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,5,2,4,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("lmi", 2), ("ansiT1617D", 3), ("ansiT1617B", 4), ("ccittQ933A", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frLportVCSigProtocolAdmin.setDescription("The value of this object identifies the desired\nLocal In-Channel Signaling Protocol that is used\nfor this frame relay UNI/NNI logical port.  This\nvalue must be made the active protocol as soon as\npossible on the device.\n\nRefer to frLportVCSigProtocol for a description of\neach signaling protocol choices.")
frLportFragControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("on", 1), ("off", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frLportFragControl.setDescription("This object controls the transmission and\nreception of fragmentation frames for this UNI or\nNNI interface.\n\non(1)   Frames are fragmented using the interface\n        fragmentation format\n        Note:  The customer side of the interface\n        must also be configured to fragment\n        frames.\n\noff(2)  Frames are not fragmented using the\n        interface fragmentation format.")
frLportFragSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 1, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4096)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frLportFragSize.setDescription("The value of this object is the size in octets of\nthe maximum size of each fragment to be sent when\nfragmenting.  This object is only used by the\nfragmentation transmitter, and the two sides of\nthe interface may differ.  The fragment size\nincludes the octets for the frame relay header,\nthe UI octet, the NLPID, the fragmentation header,\nand the fragment payload. If frLportFragControl is\nset to off, this value should be zero.")
frMgtVCSigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 44, 1, 2))
if mibBuilder.loadTexts: frMgtVCSigTable.setDescription("The Frame Relay Management VC Signaling\nParameters and Errors table.")
frMgtVCSigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: frMgtVCSigEntry.setDescription("An entry in the Frame Relay Management VC\nSignaling Parameters Errors table.")
frMgtVCSigProced = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("u2nnet", 1), ("bidirect", 2), ("u2nuser", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigProced.setDescription("The value of this object identifies the local\nin-channel signaling procedural role that is used\nfor this UNI/NNI logical port.  Bidirectional\nprocedures implies that both user-side and\nnetwork-side procedural roles are used.\n\nu2nnet(1)   Logical port operates user to network\n            procedure in the role of the network\n            side\n\nbidirect(2) Logical port operates the\n            bidirectional procedure (both user\n            and network side roles)\n\nu2nuser(3)  Logical port operates user to network\n            procedure in the role of the user\n            side")
frMgtVCSigUserN391 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserN391.setDescription("The value of this object identifies the User-side\nN391 full status polling cycle value for this\nUNI/NNI logical port.  If the logical port is not\nperforming user-side (bidirectional) procedures,\nthen this object is not instantiated and an\nattempt to read will result in the noSuchInstance\nexception response.")
frMgtVCSigUserN392 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(3)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserN392.setDescription("The value of this object identifies the User-side\nN392 error threshold value for this UNI/NNI\nlogical port.  If the logical port is not\nperforming user-side (bidirectional) procedures,\nthen this object is not instantiated.")
frMgtVCSigUserN393 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserN393.setDescription("The value of this object identifies the User-side\nN393 monitored events count value for this UNI/NNI\nlogical port.  If the logical port is not\nperforming user-side (bidirectional) procedures,\nthen this object is not instantiated.")
frMgtVCSigUserT391 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 30)).clone(10)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserT391.setDescription("The value of this object identifies the User-side\nT391 link integrity verification polling timer\nvalue for this UNI/NNI logical port.  If the\nlogical port is not performing user-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetN392 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(3)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetN392.setDescription("The value of this object identifies the Network-\nside N392 error threshold value (nN2 for LMI) for\nthis UNI/NNI logical port.  If the logical port is\nnot performing network-side procedures, then this\nobject is not instantiated.")
frMgtVCSigNetN393 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetN393.setDescription("The value of this object identifies the Network-\nside N393 monitored events count value (nN3 for\nLMI) for this UNI/NNI logical port.  If the\nlogical port is not performing network-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetT392 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 30)).clone(15)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetT392.setDescription("The value of this object identifies the Network-\nside T392 polling verification timer value (nT2\nfor LMI)  for this UNI/NNI logical port.  If the\nlogical port is not performing network-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetnN4 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 5))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetnN4.setDescription("The value of this object identifies the Network-\nside nN4 maximum status enquires received value\nfor this UNI/NNI logical port.  If the logical\nport is not performing network-side procedures or\nis not performing LMI procedures, then this object\nis not instantiated.\n\nThis object applies only to LMI and always has a\nvalue of 5.")
frMgtVCSigNetnT3 = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(5,5),constraint.ValueRangeConstraint(10,10),constraint.ValueRangeConstraint(15,15),constraint.ValueRangeConstraint(20,20),constraint.ValueRangeConstraint(25,25),constraint.ValueRangeConstraint(30,30),)).clone(20)).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetnT3.setDescription("The value of this object identifies the Network-\nside nT3 timer (for nN4 status enquires received)\nvalue for this UNI/NNI logical port.  If the\nlogical port is not performing network-side\nprocedures or is not performing LMI procedures,\nthen this object is not instantiated.\n\n  This object applies only to LMI.")
frMgtVCSigUserLinkRelErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserLinkRelErrors.setDescription("The number of user-side local in-channel\nsignaling link reliability errors (i.e., non-\nreceipt of Status/Status Enquiry messages or\ninvalid sequence numbers in a Link Integrity\nVerification Information Element) for this UNI/NNI\nlogical port.  If the logical port is not\n\n\nperforming user-side procedures, then this object\nis not instantiated.")
frMgtVCSigUserProtErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserProtErrors.setDescription("The number of user-side local in-channel\nsignaling protocol errors (i.e., protocol\ndiscriminator, unnumbered information, message\ntype, call reference, and mandatory information\nelement errors) for this UNI/NNI logical port. If\nthe logical port is not performing user-side\nprocedures, then this object is not instantiated.")
frMgtVCSigUserChanInactive = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigUserChanInactive.setDescription("The number of times the user-side channel was\ndeclared inactive (i.e., N392 errors in N393\nevents) for this UNI/NNI logical port. If the\nlogical port is not performing user-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetLinkRelErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetLinkRelErrors.setDescription("The number of network-side local in-channel\nsignaling link reliability errors (i.e., non-\nreceipt of Status/Status Enquiry messages or\ninvalid sequence numbers in a Link Integrity\nVerification Information Element) for this UNI/NNI\nlogical port.")
frMgtVCSigNetProtErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetProtErrors.setDescription("The number of network-side local in-channel\nsignaling protocol errors (i.e., protocol\ndiscriminator, message type, call reference, and\nmandatory information element errors) for this\nUNI/NNI logical port.")
frMgtVCSigNetChanInactive = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frMgtVCSigNetChanInactive.setDescription("The number of times the network-side channel was\ndeclared inactive (i.e., N392 errors in N393\nevents) for this UNI/NNI logical port.")
frMgtVCSigProcedAdmin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("u2nnet", 1), ("bidirect", 2), ("u2nuser", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigProcedAdmin.setDescription("The value of this object identifies the local\nin-channel signaling procedural role that is used\nfor this UNI/NNI logical port.  Bidirectional\nprocedures implies that both user-side and\nnetwork-side procedural roles are used.\n\nu2nnet(1)   Logical port operates user to network\n            procedure in the role of the network\n            side\n\nbidirect(2) Logical port operates the\n            bidirectional procedure (both user\n            and network side roles)\n\nu2nuser(3)  Logical port operates user to network\n            procedure in the role of the user\n            side")
frMgtVCSigUserN391Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 18), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigUserN391Admin.setDescription("The value of this object identifies the desired\nUser-side N391 full status polling cycle value for\nthis UNI/NNI logical port.  If the logical port is\nnot performing user-side (bidirectional)\nprocedures, then this object is not instantiated.")
frMgtVCSigUserN392Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 19), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigUserN392Admin.setDescription("The value of this object identifies the desired\nUser-side N392 error threshold value for this\nUNI/NNI logical port.  If the logical port is not\nperforming user-side (bidirectional) procedures,\nthen this object is not instantiated.")
frMgtVCSigUserN393Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 20), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigUserN393Admin.setDescription("The value of this object identifies the desired\nUser-side N393 monitored events count value for\nthis UNI/NNI logical port.  If the logical port is\nnot performing user-side (bidirectional)\nprocedures, then this object is not instantiated.")
frMgtVCSigUserT391Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 21), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigUserT391Admin.setDescription("The value of this object identifies the desired\nUser-side T391 link integrity verification polling\ntimer value for this UNI/NNI logical port.  If the\nlogical port is not performing user-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetN392Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 22), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigNetN392Admin.setDescription("The value of this object identifies the desired\nNetwork-side N392 error threshold value (nN2 for\nLMI) for this UNI/NNI logical port.  If the\nlogical port is not performing network-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetN393Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 23), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigNetN393Admin.setDescription("The value of this object identifies the desired\nNetwork-side N393 monitored events count value\n(nN3 for LMI) for this UNI/NNI logical port.  If\nthe logical port is not performing network-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetT392Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 24), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigNetT392Admin.setDescription("The value of this object identifies the desired\nNetwork-side T392 polling verification timer value\n(nT2 for LMI)  for this UNI/NNI logical port. If\nthe logical port is not performing network-side\nprocedures, then this object is not instantiated.")
frMgtVCSigNetnT3Admin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 2, 1, 25), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(5,5),constraint.ValueRangeConstraint(10,10),constraint.ValueRangeConstraint(15,15),constraint.ValueRangeConstraint(20,20),constraint.ValueRangeConstraint(25,25),constraint.ValueRangeConstraint(30,30),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frMgtVCSigNetnT3Admin.setDescription("The value of this object identifies the desired\nNetwork-side nT3 timer (for nN4 status enquires\nreceived) value for this UNI/NNI logical port. If\nthe logical port is not performing network-side\nprocedures or is not performing LMI procedures,\nthen this object is not instantiated.  This object\napplies only to LMI.")
frPVCEndptTable = MibTable((1, 3, 6, 1, 2, 1, 10, 44, 1, 3))
if mibBuilder.loadTexts: frPVCEndptTable.setDescription("The Frame Relay PVC End-Point table.  This table\nis used to model a PVC end-point.  This table\ncontains the traffic parameters and statistics for\na PVC end-point.\n\nThis table is used to identify the traffic\nparameters for a bi-directional PVC segment end-\n\n\npoint, and it also provides statistics for a PVC\nsegment end-point.\n\nA PVC segment end-point is identified by a UNI/NNI\nlogical port index value and DLCI index value.\n\nIf the frame relay service provider allows the\nframe relay CNM subscriber to create, modify or\ndelete PVCs using SNMP, then this table is used to\nidentify and reserve the requested traffic\nparameters of each PVC segment end-point.  The\nConnection table is used to 'connect' the end-\npoints together.  Not all implementations will\nsupport the capability of\ncreating/modifying/deleting PVCs using SNMP as a\nfeature of frame relay CNM service.\n\nUni-directional PVCs are modeled with zero valued\ntraffic parameters in one of the directions (In or\n Out direction) in this table.\n\nTo create a PVC, the following procedures shall be\nfollowed:\n\n1)  Create the entries for the PVC segment\n    endpoints in the frPVCEndptTable by specifying\n    the traffic parameters for the bi-directional\n    PVC segment endpoints. As shown in figure 2, a\n    point-to-point PVC has two endpoints, thus two\n    entries in this table.  Uni-directional PVCs\n    are modeled with zero valued traffic\n    parameters in one direction; all the `In'\n    direction parameters for one frame relay PVC\n    End-point or all the `Out' direction\n    parameters for the other frame relay PVC\n    Endpoint.\n\n    In    _____________________________  Out\n   >>>>>>|                             |>>>>>>>>\n   ______|    Frame Relay Network      |________\n    Out  |                             |  In\n   <<<<<<|_____________________________|<<<<<<<<\n Frame Relay                         Frame Relay\n     PVC                                 PVC\n   Endpoint                            Endpoint\n\n            Figure 2, PVC Terminology\n\n\n\n2)  Go to the Frame Relay Connection Group.")
frPVCEndptEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "FRNETSERV-MIB", "frPVCEndptDLCIIndex"))
if mibBuilder.loadTexts: frPVCEndptEntry.setDescription("An entry in the Frame Relay PVC Endpoint table.")
frPVCEndptDLCIIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(16, 4194303))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frPVCEndptDLCIIndex.setDescription("The value of this object is equal to the DLCI\nvalue for this PVC end-point.\n\nThe values are restricted to the legal range for\nthe size of address field supported by the logical\nport (frLportAddrDLCILen).")
frPVCEndptInMaxFrameSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4096)).clone(1600)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptInMaxFrameSize.setDescription("The value of this object is the size in octets of\nthe largest frame relay information field for this\nPVC end-point in the ingress direction (into the\nframe relay network).  The value of\nfrPVCEndptInMaxFrameSize must be less than or\nequal to the corresponding ifMtu for this frame\nrelay UNI/NNI logical port.")
frPVCEndptInBc = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptInBc.setDescription("The value of this object is equal to the\ncommitted burst size (Bc) parameter (measured in\nbits) for this PVC end-point in the ingress\ndirection (into the frame relay network).\n\nNote that the max value of this range is lower\nthan the max value allowed by Q.933 (16383 *\n10**6).\n\n\n\nNote that the value is encoded in bits whilst the\nQ.933 Link layer core parameters information\nelement encodes this information using octet\nunits.")
frPVCEndptInBe = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptInBe.setDescription("The value of this object is equal to the excess\nburst size (Be) parameter (measured in bits) for\nthis PVC end-point in the ingress direction (into\nthe frame relay network).\n\nNote that the max value of this range is lower\nthan the max value allowed by Q.933 (16383 *\n10**6).\n\nNote that the value is encoded in bits whilst the\nQ.933 Link layer core parameters information\nelement encodes this information using octet\nunits.")
frPVCEndptInCIR = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptInCIR.setDescription("The value of this object is equal to the\ncommitted information rate (CIR) parameter\n(measured in bits per second) for this PVC end-\npoint in the ingress direction (into the frame\nrelay network).\n\nNote that the max value of this range is lower\nthan the max value allowed by Q.933 (2047 *\n10**6).")
frPVCEndptOutMaxFrameSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4096)).clone(1600)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptOutMaxFrameSize.setDescription("The value of this object is the size in octets of\nthe largest frame relay information field for this\nPVC end-point in the egress direction (out of the\nframe relay network).  The value of\nfrPVCEndptOutMaxFrameSize must be less than or\nequal to the corresponding ifMtu for this frame\nrelay UNI/NNI logical port.")
frPVCEndptOutBc = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptOutBc.setDescription("The value of this object is equal to the\ncommitted burst size (Bc) parameter (measured in\nbits) for this PVC end-point in the egress\ndirection (out of the frame relay network).\n\nNote that the max value of this range is lower\nthan the max value allowed by Q.933 (16383 *\n10**6).\n\nNote that the value is encoded in bits whilst the\nQ.933 Link layer core parameters information\nelement encodes this information using octet\nunits.")
frPVCEndptOutBe = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptOutBe.setDescription("The value of this object is equal to the excess\nburst size (Be) parameter (measured in bits) for\n\n\nthis PVC end-point in the egress direction (out of\nthe frame relay network).\n\nNote that the max value of this range is lower\nthan the max value allowed by Q.933 (16383 *\n10**6).\n\nNote that the value is encoded in bits whilst the\nQ.933 Link layer core parameters information\nelement encodes this information using octet\nunits.")
frPVCEndptOutCIR = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptOutCIR.setDescription("The value of this object is equal to the\ncommitted information rate (CIR) parameter\n(measured in bits per second) for this PVC end-\npoint in the egress direction (out of the frame\nrelay network).\n\nNote that the max value of this range is lower\nthan the max value allowed by Q.933 (2047 *\n10**6).")
frPVCEndptConnectIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptConnectIdentifier.setDescription("This object is used to associate PVC end-points\nas being part of one PVC segment connection. This\nvalue of this object is equal to the value of\nfrPVCConnectIndex, which is used as one of the\nindices into the frPVCConnectTable.\n\nA connection that has been cross-connected via the\nFR/ATM PVC Service IWF cross-connect table will\nreturn the value zero when this object is read. In\ncase of these interworked connections, the\nfrPVCEndptAtmIwfConnIndex object must be accessed\n\n\nto select the entry in the FR/ATM PVC Service IWF\ncross-connect table.\n\nThe value of this object is provided by the agent,\nafter the associated entries in the\nfrPVCConnectTable or frAtmIwfConnectionTable have\nbeen created.")
frPVCEndptRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCEndptRowStatus.setDescription("This object is used to create new rows in this\ntable, modify existing rows, and to delete\nexisting rows.  To create a new PVC, the entries\nfor the PVC segment end-points in the\nfrPVCEndptTable must first be created.  Next, the\nfrPVCConnectTable is used to associate the frame\nrelay PVC segment end-points.  In order for the\nmanager to have the necessary error diagnostics,\nthe frPVCEndptRowStatus object must initially be\nset to `createAndWait(5)'.  While the\nfrPVCEndptRowStatus object is in the\n`createAndWait(5)' state, the manager can set each\ncolumnar object and get the necessary error\ndiagnostics.  The frPVCEndptRowStatus object may\nnot be set to `active(1)' unless the following\ncolumnar objects exist in this row:\nfrPVCEndptInMaxFrameSize, frPVCEndptInBc,\nfrPVCEndptInBe, frPVCEndptInCIR,\nfrPVCEndptOutMaxFrameSize, frPVCEndptOutBc,\nfrPVCEndptOutBe, and frPVCEndptOutCIR.")
frPVCEndptRcvdSigStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("deleted", 1), ("active", 2), ("inactive", 3), ("none", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptRcvdSigStatus.setDescription("The value of this object identifies the PVC\nstatus received via the local in-channel signaling\n\n\nprocedures for this PVC end-point.  This object is\nonly pertinent for interfaces that perform the\nbidirectional procedures.\n\nEach value has the following meaning:\n  deleted(1):  This PVC is not listed in the full\n               status reports received from the\n               user device.  The object retains\n               this value for as long as the PVC\n               is not listed in the full status\n               reports\n\nactive(2):   This PVC is reported as active, or\n               operational, by the user device.\n\n  inactive(3): This PVC is reported as inactive,\n               or non-operational, by the user\n               device.\n\n  none(4):     This interface is only using the\n               network-side in-channel signaling\n               procedures, so this object does\n               not apply.")
frPVCEndptInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInFrames.setDescription("The number of frames received by the network\n(ingress) for this PVC end-point. This includes\nany frames discarded by the network due to\nsubmitting more than Bc + Be data or due to any\nnetwork congestion recovery procedures.")
frPVCEndptOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutFrames.setDescription("The number of frames sent by the network (egress)\nregardless of whether they are Bc or Be frames for\nthis PVC end-point.")
frPVCEndptInDEFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInDEFrames.setDescription("The number of frames received by the network\n(ingress) with the DE bit set to (1) for this PVC\nend-point.")
frPVCEndptInExcessFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInExcessFrames.setDescription("The number of frames received by the network\n(ingress) for this PVC end-point which were\ntreated as excess traffic.  Frames which are sent\nto the network with DE set to zero are treated as\nexcess when more than Bc bits are submitted to the\nnetwork during the Committed Information Rate\nMeasurement Interval (Tc).  Excess traffic may or\nmay not be discarded at the ingress if more than\nBc + Be bits are submitted to the network during\nTc.  Traffic discarded at the ingress is not\nrecorded in frPVCEndptInExcessFrames.  Frames\nwhich are sent to the network with DE set to one\nare also treated as excess traffic.")
frPVCEndptOutExcessFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutExcessFrames.setDescription("The number of frames sent by the network (egress)\nfor this PVC end-point which were treated as\nexcess traffic.  (The DE bit may be set to one.)")
frPVCEndptInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInDiscards.setDescription("The number of frames received by the network\n(ingress) that were discarded due to traffic\nenforcement for this PVC end-point.  Congestion\ndiscards are not counted in this object.")
frPVCEndptInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInOctets.setDescription("The number of octets received by the network\n(ingress) for this PVC end-point.  This counter\nshould only count octets from the beginning of the\nframe relay header field to the end of user data.\nIf the network supporting frame relay can not\ncount octets, then this count should be an\napproximation.")
frPVCEndptOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutOctets.setDescription("The number of octets sent by the network (egress)\nfor this PVC end-point.  This counter should only\ncount octets from the beginning of the frame relay\nheader field to the end of user data.  If the\nnetwork supporting frame relay can not count\noctets, then this count should be an\napproximation.")
frPVCEndptInDiscardsDESet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInDiscardsDESet.setDescription("The number of frames received by the network\n(ingress) that were discarded with the DE bit set\ndue to traffic enforcement for this PVC end-point.\nCongestion discards are not counted in this\nobject.")
frPVCEndptInFramesFECNSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInFramesFECNSet.setDescription("The number of frames received by the network\n(ingress) that have the FECN bit set for this PVC\nend-point.")
frPVCEndptOutFramesFECNSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutFramesFECNSet.setDescription("The number of frames sent by the network (egress)\nthat have the FECN bit set for this PVC end-\npoint.")
frPVCEndptInFramesBECNSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInFramesBECNSet.setDescription("The number of frames received by the network\n(ingress) that have the BECN bit set for this PVC\nend-point.")
frPVCEndptOutFramesBECNSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutFramesBECNSet.setDescription("The number of frames sent by the network (egress)\nthat have the BECN bit set for this PVC end-\npoint.")
frPVCEndptInCongDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInCongDiscards.setDescription("The number of frames received by the network\n(ingress) that were discarded due to input buffer\ncongestion, rather than traffic enforcement, for\nthis PVC end-point.")
frPVCEndptInDECongDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptInDECongDiscards.setDescription("The number of frames counted by\nfrPVCEndptInCongDiscards with the DE bit set to\n(1).")
frPVCEndptOutCongDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutCongDiscards.setDescription("The number of frames sent by the network (egress)\nthat were discarded due to output buffer\ncongestion for this PVC end-point.")
frPVCEndptOutDECongDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutDECongDiscards.setDescription("The number of frames counted by\nfrPVCEndptOutCongDiscards with the DE bit set to\n(1).")
frPVCEndptOutDEFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptOutDEFrames.setDescription("The number of frames sent by the network (egress)\nwith the DE bit set to (1) for this PVC end-\npoint.")
frPVCEndptAtmIwfConnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 3, 1, 31), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCEndptAtmIwfConnIndex.setDescription("This object contains the index value of the\nFR/ATM cross-connect table entry used to link the\nframe relay PVC with an ATM PVC.\n\nEach row of the frPVCEndptTable that is not\ncross-connected with an ATM PVC must return the\nvalue zero when this object is read.\n\nThe value of this object is initialized by the\nagent after the associated entries in the\nfrAtmIwfConnectionTable have been created.\n\nThe value of this object is reset to zero\nfollowing destruction of the associated entry in\nthe frAtmIwfConnectionTable")
frPVCConnectIndexValue = MibScalar((1, 3, 6, 1, 2, 1, 10, 44, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCConnectIndexValue.setDescription("This object returns a hint to be used for\nfrPVCConnectIndex when creating entries in the\nfrPVCConnectTable.\n\nThe value 0 indicates that no unassigned entries\nare available.\n\nTo obtain the frPVCConnectIndex value for a new\nentry, the manager issues a management protocol\nretrieval operation to obtain the current value of\nthis object.  After each retrieval, the agent must\n\n\nmodify the value to the next unassigned index to\nprevent assignment of the same value to multiple\nmanagement systems.\n\nA management system should repeat the read to\nobtain a new value should an attempt to create the\nnew row using the previously returned hint fail.")
frPVCConnectTable = MibTable((1, 3, 6, 1, 2, 1, 10, 44, 1, 5))
if mibBuilder.loadTexts: frPVCConnectTable.setDescription("The Frame Relay PVC Connect Table is used to\nmodel the bi-directional PVC segment flows\nincluding:  point-to-point PVCs, point-to-\nmultipoint PVCs, and multipoint-to-multipoint\nPVCs.\n\nThis table has read-create access and is used to\nassociate PVC end-points together as belonging to\none connection.  The frPVCConnectIndex is used to\nassociate all the bi-directional flows.  Not all\nimplementations will support the capability of\ncreating/modifying/deleting PVCs using SNMP as a\nfeature of frame relay CNM service.\n\nOnce the entries in the frPVCEndptTable are\ncreated, the following step are used to associate\nthe PVC end-points as belonging to one PVC\nconnection:\n\n1)  Obtain a unique frPVCConnectIndex\n    using the frPVCConnectIndexValue object.\n\n2)  Connect the PVC segment endpoints together\n    with the applicable frPVCConnectIndex value\n    obtained via  frPVCConnectIndexValue.  The\n    entries in this table are created by using\n    the frPVCConnectRowStatus object.\n\n3)  The agent will provide the value of the\n    corresponding instances of\n    frPVCEndptConnectIdentifier with the\n    frPVCConnectIndex value.\n\n4)  Set frPVCConnectAdminStatus to `active(1)' in\n\n\n    all rows for this PVC segment to turn the\n    PVC on.\n\nFor example, the Frame Relay PVC Connection Group\nmodels a bi-directional, point-to-point PVC\nsegment as one entry in this table.\n\nFrame Relay                           Frame Relay\n Network                                 Network\n Low Port                               High Port\n         __________________________________\n        |                                  |\n   _____| >> from low to high PVC flow  >> |_____\n        | << from high to low PVC flow  << |\n        |__________________________________|\n\nThe terms low and high are chosen to represent\nnumerical ordering of a PVC segment's endpoints\nfor representation in this table.  That is, the\nendpoint with the lower value of ifIndex is termed\n'low', while the opposite endpoint of the segment\nis termed 'high'.  This terminology is to provide\ndirectional information; for example the\nfrPVCConnectL2hOperStatus and\nfrPVCConnectH2lOperStatus as illustrated above.\n\nIf the Frame Relay Connection table is used to\nmodel a unidirectional PVC, then one direction\n(either from low to high or from high to low) has\n its Operational Status equal to down.\n\n A PVC segment is a portion of a PVC that traverses\none Frame Relay Network, and a PVC segment is\nidentified by its two end-points (UNI/NNI logical\nport index value and DLCI index value) through one\nFrame Relay Network.")
frPVCConnectEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1)).setIndexNames((0, "FRNETSERV-MIB", "frPVCConnectIndex"), (0, "FRNETSERV-MIB", "frPVCConnectLowIfIndex"), (0, "FRNETSERV-MIB", "frPVCConnectLowDLCIIndex"), (0, "FRNETSERV-MIB", "frPVCConnectHighIfIndex"), (0, "FRNETSERV-MIB", "frPVCConnectHighDLCIIndex"))
if mibBuilder.loadTexts: frPVCConnectEntry.setDescription("An entry in the Frame Relay PVC Connect table.\nThis entry is used to model a PVC segment in two\ndirections.")
frPVCConnectIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frPVCConnectIndex.setDescription("The value of this object is equal to the\nfrPVCConnectIndexValue obtained to uniquely\nidentify this PVC segment connection.")
frPVCConnectLowIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frPVCConnectLowIfIndex.setDescription("The value of this object is equal to IF-MIB\nifIndex value of the UNI/NNI logical port for this\nPVC segment.  The term low implies that this PVC\nsegment end-point has the numerically lower\nifIndex value than the connected/associated PVC\nsegment end-point.\n\nRFC 1604 permitted a zero value for this object to\nidentify termination at a non-frame relay\ninterface.  However, this cross-connect table is\nlimited to frame relay connections.  See the frame\n\n\nrelay/ATM IWF MIB [28] for the cross-connect table\nused for those types of connections.")
frPVCConnectLowDLCIIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(16, 4194303))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frPVCConnectLowDLCIIndex.setDescription("The value of this object is equal to the DLCI\nvalue for this end-point of the PVC segment.")
frPVCConnectHighIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 4), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frPVCConnectHighIfIndex.setDescription("The value of this object is equal to IF-MIB\nifIndex value for the UNI/NNI logical port for\nthis PVC segment.  The term high implies that this\nPVC segment end-point has the numerically higher\nifIndex value than the connected/associated PVC\nsegment end-point.")
frPVCConnectHighDLCIIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(16, 4194303))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frPVCConnectHighDLCIIndex.setDescription("The value of this object is equal to the egress\nDLCI value for this end-point of the PVC segment.")
frPVCConnectAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("inactive", 2), ("testing", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCConnectAdminStatus.setDescription("The value of this object identifies the desired\nadministrative status of this bi-directional PVC\n\n\nsegment.  The active(1) state means the PVC\nsegment is currently operational; the inactive(2)\nstate means the PVC segment is currently not\noperational; the testing(3) state means the PVC\nsegment is currently undergoing a test.  This\nstate is set by an administrative entity.  This\nvalue affects the PVC status indicated across the\ningress NNI/UNI of both end-points of the bi-\ndirectional PVC segment.  When a PVC segment\nconnection is created using this table, this\nobject is initially set to `inactive(2)'.  After\nthe frPVCConnectRowStatus object is set to\n`active(1)' (and the corresponding/associated\nentries in the frPVCEndptTable have their\nfrPVCEndptRowStatus object set to `active(1)'),\nthe frPVCConnectAdminStatus object may be set to\n`active(1)' to turn on the PVC segment\nconnection.")
frPVCConnectL2hOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("inactive", 2), ("testing", 3), ("unknown", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCConnectL2hOperStatus.setDescription("The value of this object identifies the current\noperational status of the PVC segment connection\nin one direction; (i.e., in the low to high\ndirection). This value affects the PVC status\nindicated across the ingress NNI/UNI (low side) of\nthe PVC segment.\n\nThe values mean:\n\nactive(1)   - PVC is currently operational\n\ninactive(2) - PVC is currently not operational.\n              This may be because of an underlying\n              LMI or DS1 failure.\n\ntesting(3)  - PVC is currently undergoing a test.\n              This may be because of an underlying\n              frLport or DS1 undergoing a test.\n\n\nunknown(4)  - the status of the PVC currently can\n              not be determined.")
frPVCConnectH2lOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("inactive", 2), ("testing", 3), ("unknown", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCConnectH2lOperStatus.setDescription("The value of this object identifies the current\noperational status of the PVC segment connection\nin one direction; (i.e., in the high to low\ndirection)..  This value affects the PVC status\nindicated across the ingress NNI/UNI (high side)\nof the PVC segment.\n\nThe values mean:\n\nactive(1)   - PVC is currently operational\n\ninactive(2) - PVC is currently not operational.\n              This may be because of an underlying\n              LMI or DS1 failure.\n\ntesting(3)  - PVC is currently undergoing a test.\n              This may be because of an underlying\n              frLport or DS1 undergoing a test.\n\nunknown(4)  - the status of the PVC currently can\n              not be determined.")
frPVCConnectL2hLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCConnectL2hLastChange.setDescription("The value of the Interface MIB's sysUpTime object\nat the time this PVC segment entered its current\noperational state in the low to high direction.\nIf the current state was entered prior to the last\nre-initialization of the FRS agent, then this\nobject contains a zero value.")
frPVCConnectH2lLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 10), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frPVCConnectH2lLastChange.setDescription("The value of the Interface MIB's sysUpTime object\nat the time this PVC segment entered its current\noperational state in the high to low direction.\nIf the current state was entered prior to the last\nre-initialization of the FRS agent, then this\nobject contains a zero value.")
frPVCConnectRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCConnectRowStatus.setDescription("The status of this entry in the\nfrPVCConnectTable.  This variable is used to\ncreate new connections for the PVC end-points and\nto change existing connections of the PVC end-\npoints.  This object must be initially set to\n`createAndWait(5)'. In this state, the agent\nchecks the parameters in the associated entries in\nthe frPVCEndptTable to verify that the PVC end-\npoints can be connected (i.e., the In parameters\nfor one PVC end-point are equal to the Out\nparameters for the other PVC end-point).  This\nobject can not be set to `active(1)' unless the\nfollowing columnar object exists in this row:\nfrPVCConnectAdminStatus.  The agent also supplies\nthe associated value of frPVCConnectIndex for the\nfrPVCEndptConnectIdentifier instances.  To turn on\na PVC segment connection, the\nfrPVCConnectAdminStatus is set to `active(1)'.")
frPVCConnectUserName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 12), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCConnectUserName.setDescription("This is a service user assigned textual\nrepresentation of a PVC.")
frPVCConnectProviderName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 5, 1, 13), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frPVCConnectProviderName.setDescription("This is a system supplied textual representation\nof PVC.  It is assigned by the service provider.")
frAccountPVCTable = MibTable((1, 3, 6, 1, 2, 1, 10, 44, 1, 6))
if mibBuilder.loadTexts: frAccountPVCTable.setDescription("The Frame Relay Accounting PVC table.  This table\nis used to perform accounting on a PVC segment\nend-point basis.")
frAccountPVCEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 44, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "FRNETSERV-MIB", "frAccountPVCDLCIIndex"))
if mibBuilder.loadTexts: frAccountPVCEntry.setDescription("An entry in the Frame Relay Accounting PVC\ntable.")
frAccountPVCDLCIIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 6, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(16, 4194303))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frAccountPVCDLCIIndex.setDescription("The value of this object is equal to the DLCI\n\n\nvalue for this PVC segment end-point.")
frAccountPVCSegmentSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 6, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frAccountPVCSegmentSize.setDescription("The value of this object is equal to the Segment\nSize for this PVC segment end-point.")
frAccountPVCInSegments = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frAccountPVCInSegments.setDescription("The value of this object is equal to the number\nof segments received by this PVC segment end-\npoint.")
frAccountPVCOutSegments = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frAccountPVCOutSegments.setDescription("The value of this object is equal to the number\nof segments sent by this PVC segment end-point.")
frAccountLportTable = MibTable((1, 3, 6, 1, 2, 1, 10, 44, 1, 7))
if mibBuilder.loadTexts: frAccountLportTable.setDescription("The Frame Relay Accounting Logical Port table.\nThis table is used to perform accounting on a\nUNI/NNI Logical Port basis.")
frAccountLportEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 44, 1, 7, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: frAccountLportEntry.setDescription("An entry in the Frame Relay Accounting Logical\nPort table.")
frAccountLportSegmentSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 7, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frAccountLportSegmentSize.setDescription("The value of this object is equal to the Segment\nSize for this UNI/NNI logical port.")
frAccountLportInSegments = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 7, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frAccountLportInSegments.setDescription("The value of this object is equal to the number\nof segments received by this UNI/NNI logical\nport.")
frAccountLportOutSegments = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 44, 1, 7, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frAccountLportOutSegments.setDescription("The value of this object is equal to the number\n\n\nof segments sent by this UNI/NNI logical port.")
frnetservTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 44, 2))
frnetservTrapsPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 44, 2, 0))
frnetservConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 44, 3))
frnetservGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 44, 3, 1))
frnetservCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 44, 3, 2))

# Augmentions

# Notifications

frPVCConnectStatusNotif = NotificationType((1, 3, 6, 1, 2, 1, 10, 44, 2, 0, 2)).setObjects(("FRNETSERV-MIB", "frPVCConnectH2lOperStatus"), ("FRNETSERV-MIB", "frPVCConnectL2hOperStatus"), ("FRNETSERV-MIB", "frPVCEndptRcvdSigStatus"), )
if mibBuilder.loadTexts: frPVCConnectStatusNotif.setDescription("This notification indicates that the indicated\nPVC has changed state.\n\nThis notification is not sent if an FR-UNI changes\nstate; a linkDown or linkUp notification should be\nsent instead.  The first instance of\nfrPVCEndptRcvdSigStatus is for the endpoint with\nLowIfIndex, LowDLCIIndex.  The second instance of\nfrPVCEndptRcvdSigStatus is for the endpoint with\nHighIfIndex, HighDLCIIndex")
frPVCConnectStatusChange = NotificationType((1, 3, 6, 1, 2, 1, 10, 44, 2, 1)).setObjects(("FRNETSERV-MIB", "frPVCConnectHighDLCIIndex"), ("FRNETSERV-MIB", "frPVCConnectHighIfIndex"), ("FRNETSERV-MIB", "frPVCConnectL2hOperStatus"), ("FRNETSERV-MIB", "frPVCConnectLowIfIndex"), ("FRNETSERV-MIB", "frPVCConnectLowDLCIIndex"), ("FRNETSERV-MIB", "frPVCConnectH2lOperStatus"), ("FRNETSERV-MIB", "frPVCConnectIndex"), ("FRNETSERV-MIB", "frPVCEndptRcvdSigStatus"), )
if mibBuilder.loadTexts: frPVCConnectStatusChange.setDescription("Refer to the description of the\nfrPVCConnectStatusNotif notification that has\nreplaced this notification.  The notification is\ndeprecated due to the incorrect inclusion of index\nvalues and to take advantage of the trap prefix\nfor automatic conversion from SMIv2 to SMIv1 by\nmaking the one but last sub-ID a zero (i.e. the\nso-called trap prefix).")

# Groups

frnetservLportGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 1)).setObjects(("FRNETSERV-MIB", "frLportNumPlan"), ("FRNETSERV-MIB", "frLportType"), ("FRNETSERV-MIB", "frLportLocation"), ("FRNETSERV-MIB", "frLportVCSigPointer"), ("FRNETSERV-MIB", "frLportAddrDLCILen"), ("FRNETSERV-MIB", "frLportVCSigProtocol"), ("FRNETSERV-MIB", "frLportContact"), )
if mibBuilder.loadTexts: frnetservLportGroup.setDescription("A collection of objects providing information\napplicable to a Frame Relay Logical Port.  This\ngroup has been deprecated to eliminate reference\n\n\nto the object frLportVCSigPointer.\n\nUse the new group frnetservLportGroup2 as a\nreplacement for this group.")
frnetservMgtVCSigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 2)).setObjects(("FRNETSERV-MIB", "frMgtVCSigUserLinkRelErrors"), ("FRNETSERV-MIB", "frMgtVCSigUserN391"), ("FRNETSERV-MIB", "frMgtVCSigUserN393"), ("FRNETSERV-MIB", "frMgtVCSigUserN392"), ("FRNETSERV-MIB", "frMgtVCSigNetProtErrors"), ("FRNETSERV-MIB", "frMgtVCSigNetLinkRelErrors"), ("FRNETSERV-MIB", "frMgtVCSigProced"), ("FRNETSERV-MIB", "frMgtVCSigNetN392"), ("FRNETSERV-MIB", "frMgtVCSigNetN393"), ("FRNETSERV-MIB", "frMgtVCSigUserProtErrors"), ("FRNETSERV-MIB", "frMgtVCSigUserChanInactive"), ("FRNETSERV-MIB", "frMgtVCSigNetT392"), ("FRNETSERV-MIB", "frMgtVCSigUserT391"), ("FRNETSERV-MIB", "frMgtVCSigNetChanInactive"), ("FRNETSERV-MIB", "frMgtVCSigNetnT3"), ("FRNETSERV-MIB", "frMgtVCSigNetnN4"), )
if mibBuilder.loadTexts: frnetservMgtVCSigGroup.setDescription("A collection of objects providing information\napplicable to the Local In-Channel Signaling\nProcedures used for a UNI/NNI logical port.")
frnetservPVCEndptGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 3)).setObjects(("FRNETSERV-MIB", "frPVCConnectIndexValue"), ("FRNETSERV-MIB", "frPVCEndptOutOctets"), ("FRNETSERV-MIB", "frPVCEndptOutCIR"), ("FRNETSERV-MIB", "frPVCEndptInMaxFrameSize"), ("FRNETSERV-MIB", "frPVCEndptInCIR"), ("FRNETSERV-MIB", "frPVCEndptInBe"), ("FRNETSERV-MIB", "frPVCEndptOutExcessFrames"), ("FRNETSERV-MIB", "frPVCEndptOutBc"), ("FRNETSERV-MIB", "frPVCEndptOutBe"), ("FRNETSERV-MIB", "frPVCEndptOutFrames"), ("FRNETSERV-MIB", "frPVCEndptInBc"), ("FRNETSERV-MIB", "frPVCEndptConnectIdentifier"), ("FRNETSERV-MIB", "frPVCEndptInExcessFrames"), ("FRNETSERV-MIB", "frPVCEndptInOctets"), ("FRNETSERV-MIB", "frPVCEndptInDiscards"), ("FRNETSERV-MIB", "frPVCEndptInFrames"), ("FRNETSERV-MIB", "frPVCEndptInDEFrames"), ("FRNETSERV-MIB", "frPVCEndptOutMaxFrameSize"), ("FRNETSERV-MIB", "frPVCEndptRowStatus"), ("FRNETSERV-MIB", "frPVCEndptRcvdSigStatus"), )
if mibBuilder.loadTexts: frnetservPVCEndptGroup.setDescription("A collection of objects providing information\napplicable to a Frame Relay PVC end-point.")
frnetservPVCConnectGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 4)).setObjects(("FRNETSERV-MIB", "frPVCConnectRowStatus"), ("FRNETSERV-MIB", "frPVCConnectL2hOperStatus"), ("FRNETSERV-MIB", "frPVCConnectAdminStatus"), ("FRNETSERV-MIB", "frPVCConnectH2lLastChange"), ("FRNETSERV-MIB", "frPVCConnectH2lOperStatus"), ("FRNETSERV-MIB", "frPVCConnectL2hLastChange"), )
if mibBuilder.loadTexts: frnetservPVCConnectGroup.setDescription("A collection of objects providing information\napplicable to a Frame Relay PVC connection.")
frnetservAccountPVCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 5)).setObjects(("FRNETSERV-MIB", "frAccountPVCOutSegments"), ("FRNETSERV-MIB", "frAccountPVCSegmentSize"), ("FRNETSERV-MIB", "frAccountPVCInSegments"), )
if mibBuilder.loadTexts: frnetservAccountPVCGroup.setDescription("A collection of objects providing accounting\ninformation application to a Frame Relay PVC end-\npoint.")
frnetservAccountLportGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 6)).setObjects(("FRNETSERV-MIB", "frAccountLportOutSegments"), ("FRNETSERV-MIB", "frAccountLportInSegments"), ("FRNETSERV-MIB", "frAccountLportSegmentSize"), )
if mibBuilder.loadTexts: frnetservAccountLportGroup.setDescription("A collection of objects providing accounting\ninformation application to a Frame Relay logical\nport.")
frnetservLportGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 7)).setObjects(("FRNETSERV-MIB", "frLportNumPlan"), ("FRNETSERV-MIB", "frLportFragSize"), ("FRNETSERV-MIB", "frLportVCSigProtocol"), ("FRNETSERV-MIB", "frLportFragControl"), ("FRNETSERV-MIB", "frLportType"), ("FRNETSERV-MIB", "frLportLocation"), ("FRNETSERV-MIB", "frLportAddrDLCILen"), ("FRNETSERV-MIB", "frLportContact"), )
if mibBuilder.loadTexts: frnetservLportGroup2.setDescription("A collection of objects providing information\napplicable to a Frame Relay Logical Port.\n\nThis new version of the Logical Port Group\neliminates the frLportVCSigPointer and adds\nsupport for fragmentation.")
frnetservPVCEndptGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 8)).setObjects(("FRNETSERV-MIB", "frPVCEndptOutDECongDiscards"), ("FRNETSERV-MIB", "frPVCEndptInFramesFECNSet"), ("FRNETSERV-MIB", "frPVCEndptInDECongDiscards"), ("FRNETSERV-MIB", "frPVCEndptOutFramesBECNSet"), ("FRNETSERV-MIB", "frPVCEndptInFramesBECNSet"), ("FRNETSERV-MIB", "frPVCEndptInCongDiscards"), ("FRNETSERV-MIB", "frPVCEndptOutFramesFECNSet"), ("FRNETSERV-MIB", "frPVCEndptAtmIwfConnIndex"), ("FRNETSERV-MIB", "frPVCEndptOutDEFrames"), ("FRNETSERV-MIB", "frPVCEndptOutCongDiscards"), ("FRNETSERV-MIB", "frPVCEndptInDiscardsDESet"), )
if mibBuilder.loadTexts: frnetservPVCEndptGroup2.setDescription("Additions to the PVC end-point group.  These\nadditions provide new frame counters to track\nframe loss.  In addition, the new FR/ATM IWF MIB\ncross-connect index is included.")
frnetservPVCConnectNamesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 9)).setObjects(("FRNETSERV-MIB", "frPVCConnectUserName"), ("FRNETSERV-MIB", "frPVCConnectProviderName"), )
if mibBuilder.loadTexts: frnetservPVCConnectNamesGroup.setDescription("Additions to the PVC Connect Group.")
frnetservLportAdminGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 10)).setObjects(("FRNETSERV-MIB", "frLportTypeAdmin"), ("FRNETSERV-MIB", "frLportDLCIIndexValue"), ("FRNETSERV-MIB", "frLportVCSigProtocolAdmin"), )
if mibBuilder.loadTexts: frnetservLportAdminGroup.setDescription("Administrative (R/W) objects for creating a\nswitch logical port.")
frnetservMgtVCSigAdminGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 11)).setObjects(("FRNETSERV-MIB", "frMgtVCSigUserT391Admin"), ("FRNETSERV-MIB", "frMgtVCSigNetN392Admin"), ("FRNETSERV-MIB", "frMgtVCSigProcedAdmin"), ("FRNETSERV-MIB", "frMgtVCSigUserN393Admin"), ("FRNETSERV-MIB", "frMgtVCSigNetnT3Admin"), ("FRNETSERV-MIB", "frMgtVCSigUserN391Admin"), ("FRNETSERV-MIB", "frMgtVCSigUserN392Admin"), ("FRNETSERV-MIB", "frMgtVCSigNetT392Admin"), ("FRNETSERV-MIB", "frMgtVCSigNetN393Admin"), )
if mibBuilder.loadTexts: frnetservMgtVCSigAdminGroup.setDescription("A collection of objects providing information\napplicable to the Local In-Channel Signaling\nProcedures used for a UNI/NNI logical port.")
frnetservPVCNotifGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 12)).setObjects(("FRNETSERV-MIB", "frPVCConnectStatusChange"), )
if mibBuilder.loadTexts: frnetservPVCNotifGroup.setDescription("Deprecated notification group.  The\nfrPVCConnectStatusChange notification was flawed\nbecause it included redundant indexes and was not\nproperly encoded for SMIv1 conversion.")
frnetservPVCNotifGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 44, 3, 1, 13)).setObjects(("FRNETSERV-MIB", "frPVCConnectStatusNotif"), )
if mibBuilder.loadTexts: frnetservPVCNotifGroup2.setDescription("A collection of notifications that apply to frame\nrelay PVC Connections ")

# Compliances

frnetservCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 44, 3, 2, 1)).setObjects(("FRNETSERV-MIB", "frnetservMgtVCSigGroup"), ("FRNETSERV-MIB", "frnetservPVCEndptGroup"), ("FRNETSERV-MIB", "frnetservAccountLportGroup"), ("FRNETSERV-MIB", "frnetservPVCConnectGroup"), ("FRNETSERV-MIB", "frnetservLportGroup"), ("FRNETSERV-MIB", "frnetservAccountPVCGroup"), )
if mibBuilder.loadTexts: frnetservCompliance.setDescription("The compliance statement for SNMP entities which\nhave Frame Relay Network Service Interfaces.\n\nThis compliance statement has been deprecated in\nfavor of frnetservCompliance2.  The new compliance\nmodule expands the mandatory groups to include\nnotification and other new objects.")
frnetservCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 44, 3, 2, 2)).setObjects(("FRNETSERV-MIB", "frnetservMgtVCSigGroup"), ("FRNETSERV-MIB", "frnetservPVCEndptGroup"), ("FRNETSERV-MIB", "frnetservAccountLportGroup"), ("FRNETSERV-MIB", "frnetservAccountPVCGroup"), ("FRNETSERV-MIB", "frnetservPVCEndptGroup2"), ("FRNETSERV-MIB", "frnetservPVCConnectGroup"), ("FRNETSERV-MIB", "frnetservPVCNotifGroup2"), ("FRNETSERV-MIB", "frnetservPVCConnectNamesGroup"), ("FRNETSERV-MIB", "frnetservLportGroup2"), )
if mibBuilder.loadTexts: frnetservCompliance2.setDescription("The compliance statement for SNMP entities which\nhave Frame Relay Network Service Interfaces.\n\nThe distinction between 'service' and 'switch' is\nthat a 'switch' is configured via this MIB.\nHence, the various read/write objects have write\ncapability.  A 'service' represents a passive\nmonitor-only customer network management\ninterface.  The various read/write objects are\nrestricted to read-only capability.")
frnetSwitchCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 44, 3, 2, 3)).setObjects(("FRNETSERV-MIB", "frnetservMgtVCSigGroup"), ("FRNETSERV-MIB", "frnetservAccountLportGroup"), ("FRNETSERV-MIB", "frnetservPVCEndptGroup2"), ("FRNETSERV-MIB", "frnetservPVCConnectGroup"), ("FRNETSERV-MIB", "frnetservPVCNotifGroup2"), ("FRNETSERV-MIB", "frnetservLportGroup2"), ("FRNETSERV-MIB", "frnetservAccountPVCGroup"), ("FRNETSERV-MIB", "frnetservPVCEndptGroup"), ("FRNETSERV-MIB", "frnetservLportAdminGroup"), ("FRNETSERV-MIB", "frnetservMgtVCSigAdminGroup"), ("FRNETSERV-MIB", "frnetservPVCConnectNamesGroup"), )
if mibBuilder.loadTexts: frnetSwitchCompliance.setDescription("The compliance statement for SNMP entities which\nhave Frame Relay Network Switch objects.\n\nThe distinction between 'service' and 'switch' is\nthat a 'switch' is configured via this MIB.\n\n\nHence, the various read/write objects have write\ncapability.  A 'service' represents a passive\nmonitor-only customer network management\ninterface.  The various read/write objects are\nrestricted to read-only capability.")

# Exports

# Module identity
mibBuilder.exportSymbols("FRNETSERV-MIB", PYSNMP_MODULE_ID=frnetservMIB)

# Objects
mibBuilder.exportSymbols("FRNETSERV-MIB", frnetservMIB=frnetservMIB, frnetservObjects=frnetservObjects, frLportTable=frLportTable, frLportEntry=frLportEntry, frLportNumPlan=frLportNumPlan, frLportContact=frLportContact, frLportLocation=frLportLocation, frLportType=frLportType, frLportAddrDLCILen=frLportAddrDLCILen, frLportVCSigProtocol=frLportVCSigProtocol, frLportVCSigPointer=frLportVCSigPointer, frLportDLCIIndexValue=frLportDLCIIndexValue, frLportTypeAdmin=frLportTypeAdmin, frLportVCSigProtocolAdmin=frLportVCSigProtocolAdmin, frLportFragControl=frLportFragControl, frLportFragSize=frLportFragSize, frMgtVCSigTable=frMgtVCSigTable, frMgtVCSigEntry=frMgtVCSigEntry, frMgtVCSigProced=frMgtVCSigProced, frMgtVCSigUserN391=frMgtVCSigUserN391, frMgtVCSigUserN392=frMgtVCSigUserN392, frMgtVCSigUserN393=frMgtVCSigUserN393, frMgtVCSigUserT391=frMgtVCSigUserT391, frMgtVCSigNetN392=frMgtVCSigNetN392, frMgtVCSigNetN393=frMgtVCSigNetN393, frMgtVCSigNetT392=frMgtVCSigNetT392, frMgtVCSigNetnN4=frMgtVCSigNetnN4, frMgtVCSigNetnT3=frMgtVCSigNetnT3, frMgtVCSigUserLinkRelErrors=frMgtVCSigUserLinkRelErrors, frMgtVCSigUserProtErrors=frMgtVCSigUserProtErrors, frMgtVCSigUserChanInactive=frMgtVCSigUserChanInactive, frMgtVCSigNetLinkRelErrors=frMgtVCSigNetLinkRelErrors, frMgtVCSigNetProtErrors=frMgtVCSigNetProtErrors, frMgtVCSigNetChanInactive=frMgtVCSigNetChanInactive, frMgtVCSigProcedAdmin=frMgtVCSigProcedAdmin, frMgtVCSigUserN391Admin=frMgtVCSigUserN391Admin, frMgtVCSigUserN392Admin=frMgtVCSigUserN392Admin, frMgtVCSigUserN393Admin=frMgtVCSigUserN393Admin, frMgtVCSigUserT391Admin=frMgtVCSigUserT391Admin, frMgtVCSigNetN392Admin=frMgtVCSigNetN392Admin, frMgtVCSigNetN393Admin=frMgtVCSigNetN393Admin, frMgtVCSigNetT392Admin=frMgtVCSigNetT392Admin, frMgtVCSigNetnT3Admin=frMgtVCSigNetnT3Admin, frPVCEndptTable=frPVCEndptTable, frPVCEndptEntry=frPVCEndptEntry, frPVCEndptDLCIIndex=frPVCEndptDLCIIndex, frPVCEndptInMaxFrameSize=frPVCEndptInMaxFrameSize, frPVCEndptInBc=frPVCEndptInBc, frPVCEndptInBe=frPVCEndptInBe, frPVCEndptInCIR=frPVCEndptInCIR, frPVCEndptOutMaxFrameSize=frPVCEndptOutMaxFrameSize, frPVCEndptOutBc=frPVCEndptOutBc, frPVCEndptOutBe=frPVCEndptOutBe, frPVCEndptOutCIR=frPVCEndptOutCIR, frPVCEndptConnectIdentifier=frPVCEndptConnectIdentifier, frPVCEndptRowStatus=frPVCEndptRowStatus, frPVCEndptRcvdSigStatus=frPVCEndptRcvdSigStatus, frPVCEndptInFrames=frPVCEndptInFrames, frPVCEndptOutFrames=frPVCEndptOutFrames, frPVCEndptInDEFrames=frPVCEndptInDEFrames, frPVCEndptInExcessFrames=frPVCEndptInExcessFrames, frPVCEndptOutExcessFrames=frPVCEndptOutExcessFrames, frPVCEndptInDiscards=frPVCEndptInDiscards, frPVCEndptInOctets=frPVCEndptInOctets, frPVCEndptOutOctets=frPVCEndptOutOctets, frPVCEndptInDiscardsDESet=frPVCEndptInDiscardsDESet, frPVCEndptInFramesFECNSet=frPVCEndptInFramesFECNSet, frPVCEndptOutFramesFECNSet=frPVCEndptOutFramesFECNSet, frPVCEndptInFramesBECNSet=frPVCEndptInFramesBECNSet, frPVCEndptOutFramesBECNSet=frPVCEndptOutFramesBECNSet, frPVCEndptInCongDiscards=frPVCEndptInCongDiscards, frPVCEndptInDECongDiscards=frPVCEndptInDECongDiscards, frPVCEndptOutCongDiscards=frPVCEndptOutCongDiscards, frPVCEndptOutDECongDiscards=frPVCEndptOutDECongDiscards, frPVCEndptOutDEFrames=frPVCEndptOutDEFrames, frPVCEndptAtmIwfConnIndex=frPVCEndptAtmIwfConnIndex, frPVCConnectIndexValue=frPVCConnectIndexValue, frPVCConnectTable=frPVCConnectTable, frPVCConnectEntry=frPVCConnectEntry, frPVCConnectIndex=frPVCConnectIndex, frPVCConnectLowIfIndex=frPVCConnectLowIfIndex, frPVCConnectLowDLCIIndex=frPVCConnectLowDLCIIndex, frPVCConnectHighIfIndex=frPVCConnectHighIfIndex, frPVCConnectHighDLCIIndex=frPVCConnectHighDLCIIndex, frPVCConnectAdminStatus=frPVCConnectAdminStatus, frPVCConnectL2hOperStatus=frPVCConnectL2hOperStatus, frPVCConnectH2lOperStatus=frPVCConnectH2lOperStatus, frPVCConnectL2hLastChange=frPVCConnectL2hLastChange, frPVCConnectH2lLastChange=frPVCConnectH2lLastChange, frPVCConnectRowStatus=frPVCConnectRowStatus, frPVCConnectUserName=frPVCConnectUserName, frPVCConnectProviderName=frPVCConnectProviderName, frAccountPVCTable=frAccountPVCTable, frAccountPVCEntry=frAccountPVCEntry, frAccountPVCDLCIIndex=frAccountPVCDLCIIndex, frAccountPVCSegmentSize=frAccountPVCSegmentSize, frAccountPVCInSegments=frAccountPVCInSegments, frAccountPVCOutSegments=frAccountPVCOutSegments, frAccountLportTable=frAccountLportTable, frAccountLportEntry=frAccountLportEntry, frAccountLportSegmentSize=frAccountLportSegmentSize, frAccountLportInSegments=frAccountLportInSegments, frAccountLportOutSegments=frAccountLportOutSegments, frnetservTraps=frnetservTraps, frnetservTrapsPrefix=frnetservTrapsPrefix, frnetservConformance=frnetservConformance, frnetservGroups=frnetservGroups, frnetservCompliances=frnetservCompliances)

# Notifications
mibBuilder.exportSymbols("FRNETSERV-MIB", frPVCConnectStatusNotif=frPVCConnectStatusNotif, frPVCConnectStatusChange=frPVCConnectStatusChange)

# Groups
mibBuilder.exportSymbols("FRNETSERV-MIB", frnetservLportGroup=frnetservLportGroup, frnetservMgtVCSigGroup=frnetservMgtVCSigGroup, frnetservPVCEndptGroup=frnetservPVCEndptGroup, frnetservPVCConnectGroup=frnetservPVCConnectGroup, frnetservAccountPVCGroup=frnetservAccountPVCGroup, frnetservAccountLportGroup=frnetservAccountLportGroup, frnetservLportGroup2=frnetservLportGroup2, frnetservPVCEndptGroup2=frnetservPVCEndptGroup2, frnetservPVCConnectNamesGroup=frnetservPVCConnectNamesGroup, frnetservLportAdminGroup=frnetservLportAdminGroup, frnetservMgtVCSigAdminGroup=frnetservMgtVCSigAdminGroup, frnetservPVCNotifGroup=frnetservPVCNotifGroup, frnetservPVCNotifGroup2=frnetservPVCNotifGroup2)

# Compliances
mibBuilder.exportSymbols("FRNETSERV-MIB", frnetservCompliance=frnetservCompliance, frnetservCompliance2=frnetservCompliance2, frnetSwitchCompliance=frnetSwitchCompliance)
