# PySNMP SMI module. Autogenerated from smidump -f python FRSLD-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:30 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( DLCI, ) = mibBuilder.importSymbols("FRAME-RELAY-DTE-MIB", "DLCI")
( CounterBasedGauge64, ) = mibBuilder.importSymbols("HCNUM-TC", "CounterBasedGauge64")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( RowStatus, TextualConvention, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp")

# Types

class FrsldRxRP(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(4,11,9,1,5,2,6,8,10,12,3,7,)
    namedValues = namedval.NamedValues(("desLocalRP", 1), ("eqiRxRemoteRP", 10), ("eqoRxRemoteRP", 11), ("otherRxRemoteRP", 12), ("ingRxLocalRP", 2), ("tpRxLocalRP", 3), ("eqiRxLocalRP", 4), ("eqoRxLocalRP", 5), ("otherRxLocalRP", 6), ("desRemoteRP", 7), ("ingRxRemoteRP", 8), ("tpRxRemoteRP", 9), )
    
class FrsldTxRP(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(6,5,12,10,3,4,11,1,9,7,2,8,)
    namedValues = namedval.NamedValues(("srcLocalRP", 1), ("eqiTxRemoteRP", 10), ("eqoTxRemoteRP", 11), ("otherTxRemoteRP", 12), ("ingTxLocalRP", 2), ("tpTxLocalRP", 3), ("eqiTxLocalRP", 4), ("eqoTxLocalRP", 5), ("otherTxLocalRP", 6), ("srcRemoteRP", 7), ("ingTxRemoteRP", 8), ("tpTxRemoteRP", 9), )
    

# Objects

frsldMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 95)).setRevisions(("2002-01-03 00:00",))
if mibBuilder.loadTexts: frsldMIB.setOrganization("IETF Frame Relay Service MIB Working Group")
if mibBuilder.loadTexts: frsldMIB.setContactInfo("IETF Frame Relay Service MIB (frnetmib) Working Group\n\nWG Charter:    http://www.ietf.org/html.charters/\n                      frnetmib-charter.html\nWG-email:      frnetmib@sunroof.eng.sun.com\nSubscribe:     frnetmib-request@sunroof.eng.sun.com\nEmail Archive: ftp://ftp.ietf.org/ietf-mail-archive/frnetmib\n\n\nChair:      Andy Malis\n            Vivace Networks\nEmail:      Andy.Malis@vivacenetworks.com\n\nWG editor:  Robert Steinberger\n            Paradyne Networks and\n            Fujitsu Network Communications\nEmail:      robert.steinberger@fnc.fujitsu.com\n\nCo-author:  Orly Nicklass\n            RAD Data Communications Ltd.\nEMail:      Orly_n@rad.co.il")
if mibBuilder.loadTexts: frsldMIB.setDescription("The MIB module to describe generic objects for\nFRF.13 Frame Relay Service Level Definitions.")
frsldObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 95, 1))
frsldPvcCtrlTable = MibTable((1, 3, 6, 1, 2, 1, 95, 1, 1))
if mibBuilder.loadTexts: frsldPvcCtrlTable.setDescription("The Frame Relay Service Level Definitions\nPVC control table.")
frsldPvcCtrlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 95, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "FRSLD-MIB", "frsldPvcCtrlDlci"), (0, "FRSLD-MIB", "frsldPvcCtrlTransmitRP"), (0, "FRSLD-MIB", "frsldPvcCtrlReceiveRP"))
if mibBuilder.loadTexts: frsldPvcCtrlEntry.setDescription("An entry in the Frame Relay Service Level\nDefinitions PVC control table.")
frsldPvcCtrlDlci = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 1), DLCI()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frsldPvcCtrlDlci.setDescription("The value of this object is equal to the DLCI\nvalue for this PVC.")
frsldPvcCtrlTransmitRP = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 2), FrsldTxRP()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frsldPvcCtrlTransmitRP.setDescription("The reference point this PVC uses for calculation\nof transmitter related statistics.  This object\ntogether with frsldPvcCtrlReceiveRP define the\nmeasurement domain.")
frsldPvcCtrlReceiveRP = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 3), FrsldRxRP()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frsldPvcCtrlReceiveRP.setDescription("The reference point this PVC uses for calculation\nof receiver related statistics.  This object\ntogether with frsldPvcCtrlTransmitRP define the\nmeasurement domain.")
frsldPvcCtrlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlStatus.setDescription("The status of the current row.  This object is\nused to add, delete, and disable rows in this\ntable.  When the status changes to active(1) for the\nfirst time, a row will also be added to the data\ntable below.  This row SHOULD not be removed until\nthe status is changed to deleted.\n\nWhen this object is set to destroy(6), all associated\nsample and data table rows will also be deleted.\nWhen this object is changed from active(1) to any\nother valid value, the defined purge behavior will\naffect the data and sample tables.\n\nThe rows added to this table MUST have a valid\nifIndex and an ifType related to frame relay.  Further,\nthe reference points referred to by frsldPvcCtrlTransmitRP\nand frsldPvcCtrlReceiveRP MUST be supported (see the\nfrsldRPCaps object).\n\nIf at any point the row is not in the active(1) state\nand the DLCI no longer exists, the state SHOULD\nreport notReady(3).\n\nThe data in this table SHOULD persist through power\ncycles.  The symantics of readiness for the rows still\napplies.  This means that it is possible for a row to be\nreprovisioned as notReady(3) if the underlying DLCI does\nnot persist.")
frsldPvcCtrlPacketFreq = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlPacketFreq.setDescription("The frequency in seconds between initiation of\nspecialized packets used to collect delay and / or\ndelivery information as supported by the device.\nA value of zero indicates that no packets will\nbe sent.")
frsldPvcCtrlDelayFrSize = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 8188)).clone(128)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlDelayFrSize.setDescription("The size of the payload in the frame used for\ncalculation of network delay.")
frsldPvcCtrlDelayType = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("oneWay", 1), ("roundTrip", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlDelayType.setDescription("The type of delay measurement performed.")
frsldPvcCtrlDelayTimeOut = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 3600)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlDelayTimeOut.setDescription("A delay frame will count as a missed poll if\nit is not updated in the time specified by\nfrsldPvcCtrlDelayTimeOut.")
frsldPvcCtrlPurge = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 172800)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlPurge.setDescription("This object defines the amount of time the device\nwill wait, after discovering that a DLCI does not exist,\nthe DLCI was deleted or the value of frsldPvcCtrlStatus\nchanges from active(1) to either notInService(2) or\nnotReady(3), prior to automatically purging the history\nin the sample tables and resetting the data in the data\ntables to all zeroes.  If frsldPvcCtrlStatus is manually\nset to destroy(6), this object does not apply.")
frsldPvcCtrlDeleteOnPurge = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("sampleContols", 2), ("all", 3), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldPvcCtrlDeleteOnPurge.setDescription("This object defines whether rows will\nautomatically be deleted from the tables\nwhen the information is purged.\n\n- A value of none(1) indicates that no rows\n  will deleted.  The last known values will\n  be preserved.\n- A value of sampleControls(2) indicates\n  that all associated sample control rows\n  will be deleted.\n- A value of all(3) indicates that all\n  associated rows SHOULD be deleted.")
frsldPvcCtrlLastPurgeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 1, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcCtrlLastPurgeTime.setDescription("This object returns the value of sysUpTime\nat the time the information was last purged.\nThis value SHOULD be set to the sysUpTime\nupon setting frsldPvcCtrlStatus to active(1)\nfor the first time.  Each time a\ndiscontinuity in the counters occurs, this\nvalue MUST be set to the sysUpTime.\n\nIf frsldPvcCtrlStatus has never been active(1),\nthis object SHOULD return 0.\n\nThis object SHOULD be used as the discontinuity\ntimer for the counters in frsldPvcDataTable.")
frsldSmplCtrlTable = MibTable((1, 3, 6, 1, 2, 1, 95, 1, 2))
if mibBuilder.loadTexts: frsldSmplCtrlTable.setDescription("The Frame Relay Service Level Definitions\nsampling control table.")
frsldSmplCtrlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 95, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "FRSLD-MIB", "frsldPvcCtrlDlci"), (0, "FRSLD-MIB", "frsldPvcCtrlTransmitRP"), (0, "FRSLD-MIB", "frsldPvcCtrlReceiveRP"), (0, "FRSLD-MIB", "frsldSmplCtrlIdx"))
if mibBuilder.loadTexts: frsldSmplCtrlEntry.setDescription("An entry in the Frame Relay Service Level\nDefinitions sample control table.")
frsldSmplCtrlIdx = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 256))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frsldSmplCtrlIdx.setDescription("The unique index for this row in the\nsample control table.")
frsldSmplCtrlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 2, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldSmplCtrlStatus.setDescription("The status of the current row.  This object is\nused to add, delete, and disable rows in this\ntable.  This row SHOULD NOT be removed until the\nstatus is changed to destroy(6).  When the status\nchanges to active(1), the collection in the sample\ntables below will be activated.\n\nThe rows added to this table MUST have a valid\nifIndex, an ifType related to frame relay,\nfrsldPvcCtrlDlci MUST exist for the specified\nifIndex and frsldPvcCtrlStatus MUST have a\nvalue of active(1).\n\nThe value of frsldPvcCtrlStatus MUST be active(1)\nto transition this object to active(1).  If\nthe value of frsldPvcCtrlStatus becomes anything\nother than active(1) when the state of this object\nis not active(1), this object SHOULD be set to\nnotReady(3).\n\nThe data in this table SHOULD persist through power\ncycles.  The symantics of readiness for the rows still\napplies.  This means that it is possible for a row to be\nreprovisioned as notReady(3) if the underlying DLCI does\nnot persist.")
frsldSmplCtrlColPeriod = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldSmplCtrlColPeriod.setDescription("The amount of time in seconds that defines a\nperiod of collection for the statistics.\nAt the end of each period, the statistics will be\nsampled and a row is added to the sample table.")
frsldSmplCtrlBuckets = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frsldSmplCtrlBuckets.setDescription("The number of discrete buckets over which the\ndata statistics are sampled.\n\nWhen this object is created or modified, the device\nSHOULD attempt to set the frsldSmplCtrlBuckets-\nGranted to a value as close as is possible\ndepending upon the implementation and the available\nresources.")
frsldSmplCtrlBucketsGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldSmplCtrlBucketsGranted.setDescription("The number of discrete buckets granted.  This\nobject will return 0 until frsldSmplCtrlStatus is\nset to active(1).  At that time the buckets will be\nallocated depending upon implementation and\navailable resources.")
frsldPvcDataTable = MibTable((1, 3, 6, 1, 2, 1, 95, 1, 3))
if mibBuilder.loadTexts: frsldPvcDataTable.setDescription("The Frame Relay Service Level Definitions\ndata table.\n\nThis table contains accumulated values of the\ncollected data.  It is the table that should be\nreferenced by external polling mechanisms if\ntime based polling be desired.")
frsldPvcDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 95, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "FRSLD-MIB", "frsldPvcCtrlDlci"), (0, "FRSLD-MIB", "frsldPvcCtrlTransmitRP"), (0, "FRSLD-MIB", "frsldPvcCtrlReceiveRP"))
if mibBuilder.loadTexts: frsldPvcDataEntry.setDescription("An entry in the Frame Relay Service Level\nDefinitions data table.")
frsldPvcDataMissedPolls = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataMissedPolls.setDescription("The total number of polls that have been determined\nto be missed.  These polls are typically associated\nwith the calculation of delay but may also be\nused for the calculation of other statistics.  If an\nanticipated poll is not received in a reasonable\namount of time, it should be counted as missed.\nThe value used to determine the reasonable amount\nof time is contained in frsldPvcCtrlDelayTimeOut.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\n\n\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataFrDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataFrDeliveredC.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataFrDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataFrDeliveredE.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent in excess of the CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataFrOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataFrOfferedC.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP within CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\n\n\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataFrOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataFrOfferedE.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataDataDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataDataDeliveredC.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataDataDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataDataDeliveredE.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent in excess of the CIR.\n\nDiscontinuities in the value of this counter can\n\n\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataDataOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataDataOfferedC.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP within CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataDataOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataDataOfferedE.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCFrDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCFrDeliveredC.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR.  This object is a 64-bit version\nof frsldPvcDataFrDeliveredC.\n\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCFrDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 11), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCFrDeliveredE.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent in excess of the CIR.  This object is a 64-bit\nversion of frsldPvcDataFrDeliveredE.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCFrOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCFrOfferedC.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP within CIR.  This object is\na 64-bit version of frsldPvcDataFrOfferedC.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCFrOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCFrOfferedE.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR.  This\nobject is a 64-bit version of frsldPvcDataFrOfferedE.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCDataDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 14), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCDataDeliveredC.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR.  This object is a 64-bit version of\nfrsldPvcDataDataDeliveredC.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCDataDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 15), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCDataDeliveredE.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent in excess of the CIR.  This object is a 64-bit\nversion of frsldPvcDataDataDeliveredE.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCDataOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 16), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCDataOfferedC.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP within CIR.  This object is\na 64-bit version of frsldPvcDataDataOfferedC.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataHCDataOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 17), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataHCDataOfferedE.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR.\nThis object is a 64-bit version of\nfrsldPvcDataDataOfferedE.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcDataUnavailableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 18), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataUnavailableTime.setDescription("The amount of time this PVC was declared unavailable\nfor any reason since this row was created.")
frsldPvcDataUnavailables = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcDataUnavailables.setDescription("The number of times this PVC was declared unavailable\nfor any reason since this row was created.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system\nand at other times as indicated by\nfrsldPvcCtrlLastPurgeTime.")
frsldPvcSampleTable = MibTable((1, 3, 6, 1, 2, 1, 95, 1, 4))
if mibBuilder.loadTexts: frsldPvcSampleTable.setDescription("The Frame Relay Service Level Definitions\nsample table.")
frsldPvcSampleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 95, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "FRSLD-MIB", "frsldPvcCtrlDlci"), (0, "FRSLD-MIB", "frsldPvcCtrlTransmitRP"), (0, "FRSLD-MIB", "frsldPvcCtrlReceiveRP"), (0, "FRSLD-MIB", "frsldSmplCtrlIdx"), (0, "FRSLD-MIB", "frsldPvcSmplIdx"))
if mibBuilder.loadTexts: frsldPvcSampleEntry.setDescription("An entry in the Frame Relay Service Level\nDefinitions data sample table.")
frsldPvcSmplIdx = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: frsldPvcSmplIdx.setDescription("The bucket index of the current sample.  This\nincrements once for each new bucket in the\ntable.")
frsldPvcSmplDelayMin = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDelayMin.setDescription("The minimum delay reported in microseconds measured\nfor any information packet that arrived during this\ninterval.\n\nA value of zero means that no data is available.")
frsldPvcSmplDelayMax = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDelayMax.setDescription("The largest delay reported in microseconds measured\nfor any information packet that arrived during this\ninterval.\n\nA value of zero means that no data is available.")
frsldPvcSmplDelayAvg = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDelayAvg.setDescription("The average delay reported in microseconds measured\nfor all delay packets that arrived during this\ninterval.\n\nA value of zero means that no data is available.")
frsldPvcSmplMissedPolls = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplMissedPolls.setDescription("The total number of polls that were missed during\nthis interval.")
frsldPvcSmplFrDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplFrDeliveredC.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR during this interval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\n\n\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCFrDeliveredC.")
frsldPvcSmplFrDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplFrDeliveredE.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent in excess of the CIR during this interval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCFrDeliveredE.")
frsldPvcSmplFrOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplFrOfferedC.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP within CIR during this\ninterval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCFrOfferedC.")
frsldPvcSmplFrOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 9), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplFrOfferedE.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR\nduring this interval.\n\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCFrOfferedE.")
frsldPvcSmplDataDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDataDeliveredC.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR during this interval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCDataDeliveredC.")
frsldPvcSmplDataDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDataDeliveredE.setDescription("The number of octets that were received at\nfrsldPvcCtrlDeliveredRP and determined to have been\nsent in excess of the CIR during this interval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCDataDeliveredE.")
frsldPvcSmplDataOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDataOfferedC.setDescription("The number of octets that were offered through\n\n\nfrsldPvcCtrlTransmitRP within CIR during this\ninterval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCDataOfferredC.")
frsldPvcSmplDataOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplDataOfferedE.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR\nduring this interval.\n\nIf it is the case that the high capacity counters\nare also used, this MUST report the value of the\nlower 32 bits of the CounterBasedGauge64 value of\nfrsldPvcSmplHCDataOfferedE.")
frsldPvcSmplHCFrDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 14), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCFrDeliveredC.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR during this interval.  This object\nis a 64-bit version of frsldPvcSmplFrDeliveredC.")
frsldPvcSmplHCFrDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 15), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCFrDeliveredE.setDescription("The number of frames that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\n\n\nsent in excess of the CIR during this interval.\nThis object is a 64-bit version of frsldPvcSmpl-\nFrDeliveredE.")
frsldPvcSmplHCFrOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 16), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCFrOfferedC.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP within CIR during this\ninterval.  This object is a 64-bit version of\nfrsldPvcSmplFrOfferedC.")
frsldPvcSmplHCFrOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 17), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCFrOfferedE.setDescription("The number of frames that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR\nduring this interval.  This object is a 64-bit\nversion of frsldPvcSmplFrOfferedE.")
frsldPvcSmplHCDataDeliveredC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 18), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCDataDeliveredC.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent within CIR during this interval.  This value\nis a 64-bit version of frsldPvcSmplDataDeliveredC.")
frsldPvcSmplHCDataDeliveredE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 19), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCDataDeliveredE.setDescription("The number of octets that were received at\nfrsldPvcCtrlReceiveRP and determined to have been\nsent in excess of the CIR during this interval.  This\nvalue is a 64-bit version of frsldPvcSmplData-\nDeliveredE.")
frsldPvcSmplHCDataOfferedC = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 20), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCDataOfferedC.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP within CIR during this\ninterval.  This value is a 64-bit version of\nfrsldPvcSmplDataOfferedC.")
frsldPvcSmplHCDataOfferedE = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 21), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplHCDataOfferedE.setDescription("The number of octets that were offered through\nfrsldPvcCtrlTransmitRP in excess of the CIR\nduring this interval.  This object is a 64-bit\nversion of frsldPvcSmplDataOfferedE.")
frsldPvcSmplUnavailableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 22), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplUnavailableTime.setDescription("The amount of time this PVC was declared\nunavailable for any reason during this interval.")
frsldPvcSmplUnavailables = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 23), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplUnavailables.setDescription("The number of times this PVC was declared\nunavailable for any reason during this interval.")
frsldPvcSmplStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 24), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplStartTime.setDescription("The value of sysUpTime when this sample interval\nstarted.")
frsldPvcSmplEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 95, 1, 4, 1, 25), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcSmplEndTime.setDescription("The value of sysUpTime when this sample interval\nended.  No data will be reported and the row will\nnot appear in the table until the sample has\nbeen collected.")
frsldCapabilities = MibIdentifier((1, 3, 6, 1, 2, 1, 95, 2))
frsldPvcCtrlWriteCaps = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 1), Bits().subtype(namedValues=namedval.NamedValues(("frsldPvcCtrlStatus", 0), ("frsldPvcCtrlPacketFreq", 1), ("frsldPvcCtrlDelayFrSize", 2), ("frsldPvcCtrlDelayType", 3), ("frsldPvcCtrlDelayTimeOut", 4), ("frsldPvcCtrlPurge", 5), ("frsldPvcCtrlDeleteOnPurge", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldPvcCtrlWriteCaps.setDescription("This object specifies the write capabilities\nfor the read-create objects of the PVC Control\ntable.  If the corresponding bit is enabled (1),\nthe agent supports writes to that object.")
frsldSmplCtrlWriteCaps = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 2), Bits().subtype(namedValues=namedval.NamedValues(("frsldSmplCtrlStatus", 0), ("frsldSmplCtrlBuckets", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldSmplCtrlWriteCaps.setDescription("This object specifies the write capabilities\nfor the read-create objects of the Sample Control\ntable.  If the corresponding bit is enabled (1),\nthe agent supports writes to that object.")
frsldRPCaps = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 3), Bits().subtype(namedValues=namedval.NamedValues(("srcLocalRP", 0), ("ingTxLocalRP", 1), ("eqoTxRemoteRP", 10), ("otherTxRemoteRP", 11), ("desLocalRP", 12), ("ingRxLocalRP", 13), ("tpRxLocalRP", 14), ("eqiRxLocalRP", 15), ("eqoRxLocalRP", 16), ("otherRxLocalRP", 17), ("desRemoteRP", 18), ("ingRxRemoteRP", 19), ("tpTxLocalRP", 2), ("tpRxRemoteRP", 20), ("eqiRxRemoteRP", 21), ("eqoRxRemoteRP", 22), ("otherRxRemoteRP", 23), ("eqiTxLocalRP", 3), ("eqoTxLocalRP", 4), ("otherTxLocalRP", 5), ("srcRemoteRP", 6), ("ingTxRemoteRP", 7), ("tpTxRemoteRP", 8), ("eqiTxRemoteRP", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldRPCaps.setDescription("This object specifies the reference points that\nthe agent supports.  This object allows the management\napplication to discover which rows can be created on\na specific device.")
frsldMaxPvcCtrls = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frsldMaxPvcCtrls.setDescription("The maximum number of control rows that can be created\nin frsldPvcCtrlTable.  Sets to this object lower than\nthe current value of frsldNumPvcCtrls should result in\ninconsistentValue.")
frsldNumPvcCtrls = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldNumPvcCtrls.setDescription("The current number of rows in frsldPvcCtrlTable.")
frsldMaxSmplCtrls = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frsldMaxSmplCtrls.setDescription("The maximum number of control rows that can be created\nin frsldSmplCtrlTable.  Sets to this object lower than\nthe current value of frsldNumSmplCtrls should result in\ninconsistentValue.")
frsldNumSmplCtrls = MibScalar((1, 3, 6, 1, 2, 1, 95, 2, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frsldNumSmplCtrls.setDescription("The current number of rows in frsldSmplCtrlTable.")
frsldConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 95, 3))
frsldMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 95, 3, 1))
frsldMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 95, 3, 2))

# Augmentions

# Groups

frsldPvcReqCtrlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 1)).setObjects(("FRSLD-MIB", "frsldPvcCtrlLastPurgeTime"), ("FRSLD-MIB", "frsldPvcCtrlDeleteOnPurge"), ("FRSLD-MIB", "frsldPvcCtrlPurge"), ("FRSLD-MIB", "frsldPvcCtrlStatus"), )
if mibBuilder.loadTexts: frsldPvcReqCtrlGroup.setDescription("A collection of required objects providing\ncontrol information applicable to a PVC which\nimplements Service Level Definitions.")
frsldPvcPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 2)).setObjects(("FRSLD-MIB", "frsldPvcCtrlPacketFreq"), )
if mibBuilder.loadTexts: frsldPvcPacketGroup.setDescription("A collection of optional objects providing packet\nlevel control information applicable to a PVC which\nimplements Service Level Definitions.")
frsldPvcDelayCtrlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 3)).setObjects(("FRSLD-MIB", "frsldPvcCtrlDelayTimeOut"), ("FRSLD-MIB", "frsldPvcCtrlDelayFrSize"), ("FRSLD-MIB", "frsldPvcCtrlDelayType"), )
if mibBuilder.loadTexts: frsldPvcDelayCtrlGroup.setDescription("A collection of optional objects providing delay\ncontrol information applicable to a PVC which\nimplements Service Level Definitions.\n\nIf this group is implemented, frsldPvcPacketGroup\nand frsldPvcDelayDataGroup MUST also be implemented.")
frsldPvcSampleCtrlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 4)).setObjects(("FRSLD-MIB", "frsldSmplCtrlStatus"), ("FRSLD-MIB", "frsldSmplCtrlColPeriod"), ("FRSLD-MIB", "frsldSmplCtrlBuckets"), ("FRSLD-MIB", "frsldSmplCtrlBucketsGranted"), )
if mibBuilder.loadTexts: frsldPvcSampleCtrlGroup.setDescription("A collection of optional objects providing sample\ncontrol information applicable to a PVC which\nimplements Service Level Definitions.\n\nIf this group is implemented, frsldPvcReqDataGroup\nand frsldPvcSampleGeneralGroup MUST also be\nimplemented.")
frsldPvcReqDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 5)).setObjects(("FRSLD-MIB", "frsldPvcDataFrOfferedE"), ("FRSLD-MIB", "frsldPvcDataFrDeliveredE"), ("FRSLD-MIB", "frsldPvcDataDataDeliveredE"), ("FRSLD-MIB", "frsldPvcDataDataDeliveredC"), ("FRSLD-MIB", "frsldPvcDataFrOfferedC"), ("FRSLD-MIB", "frsldPvcDataFrDeliveredC"), ("FRSLD-MIB", "frsldPvcDataDataOfferedC"), ("FRSLD-MIB", "frsldPvcDataUnavailables"), ("FRSLD-MIB", "frsldPvcDataDataOfferedE"), ("FRSLD-MIB", "frsldPvcDataUnavailableTime"), )
if mibBuilder.loadTexts: frsldPvcReqDataGroup.setDescription("A collection of required objects providing data\ncollected on a PVC which implements Service\nLevel Definitions.")
frsldPvcDelayDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 6)).setObjects(("FRSLD-MIB", "frsldPvcDataMissedPolls"), )
if mibBuilder.loadTexts: frsldPvcDelayDataGroup.setDescription("A collection of optional objects providing delay\ndata collected on a PVC which implements Service\nLevel Definitions.\n\nIf this group is implemented, frsldPvcDelayCtrlGroup\nMUST also be implemented.")
frsldPvcHCFrameDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 7)).setObjects(("FRSLD-MIB", "frsldPvcDataHCFrDeliveredC"), ("FRSLD-MIB", "frsldPvcDataHCFrOfferedC"), ("FRSLD-MIB", "frsldPvcDataHCFrDeliveredE"), ("FRSLD-MIB", "frsldPvcDataHCFrOfferedE"), )
if mibBuilder.loadTexts: frsldPvcHCFrameDataGroup.setDescription("A collection of optional objects providing high\ncapacity frame data collected on a PVC which\nimplements Service Level Definitions.")
frsldPvcHCOctetDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 8)).setObjects(("FRSLD-MIB", "frsldPvcDataHCDataDeliveredC"), ("FRSLD-MIB", "frsldPvcDataHCDataOfferedE"), ("FRSLD-MIB", "frsldPvcDataHCDataOfferedC"), ("FRSLD-MIB", "frsldPvcDataHCDataDeliveredE"), )
if mibBuilder.loadTexts: frsldPvcHCOctetDataGroup.setDescription("A collection of optional objects providing high\ncapacity octet data collected on a PVC which\nimplements Service Level Definitions.")
frsldPvcSampleDelayGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 9)).setObjects(("FRSLD-MIB", "frsldPvcSmplDelayMin"), ("FRSLD-MIB", "frsldPvcSmplMissedPolls"), ("FRSLD-MIB", "frsldPvcSmplDelayMax"), ("FRSLD-MIB", "frsldPvcSmplDelayAvg"), )
if mibBuilder.loadTexts: frsldPvcSampleDelayGroup.setDescription("A collection of optional objects providing delay\nsample data collected on a PVC which implements\nService Level Definitions.\n\nIf this group is implemented, frsldPvcDelayCtrlGroup\nMUST also be implemented.")
frsldPvcSampleDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 10)).setObjects(("FRSLD-MIB", "frsldPvcSmplFrOfferedE"), ("FRSLD-MIB", "frsldPvcSmplFrDeliveredE"), ("FRSLD-MIB", "frsldPvcSmplDataDeliveredE"), ("FRSLD-MIB", "frsldPvcSmplDataDeliveredC"), ("FRSLD-MIB", "frsldPvcSmplFrOfferedC"), ("FRSLD-MIB", "frsldPvcSmplFrDeliveredC"), ("FRSLD-MIB", "frsldPvcSmplDataOfferedC"), ("FRSLD-MIB", "frsldPvcSmplDataOfferedE"), )
if mibBuilder.loadTexts: frsldPvcSampleDataGroup.setDescription("A collection of optional objects providing data\nand frame delivery sample data collected on a PVC\nwhich implements Service Level Definitions.\n\nIf this group is implemented, frsldPvcReqDataGroup\nMUST also be implemented.")
frsldPvcSampleHCFrameGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 11)).setObjects(("FRSLD-MIB", "frsldPvcSmplHCFrDeliveredC"), ("FRSLD-MIB", "frsldPvcSmplHCFrOfferedC"), ("FRSLD-MIB", "frsldPvcSmplHCFrDeliveredE"), ("FRSLD-MIB", "frsldPvcSmplHCFrOfferedE"), )
if mibBuilder.loadTexts: frsldPvcSampleHCFrameGroup.setDescription("A collection of optional objects providing high\ncapacity frame delivery sample data collected on a PVC\nwhich implements Service Level Definitions.\n\nIf this group is implemented, frsldPvcHCFrameDataGroup\nMUST also be implemented.")
frsldPvcSampleHCDataGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 12)).setObjects(("FRSLD-MIB", "frsldPvcSmplHCDataDeliveredC"), ("FRSLD-MIB", "frsldPvcSmplHCDataOfferedE"), ("FRSLD-MIB", "frsldPvcSmplHCDataOfferedC"), ("FRSLD-MIB", "frsldPvcSmplHCDataDeliveredE"), )
if mibBuilder.loadTexts: frsldPvcSampleHCDataGroup.setDescription("A collection of optional objects providing high\ncapacity data delivery sample data collected on a PVC\nwhich implements Service Level Definitions.\n\nIf this group is implemented, frsldPvcHCOctetDataGroup\n\n\nMUST also be implemented.")
frsldPvcSampleAvailGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 13)).setObjects(("FRSLD-MIB", "frsldPvcSmplUnavailables"), ("FRSLD-MIB", "frsldPvcSmplUnavailableTime"), )
if mibBuilder.loadTexts: frsldPvcSampleAvailGroup.setDescription("A collection of optional objects providing\navailability sample data collected on a PVC which\nimplements Service Level Definitions.\n\nIf this group is implemented, frsldPvcReqDataGroup\nMUST also be implemented.")
frsldPvcSampleGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 14)).setObjects(("FRSLD-MIB", "frsldPvcSmplEndTime"), ("FRSLD-MIB", "frsldPvcSmplStartTime"), )
if mibBuilder.loadTexts: frsldPvcSampleGeneralGroup.setDescription("A collection of optional objects providing\ngeneral sample data collected on a PVC which\nimplements Service Level Definitions.")
frsldCapabilitiesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 95, 3, 1, 15)).setObjects(("FRSLD-MIB", "frsldPvcCtrlWriteCaps"), ("FRSLD-MIB", "frsldNumSmplCtrls"), ("FRSLD-MIB", "frsldRPCaps"), ("FRSLD-MIB", "frsldMaxSmplCtrls"), ("FRSLD-MIB", "frsldMaxPvcCtrls"), ("FRSLD-MIB", "frsldSmplCtrlWriteCaps"), ("FRSLD-MIB", "frsldNumPvcCtrls"), )
if mibBuilder.loadTexts: frsldCapabilitiesGroup.setDescription("A collection of required objects providing\ncapability information and control for this\nMIB module.")

# Compliances

frsldCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 95, 3, 2, 1)).setObjects(("FRSLD-MIB", "frsldPvcSampleDelayGroup"), ("FRSLD-MIB", "frsldPvcSampleAvailGroup"), ("FRSLD-MIB", "frsldPvcSampleCtrlGroup"), ("FRSLD-MIB", "frsldPvcHCOctetDataGroup"), ("FRSLD-MIB", "frsldPvcSampleHCFrameGroup"), ("FRSLD-MIB", "frsldCapabilitiesGroup"), ("FRSLD-MIB", "frsldPvcSampleHCDataGroup"), ("FRSLD-MIB", "frsldPvcReqCtrlGroup"), ("FRSLD-MIB", "frsldPvcDelayDataGroup"), ("FRSLD-MIB", "frsldPvcPacketGroup"), ("FRSLD-MIB", "frsldPvcDelayCtrlGroup"), ("FRSLD-MIB", "frsldPvcReqDataGroup"), ("FRSLD-MIB", "frsldPvcSampleDataGroup"), ("FRSLD-MIB", "frsldPvcSampleGeneralGroup"), ("FRSLD-MIB", "frsldPvcHCFrameDataGroup"), )
if mibBuilder.loadTexts: frsldCompliance.setDescription("The compliance statement for SNMP entities\nwhich support with Frame Relay Service Level\nDefinitions.  This group defines the minimum\nlevel of support required for compliance.")

# Exports

# Module identity
mibBuilder.exportSymbols("FRSLD-MIB", PYSNMP_MODULE_ID=frsldMIB)

# Types
mibBuilder.exportSymbols("FRSLD-MIB", FrsldRxRP=FrsldRxRP, FrsldTxRP=FrsldTxRP)

# Objects
mibBuilder.exportSymbols("FRSLD-MIB", frsldMIB=frsldMIB, frsldObjects=frsldObjects, frsldPvcCtrlTable=frsldPvcCtrlTable, frsldPvcCtrlEntry=frsldPvcCtrlEntry, frsldPvcCtrlDlci=frsldPvcCtrlDlci, frsldPvcCtrlTransmitRP=frsldPvcCtrlTransmitRP, frsldPvcCtrlReceiveRP=frsldPvcCtrlReceiveRP, frsldPvcCtrlStatus=frsldPvcCtrlStatus, frsldPvcCtrlPacketFreq=frsldPvcCtrlPacketFreq, frsldPvcCtrlDelayFrSize=frsldPvcCtrlDelayFrSize, frsldPvcCtrlDelayType=frsldPvcCtrlDelayType, frsldPvcCtrlDelayTimeOut=frsldPvcCtrlDelayTimeOut, frsldPvcCtrlPurge=frsldPvcCtrlPurge, frsldPvcCtrlDeleteOnPurge=frsldPvcCtrlDeleteOnPurge, frsldPvcCtrlLastPurgeTime=frsldPvcCtrlLastPurgeTime, frsldSmplCtrlTable=frsldSmplCtrlTable, frsldSmplCtrlEntry=frsldSmplCtrlEntry, frsldSmplCtrlIdx=frsldSmplCtrlIdx, frsldSmplCtrlStatus=frsldSmplCtrlStatus, frsldSmplCtrlColPeriod=frsldSmplCtrlColPeriod, frsldSmplCtrlBuckets=frsldSmplCtrlBuckets, frsldSmplCtrlBucketsGranted=frsldSmplCtrlBucketsGranted, frsldPvcDataTable=frsldPvcDataTable, frsldPvcDataEntry=frsldPvcDataEntry, frsldPvcDataMissedPolls=frsldPvcDataMissedPolls, frsldPvcDataFrDeliveredC=frsldPvcDataFrDeliveredC, frsldPvcDataFrDeliveredE=frsldPvcDataFrDeliveredE, frsldPvcDataFrOfferedC=frsldPvcDataFrOfferedC, frsldPvcDataFrOfferedE=frsldPvcDataFrOfferedE, frsldPvcDataDataDeliveredC=frsldPvcDataDataDeliveredC, frsldPvcDataDataDeliveredE=frsldPvcDataDataDeliveredE, frsldPvcDataDataOfferedC=frsldPvcDataDataOfferedC, frsldPvcDataDataOfferedE=frsldPvcDataDataOfferedE, frsldPvcDataHCFrDeliveredC=frsldPvcDataHCFrDeliveredC, frsldPvcDataHCFrDeliveredE=frsldPvcDataHCFrDeliveredE, frsldPvcDataHCFrOfferedC=frsldPvcDataHCFrOfferedC, frsldPvcDataHCFrOfferedE=frsldPvcDataHCFrOfferedE, frsldPvcDataHCDataDeliveredC=frsldPvcDataHCDataDeliveredC, frsldPvcDataHCDataDeliveredE=frsldPvcDataHCDataDeliveredE, frsldPvcDataHCDataOfferedC=frsldPvcDataHCDataOfferedC, frsldPvcDataHCDataOfferedE=frsldPvcDataHCDataOfferedE, frsldPvcDataUnavailableTime=frsldPvcDataUnavailableTime, frsldPvcDataUnavailables=frsldPvcDataUnavailables, frsldPvcSampleTable=frsldPvcSampleTable, frsldPvcSampleEntry=frsldPvcSampleEntry, frsldPvcSmplIdx=frsldPvcSmplIdx, frsldPvcSmplDelayMin=frsldPvcSmplDelayMin, frsldPvcSmplDelayMax=frsldPvcSmplDelayMax, frsldPvcSmplDelayAvg=frsldPvcSmplDelayAvg, frsldPvcSmplMissedPolls=frsldPvcSmplMissedPolls, frsldPvcSmplFrDeliveredC=frsldPvcSmplFrDeliveredC, frsldPvcSmplFrDeliveredE=frsldPvcSmplFrDeliveredE, frsldPvcSmplFrOfferedC=frsldPvcSmplFrOfferedC, frsldPvcSmplFrOfferedE=frsldPvcSmplFrOfferedE, frsldPvcSmplDataDeliveredC=frsldPvcSmplDataDeliveredC, frsldPvcSmplDataDeliveredE=frsldPvcSmplDataDeliveredE, frsldPvcSmplDataOfferedC=frsldPvcSmplDataOfferedC, frsldPvcSmplDataOfferedE=frsldPvcSmplDataOfferedE, frsldPvcSmplHCFrDeliveredC=frsldPvcSmplHCFrDeliveredC, frsldPvcSmplHCFrDeliveredE=frsldPvcSmplHCFrDeliveredE, frsldPvcSmplHCFrOfferedC=frsldPvcSmplHCFrOfferedC, frsldPvcSmplHCFrOfferedE=frsldPvcSmplHCFrOfferedE, frsldPvcSmplHCDataDeliveredC=frsldPvcSmplHCDataDeliveredC, frsldPvcSmplHCDataDeliveredE=frsldPvcSmplHCDataDeliveredE, frsldPvcSmplHCDataOfferedC=frsldPvcSmplHCDataOfferedC, frsldPvcSmplHCDataOfferedE=frsldPvcSmplHCDataOfferedE, frsldPvcSmplUnavailableTime=frsldPvcSmplUnavailableTime, frsldPvcSmplUnavailables=frsldPvcSmplUnavailables, frsldPvcSmplStartTime=frsldPvcSmplStartTime, frsldPvcSmplEndTime=frsldPvcSmplEndTime, frsldCapabilities=frsldCapabilities, frsldPvcCtrlWriteCaps=frsldPvcCtrlWriteCaps, frsldSmplCtrlWriteCaps=frsldSmplCtrlWriteCaps, frsldRPCaps=frsldRPCaps, frsldMaxPvcCtrls=frsldMaxPvcCtrls, frsldNumPvcCtrls=frsldNumPvcCtrls, frsldMaxSmplCtrls=frsldMaxSmplCtrls, frsldNumSmplCtrls=frsldNumSmplCtrls, frsldConformance=frsldConformance, frsldMIBGroups=frsldMIBGroups, frsldMIBCompliances=frsldMIBCompliances)

# Groups
mibBuilder.exportSymbols("FRSLD-MIB", frsldPvcReqCtrlGroup=frsldPvcReqCtrlGroup, frsldPvcPacketGroup=frsldPvcPacketGroup, frsldPvcDelayCtrlGroup=frsldPvcDelayCtrlGroup, frsldPvcSampleCtrlGroup=frsldPvcSampleCtrlGroup, frsldPvcReqDataGroup=frsldPvcReqDataGroup, frsldPvcDelayDataGroup=frsldPvcDelayDataGroup, frsldPvcHCFrameDataGroup=frsldPvcHCFrameDataGroup, frsldPvcHCOctetDataGroup=frsldPvcHCOctetDataGroup, frsldPvcSampleDelayGroup=frsldPvcSampleDelayGroup, frsldPvcSampleDataGroup=frsldPvcSampleDataGroup, frsldPvcSampleHCFrameGroup=frsldPvcSampleHCFrameGroup, frsldPvcSampleHCDataGroup=frsldPvcSampleHCDataGroup, frsldPvcSampleAvailGroup=frsldPvcSampleAvailGroup, frsldPvcSampleGeneralGroup=frsldPvcSampleGeneralGroup, frsldCapabilitiesGroup=frsldCapabilitiesGroup)

# Compliances
mibBuilder.exportSymbols("FRSLD-MIB", frsldCompliance=frsldCompliance)
