# PySNMP SMI module. Autogenerated from smidump -f python GSMP-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:32 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( AtmVcIdentifier, AtmVpIdentifier, ) = mibBuilder.importSymbols("ATM-TC-MIB", "AtmVcIdentifier", "AtmVpIdentifier")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( ZeroBasedCounter32, ) = mibBuilder.importSymbols("RMON2-MIB", "ZeroBasedCounter32")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class GsmpLabelType(OctetString):
    pass

class GsmpNameType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(6,6)
    fixedLength = 6
    
class GsmpPartitionIdType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(1,1)
    fixedLength = 1
    
class GsmpPartitionType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,1,)
    namedValues = namedval.NamedValues(("noPartition", 1), ("fixedPartitionRequest", 2), ("fixedPartitionAssigned", 3), )
    
class GsmpVersion(Unsigned32):
    pass


# Objects

gsmpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 98)).setRevisions(("2002-05-31 00:00",))
if mibBuilder.loadTexts: gsmpMIB.setOrganization("General Switch Management Protocol (gsmp)\nWorking Group, IETF")
if mibBuilder.loadTexts: gsmpMIB.setContactInfo("WG Charter:\nhttp://www.ietf.org/html.charters/gsmp-charter.html\n\nWG-email:          gsmp@ietf.org\nSubscribe:         gsmp-request@ietf.org\nEmail Archive:\nftp://ftp.ietf.org/ietf-mail-archive/gsmp/\n\nWG Chair:    Avri Doria\nEmail:       avri@acm.org\n\nWG Chair:    Kenneth Sundell\nEmail:       ksundell@nortelnetworks.com\n\nEditor:      Hans Sjostrand\nEmail:       hans@ipunplugged.com\n\n\n\n\nEditor:      Joachim Buerkle\nEmail:       joachim.buerkle@nortelnetworks.com\n\nEditor:      Balaji Srinivasan\nEmail:       balaji@cplane.com")
if mibBuilder.loadTexts: gsmpMIB.setDescription("This MIB contains managed object definitions for the\nGeneral Switch Management Protocol, GSMP, version 3")
gsmpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 0))
gsmpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 1))
gsmpControllerTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 1))
if mibBuilder.loadTexts: gsmpControllerTable.setDescription("This table represents the Switch Controller\nEntities. An entry in this table needs to be configured\n(created) before a GSMP session might be started.")
gsmpControllerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 1, 1)).setIndexNames((0, "GSMP-MIB", "gsmpControllerEntityId"))
if mibBuilder.loadTexts: gsmpControllerEntry.setDescription("An entry in the table showing\nthe data for a specific Switch Controller\nEntity. If partitions are used, one entity\ncorresponds to one specific switch partition.\nDepending of the encapsulation used,\na corresponding row in the gsmpAtmEncapTable or the\ngsmpTcpIpEncapTable may have been created.")
gsmpControllerEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 1), GsmpNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: gsmpControllerEntityId.setDescription("The Switch Controller Entity Id is unique\nwithin the operational context of the device.")
gsmpControllerMaxVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 2), GsmpVersion().clone('3')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerMaxVersion.setDescription("The max version number of the GSMP protocol being used\nin this session. The version is negotiated by the\nadjacency protocol.")
gsmpControllerTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerTimer.setDescription("The timer specifies the nominal time between\nperiodic adjacency protocol messages. It is a constant\nfor the duration of a GSMP session. The timer is\nspecified in units of 100ms.")
gsmpControllerPort = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerPort.setDescription("The local port number for the Switch Controller\nEntity.")
gsmpControllerInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpControllerInstance.setDescription("The instance number for the Switch Controller\nEntity. The Instance number is a 24-bit number\nthat should be guaranteed to be unique within\nthe recent past and to change when the link\nor node comes back up after going down. Zero is\nnot a valid instance number. ")
gsmpControllerPartitionType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 6), GsmpPartitionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerPartitionType.setDescription("A controller can request the specific partition identifier\nto the session by setting the Partition Type to\nfixedPartitionRequest(2). A controller can let the switch\ndecide whether it wants to assign a fixed partition ID or\n\n\n\nnot, by setting the Partition Type to noPartition(1).")
gsmpControllerPartitionId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 7), GsmpPartitionIdType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerPartitionId.setDescription("The Id for the specific switch partition that this\nSwitch Controller is concerned with.\nIf partitions are not used or if the controller lets the\nswitch assigns Partition ID, i.e Partition Type =\nnoPartition(1), then this object is undefined.")
gsmpControllerDoResync = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 8), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerDoResync.setDescription("This object specifies whether the controller should\nresynchronise or reset in case of loss of synchronisation.\nIf this object is set to true then the Controller should\nresync with PFLAG=2 (recovered adjacency).")
gsmpControllerNotificationMap = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 9), Bits().subtype(namedValues=namedval.NamedValues(("sessionDown", 0), ("sessionUp", 1), ("sendFailureIndication", 2), ("receivedFailureIndication", 3), ("portUpEvent", 4), ("portDownEvent", 5), ("invalidLabelEvent", 6), ("newPortEvent", 7), ("deadPortEvent", 8), ("adjacencyUpdateEvent", 9), )).clone(("sessionDown","sessionUp","sendFailureIndication","receivedFailureIndication",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerNotificationMap.setDescription("This bitmap defines whether a corresponding SNMP\nnotification should be sent if a GSMP event is received\nby the Switch Controller. If the bit is set to 1 a\nnotification should be sent. The handling and filtering of\nthe SNMP notifications are then further specified in the\n\n\n\nSNMP notification originator application. ")
gsmpControllerSessionState = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,2,3,)).subtype(namedValues=namedval.NamedValues(("null", 1), ("synsent", 2), ("synrcvd", 3), ("estab", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpControllerSessionState.setDescription("The state for the existing or potential session that\nthis entity is concerned with.\nThe NULL state is returned if the proper encapsulation\ndata is not yet configured, if the row is not in active\nstatus or if the session is in NULL state as defined in\nthe GSMP specification.")
gsmpControllerStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerStorageType.setDescription("The storage type for this controller entity.\nConceptual rows having the value 'permanent' need not allow\nwrite-access to any columnar objects in the row.")
gsmpControllerRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerRowStatus.setDescription("An object that allows entries in this table to\nbe created and deleted using the\nRowStatus convention.\nWhile the row is in active state it's not\npossible to modify the value of any object\nfor that row except the gsmpControllerNotificationMap\nand the gsmpControllerRowStatus objects.")
gsmpSwitchTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 2))
if mibBuilder.loadTexts: gsmpSwitchTable.setDescription("This table represents the Switch\nEntities. An entry in this table needs to be configured\n(created) before a GSMP session might be started.")
gsmpSwitchEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 2, 1)).setIndexNames((0, "GSMP-MIB", "gsmpSwitchEntityId"))
if mibBuilder.loadTexts: gsmpSwitchEntry.setDescription("An entry in the table showing\nthe data for a specific Switch\nEntity. If partitions are used, one entity\ncorresponds to one specific switch partition.\nDepending of the encapsulation used,\na corresponding row in the gsmpAtmEncapTable or the\ngsmpTcpIpEncapTable may have been created.")
gsmpSwitchEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 1), GsmpNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: gsmpSwitchEntityId.setDescription("The Switch Entity Id is unique\nwithin the operational context of the device. ")
gsmpSwitchMaxVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 2), GsmpVersion().clone('3')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchMaxVersion.setDescription("The max version number of the GSMP protocol being\nsupported by this Switch. The version is negotiated by\nthe adjacency protocol.")
gsmpSwitchTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchTimer.setDescription("The timer specifies the nominal time between\nperiodic adjacency protocol messages. It is a constant\nfor the duration of a GSMP session. The timer is\nspecified in units of 100ms.")
gsmpSwitchName = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 4), GsmpNameType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchName.setDescription("The name of the Switch. The first three octets must be an\nOrganisationally Unique Identifier (OUI) that identifies\nthe manufacturer of the Switch. This is by default set to\nthe same value as the gsmpSwitchId object if not\nseparately specified. ")
gsmpSwitchPort = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 5), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchPort.setDescription("The local port number for this Switch Entity.")
gsmpSwitchInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSwitchInstance.setDescription("The instance number for the Switch Entity.\nThe Instance number is a 24-bit number\nthat should be guaranteed to be unique within\nthe recent past and to change when the link\nor node comes back up after going down. Zero is\nnot a valid instance number.")
gsmpSwitchPartitionType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 7), GsmpPartitionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchPartitionType.setDescription("A switch can assign the specific partition identifier to\nthe session by setting the Partition Type to\nfixedPartitionAssigned(3). A switch can specify\nthat no partitions are handled in the session by setting\nthe Partition Type to noPartition(1).")
gsmpSwitchPartitionId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 8), GsmpPartitionIdType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchPartitionId.setDescription("The Id for this specific switch partition that the switch\nentity represents. If partitions are not used, i.e.\nPartition Type = noPartition(1), then this object is\nundefined.")
gsmpSwitchNotificationMap = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 9), Bits().subtype(namedValues=namedval.NamedValues(("sessionDown", 0), ("sessionUp", 1), ("sendFailureIndication", 2), ("receivedFailureIndication", 3), ("portUpEvent", 4), ("portDownEvent", 5), ("invalidLabelEvent", 6), ("newPortEvent", 7), ("deadPortEvent", 8), ("adjacencyUpdateEvent", 9), )).clone(("sessionDown","sessionUp","sendFailureIndication","receivedFailureIndication",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchNotificationMap.setDescription("This bitmap defines whether a corresponding SNMP\nnotification should be sent if an GSMP event is sent\nby the Switch Entity. If the bit is set to 1 a\nnotification should be sent. The handling and filtering of\nthe SNMP notifications are then further specified in the\nSNMP notification originator application. ")
gsmpSwitchSwitchType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 10), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchSwitchType.setDescription("A 16-bit field allocated by the manufacturer\nof the switch. The Switch Type\nidentifies the product. When the Switch Type is combined\nwith the OUI from the Switch Name the product is\nuniquely identified. ")
gsmpSwitchWindowSize = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchWindowSize.setDescription("The maximum number of unacknowledged request messages\nthat may be transmitted by the controller without the\npossibility of loss. This field is used to prevent\nrequest messages from being lost in the switch because of\noverflow in the receive buffer. The field is a hint to\nthe controller.")
gsmpSwitchSessionState = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,2,3,)).subtype(namedValues=namedval.NamedValues(("null", 1), ("synsent", 2), ("synrcvd", 3), ("estab", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSwitchSessionState.setDescription("The state for the existing or potential session that\nthis entity is concerned with.\nThe NULL state is returned if the proper encapsulation\ndata is not yet configured, if the row is not in active\nstatus or if the session is in NULL state as defined in\nthe GSMP specification.")
gsmpSwitchStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 13), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchStorageType.setDescription("The storage type for this switch entity.\nConceptual rows having the value 'permanent' need not allow\nwrite-access to any columnar objects in the row.")
gsmpSwitchRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 14), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchRowStatus.setDescription("An object that allows entries in this table to\nbe created and deleted using the\nRowStatus convention.\nWhile the row is in active state it's not\npossible to modify the value of any object\nfor that row except the gsmpSwitchNotificationMap\nand the gsmpSwitchRowStatus objects.")
gsmpAtmEncapTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 3))
if mibBuilder.loadTexts: gsmpAtmEncapTable.setDescription("This table contains the atm encapsulation data\nfor the Controller or Switch that uses atm aal5 as\nencapsulation. ")
gsmpAtmEncapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 3, 1)).setIndexNames((0, "GSMP-MIB", "gsmpAtmEncapEntityId"))
if mibBuilder.loadTexts: gsmpAtmEncapEntry.setDescription("An entry in the table showing\nthe encapsulation data for a specific\nSwitch Controller entity or Switch entity.")
gsmpAtmEncapEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 1), GsmpNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: gsmpAtmEncapEntityId.setDescription("The Controller Id or Switch Id that is unique\nwithin the operational context of the device. ")
gsmpAtmEncapIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 2), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapIfIndex.setDescription("The interface index for the virtual channel over which\nthe GSMP session is established, i.e., the GSMP control\nchannel for LLC/SNAP encapsulated GSMP messages on an\nATM data link layer.")
gsmpAtmEncapVpi = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 3), AtmVpIdentifier().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapVpi.setDescription(" The VPI value for the virtual channel over which the\nGSMP session is established, i.e., the GSMP control\nchannel for LLC/SNAP encapsulated GSMP messages on an\nATM data link layer.")
gsmpAtmEncapVci = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 4), AtmVcIdentifier().clone('15')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapVci.setDescription(" The VCI value for the virtual channel over which the\nGSMP session is established, i.e., the GSMP control\nchannel for LLC/SNAP encapsulated GSMP messages on an\nATM data link layer.")
gsmpAtmEncapStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapStorageType.setDescription("The storage type for this entry. It should have the same\nvalue as the StorageType in the referring Switch\nController entity or Switch entity.")
gsmpAtmEncapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapRowStatus.setDescription("An object that allows entries in this table to\nbe created and deleted using the\nRowStatus convention.\nWhile the row is in active state it's not\npossible to modify the value of any object\nfor that row except the gsmpAtmEncapRowStatus object.")
gsmpTcpIpEncapTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 4))
if mibBuilder.loadTexts: gsmpTcpIpEncapTable.setDescription("This table contains the encapsulation data\nfor the Controller or Switch that uses TCP/IP as\nencapsulation.")
gsmpTcpIpEncapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 4, 1)).setIndexNames((0, "GSMP-MIB", "gsmpTcpIpEncapEntityId"))
if mibBuilder.loadTexts: gsmpTcpIpEncapEntry.setDescription("An entry in the table showing\nthe encapsulation data for a specific\nSwitch Controller entity or Switch entity.")
gsmpTcpIpEncapEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 1), GsmpNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: gsmpTcpIpEncapEntityId.setDescription("The Controller or Switch Id is unique\nwithin the operational context of the device. ")
gsmpTcpIpEncapAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 2), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapAddressType.setDescription("The type of address in gsmpTcpIpEncapAddress.")
gsmpTcpIpEncapAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapAddress.setDescription("The IPv4 or IPv6 address used for\nthe GSMP session peer.")
gsmpTcpIpEncapPortNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 4), InetPortNumber().clone('6068')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapPortNumber.setDescription("The TCP port number used for the TCP session\nestablishment to the GSMP peer.")
gsmpTcpIpEncapStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapStorageType.setDescription("The storage type for this entry. It should have the same\nvalue as the StorageType in the referring Switch\nController entity or Switch entity.")
gsmpTcpIpEncapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapRowStatus.setDescription("An object that allows entries in this table to\nbe created and deleted using the\nRowStatus convention.\nWhile the row is in active state it's not\npossible to modify the value of any object\nfor that row except the gsmpTcpIpEncapRowStatus object.")
gsmpSessionTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 5))
if mibBuilder.loadTexts: gsmpSessionTable.setDescription("This table represents the sessions between\nController and Switch pairs. ")
gsmpSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 5, 1)).setIndexNames((0, "GSMP-MIB", "gsmpSessionThisSideId"), (0, "GSMP-MIB", "gsmpSessionFarSideId"))
if mibBuilder.loadTexts: gsmpSessionEntry.setDescription("An entry in the table showing\nthe session data for a specific Controller and\nSwitch pair. Also, statistics for this specific\nsession is shown.")
gsmpSessionThisSideId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 1), GsmpNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: gsmpSessionThisSideId.setDescription("This side ID uniquely identifies the entity that this\nsession relates to within the operational\ncontext of the device. ")
gsmpSessionFarSideId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 2), GsmpNameType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: gsmpSessionFarSideId.setDescription("The Far side ID uniquely identifies the entity that this\nsession is established against. ")
gsmpSessionVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 3), GsmpVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionVersion.setDescription("The version number of the GSMP protocol being used in\nthis session. The version is the result of the\nnegotiation by the adjacency protocol.")
gsmpSessionTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionTimer.setDescription("The timer specifies the time remaining until the\nadjacency timer expires. The object could take negative\nvalues since if no valid GSMP messages are\nreceived in any period of time in excess of three times\nthe value of the Timer negotiated by the adjacency\nprotocol loss of synchronisation may be declared. The\ntimer is specified in units of 100ms.")
gsmpSessionPartitionId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 5), GsmpPartitionIdType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionPartitionId.setDescription("The Partition Id for the specific switch partition that\nthis session is concerned with.")
gsmpSessionAdjacencyCount = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionAdjacencyCount.setDescription("This object specifies the current number of adjacencies\nthat are established with controllers and the switch\npartition that is used for this session. The value\nincludes this session.")
gsmpSessionFarSideName = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 7), GsmpNameType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionFarSideName.setDescription("The name of the far side as advertised in the adjacency\nmessage.")
gsmpSessionFarSidePort = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionFarSidePort.setDescription("The local port number of the link across which the\nmessage is being sent.")
gsmpSessionFarSideInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionFarSideInstance.setDescription("The instance number used for the link during this\nsession. The Instance number is a 24-bit number\nthat should be guaranteed to be unique within\n\n\n\nthe recent past and to change when the link\nor node comes back up after going down. Zero is not\na valid instance number.")
gsmpSessionLastFailureCode = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionLastFailureCode.setDescription("This is the last failure code that was received over\nthis session. If no failure code have been received, the\nvalue is zero.")
gsmpSessionDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\nwhich one or more of this session's counters\nsuffered a discontinuity. If no such discontinuities have\noccurred since then, this object contains the same\ntimestamp as gsmpSessionStartUptime .")
gsmpSessionStartUptime = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 12), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStartUptime.setDescription(" The value of sysUpTime when the session came to\nestablished state.")
gsmpSessionStatSentMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 13), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatSentMessages.setDescription("The number of messages that have been sent in this\nsession. All GSMP messages pertaining to this session after\nthe session came to established state SHALL\nbe counted, also including adjacency protocol messages\nand failure response messages.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\n\n\n\nhappened.")
gsmpSessionStatFailureInds = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 14), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatFailureInds.setDescription("The number of messages that have been sent with a\nfailure indication in this session. Warning messages\nSHALL NOT be counted.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatReceivedMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 15), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatReceivedMessages.setDescription("The number of messages that have been received in\nthis session. All legal GSMP messages pertaining to this\nsession after the session came to established state SHALL\nbe counted, also including adjacency protocol messages\nand failure response messages.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatReceivedFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 16), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatReceivedFailures.setDescription("The number of messages that have been received in\nthis session with a failure indication. Warning messages\nSHALL NOT be counted.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatPortUpEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 17), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatPortUpEvents.setDescription("The number of Port Up events that have been sent or\nreceived on this session.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatPortDownEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 18), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatPortDownEvents.setDescription("The number of Port Down events that have been sent or\nreceived on this session.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatInvLabelEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 19), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatInvLabelEvents.setDescription("The number of Invalid label events that have been sent\nor received on this session.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatNewPortEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 20), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatNewPortEvents.setDescription("The number of New Port events that have been sent or\n\n\n\nreceived on this session.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatDeadPortEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 21), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatDeadPortEvents.setDescription("The number of Dead Port events that have been sent or\nreceived on this session.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpSessionStatAdjUpdateEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 22), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatAdjUpdateEvents.setDescription("The number of Adjacency Update events that have been sent\nor received on this session.\nWhen the counter suffers any discontinuity, then\nthe gsmpSessionDiscontinuityTime object indicates when it\nhappened.")
gsmpNotificationsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 2))
gsmpEventPort = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 1), Unsigned32()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: gsmpEventPort.setDescription("This object specifies the Port Number that is\ncarried in this event.")
gsmpEventPortSessionNumber = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 2), Unsigned32()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: gsmpEventPortSessionNumber.setDescription("This object specifies the Port Session Number that is\ncarried in this event.")
gsmpEventSequenceNumber = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 3), Unsigned32()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: gsmpEventSequenceNumber.setDescription("This object specifies the Event Sequence Number that is\ncarried in this event.")
gsmpEventLabel = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 4), GsmpLabelType()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: gsmpEventLabel.setDescription("This object specifies the Label that is\ncarried in this event.")
gsmpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 3))
gsmpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 3, 1))
gsmpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 3, 2))

# Augmentions

# Notifications

gsmpSessionDown = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 1)).setObjects(("GSMP-MIB", "gsmpSessionStatPortUpEvents"), ("GSMP-MIB", "gsmpSessionStatReceivedMessages"), ("GSMP-MIB", "gsmpSessionStatNewPortEvents"), ("GSMP-MIB", "gsmpSessionStatFailureInds"), ("GSMP-MIB", "gsmpSessionStatReceivedFailures"), ("GSMP-MIB", "gsmpSessionStatSentMessages"), ("GSMP-MIB", "gsmpSessionStartUptime"), ("GSMP-MIB", "gsmpSessionStatInvLabelEvents"), ("GSMP-MIB", "gsmpSessionStatAdjUpdateEvents"), ("GSMP-MIB", "gsmpSessionStatPortDownEvents"), ("GSMP-MIB", "gsmpSessionStatDeadPortEvents"), )
if mibBuilder.loadTexts: gsmpSessionDown.setDescription("When it has been enabled, this notification is\ngenerated whenever a session is taken down, regardless\nof whether the session went down normally or not.\nIts purpose is to allow a management application\n(primarily an accounting application) that is\nmonitoring the session statistics to receive the final\nvalues of these counters, so that the application can\nproperly account for the amounts the counters were\nincremented since the last time the application polled\nthem. The gsmpSessionStartUptime object provides the\ntotal amount of time that the session was active.\n\nThis notification is not a substitute for polling the\nsession statistic counts. In particular, the count\nvalues reported in this notification cannot be assumed\nto be the complete totals for the life of the session,\nsince they may have wrapped while the\nsession was up.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifiers of the objects contained in the\nnotification.\nAn instance of this notification will contain exactly\none instance of each of its objects, and these objects\nwill all belong to the same conceptual row of the\ngsmpSessionTable.")
gsmpSessionUp = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 2)).setObjects(("GSMP-MIB", "gsmpSessionFarSideInstance"), )
if mibBuilder.loadTexts: gsmpSessionUp.setDescription("When it has been enabled, this notification is\ngenerated when new session is established.\n\nThe new session is identified by the gsmpSessionThisSideId\nand gsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionFarSideInstance object\n\n\n\ncontained in the notification.")
gsmpSentFailureInd = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 3)).setObjects(("GSMP-MIB", "gsmpSessionLastFailureCode"), ("GSMP-MIB", "gsmpSessionStatFailureInds"), )
if mibBuilder.loadTexts: gsmpSentFailureInd.setDescription("When it has been enabled, this notification is\ngenerated when a message with a failure indication was\nsent.\n\nThe notification indicates a change in the value of\ngsmpSessionStatFailureInds. The\ngsmpSessionLastFailureCode contains the failure\nreason.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifiers of the objects contained in the\nnotification.")
gsmpReceivedFailureInd = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 4)).setObjects(("GSMP-MIB", "gsmpSessionLastFailureCode"), ("GSMP-MIB", "gsmpSessionStatReceivedFailures"), )
if mibBuilder.loadTexts: gsmpReceivedFailureInd.setDescription("When it has been enabled, this notification is\ngenerate when a message with a failure indication\nis received.\n\nThe notification indicates a change in the value of\ngsmpSessionStatReceivedFailures. The\ngsmpSessionLastFailureCode contains the failure\nreason.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifiers of the objects contained in the\nnotification.")
gsmpPortUpEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 5)).setObjects(("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpSessionStatPortUpEvents"), ("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpEventPort"), )
if mibBuilder.loadTexts: gsmpPortUpEvent.setDescription("When it has been enabled, this notification is\ngenerated when a Port Up Event occurs.\n\nThe notification indicates a change in the value of\ngsmpSessionStatPortUpEvents.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionStatPortUpEvents\nobject contained in the notification.")
gsmpPortDownEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 6)).setObjects(("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpSessionStatPortDownEvents"), ("GSMP-MIB", "gsmpEventPort"), )
if mibBuilder.loadTexts: gsmpPortDownEvent.setDescription("When it has been enabled, this notification is\ngenerated when a Port Down Event occurs.\n\nThe notification indicates a change in the value of\ngsmpSessionStatPortDownEvents.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionStatPortDownEvents\nobject contained in the notification.")
gsmpInvalidLabelEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 7)).setObjects(("GSMP-MIB", "gsmpEventLabel"), ("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpSessionStatInvLabelEvents"), ("GSMP-MIB", "gsmpEventPort"), )
if mibBuilder.loadTexts: gsmpInvalidLabelEvent.setDescription("When it has been enabled, this notification is\ngenerated when an Invalid Label Event occurs.\n\nThe notification indicates a change in the value of\ngsmpSessionStatInvLabelEvents.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionStatInvLabelEvents\nobject contained in the notification.")
gsmpNewPortEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 8)).setObjects(("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpSessionStatNewPortEvents"), ("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpEventPort"), )
if mibBuilder.loadTexts: gsmpNewPortEvent.setDescription("When it has been enabled, this notification is\ngenerated when a New Port Event occurs.\n\nThe notification indicates a change in the value of\ngsmpSessionStatNewPortEvents.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionStatNewPortEvents\nobject contained in the notification.")
gsmpDeadPortEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 9)).setObjects(("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpSessionStatDeadPortEvents"), ("GSMP-MIB", "gsmpEventPort"), )
if mibBuilder.loadTexts: gsmpDeadPortEvent.setDescription("When it has been enabled, this notification is\ngenerated when a Dead Port Event occurs.\n\nThe notification indicates a change in the value of\ngsmpSessionStatDeadPortEvents.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionStatDeadPortEvents\nobject contained in the notification.")
gsmpAdjacencyUpdateEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 10)).setObjects(("GSMP-MIB", "gsmpSessionAdjacencyCount"), ("GSMP-MIB", "gsmpSessionStatAdjUpdateEvents"), ("GSMP-MIB", "gsmpEventSequenceNumber"), )
if mibBuilder.loadTexts: gsmpAdjacencyUpdateEvent.setDescription("When it has been enabled, this notification is\ngenerated when an Adjacency Update Event occurs.\n\nThe gsmpSessionAdjacencyCount contains the new value of\nthe number of adjacencies\nthat are established with controllers and the switch\npartition that is used for this session.\n\nThe notification indicates a change in the value of\ngsmpSessionStatAdjUpdateEvents.\n\nThe session to which this notification\napplies is identified by the gsmpSessionThisSideId and\ngsmpSessionFarSideId which could be inferred from the\nObject Identifier of the gsmpSessionAdjacencyCount\nor the gsmpSessionStatAdjUpdateEvents object contained\nin the notification.")

# Groups

gsmpGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 1)).setObjects(("GSMP-MIB", "gsmpSessionLastFailureCode"), ("GSMP-MIB", "gsmpSessionStartUptime"), ("GSMP-MIB", "gsmpSessionStatReceivedMessages"), ("GSMP-MIB", "gsmpSessionFarSidePort"), ("GSMP-MIB", "gsmpSessionStatDeadPortEvents"), ("GSMP-MIB", "gsmpSessionTimer"), ("GSMP-MIB", "gsmpSessionStatNewPortEvents"), ("GSMP-MIB", "gsmpSessionStatPortDownEvents"), ("GSMP-MIB", "gsmpSessionPartitionId"), ("GSMP-MIB", "gsmpSessionFarSideName"), ("GSMP-MIB", "gsmpSessionFarSideInstance"), ("GSMP-MIB", "gsmpSessionStatAdjUpdateEvents"), ("GSMP-MIB", "gsmpSessionStatPortUpEvents"), ("GSMP-MIB", "gsmpSessionStatFailureInds"), ("GSMP-MIB", "gsmpSessionStatInvLabelEvents"), ("GSMP-MIB", "gsmpSessionDiscontinuityTime"), ("GSMP-MIB", "gsmpSessionAdjacencyCount"), ("GSMP-MIB", "gsmpSessionStatReceivedFailures"), ("GSMP-MIB", "gsmpSessionVersion"), ("GSMP-MIB", "gsmpSessionStatSentMessages"), )
if mibBuilder.loadTexts: gsmpGeneralGroup.setDescription("Objects that apply to all GSMP implementations.")
gsmpControllerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 2)).setObjects(("GSMP-MIB", "gsmpControllerPort"), ("GSMP-MIB", "gsmpControllerTimer"), ("GSMP-MIB", "gsmpControllerPartitionId"), ("GSMP-MIB", "gsmpControllerRowStatus"), ("GSMP-MIB", "gsmpControllerSessionState"), ("GSMP-MIB", "gsmpControllerStorageType"), ("GSMP-MIB", "gsmpControllerDoResync"), ("GSMP-MIB", "gsmpControllerNotificationMap"), ("GSMP-MIB", "gsmpControllerPartitionType"), ("GSMP-MIB", "gsmpControllerMaxVersion"), ("GSMP-MIB", "gsmpControllerInstance"), )
if mibBuilder.loadTexts: gsmpControllerGroup.setDescription("Objects that apply GSMP implementations of\nSwitch Controllers.")
gsmpSwitchGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 3)).setObjects(("GSMP-MIB", "gsmpSwitchSwitchType"), ("GSMP-MIB", "gsmpSwitchRowStatus"), ("GSMP-MIB", "gsmpSwitchInstance"), ("GSMP-MIB", "gsmpSwitchSessionState"), ("GSMP-MIB", "gsmpSwitchNotificationMap"), ("GSMP-MIB", "gsmpSwitchPort"), ("GSMP-MIB", "gsmpSwitchTimer"), ("GSMP-MIB", "gsmpSwitchMaxVersion"), ("GSMP-MIB", "gsmpSwitchStorageType"), ("GSMP-MIB", "gsmpSwitchPartitionId"), ("GSMP-MIB", "gsmpSwitchName"), ("GSMP-MIB", "gsmpSwitchPartitionType"), ("GSMP-MIB", "gsmpSwitchWindowSize"), )
if mibBuilder.loadTexts: gsmpSwitchGroup.setDescription("Objects that apply GSMP implementations of\nSwitches.")
gsmpAtmEncapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 4)).setObjects(("GSMP-MIB", "gsmpAtmEncapIfIndex"), ("GSMP-MIB", "gsmpAtmEncapVci"), ("GSMP-MIB", "gsmpAtmEncapVpi"), ("GSMP-MIB", "gsmpAtmEncapStorageType"), ("GSMP-MIB", "gsmpAtmEncapRowStatus"), )
if mibBuilder.loadTexts: gsmpAtmEncapGroup.setDescription("Objects that apply to GSMP implementations that\nsupports ATM for GSMP encapsulation.")
gsmpTcpIpEncapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 5)).setObjects(("GSMP-MIB", "gsmpTcpIpEncapAddress"), ("GSMP-MIB", "gsmpTcpIpEncapPortNumber"), ("GSMP-MIB", "gsmpTcpIpEncapAddressType"), ("GSMP-MIB", "gsmpTcpIpEncapStorageType"), ("GSMP-MIB", "gsmpTcpIpEncapRowStatus"), )
if mibBuilder.loadTexts: gsmpTcpIpEncapGroup.setDescription("Objects that apply to GSMP implementations that\nsupports TCP/IP for GSMP encapsulation.")
gsmpNotificationObjectsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 6)).setObjects(("GSMP-MIB", "gsmpEventLabel"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpEventPort"), )
if mibBuilder.loadTexts: gsmpNotificationObjectsGroup.setDescription("Objects that are contained in the notifications.")
gsmpNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 7)).setObjects(("GSMP-MIB", "gsmpSessionUp"), ("GSMP-MIB", "gsmpPortUpEvent"), ("GSMP-MIB", "gsmpSessionDown"), ("GSMP-MIB", "gsmpReceivedFailureInd"), ("GSMP-MIB", "gsmpSentFailureInd"), ("GSMP-MIB", "gsmpNewPortEvent"), ("GSMP-MIB", "gsmpDeadPortEvent"), ("GSMP-MIB", "gsmpPortDownEvent"), ("GSMP-MIB", "gsmpAdjacencyUpdateEvent"), ("GSMP-MIB", "gsmpInvalidLabelEvent"), )
if mibBuilder.loadTexts: gsmpNotificationsGroup.setDescription("The notifications which indicate specific changes\nin the value of objects gsmpSessionTable")

# Compliances

gsmpModuleCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 98, 3, 2, 1)).setObjects(("GSMP-MIB", "gsmpControllerGroup"), ("GSMP-MIB", "gsmpTcpIpEncapGroup"), ("GSMP-MIB", "gsmpNotificationObjectsGroup"), ("GSMP-MIB", "gsmpSwitchGroup"), ("GSMP-MIB", "gsmpAtmEncapGroup"), ("GSMP-MIB", "gsmpGeneralGroup"), ("GSMP-MIB", "gsmpNotificationsGroup"), )
if mibBuilder.loadTexts: gsmpModuleCompliance.setDescription("The compliance statement for agents that support\nthe GSMP MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("GSMP-MIB", PYSNMP_MODULE_ID=gsmpMIB)

# Types
mibBuilder.exportSymbols("GSMP-MIB", GsmpLabelType=GsmpLabelType, GsmpNameType=GsmpNameType, GsmpPartitionIdType=GsmpPartitionIdType, GsmpPartitionType=GsmpPartitionType, GsmpVersion=GsmpVersion)

# Objects
mibBuilder.exportSymbols("GSMP-MIB", gsmpMIB=gsmpMIB, gsmpNotifications=gsmpNotifications, gsmpObjects=gsmpObjects, gsmpControllerTable=gsmpControllerTable, gsmpControllerEntry=gsmpControllerEntry, gsmpControllerEntityId=gsmpControllerEntityId, gsmpControllerMaxVersion=gsmpControllerMaxVersion, gsmpControllerTimer=gsmpControllerTimer, gsmpControllerPort=gsmpControllerPort, gsmpControllerInstance=gsmpControllerInstance, gsmpControllerPartitionType=gsmpControllerPartitionType, gsmpControllerPartitionId=gsmpControllerPartitionId, gsmpControllerDoResync=gsmpControllerDoResync, gsmpControllerNotificationMap=gsmpControllerNotificationMap, gsmpControllerSessionState=gsmpControllerSessionState, gsmpControllerStorageType=gsmpControllerStorageType, gsmpControllerRowStatus=gsmpControllerRowStatus, gsmpSwitchTable=gsmpSwitchTable, gsmpSwitchEntry=gsmpSwitchEntry, gsmpSwitchEntityId=gsmpSwitchEntityId, gsmpSwitchMaxVersion=gsmpSwitchMaxVersion, gsmpSwitchTimer=gsmpSwitchTimer, gsmpSwitchName=gsmpSwitchName, gsmpSwitchPort=gsmpSwitchPort, gsmpSwitchInstance=gsmpSwitchInstance, gsmpSwitchPartitionType=gsmpSwitchPartitionType, gsmpSwitchPartitionId=gsmpSwitchPartitionId, gsmpSwitchNotificationMap=gsmpSwitchNotificationMap, gsmpSwitchSwitchType=gsmpSwitchSwitchType, gsmpSwitchWindowSize=gsmpSwitchWindowSize, gsmpSwitchSessionState=gsmpSwitchSessionState, gsmpSwitchStorageType=gsmpSwitchStorageType, gsmpSwitchRowStatus=gsmpSwitchRowStatus, gsmpAtmEncapTable=gsmpAtmEncapTable, gsmpAtmEncapEntry=gsmpAtmEncapEntry, gsmpAtmEncapEntityId=gsmpAtmEncapEntityId, gsmpAtmEncapIfIndex=gsmpAtmEncapIfIndex, gsmpAtmEncapVpi=gsmpAtmEncapVpi, gsmpAtmEncapVci=gsmpAtmEncapVci, gsmpAtmEncapStorageType=gsmpAtmEncapStorageType, gsmpAtmEncapRowStatus=gsmpAtmEncapRowStatus, gsmpTcpIpEncapTable=gsmpTcpIpEncapTable, gsmpTcpIpEncapEntry=gsmpTcpIpEncapEntry, gsmpTcpIpEncapEntityId=gsmpTcpIpEncapEntityId, gsmpTcpIpEncapAddressType=gsmpTcpIpEncapAddressType, gsmpTcpIpEncapAddress=gsmpTcpIpEncapAddress, gsmpTcpIpEncapPortNumber=gsmpTcpIpEncapPortNumber, gsmpTcpIpEncapStorageType=gsmpTcpIpEncapStorageType, gsmpTcpIpEncapRowStatus=gsmpTcpIpEncapRowStatus, gsmpSessionTable=gsmpSessionTable, gsmpSessionEntry=gsmpSessionEntry, gsmpSessionThisSideId=gsmpSessionThisSideId, gsmpSessionFarSideId=gsmpSessionFarSideId, gsmpSessionVersion=gsmpSessionVersion, gsmpSessionTimer=gsmpSessionTimer, gsmpSessionPartitionId=gsmpSessionPartitionId, gsmpSessionAdjacencyCount=gsmpSessionAdjacencyCount, gsmpSessionFarSideName=gsmpSessionFarSideName, gsmpSessionFarSidePort=gsmpSessionFarSidePort, gsmpSessionFarSideInstance=gsmpSessionFarSideInstance, gsmpSessionLastFailureCode=gsmpSessionLastFailureCode, gsmpSessionDiscontinuityTime=gsmpSessionDiscontinuityTime, gsmpSessionStartUptime=gsmpSessionStartUptime, gsmpSessionStatSentMessages=gsmpSessionStatSentMessages, gsmpSessionStatFailureInds=gsmpSessionStatFailureInds, gsmpSessionStatReceivedMessages=gsmpSessionStatReceivedMessages, gsmpSessionStatReceivedFailures=gsmpSessionStatReceivedFailures, gsmpSessionStatPortUpEvents=gsmpSessionStatPortUpEvents, gsmpSessionStatPortDownEvents=gsmpSessionStatPortDownEvents, gsmpSessionStatInvLabelEvents=gsmpSessionStatInvLabelEvents, gsmpSessionStatNewPortEvents=gsmpSessionStatNewPortEvents, gsmpSessionStatDeadPortEvents=gsmpSessionStatDeadPortEvents, gsmpSessionStatAdjUpdateEvents=gsmpSessionStatAdjUpdateEvents, gsmpNotificationsObjects=gsmpNotificationsObjects, gsmpEventPort=gsmpEventPort, gsmpEventPortSessionNumber=gsmpEventPortSessionNumber, gsmpEventSequenceNumber=gsmpEventSequenceNumber, gsmpEventLabel=gsmpEventLabel, gsmpConformance=gsmpConformance, gsmpGroups=gsmpGroups, gsmpCompliances=gsmpCompliances)

# Notifications
mibBuilder.exportSymbols("GSMP-MIB", gsmpSessionDown=gsmpSessionDown, gsmpSessionUp=gsmpSessionUp, gsmpSentFailureInd=gsmpSentFailureInd, gsmpReceivedFailureInd=gsmpReceivedFailureInd, gsmpPortUpEvent=gsmpPortUpEvent, gsmpPortDownEvent=gsmpPortDownEvent, gsmpInvalidLabelEvent=gsmpInvalidLabelEvent, gsmpNewPortEvent=gsmpNewPortEvent, gsmpDeadPortEvent=gsmpDeadPortEvent, gsmpAdjacencyUpdateEvent=gsmpAdjacencyUpdateEvent)

# Groups
mibBuilder.exportSymbols("GSMP-MIB", gsmpGeneralGroup=gsmpGeneralGroup, gsmpControllerGroup=gsmpControllerGroup, gsmpSwitchGroup=gsmpSwitchGroup, gsmpAtmEncapGroup=gsmpAtmEncapGroup, gsmpTcpIpEncapGroup=gsmpTcpIpEncapGroup, gsmpNotificationObjectsGroup=gsmpNotificationObjectsGroup, gsmpNotificationsGroup=gsmpNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("GSMP-MIB", gsmpModuleCompliance=gsmpModuleCompliance)
