# PySNMP SMI module. Autogenerated from smidump -f python IPOA-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:43 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "InterfaceIndexOrZero")
( ipAdEntAddr, ipNetToMediaIfIndex, ipNetToMediaNetAddress, ipNetToMediaPhysAddress, ) = mibBuilder.importSymbols("IP-MIB", "ipAdEntAddr", "ipNetToMediaIfIndex", "ipNetToMediaNetAddress", "ipNetToMediaPhysAddress")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( RowStatus, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention")

# Types

class IpoaAtmAddr(TextualConvention, OctetString):
    displayHint = "1x"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,40)
    
class IpoaAtmConnKind(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,4,2,5,3,)
    namedValues = namedval.NamedValues(("pvc", 1), ("svcIncoming", 2), ("svcOutgoing", 3), ("spvcInitiator", 4), ("spvcTarget", 5), )
    
class IpoaEncapsType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,1,2,)
    namedValues = namedval.NamedValues(("llcSnap", 1), ("vcMuxed", 2), ("other", 3), )
    
class IpoaVciInteger(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,65535)
    
class IpoaVpiInteger(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,255)
    

# Objects

ipoaMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 46)).setRevisions(("1998-02-09 00:00",))
if mibBuilder.loadTexts: ipoaMIB.setOrganization("IETF Internetworking Over NBMA Working\nGroup (ion)")
if mibBuilder.loadTexts: ipoaMIB.setContactInfo("Maria Greene (greene@xedia.com)\nXedia Corp.\n\nJim Luciani (jluciani@BayNetworks.com)\nBay Networks\n\nKenneth White (kennethw@vnet.ibm.com)\nIBM Corp.\n\nTed Kuo (tkuo@eos.ncsu.edu)\nBay Networks")
if mibBuilder.loadTexts: ipoaMIB.setDescription("This module defines a portion of the management\ninformation base (MIB) for managing Classical IP and\nARP over ATM entities.")
ipoaObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 1))
ipoaLisTrapEnable = MibScalar((1, 3, 6, 1, 2, 1, 10, 46, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipoaLisTrapEnable.setDescription("Indicates whether ipoaLisCreate and ipoaLisDelete\ntraps should be generated by this system.\n\nBy default, this object should have the value\nenabled(1) for systems where ATMARP Servers are\npresent and disabled(2) on systems where only\nclients reside.")
ipoaLisTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 2))
if mibBuilder.loadTexts: ipoaLisTable.setDescription("There is one entry in this table for every Logical IP\nSubnet (LIS) of which this system is a member.\n\nThe bulk of the objects in an ipoaLisEntry exists\nto control ATMARP for a particular LIS.  In a PVC only\nenvironment it is implementation dependent as to\nwhether this table should be supported.")
ipoaLisEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1)).setIndexNames((0, "IPOA-MIB", "ipoaLisSubnetAddr"))
if mibBuilder.loadTexts: ipoaLisEntry.setDescription("Information about a single LIS of which this system\nis a member.\n\nMembership in a LIS is independent of the actual ATM\ninterfaces being used.  The ipoaLisTable defines\nall LISs that a system is a member of.  The ipAddrTable\nand the ipoaClientTable provides the mapping from local\nIP address to ATM interface.  The ipoaLisIfMappingTable\nprovides the mappings between Logical IP Subnets and\ninterfaces.\nThe ipoaLisTable is indexed by ipoaLisSubnetAddr (IP\nsubnet address).  An entry in the ipoaLisTable should\nexist for each ipAddrEntry that is associated with an\nATM related interface used for Classical IP and ARP\nover ATM traffic.\n\nIts ipAdEntAddr and ipAdEntNetMask when ANDed together\nshould equal the ipoaLisSubnetAddr of the corresponding\nipoaLisEntry.")
ipoaLisSubnetAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaLisSubnetAddr.setDescription("The IP subnet address associated with this LIS.")
ipoaLisDefaultMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisDefaultMtu.setDescription("The default MTU used within this LIS.  Note that the\nactual MTU used for a VC between two members of the\nLIS may be negotiated during connection setup and may\nbe different than this value.  The ipoaVcNegotiatedMtu\nobject indicates the actual MTU in use for a\nparticular VC.")
ipoaLisDefaultEncapsType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 3), IpoaEncapsType().clone('llcSnap')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisDefaultEncapsType.setDescription("The default encapsulation to use on VCs created for\nthis LIS.  Note that the actual encapsulation type may\nbe negotiated during connection setup and may be\ndifferent than this value.  The\nipoaVcNegotiatedEncapsType object indicates the actual\nencapsulation in use for a particular VC.")
ipoaLisInactivityTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 4), Integer32().clone(1200)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisInactivityTimer.setDescription("The time, in seconds, before a call established for an\nipNetToMediaEntry on a client will timeout due to no\ntraffic being passed on the VC.  A value of 0 implies\nno time out.")
ipoaLisMinHoldingTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisMinHoldingTime.setDescription("The minimum amount of time, in seconds, that a call\nwill remain open.  If 0 then ipoaInactivityTimer will\ncompletely determine when a call is terminated.")
ipoaLisQDepth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisQDepth.setDescription("The maximum number of outstanding requests that are\nallowed while waiting for ATMARP replies and\nInATMARP replies for this LIS.")
ipoaLisMaxCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(500)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisMaxCalls.setDescription("The maximum number of SVCs that can be established\nsimultaneously for this LIS.")
ipoaLisCacheEntryAge = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(60, 1200)).clone(900)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisCacheEntryAge.setDescription("The time, in seconds, before an ipNetToMediaEntry will\nage out of the table.  Note that the default value will\nbe different for a client and a server.  An ATMARP\nServer should use a default of 1200 and a client should\nuse 900.")
ipoaLisRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 10)).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisRetries.setDescription("The number of times the ATMARP request will be retried\nwhen no response is received in the timeout interval\nindicated by ipoaLisTimeout.")
ipoaLisTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 60)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisTimeout.setDescription("The time to wait, in seconds, before retransmission\nof an ARP request.")
ipoaLisDefaultPeakCellRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 11), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisDefaultPeakCellRate.setDescription("This object is the signalling parameter that\nshould be used when setting up all best effort\nVCCs (Virtual Channel Connections).\nThis parameter applies to the forward and\nbackward direction on a per best effort VCC basis.\nA value of zero implies that no configured default\nexists and that local policy should be used to\ndetermine the actual default to used during\ncall setup.  ATM Signaling Support for IP over ATM\n(RFC 1755) recommends 1/10th of the ATM interface's\nspeed.")
ipoaLisActiveVcs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaLisActiveVcs.setDescription("Number of active SVCs for this LIS.")
ipoaLisRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisRowStatus.setDescription("This object allows entries to be created and deleted\nin the ipoaLisTable.\n\nWhen the ipoaLisRowStatus deleted (by setting this\nobject to destroy(6)), this has the side-effect of\nremoving all entries from the ipNetToMediaTable that\nare associated with this LIS (in other words, it\nflushes the entity's ATMARP cache).  It also removes\nthe ipoaVcTable entries that were associated with those\nipNetToMediaTable entries.  Destroying the row also\nremoves the corresponding entries in the\nipoaArpSrvrTable, ipoaArpClientTable,\nipoaLisIfMappingTable, and ipoaArpRemoteSrvrTable.\n\nEntries in both the ipNetToMediaTable and the\nipoaVcTable that are associated with a\nipoaConfigPvcEntry are not affected by changes to\nipoaLisRowStatus.")
ipoaLisIfMappingTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 3))
if mibBuilder.loadTexts: ipoaLisIfMappingTable.setDescription("There is one entry in this table for every combination\nof ipoaLisEntry and IP over ATM interface.")
ipoaLisIfMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 3, 1)).setIndexNames((0, "IPOA-MIB", "ipoaLisSubnetAddr"), (0, "IPOA-MIB", "ipoaLisIfMappingIfIndex"))
if mibBuilder.loadTexts: ipoaLisIfMappingEntry.setDescription("Defines an entry in the ipoaLisIfMappingTable.")
ipoaLisIfMappingIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 3, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaLisIfMappingIfIndex.setDescription("The ipAdEntIfIndex object from an ipAddrEntry\nis used as an index to this table when its\nipAdEntAddr is in the subnet implied by\nipoaLisSubnetAddr.")
ipoaLisIfMappingRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 3, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisIfMappingRowStatus.setDescription("This object allows entries to be created and deleted\nin the ipoaLisIfMappingTable.")
ipoaArpClientTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 4))
if mibBuilder.loadTexts: ipoaArpClientTable.setDescription("The ATMARP clients running on this system.")
ipoaArpClientEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1)).setIndexNames((0, "IP-MIB", "ipAdEntAddr"))
if mibBuilder.loadTexts: ipoaArpClientEntry.setDescription("Information about a single ATMARP Client.  Clients\ncan be started and stopped by adding and removing\nentries from this table.  An entry in the\nipoaArpClientTable has a corresponding entry in the\nipAddrTable.  Both are indexed by ipAdEntAddr.\nThe ifIndex and subnet mask of a client entry are the\nipAddrEntry's ipAdEntIfIndex and ipAdEntNetMask,\nrespectively.\n\nNote that adding and removing entries from this table\nmay have the same effect on the corresponding\nipAddrTable entry.  Row creation of an entry in this\ntable requires that either the corresponding ipAddrTable\nentry exists or that ipAdEntIfIndex and ipAdEntNetMask\nbe specified in the creation of an ipoaArpClientEntry\nat a minimum in order to create the corresponding\nipAddrEntry.  Specification of ipAdEntBcastAddr and\nipAdEntReasmMaxSize to complete an ipAddrEntry is\nimplementation dependent.\nWhether a corresponding ipAddrEntry is deleted during\nthe deletion of an ipoaArpClientEntry is considered\nimplementation dependent.")
ipoaArpClientAtmAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 1), IpoaAtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpClientAtmAddr.setDescription("The ATM address of the client.")
ipoaArpClientSrvrInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 2), IpoaAtmAddr().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientSrvrInUse.setDescription("The ATM address of the ATMARP Server,\nipoaArpRemoteSrvrAtmAddr, in use by this client.  A\nzero length octet string implies that communication\nwith a Remote ATMARP Server is not in effect.")
ipoaArpClientInArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInReqs.setDescription("The number of InATMARP requests received by this\nclient.")
ipoaArpClientInArpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpOutReqs.setDescription("The number of InATMARP requests sent by this client.")
ipoaArpClientInArpInReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInReplies.setDescription("The number of InATMARP replies received by this\nclient.")
ipoaArpClientInArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpOutReplies.setDescription("Total number of InATMARP replies sent by this client.")
ipoaArpClientInArpInvalidInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInvalidInReqs.setDescription("The number of times that this client detected an\ninvalid InATMARP request.")
ipoaArpClientInArpInvalidOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInvalidOutReqs.setDescription("The number of times that this client did not\nreceive an InATMARP reply.")
ipoaArpClientArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpInReqs.setDescription("Total number of ATMARP requests received by this\nclient.")
ipoaArpClientArpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpOutReqs.setDescription("Total number of ATMARP requests sent by this client.")
ipoaArpClientArpInReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpInReplies.setDescription("Total number of ATMARP replies received by this\nclient.")
ipoaArpClientArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpOutReplies.setDescription("Total number of ATMARP replies sent by this client.")
ipoaArpClientArpInNaks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpInNaks.setDescription("Total number of negative ATMARP replies\nreceived by this client.")
ipoaArpClientArpOutNaks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpOutNaks.setDescription("Total number of negative ATMARP replies sent by\nthis client.\n\nClassic IP and ARP over ATM does not require an\nATMARP client to transmit an ATMARP_NAK upon\nreceipt of an ATMARP request from another ATMARP\nclient.  However, implementation experience has\nshown that this error condition is somewhat easy\nto create inadvertently by configuring one ATMARP\nclient with an ipoaArpRemoteSrvrTable entry\ncontaining an ipoaArpRemoteSrvrAtmAddr value which\nis the ATM address of another ATMARP client-only\nsystem.\n\nIf an ATMARP client supports the transmission of\nATMARP_NAKs, then it should increment\nipoaArpClientArpOutNaks each time it transmits\nan ATMARP_NAK.  Otherwise, support of this\nobject is considered optional.")
ipoaArpClientArpUnknownOps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpUnknownOps.setDescription("The number of times that this client received\nan ATMARP message with an operation code for which\nit is not coded to support.")
ipoaArpClientArpNoSrvrResps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpNoSrvrResps.setDescription("The number of times this client failed to receive\na response from a ATMARP Server within the\nipoaLisTimeout value for ipoaLisRetries times.\nThis may imply that the client will re-elect a\nnew primary ATMARP Server for this LIS from the\nipoaArpRemoteSrvrTable.")
ipoaArpClientRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 17), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpClientRowStatus.setDescription("This object allows entries to be created and\ndeleted from the ipoaArpClientTable.")
ipoaArpSrvrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 5))
if mibBuilder.loadTexts: ipoaArpSrvrTable.setDescription("The ATMARP Servers running on this system.")
ipoaArpSrvrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1)).setIndexNames((0, "IP-MIB", "ipAdEntAddr"), (0, "IPOA-MIB", "ipoaArpSrvrAddr"))
if mibBuilder.loadTexts: ipoaArpSrvrEntry.setDescription("Information about an ATMARP Server within a LIS.  An\nentry in this table has two indexes: first ipAdEntAddr,\nwhich is the IP address that this system uses as a\nmember of the LIS, and then ipoaArpSrvrAddr, which is\nthe ATM address of the ATMARP Server.\n\nEntries may be created by a management application\nusing the ipoaArpSrvrRowStatus object.  Entries in this\ntable may also be created by the system and not by a\nmanagement application, for example via ILMI.\n\nEntries in this table may be deleted by setting the\nipoaArpSrvrRowStatus object to 'destroy(6)'.  This\nincludes entries that were added by the system and not\nby a management application.")
ipoaArpSrvrAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 1), IpoaAtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaArpSrvrAddr.setDescription("The ATM address of the ATMARP Server.")
ipoaArpSrvrLis = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 2), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpSrvrLis.setDescription("The subnet address that identifies the LIS with\nwhich this server is associated.")
ipoaArpSrvrInArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInReqs.setDescription("The number of InATMARP requests received by this\nATMARP Server.")
ipoaArpSrvrInArpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpOutReqs.setDescription("The number of InATMARP requests sent by this ATMARP\nServer.")
ipoaArpSrvrInArpInReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInReplies.setDescription("The number of InATMARP replies received by this\nATMARP Server.")
ipoaArpSrvrInArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpOutReplies.setDescription("The number of InATMARP replies sent by this ATMARP\nServer.")
ipoaArpSrvrInArpInvalidInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInvalidInReqs.setDescription("The number of invalid InATMARP requests received by\nthis ATMARP Server.")
ipoaArpSrvrInArpInvalidOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInvalidOutReqs.setDescription("The number of times that this server did not receive\nan InATMARP reply.")
ipoaArpSrvrArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpInReqs.setDescription("Total number of ATMARP requests received by this\nATMARP Server.")
ipoaArpSrvrArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpOutReplies.setDescription("Total number of ATMARP replies sent by this ATMARP\nServer.")
ipoaArpSrvrArpOutNaks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpOutNaks.setDescription("Total number of negative ATMARP replies sent by this\nATMARP Server.")
ipoaArpSrvrArpDupIpAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpDupIpAddrs.setDescription("The number of times that a duplicate IP address was\ndetected by this ATMARP Server.")
ipoaArpSrvrArpUnknownOps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpUnknownOps.setDescription("The number of times that this ATMARP Server received\nan ATMARP message with an operation code for which it\nis not coded to support.")
ipoaArpSrvrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 14), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpSrvrRowStatus.setDescription("This object allows entries to be created and deleted\nfrom the ipoaArpSrvrTable.")
ipoaArpRemoteSrvrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 6))
if mibBuilder.loadTexts: ipoaArpRemoteSrvrTable.setDescription("A table of non-local ATMARP Servers associated with a\nLIS.  An entry in this table has three indexes: first\nthe ipoaLisSubnetAddr of the LIS for which the\ncorresponding ATMARP Server provides ATMARP services,\nthen the ipoaArpRemoteSrvrAtmAddr, which is the ATM\naddress of the remote ATMARP Server, and finally the\nifIndex of the interface on which the VC to the ATMARP\nRemote Server will be opened.  An ifIndex value of 0\nshould be used when a single VC is to be shared for\nATMARP purposes by multiple interfaces.")
ipoaArpRemoteSrvrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1)).setIndexNames((0, "IPOA-MIB", "ipoaLisSubnetAddr"), (0, "IPOA-MIB", "ipoaArpRemoteSrvrAtmAddr"), (0, "IPOA-MIB", "ipoaArpRemoteSrvrIfIndex"))
if mibBuilder.loadTexts: ipoaArpRemoteSrvrEntry.setDescription("Information about one non-local ATMARP Server.")
ipoaArpRemoteSrvrAtmAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 1), IpoaAtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrAtmAddr.setDescription("The ATM address of the remote ATMARP Server.")
ipoaArpRemoteSrvrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrRowStatus.setDescription("This object allows entries to be created and deleted\nfrom the ipoaArpRemoteSrvrTable.\n\nDeleting an ipoaArpRemoteSrvrEntry (by setting this\nobject to destroy(6)) may affect ipoaArpClientTable\nentries.  The object ipoaArpClientSrvrInUse in an\nipoaArpClientSrvrEntry may contain the ATM address\nof an ATMARP Remote Server whose entry in the\nipoaArpRemoteSrvrTable is being removed.  In this\ncase, any corresponding ipoaArpClientSrvrInUse\nobjects should be at a minimum invalidated by\nsetting their values to that of a zero length\nOCTET STRING.\n\nThe value of ipoaArpRemoteSrvrOperStatus should be\nconsistent with that of ipoaArpRemoteSrvrRowStatus.\nFor example, successfully setting the value of\nthis object to notInService(2) after its being in\nthe up(1) state should result in\nipoaArpRemoteSrvrOperStatus being set to down(2)\nif currently up(1).")
ipoaArpRemoteSrvrIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 3), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrIfIndex.setDescription("The ifIndex of the interface that the VC to the\nRemote ATMARP Server is associated with.")
ipoaArpRemoteSrvrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 4), IpAddress().clone("0.0.0.0")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrIpAddr.setDescription("The IP Address of the Remote ATMARP Server.  A\nvalue of 0.0.0.0 implies that this address isn't\nknown.")
ipoaArpRemoteSrvrAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrAdminStatus.setDescription("The desired state for use of the ATMARP Server\nrepresented by an entry in this table.\nipoaArpRemoteSrvrAdminStatus values:\n\nup(1)   - Attempt to activate use of the\n          ATMARP Server represented by this\n          entry in the ipoaArpRemoteSrvrTable.\ndown(2) - Deactivate use of this ATMARP\n          Server.\n\nWhen a managed system creates an entry in this\ntable ipoaArpRemoteSrvrAdminStatus and\nipoaArpRemoteSrvrOperStatus are initialized as\ndown(2) by default.")
ipoaArpRemoteSrvrOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), )).clone(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrOperStatus.setDescription("The current operational state for use of a Remote\nATMARP Server.  An up(1) entry has a VC\nestablished to the respective Remote ATMARP\nServer:\n\nup(1)  - A VC exists to Remote ATMARP Server\n         whose IP Address is stored in\n         ipoaArpRemoteSrvrIpAddr.  This VC can\n         be determined by searching the\n         ipoaVcTable using\n         ipoaArpRemoteSrvrIfIndex (if not 0,\n         otherwise ignore ipNetToMediaIfIndex\n         index) and ipoaArpRemoteSrvrIpAddr.\n         An ipoaArpClientEntry should exist\n         with its ipoaArpClientSrvrInUse\n         object having the same value as\n         ipoaArpRemoteSrvrAtmAddr.\ndown(2) - Entry exists without an active VC to\n         the Remote ATMARP Server.\n\nTransition from up(1) to down(2)\nstatus may affect ipoaArpClientTable entries.\nThe object ipoaArpClientSrvrInUse in an\nipoaArpClientSrvrEntry may contain the ATM address\nof an ATMARP Remote Server whose entry in the\nipoaArpRemoteSrvrTable is being deactivated.  In\nthis case, any corresponding ipoaArpClientSrvrInUse\nobjects should be at a minimum invalidated by\nsetting their values to that of a zero length\nOCTET STRING.\n\nIf ipoaArpRemoteSrvrAdminStatus is down(2) then\nipoaArpRemoteSrvrOperStatus should be down(2).\nIf ipoaArpRemoteSrvrAdminStatus is changed to\nup(1) then ipoaArpRemoteSrvrOperStatus should\nchange to up(1) if the Remote ATMARP Server\nentry can be activated.")
ipoaVcTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 7))
if mibBuilder.loadTexts: ipoaVcTable.setDescription("A system that supports IP over ATM is an IP system and\ntherefore MUST support all of the appropriate tables in\nthe SNMPv2-MIB (RFC 1907), the IF-MIB (RFC 2233),\nthe IP-MIB (RFC 2011), the TCP-MIB (RFC 2012), and\nthe UDP-MIB (RFC 2013).  This includes the\nipNetToMediaTable (the ARP cache) that is defined\nwithin the IP-MIB (RFC 2011).  The ipoaVcTable\nkeeps a set of VCs for each entry in the ARP cache\nthat was put there by an IP over ATM system acting\nas either a host or server.  The ipoaVcTable doesn't\naugment the ipNetToMediaTable (ARP Cache) since the\nthe correspondence between tables is not necessarily\none-to-one.\n\nAn ipNetToMediaPhysAddress object should contain the\ncontent as defined by the IpoaAtmAddr textual\nconvention when used to hold an IPOA-MIB ATM Address.")
ipoaVcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1)).setIndexNames((0, "IP-MIB", "ipNetToMediaIfIndex"), (0, "IP-MIB", "ipNetToMediaNetAddress"), (0, "IPOA-MIB", "ipoaVcVpi"), (0, "IPOA-MIB", "ipoaVcVci"))
if mibBuilder.loadTexts: ipoaVcEntry.setDescription("A VC (permanent or switched) that this host or server\nhas opened with another member of a LIS.  Additional\ninformation can be determined about the VC from the\nATM-MIB.\n\nEntries in this table cannot be created by management\napplications.\n\nIn an SVC environment, an entry is automatically added\nby the system as the result of ATMARP processing.\n\nIn a PVC environment, an entry is automatically added\nto this table when an entry is created in the\nipoaConfigPvcTable and the IP Address at the remote\nend of the PVC is discovered using InATMARP.  An\nentry also is added to the ipNetToMediaTable.")
ipoaVcVpi = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 1), IpoaVpiInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaVcVpi.setDescription("The VPI value for the Virtual Circuit.")
ipoaVcVci = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 2), IpoaVciInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaVcVci.setDescription("The VCI value for the Virtual Circuit.")
ipoaVcType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 3), IpoaAtmConnKind()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaVcType.setDescription("The type of the Virtual Circuit.")
ipoaVcNegotiatedEncapsType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 4), IpoaEncapsType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaVcNegotiatedEncapsType.setDescription("The encapsulation type used when communicating over\nthis circuit.")
ipoaVcNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaVcNegotiatedMtu.setDescription("The MTU used when communicating over this circuit.")
ipoaConfigPvcTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 8))
if mibBuilder.loadTexts: ipoaConfigPvcTable.setDescription("This table MUST be supported when PVCs are intended to\nbe supported in order to enable the setup of PVCs for\nuse by IP.")
ipoaConfigPvcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1)).setIndexNames((0, "IPOA-MIB", "ipoaConfigPvcIfIndex"), (0, "IPOA-MIB", "ipoaConfigPvcVpi"), (0, "IPOA-MIB", "ipoaConfigPvcVci"))
if mibBuilder.loadTexts: ipoaConfigPvcEntry.setDescription("Defines a single PVC that exists at this host for\nuse by IP.")
ipoaConfigPvcIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaConfigPvcIfIndex.setDescription("The ifIndex of the ATM Interface that this PVC\nis associated with.")
ipoaConfigPvcVpi = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 2), IpoaVpiInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaConfigPvcVpi.setDescription("The VPI value for the Virtual Circuit.")
ipoaConfigPvcVci = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 3), IpoaVciInteger()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipoaConfigPvcVci.setDescription("The VCI value for the Virtual Circuit.")
ipoaConfigPvcDefaultMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaConfigPvcDefaultMtu.setDescription("Classical IP and ARP over ATM allows use of\nother MTU values for PVCs but considers how a\nvalue other than 9180 could be selected to be out\nof scope.  ipoaConfigPvcDefaultMtu can be used to\nconfigure the MTU to be used for the PVC.\nBoth ends MUST have the same value configured.")
ipoaConfigPvcRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaConfigPvcRowStatus.setDescription("This object allows rows to be created and deleted in\nthe ipoaConfigPvcTable.  Creation of an entry in this\ntable should eventually result in the creation of an\nipNetToMediaEntry and a corresponding ipoaVcEntry\nafter InATMARP has determined the destination address\nof the remote system that the PVC is connected to.\nSetting this object to destroy(6) should remove the\ncorresponding ipNetToMediaTable and ipoaVcTable\nentries.")
ipoaNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 2))
ipoaTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 2, 0))
ipoaConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 3))
ipoaGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 3, 1))
ipoaCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 3, 2))

# Augmentions

# Notifications

ipoaMtuExceeded = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 1)).setObjects(("IPOA-MIB", "ipoaVcNegotiatedMtu"), )
if mibBuilder.loadTexts: ipoaMtuExceeded.setDescription("A frame was received that exceeds the negotiated\nMTU size.  The VPI and VCI of the VC for which this\ncondition was detected can be determined from the\nindex values for ipoaVcNegotiatedMtu.  In addition,\nthe ifIndex and IP Address can be determined as\nwell (refer to the ipoaVcTable).")
ipoaDuplicateIpAddress = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 2)).setObjects(("IP-MIB", "ipNetToMediaPhysAddress"), ("IP-MIB", "ipNetToMediaNetAddress"), ("IP-MIB", "ipNetToMediaIfIndex"), )
if mibBuilder.loadTexts: ipoaDuplicateIpAddress.setDescription("The ATMARP Server has detected more than one ATM end\npoint attempting to associate the same IP address with\ndifferent ATM addresses.")
ipoaLisCreate = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 3)).setObjects(("IPOA-MIB", "ipoaLisSubnetAddr"), )
if mibBuilder.loadTexts: ipoaLisCreate.setDescription("Generation of this trap occurs when an ipoaLisEntry is\ncreated while the ipoaLisTrapEnable.0 object has the\nvalue enabled(1).")
ipoaLisDelete = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 4)).setObjects(("IPOA-MIB", "ipoaLisSubnetAddr"), )
if mibBuilder.loadTexts: ipoaLisDelete.setDescription("Generation of this trap occurs when an ipoaLisEntry is\ndeleted while the ipoaLisTrapEnable.0 object has the\nvalue enabled(1).")

# Groups

ipoaGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 1)).setObjects(("IPOA-MIB", "ipoaVcNegotiatedMtu"), ("IPOA-MIB", "ipoaVcNegotiatedEncapsType"), ("IPOA-MIB", "ipoaVcType"), ("IPOA-MIB", "ipoaConfigPvcDefaultMtu"), ("IPOA-MIB", "ipoaConfigPvcRowStatus"), )
if mibBuilder.loadTexts: ipoaGeneralGroup.setDescription("This group is mandatory for all IP over ATM entities.")
ipoaClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 2)).setObjects(("IPOA-MIB", "ipoaArpClientAtmAddr"), ("IPOA-MIB", "ipoaArpClientArpOutNaks"), ("IPOA-MIB", "ipoaArpClientInArpInvalidInReqs"), ("IPOA-MIB", "ipoaArpClientArpOutReqs"), ("IPOA-MIB", "ipoaArpClientInArpInReplies"), ("IPOA-MIB", "ipoaArpClientArpOutReplies"), ("IPOA-MIB", "ipoaArpClientArpInReqs"), ("IPOA-MIB", "ipoaArpClientInArpInReqs"), ("IPOA-MIB", "ipoaArpClientArpInReplies"), ("IPOA-MIB", "ipoaArpClientArpUnknownOps"), ("IPOA-MIB", "ipoaArpClientInArpOutReplies"), ("IPOA-MIB", "ipoaArpClientSrvrInUse"), ("IPOA-MIB", "ipoaArpClientInArpOutReqs"), ("IPOA-MIB", "ipoaArpClientArpInNaks"), ("IPOA-MIB", "ipoaArpClientInArpInvalidOutReqs"), ("IPOA-MIB", "ipoaArpClientArpNoSrvrResps"), ("IPOA-MIB", "ipoaArpClientRowStatus"), )
if mibBuilder.loadTexts: ipoaClientGroup.setDescription("This group is mandatory for all hosts where an IP\nover ATM client is present.")
ipoaSrvrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 3)).setObjects(("IPOA-MIB", "ipoaArpSrvrArpDupIpAddrs"), ("IPOA-MIB", "ipoaArpSrvrInArpInvalidOutReqs"), ("IPOA-MIB", "ipoaArpSrvrArpOutReplies"), ("IPOA-MIB", "ipoaArpSrvrLis"), ("IPOA-MIB", "ipoaArpSrvrArpUnknownOps"), ("IPOA-MIB", "ipoaArpSrvrInArpInReqs"), ("IPOA-MIB", "ipoaArpSrvrRowStatus"), ("IPOA-MIB", "ipoaArpSrvrArpInReqs"), ("IPOA-MIB", "ipoaArpSrvrInArpInvalidInReqs"), ("IPOA-MIB", "ipoaArpSrvrInArpInReplies"), ("IPOA-MIB", "ipoaArpSrvrInArpOutReqs"), ("IPOA-MIB", "ipoaArpSrvrInArpOutReplies"), ("IPOA-MIB", "ipoaArpSrvrArpOutNaks"), )
if mibBuilder.loadTexts: ipoaSrvrGroup.setDescription("This group is mandatory for all hosts where ATMARP\nServers are present.")
ipoaBasicNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 4)).setObjects(("IPOA-MIB", "ipoaMtuExceeded"), )
if mibBuilder.loadTexts: ipoaBasicNotificationsGroup.setDescription("The notification which an IP over ATM entity\nis required to implement.")
ipoaSrvrNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 5)).setObjects(("IPOA-MIB", "ipoaDuplicateIpAddress"), )
if mibBuilder.loadTexts: ipoaSrvrNotificationsGroup.setDescription("The notification which an IP over ATM ATMARP\nServer is required to implement.")
ipoaLisNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 6)).setObjects(("IPOA-MIB", "ipoaLisCreate"), ("IPOA-MIB", "ipoaLisDelete"), )
if mibBuilder.loadTexts: ipoaLisNotificationsGroup.setDescription("The LIS-related notifications which are required\nto be implemented by an IP over ATM ATMARP server,\nas well as by any IP over ATM client which allows\nipoaLisTrapEnable to be set to enabled(1).")
ipoaLisTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 7)).setObjects(("IPOA-MIB", "ipoaLisInactivityTimer"), ("IPOA-MIB", "ipoaLisQDepth"), ("IPOA-MIB", "ipoaLisDefaultPeakCellRate"), ("IPOA-MIB", "ipoaLisTrapEnable"), ("IPOA-MIB", "ipoaLisSubnetAddr"), ("IPOA-MIB", "ipoaArpRemoteSrvrOperStatus"), ("IPOA-MIB", "ipoaLisTimeout"), ("IPOA-MIB", "ipoaLisIfMappingRowStatus"), ("IPOA-MIB", "ipoaLisMinHoldingTime"), ("IPOA-MIB", "ipoaArpRemoteSrvrRowStatus"), ("IPOA-MIB", "ipoaLisDefaultMtu"), ("IPOA-MIB", "ipoaLisRowStatus"), ("IPOA-MIB", "ipoaArpRemoteSrvrIpAddr"), ("IPOA-MIB", "ipoaLisDefaultEncapsType"), ("IPOA-MIB", "ipoaArpRemoteSrvrAdminStatus"), ("IPOA-MIB", "ipoaLisRetries"), ("IPOA-MIB", "ipoaLisCacheEntryAge"), ("IPOA-MIB", "ipoaLisActiveVcs"), ("IPOA-MIB", "ipoaLisMaxCalls"), )
if mibBuilder.loadTexts: ipoaLisTableGroup.setDescription("This group is mandatory for all entities which\nsupport IP over ATM SVCs.  Support of objects in\nthis group by IP over ATM clients which only\nsupport IP over ATM PVCs is optional.")

# Compliances

ipoaCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 46, 3, 2, 1)).setObjects(("IPOA-MIB", "ipoaClientGroup"), ("IPOA-MIB", "ipoaSrvrGroup"), ("IPOA-MIB", "ipoaGeneralGroup"), ("IPOA-MIB", "ipoaLisNotificationsGroup"), ("IPOA-MIB", "ipoaLisTableGroup"), ("IPOA-MIB", "ipoaSrvrNotificationsGroup"), ("IPOA-MIB", "ipoaBasicNotificationsGroup"), )
if mibBuilder.loadTexts: ipoaCompliance.setDescription("The compliance statement for agents that support the\nIPOA-MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("IPOA-MIB", PYSNMP_MODULE_ID=ipoaMIB)

# Types
mibBuilder.exportSymbols("IPOA-MIB", IpoaAtmAddr=IpoaAtmAddr, IpoaAtmConnKind=IpoaAtmConnKind, IpoaEncapsType=IpoaEncapsType, IpoaVciInteger=IpoaVciInteger, IpoaVpiInteger=IpoaVpiInteger)

# Objects
mibBuilder.exportSymbols("IPOA-MIB", ipoaMIB=ipoaMIB, ipoaObjects=ipoaObjects, ipoaLisTrapEnable=ipoaLisTrapEnable, ipoaLisTable=ipoaLisTable, ipoaLisEntry=ipoaLisEntry, ipoaLisSubnetAddr=ipoaLisSubnetAddr, ipoaLisDefaultMtu=ipoaLisDefaultMtu, ipoaLisDefaultEncapsType=ipoaLisDefaultEncapsType, ipoaLisInactivityTimer=ipoaLisInactivityTimer, ipoaLisMinHoldingTime=ipoaLisMinHoldingTime, ipoaLisQDepth=ipoaLisQDepth, ipoaLisMaxCalls=ipoaLisMaxCalls, ipoaLisCacheEntryAge=ipoaLisCacheEntryAge, ipoaLisRetries=ipoaLisRetries, ipoaLisTimeout=ipoaLisTimeout, ipoaLisDefaultPeakCellRate=ipoaLisDefaultPeakCellRate, ipoaLisActiveVcs=ipoaLisActiveVcs, ipoaLisRowStatus=ipoaLisRowStatus, ipoaLisIfMappingTable=ipoaLisIfMappingTable, ipoaLisIfMappingEntry=ipoaLisIfMappingEntry, ipoaLisIfMappingIfIndex=ipoaLisIfMappingIfIndex, ipoaLisIfMappingRowStatus=ipoaLisIfMappingRowStatus, ipoaArpClientTable=ipoaArpClientTable, ipoaArpClientEntry=ipoaArpClientEntry, ipoaArpClientAtmAddr=ipoaArpClientAtmAddr, ipoaArpClientSrvrInUse=ipoaArpClientSrvrInUse, ipoaArpClientInArpInReqs=ipoaArpClientInArpInReqs, ipoaArpClientInArpOutReqs=ipoaArpClientInArpOutReqs, ipoaArpClientInArpInReplies=ipoaArpClientInArpInReplies, ipoaArpClientInArpOutReplies=ipoaArpClientInArpOutReplies, ipoaArpClientInArpInvalidInReqs=ipoaArpClientInArpInvalidInReqs, ipoaArpClientInArpInvalidOutReqs=ipoaArpClientInArpInvalidOutReqs, ipoaArpClientArpInReqs=ipoaArpClientArpInReqs, ipoaArpClientArpOutReqs=ipoaArpClientArpOutReqs, ipoaArpClientArpInReplies=ipoaArpClientArpInReplies, ipoaArpClientArpOutReplies=ipoaArpClientArpOutReplies, ipoaArpClientArpInNaks=ipoaArpClientArpInNaks, ipoaArpClientArpOutNaks=ipoaArpClientArpOutNaks, ipoaArpClientArpUnknownOps=ipoaArpClientArpUnknownOps, ipoaArpClientArpNoSrvrResps=ipoaArpClientArpNoSrvrResps, ipoaArpClientRowStatus=ipoaArpClientRowStatus, ipoaArpSrvrTable=ipoaArpSrvrTable, ipoaArpSrvrEntry=ipoaArpSrvrEntry, ipoaArpSrvrAddr=ipoaArpSrvrAddr, ipoaArpSrvrLis=ipoaArpSrvrLis, ipoaArpSrvrInArpInReqs=ipoaArpSrvrInArpInReqs, ipoaArpSrvrInArpOutReqs=ipoaArpSrvrInArpOutReqs, ipoaArpSrvrInArpInReplies=ipoaArpSrvrInArpInReplies, ipoaArpSrvrInArpOutReplies=ipoaArpSrvrInArpOutReplies, ipoaArpSrvrInArpInvalidInReqs=ipoaArpSrvrInArpInvalidInReqs, ipoaArpSrvrInArpInvalidOutReqs=ipoaArpSrvrInArpInvalidOutReqs, ipoaArpSrvrArpInReqs=ipoaArpSrvrArpInReqs, ipoaArpSrvrArpOutReplies=ipoaArpSrvrArpOutReplies, ipoaArpSrvrArpOutNaks=ipoaArpSrvrArpOutNaks, ipoaArpSrvrArpDupIpAddrs=ipoaArpSrvrArpDupIpAddrs, ipoaArpSrvrArpUnknownOps=ipoaArpSrvrArpUnknownOps, ipoaArpSrvrRowStatus=ipoaArpSrvrRowStatus, ipoaArpRemoteSrvrTable=ipoaArpRemoteSrvrTable, ipoaArpRemoteSrvrEntry=ipoaArpRemoteSrvrEntry, ipoaArpRemoteSrvrAtmAddr=ipoaArpRemoteSrvrAtmAddr, ipoaArpRemoteSrvrRowStatus=ipoaArpRemoteSrvrRowStatus, ipoaArpRemoteSrvrIfIndex=ipoaArpRemoteSrvrIfIndex, ipoaArpRemoteSrvrIpAddr=ipoaArpRemoteSrvrIpAddr, ipoaArpRemoteSrvrAdminStatus=ipoaArpRemoteSrvrAdminStatus, ipoaArpRemoteSrvrOperStatus=ipoaArpRemoteSrvrOperStatus, ipoaVcTable=ipoaVcTable, ipoaVcEntry=ipoaVcEntry, ipoaVcVpi=ipoaVcVpi, ipoaVcVci=ipoaVcVci, ipoaVcType=ipoaVcType, ipoaVcNegotiatedEncapsType=ipoaVcNegotiatedEncapsType, ipoaVcNegotiatedMtu=ipoaVcNegotiatedMtu, ipoaConfigPvcTable=ipoaConfigPvcTable, ipoaConfigPvcEntry=ipoaConfigPvcEntry, ipoaConfigPvcIfIndex=ipoaConfigPvcIfIndex, ipoaConfigPvcVpi=ipoaConfigPvcVpi, ipoaConfigPvcVci=ipoaConfigPvcVci, ipoaConfigPvcDefaultMtu=ipoaConfigPvcDefaultMtu, ipoaConfigPvcRowStatus=ipoaConfigPvcRowStatus, ipoaNotifications=ipoaNotifications, ipoaTrapPrefix=ipoaTrapPrefix, ipoaConformance=ipoaConformance, ipoaGroups=ipoaGroups, ipoaCompliances=ipoaCompliances)

# Notifications
mibBuilder.exportSymbols("IPOA-MIB", ipoaMtuExceeded=ipoaMtuExceeded, ipoaDuplicateIpAddress=ipoaDuplicateIpAddress, ipoaLisCreate=ipoaLisCreate, ipoaLisDelete=ipoaLisDelete)

# Groups
mibBuilder.exportSymbols("IPOA-MIB", ipoaGeneralGroup=ipoaGeneralGroup, ipoaClientGroup=ipoaClientGroup, ipoaSrvrGroup=ipoaSrvrGroup, ipoaBasicNotificationsGroup=ipoaBasicNotificationsGroup, ipoaSrvrNotificationsGroup=ipoaSrvrNotificationsGroup, ipoaLisNotificationsGroup=ipoaLisNotificationsGroup, ipoaLisTableGroup=ipoaLisTableGroup)

# Compliances
mibBuilder.exportSymbols("IPOA-MIB", ipoaCompliance=ipoaCompliance)
