# PySNMP SMI module. Autogenerated from smidump -f python IPSEC-SPD-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:43 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IfDirection, diffServMIBMultiFieldClfrGroup, diffServMultiFieldClfrNextFree, ) = mibBuilder.importSymbols("DIFFSERV-MIB", "IfDirection", "diffServMIBMultiFieldClfrGroup", "diffServMultiFieldClfrNextFree")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, VariablePointer, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue", "VariablePointer")

# Types

class SpdAdminStatus(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,)
    namedValues = namedval.NamedValues(("enabled", 1), ("disabled", 2), )
    
class SpdBooleanOperator(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,)
    namedValues = namedval.NamedValues(("or", 1), ("and", 2), )
    
class SpdIPPacketLogging(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(-1,65535)
    
class SpdTimePeriod(TextualConvention, OctetString):
    displayHint = "31t"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,31)
    

# Objects

spdMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 153)).setRevisions(("2007-02-07 00:00",))
if mibBuilder.loadTexts: spdMIB.setOrganization("IETF IP Security Policy Working Group")
if mibBuilder.loadTexts: spdMIB.setContactInfo("Michael Baer\nP.O. Box 72682\nDavis, CA 95617\nPhone: +1 530 902 3131\nEmail: baerm@tislabs.com\n\nRicky Charlet\nEmail: rcharlet@alumni.calpoly.edu\n\nWes Hardaker\nSparta, Inc.\nP.O. Box 382\nDavis, CA  95617\nPhone: +1 530 792 1913\nEmail: hardaker@tislabs.com\n\nRobert Story\nRevelstone Software\nPO Box 1812\n\n\n\nTucker, GA 30085\nPhone: +1 770 617 3722\nEmail: rstory@ipsp.revelstone.com\n\nCliff Wang\nARO\n4300 S. Miami Blvd.\nDurham, NC 27703\nE-Mail: cliffwangmail@yahoo.com")
if mibBuilder.loadTexts: spdMIB.setDescription("This MIB module defines configuration objects for managing\nIPsec Security Policies.  In general, this MIB can be\nimplemented anywhere IPsec security services exist (e.g.,\nbump-in-the-wire, host, gateway, firewall, router, etc.).\n\nCopyright (C) The IETF Trust (2007).  This version of\nthis MIB module is part of RFC 4807; see the RFC itself for\nfull legal notices.")
spdConfigObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 1))
spdLocalConfigObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 1, 1))
spdIngressPolicyGroupName = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: spdIngressPolicyGroupName.setDescription("This object indicates the global system policy group that\nis to be applied on ingress packets (i.e., arriving at an\ninterface from a network) when a given endpoint does not\ncontain a policy definition in the spdEndpointToGroupTable.\nIts value can be used as an index into the\nspdGroupContentsTable to retrieve a list of policies.  A\nzero length string indicates that no system-wide policy exists\nand the default policy of 'drop' SHOULD be executed for\ningress packets until one is imposed by either this object\nor by the endpoint processing a given packet.\n\nThis object MUST be persistent")
spdEgressPolicyGroupName = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32)).clone('')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: spdEgressPolicyGroupName.setDescription("This object indicates the policy group containing the\nglobal system policy that is to be applied on egress\npackets (i.e., packets leaving an interface and entering a\nnetwork) when a given endpoint does not contain a policy\ndefinition in the spdEndpointToGroupTable.  Its value can\nbe used as an index into the spdGroupContentsTable to\nretrieve a list of policies.  A zero length string\nindicates that no system-wide policy exists and the default\npolicy of 'drop' SHOULD be executed for egress packets\nuntil one is imposed by either this object or by the\nendpoint processing a given packet.\n\nThis object MUST be persistent")
spdEndpointToGroupTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 2))
if mibBuilder.loadTexts: spdEndpointToGroupTable.setDescription("This table maps policies (groupings) onto an endpoint\n(interface).  A policy group assigned to an endpoint is then\nused to control access to the network traffic passing\nthrough that endpoint.\n\n\n\n\nIf an endpoint has been configured with a policy group and\nno rule within that policy group matches that packet, the\ndefault action in this case SHALL be to drop the packet.\n\nIf no policy group has been assigned to an endpoint, then\nthe policy group specified by spdIngressPolicyGroupName MUST\nbe used on traffic inbound from the network through that\nendpoint, and the policy group specified by\nspdEgressPolicyGroupName MUST be used for traffic outbound\nto the network through that endpoint.")
spdEndpointToGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 2, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdEndGroupDirection"), (0, "IPSEC-SPD-MIB", "spdEndGroupInterface"))
if mibBuilder.loadTexts: spdEndpointToGroupEntry.setDescription("A mapping assigning a policy group to an endpoint.")
spdEndGroupDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 2, 1, 1), IfDirection()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdEndGroupDirection.setDescription("This object indicates which direction of packets crossing\nthe interface are associated with which spdEndGroupName\nobject.  Ingress packets, or packets into the device match\nwhen this value is inbound(1).  Egress packets or packets\nout of the device match when this value is outbound(2).")
spdEndGroupInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 2, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdEndGroupInterface.setDescription("This value matches the IF-MIB's ifTable's ifIndex column\nand indicates the interface associated with a given\nendpoint.  This object can be used to uniquely identify an\nendpoint that a set of policy groups are applied to.")
spdEndGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 2, 1, 3), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdEndGroupName.setDescription("The policy group name to apply at this endpoint.  The\nvalue of the spdEndGroupName object is then used as an\nindex into the spdGroupContentsTable to come up with a list\nof rules that MUST be applied at this endpoint.")
spdEndGroupLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 2, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdEndGroupLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdEndGroupStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 2, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdEndGroupStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a storage\ntype of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdEndGroupRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 2, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdEndGroupRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nThis object is considered 'notReady' and MUST NOT be set to\nactive until one or more active rows exist within the\nspdGroupContentsTable for the group referenced by the\nspdEndGroupName object.")
spdGroupContentsTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 3))
if mibBuilder.loadTexts: spdGroupContentsTable.setDescription("This table contains a list of rules and/or subgroups\ncontained within a given policy group.  For a given value\nof spdGroupContName, the set of rows sharing that value\nforms a 'group'.  The rows in a group MUST be processed\naccording to the value of the spdGroupContPriority object\nin each row.  The processing MUST be executed starting with\nthe lowest value of spdGroupContPriority and in ascending\norder thereafter.\n\nIf an action is executed as the result of the processing of\na row in a group, the processing of further rows in that\ngroup MUST stop.  Iterating to the next policy group row by\nfinding the next largest spdGroupContPriority object SHALL\nonly be done if no actions were run while processing the\ncurrent row for a given packet.")
spdGroupContentsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 3, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdGroupContName"), (0, "IPSEC-SPD-MIB", "spdGroupContPriority"))
if mibBuilder.loadTexts: spdGroupContentsEntry.setDescription("Defines a given sub-component within a policy group.  A\nsub-component is either a rule or another group as\nindicated by spdGroupContComponentType and referenced by\nspdGroupContComponentName.")
spdGroupContName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdGroupContName.setDescription("The administrative name of the group associated with this\nrow.  A 'group' is formed by all the rows in this table that\nhave the same value of this object.")
spdGroupContPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdGroupContPriority.setDescription("The priority (sequence number) of the sub-component in\na group that this row represents.  This value indicates\nthe order that each row of this table MUST be processed\nfrom low to high.  For example, a row with a priority of 0\nis processed before a row with a priority of 1, a 1 before\na 2, etc.")
spdGroupContFilter = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 3), VariablePointer().clone('1.3.6.1.2.1.153.1.7.1.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdGroupContFilter.setDescription("spdGroupContFilter points to a filter that is evaluated\nto determine whether the spdGroupContComponentName within\nthis row is exercised.  Managers can use this object to\nclassify groups of rules, or subgroups, together in order to\nachieve a greater degree of control and optimization over\nthe execution order of the items within the group.  If the\n\n\n\nfilter evaluates to false, the rule or subgroup will be\nskipped and the next rule or subgroup will be evaluated\ninstead.  This value can be used to indicate a scalar or\nrow in a table.  When indicating a row in a table, this\nvalue MUST point to the first column instance in that row.\n\nAn example usage of this object would be to limit a\ngroup of rules to executing only when the IP packet\nbeing processed is designated to be processed by IKE.\nThis effectively creates a group of IKE-specific rules.\n\nThe following tables and scalars can be pointed to by this\ncolumn.  All but diffServMultiFieldClfrTable are defined in\nthis MIB:\n\n       diffServMultiFieldClfrTable\n       spdIpOffsetFilterTable\n       spdTimeFilterTable\n       spdCompoundFilterTable\n       spdTrueFilter\n       spdIpsoHeaderFilterTable\n\nImplementations MAY choose to provide support for other\nfilter tables or scalars.\n\nIf this column is set to a VariablePointer value, which\nreferences a non-existent row in an otherwise supported\ntable, the inconsistentName exception MUST be returned.  If\nthe table or scalar pointed to by the VariablePointer is\nnot supported at all, then an inconsistentValue exception\nMUST be returned.\n\nIf, during packet processing, a row in this table is applied\nto a packet and the value of this column in that row\nreferences a non-existent or non-supported object, the\npacket MUST be dropped.")
spdGroupContComponentType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("group", 1), ("rule", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdGroupContComponentType.setDescription("Indicates whether the spdGroupContComponentName object\nis the name of another group defined within the\nspdGroupContentsTable or is the name of a rule defined\n\n\n\nwithin the spdRuleDefinitionTable.")
spdGroupContComponentName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 5), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdGroupContComponentName.setDescription("The name of the policy rule or subgroup contained within\nthis row, as indicated by the spdGroupContComponentType\nobject.")
spdGroupContLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdGroupContLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem,\nthis object SHOULD have a zero value.")
spdGroupContStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 7), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdGroupContStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a storage\ntype of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdGroupContRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 3, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdGroupContRowStatus.setDescription("This object indicates the conceptual status of this row.\n\n\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nThis object MUST NOT be set to active until the row to\nwhich the spdGroupContComponentName points to exists and is\nactive.\n\nIf active, this object MUST remain active unless one of the\nfollowing two conditions are met:\n\nI.  No active row in spdEndpointToGroupTable exists that\n    references this row's group (i.e., indicate this row's\n    spdGroupContName).\n\nII. Or at least one other active row in this table has a\n    matching spdGroupContName.\n\nIf neither condition is met, an attempt to set this row to\nsomething other than active MUST result in an\ninconsistentValue error.")
spdRuleDefinitionTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 4))
if mibBuilder.loadTexts: spdRuleDefinitionTable.setDescription("This table defines a rule by associating a filter\nor a set of filters to an action to be executed.")
spdRuleDefinitionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 4, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdRuleDefName"))
if mibBuilder.loadTexts: spdRuleDefinitionEntry.setDescription("A row defining a particular rule definition.  A rule\ndefinition binds a filter pointer to an action pointer.")
spdRuleDefName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdRuleDefName.setDescription("spdRuleDefName is the administratively assigned name of\nthe rule referred to by the spdGroupContComponentName\nobject.")
spdRuleDefDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 2), SnmpAdminString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefDescription.setDescription("A user defined string.  This field MAY be used for\nadministrative tracking purposes.")
spdRuleDefFilter = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 3), VariablePointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefFilter.setDescription("spdRuleDefFilter points to a filter that is used to\nevaluate whether the action associated with this row is\nexecuted or not.  The action will only execute if the\nfilter referenced by this object evaluates to TRUE after\nfirst applying any negation required by the\nspdRuleDefFilterNegated object.\n\nThe following tables and scalars can be pointed to by this\ncolumn.  All but diffServMultiFieldClfrTable are defined in\nthis MIB.  Implementations MAY choose to provide support\nfor other filter tables or scalars as well:\n\n       diffServMultiFieldClfrTable\n\n\n\n       spdIpOffsetFilterTable\n       spdTimeFilterTable\n       spdCompoundFilterTable\n       spdTrueFilter\n\nIf this column is set to a VariablePointer value, which\nreferences a non-existent row in an otherwise supported\ntable, the inconsistentName exception MUST be returned.  If\nthe table or scalar pointed to by the VariablePointer is\nnot supported at all, then an inconsistentValue exception\nMUST be returned.\n\nIf, during packet processing, this column has a value that\nreferences a non-existent or non-supported object, the\npacket MUST be dropped.")
spdRuleDefFilterNegated = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 4), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefFilterNegated.setDescription("spdRuleDefFilterNegated specifies whether or not the results of\nthe filter referenced by the spdRuleDefFilter object is\nnegated.")
spdRuleDefAction = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 5), VariablePointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefAction.setDescription("This column points to the action to be taken.  It MAY,\nbut is not limited to, point to a row in one of the\nfollowing tables:\n\n   spdCompoundActionTable\n   ipsaSaPreconfiguredActionTable\n   ipiaIkeActionTable\n   ipiaIpsecActionTable\n\nIt MAY also point to one of the scalar objects beneath\nspdStaticActions.\n\nIf this object is set to a pointer to a row in an\nunsupported (or unknown) table, an inconsistentValue\n\n\n\nerror MUST be returned.\n\nIf this object is set to point to a non-existent row in an\notherwise supported table, an inconsistentName error MUST\nbe returned.\n\nIf, during packet processing, this column has a value that\nreferences a non-existent or non-supported object, the\npacket MUST be dropped.")
spdRuleDefAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 6), SpdAdminStatus().clone('enabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefAdminStatus.setDescription("Indicates whether the current rule definition is considered\nactive.  If the value is enabled, the rule MUST be evaluated\nwhen processing packets.  If the value is disabled, the\npacket processing MUST continue as if this rule's filter\nhad effectively failed.")
spdRuleDefLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdRuleDefLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdRuleDefStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 8), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a\nstorage type of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\n\n\n\nto be writable.")
spdRuleDefRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 4, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdRuleDefRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nThis object MUST NOT be set to active until the containing\nconditions, filters, and actions have been defined.  Once\nactive, it MUST remain active until no active\npolicyGroupContents entries are referencing it.  A failed\nattempt to do so MUST return an inconsistentValue error.")
spdCompoundFilterTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 5))
if mibBuilder.loadTexts: spdCompoundFilterTable.setDescription("A table defining compound filters and their associated\nparameters.  A row in this table can be pointed to by a\nspdRuleDefFilter object.")
spdCompoundFilterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 5, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdCompFiltName"))
if mibBuilder.loadTexts: spdCompoundFilterEntry.setDescription("An entry in the spdCompoundFilterTable.  Each entry in this\ntable represents a compound filter.  A filter defined by\nthis table is considered to have a TRUE return value if and\nonly if:\n\nspdCompFiltLogicType is AND and all of the sub-filters\nassociated with it, as defined in the spdSubfiltersTable,\nare all true themselves (after applying any required\n\n\n\nnegation, as defined by the ficFilterIsNegated object).\n\nspdCompFiltLogicType is OR and at least one of the\nsub-filters associated with it, as defined in the\nspdSubfiltersTable, is true itself (after applying any\nrequired negation, as defined by the ficFilterIsNegated\nobject.")
spdCompFiltName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 5, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdCompFiltName.setDescription("A user definable string.  This value is used as an index\ninto this table.")
spdCompFiltDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 5, 1, 2), SnmpAdminString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompFiltDescription.setDescription("A user definable string.  This field MAY be used for\nyour administrative tracking purposes.")
spdCompFiltLogicType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 5, 1, 3), SpdBooleanOperator().clone('and')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompFiltLogicType.setDescription("Indicates whether the sub-component filters of this\ncompound filter are functionally ANDed or ORed together.")
spdCompFiltLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 5, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdCompFiltLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdCompFiltStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 5, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompFiltStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a\nstorage type of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdCompFiltRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 5, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompFiltRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nOnce active, it MUST NOT have its value changed if any\nactive rows in the spdRuleDefinitionTable are currently\npointing at this row.")
spdSubfiltersTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 6))
if mibBuilder.loadTexts: spdSubfiltersTable.setDescription("This table defines a list of filters contained within a\ngiven compound filter defined in the\nspdCompoundFilterTable.")
spdSubfiltersEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 6, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdCompFiltName"), (0, "IPSEC-SPD-MIB", "spdSubFiltPriority"))
if mibBuilder.loadTexts: spdSubfiltersEntry.setDescription("An entry in the spdSubfiltersTable.  There is an entry in\nthis table for each sub-filter of all compound filters\npresent in the spdCompoundFilterTable.")
spdSubFiltPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 6, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdSubFiltPriority.setDescription("The priority of a given filter within a compound filter.\nThe order of execution is from lowest to highest priority\nvalue (i.e., priority 0 before priority 1, 1 before 2,\netc.).  Implementations MAY choose to follow this ordering,\nas set by the manager that created the rows.  This can allow\na manager to intelligently construct filter lists such that\nfaster filters are evaluated first.")
spdSubFiltSubfilter = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 6, 1, 2), VariablePointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubFiltSubfilter.setDescription("The OID of the contained filter.  The value of this\nobject is a VariablePointer that references the filter to\nbe included in this compound filter.\n\nThe following tables and scalars can be pointed to by this\ncolumn.  All but diffServMultiFieldClfrTable are defined in\nthis MIB.  Implementations MAY choose to provide support\nfor other filter tables or scalars as well:\n\n       diffServMultiFieldClfrTable\n       spdIpsoHeaderFilterTable\n       spdIpOffsetFilterTable\n       spdTimeFilterTable\n       spdCompoundFilterTable\n       spdTrueFilter\n\nIf this column is set to a VariablePointer value that\nreferences a non-existent row in an otherwise supported\ntable, the inconsistentName exception MUST be returned.  If\nthe table or scalar pointed to by the VariablePointer is\nnot supported at all, then an inconsistentValue exception\nMUST be returned.\n\nIf, during packet processing, this column has a value that\nreferences a non-existent or non-supported object, the\npacket MUST be dropped.")
spdSubFiltSubfilterIsNegated = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 6, 1, 3), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubFiltSubfilterIsNegated.setDescription("Indicates whether or not the result of applying this sub-filter\nis negated.")
spdSubFiltLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 6, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdSubFiltLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\n\n\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdSubFiltStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 6, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubFiltStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a\nstorage type of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdSubFiltRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 6, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubFiltRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nThis object cannot be made active until a filter\nreferenced by the spdSubFiltSubfilter object is both\ndefined and active.  An attempt to do so MUST result in\nan inconsistentValue error.\n\nIf active, this object MUST remain active unless one of the\nfollowing two conditions are met:\n\nI.  No active row in the SpdCompoundFilterTable exists\n    that has a matching spdCompFiltName.\n\nII. Or, at least one other active row in this table has a\n    matching spdCompFiltName.\n\nIf neither condition is met, an attempt to set this row to\nsomething other than active MUST result in an\ninconsistentValue error.")
spdStaticFilters = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 1, 7))
spdTrueFilter = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 7, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdTrueFilter.setDescription("This scalar indicates a (automatic) true result for\na filter.  That is, this is a filter that is always\ntrue; it is useful for adding as a default filter for a\ndefault action or a set of actions.")
spdTrueFilterInstance = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 1, 7, 1, 0))
spdIpOffsetFilterTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 8))
if mibBuilder.loadTexts: spdIpOffsetFilterTable.setDescription("This table contains a list of filter definitions to be\nused within the spdRuleDefinitionTable or the\nspdSubfiltersTable.\n\nThis type of filter is used to compare an administrator\nspecified octet string to the octets at a particular\nlocation in a packet.")
spdIpOffsetFilterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 8, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdIpOffFiltName"))
if mibBuilder.loadTexts: spdIpOffsetFilterEntry.setDescription("A definition of a particular filter.")
spdIpOffFiltName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdIpOffFiltName.setDescription("The administrative name for this filter.")
spdIpOffFiltOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpOffFiltOffset.setDescription("This is the byte offset from the front of the entire IP\npacket where the value or arithmetic comparison is done.  A\nvalue of '0' indicates the first byte of the packet header.\nIf this value is greater than the length of the packet, the\nfilter represented by this row should be considered to\nfail.")
spdIpOffFiltType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,6,4,3,5,)).subtype(namedValues=namedval.NamedValues(("equal", 1), ("notEqual", 2), ("arithmeticLess", 3), ("arithmeticGreaterOrEqual", 4), ("arithmeticGreater", 5), ("arithmeticLessOrEqual", 6), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpOffFiltType.setDescription("This defines the various tests that are used when\nevaluating a given filter.\n\nThe various tests definable in this table are as follows:\n\nequal:\n  - Tests if the OCTET STRING, 'spdIpOffFiltValue', matches\n\n\n\n    a value in the packet starting at the given offset in\n    the packet and comparing the entire OCTET STRING of\n    'spdIpOffFiltValue'.  Any values compared this way are\n    assumed to be unsigned integer values in network byte\n    order of the same length as 'spdIpOffFiltValue'.\n\nnotEqual:\n  - Tests if the OCTET STRING, 'spdIpOffFiltValue', does\n    not match a value in the packet starting at the given\n    offset in the packet and comparing to the entire OCTET\n    STRING of 'spdIpOffFiltValue'.  Any values compared\n    this way are assumed to be unsigned integer values in\n    network byte order of the same length as\n    'spdIpOffFiltValue'.\n\narithmeticLess:\n  - Tests if the OCTET STRING, 'spdIpOffFiltValue', is\n    arithmetically less than ('<') the value starting at\n    the given offset within the packet.  The value in the\n    packet is assumed to be an unsigned integer in network\n    byte order of the same length as 'spdIpOffFiltValue'.\n\narithmeticGreaterOrEqual:\n  - Tests if the OCTET STRING, 'spdIpOffFiltValue', is\n    arithmetically greater than or equal to ('>=') the\n    value starting at the given offset within the packet.\n    The value in the packet is assumed to be an unsigned\n    integer in network byte order of the same length as\n    'spdIpOffFiltValue'.\n\narithmeticGreater:\n  - Tests if the OCTET STRING, 'spdIpOffFiltValue', is\n    arithmetically greater than ('>') the value starting at\n    the given offset within the packet.  The value in the\n    packet is assumed to be an unsigned integer in network\n    byte order of the same length as 'spdIpOffFiltValue'.\n\narithmeticLessOrEqual:\n  - Tests if the OCTET STRING, 'spdIpOffFiltValue', is\n    arithmetically less than or equal to ('<=') the value\n    starting at the given offset within the packet.  The\n    value in the packet is assumed to be an unsigned\n    integer in network byte order of the same length as\n    'spdIpOffFiltValue'.")
spdIpOffFiltValue = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1024))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpOffFiltValue.setDescription("spdIpOffFiltValue is used for match comparisons of a\npacket at spdIpOffFiltOffset.")
spdIpOffFiltLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdIpOffFiltLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdIpOffFiltStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpOffFiltStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a\nstorage type of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdIpOffFiltRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 8, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpOffFiltRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nIf active, this object MUST remain active if it is\n\n\n\nreferenced by an active row in another table.  An attempt\nto set it to anything other than active while it is\nreferenced by an active row in another table MUST result in\nan inconsistentValue error.")
spdTimeFilterTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 9))
if mibBuilder.loadTexts: spdTimeFilterTable.setDescription("Defines a table of filters that can be used to\neffectively enable or disable policies based on a valid\ntime range.")
spdTimeFilterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 9, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdTimeFiltName"))
if mibBuilder.loadTexts: spdTimeFilterEntry.setDescription("A row describing a given time frame for which a policy\nis filtered on to activate or deactivate the rule.\n\nIf all the column objects in a row are true for the current\ntime, the row evaluates as 'true'.  More explicitly, the\ntime matching column objects in a row MUST be logically\nANDed together to form the boolean true/false for the row.")
spdTimeFiltName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdTimeFiltName.setDescription("An administratively assigned name for this filter.")
spdTimeFiltPeriod = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 2), SpdTimePeriod().clone('THISANDPRIOR/THISANDFUTURE')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltPeriod.setDescription("The valid time period for this filter.  This column is\nconsidered 'true' if the current time is within the range of\nthis object.")
spdTimeFiltMonthOfYearMask = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 3), Bits().subtype(namedValues=namedval.NamedValues(("january", 0), ("february", 1), ("november", 10), ("december", 11), ("march", 2), ("april", 3), ("may", 4), ("june", 5), ("july", 6), ("august", 7), ("september", 8), ("october", 9), )).clone(("january","february","march","april","may","june","july","august","september","october","november","december",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltMonthOfYearMask.setDescription("A bit mask that indicates acceptable months of the year.\nThis column evaluates to 'true' if the current month's bit\nis set.")
spdTimeFiltDayOfMonthMask = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(8, 8)).setFixedLength(8).clone(hexValue='ffffffffffffffff')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltDayOfMonthMask.setDescription("Defines which days of the month the current time is\nvalid for.  It is a sequence of 64 BITS, where each BIT\nrepresents a corresponding day of the month in forward or\nreverse order.  Starting from the left-most bit, the first\n31 bits identify the day of the month, counting from the\nbeginning of the month.  The following 31 bits (bits 32-62)\nindicate the day of the month, counting from the end of the\n\n\n\nmonth.  For months with fewer than 31 days, the bits that\ncorrespond to the non-existent days of that month are\nignored (e.g., for non-leap year Februarys, bits 29-31 and\n60-62 are ignored).\n\nThis column evaluates to 'true' if the current day of the\nmonth's bit is set.\n\nFor example, a value of 0X'80 00 00 01 00 00 00 00'\nindicates that this column evaluates to true on the first\nand last days of the month.\n\nThe last two bits in the string MUST be zero.")
spdTimeFiltDayOfWeekMask = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 5), Bits().subtype(namedValues=namedval.NamedValues(("sunday", 0), ("monday", 1), ("tuesday", 2), ("wednesday", 3), ("thursday", 4), ("friday", 5), ("saturday", 6), )).clone(("sunday","monday","tuesday","wednesday","thursday","friday","saturday",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltDayOfWeekMask.setDescription("A bit mask that defines which days of the week that the current\ntime is valid for.  This column evaluates to 'true' if the\ncurrent day of the week's bit is set.")
spdTimeFiltTimeOfDayMask = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 6), SpdTimePeriod().clone('00000000T000000/00000000T240000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltTimeOfDayMask.setDescription("Indicates the start and end time of the day for which this\nfilter evaluates to true.  The date portions of the\nspdTimePeriod TC are ignored for purposes of evaluating this\nmask, and only the time-specific portions are used.\n\nThis column evaluates to 'true' if the current time of day\nis within the range of the start and end times of the day\nindicated by this object.")
spdTimeFiltLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdTimeFiltLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdTimeFiltStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 8), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a storage\ntype of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdTimeFiltRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 9, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdTimeFiltRowStatus.setDescription("This object indicates the conceptual status of this\nrow.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nIf active, this object MUST remain active if it is\nreferenced by an active row in another table.  An attempt\nto set it to anything other than active while it is\nreferenced by an active row in another table MUST result in\nan inconsistentValue error.")
spdIpsoHeaderFilterTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 10))
if mibBuilder.loadTexts: spdIpsoHeaderFilterTable.setDescription("This table contains a list of IPSO header filter\ndefinitions to be used within the spdRuleDefinitionTable or\nthe spdSubfiltersTable.  IPSO headers and their values are\ndescribed in RFC 1108.")
spdIpsoHeaderFilterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 10, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdIpsoHeadFiltName"))
if mibBuilder.loadTexts: spdIpsoHeaderFilterEntry.setDescription("A definition of a particular filter.")
spdIpsoHeadFiltName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdIpsoHeadFiltName.setDescription("The administrative name for this filter.")
spdIpsoHeadFiltType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 2), Bits().subtype(namedValues=namedval.NamedValues(("classificationLevel", 0), ("protectionAuthority", 1), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpsoHeadFiltType.setDescription("This object indicates which of the IPSO header field a\npacket is filtered on for this row.  If this object is set\nto classification(0), the spdIpsoHeadFiltClassification\n\n\n\nobject indicates how the packet is filtered.  If this object\nis set to protectionAuthority(1), the\nspdIpsoHeadFiltProtectionAuth object indicates how the\npacket is filtered.")
spdIpsoHeadFiltClassification = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(61,171,90,150,)).subtype(namedValues=namedval.NamedValues(("confidential", 150), ("unclassified", 171), ("topSecret", 61), ("secret", 90), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpsoHeadFiltClassification.setDescription("This object indicates the IPSO classification header field\nvalue that the packet MUST have for this row to evaluate to\n'true'.\n\nThe values of these enumerations are defined by RFC 1108.")
spdIpsoHeadFiltProtectionAuth = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,0,4,1,)).subtype(namedValues=namedval.NamedValues(("genser", 0), ("siopesi", 1), ("sci", 2), ("nsa", 3), ("doe", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpsoHeadFiltProtectionAuth.setDescription("This object indicates the IPSO protection authority header\nfield value that the packet MUST have for this row to\nevaluate to 'true'.\n\nThe values of these enumerations are defined by RFC 1108.\nHence the reason the SMIv2 convention of not using 0 in\nenumerated lists is violated here.")
spdIpsoHeadFiltLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdIpsoHeadFiltLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdIpsoHeadFiltStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpsoHeadFiltStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a storage\ntype of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdIpsoHeadFiltRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 10, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdIpsoHeadFiltRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nHowever, this object MUST NOT be set to active if the\nrequirements of the spdIpsoHeadFiltType object are not met.\nSpecifically, if the spdIpsoHeadFiltType bit for\nclassification(0) is set, the spdIpsoHeadFiltClassification\ncolumn MUST have a valid value for the row status to be set\nto active.  If the spdIpsoHeadFiltType bit for\nprotectionAuthority(1) is set, the\nspdIpsoHeadFiltProtectionAuth column MUST have a valid\nvalue for the row status to be set to active.\n\nIf active, this object MUST remain active if it is\nreferenced by an active row in another table.  An attempt\nto set it to anything other than active while it is\nreferenced by an active row in another table MUST result in\nan inconsistentValue error.")
spdCompoundActionTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 11))
if mibBuilder.loadTexts: spdCompoundActionTable.setDescription("Table used to allow multiple actions to be associated\nwith a rule.  It uses the spdSubactionsTable to do this.\nThe rows from spdSubactionsTable that are partially indexed\nby spdCompActName form the set of compound actions to be\nperformed.  The spdCompActExecutionStrategy column in this\ntable indicates how those actions are processed.")
spdCompoundActionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 11, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdCompActName"))
if mibBuilder.loadTexts: spdCompoundActionEntry.setDescription("A row in the spdCompoundActionTable.")
spdCompActName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 11, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdCompActName.setDescription("This is an administratively assigned name of this\ncompound action.")
spdCompActExecutionStrategy = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 11, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("doAll", 1), ("doUntilSuccess", 2), ("doUntilFailure", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompActExecutionStrategy.setDescription("This object indicates how the sub-actions are executed\nbased on the success of the actions as they finish\nexecuting.\n\n\n\ndoAll           - run each sub-action regardless of the\n                  exit status of the previous action.\n                  This parent action is always\n                  considered to have acted successfully.\n\ndoUntilSuccess  - run each sub-action until one succeeds,\n                  at which point stop processing the\n                  sub-actions within this parent\n                  compound action.  If one of the\n                  sub-actions did execute successfully,\n                  this parent action is also considered\n                  to have executed successfully.\n\ndoUntilFailure  - run each sub-action until one fails,\n                  at which point stop processing the\n                  sub-actions within this compound\n                  action.  If any sub-action fails, the\n                  result of this parent action is\n                  considered to have failed.")
spdCompActLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 11, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdCompActLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdCompActStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 11, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompActStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a storage\ntype of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdCompActRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 11, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdCompActRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nOnce a row in the spdCompoundActionTable has been made\nactive, this object MUST NOT be set to destroy without\nfirst destroying all the contained rows listed in the\nspdSubactionsTable.")
spdSubactionsTable = MibTable((1, 3, 6, 1, 2, 1, 153, 1, 12))
if mibBuilder.loadTexts: spdSubactionsTable.setDescription("This table contains a list of the sub-actions within a\ngiven compound action.  Compound actions executing these\nactions MUST execute them in series based on the\nspdSubActPriority value, with the lowest value executing\nfirst.")
spdSubactionsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 153, 1, 12, 1)).setIndexNames((0, "IPSEC-SPD-MIB", "spdCompActName"), (0, "IPSEC-SPD-MIB", "spdSubActPriority"))
if mibBuilder.loadTexts: spdSubactionsEntry.setDescription("A row containing a reference to a given compound-action\nsub-action.")
spdSubActPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 12, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: spdSubActPriority.setDescription("The priority of a given sub-action within a compound\naction.  The order in which sub-actions MUST be executed\nare based on the value from this column, with the lowest\nnumeric value executing first (i.e., priority 0 before\npriority 1, 1 before 2, etc.).")
spdSubActSubActionName = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 12, 1, 2), VariablePointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubActSubActionName.setDescription("This column points to the action to be taken.  It MAY,\nbut is not limited to, point to a row in one of the\nfollowing tables:\n\n   spdCompoundActionTable         - Allowing recursion\n   ipsaSaPreconfiguredActionTable\n   ipiaIkeActionTable\n   ipiaIpsecActionTable\n\nIt MAY also point to one of the scalar objects beneath\nspdStaticActions.\n\nIf this object is set to a pointer to a row in an\nunsupported (or unknown) table, an inconsistentValue\nerror MUST be returned.\n\nIf this object is set to point to a non-existent row in\nan otherwise supported table, an inconsistentName error\nMUST be returned.\n\nIf, during packet processing, this column has a value that\nreferences a non-existent or non-supported object, the\npacket MUST be dropped.")
spdSubActLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 12, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdSubActLastChanged.setDescription("The value of sysUpTime when this row was last modified\nor created either through SNMP SETs or by some other\nexternal means.\n\nIf this row has not been modified since the last\nre-initialization of the network management subsystem, this\nobject SHOULD have a zero value.")
spdSubActStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 12, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubActStorageType.setDescription("The storage type for this row.  Rows in this table that\nwere created through an external process MAY have a storage\ntype of readOnly or permanent.\n\nFor a storage type of permanent, none of the columns have\nto be writable.")
spdSubActRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 153, 1, 12, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: spdSubActRowStatus.setDescription("This object indicates the conceptual status of this row.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.\n\nIf active, this object MUST remain active unless one of the\nfollowing two conditions are met.  An attempt to set it to\nanything other than active while the following conditions\nare not met MUST result in an inconsistentValue error.  The\ntwo conditions are:\n\nI.  No active row in the spdCompoundActionTable exists\n    which has a matching spdCompActName.\n\nII. Or, at least one other active row in this table has a\n    matching spdCompActName.")
spdStaticActions = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 1, 13))
spdDropAction = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 13, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdDropAction.setDescription("This scalar indicates that a packet MUST be dropped\nand SHOULD NOT have action/packet logging.")
spdDropActionLog = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 13, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdDropActionLog.setDescription("This scalar indicates that a packet MUST be dropped\nand SHOULD have action/packet logging.")
spdAcceptAction = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 13, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdAcceptAction.setDescription("This Scalar indicates that a packet MUST be accepted\n(pass-through) and SHOULD NOT have action/packet logging.")
spdAcceptActionLog = MibScalar((1, 3, 6, 1, 2, 1, 153, 1, 13, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: spdAcceptActionLog.setDescription("This scalar indicates that a packet MUST be accepted\n(pass-through) and SHOULD have action/packet logging.")
spdNotificationObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 2))
spdNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 2, 0))
spdNotificationVariables = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 2, 1))
spdActionExecuted = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 1), VariablePointer()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdActionExecuted.setDescription("Points to the action instance that was executed that\nresulted in the notification being sent.")
spdIPEndpointAddType = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 2), InetAddressType()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdIPEndpointAddType.setDescription("Contains the address type for the interface that the\nnotification triggering packet is passing through.")
spdIPEndpointAddress = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 3), InetAddress()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdIPEndpointAddress.setDescription("Contains the interface address for the interface that the\nnotification triggering packet is passing through.\n\nThe format of this object is specified by the\nspdIPEndpointAddType object.")
spdIPSourceType = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 4), InetAddressType()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdIPSourceType.setDescription("Contains the source address type of the packet that\n\n\n\ntriggered the notification.")
spdIPSourceAddress = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 5), InetAddress()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdIPSourceAddress.setDescription("Contains the source address of the packet that\ntriggered the notification.\n\nThe format of this object is specified by the\nspdIPSourceType object.")
spdIPDestinationType = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 6), InetAddressType()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdIPDestinationType.setDescription("Contains the destination address type of the packet\nthat triggered the notification.")
spdIPDestinationAddress = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 7), InetAddress()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdIPDestinationAddress.setDescription("Contains the destination address of the packet that\ntriggered the notification.\n\nThe format of this object is specified by the\nspdIPDestinationType object.")
spdPacketDirection = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 8), IfDirection()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdPacketDirection.setDescription("Indicates if the packet that triggered the action in\nquestions was ingress (inbound) or egress (outbound).")
spdPacketPart = MibScalar((1, 3, 6, 1, 2, 1, 153, 2, 1, 9), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65535))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: spdPacketPart.setDescription("spdPacketPart is the front part of the full IP packet that\ntriggered this notification.  The initial size limit is\ndetermined by the smaller of the size, indicated by:\n\nI.  The value of the object with the TC syntax\n    'SpdIPPacketLogging' that indicated the packet SHOULD be\n    logged and\n\nII. The size of the triggering packet.\n\nThe final limit is determined by the SNMP packet size when\nsending the notification.  The maximum size that can be\nincluded will be the smaller of the initial size, given the\nabove, and the length that will fit in a single SNMP\nnotification packet after the rest of the notification's\nobjects and any other necessary packet data (headers encoding,\netc.) have been included in the packet.")
spdConformanceObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 3))
spdCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 3, 1))
spdGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 3, 2))
spdActions = MibIdentifier((1, 3, 6, 1, 2, 1, 153, 4))

# Augmentions

# Notifications

spdActionNotification = NotificationType((1, 3, 6, 1, 2, 1, 153, 2, 0, 1)).setObjects(("IPSEC-SPD-MIB", "spdIPEndpointAddType"), ("IPSEC-SPD-MIB", "spdIPDestinationType"), ("IPSEC-SPD-MIB", "spdIPEndpointAddress"), ("IPSEC-SPD-MIB", "spdIPSourceAddress"), ("IPSEC-SPD-MIB", "spdPacketDirection"), ("IPSEC-SPD-MIB", "spdIPDestinationAddress"), ("IPSEC-SPD-MIB", "spdIPSourceType"), ("IPSEC-SPD-MIB", "spdActionExecuted"), )
if mibBuilder.loadTexts: spdActionNotification.setDescription("Notification that an action was executed by a rule.\nOnly actions with logging enabled will result in this\nnotification getting sent.  The object includes the\nspdActionExecuted object, which will indicate which action\nwas executed within the scope of the rule.  Additionally,\nthe spdIPSourceType, spdIPSourceAddress,\nspdIPDestinationType, and spdIPDestinationAddress objects\nare included to indicate the packet source and destination\nof the packet that triggered the action.  Finally, the\nspdIPEndpointAddType, spdIPEndpointAddress, and\nspdPacketDirection objects indicate which interface the\nexecuted action was associated with, and if the packet was\ningress or egress through the endpoint.\n\nA spdActionNotification SHOULD be limited to a maximum of\none notification sent per minute for any action\nnotifications that do not have any other configuration\ncontrolling their send rate.\n\n\n\nNote that compound actions with multiple executed\nsub-actions may result in multiple notifications being sent\nfrom a single rule execution.")
spdPacketNotification = NotificationType((1, 3, 6, 1, 2, 1, 153, 2, 0, 2)).setObjects(("IPSEC-SPD-MIB", "spdIPEndpointAddType"), ("IPSEC-SPD-MIB", "spdIPDestinationType"), ("IPSEC-SPD-MIB", "spdIPEndpointAddress"), ("IPSEC-SPD-MIB", "spdIPSourceAddress"), ("IPSEC-SPD-MIB", "spdPacketDirection"), ("IPSEC-SPD-MIB", "spdIPDestinationAddress"), ("IPSEC-SPD-MIB", "spdIPSourceType"), ("IPSEC-SPD-MIB", "spdPacketPart"), ("IPSEC-SPD-MIB", "spdActionExecuted"), )
if mibBuilder.loadTexts: spdPacketNotification.setDescription("Notification that a packet passed through a Security\nAssociation (SA).  Only SAs created by actions with packet\nlogging enabled will result in this notification getting\nsent.  The objects sent MUST include the spdActionExecuted,\nwhich will indicate which action was executed within the\nscope of the rule.  Additionally, the spdIPSourceType,\nspdIPSourceAddress, spdIPDestinationType, and\nspdIPDestinationAddress objects MUST be included to\nindicate the packet source and destination of the packet\nthat triggered the action.  The spdIPEndpointAddType,\nspdIPEndpointAddress, and spdPacketDirection objects are\nincluded to indicate which endpoint the packet was\nassociated with.  Finally, spdPacketPart is included to\nenable sending a variable sized part of the front of the\npacket with the size dependent on the value of the object of\nTC syntax 'SpdIPPacketLogging', which indicated that logging\nshould be done.\n\nA spdPacketNotification SHOULD be limited to a maximum of\none notification sent per minute for any action\nnotifications that do not have any other configuration\ncontrolling their send rate.\n\nAn action notification SHOULD be limited to a maximum of\none notification sent per minute for any action\nnotifications that do not have any other configuration\ncontrolling their send rate.")

# Groups

spdEndpointGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 1)).setObjects(("IPSEC-SPD-MIB", "spdEndGroupRowStatus"), ("IPSEC-SPD-MIB", "spdEndGroupLastChanged"), ("IPSEC-SPD-MIB", "spdEndGroupStorageType"), ("IPSEC-SPD-MIB", "spdEndGroupName"), )
if mibBuilder.loadTexts: spdEndpointGroup.setDescription("This group is made up of objects from the IPsec Policy\nEndpoint Table.")
spdGroupContentsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 2)).setObjects(("IPSEC-SPD-MIB", "spdGroupContComponentType"), ("IPSEC-SPD-MIB", "spdGroupContComponentName"), ("IPSEC-SPD-MIB", "spdGroupContStorageType"), ("IPSEC-SPD-MIB", "spdGroupContFilter"), ("IPSEC-SPD-MIB", "spdGroupContRowStatus"), ("IPSEC-SPD-MIB", "spdGroupContLastChanged"), )
if mibBuilder.loadTexts: spdGroupContentsGroup.setDescription("This group is made up of objects from the IPsec Policy\nGroup Contents Table.")
spdIpsecSystemPolicyNameGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 3)).setObjects(("IPSEC-SPD-MIB", "spdEgressPolicyGroupName"), ("IPSEC-SPD-MIB", "spdIngressPolicyGroupName"), )
if mibBuilder.loadTexts: spdIpsecSystemPolicyNameGroup.setDescription("This group is made up of objects represent the System\nPolicy Group Names.")
spdRuleDefinitionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 4)).setObjects(("IPSEC-SPD-MIB", "spdRuleDefDescription"), ("IPSEC-SPD-MIB", "spdRuleDefRowStatus"), ("IPSEC-SPD-MIB", "spdRuleDefFilterNegated"), ("IPSEC-SPD-MIB", "spdRuleDefAction"), ("IPSEC-SPD-MIB", "spdRuleDefAdminStatus"), ("IPSEC-SPD-MIB", "spdRuleDefLastChanged"), ("IPSEC-SPD-MIB", "spdRuleDefFilter"), ("IPSEC-SPD-MIB", "spdRuleDefStorageType"), )
if mibBuilder.loadTexts: spdRuleDefinitionGroup.setDescription("This group is made up of objects from the IPsec Policy Rule\nDefinition Table.")
spdCompoundFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 5)).setObjects(("IPSEC-SPD-MIB", "spdSubFiltRowStatus"), ("IPSEC-SPD-MIB", "spdCompFiltLastChanged"), ("IPSEC-SPD-MIB", "spdSubFiltLastChanged"), ("IPSEC-SPD-MIB", "spdCompFiltLogicType"), ("IPSEC-SPD-MIB", "spdSubFiltSubfilterIsNegated"), ("IPSEC-SPD-MIB", "spdCompFiltRowStatus"), ("IPSEC-SPD-MIB", "spdCompFiltStorageType"), ("IPSEC-SPD-MIB", "spdSubFiltSubfilter"), ("IPSEC-SPD-MIB", "spdSubFiltStorageType"), ("IPSEC-SPD-MIB", "spdCompFiltDescription"), )
if mibBuilder.loadTexts: spdCompoundFilterGroup.setDescription("This group is made up of objects from the IPsec Policy\nCompound Filter Table and Sub-Filter Table Group.")
spdStaticFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 6)).setObjects(("IPSEC-SPD-MIB", "spdTrueFilter"), )
if mibBuilder.loadTexts: spdStaticFilterGroup.setDescription("The static filter group.  Currently this is just a true\nfilter.")
spdIPOffsetFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 7)).setObjects(("IPSEC-SPD-MIB", "spdIpOffFiltValue"), ("IPSEC-SPD-MIB", "spdIpOffFiltStorageType"), ("IPSEC-SPD-MIB", "spdIpOffFiltRowStatus"), ("IPSEC-SPD-MIB", "spdIpOffFiltType"), ("IPSEC-SPD-MIB", "spdIpOffFiltOffset"), ("IPSEC-SPD-MIB", "spdIpOffFiltLastChanged"), )
if mibBuilder.loadTexts: spdIPOffsetFilterGroup.setDescription("This group is made up of objects from the IPsec Policy IP\nOffset Filter Table.")
spdTimeFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 8)).setObjects(("IPSEC-SPD-MIB", "spdTimeFiltTimeOfDayMask"), ("IPSEC-SPD-MIB", "spdTimeFiltDayOfWeekMask"), ("IPSEC-SPD-MIB", "spdTimeFiltPeriod"), ("IPSEC-SPD-MIB", "spdTimeFiltLastChanged"), ("IPSEC-SPD-MIB", "spdTimeFiltRowStatus"), ("IPSEC-SPD-MIB", "spdTimeFiltDayOfMonthMask"), ("IPSEC-SPD-MIB", "spdTimeFiltStorageType"), ("IPSEC-SPD-MIB", "spdTimeFiltMonthOfYearMask"), )
if mibBuilder.loadTexts: spdTimeFilterGroup.setDescription("This group is made up of objects from the IPsec Policy Time\nFilter Table.")
spdIpsoHeaderFilterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 9)).setObjects(("IPSEC-SPD-MIB", "spdIpsoHeadFiltType"), ("IPSEC-SPD-MIB", "spdIpsoHeadFiltLastChanged"), ("IPSEC-SPD-MIB", "spdIpsoHeadFiltProtectionAuth"), ("IPSEC-SPD-MIB", "spdIpsoHeadFiltClassification"), ("IPSEC-SPD-MIB", "spdIpsoHeadFiltStorageType"), ("IPSEC-SPD-MIB", "spdIpsoHeadFiltRowStatus"), )
if mibBuilder.loadTexts: spdIpsoHeaderFilterGroup.setDescription("This group is made up of objects from the IPsec Policy IPSO\nHeader Filter Table.")
spdStaticActionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 10)).setObjects(("IPSEC-SPD-MIB", "spdAcceptActionLog"), ("IPSEC-SPD-MIB", "spdDropActionLog"), ("IPSEC-SPD-MIB", "spdAcceptAction"), ("IPSEC-SPD-MIB", "spdDropAction"), )
if mibBuilder.loadTexts: spdStaticActionGroup.setDescription("This group is made up of objects from the IPsec Policy\nStatic Actions.")
spdCompoundActionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 11)).setObjects(("IPSEC-SPD-MIB", "spdSubActStorageType"), ("IPSEC-SPD-MIB", "spdSubActRowStatus"), ("IPSEC-SPD-MIB", "spdCompActStorageType"), ("IPSEC-SPD-MIB", "spdCompActLastChanged"), ("IPSEC-SPD-MIB", "spdCompActExecutionStrategy"), ("IPSEC-SPD-MIB", "spdSubActLastChanged"), ("IPSEC-SPD-MIB", "spdCompActRowStatus"), ("IPSEC-SPD-MIB", "spdSubActSubActionName"), )
if mibBuilder.loadTexts: spdCompoundActionGroup.setDescription("The IPsec Policy Compound Action Table and Actions In\n\n\n\nCompound Action Table Group.")
spdActionLoggingObjectGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 12)).setObjects(("IPSEC-SPD-MIB", "spdIPEndpointAddType"), ("IPSEC-SPD-MIB", "spdIPDestinationType"), ("IPSEC-SPD-MIB", "spdIPEndpointAddress"), ("IPSEC-SPD-MIB", "spdIPSourceAddress"), ("IPSEC-SPD-MIB", "spdPacketDirection"), ("IPSEC-SPD-MIB", "spdIPDestinationAddress"), ("IPSEC-SPD-MIB", "spdIPSourceType"), ("IPSEC-SPD-MIB", "spdPacketPart"), ("IPSEC-SPD-MIB", "spdActionExecuted"), )
if mibBuilder.loadTexts: spdActionLoggingObjectGroup.setDescription("This group is made up of all the Notification objects for\nthis MIB.")
spdActionNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 153, 3, 2, 13)).setObjects(("IPSEC-SPD-MIB", "spdPacketNotification"), ("IPSEC-SPD-MIB", "spdActionNotification"), )
if mibBuilder.loadTexts: spdActionNotificationGroup.setDescription("This group is made up of all the Notifications for this MIB.")

# Compliances

spdRuleFilterFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 153, 3, 1, 1)).setObjects(("DIFFSERV-MIB", "diffServMIBMultiFieldClfrGroup"), ("IPSEC-SPD-MIB", "spdGroupContentsGroup"), ("IPSEC-SPD-MIB", "spdEndpointGroup"), ("IPSEC-SPD-MIB", "spdCompoundActionGroup"), ("IPSEC-SPD-MIB", "spdIPOffsetFilterGroup"), ("IPSEC-SPD-MIB", "spdStaticFilterGroup"), ("IPSEC-SPD-MIB", "spdCompoundFilterGroup"), ("IPSEC-SPD-MIB", "spdIpsoHeaderFilterGroup"), ("IPSEC-SPD-MIB", "spdStaticActionGroup"), ("IPSEC-SPD-MIB", "spdIpsecSystemPolicyNameGroup"), ("IPSEC-SPD-MIB", "spdRuleDefinitionGroup"), ("IPSEC-SPD-MIB", "spdTimeFilterGroup"), )
if mibBuilder.loadTexts: spdRuleFilterFullCompliance.setDescription("The compliance statement for SNMP entities that include\nan IPsec MIB implementation with Endpoint, Rules, and\nfilters support.\n\nWhen this MIB is implemented with support for read-create,\nthen such an implementation can claim full compliance.  Such\ndevices can then be both monitored and configured with this\nMIB.")
spdLoggingCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 153, 3, 1, 2)).setObjects(("IPSEC-SPD-MIB", "spdActionLoggingObjectGroup"), ("IPSEC-SPD-MIB", "spdActionNotificationGroup"), )
if mibBuilder.loadTexts: spdLoggingCompliance.setDescription("The compliance statement for SNMP entities that support\nsending notifications when actions are invoked.")
spdRuleFilterReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 153, 3, 1, 3)).setObjects(("DIFFSERV-MIB", "diffServMIBMultiFieldClfrGroup"), ("IPSEC-SPD-MIB", "spdGroupContentsGroup"), ("IPSEC-SPD-MIB", "spdEndpointGroup"), ("IPSEC-SPD-MIB", "spdCompoundActionGroup"), ("IPSEC-SPD-MIB", "spdIPOffsetFilterGroup"), ("IPSEC-SPD-MIB", "spdStaticFilterGroup"), ("IPSEC-SPD-MIB", "spdCompoundFilterGroup"), ("IPSEC-SPD-MIB", "spdIpsoHeaderFilterGroup"), ("IPSEC-SPD-MIB", "spdStaticActionGroup"), ("IPSEC-SPD-MIB", "spdIpsecSystemPolicyNameGroup"), ("IPSEC-SPD-MIB", "spdRuleDefinitionGroup"), ("IPSEC-SPD-MIB", "spdTimeFilterGroup"), )
if mibBuilder.loadTexts: spdRuleFilterReadOnlyCompliance.setDescription("The compliance statement for SNMP entities that include\nan IPsec MIB implementation with Endpoint, Rules, and\nfilters support.\n\nIf this MIB is implemented without support for read-create\n(i.e., in read-only), it is not in full compliance, but it\ncan claim read-only compliance.  Such a device can then be\nmonitored, but cannot be configured with this MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("IPSEC-SPD-MIB", PYSNMP_MODULE_ID=spdMIB)

# Types
mibBuilder.exportSymbols("IPSEC-SPD-MIB", SpdAdminStatus=SpdAdminStatus, SpdBooleanOperator=SpdBooleanOperator, SpdIPPacketLogging=SpdIPPacketLogging, SpdTimePeriod=SpdTimePeriod)

# Objects
mibBuilder.exportSymbols("IPSEC-SPD-MIB", spdMIB=spdMIB, spdConfigObjects=spdConfigObjects, spdLocalConfigObjects=spdLocalConfigObjects, spdIngressPolicyGroupName=spdIngressPolicyGroupName, spdEgressPolicyGroupName=spdEgressPolicyGroupName, spdEndpointToGroupTable=spdEndpointToGroupTable, spdEndpointToGroupEntry=spdEndpointToGroupEntry, spdEndGroupDirection=spdEndGroupDirection, spdEndGroupInterface=spdEndGroupInterface, spdEndGroupName=spdEndGroupName, spdEndGroupLastChanged=spdEndGroupLastChanged, spdEndGroupStorageType=spdEndGroupStorageType, spdEndGroupRowStatus=spdEndGroupRowStatus, spdGroupContentsTable=spdGroupContentsTable, spdGroupContentsEntry=spdGroupContentsEntry, spdGroupContName=spdGroupContName, spdGroupContPriority=spdGroupContPriority, spdGroupContFilter=spdGroupContFilter, spdGroupContComponentType=spdGroupContComponentType, spdGroupContComponentName=spdGroupContComponentName, spdGroupContLastChanged=spdGroupContLastChanged, spdGroupContStorageType=spdGroupContStorageType, spdGroupContRowStatus=spdGroupContRowStatus, spdRuleDefinitionTable=spdRuleDefinitionTable, spdRuleDefinitionEntry=spdRuleDefinitionEntry, spdRuleDefName=spdRuleDefName, spdRuleDefDescription=spdRuleDefDescription, spdRuleDefFilter=spdRuleDefFilter, spdRuleDefFilterNegated=spdRuleDefFilterNegated, spdRuleDefAction=spdRuleDefAction, spdRuleDefAdminStatus=spdRuleDefAdminStatus, spdRuleDefLastChanged=spdRuleDefLastChanged, spdRuleDefStorageType=spdRuleDefStorageType, spdRuleDefRowStatus=spdRuleDefRowStatus, spdCompoundFilterTable=spdCompoundFilterTable, spdCompoundFilterEntry=spdCompoundFilterEntry, spdCompFiltName=spdCompFiltName, spdCompFiltDescription=spdCompFiltDescription, spdCompFiltLogicType=spdCompFiltLogicType, spdCompFiltLastChanged=spdCompFiltLastChanged, spdCompFiltStorageType=spdCompFiltStorageType, spdCompFiltRowStatus=spdCompFiltRowStatus, spdSubfiltersTable=spdSubfiltersTable, spdSubfiltersEntry=spdSubfiltersEntry, spdSubFiltPriority=spdSubFiltPriority, spdSubFiltSubfilter=spdSubFiltSubfilter, spdSubFiltSubfilterIsNegated=spdSubFiltSubfilterIsNegated, spdSubFiltLastChanged=spdSubFiltLastChanged, spdSubFiltStorageType=spdSubFiltStorageType, spdSubFiltRowStatus=spdSubFiltRowStatus, spdStaticFilters=spdStaticFilters, spdTrueFilter=spdTrueFilter, spdTrueFilterInstance=spdTrueFilterInstance, spdIpOffsetFilterTable=spdIpOffsetFilterTable, spdIpOffsetFilterEntry=spdIpOffsetFilterEntry, spdIpOffFiltName=spdIpOffFiltName, spdIpOffFiltOffset=spdIpOffFiltOffset, spdIpOffFiltType=spdIpOffFiltType, spdIpOffFiltValue=spdIpOffFiltValue, spdIpOffFiltLastChanged=spdIpOffFiltLastChanged, spdIpOffFiltStorageType=spdIpOffFiltStorageType, spdIpOffFiltRowStatus=spdIpOffFiltRowStatus, spdTimeFilterTable=spdTimeFilterTable, spdTimeFilterEntry=spdTimeFilterEntry, spdTimeFiltName=spdTimeFiltName, spdTimeFiltPeriod=spdTimeFiltPeriod, spdTimeFiltMonthOfYearMask=spdTimeFiltMonthOfYearMask, spdTimeFiltDayOfMonthMask=spdTimeFiltDayOfMonthMask, spdTimeFiltDayOfWeekMask=spdTimeFiltDayOfWeekMask, spdTimeFiltTimeOfDayMask=spdTimeFiltTimeOfDayMask, spdTimeFiltLastChanged=spdTimeFiltLastChanged, spdTimeFiltStorageType=spdTimeFiltStorageType, spdTimeFiltRowStatus=spdTimeFiltRowStatus, spdIpsoHeaderFilterTable=spdIpsoHeaderFilterTable, spdIpsoHeaderFilterEntry=spdIpsoHeaderFilterEntry, spdIpsoHeadFiltName=spdIpsoHeadFiltName, spdIpsoHeadFiltType=spdIpsoHeadFiltType, spdIpsoHeadFiltClassification=spdIpsoHeadFiltClassification, spdIpsoHeadFiltProtectionAuth=spdIpsoHeadFiltProtectionAuth, spdIpsoHeadFiltLastChanged=spdIpsoHeadFiltLastChanged, spdIpsoHeadFiltStorageType=spdIpsoHeadFiltStorageType, spdIpsoHeadFiltRowStatus=spdIpsoHeadFiltRowStatus, spdCompoundActionTable=spdCompoundActionTable, spdCompoundActionEntry=spdCompoundActionEntry, spdCompActName=spdCompActName, spdCompActExecutionStrategy=spdCompActExecutionStrategy, spdCompActLastChanged=spdCompActLastChanged, spdCompActStorageType=spdCompActStorageType, spdCompActRowStatus=spdCompActRowStatus, spdSubactionsTable=spdSubactionsTable, spdSubactionsEntry=spdSubactionsEntry, spdSubActPriority=spdSubActPriority, spdSubActSubActionName=spdSubActSubActionName, spdSubActLastChanged=spdSubActLastChanged, spdSubActStorageType=spdSubActStorageType, spdSubActRowStatus=spdSubActRowStatus, spdStaticActions=spdStaticActions, spdDropAction=spdDropAction, spdDropActionLog=spdDropActionLog, spdAcceptAction=spdAcceptAction, spdAcceptActionLog=spdAcceptActionLog, spdNotificationObjects=spdNotificationObjects, spdNotifications=spdNotifications, spdNotificationVariables=spdNotificationVariables, spdActionExecuted=spdActionExecuted, spdIPEndpointAddType=spdIPEndpointAddType, spdIPEndpointAddress=spdIPEndpointAddress, spdIPSourceType=spdIPSourceType, spdIPSourceAddress=spdIPSourceAddress, spdIPDestinationType=spdIPDestinationType, spdIPDestinationAddress=spdIPDestinationAddress, spdPacketDirection=spdPacketDirection, spdPacketPart=spdPacketPart, spdConformanceObjects=spdConformanceObjects, spdCompliances=spdCompliances, spdGroups=spdGroups, spdActions=spdActions)

# Notifications
mibBuilder.exportSymbols("IPSEC-SPD-MIB", spdActionNotification=spdActionNotification, spdPacketNotification=spdPacketNotification)

# Groups
mibBuilder.exportSymbols("IPSEC-SPD-MIB", spdEndpointGroup=spdEndpointGroup, spdGroupContentsGroup=spdGroupContentsGroup, spdIpsecSystemPolicyNameGroup=spdIpsecSystemPolicyNameGroup, spdRuleDefinitionGroup=spdRuleDefinitionGroup, spdCompoundFilterGroup=spdCompoundFilterGroup, spdStaticFilterGroup=spdStaticFilterGroup, spdIPOffsetFilterGroup=spdIPOffsetFilterGroup, spdTimeFilterGroup=spdTimeFilterGroup, spdIpsoHeaderFilterGroup=spdIpsoHeaderFilterGroup, spdStaticActionGroup=spdStaticActionGroup, spdCompoundActionGroup=spdCompoundActionGroup, spdActionLoggingObjectGroup=spdActionLoggingObjectGroup, spdActionNotificationGroup=spdActionNotificationGroup)

# Compliances
mibBuilder.exportSymbols("IPSEC-SPD-MIB", spdRuleFilterFullCompliance=spdRuleFilterFullCompliance, spdLoggingCompliance=spdLoggingCompliance, spdRuleFilterReadOnlyCompliance=spdRuleFilterReadOnlyCompliance)
