# PySNMP SMI module. Autogenerated from smidump -f python ISCSI-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:45 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( AutonomousType, RowPointer, RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "RowPointer", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class IscsiDigestMethod(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,3,4,)
    namedValues = namedval.NamedValues(("none", 1), ("other", 2), ("noDigest", 3), ("crc32c", 4), )
    
class IscsiName(TextualConvention, OctetString):
    displayHint = "223t"
    subtypeSpec = OctetString.subtypeSpec+constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(16,223),)
    
class IscsiTransportProtocol(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,255)
    

# Objects

iscsiMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 142)).setRevisions(("2006-05-22 00:00",))
if mibBuilder.loadTexts: iscsiMibModule.setOrganization("IETF IPS Working Group")
if mibBuilder.loadTexts: iscsiMibModule.setContactInfo("\nMark Bakke\nCisco Systems, Inc\n7900 International Drive, Suite 400\nBloomington, MN\nUSA 55425\n\nE-mail: mbakke@cisco.com\n\nMarjorie Krueger\nHewlett-Packard\nNetworked Storage Architecture\nNetworked Storage Solutions Org.\n8000 Foothills Blvd.\nRoseville, CA 95747\n\n\n\n\nE-mail: marjorie_krueger@hp.com\n\nTom McSweeney\nIBM Corporation\n600 Park Offices Drive\nResearch Triangle Park, NC\nUSA 27709\n\nE-mail: tommcs@us.ibm.com\n\nJames Muchow\nQlogic Corp.\n6321 Bury Dr.\nEden Prairie, MN\nUSA 55346\n\nE-mail: james.muchow@qlogic.com")
if mibBuilder.loadTexts: iscsiMibModule.setDescription("The iSCSI Protocol MIB module.\nCopyright (C) The Internet Society (2006).  This version of\nthis MIB module is part of RFC 4544;  see the RFC itself for\nfull legal notices.")
iscsiNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 0))
iscsiObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1))
iscsiInstance = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 1))
iscsiInstanceAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 1, 1))
if mibBuilder.loadTexts: iscsiInstanceAttributesTable.setDescription("A list of iSCSI instances present on the system.")
iscsiInstanceAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"))
if mibBuilder.loadTexts: iscsiInstanceAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular iSCSI instance.")
iscsiInstIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiInstIndex.setDescription("An arbitrary integer used to uniquely identify a particular\niSCSI instance.  This index value must not be modified or\nreused by an agent unless a reboot has occurred.  An agent\nshould attempt to keep this value persistent across reboots.")
iscsiInstDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstDescr.setDescription("A UTF-8 string, determined by the implementation to\ndescribe the iSCSI instance.  When only a single instance\nis present, this object may be set to the zero-length\nstring; with multiple iSCSI instances, it may be used in\nan implementation-dependent manner to describe the purpose\nof the respective instance.")
iscsiInstVersionMin = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVersionMin.setDescription("The minimum version number of the iSCSI specification\nsuch that this iSCSI instance supports this minimum\nvalue, the maximum value indicated by the corresponding\ninstance in iscsiInstVersionMax, and all versions in\nbetween.")
iscsiInstVersionMax = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVersionMax.setDescription("The maximum version number of the iSCSI specification\nsuch that this iSCSI instance supports this maximum\nvalue, the minimum value indicated by the corresponding\ninstance in iscsiInstVersionMin, and all versions in\nbetween.")
iscsiInstVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVendorID.setDescription("A UTF-8 string describing the manufacturer of the\nimplementation of this instance.")
iscsiInstVendorVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 6), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstVendorVersion.setDescription("A UTF-8 string set by the manufacturer describing the\nversion of the implementation of this instance.  The\nformat of this string is determined solely by the\nmanufacturer, and is for informational purposes only.\n\n\n\nIt is unrelated to the iSCSI specification version numbers.")
iscsiInstPortalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstPortalNumber.setDescription("The number of rows in the iscsiPortalAttributesTable\nthat are currently associated with this iSCSI instance.")
iscsiInstNodeNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstNodeNumber.setDescription("The number of rows in the iscsiNodeAttributesTable\nthat are currently associated with this iSCSI instance.")
iscsiInstSessionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSessionNumber.setDescription("The number of rows in the iscsiSessionAttributesTable\nthat are currently associated with this iSCSI instance.")
iscsiInstSsnFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnFailures.setDescription("This object counts the number of times a session belonging\nto this instance has been failed.  If this counter has\nsuffered a discontinuity, the time of the last discontinuity\nis indicated in iscsiInstDiscontinuityTime.")
iscsiInstLastSsnFailureType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 11), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstLastSsnFailureType.setDescription("The counter object in the iscsiInstSsnErrorStatsTable\nthat was incremented when the last session failure occurred.\n\nIf the reason for failure is not found in the\niscsiInstSsnErrorStatsTable, the value { 0.0 } is\nused instead.")
iscsiInstLastSsnRmtNodeName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 12), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstLastSsnRmtNodeName.setDescription("The iSCSI name of the remote node from the failed\nsession.")
iscsiInstDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 1, 1, 13), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstDiscontinuityTime.setDescription("The value of SysUpTime on the most recent occasion\nat which any one or more of this instance's counters\nsuffered a discontinuity.\n\nIf no such discontinuities have occurred since the last\nre-initialization of the local management subsystem,\nthen this object contains a zero value.")
iscsiInstanceSsnErrorStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 1, 2))
if mibBuilder.loadTexts: iscsiInstanceSsnErrorStatsTable.setDescription("Statistics regarding the occurrences of error types\nthat result in a session failure.")
iscsiInstanceSsnErrorStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1))
if mibBuilder.loadTexts: iscsiInstanceSsnErrorStatsEntry.setDescription("An entry (row) containing management information applicable\nto a particular iSCSI instance.")
iscsiInstSsnDigestErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnDigestErrors.setDescription("The count of sessions that were failed due to receipt of\na PDU containing header or data digest errors.  If this\ncounter has suffered a discontinuity, the time of the last\ndiscontinuity is indicated in iscsiInstDiscontinuityTime.")
iscsiInstSsnCxnTimeoutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnCxnTimeoutErrors.setDescription("The count of sessions that were failed due to a sequence\nexceeding a time limit.  If this counter has suffered a\ndiscontinuity, the time of the last discontinuity\nis indicated in iscsiInstDiscontinuityTime.")
iscsiInstSsnFormatErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 1, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiInstSsnFormatErrors.setDescription("The count of sessions that were failed due to receipt of\na PDU that contained a format error.  If this counter has\nsuffered a discontinuity, the time of the last discontinuity\nis indicated in iscsiInstDiscontinuityTime.")
iscsiPortal = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 2))
iscsiPortalAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 2, 1))
if mibBuilder.loadTexts: iscsiPortalAttributesTable.setDescription("A list of transport endpoints (using TCP or another transport\nprotocol) used by this iSCSI instance.  An iSCSI instance may\nuse a portal to listen for incoming connections to its targets,\nto initiate connections to other targets, or both.")
iscsiPortalAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiPortalIndex"))
if mibBuilder.loadTexts: iscsiPortalAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular portal instance.")
iscsiPortalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiPortalIndex.setDescription("An arbitrary integer used to uniquely identify a particular\ntransport endpoint within this iSCSI instance.  This index\nvalue must not be modified or reused by an agent unless a\nreboot has occurred.  An agent should attempt to keep this\nvalue persistent across reboots.")
iscsiPortalRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalRowStatus.setDescription("This field allows entries to be dynamically added and\nremoved from this table via SNMP.  When adding a row to\nthis table, all non-Index/RowStatus objects must be set.\nWhen the value of this object is 'active', the values of\nthe other objects in this table cannot be changed.\nRows may be discarded using RowStatus.\n\nNote that creating a row in this table will typically\ncause the agent to create one or more rows in\niscsiTgtPortalAttributesTable and/or\niscsiIntrPortalAttributesTable.")
iscsiPortalRoles = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 3), Bits().subtype(namedValues=namedval.NamedValues(("targetTypePortal", 0), ("initiatorTypePortal", 1), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalRoles.setDescription("A portal can operate in one or both of two roles:\nas a target portal and/or an initiator portal.  If\nthe portal will operate in both roles, both bits\nmust be set.\n\nThis object will define a corresponding row that\n\n\n\nwill exist or must be created in the\niscsiTgtPortalAttributesTable, the\niscsiIntrPortalAttributesTable or both.  If the\ntargetTypePortal bit is set, one or more corresponding\niscsiTgtPortalAttributesEntry rows will be found or\ncreated.  If the initiatorTypePortal bit is set,\none or more corresponding iscsiIntrPortalAttributesEntry\nrows will be found or created.  If both bits are set, one\nor more corresponding rows will be found or created in\none of the above tables.")
iscsiPortalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 4), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalAddrType.setDescription("The type of Internet Network Address contained in the\ncorresponding instance of the iscsiPortalAddr.")
iscsiPortalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 5), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalAddr.setDescription("The portal's Internet Network Address, of the type\nspecified by the object iscsiPortalAddrType.  If\niscsiPortalAddrType has the value 'dns', this address\ngets resolved to an IP address whenever a new iSCSI\nconnection is established using this portal.")
iscsiPortalProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 6), IscsiTransportProtocol().clone('6')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalProtocol.setDescription("The portal's transport protocol.")
iscsiPortalMaxRecvDataSegLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215)).clone(8192)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalMaxRecvDataSegLength.setDescription("The maximum PDU length this portal can receive.\nThis may be constrained by hardware characteristics\nand individual implementations may choose not to\nallow this object to be changed.")
iscsiPortalPrimaryHdrDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 8), IscsiDigestMethod().clone('crc32c')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalPrimaryHdrDigest.setDescription("The preferred header digest for this portal.")
iscsiPortalPrimaryDataDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 9), IscsiDigestMethod().clone('crc32c')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalPrimaryDataDigest.setDescription("The preferred data digest method for this portal.")
iscsiPortalSecondaryHdrDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 10), IscsiDigestMethod().clone('noDigest')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalSecondaryHdrDigest.setDescription("An alternate header digest preference for this portal.")
iscsiPortalSecondaryDataDigest = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 11), IscsiDigestMethod().clone('noDigest')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalSecondaryDataDigest.setDescription("An alternate data digest preference for this portal.")
iscsiPortalRecvMarker = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 12), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalRecvMarker.setDescription("This object indicates whether or not this portal will\nrequest markers in its incoming data stream.")
iscsiPortalStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 2, 1, 1, 13), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiPortalStorageType.setDescription("The storage type for this row.  Rows in this table that were\ncreated through an external process may have a storage type of\nreadOnly or permanent.\n\nConceptual rows having the value 'permanent' need not\nallow write access to any columnar objects in the row.")
iscsiTargetPortal = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 3))
iscsiTgtPortalAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 3, 1))
if mibBuilder.loadTexts: iscsiTgtPortalAttributesTable.setDescription("A list of transport endpoints (using TCP or another transport\nprotocol) on which this iSCSI instance listens for incoming\nconnections to its targets.")
iscsiTgtPortalAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiPortalIndex"), (0, "ISCSI-MIB", "iscsiTgtPortalNodeIndexOrZero"))
if mibBuilder.loadTexts: iscsiTgtPortalAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular portal instance that is used to listen for\nincoming connections to local targets.  One or more rows in\nthis table is populated by the agent for each\n\n\n\niscsiPortalAttributesEntry row that has the bit\ntargetTypePortal set in its iscsiPortalRoles column.")
iscsiTgtPortalNodeIndexOrZero = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiTgtPortalNodeIndexOrZero.setDescription("An arbitrary integer used to uniquely identify a\nparticular node within an iSCSI instance present\non the local system.\n\nFor implementations where each {portal, node} tuple\ncan have a different portal tag, this value will\nmap to the iscsiNodeIndex.\n\nFor implementations where the portal tag is the\nsame for a given portal regardless of which node\nis using the portal, the value 0 (zero) is used.")
iscsiTgtPortalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1, 2), InetPortNumber().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiTgtPortalPort.setDescription("The portal's transport protocol port number on which the\nportal listens for incoming iSCSI connections when the\nportal is used as a target portal.  This object's storage\ntype is specified in iscsiPortalStorageType.")
iscsiTgtPortalTag = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 3, 1, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiTgtPortalTag.setDescription("The portal's aggregation tag when the portal is used as\na target portal.  Multiple-connection sessions may\n\n\n\nbe aggregated over portals sharing an identical\naggregation tag.  This object's storage type is\nspecified in iscsiPortalStorageType.")
iscsiInitiatorPortal = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 4))
iscsiIntrPortalAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 4, 1))
if mibBuilder.loadTexts: iscsiIntrPortalAttributesTable.setDescription("A list of Internet Network Addresses (using TCP or another\ntransport protocol) from which this iSCSI instance may\ninitiate connections to other targets.")
iscsiIntrPortalAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 4, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiPortalIndex"), (0, "ISCSI-MIB", "iscsiIntrPortalNodeIndexOrZero"))
if mibBuilder.loadTexts: iscsiIntrPortalAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular portal instance that is used to initiate\nconnections to iSCSI targets.  One or more rows in\nthis table is populated by the agent for each\niscsiPortalAttributesEntry row that has the bit\ninitiatorTypePortal set in its iscsiPortalRoles column.")
iscsiIntrPortalNodeIndexOrZero = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 4, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiIntrPortalNodeIndexOrZero.setDescription("An arbitrary integer used to uniquely identify a\nparticular node within an iSCSI instance present\non the local system.\n\nFor implementations where each {portal, node} tuple\ncan have a different portal tag, this value will\nmap to the iscsiNodeIndex.\n\nFor implementations where the portal tag is the\nsame for a given portal regardless of which node\nis using the portal, the value 0 (zero) is used.")
iscsiIntrPortalTag = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 4, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiIntrPortalTag.setDescription("The portal's aggregation tag when the portal is used as\nan initiator portal.  Multiple-connection sessions may\nbe aggregated over portals sharing an identical\naggregation tag.  This object's storage type is\nspecified in iscsiPortalStorageType.")
iscsiNode = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 5))
iscsiNodeAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 5, 1))
if mibBuilder.loadTexts: iscsiNodeAttributesTable.setDescription("A list of iSCSI nodes belonging to each iSCSI instance\npresent on the local system.  An iSCSI node can act as\nan initiator, a target, or both.")
iscsiNodeAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"))
if mibBuilder.loadTexts: iscsiNodeAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular iSCSI node.")
iscsiNodeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiNodeIndex.setDescription("An arbitrary integer used to uniquely identify a particular\nnode within an iSCSI instance.  This index value must not be\nmodified or reused by an agent unless a reboot has occurred.\nAn agent should attempt to keep this value persistent across\nreboots.")
iscsiNodeName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 2), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeName.setDescription("This node's iSCSI name, which is independent of the location\nof the node, and can be resolved into a set of addresses\nthrough various discovery services.")
iscsiNodeAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 3), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeAlias.setDescription("A character string that is a human-readable name or\ndescription of the iSCSI node.  If configured, this alias\nmay be communicated to the initiator or target node at\nthe remote end of the connection during a Login Request\nor Response message.  This string is not used as an\nidentifier, but can be displayed by the system's user\ninterface in a list of initiators and/or targets to\nwhich it is connected.\n\nIf no alias exists, the value is a zero-length string.")
iscsiNodeRoles = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 4), Bits().subtype(namedValues=namedval.NamedValues(("targetTypeNode", 0), ("initiatorTypeNode", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeRoles.setDescription("A node can operate in one or both of two roles:\na target role and/or an initiator role.  If the node\nwill operate in both roles, both bits must be set.\n\nThis object will also define the corresponding rows that\nwill exist in the iscsiTargetAttributesTable, the\niscsiInitiatorAttributesTable or both.  If the\ntargetTypeNode bit is set, there will be a corresponding\niscsiTargetAttributesEntry.  If the initiatorTypeNode bit\nis set, there will be a corresponding\niscsiInitiatorAttributesEntry.  If both bits are set,\nthere will be a corresponding iscsiTgtPortalAttributesEntry\nand iscsiPortalAttributesEntry.")
iscsiNodeTransportType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 5), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeTransportType.setDescription("A pointer to the corresponding row in the appropriate\n\n\n\ntable for this SCSI transport, thereby allowing management\nstations to locate the SCSI-level device that is represented\nby this iscsiNode.  For example, it will usually point to the\ncorresponding scsiTrnspt object in the SCSI MIB module.\n\nIf no corresponding row exists, the value 0.0 must be\nused to indicate this.")
iscsiNodeInitialR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeInitialR2T.setDescription("This object indicates the InitialR2T preference for this\nnode:\ntrue = YES,\nfalse = will try to negotiate NO, will accept YES ")
iscsiNodeImmediateData = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 7), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeImmediateData.setDescription("This object indicates ImmediateData preference for this\nnode:\ntrue = YES (but will accept NO),\nfalse = NO ")
iscsiNodeMaxOutstandingR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeMaxOutstandingR2T.setDescription("Maximum number of outstanding requests-to-transmit (R2Ts)\nallowed per iSCSI task.")
iscsiNodeFirstBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215)).clone(65536)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeFirstBurstLength.setDescription("The maximum length (bytes) supported for unsolicited data\nto/from this node.")
iscsiNodeMaxBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215)).clone(262144)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeMaxBurstLength.setDescription("The maximum number of bytes that can be sent within\na single sequence of Data-In or Data-Out PDUs.")
iscsiNodeMaxConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeMaxConnections.setDescription("The maximum number of connections allowed in each\nsession to and/or from this node.")
iscsiNodeDataSequenceInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 12), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDataSequenceInOrder.setDescription("The DataSequenceInOrder preference of this node.\n\n\n\nFalse (=No) indicates that iSCSI data PDU sequences may\nbe transferred in any order.  True (=Yes) indicates that\ndata PDU sequences must be transferred using\ncontinuously increasing offsets, except during\nerror recovery.")
iscsiNodeDataPDUInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 13), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDataPDUInOrder.setDescription("The DataPDUInOrder preference of this node.\nFalse (=No) indicates that iSCSI data PDUs within sequences\nmay be in any order.  True (=Yes) indicates that data PDUs\nwithin sequences must be at continuously increasing\naddresses, with no gaps or overlay between PDUs.")
iscsiNodeDefaultTime2Wait = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600)).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDefaultTime2Wait.setDescription("The DefaultTime2Wait preference of this node.  This is the\nminimum time, in seconds, to wait before attempting an\nexplicit/implicit logout or active iSCSI task reassignment\nafter an unexpected connection termination or a connection\nreset.")
iscsiNodeDefaultTime2Retain = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 15), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600)).clone(20)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeDefaultTime2Retain.setDescription("The DefaultTime2Retain preference of this node.  This is\n\n\n\nthe maximum time, in seconds after an initial wait\n(Time2Wait), before which an active iSCSI task reassignment\nis still possible after an unexpected connection termination\nor a connection reset.")
iscsiNodeErrorRecoveryLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 16), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeErrorRecoveryLevel.setDescription("The ErrorRecoveryLevel preference of this node.\nCurrently, only 0-2 are valid.\n\nThis object is designed to accommodate future error recovery\nlevels.\n\nHigher error recovery levels imply support in addition to\nsupport for the lower error level functions.  In other words,\nerror level 2 implies support for levels 0-1, since those\nfunctions are subsets of error level 2.")
iscsiNodeDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 17), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiNodeDiscontinuityTime.setDescription("The value of SysUpTime on the most recent occasion\nat which any one or more of this node's counters\nsuffered a discontinuity.\n\nIf no such discontinuities have occurred since the last\nre-initialization of the local management subsystem,\nthen this object contains a zero value.")
iscsiNodeStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 5, 1, 1, 18), StorageType().clone('volatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: iscsiNodeStorageType.setDescription("The storage type for all read-write objects within this\nrow.  Rows in this table are always created via an\nexternal process, and may have a storage type of readOnly\nor permanent.  Conceptual rows having the value 'permanent'\nneed not allow write access to any columnar objects in\nthe row.\n\nIf this object has the value 'volatile', modifications\nto read-write objects in this row are not persistent\nacross reboots.  If this object has the value\n'nonVolatile', modifications to objects in this row\nare persistent.\n\nAn implementation may choose to allow this object\nto be set to either 'nonVolatile' or 'volatile',\nallowing the management application to choose this\nbehavior.")
iscsiTarget = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 6))
iscsiTargetAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 6, 1))
if mibBuilder.loadTexts: iscsiTargetAttributesTable.setDescription("A list of iSCSI nodes that can take on a target role,\nbelonging to each iSCSI instance present on the local\nsystem.")
iscsiTargetAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"))
if mibBuilder.loadTexts: iscsiTargetAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular node that can take on a target role.")
iscsiTgtLoginFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginFailures.setDescription("This object counts the number of times a login attempt to this\nlocal target has failed.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLastFailureTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastFailureTime.setDescription("The timestamp of the most recent failure of a login attempt\nto this target.  A value of zero indicates that no such\nfailures have occurred since the last system boot.")
iscsiTgtLastFailureType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastFailureType.setDescription("The type of the most recent failure of a login attempt\nto this target, represented as the OID of the counter\nobject in iscsiTargetLoginStatsTable for which the\nrelevant instance was incremented.  A value of 0.0\nindicates a type that is not represented by any of\nthe counters in iscsiTargetLoginStatsTable.")
iscsiTgtLastIntrFailureName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 4), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastIntrFailureName.setDescription("The iSCSI name of the initiator that failed the last\nlogin attempt.")
iscsiTgtLastIntrFailureAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastIntrFailureAddrType.setDescription("The type of Internet Network Address contained in the\ncorresponding instance of the iscsiTgtLastIntrFailureAddr.\nThe value 'dns' is not allowed.")
iscsiTgtLastIntrFailureAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 1, 1, 6), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLastIntrFailureAddr.setDescription("An Internet Network Address, of the type specified by\nthe object iscsiTgtLastIntrFailureAddrType, giving the\nhost address of the initiator that failed the last login\nattempt.")
iscsiTargetLoginStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 6, 2))
if mibBuilder.loadTexts: iscsiTargetLoginStatsTable.setDescription("A table of counters that keep a record of the results\nof initiators' login attempts to this target.")
iscsiTargetLoginStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1))
if mibBuilder.loadTexts: iscsiTargetLoginStatsEntry.setDescription("An entry (row) containing counters for each result of\na login attempt to this target.")
iscsiTgtLoginAccepts = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginAccepts.setDescription("The count of Login Response PDUs with status\n0x0000, Accept Login, transmitted by this\ntarget.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLoginOtherFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginOtherFails.setDescription("The number of Login Response PDUs that were transmitted\nby this target and that were not counted by any other\nobject in the row.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLoginRedirects = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginRedirects.setDescription("The count of Login Response PDUs with status class 0x01,\nRedirection, transmitted by this target.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLoginAuthorizeFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginAuthorizeFails.setDescription("The count of Login Response PDUs with status 0x0202,\nForbidden Target, transmitted by this target.\n\nIf this counter is incremented, an iscsiTgtLoginFailure\nnotification should be generated.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLoginAuthenticateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginAuthenticateFails.setDescription("The count of Login Response PDUs with status 0x0201,\nAuthentication Failed, transmitted by this target.\n\nIf this counter is incremented, an iscsiTgtLoginFailure\nnotification should be generated.\n\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLoginNegotiateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLoginNegotiateFails.setDescription("The number of times a target has effectively refused a\nlogin because the parameter negotiation failed.\n\n\n\n\nIf this counter is incremented, an iscsiTgtLoginFailure\nnotification should be generated.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTargetLogoutStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 6, 3))
if mibBuilder.loadTexts: iscsiTargetLogoutStatsTable.setDescription("When a target receives a Logout command, it responds\nwith a Logout Response that carries a status code.\nThis table contains counters for both normal and\nabnormal logout requests received by this target.")
iscsiTargetLogoutStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 6, 3, 1))
if mibBuilder.loadTexts: iscsiTargetLogoutStatsEntry.setDescription("An entry (row) containing counters of Logout Response\nPDUs that were received by this target.")
iscsiTgtLogoutNormals = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLogoutNormals.setDescription("The count of Logout Command PDUs received by this target,\nwith reason code 0 (closes the session).\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtLogoutOthers = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 6, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiTgtLogoutOthers.setDescription("The count of Logout Command PDUs received by this target,\nwith any reason code other than 0.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiTgtAuthorization = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 7))
iscsiTgtAuthAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 7, 1))
if mibBuilder.loadTexts: iscsiTgtAuthAttributesTable.setDescription("A list of initiator identities that are authorized to\naccess each target node within each iSCSI instance\npresent on the local system.")
iscsiTgtAuthAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"), (0, "ISCSI-MIB", "iscsiTgtAuthIndex"))
if mibBuilder.loadTexts: iscsiTgtAuthAttributesEntry.setDescription("An entry (row) containing management information\napplicable to a particular target node's authorized\ninitiator identity.")
iscsiTgtAuthIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiTgtAuthIndex.setDescription("An arbitrary integer used to uniquely identify a particular\ntarget's authorized initiator identity within an iSCSI\ninstance present on the local system.  This index value must\nnot be modified or reused by an agent unless a reboot has\noccurred.  An agent should attempt to keep this value\npersistent across reboots.")
iscsiTgtAuthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiTgtAuthRowStatus.setDescription("This field allows entries to be dynamically added and\nremoved from this table via SNMP.  When adding a row to\nthis table, all non-Index/RowStatus objects must be set.\nWhen the value of this object is 'active', the values of\nthe other objects in this table cannot be changed.\nRows may be discarded using RowStatus.")
iscsiTgtAuthIdentity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiTgtAuthIdentity.setDescription("A pointer to the corresponding user entry in the IPS-AUTH\nMIB module that will be allowed to access this iSCSI target.")
iscsiTgtAuthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 7, 1, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiTgtAuthStorageType.setDescription("The storage type for this row.  Rows in this table that were\ncreated through an external process may have a storage type of\nreadOnly or permanent.\n\nConceptual rows having the value 'permanent' need not\nallow write access to any columnar objects in the row.")
iscsiInitiator = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 8))
iscsiInitiatorAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 8, 1))
if mibBuilder.loadTexts: iscsiInitiatorAttributesTable.setDescription("A list of iSCSI nodes that can take on an initiator\nrole, belonging to each iSCSI instance present on\nthe local system.")
iscsiInitiatorAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"))
if mibBuilder.loadTexts: iscsiInitiatorAttributesEntry.setDescription("An entry (row) containing management information\napplicable to a particular iSCSI node that has\ninitiator capabilities.")
iscsiIntrLoginFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginFailures.setDescription("This object counts the number of times a login attempt from\nthis local initiator has failed.\nIf this counter has suffered a discontinuity, the time of the\n\n\n\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLastFailureTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastFailureTime.setDescription("The timestamp of the most recent failure of a login attempt\nfrom this initiator.  A value of zero indicates that no such\nfailures have occurred since the last system boot.")
iscsiIntrLastFailureType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastFailureType.setDescription("The type of the most recent failure of a login attempt\nfrom this initiator, represented as the OID of the counter\nobject in iscsiInitiatorLoginStatsTable for which the\nrelevant instance was incremented.  A value of 0.0\nindicates a type that is not represented by any of\nthe counters in iscsiInitiatorLoginStatsTable.")
iscsiIntrLastTgtFailureName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 4), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastTgtFailureName.setDescription("A UTF-8 string giving the name of the target that failed\nthe last login attempt.")
iscsiIntrLastTgtFailureAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastTgtFailureAddrType.setDescription("The type of Internet Network Address contained in the\ncorresponding instance of the iscsiIntrLastTgtFailureAddr.\nThe value 'dns' is not allowed.")
iscsiIntrLastTgtFailureAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 1, 1, 6), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLastTgtFailureAddr.setDescription("An Internet Network Address, of the type specified by the\nobject iscsiIntrLastTgtFailureAddrType, giving the host\naddress of the target that failed the last login attempt.")
iscsiInitiatorLoginStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 8, 2))
if mibBuilder.loadTexts: iscsiInitiatorLoginStatsTable.setDescription("A table of counters which keep track of the results of\nthis initiator's login attempts.")
iscsiInitiatorLoginStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1))
if mibBuilder.loadTexts: iscsiInitiatorLoginStatsEntry.setDescription("An entry (row) containing counters of each result\nof this initiator's login attempts.")
iscsiIntrLoginAcceptRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginAcceptRsps.setDescription("The count of Login Response PDUs with status\n0x0000, Accept Login, received by this initiator.\nIf this counter has suffered a discontinuity, the time of the\n\n\n\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLoginOtherFailRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginOtherFailRsps.setDescription("The count of Login Response PDUs received by this\ninitiator with any status code not counted in the\nobjects below.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLoginRedirectRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginRedirectRsps.setDescription("The count of Login Response PDUs with status class 0x01,\nRedirection, received by this initiator.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLoginAuthFailRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginAuthFailRsps.setDescription("The count of Login Response PDUs with status class 0x201,\nAuthentication Failed, received by this initiator.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLoginAuthenticateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginAuthenticateFails.setDescription("The number of times the initiator has aborted a\nlogin because the target could not be authenticated.\n\nNo response is generated.\n\nIf this counter is incremented, an iscsiIntrLoginFailure\nnotification should be generated.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLoginNegotiateFails = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLoginNegotiateFails.setDescription("The number of times the initiator has aborted a\nlogin because parameter negotiation with the target\nfailed.\n\nNo response is generated.\n\nIf this counter is incremented, an iscsiIntrLoginFailure\nnotification should be generated.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiInitiatorLogoutStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 8, 3))
if mibBuilder.loadTexts: iscsiInitiatorLogoutStatsTable.setDescription("When an initiator attempts to send a Logout command, the target\nresponds with a Logout Response that carries a status code.\n\n\n\nThis table contains a list of counters of Logout Response\nPDUs of each status code that was received by each\ninitiator belonging to this iSCSI instance present on this\nsystem.")
iscsiInitiatorLogoutStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 8, 3, 1))
if mibBuilder.loadTexts: iscsiInitiatorLogoutStatsEntry.setDescription("An entry (row) containing counters of Logout Response\nPDUs of each status code that was generated by this\ninitiator.")
iscsiIntrLogoutNormals = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLogoutNormals.setDescription("The count of Logout Command PDUs generated by this initiator\nwith reason code 0 (closes the session).\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrLogoutOthers = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 8, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiIntrLogoutOthers.setDescription("The count of Logout Command PDUs generated by this initiator\nwith any status code other than 0.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiNodeDiscontinuityTime.")
iscsiIntrAuthorization = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 9))
iscsiIntrAuthAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 9, 1))
if mibBuilder.loadTexts: iscsiIntrAuthAttributesTable.setDescription("A list of target identities that each initiator\non the local system may access.")
iscsiIntrAuthAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiNodeIndex"), (0, "ISCSI-MIB", "iscsiIntrAuthIndex"))
if mibBuilder.loadTexts: iscsiIntrAuthAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular initiator node's authorized target identity.")
iscsiIntrAuthIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiIntrAuthIndex.setDescription("An arbitrary integer used to uniquely identify a\nparticular initiator node's authorized target\nidentity within an iSCSI instance present on the\nlocal system.  This index value must not be modified\nor reused by an agent unless a reboot has occurred.\nAn agent should attempt to keep this value persistent\nacross reboots.")
iscsiIntrAuthRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiIntrAuthRowStatus.setDescription("This field allows entries to be dynamically added and\nremoved from this table via SNMP.  When adding a row to\nthis table, all non-Index/RowStatus objects must be set.\nWhen the value of this object is 'active', the values of\nthe other objects in this table cannot be changed.\nRows may be discarded using RowStatus.")
iscsiIntrAuthIdentity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 3), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiIntrAuthIdentity.setDescription("A pointer to the corresponding user entry in the IPS-AUTH\nMIB module to which this initiator node should attempt to\nestablish an iSCSI session.")
iscsiIntrAuthStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 9, 1, 1, 4), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: iscsiIntrAuthStorageType.setDescription("The storage type for this row.  Rows in this table that were\ncreated through an external process may have a storage type of\nreadOnly or permanent.\n\nConceptual rows having the value 'permanent' need not\nallow write access to any columnar objects in the row.")
iscsiSession = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 10))
iscsiSessionAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 10, 1))
if mibBuilder.loadTexts: iscsiSessionAttributesTable.setDescription("A list of sessions belonging to each iSCSI instance\npresent on the system.")
iscsiSessionAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiSsnNodeIndex"), (0, "ISCSI-MIB", "iscsiSsnIndex"))
if mibBuilder.loadTexts: iscsiSessionAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular session.\n\nIf this session is a discovery session that is not attached\nto any particular node, the iscsiSsnNodeIndex will be zero.\nOtherwise, the iscsiSsnNodeIndex will have the same value as\niscsiNodeIndex.")
iscsiSsnNodeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiSsnNodeIndex.setDescription("An arbitrary integer used to uniquely identify a\nparticular node within an iSCSI instance present\non the local system.  For normal, non-discovery\nsessions, this value will map to the iscsiNodeIndex.\nFor discovery sessions that do not have a node\nassociated, the value 0 (zero) is used.")
iscsiSsnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiSsnIndex.setDescription("An arbitrary integer used to uniquely identify a\nparticular session within an iSCSI instance present\non the local system.  An agent should attempt to\nnot reuse index values unless a reboot has occurred.\niSCSI sessions are destroyed during a reboot; rows\nin this table are not persistent across reboots.")
iscsiSsnDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("inboundSession", 1), ("outboundSession", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDirection.setDescription("Direction of iSCSI session:\ninboundSession  - session is established from an external\n                  initiator to a target within this iSCSI\n                  instance.\noutboundSession - session is established from an initiator\n                  within this iSCSI instance to an external\n                  target.")
iscsiSsnInitiatorName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 4), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnInitiatorName.setDescription("If iscsiSsnDirection is Inbound, this object is a\nUTF-8 string that will contain the name of the remote\ninitiator.  If this session is a discovery session that\n\n\n\ndoes not specify a particular initiator, this object\nwill contain a zero-length string.\n\nIf iscsiSsnDirection is Outbound, this object will\ncontain a zero-length string.")
iscsiSsnTargetName = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 5), IscsiName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTargetName.setDescription("If iscsiSsnDirection is Outbound, this object is a\nUTF-8 string that will contain the name of the remote\ntarget.  If this session is a discovery session that\ndoes not specify a particular target, this object will\ncontain a zero-length string.\n\nIf iscsiSsnDirection is Inbound, this object will\ncontain a zero-length string.")
iscsiSsnTSIH = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTSIH.setDescription("The target-defined identification handle for this session.")
iscsiSsnISID = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 7), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(6, 6)).setFixedLength(6)).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnISID.setDescription("The initiator-defined portion of the iSCSI Session ID.")
iscsiSsnInitiatorAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 8), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnInitiatorAlias.setDescription("A UTF-8 string that gives the alias communicated by the\n\n\n\ninitiator end of the session during the login phase.\n\nIf no alias exists, the value is a zero-length string.")
iscsiSsnTargetAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTargetAlias.setDescription("A UTF-8 string that gives the alias communicated by the\ntarget end of the session during the login phase.\n\nIf no alias exists, the value is a zero-length string.")
iscsiSsnInitialR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnInitialR2T.setDescription("If set to true, indicates that the initiator must wait\nfor an R2T before sending to the target.  If set to false,\nthe initiator may send data immediately, within limits set\nby iscsiSsnFirstBurstLength and the expected data transfer\nlength of the request.")
iscsiSsnImmediateData = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnImmediateData.setDescription("Indicates whether the initiator and target have agreed to\nsupport immediate data on this session.")
iscsiSsnType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("normalSession", 1), ("discoverySession", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnType.setDescription("Type of iSCSI session:\nnormalSession    - session is a normal iSCSI session\ndiscoverySession - session is being used only for discovery.")
iscsiSsnMaxOutstandingR2T = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnMaxOutstandingR2T.setDescription("The maximum number of outstanding requests-to-transmit\n(R2Ts) per iSCSI task within this session.")
iscsiSsnFirstBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnFirstBurstLength.setDescription("The maximum length supported for unsolicited data sent\nwithin this session.")
iscsiSsnMaxBurstLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 15), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnMaxBurstLength.setDescription("The maximum number of bytes that can be sent within\na single sequence of Data-In or Data-Out PDUs.")
iscsiSsnConnectionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 16), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnConnectionNumber.setDescription("The number of transport protocol connections that currently\nbelong to this session.")
iscsiSsnAuthIdentity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 17), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnAuthIdentity.setDescription("This object contains a pointer to a row in the\nIPS-AUTH MIB module that identifies the authentication\nmethod being used on this session, as communicated\nduring the login phase.")
iscsiSsnDataSequenceInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDataSequenceInOrder.setDescription("False indicates that iSCSI data PDU sequences may\nbe transferred in any order.  True indicates that\ndata PDU sequences must be transferred using\ncontinuously increasing offsets, except during\nerror recovery.")
iscsiSsnDataPDUInOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 19), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDataPDUInOrder.setDescription("False indicates that iSCSI data PDUs within sequences\nmay be in any order.  True indicates that data PDUs\nwithin sequences must be at continuously increasing\naddresses, with no gaps or overlay between PDUs.\n\nDefault is true.")
iscsiSsnErrorRecoveryLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 20), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnErrorRecoveryLevel.setDescription("The level of error recovery negotiated between\nthe initiator and the target.  Higher numbers\nrepresent more detailed recovery schemes.")
iscsiSsnDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 1, 1, 21), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnDiscontinuityTime.setDescription("The value of SysUpTime on the most recent occasion\nat which any one or more of this session's counters\nsuffered a discontinuity.\nWhen a session is established, and this object is\ncreated, it is initialized to the current value\nof SysUpTime.")
iscsiSessionStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 10, 2))
if mibBuilder.loadTexts: iscsiSessionStatsTable.setDescription("A list of general iSCSI traffic counters for each of the\nsessions present on the system.")
iscsiSessionStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1))
if mibBuilder.loadTexts: iscsiSessionStatsEntry.setDescription("An entry (row) containing general iSCSI traffic counters\nfor a particular session.")
iscsiSsnCmdPDUs = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnCmdPDUs.setDescription("The count of Command PDUs transferred on this session.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnRspPDUs = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnRspPDUs.setDescription("The count of Response PDUs transferred on this session.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnTxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnTxDataOctets.setDescription("The count of data octets that were transmitted by\nthe local iSCSI node on this session.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnRxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnRxDataOctets.setDescription("The count of data octets that were received by\nthe local iSCSI node on this session.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnLCTxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnLCTxDataOctets.setDescription("A Low Capacity shadow object of iscsiSsnTxDataOctets\nfor those systems that don't support Counter64.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnLCRxDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnLCRxDataOctets.setDescription("A Low Capacity shadow object of iscsiSsnRxDataOctets\nfor those systems that don't support Counter64.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSessionCxnErrorStatsTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 10, 3))
if mibBuilder.loadTexts: iscsiSessionCxnErrorStatsTable.setDescription("A list of error counters for each of the sessions\npresent on this system.")
iscsiSessionCxnErrorStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 10, 3, 1))
if mibBuilder.loadTexts: iscsiSessionCxnErrorStatsEntry.setDescription("An entry (row) containing error counters for\na particular session.")
iscsiSsnCxnDigestErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnCxnDigestErrors.setDescription("The count of PDUs that were received on the session and\ncontained header or data digest errors.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiSsnCxnTimeoutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 10, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiSsnCxnTimeoutErrors.setDescription("The count of connections within this session\nthat have been terminated due to timeout.\nIf this counter has suffered a discontinuity, the time of the\nlast discontinuity is indicated in iscsiSsnDiscontinuityTime.")
iscsiConnection = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 1, 11))
iscsiConnectionAttributesTable = MibTable((1, 3, 6, 1, 2, 1, 142, 1, 11, 1))
if mibBuilder.loadTexts: iscsiConnectionAttributesTable.setDescription("A list of connections belonging to each iSCSI instance\npresent on the system.")
iscsiConnectionAttributesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1)).setIndexNames((0, "ISCSI-MIB", "iscsiInstIndex"), (0, "ISCSI-MIB", "iscsiSsnNodeIndex"), (0, "ISCSI-MIB", "iscsiSsnIndex"), (0, "ISCSI-MIB", "iscsiCxnIndex"))
if mibBuilder.loadTexts: iscsiConnectionAttributesEntry.setDescription("An entry (row) containing management information applicable\nto a particular connection.")
iscsiCxnIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: iscsiCxnIndex.setDescription("An arbitrary integer used to uniquely identify a\nparticular connection of a particular session within\nan iSCSI instance present on the local system.  An\nagent should attempt to not reuse index values unless\na reboot has occurred.  iSCSI connections are destroyed\nduring a reboot; rows in this table are not persistent\nacross reboots.")
iscsiCxnCid = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnCid.setDescription("The iSCSI Connection ID for this connection.")
iscsiCxnState = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("login", 1), ("full", 2), ("logout", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnState.setDescription("The current state of this connection, from an iSCSI negotiation\npoint of view.  Here are the states:\n\nlogin  - The transport protocol connection has been established,\n         but a valid iSCSI login response with the final bit set\n         has not been sent or received.\nfull   - A valid iSCSI login response with the final bit set\n         has been sent or received.\nlogout - A valid iSCSI logout command has been sent or\n         received, but the transport protocol connection has\n         not yet been closed.")
iscsiCxnAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnAddrType.setDescription("The type of Internet Network Addresses contained in the\ncorresponding instances of iscsiCxnLocalAddr and\niscsiCxnRemoteAddr.\nThe value 'dns' is not allowed.")
iscsiCxnLocalAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnLocalAddr.setDescription("The local Internet Network Address, of the type specified\nby iscsiCxnAddrType, used by this connection.")
iscsiCxnProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 6), IscsiTransportProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnProtocol.setDescription("The transport protocol over which this connection is\nrunning.")
iscsiCxnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 7), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnLocalPort.setDescription("The local transport protocol port used by this connection.\nThis object cannot have the value zero, since it represents\nan established connection.")
iscsiCxnRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 8), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnRemoteAddr.setDescription("The remote Internet Network Address, of the type specified\nby iscsiCxnAddrType, used by this connection.")
iscsiCxnRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 9), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnRemotePort.setDescription("The remote transport protocol port used by this connection.\nThis object cannot have the value zero, since it represents\nan established connection.")
iscsiCxnMaxRecvDataSegLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnMaxRecvDataSegLength.setDescription("The maximum data payload size supported for command\nor data PDUs able to be received on this connection.")
iscsiCxnMaxXmitDataSegLength = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(512, 16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnMaxXmitDataSegLength.setDescription("The maximum data payload size supported for command\nor data PDUs to be sent on this connection.")
iscsiCxnHeaderIntegrity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 12), IscsiDigestMethod()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnHeaderIntegrity.setDescription("This object identifies the iSCSI header\ndigest scheme in use within this connection.")
iscsiCxnDataIntegrity = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 13), IscsiDigestMethod()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnDataIntegrity.setDescription("This object identifies the iSCSI data\ndigest scheme in use within this connection.")
iscsiCxnRecvMarker = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 14), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnRecvMarker.setDescription("This object indicates whether or not this connection\nis receiving markers in its incoming data stream.")
iscsiCxnSendMarker = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnSendMarker.setDescription("This object indicates whether or not this connection\nis inserting markers in its outgoing data stream.")
iscsiCxnVersionActive = MibTableColumn((1, 3, 6, 1, 2, 1, 142, 1, 11, 1, 1, 16), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: iscsiCxnVersionActive.setDescription("Active version number of the iSCSI specification negotiated\non this connection.")
iscsiConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 2))
iscsiCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 2, 1))
iscsiGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 2, 2))
iscsiAdmin = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3))
iscsiDescriptors = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3, 1))
iscsiHeaderIntegrityTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3, 1, 1))
iscsiHdrIntegrityNone = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 1, 1))
if mibBuilder.loadTexts: iscsiHdrIntegrityNone.setDescription("The authoritative identifier when no integrity\nscheme (for either the header or data) is being\n\n\n\nused.")
iscsiHdrIntegrityCrc32c = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 1, 2))
if mibBuilder.loadTexts: iscsiHdrIntegrityCrc32c.setDescription("The authoritative identifier when the integrity\nscheme (for either the header or data) is CRC32c.")
iscsiDataIntegrityTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 142, 3, 1, 2))
iscsiDataIntegrityNone = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 2, 1))
if mibBuilder.loadTexts: iscsiDataIntegrityNone.setDescription("The authoritative identifier when no integrity\nscheme (for either the header or data) is being\nused.")
iscsiDataIntegrityCrc32c = ObjectIdentity((1, 3, 6, 1, 2, 1, 142, 3, 1, 2, 2))
if mibBuilder.loadTexts: iscsiDataIntegrityCrc32c.setDescription("The authoritative identifier when the integrity\nscheme (for either the header or data) is CRC32c.")

# Augmentions
iscsiInstanceAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiInstanceSsnErrorStatsEntry"))
iscsiInstanceSsnErrorStatsEntry.setIndexNames(*iscsiInstanceAttributesEntry.getIndexNames())
iscsiTargetAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiTargetLogoutStatsEntry"))
iscsiTargetLogoutStatsEntry.setIndexNames(*iscsiTargetAttributesEntry.getIndexNames())
iscsiInitiatorAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiInitiatorLogoutStatsEntry"))
iscsiInitiatorLogoutStatsEntry.setIndexNames(*iscsiInitiatorAttributesEntry.getIndexNames())
iscsiTargetAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiTargetLoginStatsEntry"))
iscsiTargetLoginStatsEntry.setIndexNames(*iscsiTargetAttributesEntry.getIndexNames())
iscsiInitiatorAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiInitiatorLoginStatsEntry"))
iscsiInitiatorLoginStatsEntry.setIndexNames(*iscsiInitiatorAttributesEntry.getIndexNames())
iscsiSessionAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiSessionCxnErrorStatsEntry"))
iscsiSessionCxnErrorStatsEntry.setIndexNames(*iscsiSessionAttributesEntry.getIndexNames())
iscsiSessionAttributesEntry.registerAugmentions(("ISCSI-MIB", "iscsiSessionStatsEntry"))
iscsiSessionStatsEntry.setIndexNames(*iscsiSessionAttributesEntry.getIndexNames())

# Notifications

iscsiTgtLoginFailure = NotificationType((1, 3, 6, 1, 2, 1, 142, 0, 1)).setObjects(("ISCSI-MIB", "iscsiTgtLastIntrFailureName"), ("ISCSI-MIB", "iscsiTgtLastFailureType"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddr"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddrType"), ("ISCSI-MIB", "iscsiTgtLoginFailures"), )
if mibBuilder.loadTexts: iscsiTgtLoginFailure.setDescription("Sent when a login is failed by a target.\n\nTo avoid sending an excessive number of notifications due\nto multiple errors counted, an SNMP agent implementing this\nnotification SHOULD NOT send more than 3 notifications of\nthis type in any 10-second time period.")
iscsiIntrLoginFailure = NotificationType((1, 3, 6, 1, 2, 1, 142, 0, 2)).setObjects(("ISCSI-MIB", "iscsiIntrLoginFailures"), ("ISCSI-MIB", "iscsiIntrLastFailureType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureName"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddrType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddr"), )
if mibBuilder.loadTexts: iscsiIntrLoginFailure.setDescription("Sent when a login is failed by an initiator.\n\nTo avoid sending an excessive number of notifications due\nto multiple errors counted, an SNMP agent implementing this\nnotification SHOULD NOT send more than 3 notifications of\nthis type in any 10-second time period.")
iscsiInstSessionFailure = NotificationType((1, 3, 6, 1, 2, 1, 142, 0, 3)).setObjects(("ISCSI-MIB", "iscsiInstLastSsnRmtNodeName"), ("ISCSI-MIB", "iscsiInstSsnFailures"), ("ISCSI-MIB", "iscsiInstLastSsnFailureType"), )
if mibBuilder.loadTexts: iscsiInstSessionFailure.setDescription("Sent when an active session is failed by either the initiator\nor the target.\n\nTo avoid sending an excessive number of notifications due\nto multiple errors counted, an SNMP agent implementing this\nnotification SHOULD NOT send more than 3 notifications of\nthis type in any 10-second time period.")

# Groups

iscsiInstanceAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 1)).setObjects(("ISCSI-MIB", "iscsiInstVendorVersion"), ("ISCSI-MIB", "iscsiInstLastSsnFailureType"), ("ISCSI-MIB", "iscsiInstVersionMin"), ("ISCSI-MIB", "iscsiInstDiscontinuityTime"), ("ISCSI-MIB", "iscsiInstVendorID"), ("ISCSI-MIB", "iscsiInstDescr"), ("ISCSI-MIB", "iscsiInstPortalNumber"), ("ISCSI-MIB", "iscsiInstSessionNumber"), ("ISCSI-MIB", "iscsiInstVersionMax"), ("ISCSI-MIB", "iscsiInstSsnFailures"), ("ISCSI-MIB", "iscsiInstLastSsnRmtNodeName"), ("ISCSI-MIB", "iscsiInstNodeNumber"), )
if mibBuilder.loadTexts: iscsiInstanceAttributesGroup.setDescription("A collection of objects providing information about iSCSI\ninstances.")
iscsiInstanceSsnErrorStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 2)).setObjects(("ISCSI-MIB", "iscsiInstSsnDigestErrors"), ("ISCSI-MIB", "iscsiInstSsnFormatErrors"), ("ISCSI-MIB", "iscsiInstSsnCxnTimeoutErrors"), )
if mibBuilder.loadTexts: iscsiInstanceSsnErrorStatsGroup.setDescription("A collection of objects providing information about\nerrors that have caused a session failure for an\niSCSI instance.")
iscsiPortalAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 3)).setObjects(("ISCSI-MIB", "iscsiPortalRoles"), ("ISCSI-MIB", "iscsiPortalStorageType"), ("ISCSI-MIB", "iscsiPortalMaxRecvDataSegLength"), ("ISCSI-MIB", "iscsiPortalSecondaryHdrDigest"), ("ISCSI-MIB", "iscsiPortalPrimaryDataDigest"), ("ISCSI-MIB", "iscsiPortalPrimaryHdrDigest"), ("ISCSI-MIB", "iscsiPortalAddrType"), ("ISCSI-MIB", "iscsiPortalRecvMarker"), ("ISCSI-MIB", "iscsiPortalSecondaryDataDigest"), ("ISCSI-MIB", "iscsiPortalProtocol"), ("ISCSI-MIB", "iscsiPortalAddr"), ("ISCSI-MIB", "iscsiPortalRowStatus"), )
if mibBuilder.loadTexts: iscsiPortalAttributesGroup.setDescription("A collection of objects providing information about\nthe transport protocol endpoints of the local targets.")
iscsiTgtPortalAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 4)).setObjects(("ISCSI-MIB", "iscsiTgtPortalPort"), ("ISCSI-MIB", "iscsiTgtPortalTag"), )
if mibBuilder.loadTexts: iscsiTgtPortalAttributesGroup.setDescription("A collection of objects providing information about\nthe transport protocol endpoints of the local targets.")
iscsiIntrPortalAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 5)).setObjects(("ISCSI-MIB", "iscsiIntrPortalTag"), )
if mibBuilder.loadTexts: iscsiIntrPortalAttributesGroup.setDescription("An object providing information about\nthe portal tags used by the local initiators.")
iscsiNodeAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 6)).setObjects(("ISCSI-MIB", "iscsiNodeDataPDUInOrder"), ("ISCSI-MIB", "iscsiNodeDiscontinuityTime"), ("ISCSI-MIB", "iscsiNodeAlias"), ("ISCSI-MIB", "iscsiNodeStorageType"), ("ISCSI-MIB", "iscsiNodeErrorRecoveryLevel"), ("ISCSI-MIB", "iscsiNodeDefaultTime2Retain"), ("ISCSI-MIB", "iscsiNodeMaxBurstLength"), ("ISCSI-MIB", "iscsiNodeDefaultTime2Wait"), ("ISCSI-MIB", "iscsiNodeDataSequenceInOrder"), ("ISCSI-MIB", "iscsiNodeTransportType"), ("ISCSI-MIB", "iscsiNodeMaxConnections"), ("ISCSI-MIB", "iscsiNodeRoles"), ("ISCSI-MIB", "iscsiNodeImmediateData"), ("ISCSI-MIB", "iscsiNodeInitialR2T"), ("ISCSI-MIB", "iscsiNodeMaxOutstandingR2T"), ("ISCSI-MIB", "iscsiNodeFirstBurstLength"), ("ISCSI-MIB", "iscsiNodeName"), )
if mibBuilder.loadTexts: iscsiNodeAttributesGroup.setDescription("A collection of objects providing information about all\nlocal targets.")
iscsiTargetAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 7)).setObjects(("ISCSI-MIB", "iscsiTgtLastIntrFailureName"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddr"), ("ISCSI-MIB", "iscsiTgtLastFailureTime"), ("ISCSI-MIB", "iscsiTgtLastFailureType"), ("ISCSI-MIB", "iscsiTgtLoginFailures"), ("ISCSI-MIB", "iscsiTgtLastIntrFailureAddrType"), )
if mibBuilder.loadTexts: iscsiTargetAttributesGroup.setDescription("A collection of objects providing information about all\nlocal targets.")
iscsiTargetLoginStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 8)).setObjects(("ISCSI-MIB", "iscsiTgtLoginOtherFails"), ("ISCSI-MIB", "iscsiTgtLoginAuthorizeFails"), ("ISCSI-MIB", "iscsiTgtLoginAuthenticateFails"), ("ISCSI-MIB", "iscsiTgtLoginNegotiateFails"), ("ISCSI-MIB", "iscsiTgtLoginAccepts"), ("ISCSI-MIB", "iscsiTgtLoginRedirects"), )
if mibBuilder.loadTexts: iscsiTargetLoginStatsGroup.setDescription("A collection of objects providing information about all\nlogin attempts by remote initiators to local targets.")
iscsiTargetLogoutStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 9)).setObjects(("ISCSI-MIB", "iscsiTgtLogoutNormals"), ("ISCSI-MIB", "iscsiTgtLogoutOthers"), )
if mibBuilder.loadTexts: iscsiTargetLogoutStatsGroup.setDescription("A collection of objects providing information about all\nlogout events between remote initiators and local targets.")
iscsiTargetAuthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 10)).setObjects(("ISCSI-MIB", "iscsiTgtAuthIdentity"), ("ISCSI-MIB", "iscsiTgtAuthRowStatus"), ("ISCSI-MIB", "iscsiTgtAuthStorageType"), )
if mibBuilder.loadTexts: iscsiTargetAuthGroup.setDescription("A collection of objects providing information about all\nremote initiators that are authorized to connect to local\ntargets.")
iscsiInitiatorAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 11)).setObjects(("ISCSI-MIB", "iscsiIntrLastTgtFailureName"), ("ISCSI-MIB", "iscsiIntrLoginFailures"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddr"), ("ISCSI-MIB", "iscsiIntrLastFailureType"), ("ISCSI-MIB", "iscsiIntrLastTgtFailureAddrType"), ("ISCSI-MIB", "iscsiIntrLastFailureTime"), )
if mibBuilder.loadTexts: iscsiInitiatorAttributesGroup.setDescription("A collection of objects providing information about\nall local initiators.")
iscsiInitiatorLoginStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 12)).setObjects(("ISCSI-MIB", "iscsiIntrLoginRedirectRsps"), ("ISCSI-MIB", "iscsiIntrLoginAuthenticateFails"), ("ISCSI-MIB", "iscsiIntrLoginNegotiateFails"), ("ISCSI-MIB", "iscsiIntrLoginAuthFailRsps"), ("ISCSI-MIB", "iscsiIntrLoginOtherFailRsps"), ("ISCSI-MIB", "iscsiIntrLoginAcceptRsps"), )
if mibBuilder.loadTexts: iscsiInitiatorLoginStatsGroup.setDescription("A collection of objects providing information about all\nlogin attempts by local initiators to remote targets.")
iscsiInitiatorLogoutStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 13)).setObjects(("ISCSI-MIB", "iscsiIntrLogoutNormals"), ("ISCSI-MIB", "iscsiIntrLogoutOthers"), )
if mibBuilder.loadTexts: iscsiInitiatorLogoutStatsGroup.setDescription("A collection of objects providing information about all\nlogout events between local initiators and remote targets.")
iscsiInitiatorAuthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 14)).setObjects(("ISCSI-MIB", "iscsiIntrAuthStorageType"), ("ISCSI-MIB", "iscsiIntrAuthRowStatus"), ("ISCSI-MIB", "iscsiIntrAuthIdentity"), )
if mibBuilder.loadTexts: iscsiInitiatorAuthGroup.setDescription("A collection of objects providing information about all\nremote targets that are initiators of the local system\nthat they are authorized to access.")
iscsiSessionAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 15)).setObjects(("ISCSI-MIB", "iscsiSsnType"), ("ISCSI-MIB", "iscsiSsnDataPDUInOrder"), ("ISCSI-MIB", "iscsiSsnImmediateData"), ("ISCSI-MIB", "iscsiSsnISID"), ("ISCSI-MIB", "iscsiSsnDirection"), ("ISCSI-MIB", "iscsiSsnConnectionNumber"), ("ISCSI-MIB", "iscsiSsnMaxOutstandingR2T"), ("ISCSI-MIB", "iscsiSsnFirstBurstLength"), ("ISCSI-MIB", "iscsiSsnDiscontinuityTime"), ("ISCSI-MIB", "iscsiSsnInitiatorName"), ("ISCSI-MIB", "iscsiSsnTargetName"), ("ISCSI-MIB", "iscsiSsnErrorRecoveryLevel"), ("ISCSI-MIB", "iscsiSsnInitiatorAlias"), ("ISCSI-MIB", "iscsiSsnTargetAlias"), ("ISCSI-MIB", "iscsiSsnTSIH"), ("ISCSI-MIB", "iscsiSsnDataSequenceInOrder"), ("ISCSI-MIB", "iscsiSsnInitialR2T"), ("ISCSI-MIB", "iscsiSsnAuthIdentity"), ("ISCSI-MIB", "iscsiSsnMaxBurstLength"), )
if mibBuilder.loadTexts: iscsiSessionAttributesGroup.setDescription("A collection of objects providing information applicable to\nall sessions.")
iscsiSessionPDUStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 16)).setObjects(("ISCSI-MIB", "iscsiSsnCmdPDUs"), ("ISCSI-MIB", "iscsiSsnRspPDUs"), )
if mibBuilder.loadTexts: iscsiSessionPDUStatsGroup.setDescription("A collection of objects providing information about PDU\ntraffic for each session.")
iscsiSessionOctetStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 17)).setObjects(("ISCSI-MIB", "iscsiSsnTxDataOctets"), ("ISCSI-MIB", "iscsiSsnRxDataOctets"), )
if mibBuilder.loadTexts: iscsiSessionOctetStatsGroup.setDescription("A collection of objects providing information about octet\ntraffic for each session using a Counter64 data type.")
iscsiSessionLCOctetStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 18)).setObjects(("ISCSI-MIB", "iscsiSsnLCRxDataOctets"), ("ISCSI-MIB", "iscsiSsnLCTxDataOctets"), )
if mibBuilder.loadTexts: iscsiSessionLCOctetStatsGroup.setDescription("A collection of objects providing information about octet\ntraffic for each session using a Counter32 data type.")
iscsiSessionCxnErrorStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 19)).setObjects(("ISCSI-MIB", "iscsiSsnCxnDigestErrors"), ("ISCSI-MIB", "iscsiSsnCxnTimeoutErrors"), )
if mibBuilder.loadTexts: iscsiSessionCxnErrorStatsGroup.setDescription("A collection of objects providing information about connection\nerrors for all sessions.")
iscsiConnectionAttributesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 20)).setObjects(("ISCSI-MIB", "iscsiCxnAddrType"), ("ISCSI-MIB", "iscsiCxnLocalPort"), ("ISCSI-MIB", "iscsiCxnRemotePort"), ("ISCSI-MIB", "iscsiCxnRecvMarker"), ("ISCSI-MIB", "iscsiCxnSendMarker"), ("ISCSI-MIB", "iscsiCxnHeaderIntegrity"), ("ISCSI-MIB", "iscsiCxnDataIntegrity"), ("ISCSI-MIB", "iscsiCxnMaxRecvDataSegLength"), ("ISCSI-MIB", "iscsiCxnState"), ("ISCSI-MIB", "iscsiCxnProtocol"), ("ISCSI-MIB", "iscsiCxnLocalAddr"), ("ISCSI-MIB", "iscsiCxnCid"), ("ISCSI-MIB", "iscsiCxnVersionActive"), ("ISCSI-MIB", "iscsiCxnRemoteAddr"), ("ISCSI-MIB", "iscsiCxnMaxXmitDataSegLength"), )
if mibBuilder.loadTexts: iscsiConnectionAttributesGroup.setDescription("A collection of objects providing information about all\nconnections used by all sessions.")
iscsiTgtLgnNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 21)).setObjects(("ISCSI-MIB", "iscsiTgtLoginFailure"), )
if mibBuilder.loadTexts: iscsiTgtLgnNotificationsGroup.setDescription("A collection of notifications that indicate a login\nfailure from a remote initiator to a local target.")
iscsiIntrLgnNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 22)).setObjects(("ISCSI-MIB", "iscsiIntrLoginFailure"), )
if mibBuilder.loadTexts: iscsiIntrLgnNotificationsGroup.setDescription("A collection of notifications that indicate a login\nfailure from a local initiator to a remote target.")
iscsiSsnFlrNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 142, 2, 2, 23)).setObjects(("ISCSI-MIB", "iscsiInstSessionFailure"), )
if mibBuilder.loadTexts: iscsiSsnFlrNotificationsGroup.setDescription("A collection of notifications that indicate session\nfailures occurring after login.")

# Compliances

iscsiComplianceV1 = ModuleCompliance((1, 3, 6, 1, 2, 1, 142, 2, 1, 1)).setObjects(("ISCSI-MIB", "iscsiInstanceAttributesGroup"), ("ISCSI-MIB", "iscsiSessionLCOctetStatsGroup"), ("ISCSI-MIB", "iscsiNodeAttributesGroup"), ("ISCSI-MIB", "iscsiTargetLogoutStatsGroup"), ("ISCSI-MIB", "iscsiSessionPDUStatsGroup"), ("ISCSI-MIB", "iscsiSessionAttributesGroup"), ("ISCSI-MIB", "iscsiInitiatorLogoutStatsGroup"), ("ISCSI-MIB", "iscsiInitiatorAttributesGroup"), ("ISCSI-MIB", "iscsiSsnFlrNotificationsGroup"), ("ISCSI-MIB", "iscsiTgtPortalAttributesGroup"), ("ISCSI-MIB", "iscsiSessionCxnErrorStatsGroup"), ("ISCSI-MIB", "iscsiPortalAttributesGroup"), ("ISCSI-MIB", "iscsiInitiatorLoginStatsGroup"), ("ISCSI-MIB", "iscsiConnectionAttributesGroup"), ("ISCSI-MIB", "iscsiIntrLgnNotificationsGroup"), ("ISCSI-MIB", "iscsiInstanceSsnErrorStatsGroup"), ("ISCSI-MIB", "iscsiTgtLgnNotificationsGroup"), ("ISCSI-MIB", "iscsiSessionOctetStatsGroup"), ("ISCSI-MIB", "iscsiTargetAttributesGroup"), ("ISCSI-MIB", "iscsiTargetLoginStatsGroup"), ("ISCSI-MIB", "iscsiIntrPortalAttributesGroup"), ("ISCSI-MIB", "iscsiInitiatorAuthGroup"), ("ISCSI-MIB", "iscsiTargetAuthGroup"), )
if mibBuilder.loadTexts: iscsiComplianceV1.setDescription("Initial version of compliance statement based on\ninitial version of this MIB module.\n\nIf an implementation can be both a target and an\ninitiator, all groups are mandatory.")

# Exports

# Module identity
mibBuilder.exportSymbols("ISCSI-MIB", PYSNMP_MODULE_ID=iscsiMibModule)

# Types
mibBuilder.exportSymbols("ISCSI-MIB", IscsiDigestMethod=IscsiDigestMethod, IscsiName=IscsiName, IscsiTransportProtocol=IscsiTransportProtocol)

# Objects
mibBuilder.exportSymbols("ISCSI-MIB", iscsiMibModule=iscsiMibModule, iscsiNotifications=iscsiNotifications, iscsiObjects=iscsiObjects, iscsiInstance=iscsiInstance, iscsiInstanceAttributesTable=iscsiInstanceAttributesTable, iscsiInstanceAttributesEntry=iscsiInstanceAttributesEntry, iscsiInstIndex=iscsiInstIndex, iscsiInstDescr=iscsiInstDescr, iscsiInstVersionMin=iscsiInstVersionMin, iscsiInstVersionMax=iscsiInstVersionMax, iscsiInstVendorID=iscsiInstVendorID, iscsiInstVendorVersion=iscsiInstVendorVersion, iscsiInstPortalNumber=iscsiInstPortalNumber, iscsiInstNodeNumber=iscsiInstNodeNumber, iscsiInstSessionNumber=iscsiInstSessionNumber, iscsiInstSsnFailures=iscsiInstSsnFailures, iscsiInstLastSsnFailureType=iscsiInstLastSsnFailureType, iscsiInstLastSsnRmtNodeName=iscsiInstLastSsnRmtNodeName, iscsiInstDiscontinuityTime=iscsiInstDiscontinuityTime, iscsiInstanceSsnErrorStatsTable=iscsiInstanceSsnErrorStatsTable, iscsiInstanceSsnErrorStatsEntry=iscsiInstanceSsnErrorStatsEntry, iscsiInstSsnDigestErrors=iscsiInstSsnDigestErrors, iscsiInstSsnCxnTimeoutErrors=iscsiInstSsnCxnTimeoutErrors, iscsiInstSsnFormatErrors=iscsiInstSsnFormatErrors, iscsiPortal=iscsiPortal, iscsiPortalAttributesTable=iscsiPortalAttributesTable, iscsiPortalAttributesEntry=iscsiPortalAttributesEntry, iscsiPortalIndex=iscsiPortalIndex, iscsiPortalRowStatus=iscsiPortalRowStatus, iscsiPortalRoles=iscsiPortalRoles, iscsiPortalAddrType=iscsiPortalAddrType, iscsiPortalAddr=iscsiPortalAddr, iscsiPortalProtocol=iscsiPortalProtocol, iscsiPortalMaxRecvDataSegLength=iscsiPortalMaxRecvDataSegLength, iscsiPortalPrimaryHdrDigest=iscsiPortalPrimaryHdrDigest, iscsiPortalPrimaryDataDigest=iscsiPortalPrimaryDataDigest, iscsiPortalSecondaryHdrDigest=iscsiPortalSecondaryHdrDigest, iscsiPortalSecondaryDataDigest=iscsiPortalSecondaryDataDigest, iscsiPortalRecvMarker=iscsiPortalRecvMarker, iscsiPortalStorageType=iscsiPortalStorageType, iscsiTargetPortal=iscsiTargetPortal, iscsiTgtPortalAttributesTable=iscsiTgtPortalAttributesTable, iscsiTgtPortalAttributesEntry=iscsiTgtPortalAttributesEntry, iscsiTgtPortalNodeIndexOrZero=iscsiTgtPortalNodeIndexOrZero, iscsiTgtPortalPort=iscsiTgtPortalPort, iscsiTgtPortalTag=iscsiTgtPortalTag, iscsiInitiatorPortal=iscsiInitiatorPortal, iscsiIntrPortalAttributesTable=iscsiIntrPortalAttributesTable, iscsiIntrPortalAttributesEntry=iscsiIntrPortalAttributesEntry, iscsiIntrPortalNodeIndexOrZero=iscsiIntrPortalNodeIndexOrZero, iscsiIntrPortalTag=iscsiIntrPortalTag, iscsiNode=iscsiNode, iscsiNodeAttributesTable=iscsiNodeAttributesTable, iscsiNodeAttributesEntry=iscsiNodeAttributesEntry, iscsiNodeIndex=iscsiNodeIndex, iscsiNodeName=iscsiNodeName, iscsiNodeAlias=iscsiNodeAlias, iscsiNodeRoles=iscsiNodeRoles, iscsiNodeTransportType=iscsiNodeTransportType, iscsiNodeInitialR2T=iscsiNodeInitialR2T, iscsiNodeImmediateData=iscsiNodeImmediateData, iscsiNodeMaxOutstandingR2T=iscsiNodeMaxOutstandingR2T, iscsiNodeFirstBurstLength=iscsiNodeFirstBurstLength, iscsiNodeMaxBurstLength=iscsiNodeMaxBurstLength, iscsiNodeMaxConnections=iscsiNodeMaxConnections, iscsiNodeDataSequenceInOrder=iscsiNodeDataSequenceInOrder, iscsiNodeDataPDUInOrder=iscsiNodeDataPDUInOrder, iscsiNodeDefaultTime2Wait=iscsiNodeDefaultTime2Wait, iscsiNodeDefaultTime2Retain=iscsiNodeDefaultTime2Retain, iscsiNodeErrorRecoveryLevel=iscsiNodeErrorRecoveryLevel, iscsiNodeDiscontinuityTime=iscsiNodeDiscontinuityTime, iscsiNodeStorageType=iscsiNodeStorageType, iscsiTarget=iscsiTarget, iscsiTargetAttributesTable=iscsiTargetAttributesTable, iscsiTargetAttributesEntry=iscsiTargetAttributesEntry, iscsiTgtLoginFailures=iscsiTgtLoginFailures, iscsiTgtLastFailureTime=iscsiTgtLastFailureTime, iscsiTgtLastFailureType=iscsiTgtLastFailureType, iscsiTgtLastIntrFailureName=iscsiTgtLastIntrFailureName, iscsiTgtLastIntrFailureAddrType=iscsiTgtLastIntrFailureAddrType, iscsiTgtLastIntrFailureAddr=iscsiTgtLastIntrFailureAddr, iscsiTargetLoginStatsTable=iscsiTargetLoginStatsTable, iscsiTargetLoginStatsEntry=iscsiTargetLoginStatsEntry, iscsiTgtLoginAccepts=iscsiTgtLoginAccepts, iscsiTgtLoginOtherFails=iscsiTgtLoginOtherFails, iscsiTgtLoginRedirects=iscsiTgtLoginRedirects, iscsiTgtLoginAuthorizeFails=iscsiTgtLoginAuthorizeFails, iscsiTgtLoginAuthenticateFails=iscsiTgtLoginAuthenticateFails, iscsiTgtLoginNegotiateFails=iscsiTgtLoginNegotiateFails, iscsiTargetLogoutStatsTable=iscsiTargetLogoutStatsTable, iscsiTargetLogoutStatsEntry=iscsiTargetLogoutStatsEntry, iscsiTgtLogoutNormals=iscsiTgtLogoutNormals, iscsiTgtLogoutOthers=iscsiTgtLogoutOthers, iscsiTgtAuthorization=iscsiTgtAuthorization, iscsiTgtAuthAttributesTable=iscsiTgtAuthAttributesTable, iscsiTgtAuthAttributesEntry=iscsiTgtAuthAttributesEntry, iscsiTgtAuthIndex=iscsiTgtAuthIndex, iscsiTgtAuthRowStatus=iscsiTgtAuthRowStatus, iscsiTgtAuthIdentity=iscsiTgtAuthIdentity, iscsiTgtAuthStorageType=iscsiTgtAuthStorageType, iscsiInitiator=iscsiInitiator, iscsiInitiatorAttributesTable=iscsiInitiatorAttributesTable, iscsiInitiatorAttributesEntry=iscsiInitiatorAttributesEntry, iscsiIntrLoginFailures=iscsiIntrLoginFailures, iscsiIntrLastFailureTime=iscsiIntrLastFailureTime, iscsiIntrLastFailureType=iscsiIntrLastFailureType, iscsiIntrLastTgtFailureName=iscsiIntrLastTgtFailureName, iscsiIntrLastTgtFailureAddrType=iscsiIntrLastTgtFailureAddrType, iscsiIntrLastTgtFailureAddr=iscsiIntrLastTgtFailureAddr, iscsiInitiatorLoginStatsTable=iscsiInitiatorLoginStatsTable, iscsiInitiatorLoginStatsEntry=iscsiInitiatorLoginStatsEntry, iscsiIntrLoginAcceptRsps=iscsiIntrLoginAcceptRsps, iscsiIntrLoginOtherFailRsps=iscsiIntrLoginOtherFailRsps, iscsiIntrLoginRedirectRsps=iscsiIntrLoginRedirectRsps, iscsiIntrLoginAuthFailRsps=iscsiIntrLoginAuthFailRsps, iscsiIntrLoginAuthenticateFails=iscsiIntrLoginAuthenticateFails, iscsiIntrLoginNegotiateFails=iscsiIntrLoginNegotiateFails, iscsiInitiatorLogoutStatsTable=iscsiInitiatorLogoutStatsTable, iscsiInitiatorLogoutStatsEntry=iscsiInitiatorLogoutStatsEntry, iscsiIntrLogoutNormals=iscsiIntrLogoutNormals, iscsiIntrLogoutOthers=iscsiIntrLogoutOthers, iscsiIntrAuthorization=iscsiIntrAuthorization, iscsiIntrAuthAttributesTable=iscsiIntrAuthAttributesTable, iscsiIntrAuthAttributesEntry=iscsiIntrAuthAttributesEntry, iscsiIntrAuthIndex=iscsiIntrAuthIndex, iscsiIntrAuthRowStatus=iscsiIntrAuthRowStatus)
mibBuilder.exportSymbols("ISCSI-MIB", iscsiIntrAuthIdentity=iscsiIntrAuthIdentity, iscsiIntrAuthStorageType=iscsiIntrAuthStorageType, iscsiSession=iscsiSession, iscsiSessionAttributesTable=iscsiSessionAttributesTable, iscsiSessionAttributesEntry=iscsiSessionAttributesEntry, iscsiSsnNodeIndex=iscsiSsnNodeIndex, iscsiSsnIndex=iscsiSsnIndex, iscsiSsnDirection=iscsiSsnDirection, iscsiSsnInitiatorName=iscsiSsnInitiatorName, iscsiSsnTargetName=iscsiSsnTargetName, iscsiSsnTSIH=iscsiSsnTSIH, iscsiSsnISID=iscsiSsnISID, iscsiSsnInitiatorAlias=iscsiSsnInitiatorAlias, iscsiSsnTargetAlias=iscsiSsnTargetAlias, iscsiSsnInitialR2T=iscsiSsnInitialR2T, iscsiSsnImmediateData=iscsiSsnImmediateData, iscsiSsnType=iscsiSsnType, iscsiSsnMaxOutstandingR2T=iscsiSsnMaxOutstandingR2T, iscsiSsnFirstBurstLength=iscsiSsnFirstBurstLength, iscsiSsnMaxBurstLength=iscsiSsnMaxBurstLength, iscsiSsnConnectionNumber=iscsiSsnConnectionNumber, iscsiSsnAuthIdentity=iscsiSsnAuthIdentity, iscsiSsnDataSequenceInOrder=iscsiSsnDataSequenceInOrder, iscsiSsnDataPDUInOrder=iscsiSsnDataPDUInOrder, iscsiSsnErrorRecoveryLevel=iscsiSsnErrorRecoveryLevel, iscsiSsnDiscontinuityTime=iscsiSsnDiscontinuityTime, iscsiSessionStatsTable=iscsiSessionStatsTable, iscsiSessionStatsEntry=iscsiSessionStatsEntry, iscsiSsnCmdPDUs=iscsiSsnCmdPDUs, iscsiSsnRspPDUs=iscsiSsnRspPDUs, iscsiSsnTxDataOctets=iscsiSsnTxDataOctets, iscsiSsnRxDataOctets=iscsiSsnRxDataOctets, iscsiSsnLCTxDataOctets=iscsiSsnLCTxDataOctets, iscsiSsnLCRxDataOctets=iscsiSsnLCRxDataOctets, iscsiSessionCxnErrorStatsTable=iscsiSessionCxnErrorStatsTable, iscsiSessionCxnErrorStatsEntry=iscsiSessionCxnErrorStatsEntry, iscsiSsnCxnDigestErrors=iscsiSsnCxnDigestErrors, iscsiSsnCxnTimeoutErrors=iscsiSsnCxnTimeoutErrors, iscsiConnection=iscsiConnection, iscsiConnectionAttributesTable=iscsiConnectionAttributesTable, iscsiConnectionAttributesEntry=iscsiConnectionAttributesEntry, iscsiCxnIndex=iscsiCxnIndex, iscsiCxnCid=iscsiCxnCid, iscsiCxnState=iscsiCxnState, iscsiCxnAddrType=iscsiCxnAddrType, iscsiCxnLocalAddr=iscsiCxnLocalAddr, iscsiCxnProtocol=iscsiCxnProtocol, iscsiCxnLocalPort=iscsiCxnLocalPort, iscsiCxnRemoteAddr=iscsiCxnRemoteAddr, iscsiCxnRemotePort=iscsiCxnRemotePort, iscsiCxnMaxRecvDataSegLength=iscsiCxnMaxRecvDataSegLength, iscsiCxnMaxXmitDataSegLength=iscsiCxnMaxXmitDataSegLength, iscsiCxnHeaderIntegrity=iscsiCxnHeaderIntegrity, iscsiCxnDataIntegrity=iscsiCxnDataIntegrity, iscsiCxnRecvMarker=iscsiCxnRecvMarker, iscsiCxnSendMarker=iscsiCxnSendMarker, iscsiCxnVersionActive=iscsiCxnVersionActive, iscsiConformance=iscsiConformance, iscsiCompliances=iscsiCompliances, iscsiGroups=iscsiGroups, iscsiAdmin=iscsiAdmin, iscsiDescriptors=iscsiDescriptors, iscsiHeaderIntegrityTypes=iscsiHeaderIntegrityTypes, iscsiHdrIntegrityNone=iscsiHdrIntegrityNone, iscsiHdrIntegrityCrc32c=iscsiHdrIntegrityCrc32c, iscsiDataIntegrityTypes=iscsiDataIntegrityTypes, iscsiDataIntegrityNone=iscsiDataIntegrityNone, iscsiDataIntegrityCrc32c=iscsiDataIntegrityCrc32c)

# Notifications
mibBuilder.exportSymbols("ISCSI-MIB", iscsiTgtLoginFailure=iscsiTgtLoginFailure, iscsiIntrLoginFailure=iscsiIntrLoginFailure, iscsiInstSessionFailure=iscsiInstSessionFailure)

# Groups
mibBuilder.exportSymbols("ISCSI-MIB", iscsiInstanceAttributesGroup=iscsiInstanceAttributesGroup, iscsiInstanceSsnErrorStatsGroup=iscsiInstanceSsnErrorStatsGroup, iscsiPortalAttributesGroup=iscsiPortalAttributesGroup, iscsiTgtPortalAttributesGroup=iscsiTgtPortalAttributesGroup, iscsiIntrPortalAttributesGroup=iscsiIntrPortalAttributesGroup, iscsiNodeAttributesGroup=iscsiNodeAttributesGroup, iscsiTargetAttributesGroup=iscsiTargetAttributesGroup, iscsiTargetLoginStatsGroup=iscsiTargetLoginStatsGroup, iscsiTargetLogoutStatsGroup=iscsiTargetLogoutStatsGroup, iscsiTargetAuthGroup=iscsiTargetAuthGroup, iscsiInitiatorAttributesGroup=iscsiInitiatorAttributesGroup, iscsiInitiatorLoginStatsGroup=iscsiInitiatorLoginStatsGroup, iscsiInitiatorLogoutStatsGroup=iscsiInitiatorLogoutStatsGroup, iscsiInitiatorAuthGroup=iscsiInitiatorAuthGroup, iscsiSessionAttributesGroup=iscsiSessionAttributesGroup, iscsiSessionPDUStatsGroup=iscsiSessionPDUStatsGroup, iscsiSessionOctetStatsGroup=iscsiSessionOctetStatsGroup, iscsiSessionLCOctetStatsGroup=iscsiSessionLCOctetStatsGroup, iscsiSessionCxnErrorStatsGroup=iscsiSessionCxnErrorStatsGroup, iscsiConnectionAttributesGroup=iscsiConnectionAttributesGroup, iscsiTgtLgnNotificationsGroup=iscsiTgtLgnNotificationsGroup, iscsiIntrLgnNotificationsGroup=iscsiIntrLgnNotificationsGroup, iscsiSsnFlrNotificationsGroup=iscsiSsnFlrNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("ISCSI-MIB", iscsiComplianceV1=iscsiComplianceV1)
