# PySNMP SMI module. Autogenerated from smidump -f python PIM-STD-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:59 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAipRouteProtocol, ) = mibBuilder.importSymbols("IANA-RTPROTO-MIB", "IANAipRouteProtocol")
( InterfaceIndex, InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "InterfaceIndexOrZero")
( InetAddress, InetAddressPrefixLength, InetAddressType, InetVersion, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressPrefixLength", "InetAddressType", "InetVersion")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TruthValue")

# Types

class PimGroupMappingOriginType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(5,2,4,6,3,7,1,)
    namedValues = namedval.NamedValues(("fixed", 1), ("configRp", 2), ("configSsm", 3), ("bsr", 4), ("autoRP", 5), ("embedded", 6), ("other", 7), )
    
class PimMode(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,5,4,6,3,)
    namedValues = namedval.NamedValues(("none", 1), ("ssm", 2), ("asm", 3), ("bidir", 4), ("dm", 5), ("other", 6), )
    

# Objects

pimStdMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 157)).setRevisions(("2007-11-02 00:00",))
if mibBuilder.loadTexts: pimStdMIB.setOrganization("IETF Protocol Independent Multicast (PIM) Working Group")
if mibBuilder.loadTexts: pimStdMIB.setContactInfo("Email: pim@ietf.org\nWG charter:\n\n\n\n\nhttp://www.ietf.org/html.charters/pim-charter.html")
if mibBuilder.loadTexts: pimStdMIB.setDescription("The MIB module for management of PIM routers.\n\nCopyright (C) The IETF Trust (2007).  This version of this\nMIB module is part of RFC 5060; see the RFC itself for full\nlegal notices.")
pimNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 157, 0))
pim = MibIdentifier((1, 3, 6, 1, 2, 1, 157, 1))
pimInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 1))
if mibBuilder.loadTexts: pimInterfaceTable.setDescription("The (conceptual) table listing the router's PIM interfaces.\nPIM is enabled on all interfaces listed in this table.")
pimInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 1, 1)).setIndexNames((0, "PIM-STD-MIB", "pimInterfaceIfIndex"), (0, "PIM-STD-MIB", "pimInterfaceIPVersion"))
if mibBuilder.loadTexts: pimInterfaceEntry.setDescription("An entry (conceptual row) in the pimInterfaceTable.  This\nentry is preserved on agent restart.")
pimInterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimInterfaceIfIndex.setDescription("The ifIndex value of this PIM interface.")
pimInterfaceIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 2), InetVersion()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimInterfaceIPVersion.setDescription("The IP version of this PIM interface.  A physical interface\nmay be configured in multiple modes concurrently, e.g., IPv4\nand IPv6; however, the traffic is considered to be logically\nseparate.")
pimInterfaceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 3), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceAddressType.setDescription("The address type of this PIM interface.")
pimInterfaceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 4), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceAddress.setDescription("The primary IP address of this router on this PIM\ninterface.  The InetAddressType is given by the\npimInterfaceAddressType object.")
pimInterfaceGenerationIDValue = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceGenerationIDValue.setDescription("The value of the Generation ID this router inserted in the\nlast PIM Hello message it sent on this interface.")
pimInterfaceDR = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 6), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceDR.setDescription("The primary IP address of the Designated Router on this PIM\ninterface.  The InetAddressType is given by the\npimInterfaceAddressType object.")
pimInterfaceDRPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 7), Unsigned32().clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceDRPriority.setDescription("The Designated Router Priority value inserted into the DR\n\n\n\nPriority option in PIM Hello messages transmitted on this\ninterface.  Numerically higher values for this object\nindicate higher priorities.")
pimInterfaceDRPriorityEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceDRPriorityEnabled.setDescription("Evaluates to TRUE if all routers on this interface are\nusing the DR Priority option.")
pimInterfaceHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 18000)).clone(30)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceHelloInterval.setDescription("The frequency at which PIM Hello messages are transmitted\non this interface.  This object corresponds to the\n'Hello_Period' timer value defined in the PIM-SM\nspecification.  A value of zero represents an 'infinite'\ninterval, and indicates that periodic PIM Hello messages\nshould not be sent on this interface.")
pimInterfaceTrigHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 60)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceTrigHelloInterval.setDescription("The maximum time before this router sends a triggered PIM\nHello message on this interface.  This object corresponds to\nthe 'Trigered_Hello_Delay' timer value defined in the PIM-SM\nspecification.  A value of zero has no special meaning and\nindicates that triggered PIM Hello messages should always be\nsent immediately.")
pimInterfaceHelloHoldtime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(105)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceHelloHoldtime.setDescription("The value set in the Holdtime field of PIM Hello messages\ntransmitted on this interface.  A value of 65535 represents\nan 'infinite' holdtime.  Implementations are recommended\nto use a holdtime that is 3.5 times the value of\npimInterfaceHelloInterval, or 65535 if\npimInterfaceHelloInterval is set to zero.")
pimInterfaceJoinPruneInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 18000)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceJoinPruneInterval.setDescription("The frequency at which this router sends PIM Join/Prune\nmessages on this PIM interface.  This object corresponds to\nthe 't_periodic' timer value defined in the PIM-SM\nspecification.  A value of zero represents an 'infinite'\ninterval, and indicates that periodic PIM Join/Prune\nmessages should not be sent on this interface.")
pimInterfaceJoinPruneHoldtime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(210)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceJoinPruneHoldtime.setDescription("The value inserted into the Holdtime field of a PIM\nJoin/Prune message sent on this interface.  A value of 65535\nrepresents an 'infinite' holdtime.  Implementations are\nrecommended to use a holdtime that is 3.5 times the value of\npimInterfaceJoinPruneInterval, or 65535 if\npimInterfaceJoinPruneInterval is set to zero.  PIM-DM\nimplementations are recommended to use the value of\npimInterfacePruneLimitInterval.")
pimInterfaceDFElectionRobustness = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 14), Unsigned32().clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceDFElectionRobustness.setDescription("The minimum number of PIM DF-Election messages that must be\nlost in order for DF election on this interface to fail.")
pimInterfaceLanDelayEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceLanDelayEnabled.setDescription("Evaluates to TRUE if all routers on this interface are\nusing the LAN Prune Delay option.")
pimInterfacePropagationDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 16), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767)).clone(500)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfacePropagationDelay.setDescription("The expected propagation delay between PIM routers on this\nnetwork or link.\n\nThis router inserts this value into the Propagation_Delay\nfield of the LAN Prune Delay option in the PIM Hello\nmessages sent on this interface.  Implementations SHOULD\nenforce a lower bound on the permitted values for this\nobject to allow for scheduling and processing delays within\nthe local router.")
pimInterfaceOverrideInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 17), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(2500)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceOverrideInterval.setDescription("The value this router inserts into the Override_Interval\nfield of the LAN Prune Delay option in the PIM Hello\n\n\n\nmessages it sends on this interface.\n\nWhen overriding a prune, PIM routers pick a random timer\nduration up to the value of this object.  The more PIM\nrouters that are active on a network, the more likely it is\nthat the prune will be overridden after a small proportion\nof this time has elapsed.\n\nThe more PIM routers are active on this network, the larger\nthis object should be to obtain an optimal spread of prune\noverride latencies.")
pimInterfaceEffectPropagDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 18), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceEffectPropagDelay.setDescription("The Effective Propagation Delay on this interface.  This\nobject is always 500 if pimInterfaceLanDelayEnabled is\nFALSE.")
pimInterfaceEffectOverrideIvl = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 19), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceEffectOverrideIvl.setDescription("The Effective Override Interval on this interface.  This\nobject is always 2500 if pimInterfaceLanDelayEnabled is\nFALSE.")
pimInterfaceSuppressionEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 20), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceSuppressionEnabled.setDescription("Whether join suppression is enabled on this interface.\nThis object is always TRUE if pimInterfaceLanDelayEnabled is\nFALSE.")
pimInterfaceBidirCapable = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 21), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceBidirCapable.setDescription("Evaluates to TRUE if all routers on this interface are\nusing the Bidirectional-PIM Capable option.")
pimInterfaceDomainBorder = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 22), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceDomainBorder.setDescription("Whether or not this interface is a PIM domain border.  This\nincludes acting as a border for PIM Bootstrap Router (BSR)\nmessages, if the BSR mechanism is in use.")
pimInterfaceStubInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 23), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceStubInterface.setDescription("Whether this interface is a 'stub interface'.  If this\nobject is set to TRUE, then no PIM packets are sent out this\ninterface, and any received PIM packets are ignored.\n\nSetting this object to TRUE is a security measure for\ninterfaces towards untrusted hosts.  This allows an\ninterface to be configured for use with IGMP (Internet Group\nManagement Protocol) or MLD (Multicast Listener Discovery)\nonly, which protects the PIM router from forged PIM messages\non the interface.\n\nTo communicate with other PIM routers using this interface,\nthis object must remain set to FALSE.\n\nChanging the value of this object while the interface is\noperational causes PIM to be disabled and then re-enabled on\nthis interface.")
pimInterfacePruneLimitInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 24), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfacePruneLimitInterval.setDescription("The minimum interval that must transpire between two\nsuccessive Prunes sent by a router.  This object corresponds\nto the 't_limit' timer value defined in the PIM-DM\nspecification.  This object is used only by PIM-DM.")
pimInterfaceGraftRetryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 25), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceGraftRetryInterval.setDescription("The minimum interval that must transpire between two\nsuccessive Grafts sent by a router.  This object corresponds\nto the 'Graft_Retry_Period' timer value defined in the\nPIM-DM specification.  This object is used only by PIM-DM.")
pimInterfaceSRPriorityEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 26), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceSRPriorityEnabled.setDescription("Evaluates to TRUE if all routers on this interface are\nusing the State Refresh option.  This object is used only by\nPIM-DM.")
pimInterfaceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 27), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceStatus.setDescription("The status of this entry.  Creating the entry enables PIM\non the interface; destroying the entry disables PIM on the\ninterface.\n\nThis status object can be set to active(1) without setting\n\n\n\nany other columnar objects in this entry.\n\nAll writeable objects in this entry can be modified when the\nstatus of this entry is active(1).")
pimInterfaceStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 1, 1, 28), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimInterfaceStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
pimNeighborTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 2))
if mibBuilder.loadTexts: pimNeighborTable.setDescription("The (conceptual) table listing the router's PIM neighbors.")
pimNeighborEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 2, 1)).setIndexNames((0, "PIM-STD-MIB", "pimNeighborIfIndex"), (0, "PIM-STD-MIB", "pimNeighborAddressType"), (0, "PIM-STD-MIB", "pimNeighborAddress"))
if mibBuilder.loadTexts: pimNeighborEntry.setDescription("An entry (conceptual row) in the pimNeighborTable.")
pimNeighborIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimNeighborIfIndex.setDescription("The value of ifIndex for the interface used to reach this\nPIM neighbor.")
pimNeighborAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 2), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimNeighborAddressType.setDescription("The address type of this PIM neighbor.")
pimNeighborAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 3), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimNeighborAddress.setDescription("The primary IP address of this PIM neighbor.  The\nInetAddressType is given by the pimNeighborAddressType\nobject.")
pimNeighborGenerationIDPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborGenerationIDPresent.setDescription("Evaluates to TRUE if this neighbor is using the Generation\nID option.")
pimNeighborGenerationIDValue = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborGenerationIDValue.setDescription("The value of the Generation ID from the last PIM Hello\nmessage received from this neighbor.  This object is always\nzero if pimNeighborGenerationIDPresent is FALSE.")
pimNeighborUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborUpTime.setDescription("The time since this PIM neighbor (last) became a neighbor\nof the local router.")
pimNeighborExpiryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 7), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborExpiryTime.setDescription("The minimum time remaining before this PIM neighbor will\ntime out.  The value zero indicates that this PIM neighbor\nwill never time out.")
pimNeighborDRPriorityPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborDRPriorityPresent.setDescription("Evaluates to TRUE if this neighbor is using the DR Priority\noption.")
pimNeighborDRPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborDRPriority.setDescription("The value of the Designated Router Priority from the last\nPIM Hello message received from this neighbor.  This object\nis always zero if pimNeighborDRPriorityPresent is FALSE.")
pimNeighborLanPruneDelayPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborLanPruneDelayPresent.setDescription("Evaluates to TRUE if this neighbor is using the LAN Prune\nDelay option.")
pimNeighborTBit = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborTBit.setDescription("Whether the T bit was set in the LAN Prune Delay option\nreceived from this neighbor.  The T bit specifies the\nability of the neighbor to disable join suppression.  This\nobject is always TRUE if pimNeighborLanPruneDelayPresent is\nFALSE.")
pimNeighborPropagationDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32767))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborPropagationDelay.setDescription("The value of the Propagation_Delay field of the LAN Prune\nDelay option received from this neighbor.  This object is\nalways zero if pimNeighborLanPruneDelayPresent is FALSE.")
pimNeighborOverrideInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborOverrideInterval.setDescription("The value of the Override_Interval field of the LAN Prune\nDelay option received from this neighbor.  This object is\nalways zero if pimNeighborLanPruneDelayPresent is FALSE.")
pimNeighborBidirCapable = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 14), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborBidirCapable.setDescription("Evaluates to TRUE if this neighbor is using the\nBidirectional-PIM Capable option.")
pimNeighborSRCapable = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 2, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborSRCapable.setDescription("Evaluates to TRUE if this neighbor is using the State\nRefresh Capable option.  This object is used only by\nPIM-DM.")
pimNbrSecAddressTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 3))
if mibBuilder.loadTexts: pimNbrSecAddressTable.setDescription("The (conceptual) table listing the secondary addresses\nadvertised by each PIM neighbor (on a subset of the rows of\nthe pimNeighborTable defined above).")
pimNbrSecAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 3, 1)).setIndexNames((0, "PIM-STD-MIB", "pimNbrSecAddressIfIndex"), (0, "PIM-STD-MIB", "pimNbrSecAddressType"), (0, "PIM-STD-MIB", "pimNbrSecAddressPrimary"), (0, "PIM-STD-MIB", "pimNbrSecAddress"))
if mibBuilder.loadTexts: pimNbrSecAddressEntry.setDescription("An entry (conceptual row) in the pimNbrSecAddressTable.")
pimNbrSecAddressIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 3, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimNbrSecAddressIfIndex.setDescription("The value of ifIndex for the interface used to reach this\nPIM neighbor.")
pimNbrSecAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 3, 1, 2), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimNbrSecAddressType.setDescription("The address type of this PIM neighbor.")
pimNbrSecAddressPrimary = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 3, 1, 3), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimNbrSecAddressPrimary.setDescription("The primary IP address of this PIM neighbor.  The\nInetAddressType is given by the pimNbrSecAddressType\nobject.")
pimNbrSecAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 3, 1, 4), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNbrSecAddress.setDescription("The secondary IP address of this PIM neighbor.  The\nInetAddressType is given by the pimNbrSecAddressType\nobject.")
pimStarGTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 4))
if mibBuilder.loadTexts: pimStarGTable.setDescription("The (conceptual) table listing the non-interface specific\n(*,G) state that PIM has.")
pimStarGEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 4, 1)).setIndexNames((0, "PIM-STD-MIB", "pimStarGAddressType"), (0, "PIM-STD-MIB", "pimStarGGrpAddress"))
if mibBuilder.loadTexts: pimStarGEntry.setDescription("An entry (conceptual row) in the pimStarGTable.")
pimStarGAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimStarGAddressType.setDescription("The address type of this multicast group.")
pimStarGGrpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimStarGGrpAddress.setDescription("The multicast group address.  The InetAddressType is given\nby the pimStarGAddressType object.")
pimStarGUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGUpTime.setDescription("The time since this entry was created by the local router.")
pimStarGPimMode = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,)).subtype(namedValues=namedval.NamedValues(("asm", 3), ("bidir", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGPimMode.setDescription("Whether this entry represents an ASM (Any Source Multicast,\nused with PIM-SM) or BIDIR-PIM group.")
pimStarGRPAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPAddressType.setDescription("The address type of the Rendezvous Point (RP), or\nunknown(0) if the RP address is unknown.")
pimStarGRPAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 6), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPAddress.setDescription("The address of the Rendezvous Point (RP) for the group.\nThe InetAddressType is given by the pimStarGRPAddressType.")
pimStarGPimModeOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 7), PimGroupMappingOriginType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGPimModeOrigin.setDescription("The mechanism by which the PIM mode and RP for the group\nwere learned.")
pimStarGRPIsLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPIsLocal.setDescription("Whether the local router is the RP for the group.")
pimStarGUpstreamJoinState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("notJoined", 1), ("joined", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGUpstreamJoinState.setDescription("Whether the local router should join the RP tree for the\ngroup.  This corresponds to the state of the upstream (*,G)\nstate machine in the PIM-SM specification.")
pimStarGUpstreamJoinTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 10), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGUpstreamJoinTimer.setDescription("The time remaining before the local router next sends a\nperiodic (*,G) Join message on pimStarGRPFIfIndex.  This\ntimer is called the (*,G) Upstream Join Timer in the PIM-SM\nspecification.  This object is zero if the timer is not\nrunning.")
pimStarGUpstreamNeighborType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 11), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGUpstreamNeighborType.setDescription("The primary address type of the upstream neighbor, or\n\n\n\nunknown(0) if the upstream neighbor address is unknown or is\nnot a PIM neighbor.")
pimStarGUpstreamNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 12), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGUpstreamNeighbor.setDescription("The primary address of the neighbor on pimStarGRPFIfIndex\nthat the local router is sending periodic (*,G) Join\nmessages to.  The InetAddressType is given by the\npimStarGUpstreamNeighborType object.  This address is called\nRPF'(*,G) in the PIM-SM specification.")
pimStarGRPFIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 13), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFIfIndex.setDescription("The value of ifIndex for the Reverse Path Forwarding\n(RPF) interface towards the RP, or zero if the RPF\ninterface is unknown.")
pimStarGRPFNextHopType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 14), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFNextHopType.setDescription("The address type of the RPF next hop towards the RP, or\nunknown(0) if the RPF next hop is unknown.")
pimStarGRPFNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 15), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFNextHop.setDescription("The address of the RPF next hop towards the RP.  The\nInetAddressType is given by the pimStarGRPFNextHopType\nobject.  This address is called MRIB.next_hop(RP(G))\nin the PIM-SM specification.")
pimStarGRPFRouteProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 16), IANAipRouteProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFRouteProtocol.setDescription("The routing mechanism via which the route used to find the\nRPF interface towards the RP was learned.")
pimStarGRPFRouteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 17), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFRouteAddress.setDescription("The IP address that, when combined with the corresponding\nvalue of pimStarGRPFRoutePrefixLength, identifies the route\nused to find the RPF interface towards the RP.  The\nInetAddressType is given by the pimStarGRPFNextHopType\nobject.\n\nThis address object is only significant up to\npimStarGRPFRoutePrefixLength bits.  The remainder of the\naddress bits are zero.")
pimStarGRPFRoutePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 18), InetAddressPrefixLength()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFRoutePrefixLength.setDescription("The prefix length that, when combined with the\ncorresponding value of pimStarGRPFRouteAddress, identifies\nthe route used to find the RPF interface towards the RP.\nThe InetAddressType is given by the pimStarGRPFNextHopType\nobject.")
pimStarGRPFRouteMetricPref = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 19), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFRouteMetricPref.setDescription("The metric preference of the route used to find the RPF\ninterface towards the RP.")
pimStarGRPFRouteMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 4, 1, 20), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGRPFRouteMetric.setDescription("The routing metric of the route used to find the RPF\ninterface towards the RP.")
pimStarGITable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 5))
if mibBuilder.loadTexts: pimStarGITable.setDescription("The (conceptual) table listing the interface-specific (*,G)\nstate that PIM has.")
pimStarGIEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 5, 1)).setIndexNames((0, "PIM-STD-MIB", "pimStarGAddressType"), (0, "PIM-STD-MIB", "pimStarGGrpAddress"), (0, "PIM-STD-MIB", "pimStarGIIfIndex"))
if mibBuilder.loadTexts: pimStarGIEntry.setDescription("An entry (conceptual row) in the pimStarGITable.")
pimStarGIIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimStarGIIfIndex.setDescription("The ifIndex of the interface that this entry corresponds\nto.")
pimStarGIUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIUpTime.setDescription("The time since this entry was created by the local router.")
pimStarGILocalMembership = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGILocalMembership.setDescription("Whether the local router has (*,G) local membership on this\ninterface (resulting from a mechanism such as IGMP or MLD).\nThis corresponds to local_receiver_include(*,G,I) in the\nPIM-SM specification.")
pimStarGIJoinPruneState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("noInfo", 1), ("join", 2), ("prunePending", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIJoinPruneState.setDescription("The state resulting from (*,G) Join/Prune messages\nreceived on this interface.  This corresponds to the state\nof the downstream per-interface (*,G) state machine in the\nPIM-SM specification.")
pimStarGIPrunePendingTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIPrunePendingTimer.setDescription("The time remaining before the local router acts on a (*,G)\nPrune message received on this interface, during which the\nrouter is waiting to see whether another downstream router\nwill override the Prune message.  This timer is called the\n(*,G) Prune-Pending Timer in the PIM-SM specification.  This\nobject is zero if the timer is not running.")
pimStarGIJoinExpiryTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIJoinExpiryTimer.setDescription("The time remaining before (*,G) Join state for this\ninterface expires.  This timer is called the (*,G) Join\nExpiry Timer in the PIM-SM specification.  This object is\nzero if the timer is not running.  A value of 'FFFFFFFF'h\nindicates an infinite expiry time.")
pimStarGIAssertState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("noInfo", 1), ("iAmAssertWinner", 2), ("iAmAssertLoser", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIAssertState.setDescription("The (*,G) Assert state for this interface.  This\ncorresponds to the state of the per-interface (*,G) Assert\nstate machine in the PIM-SM specification.  If\npimStarGPimMode is 'bidir', this object must be 'noInfo'.")
pimStarGIAssertTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIAssertTimer.setDescription("If pimStarGIAssertState is 'iAmAssertWinner', this is the\ntime remaining before the local router next sends a (*,G)\nAssert message on this interface.  If pimStarGIAssertState\nis 'iAmAssertLoser', this is the time remaining before the\n\n\n\n(*,G) Assert state expires.  If pimStarGIAssertState is\n'noInfo', this is zero.  This timer is called the (*,G)\nAssert Timer in the PIM-SM specification.")
pimStarGIAssertWinnerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 9), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIAssertWinnerAddressType.setDescription("If pimStarGIAssertState is 'iAmAssertLoser', this is the\naddress type of the assert winner; otherwise, this object is\nunknown(0).")
pimStarGIAssertWinnerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 10), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIAssertWinnerAddress.setDescription("If pimStarGIAssertState is 'iAmAssertLoser', this is the\naddress of the assert winner.  The InetAddressType is given\nby the pimStarGIAssertWinnerAddressType object.")
pimStarGIAssertWinnerMetricPref = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIAssertWinnerMetricPref.setDescription("If pimStarGIAssertState is 'iAmAssertLoser', this is the\nmetric preference of the route to the RP advertised by the\nassert winner; otherwise, this object is zero.")
pimStarGIAssertWinnerMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 5, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIAssertWinnerMetric.setDescription("If pimStarGIAssertState is 'iAmAssertLoser', this is the\nrouting metric of the route to the RP advertised by the\nassert winner; otherwise, this object is zero.")
pimSGTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 6))
if mibBuilder.loadTexts: pimSGTable.setDescription("The (conceptual) table listing the non-interface specific\n(S,G) state that PIM has.")
pimSGEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 6, 1)).setIndexNames((0, "PIM-STD-MIB", "pimSGAddressType"), (0, "PIM-STD-MIB", "pimSGGrpAddress"), (0, "PIM-STD-MIB", "pimSGSrcAddress"))
if mibBuilder.loadTexts: pimSGEntry.setDescription("An entry (conceptual row) in the pimSGTable.")
pimSGAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimSGAddressType.setDescription("The address type of the source and multicast group for this\nentry.")
pimSGGrpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimSGGrpAddress.setDescription("The multicast group address for this entry.  The\nInetAddressType is given by the pimSGAddressType object.")
pimSGSrcAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 3), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimSGSrcAddress.setDescription("The source address for this entry.  The InetAddressType is\ngiven by the pimSGAddressType object.")
pimSGUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGUpTime.setDescription("The time since this entry was created by the local router.")
pimSGPimMode = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,)).subtype(namedValues=namedval.NamedValues(("ssm", 2), ("asm", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGPimMode.setDescription("Whether pimSGGrpAddress is an SSM (Source Specific\nMulticast, used with PIM-SM) or ASM (Any Source Multicast,\nused with PIM-SM) group.")
pimSGUpstreamJoinState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("notJoined", 1), ("joined", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGUpstreamJoinState.setDescription("Whether the local router should join the shortest-path tree\nfor the source and group represented by this entry.  This\ncorresponds to the state of the upstream (S,G) state machine\nin the PIM-SM specification.")
pimSGUpstreamJoinTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 7), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGUpstreamJoinTimer.setDescription("The time remaining before the local router next sends a\nperiodic (S,G) Join message on pimSGRPFIfIndex.  This timer\nis called the (S,G) Upstream Join Timer in the PIM-SM\nspecification.  This object is zero if the timer is not\nrunning.")
pimSGUpstreamNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 8), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGUpstreamNeighbor.setDescription("The primary address of the neighbor on pimSGRPFIfIndex that\nthe local router is sending periodic (S,G) Join messages to.\nThis is zero if the RPF next hop is unknown or is not a\nPIM neighbor.  The InetAddressType is given by the\npimSGAddressType object.  This address is called RPF'(S,G)\nin the PIM-SM specification.")
pimSGRPFIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 9), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFIfIndex.setDescription("The value of ifIndex for the RPF interface towards the\nsource, or zero if the RPF interface is unknown.")
pimSGRPFNextHopType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 10), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFNextHopType.setDescription("The address type of the RPF next hop towards the source, or\nunknown(0) if the RPF next hop is unknown.")
pimSGRPFNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 11), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFNextHop.setDescription("The address of the RPF next hop towards the source.  The\nInetAddressType is given by the pimSGRPFNextHopType.  This\naddress is called MRIB.next_hop(S) in the PIM-SM\nspecification.")
pimSGRPFRouteProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 12), IANAipRouteProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFRouteProtocol.setDescription("The routing mechanism via which the route used to find the\nRPF interface towards the source was learned.")
pimSGRPFRouteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 13), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFRouteAddress.setDescription("The IP address that, when combined with the corresponding\nvalue of pimSGRPFRoutePrefixLength, identifies the route\nused to find the RPF interface towards the source.  The\nInetAddressType is given by the pimSGRPFNextHopType object.\n\nThis address object is only significant up to\n\n\n\npimSGRPFRoutePrefixLength bits.  The remainder of the\naddress bits are zero.")
pimSGRPFRoutePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 14), InetAddressPrefixLength()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFRoutePrefixLength.setDescription("The prefix length that, when combined with the\ncorresponding value of pimSGRPFRouteAddress, identifies the\nroute used to find the RPF interface towards the source.\nThe InetAddressType is given by the pimSGRPFNextHopType\nobject.")
pimSGRPFRouteMetricPref = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 15), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFRouteMetricPref.setDescription("The metric preference of the route used to find the RPF\ninterface towards the source.")
pimSGRPFRouteMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 16), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPFRouteMetric.setDescription("The routing metric of the route used to find the RPF\ninterface towards the source.")
pimSGSPTBit = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 17), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGSPTBit.setDescription("Whether the SPT bit is set; and therefore whether\nforwarding is taking place on the shortest-path tree.")
pimSGKeepaliveTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 18), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGKeepaliveTimer.setDescription("The time remaining before this (S,G) state expires, in\nthe absence of explicit (S,G) local membership or (S,G)\nJoin messages received to maintain it.  This timer is\ncalled the (S,G) Keepalive Timer in the PIM-SM\nspecification.")
pimSGDRRegisterState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 19), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("noInfo", 1), ("join", 2), ("joinPending", 3), ("prune", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGDRRegisterState.setDescription("Whether the local router should encapsulate (S,G) data\npackets in Register messages and send them to the RP.  This\ncorresponds to the state of the per-(S,G) Register state\nmachine in the PIM-SM specification.  This object is always\n'noInfo' unless pimSGPimMode is 'asm'.")
pimSGDRRegisterStopTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 20), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGDRRegisterStopTimer.setDescription("If pimSGDRRegisterState is 'prune', this is the time\nremaining before the local router sends a Null-Register\nmessage to the RP.  If pimSGDRRegisterState is\n'joinPending', this is the time remaining before the local\nrouter resumes encapsulating data packets and sending them\nto the RP.  Otherwise, this is zero.  This timer is called\nthe Register-Stop Timer in the PIM-SM specification.")
pimSGRPRegisterPMBRAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 21), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPRegisterPMBRAddressType.setDescription("The address type of the first PIM Multicast Border Router\nto send a Register message with the Border bit set.  This\n\n\n\nobject is unknown(0) if the local router is not the RP for\nthe group.")
pimSGRPRegisterPMBRAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 22), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRPRegisterPMBRAddress.setDescription("The IP address of the first PIM Multicast Border Router to\nsend a Register message with the Border bit set.  The\nInetAddressType is given by the\npimSGRPRegisterPMBRAddressType object.")
pimSGUpstreamPruneState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 23), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("forwarding", 1), ("ackpending", 2), ("pruned", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGUpstreamPruneState.setDescription("Whether the local router has pruned itself from the tree.\nThis corresponds to the state of the upstream prune (S,G)\nstate machine in the PIM-DM specification.  This object is\nused only by PIM-DM.")
pimSGUpstreamPruneLimitTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 24), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGUpstreamPruneLimitTimer.setDescription("The time remaining before the local router may send a (S,G)\nPrune message on pimSGRPFIfIndex.  This timer is called the\n(S,G) Prune Limit Timer in the PIM-DM specification.  This\nobject is zero if the timer is not running.  This object is\nused only by PIM-DM.")
pimSGOriginatorState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 25), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("notOriginator", 1), ("originator", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGOriginatorState.setDescription("Whether the router is an originator for an (S,G) message\nflow.  This corresponds to the state of the per-(S,G)\nOriginator state machine in the PIM-DM specification.  This\nobject is used only by PIM-DM.")
pimSGSourceActiveTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 26), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGSourceActiveTimer.setDescription("If pimSGOriginatorState is 'originator', this is the time\nremaining before the local router reverts to a notOriginator\nstate.  Otherwise, this is zero.  This timer is called the\nSource Active Timer in the PIM-DM specification.  This\nobject is used only by PIM-DM.")
pimSGStateRefreshTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 6, 1, 27), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGStateRefreshTimer.setDescription("If pimSGOriginatorState is 'originator', this is the time\nremaining before the local router sends a State Refresh\nmessage.  Otherwise, this is zero.  This timer is called the\nState Refresh Timer in the PIM-DM specification.  This\nobject is used only by PIM-DM.")
pimSGITable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 7))
if mibBuilder.loadTexts: pimSGITable.setDescription("The (conceptual) table listing the interface-specific (S,G)\nstate that PIM has.")
pimSGIEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 7, 1)).setIndexNames((0, "PIM-STD-MIB", "pimSGAddressType"), (0, "PIM-STD-MIB", "pimSGGrpAddress"), (0, "PIM-STD-MIB", "pimSGSrcAddress"), (0, "PIM-STD-MIB", "pimSGIIfIndex"))
if mibBuilder.loadTexts: pimSGIEntry.setDescription("An entry (conceptual row) in the pimSGITable.")
pimSGIIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimSGIIfIndex.setDescription("The ifIndex of the interface that this entry corresponds\nto.")
pimSGIUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIUpTime.setDescription("The time since this entry was created by the local router.")
pimSGILocalMembership = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGILocalMembership.setDescription("Whether the local router has (S,G) local membership on this\ninterface (resulting from a mechanism such as IGMP or MLD).\nThis corresponds to local_receiver_include(S,G,I) in the\nPIM-SM specification.")
pimSGIJoinPruneState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("noInfo", 1), ("join", 2), ("prunePending", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIJoinPruneState.setDescription("The state resulting from (S,G) Join/Prune messages\nreceived on this interface.  This corresponds to the state\nof the downstream per-interface (S,G) state machine in the\nPIM-SM and PIM-DM specification.")
pimSGIPrunePendingTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIPrunePendingTimer.setDescription("The time remaining before the local router acts on an (S,G)\nPrune message received on this interface, during which the\nrouter is waiting to see whether another downstream router\nwill override the Prune message.  This timer is called the\n(S,G) Prune-Pending Timer in the PIM-SM specification.  This\nobject is zero if the timer is not running.")
pimSGIJoinExpiryTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIJoinExpiryTimer.setDescription("The time remaining before (S,G) Join state for this\n\n\n\ninterface expires.  This timer is called the (S,G) Join\nExpiry Timer in the PIM-SM specification.  This object is\nzero if the timer is not running.  A value of 'FFFFFFFF'h\nindicates an infinite expiry time.  This timer is called the\n(S,G) Prune Timer in the PIM-DM specification.")
pimSGIAssertState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("noInfo", 1), ("iAmAssertWinner", 2), ("iAmAssertLoser", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIAssertState.setDescription("The (S,G) Assert state for this interface.  This\ncorresponds to the state of the per-interface (S,G) Assert\nstate machine in the PIM-SM specification.")
pimSGIAssertTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIAssertTimer.setDescription("If pimSGIAssertState is 'iAmAssertWinner', this is the time\nremaining before the local router next sends a (S,G) Assert\nmessage on this interface.  If pimSGIAssertState is\n'iAmAssertLoser', this is the time remaining before the\n(S,G) Assert state expires.  If pimSGIAssertState is\n'noInfo', this is zero.  This timer is called the (S,G)\nAssert Timer in the PIM-SM specification.")
pimSGIAssertWinnerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 9), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIAssertWinnerAddressType.setDescription("If pimSGIAssertState is 'iAmAssertLoser', this is the\naddress type of the assert winner; otherwise, this object is\nunknown(0).")
pimSGIAssertWinnerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 10), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIAssertWinnerAddress.setDescription("If pimSGIAssertState is 'iAmAssertLoser', this is the\naddress of the assert winner.  The InetAddressType is given\nby the pimSGIAssertWinnerAddressType object.")
pimSGIAssertWinnerMetricPref = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIAssertWinnerMetricPref.setDescription("If pimSGIAssertState is 'iAmAssertLoser', this is the\nmetric preference of the route to the source advertised by\nthe assert winner; otherwise, this object is zero.")
pimSGIAssertWinnerMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 7, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIAssertWinnerMetric.setDescription("If pimSGIAssertState is 'iAmAssertLoser', this is the\nrouting metric of the route to the source advertised by the\nassert winner; otherwise, this object is zero.")
pimSGRptTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 8))
if mibBuilder.loadTexts: pimSGRptTable.setDescription("The (conceptual) table listing the non-interface specific\n(S,G,rpt) state that PIM has.")
pimSGRptEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 8, 1)).setIndexNames((0, "PIM-STD-MIB", "pimStarGAddressType"), (0, "PIM-STD-MIB", "pimStarGGrpAddress"), (0, "PIM-STD-MIB", "pimSGRptSrcAddress"))
if mibBuilder.loadTexts: pimSGRptEntry.setDescription("An entry (conceptual row) in the pimSGRptTable.")
pimSGRptSrcAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 8, 1, 1), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimSGRptSrcAddress.setDescription("The source address for this entry.  The InetAddressType is\ngiven by the pimStarGAddressType object.")
pimSGRptUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 8, 1, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptUpTime.setDescription("The time since this entry was created by the local router.")
pimSGRptUpstreamPruneState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 8, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("rptNotJoined", 1), ("pruned", 2), ("notPruned", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptUpstreamPruneState.setDescription("Whether the local router should prune the source off the RP\ntree.  This corresponds to the state of the upstream\n(S,G,rpt) state machine for triggered messages in the PIM-SM\nspecification.")
pimSGRptUpstreamOverrideTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 8, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptUpstreamOverrideTimer.setDescription("The time remaining before the local router sends a\ntriggered (S,G,rpt) Join message on pimStarGRPFIfIndex.\nThis timer is called the (S,G,rpt) Upstream Override Timer\nin the PIM-SM specification.  This object is zero if the\ntimer is not running.")
pimSGRptITable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 9))
if mibBuilder.loadTexts: pimSGRptITable.setDescription("The (conceptual) table listing the interface-specific\n(S,G,rpt) state that PIM has.")
pimSGRptIEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 9, 1)).setIndexNames((0, "PIM-STD-MIB", "pimStarGAddressType"), (0, "PIM-STD-MIB", "pimStarGGrpAddress"), (0, "PIM-STD-MIB", "pimSGRptSrcAddress"), (0, "PIM-STD-MIB", "pimSGRptIIfIndex"))
if mibBuilder.loadTexts: pimSGRptIEntry.setDescription("An entry (conceptual row) in the pimSGRptITable.")
pimSGRptIIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 9, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimSGRptIIfIndex.setDescription("The ifIndex of the interface that this entry corresponds\nto.")
pimSGRptIUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 9, 1, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptIUpTime.setDescription("The time since this entry was created by the local router.")
pimSGRptILocalMembership = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 9, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptILocalMembership.setDescription("Whether the local router has both (*,G) include local\nmembership and (S,G) exclude local membership on this\ninterface (resulting from a mechanism such as IGMP or MLD).\nThis corresponds to local_receiver_exclude(S,G,I) in the\nPIM-SM specification.")
pimSGRptIJoinPruneState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 9, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("noInfo", 1), ("prune", 2), ("prunePending", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptIJoinPruneState.setDescription("The state resulting from (S,G,rpt) Join/Prune messages\nreceived on this interface.  This corresponds to the state\nof the downstream per-interface (S,G,rpt) state machine in\nthe PIM-SM specification.")
pimSGRptIPrunePendingTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 9, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptIPrunePendingTimer.setDescription("The time remaining before the local router starts pruning\nthis source off the RP tree.  This timer is called the\n(S,G,rpt) Prune-Pending Timer in the PIM-SM specification.\nThis object is zero if the timer is not running.")
pimSGRptIPruneExpiryTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 9, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptIPruneExpiryTimer.setDescription("The time remaining before (S,G,rpt) Prune state for this\ninterface expires.  This timer is called the (S,G,rpt)\nPrune Expiry Timer in the PIM-SM specification.  This object\nis zero if the timer is not running.  A value of 'FFFFFFFF'h\nindicates an infinite expiry time.")
pimBidirDFElectionTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 10))
if mibBuilder.loadTexts: pimBidirDFElectionTable.setDescription("The (conceptual) table listing the per-RP Designated\nForwarder (DF) Election state for each interface for all the\nRPs in BIDIR mode.")
pimBidirDFElectionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 10, 1)).setIndexNames((0, "PIM-STD-MIB", "pimBidirDFElectionAddressType"), (0, "PIM-STD-MIB", "pimBidirDFElectionRPAddress"), (0, "PIM-STD-MIB", "pimBidirDFElectionIfIndex"))
if mibBuilder.loadTexts: pimBidirDFElectionEntry.setDescription("An entry (conceptual row) in the pimBidirDFElectionTable.")
pimBidirDFElectionAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimBidirDFElectionAddressType.setDescription("The address type of the RP for which the DF state is being\nmaintained.")
pimBidirDFElectionRPAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimBidirDFElectionRPAddress.setDescription("The IP address of the RP for which the DF state is being\nmaintained.  The InetAddressType is given by the\npimBidirDFElectionAddressType object.")
pimBidirDFElectionIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 3), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimBidirDFElectionIfIndex.setDescription("The value of ifIndex for the interface for which the DF\nstate is being maintained.")
pimBidirDFElectionWinnerAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionWinnerAddressType.setDescription("The primary address type of the winner of the DF Election\nprocess.  A value of unknown(0) indicates there is currently\n\n\n\nno DF.")
pimBidirDFElectionWinnerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 5), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionWinnerAddress.setDescription("The primary IP address of the winner of the DF Election\nprocess.  The InetAddressType is given by the\npimBidirDFElectionWinnerAddressType object.")
pimBidirDFElectionWinnerUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionWinnerUpTime.setDescription("The time since the current winner (last) became elected as\nthe DF for this RP.")
pimBidirDFElectionWinnerMetricPref = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionWinnerMetricPref.setDescription("The metric preference advertised by the DF Winner, or zero\nif there is currently no DF.")
pimBidirDFElectionWinnerMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionWinnerMetric.setDescription("The metric advertised by the DF Winner, or zero if there is\ncurrently no DF.")
pimBidirDFElectionState = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("dfOffer", 1), ("dfLose", 2), ("dfWinner", 3), ("dfBackoff", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionState.setDescription("The state of this interface with respect to DF-Election for\nthis RP.  The states correspond to the ones defined in the\nBIDIR-PIM specification.")
pimBidirDFElectionStateTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 10, 1, 10), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimBidirDFElectionStateTimer.setDescription("The minimum time remaining after which the local router\nwill expire the current DF state represented by\npimBidirDFElectionState.")
pimStaticRPTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 11))
if mibBuilder.loadTexts: pimStaticRPTable.setDescription("This table is used to manage static configuration of RPs.\n\nIf the group prefixes configured for two or more rows in\nthis table overlap, the row with the greatest value of\npimStaticRPGrpPrefixLength is used for the overlapping\nrange.")
pimStaticRPEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 11, 1)).setIndexNames((0, "PIM-STD-MIB", "pimStaticRPAddressType"), (0, "PIM-STD-MIB", "pimStaticRPGrpAddress"), (0, "PIM-STD-MIB", "pimStaticRPGrpPrefixLength"))
if mibBuilder.loadTexts: pimStaticRPEntry.setDescription("An entry (conceptual row) in the pimStaticRPTable.  This\nentry is preserved on agent restart.")
pimStaticRPAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimStaticRPAddressType.setDescription("The address type of this entry.")
pimStaticRPGrpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimStaticRPGrpAddress.setDescription("The multicast group address that, when combined with\npimStaticRPGrpPrefixLength, gives the group prefix for this\nentry.  The InetAddressType is given by the\npimStaticRPAddressType object.\n\nThis address object is only significant up to\npimStaticRPGrpPrefixLength bits.  The remainder of the\naddress bits are zero.  This is especially important for\nthis index field, which is part of the index of this entry.\nAny non-zero bits would signify an entirely different\nentry.")
pimStaticRPGrpPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 3), InetAddressPrefixLength().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 128))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimStaticRPGrpPrefixLength.setDescription("The multicast group prefix length that, when combined\nwith pimStaticRPGrpAddress, gives the group prefix for this\nentry.  The InetAddressType is given by the\npimStaticRPAddressType object.  If pimStaticRPAddressType is\n'ipv4' or 'ipv4z', this object must be in the range 4..32.\n\n\n\nIf pimStaticRPGrpAddressType is 'ipv6' or 'ipv6z', this\nobject must be in the range 8..128.")
pimStaticRPRPAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 4), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimStaticRPRPAddress.setDescription("The IP address of the RP to be used for groups within this\ngroup prefix.  The InetAddressType is given by the\npimStaticRPAddressType object.")
pimStaticRPPimMode = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,4,3,)).subtype(namedValues=namedval.NamedValues(("ssm", 2), ("asm", 3), ("bidir", 4), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimStaticRPPimMode.setDescription("The PIM mode to be used for groups in this group prefix.\n\nIf this object is set to ssm(2), then pimStaticRPRPAddress\nmust be set to zero.  No RP operations are ever possible for\nPIM Mode SSM.")
pimStaticRPOverrideDynamic = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimStaticRPOverrideDynamic.setDescription("Whether this static RP configuration will override other\ngroup mappings in this group prefix.  If this object is\nTRUE, then it will override:\n\n-  RP information learned dynamically for groups in this\ngroup prefix.\n\n-  RP information configured in pimStaticRPTable with\npimStaticRPOverrideDynamic set to FALSE.\n\nSee pimGroupMappingTable for details.")
pimStaticRPPrecedence = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 7), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimStaticRPPrecedence.setDescription("The value for pimGroupMappingPrecedence to be used for this\nstatic RP configuration.  This allows fine control over\nwhich configuration is overridden by this static\nconfiguration.\n\nIf pimStaticRPOverrideDynamic is set to TRUE, all dynamic RP\nconfiguration is overridden by this static configuration,\nwhatever the value of this object.\n\nThe absolute values of this object have a significance only\non the local router and do not need to be coordinated with\nother routers.  A setting of this object may have different\neffects when applied to other routers.\n\nDo not use this object unless fine control of static RP\nbehavior on the local router is required.")
pimStaticRPRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimStaticRPRowStatus.setDescription("The status of this row, by which rows in this table can\nbe created and destroyed.\n\nThis status object cannot be set to active(1) before a valid\nvalue has been written to pimStaticRPRPAddress.\n\nAll writeable objects in this entry can be modified when the\nstatus of this entry is active(1).")
pimStaticRPStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 11, 1, 9), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimStaticRPStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
pimAnycastRPSetTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 12))
if mibBuilder.loadTexts: pimAnycastRPSetTable.setDescription("This table is used to manage Anycast-RP via PIM Register\nmessages, as opposed to via other protocols such as MSDP\n(Multicast Source Discovery Protocol).\n\nEntries must be configured in this table if and only if the\nlocal router is a member of one or more Anycast-RP sets,\nthat is, one or more Anycast-RP addresses are assigned to\nthe local router.  Note that if using static RP\nconfiguration, this is in addition to, not instead of, the\npimStaticRPTable entries that must be configured for the\nAnycast-RPs.\n\nThe set of rows with the same values of both\npimAnycastRPSetAddressType and pimAnycastRPSetAnycastAddress\ncorresponds to the Anycast-RP set for that Anycast-RP\naddress.\n\nWhen an Anycast-RP set configuration is active, one entry\nper pimAnycastRPSetAnycastAddress corresponds to the local\nrouter.  The local router is identified by the\npimAnycastRpSetLocalRouter object.  That entry determines\nthe source address used by the local router when forwarding\nPIM Register messages within the Anycast-RP set.")
pimAnycastRPSetEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 12, 1)).setIndexNames((0, "PIM-STD-MIB", "pimAnycastRPSetAddressType"), (0, "PIM-STD-MIB", "pimAnycastRPSetAnycastAddress"), (0, "PIM-STD-MIB", "pimAnycastRPSetRouterAddress"))
if mibBuilder.loadTexts: pimAnycastRPSetEntry.setDescription("An entry corresponds to a single router within a particular\nAnycast-RP set.  This entry is preserved on agent restart.")
pimAnycastRPSetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 12, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimAnycastRPSetAddressType.setDescription("The address type of the Anycast-RP address and router\naddress.")
pimAnycastRPSetAnycastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 12, 1, 2), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimAnycastRPSetAnycastAddress.setDescription("The Anycast-RP address.  The InetAddressType is given by\nthe pimAnycastRPSetAddressType object.")
pimAnycastRPSetRouterAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 12, 1, 3), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimAnycastRPSetRouterAddress.setDescription("The address of a router that is a member of the Anycast-RP\nset.  The InetAddressType is given by the\npimAnycastRPSetAddressType object.\n\nThis address differs from pimAnycastRPSetAnycastAddress.\nEqual values for these two addresses in a single entry are\nnot permitted.  That would cause a Register loop.")
pimAnycastRPSetLocalRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 12, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimAnycastRPSetLocalRouter.setDescription("Whether this entry corresponds to the local router.")
pimAnycastRPSetRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 12, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimAnycastRPSetRowStatus.setDescription("The status of this row, by which rows in this table can\nbe created and destroyed.\n\nThis status object can be set to active(1) without setting\nany other columnar objects in this entry.\n\nAll writeable objects in this entry can be modified when the\nstatus of this entry is active(1).")
pimAnycastRPSetStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 12, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pimAnycastRPSetStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
pimGroupMappingTable = MibTable((1, 3, 6, 1, 2, 1, 157, 1, 13))
if mibBuilder.loadTexts: pimGroupMappingTable.setDescription("The (conceptual) table listing mappings from multicast\ngroup prefixes to the PIM mode and RP address to use for\ngroups within that group prefix.\n\nRows in this table are created for a variety of reasons,\nindicated by the value of the pimGroupMappingOrigin object.\n\n-  Rows with a pimGroupMappingOrigin value of 'fixed' are\n   created automatically by the router at startup, to\n   correspond to the well-defined prefixes of link-local and\n   unroutable group addresses.  These rows are never\n   destroyed.\n\n\n\n\n-  Rows with a pimGroupMappingOrigin value of 'embedded' are\n   created by the router to correspond to group prefixes\n   that are to be treated as being in Embedded-RP format.\n\n-  Rows with a pimGroupMappingOrigin value of 'configRp' are\n   created and destroyed as a result of rows in the\n   pimStaticRPTable being created and destroyed.\n\n-  Rows with a pimGroupMappingOrigin value of 'configSsm'\n   are created and destroyed as a result of configuration of\n   SSM address ranges to the local router.\n\n-  Rows with a pimGroupMappingOrigin value of 'bsr' are\n   created as a result of running the PIM Bootstrap Router\n   (BSR) mechanism.  If the local router is not the elected\n   BSR, these rows are created to correspond to group\n   prefixes in the PIM Bootstrap messages received from the\n   elected BSR.  If the local router is the elected BSR,\n   these rows are created to correspond to group prefixes in\n   the PIM Bootstrap messages that the local router sends.\n   In either case, these rows are destroyed when the group\n   prefixes are timed out by the BSR mechanism.\n\n-  Rows with a pimGroupMappingOrigin value of 'other' are\n   created and destroyed according to some other mechanism\n   not specified here.\n\nGiven the collection of rows in this table at any point in\ntime, the PIM mode and RP address to use for a particular\ngroup is determined using the following algorithm.\n\n1. From the set of all rows, the subset whose group prefix\n   contains the group in question are selected.\n\n2. If there are no such rows, then the group mapping is\n   undefined.\n\n3. If there are multiple selected rows, and a subset is\n   defined by pimStaticRPTable (pimGroupMappingOrigin value\n   of 'configRp') with pimStaticRPOverrideDynamic set to\n   TRUE, then this subset is selected.\n\n4. From the selected subset of rows, the subset that have\n   the greatest value of pimGroupMappingGrpPrefixLength are\n   selected.\n\n5. If there are still multiple selected rows, the subset\n   that has the highest precedence (the lowest numerical\n\n\n\n   value for pimGroupMappingPrecedence) is selected.\n\n6. If there are still multiple selected rows, the row\n   selected is implementation dependent; the implementation\n   might or might not apply the PIM hash function to select\n   the row.\n\n7. The group mode to use is given by the value of\n   pimGroupMappingPimMode from the single selected row; the\n   RP to use is given by the value of\n   pimGroupMappingRPAddress, unless pimGroupMappingOrigin is\n   'embedded', in which case, the RP is extracted from the\n   group address in question.")
pimGroupMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 157, 1, 13, 1)).setIndexNames((0, "PIM-STD-MIB", "pimGroupMappingOrigin"), (0, "PIM-STD-MIB", "pimGroupMappingAddressType"), (0, "PIM-STD-MIB", "pimGroupMappingGrpAddress"), (0, "PIM-STD-MIB", "pimGroupMappingGrpPrefixLength"), (0, "PIM-STD-MIB", "pimGroupMappingRPAddressType"), (0, "PIM-STD-MIB", "pimGroupMappingRPAddress"))
if mibBuilder.loadTexts: pimGroupMappingEntry.setDescription("An entry (conceptual row) in the pimGroupMappingTable.")
pimGroupMappingOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 1), PimGroupMappingOriginType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimGroupMappingOrigin.setDescription("The mechanism by which this group mapping was learned.")
pimGroupMappingAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 2), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimGroupMappingAddressType.setDescription("The address type of the IP multicast group prefix.")
pimGroupMappingGrpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 3), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimGroupMappingGrpAddress.setDescription("The IP multicast group address that, when combined with\npimGroupMappingGrpPrefixLength, gives the group prefix for\nthis mapping.  The InetAddressType is given by the\npimGroupMappingAddressType object.\n\nThis address object is only significant up to\npimGroupMappingGrpPrefixLength bits.  The remainder of the\naddress bits are zero.  This is especially important for\nthis index field, which is part of the index of this entry.\nAny non-zero bits would signify an entirely different\nentry.")
pimGroupMappingGrpPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 4), InetAddressPrefixLength().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 128))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimGroupMappingGrpPrefixLength.setDescription("The multicast group prefix length that, when combined\nwith pimGroupMappingGrpAddress, gives the group prefix for\nthis mapping.  The InetAddressType is given by the\npimGroupMappingAddressType object.  If\npimGroupMappingAddressType is 'ipv4' or 'ipv4z', this\nobject must be in the range 4..32.  If\npimGroupMappingAddressType is 'ipv6' or 'ipv6z', this object\nmust be in the range 8..128.")
pimGroupMappingRPAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 5), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimGroupMappingRPAddressType.setDescription("The address type of the RP to be used for groups within\nthis group prefix, or unknown(0) if no RP is to be used or\n\n\n\nif the RP address is unknown.  This object must be\nunknown(0) if pimGroupMappingPimMode is ssm(2), or if\npimGroupMappingOrigin is embedded(6).")
pimGroupMappingRPAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 6), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pimGroupMappingRPAddress.setDescription("The IP address of the RP to be used for groups within this\ngroup prefix.  The InetAddressType is given by the\npimGroupMappingRPAddressType object.")
pimGroupMappingPimMode = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 7), PimMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimGroupMappingPimMode.setDescription("The PIM mode to be used for groups in this group prefix.")
pimGroupMappingPrecedence = MibTableColumn((1, 3, 6, 1, 2, 1, 157, 1, 13, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimGroupMappingPrecedence.setDescription("The precedence of this row, used in the algorithm that\ndetermines which row applies to a given group address\n(described above).  Numerically higher values for this\nobject indicate lower precedences, with the value zero\ndenoting the highest precedence.\n\nThe absolute values of this object have a significance only\non the local router and do not need to be coordinated with\nother routers.")
pimKeepalivePeriod = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(210)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimKeepalivePeriod.setDescription("The duration of the Keepalive Timer.  This is the period\nduring which the PIM router will maintain (S,G) state in the\nabsence of explicit (S,G) local membership or (S,G) join\nmessages received to maintain it.  This timer period is\ncalled the Keepalive_Period in the PIM-SM specification.  It\nis called the SourceLifetime in the PIM-DM specification.\n\n\n\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimRegisterSuppressionTime = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 15), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(60)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimRegisterSuppressionTime.setDescription("The duration of the Register Suppression Timer.  This is\nthe period during which a PIM Designated Router (DR) stops\nsending Register-encapsulated data to the Rendezvous Point\n(RP) after receiving a Register-Stop message.  This object\nis used to run timers both at the DR and at the RP.  This\ntimer period is called the Register_Suppression_Time in the\nPIM-SM specification.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimStarGEntries = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGEntries.setDescription("The number of entries in the pimStarGTable.")
pimStarGIEntries = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 17), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimStarGIEntries.setDescription("The number of entries in the pimStarGITable.")
pimSGEntries = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 18), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGEntries.setDescription("The number of entries in the pimSGTable.")
pimSGIEntries = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 19), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGIEntries.setDescription("The number of entries in the pimSGITable.")
pimSGRptEntries = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 20), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptEntries.setDescription("The number of entries in the pimSGRptTable.")
pimSGRptIEntries = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimSGRptIEntries.setDescription("The number of entries in the pimSGRptITable.")
pimOutAsserts = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 22), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimOutAsserts.setDescription("The number of Asserts sent by this router.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimInAsserts = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 23), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInAsserts.setDescription("The number of Asserts received by this router.  Asserts\nare multicast to all routers on a network.  This counter is\nincremented by all routers that receive an assert, not only\nthose routers that are contesting the assert.\n\n\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimLastAssertInterface = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 24), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimLastAssertInterface.setDescription("The interface on which this router most recently sent or\nreceived an assert, or zero if this router has not sent or\nreceived an assert.")
pimLastAssertGroupAddressType = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 25), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimLastAssertGroupAddressType.setDescription("The address type of the multicast group address in the most\nrecently sent or received assert.  If this router has not\nsent or received an assert, then this object is set to\nunknown(0).")
pimLastAssertGroupAddress = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 26), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimLastAssertGroupAddress.setDescription("The multicast group address in the most recently sent or\nreceived assert.  The InetAddressType is given by the\npimLastAssertGroupAddressType object.")
pimLastAssertSourceAddressType = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 27), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimLastAssertSourceAddressType.setDescription("The address type of the source address in the most recently\nsent or received assert.  If the most recent assert was\n(*,G), or if this router has not sent or received an assert,\nthen this object is set to unknown(0).")
pimLastAssertSourceAddress = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 28), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimLastAssertSourceAddress.setDescription("The source address in the most recently sent or received\nassert.  The InetAddressType is given by the\npimLastAssertSourceAddressType object.")
pimNeighborLossNotificationPeriod = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 29), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(0)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimNeighborLossNotificationPeriod.setDescription("The minimum time that must elapse between pimNeighborLoss\nnotifications originated by this router.  The maximum value\n65535 represents an 'infinite' time, in which case, no\npimNeighborLoss notifications are ever sent.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimNeighborLossCount = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimNeighborLossCount.setDescription("The number of neighbor loss events that have occurred.\n\nThis counter is incremented when the neighbor timer expires,\nand the router has no other neighbors on the same interface\nwith the same IP version and a lower IP address than itself.\n\nThis counter is incremented whenever a pimNeighborLoss\nnotification would be generated.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimInvalidRegisterNotificationPeriod = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 31), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(10, 65535)).clone(65535)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimInvalidRegisterNotificationPeriod.setDescription("The minimum time that must elapse between\npimInvalidRegister notifications originated by this router.\nThe default value of 65535 represents an 'infinite' time, in\nwhich case, no pimInvalidRegister notifications are ever\nsent.\n\nThe non-zero minimum allowed value provides resilience\nagainst propagation of denial-of-service attacks from the\ndata and control planes to the network management plane.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimInvalidRegisterMsgsRcvd = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidRegisterMsgsRcvd.setDescription("The number of invalid PIM Register messages that have been\nreceived by this device.\n\nA PIM Register message is invalid if either\n\no the destination address of the Register message does not\n  match the Group to RP mapping on this device, or\n\no this device believes the group address to be within an\n  SSM address range, but this Register implies ASM usage.\n\nThese conditions can occur transiently while RP mapping\nchanges propagate through the network.  If this counter is\nincremented repeatedly over several minutes, then there is a\npersisting configuration error that requires correction.\n\nThe active Group to RP mapping on this device is specified\nby the object pimGroupMappingPimMode.  If there is no such\nmapping, then the object pimGroupMappingPimMode is absent.\nThe RP address contained in the invalid Register is\npimInvalidRegisterRp.\n\nMulticast data carried by invalid Register messages is\ndiscarded.  The discarded data is from a source directly\n\n\n\nconnected to pimInvalidRegisterOrigin, and is addressed to\npimInvalidRegisterGroup.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimInvalidRegisterAddressType = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 33), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidRegisterAddressType.setDescription("The address type stored in pimInvalidRegisterOrigin,\npimInvalidRegisterGroup, and pimInvalidRegisterRp.\n\nIf no invalid Register messages have been received, then\nthis object is set to unknown(0).")
pimInvalidRegisterOrigin = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 34), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidRegisterOrigin.setDescription("The source address of the last invalid Register message\nreceived by this device.")
pimInvalidRegisterGroup = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 35), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidRegisterGroup.setDescription("The IP multicast group address to which the last invalid\nRegister message received by this device was addressed.")
pimInvalidRegisterRp = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 36), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidRegisterRp.setDescription("The RP address to which the last invalid Register message\nreceived by this device was delivered.")
pimInvalidJoinPruneNotificationPeriod = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 37), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(10, 65535)).clone(65535)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimInvalidJoinPruneNotificationPeriod.setDescription("The minimum time that must elapse between\npimInvalidJoinPrune notifications originated by this router.\nThe default value of 65535 represents an 'infinite' time, in\nwhich case, no pimInvalidJoinPrune notifications are ever\nsent.\n\nThe non-zero minimum allowed value provides resilience\nagainst propagation of denial-of-service attacks from the\ncontrol plane to the network management plane.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimInvalidJoinPruneMsgsRcvd = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidJoinPruneMsgsRcvd.setDescription("The number of invalid PIM Join/Prune messages that have\nbeen received by this device.\n\nA PIM Join/Prune message is invalid if either\n\no the Group to RP mapping specified by this message does not\n  match the Group to RP mapping on this device, or\n\no this device believes the group address to be within an\n  SSM address range, but this Join/Prune (*,G) or (S,G,rpt)\n  implies ASM usage.\n\nThese conditions can occur transiently while RP mapping\nchanges propagate through the network.  If this counter is\nincremented repeatedly over several minutes, then there is a\npersisting configuration error that requires correction.\n\nThe active Group to RP mapping on this device is specified\nby the object pimGroupMappingPimMode.  If there is no such\nmapping, then the object pimGroupMappingPimMode is absent.\nThe RP address contained in the invalid Join/Prune is\npimInvalidJoinPruneRp.\n\n\n\nInvalid Join/Prune messages are discarded.  This may result\nin loss of multicast data affecting listeners downstream of\npimInvalidJoinPruneOrigin, for multicast data addressed to\npimInvalidJoinPruneGroup.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimInvalidJoinPruneAddressType = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 39), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidJoinPruneAddressType.setDescription("The address type stored in pimInvalidJoinPruneOrigin,\npimInvalidJoinPruneGroup, and pimInvalidJoinPruneRp.\n\nIf no invalid Join/Prune messages have been received, this\nobject is set to unknown(0).")
pimInvalidJoinPruneOrigin = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 40), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidJoinPruneOrigin.setDescription("The source address of the last invalid Join/Prune message\nreceived by this device.")
pimInvalidJoinPruneGroup = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 41), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidJoinPruneGroup.setDescription("The IP multicast group address carried in the last\ninvalid Join/Prune message received by this device.")
pimInvalidJoinPruneRp = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 42), InetAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(4,4),constraint.ValueSizeConstraint(8,8),constraint.ValueSizeConstraint(16,16),constraint.ValueSizeConstraint(20,20),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInvalidJoinPruneRp.setDescription("The RP address carried in the last invalid Join/Prune\n\n\n\nmessage received by this device.")
pimRPMappingNotificationPeriod = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 43), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(65535)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimRPMappingNotificationPeriod.setDescription("The minimum time that must elapse between\npimRPMappingChange notifications originated by this router.\nThe default value of 65535 represents an 'infinite' time, in\nwhich case, no pimRPMappingChange notifications are ever\nsent.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimRPMappingChangeCount = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimRPMappingChangeCount.setDescription("The number of changes to active RP mappings on this device.\n\nInformation about active RP mappings is available in\npimGroupMappingTable.  Only changes to active mappings cause\nthis counter to be incremented.  That is, changes that\nmodify the pimGroupMappingEntry with the highest precedence\nfor a group (lowest value of pimGroupMappingPrecedence).\n\nSuch changes may result from manual configuration of this\ndevice, or from automatic RP mapping discovery methods\nincluding the PIM Bootstrap Router (BSR) mechanism.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimInterfaceElectionNotificationPeriod = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 45), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(65535)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimInterfaceElectionNotificationPeriod.setDescription("The minimum time that must elapse between\npimInterfaceElection notifications originated by this\nrouter.  The default value of 65535 represents an 'infinite'\ntime, in which case, no pimInterfaceElection notifications\nare ever sent.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimInterfaceElectionWinCount = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 46), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pimInterfaceElectionWinCount.setDescription("The number of times this device has been elected DR or DF\non any interface.\n\nElections occur frequently on newly-active interfaces, as\ntriggered Hellos establish adjacencies.  This counter is not\nincremented for elections on an interface until the first\nperiodic Hello has been sent.  If this router is the DR or\nDF at the time of sending the first periodic Hello after\ninterface activation, then this counter is incremented\n(once) at that time.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, for example,\nwhen the device is rebooted.")
pimRefreshInterval = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 47), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(60)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: pimRefreshInterval.setDescription("The interval between successive State Refresh messages sent\nby an Originator.  This timer period is called the\nRefreshInterval in the PIM-DM specification.  This object is\nused only by PIM-DM.\n\nThe storage type of this object is determined by\npimDeviceConfigStorageType.")
pimDeviceConfigStorageType = MibScalar((1, 3, 6, 1, 2, 1, 157, 1, 48), StorageType().clone('nonVolatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pimDeviceConfigStorageType.setDescription("The storage type used for the global PIM configuration of\nthis device, comprised of the objects listed below.  If this\nstorage type takes the value 'permanent', write-access to\nthe listed objects need not be allowed.\n\nThe objects described by this storage type are:\npimKeepalivePeriod, pimRegisterSuppressionTime,\npimNeighborLossNotificationPeriod,\npimInvalidRegisterNotificationPeriod,\npimInvalidJoinPruneNotificationPeriod,\npimRPMappingNotificationPeriod,\npimInterfaceElectionNotificationPeriod, and\npimRefreshInterval.")
pimMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 157, 2))
pimMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 157, 2, 1))
pimMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 157, 2, 2))

# Augmentions

# Notifications

pimNeighborLoss = NotificationType((1, 3, 6, 1, 2, 1, 157, 0, 1)).setObjects(("PIM-STD-MIB", "pimNeighborUpTime"), )
if mibBuilder.loadTexts: pimNeighborLoss.setDescription("A pimNeighborLoss notification signifies the loss of an\n\n\n\nadjacency with a neighbor.  This notification should be\ngenerated when the neighbor timer expires, and the router\nhas no other neighbors on the same interface with the same\nIP version and a lower IP address than itself.\n\nThis notification is generated whenever the counter\npimNeighborLossCount is incremented, subject\nto the rate limit specified by\npimNeighborLossNotificationPeriod.")
pimInvalidRegister = NotificationType((1, 3, 6, 1, 2, 1, 157, 0, 2)).setObjects(("PIM-STD-MIB", "pimGroupMappingPimMode"), ("PIM-STD-MIB", "pimInvalidRegisterAddressType"), ("PIM-STD-MIB", "pimInvalidRegisterOrigin"), ("PIM-STD-MIB", "pimInvalidRegisterGroup"), ("PIM-STD-MIB", "pimInvalidRegisterRp"), )
if mibBuilder.loadTexts: pimInvalidRegister.setDescription("A pimInvalidRegister notification signifies that an invalid\nPIM Register message was received by this device.\n\nThis notification is generated whenever the counter\npimInvalidRegisterMsgsRcvd is incremented, subject to the\nrate limit specified by\npimInvalidRegisterNotificationPeriod.")
pimInvalidJoinPrune = NotificationType((1, 3, 6, 1, 2, 1, 157, 0, 3)).setObjects(("PIM-STD-MIB", "pimInvalidJoinPruneRp"), ("PIM-STD-MIB", "pimGroupMappingPimMode"), ("PIM-STD-MIB", "pimInvalidJoinPruneGroup"), ("PIM-STD-MIB", "pimInvalidJoinPruneOrigin"), ("PIM-STD-MIB", "pimInvalidJoinPruneAddressType"), ("PIM-STD-MIB", "pimNeighborUpTime"), )
if mibBuilder.loadTexts: pimInvalidJoinPrune.setDescription("A pimInvalidJoinPrune notification signifies that an\ninvalid PIM Join/Prune message was received by this device.\n\nThis notification is generated whenever the counter\npimInvalidJoinPruneMsgsRcvd is incremented, subject to the\nrate limit specified by\npimInvalidJoinPruneNotificationPeriod.")
pimRPMappingChange = NotificationType((1, 3, 6, 1, 2, 1, 157, 0, 4)).setObjects(("PIM-STD-MIB", "pimGroupMappingPimMode"), ("PIM-STD-MIB", "pimGroupMappingPrecedence"), )
if mibBuilder.loadTexts: pimRPMappingChange.setDescription("A pimRPMappingChange notification signifies a change to the\nactive RP mapping on this device.\n\nThis notification is generated whenever the counter\npimRPMappingChangeCount is incremented, subject to the\nrate limit specified by\npimRPMappingChangeNotificationPeriod.")
pimInterfaceElection = NotificationType((1, 3, 6, 1, 2, 1, 157, 0, 5)).setObjects(("PIM-STD-MIB", "pimInterfaceAddressType"), ("PIM-STD-MIB", "pimInterfaceAddress"), )
if mibBuilder.loadTexts: pimInterfaceElection.setDescription("A pimInterfaceElection notification signifies that a new DR\nor DF has been elected on a network.\n\nThis notification is generated whenever the counter\npimInterfaceElectionWinCount is incremented, subject to the\nrate limit specified by\npimInterfaceElectionNotificationPeriod.")

# Groups

pimTopologyGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 1)).setObjects(("PIM-STD-MIB", "pimInterfaceHelloHoldtime"), ("PIM-STD-MIB", "pimInterfaceEffectPropagDelay"), ("PIM-STD-MIB", "pimNeighborDRPriority"), ("PIM-STD-MIB", "pimInterfaceGenerationIDValue"), ("PIM-STD-MIB", "pimNeighborTBit"), ("PIM-STD-MIB", "pimInterfaceDR"), ("PIM-STD-MIB", "pimNbrSecAddress"), ("PIM-STD-MIB", "pimNeighborGenerationIDValue"), ("PIM-STD-MIB", "pimInterfaceAddressType"), ("PIM-STD-MIB", "pimNeighborBidirCapable"), ("PIM-STD-MIB", "pimInterfaceEffectOverrideIvl"), ("PIM-STD-MIB", "pimInterfaceJoinPruneHoldtime"), ("PIM-STD-MIB", "pimInterfaceSuppressionEnabled"), ("PIM-STD-MIB", "pimInterfaceBidirCapable"), ("PIM-STD-MIB", "pimNeighborOverrideInterval"), ("PIM-STD-MIB", "pimNeighborPropagationDelay"), ("PIM-STD-MIB", "pimInterfaceDRPriorityEnabled"), ("PIM-STD-MIB", "pimInterfaceAddress"), ("PIM-STD-MIB", "pimNeighborLanPruneDelayPresent"), ("PIM-STD-MIB", "pimNeighborGenerationIDPresent"), ("PIM-STD-MIB", "pimNeighborDRPriorityPresent"), ("PIM-STD-MIB", "pimNeighborExpiryTime"), ("PIM-STD-MIB", "pimInterfaceLanDelayEnabled"), ("PIM-STD-MIB", "pimNeighborUpTime"), )
if mibBuilder.loadTexts: pimTopologyGroup.setDescription("A collection of read-only objects used to report local PIM\ntopology.")
pimNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 2)).setObjects(("PIM-STD-MIB", "pimNeighborLoss"), )
if mibBuilder.loadTexts: pimNotificationGroup.setDescription("A collection of notifications for signaling important PIM\nevents.")
pimTuningParametersGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 3)).setObjects(("PIM-STD-MIB", "pimInterfaceOverrideInterval"), ("PIM-STD-MIB", "pimInterfaceStorageType"), ("PIM-STD-MIB", "pimInterfaceHelloInterval"), ("PIM-STD-MIB", "pimInterfaceDomainBorder"), ("PIM-STD-MIB", "pimInterfaceStatus"), ("PIM-STD-MIB", "pimInterfacePropagationDelay"), ("PIM-STD-MIB", "pimInterfaceDRPriority"), ("PIM-STD-MIB", "pimRegisterSuppressionTime"), ("PIM-STD-MIB", "pimKeepalivePeriod"), ("PIM-STD-MIB", "pimInterfaceTrigHelloInterval"), ("PIM-STD-MIB", "pimInterfaceJoinPruneInterval"), ("PIM-STD-MIB", "pimInterfaceStubInterface"), )
if mibBuilder.loadTexts: pimTuningParametersGroup.setDescription("A collection of writeable objects used to configure PIM\nbehavior and to tune performance.")
pimRouterStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 4)).setObjects(("PIM-STD-MIB", "pimStarGEntries"), ("PIM-STD-MIB", "pimSGEntries"), ("PIM-STD-MIB", "pimSGRptEntries"), ("PIM-STD-MIB", "pimSGRptIEntries"), ("PIM-STD-MIB", "pimSGIEntries"), ("PIM-STD-MIB", "pimStarGIEntries"), )
if mibBuilder.loadTexts: pimRouterStatisticsGroup.setDescription("A collection of statistics global to the PIM router.")
pimSsmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 5)).setObjects(("PIM-STD-MIB", "pimSGIAssertWinnerAddress"), ("PIM-STD-MIB", "pimSGRPRegisterPMBRAddressType"), ("PIM-STD-MIB", "pimSGIAssertState"), ("PIM-STD-MIB", "pimSGUpstreamNeighbor"), ("PIM-STD-MIB", "pimSGRPFRouteProtocol"), ("PIM-STD-MIB", "pimSGRPFRouteAddress"), ("PIM-STD-MIB", "pimSGRPFNextHop"), ("PIM-STD-MIB", "pimSGILocalMembership"), ("PIM-STD-MIB", "pimSGIUpTime"), ("PIM-STD-MIB", "pimSGRPRegisterPMBRAddress"), ("PIM-STD-MIB", "pimSGPimMode"), ("PIM-STD-MIB", "pimSGIPrunePendingTimer"), ("PIM-STD-MIB", "pimSGDRRegisterStopTimer"), ("PIM-STD-MIB", "pimSGKeepaliveTimer"), ("PIM-STD-MIB", "pimSGIAssertWinnerMetricPref"), ("PIM-STD-MIB", "pimSGRPFRouteMetric"), ("PIM-STD-MIB", "pimSGRPFRoutePrefixLength"), ("PIM-STD-MIB", "pimSGUpTime"), ("PIM-STD-MIB", "pimSGSPTBit"), ("PIM-STD-MIB", "pimSGUpstreamJoinState"), ("PIM-STD-MIB", "pimSGIAssertWinnerMetric"), ("PIM-STD-MIB", "pimSGIAssertWinnerAddressType"), ("PIM-STD-MIB", "pimSGRPFIfIndex"), ("PIM-STD-MIB", "pimSGRPFNextHopType"), ("PIM-STD-MIB", "pimSGRPFRouteMetricPref"), ("PIM-STD-MIB", "pimSGIJoinPruneState"), ("PIM-STD-MIB", "pimSGUpstreamJoinTimer"), ("PIM-STD-MIB", "pimSGIJoinExpiryTimer"), ("PIM-STD-MIB", "pimSGIAssertTimer"), ("PIM-STD-MIB", "pimSGDRRegisterState"), )
if mibBuilder.loadTexts: pimSsmGroup.setDescription("A collection of objects to support management of PIM\nrouters running the PIM SSM (Source Specific Multicast)\nprotocol, in PIM mode SM (Sparse Mode).")
pimRPConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 6)).setObjects(("PIM-STD-MIB", "pimStaticRPPimMode"), ("PIM-STD-MIB", "pimStaticRPOverrideDynamic"), ("PIM-STD-MIB", "pimGroupMappingPimMode"), ("PIM-STD-MIB", "pimStaticRPStorageType"), ("PIM-STD-MIB", "pimStaticRPRowStatus"), ("PIM-STD-MIB", "pimGroupMappingPrecedence"), ("PIM-STD-MIB", "pimStaticRPRPAddress"), )
if mibBuilder.loadTexts: pimRPConfigGroup.setDescription("A collection of objects to support configuration of RPs\n(Rendezvous Points) and Group Mappings.")
pimSmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 7)).setObjects(("PIM-STD-MIB", "pimSGRptUpTime"), ("PIM-STD-MIB", "pimStarGRPIsLocal"), ("PIM-STD-MIB", "pimStarGIAssertWinnerMetricPref"), ("PIM-STD-MIB", "pimStarGUpstreamJoinTimer"), ("PIM-STD-MIB", "pimSGRptIJoinPruneState"), ("PIM-STD-MIB", "pimStarGRPFNextHopType"), ("PIM-STD-MIB", "pimStarGRPFIfIndex"), ("PIM-STD-MIB", "pimSGRptUpstreamPruneState"), ("PIM-STD-MIB", "pimStarGPimModeOrigin"), ("PIM-STD-MIB", "pimStarGUpstreamJoinState"), ("PIM-STD-MIB", "pimStarGIPrunePendingTimer"), ("PIM-STD-MIB", "pimStarGRPFRouteMetricPref"), ("PIM-STD-MIB", "pimStarGRPFRouteAddress"), ("PIM-STD-MIB", "pimStarGUpstreamNeighbor"), ("PIM-STD-MIB", "pimStarGUpstreamNeighborType"), ("PIM-STD-MIB", "pimStarGIAssertWinnerAddress"), ("PIM-STD-MIB", "pimSGRptIUpTime"), ("PIM-STD-MIB", "pimStarGIAssertWinnerAddressType"), ("PIM-STD-MIB", "pimStarGIAssertWinnerMetric"), ("PIM-STD-MIB", "pimStarGIAssertState"), ("PIM-STD-MIB", "pimSGRptIPrunePendingTimer"), ("PIM-STD-MIB", "pimStarGRPFRouteMetric"), ("PIM-STD-MIB", "pimStarGRPFRoutePrefixLength"), ("PIM-STD-MIB", "pimStarGRPFNextHop"), ("PIM-STD-MIB", "pimStarGIUpTime"), ("PIM-STD-MIB", "pimStarGRPFRouteProtocol"), ("PIM-STD-MIB", "pimStarGUpTime"), ("PIM-STD-MIB", "pimSGRptILocalMembership"), ("PIM-STD-MIB", "pimStarGPimMode"), ("PIM-STD-MIB", "pimStarGRPAddressType"), ("PIM-STD-MIB", "pimSGRptUpstreamOverrideTimer"), ("PIM-STD-MIB", "pimStarGIJoinExpiryTimer"), ("PIM-STD-MIB", "pimStarGRPAddress"), ("PIM-STD-MIB", "pimStarGIAssertTimer"), ("PIM-STD-MIB", "pimStarGIJoinPruneState"), ("PIM-STD-MIB", "pimSGRptIPruneExpiryTimer"), ("PIM-STD-MIB", "pimStarGILocalMembership"), )
if mibBuilder.loadTexts: pimSmGroup.setDescription("A collection of objects to support management of PIM\nrouters running PIM-SM (Sparse Mode).  The groups\npimSsmGroup and pimRPConfigGroup are also required.")
pimBidirGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 8)).setObjects(("PIM-STD-MIB", "pimBidirDFElectionWinnerAddress"), ("PIM-STD-MIB", "pimBidirDFElectionStateTimer"), ("PIM-STD-MIB", "pimBidirDFElectionWinnerMetric"), ("PIM-STD-MIB", "pimBidirDFElectionWinnerAddressType"), ("PIM-STD-MIB", "pimBidirDFElectionState"), ("PIM-STD-MIB", "pimInterfaceDFElectionRobustness"), ("PIM-STD-MIB", "pimBidirDFElectionWinnerMetricPref"), ("PIM-STD-MIB", "pimBidirDFElectionWinnerUpTime"), )
if mibBuilder.loadTexts: pimBidirGroup.setDescription("A collection of objects to support management of PIM\nrouters running BIDIR mode.  The groups pimSsmGroup,\npimSmGroup and pimRPConfigGroup are also required.")
pimAnycastRpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 9)).setObjects(("PIM-STD-MIB", "pimAnycastRPSetRowStatus"), ("PIM-STD-MIB", "pimAnycastRPSetStorageType"), ("PIM-STD-MIB", "pimAnycastRPSetLocalRouter"), )
if mibBuilder.loadTexts: pimAnycastRpGroup.setDescription("A collection of objects to support management of the PIM\nAnycast-RP mechanism.")
pimStaticRPPrecedenceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 10)).setObjects(("PIM-STD-MIB", "pimStaticRPPrecedence"), )
if mibBuilder.loadTexts: pimStaticRPPrecedenceGroup.setDescription("A collection of objects to allow fine control of\ninteractions between static RP configuration and\ndynamically acquired group to RP mappings.")
pimNetMgmtNotificationObjects = NotificationGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 11)).setObjects(("PIM-STD-MIB", "pimInvalidJoinPruneRp"), ("PIM-STD-MIB", "pimInvalidRegisterRp"), ("PIM-STD-MIB", "pimInterfaceElectionWinCount"), ("PIM-STD-MIB", "pimInvalidRegisterAddressType"), ("PIM-STD-MIB", "pimInvalidRegisterGroup"), ("PIM-STD-MIB", "pimInvalidRegisterOrigin"), ("PIM-STD-MIB", "pimInterfaceElectionNotificationPeriod"), ("PIM-STD-MIB", "pimInvalidJoinPruneOrigin"), ("PIM-STD-MIB", "pimInvalidRegisterNotificationPeriod"), ("PIM-STD-MIB", "pimInvalidJoinPruneMsgsRcvd"), ("PIM-STD-MIB", "pimInvalidJoinPruneAddressType"), ("PIM-STD-MIB", "pimRPMappingNotificationPeriod"), ("PIM-STD-MIB", "pimInvalidRegisterMsgsRcvd"), ("PIM-STD-MIB", "pimRPMappingChangeCount"), ("PIM-STD-MIB", "pimInvalidJoinPruneGroup"), ("PIM-STD-MIB", "pimInvalidJoinPruneNotificationPeriod"), )
if mibBuilder.loadTexts: pimNetMgmtNotificationObjects.setDescription("A collection of objects to support notification of PIM\nnetwork management events.")
pimNetMgmtNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 12)).setObjects(("PIM-STD-MIB", "pimInterfaceElection"), ("PIM-STD-MIB", "pimRPMappingChange"), ("PIM-STD-MIB", "pimInvalidJoinPrune"), ("PIM-STD-MIB", "pimInvalidRegister"), )
if mibBuilder.loadTexts: pimNetMgmtNotificationGroup.setDescription("A collection of notifications for signaling PIM network\nmanagement events.")
pimDiagnosticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 13)).setObjects(("PIM-STD-MIB", "pimOutAsserts"), ("PIM-STD-MIB", "pimLastAssertInterface"), ("PIM-STD-MIB", "pimLastAssertGroupAddress"), ("PIM-STD-MIB", "pimLastAssertSourceAddress"), ("PIM-STD-MIB", "pimLastAssertGroupAddressType"), ("PIM-STD-MIB", "pimLastAssertSourceAddressType"), ("PIM-STD-MIB", "pimInAsserts"), ("PIM-STD-MIB", "pimNeighborLossNotificationPeriod"), ("PIM-STD-MIB", "pimNeighborLossCount"), )
if mibBuilder.loadTexts: pimDiagnosticsGroup.setDescription("Objects providing additional diagnostics related to a PIM\nrouter.")
pimDmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 14)).setObjects(("PIM-STD-MIB", "pimSGUpstreamPruneLimitTimer"), ("PIM-STD-MIB", "pimInterfaceSRPriorityEnabled"), ("PIM-STD-MIB", "pimSGUpstreamPruneState"), ("PIM-STD-MIB", "pimNeighborSRCapable"), ("PIM-STD-MIB", "pimInterfaceGraftRetryInterval"), ("PIM-STD-MIB", "pimSGOriginatorState"), ("PIM-STD-MIB", "pimSGSourceActiveTimer"), ("PIM-STD-MIB", "pimSGStateRefreshTimer"), ("PIM-STD-MIB", "pimRefreshInterval"), ("PIM-STD-MIB", "pimInterfacePruneLimitInterval"), )
if mibBuilder.loadTexts: pimDmGroup.setDescription("A collection of objects required for management of PIM\nDense Mode (PIM-DM) function.  The groups pimSsmGroup and\npimSmGroup are also required.")
pimDeviceStorageGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 157, 2, 2, 15)).setObjects(("PIM-STD-MIB", "pimDeviceConfigStorageType"), )
if mibBuilder.loadTexts: pimDeviceStorageGroup.setDescription("An object that specifies the volatility of global PIM\nconfiguration settings on this device.")

# Compliances

pimMIBComplianceAsm = ModuleCompliance((1, 3, 6, 1, 2, 1, 157, 2, 1, 1)).setObjects(("PIM-STD-MIB", "pimRouterStatisticsGroup"), ("PIM-STD-MIB", "pimAnycastRpGroup"), ("PIM-STD-MIB", "pimTuningParametersGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationObjects"), ("PIM-STD-MIB", "pimDiagnosticsGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationGroup"), ("PIM-STD-MIB", "pimStaticRPPrecedenceGroup"), ("PIM-STD-MIB", "pimRPConfigGroup"), ("PIM-STD-MIB", "pimNotificationGroup"), ("PIM-STD-MIB", "pimSsmGroup"), ("PIM-STD-MIB", "pimSmGroup"), ("PIM-STD-MIB", "pimDeviceStorageGroup"), ("PIM-STD-MIB", "pimTopologyGroup"), )
if mibBuilder.loadTexts: pimMIBComplianceAsm.setDescription("The compliance statement for routers which are running\nPIM-SM (Sparse Mode).")
pimMIBComplianceBidir = ModuleCompliance((1, 3, 6, 1, 2, 1, 157, 2, 1, 2)).setObjects(("PIM-STD-MIB", "pimRouterStatisticsGroup"), ("PIM-STD-MIB", "pimAnycastRpGroup"), ("PIM-STD-MIB", "pimTuningParametersGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationObjects"), ("PIM-STD-MIB", "pimDiagnosticsGroup"), ("PIM-STD-MIB", "pimBidirGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationGroup"), ("PIM-STD-MIB", "pimStaticRPPrecedenceGroup"), ("PIM-STD-MIB", "pimRPConfigGroup"), ("PIM-STD-MIB", "pimNotificationGroup"), ("PIM-STD-MIB", "pimSmGroup"), ("PIM-STD-MIB", "pimDeviceStorageGroup"), ("PIM-STD-MIB", "pimTopologyGroup"), )
if mibBuilder.loadTexts: pimMIBComplianceBidir.setDescription("The compliance statement for routers which are running\nBidir-PIM.")
pimMIBComplianceSsm = ModuleCompliance((1, 3, 6, 1, 2, 1, 157, 2, 1, 3)).setObjects(("PIM-STD-MIB", "pimSsmGroup"), ("PIM-STD-MIB", "pimTuningParametersGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationObjects"), ("PIM-STD-MIB", "pimRouterStatisticsGroup"), ("PIM-STD-MIB", "pimDiagnosticsGroup"), ("PIM-STD-MIB", "pimTopologyGroup"), ("PIM-STD-MIB", "pimNotificationGroup"), ("PIM-STD-MIB", "pimDeviceStorageGroup"), )
if mibBuilder.loadTexts: pimMIBComplianceSsm.setDescription("The compliance statement for routers which are running\nPIM SSM (Source Specific Multicast).")
pimMIBComplianceDm = ModuleCompliance((1, 3, 6, 1, 2, 1, 157, 2, 1, 4)).setObjects(("PIM-STD-MIB", "pimRouterStatisticsGroup"), ("PIM-STD-MIB", "pimAnycastRpGroup"), ("PIM-STD-MIB", "pimTuningParametersGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationObjects"), ("PIM-STD-MIB", "pimDiagnosticsGroup"), ("PIM-STD-MIB", "pimNetMgmtNotificationGroup"), ("PIM-STD-MIB", "pimDmGroup"), ("PIM-STD-MIB", "pimStaticRPPrecedenceGroup"), ("PIM-STD-MIB", "pimRPConfigGroup"), ("PIM-STD-MIB", "pimNotificationGroup"), ("PIM-STD-MIB", "pimSsmGroup"), ("PIM-STD-MIB", "pimSmGroup"), ("PIM-STD-MIB", "pimDeviceStorageGroup"), ("PIM-STD-MIB", "pimTopologyGroup"), )
if mibBuilder.loadTexts: pimMIBComplianceDm.setDescription("The compliance statement for routers which are running\nPIM-DM (Dense Mode).")

# Exports

# Module identity
mibBuilder.exportSymbols("PIM-STD-MIB", PYSNMP_MODULE_ID=pimStdMIB)

# Types
mibBuilder.exportSymbols("PIM-STD-MIB", PimGroupMappingOriginType=PimGroupMappingOriginType, PimMode=PimMode)

# Objects
mibBuilder.exportSymbols("PIM-STD-MIB", pimStdMIB=pimStdMIB, pimNotifications=pimNotifications, pim=pim, pimInterfaceTable=pimInterfaceTable, pimInterfaceEntry=pimInterfaceEntry, pimInterfaceIfIndex=pimInterfaceIfIndex, pimInterfaceIPVersion=pimInterfaceIPVersion, pimInterfaceAddressType=pimInterfaceAddressType, pimInterfaceAddress=pimInterfaceAddress, pimInterfaceGenerationIDValue=pimInterfaceGenerationIDValue, pimInterfaceDR=pimInterfaceDR, pimInterfaceDRPriority=pimInterfaceDRPriority, pimInterfaceDRPriorityEnabled=pimInterfaceDRPriorityEnabled, pimInterfaceHelloInterval=pimInterfaceHelloInterval, pimInterfaceTrigHelloInterval=pimInterfaceTrigHelloInterval, pimInterfaceHelloHoldtime=pimInterfaceHelloHoldtime, pimInterfaceJoinPruneInterval=pimInterfaceJoinPruneInterval, pimInterfaceJoinPruneHoldtime=pimInterfaceJoinPruneHoldtime, pimInterfaceDFElectionRobustness=pimInterfaceDFElectionRobustness, pimInterfaceLanDelayEnabled=pimInterfaceLanDelayEnabled, pimInterfacePropagationDelay=pimInterfacePropagationDelay, pimInterfaceOverrideInterval=pimInterfaceOverrideInterval, pimInterfaceEffectPropagDelay=pimInterfaceEffectPropagDelay, pimInterfaceEffectOverrideIvl=pimInterfaceEffectOverrideIvl, pimInterfaceSuppressionEnabled=pimInterfaceSuppressionEnabled, pimInterfaceBidirCapable=pimInterfaceBidirCapable, pimInterfaceDomainBorder=pimInterfaceDomainBorder, pimInterfaceStubInterface=pimInterfaceStubInterface, pimInterfacePruneLimitInterval=pimInterfacePruneLimitInterval, pimInterfaceGraftRetryInterval=pimInterfaceGraftRetryInterval, pimInterfaceSRPriorityEnabled=pimInterfaceSRPriorityEnabled, pimInterfaceStatus=pimInterfaceStatus, pimInterfaceStorageType=pimInterfaceStorageType, pimNeighborTable=pimNeighborTable, pimNeighborEntry=pimNeighborEntry, pimNeighborIfIndex=pimNeighborIfIndex, pimNeighborAddressType=pimNeighborAddressType, pimNeighborAddress=pimNeighborAddress, pimNeighborGenerationIDPresent=pimNeighborGenerationIDPresent, pimNeighborGenerationIDValue=pimNeighborGenerationIDValue, pimNeighborUpTime=pimNeighborUpTime, pimNeighborExpiryTime=pimNeighborExpiryTime, pimNeighborDRPriorityPresent=pimNeighborDRPriorityPresent, pimNeighborDRPriority=pimNeighborDRPriority, pimNeighborLanPruneDelayPresent=pimNeighborLanPruneDelayPresent, pimNeighborTBit=pimNeighborTBit, pimNeighborPropagationDelay=pimNeighborPropagationDelay, pimNeighborOverrideInterval=pimNeighborOverrideInterval, pimNeighborBidirCapable=pimNeighborBidirCapable, pimNeighborSRCapable=pimNeighborSRCapable, pimNbrSecAddressTable=pimNbrSecAddressTable, pimNbrSecAddressEntry=pimNbrSecAddressEntry, pimNbrSecAddressIfIndex=pimNbrSecAddressIfIndex, pimNbrSecAddressType=pimNbrSecAddressType, pimNbrSecAddressPrimary=pimNbrSecAddressPrimary, pimNbrSecAddress=pimNbrSecAddress, pimStarGTable=pimStarGTable, pimStarGEntry=pimStarGEntry, pimStarGAddressType=pimStarGAddressType, pimStarGGrpAddress=pimStarGGrpAddress, pimStarGUpTime=pimStarGUpTime, pimStarGPimMode=pimStarGPimMode, pimStarGRPAddressType=pimStarGRPAddressType, pimStarGRPAddress=pimStarGRPAddress, pimStarGPimModeOrigin=pimStarGPimModeOrigin, pimStarGRPIsLocal=pimStarGRPIsLocal, pimStarGUpstreamJoinState=pimStarGUpstreamJoinState, pimStarGUpstreamJoinTimer=pimStarGUpstreamJoinTimer, pimStarGUpstreamNeighborType=pimStarGUpstreamNeighborType, pimStarGUpstreamNeighbor=pimStarGUpstreamNeighbor, pimStarGRPFIfIndex=pimStarGRPFIfIndex, pimStarGRPFNextHopType=pimStarGRPFNextHopType, pimStarGRPFNextHop=pimStarGRPFNextHop, pimStarGRPFRouteProtocol=pimStarGRPFRouteProtocol, pimStarGRPFRouteAddress=pimStarGRPFRouteAddress, pimStarGRPFRoutePrefixLength=pimStarGRPFRoutePrefixLength, pimStarGRPFRouteMetricPref=pimStarGRPFRouteMetricPref, pimStarGRPFRouteMetric=pimStarGRPFRouteMetric, pimStarGITable=pimStarGITable, pimStarGIEntry=pimStarGIEntry, pimStarGIIfIndex=pimStarGIIfIndex, pimStarGIUpTime=pimStarGIUpTime, pimStarGILocalMembership=pimStarGILocalMembership, pimStarGIJoinPruneState=pimStarGIJoinPruneState, pimStarGIPrunePendingTimer=pimStarGIPrunePendingTimer, pimStarGIJoinExpiryTimer=pimStarGIJoinExpiryTimer, pimStarGIAssertState=pimStarGIAssertState, pimStarGIAssertTimer=pimStarGIAssertTimer, pimStarGIAssertWinnerAddressType=pimStarGIAssertWinnerAddressType, pimStarGIAssertWinnerAddress=pimStarGIAssertWinnerAddress, pimStarGIAssertWinnerMetricPref=pimStarGIAssertWinnerMetricPref, pimStarGIAssertWinnerMetric=pimStarGIAssertWinnerMetric, pimSGTable=pimSGTable, pimSGEntry=pimSGEntry, pimSGAddressType=pimSGAddressType, pimSGGrpAddress=pimSGGrpAddress, pimSGSrcAddress=pimSGSrcAddress, pimSGUpTime=pimSGUpTime, pimSGPimMode=pimSGPimMode, pimSGUpstreamJoinState=pimSGUpstreamJoinState, pimSGUpstreamJoinTimer=pimSGUpstreamJoinTimer, pimSGUpstreamNeighbor=pimSGUpstreamNeighbor, pimSGRPFIfIndex=pimSGRPFIfIndex, pimSGRPFNextHopType=pimSGRPFNextHopType, pimSGRPFNextHop=pimSGRPFNextHop, pimSGRPFRouteProtocol=pimSGRPFRouteProtocol, pimSGRPFRouteAddress=pimSGRPFRouteAddress, pimSGRPFRoutePrefixLength=pimSGRPFRoutePrefixLength, pimSGRPFRouteMetricPref=pimSGRPFRouteMetricPref, pimSGRPFRouteMetric=pimSGRPFRouteMetric, pimSGSPTBit=pimSGSPTBit, pimSGKeepaliveTimer=pimSGKeepaliveTimer, pimSGDRRegisterState=pimSGDRRegisterState, pimSGDRRegisterStopTimer=pimSGDRRegisterStopTimer, pimSGRPRegisterPMBRAddressType=pimSGRPRegisterPMBRAddressType, pimSGRPRegisterPMBRAddress=pimSGRPRegisterPMBRAddress, pimSGUpstreamPruneState=pimSGUpstreamPruneState, pimSGUpstreamPruneLimitTimer=pimSGUpstreamPruneLimitTimer, pimSGOriginatorState=pimSGOriginatorState, pimSGSourceActiveTimer=pimSGSourceActiveTimer, pimSGStateRefreshTimer=pimSGStateRefreshTimer, pimSGITable=pimSGITable, pimSGIEntry=pimSGIEntry, pimSGIIfIndex=pimSGIIfIndex, pimSGIUpTime=pimSGIUpTime, pimSGILocalMembership=pimSGILocalMembership)
mibBuilder.exportSymbols("PIM-STD-MIB", pimSGIJoinPruneState=pimSGIJoinPruneState, pimSGIPrunePendingTimer=pimSGIPrunePendingTimer, pimSGIJoinExpiryTimer=pimSGIJoinExpiryTimer, pimSGIAssertState=pimSGIAssertState, pimSGIAssertTimer=pimSGIAssertTimer, pimSGIAssertWinnerAddressType=pimSGIAssertWinnerAddressType, pimSGIAssertWinnerAddress=pimSGIAssertWinnerAddress, pimSGIAssertWinnerMetricPref=pimSGIAssertWinnerMetricPref, pimSGIAssertWinnerMetric=pimSGIAssertWinnerMetric, pimSGRptTable=pimSGRptTable, pimSGRptEntry=pimSGRptEntry, pimSGRptSrcAddress=pimSGRptSrcAddress, pimSGRptUpTime=pimSGRptUpTime, pimSGRptUpstreamPruneState=pimSGRptUpstreamPruneState, pimSGRptUpstreamOverrideTimer=pimSGRptUpstreamOverrideTimer, pimSGRptITable=pimSGRptITable, pimSGRptIEntry=pimSGRptIEntry, pimSGRptIIfIndex=pimSGRptIIfIndex, pimSGRptIUpTime=pimSGRptIUpTime, pimSGRptILocalMembership=pimSGRptILocalMembership, pimSGRptIJoinPruneState=pimSGRptIJoinPruneState, pimSGRptIPrunePendingTimer=pimSGRptIPrunePendingTimer, pimSGRptIPruneExpiryTimer=pimSGRptIPruneExpiryTimer, pimBidirDFElectionTable=pimBidirDFElectionTable, pimBidirDFElectionEntry=pimBidirDFElectionEntry, pimBidirDFElectionAddressType=pimBidirDFElectionAddressType, pimBidirDFElectionRPAddress=pimBidirDFElectionRPAddress, pimBidirDFElectionIfIndex=pimBidirDFElectionIfIndex, pimBidirDFElectionWinnerAddressType=pimBidirDFElectionWinnerAddressType, pimBidirDFElectionWinnerAddress=pimBidirDFElectionWinnerAddress, pimBidirDFElectionWinnerUpTime=pimBidirDFElectionWinnerUpTime, pimBidirDFElectionWinnerMetricPref=pimBidirDFElectionWinnerMetricPref, pimBidirDFElectionWinnerMetric=pimBidirDFElectionWinnerMetric, pimBidirDFElectionState=pimBidirDFElectionState, pimBidirDFElectionStateTimer=pimBidirDFElectionStateTimer, pimStaticRPTable=pimStaticRPTable, pimStaticRPEntry=pimStaticRPEntry, pimStaticRPAddressType=pimStaticRPAddressType, pimStaticRPGrpAddress=pimStaticRPGrpAddress, pimStaticRPGrpPrefixLength=pimStaticRPGrpPrefixLength, pimStaticRPRPAddress=pimStaticRPRPAddress, pimStaticRPPimMode=pimStaticRPPimMode, pimStaticRPOverrideDynamic=pimStaticRPOverrideDynamic, pimStaticRPPrecedence=pimStaticRPPrecedence, pimStaticRPRowStatus=pimStaticRPRowStatus, pimStaticRPStorageType=pimStaticRPStorageType, pimAnycastRPSetTable=pimAnycastRPSetTable, pimAnycastRPSetEntry=pimAnycastRPSetEntry, pimAnycastRPSetAddressType=pimAnycastRPSetAddressType, pimAnycastRPSetAnycastAddress=pimAnycastRPSetAnycastAddress, pimAnycastRPSetRouterAddress=pimAnycastRPSetRouterAddress, pimAnycastRPSetLocalRouter=pimAnycastRPSetLocalRouter, pimAnycastRPSetRowStatus=pimAnycastRPSetRowStatus, pimAnycastRPSetStorageType=pimAnycastRPSetStorageType, pimGroupMappingTable=pimGroupMappingTable, pimGroupMappingEntry=pimGroupMappingEntry, pimGroupMappingOrigin=pimGroupMappingOrigin, pimGroupMappingAddressType=pimGroupMappingAddressType, pimGroupMappingGrpAddress=pimGroupMappingGrpAddress, pimGroupMappingGrpPrefixLength=pimGroupMappingGrpPrefixLength, pimGroupMappingRPAddressType=pimGroupMappingRPAddressType, pimGroupMappingRPAddress=pimGroupMappingRPAddress, pimGroupMappingPimMode=pimGroupMappingPimMode, pimGroupMappingPrecedence=pimGroupMappingPrecedence, pimKeepalivePeriod=pimKeepalivePeriod, pimRegisterSuppressionTime=pimRegisterSuppressionTime, pimStarGEntries=pimStarGEntries, pimStarGIEntries=pimStarGIEntries, pimSGEntries=pimSGEntries, pimSGIEntries=pimSGIEntries, pimSGRptEntries=pimSGRptEntries, pimSGRptIEntries=pimSGRptIEntries, pimOutAsserts=pimOutAsserts, pimInAsserts=pimInAsserts, pimLastAssertInterface=pimLastAssertInterface, pimLastAssertGroupAddressType=pimLastAssertGroupAddressType, pimLastAssertGroupAddress=pimLastAssertGroupAddress, pimLastAssertSourceAddressType=pimLastAssertSourceAddressType, pimLastAssertSourceAddress=pimLastAssertSourceAddress, pimNeighborLossNotificationPeriod=pimNeighborLossNotificationPeriod, pimNeighborLossCount=pimNeighborLossCount, pimInvalidRegisterNotificationPeriod=pimInvalidRegisterNotificationPeriod, pimInvalidRegisterMsgsRcvd=pimInvalidRegisterMsgsRcvd, pimInvalidRegisterAddressType=pimInvalidRegisterAddressType, pimInvalidRegisterOrigin=pimInvalidRegisterOrigin, pimInvalidRegisterGroup=pimInvalidRegisterGroup, pimInvalidRegisterRp=pimInvalidRegisterRp, pimInvalidJoinPruneNotificationPeriod=pimInvalidJoinPruneNotificationPeriod, pimInvalidJoinPruneMsgsRcvd=pimInvalidJoinPruneMsgsRcvd, pimInvalidJoinPruneAddressType=pimInvalidJoinPruneAddressType, pimInvalidJoinPruneOrigin=pimInvalidJoinPruneOrigin, pimInvalidJoinPruneGroup=pimInvalidJoinPruneGroup, pimInvalidJoinPruneRp=pimInvalidJoinPruneRp, pimRPMappingNotificationPeriod=pimRPMappingNotificationPeriod, pimRPMappingChangeCount=pimRPMappingChangeCount, pimInterfaceElectionNotificationPeriod=pimInterfaceElectionNotificationPeriod, pimInterfaceElectionWinCount=pimInterfaceElectionWinCount, pimRefreshInterval=pimRefreshInterval, pimDeviceConfigStorageType=pimDeviceConfigStorageType, pimMIBConformance=pimMIBConformance, pimMIBCompliances=pimMIBCompliances, pimMIBGroups=pimMIBGroups)

# Notifications
mibBuilder.exportSymbols("PIM-STD-MIB", pimNeighborLoss=pimNeighborLoss, pimInvalidRegister=pimInvalidRegister, pimInvalidJoinPrune=pimInvalidJoinPrune, pimRPMappingChange=pimRPMappingChange, pimInterfaceElection=pimInterfaceElection)

# Groups
mibBuilder.exportSymbols("PIM-STD-MIB", pimTopologyGroup=pimTopologyGroup, pimNotificationGroup=pimNotificationGroup, pimTuningParametersGroup=pimTuningParametersGroup, pimRouterStatisticsGroup=pimRouterStatisticsGroup, pimSsmGroup=pimSsmGroup, pimRPConfigGroup=pimRPConfigGroup, pimSmGroup=pimSmGroup, pimBidirGroup=pimBidirGroup, pimAnycastRpGroup=pimAnycastRpGroup, pimStaticRPPrecedenceGroup=pimStaticRPPrecedenceGroup, pimNetMgmtNotificationObjects=pimNetMgmtNotificationObjects, pimNetMgmtNotificationGroup=pimNetMgmtNotificationGroup, pimDiagnosticsGroup=pimDiagnosticsGroup, pimDmGroup=pimDmGroup, pimDeviceStorageGroup=pimDeviceStorageGroup)

# Compliances
mibBuilder.exportSymbols("PIM-STD-MIB", pimMIBComplianceAsm=pimMIBComplianceAsm, pimMIBComplianceBidir=pimMIBComplianceBidir, pimMIBComplianceSsm=pimMIBComplianceSsm, pimMIBComplianceDm=pimMIBComplianceDm)
