# PySNMP SMI module. Autogenerated from smidump -f python POLICY-BASED-MANAGEMENT-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:00 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, RowPointer, RowStatus, StorageType, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowPointer", "RowStatus", "StorageType", "TextualConvention")

# Types

class PmUTF8String(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,65535)
    

# Objects

pmMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 124)).setRevisions(("2005-02-07 00:00",))
if mibBuilder.loadTexts: pmMib.setOrganization("IETF SNMP Configuration Working Group")
if mibBuilder.loadTexts: pmMib.setContactInfo("\n\n\n\n\nSteve Waldbusser\nPhone: +1-650-948-6500\nFax:   +1-650-745-0671\nEmail: waldbusser@nextbeacon.com\n\nJon Saperia (WG Co-chair)\nJDS Consulting, Inc.\n84 Kettell Plain Road.\nStow MA 01775\nUSA\nPhone: +1-978-461-0249\nFax:   +1-617-249-0874\nEmail: saperia@jdscons.com\n\nThippanna Hongal\nRiverstone Networks, Inc.\n5200 Great America Parkway\nSanta Clara, CA, 95054\nUSA\n\nPhone: +1-408-878-6562\nFax:   +1-408-878-6501\nEmail: hongal@riverstonenet.com\n\nDavid Partain (WG Co-chair)\nPostal: Ericsson AB\n        P.O. Box 1248\n        SE-581 12 Linkoping\n        Sweden\nTel: +46 13 28 41 44\nE-mail: David.Partain@ericsson.com\n\nAny questions or comments about this document can also be\ndirected to the working group at snmpconf@snmp.com.")
if mibBuilder.loadTexts: pmMib.setDescription("The MIB module for policy-based configuration of SNMP\ninfrastructures.\n\nCopyright (C) The Internet Society (2005).  This version of\nthis MIB module is part of RFC 4011; see the RFC itself for\nfull legal notices.")
pmNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 0))
pmPolicyTable = MibTable((1, 3, 6, 1, 2, 1, 124, 1))
if mibBuilder.loadTexts: pmPolicyTable.setDescription("The policy table.  A policy is a pairing of a\npolicyCondition and a policyAction that is used to apply the\naction to a selected set of elements.")
pmPolicyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 1, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAdminGroup"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"))
if mibBuilder.loadTexts: pmPolicyEntry.setDescription("An entry in the policy table representing one policy.")
pmPolicyAdminGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 1), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmPolicyAdminGroup.setDescription("An administratively assigned string that can be used to group\npolicies for convenience, for readability, or to simplify\nconfiguration of access control.\n\nThe value of this string does not affect policy processing in\nany way.  If grouping is not desired or necessary, this object\nmay be set to a zero-length string.")
pmPolicyIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmPolicyIndex.setDescription("A unique index for this policy entry, unique among all\npolicies regardless of administrative group.")
pmPolicyPrecedenceGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 3), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyPrecedenceGroup.setDescription("An administratively assigned string that is used to group\npolicies.  For each element, only one policy in the same\nprecedence group may be active on that element.  If multiple\npolicies would be active on an element (because their\nconditions return non-zero), the execution environment will\nonly allow the policy with the highest value of\npmPolicyPrecedence to be active.\n\nAll values of this object must have been successfully\ntransformed by Stringprep RFC 3454.  Management stations\nmust perform this translation and must only set this object to\nstring values that have been transformed.")
pmPolicyPrecedence = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyPrecedence.setDescription("If, while checking to see which policy conditions match an\nelement, 2 or more ready policies in the same precedence group\nmatch the same element, the pmPolicyPrecedence object provides\nthe rule to arbitrate which single policy will be active on\n'this element'.  Of policies in the same precedence group, only\nthe ready and matching policy with the highest precedence\nvalue (e.g., 2 is higher than 1) will have its policy action\nperiodically executed on 'this element'.\n\nWhen a policy is active on an element but the condition ceases\nto match the element, its action (if currently running) will\nbe allowed to finish and then the condition-matching ready\npolicy with the next-highest precedence will immediately\nbecome active (and have its action run immediately).  If the\ncondition of a higher-precedence ready policy suddenly begins\nmatching an element, the previously-active policy's action (if\ncurrently running) will be allowed to finish and then the\nhigher precedence policy will immediately become active.  Its\naction will run immediately, and any lower-precedence matching\npolicy will not be active anymore.\n\nIn the case where multiple ready policies share the highest\nvalue, it is an implementation-dependent matter as to which\nsingle policy action will be chosen.\n\nNote that if it is necessary to take certain actions after a\npolicy is no longer active on an element, these actions should\nbe included in a lower-precedence policy that is in the same\nprecedence group.")
pmPolicySchedule = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicySchedule.setDescription("This policy will be ready if any of the associated schedule\nentries are active.\n\nIf the value of this object is 0, this policy is always\nready.\n\nIf the value of this object is non-zero but doesn't\nrefer to a schedule group that includes an active schedule,\nthen the policy will not be ready, even if this is due to a\nmisconfiguration of this object or the pmSchedTable.")
pmPolicyElementTypeFilter = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 6), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyElementTypeFilter.setDescription("This object specifies the element types for which this policy\ncan be executed.\n\nThe format of this object will be a sequence of\npmElementTypeRegOIDPrefix values, encoded in the following\nBNF form:\n\nelementTypeFilter:   oid [ ';' oid ]*\n              oid:   subid [ '.' subid ]*\n            subid:   '0' | decimal_constant\n\nFor example, to register for the policy to be run on all\ninterface elements, the 'ifEntry' element type will be\nregistered as '1.3.6.1.2.1.2.2.1'.\n\nIf a value is included that does not represent a registered\npmElementTypeRegOIDPrefix, then that value will be ignored.")
pmPolicyConditionScriptIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyConditionScriptIndex.setDescription("A pointer to the row or rows in the pmPolicyCodeTable that\ncontain the condition code for this policy.  When a policy\nentry is created, a pmPolicyCodeIndex value unused by this\npolicy's adminGroup will be assigned to this object.\n\nA policy condition is one or more PolicyScript statements\nthat result(s) in a boolean value that represents whether\nan element is a member of a set of elements upon which an\naction is to be performed.  If a policy is ready and the\ncondition returns true for an element of a proper element\ntype, and if no higher-precedence policy should be active,\nthen the policy is active on that element.\n\nCondition evaluation stops immediately when any run-time\nexception is detected, and the policyAction is not executed.\n\nThe policyCondition is evaluated for various elements.  Any\nelement for which the policyCondition returns any nonzero value\nwill match the condition and will have the associated\n\n\n\npolicyAction executed on that element unless a\nhigher-precedence policy in the same precedence group also\nmatches 'this element'.\n\nIf the condition object is empty (contains no code) or\notherwise does not return a value, the element will not be\nmatched.\n\nWhen this condition is executed, if SNMP requests are made to\nthe local system and secModel/secName/secLevel aren't\nspecified, access to objects is under the security\ncredentials of the requester who most recently modified the\nassociated pmPolicyAdminStatus object.  If SNMP requests are\nmade in which secModel/secName/secLevel are specified, then\nthe specified credentials are retrieved from the local\nconfiguration datastore only if VACM is configured to\nallow access to the requester who most recently modified the\nassociated pmPolicyAdminStatus object.  See the Security\nConsiderations section for more information.")
pmPolicyActionScriptIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyActionScriptIndex.setDescription("A pointer to the row or rows in the pmPolicyCodeTable that\ncontain the action code for this policy.  When a policy entry\nis created, a pmPolicyCodeIndex value unused by this policy's\nadminGroup will be assigned to this object.\n\nA PolicyAction is an operation performed on a\nset of elements for which the policy is active.\n\nAction evaluation stops immediately when any run-time\nexception is detected.\n\nWhen this condition is executed, if SNMP requests are made to\nthe local system and secModel/secName/secLevel aren't\nspecified, access to objects is under the security\ncredentials of the requester who most recently modified the\nassociated pmPolicyAdminStatus object.  If SNMP requests are\nmade in which secModel/secName/secLevel are specified, then\nthe specified credentials are retrieved from the local\nconfiguration datastore only if VACM is configured to\nallow access to the requester who most recently modified the\nassociated pmPolicyAdminStatus object.  See the Security\nConsiderations section for more information.")
pmPolicyParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 9), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyParameters.setDescription("From time to time, policy scripts may seek one or more\nparameters (e.g., site-specific constants).  These parameters\nmay be installed with the script in this object and are\naccessible to the script via the getParameters() function.  If\nit is necessary for multiple parameters to be passed to the\nscript, the script can choose whatever encoding/delimiting\nmechanism is most appropriate.")
pmPolicyConditionMaxLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyConditionMaxLatency.setDescription("Every element under the control of this agent is\nre-checked periodically to see whether it is under control\nof this policy by re-running the condition for this policy.\nThis object lets the manager control the maximum amount of\ntime that may pass before an element is re-checked.\n\nIn other words, in any given interval of this duration, all\nelements must be re-checked.  Note that how the policy agent\nschedules the checking of various elements within this\ninterval is an implementation-dependent matter.\nImplementations may wish to re-run a condition more\nquickly if they note a change to the role strings for an\nelement.")
pmPolicyActionMaxLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyActionMaxLatency.setDescription("Every element that matches this policy's condition and is\ntherefore under control of this policy will have this policy's\naction executed periodically to ensure that the element\nremains in the state dictated by the policy.\nThis object lets the manager control the maximum amount of\n\n\n\ntime that may pass before an element has the action run on\nit.\n\nIn other words, in any given interval of this duration, all\nelements under control of this policy must have the action run\non them.  Note that how the policy agent schedules the policy\naction on various elements within this interval is an\nimplementation-dependent matter.")
pmPolicyMaxIterations = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 12), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyMaxIterations.setDescription("If a condition or action script iterates in loops too many\ntimes in one invocation, the execution environment may\nconsider it in an infinite loop or otherwise not acting\nas intended and may be terminated by the execution\nenvironment.  The execution environment will count the\ncumulative number of times all 'for' or 'while' loops iterated\nand will apply a threshold to determine when to terminate the\nscript.  What threshold the execution environment uses is an\nimplementation-dependent manner, but the value of\nthis object SHOULD be the basis for choosing the threshold for\neach script.  The value of this object represents a\npolicy-specific threshold and can be tuned for policies of\nvarying workloads.  If this value is zero, no\nthreshold will be enforced except for any\nimplementation-dependent maximum.  Regardless of this value,\nthe agent is allowed to terminate any script invocation that\nexceeds a local CPU or memory limitation.\n\nNote that the condition and action invocations are tracked\nseparately.")
pmPolicyDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 13), PmUTF8String()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyDescription.setDescription("A description of this rule and its significance, typically\nprovided by a human.")
pmPolicyMatches = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyMatches.setDescription("The number of elements that, in their most recent execution\nof the associated condition, were matched by the condition.")
pmPolicyAbnormalTerminations = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyAbnormalTerminations.setDescription("The number of elements that, in their most recent execution\nof the associated condition or action, have experienced a\nrun-time exception and terminated abnormally.  Note that if a\npolicy was experiencing a run-time exception while processing\na particular element but runs normally on a subsequent\ninvocation, this number can decline.")
pmPolicyExecutionErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmPolicyExecutionErrors.setDescription("The total number of times that execution of this policy's\ncondition or action has been terminated due to run-time\nexceptions.")
pmPolicyDebugging = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("off", 1), ("on", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyDebugging.setDescription("The status of debugging for this policy.  If this is turned\non(2), log entries will be created in the pmDebuggingTable\nfor each run-time exception that is experienced by this\npolicy.")
pmPolicyAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 18), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("enabled", 2), ("enabledAutoRemove", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyAdminStatus.setDescription("The administrative status of this policy.\n\nThe policy will be valid only if the associated\npmPolicyRowStatus is set to active(1) and this object is set\nto enabled(2) or enabledAutoRemove(3).\n\nIf this object is set to enabledAutoRemove(3), the next time\nthe associated schedule moves from the active state to the\ninactive state, this policy will immediately be deleted,\nincluding any associated entries in the pmPolicyCodeTable.\n\nThe following related objects may not be changed unless this\nobject is set to disabled(1):\n    pmPolicyPrecedenceGroup, pmPolicyPrecedence,\n    pmPolicySchedule, pmPolicyElementTypeFilter,\n    pmPolicyConditionScriptIndex, pmPolicyActionScriptIndex,\n    pmPolicyParameters, and any pmPolicyCodeTable row\n    referenced by this policy.\nIn order to change any of these parameters, the policy must\nbe moved to the disabled(1) state, changed, and then\nre-enabled.\n\nWhen this policy moves to either enabled state from the\ndisabled state, any cached values of policy condition must be\nerased, and any Policy or PolicyElement scratchpad values for\nthis policy should be removed.  Policy execution will begin by\ntesting the policy condition on all appropriate elements.")
pmPolicyStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 19), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyStorageType.setDescription("This object defines whether this policy and any associated\nentries in the pmPolicyCodeTable are kept in volatile storage\nand lost upon reboot or if this row is backed up by\nnon-volatile or permanent storage.\n\n\n\n\nIf the value of this object is 'permanent', the values for\nthe associated pmPolicyAdminStatus object must remain\nwritable.")
pmPolicyRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 1, 1, 20), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyRowStatus.setDescription("The row status of this pmPolicyEntry.\n\nThe status may not be set to active if any of the related\nentries in the pmPolicyCode table do not have a status of\nactive or if any of the objects in this row are not set to\nvalid values.  Only the following objects may be modified\nwhile in the active state:\n    pmPolicyParameters\n    pmPolicyConditionMaxLatency\n    pmPolicyActionMaxLatency\n    pmPolicyDebugging\n    pmPolicyAdminStatus\n\nIf this row is deleted, any associated entries in the\npmPolicyCodeTable will be deleted as well.")
pmPolicyCodeTable = MibTable((1, 3, 6, 1, 2, 1, 124, 2))
if mibBuilder.loadTexts: pmPolicyCodeTable.setDescription("The pmPolicyCodeTable stores the code for policy conditions and\nactions.\n\nAn example of the relationships between the code table and the\npolicy table follows:\n\npmPolicyTable\n    AdminGroup  Index   ConditionScriptIndex  ActionScriptIndex\nA   ''          1       1                     2\nB   'oper'      1       1                     2\nC   'oper'      2       3                     4\n\npmPolicyCodeTable\nAdminGroup  ScriptIndex  Segment    Note\n\n\n\n''          1            1          Filter for policy A\n''          2            1          Action for policy A\n'oper'      1            1          Filter for policy B\n'oper'      2            1          Action 1/2 for policy B\n'oper'      2            2          Action 2/2 for policy B\n'oper'      3            1          Filter for policy C\n'oper'      4            1          Action for policy C\n\nIn this example, there are 3 policies: 1 in the '' adminGroup,\nand 2 in the 'oper' adminGroup.  Policy A has been assigned\nscript indexes 1 and 2 (these script indexes are assigned out of\na separate pool per adminGroup), with 1 code segment each for\nthe filter and the action.  Policy B has been assigned script\nindexes 1 and 2 (out of the pool for the 'oper' adminGroup).\nWhile the filter has 1 segment, the action is longer and is\nloaded into 2 segments.  Finally, Policy C has been assigned\nscript indexes 3 and 4, with 1 code segment each for the filter\nand the action.")
pmPolicyCodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 2, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAdminGroup"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeScriptIndex"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeSegment"))
if mibBuilder.loadTexts: pmPolicyCodeEntry.setDescription("An entry in the policy code table representing one code\nsegment.  Entries that share a common AdminGroup/ScriptIndex\npair make up a single script.  Valid values of ScriptIndex are\nretrieved from pmPolicyConditionScriptIndex and\npmPolicyActionScriptIndex after a pmPolicyEntry is\ncreated.  Segments of code can then be written to this table\nwith the learned ScriptIndex values.\n\nThe StorageType of this entry is determined by the value of\nthe associated pmPolicyStorageType.\n\nThe pmPolicyAdminGroup element of the index represents the\nadministrative group of the policy of which this code entry is\na part.")
pmPolicyCodeScriptIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmPolicyCodeScriptIndex.setDescription("A unique index for each policy condition or action.  The code\nfor each such condition or action may be composed of multiple\nentries in this table if the code cannot fit in one entry.\nValues of pmPolicyCodeScriptIndex may not be used unless\nthey have previously been assigned in the\npmPolicyConditionScriptIndex or pmPolicyActionScriptIndex\nobjects.")
pmPolicyCodeSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmPolicyCodeSegment.setDescription("A unique index for each segment of a policy condition or\naction.\n\nWhen a policy condition or action spans multiple entries in\nthis table, the code of that policy starts from the\nlowest-numbered segment and continues with increasing segment\nvalues until it ends with the highest-numbered segment.")
pmPolicyCodeText = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 3), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1024))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyCodeText.setDescription("A segment of policy code (condition or action).  Lengthy\nPolicy conditions or actions may be stored in multiple\nsegments in this table that share the same value of\npmPolicyCodeScriptIndex.  When multiple segments are used, it\nis recommended that each segment be as large as is practical.\n\nEntries in this table are associated with policies by values\nof the pmPolicyConditionScriptIndex and\npmPolicyActionScriptIndex objects.  If the status of the\nrelated policy is active, then this object may not be\nmodified.")
pmPolicyCodeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmPolicyCodeStatus.setDescription("The status of this code entry.\n\nEntries in this table are associated with policies by values\nof the pmPolicyConditionScriptIndex and\npmPolicyActionScriptIndex objects.  If the status of the\nrelated policy is active, then this object can not be\nmodified (i.e., deleted or set to notInService), nor may new\nentries be created.\n\nIf the status of this object is active, no objects in this\nrow may be modified.")
pmElementTypeRegTable = MibTable((1, 3, 6, 1, 2, 1, 124, 3))
if mibBuilder.loadTexts: pmElementTypeRegTable.setDescription("A registration table for element types managed by this\nsystem.\n\nThe Element Type Registration table allows the manager to\nlearn what element types are being managed by the system and\nto register new types, if necessary.  An element type is\nregistered by providing the OID of an SNMP object (i.e.,\nwithout the instance).  Each SNMP instance that exists under\nthat object is a distinct element.  The index of the element is\nthe index part of the discovered OID.  This index will be\nsupplied to policy conditions and actions so that this code\ncan inspect and configure the element.\n\nFor example, this table might contain the following entries.\nThe first three are agent-installed, and the 4th was\ndownloaded by a management station:\n\nOIDPrefix        MaxLatency  Description               StorageType\nifEntry          100 mS      interfaces - builtin      readOnly\n0.0              100 mS      system element - builtin  readOnly\nfrCircuitEntry   100 mS      FR Circuits - builtin     readOnly\nhrSWRunEntry     60 sec      Running Processes         volatile\n\n\n\n\nNote that agents may automatically configure elements in this\ntable for frequently used element types (interfaces, circuits,\netc.).  In particular, it may configure elements for whom\ndiscovery is optimized in one or both of the following ways:\n\n1. The agent may discover elements by scanning internal data\n   structures as opposed to issuing local SNMP requests.  It is\n   possible to recreate the exact semantics described in this\n   table even if local SNMP requests are not issued.\n\n2. The agent may receive asynchronous notification of new\n   elements (for example, 'card inserted') and use that\n   information to instantly create elements rather than\n   through polling.  A similar feature might be available for\n   the deletion of elements.\n\nNote that the disposition of agent-installed entries is\ndescribed by the pmPolicyStorageType object.")
pmElementTypeRegEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 3, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegOIDPrefix"))
if mibBuilder.loadTexts: pmElementTypeRegEntry.setDescription("A registration of an element type.\n\nNote that some values of this table's index may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP protocol.\nImplementations should take care to avoid such values.")
pmElementTypeRegOIDPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 2), ObjectIdentifier()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmElementTypeRegOIDPrefix.setDescription("This OBJECT IDENTIFIER value identifies a table in which all\n\n\n\nelements of this type will be found.  Every row in the\nreferenced table will be treated as an element for the\nperiod of time that it remains in the table.  The agent will\nthen execute policy conditions and actions as appropriate on\neach of these elements.\n\nThis object identifier value is specified down to the 'entry'\ncomponent (e.g., ifEntry) of the identifier.\n\nThe index of each discovered row will be passed to each\ninvocation of the policy condition and policy action.\n\nThe actual mechanism by which instances are discovered is\nimplementation dependent.  Periodic walks of the table to\ndiscover the rows in the table is one such mechanism.  This\nmechanism has the advantage that it can be performed by an\nagent with no knowledge of the names, syntax, or semantics\nof the MIB objects in the table.  This mechanism also serves as\nthe reference design.  Other implementation-dependent\nmechanisms may be implemented that are more efficient (perhaps\nbecause they are hard coded) or that don't require polling.\nThese mechanisms must discover the same elements as would the\ntable-walking reference design.\n\nThis object can contain a OBJECT IDENTIFIER, '0.0'.\n'0.0' represents the single instance of the system\nitself and provides an execution context for policies to\noperate on the 'system element' and on MIB objects\nmodeled as scalars.  For example, '0.0' gives an execution\ncontext for policy-based selection of the operating system\ncode version (likely modeled as a scalar MIB object).  The\nelement type '0.0' always exists; as a consequence, no actual\ndiscovery will take place, and the pmElementTypeRegMaxLatency\nobject will have no effect for the '0.0' element\ntype.  However, if the '0.0' element type is not registered in\nthe table, policies will not be executed on the '0.0' element.\n\nWhen a policy is invoked on behalf of a '0.0' entry in this\ntable, the element name will be '0.0', and there is no index\nof 'this element' (in other words, it has zero length).\n\nAs this object is used in the index for the\npmElementTypeRegTable, users of this table should be careful\nnot to create entries that would result in instance names with\nmore than 128 sub-identifiers.")
pmElementTypeRegMaxLatency = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 3), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegMaxLatency.setDescription("The PM agent is responsible for discovering new elements of\ntypes that are registered.  This object lets the manager\ncontrol the maximum amount of time that may pass between the\ntime an element is created and when it is discovered.\n\nIn other words, in any given interval of this duration, all\nnew elements must be discovered.  Note that how the policy\nagent schedules the checking of various elements within this\ninterval is an implementation-dependent matter.")
pmElementTypeRegDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 4), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegDescription.setDescription("A descriptive label for this registered type.")
pmElementTypeRegStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 5), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegStorageType.setDescription("This object defines whether this row is kept\nin volatile storage and lost upon reboot or\nbacked up by non-volatile or permanent storage.\n\nIf the value of this object is 'permanent', no values in the\nassociated row have to be writable.")
pmElementTypeRegRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmElementTypeRegRowStatus.setDescription("The status of this registration entry.\n\nIf the value of this object is active, no objects in this row\nmay be modified.")
pmRoleTable = MibTable((1, 3, 6, 1, 2, 1, 124, 4))
if mibBuilder.loadTexts: pmRoleTable.setDescription("The pmRoleTable is a read-create table that organizes role\nstrings sorted by element.  This table is used to create and\nmodify role strings and their associations, as well as to allow\na management station to learn about the existence of roles and\ntheir associations.\n\nIt is the responsibility of the agent to keep track of any\nre-indexing of the underlying SNMP elements and to continue to\nassociate role strings with the element with which they were\ninitially configured.\n\nPolicy MIB agents that have elements in multiple local SNMP\ncontexts have to allow some roles to be assigned to elements\nin particular contexts.  This is particularly true when some\nelements have the same names in different contexts and the\ncontext is required to disambiguate them.  In those situations,\na value for the pmRoleContextName may be provided.  When a\npmRoleContextName value is not provided, the assignment is to\nthe element in the default context.\n\nPolicy MIB agents that discover elements on other systems and\nexecute policies on their behalf need to have access to role\ninformation for these remote elements.  In such situations,\nrole assignments for other systems can be stored in this table\nby providing values for the pmRoleContextEngineID parameters.\n\nFor example:\nExample:\nelement       role    context ctxEngineID   #comment\nifindex.1     gold                          local, default context\nifindex.2     gold                          local, default context\nrepeaterid.1  foo     rptr1                 local, rptr1 context\nrepeaterid.1  bar     rptr2                 local, rptr2 context\nifindex.1     gold    ''      A             different system\nifindex.1     gold    ''      B             different system\n\n The agent must store role string associations in non-volatile\n storage.")
pmRoleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 4, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleContextEngineID"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmRoleString"))
if mibBuilder.loadTexts: pmRoleEntry.setDescription("A role string entry associates a role string with an\nindividual element.\n\nNote that some combinations of index values may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP\nprotocol.  Implementations should take care to avoid such\ncombinations.")
pmRoleElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 1), RowPointer()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmRoleElement.setDescription("The element with which this role string is associated.\n\nFor example, if the element is interface 3, then this object\nwill contain the OID for 'ifIndex.3'.\n\nIf the agent assigns new indexes in the MIB table to\nrepresent the same underlying element (re-indexing), the\nagent will modify this value to contain the new index for the\nunderlying element.\n\nAs this object is used in the index for the pmRoleTable,\nusers of this table should be careful not to create entries\nthat would result in instance names with more than 128\nsub-identifiers.")
pmRoleContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmRoleContextName.setDescription("If the associated element is not in the default SNMP context\nfor the target system, this object is used to identify the\ncontext.  If the element is in the default context, this object\nis equal to the empty string.")
pmRoleContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 3), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(5,32),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmRoleContextEngineID.setDescription("If the associated element is on a remote system, this object\nis used to identify the remote system.  This object contains\nthe contextEngineID of the system for which this role string\nassignment is valid.  If the element is on the local system\nthis object will be the empty string.")
pmRoleString = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 4), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmRoleString.setDescription("The role string that is associated with an element through\nthis table.  All role strings must have been successfully\ntransformed by Stringprep RFC 3454.  Management stations\nmust perform this translation and must only set this object\nto string values that have been transformed.\n\nA role string is an administratively specified characteristic\nof a managed element (for example, an interface).  It is a\nselector for policy rules, that determines the applicability of\nthe rule to a particular managed element.")
pmRoleStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 4, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmRoleStatus.setDescription("The status of this role string.\n\n\n\n\n\nIf the value of this object is active, no object in this row\nmay be modified.")
pmCapabilitiesTable = MibTable((1, 3, 6, 1, 2, 1, 124, 5))
if mibBuilder.loadTexts: pmCapabilitiesTable.setDescription("The pmCapabilitiesTable contains a description of\nthe inherent capabilities of the system so that\nmanagement stations can learn of an agent's capabilities and\ndifferentially install policies based on the capabilities.\n\nCapabilities are expressed at the system level.  There can be\nvariation in how capabilities are realized from one vendor or\nmodel to the next.  Management systems should consider these\ndifferences before selecting which policy to install in a\nsystem.")
pmCapabilitiesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 5, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesType"))
if mibBuilder.loadTexts: pmCapabilitiesEntry.setDescription("A capabilities entry holds an OID indicating support for a\nparticular capability.  Capabilities may include hardware and\nsoftware functions and the implementation of MIB\nModules.  The semantics of the OID are defined in the\ndescription of pmCapabilitiesType.\n\nEntries appear in this table if any element in the system has\na specific capability.  A capability should appear in this\ntable only once, regardless of the number of elements in the\nsystem with that capability.  An entry is removed from this\ntable when the last element in the system that has the\ncapability is removed.  In some cases, capabilities are\ndynamic and exist only in software.  This table should have an\nentry for the capability even if there are no current\ninstances.  Examples include systems with database or WEB\nservices.  While the system has the ability to create new\ndatabases or WEB services, the entry should exist.  In these\ncases, the ability to create these services could come from\nother processes that are running in the system, even though\nthere are no currently open databases or WEB servers running.\n\n\n\nCapabilities may include the implementation of MIB Modules\nbut need not be limited to those that represent MIB Modules\nwith one or more configurable objects.  It may also be\nvaluable to include entries for capabilities that do not\ninclude configuration objects, as that information, in\ncombination with other entries in this table, might be used\nby the management software to determine whether to\ninstall a policy.\n\nVendor software may also add entries in this table to express\ncapabilities from their private branch.\n\nNote that some values of this table's index may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP\nprotocol.  Implementations should take care to avoid such\nvalues.")
pmCapabilitiesType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 5, 1, 1), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmCapabilitiesType.setDescription("There are three types of OIDs that may be present in the\npmCapabilitiesType object:\n\n1) The OID of a MODULE-COMPLIANCE macro that represents the\nhighest level of compliance realized by the agent for that\nMIB Module.  For example, an agent that implements the OSPF\nMIB Module at the highest level of compliance would have the\nvalue of '1.3.6.1.2.1.14.15.2' in the pmCapabilitiesType\nobject.  For software that realizes standard MIB\nModules that do not have compliance statements, the base OID\nof the MIB Module should be used instead.  If the OSPF MIB\nModule had not been created with a compliance statement, then\nthe correct value of the pmCapabilitiesType would be\n'1.3.6.1.2.1.14'.  In the cases where multiple compliance\nstatements in a MIB Module are supported by the agent, and\nwhere one compliance statement does not by definition include\nthe other, each of the compliance OIDs would have entries in\nthis table.\n\n\n\n\nMIB Documents can contain more than one MIB Module.  In the\ncase of OSPF, there is a second MIB Module\nthat describes notifications for the OSPF Version 2 Protocol.\nIf the agent also realizes these functions, an entry will\nalso exist for those capabilities in this table.\n\n2) Vendors should install OIDs in this table that represent\nvendor-specific capabilities.  These capabilities can be\nexpressed just as those described above for MIB Modules on\nthe standards track.  In addition, vendors may install any\nOID they desire from their registered branch.  The OIDs may be\nat any level of granularity, from the root of their entire\nbranch to an instance of a single OID.  There is no\nrestriction on the number of registrations they may make,\nthough care should be taken to avoid unnecessary entries.\n\n3) OIDs that represent one capability or a collection of\ncapabilities that could be any collection of MIB Objects or\nhardware or software functions may be created in working\ngroups and registered in a MIB Module.  Other entities (e.g.,\nvendors) may also make registrations.  Software will register\nthese standard capability OIDs, as well as vendor specific\nOIDs.\n\nIf the OID for a known capability is not present in the\ntable, then it should be assumed that the capability is not\nimplemented.\n\nAs this object is used in the index for the\npmCapabilitiesTable, users of this table should be careful\nnot to create entries that would result in instance names\nwith more than 128 sub-identifiers.")
pmCapabilitiesOverrideTable = MibTable((1, 3, 6, 1, 2, 1, 124, 6))
if mibBuilder.loadTexts: pmCapabilitiesOverrideTable.setDescription("The pmCapabilitiesOverrideTable allows management stations\nto override pmCapabilitiesTable entries that have been\nregistered by the agent.  This facility can be used to avoid\nsituations in which managers in the network send policies to\na system that has advertised a capability in the\npmCapabilitiesTable but that should not be installed on this\nparticular system.  One example could be newly deployed\n\n\n\nequipment that is still in a trial state in a trial state or\nresources reserved for some other administrative reason.\nThis table can also be used to override entries in the\npmCapabilitiesTable through the use of the\npmCapabilitiesOverrideState object.  Capabilities can also be\ndeclared available in this table that were not registered in\nthe pmCapabilitiesTable.  A management application can make\nan entry in this table for any valid OID and declare the\ncapability available by setting the\npmCapabilitiesOverrideState for that row to valid(1).")
pmCapabilitiesOverrideEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 6, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesOverrideType"))
if mibBuilder.loadTexts: pmCapabilitiesOverrideEntry.setDescription("An entry in this table indicates whether a particular\ncapability is valid or invalid.\n\nNote that some values of this table's index may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP\nprotocol.  Implementations should take care to avoid such\nvalues.")
pmCapabilitiesOverrideType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 6, 1, 1), ObjectIdentifier()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmCapabilitiesOverrideType.setDescription("This is the OID of the capability that is declared valid or\ninvalid by the pmCapabilitiesOverrideState value for this\nrow.  Any valid OID, as described in the pmCapabilitiesTable,\nis permitted in the pmCapabilitiesOverrideType object.  This\nmeans that capabilities can be expressed at any level, from a\nspecific instance of an object to a table or entire module.\nThere are no restrictions on whether these objects are from\nstandards track MIB documents or in the private branch of the\nMIB.\n\n\n\nIf an entry exists in this table for which there is a\ncorresponding entry in the pmCapabilitiesTable, then this entry\nshall have precedence over the entry in the\npmCapabilitiesTable.  All entries in this table must be\npreserved across reboots.\n\nAs this object is used in the index for the\npmCapabilitiesOverrideTable, users of this table should be\ncareful not to create entries that would result in instance\nnames with more than 128 sub-identifiers.")
pmCapabilitiesOverrideState = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 6, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("invalid", 1), ("valid", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmCapabilitiesOverrideState.setDescription("A pmCapabilitiesOverrideState of invalid indicates that\nmanagement software should not send policies to this system\nfor the capability identified in the\npmCapabilitiesOverrideType for this row of the table.  This\nbehavior is the same whether the capability represented by\nthe pmCapabilitiesOverrideType exists only in this table\n(that is, it was installed by an external management\napplication) or exists in this table as well as the\npmCapabilitiesTable.  This would be the case when a manager\nwanted to disable a capability that the native management\nsystem found and registered in the pmCapabilitiesTable.\n\nAn entry in this table that has a pmCapabilitiesOverrideState\nof valid should be treated as though it appeared in the\npmCapabilitiesTable.  If the entry also exists in the\npmCapabilitiesTable in the pmCapabilitiesType object, and if\nthe value of this object is valid, then the system shall\noperate as though this entry did not exist and policy\ninstallations and executions will continue in a normal\nfashion.")
pmCapabilitiesOverrideRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 6, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmCapabilitiesOverrideRowStatus.setDescription("The row status of this pmCapabilitiesOverrideEntry.\n\n\n\nIf the value of this object is active, no object in this row\nmay be modified.")
pmSchedLocalTime = MibScalar((1, 3, 6, 1, 2, 1, 124, 7), DateAndTime().subtype(subtypeSpec=constraint.ValueSizeConstraint(11, 11)).setFixedLength(11)).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmSchedLocalTime.setDescription("The local time used by the scheduler.  Schedules that\nrefer to calendar time will use the local time indicated\nby this object.  An implementation MUST return all 11 bytes\nof the DateAndTime textual-convention so that a manager\nmay retrieve the offset from GMT time.")
pmSchedTable = MibTable((1, 3, 6, 1, 2, 1, 124, 8))
if mibBuilder.loadTexts: pmSchedTable.setDescription("This table defines schedules for policies.")
pmSchedEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 8, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmSchedIndex"))
if mibBuilder.loadTexts: pmSchedEntry.setDescription("An entry describing a particular schedule.\n\nUnless noted otherwise, writable objects of this row can be\nmodified independently of the current value of pmSchedRowStatus,\npmSchedAdminStatus and pmSchedOperStatus.  In particular, it\nis legal to modify pmSchedWeekDay, pmSchedMonth, and\npmSchedDay when pmSchedRowStatus is active.")
pmSchedIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmSchedIndex.setDescription("The locally unique, administratively assigned index for this\nscheduling entry.")
pmSchedGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedGroupIndex.setDescription("The locally unique, administratively assigned index for the\nschedule group this scheduling entry belongs to.\n\nTo assign multiple schedule entries to the same group, the\npmSchedGroupIndex of each entry in the group will be set to\nthe same value.  This pmSchedGroupIndex value must be equal to\nthe pmSchedIndex of one of the entries in the group.  If the\nentry whose pmSchedIndex equals the pmSchedGroupIndex\nfor the group is deleted, the agent will assign a new\npmSchedGroupIndex to all remaining members of the group.\n\nIf an entry is not a member of a group, its pmSchedGroupIndex\nmust be assigned to the value of its pmSchedIndex.\n\nPolicies that are controlled by a group of schedule entries\nare active when any schedule in the group is active.")
pmSchedDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 3), PmUTF8String().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedDescr.setDescription("The human-readable description of the purpose of this\nscheduling entry.")
pmSchedTimePeriod = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 4), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 31))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedTimePeriod.setDescription("The overall range of calendar dates and times over which this\nschedule is active.  It is stored in a slightly extended version\nof the format for a 'period-explicit' defined in RFC 2445.\nThis format is expressed as a string representing the\nstarting date and time, in which the character 'T' indicates\nthe beginning of the time portion, followed by the solidus\ncharacter, '/', followed by a similar string representing an\nend date and time.  The start of the period MUST be before the\nend of the period.  Date-Time values are expressed as\nsubstrings of the form 'yyyymmddThhmmss'.  For example:\n\n    20000101T080000/20000131T130000\n\n      January 1, 2000, 0800 through January 31, 2000, 1PM\n\nThe 'Date with UTC time' format defined in RFC 2445 in which\nthe Date-Time string ends with the character 'Z' is not\nallowed.\n\nThis 'period-explicit' format is also extended to allow two\nspecial cases in which one of the Date-Time strings is\nreplaced with a special string defined in RFC 2445:\n\n1. If the first Date-Time value is replaced with the string\n   'THISANDPRIOR', then the value indicates that the schedule\n   is active at any time prior to the Date-Time that appears\n   after the '/'.\n\n2. If the second Date-Time is replaced with the string\n   'THISANDFUTURE', then the value indicates that the schedule\n   is active at any time after the Date-Time that appears\n   before the '/'.\n\n\n\n\nNote that although RFC 2445 defines these two strings, they are\nnot specified for use in the 'period-explicit' format.  The use\nof these strings represents an extension to the\n'period-explicit' format.")
pmSchedMonth = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 5), Bits().subtype(namedValues=namedval.NamedValues(("january", 0), ("february", 1), ("november", 10), ("december", 11), ("march", 2), ("april", 3), ("may", 4), ("june", 5), ("july", 6), ("august", 7), ("september", 8), ("october", 9), )).clone(("january","february","march","april","may","june","july","august","september","october","november","december",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedMonth.setDescription("Within the overall time period specified in the\npmSchedTimePeriod object, the value of this object specifies\nthe specific months within that time period when the schedule\nis active.  Setting all bits will cause the schedule to act\nindependently of the month.")
pmSchedDay = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 6), Bits().subtype(namedValues=namedval.NamedValues(("d1", 0), ("d2", 1), ("d11", 10), ("d12", 11), ("d13", 12), ("d14", 13), ("d15", 14), ("d16", 15), ("d17", 16), ("d18", 17), ("d19", 18), ("d20", 19), ("d3", 2), ("d21", 20), ("d22", 21), ("d23", 22), ("d24", 23), ("d25", 24), ("d26", 25), ("d27", 26), ("d28", 27), ("d29", 28), ("d30", 29), ("d4", 3), ("d31", 30), ("r1", 31), ("r2", 32), ("r3", 33), ("r4", 34), ("r5", 35), ("r6", 36), ("r7", 37), ("r8", 38), ("r9", 39), ("d5", 4), ("r10", 40), ("r11", 41), ("r12", 42), ("r13", 43), ("r14", 44), ("r15", 45), ("r16", 46), ("r17", 47), ("r18", 48), ("r19", 49), ("d6", 5), ("r20", 50), ("r21", 51), ("r22", 52), ("r23", 53), ("r24", 54), ("r25", 55), ("r26", 56), ("r27", 57), ("r28", 58), ("r29", 59), ("d7", 6), ("r30", 60), ("r31", 61), ("d8", 7), ("d9", 8), ("d10", 9), )).clone(("d1","d2","d3","d4","d5","d6","d7","d8","d9","d10","d11","d12","d13","d14","d15","d16","d17","d18","d19","d20","d21","d22","d23","d24","d25","d26","d27","d28","d29","d30","d31","r1","r2","r3","r4","r5","r6","r7","r8","r9","r10","r11","r12","r13","r14","r15","r16","r17","r18","r19","r20","r21","r22","r23","r24","r25","r26","r27","r28","r29","r30","r31",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedDay.setDescription("Within the overall time period specified in the\npmSchedTimePeriod object, the value of this object specifies\nthe specific days of the month within that time period when\nthe schedule is active.\n\nThere are two sets of bits one can use to define the day\nwithin a month:\n\nEnumerations starting with the letter 'd' indicate a\nday in a month relative to the first day of a month.\nThe first day of the month can therefore be specified\nby setting the bit d1(0), and d31(30) means the last\nday of a month with 31 days.\n\nEnumerations starting with the letter 'r' indicate a\nday in a month in reverse order, relative to the last\nday of a month.  The last day in the month can therefore\nbe specified by setting the bit r1(31), and r31(61) means\nthe first day of a month with 31 days.\n\nSetting multiple bits will include several days in the set\nof possible days for this schedule.  Setting all bits starting\nwith the letter 'd' or all bits starting with the letter 'r'\nwill cause the schedule to act independently of the day of the\nmonth.")
pmSchedWeekDay = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 7), Bits().subtype(namedValues=namedval.NamedValues(("sunday", 0), ("monday", 1), ("tuesday", 2), ("wednesday", 3), ("thursday", 4), ("friday", 5), ("saturday", 6), )).clone(("sunday","monday","tuesday","wednesday","thursday","friday","saturday",))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedWeekDay.setDescription("Within the overall time period specified in the\npmSchedTimePeriod object, the value of this object specifies\nthe specific days of the week within that time period when\nthe schedule is active.  Setting all bits will cause the\nschedule to act independently of the day of the week.")
pmSchedTimeOfDay = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 8), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 15)).clone('T000000/T235959')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedTimeOfDay.setDescription("Within the overall time period specified in the\npmSchedTimePeriod object, the value of this object specifies\nthe range of times in a day when the schedule is active.\n\nThis value is stored in a format based on the RFC 2445 format\nfor 'time': The character 'T' followed by a 'time' string,\nfollowed by the solidus character, '/', followed by the\ncharacter 'T', followed by a second time string.  The first time\nindicates the beginning of the range, and the second time\nindicates the end.  Thus, this value takes the following\nform:\n\n    'Thhmmss/Thhmmss'.\n\nThe second substring always identifies a later time than the\nfirst substring.  To allow for ranges that span midnight,\nhowever, the value of the second string may be smaller than\nthe value of the first substring.  Thus, 'T080000/T210000'\nidentifies the range from 0800 until 2100, whereas\n'T210000/T080000' identifies the range from 2100 until 0800 of\nthe following day.\n\nWhen a range spans midnight, by definition it includes parts\nof two successive days.  When one of these days is also\nselected by either the MonthOfYearMask, DayOfMonthMask, and/or\nDayOfWeekMask, but the other day is not, then the policy is\nactive only during the portion of the range that falls on the\nselected day.  For example, if the range extends from 2100\n\n\n\nuntil 0800, and the day of week mask selects Monday and\nTuesday, then the policy is active during the following three\nintervals:\n\n    From midnight Sunday until 0800 Monday\n    From 2100 Monday until 0800 Tuesday\n    From 2100 Tuesday until 23:59:59 Tuesday\n\n Setting this value to 'T000000/T235959' will cause the\n schedule to act independently of the time of day.")
pmSchedLocalOrUtc = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("localTime", 1), ("utcTime", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedLocalOrUtc.setDescription("This object indicates whether the times represented in the\nTimePeriod object and in the various Mask objects represent\nlocal times or UTC times.")
pmSchedStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 10), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedStorageType.setDescription("This object defines whether this schedule entry is kept\nin volatile storage and lost upon reboot or\nbacked up by non-volatile or permanent storage.\n\nConceptual rows having the value 'permanent' must allow write\naccess to the columnar objects pmSchedDescr, pmSchedWeekDay,\npmSchedMonth, and pmSchedDay.\n\nIf the value of this object is 'permanent', no values in the\nassociated row have to be writable.")
pmSchedRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 8, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: pmSchedRowStatus.setDescription("The status of this schedule entry.\n\nIf the value of this object is active, no object in this row\nmay be modified.")
pmTrackingPETable = MibTable((1, 3, 6, 1, 2, 1, 124, 9))
if mibBuilder.loadTexts: pmTrackingPETable.setDescription("The pmTrackingPETable describes what elements\nare active (under control of) a policy.  This table is indexed\nin order to optimize retrieval of the entire status for a\ngiven policy.")
pmTrackingPEEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 9, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEContextEngineID"))
if mibBuilder.loadTexts: pmTrackingPEEntry.setDescription("An entry in the pmTrackingPETable.  The pmPolicyIndex in\nthe index specifies the policy tracked by this entry.\n\nNote that some combinations of index values may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP\nprotocol.  Implementations should take care to avoid such\ncombinations.")
pmTrackingPEElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 1), RowPointer()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmTrackingPEElement.setDescription("The element that is acted upon by the associated policy.\n\nAs this object is used in the index for the\npmTrackingPETable, users of this table should be careful not\nto create entries that would result in instance names with\nmore than 128 sub-identifiers.")
pmTrackingPEContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmTrackingPEContextName.setDescription("If the associated element is not in the default SNMP context\nfor the target system, this object is used to identify the\ncontext.  If the element is in the default context, this object\nis equal to the empty string.")
pmTrackingPEContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 3), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(5,32),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmTrackingPEContextEngineID.setDescription("If the associated element is on a remote system, this object\nis used to identify the remote system.  This object contains\nthe contextEngineID of the system on which the associated\nelement resides.  If the element is on the local system,\nthis object will be the empty string.")
pmTrackingPEInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 9, 1, 4), Bits().subtype(namedValues=namedval.NamedValues(("actionSkippedDueToPrecedence", 0), ("conditionRunTimeException", 1), ("conditionUserSignal", 2), ("actionRunTimeException", 3), ("actionUserSignal", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmTrackingPEInfo.setDescription("This object returns information about the previous policy\nscript executions.\n\nIf the actionSkippedDueToPrecedence(1) bit is set, the last\nexecution of the associated policy condition returned non-zero,\nbut the action is not active, because it was trumped by a\nmatching policy condition in the same precedence group with a\nhigher precedence value.\n\nIf the conditionRunTimeException(2) bit is set, the last\nexecution of the associated policy condition encountered a\nrun-time exception and aborted.\n\nIf the conditionUserSignal(3) bit is set, the last\nexecution of the associated policy condition called the\nsignalError() function.\n\nIf the actionRunTimeException(4) bit is set, the last\nexecution of the associated policy action encountered a\nrun-time exception and aborted.\n\nIf the actionUserSignal(5) bit is set, the last\nexecution of the associated policy action called the\nsignalError() function.\n\nEntries will only exist in this table of one or more bits are\nset.  In particular, if an entry does not exist for a\nparticular policy/element combination, it can be assumed that\nthe policy's condition did not match 'this element'.")
pmTrackingEPTable = MibTable((1, 3, 6, 1, 2, 1, 124, 10))
if mibBuilder.loadTexts: pmTrackingEPTable.setDescription("The pmTrackingEPTable describes what policies\nare controlling an element.  This table is indexed in\norder to optimize retrieval of the status of all policies\nactive for a given element.")
pmTrackingEPEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 10, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPContextEngineID"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"))
if mibBuilder.loadTexts: pmTrackingEPEntry.setDescription("An entry in the pmTrackingEPTable.  Entries exist for all\nelement/policy combinations for which the policy's condition\nmatches and only if the schedule for the policy is active.\n\nThe pmPolicyIndex in the index specifies the policy\ntracked by this entry.\n\nNote that some combinations of index values may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP protocol.\nImplementations should take care to avoid such combinations.")
pmTrackingEPElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 1), RowPointer()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmTrackingEPElement.setDescription("The element acted upon by the associated policy.\n\nAs this object is used in the index for the\npmTrackingEPTable, users of this table should be careful\nnot to create entries that would result in instance names\nwith more than 128 sub-identifiers.")
pmTrackingEPContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmTrackingEPContextName.setDescription("If the associated element is not in the default SNMP context\n\n\n\nfor the target system, this object is used to identify the\ncontext.  If the element is in the default context, this object\nis equal to the empty string.")
pmTrackingEPContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 3), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(5,32),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmTrackingEPContextEngineID.setDescription("If the associated element is on a remote system, this object\nis used to identify the remote system.  This object contains\nthe contextEngineID of the system on which the associated\nelement resides.  If the element is on the local system,\nthis object will be the empty string.")
pmTrackingEPStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 10, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("on", 1), ("forceOff", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: pmTrackingEPStatus.setDescription("This entry will only exist if the calendar for the policy is\nactive and if the associated policyCondition returned 1 for\n'this element'.\n\nA policy can be forcibly disabled on a particular element\nby setting this value to forceOff(2).  The agent should then\nact as though the policyCondition failed for 'this element'.\nThe forceOff(2) state will persist (even across reboots) until\nthis value is set to on(1) by a management request.  The\nforceOff(2) state may be set even if the entry does not\npreviously exist so that future policy invocations can be\navoided.\n\nUnless forcibly disabled, if this entry exists, its value\nwill be on(1).")
pmDebuggingTable = MibTable((1, 3, 6, 1, 2, 1, 124, 11))
if mibBuilder.loadTexts: pmDebuggingTable.setDescription("Policies that have debugging turned on will generate a log\nentry in the policy debugging table for every runtime\nexception that occurs in either the condition or action\ncode.\n\nThe pmDebuggingTable logs debugging messages when\npolicies experience run-time exceptions in either the condition\nor action code and the associated pmPolicyDebugging object\nhas been turned on.\n\nThe maximum number of debugging entries that will be stored\nand the maximum length of time an entry will be kept are an\nimplementation-dependent manner.  If entries must\nbe discarded to make room for new entries, the oldest entries\nmust be discarded first.\n\nIf the system restarts, all debugging entries may be deleted.")
pmDebuggingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 124, 11, 1)).setIndexNames((0, "POLICY-BASED-MANAGEMENT-MIB", "pmPolicyIndex"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingElement"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingContextName"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingContextEngineID"), (0, "POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingLogIndex"))
if mibBuilder.loadTexts: pmDebuggingEntry.setDescription("An entry in the pmDebuggingTable.  The pmPolicyIndex in the\nindex specifies the policy that encountered the exception\nthat led to this log entry.\n\nNote that some combinations of index values may result in an\ninstance name that exceeds a length of 128 sub-identifiers,\nwhich exceeds the maximum for the SNMP protocol.\nImplementations should take care to avoid such combinations.")
pmDebuggingElement = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 1), RowPointer()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmDebuggingElement.setDescription("The element the policy was executing on when it encountered\nthe error that led to this log entry.\n\nFor example, if the element is interface 3, then this object\nwill contain the OID for 'ifIndex.3'.\n\nAs this object is used in the index for the\npmDebuggingTable, users of this table should be careful\nnot to create entries that would result in instance names\nwith more than 128 sub-identifiers.")
pmDebuggingContextName = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmDebuggingContextName.setDescription("If the associated element is not in the default SNMP context\nfor the target system, this object is used to identify the\ncontext.  If the element is in the default context, this object\nis equal to the empty string.")
pmDebuggingContextEngineID = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 3), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(5,32),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmDebuggingContextEngineID.setDescription("If the associated element is on a remote system, this object\nis used to identify the remote system.  This object contains\nthe contextEngineID of the system on which the associated\nelement resides.  If the element is on the local system,\nthis object will be the empty string.")
pmDebuggingLogIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: pmDebuggingLogIndex.setDescription("A unique index for this log entry among other log entries\nfor this policy/element combination.")
pmDebuggingMessage = MibTableColumn((1, 3, 6, 1, 2, 1, 124, 11, 1, 5), PmUTF8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: pmDebuggingMessage.setDescription("An error message generated by the policy execution\nenvironment.  It is recommended that this message include the\ntime of day when the message was generated, if known.")
pmConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12))
pmCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12, 1))
pmGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12, 2))
pmBaseFunctionLibrary = MibIdentifier((1, 3, 6, 1, 2, 1, 124, 12, 2, 4))

# Augmentions

# Notifications

pmNewRoleNotification = NotificationType((1, 3, 6, 1, 2, 1, 124, 0, 1)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmRoleStatus"), )
if mibBuilder.loadTexts: pmNewRoleNotification.setDescription("The pmNewRoleNotification is sent when an agent is configured\nwith its first instance of a previously unused role string\n(not every time a new element is given a particular role).\n\nAn instance of the pmRoleStatus object is sent containing\nthe new roleString in its index.  In the event that two or\nmore elements are given the same role simultaneously, it is an\nimplementation-dependent matter as to which pmRoleTable\ninstance will be included in the notification.")
pmNewCapabilityNotification = NotificationType((1, 3, 6, 1, 2, 1, 124, 0, 2)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesType"), )
if mibBuilder.loadTexts: pmNewCapabilityNotification.setDescription("The pmNewCapabilityNotification is sent when an agent\ngains a new capability that did not previously exist in any\nelement on the system (not every time an element gains a\nparticular capability).\n\nAn instance of the pmCapabilitiesType object is sent containing\nthe identity of the new capability.  In the event that two or\nmore elements gain the same capability simultaneously, it is an\nimplementation-dependent matter as to which pmCapabilitiesType\ninstance will be included in the notification.")
pmAbnormalTermNotification = NotificationType((1, 3, 6, 1, 2, 1, 124, 0, 3)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEInfo"), )
if mibBuilder.loadTexts: pmAbnormalTermNotification.setDescription("The pmAbnormalTermNotification is sent when a policy's\npmPolicyAbnormalTerminations gauge value changes from zero to\nany value greater than zero and no such notification has been\nsent for that policy in the last 5 minutes.\n\nThe notification contains an instance of the pmTrackingPEInfo\nobject where the pmPolicyIndex component of the index\nidentifies the associated policy and the rest of the index\nidentifies an element on which the policy failed.")

# Groups

pmPolicyManagementGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 124, 12, 2, 1)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyExecutionErrors"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegMaxLatency"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicySchedule"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyMatches"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAdminStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyAbnormalTerminations"), ("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmRoleStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyPrecedenceGroup"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyStorageType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyConditionMaxLatency"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyDebugging"), ("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesOverrideRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegDescription"), ("POLICY-BASED-MANAGEMENT-MIB", "pmCapabilitiesOverrideState"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyActionMaxLatency"), ("POLICY-BASED-MANAGEMENT-MIB", "pmTrackingPEInfo"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyCodeText"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyActionScriptIndex"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmDebuggingMessage"), ("POLICY-BASED-MANAGEMENT-MIB", "pmTrackingEPStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyElementTypeFilter"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyConditionScriptIndex"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyPrecedence"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyDescription"), ("POLICY-BASED-MANAGEMENT-MIB", "pmElementTypeRegStorageType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyMaxIterations"), ("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyParameters"), )
if mibBuilder.loadTexts: pmPolicyManagementGroup.setDescription("Objects that allow for the creation and management of\nconfiguration policies.")
pmSchedGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 124, 12, 2, 2)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmSchedMonth"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedGroupIndex"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedDay"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedDescr"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedStorageType"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedLocalTime"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedTimePeriod"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedLocalOrUtc"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedRowStatus"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedTimeOfDay"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedWeekDay"), )
if mibBuilder.loadTexts: pmSchedGroup.setDescription("Objects that allow for the scheduling of policies.")
pmNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 124, 12, 2, 3)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmNewRoleNotification"), ("POLICY-BASED-MANAGEMENT-MIB", "pmAbnormalTermNotification"), ("POLICY-BASED-MANAGEMENT-MIB", "pmNewCapabilityNotification"), )
if mibBuilder.loadTexts: pmNotificationGroup.setDescription("Notifications sent by an Policy MIB agent.")

# Compliances

pmCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 124, 12, 1, 1)).setObjects(("POLICY-BASED-MANAGEMENT-MIB", "pmPolicyManagementGroup"), ("POLICY-BASED-MANAGEMENT-MIB", "pmNotificationGroup"), ("POLICY-BASED-MANAGEMENT-MIB", "pmSchedGroup"), )
if mibBuilder.loadTexts: pmCompliance.setDescription("Describes the requirements for conformance to\nthe Policy-Based Management MIB")

# Exports

# Module identity
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", PYSNMP_MODULE_ID=pmMib)

# Types
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", PmUTF8String=PmUTF8String)

# Objects
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", pmMib=pmMib, pmNotifications=pmNotifications, pmPolicyTable=pmPolicyTable, pmPolicyEntry=pmPolicyEntry, pmPolicyAdminGroup=pmPolicyAdminGroup, pmPolicyIndex=pmPolicyIndex, pmPolicyPrecedenceGroup=pmPolicyPrecedenceGroup, pmPolicyPrecedence=pmPolicyPrecedence, pmPolicySchedule=pmPolicySchedule, pmPolicyElementTypeFilter=pmPolicyElementTypeFilter, pmPolicyConditionScriptIndex=pmPolicyConditionScriptIndex, pmPolicyActionScriptIndex=pmPolicyActionScriptIndex, pmPolicyParameters=pmPolicyParameters, pmPolicyConditionMaxLatency=pmPolicyConditionMaxLatency, pmPolicyActionMaxLatency=pmPolicyActionMaxLatency, pmPolicyMaxIterations=pmPolicyMaxIterations, pmPolicyDescription=pmPolicyDescription, pmPolicyMatches=pmPolicyMatches, pmPolicyAbnormalTerminations=pmPolicyAbnormalTerminations, pmPolicyExecutionErrors=pmPolicyExecutionErrors, pmPolicyDebugging=pmPolicyDebugging, pmPolicyAdminStatus=pmPolicyAdminStatus, pmPolicyStorageType=pmPolicyStorageType, pmPolicyRowStatus=pmPolicyRowStatus, pmPolicyCodeTable=pmPolicyCodeTable, pmPolicyCodeEntry=pmPolicyCodeEntry, pmPolicyCodeScriptIndex=pmPolicyCodeScriptIndex, pmPolicyCodeSegment=pmPolicyCodeSegment, pmPolicyCodeText=pmPolicyCodeText, pmPolicyCodeStatus=pmPolicyCodeStatus, pmElementTypeRegTable=pmElementTypeRegTable, pmElementTypeRegEntry=pmElementTypeRegEntry, pmElementTypeRegOIDPrefix=pmElementTypeRegOIDPrefix, pmElementTypeRegMaxLatency=pmElementTypeRegMaxLatency, pmElementTypeRegDescription=pmElementTypeRegDescription, pmElementTypeRegStorageType=pmElementTypeRegStorageType, pmElementTypeRegRowStatus=pmElementTypeRegRowStatus, pmRoleTable=pmRoleTable, pmRoleEntry=pmRoleEntry, pmRoleElement=pmRoleElement, pmRoleContextName=pmRoleContextName, pmRoleContextEngineID=pmRoleContextEngineID, pmRoleString=pmRoleString, pmRoleStatus=pmRoleStatus, pmCapabilitiesTable=pmCapabilitiesTable, pmCapabilitiesEntry=pmCapabilitiesEntry, pmCapabilitiesType=pmCapabilitiesType, pmCapabilitiesOverrideTable=pmCapabilitiesOverrideTable, pmCapabilitiesOverrideEntry=pmCapabilitiesOverrideEntry, pmCapabilitiesOverrideType=pmCapabilitiesOverrideType, pmCapabilitiesOverrideState=pmCapabilitiesOverrideState, pmCapabilitiesOverrideRowStatus=pmCapabilitiesOverrideRowStatus, pmSchedLocalTime=pmSchedLocalTime, pmSchedTable=pmSchedTable, pmSchedEntry=pmSchedEntry, pmSchedIndex=pmSchedIndex, pmSchedGroupIndex=pmSchedGroupIndex, pmSchedDescr=pmSchedDescr, pmSchedTimePeriod=pmSchedTimePeriod, pmSchedMonth=pmSchedMonth, pmSchedDay=pmSchedDay, pmSchedWeekDay=pmSchedWeekDay, pmSchedTimeOfDay=pmSchedTimeOfDay, pmSchedLocalOrUtc=pmSchedLocalOrUtc, pmSchedStorageType=pmSchedStorageType, pmSchedRowStatus=pmSchedRowStatus, pmTrackingPETable=pmTrackingPETable, pmTrackingPEEntry=pmTrackingPEEntry, pmTrackingPEElement=pmTrackingPEElement, pmTrackingPEContextName=pmTrackingPEContextName, pmTrackingPEContextEngineID=pmTrackingPEContextEngineID, pmTrackingPEInfo=pmTrackingPEInfo, pmTrackingEPTable=pmTrackingEPTable, pmTrackingEPEntry=pmTrackingEPEntry, pmTrackingEPElement=pmTrackingEPElement, pmTrackingEPContextName=pmTrackingEPContextName, pmTrackingEPContextEngineID=pmTrackingEPContextEngineID, pmTrackingEPStatus=pmTrackingEPStatus, pmDebuggingTable=pmDebuggingTable, pmDebuggingEntry=pmDebuggingEntry, pmDebuggingElement=pmDebuggingElement, pmDebuggingContextName=pmDebuggingContextName, pmDebuggingContextEngineID=pmDebuggingContextEngineID, pmDebuggingLogIndex=pmDebuggingLogIndex, pmDebuggingMessage=pmDebuggingMessage, pmConformance=pmConformance, pmCompliances=pmCompliances, pmGroups=pmGroups, pmBaseFunctionLibrary=pmBaseFunctionLibrary)

# Notifications
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", pmNewRoleNotification=pmNewRoleNotification, pmNewCapabilityNotification=pmNewCapabilityNotification, pmAbnormalTermNotification=pmAbnormalTermNotification)

# Groups
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", pmPolicyManagementGroup=pmPolicyManagementGroup, pmSchedGroup=pmSchedGroup, pmNotificationGroup=pmNotificationGroup)

# Compliances
mibBuilder.exportSymbols("POLICY-BASED-MANAGEMENT-MIB", pmCompliance=pmCompliance)
