# PySNMP SMI module. Autogenerated from smidump -f python SIP-COMMON-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:11 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetPortNumber")
( applIndex, ) = mibBuilder.importSymbols("NETWORK-SERVICES-MIB", "applIndex")
( SipTCEntityRole, SipTCMethodName, SipTCOptionTagHeaders, SipTCTransportProtocol, ) = mibBuilder.importSymbols("SIP-TC-MIB", "SipTCEntityRole", "SipTCMethodName", "SipTCOptionTagHeaders", "SipTCTransportProtocol")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TimeStamp", "TruthValue")

# Objects

sipCommonMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 149)).setRevisions(("2007-04-20 00:00",))
if mibBuilder.loadTexts: sipCommonMIB.setOrganization("IETF Session Initiation Protocol Working Group")
if mibBuilder.loadTexts: sipCommonMIB.setContactInfo("SIP WG email: sip@ietf.org\n\nCo-editor  Kevin Lingle\n           Cisco Systems, Inc.\npostal:    7025 Kit Creek Road\n           P.O. Box 14987\n           Research Triangle Park, NC 27709\n           USA\nemail:     klingle@cisco.com\nphone:     +1 919 476 2029\n\nCo-editor  Joon Maeng\nemail:     jmaeng@austin.rr.com\n\nCo-editor  Jean-Francois Mule\n           CableLabs\n\n\npostal:    858 Coal Creek Circle\n           Louisville, CO 80027\n           USA\nemail:     jf.mule@cablelabs.com\nphone:     +1 303 661 9100\n\nCo-editor  Dave Walker\nemail:     drwalker@rogers.com")
if mibBuilder.loadTexts: sipCommonMIB.setDescription("Session Initiation Protocol (SIP) Common MIB module.  This\nmodule defines objects that may be common to all SIP entities.\n\nSIP is an application-layer signaling protocol for creating,\nmodifying and terminating multimedia sessions with one or more\nparticipants.  These sessions include Internet multimedia\nconferences and Internet telephone calls.  SIP is defined in\nRFC 3261 (June 2002).\n\nThis MIB is defined for managing objects that are common to\nSIP User Agents (UAs), Proxy, Redirect, and Registrar servers.\nObjects specific to each of these entities MAY be managed using\nentity specific MIBs defined in other modules.\n\nCopyright (C) The IETF Trust (2007).  This version of\nthis MIB module is part of RFC 4780; see the RFC itself for\nfull legal notices.")
sipCommonMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 0))
sipCommonMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1))
sipCommonCfgBase = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 1))
sipCommonCfgTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 1, 1))
if mibBuilder.loadTexts: sipCommonCfgTable.setDescription("This table contains the common configuration objects applicable\nto all SIP entities.")
sipCommonCfgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: sipCommonCfgEntry.setDescription("A row of common configuration.\n\nEach row represents objects for a particular SIP entity\ninstance present in this system.  applIndex is used to uniquely\nidentify these instances of SIP entities and correlate them\nthrough the common framework of the NETWORK-SERVICES-MIB (RFC\n2788).")
sipCommonCfgProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgProtocolVersion.setDescription("This object will reflect the version of SIP supported by this\nSIP entity.  It will follow the same format as SIP version\ninformation contained in the SIP messages generated by this SIP\nentity.  For example, entities supporting SIP version 2 will\nreturn 'SIP/2.0' as dictated by the standard.")
sipCommonCfgServiceOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,7,5,1,6,2,4,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("up", 2), ("down", 3), ("congested", 4), ("restarting", 5), ("quiescing", 6), ("testing", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgServiceOperStatus.setDescription("This object contains the current operational state of\nthe SIP application.\n\nunknown    : The operational status cannot be determined\n             for some reason.\nup         : The application is operating normally and is\n             processing (receiving and possibly issuing) SIP\n             requests and responses.\ndown       : The application is currently unable to process\n             SIP messages.\ncongested  : The application is operational but no additional\n\n\n\n             inbound transactions can be accommodated at the\n             moment.\nrestarting : The application is currently unavailable, but it\n             is in the process of restarting and will\n             presumably, soon be able to process SIP messages.\nquiescing  : The application is currently operational\n             but has been administratively put into\n             quiescence mode.  Additional inbound\n             transactions MAY be rejected.\ntesting    : The application is currently in test mode\n             and MAY not be able to process SIP messages.\n\nThe operational status values defined for this object are not\nbased on any specific information contained in the SIP\nstandard.")
sipCommonCfgServiceStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgServiceStartTime.setDescription("The value of sysUpTime at the time the SIP entity was last\nstarted.  If started prior to the last re-initialization of the\nlocal network management subsystem, then this object contains a\nzero value.")
sipCommonCfgServiceLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgServiceLastChange.setDescription("The value of sysUpTime at the time the SIP entity entered its\ncurrent operational state.  If the current state was entered\nprior to the last re-initialization of the local network\nmanagement subsystem, then this object contains a zero value.")
sipCommonCfgOrganization = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgOrganization.setDescription("This object contains the organization name that the SIP entity\ninserts into Organization headers of SIP messages processed by\nthis system.  If the string is empty, no Organization header is\nto be generated.")
sipCommonCfgMaxTransactions = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgMaxTransactions.setDescription("This object indicates the maximum number of simultaneous\ntransactions per second that the SIP entity can manage.  In\ngeneral, the value of this object SHOULD reflect a level of\ntransaction processing per second that is considered high\nenough to impact the system's CPU and/or memory resources to\nthe point of deteriorating SIP call processing but not high\nenough to cause catastrophic system failure.")
sipCommonCfgServiceNotifEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 7), Bits().subtype(namedValues=namedval.NamedValues(("sipCommonServiceColdStart", 0), ("sipCommonServiceWarmStart", 1), ("sipCommonServiceStatusChanged", 2), )).clone(("sipCommonServiceColdStart","sipCommonServiceWarmStart",))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipCommonCfgServiceNotifEnable.setDescription("This object specifies which SIP service related notifications\nare enabled.  Each bit represents a specific notification.  If\na bit has a value 1, the associated notification is enabled and\nwill be generated by the SIP entity at the appropriate time.\n\nSupport for these notifications is OPTIONAL: either none or all\nnotification values are supported.  If an implementation does\nnot support this object, it should return a 'noSuchObject'\nexception to an SNMP GET operation.  If notifications are\nsupported, this object's default value SHOULD reflect\nsipCommonServiceColdStart and sipCommonServiceWarmStart enabled\nand sipCommonServiceStatusChanged disabled.\n\nThis object value SHOULD persist across reboots.")
sipCommonCfgEntityType = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 1, 1, 8), SipTCEntityRole()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgEntityType.setDescription("This object identifies the list of SIP entities to which this\nrow is related.  It is defined as a bit map.  Each bit\nrepresents a type of SIP entity.  If a bit has value 1, the\nSIP entity represented by this row plays the role of this\nentity type.  If a bit has value 0, the SIP entity represented\nby this row does not act as this entity type.  Combinations\nof bits can be set when the SIP entity plays multiple SIP\nroles.")
sipCommonPortTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 1, 2))
if mibBuilder.loadTexts: sipCommonPortTable.setDescription("This table contains the list of ports that each SIP entity in\nthis system is allowed to use.  These ports can be advertised\nusing the Contact header in a REGISTER request or response.")
sipCommonPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 1, 2, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "SIP-COMMON-MIB", "sipCommonPort"))
if mibBuilder.loadTexts: sipCommonPortEntry.setDescription("Specification of a particular port.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonPort = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 2, 1, 1), InetPortNumber().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonPort.setDescription("This object reflects a particular port that can be used by the\nSIP application.")
sipCommonPortTransportRcv = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 2, 1, 2), SipTCTransportProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonPortTransportRcv.setDescription("This object will specify the transport protocol the SIP entity\nwill use to receive SIP messages.\n\nThis object is a bit map.  Each bit represents a transport\nprotocol.  If a bit has value 1, then that transport protocol\nis currently being used.  If a bit has value 0, then that\ntransport protocol is currently not being used.")
sipCommonOptionTagTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 1, 3))
if mibBuilder.loadTexts: sipCommonOptionTagTable.setDescription("This table contains a list of the SIP option tags (SIP\nextensions) that are either required, supported, or\nunsupported by the SIP entity.  These option tags are\nused in the Require, Proxy-Require, Supported, and\nUnsupported header fields.\n\nExample: If a user agent client supports, and requires the\nserver to support, reliability of provisional responses\n(RFC 3262), this table contains a row with the option tag string\n'100rel' in sipCommonOptionTag and the OCTET STRING value of\n'1010 0000' or '0xA0' in sipCommonOptionTagHeaderField.\n\nIf a server does not support the required feature (indicated in\na Require header to a UAS, or in a Proxy-Require to a Proxy\nServer), the server returns a 420 Bad Extension listing the\nfeature in an Unsupported header.\n\nNormally, the list of such features supported by an entity is\nstatic (i.e., will not change over time).")
sipCommonOptionTagEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 1, 3, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "SIP-COMMON-MIB", "sipCommonOptionTagIndex"))
if mibBuilder.loadTexts: sipCommonOptionTagEntry.setDescription("A particular SIP option tag (extension) supported or\nunsupported by the SIP entity, and which may be supported or\nrequired by a peer.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through the\ncommon framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonOptionTagIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonOptionTagIndex.setDescription("This object uniquely identifies a conceptual row in the table.")
sipCommonOptionTag = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 3, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonOptionTag.setDescription("This object indicates the SIP option tag.  The option tag names\nare registered with IANA and available at http://www.iana.org.")
sipCommonOptionTagHeaderField = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 3, 1, 3), SipTCOptionTagHeaders()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonOptionTagHeaderField.setDescription("This object indicates whether the SIP option tag is supported\n(Supported header), unsupported (Unsupported header), or\nrequired (Require or Proxy-Require header) by the SIP entity.\nA SIP option tag may be both supported and required.")
sipCommonMethodSupportedTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 1, 4))
if mibBuilder.loadTexts: sipCommonMethodSupportedTable.setDescription("This table contains a list of methods supported by each SIP\nentity in this system (see the standard set of SIP methods in\nSection 7.1 of RFC 3261).  Any additional methods that may be\nincorporated into the SIP protocol can be represented by this\ntable without any requirement to update this MIB module.\n\nThe table is informational in nature and conveys capabilities\nof the managed system to the SNMP Manager.\n\nFrom a protocol point of view, the list of methods advertised\nby the SIP entity in the Allow header (Section 20.5 of RFC\n3261) MUST be consistent with the methods reflected in this\ntable.")
sipCommonMethodSupportedEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 1, 4, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "SIP-COMMON-MIB", "sipCommonMethodSupportedIndex"))
if mibBuilder.loadTexts: sipCommonMethodSupportedEntry.setDescription("A particular method supported by the SIP entity.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonMethodSupportedIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonMethodSupportedIndex.setDescription("This object uniquely identifies a conceptual row in the table\nand reflects an assigned number used to identify a specific\nSIP method.\n\nThis identifier is suitable for referencing the associated\nmethod throughout this and other MIBs supported by this managed\nsystem.")
sipCommonMethodSupportedName = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 1, 4, 1, 2), SipTCMethodName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonMethodSupportedName.setDescription("This object reflects the supported method's name.  The method\nname MUST be all upper case (e.g., 'INVITE').")
sipCommonCfgTimer = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 2))
sipCommonCfgTimerTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 2, 1))
if mibBuilder.loadTexts: sipCommonCfgTimerTable.setDescription("This table contains timer configuration objects applicable to\nSIP user agent and SIP stateful Proxy Server entities.")
sipCommonCfgTimerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: sipCommonCfgTimerEntry.setDescription("A row of timer configuration.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).\nThe objects in this table entry SHOULD be non-volatile and\ntheir value SHOULD be kept at reboot.")
sipCommonCfgTimerA = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(100, 1000)).clone(500)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerA.setDescription("This object reflects the initial value for the retransmit timer\nfor the INVITE method.  The retransmit timer doubles after each\nretransmission, ensuring an exponential backoff in network\ntraffic.  This object represents the initial time a SIP entity\nwill wait to receive a provisional response to an INVITE before\nresending the INVITE request.")
sipCommonCfgTimerB = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(32000, 300000)).clone(32000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerB.setDescription("This object reflects the maximum time a SIP entity will wait to\nreceive a final response to an INVITE.  The timer is started\nupon transmission of the initial INVITE request.")
sipCommonCfgTimerC = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(180000, 300000)).clone(180000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerC.setDescription("This object reflects the maximum time a SIP Proxy Server will\nwait to receive a provisional response to an INVITE.  The Timer\nC MUST be set for each client transaction when an INVITE\nrequest is proxied.")
sipCommonCfgTimerD = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 300000)).clone(32000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerD.setDescription("This object reflects the amount of time that the server\ntransaction can remain in the 'Completed' state when unreliable\ntransports are used.  The default value MUST be equal to or\ngreater than 32000 for UDP transport, and its value MUST be 0\nfor TCP/SCTP transport.")
sipCommonCfgTimerE = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(100, 1000)).clone(500)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerE.setDescription("This object reflects the initial value for the retransmit timer\nfor a non-INVITE method while in 'Trying' state.  The\nretransmit timer doubles after each retransmission until it\nreaches T2 to ensure an exponential backoff in network traffic.\nThis object represents the initial time a SIP entity will wait\nto receive a provisional response to the request before\nresending the non-INVITE request.")
sipCommonCfgTimerF = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(32000, 300000)).clone(32000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerF.setDescription("This object reflects the maximum time a SIP entity will wait to\nreceive a final response to a non-INVITE request.  The timer is\nstarted upon transmission of the initial request.")
sipCommonCfgTimerG = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 1000)).clone(500)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerG.setDescription("This object reflects the initial value for the retransmit timer\nfor final responses to INVITE requests.  If timer G fires, the\nresponse is passed to the transport layer again for\nretransmission, and timer G is set to fire in MIN(2*T1, T2)\nseconds.  From then on, when timer G fires, the response is\npassed to the transport again for transmission, and timer G is\nreset with a value that doubles, unless that value exceeds T2,\nin which case, it is reset with the value of T2.  The default\nvalue MUST be T1 for UDP transport, and its value MUST be 0 for\nreliable transport like TCP/SCTP.")
sipCommonCfgTimerH = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(32000, 300000)).clone(32000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerH.setDescription("This object reflects the maximum time a server will wait to\nreceive an ACK before it abandons retransmitting the response.\n\n\n\nThe timer is started upon entering the 'Completed' state.")
sipCommonCfgTimerI = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 10000)).clone(5000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerI.setDescription("This object reflects the maximum time a SIP entity will wait to\nreceive additional ACK message retransmissions.\n\nThe timer is started upon entering the 'Confirmed' state.  The\ndefault value MUST be T4 for UDP transport and its value MUST\nbe 0 for reliable transport like TCP/SCTP.")
sipCommonCfgTimerJ = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(32000, 300000)).clone(32000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerJ.setDescription("This object reflects the maximum time a SIP server will wait to\nreceive retransmissions of non-INVITE requests.  The timer is\nstarted upon entering the 'Completed' state for non-INVITE\ntransactions.  When timer J fires, the server MUST transition to\nthe 'Terminated' state.")
sipCommonCfgTimerK = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 10000)).clone(5000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerK.setDescription("This object reflects the maximum time a SIP client will wait to\nreceive retransmissions of responses to non-INVITE requests.\nThe timer is started upon entering the 'Completed' state for\n\n\n\nnon-INVITE transactions.  When timer K fires, the server MUST\ntransition to the 'Terminated' state.  The default value MUST\nbe T4 for UDP transport, and its value MUST be 0 for reliable\ntransport like TCP/SCTP.")
sipCommonCfgTimerT1 = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(200, 10000)).clone(500)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerT1.setDescription("This object reflects the T1 timer for a SIP entity.  T1 is an\nestimate of the round-trip time (RTT) between the client and\nserver transactions.")
sipCommonCfgTimerT2 = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(200, 10000)).clone(4000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerT2.setDescription("This object reflects the T2 timer for a SIP entity.  T2 is the\nmaximum retransmit interval for non-INVITE requests and INVITE\nresponses.  It's used in various parts of the protocol to reset\nother Timer* objects to this value.")
sipCommonCfgTimerT4 = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 2, 1, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(200, 10000)).clone(5000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonCfgTimerT4.setDescription("This object reflects the T4 timer for a SIP entity.  T4 is the\nmaximum duration a message will remain in the network.  It\nrepresents the amount of time the network will take to clear\nmessages between client and server transactions.  It's used in\n\n\n\nvarious parts of the protocol to reset other Timer* objects to\nthis value.")
sipCommonSummaryStats = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 3))
sipCommonSummaryStatsTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 3, 1))
if mibBuilder.loadTexts: sipCommonSummaryStatsTable.setDescription("This table contains the summary statistics objects applicable\nto all SIP entities.  Each row represents those objects for a\nparticular SIP entity present in this system.")
sipCommonSummaryStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: sipCommonSummaryStatsEntry.setDescription("A row of summary statistics.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonSummaryInRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonSummaryInRequests.setDescription("This object indicates the total number of SIP request messages\nreceived by the SIP entity, including retransmissions.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonSummaryDisconTime object in the same\nrow.")
sipCommonSummaryOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonSummaryOutRequests.setDescription("This object contains the total number of SIP request messages\nsent out (originated and relayed) by the SIP entity.  Where a\nparticular message is sent more than once, for example as a\nretransmission or as a result of forking, each transmission is\ncounted separately.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonSummaryDisconTime object in the same\nrow.")
sipCommonSummaryInResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonSummaryInResponses.setDescription("This object contains the total number of SIP response messages\nreceived by the SIP entity, including retransmissions.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonSummaryDisconTime object in the same\nrow.")
sipCommonSummaryOutResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonSummaryOutResponses.setDescription("This object contains the total number of SIP response messages\nsent (originated and relayed) by the SIP entity including\nretransmissions.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonSummaryDisconTime object in the same\nrow.")
sipCommonSummaryTotalTransactions = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonSummaryTotalTransactions.setDescription("This object contains a count of the number of transactions that\nare in progress and transactions that have reached the\n'Terminated' state.  It is not applicable to stateless SIP Proxy\nServers.\n\nA SIP transaction occurs between a client and a server, and\ncomprises all messages from the first request sent from the\nclient to the server, up to a final (non-1xx) response sent\nfrom the server to the client.\n\nIf the request is INVITE and the final response is a non-2xx,\nthe transaction also include an ACK to the response.  The ACK\nfor a 2xx response to an INVITE request is a separate\ntransaction.\n\nThe branch ID parameter in the Via header field values serves\nas a transaction identifier.\n\nA transaction is identified by the CSeq sequence number within\na single call leg.  The ACK request has the same CSeq number as\nthe corresponding INVITE request, but comprises a transaction\nof its own.\n\nIn the case of a forked request, each branch counts as a single\ntransaction.\n\nFor a transaction stateless Proxy Server, this counter is\nalways 0.\n\n\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonSummaryDisconTime object in the same\nrow.")
sipCommonSummaryDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 3, 1, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonSummaryDisconTime.setDescription("The value of the sysUpTime object when the counters for the\nsummary statistics objects in this row last experienced a\ndiscontinuity.")
sipCommonMethodStats = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 4))
sipCommonMethodStatsTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 4, 1))
if mibBuilder.loadTexts: sipCommonMethodStatsTable.setDescription("This table contains the method statistics objects for SIP\nentities.  Each row represents those objects for a particular\nSIP entity present in this system.")
sipCommonMethodStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 4, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "SIP-COMMON-MIB", "sipCommonMethodStatsName"))
if mibBuilder.loadTexts: sipCommonMethodStatsEntry.setDescription("A row of per entity method statistics.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonMethodStatsName = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 4, 1, 1, 1), SipTCMethodName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonMethodStatsName.setDescription("This object uniquely identifies the SIP method related to the\nobjects in a particular row.")
sipCommonMethodStatsOutbounds = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 4, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonMethodStatsOutbounds.setDescription("This object reflects the total number of requests sent by the\nSIP entity, excluding retransmissions.  Retransmissions are\ncounted separately and are not reflected in this counter.  A\nManagement Station can detect discontinuities in this counter\nby monitoring the sipCommonMethodStatsDisconTime object in the\nsame row.")
sipCommonMethodStatsInbounds = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 4, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonMethodStatsInbounds.setDescription("This object reflects the total number of requests received by\nthe SIP entity.  Retransmissions are counted separately and are\nnot reflected in this counter.  A Management Station can detect\ndiscontinuities in this counter by monitoring the\nsipCommonMethodStatsDisconTime object in the same row.")
sipCommonMethodStatsDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 4, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonMethodStatsDisconTime.setDescription("The value of the sysUpTime object when the counters for the\nmethod statistics objects in this row last experienced a\ndiscontinuity.")
sipCommonStatusCode = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 5))
sipCommonStatusCodeTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 5, 1))
if mibBuilder.loadTexts: sipCommonStatusCodeTable.setDescription("This table contains the list of SIP status codes that each SIP\nentity in this system has been requested to monitor.  It is the\nmechanism by which specific status codes are monitored.\nEntries created in this table must not persist across reboots.")
sipCommonStatusCodeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "SIP-COMMON-MIB", "sipCommonStatusCodeMethod"), (0, "SIP-COMMON-MIB", "sipCommonStatusCodeValue"))
if mibBuilder.loadTexts: sipCommonStatusCodeEntry.setDescription("This row contains information on a particular SIP status code\nthat the SIP entity has been requested to monitor.  Entries\ncreated in this table must not persist across reboots.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonStatusCodeMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1, 1), SipTCMethodName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonStatusCodeMethod.setDescription("This object uniquely identifies a conceptual row in the\ntable.")
sipCommonStatusCodeValue = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(100, 999))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonStatusCodeValue.setDescription("This object contains a SIP status code value that the SIP\nentity has been requested to monitor.  All of the other\ninformation in the row is related to this value.")
sipCommonStatusCodeIns = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatusCodeIns.setDescription("This object reflects the total number of response messages\nreceived by the SIP entity with the status code value contained\nin the sipCommonStatusCodeValue column.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service, or when the\nmonitoring of the status code is temporarily disabled.  A\nManagement Station can detect discontinuities in this counter\nby monitoring the sipCommonStatusCodeDisconTime object in the\nsame row.")
sipCommonStatusCodeOuts = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatusCodeOuts.setDescription("This object reflects the total number of response messages sent\nby the SIP entity with the status code value contained in the\nsipCommonStatusCodeValue column.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service, or when the\nmonitoring of the Status code is temporarily disabled.  A\nManagement Station can detect discontinuities in this counter\nby monitoring the sipCommonStatusCodeDisconTime object in the\nsame row.")
sipCommonStatusCodeRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sipCommonStatusCodeRowStatus.setDescription("The row augmentation in sipCommonStatusCodeNotifTable will be\ngoverned by the value of this RowStatus.\n\nThe values 'createAndGo' and 'destroy' are the only valid\nvalues allowed for this object.  If a row exists, it will\nreflect a status of 'active' when queried.")
sipCommonStatusCodeDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 1, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatusCodeDisconTime.setDescription("The value of the sysUpTime object when the counters for the\nstatus code statistics objects in this row last experienced\na discontinuity.")
sipCommonStatusCodeNotifTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 5, 2))
if mibBuilder.loadTexts: sipCommonStatusCodeNotifTable.setDescription("This table contains objects to control notifications related to\nparticular status codes that each SIP entity in this system has\nbeen requested to monitor.\n\nThere is an entry in this table corresponding to each entry in\nsipCommonStatusCodeTable.  Therefore, this table augments\nsipCommonStatusCodeTable and utilizes the same index\nmethodology.\n\nThe objects in this table are not included directly in the\nsipCommonStatusCodeTable simply to keep the status code\nnotification control objects separate from the actual status\ncode statistics.")
sipCommonStatusCodeNotifEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 5, 2, 1))
if mibBuilder.loadTexts: sipCommonStatusCodeNotifEntry.setDescription("This row contains information controlling notifications for a\nparticular SIP status code that the SIP entity has been\nrequested to monitor.")
sipCommonStatusCodeNotifSend = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 2, 1, 1), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifSend.setDescription("This object controls whether a sipCommonStatusCodeNotif is\nemitted when the status code value specified by\nsipCommonStatusCodeValue is sent or received.  If the value of\nthis object is 'true', then a notification is sent.  If it is\n'false', no notification is sent.\nNote well that a notification MAY be emitted for every message\nsent or received that contains the particular status code.\nDepending on the status code involved, this can cause a\nsignificant number of notification emissions that could be\ndetrimental to network performance.  Managers are forewarned to\nbe prudent in the use of this object to enable notifications.\nLook to sipCommonStatusCodeNotifEmitMode for alternative\ncontrols for sipCommonStatusCodeNotif emissions.")
sipCommonStatusCodeNotifEmitMode = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("normal", 1), ("oneShot", 2), ("triggered", 3), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifEmitMode.setDescription("The object sipCommonStatusCodeNotifSend MUST be set to 'true'\nfor the values of this object to have any effect.  It is\nRECOMMENDED that the desired emit mode be established by this\nobject prior to setting sipCommonStatusCodeNotifSend to 'true'.\nThis object and the sipCommonStatusCodeNotifSend object can\nobviously be set independently, but their respective values\nwill have a dependency on each other and the resulting\nnotifications.\n\nThis object specifies the mode for emissions of\nsipCommonStatusCodeNotif notifications.\n\nnormal    : sipCommonStatusCodeNotif notifications will be\n            emitted by the system for each SIP response\n            message sent or received that contains the\n            desired status code.\n\noneShot   : Only one sipCommonStatusCodeNotif notification\n            will be emitted.  It will be the next SIP response\n            message sent or received that contains the\n            desired status code.\n\n            No more notifications are emitted until this\n            object is set to 'oneShot' again or set to\n            'normal'.  This option is provided as a means of\n            quelling the potential promiscuous behavior that\n            can be associated with the\n            sipCommonStatusCodeNotif.\n\ntriggered : This value is only readable and cannot be set.  It\n            reflects that the 'oneShot' case has occurred,\n            and indicates that the mode needs to be reset to\n            get further notifications.  The mode is reset by\n            setting this object to 'oneShot' or 'normal'.")
sipCommonStatusCodeNotifThresh = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 2, 1, 3), Unsigned32().clone(500)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifThresh.setDescription("This object specifies the number of response messages sent or\nreceived by this system that are considered excessive.  Based\non crossing that threshold, a\nsipCommonStatusCodeThreshExceededInNotif notification or a\nsipCommonStatusCodeThreshExceededOutNotif will be sent.  The\nsipCommonStatusCodeThreshExceededInNotif and\n\n\n\nsipCommonStatusCodeThreshExceededOutNotif notifications can be\nused as an early warning mechanism in lieu of using\nsipCommonStatusCodeNotif.\n\nNote that the configuration applied by this object will be\napplied equally to inbound and outbound response messages.")
sipCommonStatusCodeNotifInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 5, 2, 1, 4), Unsigned32().clone(60)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifInterval.setDescription("This object specifies the time interval over which, if\nsipCommonStatusCodeThresh is exceeded with respect to sent or\nreceived messages, a sipCommonStatusCodeThreshExceededInNotif\nor sipCommonStatusCodeThreshExceededOutNotif notification will\nbe sent.\n\nNote that the configuration applied by this object will be\napplied equally to inbound and outbound response messages.")
sipCommonStatsTrans = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 6))
sipCommonTransCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 6, 1))
if mibBuilder.loadTexts: sipCommonTransCurrentTable.setDescription("This table contains information on the transactions currently\nawaiting definitive responses by each SIP entity in this\nsystem.\n\nThis table does not apply to transaction stateless Proxy\nServers.")
sipCommonTransCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 6, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: sipCommonTransCurrentEntry.setDescription("Information on a particular SIP entity's current transactions.\n\n\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonTransCurrentactions = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 6, 1, 1, 1), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonTransCurrentactions.setDescription("This object contains the number of transactions awaiting\ndefinitive (non-1xx) response.  In the case of a forked\nrequest, each branch counts as a single transaction\ncorresponding to the entity identified by applIndex.")
sipCommonStatsRetry = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 7))
sipCommonStatsRetryTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 7, 1))
if mibBuilder.loadTexts: sipCommonStatsRetryTable.setDescription("This table contains retry statistics objects applicable to each\nSIP entity in this system.")
sipCommonStatsRetryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 7, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "SIP-COMMON-MIB", "sipCommonStatsRetryMethod"))
if mibBuilder.loadTexts: sipCommonStatsRetryEntry.setDescription("A row of retry statistics.\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through the\ncommon framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonStatsRetryMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 7, 1, 1, 1), SipTCMethodName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sipCommonStatsRetryMethod.setDescription("This object uniquely identifies the SIP method related to the\nobjects in a row.")
sipCommonStatsRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 7, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatsRetries.setDescription("This object reflects the total number of request\nretransmissions that have been sent by the SIP entity.  Note\nthat there could be multiple retransmissions per request.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonStatsRetryDisconTime object in the same\nrow.")
sipCommonStatsRetryFinalResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 7, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatsRetryFinalResponses.setDescription("This object reflects the total number of Final Response retries\nthat have been sent by the SIP entity.  Note that there could\nbe multiple retransmissions per request.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\n\n\n\nmonitoring the sipCommonStatsRetryDisconTime object in the same\nrow.")
sipCommonStatsRetryNonFinalResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 7, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatsRetryNonFinalResponses.setDescription("This object reflects the total number of non-Final Response\nretries that have been sent by the SIP entity.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonStatsRetryDisconTime object in the same\nrow.")
sipCommonStatsRetryDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 7, 1, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonStatsRetryDisconTime.setDescription("The value of the sysUpTime object when the counters for the\nretry statistics objects in this row last experienced a\ndiscontinuity.")
sipCommonOtherStats = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 8))
sipCommonOtherStatsTable = MibTable((1, 3, 6, 1, 2, 1, 149, 1, 8, 1))
if mibBuilder.loadTexts: sipCommonOtherStatsTable.setDescription("This table contains other common statistics supported by each\nSIP entity in this system.")
sipCommonOtherStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 149, 1, 8, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: sipCommonOtherStatsEntry.setDescription("Information on a particular SIP entity's other common\nstatistics.\n\n\n\nEach row represents those objects for a particular SIP entity\npresent in this system.  applIndex is used to uniquely identify\nthese instances of SIP entities and correlate them through\nthe common framework of the NETWORK-SERVICES-MIB (RFC 2788).")
sipCommonOtherStatsNumUnsupportedUris = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 8, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonOtherStatsNumUnsupportedUris.setDescription("Number of RequestURIs received with an unsupported scheme.\nA server normally responds to such requests with a 400 Bad\nRequest status code.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonOtherStatsDisconTime object in the same\nrow.")
sipCommonOtherStatsNumUnsupportedMethods = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 8, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonOtherStatsNumUnsupportedMethods.setDescription("Number of SIP requests received with unsupported methods.  A\nserver normally responds to such requests with a 501 (Not\nImplemented) or 405 (Method Not Allowed).\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonOtherStatsDisconTime object in the same\nrow.")
sipCommonOtherStatsOtherwiseDiscardedMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 8, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonOtherStatsOtherwiseDiscardedMsgs.setDescription("Number of SIP messages received that, for any number of\nreasons, was discarded without a response.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the SIP entity or service.  A Management\nStation can detect discontinuities in this counter by\nmonitoring the sipCommonOtherStatsDisconTime object in the same\nrow.")
sipCommonOtherStatsDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 149, 1, 8, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sipCommonOtherStatsDisconTime.setDescription("The value of the sysUpTime object when the counters for the\nstatistics objects in this row last experienced a\ndiscontinuity.")
sipCommonNotifObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 1, 9))
sipCommonStatusCodeNotifTo = MibScalar((1, 3, 6, 1, 2, 1, 149, 1, 9, 1), SnmpAdminString()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifTo.setDescription("This object contains the value of the To header in the message\ncontaining the status code that caused the notification.  The\nheader name will be part of this object value.  For example,\n'To: Watson '.")
sipCommonStatusCodeNotifFrom = MibScalar((1, 3, 6, 1, 2, 1, 149, 1, 9, 2), SnmpAdminString()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifFrom.setDescription("This object contains the value of the From header in the\nmessage containing the status code that caused the\n\n\n\nnotification.  The header name will be part of this object\nvalue.  For example, 'From: Watson '.")
sipCommonStatusCodeNotifCallId = MibScalar((1, 3, 6, 1, 2, 1, 149, 1, 9, 3), SnmpAdminString()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifCallId.setDescription("This object contains the value of the Call-ID in the message\ncontaining the status code that caused the notification.  The\nheader name will be part of this object value.  For example,\n'Call-ID: 5551212@example.com'.")
sipCommonStatusCodeNotifCSeq = MibScalar((1, 3, 6, 1, 2, 1, 149, 1, 9, 4), Unsigned32()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: sipCommonStatusCodeNotifCSeq.setDescription("This object contains the CSeq value in the message containing\nthe status code that caused the notification.  The header name\nwill be part of this object value.  For example, 'CSeq: 1722\nINVITE'.")
sipCommonNotifApplIndex = MibScalar((1, 3, 6, 1, 2, 1, 149, 1, 9, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: sipCommonNotifApplIndex.setDescription("This object contains the applIndex as described in RFC 2788.\nThis object is created in order to allow a variable binding\ncontaining a value of applIndex in a notification.")
sipCommonNotifSequenceNumber = MibScalar((1, 3, 6, 1, 2, 1, 149, 1, 9, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: sipCommonNotifSequenceNumber.setDescription("This object contains a sequence number for each notification\ngenerated by this SIP entity.  Each notification SHOULD have a\nunique sequence number.  A network manager can use this\ninformation to determine whether notifications from a\n\n\n\nparticular SIP entity have been missed.  The value of this\nobject MUST start at 1 and increase by 1 with each generated\nnotification.  If a system restarts, the sequence number MAY\nstart again from 1.")
sipCommonMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 2))
sipCommonMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 2, 1))
sipCommonMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 149, 2, 2))

# Augmentions
sipCommonStatusCodeEntry.registerAugmentions(("SIP-COMMON-MIB", "sipCommonStatusCodeNotifEntry"))
sipCommonStatusCodeNotifEntry.setIndexNames(*sipCommonStatusCodeEntry.getIndexNames())

# Notifications

sipCommonStatusCodeNotif = NotificationType((1, 3, 6, 1, 2, 1, 149, 0, 1)).setObjects(("SIP-COMMON-MIB", "sipCommonStatusCodeNotifFrom"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifCSeq"), ("SIP-COMMON-MIB", "sipCommonStatusCodeOuts"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifCallId"), ("SIP-COMMON-MIB", "sipCommonStatusCodeIns"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifTo"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), )
if mibBuilder.loadTexts: sipCommonStatusCodeNotif.setDescription("Signifies that a specific status code has been sent or received\nby the system.")
sipCommonStatusCodeThreshExceededInNotif = NotificationType((1, 3, 6, 1, 2, 1, 149, 0, 2)).setObjects(("SIP-COMMON-MIB", "sipCommonStatusCodeIns"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), )
if mibBuilder.loadTexts: sipCommonStatusCodeThreshExceededInNotif.setDescription("Signifies that a specific status code was found to have been\nreceived by the system frequently enough to exceed the\nconfigured threshold.  This notification can be used as\nan early warning mechanism in lieu of using\nsipCommonStatusCodeNotif.")
sipCommonStatusCodeThreshExceededOutNotif = NotificationType((1, 3, 6, 1, 2, 1, 149, 0, 3)).setObjects(("SIP-COMMON-MIB", "sipCommonStatusCodeOuts"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), )
if mibBuilder.loadTexts: sipCommonStatusCodeThreshExceededOutNotif.setDescription("Signifies that a specific status code was found to have been\nsent by the system enough to exceed the configured threshold.\nThis notification can be used as an early warning mechanism in\nlieu of using sipCommonStatusCodeNotif.")
sipCommonServiceColdStart = NotificationType((1, 3, 6, 1, 2, 1, 149, 0, 4)).setObjects(("SIP-COMMON-MIB", "sipCommonCfgServiceStartTime"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), )
if mibBuilder.loadTexts: sipCommonServiceColdStart.setDescription("Signifies that the SIP service has reinitialized itself or\nstarted for the first time.  This SHOULD result from a hard\n'down' to 'up' administrative status change.  The configuration\nor behavior of the service MAY be altered.")
sipCommonServiceWarmStart = NotificationType((1, 3, 6, 1, 2, 1, 149, 0, 5)).setObjects(("SIP-COMMON-MIB", "sipCommonCfgServiceLastChange"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), )
if mibBuilder.loadTexts: sipCommonServiceWarmStart.setDescription("Signifies that the SIP service has reinitialized itself and is\nrestarting after an administrative 'reset'.  The configuration\nor behavior of the service MAY be altered.")
sipCommonServiceStatusChanged = NotificationType((1, 3, 6, 1, 2, 1, 149, 0, 6)).setObjects(("SIP-COMMON-MIB", "sipCommonCfgServiceLastChange"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), ("SIP-COMMON-MIB", "sipCommonCfgServiceOperStatus"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), )
if mibBuilder.loadTexts: sipCommonServiceStatusChanged.setDescription("Signifies that the SIP service operational status has changed.")

# Groups

sipCommonConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 1)).setObjects(("SIP-COMMON-MIB", "sipCommonCfgServiceNotifEnable"), ("SIP-COMMON-MIB", "sipCommonCfgMaxTransactions"), ("SIP-COMMON-MIB", "sipCommonCfgEntityType"), ("SIP-COMMON-MIB", "sipCommonCfgServiceOperStatus"), ("SIP-COMMON-MIB", "sipCommonOptionTag"), ("SIP-COMMON-MIB", "sipCommonMethodSupportedName"), ("SIP-COMMON-MIB", "sipCommonPortTransportRcv"), ("SIP-COMMON-MIB", "sipCommonOptionTagHeaderField"), ("SIP-COMMON-MIB", "sipCommonCfgServiceLastChange"), ("SIP-COMMON-MIB", "sipCommonCfgServiceStartTime"), ("SIP-COMMON-MIB", "sipCommonCfgProtocolVersion"), )
if mibBuilder.loadTexts: sipCommonConfigGroup.setDescription("A collection of objects providing configuration common to all\nSIP entities.")
sipCommonInformationalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 2)).setObjects(("SIP-COMMON-MIB", "sipCommonCfgOrganization"), )
if mibBuilder.loadTexts: sipCommonInformationalGroup.setDescription("A collection of objects providing configuration common to all\nSIP entities.")
sipCommonConfigTimerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 3)).setObjects(("SIP-COMMON-MIB", "sipCommonCfgTimerT1"), ("SIP-COMMON-MIB", "sipCommonCfgTimerT2"), ("SIP-COMMON-MIB", "sipCommonCfgTimerT4"), ("SIP-COMMON-MIB", "sipCommonCfgTimerH"), ("SIP-COMMON-MIB", "sipCommonCfgTimerI"), ("SIP-COMMON-MIB", "sipCommonCfgTimerJ"), ("SIP-COMMON-MIB", "sipCommonCfgTimerK"), ("SIP-COMMON-MIB", "sipCommonCfgTimerA"), ("SIP-COMMON-MIB", "sipCommonCfgTimerB"), ("SIP-COMMON-MIB", "sipCommonCfgTimerC"), ("SIP-COMMON-MIB", "sipCommonCfgTimerD"), ("SIP-COMMON-MIB", "sipCommonCfgTimerE"), ("SIP-COMMON-MIB", "sipCommonCfgTimerF"), ("SIP-COMMON-MIB", "sipCommonCfgTimerG"), )
if mibBuilder.loadTexts: sipCommonConfigTimerGroup.setDescription("A collection of objects providing timer configuration common to\nall SIP entities.")
sipCommonStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 4)).setObjects(("SIP-COMMON-MIB", "sipCommonSummaryInResponses"), ("SIP-COMMON-MIB", "sipCommonOtherStatsNumUnsupportedMethods"), ("SIP-COMMON-MIB", "sipCommonSummaryOutRequests"), ("SIP-COMMON-MIB", "sipCommonSummaryDisconTime"), ("SIP-COMMON-MIB", "sipCommonMethodStatsOutbounds"), ("SIP-COMMON-MIB", "sipCommonMethodStatsDisconTime"), ("SIP-COMMON-MIB", "sipCommonSummaryOutResponses"), ("SIP-COMMON-MIB", "sipCommonStatusCodeRowStatus"), ("SIP-COMMON-MIB", "sipCommonOtherStatsOtherwiseDiscardedMsgs"), ("SIP-COMMON-MIB", "sipCommonOtherStatsDisconTime"), ("SIP-COMMON-MIB", "sipCommonStatusCodeOuts"), ("SIP-COMMON-MIB", "sipCommonSummaryTotalTransactions"), ("SIP-COMMON-MIB", "sipCommonStatusCodeDisconTime"), ("SIP-COMMON-MIB", "sipCommonMethodStatsInbounds"), ("SIP-COMMON-MIB", "sipCommonStatusCodeIns"), ("SIP-COMMON-MIB", "sipCommonOtherStatsNumUnsupportedUris"), ("SIP-COMMON-MIB", "sipCommonTransCurrentactions"), ("SIP-COMMON-MIB", "sipCommonSummaryInRequests"), )
if mibBuilder.loadTexts: sipCommonStatsGroup.setDescription("A collection of objects providing statistics common to all SIP\nentities.")
sipCommonStatsRetryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 5)).setObjects(("SIP-COMMON-MIB", "sipCommonStatsRetryNonFinalResponses"), ("SIP-COMMON-MIB", "sipCommonStatsRetryFinalResponses"), ("SIP-COMMON-MIB", "sipCommonStatsRetries"), ("SIP-COMMON-MIB", "sipCommonStatsRetryDisconTime"), )
if mibBuilder.loadTexts: sipCommonStatsRetryGroup.setDescription("A collection of objects providing retry statistics.")
sipCommonNotifGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 6)).setObjects(("SIP-COMMON-MIB", "sipCommonServiceWarmStart"), ("SIP-COMMON-MIB", "sipCommonServiceStatusChanged"), ("SIP-COMMON-MIB", "sipCommonServiceColdStart"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotif"), ("SIP-COMMON-MIB", "sipCommonStatusCodeThreshExceededOutNotif"), ("SIP-COMMON-MIB", "sipCommonStatusCodeThreshExceededInNotif"), )
if mibBuilder.loadTexts: sipCommonNotifGroup.setDescription("A collection of notifications common to all SIP entities.")
sipCommonStatusCodeNotifGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 7)).setObjects(("SIP-COMMON-MIB", "sipCommonStatusCodeNotifEmitMode"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifThresh"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifSend"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifInterval"), )
if mibBuilder.loadTexts: sipCommonStatusCodeNotifGroup.setDescription("A collection of objects related to the control and attribution\nof notifications common to all SIP entities.")
sipCommonNotifObjectsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 149, 2, 2, 8)).setObjects(("SIP-COMMON-MIB", "sipCommonStatusCodeNotifFrom"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifCSeq"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifTo"), ("SIP-COMMON-MIB", "sipCommonNotifApplIndex"), ("SIP-COMMON-MIB", "sipCommonStatusCodeNotifCallId"), ("SIP-COMMON-MIB", "sipCommonNotifSequenceNumber"), )
if mibBuilder.loadTexts: sipCommonNotifObjectsGroup.setDescription("A collection of accessible-for-notify objects related to the\nnotification defined in this MIB module.")

# Compliances

sipCommonCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 149, 2, 1, 1)).setObjects(("SIP-COMMON-MIB", "sipCommonStatusCodeNotifGroup"), ("SIP-COMMON-MIB", "sipCommonConfigGroup"), ("SIP-COMMON-MIB", "sipCommonNotifGroup"), ("SIP-COMMON-MIB", "sipCommonNotifObjectsGroup"), ("SIP-COMMON-MIB", "sipCommonStatsRetryGroup"), ("SIP-COMMON-MIB", "sipCommonConfigTimerGroup"), ("SIP-COMMON-MIB", "sipCommonStatsGroup"), ("SIP-COMMON-MIB", "sipCommonInformationalGroup"), )
if mibBuilder.loadTexts: sipCommonCompliance.setDescription("The compliance statement for SIP entities.")

# Exports

# Module identity
mibBuilder.exportSymbols("SIP-COMMON-MIB", PYSNMP_MODULE_ID=sipCommonMIB)

# Objects
mibBuilder.exportSymbols("SIP-COMMON-MIB", sipCommonMIB=sipCommonMIB, sipCommonMIBNotifications=sipCommonMIBNotifications, sipCommonMIBObjects=sipCommonMIBObjects, sipCommonCfgBase=sipCommonCfgBase, sipCommonCfgTable=sipCommonCfgTable, sipCommonCfgEntry=sipCommonCfgEntry, sipCommonCfgProtocolVersion=sipCommonCfgProtocolVersion, sipCommonCfgServiceOperStatus=sipCommonCfgServiceOperStatus, sipCommonCfgServiceStartTime=sipCommonCfgServiceStartTime, sipCommonCfgServiceLastChange=sipCommonCfgServiceLastChange, sipCommonCfgOrganization=sipCommonCfgOrganization, sipCommonCfgMaxTransactions=sipCommonCfgMaxTransactions, sipCommonCfgServiceNotifEnable=sipCommonCfgServiceNotifEnable, sipCommonCfgEntityType=sipCommonCfgEntityType, sipCommonPortTable=sipCommonPortTable, sipCommonPortEntry=sipCommonPortEntry, sipCommonPort=sipCommonPort, sipCommonPortTransportRcv=sipCommonPortTransportRcv, sipCommonOptionTagTable=sipCommonOptionTagTable, sipCommonOptionTagEntry=sipCommonOptionTagEntry, sipCommonOptionTagIndex=sipCommonOptionTagIndex, sipCommonOptionTag=sipCommonOptionTag, sipCommonOptionTagHeaderField=sipCommonOptionTagHeaderField, sipCommonMethodSupportedTable=sipCommonMethodSupportedTable, sipCommonMethodSupportedEntry=sipCommonMethodSupportedEntry, sipCommonMethodSupportedIndex=sipCommonMethodSupportedIndex, sipCommonMethodSupportedName=sipCommonMethodSupportedName, sipCommonCfgTimer=sipCommonCfgTimer, sipCommonCfgTimerTable=sipCommonCfgTimerTable, sipCommonCfgTimerEntry=sipCommonCfgTimerEntry, sipCommonCfgTimerA=sipCommonCfgTimerA, sipCommonCfgTimerB=sipCommonCfgTimerB, sipCommonCfgTimerC=sipCommonCfgTimerC, sipCommonCfgTimerD=sipCommonCfgTimerD, sipCommonCfgTimerE=sipCommonCfgTimerE, sipCommonCfgTimerF=sipCommonCfgTimerF, sipCommonCfgTimerG=sipCommonCfgTimerG, sipCommonCfgTimerH=sipCommonCfgTimerH, sipCommonCfgTimerI=sipCommonCfgTimerI, sipCommonCfgTimerJ=sipCommonCfgTimerJ, sipCommonCfgTimerK=sipCommonCfgTimerK, sipCommonCfgTimerT1=sipCommonCfgTimerT1, sipCommonCfgTimerT2=sipCommonCfgTimerT2, sipCommonCfgTimerT4=sipCommonCfgTimerT4, sipCommonSummaryStats=sipCommonSummaryStats, sipCommonSummaryStatsTable=sipCommonSummaryStatsTable, sipCommonSummaryStatsEntry=sipCommonSummaryStatsEntry, sipCommonSummaryInRequests=sipCommonSummaryInRequests, sipCommonSummaryOutRequests=sipCommonSummaryOutRequests, sipCommonSummaryInResponses=sipCommonSummaryInResponses, sipCommonSummaryOutResponses=sipCommonSummaryOutResponses, sipCommonSummaryTotalTransactions=sipCommonSummaryTotalTransactions, sipCommonSummaryDisconTime=sipCommonSummaryDisconTime, sipCommonMethodStats=sipCommonMethodStats, sipCommonMethodStatsTable=sipCommonMethodStatsTable, sipCommonMethodStatsEntry=sipCommonMethodStatsEntry, sipCommonMethodStatsName=sipCommonMethodStatsName, sipCommonMethodStatsOutbounds=sipCommonMethodStatsOutbounds, sipCommonMethodStatsInbounds=sipCommonMethodStatsInbounds, sipCommonMethodStatsDisconTime=sipCommonMethodStatsDisconTime, sipCommonStatusCode=sipCommonStatusCode, sipCommonStatusCodeTable=sipCommonStatusCodeTable, sipCommonStatusCodeEntry=sipCommonStatusCodeEntry, sipCommonStatusCodeMethod=sipCommonStatusCodeMethod, sipCommonStatusCodeValue=sipCommonStatusCodeValue, sipCommonStatusCodeIns=sipCommonStatusCodeIns, sipCommonStatusCodeOuts=sipCommonStatusCodeOuts, sipCommonStatusCodeRowStatus=sipCommonStatusCodeRowStatus, sipCommonStatusCodeDisconTime=sipCommonStatusCodeDisconTime, sipCommonStatusCodeNotifTable=sipCommonStatusCodeNotifTable, sipCommonStatusCodeNotifEntry=sipCommonStatusCodeNotifEntry, sipCommonStatusCodeNotifSend=sipCommonStatusCodeNotifSend, sipCommonStatusCodeNotifEmitMode=sipCommonStatusCodeNotifEmitMode, sipCommonStatusCodeNotifThresh=sipCommonStatusCodeNotifThresh, sipCommonStatusCodeNotifInterval=sipCommonStatusCodeNotifInterval, sipCommonStatsTrans=sipCommonStatsTrans, sipCommonTransCurrentTable=sipCommonTransCurrentTable, sipCommonTransCurrentEntry=sipCommonTransCurrentEntry, sipCommonTransCurrentactions=sipCommonTransCurrentactions, sipCommonStatsRetry=sipCommonStatsRetry, sipCommonStatsRetryTable=sipCommonStatsRetryTable, sipCommonStatsRetryEntry=sipCommonStatsRetryEntry, sipCommonStatsRetryMethod=sipCommonStatsRetryMethod, sipCommonStatsRetries=sipCommonStatsRetries, sipCommonStatsRetryFinalResponses=sipCommonStatsRetryFinalResponses, sipCommonStatsRetryNonFinalResponses=sipCommonStatsRetryNonFinalResponses, sipCommonStatsRetryDisconTime=sipCommonStatsRetryDisconTime, sipCommonOtherStats=sipCommonOtherStats, sipCommonOtherStatsTable=sipCommonOtherStatsTable, sipCommonOtherStatsEntry=sipCommonOtherStatsEntry, sipCommonOtherStatsNumUnsupportedUris=sipCommonOtherStatsNumUnsupportedUris, sipCommonOtherStatsNumUnsupportedMethods=sipCommonOtherStatsNumUnsupportedMethods, sipCommonOtherStatsOtherwiseDiscardedMsgs=sipCommonOtherStatsOtherwiseDiscardedMsgs, sipCommonOtherStatsDisconTime=sipCommonOtherStatsDisconTime, sipCommonNotifObjects=sipCommonNotifObjects, sipCommonStatusCodeNotifTo=sipCommonStatusCodeNotifTo, sipCommonStatusCodeNotifFrom=sipCommonStatusCodeNotifFrom, sipCommonStatusCodeNotifCallId=sipCommonStatusCodeNotifCallId, sipCommonStatusCodeNotifCSeq=sipCommonStatusCodeNotifCSeq, sipCommonNotifApplIndex=sipCommonNotifApplIndex, sipCommonNotifSequenceNumber=sipCommonNotifSequenceNumber, sipCommonMIBConformance=sipCommonMIBConformance, sipCommonMIBCompliances=sipCommonMIBCompliances, sipCommonMIBGroups=sipCommonMIBGroups)

# Notifications
mibBuilder.exportSymbols("SIP-COMMON-MIB", sipCommonStatusCodeNotif=sipCommonStatusCodeNotif, sipCommonStatusCodeThreshExceededInNotif=sipCommonStatusCodeThreshExceededInNotif, sipCommonStatusCodeThreshExceededOutNotif=sipCommonStatusCodeThreshExceededOutNotif, sipCommonServiceColdStart=sipCommonServiceColdStart, sipCommonServiceWarmStart=sipCommonServiceWarmStart, sipCommonServiceStatusChanged=sipCommonServiceStatusChanged)

# Groups
mibBuilder.exportSymbols("SIP-COMMON-MIB", sipCommonConfigGroup=sipCommonConfigGroup, sipCommonInformationalGroup=sipCommonInformationalGroup, sipCommonConfigTimerGroup=sipCommonConfigTimerGroup, sipCommonStatsGroup=sipCommonStatsGroup, sipCommonStatsRetryGroup=sipCommonStatsRetryGroup, sipCommonNotifGroup=sipCommonNotifGroup, sipCommonStatusCodeNotifGroup=sipCommonStatusCodeNotifGroup, sipCommonNotifObjectsGroup=sipCommonNotifObjectsGroup)

# Compliances
mibBuilder.exportSymbols("SIP-COMMON-MIB", sipCommonCompliance=sipCommonCompliance)
