# PySNMP SMI module. Autogenerated from smidump -f python SNA-SDLC-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:14 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ifAdminStatus, ifIndex, ifOperStatus, mib_2, ) = mibBuilder.importSymbols("RFC1213-MIB", "ifAdminStatus", "ifIndex", "ifOperStatus", "mib-2")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks")
( DisplayString, RowStatus, TimeInterval, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowStatus", "TimeInterval")

# Objects

snaDLC = ModuleIdentity((1, 3, 6, 1, 2, 1, 41)).setRevisions(("1994-11-15 00:00",))
if mibBuilder.loadTexts: snaDLC.setOrganization("IETF SNA DLC MIB Working Group")
if mibBuilder.loadTexts: snaDLC.setContactInfo("        Wayne Clark\n\nPostal: cisco Systems, Inc.\n        3100 Smoketree Ct.\n        Suite 1000\n        Raleigh, NC 27604\n        US\n\n   Tel: +1 919 878 6958\n\nE-Mail: wclark@cisco.com")
if mibBuilder.loadTexts: snaDLC.setDescription("This is the MIB module for objects used to\nmanage SDLC devices.")
sdlc = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1))
sdlcPortGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 1))
sdlcPortAdminTable = MibTable((1, 3, 6, 1, 2, 1, 41, 1, 1, 1))
if mibBuilder.loadTexts: sdlcPortAdminTable.setDescription("This table contains objects that can be\nchanged to manage an SDLC port.    Changing one\nof these parameters may take effect in the\noperating port immediately or may wait until\nthe interface is restarted depending on the\ndetails of the implementation.\n\nMost of the objects in this read-write table\nhave corresponding read-only objects in the\nsdlcPortOperTable that return the current\noperating value.\n\nThe operating values may be different from\nthese configured values if  a configured\nparameter was changed after the interface was\nstarted.")
sdlcPortAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"))
if mibBuilder.loadTexts: sdlcPortAdminEntry.setDescription("A list of configured values for an SDLC port.")
sdlcPortAdminName = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminName.setDescription("An octet string that defines the physical port\nto which this interface is assigned.  It has\nimplementation-specific significance. Its value\nshall be unique within the administered\nsystem.  It must contain only ASCII printable\ncharacters.  Should an implementation choose to\naccept a write operation  for this object, it\ncauses the logical port definition associated\nwith the table instance to be moved to  a\ndifferent physical port.  A write operation\nshall not take effect until the port is cycled\ninactive.")
sdlcPortAdminRole = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("primary", 1), ("secondary", 2), ("negotiable", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminRole.setDescription("This object describes the role that the link\nstation shall assume the next time a connection\nis established.\n\nEven though this is defined as a port object,\nit is a link station attribute in the sense\nthat a role is per link station.  However, it\nis not possible to vary link station roles on a\nparticular port.  For example, if an SDLC port\nis configured to primary, all link stations on\nthat port must be primary.")
sdlcPortAdminType = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("leased", 1), ("switched", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminType.setDescription("This parameter defines whether the SDLC port\nis to connect to a leased or switched line.  A\nwrite operation to this administrative  value\nshall not take effect until the SDLC port has\nbeen cycled inactive.")
sdlcPortAdminTopology = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("pointToPoint", 1), ("multipoint", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminTopology.setDescription("This parameter defines whether the SDLC port is\ncapable of operating in either a point-to-point\nor multipoint topology.\n\nsdlcPortAdminTopology == multipoint implies the\nport can also operate in a point-to-point\ntopology.  sdlcPortAdminTopology ==\npointToPoint does not imply the port can\noperate in a multipoint topology.\n\nA write operation to this administrative value\nshall not take effect until the SDLC port has\nbeen cycled inactive.")
sdlcPortAdminISTATUS = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminISTATUS.setDescription("This parameter controls the initial value of\nthe administrative status, ifAdminStatus, of\nthis SDLC port at port start-up.  Depending\non the implementation, a write operation to\nthis administrative object may not take effect\nuntil the SDLC port has been cycled inactive.")
sdlcPortAdminACTIVTO = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 6), TimeInterval().clone('0')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminACTIVTO.setDescription("This parameter defines the period of time (in\n1/100ths of a second) that the port will allow a\nswitched line to remain inactive before\ndisconnecting.  A switched line is considered\nto be inactive if there are no I-Frames being\ntransferred.  A value of zero indicates no\ntimeout.  Depending on the implementation, a\nwrite operation to this administered value may\nnot take effect until the port is cycled\ninactive.\n\nThis object only has meaning for SDLC ports\nwhere sdlcPortAdminType == switched\n\nThe object descriptor contains the name of an\nNCP configuration parameter, ACTIVTO.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP ACTIVTO is\nrepresented in seconds.")
sdlcPortAdminPAUSE = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 7), TimeInterval().clone('200')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminPAUSE.setDescription("This object defines the minimum elapsed time\n(in 1/100ths of a second) between any two\ntraversals of the poll list for a primary SDLC\nport.  Depending on the implementation, a write\noperation to this administered value  may not\ntake effect until the port is cycled inactive.\nThe object descriptor contains the name of an\nNCP configuration parameter, PAUSE.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP PAUSE is\nrepresented in 1/10ths of a second.\n\nThis object only has meaning for SDLC ports\nwhere sdlcPortAdminRole == primary ")
sdlcPortAdminSERVLIM = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 8), Integer32().clone(20)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminSERVLIM.setDescription("This object defines the number of times the\nactive poll list will be traversed before\npolling a station on the slow poll list for a\nprimary, multipoint SDLC port.  Depending  on\nthe implementation, a write operation to this\nadministered value  may not take effect until\nthe port is cycled inactive.\n\nThis object only has meaning for SDLC ports\nwhere\n    sdlcPortAdminRole == primary\nand\n    sdlcPortAdminTopology == multipoint ")
sdlcPortAdminSlowPollTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 1, 1, 9), TimeInterval().clone('2000')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sdlcPortAdminSlowPollTimer.setDescription("This object describes the elapsed time (in\n1/100ths of a second) between polls for failed\nsecondary link station addresses.  Depending\non the implementation, a write operation to\nthis administered value  may not take effect\nuntil the port is cycled inactive.\n\nThis object only has meaning for SDLC ports\nwhere\n    sdlcPortAdminRole == primary\nand\n    sdlcPortAdminTopology == multipoint ")
sdlcPortOperTable = MibTable((1, 3, 6, 1, 2, 1, 41, 1, 1, 2))
if mibBuilder.loadTexts: sdlcPortOperTable.setDescription("This table contains current SDLC port\nparameters.  Many of these objects have\ncorresponding objects inthe sdlcPortAdminTable.")
sdlcPortOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"))
if mibBuilder.loadTexts: sdlcPortOperEntry.setDescription("Currently set parameters for a specific SDLC\nport.")
sdlcPortOperName = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperName.setDescription("An octet string that describes the physical\nport to which this interface is currently\nattached.  It has  implementation-specific\nsignificance.")
sdlcPortOperRole = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("primary", 1), ("secondary", 2), ("undefined", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperRole.setDescription("This object describes the role that the link\nstation has assumed on this connection.\n\nEven though this is defined as a port object,\nit is a link station attribute in the sense\nthat a role is per link station.  However, it\nis not possible to vary link station roles on a\nparticular port.  For example, if an SDLC port\nis configured to primary, all link stations on\nthat port must be primary.\n\nThe value of sdlcPortOperRole is undefined(3)\nwhenever the link station role has not yet been\nestablished by the mode setting command.")
sdlcPortOperType = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("leased", 1), ("switched", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperType.setDescription("This parameter defines whether the SDLC port\nis currently operating as though connected to a\nleased or switched line.")
sdlcPortOperTopology = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("pointToPoint", 1), ("multipoint", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperTopology.setDescription("This parameter defines whether the SDLC port is\ncurrently operating in a point-to-point or\nmultipoint topology.")
sdlcPortOperISTATUS = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperISTATUS.setDescription("This parameter describes the initial value of\nthe administrative status, ifAdminStatus, of\nthis SDLC port at last port start-up.")
sdlcPortOperACTIVTO = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 6), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperACTIVTO.setDescription("This parameter defines the period of time (in\n100ths of a second) that the port will allow a\nswitched line to remain inactive before\ndisconnecting.  A switched line is considered\nto be inactive if there are no I-Frames being\ntransferred.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, ACTIVTO.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP ACTIVTO is\nrepresented in seconds.\nA value of zero indicates no timeout.")
sdlcPortOperPAUSE = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 7), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperPAUSE.setDescription("This object describes the current minimum\nelapsed time (in 1/100ths of a second) between\nany two traversals of the poll list for a\nprimary SDLC port.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, PAUSE.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP PAUSE is\nrepresented in 1/10ths of a second.\n\nThis object only has meaning for SDLC ports\nwhere\n    sdlcPortAdminRole == primary ")
sdlcPortOperSlowPollMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("servlim", 1), ("pollpause", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperSlowPollMethod.setDescription("This object defines the exact method that is in\neffect for periodically polling failed secondary\nlink station addresses.\n\nIf sdlcPortOperSlowPollMethod == servlim, then\nsdlcPortOperSERVLIM defines the actual polling\ncharacteristics.\n\nIf sdlcPortOperSlowPollMethod == pollpause,\nthen sdlcPortOperSlowPollTimer defines the\nactual polling characteristics.\n\nIf sdlcPortOperSlowPollMethod == other, then\nthe polling characteristics are modeled in\nvendor-specific objects.\n\nThis object only has meaning for SDLC ports\nwhere\n    sdlcPortOperRole == primary\nand\n    sdlcPortOperTopology == multipoint ")
sdlcPortOperSERVLIM = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 9), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperSERVLIM.setDescription("This object describes the number of times the\nactive poll list is currently being traversed\nbefore polling a station on the slow poll list\nfor a primary, multipoint SDLC port.\n\nThis object only has meaning for SDLC ports\nwhere\n    sdlcPortOperRole == primary\nand\n    sdlcPortOperTopology == multipoint ")
sdlcPortOperSlowPollTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 10), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperSlowPollTimer.setDescription("This object describes the elapsed time (in\n1/100ths of a second) between polls for failed\nsecondary link station addresses.\n\nThis object only has meaning for SDLC ports\nwhere\n    sdlcPortOperRole == primary\nand\n    sdlcPortOperTopology == multipoint ")
sdlcPortOperLastModifyTime = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperLastModifyTime.setDescription("This object describes the value of sysUpTime\nwhen this port definition was last modified.\nIf the port has not been modified, then this\nvalue shall be zero.")
sdlcPortOperLastFailTime = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 12), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperLastFailTime.setDescription("This object describes the value of sysUpTime\nwhen this SDLC port last failed.  If the port\nhas not failed, then this value shall be zero.")
sdlcPortOperLastFailCause = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 2, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("undefined", 1), ("physical", 2), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortOperLastFailCause.setDescription("This enumerated object describes the cause of\nthe last failure of this SDLC port.  If the\nport has not failed, then this object has a\nvalue of undefined(1).")
sdlcPortStatsTable = MibTable((1, 3, 6, 1, 2, 1, 41, 1, 1, 3))
if mibBuilder.loadTexts: sdlcPortStatsTable.setDescription("Each entry in this table contains statistics\nfor a specific SDLC port.")
sdlcPortStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"))
if mibBuilder.loadTexts: sdlcPortStatsEntry.setDescription("A list of statistics for an SDLC port.")
sdlcPortStatsPhysicalFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsPhysicalFailures.setDescription("This object reflects the total number of times\nthis port has failed due to its physical media\nsince port startup.  At port startup time,\nthis object must be initialized to zero.")
sdlcPortStatsInvalidAddresses = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsInvalidAddresses.setDescription("This object reflects the total number of\nframes received by this port with invalid link\nstation addresses.")
sdlcPortStatsDwarfFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsDwarfFrames.setDescription("This object reflects the total number of\nframes received by this port which were\ndelivered intact by the physical layer but were\ntoo short to be legal.\n\nIgnoring the frame check sequence (FCS), a\nframe is considered to be too short if it\nis less than 2 bytes for sdlcLSOperMODULO of\neight, or if it is less than 3 bytes for\nsdlcLSOperMODULO of onetwentyeight.")
sdlcPortStatsPollsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsPollsIn.setDescription("This object reflects the total number of polls\nreceived by this port since the port was\ncreated.")
sdlcPortStatsPollsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsPollsOut.setDescription("This object reflects the total number of polls\nsent by this port since the port was created.")
sdlcPortStatsPollRspsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsPollRspsIn.setDescription("This object reflects the total number of poll\nresponses received by this port since the port\nwas created.")
sdlcPortStatsPollRspsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsPollRspsOut.setDescription("This object reflects the total number of poll\nresponses sent by this port since the port was\ncreated.")
sdlcPortStatsLocalBusies = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsLocalBusies.setDescription("This object reflects the total number of\ntimes that the local SDLC link stations on\nthis port have entered a busy state (RNR).\nThis object is initialized to zero when the\nport is created.")
sdlcPortStatsRemoteBusies = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsRemoteBusies.setDescription("This object reflects the total number of\ntimes that the adjacent (i.e., remote) SDLC\nlink stations on this port have entered a busy\nstate (RNR).  This object is initialized to\nzero when the port is created.")
sdlcPortStatsIFramesIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsIFramesIn.setDescription("This object reflects the total number of\nI-Frames that have been received by SDLC link\nstations on this port.  This object is\ninitialized to zero when the port is created.")
sdlcPortStatsIFramesOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsIFramesOut.setDescription("This object reflects the total number of\nI-Frames that have been transmitted by SDLC\nlink stations on this port.  This object is\ninitialized to zero when the port is created.")
sdlcPortStatsOctetsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsOctetsIn.setDescription("This object reflects the total octets\nreceived from adjacent SDLC link stations on\nthis port.  This object covers the address,\ncontrol, and information field of I-Frames\nonly.  This object is initialized to zero when\nthe port is created.")
sdlcPortStatsOctetsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsOctetsOut.setDescription("This object reflects the total octets\ntransmitted to adjacent SDLC link stations on\nthis port.  This object covers the address,\ncontrol, and information field of I-Frames\nonly.  This object is initialized to zero when\nthe port is created.")
sdlcPortStatsProtocolErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsProtocolErrs.setDescription("This object reflects the total number of\ntimes that the SDLC link stations on this port\nhave deactivated the link as a result of\nhaving received a protocol violation from the\nadjacent link station.  This object is\ninitialized to zero when the port is created.")
sdlcPortStatsActivityTOs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsActivityTOs.setDescription("This object reflects the total number of\ntimes that the SDLC link stations on this port\nhave deactivated the link as a result of no\nactivity on the link.  This object is\ninitialized to zero when the port is created.")
sdlcPortStatsRNRLIMITs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsRNRLIMITs.setDescription("This object reflects the total number of\ntimes that the SDLC link stations on this port\nhave deactivated the link as a result of its\nRNRLIMIT timer expiring.  This object is\ninitialized to zero when the port is created.")
sdlcPortStatsRetriesExps = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsRetriesExps.setDescription("This object reflects the total number of\ntimes that the SDLC link stations on this port\nhave deactivated the link as a result of a\nretry sequence being exhausted.  This object\nis initialized to zero when the port is\ncreated.")
sdlcPortStatsRetransmitsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsRetransmitsIn.setDescription("This object reflects the total number of\nI-Frames retransmitted by remote link stations\nfor all SDLC link stations on this port.  This\nobject is initialized to zero when the port is\ncreated.")
sdlcPortStatsRetransmitsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 1, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcPortStatsRetransmitsOut.setDescription("This object reflects the total number of\nI-Frames retransmitted by all local SDLC link\nstations on this port.  This object is\ninitialized to zero when the port is created.")
sdlcLSGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 2))
sdlcLSAdminTable = MibTable((1, 3, 6, 1, 2, 1, 41, 1, 2, 1))
if mibBuilder.loadTexts: sdlcLSAdminTable.setDescription("This table contains objects that can be\nchanged to manage an SDLC link station.\nChanging one of these parameters may take\neffect in the operating link immediately or may\nwait until the link is restarted depending on\nthe details of the implementation.\n\nThe entries in sdlcLSAdminTable can be created\neither by an agent or a management station. The\nmanagement station can create an entry in\nsdlcLSAdminTable by setting the appropriate\nvalue in sdlcLSAdminRowStatus.\n\nMost of the objects in this read-create table\nhave corresponding read-only objects in the\nsdlcLSOperTable that reflect the current\noperating value.\n\nThe operating values may be different from\nthese configured values if changed by XID\nnegotiation or if a configured parameter was\nchanged after the link was started.")
sdlcLSAdminEntry = MibTableRow((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"), (0, "SNA-SDLC-MIB", "sdlcLSAddress"))
if mibBuilder.loadTexts: sdlcLSAdminEntry.setDescription("A list of configured values for an SDLC link\nstation.")
sdlcLSAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAddress.setDescription("This value is the poll address of the\nsecondary link station for this SDLC link.  It\nuniquely identifies the SDLC link station\nwithin a single SDLC port.")
sdlcLSAdminName = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 2), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminName.setDescription("An octet string that defines the local name of\nthe SDLC link station.  This field may be sent\nin the XID3 control vector 0x0E, type 0xF7.")
sdlcLSAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminState.setDescription("This object controls the desired state of the\nSDLC station.  The managed system shall attempt\nto keep the operational state, sdlcLSOperState,\nconsistent with this value.")
sdlcLSAdminISTATUS = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("inactive", 1), ("active", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminISTATUS.setDescription("This parameter controls the desired state,\nsdlcLSAdminState, of the SDLC link station at\nlink station start-up.")
sdlcLSAdminMAXDATASend = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 5), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminMAXDATASend.setDescription("This object contains the maximum PDU size that\nthe local link station thinks it can send to\nthe adjacent link station before having\nreceived any XID from the ALS.  After the\nmaximum PDU size that the ALS can receive is\nknown (via XID exchange) that value is\nreflected in sdlcLSOperMAXDATASend and takes\nprecedence over this object.\n\nThis value includes the Transmission Header\n(TH) and the Request Header (RH).")
sdlcLSAdminMAXDATARcv = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 6), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminMAXDATARcv.setDescription("This object contains the maximum PDU size that\nthe local link station can receive from the\nadjacent link station.  This value is sent in\nthe XID to the ALS.\n\nThis value includes the Transmission Header\n(TH) and the Request Header (RH).")
sdlcLSAdminREPLYTO = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 7), TimeInterval().clone('100')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminREPLYTO.setDescription("This object controls the reply timeout (in\n1/100ths of a second) for an SDLC link\nstation.  If the link station does not receive\na response to a poll or message before the\nspecified time expires then the appropriate\nerror recovery shall be initiated.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, REPLYTO.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP REPLYTO is\nrepresented in 1/10ths of a second.\n\nDepending on the implementation, a write\noperation to this administered value  may not\nchange the operational value, sdlcLSOperREPLYTO,\nuntil the link station is cycled inactive.\n\nThis object only has meaning for SDLC ports\nwhere sdlcPortAdminRole == primary ")
sdlcLSAdminMAXIN = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 127)).clone(7)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminMAXIN.setDescription("This object controls the maximum number of\nunacknowledged I-frames which an SDLC link\nstation may receive.  This should range from 1\nto (sdlcLSAdminMODULO - 1).  This value is sent\nin the XID to the ALS.\n\nA write operation to this administered value\nwill not change the operational value,\nsdlcLSOperMAXIN, until the link station is\ncycled inactive.")
sdlcLSAdminMAXOUT = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 127)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminMAXOUT.setDescription("This object controls the maximum number of\nconsecutive unacknowledged I-frames which an\nSDLC link station shall send without an\nacknowledgement.  This shall range from 1 to\n(sdlcLSAdminMODULO - 1).\n\nFor link stations on switched SDLC lines,\ncertain implementions may choose to override\nthis administered value with the value\nreceived in the XID exchange.\n\nDepending on the implementation, a write\noperation to this administered value may not\nchange the operational value,\nsdlcLSOperMAXOUT, until the link station is\ncycled inactive.\n\nAn implementation can support only modulo 8,\nonly modulo 128, or both.")
sdlcLSAdminMODULO = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(128,8,)).subtype(namedValues=namedval.NamedValues(("onetwentyeight", 128), ("eight", 8), )).clone(8)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminMODULO.setDescription("This object controls the modulus for an SDLC\nlink station.  This modulus determines the size\nof the rotating acknowledgement window used the\nSDLC link station pair.\n\nA write operation to this administered value\nwill not change the operational value,\nsdlcLSOperMODULO, until the link station is\ncycled inactive.\n\nAn implementation can support only modulo 8,\nonly modulo 128, or both.")
sdlcLSAdminRETRIESm = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128)).clone(15)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminRETRIESm.setDescription("This object controls number of retries in a\nretry sequence for the local SDLC link\nstation.  A retry sequence is a series of\nretransmitted frames ( data or control) for\nwhich no positive acknowledgement is received.\n\nThe number of times that the retry sequence is\nto be repeated is controlled by the object:\nsdlcLSAdminRETRIESn.  The interval between retry\nsequences is controlled by the object:\nsdlcLSAdminRETRIESt.\n\nA value of zero indicates no retries. If the\nvalue of sdlcLSAdminRETRIESm is zero, then the\nvalues of sdlcLSAdminRETRIESt and\nsdlcLSAdminRETRIESn should also be zero.\n\nDepending on the implementation, a write\noperation to this administered value  may not\nchange the operational value,\nsdlcLSOperRETRIESm, until the link station is\ncycled inactive.")
sdlcLSAdminRETRIESt = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 12), TimeInterval().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminRETRIESt.setDescription("This object controls the interval (in 1/100ths\nof a second) between retry sequences for the\nlocal SDLC link station if multiple retry\nsequences are specified .  A retry sequence is\na series of retransmitted frames ( data or\ncontrol) for which no positive acknowledgement\nis received.\n\nThe number of repeated retries sequences is\ncontrolled by the object: sdlcLSAdminRETRIESn.\nThe retries per sequence is controlled by the\nobject:  sdlcLSAdminRETRIESm.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, RETRIESt.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP RETRIESt is\nrepresented in seconds.\n\nDepending on the implementation, a write\noperation to this administered value  may not\nchange the operational value,\nsdlcLSOperRETRIESt, until the link station is\ncycled inactive.")
sdlcLSAdminRETRIESn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 13), Integer32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminRETRIESn.setDescription("This object controls the number of times that\na retry sequence is repeated for the local SDLC\nlink station.  A retry sequence is a series of\nretransmitted frames ( data or control) for\nwhich no positive acknowledgement is received.\n\nThe interval between retry sequences is\ncontrolled by the object: sdlcLSAdminRETRIESn.\nThe retries per sequence is controlled by the\nobject:  sdlcLSAdminRETRIESm.\n\nDepending on the implementation, a write\noperation to this administered value  may not\nchange the operational value,\nsdlcLSOperRETRIESn, until the link station is\ncycled inactive.")
sdlcLSAdminRNRLIMIT = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 14), TimeInterval().clone('18000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminRNRLIMIT.setDescription("This object controls the length of time (in\n1/100ths of a second) that an SDLC link station\nwill allow its adjacent link station to remain\nin a busy (RNR) state before declaring it\ninoperative.\n\nA value of sdlcLSAdminRNRLIMIT == 0 means there\nis no limit.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, RNRLIMIT.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP RNRLIMIT is\nrepresented in minutes.\n\nDepending on the implementation, a write\noperation to this administered value  may not\nchange the operational value,\nsdlcLSOperRNRLIMIT, until the link station is\ncycled inactive.")
sdlcLSAdminDATMODE = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 15), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("half", 1), ("full", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminDATMODE.setDescription("This object controls whether communications\nmode with the adjacent link station is\ntwo-way-alternate (half) or two-way-simultaneous\n(full).\n\nA write operation to this administered value\nwill not change the operational value,\nsdlcLSOperDATMODE, until the link station is\ncycled inactive.")
sdlcLSAdminGPoll = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 254))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminGPoll.setDescription("This object describes the group poll address\nfor this link station instance.  If group poll\nis not in effect for this link station\ninstance, the value for sdlcLSAdminGPoll should\nbe zero.\n\nDepending on the implementation, a write\noperation to this administered value may not\nchange the operational value, sdlcLSOperGPoll,\nuntil the link station is cycled inactive.")
sdlcLSAdminSimRim = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("no", 1), ("yes", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminSimRim.setDescription("This object controls the support for\ntransmission and receipt of SIM and RIM control\nframes for this link station.  The value of\nthis object controls the setting of the\ntransmit-receive capability sent in the XID\nfield.")
sdlcLSAdminXmitRcvCap = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 18), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("twa", 1), ("tws", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminXmitRcvCap.setDescription("This object controls the transmit-receive\ncapabilities for this SDLC link station.  The\nvalue of this object establishes the value of\nthe transmit-receive capability indicator sent\nin the XID image to the adjacent link station.")
sdlcLSAdminRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 1, 1, 19), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: sdlcLSAdminRowStatus.setDescription("This object is used by a management station to\ncreate or delete the row entry in\nsdlcLSAdminTable following the RowStatus\ntextual convention.\n\nUpon successful creation of the row, an agent\nautomatically creates a corresponding entry in\nthe sdlcLSOperTable with sdlcLSOperState equal\nto 'discontacted (1)'.")
sdlcLSOperTable = MibTable((1, 3, 6, 1, 2, 1, 41, 1, 2, 2))
if mibBuilder.loadTexts: sdlcLSOperTable.setDescription("This table contains current SDLC link\nparameters.  Many of these objects have\ncorresponding objects in the\nsdlcLSAdminTable.")
sdlcLSOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"), (0, "SNA-SDLC-MIB", "sdlcLSAddress"))
if mibBuilder.loadTexts: sdlcLSOperEntry.setDescription("A list of status and control values for an\nSDLC link station.")
sdlcLSOperName = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 10))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperName.setDescription("An octet string that defines the name of the\nremote SDLC link station.  This field is\nreceived in the XID3 control vector 0x0E, type\n0xF7.")
sdlcLSOperRole = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("primary", 1), ("secondary", 2), ("undefined", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperRole.setDescription("This object reflects the current role that the\nlink station is assuming.\n\nThe value of sdlcLSOperRole is undefined(3)\nwhenever the link station role has not yet been\nestablished by the mode setting command.")
sdlcLSOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,2,1,3,)).subtype(namedValues=namedval.NamedValues(("discontacted", 1), ("contactPending", 2), ("contacted", 3), ("discontactPending", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperState.setDescription("This object describes the operational state of\nthe SDLC link station.  The managed system\nshall attempt to keep this value consistent\nwith the administered state, sdlcLSAdminState")
sdlcLSOperMAXDATASend = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperMAXDATASend.setDescription("This object contains the actual maximum PDU\nsize that the local link station can send to\nthe adjacent link station.  This object is\nestablished from the value received in the XID\nfrom the adjacent link station.  If no XID\nis received, then this value is implementation\ndependent (for instance, it could be the value\nof sdlcLSAdminMAXDATASend).\nThis value includes the Transmission Header\n(TH) and the Request Header (RH).")
sdlcLSOperREPLYTO = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 5), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperREPLYTO.setDescription("This object reflects the current reply timeout\n(in 1/100ths of a second) for an SDLC link\nstation.  If the link station does not receive\na response to a poll or message before the\nspecified time expires then the appropriate\nerror recovery shall be initiated.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, REPLYTO.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP REPLYTO is\nrepresented in 1/10ths of a second.\n\nThis object only has meaning for SDLC ports\nwhere sdlcPortOperRole == primary ")
sdlcLSOperMAXIN = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperMAXIN.setDescription("This object reflects the current maximum\nnumber of unacknowledged I-frames which an SDLC\nlink station may receive.  This shall range\nfrom 1 to (sdlcLSOperMODULO - 1).")
sdlcLSOperMAXOUT = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperMAXOUT.setDescription("This object controls the maximum number of\nconsecutive unacknowledged I-frames which an\nSDLC link station shall send without an\nacknowledgement.  This shall range from 1 to\n(sdlcLSAdminMODULO - 1).\nThis value may controlled by the administered\nMAXOUT, sdlcLSAdminMAXOUT, or by the MAXIN value\nreceived during the XID exchange.")
sdlcLSOperMODULO = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(128,8,)).subtype(namedValues=namedval.NamedValues(("onetwentyeight", 128), ("eight", 8), )).clone(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperMODULO.setDescription("This object reflects the current modulus for\nan SDLC link station.  This modulus determines\nthe size of rotating acknowledgement window\nused by the SDLC link station pair.")
sdlcLSOperRETRIESm = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperRETRIESm.setDescription("This object controls number of retries in a\nretry sequence for an SDLC link station.  A\nretry sequence is a series of retransmitted\nframes ( data or control) for which no positive\nacknowledgement is received.\n\nThe current number of times that the retry\nsequence is to be repeated is reflected by the\nobject:  sdlcLSOperRETRIESn.  The current\ninterval between retry sequences is reflected\nby the object:  sdlcLSOperRETRIESt.")
sdlcLSOperRETRIESt = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 10), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperRETRIESt.setDescription("This object reflects the current interval (in\n1/100ths of a second) between retry sequences\nfor an SDLC link station if multiple retry\nsequences are specified.  A retry sequence is a\nseries of retransmitted frames ( data or\ncontrol) for which no positive acknowledgement\nis received.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, RETRIESt.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP RETRIESt is\nrepresented in seconds.\n\nThe current number of repeated retries\nsequences is reflected by the object:\nsdlcLSOperRETRIESn.  The current retries per\nsequence is reflected by the object:\nsdlcLSOperRETRIESm.")
sdlcLSOperRETRIESn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperRETRIESn.setDescription("This object reflects the current number of\ntimes that a retry sequence is repeated for an\nSDLC link station.  A retry sequence is a\nseries of retransmitted frames ( data or\ncontrol) for which no positive acknowledgement\nis received.\n\nThe current interval between retry sequences is\nreflected by the object: sdlcLSOperRETRIESn.\nThe current retries per sequence is reflected\nby the object:  sdlcLSOperRETRIESm.")
sdlcLSOperRNRLIMIT = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 12), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperRNRLIMIT.setDescription("This object reflects the current length of\ntime (in 1/100ths of a second) that an SDLC\nlink station will allow its adjacent link\nstation to remain in a busy (RNR) state before\ndeclaring it inoperative.\n\nThe object descriptor contains the name of an\nNCP configuration parameter, RNRLIMIT.  Please\nnote that the value of this object represents\n1/100ths of a second while the NCP RNRLIMIT is\nrepresented in minutes.\n\nA value of sdlcLSOperRNRLIMIT == 0 means there\nis no limit.")
sdlcLSOperDATMODE = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("half", 1), ("full", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperDATMODE.setDescription("This object reflects whether the current\ncommunications mode with the adjacent link\nstation is two-way-alternate (half) or\ntwo-way-simultaneous (full).")
sdlcLSOperLastModifyTime = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 14), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastModifyTime.setDescription("This object describes the value of sysUpTime\nwhen this link station definition was last\nmodified.  If the link station has not been\nmodified, then this value shall be zero.")
sdlcLSOperLastFailTime = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 15), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastFailTime.setDescription("This object describes the value of sysUpTime\nwhen this SDLC link station last failed.  If\nthe link station has not failed, then this\nvalue shall be zero.")
sdlcLSOperLastFailCause = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,1,2,5,7,8,4,3,)).subtype(namedValues=namedval.NamedValues(("undefined", 1), ("rxFRMR", 2), ("txFRMR", 3), ("noResponse", 4), ("protocolErr", 5), ("noActivity", 6), ("rnrLimit", 7), ("retriesExpired", 8), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastFailCause.setDescription("This enumerated object reflects the cause of\nthe last failure of this SDLC link station.  If\nthe link station has not failed, then this\nobject will have a value of undefined(1).")
sdlcLSOperLastFailCtrlIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 17), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 2))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastFailCtrlIn.setDescription("This object reflects the last control octet or\noctets (depending on modulus) received by this\nSDLC link station at the time of the last\nfailure.  If the link station has not failed,\nthen this value has no meaning.")
sdlcLSOperLastFailCtrlOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 18), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 2))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastFailCtrlOut.setDescription("This object reflects the last control octet or\noctets (depending on modulus) sent by this SDLC\nlink station at the time of the last failure.\nIf the link station has not failed, then this\nvalue has no meaning.")
sdlcLSOperLastFailFRMRInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 19), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(3, 3)).setFixedLength(3)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastFailFRMRInfo.setDescription("This object reflects the information field of\nthe FRMR frame if the last failure for this\nSDLC link station was as a result of an invalid\nframe.  Otherwise, this field has no meaning.")
sdlcLSOperLastFailREPLYTOs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperLastFailREPLYTOs.setDescription("This object reflects the number of times that\nthe REPLYTO timer had expired for an SDLC link\nstation at the time of the last failure. If the\nlink station has not failed, then this value\nhas no meaning.")
sdlcLSOperEcho = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("no", 1), ("yes", 2), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperEcho.setDescription("This object identifies whether the echo bit is\nin effect for this particular link station.")
sdlcLSOperGPoll = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 22), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 254)).clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperGPoll.setDescription("This object describes the group poll address\nin effect for this link station instance.")
sdlcLSOperSimRim = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 23), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("no", 1), ("yes", 2), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperSimRim.setDescription("This object reflects the support for\ntransmission and receipt of SIM and RIM control\nframes for the adjacent link station.  The\nvalue of this object is set from the XID field\nreceived from the adjacent link station.")
sdlcLSOperXmitRcvCap = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 2, 1, 24), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("twa", 1), ("tws", 2), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSOperXmitRcvCap.setDescription("This object reflects the transmit-receive\ncapabilities for the adjacent SDLC link\nstation.  The value of this object is the value\nof the transmit-receive capability indicator\nreceived in the XID image from the adjacent\nlink station.")
sdlcLSStatsTable = MibTable((1, 3, 6, 1, 2, 1, 41, 1, 2, 3))
if mibBuilder.loadTexts: sdlcLSStatsTable.setDescription("Each entry in this table contains statistics\nfor a specific SDLC link station.")
sdlcLSStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1)).setIndexNames((0, "RFC1213-MIB", "ifIndex"), (0, "SNA-SDLC-MIB", "sdlcLSAddress"))
if mibBuilder.loadTexts: sdlcLSStatsEntry.setDescription("A list of statistics for an SDLC link station.")
sdlcLSStatsBLUsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsBLUsIn.setDescription("This object reflects the total basic link\nunits (BLUs; frames) received from an adjacent\nSDLC link station since link station startup.\nAt link station startup time, this object must\nbe initialized to zero.")
sdlcLSStatsBLUsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsBLUsOut.setDescription("This object reflects the total basic link\nunits (BLUs; frames), transmitted to an\nadjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsOctetsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsOctetsIn.setDescription("This object reflects the total octets received\nfrom an adjacent SDLC link station since link\nstation startup.  This object covers the\naddress, control, and information field of\nI-Frames only.  At link station startup time,\nthis object must be initialized to zero.")
sdlcLSStatsOctetsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsOctetsOut.setDescription("This object reflects the total octets\ntransmitted to an adjacent SDLC link station\nsince link station startup.  This object covers\nthe address, control, and information field of\nI-Frames only.  At link station startup time,\nthis object must be initialized to zero.")
sdlcLSStatsPollsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsPollsIn.setDescription("This object reflects the total polls received\nfrom an adjacent SDLC link station since link\nstation startup.  At link station startup time,\nthis object must be initialized to zero.")
sdlcLSStatsPollsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsPollsOut.setDescription("This object reflects the total polls sent to\nan adjacent SDLC link station since link\nstation startup.  At link station startup time,\nthis object must be initialized to zero.")
sdlcLSStatsPollRspsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsPollRspsOut.setDescription("This object reflects the total number of poll\nresponses sent to the adjacent SDLC link\nstation since link station startup.  This value\nincludes I-frames that are sent in response to\na poll.\n\nAt link station startup time, this object must\nbe initialized to zero.")
sdlcLSStatsPollRspsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsPollRspsIn.setDescription("This object reflects the total number of poll\nresponses received from the adjacent SDLC link\nstation since station startup.  This value\nincludes I-frames that are received in response\nto a poll.\n\nAt link station startup time, this object must\nbe initialized to zero.")
sdlcLSStatsLocalBusies = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsLocalBusies.setDescription("This object reflects the total number of times\nthat the local SDLC link station has entered a\nbusy state (RNR) since link station startup.\nAt link station startup time, this object must\nbe initialized to zero.")
sdlcLSStatsRemoteBusies = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRemoteBusies.setDescription("This object reflects the total number of times\nthat an adjacent ( remote) SDLC link station\nhas entered a busy state (RNR) since link\nstation startup.  At link station startup time,\nthis object must be initialized to zero.")
sdlcLSStatsIFramesIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsIFramesIn.setDescription("This object reflects the total I-frames\nreceived from an adjacent SDLC link station\nsince link station startup.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsIFramesOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsIFramesOut.setDescription("This object reflects the total I-frames\ntransmitted to an adjacent SDLC link station\nsince link station startup.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsUIFramesIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsUIFramesIn.setDescription("This object reflects the total UI-frames\nreceived from an adjacent SDLC link station\nsince link station startup.")
sdlcLSStatsUIFramesOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsUIFramesOut.setDescription("This object reflects the total UI-frames\ntransmitted to an adjacent SDLC link station\nsince link station startup.")
sdlcLSStatsXIDsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsXIDsIn.setDescription("This object reflects the total XID frames\nreceived from an adjacent SDLC link station\nsince link station startup.")
sdlcLSStatsXIDsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsXIDsOut.setDescription("This object reflects the total XID frames\ntransmitted to an adjacent SDLC link station\nsince link station startup.")
sdlcLSStatsTESTsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsTESTsIn.setDescription("This object reflects the total TEST frames,\ncommands or responses, received from an\nadjacent SDLC link station since link station\nstartup.")
sdlcLSStatsTESTsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsTESTsOut.setDescription("This object reflects the total TEST frames,\ncommands or responses, transmitted to an\nadjacent SDLC link station since link station\nstartup.")
sdlcLSStatsREJsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsREJsIn.setDescription("This object reflects the total REJ frames\nreceived from an adjacent SDLC link station\nsince link station startup.")
sdlcLSStatsREJsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsREJsOut.setDescription("This object reflects the total REJ frames\ntransmitted to an adjacent SDLC link station\nsince link station startup.")
sdlcLSStatsFRMRsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsFRMRsIn.setDescription("This object reflects the total frame reject\n(FRMR) frames received from an adjacent SDLC\nlink station since link station startup.")
sdlcLSStatsFRMRsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsFRMRsOut.setDescription("This object reflects the total frame reject\n(FRMR) frames transmitted to an adjacent SDLC\nlink station since link station startup.")
sdlcLSStatsSIMsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsSIMsIn.setDescription("This object reflects the total set\ninitialization mode (SIM) frames received from\nan adjacent SDLC link station since link station\nstartup.")
sdlcLSStatsSIMsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsSIMsOut.setDescription("This object reflects the total set\ninitialization mode (SIM) frames transmitted to\nan adjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsRIMsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRIMsIn.setDescription("This object reflects the total request\ninitialization mode (RIM) frames received from\nan adjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsRIMsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRIMsOut.setDescription("This object reflects the total request\ninitialization mode (RIM) frames transmitted to\nan adjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsDISCIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsDISCIn.setDescription("This object reflects the total number of\ndisconnect (DISC) requests received from an\nadjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsDISCOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsDISCOut.setDescription("This object reflects the total number of\ndisconnect (DISC) requests transmited to an\nadjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsUAIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsUAIn.setDescription("This object reflects the total number of\nunnumbered acknowledgements (UA) requests\nreceived from an adjacent SDLC link station\nsince link station startup.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsUAOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsUAOut.setDescription("This object reflects the total number of\nunnumbered acknowledgements (UA) requests\ntransmited to an adjacent SDLC link station\nsince link station startup.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsDMIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsDMIn.setDescription("This object reflects the total number of\ndisconnect mode (DM) requests received from an\nadjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsDMOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsDMOut.setDescription("This object reflects the total number of\ndisconnect mode (DM) requests transmited to an\nadjacent SDLC link station since link station\nstartup.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsSNRMIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsSNRMIn.setDescription("This object reflects the total number of\nset normal response mode (SNRM/SNRME) requests\nreceived from an adjacent SDLC link station\nsince link station startup.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsSNRMOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsSNRMOut.setDescription("This object reflects the total number of\nset normal response mode (SNRM/SNRME) requests\ntransmited to an adjacent SDLC link station\nsince link station startup.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsProtocolErrs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsProtocolErrs.setDescription("This object reflects the total occurrences,\nsince link station startup, where this SDLC\nlink station has inactivated the link as a\nresult of receiving a frame from its adjacent\nlink station which was in violation of the\nprotocol.  At link station startup time, this\nobject must be initialized to zero.")
sdlcLSStatsActivityTOs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsActivityTOs.setDescription("This object reflects the total occurrences,\nsince startup, where this SDLC link station has\ninactivated the link as a result of no activity\non the link.  At link station startup time,\nthis object must be initialized to zero.")
sdlcLSStatsRNRLIMITs = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 37), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRNRLIMITs.setDescription("This object reflects the total occurrences,\nsince startup, where this SDLC link station has\ninactivated the link as a result of its\nRNRLIMIT timer expiring.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsRetriesExps = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRetriesExps.setDescription("This object reflects the total occurrences,\nsince startup, where this SDLC link station has\ninactivated the link as a result of a retry\nsequence being exhausted.  At link station\nstartup time, this object must be initialized\nto zero.")
sdlcLSStatsRetransmitsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 39), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRetransmitsIn.setDescription("This object reflects the total number of\ninformation frames retransmitted by the remote\nlink station because the N(s) received from\nthat link station indicated that one or more\ninformation frames sent by that station were\nlost.  This event causes the first missing\ninformation frame of a window and all\nsubsequent information frames to be\nretransmitted.  At link station startup time,\nthis object must be initialized to zero.\n\nManagement: If the value of\nsdlcLSStatsRetransmitsIn grows over time, then\nthe quality of the serial line is in\nquestion.  You might want to look at\ndecreasing the value for\nsdlcLSAdminMAXDATASend to compensate for the\nlower quality line.")
sdlcLSStatsRetransmitsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 41, 1, 2, 3, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sdlcLSStatsRetransmitsOut.setDescription("This object reflects the total number of\ninformation frames retransmitted to a remote\nlink station because the N(r) received from\nthat link station indicated that one or more\ninformation frames sent to that station were\nlost. This event causes the first missing\ninformation frame of a window and all\nsubsequent information frames to be\nretransmitted.  At link station startup time,\nthis object must be initialized to zero.\n\nManagement: If the value of\nsdlcLSStatsRetransmitsOut grows over time,\nthen the quality of the serial line is in\nquestion.  You might want to look at\ndecreasing the value for sdlcLSAdminMAXDATASend\nto compensate for the lower quality line.")
sdlcTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 3))
sdlcConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 4))
sdlcCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 4, 1))
sdlcGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 4, 2))
sdlcCoreGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1))
sdlcPrimaryGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 2))

# Augmentions

# Notifications

sdlcPortStatusChange = NotificationType((1, 3, 6, 1, 2, 1, 41, 1, 3, 1)).setObjects(("RFC1213-MIB", "ifIndex"), ("SNA-SDLC-MIB", "sdlcPortOperLastFailCause"), ("SNA-SDLC-MIB", "sdlcPortOperLastFailTime"), ("RFC1213-MIB", "ifAdminStatus"), ("RFC1213-MIB", "ifOperStatus"), )
if mibBuilder.loadTexts: sdlcPortStatusChange.setDescription("This trap indicates that the state of an SDLC\nport has transitioned to active or inactive.")
sdlcLSStatusChange = NotificationType((1, 3, 6, 1, 2, 1, 41, 1, 3, 2)).setObjects(("SNA-SDLC-MIB", "sdlcLSOperLastFailTime"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailCtrlOut"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailREPLYTOs"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailCause"), ("RFC1213-MIB", "ifIndex"), ("SNA-SDLC-MIB", "sdlcLSAdminState"), ("SNA-SDLC-MIB", "sdlcLSAddress"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailCtrlIn"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailFRMRInfo"), ("SNA-SDLC-MIB", "sdlcLSOperState"), )
if mibBuilder.loadTexts: sdlcLSStatusChange.setDescription("This trap indicates that the state of an SDLC\nlink station has transitioned to contacted or\ndiscontacted.")

# Groups

sdlcCorePortAdminGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1, 1)).setObjects(("SNA-SDLC-MIB", "sdlcPortAdminName"), ("SNA-SDLC-MIB", "sdlcPortAdminRole"), ("SNA-SDLC-MIB", "sdlcPortAdminTopology"), ("SNA-SDLC-MIB", "sdlcPortAdminISTATUS"), ("SNA-SDLC-MIB", "sdlcPortAdminType"), )
if mibBuilder.loadTexts: sdlcCorePortAdminGroup.setDescription("The sdlcCorePortAdminGroup defines objects\nwhich are common to the PortAdmin group of all\ncompliant link stations.")
sdlcCorePortOperGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1, 2)).setObjects(("SNA-SDLC-MIB", "sdlcPortOperLastFailCause"), ("SNA-SDLC-MIB", "sdlcPortOperACTIVTO"), ("SNA-SDLC-MIB", "sdlcPortOperISTATUS"), ("SNA-SDLC-MIB", "sdlcPortOperName"), ("SNA-SDLC-MIB", "sdlcPortOperRole"), ("SNA-SDLC-MIB", "sdlcPortOperLastFailTime"), ("SNA-SDLC-MIB", "sdlcPortOperType"), ("SNA-SDLC-MIB", "sdlcPortOperTopology"), )
if mibBuilder.loadTexts: sdlcCorePortOperGroup.setDescription("The sdlcCorePortOperGroup defines objects\nwhich are common to the PortOper group of all\ncompliant link stations.")
sdlcCorePortStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1, 3)).setObjects(("SNA-SDLC-MIB", "sdlcPortStatsInvalidAddresses"), ("SNA-SDLC-MIB", "sdlcPortStatsDwarfFrames"), ("SNA-SDLC-MIB", "sdlcPortStatsPhysicalFailures"), )
if mibBuilder.loadTexts: sdlcCorePortStatsGroup.setDescription("The sdlcCorePortStatsGroup defines objects\nwhich are common to the PortStats group of all\ncompliant link stations.")
sdlcCoreLSAdminGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1, 4)).setObjects(("SNA-SDLC-MIB", "sdlcLSAdminGPoll"), ("SNA-SDLC-MIB", "sdlcLSAdminRNRLIMIT"), ("SNA-SDLC-MIB", "sdlcLSAdminDATMODE"), ("SNA-SDLC-MIB", "sdlcLSAdminName"), ("SNA-SDLC-MIB", "sdlcLSAdminMAXDATARcv"), ("SNA-SDLC-MIB", "sdlcLSAdminMAXIN"), ("SNA-SDLC-MIB", "sdlcLSAdminISTATUS"), ("SNA-SDLC-MIB", "sdlcLSAdminSimRim"), ("SNA-SDLC-MIB", "sdlcLSAdminRowStatus"), ("SNA-SDLC-MIB", "sdlcLSAdminMAXOUT"), ("SNA-SDLC-MIB", "sdlcLSAdminRETRIESm"), ("SNA-SDLC-MIB", "sdlcLSAdminState"), ("SNA-SDLC-MIB", "sdlcLSAddress"), ("SNA-SDLC-MIB", "sdlcLSAdminRETRIESt"), ("SNA-SDLC-MIB", "sdlcLSAdminMAXDATASend"), ("SNA-SDLC-MIB", "sdlcLSAdminMODULO"), ("SNA-SDLC-MIB", "sdlcLSAdminRETRIESn"), )
if mibBuilder.loadTexts: sdlcCoreLSAdminGroup.setDescription("The sdlcCorePortAdminGroup defines objects\nwhich are common to the PortAdmin group of all\ncompliant link stations.")
sdlcCoreLSOperGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1, 5)).setObjects(("SNA-SDLC-MIB", "sdlcLSOperLastFailTime"), ("SNA-SDLC-MIB", "sdlcLSOperRETRIESt"), ("SNA-SDLC-MIB", "sdlcLSOperRETRIESn"), ("SNA-SDLC-MIB", "sdlcLSOperGPoll"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailCause"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailCtrlIn"), ("SNA-SDLC-MIB", "sdlcLSOperEcho"), ("SNA-SDLC-MIB", "sdlcLSOperRNRLIMIT"), ("SNA-SDLC-MIB", "sdlcLSOperMODULO"), ("SNA-SDLC-MIB", "sdlcLSOperMAXOUT"), ("SNA-SDLC-MIB", "sdlcLSOperDATMODE"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailCtrlOut"), ("SNA-SDLC-MIB", "sdlcLSOperMAXDATASend"), ("SNA-SDLC-MIB", "sdlcLSOperRole"), ("SNA-SDLC-MIB", "sdlcLSOperRETRIESm"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailREPLYTOs"), ("SNA-SDLC-MIB", "sdlcLSOperLastFailFRMRInfo"), ("SNA-SDLC-MIB", "sdlcLSOperMAXIN"), ("SNA-SDLC-MIB", "sdlcLSOperState"), )
if mibBuilder.loadTexts: sdlcCoreLSOperGroup.setDescription("The sdlcCorePortOperGroup defines objects\nwhich are common to the PortOper group of all\ncompliant link stations.")
sdlcCoreLSStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 1, 6)).setObjects(("SNA-SDLC-MIB", "sdlcLSStatsUIFramesOut"), ("SNA-SDLC-MIB", "sdlcLSStatsRemoteBusies"), ("SNA-SDLC-MIB", "sdlcLSStatsBLUsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsTESTsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsSIMsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsXIDsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsTESTsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsRIMsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsRNRLIMITs"), ("SNA-SDLC-MIB", "sdlcLSStatsPollRspsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsIFramesIn"), ("SNA-SDLC-MIB", "sdlcLSStatsREJsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsRetransmitsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsSIMsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsBLUsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsRetriesExps"), ("SNA-SDLC-MIB", "sdlcLSStatsPollsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsOctetsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsPollsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsREJsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsLocalBusies"), ("SNA-SDLC-MIB", "sdlcLSStatsFRMRsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsIFramesOut"), ("SNA-SDLC-MIB", "sdlcLSStatsFRMRsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsPollRspsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsRIMsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsXIDsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsUIFramesIn"), ("SNA-SDLC-MIB", "sdlcLSStatsOctetsIn"), ("SNA-SDLC-MIB", "sdlcLSStatsRetransmitsOut"), ("SNA-SDLC-MIB", "sdlcLSStatsProtocolErrs"), )
if mibBuilder.loadTexts: sdlcCoreLSStatsGroup.setDescription("The sdlcCorePortStatsGroup defines objects\nwhich are common to the PortStats group of all\ncompliant link stations.")
sdlcPrimaryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 2, 1)).setObjects(("SNA-SDLC-MIB", "sdlcLSOperREPLYTO"), ("SNA-SDLC-MIB", "sdlcPortOperPAUSE"), ("SNA-SDLC-MIB", "sdlcPortAdminPAUSE"), ("SNA-SDLC-MIB", "sdlcLSAdminREPLYTO"), )
if mibBuilder.loadTexts: sdlcPrimaryGroup.setDescription("The sdlcPrimaryGroup defines objects which\nare common to all compliant primary link\nstations.")
sdlcPrimaryMultipointGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 41, 1, 4, 2, 2, 2)).setObjects(("SNA-SDLC-MIB", "sdlcPortOperSERVLIM"), ("SNA-SDLC-MIB", "sdlcPortAdminSlowPollTimer"), ("SNA-SDLC-MIB", "sdlcPortAdminSERVLIM"), ("SNA-SDLC-MIB", "sdlcPortOperSlowPollTimer"), ("SNA-SDLC-MIB", "sdlcPortOperSlowPollMethod"), )
if mibBuilder.loadTexts: sdlcPrimaryMultipointGroup.setDescription("The sdlcPrimaryMultipointGroup defines objects\nwhich are common to all compliant primary link\nstations that are in a multipoint topology.")

# Compliances

sdlcCoreCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 41, 1, 4, 1, 1)).setObjects(("SNA-SDLC-MIB", "sdlcCoreLSStatsGroup"), ("SNA-SDLC-MIB", "sdlcCorePortAdminGroup"), ("SNA-SDLC-MIB", "sdlcCoreLSAdminGroup"), ("SNA-SDLC-MIB", "sdlcCoreLSOperGroup"), ("SNA-SDLC-MIB", "sdlcCorePortStatsGroup"), ("SNA-SDLC-MIB", "sdlcCorePortOperGroup"), )
if mibBuilder.loadTexts: sdlcCoreCompliance.setDescription("The core compliance statement for all SDLC\nnodes.")
sdlcPrimaryCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 41, 1, 4, 1, 2)).setObjects(("SNA-SDLC-MIB", "sdlcPrimaryGroup"), )
if mibBuilder.loadTexts: sdlcPrimaryCompliance.setDescription("The compliance statement for all nodes that\nare performing the role of a Primary link\nstation.")
sdlcPrimaryMultipointCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 41, 1, 4, 1, 3)).setObjects(("SNA-SDLC-MIB", "sdlcPrimaryMultipointGroup"), )
if mibBuilder.loadTexts: sdlcPrimaryMultipointCompliance.setDescription("The compliance statement for all nodes that\nare performing the role of a primary link\nstation on a multipoint line.")

# Exports

# Module identity
mibBuilder.exportSymbols("SNA-SDLC-MIB", PYSNMP_MODULE_ID=snaDLC)

# Objects
mibBuilder.exportSymbols("SNA-SDLC-MIB", snaDLC=snaDLC, sdlc=sdlc, sdlcPortGroup=sdlcPortGroup, sdlcPortAdminTable=sdlcPortAdminTable, sdlcPortAdminEntry=sdlcPortAdminEntry, sdlcPortAdminName=sdlcPortAdminName, sdlcPortAdminRole=sdlcPortAdminRole, sdlcPortAdminType=sdlcPortAdminType, sdlcPortAdminTopology=sdlcPortAdminTopology, sdlcPortAdminISTATUS=sdlcPortAdminISTATUS, sdlcPortAdminACTIVTO=sdlcPortAdminACTIVTO, sdlcPortAdminPAUSE=sdlcPortAdminPAUSE, sdlcPortAdminSERVLIM=sdlcPortAdminSERVLIM, sdlcPortAdminSlowPollTimer=sdlcPortAdminSlowPollTimer, sdlcPortOperTable=sdlcPortOperTable, sdlcPortOperEntry=sdlcPortOperEntry, sdlcPortOperName=sdlcPortOperName, sdlcPortOperRole=sdlcPortOperRole, sdlcPortOperType=sdlcPortOperType, sdlcPortOperTopology=sdlcPortOperTopology, sdlcPortOperISTATUS=sdlcPortOperISTATUS, sdlcPortOperACTIVTO=sdlcPortOperACTIVTO, sdlcPortOperPAUSE=sdlcPortOperPAUSE, sdlcPortOperSlowPollMethod=sdlcPortOperSlowPollMethod, sdlcPortOperSERVLIM=sdlcPortOperSERVLIM, sdlcPortOperSlowPollTimer=sdlcPortOperSlowPollTimer, sdlcPortOperLastModifyTime=sdlcPortOperLastModifyTime, sdlcPortOperLastFailTime=sdlcPortOperLastFailTime, sdlcPortOperLastFailCause=sdlcPortOperLastFailCause, sdlcPortStatsTable=sdlcPortStatsTable, sdlcPortStatsEntry=sdlcPortStatsEntry, sdlcPortStatsPhysicalFailures=sdlcPortStatsPhysicalFailures, sdlcPortStatsInvalidAddresses=sdlcPortStatsInvalidAddresses, sdlcPortStatsDwarfFrames=sdlcPortStatsDwarfFrames, sdlcPortStatsPollsIn=sdlcPortStatsPollsIn, sdlcPortStatsPollsOut=sdlcPortStatsPollsOut, sdlcPortStatsPollRspsIn=sdlcPortStatsPollRspsIn, sdlcPortStatsPollRspsOut=sdlcPortStatsPollRspsOut, sdlcPortStatsLocalBusies=sdlcPortStatsLocalBusies, sdlcPortStatsRemoteBusies=sdlcPortStatsRemoteBusies, sdlcPortStatsIFramesIn=sdlcPortStatsIFramesIn, sdlcPortStatsIFramesOut=sdlcPortStatsIFramesOut, sdlcPortStatsOctetsIn=sdlcPortStatsOctetsIn, sdlcPortStatsOctetsOut=sdlcPortStatsOctetsOut, sdlcPortStatsProtocolErrs=sdlcPortStatsProtocolErrs, sdlcPortStatsActivityTOs=sdlcPortStatsActivityTOs, sdlcPortStatsRNRLIMITs=sdlcPortStatsRNRLIMITs, sdlcPortStatsRetriesExps=sdlcPortStatsRetriesExps, sdlcPortStatsRetransmitsIn=sdlcPortStatsRetransmitsIn, sdlcPortStatsRetransmitsOut=sdlcPortStatsRetransmitsOut, sdlcLSGroup=sdlcLSGroup, sdlcLSAdminTable=sdlcLSAdminTable, sdlcLSAdminEntry=sdlcLSAdminEntry, sdlcLSAddress=sdlcLSAddress, sdlcLSAdminName=sdlcLSAdminName, sdlcLSAdminState=sdlcLSAdminState, sdlcLSAdminISTATUS=sdlcLSAdminISTATUS, sdlcLSAdminMAXDATASend=sdlcLSAdminMAXDATASend, sdlcLSAdminMAXDATARcv=sdlcLSAdminMAXDATARcv, sdlcLSAdminREPLYTO=sdlcLSAdminREPLYTO, sdlcLSAdminMAXIN=sdlcLSAdminMAXIN, sdlcLSAdminMAXOUT=sdlcLSAdminMAXOUT, sdlcLSAdminMODULO=sdlcLSAdminMODULO, sdlcLSAdminRETRIESm=sdlcLSAdminRETRIESm, sdlcLSAdminRETRIESt=sdlcLSAdminRETRIESt, sdlcLSAdminRETRIESn=sdlcLSAdminRETRIESn, sdlcLSAdminRNRLIMIT=sdlcLSAdminRNRLIMIT, sdlcLSAdminDATMODE=sdlcLSAdminDATMODE, sdlcLSAdminGPoll=sdlcLSAdminGPoll, sdlcLSAdminSimRim=sdlcLSAdminSimRim, sdlcLSAdminXmitRcvCap=sdlcLSAdminXmitRcvCap, sdlcLSAdminRowStatus=sdlcLSAdminRowStatus, sdlcLSOperTable=sdlcLSOperTable, sdlcLSOperEntry=sdlcLSOperEntry, sdlcLSOperName=sdlcLSOperName, sdlcLSOperRole=sdlcLSOperRole, sdlcLSOperState=sdlcLSOperState, sdlcLSOperMAXDATASend=sdlcLSOperMAXDATASend, sdlcLSOperREPLYTO=sdlcLSOperREPLYTO, sdlcLSOperMAXIN=sdlcLSOperMAXIN, sdlcLSOperMAXOUT=sdlcLSOperMAXOUT, sdlcLSOperMODULO=sdlcLSOperMODULO, sdlcLSOperRETRIESm=sdlcLSOperRETRIESm, sdlcLSOperRETRIESt=sdlcLSOperRETRIESt, sdlcLSOperRETRIESn=sdlcLSOperRETRIESn, sdlcLSOperRNRLIMIT=sdlcLSOperRNRLIMIT, sdlcLSOperDATMODE=sdlcLSOperDATMODE, sdlcLSOperLastModifyTime=sdlcLSOperLastModifyTime, sdlcLSOperLastFailTime=sdlcLSOperLastFailTime, sdlcLSOperLastFailCause=sdlcLSOperLastFailCause, sdlcLSOperLastFailCtrlIn=sdlcLSOperLastFailCtrlIn, sdlcLSOperLastFailCtrlOut=sdlcLSOperLastFailCtrlOut, sdlcLSOperLastFailFRMRInfo=sdlcLSOperLastFailFRMRInfo, sdlcLSOperLastFailREPLYTOs=sdlcLSOperLastFailREPLYTOs, sdlcLSOperEcho=sdlcLSOperEcho, sdlcLSOperGPoll=sdlcLSOperGPoll, sdlcLSOperSimRim=sdlcLSOperSimRim, sdlcLSOperXmitRcvCap=sdlcLSOperXmitRcvCap, sdlcLSStatsTable=sdlcLSStatsTable, sdlcLSStatsEntry=sdlcLSStatsEntry, sdlcLSStatsBLUsIn=sdlcLSStatsBLUsIn, sdlcLSStatsBLUsOut=sdlcLSStatsBLUsOut, sdlcLSStatsOctetsIn=sdlcLSStatsOctetsIn, sdlcLSStatsOctetsOut=sdlcLSStatsOctetsOut, sdlcLSStatsPollsIn=sdlcLSStatsPollsIn, sdlcLSStatsPollsOut=sdlcLSStatsPollsOut, sdlcLSStatsPollRspsOut=sdlcLSStatsPollRspsOut, sdlcLSStatsPollRspsIn=sdlcLSStatsPollRspsIn, sdlcLSStatsLocalBusies=sdlcLSStatsLocalBusies, sdlcLSStatsRemoteBusies=sdlcLSStatsRemoteBusies, sdlcLSStatsIFramesIn=sdlcLSStatsIFramesIn, sdlcLSStatsIFramesOut=sdlcLSStatsIFramesOut, sdlcLSStatsUIFramesIn=sdlcLSStatsUIFramesIn, sdlcLSStatsUIFramesOut=sdlcLSStatsUIFramesOut, sdlcLSStatsXIDsIn=sdlcLSStatsXIDsIn, sdlcLSStatsXIDsOut=sdlcLSStatsXIDsOut, sdlcLSStatsTESTsIn=sdlcLSStatsTESTsIn, sdlcLSStatsTESTsOut=sdlcLSStatsTESTsOut, sdlcLSStatsREJsIn=sdlcLSStatsREJsIn, sdlcLSStatsREJsOut=sdlcLSStatsREJsOut, sdlcLSStatsFRMRsIn=sdlcLSStatsFRMRsIn, sdlcLSStatsFRMRsOut=sdlcLSStatsFRMRsOut, sdlcLSStatsSIMsIn=sdlcLSStatsSIMsIn, sdlcLSStatsSIMsOut=sdlcLSStatsSIMsOut, sdlcLSStatsRIMsIn=sdlcLSStatsRIMsIn, sdlcLSStatsRIMsOut=sdlcLSStatsRIMsOut)
mibBuilder.exportSymbols("SNA-SDLC-MIB", sdlcLSStatsDISCIn=sdlcLSStatsDISCIn, sdlcLSStatsDISCOut=sdlcLSStatsDISCOut, sdlcLSStatsUAIn=sdlcLSStatsUAIn, sdlcLSStatsUAOut=sdlcLSStatsUAOut, sdlcLSStatsDMIn=sdlcLSStatsDMIn, sdlcLSStatsDMOut=sdlcLSStatsDMOut, sdlcLSStatsSNRMIn=sdlcLSStatsSNRMIn, sdlcLSStatsSNRMOut=sdlcLSStatsSNRMOut, sdlcLSStatsProtocolErrs=sdlcLSStatsProtocolErrs, sdlcLSStatsActivityTOs=sdlcLSStatsActivityTOs, sdlcLSStatsRNRLIMITs=sdlcLSStatsRNRLIMITs, sdlcLSStatsRetriesExps=sdlcLSStatsRetriesExps, sdlcLSStatsRetransmitsIn=sdlcLSStatsRetransmitsIn, sdlcLSStatsRetransmitsOut=sdlcLSStatsRetransmitsOut, sdlcTraps=sdlcTraps, sdlcConformance=sdlcConformance, sdlcCompliances=sdlcCompliances, sdlcGroups=sdlcGroups, sdlcCoreGroups=sdlcCoreGroups, sdlcPrimaryGroups=sdlcPrimaryGroups)

# Notifications
mibBuilder.exportSymbols("SNA-SDLC-MIB", sdlcPortStatusChange=sdlcPortStatusChange, sdlcLSStatusChange=sdlcLSStatusChange)

# Groups
mibBuilder.exportSymbols("SNA-SDLC-MIB", sdlcCorePortAdminGroup=sdlcCorePortAdminGroup, sdlcCorePortOperGroup=sdlcCorePortOperGroup, sdlcCorePortStatsGroup=sdlcCorePortStatsGroup, sdlcCoreLSAdminGroup=sdlcCoreLSAdminGroup, sdlcCoreLSOperGroup=sdlcCoreLSOperGroup, sdlcCoreLSStatsGroup=sdlcCoreLSStatsGroup, sdlcPrimaryGroup=sdlcPrimaryGroup, sdlcPrimaryMultipointGroup=sdlcPrimaryMultipointGroup)

# Compliances
mibBuilder.exportSymbols("SNA-SDLC-MIB", sdlcCoreCompliance=sdlcCoreCompliance, sdlcPrimaryCompliance=sdlcPrimaryCompliance, sdlcPrimaryMultipointCompliance=sdlcPrimaryMultipointCompliance)
