# PySNMP SMI module. Autogenerated from smidump -f python SOURCE-ROUTING-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:15 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( dot1dBridge, dot1dSr, ) = mibBuilder.importSymbols("BRIDGE-MIB", "dot1dBridge", "dot1dSr")
( Bits, Counter32, Gauge32, Integer32, Integer32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")

# Objects

dot1dSrPortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 3, 1))
if mibBuilder.loadTexts: dot1dSrPortTable.setDescription("A table that contains information about every\nport that is associated with this source route\nbridge.")
dot1dSrPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 3, 1, 1)).setIndexNames((0, "SOURCE-ROUTING-MIB", "dot1dSrPort"))
if mibBuilder.loadTexts: dot1dSrPortEntry.setDescription("A list of information for each port of a source\nroute bridge.")
dot1dSrPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPort.setDescription("The port number of the port for which this entry\ncontains Source Route management information.")
dot1dSrPortHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrPortHopCount.setDescription("The maximum number of routing descriptors allowed\nin an All Paths or Spanning Tree Explorer frames.")
dot1dSrPortLocalSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 3), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrPortLocalSegment.setDescription("The segment number that uniquely identifies the\nsegment to which this port is connected. Current\nsource routing protocols limit this value to the\nrange: 0 through 4095. (The value 0 is used by\nsome management applications for special test\ncases.) A value of 65535 signifies that no segment\nnumber is assigned to this port.")
dot1dSrPortBridgeNum = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 4), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrPortBridgeNum.setDescription("A bridge number uniquely identifies a bridge when\nmore than one bridge is used to span the same two\nsegments.  Current source routing protocols limit\nthis value to the range: 0 through 15. A value of\n65535 signifies that no bridge number is assigned\nto this bridge.")
dot1dSrPortTargetSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 5), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrPortTargetSegment.setDescription("The segment number that corresponds to the target\nsegment this port is considered to be connected to\nby the bridge.  Current source routing protocols\nlimit this value to the range: 0 through 4095.\n(The value 0 is used by some management\napplications for special test cases.) A value of\n65535 signifies that no target segment is assigned\nto this port.")
dot1dSrPortLargestFrame = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 6), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrPortLargestFrame.setDescription("The maximum size of the INFO field (LLC and\nabove) that this port can send/receive.  It does\nnot include any MAC level (framing) octets.  The\nvalue of this object is used by this bridge to\ndetermine whether a modification of the\nLargestFrame (LF, see [14]) field of the Routing\nControl field of the Routing Information Field is\nnecessary.\n\n64 valid values are defined by the IEEE 802.5M SRT\nAddendum: 516, 635, 754, 873, 993, 1112, 1231,\n1350, 1470, 1542, 1615, 1688, 1761, 1833, 1906,\n1979, 2052, 2345, 2638, 2932, 3225, 3518, 3812,\n4105, 4399, 4865, 5331, 5798, 6264, 6730, 7197,\n7663, 8130, 8539, 8949, 9358, 9768, 10178, 10587,\n10997, 11407, 12199, 12992, 13785, 14578, 15370,\n16163, 16956, 17749, 20730, 23711, 26693, 29674,\n32655, 35637, 38618, 41600, 44591, 47583, 50575,\n53567, 56559, 59551, and 65535.\n\nAn illegal value will not be accepted by the\nbridge.")
dot1dSrPortSTESpanMode = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("auto-span", 1), ("disabled", 2), ("forced", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrPortSTESpanMode.setDescription("Determines how this port behaves when presented\nwith a Spanning Tree Explorer frame.  The value\n'disabled(2)' indicates that the port will not\naccept or send Spanning Tree Explorer packets; any\nSTE packets received will be silently discarded.\nThe value 'forced(3)' indicates the port will\nalways accept and propagate Spanning Tree Explorer\nframes.  This allows a manually configured\nSpanning Tree for this class of packet to be\nconfigured.  Note that unlike transparent\nbridging, this is not catastrophic to the network\nif there are loops.  The value 'auto-span(1)' can\nonly be returned by a bridge that both implements\nthe Spanning Tree Protocol and has use of the\nprotocol enabled on this port. The behavior of the\nport for Spanning Tree Explorer frames is\ndetermined by the state of dot1dStpPortState.  If\nthe port is in the 'forwarding' state, the frame\nwill be accepted or propagated.  Otherwise, it\nwill be silently discarded.")
dot1dSrPortSpecInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortSpecInFrames.setDescription("The number of Specifically Routed frames, also\nreferred to as Source Routed Frames, that have\nbeen received from this port's segment.")
dot1dSrPortSpecOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortSpecOutFrames.setDescription("The number of Specifically Routed frames, also\nreferred to as Source Routed Frames, that this\nport has transmitted on its segment.")
dot1dSrPortApeInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortApeInFrames.setDescription("The number of All Paths Explorer frames, also\nreferred to as All Routes Explorer frames, that\nhave been received by this port from its segment.")
dot1dSrPortApeOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortApeOutFrames.setDescription("The number of all Paths Explorer Frames, also\nreferred to as All Routes Explorer frames, that\nhave been transmitted by this port on its\nsegment.")
dot1dSrPortSteInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortSteInFrames.setDescription("The number of spanning tree explorer frames that\nhave been received by this port from its segment.")
dot1dSrPortSteOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortSteOutFrames.setDescription("The number of spanning tree explorer frames that\nhave been transmitted by this port on its\nsegment.")
dot1dSrPortSegmentMismatchDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortSegmentMismatchDiscards.setDescription("The number of explorer frames that have been\ndiscarded by this port because the routing\ndescriptor field contained an invalid adjacent\nsegment value.")
dot1dSrPortDuplicateSegmentDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortDuplicateSegmentDiscards.setDescription("The number of frames that have been discarded by\nthis port because the routing descriptor field\ncontained a duplicate segment identifier.")
dot1dSrPortHopCountExceededDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortHopCountExceededDiscards.setDescription("The number of explorer frames that have been\ndiscarded by this port because the Routing\nInformation Field has exceeded the maximum route\ndescriptor length.")
dot1dSrPortDupLanIdOrTreeErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortDupLanIdOrTreeErrors.setDescription("The number of duplicate LAN IDs or Tree errors.\nThis helps in detection of problems in networks\ncontaining older IBM Source Routing Bridges.")
dot1dSrPortLanIdMismatches = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 3, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dSrPortLanIdMismatches.setDescription("The number of ARE and STE frames that were\ndiscarded because the last LAN ID in the routing\ninformation field did not equal the LAN-in ID.\nThis error can occur in implementations which do\nonly a LAN-in ID and Bridge Number check instead\nof a LAN-in ID, Bridge Number, and LAN-out ID\ncheck before they forward broadcast frames.")
dot1dSrBridgeLfMode = MibScalar((1, 3, 6, 1, 2, 1, 17, 3, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("mode3", 1), ("mode6", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dSrBridgeLfMode.setDescription("Indicates whether the bridge operates using older\n3 bit length negotiation fields or the newer 6 bit\nlength field in its RIF.")
dot1dPortPair = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 10))
dot1dPortPairTableSize = MibScalar((1, 3, 6, 1, 2, 1, 17, 10, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1dPortPairTableSize.setDescription("The total number of entries in the Bridge Port\nPair Database.")
dot1dPortPairTable = MibTable((1, 3, 6, 1, 2, 1, 17, 10, 2))
if mibBuilder.loadTexts: dot1dPortPairTable.setDescription("A table that contains information about every\nport pair database entity associated with this\nsource routing bridge.")
dot1dPortPairEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 10, 2, 1)).setIndexNames((0, "SOURCE-ROUTING-MIB", "dot1dPortPairLowPort"), (0, "SOURCE-ROUTING-MIB", "dot1dPortPairHighPort"))
if mibBuilder.loadTexts: dot1dPortPairEntry.setDescription("A list of information for each port pair entity\nof a bridge.")
dot1dPortPairLowPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 10, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dPortPairLowPort.setDescription("The port number of the lower numbered port for\nwhich this entry contains port pair database\ninformation.")
dot1dPortPairHighPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 10, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dPortPairHighPort.setDescription("The port number of the higher numbered port for\nwhich this entry contains port pair database\ninformation.")
dot1dPortPairBridgeNum = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 10, 2, 1, 3), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dPortPairBridgeNum.setDescription("A bridge number that uniquely identifies the path\nprovided by this source routing bridge between the\nsegments connected to dot1dPortPairLowPort and\ndot1dPortPairHighPort.  The purpose of bridge\nnumber is to disambiguate between multiple paths\nconnecting the same two LANs.")
dot1dPortPairBridgeState = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 10, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ("invalid", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1dPortPairBridgeState.setDescription("The state of dot1dPortPairBridgeNum.  Writing\n'invalid(3)' to this object removes the\ncorresponding entry.")

# Augmentions

# Exports

# Objects
mibBuilder.exportSymbols("SOURCE-ROUTING-MIB", dot1dSrPortTable=dot1dSrPortTable, dot1dSrPortEntry=dot1dSrPortEntry, dot1dSrPort=dot1dSrPort, dot1dSrPortHopCount=dot1dSrPortHopCount, dot1dSrPortLocalSegment=dot1dSrPortLocalSegment, dot1dSrPortBridgeNum=dot1dSrPortBridgeNum, dot1dSrPortTargetSegment=dot1dSrPortTargetSegment, dot1dSrPortLargestFrame=dot1dSrPortLargestFrame, dot1dSrPortSTESpanMode=dot1dSrPortSTESpanMode, dot1dSrPortSpecInFrames=dot1dSrPortSpecInFrames, dot1dSrPortSpecOutFrames=dot1dSrPortSpecOutFrames, dot1dSrPortApeInFrames=dot1dSrPortApeInFrames, dot1dSrPortApeOutFrames=dot1dSrPortApeOutFrames, dot1dSrPortSteInFrames=dot1dSrPortSteInFrames, dot1dSrPortSteOutFrames=dot1dSrPortSteOutFrames, dot1dSrPortSegmentMismatchDiscards=dot1dSrPortSegmentMismatchDiscards, dot1dSrPortDuplicateSegmentDiscards=dot1dSrPortDuplicateSegmentDiscards, dot1dSrPortHopCountExceededDiscards=dot1dSrPortHopCountExceededDiscards, dot1dSrPortDupLanIdOrTreeErrors=dot1dSrPortDupLanIdOrTreeErrors, dot1dSrPortLanIdMismatches=dot1dSrPortLanIdMismatches, dot1dSrBridgeLfMode=dot1dSrBridgeLfMode, dot1dPortPair=dot1dPortPair, dot1dPortPairTableSize=dot1dPortPairTableSize, dot1dPortPairTable=dot1dPortPairTable, dot1dPortPairEntry=dot1dPortPairEntry, dot1dPortPairLowPort=dot1dPortPairLowPort, dot1dPortPairHighPort=dot1dPortPairHighPort, dot1dPortPairBridgeNum=dot1dPortPairBridgeNum, dot1dPortPairBridgeState=dot1dPortPairBridgeState)

