# PySNMP SMI module. Autogenerated from smidump -f python SYSAPPL-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:15 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "TextualConvention")

# Types

class LongUtf8String(TextualConvention, OctetString):
    displayHint = "1024a"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,1024)
    
class RunState(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(5,1,2,3,4,)
    namedValues = namedval.NamedValues(("running", 1), ("runnable", 2), ("waiting", 3), ("exiting", 4), ("other", 5), )
    
class Utf8String(TextualConvention, OctetString):
    displayHint = "255a"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,255)
    

# Objects

sysApplMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 54)).setRevisions(("1997-10-20 00:00",))
if mibBuilder.loadTexts: sysApplMIB.setOrganization("IETF Applications MIB Working Group")
if mibBuilder.loadTexts: sysApplMIB.setContactInfo("Cheryl Krupczak (Editor, WG Advisor)\nPostal: Empire Technologies, Inc.\n541 Tenth Street NW\nSuite 169\nAtlanta, GA 30318\nUSA\nPhone: (770) 384-0184\nEmail: cheryl@empiretech.com\n\nJon Saperia (WG Chair)\nPostal:  BGS Systems, Inc.\nOne First Avenue\nWaltham, MA 02254-9111\nUSA\nPhone: (617) 891-0000\nEmail: saperia@networks.bgs.com")
if mibBuilder.loadTexts: sysApplMIB.setDescription("The MIB module defines management objects that model\napplications as collections of executables and files\ninstalled and executing on a host system.  The MIB\npresents a system-level view of applications; i.e.,\nobjects in this MIB are limited to those attributes\nthat can typically be obtained from the system itself\nwithout adding special instrumentation to the applications.")
sysApplOBJ = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1))
sysApplInstalled = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1, 1))
sysApplInstallPkgTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 1, 1))
if mibBuilder.loadTexts: sysApplInstallPkgTable.setDescription("The table listing the software application packages\ninstalled on a host computer. In order to appear in\nthis table, it may be necessary for the application\nto be installed using some type of software\ninstallation mechanism or global registry so that its\nexistence can be detected by the agent implementation.")
sysApplInstallPkgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"))
if mibBuilder.loadTexts: sysApplInstallPkgEntry.setDescription("The logical row describing an installed application\npackage.")
sysApplInstallPkgIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplInstallPkgIndex.setDescription("An integer used only for indexing purposes.\nGenerally monotonically increasing from 1 as new\napplications are installed.\n\nThe value for each installed application must\nremain constant at least from one re-initialization of\nthe network management entity which implements this\nMIB module to the next re-initialization.\n\nThe specific value is meaningful only within a given SNMP\nentity. A sysApplInstallPkgIndex value must not be re-used\nuntil the next agent entity restart in the event the\ninstalled application entry is deleted.")
sysApplInstallPkgManufacturer = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 2), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgManufacturer.setDescription("The Manufacturer of the software application package.")
sysApplInstallPkgProductName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 3), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgProductName.setDescription("The name assigned to the software application package\nby the Manufacturer.")
sysApplInstallPkgVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 4), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgVersion.setDescription("The version number assigned to the application package\nby the manufacturer of the software.")
sysApplInstallPkgSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 5), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgSerialNumber.setDescription("The serial number of the software assigned by the\nmanufacturer.")
sysApplInstallPkgDate = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgDate.setDescription("The date and time this software application was installed\non the host.")
sysApplInstallPkgLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 7), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgLocation.setDescription("The complete path name where the application package\nis installed.  For example, the value would be\n'/opt/MyapplDir' if the application package was installed\nin the /opt/MyapplDir directory.")
sysApplInstallElmtTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 1, 2))
if mibBuilder.loadTexts: sysApplInstallElmtTable.setDescription("This table details the individual application package\nelements (files and executables) which comprise the\napplications defined in the sysApplInstallPkg Table.\nEach entry in this table has an index to the\nsysApplInstallPkg table to identify the application\npackage of which it is a part. As a result, there may\nbe many entries in this table for each instance in the\nsysApplInstallPkg Table.\n\nTable entries are indexed by sysApplInstallPkgIndex,\nsysApplInstallElmtIndex to facilitate retrieval of\nall elements associated with a particular installed\napplication package.")
sysApplInstallElmtEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplInstallElmtIndex"))
if mibBuilder.loadTexts: sysApplInstallElmtEntry.setDescription("The logical row describing an element of an installed\napplication.  The element may be an executable or\nnon-executable file.")
sysApplInstallElmtIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplInstallElmtIndex.setDescription("An arbitrary integer used for indexing.  The value\nof this index is unique among all rows in this table\nthat exist or have existed since the last agent restart.")
sysApplInstallElmtName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 2), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtName.setDescription("The name of this element which is contained in the\napplication.")
sysApplInstallElmtType = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,2,5,3,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("nonexecutable", 2), ("operatingSystem", 3), ("deviceDriver", 4), ("application", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtType.setDescription("The type of element that is part of the installed\napplication.")
sysApplInstallElmtDate = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtDate.setDescription("The date and time that this component was installed on\nthe system.")
sysApplInstallElmtPath = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 5), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtPath.setDescription("The full directory path where this element is installed.\nFor example, the value would be '/opt/EMPuma/bin' for an\nelement installed in the directory '/opt/EMPuma/bin'.\nMost application packages include information about the\nelements contained in the package. In addition, elements\nare typically installed in sub-directories under the\npackage installation directory.  In cases where the\nelement path names are not included in the package\ninformation itself, the path can usually be determined\nby a simple search of the sub-directories.  If the\nelement is not installed in that location and there is\nno other information available to the agent implementation,\nthen the path is unknown and null is returned.")
sysApplInstallElmtSizeHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtSizeHigh.setDescription("The installed file size in 2^32 byte blocks. This is\nthe size of the file on disk immediately after installation.\n\nFor example, for a file with a total size of 4,294,967,296\nbytes, this variable would have a value of 1; for a file\nwith a total size of 4,294,967,295 bytes this variable\nwould be 0.")
sysApplInstallElmtSizeLow = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtSizeLow.setDescription("The installed file size modulo 2^32 bytes.  This is\nthe size of the file on disk immediately after installation.\n\nFor example, for a file with a total size of 4,294,967,296\nbytes this variable would have a value of 0; for a file with\na total size of 4,294,967,295 bytes this variable would be\n4,294,967,295.")
sysApplInstallElmtRole = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 8), Bits().subtype(namedValues=namedval.NamedValues(("executable", 0), ("exclusive", 1), ("primary", 2), ("required", 3), ("dependent", 4), ("unknown", 5), )).clone(("unknown",))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplInstallElmtRole.setDescription("An operator assigned value used in the determination of\napplication status. This value is used by the agent to\ndetermine both the mapping of started processes to the\ninitiation of an application, as well as to allow for a\ndetermination of application health. The default value,\nunknown(5), is used when an operator has not yet assigned\none of the other values.  If unknown(5) is set, bits\n1 - 4 have no meaning.  The possible values are:\n\n        executable(0),\n            An application may have one or\n            more executable elements.  The rest of the\n            bits have no meaning if the element is not\n            executable.\n        exclusive(1),\n            Only one copy of an exclusive element may be\n            running per invocation of the running\n            application.\n        primary(2),\n            The primary executable.  An application can\n            have one, and only one element that is designated\n            as the primary executable.  The execution of\n            this element constitutes an invocation of\n            the application.  This is used by the agent\n            implementation to determine the initiation of\n            an application.  The primary executable must\n            remain running long enough for the agent\n            implementation to detect its presence.\n        required(3),\n            An application may have zero or more required\n            elements. All required elements must be running\n            in order for the application to be judged to be\n            running and healthy.\n        dependent(4),\n            An application may have zero or more\n            dependent elements. Dependent elements may\n            not be running unless required elements are.\n        unknown(5)\n            Default value for the case when an operator\n            has not yet assigned one of the other values.\n            When set, bits 1, 2, 3, and 4 have no meaning.\n\n sysApplInstallElmtRole is used by the agent implementation\n in determining the initiation of an application, the\n current state of a running application (see\n sysApplRunCurrentState), when an application invocation is\n no longer running, and the exit status of a terminated\n application invocation (see sysApplPastRunExitState).")
sysApplInstallElmtModifyDate = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtModifyDate.setDescription("The date and time that this element was last modified.\nModification of the sysApplInstallElmtRole columnar\nobject does NOT constitute a modification of the element\nitself and should not affect the value of this object.")
sysApplInstallElmtCurSizeHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtCurSizeHigh.setDescription("The current file size in 2^32 byte blocks.\nFor example, for a file with a total size of 4,294,967,296\nbytes, this variable would have a value of 1; for a file\nwith a total size of 4,294,967,295 bytes this variable\nwould be 0.")
sysApplInstallElmtCurSizeLow = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtCurSizeLow.setDescription("The current file size modulo 2^32 bytes.\nFor example, for a file with a total size of 4,294,967,296\nbytes this variable would have a value of 0; for a file with\na total size of 4,294,967,295 bytes this variable would be\n4,294,967,295.")
sysApplRun = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1, 2))
sysApplRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 1))
if mibBuilder.loadTexts: sysApplRunTable.setDescription("The table describes the applications which are executing\non the host.  Each time an application is invoked,\nan entry is created in this table. When an application ends,\nthe entry is removed from this table and a corresponding\n        entry is created in the SysApplPastRunTable.\n\nA new entry is created in this table whenever the agent\nimplementation detects a new running process that is an\ninstalled application element whose sysApplInstallElmtRole\ndesignates it as being the application's primary executable\n(sysApplInstallElmtRole = primary(2) ).\n\nThe table is indexed by sysApplInstallPkgIndex,\nsysApplRunIndex to enable managers to easily locate all\ninvocations of a particular application package.")
sysApplRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplRunIndex"))
if mibBuilder.loadTexts: sysApplRunEntry.setDescription("The logical row describing an application which is\ncurrently running on this host.")
sysApplRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplRunIndex.setDescription("Part of the index for this table. An arbitrary\ninteger used only for indexing purposes. Generally\nmonotonically increasing from 1 as new applications are\nstarted on the host, it uniquely identifies application\ninvocations.\n\nThe numbering for this index increases by 1 for each\nINVOCATION of an application, regardless of which\ninstalled application package this entry represents a\nrunning instance of.\n\nAn example of the indexing for a couple of entries is\nshown below.\n\n              :\n         sysApplRunStarted.17.14\n         sysApplRunStarted.17.63\n         sysApplRunStarted.18.13\n              :\n\nIn this example, the agent has observed 12 application\ninvocations when the application represented by entry 18\nin the sysApplInstallPkgTable is invoked.  The next\ninvocation detected by the agent is an invocation of\ninstalled application package 17.  Some time later,\ninstalled application 17 is invoked a second time.\n\nNOTE: this index is not intended to reflect a real-time\n(wall clock time) ordering of application invocations;\nit is merely intended to uniquely identify running\ninstances of applications.  Although the\nsysApplInstallPkgIndex is included in the INDEX clause\nfor this table, it serves only to ease searching of\nthis table by installed application and does not\ncontribute to uniquely identifying table entries.")
sysApplRunStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplRunStarted.setDescription("The date and time that the application was started.")
sysApplRunCurrentState = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1, 3), RunState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplRunCurrentState.setDescription("The current state of the running application instance.\nThe possible values are running(1), runnable(2) but waiting\nfor a resource such as CPU, waiting(3) for an event,\nexiting(4), or other(5). This value is based on an evaluation\nof the running elements of this application instance (see\nsysApplElmRunState) and their Roles as defined by\nsysApplInstallElmtRole.  An agent implementation may\ndetect that an application instance is in the process of\nexiting if one or more of its REQUIRED elements are no\nlonger running.  Most agent implementations will wait until\na second internal poll has been completed to give the\nsystem time to start REQUIRED elements before marking the\napplication instance as exiting.")
sysApplPastRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 2))
if mibBuilder.loadTexts: sysApplPastRunTable.setDescription("A history of the applications that have previously run\non the host computer.  An entry's information is moved to\nthis table from the sysApplRunTable when the invoked\napplication represented by the entry ceases to be running.\n\nAn agent implementation can determine that an application\ninvocation is no longer running by evaluating the running\nelements of the application instance and their Roles as\ndefined by sysApplInstallElmtRole.  Obviously, if there\nare no running elements for the application instance,\nthen the application invocation is no longer running.\nIf any one of the REQUIRED elements is not running,\nthe application instance may be in the process of exiting.\nMost agent implementations will wait until a second internal\npoll has been completed to give the system time to either\nrestart partial failures or to give all elements time to\nexit.  If, after the second poll, there are REQUIRED\nelements that are not running, then the application\ninstance may be considered by the agent implementation\nto no longer be running.\n\nEntries remain in the sysApplPastRunTable until they\nare aged out when either the table size reaches a maximum\nas determined by the sysApplPastRunMaxRows, or when an entry\nhas aged to exceed a time limit as set by\nsysApplPastRunTblTimeLimit.\n\nEntries in this table are indexed by sysApplInstallPkgIndex,\nsysApplPastRunIndex to facilitate retrieval of all past\nrun invocations of a particular installed application.")
sysApplPastRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplPastRunIndex"))
if mibBuilder.loadTexts: sysApplPastRunEntry.setDescription("The logical row describing an invocation of an application\nwhich was previously run and has terminated.  The entry\nis basically copied from the sysApplRunTable when the\napplication instance terminates.  Hence, the entry's\nvalue for sysApplPastRunIndex is the same as its value was\nfor sysApplRunIndex.")
sysApplPastRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplPastRunIndex.setDescription("Part of the index for this table. An integer\nmatching the value of the removed sysApplRunIndex\ncorresponding to this row.")
sysApplPastRunStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunStarted.setDescription("The date and time that the application was started.")
sysApplPastRunExitState = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("complete", 1), ("failed", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunExitState.setDescription("The state of the application instance when it terminated.\nThis value is based on an evaluation of the running elements\nof an application and their Roles as defined by\nsysApplInstallElmtRole.  An application instance is said to\nhave exited in a COMPLETE state and its entry is removed\nfrom the sysApplRunTable and added to the sysApplPastRunTable\nwhen the agent detects that ALL elements of an application\ninvocation are no longer running.  Most agent implementations\nwill wait until a second internal poll has been completed to\ngive the system time to either restart partial failures or\nto give all elements time to exit.  A failed state occurs if,\nafter the second poll, any elements continue to run but\none or more of the REQUIRED elements are no longer running.\nAll other combinations MUST be defined as OTHER.")
sysApplPastRunTimeEnded = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunTimeEnded.setDescription("The DateAndTime the application instance was determined\nto be no longer running.")
sysApplElmtRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 3))
if mibBuilder.loadTexts: sysApplElmtRunTable.setDescription("The table describes the processes which are\ncurrently executing on the host system. Each entry\nrepresents a running process and is associated with\nthe invoked application of which that process is a part, if\npossible.  This table contains an entry for every process\ncurrently running on the system, regardless of whether its\n'parent' application can be determined.  So, for example,\nprocesses like 'ps' and 'grep' will have entries though they\nare not associated with an installed application package.\n\nBecause a running application may involve\nmore than one executable, it is possible to have\nmultiple entries in this table for each application.\nEntries are removed from this table when the process\nterminates.\nThe table is indexed by sysApplElmtRunInstallPkg,\nsysApplElmtRunInvocID, and sysApplElmtRunIndex to\nfacilitate the retrieval of all running elements of a\nparticular invoked application which has been installed on\nthe system.")
sysApplElmtRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunInstallPkg"), (0, "SYSAPPL-MIB", "sysApplElmtRunInvocID"), (0, "SYSAPPL-MIB", "sysApplElmtRunIndex"))
if mibBuilder.loadTexts: sysApplElmtRunEntry.setDescription("The logical row describing a process currently\nrunning on this host.  When possible, the entry is\nassociated with the invoked application of which it\nis a part.")
sysApplElmtRunInstallPkg = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplElmtRunInstallPkg.setDescription("Part of the index for this table, this value\nidentifies the installed software package for\nthe application of which this process is a part.\nProvided that the process's 'parent' application can be\ndetermined, the value of this object is the same\nvalue as the sysApplInstallPkgIndex for the\nentry in the sysApplInstallPkgTable that corresponds\nto the installed application of which this process\nis a part.\n\nIf, however, the 'parent' application cannot be\ndetermined, (for example the process is not part\nof a particular installed application), the value\nfor this object is then '0', signifying that this\nprocess cannot be related back to an application,\nand in turn, an installed software package.")
sysApplElmtRunInvocID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplElmtRunInvocID.setDescription("Part of the index for this table, this value\nidentifies the invocation of an application of which\nthis process is a part.  Provided that the 'parent'\napplication can be determined, the value of this object\nis the same value as the sysApplRunIndex for the\ncorresponding application invocation in the\nsysApplRunTable.\n\nIf, however, the 'parent' application cannot be\ndetermined, the value for this object is then '0',\nsignifying that this process cannot be related back\nto an invocation of an application in the\nsysApplRunTable.")
sysApplElmtRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplElmtRunIndex.setDescription("Part of the index for this table.  A unique value\nfor each process running on the host.  Wherever\npossible, this should be the system's native, unique\nidentification number.")
sysApplElmtRunInstallID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunInstallID.setDescription("The index into the sysApplInstallElmtTable. The\nvalue of this object is the same value as the\nsysApplInstallElmtIndex for the application element\nof which this entry represents a running instance.\nIf this process cannot be associated with an installed\nexecutable, the value should be '0'.")
sysApplElmtRunTimeStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunTimeStarted.setDescription("The time the process was started.")
sysApplElmtRunState = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 6), RunState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunState.setDescription("The current state of the running process. The\npossible values are running(1), runnable(2) but waiting\nfor a resource such as CPU, waiting(3) for an event,\nexiting(4), or other(5).")
sysApplElmtRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 7), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunName.setDescription("The full path and filename of the process.\nFor example, '/opt/MYYpkg/bin/myyproc' would\nbe returned for process 'myyproc' whose execution\npath is '/opt/MYYpkg/bin/myyproc'.")
sysApplElmtRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 8), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunParameters.setDescription("The starting parameters for the process.")
sysApplElmtRunCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunCPU.setDescription("The number of centi-seconds of the total system's\nCPU resources consumed by this process.  Note that\non a multi-processor system, this value may\nhave been incremented by more than one centi-second\nin one centi-second of real (wall clock) time.")
sysApplElmtRunMemory = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunMemory.setDescription("The total amount of real system memory measured in\nKbytes currently allocated to this process.")
sysApplElmtRunNumFiles = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunNumFiles.setDescription("The number of regular files currently open by the\nprocess.  Transport connections (sockets)\nshould NOT be included in the calculation of\nthis value, nor should operating system specific\nspecial file types.")
sysApplElmtRunUser = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 12), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunUser.setDescription("The process owner's login name (e.g. root).")
sysApplElmtPastRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 4))
if mibBuilder.loadTexts: sysApplElmtPastRunTable.setDescription("The table describes the processes which have previously\nexecuted on the host system as part of an application.\nEach entry represents a process which has previously\nexecuted and is associated with the invoked application\nof which it was a part.  Because an invoked application\nmay involve more than one executable, it is possible\nto have multiple entries in this table for\neach application invocation. Entries are added\nto this table when the corresponding process in the\nsysApplElmtRun Table terminates.\n\nEntries remain in this table until they are aged out when\neither the number of entries in the table reaches a\nmaximum as determined by sysApplElmtPastRunMaxRows, or\nwhen an entry has aged to exceed a time limit as set by\nsysApplElmtPastRunTblTimeLimit.  When aging out entries,\nthe oldest entry, as determined by the value of\nsysApplElmtPastRunTimeEnded, will be removed first.\n\nThe table is indexed by sysApplInstallPkgIndex (from the\nsysApplInstallPkgTable), sysApplElmtPastRunInvocID,\nand sysApplElmtPastRunIndex to make it easy to locate all\npreviously executed processes of a particular invoked\napplication that has been installed on the system.")
sysApplElmtPastRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplElmtPastRunInvocID"), (0, "SYSAPPL-MIB", "sysApplElmtPastRunIndex"))
if mibBuilder.loadTexts: sysApplElmtPastRunEntry.setDescription("The logical row describing a process which was\npreviously executed on this host as part of an\ninstalled application.  The entry is basically copied\nfrom the sysApplElmtRunTable when the process\nterminates.  Hence, the entry's value for\nsysApplElmtPastRunIndex is the same as its value\nwas for sysApplElmtRunIndex.  Note carefully: only those\nprocesses which could be associated with an\nidentified application are included in this table.")
sysApplElmtPastRunInvocID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplElmtPastRunInvocID.setDescription("Part of the index for this table, this value\nidentifies the invocation of an application of which\nthe process represented by this entry was a part.\nThe value of this object is the same value as the\nsysApplRunIndex for the corresponding application\ninvocation in the sysApplRunTable.  If the invoked\napplication as a whole has terminated, it will be the\nsame as the sysApplPastRunIndex.")
sysApplElmtPastRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplElmtPastRunIndex.setDescription("Part of the index for this table. An integer\nassigned by the agent equal to the corresponding\nsysApplElmtRunIndex which was removed from the\nsysApplElmtRunTable and moved to this table\nwhen the element terminated.\n\nNote: entries in this table are indexed by\nsysApplElmtPastRunInvocID, sysApplElmtPastRunIndex.\nThe possibility exists, though unlikely, of a\ncollision occurring by a new entry which was run\nby the same invoked application (InvocID), and\nwas assigned the same process identification number\n(ElmtRunIndex) as an element which was previously\nrun by the same invoked application.\n\nShould this situation occur, the new entry replaces\nthe old entry.\n\nSee Section: 'Implementation Issues -\nsysApplElmtPastRunTable Entry Collisions' for the\nconditions that would have to occur in order for a\ncollision to occur.")
sysApplElmtPastRunInstallID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunInstallID.setDescription("The index into the installed element table. The\nvalue of this object is the same value as the\nsysApplInstallElmtIndex for the application element\nof which this entry represents a previously executed\nprocess.")
sysApplElmtPastRunTimeStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunTimeStarted.setDescription("The time the process was started.")
sysApplElmtPastRunTimeEnded = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunTimeEnded.setDescription("The time the process ended.")
sysApplElmtPastRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 6), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunName.setDescription("The full path and filename of the process.\nFor example, '/opt/MYYpkg/bin/myyproc' would\nbe returned for process 'myyproc' whose execution\npath was '/opt/MYYpkg/bin/myyproc'.")
sysApplElmtPastRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 7), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunParameters.setDescription("The starting parameters for the process.")
sysApplElmtPastRunCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunCPU.setDescription("The last known number of centi-seconds of the total\nsystem's CPU resources consumed by this process.\nNote that on a multi-processor system, this value may\nincrement by more than one centi-second in one\ncenti-second of real (wall clock) time.")
sysApplElmtPastRunMemory = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunMemory.setDescription("The last known total amount of real system memory\nmeasured in Kbytes allocated to this process before it\nterminated.")
sysApplElmtPastRunNumFiles = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunNumFiles.setDescription("The last known number of files open by the\nprocess before it terminated.  Transport\nconnections (sockets) should NOT be included in\nthe calculation of this value.")
sysApplElmtPastRunUser = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 11), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunUser.setDescription("The process owner's login name (e.g. root).")
sysApplPastRunMaxRows = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 134980144)).clone(500)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplPastRunMaxRows.setDescription("The maximum number of entries allowed in the\nsysApplPastRunTable.  Once the number of rows in\nthe sysApplPastRunTable reaches this value, the\nmanagement subsystem will remove the oldest entry\nin the table to make room for the new entry to be added.\nEntries will be removed on the basis of oldest\nsysApplPastRunTimeEnded value first.\n\nThis object may be used to control the amount of\nsystem resources that can used for sysApplPastRunTable\nentries. A conforming implementation should attempt\nto support the default value, however, a lesser value\nmay be necessary due to implementation-dependent issues\nand resource availability.")
sysApplPastRunTableRemItems = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunTableRemItems.setDescription("A counter of the number of entries removed from\nthe sysApplPastRunTable because of table size limitations\nas set in sysApplPastRunMaxRows.  This counter is the\nnumber of entries the management subsystem has had to\nremove in order to make room for new entries (so as not\nto exceed the limit set by sysApplPastRunMaxRows) since\nthe last initialization of the management subsystem.")
sysApplPastRunTblTimeLimit = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).clone(7200)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: sysApplPastRunTblTimeLimit.setDescription("The maximum time in seconds which an entry in the\nsysApplPastRunTable may exist before it is removed.\nAny entry that is older than this value will be\nremoved (aged out) from the table.\n\nNote that an entry may be aged out prior to reaching\nthis time limit if it is the oldest entry in the\ntable and must be removed to make space for a new\nentry so as to not exceed sysApplPastRunMaxRows.")
sysApplElemPastRunMaxRows = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).clone(500)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplElemPastRunMaxRows.setDescription("The maximum number of entries allowed in the\nsysApplElmtPastRunTable.  Once the number of rows in\nthe sysApplElmtPastRunTable reaches this value,\nthe management subsystem will remove the oldest entry\nto make room for the new entry to be added.  Entries\nwill be removed on the basis of oldest\nsysApplElmtPastRunTimeEnded value first.\nThis object may be used to control the amount of\nsystem resources that can used for sysApplElemPastRunTable\nentries. A conforming implementation should attempt\nto support the default value, however, a lesser value\nmay be necessary due to implementation-dependent issues\nand resource availability.")
sysApplElemPastRunTableRemItems = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElemPastRunTableRemItems.setDescription("A counter of the number of entries removed from the\nsysApplElemPastRunTable because of table size limitations\nas set in sysApplElemPastRunMaxRows.  This counter is the\nnumber of entries the management subsystem has had to\nremove in order to make room for new entries (so as not\nto exceed the limit set by sysApplElemPastRunMaxRows) since\nthe last initialization of the management subsystem.")
sysApplElemPastRunTblTimeLimit = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).clone(7200)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: sysApplElemPastRunTblTimeLimit.setDescription("The maximum time in seconds which an entry in the\nsysApplElemPastRunTable may exist before it is removed.\nAny entry that is older than this value will be\nremoved (aged out) from the table.\n\nNote that an entry may be aged out prior to reaching\nthis time limit if it is the oldest entry in the\ntable and must be removed to make space for a new\nentry so as to not exceed sysApplElemPastRunMaxRows.")
sysApplAgentPollInterval = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295)).clone(60)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: sysApplAgentPollInterval.setDescription("The minimum interval in seconds that the management\nsubsystem implementing this MIB will poll the status\nof the managed resources. Because of the non-trivial\neffort involved in polling the managed resources,\nand because the method for obtaining the status of\nthe managed resources is implementation-dependent,\na conformant implementation may chose a lower bound\ngreater than 0.\n\nA value of 0 indicates that there is no delay\nin the passing of information from the managed\nresources to the agent.")
sysApplMap = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1, 3))
sysApplMapTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 3, 1))
if mibBuilder.loadTexts: sysApplMapTable.setDescription("The sole purpose of this table is to provide a\n'backwards' mapping so that, given a known\nsysApplElmtRunIndex (process identification number),\nthe corresponding invoked application (sysApplRunIndex),\ninstalled element (sysApplInstallElmtIndex), and\ninstalled application package (sysApplInstallPkgIndex)\ncan be quickly determined.\n\nThis table will contain one entry for each process\nthat is currently executing on the system.\n\nIt is expected that management applications will use\nthis mapping table by doing a 'GetNext' operation with\nthe known process ID number (sysApplElmtRunIndex) as the\npartial instance identifier.  Assuming that there is an\nentry for the process, the result should return a single\ncolumnar value, the sysApplMapInstallPkgIndex, with the\nsysApplElmtRunIndex, sysApplRunIndex, and\nsysApplInstallElmtIndex contained in the instance identifier\nfor the returned MIB object value.\n\nNOTE: if the process can not be associated back to an\ninvoked application installed on the system, then the\nvalue returned for the columnar value\nsysApplMapInstallPkgIndex will be '0' and the instance\nportion of the object-identifier will be the process ID\nnumber (sysApplElmtRunIndex) followed by 0.0.")
sysApplMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 3, 1, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunIndex"), (0, "SYSAPPL-MIB", "sysApplElmtRunInvocID"), (0, "SYSAPPL-MIB", "sysApplMapInstallElmtIndex"))
if mibBuilder.loadTexts: sysApplMapEntry.setDescription("A logical row representing a process currently running\non the system.  This entry provides the index mapping from\nprocess identifier, back to the invoked application,\ninstalled element, and finally, the installed application\npackage.  The entry includes only one accessible columnar\nobject, the sysApplMapInstallPkgIndex, but the\ninvoked application and installed element can be\ndetermined from the instance identifier since they form\npart of the index clause.")
sysApplMapInstallElmtIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sysApplMapInstallElmtIndex.setDescription("The index into the sysApplInstallElmtTable. The\nvalue of this object is the same value as the\nsysApplInstallElmtIndex for the application element\nof which this entry represents a running instance.\nIf this process cannot be associated to an installed\nexecutable, the value should be '0'.")
sysApplMapInstallPkgIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 3, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplMapInstallPkgIndex.setDescription("The value of this object identifies the installed\nsoftware package for the application of which this\nprocess is a part.  Provided that the process's 'parent'\napplication can be determined, the value of this object\nis the same value as the sysApplInstallPkgIndex for the\nentry in the sysApplInstallPkgTable that corresponds\nto the installed application of which this process\nis a part.\n\nIf, however, the 'parent' application cannot be\ndetermined, (for example the process is not part\nof a particular installed application), the value\nfor this object is then '0', signifying that this\nprocess cannot be related back to an application,\nand in turn, an installed software package.")
sysApplNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 2))
sysApplConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 3))
sysApplMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 3, 1))
sysApplMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 3, 2))

# Augmentions

# Groups

sysApplInstalledGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 54, 3, 2, 1)).setObjects(("SYSAPPL-MIB", "sysApplInstallElmtSizeHigh"), ("SYSAPPL-MIB", "sysApplInstallPkgSerialNumber"), ("SYSAPPL-MIB", "sysApplInstallElmtSizeLow"), ("SYSAPPL-MIB", "sysApplInstallElmtRole"), ("SYSAPPL-MIB", "sysApplInstallElmtCurSizeHigh"), ("SYSAPPL-MIB", "sysApplInstallPkgProductName"), ("SYSAPPL-MIB", "sysApplInstallPkgManufacturer"), ("SYSAPPL-MIB", "sysApplInstallElmtType"), ("SYSAPPL-MIB", "sysApplInstallPkgDate"), ("SYSAPPL-MIB", "sysApplInstallElmtPath"), ("SYSAPPL-MIB", "sysApplInstallElmtDate"), ("SYSAPPL-MIB", "sysApplInstallPkgLocation"), ("SYSAPPL-MIB", "sysApplInstallElmtName"), ("SYSAPPL-MIB", "sysApplInstallPkgVersion"), ("SYSAPPL-MIB", "sysApplInstallElmtCurSizeLow"), ("SYSAPPL-MIB", "sysApplInstallElmtModifyDate"), )
if mibBuilder.loadTexts: sysApplInstalledGroup.setDescription("The system application installed group contains\ninformation about applications and their constituent\ncomponents which have been installed on the host system.")
sysApplRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 54, 3, 2, 2)).setObjects(("SYSAPPL-MIB", "sysApplElmtRunInstallID"), ("SYSAPPL-MIB", "sysApplPastRunExitState"), ("SYSAPPL-MIB", "sysApplElmtPastRunUser"), ("SYSAPPL-MIB", "sysApplElmtPastRunMemory"), ("SYSAPPL-MIB", "sysApplElmtRunName"), ("SYSAPPL-MIB", "sysApplAgentPollInterval"), ("SYSAPPL-MIB", "sysApplElmtRunState"), ("SYSAPPL-MIB", "sysApplElmtPastRunName"), ("SYSAPPL-MIB", "sysApplElmtPastRunCPU"), ("SYSAPPL-MIB", "sysApplRunCurrentState"), ("SYSAPPL-MIB", "sysApplElmtPastRunTimeStarted"), ("SYSAPPL-MIB", "sysApplElmtPastRunParameters"), ("SYSAPPL-MIB", "sysApplElemPastRunMaxRows"), ("SYSAPPL-MIB", "sysApplPastRunStarted"), ("SYSAPPL-MIB", "sysApplPastRunMaxRows"), ("SYSAPPL-MIB", "sysApplElmtPastRunInstallID"), ("SYSAPPL-MIB", "sysApplPastRunTblTimeLimit"), ("SYSAPPL-MIB", "sysApplPastRunTableRemItems"), ("SYSAPPL-MIB", "sysApplElmtRunNumFiles"), ("SYSAPPL-MIB", "sysApplRunStarted"), ("SYSAPPL-MIB", "sysApplElmtPastRunTimeEnded"), ("SYSAPPL-MIB", "sysApplPastRunTimeEnded"), ("SYSAPPL-MIB", "sysApplElmtRunUser"), ("SYSAPPL-MIB", "sysApplElmtRunMemory"), ("SYSAPPL-MIB", "sysApplElmtRunParameters"), ("SYSAPPL-MIB", "sysApplElmtPastRunNumFiles"), ("SYSAPPL-MIB", "sysApplElemPastRunTblTimeLimit"), ("SYSAPPL-MIB", "sysApplElmtRunCPU"), ("SYSAPPL-MIB", "sysApplElemPastRunTableRemItems"), ("SYSAPPL-MIB", "sysApplElmtRunTimeStarted"), )
if mibBuilder.loadTexts: sysApplRunGroup.setDescription("The system application run group contains information\nabout applications and associated elements which have\nrun or are currently running on the host system.")
sysApplMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 54, 3, 2, 3)).setObjects(("SYSAPPL-MIB", "sysApplMapInstallPkgIndex"), )
if mibBuilder.loadTexts: sysApplMapGroup.setDescription("The Map Group contains a single table, sysApplMapTable,\nthat provides a backwards mapping for determining the\ninvoked application, installed element, and installed\napplication package given a known process identification\nnumber.")

# Compliances

sysApplMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 54, 3, 1, 1)).setObjects(("SYSAPPL-MIB", "sysApplMapGroup"), ("SYSAPPL-MIB", "sysApplInstalledGroup"), ("SYSAPPL-MIB", "sysApplRunGroup"), )
if mibBuilder.loadTexts: sysApplMIBCompliance.setDescription("Describes the requirements for conformance to\nthe System Application MIB")

# Exports

# Module identity
mibBuilder.exportSymbols("SYSAPPL-MIB", PYSNMP_MODULE_ID=sysApplMIB)

# Types
mibBuilder.exportSymbols("SYSAPPL-MIB", LongUtf8String=LongUtf8String, RunState=RunState, Utf8String=Utf8String)

# Objects
mibBuilder.exportSymbols("SYSAPPL-MIB", sysApplMIB=sysApplMIB, sysApplOBJ=sysApplOBJ, sysApplInstalled=sysApplInstalled, sysApplInstallPkgTable=sysApplInstallPkgTable, sysApplInstallPkgEntry=sysApplInstallPkgEntry, sysApplInstallPkgIndex=sysApplInstallPkgIndex, sysApplInstallPkgManufacturer=sysApplInstallPkgManufacturer, sysApplInstallPkgProductName=sysApplInstallPkgProductName, sysApplInstallPkgVersion=sysApplInstallPkgVersion, sysApplInstallPkgSerialNumber=sysApplInstallPkgSerialNumber, sysApplInstallPkgDate=sysApplInstallPkgDate, sysApplInstallPkgLocation=sysApplInstallPkgLocation, sysApplInstallElmtTable=sysApplInstallElmtTable, sysApplInstallElmtEntry=sysApplInstallElmtEntry, sysApplInstallElmtIndex=sysApplInstallElmtIndex, sysApplInstallElmtName=sysApplInstallElmtName, sysApplInstallElmtType=sysApplInstallElmtType, sysApplInstallElmtDate=sysApplInstallElmtDate, sysApplInstallElmtPath=sysApplInstallElmtPath, sysApplInstallElmtSizeHigh=sysApplInstallElmtSizeHigh, sysApplInstallElmtSizeLow=sysApplInstallElmtSizeLow, sysApplInstallElmtRole=sysApplInstallElmtRole, sysApplInstallElmtModifyDate=sysApplInstallElmtModifyDate, sysApplInstallElmtCurSizeHigh=sysApplInstallElmtCurSizeHigh, sysApplInstallElmtCurSizeLow=sysApplInstallElmtCurSizeLow, sysApplRun=sysApplRun, sysApplRunTable=sysApplRunTable, sysApplRunEntry=sysApplRunEntry, sysApplRunIndex=sysApplRunIndex, sysApplRunStarted=sysApplRunStarted, sysApplRunCurrentState=sysApplRunCurrentState, sysApplPastRunTable=sysApplPastRunTable, sysApplPastRunEntry=sysApplPastRunEntry, sysApplPastRunIndex=sysApplPastRunIndex, sysApplPastRunStarted=sysApplPastRunStarted, sysApplPastRunExitState=sysApplPastRunExitState, sysApplPastRunTimeEnded=sysApplPastRunTimeEnded, sysApplElmtRunTable=sysApplElmtRunTable, sysApplElmtRunEntry=sysApplElmtRunEntry, sysApplElmtRunInstallPkg=sysApplElmtRunInstallPkg, sysApplElmtRunInvocID=sysApplElmtRunInvocID, sysApplElmtRunIndex=sysApplElmtRunIndex, sysApplElmtRunInstallID=sysApplElmtRunInstallID, sysApplElmtRunTimeStarted=sysApplElmtRunTimeStarted, sysApplElmtRunState=sysApplElmtRunState, sysApplElmtRunName=sysApplElmtRunName, sysApplElmtRunParameters=sysApplElmtRunParameters, sysApplElmtRunCPU=sysApplElmtRunCPU, sysApplElmtRunMemory=sysApplElmtRunMemory, sysApplElmtRunNumFiles=sysApplElmtRunNumFiles, sysApplElmtRunUser=sysApplElmtRunUser, sysApplElmtPastRunTable=sysApplElmtPastRunTable, sysApplElmtPastRunEntry=sysApplElmtPastRunEntry, sysApplElmtPastRunInvocID=sysApplElmtPastRunInvocID, sysApplElmtPastRunIndex=sysApplElmtPastRunIndex, sysApplElmtPastRunInstallID=sysApplElmtPastRunInstallID, sysApplElmtPastRunTimeStarted=sysApplElmtPastRunTimeStarted, sysApplElmtPastRunTimeEnded=sysApplElmtPastRunTimeEnded, sysApplElmtPastRunName=sysApplElmtPastRunName, sysApplElmtPastRunParameters=sysApplElmtPastRunParameters, sysApplElmtPastRunCPU=sysApplElmtPastRunCPU, sysApplElmtPastRunMemory=sysApplElmtPastRunMemory, sysApplElmtPastRunNumFiles=sysApplElmtPastRunNumFiles, sysApplElmtPastRunUser=sysApplElmtPastRunUser, sysApplPastRunMaxRows=sysApplPastRunMaxRows, sysApplPastRunTableRemItems=sysApplPastRunTableRemItems, sysApplPastRunTblTimeLimit=sysApplPastRunTblTimeLimit, sysApplElemPastRunMaxRows=sysApplElemPastRunMaxRows, sysApplElemPastRunTableRemItems=sysApplElemPastRunTableRemItems, sysApplElemPastRunTblTimeLimit=sysApplElemPastRunTblTimeLimit, sysApplAgentPollInterval=sysApplAgentPollInterval, sysApplMap=sysApplMap, sysApplMapTable=sysApplMapTable, sysApplMapEntry=sysApplMapEntry, sysApplMapInstallElmtIndex=sysApplMapInstallElmtIndex, sysApplMapInstallPkgIndex=sysApplMapInstallPkgIndex, sysApplNotifications=sysApplNotifications, sysApplConformance=sysApplConformance, sysApplMIBCompliances=sysApplMIBCompliances, sysApplMIBGroups=sysApplMIBGroups)

# Groups
mibBuilder.exportSymbols("SYSAPPL-MIB", sysApplInstalledGroup=sysApplInstalledGroup, sysApplRunGroup=sysApplRunGroup, sysApplMapGroup=sysApplMapGroup)

# Compliances
mibBuilder.exportSymbols("SYSAPPL-MIB", sysApplMIBCompliance=sysApplMIBCompliance)
