# PySNMP SMI module. Autogenerated from smidump -f python T11-FC-FABRIC-ADDR-MGR-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:16 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( FcDomainIdOrZero, FcNameIdOrZero, fcmInstanceIndex, fcmSwitchIndex, ) = mibBuilder.importSymbols("FC-MGMT-MIB", "FcDomainIdOrZero", "FcNameIdOrZero", "fcmInstanceIndex", "fcmSwitchIndex")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TruthValue")
( T11FabricIndex, ) = mibBuilder.importSymbols("T11-TC-MIB", "T11FabricIndex")

# Types

class T11FamDomainInterfaceRole(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,2,3,6,4,5,)
    namedValues = namedval.NamedValues(("nonPrincipal", 1), ("principalUpstream", 2), ("principalDownsteam", 3), ("isolated", 4), ("down", 5), ("unknown", 6), )
    
class T11FamDomainPriority(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(1,255)
    
class T11FamState(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(7,6,4,8,12,11,10,1,3,5,9,2,)
    namedValues = namedval.NamedValues(("other", 1), ("noDomains", 10), ("disabled", 11), ("unknown", 12), ("starting", 2), ("unconfigured", 3), ("principalSwitchSelection", 4), ("domainIdDistribution", 5), ("buildFabricPhase", 6), ("reconfigureFabricPhase", 7), ("stable", 8), ("stableWithNoEports", 9), )
    

# Objects

t11FcFabricAddrMgrMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 137)).setRevisions(("2006-03-02 00:00",))
if mibBuilder.loadTexts: t11FcFabricAddrMgrMIB.setOrganization("T11")
if mibBuilder.loadTexts: t11FcFabricAddrMgrMIB.setContactInfo("     Claudio DeSanti\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA 95134 USA\nPhone: +1 408 853-9172\nEMail: cds@cisco.com\n\nKeith McCloghrie\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA USA 95134\nPhone: +1 408-526-5260\nEMail: kzm@cisco.com")
if mibBuilder.loadTexts: t11FcFabricAddrMgrMIB.setDescription("The MIB module for the Fabric Address management\nfunctionality defined by the Fibre Channel standards.  For\nthe purposes of this MIB, Fabric Address Manager refers to\nthe functionality of acquiring DomainID(s) as specified in\nFC-SW-3, and managing Fibre Channel Identifiers as specified\nin FC-FS.  An instance of 'Fabric Address Manager' software\nfunctionality executes in the Principal Switch, and in each\nother switch.\n\nAfter an agent reboot, the values of read-write objects\ndefined in this MIB module are implementation-dependent.\n\nCopyright (C) The Internet Society (2006).  This version of\nthis MIB module is part of RFC 4439;  see the RFC itself for\nfull legal notices.")
t11FamNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 0))
t11FamMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 1))
t11FamConfiguration = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 1, 1))
t11FamTable = MibTable((1, 3, 6, 1, 2, 1, 137, 1, 1, 1))
if mibBuilder.loadTexts: t11FamTable.setDescription("This table contains Fabric Address Manager related\nparameters that are able to be configured and monitored\nin a Fibre Channel switch.  For each of the switches\n(identified by fcmSwitchIndex) managed by a Fibre Channel\nmanagement instance (identified by fcmInstanceIndex),\nthere is any entry for each Fabric known to that switch.\nEntries are implicitly created/removed if and when\nadditional Fabrics are created/deleted.")
t11FamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricIndex"))
if mibBuilder.loadTexts: t11FamEntry.setDescription("An entry provides information on the local Fabric Address\nManager functionality for a Fabric known to a\nparticular switch.")
t11FamFabricIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 1), T11FabricIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11FamFabricIndex.setDescription("A unique index value that uniquely identifies a\nparticular Fabric known to a particular switch.\n\nIn a Fabric conformant to FC-SW-3, only a single Fabric\ncan operate within a physical infrastructure, and thus,\nthe value of this Fabric Index will always be 1.\n\nHowever, the current standard, FC-SW-4, defines\nhow multiple Fabrics, each with its own management\ninstrumentation, could operate within one (or more)\nphysical infrastructures.  When such multiple Fabrics\nare in use, this index value is used to uniquely\nidentify a particular Fabric within a physical\ninfrastructure.")
t11FamConfigDomainId = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 2), FcDomainIdOrZero().clone('0')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamConfigDomainId.setDescription("The configured Domain_ID of the particular switch on this\nFabric, or zero if no Domain_ID has been configured.\nThe meaning of this object depends on\nt11FamConfigDomainIdType object.\n\nIf t11FamConfigDomainIdType is 'preferred', then the\nconfigured Domain_ID is called the 'preferred Domain_ID'.\nValid values are between 0 and 239.  In a situation where\nthis Domain_ID cannot be assigned, any other Domain_ID\nwill be acceptable.  A value of zero means any Domain_ID.\n\nIf t11FamConfigDomainIdType is 'insistent', then the\nconfigured Domain_ID is called the 'insistent Domain_ID' and\nvalid values are between 1 and 239.  In a situation where\nthis Domain_ID cannot be assigned, no other Domain_ID is\nacceptable.\n\nIn both of the above cases, the switch sends an RDI (Request\nDomain_ID) to request this Domain_ID to the Principal\nSwitch.  If no Domain_ID is able to be granted in the case\nof 'preferred', or if an 'insistent' Domain_ID is configured\nbut not able to be granted, then it is an error condition.\nWhen this error occurs, the switch will continue as if it\nreceives a SW_RJT with a reason/explanation of 'Unable to\nperform command request'/'Domain_ID not available'.  That\nis, its E_Ports on that Fabric will be isolated and the\nadministrator informed via a 't11FamDomainIdNotAssigned'\nnotification.\n\nIf t11FamConfigDomainIdType is 'static', then the configured\nDomain_ID is called the 'static Domain_ID' and valid values\nare between 1 and 239.  In this situation, there is no\nPrincipal Switch in the Fabric and the Domain_ID is simply\nassigned by configuration, together with the Fabric_Name.\nA switch configured with a static Domain_ID, on receiving\nan EFP, BF, RCF, DIA, or RDI SW_ILS, shall reply with an\nSW_RJT having Reason Code Explanation 'E_Port is Isolated'\nand shall isolate the receiving E_Port.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamConfigDomainIdType = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("preferred", 1), ("insistent", 2), ("static", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamConfigDomainIdType.setDescription("Type of configured Domain_ID contained in\nt11FamConfigDomainId.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamAutoReconfigure = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 4), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamAutoReconfigure.setDescription("This object determines how a particular switch\nresponds to certain error conditions.\n\nThe condition that might cause these errors is\nthe merging of two disjoint Fabrics that have\noverlapping Domain_ID lists.\n\nIf value of this object is 'true', the switch will\nsend an RCF (ReConfigureFabric) to rebuild the\nFabric.\n\nIf 'false', the switch will isolate the E_Ports on\nwhich the errors happened.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamContiguousAllocation = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamContiguousAllocation.setDescription("Determines how a particular switch behaves when elected as\nthe Principal Switch.\n\nIf true, the switch will only accept RDIs with a contiguous\nallocation; specifically, it will reject RDIs with\nnon-contiguous Domain_IDs, and if an RDI for a contiguous\nDomain_ID is not able to be fulfilled, it will try to\nreplace all the Domain_IDs in the list with contiguous\nDomain_IDs, and if that fails, the RDI will be rejected.\n\nIf false, then the switch acts normally in granting\nthe Domain_IDs even if they are not contiguous.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 6), T11FamDomainPriority()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamPriority.setDescription("The initial or configured priority of a particular switch\nto be used in Principal Switch selection process.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamPrincipalSwitchWwn = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 7), FcNameIdOrZero().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamPrincipalSwitchWwn.setDescription("The WWN of the Principal Switch on this Fabric,\nor zero-length string if the identity of the principal\nswitch is unknown.")
t11FamLocalSwitchWwn = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 8), FcNameIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamLocalSwitchWwn.setDescription("The WWN of the particular switch on this Fabric.")
t11FamAssignedAreaIdList = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 9), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamAssignedAreaIdList.setDescription("The list of (zero or more) Area_IDs that have been\nassigned by a particular switch in this Fabric, formatted\nas an array of octets in ascending order.\n\nEach octet represents one Area_ID.  So, the list containing\nArea_IDs 23, 45, 235, and 56 would be formatted as the\n4-octet string x'172d38eb'.\n\nA particular area's Area_ID is used as the index into the\nt11FamAreaTable to get the statistics on that area.")
t11FamGrantedFcIds = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamGrantedFcIds.setDescription("The total number of Fibre Channel Address Identifiers\ngranted (for local use, i.e., with a particular switch's\nDomain_ID) by the Fabric Address Manager on that switch.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11FamRecoveredFcIds = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamRecoveredFcIds.setDescription("The total number of Fibre Channel Address Identifiers that\nhave been recovered by the Fabric Address Manager on a\nparticular switch since the switch has been initialized.\nA recovered Fibre Channel Address Identifier is one that is\nexplicitly returned after previously being used.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11FamFreeFcIds = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamFreeFcIds.setDescription("The number of Fibre Channel Address Identifiers that are\ncurrently unassigned on this Fabric and could be available\nfor assignment either immediately or at some later time.\n\nThe sum of the instances of FreeFcIds and AssignedFcIds\ncorresponding to a particular Fabric is the total number of\nFibre Channel Address Identifiers that the local Fabric\nAddress Management is capable of assigning on that Fabric.")
t11FamAssignedFcIds = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamAssignedFcIds.setDescription("The number of Fibre Channel Address Identifiers that are\ncurrently assigned on this Fabric.\n\nThe sum of the instances of FreeFcIds and AssignedFcIds\ncorresponding to a particular Fabric is the total number of\nFibre Channel Address Identifiers that the local Fabric\nAddress Management is capable of assigning on that Fabric.")
t11FamAvailableFcIds = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamAvailableFcIds.setDescription("The number of Fibre Channel Address Identifiers that are\nunassigned and currently available for immediate assignment\non the Fabric, e.g., with the 'Clean Address' bit set to 1.")
t11FamRunningPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 15), T11FamDomainPriority()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamRunningPriority.setDescription("The running priority of a particular switch on this Fabric.\nThis value is initialized to the value of t11FamPriority,\nand subsequently altered as specified by the procedures\ndefined in FC-SW-3.")
t11FamPrincSwRunningPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 16), T11FamDomainPriority()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamPrincSwRunningPriority.setDescription("The running priority of the Principal Switch on this\nFabric.")
t11FamState = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 17), T11FamState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamState.setDescription("The state of the Fabric Address Manager on a particular\nswitch on this Fabric.")
t11FamLocalPrincipalSwitchSlctns = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamLocalPrincipalSwitchSlctns.setDescription("The number of times a particular switch became the\nPrincipal Switch on this Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11FamPrincipalSwitchSelections = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamPrincipalSwitchSelections.setDescription("The number of Principal Switch selections on this Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11FamBuildFabrics = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamBuildFabrics.setDescription("The number of non-disruptive fabric reconfigurations (BFs)\nthat have occurred on this Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11FamFabricReconfigures = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamFabricReconfigures.setDescription("The number of disruptive fabric reconfigurations (RCFs)\nthat have occurred on this Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11FamDomainId = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 22), FcDomainIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamDomainId.setDescription("The Domain_ID of a particular switch on this Fabric or\nzero if no Domain_ID has been assigned.")
t11FamSticky = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 23), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamSticky.setDescription("An indication of whether a particular switch is supporting\nthe concept of Preferred Domain_IDs via a best-effort\nattempt to re-assign the same Fibre Channel Address\nIdentifier value to a port on the next occasion when a port\nrequests an assignment on this Fabric.\n\nIf the value of this object is 'true', then the switch is\nmaintaining rows in the t11FamFcIdCacheTable for this\nFabric.")
t11FamRestart = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 24), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("nonDisruptive", 1), ("disruptive", 2), ("noOp", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamRestart.setDescription("This object tells the Fabric Address Manager to\nrequest a Fabric reconfiguration.\n\nIf this object is set to 'disruptive', then an RCF\n(ReConfigure Fabric) is generated in the Fabric\nin order for the Fabric to recover from the errors.\n\nIf this object is set to 'nonDisruptive', then a\nBF (Build Fabric) is generated in the Fabric.\n\nNo action is taken if this object is set to 'noOp'.\nThe value of the object when read is always 'noOp'.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamRcFabricNotifyEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 25), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamRcFabricNotifyEnable.setDescription("An indication of whether or not a particular switch\nshould issue a t11FamFabricChangeNotify notification on\nsending or receiving ReConfigureFabric (RCF) on a Fabric.\n\nIf the value of the object is 'true', then the\nnotification is generated.  If the value is 'false',\nnotification is not generated.\n\nIf an implementation requires all Fabrics to have the\nsame value, then setting one instance of this object\nto a new object will result in all corresponding\ninstances being set to that same new value.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 26), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamEnable.setDescription("Enables the Fabric Address Manager on this switch\non this Fabric.\n\nIf enabled on a Fabric, the switch will participate in\nPrincipal Switch selection, and Domain_IDs are assigned\ndynamically.  If disabled, the switch will not participate\nin Principal Switch selection, and Domain_IDs are\nassigned statically.  Thus, the corresponding value of\nt11FamConfigDomainIdType needs to be 'static'.\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamFabricName = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 1, 1, 27), FcNameIdOrZero()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11FamFabricName.setDescription("The WWN that is configured on this switch to be used as\nthe name of this Fabric when the value of t11FamEnable is\n'false'.\n\nIf the value of t11FamEnable is 'true', this value is not\nused.\n\nFibre Channel requires that:\n    a) all switches in an operational Fabric be\n       configured with the same Fabric name; and\n    b) each Fabric have a unique Fabric name.\nIf either of these is violated, either by switches within a\nsingle Fabric being configured with different Fabric names,\nor by multiple Fabrics that share management applications\nor interact in other ways having the same Fabric name,\nthen the behavior of the switches and associated management\nfunctions is not specified by Fibre Channel or Internet\nstandards.\n\n\n\nFor the persistence of values across reboots, see the\nMODULE-IDENTITY's DESCRIPTION clause.")
t11FamIfTable = MibTable((1, 3, 6, 1, 2, 1, 137, 1, 1, 2))
if mibBuilder.loadTexts: t11FamIfTable.setDescription("This table contains those Fabric Address Manager parameters\nand status values that are per-interface (identified\nby an ifIndex value), per-Fabric (identified by a\nt11FamFabricIndex value), and per-switch (identified by\nvalues of fcmInstanceIndex and fcmSwitchIndex).\n\nAn entry in this table is automatically created when\nan E_Port becomes non-isolated on a particular Fabric.\n\nAn entry is deleted automatically from this table if:\na) the corresponding interface is no longer an E_Port (e.g.,\n   a G_Port that is dynamically determined to be an F_Port),\n   and all configuration parameter(s) have default values; or\nb) the interface identified by ifIndex no longer exists\n   (e.g., because a line-card is physically removed); or\nc) the row in the t11FamTable corresponding the fabric\n   identified by t11FamFabricID no longer exists.\n\nCreating an entry in this table via t11FamIfRowStatus\nprovides the means to specify non-default parameter value(s)\nfor an interface at a time when the relevant row in this\ntable does not exist, i.e., because the interface is either\ndown or it is not an E_Port.")
t11FamIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 137, 1, 1, 2, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricIndex"), (0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: t11FamIfEntry.setDescription("An entry containing information on the interface\nconfiguration on the Fabric identified by\n\n\n\nt11FamFabricIndex.")
t11FamIfRcfReject = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 2, 1, 1), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11FamIfRcfReject.setDescription("This object determines if the incoming ReConfigure\nFabric (RCF) messages on this interface on this\nFabric is accepted or not.  If this object is 'true', then\nthe incoming RCF is rejected.  If 'false', incoming RCF is\naccepted.\n\nNote that this object does not apply to the outgoing\nRCFs generated by this interface.\n\nImplementations that support write-access to this object\ncan do so under whatever conditions they choose.")
t11FamIfRole = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 2, 1, 2), T11FamDomainInterfaceRole()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamIfRole.setDescription("The role of this interface.")
t11FamIfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 1, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11FamIfRowStatus.setDescription("The status of this row.")
t11FamInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 1, 2))
t11FamAreaTable = MibTable((1, 3, 6, 1, 2, 1, 137, 1, 2, 1))
if mibBuilder.loadTexts: t11FamAreaTable.setDescription("This table contains area assignments per-Fabric by a\nswitch's Fabric Address Manager.  Each octet in\nt11FamAssignedAreaList is able to be used to index into\nthis table to find information on each area.")
t11FamAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 137, 1, 2, 1, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAreaAreaId"))
if mibBuilder.loadTexts: t11FamAreaEntry.setDescription("An entry gives information on the Area_ID and all\nPort_IDs that have been assigned within an area for\nthe Fabric identified by t11FamFabricIndex, by the\nFabric Address Manager in the switch identified by\nfcmInstanceIndex and fcmSwitchIndex.")
t11FamAreaAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11FamAreaAreaId.setDescription("The Area_ID of this area.")
t11FamAreaAssignedPortIdList = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 1, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamAreaAssignedPortIdList.setDescription("The list of Port_IDs which have been assigned in\nthis area and Fabric, formatted as an array of\noctets in ascending order.  There could be zero or more\nPort_IDs assigned on this area and Fabric.\n\nEach octet represents one Port_ID.  So, the list containing\nthe Port_IDs 23, 45, 235, and 56 would be formatted as the\n4-octet string x'172d38eb'.")
t11FamDatabaseTable = MibTable((1, 3, 6, 1, 2, 1, 137, 1, 2, 2))
if mibBuilder.loadTexts: t11FamDatabaseTable.setDescription("This table contains all information known by\na switch about all the domains that have been\nassigned in each Fabric.")
t11FamDatabaseEntry = MibTableRow((1, 3, 6, 1, 2, 1, 137, 1, 2, 2, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamDatabaseDomainId"))
if mibBuilder.loadTexts: t11FamDatabaseEntry.setDescription("An entry (conceptual row) in the t11FamDatabaseTable\ncontaining information about one Domain_ID in the\nFabric identified by t11FamFabricIndex, and known by\nthe switch identified by t11FamFabricIndex and\nt11FamDatabaseDomainId.")
t11FamDatabaseDomainId = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 2, 1, 1), FcDomainIdOrZero().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 239))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11FamDatabaseDomainId.setDescription("The Domain_ID for which this row contains information.\nThe value must be non-zero.")
t11FamDatabaseSwitchWwn = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 2, 1, 2), FcNameIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamDatabaseSwitchWwn.setDescription("The node name (WWN) of the switch to which the\ncorresponding value of t11FamDatabaseDomainId is currently\nassigned for the particular Fabric.")
t11FamMaxFcIdCacheSize = MibScalar((1, 3, 6, 1, 2, 1, 137, 1, 2, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamMaxFcIdCacheSize.setDescription("The maximum number of Fibre Channel Address Identifiers\nthat are able to be cached in the t11FamFcIdCacheTable.\nIf the number is unknown, the value of this object is\nzero.")
t11FamFcIdCacheTable = MibTable((1, 3, 6, 1, 2, 1, 137, 1, 2, 4))
if mibBuilder.loadTexts: t11FamFcIdCacheTable.setDescription("This table contains all the Fibre Channel Address\nIdentifiers that have recently been released by the\nFabric Address Manager in a switch.  So, it lists\nall the Fibre Channel Address Identifiers that have valid\nWWN-to-Fibre Channel Address Identifier mappings and are\ncurrently not assigned to any ports.  These Fibre Channel\nAddress Identifiers were assigned to ports but have since\nbeen released.  These cached Fibre Channel Address\nIdentifiers contain only Area_ID and Port_ID information.\nThis cache is kept to provide best-effort re-assignment of\nsame Fibre Channel Address Identifiers; i.e., when an\nNx_Port asks for a Fibre Channel Address Identifier, soon\nafter releasing one, the same value is re-assigned, if\npossible.")
t11FamFcIdCacheEntry = MibTableRow((1, 3, 6, 1, 2, 1, 137, 1, 2, 4, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricIndex"), (0, "T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFcIdCacheWwn"))
if mibBuilder.loadTexts: t11FamFcIdCacheEntry.setDescription("An entry (conceptual row) in the t11FamFcIdCacheTable\ncontaining information about one Fibre Channel Address\nIdentifier that was released from a WWN, corresponding to a\nrange of one or more ports connected to the switch\n(identified by t11FamFabricIndex and t11FamFcIdCacheWwn) in\nthe Fabric (identified by t11FamFabricIndex).  An entry is\ncreated when a Fibre Channel Address Identifier is released\nby the last port in the range.  The oldest entry is deleted\nif the number of rows in this table reaches\nt11FamMaxFcIdCacheSize, and its space is required for a new\nentry.  An entry is also deleted when its Fibre Channel\nAddress Identifier is assigned to a port.")
t11FamFcIdCacheWwn = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 4, 1, 1), FcNameIdOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11FamFcIdCacheWwn.setDescription("The N_Port_Name (WWN) of the port associated with this\nentry.")
t11FamFcIdCacheAreaIdPortId = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 4, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamFcIdCacheAreaIdPortId.setDescription("The combination of this object and t11FamFcIdCachePortIds\nrepresent one range of Fibre Channel Address Identifiers,\nwhich were assigned and later released.  This object\ncontains the Area_ID and Port_ID of the first Fibre\nChannel Address Identifier in the range.\n\nNote that this object is only 2 bytes.")
t11FamFcIdCachePortIds = MibTableColumn((1, 3, 6, 1, 2, 1, 137, 1, 2, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FamFcIdCachePortIds.setDescription("The combination of t11FamFcIdCacheAreaIdPortId and this\nobject represent one range of Fibre Channel Address\nIdentifiers, which were assigned and later released.  This\nobject contains the number of (consecutive) Fibre Channel\nAddress Identifiers in the range.")
t11FamNotifyControl = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 1, 3))
t11FamNotifyFabricIndex = MibScalar((1, 3, 6, 1, 2, 1, 137, 1, 3, 1), T11FabricIndex()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: t11FamNotifyFabricIndex.setDescription("A unique index value that identifies a particular\nFabric for which a particular notification is generated.\n\nIn a Fabric conformant to SW-3, only a single Fabric\ncan operate within a physical infrastructure, and thus,\nthe value of this Fabric Index will always be 1.\n\nHowever, the current standard, FC-SW-4, defines\nhow multiple Fabrics, each with its own management\n\n\n\ninstrumentation, could operate within one (or more)\nphysical infrastructures.  In order to accommodate this\nscenario, this index value is used to uniquely identify a\nparticular Fabric within a physical infrastructure.")
t11FamMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 2))
t11FamMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 2, 1))
t11FamMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 137, 2, 2))

# Augmentions

# Notifications

t11FamDomainIdNotAssignedNotify = NotificationType((1, 3, 6, 1, 2, 1, 137, 0, 1)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamNotifyFabricIndex"), )
if mibBuilder.loadTexts: t11FamDomainIdNotAssignedNotify.setDescription("This notification indicates that a Domain_ID has not\nbeen configured or assigned for a particular Fabric,\nidentified by t11FamNotifyFabricIndex, on a particular\nswitch identified by t11FamLocalSwitchWwn.  This could\nhappen under the following conditions, and results in the\nswitch isolating E_Ports on the Fabric:\n\n - if the switch's request for a configured static\n   Domain_ID is rejected or no other Domain_ID is\n   assigned, then the E_Ports are isolated.")
t11FamNewPrincipalSwitchNotify = NotificationType((1, 3, 6, 1, 2, 1, 137, 0, 2)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamNotifyFabricIndex"), )
if mibBuilder.loadTexts: t11FamNewPrincipalSwitchNotify.setDescription("This notification indicates that a particular switch,\nidentified by t11FamLocalSwitchWwn, has become the new\nPrincipal Switch on the Fabric identified by\nt11FamNotifyFabricIndex.\n\nThis notification is sent soon after its election as\nthe new Principal Switch, i.e., upon expiration of a\nPrincipal Switch selection timer that is equal to\ntwice the Fabric Stability Timeout value (F_S_TOV).")
t11FamFabricChangeNotify = NotificationType((1, 3, 6, 1, 2, 1, 137, 0, 3)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamNotifyFabricIndex"), )
if mibBuilder.loadTexts: t11FamFabricChangeNotify.setDescription("This notification is sent whenever a particular switch,\nidentified by t11FamLocalSwitchWwn, sends or\nreceives a Build Fabric (BF) or a ReConfigure Fabric\n(RCF) message on the Fabric identified by\n\n\n\nt11FamNotifyFabricIndex.\n\nThis notification is not sent if a\n't11FamNewPrincipalSwitchNotify' notification is sent\nfor the same event.")

# Groups

t11FamGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 137, 2, 2, 1)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamSticky"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAutoReconfigure"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamRestart"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamConfigDomainId"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAssignedFcIds"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamPrincipalSwitchSelections"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamIfRowStatus"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamContiguousAllocation"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamConfigDomainIdType"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAvailableFcIds"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFreeFcIds"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamDomainId"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamIfRcfReject"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricName"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamBuildFabrics"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamPrincipalSwitchWwn"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricReconfigures"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamRcFabricNotifyEnable"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamEnable"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAssignedAreaIdList"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamPrincSwRunningPriority"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamIfRole"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamState"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamPriority"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamGrantedFcIds"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamRunningPriority"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamNotifyFabricIndex"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalPrincipalSwitchSlctns"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamRecoveredFcIds"), )
if mibBuilder.loadTexts: t11FamGroup.setDescription("A collection of general objects for displaying and\nconfiguring Fabric Address management.")
t11FamCommandGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 137, 2, 2, 2)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamRestart"), )
if mibBuilder.loadTexts: t11FamCommandGroup.setDescription("A collection of objects used for initiating an\noperation on the Fabric.")
t11FamDatabaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 137, 2, 2, 3)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamDatabaseSwitchWwn"), )
if mibBuilder.loadTexts: t11FamDatabaseGroup.setDescription("A collection of objects containing information about\nDomain-IDs assignments.")
t11FamAreaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 137, 2, 2, 4)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAreaAssignedPortIdList"), )
if mibBuilder.loadTexts: t11FamAreaGroup.setDescription("A collection of objects containing information about\ncurrently assigned addresses within a domain.")
t11FamCacheGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 137, 2, 2, 5)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamMaxFcIdCacheSize"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFcIdCachePortIds"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFcIdCacheAreaIdPortId"), )
if mibBuilder.loadTexts: t11FamCacheGroup.setDescription("A collection of objects containing information about\nrecently-released Fibre Channel Address Identifiers.")
t11FamNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 137, 2, 2, 6)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamFabricChangeNotify"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamNewPrincipalSwitchNotify"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamDomainIdNotAssignedNotify"), )
if mibBuilder.loadTexts: t11FamNotificationGroup.setDescription("A collection of notifications for status monitoring\nand notification.")

# Compliances

t11FamMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 137, 2, 1, 1)).setObjects(("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamCommandGroup"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamNotificationGroup"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamCacheGroup"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamAreaGroup"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamGroup"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamDatabaseGroup"), )
if mibBuilder.loadTexts: t11FamMIBCompliance.setDescription("The compliance statement for Fibre Channel switches\nthat implement Fabric Address Manager functionality.")

# Exports

# Module identity
mibBuilder.exportSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", PYSNMP_MODULE_ID=t11FcFabricAddrMgrMIB)

# Types
mibBuilder.exportSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", T11FamDomainInterfaceRole=T11FamDomainInterfaceRole, T11FamDomainPriority=T11FamDomainPriority, T11FamState=T11FamState)

# Objects
mibBuilder.exportSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", t11FcFabricAddrMgrMIB=t11FcFabricAddrMgrMIB, t11FamNotifications=t11FamNotifications, t11FamMIBObjects=t11FamMIBObjects, t11FamConfiguration=t11FamConfiguration, t11FamTable=t11FamTable, t11FamEntry=t11FamEntry, t11FamFabricIndex=t11FamFabricIndex, t11FamConfigDomainId=t11FamConfigDomainId, t11FamConfigDomainIdType=t11FamConfigDomainIdType, t11FamAutoReconfigure=t11FamAutoReconfigure, t11FamContiguousAllocation=t11FamContiguousAllocation, t11FamPriority=t11FamPriority, t11FamPrincipalSwitchWwn=t11FamPrincipalSwitchWwn, t11FamLocalSwitchWwn=t11FamLocalSwitchWwn, t11FamAssignedAreaIdList=t11FamAssignedAreaIdList, t11FamGrantedFcIds=t11FamGrantedFcIds, t11FamRecoveredFcIds=t11FamRecoveredFcIds, t11FamFreeFcIds=t11FamFreeFcIds, t11FamAssignedFcIds=t11FamAssignedFcIds, t11FamAvailableFcIds=t11FamAvailableFcIds, t11FamRunningPriority=t11FamRunningPriority, t11FamPrincSwRunningPriority=t11FamPrincSwRunningPriority, t11FamState=t11FamState, t11FamLocalPrincipalSwitchSlctns=t11FamLocalPrincipalSwitchSlctns, t11FamPrincipalSwitchSelections=t11FamPrincipalSwitchSelections, t11FamBuildFabrics=t11FamBuildFabrics, t11FamFabricReconfigures=t11FamFabricReconfigures, t11FamDomainId=t11FamDomainId, t11FamSticky=t11FamSticky, t11FamRestart=t11FamRestart, t11FamRcFabricNotifyEnable=t11FamRcFabricNotifyEnable, t11FamEnable=t11FamEnable, t11FamFabricName=t11FamFabricName, t11FamIfTable=t11FamIfTable, t11FamIfEntry=t11FamIfEntry, t11FamIfRcfReject=t11FamIfRcfReject, t11FamIfRole=t11FamIfRole, t11FamIfRowStatus=t11FamIfRowStatus, t11FamInfo=t11FamInfo, t11FamAreaTable=t11FamAreaTable, t11FamAreaEntry=t11FamAreaEntry, t11FamAreaAreaId=t11FamAreaAreaId, t11FamAreaAssignedPortIdList=t11FamAreaAssignedPortIdList, t11FamDatabaseTable=t11FamDatabaseTable, t11FamDatabaseEntry=t11FamDatabaseEntry, t11FamDatabaseDomainId=t11FamDatabaseDomainId, t11FamDatabaseSwitchWwn=t11FamDatabaseSwitchWwn, t11FamMaxFcIdCacheSize=t11FamMaxFcIdCacheSize, t11FamFcIdCacheTable=t11FamFcIdCacheTable, t11FamFcIdCacheEntry=t11FamFcIdCacheEntry, t11FamFcIdCacheWwn=t11FamFcIdCacheWwn, t11FamFcIdCacheAreaIdPortId=t11FamFcIdCacheAreaIdPortId, t11FamFcIdCachePortIds=t11FamFcIdCachePortIds, t11FamNotifyControl=t11FamNotifyControl, t11FamNotifyFabricIndex=t11FamNotifyFabricIndex, t11FamMIBConformance=t11FamMIBConformance, t11FamMIBCompliances=t11FamMIBCompliances, t11FamMIBGroups=t11FamMIBGroups)

# Notifications
mibBuilder.exportSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", t11FamDomainIdNotAssignedNotify=t11FamDomainIdNotAssignedNotify, t11FamNewPrincipalSwitchNotify=t11FamNewPrincipalSwitchNotify, t11FamFabricChangeNotify=t11FamFabricChangeNotify)

# Groups
mibBuilder.exportSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", t11FamGroup=t11FamGroup, t11FamCommandGroup=t11FamCommandGroup, t11FamDatabaseGroup=t11FamDatabaseGroup, t11FamAreaGroup=t11FamAreaGroup, t11FamCacheGroup=t11FamCacheGroup, t11FamNotificationGroup=t11FamNotificationGroup)

# Compliances
mibBuilder.exportSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", t11FamMIBCompliance=t11FamMIBCompliance)
