# PySNMP SMI module. Autogenerated from smidump -f python T11-FC-FABRIC-LOCK-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:16 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( fcmInstanceIndex, fcmSwitchIndex, ) = mibBuilder.importSymbols("FC-MGMT-MIB", "fcmInstanceIndex", "fcmSwitchIndex")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( RowStatus, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus")
( T11NsGs4RejectReasonCode, ) = mibBuilder.importSymbols("T11-FC-NAME-SERVER-MIB", "T11NsGs4RejectReasonCode")
( T11FabricIndex, ) = mibBuilder.importSymbols("T11-TC-MIB", "T11FabricIndex")

# Objects

t11FabricLockMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 159)).setRevisions(("2007-06-27 00:00",))
if mibBuilder.loadTexts: t11FabricLockMIB.setOrganization("For the initial versions, T11.\nFor later versions, the IETF's IMSS Working Group.")
if mibBuilder.loadTexts: t11FabricLockMIB.setContactInfo("      Claudio DeSanti\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA 95134 USA\nEMail: cds@cisco.com\n\nKeith McCloghrie\n\n\n\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA 95134 USA\nEMail: kzm@cisco.com")
if mibBuilder.loadTexts: t11FabricLockMIB.setDescription("The MIB module for the management of locks on a Fibre\nChannel Fabric.  A Fibre Channel Fabric lock is used to\nensure serialized access to some types of management data\nrelated to a Fabric, e.g., the Fabric's Zoning Database.\n\nSome (managing) applications generate Fabric locks by\ninitiating server sessions.  Server sessions are\ndefined generically in FC-GS-5 to represent a collection of\none or more requests to the session's server, e.g., to the\nZone Server.  Such a session is started by a Server Session\nBegin (SSB) request, and terminated by a Server Session End\n(SSE) request.  The switch receiving the SSB is called the\n'managing' switch.  Some applications require the\n'managing' switch to lock the Fabric for the particular\napplication, e.g., for Enhanced Zoning, before it can\nrespond successfully to the SSB.  On receipt of the\nsubsequent SSE, the lock is released.  For this usage, the\nmanaging switch sends an Acquire Change Authorization (ACA)\nrequest to other switches to lock the Fabric.\n\nFor some other applications, a managing switch locks the\nFabric using an Enhanced Acquire Change Authorization (EACA)\nrequest, which identifies the application on whose behalf\nthe Fabric is being locked with an Application_ID.\n\nFabric locks can also be requested more directly, e.g.,\nthrough the use of this MIB.  In these situations, the term\n'managing' switch is used to indicate the switch that\nreceives such a request and executes it by issuing either\nACA or EACA requests to other switches in the Fabric.\n\nThis MIB module defines information about the 'managing'\nswitch for currently-active Fabric locks.\n\nCopyright (C) The IETF Trust (2007).  This version\nof this MIB module is part of RFC 4936;  see the RFC\nitself for full legal notices.")
t11FLockMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 159, 0))
t11FLockMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 159, 1))
t11FLockConfiguration = MibIdentifier((1, 3, 6, 1, 2, 1, 159, 1, 1))
t11FLockTable = MibTable((1, 3, 6, 1, 2, 1, 159, 1, 1, 1))
if mibBuilder.loadTexts: t11FLockTable.setDescription("A table containing information about the 'managing'\nswitch of each current Fabric lock, e.g., for the\ntypes of Servers defined in FC-GS-5.\n\nEach entry in this table represents either:\n\n1) a current Fabric lock,\n2) an in-progress attempt, requested via SNMP, to set up\n   a lock, or\n3) a failed attempt, requested via SNMP, to set up a lock.\n\nIf an entry is created via t11FLockRowStatus, but the\nattempt to obtain the lock fails, then the entry continues\nto exist until it is deleted via t11FLockRowStatus, or\nit is overwritten by the lock being established via\na means other than SNMP.  However, rows created via\nt11FLockRowStatus are not retained over restarts.")
t11FLockEntry = MibTableRow((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-FABRIC-LOCK-MIB", "t11FLockFabricIndex"), (0, "T11-FC-FABRIC-LOCK-MIB", "t11FLockApplicationID"))
if mibBuilder.loadTexts: t11FLockEntry.setDescription("Each entry contains information specific to a current\nFabric lock set up by a particular 'managing' switch on a\nparticular Fabric.  The 'managing switch' is identified by\nvalues of fcmInstanceIndex and fcmSwitchIndex.\n\nServer sessions for several different types of servers\nare defined in FC-GS-5.  The behavior of a server with\n\n\n\nrespect to commands received within a server session is\nspecified for each type of server.  For some types,\nparameter changes can only be made within the context of a\nsession, and the setting up of a session requires that the\nFabric be locked.  A Fabric is locked by one switch, called\nthe 'managing' switch, sending Acquire Change Authorization\n(ACA) requests to all other switches in the Fabric.\n\nFor other applications, a Fabric lock is established by the\n'managing' switch sending Enhanced Acquire Change\nAuthorization (EACA) requests to other switches in the\nFabric.  Each EACA request includes an Application_ID\nvalue to identify the application requesting the lock.\n\nFor the benefit of this MIB module, a distinct value of\nApplication_ID has also been assigned/reserved (see\nANSI INCITS T11/06-679v0, titled 'FC-SW-5 Letter to\nT11.5') as a means of distinguishing locks established via\nAcquire Change Authorization (ACA) requests.  This\nadditional assignment allows an Application_ID to be used to\nuniquely identify any active lock amongst all those\nestablished by either an EACA or an ACA.\n\nWhenever a Fabric is locked, by the sending of either an ACA\nor an EACA, a row gets created in the representation of this\ntable for the 'managing' switch.\n\nIn order to process SNMP SetRequests that make parameter\nchanges for the relevant types of servers (e.g., to the\nZoning Database), the SNMP agent must get serialized access\nto the Fabric (for the relevant type of management data),\ni.e., the Fabric must be locked by creating an entry in\nthis table via an SNMP SetRequest.  Creating an entry in\nthis table via an SNMP SetRequest causes an ACA or an EACA\nto be sent to all other switches in the Fabric.  The value\nof t11FLockApplicationID for such an entry determines\nwhether an ACA or an EACA is sent.\n\nIf an entry in this table is created by an SNMP SetRequest,\nthe value of the t11FLockInitiatorType object in that entry\nwill normally be 'snmp'.  A row for which the value of\nt11FLockInitiatorType is not 'snmp' cannot be modified\nvia SNMP.  In particular, it cannot be deleted via\nt11FLockRowStatus.  Note that it's possible for a row to be\ncreated by an SNMP SetRequest, but for the setup of the lock\nto fail, and immediately thereafter be replaced by a lock\nsuccessfully set up by some other means; in such a case, the\nvalue of t11FLockInitiatorType would change as and when the\n\n\n\nlock was set up by the other means, and so the row could\nnot thereafter be deleted via t11FLockRowStatus.\n\nFC-GS-5 mentions various error situations in which a\nFabric lock is released so as to avoid a deadlock.  In\nsuch situations, the agent removes the corresponding row\nin this table as and when the lock is released.  This can\nhappen for all values of t11FLockInitiatorType.")
t11FLockFabricIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 1), T11FabricIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11FLockFabricIndex.setDescription("A unique index value that uniquely identifies a\nparticular Fabric.\n\nIn a Fabric conformant to FC-SW-4, multiple Virtual Fabrics\ncan operate within one (or more) physical infrastructures,\nand this index value is used to uniquely identify a\n\n\n\nparticular (physical or virtual) Fabric within a physical\ninfrastructure.\n\nIn a Fabric conformant to versions earlier than FC-SW-4,\nonly a single Fabric could operate within a physical\ninfrastructure, and thus, the value of this Fabric Index\nwas defined to always be 1.")
t11FLockApplicationID = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 2), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11FLockApplicationID.setDescription("The Application_ID value that identifies the type of\napplication for which the Fabric is locked.\n\nA lock established via Acquire Change Authorization (ACA)\ndoes not, strictly speaking, have an Application_ID value.\nHowever, the value 'FF'h (255 decimal) has been reserved\nby T11 to be used as the value of this MIB object as and\nwhen a lock is established by an ACA.  This value was\ninitially documented in a letter from the FC-SW-5 Editor\nto T11.5, which was approved by the T11 and T11.5 plenary\nmeetings on October 5, 2006.")
t11FLockInitiatorType = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("ssb", 2), ("cli", 3), ("snmp", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockInitiatorType.setDescription("This object specifies what type of initiator generated\nthe request that caused this lock to be established:\n\n    other     - none of the following.\n\n\n\n    ssb       - this lock was established due to the\n                receipt of an SSB, e.g., from a GS-5\n                client.\n    cli       - this lock was established in order\n                to process a Command Line Interface\n                (CLI) command.\n    snmp      - this lock was established as a result\n                of an SNMP SetRequest.")
t11FLockInitiator = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockInitiator.setDescription("This object specifies the initiator whose request\ncaused this lock to be established.\n\nIf the value of the corresponding instance\nof t11FLockInitiatorType is 'ssb', this\nobject will contain the FC_ID of the client\nthat issued the Server Session Begin (SSB)\nthat required the lock to be established.\n\nIf the value of the corresponding instance\nof t11FLockInitiatorType object is 'cli', this\nobject will contain the user name of the CLI\n(Command Line Interface) user on whose behalf\nthe lock was established.\n\nIf the value of the corresponding instance of\nt11FLockInitiatorType is 'snmp', this object\nwill contain the SNMP securityName used by the\nSNMPv3 message containing the SetRequest that\ncreated this row.  (If the row was created via\nSNMPv1 or SNMPv2c, then the appropriate value of\nthe snmpCommunitySecurityName is used.)")
t11FLockInitiatorIpAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 5), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockInitiatorIpAddrType.setDescription("This object specifies the type of IP address contained\nin the corresponding instance of t11FLockInitiatorIpAddr.\nIf the IP address of the location of the initiator is\nunknown or not applicable, this object has the value:\n'unknown'.")
t11FLockInitiatorIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 6), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockInitiatorIpAddr.setDescription("This object specifies the IP address of the location\nof the initiator that established this lock via a\nrequest of the type given by the corresponding instance\nof t11FLockInitiatorType.  In cases where the\ncorresponding instance of t11FLockInitiatorIpAddrType has\nthe value: 'unknown', the value of this object is the\nzero-length string.")
t11FLockStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("settingUp", 2), ("rejectFailure", 3), ("otherFailure", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockStatus.setDescription("This object gives the current status of the lock:\n\n'active'        -- the lock is currently established.\n'settingUp'     -- the 'managing' switch is currently\n                   attempting to set up the lock, e.g.,\n                   it is waiting to receive Accepts\n                   for ACAs from every switch in the\n                   Fabric.\n\n\n\n'rejectFailure' -- the 'managing' switch's attempt to\n                   set up the lock was rejected with\n                   the reason codes given by:\n                      t11FLockRejectReasonCode,\n                      t11FLockRejectReasonCodeExp and\n                      t11FLockRejectReasonVendorCode.\n'otherFailure'  -- the 'managing' switch's attempt\n                   to set up the lock failed (but no\n                   reason codes are available).\n\nFor values of t11FLockInitiatorType other than 'snmp',\na row is only required to be instantiated in this table\nwhen the value of this object is 'active'.\n\nIf the value of the corresponding instance of\nt11FLockInitiatorType is 'snmp', the initial value of this\nobject when the row is first created is 'settingUp'.  As\nand when the setup succeeds, the value transitions to\n'active'.  If the setup fails, the value transitions to\neither 'rejectFailure' or 'otherFailure'.  Note that such a\nfailure value is overwritten on the next attempt to obtain\nthe lock, which could be immediately after the failure,\ne.g., by a GS-5 client.\n\nWhen the value of this object is 'rejectFailure', the\nrejection's reason codes are given by the corresponding\nvalues of t11FLockRejectReasonCode,\nt11FLockRejectReasonCodeExp and\nt11FLockRejectReasonVendorCode.")
t11FLockRejectReasonCode = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 8), T11NsGs4RejectReasonCode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockRejectReasonCode.setDescription("When the value of the corresponding instance of\nt11FLockStatus is 'rejectFailure', this object contains\nthe rejection's reason code.")
t11FLockRejectReasonCodeExp = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 9), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockRejectReasonCodeExp.setDescription("When the value of the corresponding instance of\nt11FLockStatus is 'rejectFailure', this object contains\nthe rejection's reason code explanation.")
t11FLockRejectReasonVendorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 10), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11FLockRejectReasonVendorCode.setDescription("When the value of the corresponding instance of\nt11FLockStatus is 'rejectFailure', this object contains\nthe rejection's vendor-specific code.")
t11FLockRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 159, 1, 1, 1, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11FLockRowStatus.setDescription("The status of this conceptual row.\n\nA row in this table can be modified or deleted via\nthis object only when the row's value of\nt11FLockInitiatorType is 'snmp'.")
t11FLockMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 159, 2))
t11FLockMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 159, 2, 1))
t11FLockMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 159, 2, 2))

# Augmentions

# Groups

t11FLockActiveGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 159, 2, 2, 1)).setObjects(("T11-FC-FABRIC-LOCK-MIB", "t11FLockInitiator"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockRejectReasonCode"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockRejectReasonVendorCode"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockInitiatorIpAddrType"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockRowStatus"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockStatus"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockRejectReasonCodeExp"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockInitiatorType"), ("T11-FC-FABRIC-LOCK-MIB", "t11FLockInitiatorIpAddr"), )
if mibBuilder.loadTexts: t11FLockActiveGroup.setDescription("A collection of objects containing information\nabout current Fabric locks.")

# Compliances

t11FLockMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 159, 2, 1, 1)).setObjects(("T11-FC-FABRIC-LOCK-MIB", "t11FLockActiveGroup"), )
if mibBuilder.loadTexts: t11FLockMIBCompliance.setDescription("The compliance statement for entities that support\nFabric locks in support of GS-5 Server applications.")

# Exports

# Module identity
mibBuilder.exportSymbols("T11-FC-FABRIC-LOCK-MIB", PYSNMP_MODULE_ID=t11FabricLockMIB)

# Objects
mibBuilder.exportSymbols("T11-FC-FABRIC-LOCK-MIB", t11FabricLockMIB=t11FabricLockMIB, t11FLockMIBNotifications=t11FLockMIBNotifications, t11FLockMIBObjects=t11FLockMIBObjects, t11FLockConfiguration=t11FLockConfiguration, t11FLockTable=t11FLockTable, t11FLockEntry=t11FLockEntry, t11FLockFabricIndex=t11FLockFabricIndex, t11FLockApplicationID=t11FLockApplicationID, t11FLockInitiatorType=t11FLockInitiatorType, t11FLockInitiator=t11FLockInitiator, t11FLockInitiatorIpAddrType=t11FLockInitiatorIpAddrType, t11FLockInitiatorIpAddr=t11FLockInitiatorIpAddr, t11FLockStatus=t11FLockStatus, t11FLockRejectReasonCode=t11FLockRejectReasonCode, t11FLockRejectReasonCodeExp=t11FLockRejectReasonCodeExp, t11FLockRejectReasonVendorCode=t11FLockRejectReasonVendorCode, t11FLockRowStatus=t11FLockRowStatus, t11FLockMIBConformance=t11FLockMIBConformance, t11FLockMIBCompliances=t11FLockMIBCompliances, t11FLockMIBGroups=t11FLockMIBGroups)

# Groups
mibBuilder.exportSymbols("T11-FC-FABRIC-LOCK-MIB", t11FLockActiveGroup=t11FLockActiveGroup)

# Compliances
mibBuilder.exportSymbols("T11-FC-FABRIC-LOCK-MIB", t11FLockMIBCompliance=t11FLockMIBCompliance)
