# PySNMP SMI module. Autogenerated from smidump -f python TCP-ESTATS-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:19 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ZeroBasedCounter64, ) = mibBuilder.importSymbols("HCNUM-TC", "ZeroBasedCounter64")
( ZeroBasedCounter32, ) = mibBuilder.importSymbols("RMON2-MIB", "ZeroBasedCounter32")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "TextualConvention", "TimeStamp", "TruthValue")
( tcpConnectionEntry, tcpListenerEntry, ) = mibBuilder.importSymbols("TCP-MIB", "tcpConnectionEntry", "tcpListenerEntry")

# Types

class TcpEStatsNegotiated(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,3,2,)
    namedValues = namedval.NamedValues(("enabled", 1), ("selfDisabled", 2), ("peerDisabled", 3), )
    

# Objects

tcpEStatsMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 156)).setRevisions(("2007-05-18 00:00",))
if mibBuilder.loadTexts: tcpEStatsMIB.setOrganization("IETF TSV Working Group")
if mibBuilder.loadTexts: tcpEStatsMIB.setContactInfo("Matt Mathis\nJohn Heffner\nWeb100 Project\nPittsburgh Supercomputing Center\n300 S. Craig St.\nPittsburgh, PA 15213\nEmail: mathis@psc.edu, jheffner@psc.edu\n\nRajiv Raghunarayan\nCisco Systems Inc.\nSan Jose, CA 95134\nPhone: 408 853 9612\nEmail: raraghun@cisco.com\n\nJon Saperia\n84 Kettell Plain Road\nStow, MA 01775\nPhone: 617-201-2655\nEmail: saperia@jdscons.com ")
if mibBuilder.loadTexts: tcpEStatsMIB.setDescription("Documentation of TCP Extended Performance Instrumentation\nvariables from the Web100 project.  [Web100]\n\nAll of the objects in this MIB MUST have the same\npersistence properties as the underlying TCP implementation.\nOn a reboot, all zero-based counters MUST be cleared, all\ndynamically created table rows MUST be deleted, and all\nread-write objects MUST be restored to their default values.\n\nIt is assumed that all TCP implementation have some\ninitialization code (if nothing else to set IP addresses)\nthat has the opportunity to adjust tcpEStatsConnTableLatency\nand other read-write scalars controlling the creation of the\nvarious tables, before establishing the first TCP\nconnection.  Implementations MAY also choose to make these\ncontrol scalars persist across reboots.\n\nCopyright (C) The IETF Trust (2007).  This version\nof this MIB module is a part of RFC 4898; see the RFC\nitself for full legal notices.")
tcpEStatsNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 0))
tcpEStatsMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 1))
tcpEStats = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 1, 1))
tcpEStatsListenerTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 1))
if mibBuilder.loadTexts: tcpEStatsListenerTable.setDescription("This table contains information about TCP Listeners,\nin addition to the information maintained by the\ntcpListenerTable RFC 4022.")
tcpEStatsListenerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1))
if mibBuilder.loadTexts: tcpEStatsListenerEntry.setDescription("Each entry in the table contains information about\na specific TCP Listener.")
tcpEStatsListenerStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 1), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerStartTime.setDescription("The value of sysUpTime at the time this listener was\nestablished.  If the current state was entered prior to\nthe last re-initialization of the local network management\nsubsystem, then this object contains a zero value.")
tcpEStatsListenerSynRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerSynRcvd.setDescription("The number of SYNs which have been received for this\nlistener.  The total number of failed connections for\nall reasons can be estimated to be tcpEStatsListenerSynRcvd\nminus tcpEStatsListenerAccepted and\ntcpEStatsListenerCurBacklog.")
tcpEStatsListenerInitial = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerInitial.setDescription("The total number of connections for which the Listener\nhas allocated initial state and placed the\nconnection in the backlog.  This may happen in the\nSYN-RCVD or ESTABLISHED states, depending on the\nimplementation.")
tcpEStatsListenerEstablished = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerEstablished.setDescription("The number of connections that have been established to\nthis endpoint (e.g., the number of first ACKs that have\nbeen received for this listener).")
tcpEStatsListenerAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 5), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerAccepted.setDescription("The total number of connections for which the Listener\nhas successfully issued an accept, removing the connection\nfrom the backlog.")
tcpEStatsListenerExceedBacklog = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 6), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerExceedBacklog.setDescription("The total number of connections dropped from the\nbacklog by this listener due to all reasons.  This\nincludes all connections that are allocated initial\nresources, but are not accepted for some reason.")
tcpEStatsListenerHCSynRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 7), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerHCSynRcvd.setDescription("The number of SYNs that have been received for this\nlistener on systems that can process (or reject) more\nthan 1 million connections per second.  See\ntcpEStatsListenerSynRcvd.")
tcpEStatsListenerHCInitial = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 8), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerHCInitial.setDescription("The total number of connections for which the Listener\nhas allocated initial state and placed the connection\nin the backlog on systems that can process (or reject)\nmore than 1 million connections per second.  See\ntcpEStatsListenerInitial.")
tcpEStatsListenerHCEstablished = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 9), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerHCEstablished.setDescription("The number of connections that have been established to\nthis endpoint on systems that can process (or reject) more\nthan 1 million connections per second.  See\ntcpEStatsListenerEstablished.")
tcpEStatsListenerHCAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 10), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerHCAccepted.setDescription("The total number of connections for which the Listener\nhas successfully issued an accept, removing the connection\nfrom the backlog on systems that can process (or reject)\nmore than 1 million connections per second.  See\ntcpEStatsListenerAccepted.")
tcpEStatsListenerHCExceedBacklog = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 11), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerHCExceedBacklog.setDescription("The total number of connections dropped from the\nbacklog by this listener due to all reasons on\nsystems that can process (or reject) more than\n1 million connections per second.  See\ntcpEStatsListenerExceedBacklog.")
tcpEStatsListenerCurConns = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerCurConns.setDescription("The current number of connections in the ESTABLISHED\nstate, which have also been accepted.  It excludes\nconnections that have been established but not accepted\nbecause they are still subject to being discarded to\nshed load without explicit action by either endpoint.")
tcpEStatsListenerMaxBacklog = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerMaxBacklog.setDescription("The maximum number of connections allowed in the\nbacklog at one time.")
tcpEStatsListenerCurBacklog = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerCurBacklog.setDescription("The current number of connections that are in the backlog.\nThis gauge includes connections in ESTABLISHED or\nSYN-RECEIVED states for which the Listener has not yet\nissued an accept.\n\nIf this listener is using some technique to implicitly\nrepresent the SYN-RECEIVED states (e.g., by\ncryptographically encoding the state information in the\ninitial sequence number, ISS), it MAY elect to exclude\nconnections in the SYN-RECEIVED state from the backlog.")
tcpEStatsListenerCurEstabBacklog = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 1, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerCurEstabBacklog.setDescription("The current number of connections in the backlog that are\nin the ESTABLISHED state, but for which the Listener has\nnot yet issued an accept.")
tcpEStatsConnectIdTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 2))
if mibBuilder.loadTexts: tcpEStatsConnectIdTable.setDescription("This table maps information that uniquely identifies\neach active TCP connection to the connection ID used by\n\n\n\nother tables in this MIB Module.  It is an extension of\ntcpConnectionTable in RFC 4022.\n\nEntries are retained in this table for the number of\nseconds indicated by the tcpEStatsConnTableLatency\nobject, after the TCP connection first enters the closed\nstate.")
tcpEStatsConnectIdEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 2, 1))
if mibBuilder.loadTexts: tcpEStatsConnectIdEntry.setDescription("Each entry in this table maps a TCP connection\n4-tuple to a connection index.")
tcpEStatsConnectIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsConnectIndex.setDescription("A unique integer value assigned to each TCP Connection\nentry.\n\nThe RECOMMENDED algorithm is to begin at 1 and increase to\nsome implementation-specific maximum value and then start\nagain at 1 skipping values already in use.")
tcpEStatsPerfTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 3))
if mibBuilder.loadTexts: tcpEStatsPerfTable.setDescription("This table contains objects that are useful for\n\n\n\nmeasuring TCP performance and first line problem\ndiagnosis.  Most objects in this table directly expose\nsome TCP state variable or are easily implemented as\nsimple functions (e.g., the maximum value) of TCP\nstate variables.\n\nEntries are retained in this table for the number of\nseconds indicated by the tcpEStatsConnTableLatency\nobject, after the TCP connection first enters the closed\nstate.")
tcpEStatsPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1)).setIndexNames((0, "TCP-ESTATS-MIB", "tcpEStatsConnectIndex"))
if mibBuilder.loadTexts: tcpEStatsPerfEntry.setDescription("Each entry in this table has information about the\ncharacteristics of each active and recently closed TCP\nconnection.")
tcpEStatsPerfSegsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 1), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSegsOut.setDescription("The total number of segments sent.")
tcpEStatsPerfDataSegsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfDataSegsOut.setDescription("The number of segments sent containing a positive length\ndata segment.")
tcpEStatsPerfDataOctetsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfDataOctetsOut.setDescription("The number of octets of data contained in transmitted\nsegments, including retransmitted data.  Note that this does\nnot include TCP headers.")
tcpEStatsPerfHCDataOctetsOut = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 4), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfHCDataOctetsOut.setDescription("The number of octets of data contained in transmitted\nsegments, including retransmitted data, on systems that can\ntransmit more than 10 million bits per second.  Note that\nthis does not include TCP headers.")
tcpEStatsPerfSegsRetrans = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 5), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSegsRetrans.setDescription("The number of segments transmitted containing at least some\nretransmitted data.")
tcpEStatsPerfOctetsRetrans = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 6), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfOctetsRetrans.setDescription("The number of octets retransmitted.")
tcpEStatsPerfSegsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 7), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSegsIn.setDescription("The total number of segments received.")
tcpEStatsPerfDataSegsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 8), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfDataSegsIn.setDescription("The number of segments received containing a positive\n\n\n\nlength data segment.")
tcpEStatsPerfDataOctetsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 9), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfDataOctetsIn.setDescription("The number of octets contained in received data segments,\nincluding retransmitted data.  Note that this does not\ninclude TCP headers.")
tcpEStatsPerfHCDataOctetsIn = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 10), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfHCDataOctetsIn.setDescription("The number of octets contained in received data segments,\nincluding retransmitted data, on systems that can receive\nmore than 10 million bits per second.  Note that this does\nnot include TCP headers.")
tcpEStatsPerfElapsedSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 11), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfElapsedSecs.setDescription("The seconds part of the time elapsed between\ntcpEStatsPerfStartTimeStamp and the most recent protocol\nevent (segment sent or received).")
tcpEStatsPerfElapsedMicroSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 12), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfElapsedMicroSecs.setDescription("The micro-second part of time elapsed between\ntcpEStatsPerfStartTimeStamp to the most recent protocol\nevent (segment sent or received).  This may be updated in\nwhatever time granularity is the system supports.")
tcpEStatsPerfStartTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 13), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfStartTimeStamp.setDescription("Time at which this row was created and all\nZeroBasedCounters in the row were initialized to zero.")
tcpEStatsPerfCurMSS = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCurMSS.setDescription("The current maximum segment size (MSS), in octets.")
tcpEStatsPerfPipeSize = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfPipeSize.setDescription("The TCP senders current estimate of the number of\nunacknowledged data octets in the network.\n\nWhile not in recovery (e.g., while the receiver is not\nreporting missing data to the sender), this is precisely the\nsame as 'Flight size' as defined in RFC 2581, which can be\ncomputed as SND.NXT minus SND.UNA. [RFC793]\n\nDuring recovery, the TCP sender has incomplete information\nabout the state of the network (e.g., which segments are\nlost vs reordered, especially if the return path is also\ndropping TCP acknowledgments).  Current TCP standards do not\nmandate any specific algorithm for estimating the number of\nunacknowledged data octets in the network.\n\nRFC 3517 describes a conservative algorithm to use SACK\n\n\n\ninformation to estimate the number of unacknowledged data\noctets in the network. tcpEStatsPerfPipeSize object SHOULD\nbe the same as 'pipe' as defined in RFC 3517 if it is\nimplemented. (Note that while not in recovery the pipe\nalgorithm yields the same values as flight size).\n\nIf RFC 3517 is not implemented, the data octets in flight\nSHOULD be estimated as SND.NXT minus SND.UNA adjusted by\nsome measure of the data that has left the network and\nretransmitted data.  For example, with Reno or NewReno style\nTCP, the number of duplicate acknowledgment is used to\ncount the number of segments that have left the network.\nThat is,\nPipeSize=SND.NXT-SND.UNA+(retransmits-dupacks)*CurMSS")
tcpEStatsPerfMaxPipeSize = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 16), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfMaxPipeSize.setDescription("The maximum value of tcpEStatsPerfPipeSize, for this\nconnection.")
tcpEStatsPerfSmoothedRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 17), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSmoothedRTT.setDescription("The smoothed round trip time used in calculation of the\nRTO. See SRTT in [RFC2988].")
tcpEStatsPerfCurRTO = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 18), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCurRTO.setDescription("The current value of the retransmit timer RTO.")
tcpEStatsPerfCongSignals = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 19), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCongSignals.setDescription("The number of multiplicative downward congestion window\nadjustments due to all forms of congestion signals,\nincluding Fast Retransmit, Explicit Congestion Notification\n(ECN), and timeouts.  This object summarizes all events that\ninvoke the MD portion of Additive Increase Multiplicative\nDecrease (AIMD) congestion control, and as such is the best\nindicator of how a cwnd is being affected by congestion.\n\nNote that retransmission timeouts multiplicatively reduce\nthe window implicitly by setting ssthresh, and SHOULD be\nincluded in tcpEStatsPerfCongSignals.  In order to minimize\nspurious congestion indications due to out-of-order\nsegments, tcpEStatsPerfCongSignals SHOULD be incremented in\nassociation with the Fast Retransmit algorithm.")
tcpEStatsPerfCurCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 20), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCurCwnd.setDescription("The current congestion window, in octets.")
tcpEStatsPerfCurSsthresh = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCurSsthresh.setDescription("The current slow start threshold in octets.")
tcpEStatsPerfTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 22), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfTimeouts.setDescription("The number of times the retransmit timeout has expired when\nthe RTO backoff multiplier is equal to one.")
tcpEStatsPerfCurRwinSent = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 23), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCurRwinSent.setDescription("The most recent window advertisement sent, in octets.")
tcpEStatsPerfMaxRwinSent = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfMaxRwinSent.setDescription("The maximum window advertisement sent, in octets.")
tcpEStatsPerfZeroRwinSent = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 25), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfZeroRwinSent.setDescription("The number of acknowledgments sent announcing a zero\n\n\n\nreceive window, when the previously announced window was\nnot zero.")
tcpEStatsPerfCurRwinRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 26), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfCurRwinRcvd.setDescription("The most recent window advertisement received, in octets.")
tcpEStatsPerfMaxRwinRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 27), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfMaxRwinRcvd.setDescription("The maximum window advertisement received, in octets.")
tcpEStatsPerfZeroRwinRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 28), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfZeroRwinRcvd.setDescription("The number of acknowledgments received announcing a zero\nreceive window, when the previously announced window was\nnot zero.")
tcpEStatsPerfSndLimTransRwin = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 31), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSndLimTransRwin.setDescription("The number of transitions into the 'Receiver Limited' state\nfrom either the 'Congestion Limited' or 'Sender Limited'\nstates.  This state is entered whenever TCP transmission\nstops because the sender has filled the announced receiver\nwindow, i.e., when SND.NXT has advanced to SND.UNA +\nSND.WND - 1 as described in RFC 793.")
tcpEStatsPerfSndLimTransCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 32), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSndLimTransCwnd.setDescription("The number of transitions into the 'Congestion Limited'\nstate from either the 'Receiver Limited' or 'Sender\nLimited' states.  This state is entered whenever TCP\ntransmission stops because the sender has reached some\nlimit defined by congestion control (e.g., cwnd) or other\nalgorithms (retransmission timeouts) designed to control\nnetwork traffic.  See the definition of 'CONGESTION WINDOW'\n\n\n\nin RFC 2581.")
tcpEStatsPerfSndLimTransSnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 33), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSndLimTransSnd.setDescription("The number of transitions into the 'Sender Limited' state\nfrom either the 'Receiver Limited' or 'Congestion Limited'\nstates.  This state is entered whenever TCP transmission\nstops due to some sender limit such as running out of\napplication data or other resources and the Karn algorithm.\nWhen TCP stops sending data for any reason, which cannot be\nclassified as Receiver Limited or Congestion Limited, it\nMUST be treated as Sender Limited.")
tcpEStatsPerfSndLimTimeRwin = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 34), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSndLimTimeRwin.setDescription("The cumulative time spent in the 'Receiver Limited' state.\nSee tcpEStatsPerfSndLimTransRwin.")
tcpEStatsPerfSndLimTimeCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 35), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSndLimTimeCwnd.setDescription("The cumulative time spent in the 'Congestion Limited'\nstate.  See tcpEStatsPerfSndLimTransCwnd.  When there is a\nretransmission timeout, it SHOULD be counted in\ntcpEStatsPerfSndLimTimeCwnd (and not the cumulative time\nfor some other state.)")
tcpEStatsPerfSndLimTimeSnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 3, 1, 36), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPerfSndLimTimeSnd.setDescription("The cumulative time spent in the 'Sender Limited' state.\nSee tcpEStatsPerfSndLimTransSnd.")
tcpEStatsPathTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 4))
if mibBuilder.loadTexts: tcpEStatsPathTable.setDescription("This table contains objects that can be used to infer\ndetailed behavior of the Internet path, such as the\nextent that there is reordering, ECN bits, and if\nRTT fluctuations are correlated to losses.\n\nEntries are retained in this table for the number of\nseconds indicated by the tcpEStatsConnTableLatency\nobject, after the TCP connection first enters the closed\nstate.")
tcpEStatsPathEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1)).setIndexNames((0, "TCP-ESTATS-MIB", "tcpEStatsConnectIndex"))
if mibBuilder.loadTexts: tcpEStatsPathEntry.setDescription("Each entry in this table has information about the\ncharacteristics of each active and recently closed TCP\nconnection.")
tcpEStatsPathRetranThresh = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathRetranThresh.setDescription("The number of duplicate acknowledgments required to trigger\nFast Retransmit.  Note that although this is constant in\ntraditional Reno TCP implementations, it is adaptive in\nmany newer TCPs.")
tcpEStatsPathNonRecovDAEpisodes = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 2), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathNonRecovDAEpisodes.setDescription("The number of duplicate acknowledgment episodes that did\nnot trigger a Fast Retransmit because ACK advanced prior to\nthe number of duplicate acknowledgments reaching\nRetranThresh.\n\n\n\n\nIn many implementations this is the number of times the\n'dupacks' counter is set to zero when it is non-zero but\nless than RetranThresh.\n\nNote that the change in tcpEStatsPathNonRecovDAEpisodes\ndivided by the change in tcpEStatsPerfDataSegsOut is an\nestimate of the frequency of data reordering on the forward\npath over some interval.")
tcpEStatsPathSumOctetsReordered = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 3), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathSumOctetsReordered.setDescription("The sum of the amounts SND.UNA advances on the\nacknowledgment which ends a dup-ack episode without a\nretransmission.\n\nNote the change in tcpEStatsPathSumOctetsReordered divided\nby the change in tcpEStatsPathNonRecovDAEpisodes is an\nestimates of the average reordering distance, over some\ninterval.")
tcpEStatsPathNonRecovDA = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathNonRecovDA.setDescription("Duplicate acks (or SACKS) that did not trigger a Fast\nRetransmit because ACK advanced prior to the number of\nduplicate acknowledgments reaching RetranThresh.\n\nIn many implementations, this is the sum of the 'dupacks'\ncounter, just before it is set to zero because ACK advanced\nwithout a Fast Retransmit.\n\nNote that the change in tcpEStatsPathNonRecovDA divided by\nthe change in tcpEStatsPathNonRecovDAEpisodes is an\nestimate of the average reordering distance in segments\nover some interval.")
tcpEStatsPathSampleRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathSampleRTT.setDescription("The most recent raw round trip time measurement used in\ncalculation of the RTO.")
tcpEStatsPathRTTVar = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathRTTVar.setDescription("The round trip time variation used in calculation of the\nRTO.  See RTTVAR in [RFC2988].")
tcpEStatsPathMaxRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathMaxRTT.setDescription("The maximum sampled round trip time.")
tcpEStatsPathMinRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathMinRTT.setDescription("The minimum sampled round trip time.")
tcpEStatsPathSumRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 15), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathSumRTT.setDescription("The sum of all sampled round trip times.\n\nNote that the change in tcpEStatsPathSumRTT divided by the\nchange in tcpEStatsPathCountRTT is the mean RTT, uniformly\naveraged over an enter interval.")
tcpEStatsPathHCSumRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 16), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathHCSumRTT.setDescription("The sum of all sampled round trip times, on all systems\nthat implement multiple concurrent RTT measurements.\n\nNote that the change in tcpEStatsPathHCSumRTT divided by\nthe change in tcpEStatsPathCountRTT is the mean RTT,\nuniformly averaged over an enter interval.")
tcpEStatsPathCountRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 17), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathCountRTT.setDescription("The number of round trip time samples included in\ntcpEStatsPathSumRTT and tcpEStatsPathHCSumRTT.")
tcpEStatsPathMaxRTO = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 18), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathMaxRTO.setDescription("The maximum value of the retransmit timer RTO.")
tcpEStatsPathMinRTO = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 19), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathMinRTO.setDescription("The minimum value of the retransmit timer RTO.")
tcpEStatsPathIpTtl = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 20), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathIpTtl.setDescription("The value of the TTL field carried in the most recently\nreceived IP header.  This is sometimes useful to detect\nchanging or unstable routes.")
tcpEStatsPathIpTosIn = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 21), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathIpTosIn.setDescription("The value of the IPv4 Type of Service octet, or the IPv6\ntraffic class octet, carried in the most recently received\nIP header.\n\nThis is useful to diagnose interactions between TCP and any\nIP layer packet scheduling and delivery policy, which might\nbe in effect to implement Diffserv.")
tcpEStatsPathIpTosOut = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 22), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathIpTosOut.setDescription("The value of the IPv4 Type Of Service octet, or the IPv6\ntraffic class octet, carried in the most recently\ntransmitted IP header.\n\nThis is useful to diagnose interactions between TCP and any\nIP layer packet scheduling and delivery policy, which might\nbe in effect to implement Diffserv.")
tcpEStatsPathPreCongSumCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 23), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathPreCongSumCwnd.setDescription("The sum of the values of the congestion window, in octets,\ncaptured each time a congestion signal is received.  This\nMUST be updated each time tcpEStatsPerfCongSignals is\nincremented, such that the change in\ntcpEStatsPathPreCongSumCwnd divided by the change in\ntcpEStatsPerfCongSignals is the average window (over some\ninterval) just prior to a congestion signal.")
tcpEStatsPathPreCongSumRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 24), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathPreCongSumRTT.setDescription("Sum of the last sample of the RTT (tcpEStatsPathSampleRTT)\nprior to the received congestion signals.  This MUST be\nupdated each time tcpEStatsPerfCongSignals is incremented,\nsuch that the change in tcpEStatsPathPreCongSumRTT divided by\nthe change in tcpEStatsPerfCongSignals is the average RTT\n(over some interval) just prior to a congestion signal.")
tcpEStatsPathPostCongSumRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 25), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathPostCongSumRTT.setDescription("Sum of the first sample of the RTT (tcpEStatsPathSampleRTT)\nfollowing each congestion signal.  Such that the change in\ntcpEStatsPathPostCongSumRTT divided by the change in\ntcpEStatsPathPostCongCountRTT is the average RTT (over some\ninterval) just after a congestion signal.")
tcpEStatsPathPostCongCountRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 26), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathPostCongCountRTT.setDescription("The number of RTT samples included in\ntcpEStatsPathPostCongSumRTT such that the change in\ntcpEStatsPathPostCongSumRTT divided by the change in\ntcpEStatsPathPostCongCountRTT is the average RTT (over some\ninterval) just after a congestion signal.")
tcpEStatsPathECNsignals = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 27), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathECNsignals.setDescription("The number of congestion signals delivered to the TCP\nsender via explicit congestion notification (ECN).  This is\ntypically the number of segments bearing Echo Congestion\n\n\n\nExperienced (ECE) bits, but\nshould also include segments failing the ECN nonce check or\nother explicit congestion signals.")
tcpEStatsPathDupAckEpisodes = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 28), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathDupAckEpisodes.setDescription("The number of Duplicate Acks Sent when prior Ack was not\nduplicate.  This is the number of times that a contiguous\nseries of duplicate acknowledgments have been sent.\n\nThis is an indication of the number of data segments lost\nor reordered on the path from the remote TCP endpoint to\nthe near TCP endpoint.")
tcpEStatsPathRcvRTT = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 29), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathRcvRTT.setDescription("The receiver's estimate of the Path RTT.\n\nAdaptive receiver window algorithms depend on the receiver\nto having a good estimate of the path RTT.")
tcpEStatsPathDupAcksOut = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 30), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathDupAcksOut.setDescription("The number of duplicate ACKs sent.  The ratio of the change\nin tcpEStatsPathDupAcksOut to the change in\ntcpEStatsPathDupAckEpisodes is an indication of reorder or\nrecovery distance over some interval.")
tcpEStatsPathCERcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 31), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathCERcvd.setDescription("The number of segments received with IP headers bearing\nCongestion Experienced (CE) markings.")
tcpEStatsPathECESent = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 4, 1, 32), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsPathECESent.setDescription("Number of times the Echo Congestion Experienced (ECE) bit\nin the TCP header has been set (transitioned from 0 to 1),\ndue to a Congestion Experienced (CE) marking on an IP\nheader.  Note that ECE can be set and reset only once per\nRTT, while CE can be set on many segments per RTT.")
tcpEStatsStackTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 5))
if mibBuilder.loadTexts: tcpEStatsStackTable.setDescription("This table contains objects that are most useful for\ndetermining how well some of the TCP control\nalgorithms are coping with this particular\n\n\n\npath.\n\nEntries are retained in this table for the number of\nseconds indicated by the tcpEStatsConnTableLatency\nobject, after the TCP connection first enters the closed\nstate.")
tcpEStatsStackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1)).setIndexNames((0, "TCP-ESTATS-MIB", "tcpEStatsConnectIndex"))
if mibBuilder.loadTexts: tcpEStatsStackEntry.setDescription("Each entry in this table has information about the\ncharacteristics of each active and recently closed TCP\nconnection.")
tcpEStatsStackActiveOpen = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackActiveOpen.setDescription("True(1) if the local connection traversed the SYN-SENT\nstate, else false(2).")
tcpEStatsStackMSSSent = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMSSSent.setDescription("The value sent in an MSS option, or zero if none.")
tcpEStatsStackMSSRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMSSRcvd.setDescription("The value received in an MSS option, or zero if none.")
tcpEStatsStackWinScaleSent = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 14))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackWinScaleSent.setDescription("The value of the transmitted window scale option if one was\nsent; otherwise, a value of -1.\n\nNote that if both tcpEStatsStackWinScaleSent and\ntcpEStatsStackWinScaleRcvd are not -1, then Rcv.Wind.Scale\nwill be the same as this value and used to scale receiver\nwindow announcements from the local host to the remote\nhost.")
tcpEStatsStackWinScaleRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 14))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackWinScaleRcvd.setDescription("The value of the received window scale option if one was\nreceived; otherwise, a value of -1.\n\nNote that if both tcpEStatsStackWinScaleSent and\ntcpEStatsStackWinScaleRcvd are not -1, then Snd.Wind.Scale\nwill be the same as this value and used to scale receiver\nwindow announcements from the remote host to the local\nhost.")
tcpEStatsStackTimeStamps = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 6), TcpEStatsNegotiated()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackTimeStamps.setDescription("Enabled(1) if TCP timestamps have been negotiated on,\nselfDisabled(2) if they are disabled or not implemented on\nthe local host, or peerDisabled(3) if not negotiated by the\nremote hosts.")
tcpEStatsStackECN = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 7), TcpEStatsNegotiated()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackECN.setDescription("Enabled(1) if Explicit Congestion Notification (ECN) has\nbeen negotiated on, selfDisabled(2) if it is disabled or\nnot implemented on the local host, or peerDisabled(3) if\nnot negotiated by the remote hosts.")
tcpEStatsStackWillSendSACK = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 8), TcpEStatsNegotiated()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackWillSendSACK.setDescription("Enabled(1) if the local host will send SACK options,\nselfDisabled(2) if SACK is disabled or not implemented on\nthe local host, or peerDisabled(3) if the remote host did\nnot send the SACK-permitted option.\n\nNote that SACK negotiation is not symmetrical.  SACK can\nenabled on one side of the connection and not the other.")
tcpEStatsStackWillUseSACK = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 9), TcpEStatsNegotiated()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackWillUseSACK.setDescription("Enabled(1) if the local host will process SACK options,\nselfDisabled(2) if SACK is disabled or not implemented on\nthe local host, or peerDisabled(3) if the remote host sends\n\n\n\nduplicate ACKs without SACK options, or the local host\notherwise decides not to process received SACK options.\n\nUnlike other TCP options, the remote data receiver cannot\nexplicitly indicate if it is able to generate SACK options.\nWhen sending data, the local host has to deduce if the\nremote receiver is sending SACK options.  This object can\ntransition from Enabled(1) to peerDisabled(3) after the SYN\nexchange.\n\nNote that SACK negotiation is not symmetrical.  SACK can\nenabled on one side of the connection and not the other.")
tcpEStatsStackState = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(8,9,11,2,10,7,6,4,5,1,3,12,)).subtype(namedValues=namedval.NamedValues(("tcpESStateClosed", 1), ("tcpESStateClosing", 10), ("tcpESStateTimeWait", 11), ("tcpESStateDeleteTcb", 12), ("tcpESStateListen", 2), ("tcpESStateSynSent", 3), ("tcpESStateSynReceived", 4), ("tcpESStateEstablished", 5), ("tcpESStateFinWait1", 6), ("tcpESStateFinWait2", 7), ("tcpESStateCloseWait", 8), ("tcpESStateLastAck", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackState.setDescription("An integer value representing the connection state from the\nTCP State Transition Diagram.\n\nThe value listen(2) is included only for parallelism to the\nold tcpConnTable, and SHOULD NOT be used because the listen\nstate in managed by the tcpListenerTable.\n\nThe value DeleteTcb(12) is included only for parallelism to\nthe tcpConnTable mechanism for terminating connections,\n\n\n\nalthough this table does not permit writing.")
tcpEStatsStackNagle = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackNagle.setDescription("True(1) if the Nagle algorithm is being used, else\nfalse(2).")
tcpEStatsStackMaxSsCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMaxSsCwnd.setDescription("The maximum congestion window used during Slow Start, in\noctets.")
tcpEStatsStackMaxCaCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMaxCaCwnd.setDescription("The maximum congestion window used during Congestion\nAvoidance, in octets.")
tcpEStatsStackMaxSsthresh = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMaxSsthresh.setDescription("The maximum slow start threshold, excluding the initial\nvalue.")
tcpEStatsStackMinSsthresh = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMinSsthresh.setDescription("The minimum slow start threshold.")
tcpEStatsStackInRecovery = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("tcpESDataContiguous", 1), ("tcpESDataUnordered", 2), ("tcpESDataRecovery", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackInRecovery.setDescription("An integer value representing the state of the loss\nrecovery for this connection.\n\ntcpESDataContiguous(1) indicates that the remote receiver\nis reporting contiguous data (no duplicate acknowledgments\nor SACK options) and that there are no unacknowledged\nretransmissions.\n\ntcpESDataUnordered(2) indicates that the remote receiver is\nreporting missing or out-of-order data (e.g., sending\nduplicate acknowledgments or SACK options) and that there\nare no unacknowledged retransmissions (because the missing\ndata has not yet been retransmitted).\n\ntcpESDataRecovery(3) indicates that the sender has\noutstanding retransmitted data that is still\n\n\n\nunacknowledged.")
tcpEStatsStackDupAcksIn = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 17), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackDupAcksIn.setDescription("The number of duplicate ACKs received.")
tcpEStatsStackSpuriousFrDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 18), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSpuriousFrDetected.setDescription("The number of acknowledgments reporting out-of-order\nsegments after the Fast Retransmit algorithm has already\nretransmitted the segments. (For example as detected by the\nEifel algorithm).'")
tcpEStatsStackSpuriousRtoDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 19), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSpuriousRtoDetected.setDescription("The number of acknowledgments reporting segments that have\nalready been retransmitted due to a Retransmission Timeout.")
tcpEStatsStackSoftErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 21), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSoftErrors.setDescription("The number of segments that fail various consistency tests\nduring TCP input processing.  Soft errors might cause the\nsegment to be discarded but some do not.  Some of these soft\nerrors cause the generation of a TCP acknowledgment, while\nothers are silently discarded.")
tcpEStatsStackSoftErrorReason = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 22), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,7,4,5,2,6,8,)).subtype(namedValues=namedval.NamedValues(("belowDataWindow", 1), ("aboveDataWindow", 2), ("belowAckWindow", 3), ("aboveAckWindow", 4), ("belowTSWindow", 5), ("aboveTSWindow", 6), ("dataCheckSum", 7), ("otherSoftError", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSoftErrorReason.setDescription("This object identifies which consistency test most recently\nfailed during TCP input processing.  This object SHOULD be\nset every time tcpEStatsStackSoftErrors is incremented.  The\ncodes are as follows:\n\nbelowDataWindow(1) - All data in the segment is below\nSND.UNA. (Normal for keep-alives and zero window probes).\n\naboveDataWindow(2) - Some data in the segment is above\nSND.WND. (Indicates an implementation bug or possible\nattack).\n\nbelowAckWindow(3) - ACK below SND.UNA. (Indicates that the\nreturn path is reordering ACKs)\n\naboveAckWindow(4) - An ACK for data that we have not sent.\n(Indicates an implementation bug or possible attack).\n\nbelowTSWindow(5) - TSecr on the segment is older than the\ncurrent TS.Recent (Normal for the rare case where PAWS\ndetects data reordered by the network).\n\naboveTSWindow(6) - TSecr on the segment is newer than the\ncurrent TS.Recent. (Indicates an implementation bug or\npossible attack).\n\n\n\n\ndataCheckSum(7) - Incorrect checksum.  Note that this value\nis intrinsically fragile, because the header fields used to\nidentify the connection may have been corrupted.\n\notherSoftError(8) - All other soft errors not listed\nabove.")
tcpEStatsStackSlowStart = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 23), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSlowStart.setDescription("The number of times the congestion window has been\nincreased by the Slow Start algorithm.")
tcpEStatsStackCongAvoid = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 24), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackCongAvoid.setDescription("The number of times the congestion window has been\nincreased by the Congestion Avoidance algorithm.")
tcpEStatsStackOtherReductions = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 25), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackOtherReductions.setDescription("The number of congestion window reductions made as a result\nof anything other than AIMD congestion control algorithms.\nExamples of non-multiplicative window reductions include\nCongestion Window Validation [RFC2861] and experimental\nalgorithms such as Vegas [Bra94].\n\n\n\n\nAll window reductions MUST be counted as either\ntcpEStatsPerfCongSignals or tcpEStatsStackOtherReductions.")
tcpEStatsStackCongOverCount = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 26), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackCongOverCount.setDescription("The number of congestion events that were 'backed out' of\nthe congestion control state machine such that the\ncongestion window was restored to a prior value.  This can\nhappen due to the Eifel algorithm [RFC3522] or other\nalgorithms that can be used to detect and cancel spurious\ninvocations of the Fast Retransmit Algorithm.\n\nAlthough it may be feasible to undo the effects of spurious\ninvocation of the Fast Retransmit congestion events cannot\neasily be backed out of tcpEStatsPerfCongSignals and\ntcpEStatsPathPreCongSumCwnd, etc.")
tcpEStatsStackFastRetran = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 27), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackFastRetran.setDescription("The number of invocations of the Fast Retransmit algorithm.")
tcpEStatsStackSubsequentTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 28), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSubsequentTimeouts.setDescription("The number of times the retransmit timeout has expired after\nthe RTO has been doubled.  See Section 5.5 of RFC 2988.")
tcpEStatsStackCurTimeoutCount = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 29), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackCurTimeoutCount.setDescription("The current number of times the retransmit timeout has\nexpired without receiving an acknowledgment for new data.\ntcpEStatsStackCurTimeoutCount is reset to zero when new\ndata is acknowledged and incremented for each invocation of\nSection 5.5 of RFC 2988.")
tcpEStatsStackAbruptTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 30), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackAbruptTimeouts.setDescription("The number of timeouts that occurred without any\nimmediately preceding duplicate acknowledgments or other\nindications of congestion.  Abrupt Timeouts indicate that\nthe path lost an entire window of data or acknowledgments.\n\nTimeouts that are preceded by duplicate acknowledgments or\nother congestion signals (e.g., ECN) are not counted as\nabrupt, and might have been avoided by a more sophisticated\nFast Retransmit algorithm.")
tcpEStatsStackSACKsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 31), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSACKsRcvd.setDescription("The number of SACK options received.")
tcpEStatsStackSACKBlocksRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 32), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSACKBlocksRcvd.setDescription("The number of SACK blocks received (within SACK options).")
tcpEStatsStackSendStall = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 33), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSendStall.setDescription("The number of interface stalls or other sender local\nresource limitations that are treated as congestion\nsignals.")
tcpEStatsStackDSACKDups = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 34), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackDSACKDups.setDescription("The number of duplicate segments reported to the local host\nby D-SACK blocks.")
tcpEStatsStackMaxMSS = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 35), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMaxMSS.setDescription("The maximum MSS, in octets.")
tcpEStatsStackMinMSS = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 36), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMinMSS.setDescription("The minimum MSS, in octets.")
tcpEStatsStackSndInitial = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 37), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackSndInitial.setDescription("Initial send sequence number.  Note that by definition\ntcpEStatsStackSndInitial never changes for a given\nconnection.")
tcpEStatsStackRecInitial = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 38), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackRecInitial.setDescription("Initial receive sequence number.  Note that by definition\ntcpEStatsStackRecInitial never changes for a given\nconnection.")
tcpEStatsStackCurRetxQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 39), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackCurRetxQueue.setDescription("The current number of octets of data occupying the\nretransmit queue.")
tcpEStatsStackMaxRetxQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 40), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMaxRetxQueue.setDescription("The maximum number of octets of data occupying the\nretransmit queue.")
tcpEStatsStackCurReasmQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 41), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackCurReasmQueue.setDescription("The current number of octets of sequence space spanned by\nthe reassembly queue.  This is generally the difference\nbetween rcv.nxt and the sequence number of the right most\nedge of the reassembly queue.")
tcpEStatsStackMaxReasmQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 5, 1, 42), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsStackMaxReasmQueue.setDescription("The maximum value of tcpEStatsStackCurReasmQueue")
tcpEStatsAppTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 6))
if mibBuilder.loadTexts: tcpEStatsAppTable.setDescription("This table contains objects that are useful for\ndetermining if the application using TCP is\n\n\n\nlimiting TCP performance.\n\nEntries are retained in this table for the number of\nseconds indicated by the tcpEStatsConnTableLatency\nobject, after the TCP connection first enters the closed\nstate.")
tcpEStatsAppEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1)).setIndexNames((0, "TCP-ESTATS-MIB", "tcpEStatsConnectIndex"))
if mibBuilder.loadTexts: tcpEStatsAppEntry.setDescription("Each entry in this table has information about the\ncharacteristics of each active and recently closed TCP\nconnection.")
tcpEStatsAppSndUna = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppSndUna.setDescription("The value of SND.UNA, the oldest unacknowledged sequence\nnumber.\n\nNote that SND.UNA is a TCP state variable that is congruent\nto Counter32 semantics.")
tcpEStatsAppSndNxt = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppSndNxt.setDescription("The value of SND.NXT, the next sequence number to be sent.\nNote that tcpEStatsAppSndNxt is not monotonic (and thus not\na counter) because TCP sometimes retransmits lost data by\npulling tcpEStatsAppSndNxt back to the missing data.")
tcpEStatsAppSndMax = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppSndMax.setDescription("The farthest forward (right most or largest) SND.NXT value.\nNote that this will be equal to tcpEStatsAppSndNxt except\nwhen tcpEStatsAppSndNxt is pulled back during recovery.")
tcpEStatsAppThruOctetsAcked = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 4), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppThruOctetsAcked.setDescription("The number of octets for which cumulative acknowledgments\nhave been received.  Note that this will be the sum of\nchanges to tcpEStatsAppSndUna.")
tcpEStatsAppHCThruOctetsAcked = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 5), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppHCThruOctetsAcked.setDescription("The number of octets for which cumulative acknowledgments\nhave been received, on systems that can receive more than\n10 million bits per second.  Note that this will be the sum\nof changes in tcpEStatsAppSndUna.")
tcpEStatsAppRcvNxt = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppRcvNxt.setDescription("The value of RCV.NXT.  The next sequence number expected on\nan incoming segment, and the left or lower edge of the\nreceive window.\n\nNote that RCV.NXT is a TCP state variable that is congruent\nto Counter32 semantics.")
tcpEStatsAppThruOctetsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 7), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppThruOctetsReceived.setDescription("The number of octets for which cumulative acknowledgments\nhave been sent.  Note that this will be the sum of changes\nto tcpEStatsAppRcvNxt.")
tcpEStatsAppHCThruOctetsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 8), ZeroBasedCounter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppHCThruOctetsReceived.setDescription("The number of octets for which cumulative acknowledgments\nhave been sent, on systems that can transmit more than 10\nmillion bits per second.  Note that this will be the sum of\nchanges in tcpEStatsAppRcvNxt.")
tcpEStatsAppCurAppWQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppCurAppWQueue.setDescription("The current number of octets of application data buffered\nby TCP, pending first transmission, i.e., to the left of\nSND.NXT or SndMax.  This data will generally be transmitted\n(and SND.NXT advanced to the left) as soon as there is an\navailable congestion window (cwnd) or receiver window\n(rwin).  This is the amount of data readily available for\ntransmission, without scheduling the application.  TCP\nperformance may suffer if there is insufficient queued\nwrite data.")
tcpEStatsAppMaxAppWQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppMaxAppWQueue.setDescription("The maximum number of octets of application data buffered\nby TCP, pending first transmission.  This is the maximum\nvalue of tcpEStatsAppCurAppWQueue.  This pair of objects can\nbe used to determine if insufficient queued data is steady\nstate (suggesting insufficient queue space) or transient\n(suggesting insufficient application performance or\nexcessive CPU load or scheduler latency).")
tcpEStatsAppCurAppRQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppCurAppRQueue.setDescription("The current number of octets of application data that has\nbeen acknowledged by TCP but not yet delivered to the\napplication.")
tcpEStatsAppMaxAppRQueue = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 6, 1, 14), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsAppMaxAppRQueue.setDescription("The maximum number of octets of application data that has\nbeen acknowledged by TCP but not yet delivered to the\napplication.")
tcpEStatsTuneTable = MibTable((1, 3, 6, 1, 2, 1, 156, 1, 1, 7))
if mibBuilder.loadTexts: tcpEStatsTuneTable.setDescription("This table contains per-connection controls that can\nbe used to work around a number of common problems that\nplague TCP over some paths.  All can be characterized as\nlimiting the growth of the congestion window so as to\nprevent TCP from overwhelming some component in the\npath.\n\nEntries are retained in this table for the number of\nseconds indicated by the tcpEStatsConnTableLatency\nobject, after the TCP connection first enters the closed\nstate.")
tcpEStatsTuneEntry = MibTableRow((1, 3, 6, 1, 2, 1, 156, 1, 1, 7, 1)).setIndexNames((0, "TCP-ESTATS-MIB", "tcpEStatsConnectIndex"))
if mibBuilder.loadTexts: tcpEStatsTuneEntry.setDescription("Each entry in this table is a control that can be used to\nplace limits on each active TCP connection.")
tcpEStatsTuneLimCwnd = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 7, 1, 1), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsTuneLimCwnd.setDescription("A control to set the maximum congestion window that may be\nused, in octets.")
tcpEStatsTuneLimSsthresh = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 7, 1, 2), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsTuneLimSsthresh.setDescription("A control to limit the maximum queue space (in octets) that\nthis TCP connection is likely to occupy during slowstart.\n\nIt can be implemented with the algorithm described in\nRFC 3742 by setting the max_ssthresh parameter to twice\ntcpEStatsTuneLimSsthresh.\n\nThis algorithm can be used to overcome some TCP performance\nproblems over network paths that do not have sufficient\nbuffering to withstand the bursts normally present during\nslowstart.")
tcpEStatsTuneLimRwin = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 7, 1, 3), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsTuneLimRwin.setDescription("A control to set the maximum window advertisement that may\nbe sent, in octets.")
tcpEStatsTuneLimMSS = MibTableColumn((1, 3, 6, 1, 2, 1, 156, 1, 1, 7, 1, 4), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsTuneLimMSS.setDescription("A control to limit the maximum segment size in octets, that\nthis TCP connection can use.")
tcpEStatsControl = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 1, 2))
tcpEStatsControlPath = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 2, 1), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsControlPath.setDescription("Controls the activation of the TCP Path Statistics\ntable.\n\nA value 'true' indicates that the TCP Path Statistics\ntable is active, while 'false' indicates that the\ntable is inactive.")
tcpEStatsControlStack = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 2, 2), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsControlStack.setDescription("Controls the activation of the TCP Stack Statistics\ntable.\n\nA value 'true' indicates that the TCP Stack Statistics\ntable is active, while 'false' indicates that the\ntable is inactive.")
tcpEStatsControlApp = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 2, 3), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsControlApp.setDescription("Controls the activation of the TCP Application\nStatistics table.\n\nA value 'true' indicates that the TCP Application\nStatistics table is active, while 'false' indicates\nthat the table is inactive.")
tcpEStatsControlTune = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 2, 4), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsControlTune.setDescription("Controls the activation of the TCP Tuning table.\n\nA value 'true' indicates that the TCP Tuning\ntable is active, while 'false' indicates that the\ntable is inactive.")
tcpEStatsControlNotify = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 2, 5), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tcpEStatsControlNotify.setDescription("Controls the generation of all notifications defined in\nthis MIB.\n\nA value 'true' indicates that the notifications\nare active, while 'false' indicates that the\nnotifications are inactive.")
tcpEStatsConnTableLatency = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 2, 6), Unsigned32().clone(0)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: tcpEStatsConnTableLatency.setDescription("Specifies the number of seconds that the entity will\nretain entries in the TCP connection tables, after the\nconnection first enters the closed state.  The entity\nSHOULD provide a configuration option to enable\n\n\n\ncustomization of this value.  A value of 0\nresults in entries being removed from the tables as soon as\nthe connection enters the closed state.  The value of\nthis object pertains to the following tables:\n  tcpEStatsConnectIdTable\n  tcpEStatsPerfTable\n  tcpEStatsPathTable\n  tcpEStatsStackTable\n  tcpEStatsAppTable\n  tcpEStatsTuneTable")
tcpEStatsScalar = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 1, 3))
tcpEStatsListenerTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 156, 1, 3, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tcpEStatsListenerTableLastChange.setDescription("The value of sysUpTime at the time of the last\ncreation or deletion of an entry in the tcpListenerTable.\nIf the number of entries has been unchanged since the\nlast re-initialization of the local network management\nsubsystem, then this object contains a zero value.")
tcpEStatsConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 2))
tcpEStatsCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 2, 1))
tcpEStatsGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 156, 2, 2))

# Augmentions
tcpConnectionEntry, = mibBuilder.importSymbols("TCP-MIB", "tcpConnectionEntry")
tcpConnectionEntry.registerAugmentions(("TCP-ESTATS-MIB", "tcpEStatsConnectIdEntry"))
tcpEStatsConnectIdEntry.setIndexNames(*tcpConnectionEntry.getIndexNames())
tcpListenerEntry, = mibBuilder.importSymbols("TCP-MIB", "tcpListenerEntry")
tcpListenerEntry.registerAugmentions(("TCP-ESTATS-MIB", "tcpEStatsListenerEntry"))
tcpEStatsListenerEntry.setIndexNames(*tcpListenerEntry.getIndexNames())

# Notifications

tcpEStatsEstablishNotification = NotificationType((1, 3, 6, 1, 2, 1, 156, 0, 1)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsConnectIndex"), )
if mibBuilder.loadTexts: tcpEStatsEstablishNotification.setDescription("The indicated connection has been accepted\n(or alternatively entered the established state).")
tcpEStatsCloseNotification = NotificationType((1, 3, 6, 1, 2, 1, 156, 0, 2)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsConnectIndex"), )
if mibBuilder.loadTexts: tcpEStatsCloseNotification.setDescription("The indicated connection has left the\nestablished state")

# Groups

tcpEStatsListenerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 1)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsListenerEstablished"), ("TCP-ESTATS-MIB", "tcpEStatsListenerStartTime"), ("TCP-ESTATS-MIB", "tcpEStatsListenerCurBacklog"), ("TCP-ESTATS-MIB", "tcpEStatsListenerAccepted"), ("TCP-ESTATS-MIB", "tcpEStatsListenerCurEstabBacklog"), ("TCP-ESTATS-MIB", "tcpEStatsListenerCurConns"), ("TCP-ESTATS-MIB", "tcpEStatsListenerSynRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsListenerTableLastChange"), ("TCP-ESTATS-MIB", "tcpEStatsListenerExceedBacklog"), ("TCP-ESTATS-MIB", "tcpEStatsListenerInitial"), ("TCP-ESTATS-MIB", "tcpEStatsListenerMaxBacklog"), )
if mibBuilder.loadTexts: tcpEStatsListenerGroup.setDescription("The tcpEStatsListener group includes objects that\nprovide valuable statistics and debugging\ninformation for TCP Listeners.")
tcpEStatsListenerHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 2)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsListenerHCAccepted"), ("TCP-ESTATS-MIB", "tcpEStatsListenerHCSynRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsListenerHCEstablished"), ("TCP-ESTATS-MIB", "tcpEStatsListenerHCExceedBacklog"), ("TCP-ESTATS-MIB", "tcpEStatsListenerHCInitial"), )
if mibBuilder.loadTexts: tcpEStatsListenerHCGroup.setDescription("The tcpEStatsListenerHC group includes 64-bit\ncounters in tcpEStatsListenerTable.")
tcpEStatsConnectIdGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 3)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsConnectIndex"), ("TCP-ESTATS-MIB", "tcpEStatsConnTableLatency"), )
if mibBuilder.loadTexts: tcpEStatsConnectIdGroup.setDescription("The tcpEStatsConnectId group includes objects that\nidentify TCP connections and control how long TCP\nconnection entries are retained in the tables.")
tcpEStatsPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 4)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsPerfTimeouts"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSegsOut"), ("TCP-ESTATS-MIB", "tcpEStatsPerfOctetsRetrans"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCurRwinSent"), ("TCP-ESTATS-MIB", "tcpEStatsPerfMaxRwinSent"), ("TCP-ESTATS-MIB", "tcpEStatsPerfPipeSize"), ("TCP-ESTATS-MIB", "tcpEStatsPerfElapsedMicroSecs"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSegsRetrans"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSmoothedRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPerfElapsedSecs"), ("TCP-ESTATS-MIB", "tcpEStatsPerfZeroRwinRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCurCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfMaxRwinRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCongSignals"), ("TCP-ESTATS-MIB", "tcpEStatsPerfZeroRwinSent"), ("TCP-ESTATS-MIB", "tcpEStatsPerfDataOctetsOut"), ("TCP-ESTATS-MIB", "tcpEStatsPerfDataSegsOut"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCurSsthresh"), ("TCP-ESTATS-MIB", "tcpEStatsPerfStartTimeStamp"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCurRwinRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCurMSS"), ("TCP-ESTATS-MIB", "tcpEStatsPerfCurRTO"), ("TCP-ESTATS-MIB", "tcpEStatsPerfDataOctetsIn"), ("TCP-ESTATS-MIB", "tcpEStatsPerfMaxPipeSize"), ("TCP-ESTATS-MIB", "tcpEStatsPerfDataSegsIn"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSegsIn"), )
if mibBuilder.loadTexts: tcpEStatsPerfGroup.setDescription("The tcpEStatsPerf group includes those objects that\nprovide basic performance data for a TCP connection.")
tcpEStatsPerfOptionalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 5)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsPerfSndLimTimeCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSndLimTransCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSndLimTransRwin"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSndLimTimeRwin"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSndLimTransSnd"), ("TCP-ESTATS-MIB", "tcpEStatsPerfSndLimTimeSnd"), )
if mibBuilder.loadTexts: tcpEStatsPerfOptionalGroup.setDescription("The tcpEStatsPerf group includes those objects that\nprovide basic performance data for a TCP connection.")
tcpEStatsPerfHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 6)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsPerfHCDataOctetsOut"), ("TCP-ESTATS-MIB", "tcpEStatsPerfHCDataOctetsIn"), )
if mibBuilder.loadTexts: tcpEStatsPerfHCGroup.setDescription("The tcpEStatsPerfHC group includes 64-bit\ncounters in the tcpEStatsPerfTable.")
tcpEStatsPathGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 7)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsPathSumOctetsReordered"), ("TCP-ESTATS-MIB", "tcpEStatsPathNonRecovDA"), ("TCP-ESTATS-MIB", "tcpEStatsControlPath"), ("TCP-ESTATS-MIB", "tcpEStatsPathNonRecovDAEpisodes"), ("TCP-ESTATS-MIB", "tcpEStatsPathRetranThresh"), )
if mibBuilder.loadTexts: tcpEStatsPathGroup.setDescription("The tcpEStatsPath group includes objects that\ncontrol the creation of the tcpEStatsPathTable,\nand provide information about the path\nfor each TCP connection.")
tcpEStatsPathOptionalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 8)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsPathIpTosOut"), ("TCP-ESTATS-MIB", "tcpEStatsPathIpTtl"), ("TCP-ESTATS-MIB", "tcpEStatsPathMinRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathDupAckEpisodes"), ("TCP-ESTATS-MIB", "tcpEStatsPathCERcvd"), ("TCP-ESTATS-MIB", "tcpEStatsPathPreCongSumRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathSampleRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathCountRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathRTTVar"), ("TCP-ESTATS-MIB", "tcpEStatsPathPostCongSumRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathECESent"), ("TCP-ESTATS-MIB", "tcpEStatsPathSumRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathMaxRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathECNsignals"), ("TCP-ESTATS-MIB", "tcpEStatsPathMinRTO"), ("TCP-ESTATS-MIB", "tcpEStatsPathPreCongSumCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsPathRcvRTT"), ("TCP-ESTATS-MIB", "tcpEStatsPathIpTosIn"), ("TCP-ESTATS-MIB", "tcpEStatsPathMaxRTO"), ("TCP-ESTATS-MIB", "tcpEStatsPathDupAcksOut"), ("TCP-ESTATS-MIB", "tcpEStatsPathPostCongCountRTT"), )
if mibBuilder.loadTexts: tcpEStatsPathOptionalGroup.setDescription("The tcpEStatsPath group includes objects that\nprovide additional information about the path\nfor each TCP connection.")
tcpEStatsPathHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 9)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsPathHCSumRTT"), )
if mibBuilder.loadTexts: tcpEStatsPathHCGroup.setDescription("The tcpEStatsPathHC group includes 64-bit\ncounters in the tcpEStatsPathTable.")
tcpEStatsStackGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 10)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsStackWinScaleRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsStackMaxSsCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsStackMSSSent"), ("TCP-ESTATS-MIB", "tcpEStatsStackMaxSsthresh"), ("TCP-ESTATS-MIB", "tcpEStatsStackMaxCaCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsControlStack"), ("TCP-ESTATS-MIB", "tcpEStatsStackDupAcksIn"), ("TCP-ESTATS-MIB", "tcpEStatsStackState"), ("TCP-ESTATS-MIB", "tcpEStatsStackInRecovery"), ("TCP-ESTATS-MIB", "tcpEStatsStackECN"), ("TCP-ESTATS-MIB", "tcpEStatsStackSpuriousRtoDetected"), ("TCP-ESTATS-MIB", "tcpEStatsStackNagle"), ("TCP-ESTATS-MIB", "tcpEStatsStackWillUseSACK"), ("TCP-ESTATS-MIB", "tcpEStatsStackMSSRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsStackWillSendSACK"), ("TCP-ESTATS-MIB", "tcpEStatsStackWinScaleSent"), ("TCP-ESTATS-MIB", "tcpEStatsStackMinSsthresh"), ("TCP-ESTATS-MIB", "tcpEStatsStackSpuriousFrDetected"), ("TCP-ESTATS-MIB", "tcpEStatsStackTimeStamps"), ("TCP-ESTATS-MIB", "tcpEStatsStackActiveOpen"), )
if mibBuilder.loadTexts: tcpEStatsStackGroup.setDescription("The tcpEStatsConnState group includes objects that\ncontrol the creation of the tcpEStatsStackTable,\nand provide information about the operation of\nalgorithms used within TCP.")
tcpEStatsStackOptionalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 11)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsStackCurRetxQueue"), ("TCP-ESTATS-MIB", "tcpEStatsStackMaxRetxQueue"), ("TCP-ESTATS-MIB", "tcpEStatsStackMaxReasmQueue"), ("TCP-ESTATS-MIB", "tcpEStatsStackSendStall"), ("TCP-ESTATS-MIB", "tcpEStatsStackDSACKDups"), ("TCP-ESTATS-MIB", "tcpEStatsStackSACKBlocksRcvd"), ("TCP-ESTATS-MIB", "tcpEStatsStackSlowStart"), ("TCP-ESTATS-MIB", "tcpEStatsStackOtherReductions"), ("TCP-ESTATS-MIB", "tcpEStatsStackMaxMSS"), ("TCP-ESTATS-MIB", "tcpEStatsStackMinMSS"), ("TCP-ESTATS-MIB", "tcpEStatsStackCongOverCount"), ("TCP-ESTATS-MIB", "tcpEStatsStackAbruptTimeouts"), ("TCP-ESTATS-MIB", "tcpEStatsStackSoftErrorReason"), ("TCP-ESTATS-MIB", "tcpEStatsStackCongAvoid"), ("TCP-ESTATS-MIB", "tcpEStatsStackFastRetran"), ("TCP-ESTATS-MIB", "tcpEStatsStackCurTimeoutCount"), ("TCP-ESTATS-MIB", "tcpEStatsStackCurReasmQueue"), ("TCP-ESTATS-MIB", "tcpEStatsStackSndInitial"), ("TCP-ESTATS-MIB", "tcpEStatsStackSoftErrors"), ("TCP-ESTATS-MIB", "tcpEStatsStackRecInitial"), ("TCP-ESTATS-MIB", "tcpEStatsStackSubsequentTimeouts"), ("TCP-ESTATS-MIB", "tcpEStatsStackSACKsRcvd"), )
if mibBuilder.loadTexts: tcpEStatsStackOptionalGroup.setDescription("The tcpEStatsConnState group includes objects that\nprovide additional information about the operation of\nalgorithms used within TCP.")
tcpEStatsAppGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 12)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsAppRcvNxt"), ("TCP-ESTATS-MIB", "tcpEStatsAppThruOctetsReceived"), ("TCP-ESTATS-MIB", "tcpEStatsAppThruOctetsAcked"), ("TCP-ESTATS-MIB", "tcpEStatsAppSndUna"), ("TCP-ESTATS-MIB", "tcpEStatsAppSndNxt"), ("TCP-ESTATS-MIB", "tcpEStatsControlApp"), ("TCP-ESTATS-MIB", "tcpEStatsAppSndMax"), )
if mibBuilder.loadTexts: tcpEStatsAppGroup.setDescription("The tcpEStatsConnState group includes objects that\ncontrol the creation of the tcpEStatsAppTable,\nand provide information about the operation of\nalgorithms used within TCP.")
tcpEStatsAppHCGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 13)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsAppHCThruOctetsAcked"), ("TCP-ESTATS-MIB", "tcpEStatsAppHCThruOctetsReceived"), )
if mibBuilder.loadTexts: tcpEStatsAppHCGroup.setDescription("The tcpEStatsStackHC group includes 64-bit\ncounters in the tcpEStatsStackTable.")
tcpEStatsAppOptionalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 14)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsAppCurAppRQueue"), ("TCP-ESTATS-MIB", "tcpEStatsAppCurAppWQueue"), ("TCP-ESTATS-MIB", "tcpEStatsAppMaxAppRQueue"), ("TCP-ESTATS-MIB", "tcpEStatsAppMaxAppWQueue"), )
if mibBuilder.loadTexts: tcpEStatsAppOptionalGroup.setDescription("The tcpEStatsConnState group includes objects that\nprovide additional information about how applications\nare interacting with each TCP connection.")
tcpEStatsTuneOptionalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 15)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsTuneLimCwnd"), ("TCP-ESTATS-MIB", "tcpEStatsTuneLimMSS"), ("TCP-ESTATS-MIB", "tcpEStatsControlTune"), ("TCP-ESTATS-MIB", "tcpEStatsTuneLimRwin"), ("TCP-ESTATS-MIB", "tcpEStatsTuneLimSsthresh"), )
if mibBuilder.loadTexts: tcpEStatsTuneOptionalGroup.setDescription("The tcpEStatsConnState group includes objects that\ncontrol the creation of the tcpEStatsConnectionTable,\nwhich can be used to set tuning parameters\nfor each TCP connection.")
tcpEStatsNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 16)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsCloseNotification"), ("TCP-ESTATS-MIB", "tcpEStatsEstablishNotification"), )
if mibBuilder.loadTexts: tcpEStatsNotificationsGroup.setDescription("Notifications sent by a TCP extended statistics agent.")
tcpEStatsNotificationsCtlGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 156, 2, 2, 17)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsControlNotify"), )
if mibBuilder.loadTexts: tcpEStatsNotificationsCtlGroup.setDescription("The tcpEStatsNotificationsCtl group includes the\nobject that controls the creation of the events\nin the tcpEStatsNotificationsGroup.")

# Compliances

tcpEStatsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 156, 2, 1, 1)).setObjects(("TCP-ESTATS-MIB", "tcpEStatsAppOptionalGroup"), ("TCP-ESTATS-MIB", "tcpEStatsNotificationsGroup"), ("TCP-ESTATS-MIB", "tcpEStatsListenerHCGroup"), ("TCP-ESTATS-MIB", "tcpEStatsPathOptionalGroup"), ("TCP-ESTATS-MIB", "tcpEStatsPerfGroup"), ("TCP-ESTATS-MIB", "tcpEStatsConnectIdGroup"), ("TCP-ESTATS-MIB", "tcpEStatsAppHCGroup"), ("TCP-ESTATS-MIB", "tcpEStatsAppGroup"), ("TCP-ESTATS-MIB", "tcpEStatsStackOptionalGroup"), ("TCP-ESTATS-MIB", "tcpEStatsPerfOptionalGroup"), ("TCP-ESTATS-MIB", "tcpEStatsTuneOptionalGroup"), ("TCP-ESTATS-MIB", "tcpEStatsListenerGroup"), ("TCP-ESTATS-MIB", "tcpEStatsPathGroup"), ("TCP-ESTATS-MIB", "tcpEStatsStackGroup"), ("TCP-ESTATS-MIB", "tcpEStatsPerfHCGroup"), ("TCP-ESTATS-MIB", "tcpEStatsNotificationsCtlGroup"), ("TCP-ESTATS-MIB", "tcpEStatsPathHCGroup"), )
if mibBuilder.loadTexts: tcpEStatsCompliance.setDescription("Compliance statement for all systems that implement TCP\nextended statistics.")

# Exports

# Module identity
mibBuilder.exportSymbols("TCP-ESTATS-MIB", PYSNMP_MODULE_ID=tcpEStatsMIB)

# Types
mibBuilder.exportSymbols("TCP-ESTATS-MIB", TcpEStatsNegotiated=TcpEStatsNegotiated)

# Objects
mibBuilder.exportSymbols("TCP-ESTATS-MIB", tcpEStatsMIB=tcpEStatsMIB, tcpEStatsNotifications=tcpEStatsNotifications, tcpEStatsMIBObjects=tcpEStatsMIBObjects, tcpEStats=tcpEStats, tcpEStatsListenerTable=tcpEStatsListenerTable, tcpEStatsListenerEntry=tcpEStatsListenerEntry, tcpEStatsListenerStartTime=tcpEStatsListenerStartTime, tcpEStatsListenerSynRcvd=tcpEStatsListenerSynRcvd, tcpEStatsListenerInitial=tcpEStatsListenerInitial, tcpEStatsListenerEstablished=tcpEStatsListenerEstablished, tcpEStatsListenerAccepted=tcpEStatsListenerAccepted, tcpEStatsListenerExceedBacklog=tcpEStatsListenerExceedBacklog, tcpEStatsListenerHCSynRcvd=tcpEStatsListenerHCSynRcvd, tcpEStatsListenerHCInitial=tcpEStatsListenerHCInitial, tcpEStatsListenerHCEstablished=tcpEStatsListenerHCEstablished, tcpEStatsListenerHCAccepted=tcpEStatsListenerHCAccepted, tcpEStatsListenerHCExceedBacklog=tcpEStatsListenerHCExceedBacklog, tcpEStatsListenerCurConns=tcpEStatsListenerCurConns, tcpEStatsListenerMaxBacklog=tcpEStatsListenerMaxBacklog, tcpEStatsListenerCurBacklog=tcpEStatsListenerCurBacklog, tcpEStatsListenerCurEstabBacklog=tcpEStatsListenerCurEstabBacklog, tcpEStatsConnectIdTable=tcpEStatsConnectIdTable, tcpEStatsConnectIdEntry=tcpEStatsConnectIdEntry, tcpEStatsConnectIndex=tcpEStatsConnectIndex, tcpEStatsPerfTable=tcpEStatsPerfTable, tcpEStatsPerfEntry=tcpEStatsPerfEntry, tcpEStatsPerfSegsOut=tcpEStatsPerfSegsOut, tcpEStatsPerfDataSegsOut=tcpEStatsPerfDataSegsOut, tcpEStatsPerfDataOctetsOut=tcpEStatsPerfDataOctetsOut, tcpEStatsPerfHCDataOctetsOut=tcpEStatsPerfHCDataOctetsOut, tcpEStatsPerfSegsRetrans=tcpEStatsPerfSegsRetrans, tcpEStatsPerfOctetsRetrans=tcpEStatsPerfOctetsRetrans, tcpEStatsPerfSegsIn=tcpEStatsPerfSegsIn, tcpEStatsPerfDataSegsIn=tcpEStatsPerfDataSegsIn, tcpEStatsPerfDataOctetsIn=tcpEStatsPerfDataOctetsIn, tcpEStatsPerfHCDataOctetsIn=tcpEStatsPerfHCDataOctetsIn, tcpEStatsPerfElapsedSecs=tcpEStatsPerfElapsedSecs, tcpEStatsPerfElapsedMicroSecs=tcpEStatsPerfElapsedMicroSecs, tcpEStatsPerfStartTimeStamp=tcpEStatsPerfStartTimeStamp, tcpEStatsPerfCurMSS=tcpEStatsPerfCurMSS, tcpEStatsPerfPipeSize=tcpEStatsPerfPipeSize, tcpEStatsPerfMaxPipeSize=tcpEStatsPerfMaxPipeSize, tcpEStatsPerfSmoothedRTT=tcpEStatsPerfSmoothedRTT, tcpEStatsPerfCurRTO=tcpEStatsPerfCurRTO, tcpEStatsPerfCongSignals=tcpEStatsPerfCongSignals, tcpEStatsPerfCurCwnd=tcpEStatsPerfCurCwnd, tcpEStatsPerfCurSsthresh=tcpEStatsPerfCurSsthresh, tcpEStatsPerfTimeouts=tcpEStatsPerfTimeouts, tcpEStatsPerfCurRwinSent=tcpEStatsPerfCurRwinSent, tcpEStatsPerfMaxRwinSent=tcpEStatsPerfMaxRwinSent, tcpEStatsPerfZeroRwinSent=tcpEStatsPerfZeroRwinSent, tcpEStatsPerfCurRwinRcvd=tcpEStatsPerfCurRwinRcvd, tcpEStatsPerfMaxRwinRcvd=tcpEStatsPerfMaxRwinRcvd, tcpEStatsPerfZeroRwinRcvd=tcpEStatsPerfZeroRwinRcvd, tcpEStatsPerfSndLimTransRwin=tcpEStatsPerfSndLimTransRwin, tcpEStatsPerfSndLimTransCwnd=tcpEStatsPerfSndLimTransCwnd, tcpEStatsPerfSndLimTransSnd=tcpEStatsPerfSndLimTransSnd, tcpEStatsPerfSndLimTimeRwin=tcpEStatsPerfSndLimTimeRwin, tcpEStatsPerfSndLimTimeCwnd=tcpEStatsPerfSndLimTimeCwnd, tcpEStatsPerfSndLimTimeSnd=tcpEStatsPerfSndLimTimeSnd, tcpEStatsPathTable=tcpEStatsPathTable, tcpEStatsPathEntry=tcpEStatsPathEntry, tcpEStatsPathRetranThresh=tcpEStatsPathRetranThresh, tcpEStatsPathNonRecovDAEpisodes=tcpEStatsPathNonRecovDAEpisodes, tcpEStatsPathSumOctetsReordered=tcpEStatsPathSumOctetsReordered, tcpEStatsPathNonRecovDA=tcpEStatsPathNonRecovDA, tcpEStatsPathSampleRTT=tcpEStatsPathSampleRTT, tcpEStatsPathRTTVar=tcpEStatsPathRTTVar, tcpEStatsPathMaxRTT=tcpEStatsPathMaxRTT, tcpEStatsPathMinRTT=tcpEStatsPathMinRTT, tcpEStatsPathSumRTT=tcpEStatsPathSumRTT, tcpEStatsPathHCSumRTT=tcpEStatsPathHCSumRTT, tcpEStatsPathCountRTT=tcpEStatsPathCountRTT, tcpEStatsPathMaxRTO=tcpEStatsPathMaxRTO, tcpEStatsPathMinRTO=tcpEStatsPathMinRTO, tcpEStatsPathIpTtl=tcpEStatsPathIpTtl, tcpEStatsPathIpTosIn=tcpEStatsPathIpTosIn, tcpEStatsPathIpTosOut=tcpEStatsPathIpTosOut, tcpEStatsPathPreCongSumCwnd=tcpEStatsPathPreCongSumCwnd, tcpEStatsPathPreCongSumRTT=tcpEStatsPathPreCongSumRTT, tcpEStatsPathPostCongSumRTT=tcpEStatsPathPostCongSumRTT, tcpEStatsPathPostCongCountRTT=tcpEStatsPathPostCongCountRTT, tcpEStatsPathECNsignals=tcpEStatsPathECNsignals, tcpEStatsPathDupAckEpisodes=tcpEStatsPathDupAckEpisodes, tcpEStatsPathRcvRTT=tcpEStatsPathRcvRTT, tcpEStatsPathDupAcksOut=tcpEStatsPathDupAcksOut, tcpEStatsPathCERcvd=tcpEStatsPathCERcvd, tcpEStatsPathECESent=tcpEStatsPathECESent, tcpEStatsStackTable=tcpEStatsStackTable, tcpEStatsStackEntry=tcpEStatsStackEntry, tcpEStatsStackActiveOpen=tcpEStatsStackActiveOpen, tcpEStatsStackMSSSent=tcpEStatsStackMSSSent, tcpEStatsStackMSSRcvd=tcpEStatsStackMSSRcvd, tcpEStatsStackWinScaleSent=tcpEStatsStackWinScaleSent, tcpEStatsStackWinScaleRcvd=tcpEStatsStackWinScaleRcvd, tcpEStatsStackTimeStamps=tcpEStatsStackTimeStamps, tcpEStatsStackECN=tcpEStatsStackECN, tcpEStatsStackWillSendSACK=tcpEStatsStackWillSendSACK, tcpEStatsStackWillUseSACK=tcpEStatsStackWillUseSACK, tcpEStatsStackState=tcpEStatsStackState, tcpEStatsStackNagle=tcpEStatsStackNagle, tcpEStatsStackMaxSsCwnd=tcpEStatsStackMaxSsCwnd, tcpEStatsStackMaxCaCwnd=tcpEStatsStackMaxCaCwnd, tcpEStatsStackMaxSsthresh=tcpEStatsStackMaxSsthresh, tcpEStatsStackMinSsthresh=tcpEStatsStackMinSsthresh, tcpEStatsStackInRecovery=tcpEStatsStackInRecovery, tcpEStatsStackDupAcksIn=tcpEStatsStackDupAcksIn, tcpEStatsStackSpuriousFrDetected=tcpEStatsStackSpuriousFrDetected, tcpEStatsStackSpuriousRtoDetected=tcpEStatsStackSpuriousRtoDetected, tcpEStatsStackSoftErrors=tcpEStatsStackSoftErrors, tcpEStatsStackSoftErrorReason=tcpEStatsStackSoftErrorReason, tcpEStatsStackSlowStart=tcpEStatsStackSlowStart, tcpEStatsStackCongAvoid=tcpEStatsStackCongAvoid, tcpEStatsStackOtherReductions=tcpEStatsStackOtherReductions, tcpEStatsStackCongOverCount=tcpEStatsStackCongOverCount, tcpEStatsStackFastRetran=tcpEStatsStackFastRetran, tcpEStatsStackSubsequentTimeouts=tcpEStatsStackSubsequentTimeouts, tcpEStatsStackCurTimeoutCount=tcpEStatsStackCurTimeoutCount, tcpEStatsStackAbruptTimeouts=tcpEStatsStackAbruptTimeouts, tcpEStatsStackSACKsRcvd=tcpEStatsStackSACKsRcvd, tcpEStatsStackSACKBlocksRcvd=tcpEStatsStackSACKBlocksRcvd, tcpEStatsStackSendStall=tcpEStatsStackSendStall, tcpEStatsStackDSACKDups=tcpEStatsStackDSACKDups, tcpEStatsStackMaxMSS=tcpEStatsStackMaxMSS, tcpEStatsStackMinMSS=tcpEStatsStackMinMSS, tcpEStatsStackSndInitial=tcpEStatsStackSndInitial)
mibBuilder.exportSymbols("TCP-ESTATS-MIB", tcpEStatsStackRecInitial=tcpEStatsStackRecInitial, tcpEStatsStackCurRetxQueue=tcpEStatsStackCurRetxQueue, tcpEStatsStackMaxRetxQueue=tcpEStatsStackMaxRetxQueue, tcpEStatsStackCurReasmQueue=tcpEStatsStackCurReasmQueue, tcpEStatsStackMaxReasmQueue=tcpEStatsStackMaxReasmQueue, tcpEStatsAppTable=tcpEStatsAppTable, tcpEStatsAppEntry=tcpEStatsAppEntry, tcpEStatsAppSndUna=tcpEStatsAppSndUna, tcpEStatsAppSndNxt=tcpEStatsAppSndNxt, tcpEStatsAppSndMax=tcpEStatsAppSndMax, tcpEStatsAppThruOctetsAcked=tcpEStatsAppThruOctetsAcked, tcpEStatsAppHCThruOctetsAcked=tcpEStatsAppHCThruOctetsAcked, tcpEStatsAppRcvNxt=tcpEStatsAppRcvNxt, tcpEStatsAppThruOctetsReceived=tcpEStatsAppThruOctetsReceived, tcpEStatsAppHCThruOctetsReceived=tcpEStatsAppHCThruOctetsReceived, tcpEStatsAppCurAppWQueue=tcpEStatsAppCurAppWQueue, tcpEStatsAppMaxAppWQueue=tcpEStatsAppMaxAppWQueue, tcpEStatsAppCurAppRQueue=tcpEStatsAppCurAppRQueue, tcpEStatsAppMaxAppRQueue=tcpEStatsAppMaxAppRQueue, tcpEStatsTuneTable=tcpEStatsTuneTable, tcpEStatsTuneEntry=tcpEStatsTuneEntry, tcpEStatsTuneLimCwnd=tcpEStatsTuneLimCwnd, tcpEStatsTuneLimSsthresh=tcpEStatsTuneLimSsthresh, tcpEStatsTuneLimRwin=tcpEStatsTuneLimRwin, tcpEStatsTuneLimMSS=tcpEStatsTuneLimMSS, tcpEStatsControl=tcpEStatsControl, tcpEStatsControlPath=tcpEStatsControlPath, tcpEStatsControlStack=tcpEStatsControlStack, tcpEStatsControlApp=tcpEStatsControlApp, tcpEStatsControlTune=tcpEStatsControlTune, tcpEStatsControlNotify=tcpEStatsControlNotify, tcpEStatsConnTableLatency=tcpEStatsConnTableLatency, tcpEStatsScalar=tcpEStatsScalar, tcpEStatsListenerTableLastChange=tcpEStatsListenerTableLastChange, tcpEStatsConformance=tcpEStatsConformance, tcpEStatsCompliances=tcpEStatsCompliances, tcpEStatsGroups=tcpEStatsGroups)

# Notifications
mibBuilder.exportSymbols("TCP-ESTATS-MIB", tcpEStatsEstablishNotification=tcpEStatsEstablishNotification, tcpEStatsCloseNotification=tcpEStatsCloseNotification)

# Groups
mibBuilder.exportSymbols("TCP-ESTATS-MIB", tcpEStatsListenerGroup=tcpEStatsListenerGroup, tcpEStatsListenerHCGroup=tcpEStatsListenerHCGroup, tcpEStatsConnectIdGroup=tcpEStatsConnectIdGroup, tcpEStatsPerfGroup=tcpEStatsPerfGroup, tcpEStatsPerfOptionalGroup=tcpEStatsPerfOptionalGroup, tcpEStatsPerfHCGroup=tcpEStatsPerfHCGroup, tcpEStatsPathGroup=tcpEStatsPathGroup, tcpEStatsPathOptionalGroup=tcpEStatsPathOptionalGroup, tcpEStatsPathHCGroup=tcpEStatsPathHCGroup, tcpEStatsStackGroup=tcpEStatsStackGroup, tcpEStatsStackOptionalGroup=tcpEStatsStackOptionalGroup, tcpEStatsAppGroup=tcpEStatsAppGroup, tcpEStatsAppHCGroup=tcpEStatsAppHCGroup, tcpEStatsAppOptionalGroup=tcpEStatsAppOptionalGroup, tcpEStatsTuneOptionalGroup=tcpEStatsTuneOptionalGroup, tcpEStatsNotificationsGroup=tcpEStatsNotificationsGroup, tcpEStatsNotificationsCtlGroup=tcpEStatsNotificationsCtlGroup)

# Compliances
mibBuilder.exportSymbols("TCP-ESTATS-MIB", tcpEStatsCompliance=tcpEStatsCompliance)
