# PySNMP SMI module. Autogenerated from smidump -f python TN3270E-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:21 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANATn3270DeviceType, IANATn3270Functions, IANATn3270ResourceType, IANATn3270eAddrType, IANATn3270eAddress, IANATn3270eClientType, IANATn3270eLogData, ) = mibBuilder.importSymbols("IANATn3270eTC-MIB", "IANATn3270DeviceType", "IANATn3270Functions", "IANATn3270ResourceType", "IANATn3270eAddrType", "IANATn3270eAddress", "IANATn3270eClientType", "IANATn3270eLogData")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32")
( DateAndTime, RowStatus, TextualConvention, TestAndIncr, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowStatus", "TextualConvention", "TestAndIncr", "TimeStamp")
( Utf8String, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "Utf8String")

# Types

class SnaResourceName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,17)
    
class Tn3270eTraceData(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(3,4096),)
    

# Objects

tn3270eMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 8)).setRevisions(("1998-07-27 00:00",))
if mibBuilder.loadTexts: tn3270eMIB.setOrganization("TN3270E Working Group")
if mibBuilder.loadTexts: tn3270eMIB.setContactInfo("Kenneth White (kennethw@vnet.ibm.com)\nIBM Corp. - Dept. BRQA/Bldg. 501/G114\nP.O. Box 12195\n3039 Cornwallis\nRTP, NC 27709-2195\nUSA\n\nRobert Moore (remoore@us.ibm.com)\nIBM Corp. - Dept. BRQA/Bldg. 501/G114\nP.O. Box 12195\n3039 Cornwallis\nRTP, NC 27709-2195\nUSA\n+1-919-254-4436")
if mibBuilder.loadTexts: tn3270eMIB.setDescription("This module defines a portion of the management\ninformation base (MIB) for managing TN3270E servers.")
tn3270eNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 0))
tn3270eObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 1))
tn3270eSrvrConfTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 1))
if mibBuilder.loadTexts: tn3270eSrvrConfTable.setDescription("This table defines the configuration elements for\nTN3270E servers.  The number of entries in this table\nis expected to vary depending on the location of the\ntable.  A particular TN3270E server is expected to\nhave a single entry.  Modeling of the configuration\nelements as a table allows multiple TN3270E\nservers to be serviced by the same SNMP agent.\nAn implementation SHOULD NOT retain an SNMP-created\nentry in this table across re-IPLs (Initial Program\nLoads) of the corresponding TN3270E server.")
tn3270eSrvrConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"))
if mibBuilder.loadTexts: tn3270eSrvrConfEntry.setDescription("Definition of the configuration elements for a single\nTN3270E server.")
tn3270eSrvrConfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eSrvrConfIndex.setDescription("Identifier for a single TN3270E server.\n\ntn3270eSrvrConfIndex values need not be\ncontiguous.")
tn3270eSrvrConfInactivityTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 99999999)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfInactivityTimeout.setDescription("The inactivity time-out specified in seconds.  When a\nconnection has been inactive for the number of seconds\nspecified by this object it is closed.  Only user traffic\nis considered when determining whether there has been\nactivity on a connection.\n\nThe default value 0 means that no inactivity time-out is\nin effect.")
tn3270eSrvrConfConnectivityChk = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("timingMark", 1), ("nop", 2), ("noCheck", 3), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfConnectivityChk.setDescription("This object enables TIMING-MARK processing, NOP\nprocessing, or neither for a TN3270E server.")
tn3270eSrvrConfTmNopInactTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 86400)).clone(600)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfTmNopInactTime.setDescription("The amount of time a connection must have had no\ntraffic on it in order for a TIMING-MARK or NOP request\nto be sent on the connection.  This value applies only\nwhen connections are being examined for recent activity\non a scan interval controlled by the value of the\ntn3270eSrvrConfTmNopInterval object.")
tn3270eSrvrConfTmNopInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 86400)).clone(120)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfTmNopInterval.setDescription("The scan interval to be used by a TN3270E server when\nit examines its Telnet connections for recent activity.\nThe server scans its Telnet connections on the interval\nprovided by this object, looking for ones that have been\nidle for more than the value provided by the\ntn3270eSrvrConfTmNopInactTime object.  A TIMING-MARK or\nNOP request is sent for each connection that has\nexhibited no activity for this period of time.")
tn3270eSrvrFunctionsSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 6), IANATn3270Functions().clone('(scsCtlCodes, dataStreamCtl, responses, bindImage, sysreq)')).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrFunctionsSupported.setDescription("This object indicates the functions supported by a\nTN3270E server.")
tn3270eSrvrConfAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ("stopImmediate", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfAdminStatus.setDescription("The desired state of the TN3270E server represented\nby this entry in the table:\n\nup(1)            - Activate this TN3270E server.\ndown(2)          - Informs the associated TN3270E\n                   server to gracefully terminate\n                   its processing.\nstopImmediate(3) - Informs the associated TN3270E\n                   server to terminate itself\n                   immediately.\n\nWhen a managed system creates an entry in this table,\ntn3270eSrvrConfAdminStatus and tn3270eSrvrConfOperStatus\nare initialized as up(1) by default.\n\nThe exact behavior of a server in response to a down(2)\nor stopImmediate(3) command is left implementation-\ndependent.  A TN3270E server that is capable of it\nSHOULD close all of its TN3270 and TN3270E sessions\nduring a graceful termination.\n\nOften the function enabled via stopImmediate(3) is used\nas a last resort by a system administrator, to attempt\nto either bring down a hung TN3270E server or free up\nits resources immediately to aid in general system\navailability, or to shut down a TN3270E server that is\nnot recognizing a down(2) request.\n\nA TN3270E server that does not distinguish between\ndown(2) or stopImmediate(3) transitions should not\nsupport stopImmediate(3).")
tn3270eSrvrConfOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,4,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ("busy", 3), ("shuttingDown", 4), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrConfOperStatus.setDescription("The current operational state of a TN3270E server.\nThe following values are defined:\n\n up(1)            - the server is active and accepting\n                    new client connections\n down(2)          - the server is not active\n busy(3)          - the server is active, but is not\n                    accepting new client connections\n                    because it lacks the resources to\n                    do so\n shuttingDown(4)  - the server is active, but is not\n                    accepting new client connections\n                    because it is in the process of\n                    performing a graceful shutdown.")
tn3270eSrvrConfSessionTermState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("terminate", 1), ("luSessionPend", 2), ("queueSession", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfSessionTermState.setDescription("This object determines what a TN3270E server\nshould do when a TN3270 Session terminates:\nterminate(1)     => Terminate the TCP connection.\nluSessionPend(2) => Do not drop the TCP connection\n                   associated with a client when its\n                   TN3270 session ends.  Processing\n                   should redrive session initialization\n                   as if the client were first connecting.\nqueueSession(3)  => This value relates to the Close\n                   Destination PASS (CLSDST PASS) operation\n                   in VTAM.  An example provides the\n                   easiest explanation.  Suppose a TN3270E\n                   client is in session with APPL1, and\n                   APPL1 does a CLSDST PASS of the client's\n                   session to APPL2.  queueSession(3)\n                   specifies that the TN3270E server must\n                   keep the TCP connection with the client\n                   active after it receives the UNBIND from\n                   APPL1, waiting for the BIND from APPL2.")
tn3270eSrvrConfSrvrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("host", 1), ("gateway", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrConfSrvrType.setDescription("This object indicates the type of TN3270E server.\nThe existence of MIB tables and objects that will be\ndefined by follow-on MIBs may be predicated on whether\nthe TN3270E server can be local to the same host as a\ntarget application (host(1)) or will always be remote\n(gateway(2)).\n\nA host TN3270E server refers to an implementation where\nthe TN3270E server is collocated with the Systems\nNetwork Architecture (SNA) System Services Control Point\n(SSCP) for the dependent Secondary Logical Units (SLUs)\nthat the server makes available to its clients for\nconnecting into an SNA network.\nA gateway TN3270E server resides on an SNA node other\nthan an SSCP, either an SNA type 2.0 node or an APPN node\nacting in the role of a Dependent LU Requester (DLUR).\n\nHost and gateway TN3270E server implementations typically\ndiffer greatly as to their internal implementation and\nsystem definition (SYSDEF) requirements.")
tn3270eSrvrConfContact = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 11), SnmpAdminString().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfContact.setDescription("This object provides a scratch pad for a TN3270E\nserver administrator for storing information for\nlater retrieval.")
tn3270eSrvrConfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfRowStatus.setDescription("This object allows entries to be created and deleted\nin the tn3270eSrvrConfTable.  Entries may also be\ncreated and deleted as a result of implementation-\ndependent operations.\n\nWith the exception of tn3270eSrvrConfSrvrType, which\nan implementation can easily fill in for itself, all\nthe columnar objects in this table have DEFVALs\nassociated with them.  Consequently, a Management\nStation can create a conceptual row via a SET\noperation that specifies a value only for this object.\n\nWhen a tn3270eSrvrConfEntry is deleted (by setting\nthis object to destroy(6)), this has the side-effect\nof removing all the associated entries (i.e., those\nhaving the same tn3270eSrvrConfIndex) from the\ntn3270eSrvrPortTable, the tn3270eSrvrStatsTable, the\ntn3270eClientGroupTable, the tn3270eResPoolTable,\nthe tn3270eSnaMapTable, the tn3270eClientResMapTable,\nand the tn3270eResMapTable.  All entries in the\ntn3270eTcpConnTable that belong to a TN3270E server\nthat has been deleted MUST also be removed.\nIn other words, a tn3270eSrvrConfEntry must exist for\na TN3270E server in order for it to have entries in\nany of the other tables defined by this MIB.")
tn3270eSrvrConfLastActTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 13), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrConfLastActTime.setDescription("This object reports the DateAndTime when a TN3270E\nserver was most recently activated.\n\nThe special value of all '00'Hs indicates that the\nserver has never been active, i.e., that the value of\ntn3270eSrvrOperStatus has never been anything other\nthan down(2).")
tn3270eSrvrConfTmTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 600)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfTmTimeout.setDescription("The TIMING-MARK time-out, specified in seconds.")
tn3270eSrvrPortTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 2))
if mibBuilder.loadTexts: tn3270eSrvrPortTable.setDescription("This table defines the TCP ports associated with\nTN3270E servers.  No entry in this table shall exist\nwithout a corresponding (same tn3270eSrvrConfIndex)\nentry in the tn3270eSrvrConfTable existing.\n\nAn implementation SHOULD NOT retain SNMP-created\nentries in this table across re-IPLs (Initial Program\nLoads) of the corresponding TN3270E server.")
tn3270eSrvrPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eSrvrPort"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddrType"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddress"))
if mibBuilder.loadTexts: tn3270eSrvrPortEntry.setDescription("Definition of a single TCP port assignment to a\nTN3270E server.  Assignment of a port on a local\naddress basis is enabled though use of\ntn3270eSrvrPortAddrType and tn3270eSrvrPortAddress.\n\nA TCP port assignment that is not restricted to\na local address SHALL specify a tn3270eSrvrPortAddrType\nof unknown(0), and SHALL use a zero-length octet string\nfor the tn3270eSrvrPortAddress.")
tn3270eSrvrPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eSrvrPort.setDescription("Indicates a port assigned to a server.")
tn3270eSrvrPortAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 2), IANATn3270eAddrType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eSrvrPortAddrType.setDescription("Indicates the type of an address local to the host on\nwhich the TN3270E server resides that is represented\nin tn3270eSrvrPortAddress.  A value of unknown(0)\nSHALL be used for this object when the port is not\nto be restricted to a local address.")
tn3270eSrvrPortAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 3), IANATn3270eAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eSrvrPortAddress.setDescription("A local address on the host that a TN3270E server\nresides on that is associated with a TCP port that\nis to be used or is in use by a TN3270E server.\ntn3270eClientGroupAddrType indicates the\naddress type (IPv4 or IPv6, for example).\n\nA zero-length octet string SHALL be used as the\nvalue of this object when a local address isn't\nbeing specified.")
tn3270eSrvrPortRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrPortRowStatus.setDescription("This object allows entries to be created and deleted\nin the tn3270eSrvrPortTable.  Entries may also be\ncreated and deleted as a result of implementation-\ndependent operations.\n\nSince this is the only accessible object in this table,\na Management Station can create a conceptual row via a SET\noperation that specifies a value only for this object.\n\nAn entry in this table is deleted by setting this object\nto destroy(6).  Deletion of a tn3270eSrvrPortEntry has\nno effect on any other table entry defined by this MIB.")
tn3270eSrvrStatsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 3))
if mibBuilder.loadTexts: tn3270eSrvrStatsTable.setDescription("This table defines a set of statistics concerning\nTN3270E server performance.\n\nNo entry in this table shall exist without\na corresponding (same tn3270eSrvrConfIndex) entry in\nthe tn3270eSrvrConfTable existing.")
tn3270eSrvrStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eSrvrPort"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddrType"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddress"))
if mibBuilder.loadTexts: tn3270eSrvrStatsEntry.setDescription("A collection of statistical and maximum usage objects\nfor a single TN3270 server.  An entry can represent the total\nactivity of the server, or it can represent the activity\noccurring at the server on either a port or a\nport-and-local-address basis.\n\nCollection of the statistics represented by the objects\nin this table is not mandatory.   An implementation\nof this table MUST use only one of the three levels of\nrefinement that this table supports for the entries\nassociated with each TN3270E server.\n\nThe indexing for a row that represents total server\nstatistics is as follows:\n\n     tn3270eSrvrConfIndex      value identifying the server\n     tn3270eSrvrPort           0\n     tn3270eSrvrPortAddrType   unknown(0)\n     tn3270eSrvrPortAddress    zero-length octet string.\n\nOn a port basis:\n\n     tn3270eSrvrConfIndex      value identifying the server\n     tn3270eSrvrPort           > 0\n     tn3270eSrvrPortAddrType   unknown(0)\n     tn3270eSrvrPortAddress    zero-length octet string.\n\nOn a port-and-local-address basis:\n\n     tn3270eSrvrConfIndex      value identifying the server\n     tn3270eSrvrPort           > 0\n     tn3270eSrvrPortAddrType   valid value other than unknown(0)\n     tn3270eSrvrPortAddress    non-zero-length octet string.")
tn3270eSrvrStatsUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsUpTime.setDescription("The value of the sysUpTime object the last time\nthe TN3270E server was re-initialized.\n\nServer re-initialization is the only discontinuity\nevent for the counters in this table.  Even if table\nentries are on a port or port-and-local-address\nbasis, port deactivation and reactivation do not\nresult in counter discontinuities.")
tn3270eSrvrStatsMaxTerms = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsMaxTerms.setDescription("Indicates the maximum number of terminal LUs available\nfor use at a TN3270E server for the granularity of this\nconceptual row (server-wide, port, or\nport-and-local-address).")
tn3270eSrvrStatsInUseTerms = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInUseTerms.setDescription("Indicates the number of terminal LUs currently in\nuse at a TN3270E server for the granularity of this\nconceptual row (server-wide, port, or\nport-and-local-address).")
tn3270eSrvrStatsSpareTerms = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsSpareTerms.setDescription("Indicates the number of free terminal LUs at a TN3270E\nserver for the granularity of this conceptual row\n(server-wide, port, or port-and-local-address).\n\nIt is possible that the difference between\ntn3270eSrvrStatsMaxTerms and tn3270eSrvrStatsInUseTerms\nin a conceptual row does not equal the value of\ntn3270eSrvrStatsSpareTerms in that row:  an LU may\nexist but not be usable by a client connection.\n\nAlternatively, the administrative ceiling represented\nby tn3270eSrvrStatsMaxTerms may have been lowered to\na point where it is less than the current value of\ntn3270eSrvrStatsInUseTerms.  In this case\ntn3270eSrvrStatsSpareTerms returns the value 0.")
tn3270eSrvrStatsMaxPtrs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsMaxPtrs.setDescription("Indicates the maximum number of printer resources\navailable for use by a TN3270E server for the\ngranularity of this conceptual row (server-wide,\nport, or port-and-local-address).")
tn3270eSrvrStatsInUsePtrs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInUsePtrs.setDescription("Indicates the number of printer resources\ncurrently in use by a TN3270E server for the\ngranularity of this conceptual row (server-wide,\nport, or port-and-local-address).")
tn3270eSrvrStatsSparePtrs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsSparePtrs.setDescription("Indicates the number of free printer resources at\na TN3270E server for the granularity of this conceptual\nrow (server-wide, port, or port-and-local-address).\n\nIt is possible that the difference between\ntn3270eSrvrStatsMaxPtrs and tn3270eSrvrStatsInUsePtrs\nin a conceptual row does not equal the value of\ntn3270eSrvrStatsSparePtrs in that row:  a printer\nresource may exist but not be usable by a client\nconnection.\n\nAlternatively, the administrative ceiling represented\nby tn3270eSrvrStatsMaxPtrs may have been lowered to\na point where it is less than the current value of\ntn3270eSrvrStatsInUsePtrs.  In this case\ntn3270eSrvrStatsSparePtrs returns the value 0.")
tn3270eSrvrStatsInConnects = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInConnects.setDescription("Indicates the number of client (TCP) connections\nthat succeeded at a TN3270E server for the\ngranularity of this conceptual row (server-wide,\nport, or port-and-local-address).\n\nThe tn3270eSrvrStatsConnResrceRejs and\ntn3270eSrvrStatsConnErrorRejs objects provide a count\nof failed connection attempts.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsConnResrceRejs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsConnResrceRejs.setDescription("Indicates the number of (TCP) connections rejected\nduring connection setup at a TN3270E server for the\ngranularity of this conceptual row (server-wide,\nport, or port-and-local-address) due to a lack of\nresources at the server.  An example of when this\ncounter would be incremented is when no terminal\nor printer resource is available to associate with a\nclient's TCP connection.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsDisconnects = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsDisconnects.setDescription("Indicates the number of (TCP) connections that were\ndisconnected at a TN3270E server for the\ngranularity of this conceptual row (server-wide,\nport, or port-and-local-address).\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsHCInOctets.setDescription("Indicates the number of octets received from TN3270\nand TN3270E clients for the granularity of this\nconceptual row (server-wide, port, or\nport-and-local-address).\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInOctets.setDescription("Low-order 32 bits of tn3270eSrvrStatsHCInOctets for\nthis conceptual row.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 14), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsHCOutOctets.setDescription("Indicates the number of octets sent to TN3270\nand TN3270E clients for the granularity of this\nconceptual row (server-wide, port, or\nport-and-local-address).\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsOutOctets.setDescription("Low-order 32 bits of tn3270eSrvrStatsHCOutOctets for\nthis conceptual row.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eSrvrStatsConnErrorRejs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsConnErrorRejs.setDescription("Indicates the number of (TCP) connections rejected\nduring connection setup at a TN3270E server for the\ngranularity of this conceptual row (server-wide,\nport, or port-and-local-address) due to an error\nof some type.  An example of when this counter would\nbe incremented is when the client and the server\ncannot agree on a common set of TN3270E functions for\nthe connection.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the tn3270eSrvrStatsUpTime\nobject.")
tn3270eClientGroupTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 4))
if mibBuilder.loadTexts: tn3270eClientGroupTable.setDescription("This table defines client address groupings for use\nby a TN3270E server.\n\nNo entry in this table shall exist without\na corresponding (same tn3270eSrvrConfIndex) entry in\nthe tn3270eSrvrConfTable existing.\n\nAn implementation SHOULD NOT retain SNMP-created\nentries in this table across re-IPLs (Initial Program\nLoads) of the corresponding TN3270E server.")
tn3270eClientGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eClientGroupName"), (0, "TN3270E-MIB", "tn3270eClientGroupAddrType"), (0, "TN3270E-MIB", "tn3270eClientGroupAddress"))
if mibBuilder.loadTexts: tn3270eClientGroupEntry.setDescription("Definition of a single client address entry.  All\nentries with the same first two indexes,\ntn3270eSrvrConfIndex and tn3270eClientGroupName, are\nconsidered to be in the same client group.")
tn3270eClientGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 1), Utf8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 24))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eClientGroupName.setDescription("The name of a client group.  Note: client group\nnames are required to be unique only with respect\nto a single TN3270E server.")
tn3270eClientGroupAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 2), IANATn3270eAddrType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eClientGroupAddrType.setDescription("Indicates the type of the address represented in\ntn3270eClientGroupAddress.")
tn3270eClientGroupAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 3), IANATn3270eAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eClientGroupAddress.setDescription("The client address of a member of a client group.\nThe value of tn3270eClientGroupAddrType indicates\nthe address type (IPv4 or IPv6, for example).")
tn3270eClientGroupSubnetMask = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 4), IpAddress().clone("255.255.255.255")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientGroupSubnetMask.setDescription("The corresponding subnet mask associated with\ntn3270eClientGroupAddress.  A single IP address is\nrepresented by having this object contain the value\nof 255.255.255.255.\n\nThis object's value is meaningful only if\ntn3270eClientGroupAddrType has a value of ipv4(1).")
tn3270eClientGroupPfxLength = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 128)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientGroupPfxLength.setDescription("The corresponding IPv6 network prefix length.\n\nThis object's value is meaningful only if\ntn3270eClientGroupAddrType  has a value of ipv6(2).")
tn3270eClientGroupRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientGroupRowStatus.setDescription("This object allows entries to be created and deleted\nin the tn3270eClientGroupTable.  Entries may also be\ncreated and deleted as a result of implementation-\ndependent operations.\n\nAn entry in this table is deleted by setting this object\nto destroy(6).  When the number of entries in this table\nfor a given client group becomes 0, this has the side-\neffect of removing any entries for the group in the\ntn3270eClientResMapTable.")
tn3270eResPoolTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 5))
if mibBuilder.loadTexts: tn3270eResPoolTable.setDescription("This table defines resource groupings; the term\n'pool' is used as it is defined by RFC 2355.\n\nNo entry in this table shall exist without\na corresponding (same tn3270eSrvrConfIndex) entry in\nthe tn3270eSrvrConfTable existing.\n\nAn implementation SHOULD NOT retain SNMP-created\nentries in this table across re-IPLs (Initial Program\nLoads) of the corresponding TN3270E server.")
tn3270eResPoolEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eResPoolName"), (0, "TN3270E-MIB", "tn3270eResPoolElementName"))
if mibBuilder.loadTexts: tn3270eResPoolEntry.setDescription("Definition of a single resource pool member.  All entries\nwith the same first two indexes, tn3270eSrvrConfIndex and\ntn3270eResPoolName, are considered to be in the same pool.")
tn3270eResPoolName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 1), Utf8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 24))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eResPoolName.setDescription("The name of a resource pool.")
tn3270eResPoolElementName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 2), SnaResourceName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eResPoolElementName.setDescription("The name of a member of a resource pool.")
tn3270eResPoolElementType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 3), IANATn3270ResourceType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eResPoolElementType.setDescription("The type of the entity in a resource pool.")
tn3270eResPoolRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eResPoolRowStatus.setDescription("This object allows entries to be created and deleted\nin the tn3270eResPoolTable.  Entries may also be\ncreated and deleted as a result of implementation-\ndependent operations.\n\nAn entry in this table is deleted by setting this object\nto destroy(6).  When all entries in this table associated\nwith the same tn3270eResPoolElementName have been removed,\nthen any associated (tn3270eResPoolElementName matching\ntn3270eClientResMapPoolName with same tn3270eSrvrConfIndex\nvalues) entries in the tn3270eClientResMapTable SHALL\nalso be removed.")
tn3270eSnaMapTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 6))
if mibBuilder.loadTexts: tn3270eSnaMapTable.setDescription("This table provide a mapping from the name by which\na secondary LU is known in the SNA network to the\nname by which it is known locally at the TN3270e\nserver.  This latter name serves as an index into\nthe tn3270eResPoolTable and the tn3270eResMapTable.\nNo entry in this table shall exist without\na corresponding (same tn3270eSrvrConfIndex) entry in\nthe tn3270eSrvrConfTable existing.")
tn3270eSnaMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eSnaMapSscpSuppliedName"))
if mibBuilder.loadTexts: tn3270eSnaMapEntry.setDescription("Definition of a single mapping from an SSCP-supplied\nSLU name to a local SLU name.\n\nNote:  In certain pathological cases, it is possible\nthat an SSCP will send on an ACTLU for a local LU an\nSLU name currently represented by an entry in this\ntable that associates it with a different local LU.\nIn these cases the association from the newer ACTLU\nSHOULD be the one represented in this table.")
tn3270eSnaMapSscpSuppliedName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1, 1), SnaResourceName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eSnaMapSscpSuppliedName.setDescription("The name of the secondary LU (SLU) as it is known in\nthe SNA network.  This name is sent by the SSCP on\nthe Activate Logical Unit (ACTLU) request.")
tn3270eSnaMapLocalName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1, 2), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSnaMapLocalName.setDescription("The local name of the secondary LU (SLU).")
tn3270eSnaMapPrimaryLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1, 3), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSnaMapPrimaryLuName.setDescription("When there is a currently active LU-LU session for\nthis connection, this object returns the primary LU\n(PLU) name from the BIND.  When there is no active\nLU-LU session, or when the PLU name is unavailable\nfor some other reason, this object returns a\nzero-length octet string.")
tn3270eClientResMapTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 7))
if mibBuilder.loadTexts: tn3270eClientResMapTable.setDescription("This table defines resource-pool to client-group\nmappings.  Since both the resource pool name and client\ngroup name are included in the index clause of this\ntable, multiple resource pools can be assigned to the\nsame client group.  This enables use of multiple\nresource pools for use in client to resource mapping.\nAssigning multiple client groups to the same resource\npool is also allowed, but is not the primary purpose\nfor how the indexing is structured.\n\nAssignment of a resource pool to client group can be\nrestricted based on TCP port.  An index value of 0 for\ntn3270eClientResMapClientPort disables restriction of\nresource assignment based on client target port\nselection.\n\nNo entry in this table shall exist without\na corresponding (same tn3270eSrvrConfIndex) entry in\nthe tn3270eSrvrConfTable existing.\n\nAn implementation SHOULD NOT retain SNMP-created\nentries in this table across re-IPLs (Initial Program\nLoads) of the corresponding TN3270E server.")
tn3270eClientResMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eClientResMapPoolName"), (0, "TN3270E-MIB", "tn3270eClientResMapClientGroupName"), (0, "TN3270E-MIB", "tn3270eClientResMapClientPort"))
if mibBuilder.loadTexts: tn3270eClientResMapEntry.setDescription("Definition of a single resource pool to client group\nmapping.")
tn3270eClientResMapPoolName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 1), Utf8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 24))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eClientResMapPoolName.setDescription("The name of a resource pool.")
tn3270eClientResMapClientGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 2), Utf8String().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 24))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eClientResMapClientGroupName.setDescription("The name of the client group that is mapped to a\nresource pool.")
tn3270eClientResMapClientPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eClientResMapClientPort.setDescription("A port number restricting the scope of a mapping\nfrom a resource pool to a client group.  The\nvalue 0 for this object indicates that the scope\nof the mapping is not restricted.")
tn3270eClientResMapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientResMapRowStatus.setDescription("This object allows entries to be created and deleted\nin the tn3270eClientResMapTable.  Entries may also be\ncreated and deleted as a result of implementation-\ndependent operations.\n\nAn entry in this table is deleted by setting this object\nto destroy(6).  Removing an entry from this table doesn't\naffect any other table entry defined in this MIB.")
tn3270eResMapTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 8))
if mibBuilder.loadTexts: tn3270eResMapTable.setDescription("This table defines the actual mapping of a resource\nto a client address.\n\nNo entry in this table shall exist without\na corresponding (same tn3270eSrvrConfIndex) entry in\nthe tn3270eSrvrConfTable existing.")
tn3270eResMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eResMapElementName"))
if mibBuilder.loadTexts: tn3270eResMapEntry.setDescription("Definition of the mapping of a Resource Element to\na client address.")
tn3270eResMapElementName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 1), SnaResourceName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eResMapElementName.setDescription("The name of a resource element.  This is the name by\nwhich the server implementing this table knows the\nresource.  It may be different from the name by which\nthe resource is known in the SNA network.  This latter\nname is returned in the tn3270eResMapSscpSuppliedName\nobject.")
tn3270eResMapAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 2), IANATn3270eAddrType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapAddrType.setDescription("Indicates the type of the client address represented\nin tn3270eResMapAddress.")
tn3270eResMapAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 3), IANATn3270eAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapAddress.setDescription("A client address.")
tn3270eResMapPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapPort.setDescription("A client port.")
tn3270eResMapElementType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 5), IANATn3270ResourceType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapElementType.setDescription("The type of the associated resource element.")
tn3270eResMapSscpSuppliedName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 6), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapSscpSuppliedName.setDescription("The name of the secondary LU (SLU) as it is known\nin a SNA network.  This name is sent by the SSCP on\nthe Activate Logical Unit (ACTLU) request.  If this\nname is not known, this object returns a zero-length\noctet string.")
tn3270eTcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 9))
if mibBuilder.loadTexts: tn3270eTcpConnTable.setDescription("This table has an entry for each TN3270(E) client\nconnection that is currently active at a TN3270E server.\nAn implementation MAY retain entries for connections\nthat have been terminated, but which entries are\nretained, how many entries are retained, and how long\nthey are retained is entirely implementation-dependent.\n\nThe indexing for this table is designed to support the\nuse of an SNMP GET-NEXT operation using only the remote\naddress type, remote address, and remote port, as a way\nfor a Management Station to retrieve the table entries\nrelated to a particular TN3270(E) client.")
tn3270eTcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1)).setIndexNames((0, "TN3270E-MIB", "tn3270eTcpConnRemAddrType"), (0, "TN3270E-MIB", "tn3270eTcpConnRemAddress"), (0, "TN3270E-MIB", "tn3270eTcpConnRemPort"), (0, "TN3270E-MIB", "tn3270eTcpConnLocalAddrType"), (0, "TN3270E-MIB", "tn3270eTcpConnLocalAddress"), (0, "TN3270E-MIB", "tn3270eTcpConnLocalPort"))
if mibBuilder.loadTexts: tn3270eTcpConnEntry.setDescription("Provides information about a single TN3270/TN3270E\nsession.  Note: a tn3270eSrvrConfIndex is not needed\nin this table, since the combination of remote and\nlocal addresses and ports is sufficient to\nguarantee uniqueness across the TN3270E servers\nserviced by an SNMP agent.  Because of this indexing\nstructure, however, this table does not support\nview-based access control policies that provide\naccess to table rows on a per-server basis.")
tn3270eTcpConnRemAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 1), IANATn3270eAddrType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eTcpConnRemAddrType.setDescription("Indicates the type of the value of the\ntn3270eTcpConnRemAddress object.  For example,\nipv4(1) or ipv6(2).")
tn3270eTcpConnRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 2), IANATn3270eAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eTcpConnRemAddress.setDescription("The remote address associated with a TN3270E client.\ntn3270eTcpConnRemAddrType indicates the address type\n(IPv4 or IPv6, for example).\n\nIf a TN3270(E) client is connected to its\nserver via a proxy client the address represented by\nthe value of this object shall be the remote client's\naddress, not the proxy client's address.")
tn3270eTcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eTcpConnRemPort.setDescription("The remote port associated with a TN3270E client.  The value 0\nis used if the tn3270eTcpConnRemAddrType identifies an address\ntype that does not support ports.\n\nIf a TN3270(E) client is connected to its server via a proxy\nclient, the port represented by the value of this object shall\nbe the remote client's port, not the proxy client's port.")
tn3270eTcpConnLocalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 4), IANATn3270eAddrType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eTcpConnLocalAddrType.setDescription("Indicates the type of the value of the\ntn3270eTcpConnLocalAddress object.  For example,\nipv4(1) or ipv6(2).")
tn3270eTcpConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 5), IANATn3270eAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eTcpConnLocalAddress.setDescription("The local address associated with a TN3270E client.\ntn3270eTcpConnRemAddrType indicates the address type\n(IPv4 or IPv6, for example).")
tn3270eTcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tn3270eTcpConnLocalPort.setDescription("The remote port associated with a TN3270E client.")
tn3270eTcpConnLastActivity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 7), TimeTicks().clone('0')).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnLastActivity.setDescription("The number of 100ths of seconds since any data was\ntransferred for the associated TCP Connection.")
tn3270eTcpConnBytesIn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnBytesIn.setDescription("The number of bytes received by the server from TCP\nfor this connection.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the\ntn3270eTcpConnActivationTime object.")
tn3270eTcpConnBytesOut = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnBytesOut.setDescription("The number of bytes sent to TCP for this connection.\n\nA Management Station can detect discontinuities in\nthis counter by monitoring the\ntn3270eTcpConnActivationTime object.")
tn3270eTcpConnResourceElement = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 10), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnResourceElement.setDescription("LU/Print secondary name for connecting an client\ninto an SNA network.")
tn3270eTcpConnResourceType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 11), IANATn3270ResourceType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnResourceType.setDescription("Indicates the type of resource identified by\ntn3270eTcpConnResourceElement.")
tn3270eTcpConnDeviceType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 12), IANATn3270DeviceType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnDeviceType.setDescription("Indicates the device type if negotiated with the\nclient.  A value of unknown(100) should be used as\nthe value of this object when a device type is not\nnegotiated.  Refer to RFC 2355 for how device types\ncan be negotiated.")
tn3270eTcpConnFunctions = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 13), IANATn3270Functions()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnFunctions.setDescription("This object indicates which of the TN3270 and TN3270E\nfunctions were negotiated by the server and the client\nfor this TCP connection.\n\nRefer to tn3270eSrvrFunctionsSupported for the list of\nthese functions supported by the server.")
tn3270eTcpConnId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 14), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnId.setDescription("The connection identifier associated with a TN3270 or\na TN3270E session's TCP connection.  TCP implementations\noften assign a unique (with respect to itself) unsigned\ninteger as an identifier for a TCP connection.\n\nThe value 0 indicates that a connection does not have\na valid connection identifier.")
tn3270eTcpConnClientIdFormat = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 15), IANATn3270eClientType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnClientIdFormat.setDescription("The format of a corresponding tn3270eTcpConnClientId\nobject as defined by the IANSTn3270eClientType textual\nconvention imported from the IANATn3270eTC-MIB.")
tn3270eTcpConnClientId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 16), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 512))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnClientId.setDescription("Additional client identification information.  The\ntype of this information is indicated by the value of\nthe corresponding tn3270eTcpConnClientIdFormat object.\nAll values are returned in network-byte order.\n\nThe purpose of this object is to provide an alternate\nmeans of identifying a client, other than though the\nremote address returned in tn3270eTcpConnRemAddress.")
tn3270eTcpConnTraceData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 17), Tn3270eTraceData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnTraceData.setDescription("Trace data for this session.")
tn3270eTcpConnLogInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 18), IANATn3270eLogData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnLogInfo.setDescription("Log information, encoded as specified in the\nIANATn3270eLogData textual convention from the\nIANAtn3270eTC-MIB.")
tn3270eTcpConnLuLuBindImage = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 19), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnLuLuBindImage.setDescription("When there is a currently active LU-LU session for\nthis connection, this object returns the BIND Image\n(defined to be bytes 1-p of the complete BIND Request\nUnit -- see 'SNA Formats' for more information)\nthat was received from the PLU during session\nactivation.  When there is no active LU-LU session,\nor when a BIND image is unavailable for some other\nreason, this object returns a zero-length octet\nstring.")
tn3270eTcpConnSnaState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,5,1,3,4,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("noSluSession", 2), ("sscpLuSession", 3), ("luLuSession", 4), ("sscpLuSessionAndLuLuSession", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnSnaState.setDescription("The current state of the SNA side of the end-to-end\nTN3270 connection.  The following states are defined:\n\n    unknown(1)          - The true state is not known.\n    noSluSession(2)     - The SLU has neither an SSCP-LU\n                          nor an LU-LU session active.\n    sscpLuSession(3)    - The SSCP-LU session for the SLU\n                          is active, but the SLU is not\n                          currently in session with a PLU.\n    luLuSession(4)      - The SLU is currently in session\n                          with a PLU, but the SSCP-LU\n                          session for the LU is not active.\n    sscpLuSessionAndLuLuSession(5) - The SLU currently has\n                          an active session with a PLU,\n                          and the SSCP-LU session for the\n                          SLU is active.")
tn3270eTcpConnStateLastDiscReason = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 21), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(11,5,13,12,4,2,7,1,6,8,3,10,9,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("clientNotResponding", 10), ("serverClose", 11), ("sysreqLogoff", 12), ("serverSpecificHexCode", 13), ("hostSendsUnbind", 2), ("hostDontAcceptConnection", 3), ("outOfResource", 4), ("clientProtocolError", 5), ("invalidDeviceName", 6), ("deviceInUse", 7), ("inactivityTimeout", 8), ("hostNotResponding", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnStateLastDiscReason.setDescription("The last disconnect reason.  A session that has not\nexperienced a disconnect shall use the value unknown(1)\nfor this object.  Depending on when an implementation\nremoves entries from this table, certain states may\nnever be returned.")
tn3270eTcpConnSrvrConfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 22), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnSrvrConfIndex.setDescription("tn3270eSrvrConfIndex of the tn3270eSrvrConfEntry\nbelonging to the TN3270E server to which this entry\nbelongs.")
tn3270eTcpConnActivationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 23), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnActivationTime.setDescription("The value of the sysUpTime object the last time\nthis TCP connection became active.")
tn3270eConfSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 34, 8, 1, 10), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tn3270eConfSpinLock.setDescription("An advisory lock used to allow cooperating\nTN3270E-MIB applications to coordinate their use\nof the tn3270eSrvrConfTable, the tn3270eSrvrPortTable,\nthe tn3270eClientGroupTable, the tn3270eResPoolTable,\nand the tn3270eClientResMapTable.\n\nWhen creating a new entry or altering an existing entry\nin the any of the tables mentioned above, an application\nshould make use of tn3270eRtSpinLock to serialize\napplication changes or additions.\n\nSince this is an advisory lock, the use of this lock is\nnot enforced.")
tn3270eConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 3))
tn3270eGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 3, 1))
tn3270eCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 3, 2))

# Augmentions

# Groups

tn3270eBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 1)).setObjects(("TN3270E-MIB", "tn3270eSrvrStatsConnResrceRejs"), ("TN3270E-MIB", "tn3270eSrvrStatsInUsePtrs"), ("TN3270E-MIB", "tn3270eSrvrStatsSparePtrs"), ("TN3270E-MIB", "tn3270eSrvrStatsInConnects"), ("TN3270E-MIB", "tn3270eSrvrStatsSpareTerms"), ("TN3270E-MIB", "tn3270eSrvrFunctionsSupported"), ("TN3270E-MIB", "tn3270eConfSpinLock"), ("TN3270E-MIB", "tn3270eSrvrConfTmNopInactTime"), ("TN3270E-MIB", "tn3270eSrvrConfContact"), ("TN3270E-MIB", "tn3270eSrvrStatsInUseTerms"), ("TN3270E-MIB", "tn3270eSrvrStatsDisconnects"), ("TN3270E-MIB", "tn3270eSnaMapPrimaryLuName"), ("TN3270E-MIB", "tn3270eSrvrStatsInOctets"), ("TN3270E-MIB", "tn3270eSrvrConfTmTimeout"), ("TN3270E-MIB", "tn3270eSnaMapLocalName"), ("TN3270E-MIB", "tn3270eSrvrConfAdminStatus"), ("TN3270E-MIB", "tn3270eSrvrStatsConnErrorRejs"), ("TN3270E-MIB", "tn3270eSrvrStatsMaxTerms"), ("TN3270E-MIB", "tn3270eSrvrConfTmNopInterval"), ("TN3270E-MIB", "tn3270eSrvrConfSrvrType"), ("TN3270E-MIB", "tn3270eSrvrStatsUpTime"), ("TN3270E-MIB", "tn3270eSrvrConfOperStatus"), ("TN3270E-MIB", "tn3270eSrvrConfRowStatus"), ("TN3270E-MIB", "tn3270eClientGroupPfxLength"), ("TN3270E-MIB", "tn3270eSrvrStatsOutOctets"), ("TN3270E-MIB", "tn3270eClientGroupRowStatus"), ("TN3270E-MIB", "tn3270eSrvrConfInactivityTimeout"), ("TN3270E-MIB", "tn3270eSrvrConfLastActTime"), ("TN3270E-MIB", "tn3270eSrvrConfSessionTermState"), ("TN3270E-MIB", "tn3270eSrvrPortRowStatus"), ("TN3270E-MIB", "tn3270eSrvrConfConnectivityChk"), ("TN3270E-MIB", "tn3270eClientGroupSubnetMask"), ("TN3270E-MIB", "tn3270eSrvrStatsMaxPtrs"), )
if mibBuilder.loadTexts: tn3270eBasicGroup.setDescription("This group is mandatory for all hosts supporting the\nTN3270E-MIB.")
tn3270eSessionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 2)).setObjects(("TN3270E-MIB", "tn3270eTcpConnSrvrConfIndex"), ("TN3270E-MIB", "tn3270eResMapAddrType"), ("TN3270E-MIB", "tn3270eTcpConnBytesOut"), ("TN3270E-MIB", "tn3270eTcpConnFunctions"), ("TN3270E-MIB", "tn3270eTcpConnResourceElement"), ("TN3270E-MIB", "tn3270eResMapPort"), ("TN3270E-MIB", "tn3270eTcpConnActivationTime"), ("TN3270E-MIB", "tn3270eResMapAddress"), ("TN3270E-MIB", "tn3270eTcpConnResourceType"), ("TN3270E-MIB", "tn3270eTcpConnLastActivity"), ("TN3270E-MIB", "tn3270eTcpConnDeviceType"), ("TN3270E-MIB", "tn3270eResMapSscpSuppliedName"), ("TN3270E-MIB", "tn3270eResMapElementType"), ("TN3270E-MIB", "tn3270eTcpConnBytesIn"), )
if mibBuilder.loadTexts: tn3270eSessionGroup.setDescription("This group is mandatory for all hosts supporting the\nTN3270E-MIB.")
tn3270eResMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 3)).setObjects(("TN3270E-MIB", "tn3270eTcpConnSnaState"), ("TN3270E-MIB", "tn3270eTcpConnTraceData"), ("TN3270E-MIB", "tn3270eResPoolElementType"), ("TN3270E-MIB", "tn3270eTcpConnId"), ("TN3270E-MIB", "tn3270eTcpConnClientId"), ("TN3270E-MIB", "tn3270eTcpConnLuLuBindImage"), ("TN3270E-MIB", "tn3270eResPoolRowStatus"), ("TN3270E-MIB", "tn3270eTcpConnStateLastDiscReason"), ("TN3270E-MIB", "tn3270eClientResMapRowStatus"), ("TN3270E-MIB", "tn3270eTcpConnClientIdFormat"), ("TN3270E-MIB", "tn3270eTcpConnLogInfo"), )
if mibBuilder.loadTexts: tn3270eResMapGroup.setDescription("This group is optional for all hosts supporting the\nTN3270E-MIB.")
tn3270eHiCapacityGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 4)).setObjects(("TN3270E-MIB", "tn3270eSrvrStatsHCOutOctets"), ("TN3270E-MIB", "tn3270eSrvrStatsHCInOctets"), )
if mibBuilder.loadTexts: tn3270eHiCapacityGroup.setDescription("Support of these objects is REQUIRED when the\nCounter32 versions can potentially wrap too\nfrequently.  This group is optional for all other\nhosts supporting the TN3270E-MIB.\n\nThe IF-MIB (RFC 2233) requires that the 64-bit\nversions of its counters be implemented when an\ninterface can support rates of around 20 million\nbits per second or greater.  This implies a minimum\nwrap rate of just over 28 minutes.  It is recommended\nthat this same guideline be used for determining\nwhether an implementation implements these objects.\n\nThis group contains two objects with the syntax\nCounter64.  An implementation that doesn't support\nthese objects should return noSuchObject, since\nreturning a zero is misleading.")

# Compliances

tn3270eCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 8, 3, 2, 1)).setObjects(("TN3270E-MIB", "tn3270eResMapGroup"), ("TN3270E-MIB", "tn3270eSessionGroup"), ("TN3270E-MIB", "tn3270eBasicGroup"), ("TN3270E-MIB", "tn3270eHiCapacityGroup"), )
if mibBuilder.loadTexts: tn3270eCompliance.setDescription("The compliance statement for agents that support the\nTN3270E-MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("TN3270E-MIB", PYSNMP_MODULE_ID=tn3270eMIB)

# Types
mibBuilder.exportSymbols("TN3270E-MIB", SnaResourceName=SnaResourceName, Tn3270eTraceData=Tn3270eTraceData)

# Objects
mibBuilder.exportSymbols("TN3270E-MIB", tn3270eMIB=tn3270eMIB, tn3270eNotifications=tn3270eNotifications, tn3270eObjects=tn3270eObjects, tn3270eSrvrConfTable=tn3270eSrvrConfTable, tn3270eSrvrConfEntry=tn3270eSrvrConfEntry, tn3270eSrvrConfIndex=tn3270eSrvrConfIndex, tn3270eSrvrConfInactivityTimeout=tn3270eSrvrConfInactivityTimeout, tn3270eSrvrConfConnectivityChk=tn3270eSrvrConfConnectivityChk, tn3270eSrvrConfTmNopInactTime=tn3270eSrvrConfTmNopInactTime, tn3270eSrvrConfTmNopInterval=tn3270eSrvrConfTmNopInterval, tn3270eSrvrFunctionsSupported=tn3270eSrvrFunctionsSupported, tn3270eSrvrConfAdminStatus=tn3270eSrvrConfAdminStatus, tn3270eSrvrConfOperStatus=tn3270eSrvrConfOperStatus, tn3270eSrvrConfSessionTermState=tn3270eSrvrConfSessionTermState, tn3270eSrvrConfSrvrType=tn3270eSrvrConfSrvrType, tn3270eSrvrConfContact=tn3270eSrvrConfContact, tn3270eSrvrConfRowStatus=tn3270eSrvrConfRowStatus, tn3270eSrvrConfLastActTime=tn3270eSrvrConfLastActTime, tn3270eSrvrConfTmTimeout=tn3270eSrvrConfTmTimeout, tn3270eSrvrPortTable=tn3270eSrvrPortTable, tn3270eSrvrPortEntry=tn3270eSrvrPortEntry, tn3270eSrvrPort=tn3270eSrvrPort, tn3270eSrvrPortAddrType=tn3270eSrvrPortAddrType, tn3270eSrvrPortAddress=tn3270eSrvrPortAddress, tn3270eSrvrPortRowStatus=tn3270eSrvrPortRowStatus, tn3270eSrvrStatsTable=tn3270eSrvrStatsTable, tn3270eSrvrStatsEntry=tn3270eSrvrStatsEntry, tn3270eSrvrStatsUpTime=tn3270eSrvrStatsUpTime, tn3270eSrvrStatsMaxTerms=tn3270eSrvrStatsMaxTerms, tn3270eSrvrStatsInUseTerms=tn3270eSrvrStatsInUseTerms, tn3270eSrvrStatsSpareTerms=tn3270eSrvrStatsSpareTerms, tn3270eSrvrStatsMaxPtrs=tn3270eSrvrStatsMaxPtrs, tn3270eSrvrStatsInUsePtrs=tn3270eSrvrStatsInUsePtrs, tn3270eSrvrStatsSparePtrs=tn3270eSrvrStatsSparePtrs, tn3270eSrvrStatsInConnects=tn3270eSrvrStatsInConnects, tn3270eSrvrStatsConnResrceRejs=tn3270eSrvrStatsConnResrceRejs, tn3270eSrvrStatsDisconnects=tn3270eSrvrStatsDisconnects, tn3270eSrvrStatsHCInOctets=tn3270eSrvrStatsHCInOctets, tn3270eSrvrStatsInOctets=tn3270eSrvrStatsInOctets, tn3270eSrvrStatsHCOutOctets=tn3270eSrvrStatsHCOutOctets, tn3270eSrvrStatsOutOctets=tn3270eSrvrStatsOutOctets, tn3270eSrvrStatsConnErrorRejs=tn3270eSrvrStatsConnErrorRejs, tn3270eClientGroupTable=tn3270eClientGroupTable, tn3270eClientGroupEntry=tn3270eClientGroupEntry, tn3270eClientGroupName=tn3270eClientGroupName, tn3270eClientGroupAddrType=tn3270eClientGroupAddrType, tn3270eClientGroupAddress=tn3270eClientGroupAddress, tn3270eClientGroupSubnetMask=tn3270eClientGroupSubnetMask, tn3270eClientGroupPfxLength=tn3270eClientGroupPfxLength, tn3270eClientGroupRowStatus=tn3270eClientGroupRowStatus, tn3270eResPoolTable=tn3270eResPoolTable, tn3270eResPoolEntry=tn3270eResPoolEntry, tn3270eResPoolName=tn3270eResPoolName, tn3270eResPoolElementName=tn3270eResPoolElementName, tn3270eResPoolElementType=tn3270eResPoolElementType, tn3270eResPoolRowStatus=tn3270eResPoolRowStatus, tn3270eSnaMapTable=tn3270eSnaMapTable, tn3270eSnaMapEntry=tn3270eSnaMapEntry, tn3270eSnaMapSscpSuppliedName=tn3270eSnaMapSscpSuppliedName, tn3270eSnaMapLocalName=tn3270eSnaMapLocalName, tn3270eSnaMapPrimaryLuName=tn3270eSnaMapPrimaryLuName, tn3270eClientResMapTable=tn3270eClientResMapTable, tn3270eClientResMapEntry=tn3270eClientResMapEntry, tn3270eClientResMapPoolName=tn3270eClientResMapPoolName, tn3270eClientResMapClientGroupName=tn3270eClientResMapClientGroupName, tn3270eClientResMapClientPort=tn3270eClientResMapClientPort, tn3270eClientResMapRowStatus=tn3270eClientResMapRowStatus, tn3270eResMapTable=tn3270eResMapTable, tn3270eResMapEntry=tn3270eResMapEntry, tn3270eResMapElementName=tn3270eResMapElementName, tn3270eResMapAddrType=tn3270eResMapAddrType, tn3270eResMapAddress=tn3270eResMapAddress, tn3270eResMapPort=tn3270eResMapPort, tn3270eResMapElementType=tn3270eResMapElementType, tn3270eResMapSscpSuppliedName=tn3270eResMapSscpSuppliedName, tn3270eTcpConnTable=tn3270eTcpConnTable, tn3270eTcpConnEntry=tn3270eTcpConnEntry, tn3270eTcpConnRemAddrType=tn3270eTcpConnRemAddrType, tn3270eTcpConnRemAddress=tn3270eTcpConnRemAddress, tn3270eTcpConnRemPort=tn3270eTcpConnRemPort, tn3270eTcpConnLocalAddrType=tn3270eTcpConnLocalAddrType, tn3270eTcpConnLocalAddress=tn3270eTcpConnLocalAddress, tn3270eTcpConnLocalPort=tn3270eTcpConnLocalPort, tn3270eTcpConnLastActivity=tn3270eTcpConnLastActivity, tn3270eTcpConnBytesIn=tn3270eTcpConnBytesIn, tn3270eTcpConnBytesOut=tn3270eTcpConnBytesOut, tn3270eTcpConnResourceElement=tn3270eTcpConnResourceElement, tn3270eTcpConnResourceType=tn3270eTcpConnResourceType, tn3270eTcpConnDeviceType=tn3270eTcpConnDeviceType, tn3270eTcpConnFunctions=tn3270eTcpConnFunctions, tn3270eTcpConnId=tn3270eTcpConnId, tn3270eTcpConnClientIdFormat=tn3270eTcpConnClientIdFormat, tn3270eTcpConnClientId=tn3270eTcpConnClientId, tn3270eTcpConnTraceData=tn3270eTcpConnTraceData, tn3270eTcpConnLogInfo=tn3270eTcpConnLogInfo, tn3270eTcpConnLuLuBindImage=tn3270eTcpConnLuLuBindImage, tn3270eTcpConnSnaState=tn3270eTcpConnSnaState, tn3270eTcpConnStateLastDiscReason=tn3270eTcpConnStateLastDiscReason, tn3270eTcpConnSrvrConfIndex=tn3270eTcpConnSrvrConfIndex, tn3270eTcpConnActivationTime=tn3270eTcpConnActivationTime, tn3270eConfSpinLock=tn3270eConfSpinLock, tn3270eConformance=tn3270eConformance, tn3270eGroups=tn3270eGroups, tn3270eCompliances=tn3270eCompliances)

# Groups
mibBuilder.exportSymbols("TN3270E-MIB", tn3270eBasicGroup=tn3270eBasicGroup, tn3270eSessionGroup=tn3270eSessionGroup, tn3270eResMapGroup=tn3270eResMapGroup, tn3270eHiCapacityGroup=tn3270eHiCapacityGroup)

# Compliances
mibBuilder.exportSymbols("TN3270E-MIB", tn3270eCompliance=tn3270eCompliance)
