# PySNMP SMI module. Autogenerated from smidump -f python TRIP-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:22 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( applIndex, applRFC2788Group, ) = mibBuilder.importSymbols("NETWORK-SERVICES-MIB", "applIndex", "applRFC2788Group")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, RowStatus, StorageType, TimeInterval, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowStatus", "StorageType", "TimeInterval", "TimeStamp", "TruthValue")
( TripAddressFamily, TripAppProtocol, TripCommunityId, TripId, TripItad, TripProtocolVersion, TripSendReceiveMode, ) = mibBuilder.importSymbols("TRIP-TC-MIB", "TripAddressFamily", "TripAppProtocol", "TripCommunityId", "TripId", "TripItad", "TripProtocolVersion", "TripSendReceiveMode")

# Objects

tripMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 116)).setRevisions(("2004-09-02 00:00",))
if mibBuilder.loadTexts: tripMIB.setOrganization("IETF IPTel Working Group.\n\n\nMailing list: iptel@lists.bell-labs.com")
if mibBuilder.loadTexts: tripMIB.setContactInfo("Co-editor  David Zinman\npostal:    265 Ridley Blvd.\n           Toronto ON, M5M 4N8\n           Canada\nemail:     dzinman@rogers.com\nphone:     +1 416 433 4298\n\nCo-editor: David Walker\n       Sedna Wireless Inc.\npostal:    495 March Road, Suite 500\n       Ottawa, ON K2K 3G1\n       Canada\nemail:     david.walker@sedna-wireless.com\nphone:     +1 613 878 8142\n\nCo-editor   Jianping Jiang\n        Syndesis Limited\npostal:     30 Fulton Way\n        Richmond Hill, ON L4B 1J5\n        Canada\n\nemail:      jjiang@syndesis.com\nphone:      +1 905 886-7818 x2515")
if mibBuilder.loadTexts: tripMIB.setDescription("The MIB module describing Telephony Routing over IP\n(TRIP). TRIP is a policy driven inter-administrative\ndomain protocol for advertising the reachability of\ntelephony destinations between location servers (LS), and\nfor advertising attributes of the routes to those\ndestinations.\n\nCopyright (C) The Internet Society (2004). This version of\nthis MIB module is part of RFC 3872, see the RFC itself\nfor full legal notices.")
tripMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 0))
tripMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 1))
tripCfgTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 1))
if mibBuilder.loadTexts: tripCfgTable.setDescription("This table contains the common configuration objects\napplicable to all TRIP applications referenced by the\napplIndex.  Each row represents those objects for a\nparticular TRIP LS present in this system. The\ninstances of TRIP LS's are uniquely identified by the\napplIndex. The objects in this table SHOULD be\nnonVolatile and survive a reboot.")
tripCfgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 1, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: tripCfgEntry.setDescription("A row of common configuration.")
tripCfgProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 1), TripProtocolVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgProtocolVersion.setDescription("This object will reflect the version of TRIP\nsupported by this system.  It follows the same\nformat as TRIP version information contained\nin the TRIP messages generated by this TRIP entity.")
tripCfgItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 2), TripItad()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgItad.setDescription("The Internet Telephony Administrative domain (ITAD)\nof this LS.")
tripCfgIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 3), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgIdentifier.setDescription("The object that identifies this TRIP Client.")
tripCfgAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgAdminStatus.setDescription("The desired TRIP state.\n\nup(1)  : Set the application to normal operation.\n\ndown(2): Set the application to a state where it will\n         not process TRIP messages.\n\nSetting this object should be reflected in\ntripCfgOperStatus. If an unknown error occurs\ntripCfgOperStatus will return unknown(0).")
tripCfgOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,0,3,1,)).subtype(namedValues=namedval.NamedValues(("unknown", 0), ("up", 1), ("down", 2), ("faulty", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgOperStatus.setDescription("The current operational state of the TRIP protocol.\n\nunknown(0): The operating status of the application is\n            unknown.\n\nup(1):      The application is operating normally, and\n            is ready to process (receive and issue) TRIP\n            requests and responses.\n\ndown(2):    The application is currently not processing\n            TRIP messages. This occurs if the TRIP\n            application is in an initialization state or\n            if tripCfgAdminStatus is set to down(2).\n\nfaulty(3):  The application is not operating normally due\n            to a fault in the system.\n\nIf tripCfgAdminStatus is down(2) then tripOperStatus SHOULD\nbe down(2). If tripAdminStatus is changed to up(1) then\ntripOperStatus SHOULD change to up(1) if there is no\nfault that prevents the TRIP protocol from moving to the\nup(1) state.")
tripCfgAddrIAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 6), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgAddrIAddrType.setDescription("The type of Inet Address of the tripAddr.")
tripCfgAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 7), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgAddr.setDescription("The network address of the local LS that the peer\nconnects to. The type of address depends on the object\ntripCfgAddrIAddrType. The type of this address is\ndetermined by the value of the\ntripCfgAddrIAddrType object.")
tripCfgPort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 8), InetPortNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgPort.setDescription("The local tcp/udp port on the local LS that the peer\nconnects to.")
tripCfgMinItadOriginationInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(30)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgMinItadOriginationInterval.setDescription("The minimum amount of time that MUST elapse between\nadvertisement of the update message that reports changes\nwithin the LS's own ITAD.")
tripCfgMinRouteAdvertisementInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(30)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgMinRouteAdvertisementInterval.setDescription("Specifies minimal interval between successive\nadvertisements to a particular destination from an LS.")
tripCfgMaxPurgeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(10)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgMaxPurgeTime.setDescription("Indicates the interval that the LS MUST maintain routes\nmarked as withdrawn in its database.")
tripCfgDisableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(180)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgDisableTime.setDescription("Indicates the interval that the TRIP module of the\nLS MUST be disabled while routes originated by this\nLS with high sequence numbers can be removed.")
tripCfgSendReceiveMode = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 13), TripSendReceiveMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripCfgSendReceiveMode.setDescription("The operational mode of the TRIP entity running on this\nsystem.")
tripCfgStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 1, 1, 14), StorageType().clone('nonVolatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tripCfgStorage.setDescription("The storage type for this conceptual row. Conceptual rows\nhaving the value 'permanent' need not allow write-access\nto any columnar objects in the row.")
tripRouteTypeTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 2))
if mibBuilder.loadTexts: tripRouteTypeTable.setDescription("The TRIP peer Route Type table contains one entry per\nsupported protocol - address family pair.  The objects in\nthis table are volatile and are refreshed after a reboot.")
tripRouteTypeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 2, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripRouteTypeAddrInetType"), (0, "TRIP-MIB", "tripRouteTypeAddr"), (0, "TRIP-MIB", "tripRouteTypePort"), (0, "TRIP-MIB", "tripRouteTypeProtocolId"), (0, "TRIP-MIB", "tripRouteTypeAddrFamilyId"))
if mibBuilder.loadTexts: tripRouteTypeEntry.setDescription("An entry containing information about the route type\nthat a particular TRIP entity supports. Each entry\nrepresents information about either the local or a remote\nLS peer.  The object tripRouteTypePeer is used to\ndistinguish this.  In the case of a local LS, the\naddress/port information will reflect the values\nconfigured in tripCfgTable.  In the case of a remote\npeer, the address/port information will reflect the\nvalues of an entry in the tripPeerTable.\n\nImplementation need to be aware that if the size of\ntripRouteTypeAddr exceeds 111 sub-IDs, then OIDs of column\ninstances in this table will have more than 128 sub-IDs\nand cannot be accessed using SNMPv1, SNMPv2c, or snmpv3.")
tripRouteTypeAddrInetType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteTypeAddrInetType.setDescription("The type of Inet Address of the tripRouteTypeAddr.")
tripRouteTypeAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteTypeAddr.setDescription("The network address of this entry's TRIP peer LS. The\ntype of this address is determined by the value of the\ntripRouteTypeAddrInetType object.")
tripRouteTypePort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 3), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteTypePort.setDescription("The port for the TCP connection between this and\nan associated TRIP peer.")
tripRouteTypeProtocolId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 4), TripAppProtocol()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteTypeProtocolId.setDescription("The object identifier of a protocol that the associated\npeer is using.")
tripRouteTypeAddrFamilyId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 5), TripAddressFamily()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteTypeAddrFamilyId.setDescription("The object identifier of an address family that the\nassociated peer belongs to.")
tripRouteTypePeer = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 2, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("local", 1), ("remote", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteTypePeer.setDescription("This object identifies whether this entry is\n\n\n\nassociated with a 'local' or 'remote' LS peer.")
tripSupportedCommunityTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 3))
if mibBuilder.loadTexts: tripSupportedCommunityTable.setDescription("The list of TRIP communities that this LS supports. A\nTRIP community is a group of destinations that share\ncommon properties.\n\nThe TRIP Supported Communities entry is used to group\ndestinations so that the routing decision can be based\non the identity of the group.")
tripSupportedCommunityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 3, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripSupportedCommunityId"))
if mibBuilder.loadTexts: tripSupportedCommunityEntry.setDescription("Entry containing information about a community. A TRIP\ncommunity is a group of destinations that share some\ncommon property. This attribute is used so that routing\ndecisions can be based on the identity of the group.")
tripSupportedCommunityId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 1), TripCommunityId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripSupportedCommunityId.setDescription("The identifier of the supported Community.")
tripSupportedCommunityItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 2), TripItad()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripSupportedCommunityItad.setDescription("The ITAD of the community.")
tripSupportedCommunityStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 3), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripSupportedCommunityStorage.setDescription("The storage type for this conceptual row.  Conceptual\nrows having the value 'permanent' need not allow write-\naccess to any columnar objects in the row. It is not a\nrequirement that this storage be non volatile.")
tripSupportedCommunityRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripSupportedCommunityRowStatus.setDescription("The row status of the entry. This object is REQUIRED\nto create or delete rows by a manager. A value for\ntripSupportedCommunityItad MUST be set for row creation\nto be successful. If the instance already exists for a\nparticular applIndex, the row create operation will\nfail.\n\nThe value of this object has no effect on whether\nother objects in this conceptual row can be modified.")
tripPeerTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 4))
if mibBuilder.loadTexts: tripPeerTable.setDescription("The TRIP peer table. This table contains one entry per\nTRIP peer, and information about the connection with\n\n\n\nthe peer.")
tripPeerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 4, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripPeerRemoteAddrInetType"), (0, "TRIP-MIB", "tripPeerRemoteAddr"), (0, "TRIP-MIB", "tripPeerRemotePort"))
if mibBuilder.loadTexts: tripPeerEntry.setDescription("Entry containing information about the connection with\na TRIP peer.\n\nImplementation need to be aware that if the size of\ntripPeerRemoteAddr exceeds 113 sub-IDs, then OIDs of\ncolumn instances in this table will have more than 128\nsub-IDs and cannot be accessed using SNMPv1, SNMPv2c, or\nsnmpv3.")
tripPeerRemoteAddrInetType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripPeerRemoteAddrInetType.setDescription("The type of Inet Address of the tripPeerRemoteAddr.")
tripPeerRemoteAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripPeerRemoteAddr.setDescription("The IP address of this entry's TRIP peer LS. The type of\nthis address is determined by the value of the\ntripPeerRemoteAddrInetType object.")
tripPeerRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 3), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripPeerRemotePort.setDescription("The remote port for the TCP connection between the\nTRIP peers.")
tripPeerIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 4), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerIdentifier.setDescription("TRIP identifier of the peer.")
tripPeerState = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,5,4,1,2,3,)).subtype(namedValues=namedval.NamedValues(("idle", 1), ("connect", 2), ("active", 3), ("openSent", 4), ("openConfirm", 5), ("established", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerState.setDescription("TRIP Peer Finite State Machine state.\n\nidle(1)       : The initial state. Local LS refuses all\n                incoming connections. No application\n                resources are allocated to processing\n                information about the remote peer.\n\nconnect(2)    : Local LS waiting for a transport\n                protocol connection to be completed to\n                the peer, and is listening for inbound\n                transport connections from the peer.\n\nactive(3)     : Local LS is listening for an inbound\n                connection from the peer, but is not in\n                the process of initiating a connection\n                to the remote peer.\n\nopenSent(4)   : Local LS has sent an OPEN message to its\n                peer and is waiting for an OPEN message\n                from the remote peer.\n\nopenConfirm(5): Local LS has sent an OPEN message to the\n                remote peer, received an OPEN message from\n                the remote peer, and sent a KEEPALIVE\n                message in response to the OPEN. The local\n                LS is now waiting for a KEEPALIVE message\n                or a NOTIFICATION message in response to\n                its OPEN message.\n\nestablished(6): LS can exchange UPDATE, NOTIFICATION, and\n                KEEPALIVE messages with its peer.")
tripPeerAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("down", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerAdminStatus.setDescription("This object is used to affect the TRIP connection\nstate.\n\nup(1)   : Allow a connection with the peer LS.\n\ndown(2) : disconnect the connection from the peer LS and\n          do not allow any further connections to this\n\n\n\n          peer.\n\nIf this value is set to down(2) then tripPeerState will\nhave the value of idle(1).")
tripPeerNegotiatedVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 7), TripProtocolVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerNegotiatedVersion.setDescription("The negotiated version of TRIP running between this\nlocal entity and this peer.")
tripPeerSendReceiveMode = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 8), TripSendReceiveMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerSendReceiveMode.setDescription("The operational mode of this peer.")
tripPeerRemoteItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 9), TripItad()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerRemoteItad.setDescription("The Internet Telephony Administrative domain of\nthis peer.")
tripPeerConnectRetryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(120)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerConnectRetryInterval.setDescription("Specifies the initial amount of time that will elapse\nbetween connection retry. This value SHOULD double\nafter each attempt up to the value of\ntripPeerMaxRetryInterval. This value MUST always be less\nthan or equal to the value of tripPeerMaxRetryInterval.\nAttempts to set this value higher than the max retry\nwill not be allowed.")
tripPeerMaxRetryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(360)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerMaxRetryInterval.setDescription("Specifies the maximum amount of time that will elapse\nbetween connection retries. Once the value of\ntripPeerConnectRetryInterval has reached this value, no\nmore retries will be attempted. Attempts to set this\nvalue lower than the retry interval SHOULD not be\nallowed.")
tripPeerHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerHoldTime.setDescription("The time interval in seconds for the hold timer that\nis established with the peer. The value of this object\nis the smaller of the values in\ntripPeerHoldTimeConfigured and the hold time received\nin the open message.")
tripPeerKeepAlive = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerKeepAlive.setDescription("Specifies the amount of time that MUST elapse between\nkeep alive messages. This value is negotiated with the\nremote when a connection is established.")
tripPeerHoldTimeConfigured = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 14), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(3,65535),)).clone(240)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerHoldTimeConfigured.setDescription("Specifies the maximum time that MAY elapse between the\nreceipt of successive keepalive or update message. A value\nof 0 means that keepalive or update messages will not be\n\n\n\nsent.")
tripPeerKeepAliveConfigured = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 15), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(30)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerKeepAliveConfigured.setDescription("Specifies the amount of time that MUST elapse between\nkeep alive messages.")
tripPeerMaxPurgeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 16), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerMaxPurgeTime.setDescription("Indicates the interval that the LS MUST maintain routes\nmarked as withdrawn in its database.")
tripPeerDisableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 17), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerDisableTime.setDescription("Indicate the interval that the TRIP module of the remote\npeer LS MUST be disabled while routes originated by the\nlocal LS with high sequence numbers can be removed.")
tripPeerLearned = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 18), TruthValue().clone('false')).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerLearned.setDescription("Indicates whether this entry was learned or\nconfigured.")
tripPeerStorage = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 19), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerStorage.setDescription("The storage type for this conceptual row.  Conceptual\nrows having the value 'permanent' need not allow write-\naccess to any columnar objects in the row. It is not a\nrequirement that this storage be non volatile.")
tripPeerRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 4, 1, 20), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tripPeerRowStatus.setDescription("The row status of the entry. This object is REQUIRED to\ncreate or delete rows remotely by a manager. If the\ninstance already exists for a particular applIndex, the\nrow create operation will fail.\n\nThe value of this object has no effect on whether\nother objects in this conceptual row can be modified.\n\nEntries in this table can be learned by the TRIP\napplication, or provisioned through this table.")
tripPeerStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 5))
if mibBuilder.loadTexts: tripPeerStatisticsTable.setDescription("The TRIP peer stats table. This table contains one\nentry per remote TRIP peer, and statistics related to the\nconnection with the remote peer. The objects in this\ntable are volatile.")
tripPeerStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 5, 1))
if mibBuilder.loadTexts: tripPeerStatisticsEntry.setDescription("Entry containing information about the connection with\na TRIP peer.")
tripPeerInUpdates = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerInUpdates.setDescription("The number of TRIP update messages received from this\nremote peer since the last restart of this location\nserver.")
tripPeerOutUpdates = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerOutUpdates.setDescription("The number of TRIP update messages sent to this remote\npeer since the last restart of this LS.")
tripPeerInTotalMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerInTotalMessages.setDescription("The total number of TRIP messages received from the\nremote peer on this connection since the last restart\nof this LS.")
tripPeerOutTotalMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerOutTotalMessages.setDescription("The total number of outgoing TRIP messages sent to the\nremote peer since the last restart of this LS.")
tripPeerFsmEstablishedTransitions = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerFsmEstablishedTransitions.setDescription("The number of times the remote peer has transitioned\ninto the established state since the last restart of this\nLS.")
tripPeerFsmEstablishedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerFsmEstablishedTime.setDescription("Indicates the time and date that this remote peer entered\nthe 'established' state.")
tripPeerInUpdateElapsedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 7), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerInUpdateElapsedTime.setDescription("Elapsed time in hundredths of seconds since the last\nTRIP update message was received from this remote peer.")
tripPeerStateChangeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 5, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripPeerStateChangeTime.setDescription("The value of sysUpTime when the last state change of\ntripPeerState took place.")
tripRouteTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 6))
if mibBuilder.loadTexts: tripRouteTable.setDescription("The TRIP route table containing information about\nreachable routes that are to be added to service by the\nreceiving LS. The objects in this table are volatile\nand are refreshed when this LS rediscovers its route\ntable.")
tripRouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 6, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripRouteAppProtocol"), (0, "TRIP-MIB", "tripRouteAddressFamily"), (0, "TRIP-MIB", "tripRouteAddress"), (0, "TRIP-MIB", "tripRoutePeer"))
if mibBuilder.loadTexts: tripRouteEntry.setDescription("Information about a route to a called destination.")
tripRouteAppProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 1), TripAppProtocol()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteAppProtocol.setDescription("The protocol for which this entry of the routing table\nis maintained.")
tripRouteAddressFamily = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 2), TripAddressFamily()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteAddressFamily.setDescription("Specifies the type of address for the destination\nroute.")
tripRouteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 105))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteAddress.setDescription("This is the address (prefix) of the family type given\nby Address Family of the destination. It is the prefix\nof addresses reachable from this gateway via the next\nhop server. The SIZE value of 105 has been assigned due\nto the sub identifier of object types length limitation\nas defined in SMIv2.")
tripRoutePeer = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 4), TripId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRoutePeer.setDescription("The identifier of the peer where the route information\nwas learned.")
tripRouteTRIBMask = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 5), Bits().subtype(namedValues=namedval.NamedValues(("adjTribIns", 0), ("extTrib", 1), ("locTrib", 2), ("adjTribOut", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteTRIBMask.setDescription("Indicates which Telephony Routing Information Base (TRIB)\nthis entry belongs to. This is\na bit-map of possible types. If the bit has a value of\n1, then the entry is a member of the corresponding TRIB\ntype. If the bit has a value of 0 then the entry is not\na member of the TRIP type. The various bit positions\nare:\n\n0    adjTribIns     The entry is of type adj-TRIBs-ins,\n                    stores routing information that has\n                    been learned from inbound UPDATE\n                    messages.\n1    extTrib        The entry is of type ext-TRIB, the\n                    best route for a given destination.\n2    locTrib        The entry is of type loc-TRIB contains\n                    the local TRIP routing information\n                    that the LS has selected.\n3    adjTribOut     The entry is of type adj-TRIBs-out,\n                    stores the information that the local\n                    LS has selected for advertisement to\n                    its external peers.")
tripRouteAddressSequenceNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAddressSequenceNumber.setDescription("Indicates the version of the destination route\noriginated by the LS identified by\ntripRouteAddressOriginatorId intra-domain attribute.")
tripRouteAddressOriginatorId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 7), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAddressOriginatorId.setDescription("This is an intra-domain attribute indicating the\ninternal LS that originated the route into the ITAD.")
tripRouteNextHopServerIAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 8), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServerIAddrType.setDescription("The type of Inet Address of the tripRouteNextHopServer.")
tripRouteNextHopServer = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 9), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServer.setDescription("Indicates the next hop that messages of a given protocol\ndestined for tripRouteAddress SHOULD be sent to. The type\nof this address is determined by the value of the\ntripRouteNextHopServerIAddrType object.")
tripRouteNextHopServerPort = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 10), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServerPort.setDescription("The port of the next hop server that this route\nwill use.")
tripRouteNextHopServerItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 11), TripItad()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteNextHopServerItad.setDescription("Indicates the domain of the next hop.")
tripRouteMultiExitDisc = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteMultiExitDisc.setDescription("The Multiple Exit Discriminator allows an LS to\ndiscriminate between, and indicate preference for,\notherwise similar routes to a neighbouring domain.\nA higher value represents a more preferred routing\nobject.")
tripRouteLocalPref = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteLocalPref.setDescription("Indicated the local LS's degree of preference for an\nadvertised route destination.")
tripRouteAdvertisementPath = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 14), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 252))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAdvertisementPath.setDescription("Identifies the sequence of domains through which this\nadvertisement has passed.\n\nThis object is probably best represented as sequence of\nTripItads. For SMI compatibility, though, it is\nrepresented as an OCTET STRING. This object is a sequence\nof ITADs where each set of 4 octets corresponds to a TRIP\nITAD in network byte order.")
tripRouteRoutedPath = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 15), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 252))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteRoutedPath.setDescription("Identifies the ITADs through which messages sent using\nthis route would pass. These are a subset of\ntripRouteAdvertisementPath.\n\nThis object is probably best represented as sequence of\nTripItads. For SMI compatibility, though, it is\nrepresented as OCTET STRING.  This object is a sequence\nof ITADs where each set of 4 octets corresponds to a TRIP\nITAD in network byte order.")
tripRouteAtomicAggregate = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteAtomicAggregate.setDescription("Indicates that a route MAY traverse domains not listed\nin tripRouteRoutedPath. If an LS selects the less\nspecific route from a set of overlapping routes, then\nthis value returns TRUE.")
tripRouteUnknown = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 17), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteUnknown.setDescription("This object contains one or more attributes that were not\nunderstood, and because they were transitive, were dropped\nduring aggregation. They take the format of a triple\n<attribute type, attribute length, attribute value>, of\nvariable length. If no attributes were dropped, this\nreturns an OCTET STRING of size 0.")
tripRouteWithdrawn = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteWithdrawn.setDescription("Indicates if this route is to be removed from service\nby the receiving LS.")
tripRouteConverted = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 19), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteConverted.setDescription("Indicates if this route has been converted to a\ndifferent application protocol than it had originally.")
tripRouteReceivedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 6, 1, 20), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteReceivedTime.setDescription("The value of sysUpTime when this route was received.")
tripRouteCommunityTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 7))
if mibBuilder.loadTexts: tripRouteCommunityTable.setDescription("A table containing a list of TRIP communities associated\nwith a route. Each instance of tripRouteTypeEntry that has\nthe tripRouteTypePeer object set to remote(2) has an\ninstance in the tripRouteTable as a parent. The objects\nin this table are volatile and are refreshed after a\nreboot.")
tripRouteCommunityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 7, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripRouteAppProtocol"), (0, "TRIP-MIB", "tripRouteAddressFamily"), (0, "TRIP-MIB", "tripRouteAddress"), (0, "TRIP-MIB", "tripRoutePeer"), (0, "TRIP-MIB", "tripRouteCommunityId"))
if mibBuilder.loadTexts: tripRouteCommunityEntry.setDescription("Information about communities associated with a route.\nAn entry with a tripRouteAddress of 00 and a\ntripRoutePeer of 0 refers to the local LS.")
tripRouteCommunityId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 7, 1, 1), TripCommunityId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripRouteCommunityId.setDescription("The community identifier.")
tripRouteCommunityItad = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 7, 1, 2), TripItad()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripRouteCommunityItad.setDescription("The ITAD associated with this community.")
tripItadTopologyTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 8))
if mibBuilder.loadTexts: tripItadTopologyTable.setDescription("The sequence of link connections between peers within an\nITAD. The objects in this table are volatile and are\nrefreshed after a reboot.")
tripItadTopologyEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 8, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripItadTopologyOrigId"))
if mibBuilder.loadTexts: tripItadTopologyEntry.setDescription("Information about a peer of the LS identified by\ntripItadTopologyOrigId.")
tripItadTopologyOrigId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 8, 1, 1), TripId()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: tripItadTopologyOrigId.setDescription("Indicates the internal LS that originated the ITAD\ntopology information into the ITAD.")
tripItadTopologySeqNum = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 8, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripItadTopologySeqNum.setDescription("Indicates the version of the ITAD topology originated\nby the LS identified by tripItadTopologyOrigId.")
tripItadTopologyIdTable = MibTable((1, 3, 6, 1, 2, 1, 116, 1, 9))
if mibBuilder.loadTexts: tripItadTopologyIdTable.setDescription("The list of other LS's within the ITAD domain that the\nLS identified by tripItadTopologyOrigId is currently\npeering. Each instance of tripItadTopologyIdEntry has an\ninstance in the tripItadTopologyTable as a parent. The\nobjects in this table are volatile and are refreshed\nafter a reboot.")
tripItadTopologyIdEntry = MibTableRow((1, 3, 6, 1, 2, 1, 116, 1, 9, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "TRIP-MIB", "tripItadTopologyOrigId"), (0, "TRIP-MIB", "tripItadTopologyId"))
if mibBuilder.loadTexts: tripItadTopologyIdEntry.setDescription("Information about a peer to the LS identified by\ntripItadTopologyOrigId.")
tripItadTopologyId = MibTableColumn((1, 3, 6, 1, 2, 1, 116, 1, 9, 1, 1), TripId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tripItadTopologyId.setDescription("The index into this entry. Indicates the other location\nservers within the ITAD domain that this LS identified\nby tripItadTopologyOrigId is currently peering.")
tripMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 2))
tripMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 2, 1))
tripMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 2, 2))
tripMIBNotifObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 116, 3))
tripNotifApplIndex = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: tripNotifApplIndex.setDescription("This object contains the application Index. It is used\nto bind this notification with a specific instance of\nTRIP entity.")
tripNotifPeerAddrInetType = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 2), InetAddressType()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: tripNotifPeerAddrInetType.setDescription("The type of Inet Address of the tripNotifPeerAddr.")
tripNotifPeerAddr = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 3), InetAddress()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: tripNotifPeerAddr.setDescription("The IP address of this entry's TRIP peer LS. This object\ncontains the value of tripPeerRemoteAddr. The type of this\naddress is determined by the value of the\ntripNotifPeerAddrInetType object.")
tripNotifPeerErrCode = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,3,4,1,7,5,2,)).subtype(namedValues=namedval.NamedValues(("messageHeader", 1), ("openMessage", 2), ("updateMessage", 3), ("holdTimerExpired", 4), ("finiteStateMachine", 5), ("cease", 6), ("tripNotification", 7), ))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: tripNotifPeerErrCode.setDescription("Notification message of TRIP error. The meaning of this\nvalue is applicable to the following functions:\n\nmessageHeader(1)\n - All errors detected while processing the TRIP message\n   header.\n\nopenMessage(2)\n - All errors detected while processing the OPEN message.\n\nupdateMessage(3)\n - All errors detected while processing the UPDATE\n   message.\n\nholdTimerExpired(4)\n - A notification generated when the hold timer expires.\n\nfiniteStateMachine(5)\n - All errors detected by the TRIP Finite State Machine.\n\ncease(6)\n - Any fatal error condition that the rest of the values\n   do not cover.\n\ntripNotification(7)\n - Any error encountered while sending a notification\n   message.")
tripNotifPeerErrSubcode = MibScalar((1, 3, 6, 1, 2, 1, 116, 3, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: tripNotifPeerErrSubcode.setDescription("The sub error code associated with error code. The\n\n\n\nmeaning of this value is dependent on the value of\ntripNotifPeerErrCode.\n\nMessage Header (1) Error Subcodes:\n1 - Bad Message Length.\n2 - Bad Message Type.\n\nOPEN Message (2) Error Subcodes:\n1 - Unsupported Version Number.\n2 - Bad Peer ITAD.\n3 - Bad TRIP Identifier.\n4 - Unsupported Optional Parameter.\n5 - Unacceptable Hold Time.\n6 - Unsupported Capability.\n7 - Capability Mismatch.\n\nUPDATE Message (3) Error Subcodes:\n1 - Malformed Attribute List.\n2 - Unrecognized Well-known Attribute.\n3 - Missing Well-known Mandatory Attribute.\n4 - Attribute Flags Error.\n5 - Attribute Length Error.\n6 - Invalid Attribute.")

# Augmentions
tripPeerEntry.registerAugmentions(("TRIP-MIB", "tripPeerStatisticsEntry"))
tripPeerStatisticsEntry.setIndexNames(*tripPeerEntry.getIndexNames())

# Notifications

tripConnectionEstablished = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 1)).setObjects(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), )
if mibBuilder.loadTexts: tripConnectionEstablished.setDescription("The TRIP Connection Established event is generated when\nthe TRIP finite state machine enters the ESTABLISHED\nstate.")
tripConnectionDropped = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 2)).setObjects(("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), )
if mibBuilder.loadTexts: tripConnectionDropped.setDescription("The TRIP Connection Dropped event is generated when the\n\n\n\nTRIP finite state machine leaves the ESTABLISHED state.")
tripFSM = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 3)).setObjects(("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), )
if mibBuilder.loadTexts: tripFSM.setDescription("The trip FSM Event is generated when any error is\ndetected by the TRIP Finite State Machine.")
tripOpenMessageError = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 4)).setObjects(("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), )
if mibBuilder.loadTexts: tripOpenMessageError.setDescription("Errors detected while processing the OPEN message.")
tripUpdateMessageError = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 5)).setObjects(("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), )
if mibBuilder.loadTexts: tripUpdateMessageError.setDescription("Errors detected while processing the UPDATE message.")
tripHoldTimerExpired = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 6)).setObjects(("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), )
if mibBuilder.loadTexts: tripHoldTimerExpired.setDescription("The system does not receive successive messages within\nthe period specified by the negotiated Hold Time.")
tripConnectionCollision = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 7)).setObjects(("TRIP-MIB", "tripNotifApplIndex"), )
if mibBuilder.loadTexts: tripConnectionCollision.setDescription("A pair of LSs tried to simultaneously to establish a\ntransport connection to each other.")
tripCease = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 8)).setObjects(("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), ("TRIP-MIB", "tripNotifPeerAddr"), )
if mibBuilder.loadTexts: tripCease.setDescription("A TRIP peer MAY choose at any given time to close its TRIP\nconnection by sending this notification message. However,\nthe Cease notification message MUST NOT be used when a\nfatal error occurs.")
tripNotificationErr = NotificationType((1, 3, 6, 1, 2, 1, 116, 0, 9)).setObjects(("TRIP-MIB", "tripNotifApplIndex"), )
if mibBuilder.loadTexts: tripNotificationErr.setDescription("Generated if there is an error detected in a TRIP\nnotification message sent with another cause. Note that\nthe TRIP notification referred to in this object is not\nan SNMP notification, it is a specific message described\nin the TRIP specification.")

# Groups

tripConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 1)).setObjects(("TRIP-MIB", "tripSupportedCommunityItad"), ("TRIP-MIB", "tripCfgOperStatus"), ("TRIP-MIB", "tripCfgIdentifier"), ("TRIP-MIB", "tripCfgProtocolVersion"), ("TRIP-MIB", "tripCfgAdminStatus"), ("TRIP-MIB", "tripCfgPort"), ("TRIP-MIB", "tripRouteTypePeer"), ("TRIP-MIB", "tripCfgItad"), ("TRIP-MIB", "tripCfgAddrIAddrType"), ("TRIP-MIB", "tripCfgStorage"), ("TRIP-MIB", "tripCfgDisableTime"), ("TRIP-MIB", "tripSupportedCommunityStorage"), ("TRIP-MIB", "tripCfgMinRouteAdvertisementInterval"), ("TRIP-MIB", "tripCfgSendReceiveMode"), ("TRIP-MIB", "tripCfgMinItadOriginationInterval"), ("TRIP-MIB", "tripCfgAddr"), ("TRIP-MIB", "tripCfgMaxPurgeTime"), ("TRIP-MIB", "tripSupportedCommunityRowStatus"), )
if mibBuilder.loadTexts: tripConfigGroup.setDescription("The global objects for configuring trip.")
tripPeerTableConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 2)).setObjects(("TRIP-MIB", "tripPeerKeepAlive"), ("TRIP-MIB", "tripPeerStorage"), ("TRIP-MIB", "tripPeerKeepAliveConfigured"), ("TRIP-MIB", "tripPeerState"), ("TRIP-MIB", "tripPeerNegotiatedVersion"), ("TRIP-MIB", "tripPeerDisableTime"), ("TRIP-MIB", "tripPeerMaxPurgeTime"), ("TRIP-MIB", "tripPeerLearned"), ("TRIP-MIB", "tripPeerMaxRetryInterval"), ("TRIP-MIB", "tripPeerRowStatus"), ("TRIP-MIB", "tripPeerIdentifier"), ("TRIP-MIB", "tripPeerConnectRetryInterval"), ("TRIP-MIB", "tripPeerHoldTime"), ("TRIP-MIB", "tripPeerRemoteItad"), ("TRIP-MIB", "tripPeerHoldTimeConfigured"), ("TRIP-MIB", "tripPeerSendReceiveMode"), ("TRIP-MIB", "tripPeerAdminStatus"), )
if mibBuilder.loadTexts: tripPeerTableConfigGroup.setDescription("The global objects for configuring the TRIP peer\ntable.")
tripPeerTableStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 3)).setObjects(("TRIP-MIB", "tripPeerOutTotalMessages"), ("TRIP-MIB", "tripPeerFsmEstablishedTransitions"), ("TRIP-MIB", "tripPeerStateChangeTime"), ("TRIP-MIB", "tripPeerInUpdateElapsedTime"), ("TRIP-MIB", "tripPeerInUpdates"), ("TRIP-MIB", "tripPeerFsmEstablishedTime"), ("TRIP-MIB", "tripPeerOutUpdates"), ("TRIP-MIB", "tripPeerInTotalMessages"), )
if mibBuilder.loadTexts: tripPeerTableStatsGroup.setDescription("The global statistics the TRIP peer table.")
tripRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 4)).setObjects(("TRIP-MIB", "tripRouteNextHopServerPort"), ("TRIP-MIB", "tripRouteAddressOriginatorId"), ("TRIP-MIB", "tripRouteNextHopServerItad"), ("TRIP-MIB", "tripRouteLocalPref"), ("TRIP-MIB", "tripRouteAdvertisementPath"), ("TRIP-MIB", "tripRouteMultiExitDisc"), ("TRIP-MIB", "tripRouteAtomicAggregate"), ("TRIP-MIB", "tripRouteUnknown"), ("TRIP-MIB", "tripRouteAddressSequenceNumber"), ("TRIP-MIB", "tripRouteConverted"), ("TRIP-MIB", "tripRouteNextHopServer"), ("TRIP-MIB", "tripRouteTRIBMask"), ("TRIP-MIB", "tripRouteCommunityItad"), ("TRIP-MIB", "tripRouteReceivedTime"), ("TRIP-MIB", "tripRouteNextHopServerIAddrType"), ("TRIP-MIB", "tripRouteWithdrawn"), ("TRIP-MIB", "tripRouteRoutedPath"), )
if mibBuilder.loadTexts: tripRouteGroup.setDescription("The global objects for configuring route attribute.")
tripItadTopologyGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 5)).setObjects(("TRIP-MIB", "tripItadTopologySeqNum"), ("TRIP-MIB", "tripItadTopologyId"), )
if mibBuilder.loadTexts: tripItadTopologyGroup.setDescription("The objects that define the TRIP ITAD topology.")
tripNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 6)).setObjects(("TRIP-MIB", "tripConnectionDropped"), ("TRIP-MIB", "tripNotificationErr"), ("TRIP-MIB", "tripOpenMessageError"), ("TRIP-MIB", "tripFSM"), ("TRIP-MIB", "tripUpdateMessageError"), ("TRIP-MIB", "tripConnectionEstablished"), ("TRIP-MIB", "tripHoldTimerExpired"), ("TRIP-MIB", "tripConnectionCollision"), ("TRIP-MIB", "tripCease"), )
if mibBuilder.loadTexts: tripNotificationGroup.setDescription("A collection of notifications defined for TRIP.")
tripNotifObjectGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 116, 2, 2, 7)).setObjects(("TRIP-MIB", "tripNotifPeerErrCode"), ("TRIP-MIB", "tripNotifPeerErrSubcode"), ("TRIP-MIB", "tripNotifApplIndex"), ("TRIP-MIB", "tripNotifPeerAddr"), ("TRIP-MIB", "tripNotifPeerAddrInetType"), )
if mibBuilder.loadTexts: tripNotifObjectGroup.setDescription("The collection of objects that specify information for\nTRIP notifications.")

# Compliances

tripMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 116, 2, 1, 1)).setObjects(("TRIP-MIB", "tripNotificationGroup"), ("TRIP-MIB", "tripItadTopologyGroup"), ("TRIP-MIB", "tripNotifObjectGroup"), ("TRIP-MIB", "tripRouteGroup"), ("NETWORK-SERVICES-MIB", "applRFC2788Group"), ("TRIP-MIB", "tripPeerTableConfigGroup"), ("TRIP-MIB", "tripPeerTableStatsGroup"), ("TRIP-MIB", "tripConfigGroup"), )
if mibBuilder.loadTexts: tripMIBFullCompliance.setDescription("The compliance statement for TRIP entities that\nimplement this MIB module in read-write mode, such\nthat it can be used for both monitoring and configuring\nthe TRIP entity.\n\nThere is one INDEX object that cannot be represented in\nthe form of OBJECT clauses in SMIv2, but for which there\nis a compliance requirement, expressed in OBJECT clause\nform in this description:\n\n-- OBJECT      tripRouteTypeAddrInetType\n-- SYNTAX      InetAddressType (ipv4(1), ipv6(2),\n--                              ipv4z(3), ipv6z(4))\n-- DESCRIPTION\n--     This MIB requires support for global and\n--     non-global ipv4 and ipv6 addresses.\n--\n-- OBJECT      tripRouteTypeAddr\n-- SYNTAX      InetAddress (SIZE (4 | 8 | 16 | 20))\n-- DESCRIPTION\n--     This MIB requires support for global and\n--     non-global IPv4 and IPv6 addresses.\n--")
tripMIBReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 116, 2, 1, 2)).setObjects(("TRIP-MIB", "tripNotificationGroup"), ("TRIP-MIB", "tripItadTopologyGroup"), ("TRIP-MIB", "tripNotifObjectGroup"), ("TRIP-MIB", "tripRouteGroup"), ("NETWORK-SERVICES-MIB", "applRFC2788Group"), ("TRIP-MIB", "tripPeerTableConfigGroup"), ("TRIP-MIB", "tripPeerTableStatsGroup"), ("TRIP-MIB", "tripConfigGroup"), )
if mibBuilder.loadTexts: tripMIBReadOnlyCompliance.setDescription("The compliance statement for TRIP entities that\nimplement this MIB module in read only mode. Such TRIP\nentities can then only be monitored, but not be\nconfigured via this MIB module.\n\nIn read-only mode, the manager will not be able to add,\nremove or modify rows to any table, however the TRIP\napplication may modify, remove or add rows to a table.\n\nThere is one INDEX object that cannot be represented in\nthe form of OBJECT clauses in SMIv2, but for which there\nis a compliance requirement, expressed in OBJECT clause\nform in this description:\n\n-- OBJECT      tripRouteTypeAddrInetType\n-- SYNTAX      InetAddressType (ipv4(1), ipv6(2),\n--                              ipv4z(3), ipv6z(4))\n-- DESCRIPTION\n--     This MIB requires support for global and\n--     non-global ipv4 and ipv6 addresses.\n--\n-- OBJECT      tripRouteTypeAddr\n-- SYNTAX      InetAddress (SIZE (4 | 8 | 16 | 20))\n-- DESCRIPTION\n--     This MIB requires support for global and\n\n\n\n--     non-global IPv4 and IPv6 addresses.\n--")

# Exports

# Module identity
mibBuilder.exportSymbols("TRIP-MIB", PYSNMP_MODULE_ID=tripMIB)

# Objects
mibBuilder.exportSymbols("TRIP-MIB", tripMIB=tripMIB, tripMIBNotifications=tripMIBNotifications, tripMIBObjects=tripMIBObjects, tripCfgTable=tripCfgTable, tripCfgEntry=tripCfgEntry, tripCfgProtocolVersion=tripCfgProtocolVersion, tripCfgItad=tripCfgItad, tripCfgIdentifier=tripCfgIdentifier, tripCfgAdminStatus=tripCfgAdminStatus, tripCfgOperStatus=tripCfgOperStatus, tripCfgAddrIAddrType=tripCfgAddrIAddrType, tripCfgAddr=tripCfgAddr, tripCfgPort=tripCfgPort, tripCfgMinItadOriginationInterval=tripCfgMinItadOriginationInterval, tripCfgMinRouteAdvertisementInterval=tripCfgMinRouteAdvertisementInterval, tripCfgMaxPurgeTime=tripCfgMaxPurgeTime, tripCfgDisableTime=tripCfgDisableTime, tripCfgSendReceiveMode=tripCfgSendReceiveMode, tripCfgStorage=tripCfgStorage, tripRouteTypeTable=tripRouteTypeTable, tripRouteTypeEntry=tripRouteTypeEntry, tripRouteTypeAddrInetType=tripRouteTypeAddrInetType, tripRouteTypeAddr=tripRouteTypeAddr, tripRouteTypePort=tripRouteTypePort, tripRouteTypeProtocolId=tripRouteTypeProtocolId, tripRouteTypeAddrFamilyId=tripRouteTypeAddrFamilyId, tripRouteTypePeer=tripRouteTypePeer, tripSupportedCommunityTable=tripSupportedCommunityTable, tripSupportedCommunityEntry=tripSupportedCommunityEntry, tripSupportedCommunityId=tripSupportedCommunityId, tripSupportedCommunityItad=tripSupportedCommunityItad, tripSupportedCommunityStorage=tripSupportedCommunityStorage, tripSupportedCommunityRowStatus=tripSupportedCommunityRowStatus, tripPeerTable=tripPeerTable, tripPeerEntry=tripPeerEntry, tripPeerRemoteAddrInetType=tripPeerRemoteAddrInetType, tripPeerRemoteAddr=tripPeerRemoteAddr, tripPeerRemotePort=tripPeerRemotePort, tripPeerIdentifier=tripPeerIdentifier, tripPeerState=tripPeerState, tripPeerAdminStatus=tripPeerAdminStatus, tripPeerNegotiatedVersion=tripPeerNegotiatedVersion, tripPeerSendReceiveMode=tripPeerSendReceiveMode, tripPeerRemoteItad=tripPeerRemoteItad, tripPeerConnectRetryInterval=tripPeerConnectRetryInterval, tripPeerMaxRetryInterval=tripPeerMaxRetryInterval, tripPeerHoldTime=tripPeerHoldTime, tripPeerKeepAlive=tripPeerKeepAlive, tripPeerHoldTimeConfigured=tripPeerHoldTimeConfigured, tripPeerKeepAliveConfigured=tripPeerKeepAliveConfigured, tripPeerMaxPurgeTime=tripPeerMaxPurgeTime, tripPeerDisableTime=tripPeerDisableTime, tripPeerLearned=tripPeerLearned, tripPeerStorage=tripPeerStorage, tripPeerRowStatus=tripPeerRowStatus, tripPeerStatisticsTable=tripPeerStatisticsTable, tripPeerStatisticsEntry=tripPeerStatisticsEntry, tripPeerInUpdates=tripPeerInUpdates, tripPeerOutUpdates=tripPeerOutUpdates, tripPeerInTotalMessages=tripPeerInTotalMessages, tripPeerOutTotalMessages=tripPeerOutTotalMessages, tripPeerFsmEstablishedTransitions=tripPeerFsmEstablishedTransitions, tripPeerFsmEstablishedTime=tripPeerFsmEstablishedTime, tripPeerInUpdateElapsedTime=tripPeerInUpdateElapsedTime, tripPeerStateChangeTime=tripPeerStateChangeTime, tripRouteTable=tripRouteTable, tripRouteEntry=tripRouteEntry, tripRouteAppProtocol=tripRouteAppProtocol, tripRouteAddressFamily=tripRouteAddressFamily, tripRouteAddress=tripRouteAddress, tripRoutePeer=tripRoutePeer, tripRouteTRIBMask=tripRouteTRIBMask, tripRouteAddressSequenceNumber=tripRouteAddressSequenceNumber, tripRouteAddressOriginatorId=tripRouteAddressOriginatorId, tripRouteNextHopServerIAddrType=tripRouteNextHopServerIAddrType, tripRouteNextHopServer=tripRouteNextHopServer, tripRouteNextHopServerPort=tripRouteNextHopServerPort, tripRouteNextHopServerItad=tripRouteNextHopServerItad, tripRouteMultiExitDisc=tripRouteMultiExitDisc, tripRouteLocalPref=tripRouteLocalPref, tripRouteAdvertisementPath=tripRouteAdvertisementPath, tripRouteRoutedPath=tripRouteRoutedPath, tripRouteAtomicAggregate=tripRouteAtomicAggregate, tripRouteUnknown=tripRouteUnknown, tripRouteWithdrawn=tripRouteWithdrawn, tripRouteConverted=tripRouteConverted, tripRouteReceivedTime=tripRouteReceivedTime, tripRouteCommunityTable=tripRouteCommunityTable, tripRouteCommunityEntry=tripRouteCommunityEntry, tripRouteCommunityId=tripRouteCommunityId, tripRouteCommunityItad=tripRouteCommunityItad, tripItadTopologyTable=tripItadTopologyTable, tripItadTopologyEntry=tripItadTopologyEntry, tripItadTopologyOrigId=tripItadTopologyOrigId, tripItadTopologySeqNum=tripItadTopologySeqNum, tripItadTopologyIdTable=tripItadTopologyIdTable, tripItadTopologyIdEntry=tripItadTopologyIdEntry, tripItadTopologyId=tripItadTopologyId, tripMIBConformance=tripMIBConformance, tripMIBCompliances=tripMIBCompliances, tripMIBGroups=tripMIBGroups, tripMIBNotifObjects=tripMIBNotifObjects, tripNotifApplIndex=tripNotifApplIndex, tripNotifPeerAddrInetType=tripNotifPeerAddrInetType, tripNotifPeerAddr=tripNotifPeerAddr, tripNotifPeerErrCode=tripNotifPeerErrCode, tripNotifPeerErrSubcode=tripNotifPeerErrSubcode)

# Notifications
mibBuilder.exportSymbols("TRIP-MIB", tripConnectionEstablished=tripConnectionEstablished, tripConnectionDropped=tripConnectionDropped, tripFSM=tripFSM, tripOpenMessageError=tripOpenMessageError, tripUpdateMessageError=tripUpdateMessageError, tripHoldTimerExpired=tripHoldTimerExpired, tripConnectionCollision=tripConnectionCollision, tripCease=tripCease, tripNotificationErr=tripNotificationErr)

# Groups
mibBuilder.exportSymbols("TRIP-MIB", tripConfigGroup=tripConfigGroup, tripPeerTableConfigGroup=tripPeerTableConfigGroup, tripPeerTableStatsGroup=tripPeerTableStatsGroup, tripRouteGroup=tripRouteGroup, tripItadTopologyGroup=tripItadTopologyGroup, tripNotificationGroup=tripNotificationGroup, tripNotifObjectGroup=tripNotifObjectGroup)

# Compliances
mibBuilder.exportSymbols("TRIP-MIB", tripMIBFullCompliance=tripMIBFullCompliance, tripMIBReadOnlyCompliance=tripMIBReadOnlyCompliance)
