# PySNMP SMI module. Autogenerated from smidump -f python APM-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:06 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( OwnerString, rmon, ) = mibBuilder.importSymbols("RMON-MIB", "OwnerString", "rmon")
( protocolDirLocalIndex, ) = mibBuilder.importSymbols("RMON2-MIB", "protocolDirLocalIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32")
( DateAndTime, RowStatus, StorageType, TextualConvention, TimeInterval, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowStatus", "StorageType", "TextualConvention", "TimeInterval", "TimeStamp", "TruthValue")

# Types

class AppLocalIndex(Unsigned32):
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(1,2147483647)
    
class DataSourceOrZero(ObjectIdentifier):
    pass

class ProtocolDirNetworkAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,255)
    
class RmonClientID(Unsigned32):
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,4294967295)
    
class TransactionAggregationType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,1,3,4,)
    namedValues = namedval.NamedValues(("flows", 1), ("clients", 2), ("servers", 3), ("applications", 4), )
    

# Objects

apm = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 23)).setRevisions(("2004-02-19 00:00",))
if mibBuilder.loadTexts: apm.setOrganization("IETF RMON MIB Working Group")
if mibBuilder.loadTexts: apm.setContactInfo("Author:\nSteve Waldbusser\n\n\n\nPhone:  +1-650-948-6500\nFax :   +1-650-745-0671\nEmail:  waldbusser@nextbeacon.com\n\nWorking Group Chair:\nAndy Bierman\nCisco Systems, Inc.\nPostal: 170 West Tasman Drive\nSan Jose, CA USA 95134\nTel: +1 408 527-3711\nE-mail: abierman@cisco.com\n\nWorking Group Mailing List: <rmonmib@ietf.org>\nTo subscribe send email to: <rmonmib-request@ietf.org>")
if mibBuilder.loadTexts: apm.setDescription("The MIB module for measuring application performance\nas experienced by end-users.\n\nCopyright (C) The Internet Society (2004). This version of\nthis MIB module is part of RFC 3729; see the RFC itself for\nfull legal notices.")
apmNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 0))
apmMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 1))
apmAppDirTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 1))
if mibBuilder.loadTexts: apmAppDirTable.setDescription("The APM MIB directory of applications and application\nverbs. The agent will populate this table with all\napplications/verbs of any responsivenessType it has the\ncapability to monitor. Since the agent populates this table\nwith every entry it has the capability to monitor, the\nentries in this table are read-write, allowing the management\nstation to modify parameters in this table but not to add new\nentries or delete entries (however, entries may be\ndisabled). If new entries are added to the apmHttpFilterTable\nor the apmUserDefinedAppTable, the agent will add the\ncorresponding entries to this table.\n\nIt is an implementation-dependent matter as to how the agent\nsets these default parameters. For example, it may leave\ncertain entries in this table 'off(0)' if the agent developer\n\n\n\nbelieves that combination will be infrequently used, allowing\na manager that needs that capability to set it to 'on(1)'.\n\nSome applications are registered in the RMON2 protocol\ndirectory and some are registered in other tables in this\nMIB Module. Regardless of where an application is originally\nregistered, it is assigned an AppLocalIndex value that is the\nprimary index for this table.\n\nThe contents of this table affect all reports and exceptions\ngenerated by this agent. Accordingly, modification of this\ntable should be performed by a manager acting in the role of\nadministrator. In particular, management software should not\nrequire or enforce particular configuration of this table - it\nshould reflect the preferences of the site administrator, not\nthe software author. As a practical matter, this requires\nmanagement software to allow the administrator to configure\nthe values it will use so that it can be adapted to the site\npolicy.")
apmAppDirEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1)).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"))
if mibBuilder.loadTexts: apmAppDirEntry.setDescription("The APM MIB directory of applications and application\nverbs. An entry will exist in this table for all applications\nfor which application performance measurement is supported.")
apmAppDirAppLocalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 1), AppLocalIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmAppDirAppLocalIndex.setDescription("The AppLocalIndex assigned for this application Directory\nentry.")
apmAppDirResponsivenessType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("transactionOriented", 1), ("throughputOriented", 2), ("streamingOriented", 3), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmAppDirResponsivenessType.setDescription("This object describes and configures the agent's support for\napplication performance measurement for this application.\nThere are 3 types of measurements for different types of\napplications:\n\nTransaction-Oriented applications have a fairly constant\nworkload to perform for all transactions. The responsiveness\nmetric for transaction-oriented applications is application\nresponse time (from first request to final delivery of\nservice) and is measured in milliseconds. This is\ncommonly referred to as end-user response time.\n\nThroughput-Oriented applications have widely varying workloads\nbased on the nature of the client request. In particular,\nthroughput-oriented applications vary widely in the amount of\ndata that must be transported to satisfy the request. The\nresponsiveness metric for throughput-oriented applications is\nkilobits per second.\n\nStreaming-Oriented applications deliver data at a constant\nmetered rate of speed regardless of the responsiveness of the\nnetworking and computing infrastructure. This constant rate of\nspeed is generally specified to be below (sometimes well\nbelow) the nominal capability of the infrastructure. However,\nwhen the infrastructures cannot deliver data at this speed,\ninterruption of service or degradation of service can\nresult. The responsiveness metric for streaming-oriented\napplications is the ratio of time that the service is degraded\nor interrupted to the total service time. This metric is\nmeasured in parts per million.\n\nNote that for some applications, measuring more than one\nresponsiveness type may be interesting. For agents that wish\n\n\n\nto support more than one measurement for a application, they\nwill populate this table with multiple entries for that\napplication, one for each type.")
apmAppDirConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("off", 1), ("on", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirConfig.setDescription("This object describes and configures support for application\nperformance measurement for this application.\n\nIf the value of this object is on(2), the agent supports\nmeasurement of application performance metrics for this\napplication and is configured to measure such metrics for all\nAPM MIB functions and all interfaces.  If the value of this\nobject is off(1), the agent supports measurement of\napplication performance for this application but is configured\nto not measure these metrics for any APM MIB functions or\ninterfaces.  Whenever this value changes from on(2) to off(1),\nthe agent shall delete all related entries in all tables in\nthis MIB Module.\n\nThe value of this object must persist across reboots.")
apmAppDirResponsivenessBoundary1 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary1.setDescription("The boundary value between bucket1 and bucket 2. If this\nvalue is modified, all entries in the apmReportTable must be\ndeleted by the agent.\n\nThe value of this object must persist across reboots.")
apmAppDirResponsivenessBoundary2 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 5), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary2.setDescription("The boundary value between bucket2 and bucket 3. If this\n\n\n\nvalue is modified, all entries in the apmReportTable must be\ndeleted by the agent.\n\nThe value of this object must persist across reboots.")
apmAppDirResponsivenessBoundary3 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 6), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary3.setDescription("The boundary value between bucket3 and bucket 4. If this\nvalue is modified, all entries in the apmReportTable must be\ndeleted by the agent.\n\nThe value of this object must persist across reboots.")
apmAppDirResponsivenessBoundary4 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 7), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary4.setDescription("The boundary value between bucket4 and bucket 5. If this\nvalue is modified, all entries in the apmReportTable must be\ndeleted by the agent.\n\nThe value of this object must persist across reboots.")
apmAppDirResponsivenessBoundary5 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 8), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary5.setDescription("The boundary value between bucket5 and bucket 6. If this\nvalue is modified, all entries in the apmReportTable must be\ndeleted by the agent.\n\nThe value of this object must persist across reboots.")
apmAppDirResponsivenessBoundary6 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 1, 1, 9), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirResponsivenessBoundary6.setDescription("The boundary value between bucket6 and bucket 7. If this\n\n\n\nvalue is modified, all entries in the apmReportTable must be\ndeleted by the agent.\n\nThe value of this object must persist across reboots.")
apmBucketBoundaryLastChange = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmBucketBoundaryLastChange.setDescription("The value of sysUpTime the last time that any bucket boundary\nin any appDirEntry was changed. This object can help to\ndetermine if two managers are both trying to enforce different\nconfigurations of this table.")
apmAppDirID = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 3), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmAppDirID.setDescription("This object allows managers to avoid downloading application\ndirectory information when the directory is set to a known\n(usually fixed) configuration.\n\nIf the value of this object isn't 0.0, it signifies\nthat the entire contents of the apmAppDirTable,\napmHttpFilterTable, apmUserDefinedAppTable and\nprotocolDirTable are equal to a known state identified\nby the value of this object. If a manager recognizes this\nvalue as identifying a directory configuration it has a local\ncopy of, it may use this local copy rather than downloading\nthese tables. Note that it may have downloaded this local copy\n(and the ID) from another agent and used this copy for all\nother agents that advertised the same ID.\n\nIf an agent recognizes that the entire contents of the\napmAppDirTable, apmHttpFilterTable,\napmUserDefinedAppTable and protocolDirTable are equal to\na known state to which an ID has been assigned, it should set\nthis object to that ID.\n\nIn many cases when this feature is used, the application\ndirectory information will be in read-only memory and thus the\ntables may not be modified via SNMP requests. In the event\n\n\n\nthat the tables are writable and a modification is made, the\nagent is responsible for setting this object to 0.0 if it\ncannot determine that the state is equal to a known state.\n\nAn agent is not obligated to recognize and advertise all such\nregistered states as it may not have knowledge of all states.\nThus, a manager may encounter agents whose DirectoryID value\nis 0.0 even though the contents of the directory were equal to\na registered state.\n\nNote that the contents of those tables includes the\nprotocolDirLocalIndex and appLocalIndex values. In other\nwords, these values can't be assigned randomly on each agent,\nbut must be equal to values that are part of the known\nstate. While it is possible for a manager to download\napplication directory details using SNMP and to set the\nappropriate directoryID, the manager would need to have some\nscheme to ensure consistent values of LocalIndex variables\nfrom agent to agent. Such schemes are outside the scope of\nthis specification.\n\nApplication directory registrations are unique within an\nadministrative domain.\n\nTypically these registrations will be made by an agent\nsoftware developer who will set the application directory\ntables to a read-only state and assign a DirectoryID to that\nstate. Thus, all agents running this software would share the\nsame DirectoryID. As the application directory might change\nfrom one software release to the next, the developer may\nregister different DirectoryID's for each software release.\n\nA customer could also create a site-wide application directory\nconfiguration and assign a DirectoryID to that configuration\nas long as consistent values of LocalIndex variables can be\nensured.\n\nThe value of this object must persist across reboots.")
apmHttpFilterTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 4))
if mibBuilder.loadTexts: apmHttpFilterTable.setDescription("A table that creates virtual applications which measure the\nperformance of certain web pages or sets of web pages.\n\nWhen an entry is added to this table, the agent will\nautomatically create one or more entries in the\napmAppDirTable (one for each responsivenessType it is\ncapable of measuring).\n\nNote that when entries exist in this table some HTTP\ntransactions will be summarized twice: in applications\nrepresented here as well as the HTTP application. If entries\nin this table overlap, these transactions may be summarized\nadditional times.\n\nThe contents of this table affect all reports and exceptions\ngenerated by this agent. Accordingly, modification of this\ntable should be performed by a manager acting in the role of\nadministrator. In particular, management software should not\nrequire or enforce particular configuration of this table - it\nshould reflect the preferences of the site administrator, not\nthe software author.")
apmHttpFilterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1)).setIndexNames((0, "APM-MIB", "apmHttpFilterIndex"))
if mibBuilder.loadTexts: apmHttpFilterEntry.setDescription("A virtual application which measure the performance of certain\nweb pages or sets of web pages.")
apmHttpFilterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmHttpFilterIndex.setDescription("An index that uniquely identifies an entry in the\napmHttpFilterTable.")
apmHttpFilterAppLocalIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 2), AppLocalIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmHttpFilterAppLocalIndex.setDescription("The AppLocalIndex that represents HTTP transactions\nthat match this entry.\n\nThis object is read-only. A value is created by the agent from\nan unused AppLocalIndex value when this apmHttpFilterEntry is\ncreated.")
apmHttpFilterServerProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterServerProtocol.setDescription("The protocolDirLocalIndex value of the network level protocol\nof the apmHttpFilterServerAddress.")
apmHttpFilterServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 4), ProtocolDirNetworkAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterServerAddress.setDescription("This entry will only represent transactions coming from the\nnetwork address specified in this object.\n\n\n\n\nThis is represented as an octet string with\nspecific semantics and length as identified\nby the associated apmHttpFilterServerProtocol object.\n\nIf this object is the zero-length string, then this entry will\nmatch one of the addresses represented by the 'host' component\nof the associated apmHttpFilterURLPath object, where the\nformat if a URL [9] is\nhttp://<host>:<port>/<path>?<searchpart>.")
apmHttpFilterURLPath = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 5), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterURLPath.setDescription("This entry will only represent HTTP transactions\nwhere the URL path component in the request matches this\nvalue. This value represents the requested path regardless of\nany substitution that the server might perform.\n\nPrior to the matching, the URL is stripped of any server\naddress or DNS name and consists solely of the path name on\nthat server.\n\nIf the length of this object is zero, then this entry will\nmatch if the associated apmHttpFilterServerAddress match. If\nthe length of that object is also zero, then this entry will\nmatch nothing.\n\nThe value of the associated apmHttpFilterMatchType dictates\nthe type of matching that will be attempted.")
apmHttpFilterMatchType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("exact", 1), ("stripTrailingSlash", 2), ("prefix", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterMatchType.setDescription("The matching algorithm used to compare the URL pathname.\n\nIf the value is exact(1), then the pathname component will be\ncompared with the associated apmHttpFilterURLPath and\nwill only be associated with this entry if it matches exactly.\n\n\n\nIf the value is stripTrailingSlash(2), then the pathname\ncomponent will be compared with the associated\napmHttpFilterURLPath and will only be associated with this\nentry if it matches exactly or if the pathname ends with a '/'\nsymbol and matches apmHttpFilterURLPath if the '/' symbol is\nremoved from the pathname. This option exists for those paths\nwhere an optional trailing slash is possible but for which a\nprefix match would be too broad.\n\nIf the value is prefix(3), then the pathname component will be\ncompared with the associated apmHttpFilterURLPath and will\nonly be associated with this entry if the beginning of the\npathname matches every octet of this value. Octets that extend\nbeyond the length of this value are ignored.")
apmHttpFilterOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 7), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
apmHttpFilterStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 8), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterStorageType.setDescription("The storage type of this apmHttpFilterEntry. If the value of\nthis object is 'permanent', no objects in this row need to be\nwritable.")
apmHttpFilterRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 4, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmHttpFilterRowStatus.setDescription("The status of this apmHttpFilterEntry. No objects in this row\nmay be modified while the row's status is 'active'.")
apmHttpIgnoreUnregisteredURLs = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmHttpIgnoreUnregisteredURLs.setDescription("When true, APM measurements of HTTP transactions will only\nmeasure transactions relating to URLs that match a filter in\nthe apmHttpFilterTable. Thus, measurements for the HTTP\napplication will present aggregated statistics for\nURL-matching HTTP transactions and measurements for the HTTP\nGET application verb will present aggregated statistics for\nURL-matching HTTP GET transactions.\n\nThis will be used in environments that wish to monitor only\ntargeted URLs and to ignore large volumes of internet web\nbrowsing traffic.\n\nThis object affects all APM reports and exceptions generated\nby this agent. Accordingly, modification of this object should\nbe performed by a manager acting in the role of\nadministrator. In particular, management software should not\nrequire or enforce particular configuration of this object -\nit should reflect the preferences of the site administrator,\nnot the software author.\n\nThe value of this object must persist across reboots.")
apmHttp4xxIsFailure = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmHttp4xxIsFailure.setDescription("When true, this agent will recognize HTTP errors in the range\nof 400 through 499 and will treat them as unavailable\ntransactions. When false or when this object isn't supported,\nthey will be treated as successful transactions.\n\nThis object allows such error pages to be tracked at the\npossible expense of having user typos treated as poor service\non the part of the web server.\n\nThis object affects all reports and exceptions generated by\nthis agent. Accordingly, modification of this object should be\nperformed by a manager acting in the role of administrator. In\nparticular, management software should not require or enforce\nparticular configuration of this object - it should reflect\nthe preferences of the site administrator, not the software\nauthor.\n\nThe value of this object must persist across reboots.")
apmUserDefinedAppTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 7))
if mibBuilder.loadTexts: apmUserDefinedAppTable.setDescription("A table that advertises user-defined applications that the\nagent is measuring.\n\nThe agent will automatically create one or more entries in the\napmAppDirTable (one for each responsivenessType it is\ncapable of measuring) for each entry in this table.\n\nNote that when entries exist in this table some\ntransactions can be summarized more than once if there is\noverlap between applications defined here and applications\ndefined in the protocol directory or in the httpFilter table.")
apmUserDefinedAppEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 7, 1)).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"))
if mibBuilder.loadTexts: apmUserDefinedAppEntry.setDescription("A user-defined application that the agent is measuring, along\nwith its AppLocalIndex assignment.\n\nThe apmAppDirAppLocalIndex value in the index identifies\nthe agent-assigned AppLocalIndex value for this user-defined\napplication.")
apmUserDefinedAppParentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 7, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmUserDefinedAppParentIndex.setDescription("The protocolDirLocalIndex value of the highest-layer\nprotocol defined in the protocolDirTable that this\napplication is a child of.")
apmUserDefinedAppApplication = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 7, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmUserDefinedAppApplication.setDescription("A human readable descriptive tag for this application.")
apmNameTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 8))
if mibBuilder.loadTexts: apmNameTable.setDescription("A client machine may have multiple addresses during a period\nof monitoring. The apmNameTable assigns a long-lived\nidentifier to a client and records what addresses were\nassigned to that client for periods of time. Various\nimplementation techniques exist for tracking this mapping but\nif an agent is unable to track client address mappings, it may\nmap client identifiers to client addresses rather than to\ndistinct client machines.\n\nA particular apmNameClientID should be a constant attribute of\na particular client. When available, the agent may also record\nthe machine name and/or user name which may be valuable for\ndisplaying to humans. The apmNameMachineName and\napmNameUserName are relatively constant, changing only if\nthese attributes actually change on the client.\n\nThe agent will store a historical log of these entries, aging\nout old entries as the log becomes too large. Since this table\ncontains information vital to the interpretation of other\ntables (e.g., the apmReportTable), the agent should ensure that\n\n\n\nthe log doesn't age out entries that would be referenced by\ndata in those tables.\n\nNote that an entry for a clientID is active from its\nStartTime until the StartTime of another entry (for the same\nclientID) that supersedes it, or 'now' if none supersede\nit. Therefore, if a clientID only has a single entry, it is by\ndefinition very new and should never be aged out. No entry for\na clientID should be aged out unless it has been updated by a\nnew entry for the client (i.e., with an updated address) and\nonly if the new entry is 'old' enough.\n\nTo determine how old is old enough, compute the maximum value\nof Interval * (NumReports + 1) of all entries in the\napmReportControlTable (the '+ 1' is to allow a reasonable\nperiod of time for the report to be downloaded). Then take the\nlarger of this value and the age in seconds of the oldest\nentry in the current transaction table. If an entry for a\nclientID is superseded by another entry whose StartTime is\nmore than this many seconds ago, then the older entry may be\ndeleted.")
apmNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1)).setIndexNames((0, "APM-MIB", "apmNameClientID"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "APM-MIB", "apmNameClientAddress"), (0, "APM-MIB", "apmNameMappingStartTime"))
if mibBuilder.loadTexts: apmNameEntry.setDescription("An entry in the APM name table. An entry exists for each\nperiod of time that a client has been associated with a\nparticular address.\n\nThe protocolDirLocalIndex value in the index identifies\nthe network layer protocol for the ClientAddress for this\nentry.\n\nNote that some combinations of index values may result in an\nindex that exceeds 128 sub-identifiers in length which exceeds\nthe maximum for the SNMP protocol. Implementations should take\ncare to avoid such combinations.")
apmNameClientID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 1), RmonClientID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmNameClientID.setDescription("A unique ID assigned to the machine represented by this\nmapping. This ID is assigned by the agent using an\nimplementation-specific algorithm.")
apmNameClientAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 2), ProtocolDirNetworkAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmNameClientAddress.setDescription("The network client address for this client when this mapping\nwas active.\n\nThis is represented as an octet string with specific semantics\nand length as identified by the protocolDirLocalIndex\ncomponent of the index. This object may not be the zero length\nstring.\n\nSince this object is an index variable, it is encoded in the\nindex according to the index encoding rules.  For example, if\nthe protocolDirLocalIndex component of the index indicates an\nencapsulation of ip, this object is encoded as a length octet\nof 4, followed by the 4 octets of the ip address, in network\nbyte order. Care should be taken to avoid values of this\nobject that, in conjunction with the other index variables,\nwould result in an index longer than SNMP's maximum of 128\nsubidentifiers.")
apmNameMappingStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 3), DateAndTime()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmNameMappingStartTime.setDescription("The time that the agent first discovered this mapping\nas active.")
apmNameMachineName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 4), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmNameMachineName.setDescription("The human readable name of the client machine.\n\nIf the client has no machine name or the agent is\nunable to learn the machine name, this object will be\na zero-length string.")
apmNameUserName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 8, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmNameUserName.setDescription("The human readable name of a human user using the client\nmachine. If more than one user name are available\nsimultaneously, it is an implementation-dependent matter as to\nwhich is used here. However, if the user name changes, this\nobject should change to reflect that change.\n\nNon-human user names like 'root' or 'administrator' aren't\nintended as values for this object. If the client has no\nrecorded user name or the agent is unable to learn a user\nname, this object will be a zero-length string.")
apmReportControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 9))
if mibBuilder.loadTexts: apmReportControlTable.setDescription("Parameters that control the creation of a set of reports that\naggregate application performance.")
apmReportControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1)).setIndexNames((0, "APM-MIB", "apmReportControlIndex"))
if mibBuilder.loadTexts: apmReportControlEntry.setDescription("A conceptual row in the apmReportControlTable.\n\nAn example of the indexing of this table is\n\n\n\napmReportControlInterval.3")
apmReportControlIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmReportControlIndex.setDescription("An index that uniquely identifies an entry in the\napmReportControlTable.  Each such entry defines a unique\nreport whose results are placed in the apmReportTable on\nbehalf of this apmReportControlEntry.")
apmReportControlDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 2), DataSourceOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlDataSource.setDescription("The source of the data for APM Reports generated on\nbehalf of this apmReportControlEntry.\n\nIf the measurement is being performed by a probe, this should\nbe set to interface or port where data was received for\nanalysis. If the measurement isn't being performed by a probe,\nthis should be set to the primary interface over which the\nmeasurement is being performed. If the measurement isn't being\nperformed by a probe and there is no primary interface or this\n\n\n\ninformation isn't known, this object should be set to 0.0.\n\nThis object may not be modified if the associated\napmReportControlStatus object is equal to active(1).")
apmReportControlAggregationType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 3), TransactionAggregationType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlAggregationType.setDescription("The type of aggregation being performed for this set of\nreports.\n\nThe metrics for a single transaction are the responsiveness of\nthe transaction and whether the transaction succeeded (a\nboolean). When such metrics are aggregated in this MIB Module,\nthese metrics are replaced by averages and distributions of\nresponsiveness and availability. The metrics describing\naggregates are constant no matter which type of aggregation is\nbeing performed. These metrics may be found in the\napmReportTable.\n\nThe flows(1) aggregation is the simplest. All transactions\nthat share common application/server/client 3-tuples are\naggregated together, resulting in a set of metrics for all\nsuch unique 3-tuples.\n\nThe clients(2) aggregation results in somewhat more\naggregation (i.e., fewer resulting records). All transactions\nthat share common application/client tuples are aggregated\ntogether, resulting in a set of metrics for all such unique\ntuples.\n\nThe servers(3) aggregation usually results in still more\naggregation (i.e., fewer resulting records). All transactions\nthat share common application/server tuples are aggregated\ntogether, resulting in a set of metrics for all such unique\ntuples.\n\nThe applications(4) aggregation results in the most\naggregation (i.e., the fewest resulting records). All\n\n\n\ntransactions that share a common application are aggregated\ntogether, resulting in a set of metrics for all such unique\napplications.\n\nNote that it is not meaningful to aggregate applications, as\ndifferent applications have widely varying characteristics.\nAs a result, this set of aggregations is complete.\n\nThis object may not be modified if the associated\napmReportControlStatus object is equal to active(1).")
apmReportControlInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 4), Unsigned32().clone(3600)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlInterval.setDescription("The interval in seconds over which data is accumulated before\nbeing aggregated into a report in the apmReportTable.  All\nreports with the same apmReportControlIndex will be based on\nthe same interval. This object must be greater than zero.\n\nMany users desire that these reports be synchronized to within\nseconds of the beginning of the hour because the results may\nbe correlated more meaningfully to business behavior and so\nthat data from multiple agents is aggregated over the same\ntime periods. Thus management software may take extra effort\nto synchronize reports to the beginning of the hour and to one\nanother. However, the agent must not allow reports to 'drift'\nover time as they will quickly become unsynchronized. In\nparticular, if there is any fixed processing delay between\nreports, the reports should deduct this time from the interval\nso that reports don't drift.\n\nThis object may not be modified if the associated\napmReportControlStatus object is equal to active(1).")
apmReportControlRequestedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 5), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlRequestedSize.setDescription("The number of entries requested to be allocated for each\nreport generated on behalf of this entry.")
apmReportControlGrantedSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlGrantedSize.setDescription("The number of entries per report the agent has allocated\nbased on the requested amount in apmReportControlRequestedSize.\nSince multiple reports are saved, the total number of entries\nallocated will be this number multiplied by the value of\napmReportControlGrantedReports, or 1 if that object doesn't\nexist.\n\nWhen the associated apmReportControlRequestedSize object is\ncreated or modified, the agent should set this object as\nclosely to the requested value as is possible for the\nparticular implementation and available resources. When\nconsidering resources available, the agent must consider its\nability to allocate this many entries for all reports.\n\nNote that while the actual number of entries stored in the\nreports may fluctuate due to changing conditions, the agent\nmust continue to have storage available to satisfy the full\nreport size for all reports when necessary. Further, the agent\nmust not lower this value except as a result of a set to the\nassociated apmReportControlRequestedSize object.")
apmReportControlRequestedReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlRequestedReports.setDescription("The number of saved reports requested to be allocated on\nbehalf of this entry.")
apmReportControlGrantedReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 8), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlGrantedReports.setDescription("The number of saved reports the agent has allocated\nbased on the requested amount in\napmReportControlRequestedReports. Since each report can have\nmany entries, the total number of entries allocated will be\nthis number multiplied by the value of\napmReportControlGrantedSize, or 1 if that object doesn't\nexist.\n\n\n\nWhen the associated apmReportControlRequestedReports object is\ncreated or modified, the agent should set this object as\nclosely to the requested value as is possible for the\nparticular implementation and available resources. When\nconsidering resources available, the agent must consider its\nability to allocate this many reports each with the number of\nentries represented by apmReportControlGrantedSize, or 1 if\nthat object doesn't exist.\n\nNote that while the storage required for each report may\nfluctuate due to changing conditions, the agent must continue\nto have storage available to satisfy the full report size for\nall reports when necessary. Further, the agent must not lower\nthis value except as a result of a set to the associated\napmReportControlRequestedSize object.")
apmReportControlStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlStartTime.setDescription("The value of sysUpTime when the system began processing the\nreport in progress. Note that the report in progress is not\navailable.\n\nThis object may be used by the management station to figure\nout the start time for all previous reports saved for this\napmReportControlEntry, as reports are started at fixed\nintervals.")
apmReportControlReportNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 10), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlReportNumber.setDescription("The number of the report in progress. When an\napmReportControlEntry is activated, the first report will be\nnumbered one.")
apmReportControlDeniedInserts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlDeniedInserts.setDescription("The number of failed attempts to add an entry to reports for\n\n\n\nthis apmReportControlEntry because the number of entries\nwould have exceeded apmReportControlGrantedSize.\n\nThis number is valuable in determining if enough entries have\nbeen allocated for reports in light of fluctuating network\nusage. Note that since an entry that is denied will often be\nattempted again, this number will not predict the exact number\nof additional entries needed, but can be used to understand\nthe relative magnitude of the problem.\n\nAlso note that there is no ordering specified for the entries\nin the report, thus there are no rules for which entries will\nbe omitted when not enough entries are available. As a\nconsequence, the agent is not required to delete 'least\nvaluable' entries first.")
apmReportControlDroppedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportControlDroppedFrames.setDescription("The total number of frames which were received by the agent\nand therefore not accounted for in the *StatsDropEvents, but\nfor which the agent chose not to count for this entry for\nwhatever reason.  Most often, this event occurs when the agent\nis out of some resources and decides to shed load from this\ncollection.\n\nThis count does not include packets that were not counted\nbecause they had MAC-layer errors.\n\nThis counter is only relevant if this apm report is based on\na data source whose collection methodology is based on\nanalyzing network traffic.\n\nNote that if the apmReportTables are inactive because no\napplications are enabled in the application directory, this\nvalue should be 0.\n\nNote that, unlike the dropEvents counter, this number is the\nexact number of frames dropped.")
apmReportControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 13), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
apmReportControlStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 14), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlStorageType.setDescription("The storage type of this apmReportControlEntry. If the value\nof this object is 'permanent', no objects in this row need to\nbe writable.")
apmReportControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 9, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmReportControlStatus.setDescription("The status of this apmReportControlEntry.\n\nAn entry may not exist in the active state unless all\nobjects in the entry have an appropriate value. The only\nobjects in the entry that may be modified while the entry is\nin the active state are apmReportControlRequestedSize and\napmReportControlRequestedReports.\n\nIf this object is not equal to active(1), all\nassociated entries in the apmReportTable shall be deleted\nby the agent.")
apmReportTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 10))
if mibBuilder.loadTexts: apmReportTable.setDescription("The data resulting from aggregated APM reports. Consult the\ndefinition of apmReportControlAggregationType for the\ndefinition of the various types of aggregations.")
apmReportEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1)).setIndexNames((0, "APM-MIB", "apmReportControlIndex"), (0, "APM-MIB", "apmReportIndex"), (0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "APM-MIB", "apmReportServerAddress"), (0, "APM-MIB", "apmNameClientID"))
if mibBuilder.loadTexts: apmReportEntry.setDescription("A conceptual row in the apmReportTable.\nThe apmReportControlIndex value in the index identifies the\napmReportControlEntry on whose behalf this entry was created.\nThe apmReportIndex value in the index identifies which report\n(in the series of reports) this entry is a part of.\nThe apmAppDirAppLocalIndex value in the index identifies\nthe common application of the transactions aggregated in this\nentry.\nThe apmAppDirResponsivenessType value in the index\nidentifies the type of responsiveness metric reported by\nthis entry and uniquely identifies this entry when more\nthan one responsiveness metric is measured for a flow.\nEntries will only exist in this table for those\ncombinations of AppLocalIndex and ResponsivenessType\nthat are configured 'on(1)'.\nThe protocolDirLocalIndex value in the index identifies\nthe network layer protocol of the apmReportServerAddress.\nWhen the associated apmReportControlAggregationType value is\nequal to applications(4) or clients(2), this\nprotocolDirLocalIndex value will equal 0.\nThe apmReportServerAddress value in the index identifies the\nnetwork layer address of the server in transactions aggregated\nin this entry.\nThe apmNameClientID value in the index identifies the\nclient in transactions aggregated in this entry. If the\nassociated apmReportControlAggregationType is equal to\napplications(4) or servers(3), then this protocolDirLocalIndex\nvalue will equal 0.\n\nAn example of the indexing of this entry is\napmReportTransactionCount.3.15.3.1.8.4.192.168.1.2.3232235788\n\nNote that some combinations of index values may result in an\nindex that exceeds 128 sub-identifiers in length which exceeds\nthe maximum for the SNMP protocol. Implementations should take\ncare to avoid such combinations.")
apmReportIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmReportIndex.setDescription("The value of apmReportControlReportNumber for the report to\nwhich this entry belongs.")
apmReportServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 2), ProtocolDirNetworkAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmReportServerAddress.setDescription("The network server address for this apmReportEntry.\n\nThis is represented as an octet string with\nspecific semantics and length as identified\nby the protocolDirLocalIndex component of the index.\n\nSince this object is an index variable, it is encoded in the\nindex according to the index encoding rules.  For example, if\nthe protocolDirLocalIndex indicates an encapsulation of ip,\nthis object is encoded as a length octet of 4, followed by the\n4 octets of the ip address, in network byte order. Care\nshould be taken to avoid values of this object that, in\nconjunction with the other index variables, would result in an\nindex longer than SNMP's maximum of 128 subidentifiers.\n\nIf the associated apmReportControlAggregationType is equal to\napplications(4) or clients(2), then this object will be a null\nstring and will be encoded simply as a length octet of 0.")
apmReportTransactionCount = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportTransactionCount.setDescription("The total number of transactions aggregated into this record.")
apmReportSuccessfulTransactions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportSuccessfulTransactions.setDescription("The total number of successful transactions aggregated into\nthis record.")
apmReportResponsivenessMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessMean.setDescription("The arithmetic mean of the responsiveness metrics for all\nsuccessful transactions aggregated into this record.")
apmReportResponsivenessMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessMin.setDescription("The minimum of the responsiveness metrics for all\nsuccessful transactions aggregated into this record.")
apmReportResponsivenessMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessMax.setDescription("The maximum of the responsiveness metrics for all\nsuccessful transactions aggregated into this record.")
apmReportResponsivenessB1 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB1.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness was less than boundary1 value for\nthis application.")
apmReportResponsivenessB2 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB2.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness did not fall into Bucket 1 and was\ngreater than or equal to the boundary1 value for this\napplication and less than the boundary2 value for this\napplication.")
apmReportResponsivenessB3 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB3.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness did not fall into Bucket 1 or 2\nand as greater than or equal to the boundary2 value for this\napplication and less than the boundary3 value for this\napplication.")
apmReportResponsivenessB4 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB4.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness did not fall into Buckets 1\nthrough 3 and was greater than or equal to the boundary3 value\nfor this application and less than the boundary4 value for\nthis application.")
apmReportResponsivenessB5 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB5.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness did not fall into Buckets 1\nthrough 4 and was greater than or equal to the boundary4 value\nfor this application and less than the boundary5 value for\nthis application.")
apmReportResponsivenessB6 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB6.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness did not fall into Buckets 1\nthrough 5 and was greater than or equal to the\nboundary5 value for this application and less than the\nboundary6 value for this application.")
apmReportResponsivenessB7 = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 10, 1, 14), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmReportResponsivenessB7.setDescription("The number of successful transactions aggregated into this\nrecord whose responsiveness did not fall into Buckets 1\nthrough 6 and was greater than or equal to the boundary6 value\nfor this application.")
apmTransactionTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 11))
if mibBuilder.loadTexts: apmTransactionTable.setDescription("This table contains transactions that are currently running\nor have recently finished.")
apmTransactionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1)).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"), (0, "RMON2-MIB", "protocolDirLocalIndex"), (0, "APM-MIB", "apmTransactionServerAddress"), (0, "APM-MIB", "apmNameClientID"), (0, "APM-MIB", "apmTransactionID"))
if mibBuilder.loadTexts: apmTransactionEntry.setDescription("A conceptual row in the apmTransactionTable.\n\nThe apmAppDirAppLocalIndex value in the index identifies\nthe application of the transaction represented by this entry.\nThe apmAppDirResponsivenessType value in the index\nidentifies the type of responsiveness metric reported by\nthis entry and uniquely identifies this entry when more\nthan one responsiveness metric is measured for a flow.\nEntries will only exist in this table for those\ncombinations of AppLocalIndex and ResponsivenessType\nthat are configured 'on(1)'.\nThe protocolDirLocalIndex value in the index identifies\nthe network layer protocol of the apmTransactionServerAddress.\nThe apmTransactionServerAddress value in the index identifies\nthe network layer address of the server in the transaction\nrepresented by this entry.\nThe apmNameClientID value in the index identifies the\nclient in the transaction represented by this entry.\n\nAn example of the indexing of this entry is\napmTransactionCount.3.1.8.4.192.168.1.2.3232235788.2987\n\nNote that some combinations of index values may result in an\nindex that exceeds 128 sub-identifiers in length which exceeds\nthe maximum for the SNMP protocol. Implementations should take\ncare to avoid such combinations.")
apmTransactionServerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 1), ProtocolDirNetworkAddress().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmTransactionServerAddress.setDescription("The network server address for this apmTransactionEntry.\n\nThis is represented as an octet string with specific semantics\nand length as identified by the protocolDirLocalIndex\ncomponent of the index. This object may not be the zero length\nstring.\n\nFor example, if the protocolDirLocalIndex indicates an\nencapsulation of ip, this object is encoded as a length octet\nof 4, followed by the 4 octets of the ip address, in network\nbyte order. Care should be taken to avoid values of this\nobject that, in conjunction with the other index variables,\nwould result in an index longer than SNMP's maximum of 128\nsubidentifiers.")
apmTransactionID = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmTransactionID.setDescription("A unique value for this transaction amongst other\ntransactions sharing the same application layer protocol and\nserver and client addresses. Implementations may choose to use\nthe value of the client's source port, when possible.")
apmTransactionResponsiveness = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmTransactionResponsiveness.setDescription("The current value of the responsiveness metric for this\ntransaction. If this transaction has completed, the final\nvalue of the metric will be available.\n\nNote that this value may change over the lifetime of the\ntransaction and it is the final value of this metric that is\nrecorded as the responsiveness of the transaction for use in\nother APM MIB functions.")
apmTransactionAge = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 4), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmTransactionAge.setDescription("If this transaction is still executing, this value shall be\n\n\n\nthe length of time since it was started. If it has completed,\nthis value shall be the length of time it was executing.")
apmTransactionSuccess = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 11, 1, 5), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmTransactionSuccess.setDescription("The success of this transaction up to this time. Once a\ntransaction has been marked as failed, it cannot move back\ninto the successful state.")
apmTransactionsRequestedHistorySize = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 12), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmTransactionsRequestedHistorySize.setDescription("The maximum number of completed transactions desired to be\nretained in the apmTransactionTable. If the agent doesn't have\nenough resources to retain this many, it will retain as many as\npossible. Regardless of this value, the agent must attempt to\nkeep records for all current transactions it is monitoring.\n\nThe value of this object must persist across reboots.")
apmExceptionTable = MibTable((1, 3, 6, 1, 2, 1, 16, 23, 1, 13))
if mibBuilder.loadTexts: apmExceptionTable.setDescription("This table creates filters so that a management station can\nget immediate notification of a transaction that has had poor\n\n\n\navailability or responsiveness.\n\nEach apmExceptionEntry is associated with a particular type of\ntransaction and is applied to all transactions of that\ntype. Multiple apmExceptionEntries may be associated with a\nparticular type of transaction. A transaction type is\nidentified by the value of the apmAppDirAppLocalIndex\ncomponent of the index.\n\nBecause the quality of a transaction is not known until it is\ncompleted, these thresholds are only applied after the\ntransaction has completed.")
apmExceptionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1)).setIndexNames((0, "APM-MIB", "apmAppDirAppLocalIndex"), (0, "APM-MIB", "apmAppDirResponsivenessType"), (0, "APM-MIB", "apmExceptionIndex"))
if mibBuilder.loadTexts: apmExceptionEntry.setDescription("A conceptual row in the apmExceptionTable.\n\nThe apmAppDirAppLocalIndex value in the index identifies\nthe application this entry will monitor.\nThe apmAppDirResponsivenessType value in the index\nidentifies the type of responsiveness metric this entry will\nmonitor.")
apmExceptionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apmExceptionIndex.setDescription("An index that uniquely identifies an entry in the\napmExceptionTable amongst other entries with equivalent index\nvalues for apmAppDirAppLocalIndex and\napmAppDirResponsivenessType. Each such entry sets up\nthresholds for a particular measurement of a particular\napplication.")
apmExceptionResponsivenessComparison = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("greater", 2), ("less", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionResponsivenessComparison.setDescription("If this value is greater(2) or less(3), the associated\napmExceptionResponsivenessThreshold will be compared to this\nvalue and an exception will be created if the responsiveness\nis greater than the threshold (greater(2)) or less than the\nthreshold (less(3)).")
apmExceptionResponsivenessThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 3), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionResponsivenessThreshold.setDescription("The threshold that responsiveness metrics are compared to.")
apmExceptionUnsuccessfulException = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("off", 1), ("on", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionUnsuccessfulException.setDescription("If this value is on(2), an exception will be created if a\ntransaction of the associated type is unsuccessful.")
apmExceptionResponsivenessEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmExceptionResponsivenessEvents.setDescription("The total number of responsiveness exceptions generated. This\ncounter will be incremented even if no notification was sent\ndue to notifications not being configured or due to exceeding\nthe apmNotificationMaxRate value.")
apmExceptionUnsuccessfulEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apmExceptionUnsuccessfulEvents.setDescription("The total number of unsuccessful exceptions generated. This\ncounter will be incremented even if no notification was sent\ndue to notifications not being configured or due to exceeding\nthe apmNotificationMaxRate value.")
apmExceptionOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 7), OwnerString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
apmExceptionStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 8), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionStorageType.setDescription("The storage type of this apmReportControlEntry. If the value\nof this object is 'permanent', no objects in this row need to\nbe writable.")
apmExceptionStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 23, 1, 13, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apmExceptionStatus.setDescription("The status of this apmExceptionEntry. The only objects in the\nentry that may be modified while the entry is in the active\nstate are apmExceptionResponsivenessComparison,\napmExceptionResponsivenessThreshold and\napmExceptionUnsuccessfulException.")
apmThroughputExceptionMinTime = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 14), Unsigned32().clone(10)).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: apmThroughputExceptionMinTime.setDescription("Because the responsiveness for throughput-oriented\ntransactions is divided by the elapsed time, it can be very\nsensitive to short-term performance variations for\ntransactions that take a short period of time. For example,\nwhen downloading a very short file, a single dropped packet\ncould double or triple the total response time.\n\nFurther, throughput is usually examined for applications that\ntransfer a lot of data, and when doing so it is helpful to\nconceptualize transaction costs that are proportional to the\namount of data separately from those costs that are relatively\nfixed (i.e., independent of the amount of data).  For very\nshort transactions, these fixed transaction costs (handshake,\nsetup time, authentication, round-trip time) may dominate the\ntotal response time for the transaction, resulting in\nthroughput measurements that aren't really proportional to the\nnetwork's, server's and client's combined data throughput\ncapability.\n\nThis object controls the minimum number of seconds that an\nthroughput-based transaction must exceed before an exception\ncan be generated for it. If this object is set to zero, then\nall throughput-based transactions are candidates for\nexceptions.\n\nThe value of this object must persist across reboots.")
apmNotificationMaxRate = MibScalar((1, 3, 6, 1, 2, 1, 16, 23, 1, 15), Unsigned32().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apmNotificationMaxRate.setDescription("The maximum number of notifications that can be generated\nfrom this agent by the apmExceptionTable in any 60 second\nperiod.\n\nThe value of this object must persist across reboots.")
apmConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 2))
apmCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 2, 1))
apmGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 23, 2, 2))

# Augmentions

# Notifications

apmTransactionResponsivenessAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 23, 0, 1)).setObjects(("APM-MIB", "apmExceptionResponsivenessThreshold"), ("APM-MIB", "apmTransactionResponsiveness"), )
if mibBuilder.loadTexts: apmTransactionResponsivenessAlarm.setDescription("Notification sent when a transaction exceeds a threshold\ndefined in the apmException table. The index of the\nincluded apmExceptionResponsivenessThreshold object identifies\nthe apmExceptionEntry that specified the threshold. The\napmTransactionResponsiveness variable identifies the actual\ntransaction and its responsiveness.\n\nAgent implementors are urged to include additional data\nobjects in the alarm that may explain the reason for the\nalarm. It is helpful to include such data in the alarm because\nit describes the situation at the time the alarm was\ngenerated, where polls after the fact may not provide\nmeaningful information. Examples of such information are CPU\nload, memory utilization, network utilization, and transaction\nstatistics.")
apmTransactionUnsuccessfulAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 23, 0, 2)).setObjects(("APM-MIB", "apmExceptionResponsivenessThreshold"), )
if mibBuilder.loadTexts: apmTransactionUnsuccessfulAlarm.setDescription("Notification sent when a transaction is unsuccessful.\nThe index of the included apmExceptionResponsivenessThreshold\nobject identifies both the type of the transaction that caused\nthis notification as well as the apmExceptionEntry that\nspecified the threshold.\n\nAgent implementors are urged to include additional data\nobjects in the alarm that may explain the reason for the\nalarm. It is helpful to include such data in the alarm because\nit describes the situation at the time the alarm was\ngenerated, where polls after the fact may not provide\nmeaningful information. Examples of such information are CPU\nload, memory utilization, network utilization, and transaction\nstatistics.")

# Groups

apmAppDirGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 1)).setObjects(("APM-MIB", "apmAppDirID"), ("APM-MIB", "apmAppDirResponsivenessBoundary1"), ("APM-MIB", "apmAppDirResponsivenessBoundary3"), ("APM-MIB", "apmAppDirResponsivenessBoundary2"), ("APM-MIB", "apmAppDirResponsivenessBoundary5"), ("APM-MIB", "apmAppDirResponsivenessBoundary4"), ("APM-MIB", "apmAppDirResponsivenessBoundary6"), ("APM-MIB", "apmNameUserName"), ("APM-MIB", "apmNameMachineName"), ("APM-MIB", "apmAppDirConfig"), ("APM-MIB", "apmBucketBoundaryLastChange"), )
if mibBuilder.loadTexts: apmAppDirGroup.setDescription("The APM MIB directory of applications and application verbs.")
apmUserDefinedApplicationsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 2)).setObjects(("APM-MIB", "apmHttpFilterServerProtocol"), ("APM-MIB", "apmHttpFilterServerAddress"), ("APM-MIB", "apmUserDefinedAppApplication"), ("APM-MIB", "apmHttp4xxIsFailure"), ("APM-MIB", "apmHttpFilterStorageType"), ("APM-MIB", "apmHttpIgnoreUnregisteredURLs"), ("APM-MIB", "apmHttpFilterRowStatus"), ("APM-MIB", "apmHttpFilterMatchType"), ("APM-MIB", "apmHttpFilterAppLocalIndex"), ("APM-MIB", "apmUserDefinedAppParentIndex"), ("APM-MIB", "apmHttpFilterOwner"), ("APM-MIB", "apmHttpFilterURLPath"), )
if mibBuilder.loadTexts: apmUserDefinedApplicationsGroup.setDescription("Objects used for creating and managing user-defined\napplications.")
apmReportGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 3)).setObjects(("APM-MIB", "apmReportSuccessfulTransactions"), ("APM-MIB", "apmReportControlGrantedSize"), ("APM-MIB", "apmReportControlDataSource"), ("APM-MIB", "apmReportControlRequestedSize"), ("APM-MIB", "apmReportControlStorageType"), ("APM-MIB", "apmReportControlGrantedReports"), ("APM-MIB", "apmReportResponsivenessB6"), ("APM-MIB", "apmReportResponsivenessB7"), ("APM-MIB", "apmReportControlDroppedFrames"), ("APM-MIB", "apmReportResponsivenessB5"), ("APM-MIB", "apmReportResponsivenessB2"), ("APM-MIB", "apmReportResponsivenessB3"), ("APM-MIB", "apmReportResponsivenessB1"), ("APM-MIB", "apmReportControlInterval"), ("APM-MIB", "apmReportControlAggregationType"), ("APM-MIB", "apmReportResponsivenessMean"), ("APM-MIB", "apmReportControlReportNumber"), ("APM-MIB", "apmReportControlOwner"), ("APM-MIB", "apmReportResponsivenessMin"), ("APM-MIB", "apmReportControlStartTime"), ("APM-MIB", "apmReportTransactionCount"), ("APM-MIB", "apmReportControlRequestedReports"), ("APM-MIB", "apmReportControlStatus"), ("APM-MIB", "apmReportResponsivenessMax"), ("APM-MIB", "apmReportControlDeniedInserts"), ("APM-MIB", "apmReportResponsivenessB4"), )
if mibBuilder.loadTexts: apmReportGroup.setDescription("The apm report group controls the creation and retrieval of\nreports that aggregate application performance.")
apmTransactionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 4)).setObjects(("APM-MIB", "apmTransactionSuccess"), ("APM-MIB", "apmTransactionsRequestedHistorySize"), ("APM-MIB", "apmTransactionAge"), ("APM-MIB", "apmTransactionResponsiveness"), )
if mibBuilder.loadTexts: apmTransactionGroup.setDescription("The apm transaction group contains statistics for\nindividual transactions.")
apmExceptionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 5)).setObjects(("APM-MIB", "apmExceptionStorageType"), ("APM-MIB", "apmExceptionUnsuccessfulException"), ("APM-MIB", "apmExceptionResponsivenessComparison"), ("APM-MIB", "apmNotificationMaxRate"), ("APM-MIB", "apmExceptionOwner"), ("APM-MIB", "apmThroughputExceptionMinTime"), ("APM-MIB", "apmExceptionStatus"), ("APM-MIB", "apmExceptionUnsuccessfulEvents"), ("APM-MIB", "apmExceptionResponsivenessThreshold"), ("APM-MIB", "apmExceptionResponsivenessEvents"), )
if mibBuilder.loadTexts: apmExceptionGroup.setDescription("The apm exception group causes notifications to be sent\nwhenever transactions are detected that had poor availability\nor responsiveness.")
apmNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 16, 23, 2, 2, 6)).setObjects(("APM-MIB", "apmTransactionUnsuccessfulAlarm"), ("APM-MIB", "apmTransactionResponsivenessAlarm"), )
if mibBuilder.loadTexts: apmNotificationGroup.setDescription("Notifications sent by an APM MIB agent.")

# Compliances

apmCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 23, 2, 1, 1)).setObjects(("APM-MIB", "apmReportGroup"), ("APM-MIB", "apmNotificationGroup"), ("APM-MIB", "apmExceptionGroup"), ("APM-MIB", "apmUserDefinedApplicationsGroup"), ("APM-MIB", "apmAppDirGroup"), ("APM-MIB", "apmTransactionGroup"), )
if mibBuilder.loadTexts: apmCompliance.setDescription("Describes the requirements for conformance to\nthe APM MIB")

# Exports

# Module identity
mibBuilder.exportSymbols("APM-MIB", PYSNMP_MODULE_ID=apm)

# Types
mibBuilder.exportSymbols("APM-MIB", AppLocalIndex=AppLocalIndex, DataSourceOrZero=DataSourceOrZero, ProtocolDirNetworkAddress=ProtocolDirNetworkAddress, RmonClientID=RmonClientID, TransactionAggregationType=TransactionAggregationType)

# Objects
mibBuilder.exportSymbols("APM-MIB", apm=apm, apmNotifications=apmNotifications, apmMibObjects=apmMibObjects, apmAppDirTable=apmAppDirTable, apmAppDirEntry=apmAppDirEntry, apmAppDirAppLocalIndex=apmAppDirAppLocalIndex, apmAppDirResponsivenessType=apmAppDirResponsivenessType, apmAppDirConfig=apmAppDirConfig, apmAppDirResponsivenessBoundary1=apmAppDirResponsivenessBoundary1, apmAppDirResponsivenessBoundary2=apmAppDirResponsivenessBoundary2, apmAppDirResponsivenessBoundary3=apmAppDirResponsivenessBoundary3, apmAppDirResponsivenessBoundary4=apmAppDirResponsivenessBoundary4, apmAppDirResponsivenessBoundary5=apmAppDirResponsivenessBoundary5, apmAppDirResponsivenessBoundary6=apmAppDirResponsivenessBoundary6, apmBucketBoundaryLastChange=apmBucketBoundaryLastChange, apmAppDirID=apmAppDirID, apmHttpFilterTable=apmHttpFilterTable, apmHttpFilterEntry=apmHttpFilterEntry, apmHttpFilterIndex=apmHttpFilterIndex, apmHttpFilterAppLocalIndex=apmHttpFilterAppLocalIndex, apmHttpFilterServerProtocol=apmHttpFilterServerProtocol, apmHttpFilterServerAddress=apmHttpFilterServerAddress, apmHttpFilterURLPath=apmHttpFilterURLPath, apmHttpFilterMatchType=apmHttpFilterMatchType, apmHttpFilterOwner=apmHttpFilterOwner, apmHttpFilterStorageType=apmHttpFilterStorageType, apmHttpFilterRowStatus=apmHttpFilterRowStatus, apmHttpIgnoreUnregisteredURLs=apmHttpIgnoreUnregisteredURLs, apmHttp4xxIsFailure=apmHttp4xxIsFailure, apmUserDefinedAppTable=apmUserDefinedAppTable, apmUserDefinedAppEntry=apmUserDefinedAppEntry, apmUserDefinedAppParentIndex=apmUserDefinedAppParentIndex, apmUserDefinedAppApplication=apmUserDefinedAppApplication, apmNameTable=apmNameTable, apmNameEntry=apmNameEntry, apmNameClientID=apmNameClientID, apmNameClientAddress=apmNameClientAddress, apmNameMappingStartTime=apmNameMappingStartTime, apmNameMachineName=apmNameMachineName, apmNameUserName=apmNameUserName, apmReportControlTable=apmReportControlTable, apmReportControlEntry=apmReportControlEntry, apmReportControlIndex=apmReportControlIndex, apmReportControlDataSource=apmReportControlDataSource, apmReportControlAggregationType=apmReportControlAggregationType, apmReportControlInterval=apmReportControlInterval, apmReportControlRequestedSize=apmReportControlRequestedSize, apmReportControlGrantedSize=apmReportControlGrantedSize, apmReportControlRequestedReports=apmReportControlRequestedReports, apmReportControlGrantedReports=apmReportControlGrantedReports, apmReportControlStartTime=apmReportControlStartTime, apmReportControlReportNumber=apmReportControlReportNumber, apmReportControlDeniedInserts=apmReportControlDeniedInserts, apmReportControlDroppedFrames=apmReportControlDroppedFrames, apmReportControlOwner=apmReportControlOwner, apmReportControlStorageType=apmReportControlStorageType, apmReportControlStatus=apmReportControlStatus, apmReportTable=apmReportTable, apmReportEntry=apmReportEntry, apmReportIndex=apmReportIndex, apmReportServerAddress=apmReportServerAddress, apmReportTransactionCount=apmReportTransactionCount, apmReportSuccessfulTransactions=apmReportSuccessfulTransactions, apmReportResponsivenessMean=apmReportResponsivenessMean, apmReportResponsivenessMin=apmReportResponsivenessMin, apmReportResponsivenessMax=apmReportResponsivenessMax, apmReportResponsivenessB1=apmReportResponsivenessB1, apmReportResponsivenessB2=apmReportResponsivenessB2, apmReportResponsivenessB3=apmReportResponsivenessB3, apmReportResponsivenessB4=apmReportResponsivenessB4, apmReportResponsivenessB5=apmReportResponsivenessB5, apmReportResponsivenessB6=apmReportResponsivenessB6, apmReportResponsivenessB7=apmReportResponsivenessB7, apmTransactionTable=apmTransactionTable, apmTransactionEntry=apmTransactionEntry, apmTransactionServerAddress=apmTransactionServerAddress, apmTransactionID=apmTransactionID, apmTransactionResponsiveness=apmTransactionResponsiveness, apmTransactionAge=apmTransactionAge, apmTransactionSuccess=apmTransactionSuccess, apmTransactionsRequestedHistorySize=apmTransactionsRequestedHistorySize, apmExceptionTable=apmExceptionTable, apmExceptionEntry=apmExceptionEntry, apmExceptionIndex=apmExceptionIndex, apmExceptionResponsivenessComparison=apmExceptionResponsivenessComparison, apmExceptionResponsivenessThreshold=apmExceptionResponsivenessThreshold, apmExceptionUnsuccessfulException=apmExceptionUnsuccessfulException, apmExceptionResponsivenessEvents=apmExceptionResponsivenessEvents, apmExceptionUnsuccessfulEvents=apmExceptionUnsuccessfulEvents, apmExceptionOwner=apmExceptionOwner, apmExceptionStorageType=apmExceptionStorageType, apmExceptionStatus=apmExceptionStatus, apmThroughputExceptionMinTime=apmThroughputExceptionMinTime, apmNotificationMaxRate=apmNotificationMaxRate, apmConformance=apmConformance, apmCompliances=apmCompliances, apmGroups=apmGroups)

# Notifications
mibBuilder.exportSymbols("APM-MIB", apmTransactionResponsivenessAlarm=apmTransactionResponsivenessAlarm, apmTransactionUnsuccessfulAlarm=apmTransactionUnsuccessfulAlarm)

# Groups
mibBuilder.exportSymbols("APM-MIB", apmAppDirGroup=apmAppDirGroup, apmUserDefinedApplicationsGroup=apmUserDefinedApplicationsGroup, apmReportGroup=apmReportGroup, apmTransactionGroup=apmTransactionGroup, apmExceptionGroup=apmExceptionGroup, apmNotificationGroup=apmNotificationGroup)

# Compliances
mibBuilder.exportSymbols("APM-MIB", apmCompliance=apmCompliance)
