# PySNMP SMI module. Autogenerated from smidump -f python APPLETALK-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:07 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( Bits, Counter32, Integer32, Integer32, IpAddress, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "IpAddress", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString")

# Types

class ATName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,32)
    
class ATNetworkNumber(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(2,2)
    fixedLength = 2
    
class DdpNodeAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(3,3)
    fixedLength = 3
    
class DdpSocketAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(4,4)
    fixedLength = 4
    

# Objects

appletalk = MibIdentifier((1, 3, 6, 1, 2, 1, 13))
llap = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 1))
llapTable = MibTable((1, 3, 6, 1, 2, 1, 13, 1, 1))
if mibBuilder.loadTexts: llapTable.setDescription("The list of LLAP entries.")
llapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 1, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "llapIfIndex"))
if mibBuilder.loadTexts: llapEntry.setDescription("An LLAP entry containing objects for the LocalTalk\nLink Access Protocol for a particular LocalTalk\ninterface.\n\nAs an example, an instance of the llapOutPkts object\nmight be named llapOutPks.1")
llapIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapIfIndex.setDescription("The LLAP interface to which this entry pertains.\nThe interface identified by a particular value of\nthis index is the same interface as identified\nby the same value of ifIndex.")
llapInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapInPkts.setDescription("The total number of good data packets received on\nthis LocalTalk interface.")
llapOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapOutPkts.setDescription("The total number of data packets transmitted on\nthis LocalTalk interface.")
llapInNoHandlers = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapInNoHandlers.setDescription("The total number of good packets received on this\nLocalTalk interface for which there was no protocol\nhandler.")
llapInLengthErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapInLengthErrors.setDescription("The total number of packets received on this LocalTalk\ninterface whose actual length did not match the length\nin the header.")
llapInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapInErrors.setDescription("The total number of packets containing errors received\non this LocalTalk interface.")
llapCollisions = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapCollisions.setDescription("The total number of collisions assumed on this\nLocalTalk interface due to the lack of a lapCTS reply.")
llapDefers = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapDefers.setDescription("The total number of times this LocalTalk interface\ndeferred to other packets.")
llapNoDataErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapNoDataErrors.setDescription("The total number of times this LocalTalk interface\nreceived a lapRTS packet and expected a data packet,\nbut did not receive any data packet.")
llapRandomCTSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapRandomCTSErrors.setDescription("The total number of times this LocalTalk interface\nreceived a lapCTS packet that was not solicited by a\nlapRTS packet.")
llapFCSErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 1, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: llapFCSErrors.setDescription("The total number of times this LocalTalk interface\nreceived a packet with an FCS (Frame Check Sequence)\nerror.")
aarp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 2))
aarpTable = MibTable((1, 3, 6, 1, 2, 1, 13, 2, 1))
if mibBuilder.loadTexts: aarpTable.setDescription("The AppleTalk Address Translation Table contains an\nequivalence of AppleTalk Network Addresses to the link\nlayer physical address.")
aarpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 2, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "aarpIfIndex"), (0, "APPLETALK-MIB", "aarpNetAddress"))
if mibBuilder.loadTexts: aarpEntry.setDescription("Each entry contains one AppleTalk Network Address to\nphysical address equivalence.\n\nAs an example, an instance of the aarpPhysAddress\nobject might be named aarpPhysAddress.1.0.80.234")
aarpIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 2, 1, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aarpIfIndex.setDescription("The interface on which this entry's equivalence is\neffective.  The interface identified by a particular\nvalue of this index is the same interface as\nidentified by the same value of ifIndex.")
aarpPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 2, 1, 1, 2), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: aarpPhysAddress.setDescription("The media-dependent physical address.")
aarpNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 2, 1, 1, 3), DdpNodeAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aarpNetAddress.setDescription("The AppleTalk Network Address corresponding to the\nmedia-dependent physical address.")
aarpStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: aarpStatus.setDescription("The status of this AARP entry.\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in the\naarpTable.  That is, it effectively disassociates\nthe mapping identified with said entry.  It is an\nimplementation-specific matter as to whether the agent\nremoves an invalidated entry from the table.\nAccordingly, management stations must be prepared to\nreceive from agents tabular information corresponding\nto entries not currently in use.  Proper\ninterpretation of such entries requires examination\nof the relevant aarpStatus object.")
aarpLookups = MibScalar((1, 3, 6, 1, 2, 1, 13, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aarpLookups.setDescription("The number of times the AARP cache for this entity\nwas searched.")
aarpHits = MibScalar((1, 3, 6, 1, 2, 1, 13, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aarpHits.setDescription("The number of times an entry was searched for and\nfound in the AARP cache for this entity.")
atport = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 3))
atportTable = MibTable((1, 3, 6, 1, 2, 1, 13, 3, 1))
if mibBuilder.loadTexts: atportTable.setDescription("A list of AppleTalk ports for this entity.")
atportEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 3, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "atportIndex"))
if mibBuilder.loadTexts: atportEntry.setDescription("The description of one of the AppleTalk\nports on this entity.\n\nAs an example, an instance of the atportNetFrom object\nmight be named atportNetFrom.2")
atportIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportIndex.setDescription("A unique value for each AppleTalk port.\nIts value is between 1 and the total number of\nAppleTalk ports.  The value for each port must\nremain constant at least from the re-initialization\nof the entity's network management system to the\nnext re-initialization.")
atportDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 2), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportDescr.setDescription("A text string containing information about the\nport.  This string is intended for presentation\nto a human; it must not contain anything but printable\nASCII characters.")
atportType = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(8,16,24,17,14,22,21,2,5,11,9,18,1,15,20,19,12,7,4,3,6,23,13,10,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("fdditalk", 10), ("arctalk", 11), ("smdstalk", 12), ("aurp", 13), ("frameRelay", 14), ("x25", 15), ("ip", 16), ("osi", 17), ("decnetIV", 18), ("arap", 19), ("localtalk", 2), ("isdnInThePacketMode", 20), ("nonAppleTalk3Com", 21), ("ipx", 22), ("arns", 23), ("hdlc", 24), ("ethertalk1", 3), ("ethertalk2", 4), ("tokentalk", 5), ("iptalk", 6), ("serialPPP", 7), ("serialNonstandard", 8), ("virtual", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportType.setDescription("The type of port, distinguished by the protocol\nimmediately below DDP in the protocol stack.")
atportNetStart = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 4), ATNetworkNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportNetStart.setDescription("The first AppleTalk network address in the range\nconfigured for this port.  If this port is not a\nnative AppleTalk port, this object shall have the\nvalue of two octets of zero.")
atportNetEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 5), ATNetworkNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportNetEnd.setDescription("The last AppleTalk network address in the range\nconfigured for this port.  If the network to which\nthis AppleTalk port is connected is a non-extended\nnetwork, or if it is not a native AppleTalk port,\nthe value for atportNetEnd shall be two octets of\nzero.")
atportNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 6), DdpNodeAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportNetAddress.setDescription("The AppleTalk network address configured for this\nport.  In addition, this value may be used as a hint\nfor an initial node number used during node-finding.\nIf this port is not a native AppleTalk port, this\nobject shall have the value of three octets of zero.")
atportStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(7,3,1,5,6,4,2,)).subtype(namedValues=namedval.NamedValues(("routing", 1), ("unconfigured", 2), ("off", 3), ("invalid", 4), ("endNode", 5), ("offDueToConflict", 6), ("other", 7), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportStatus.setDescription("The configuration status of this port.\n\nSetting this object to the value invalid(4) has the\neffect of invalidating the corresponding entry in the\natportTable.  That is, it effectively disassociates the\nmapping identified with said entry.  It is an\nimplementation-specific matter as to whether the agent\nremoves an invalidated entry from the table.\nAccordingly, management stations must be prepared to\nreceive from agents tabular information corresponding\nto entries not currently in use.  Proper\ninterpretation of such entries requires examination\nof the relevant atportStatus object.")
atportNetConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,1,3,4,2,6,)).subtype(namedValues=namedval.NamedValues(("conflictOrientedSeed", 1), ("garnered", 2), ("guessed", 3), ("unconfigured", 4), ("conflictAverseSeed", 5), ("softSeed", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportNetConfig.setDescription("The status of the network information for this port.\nIf this port is not a native AppleTalk port, this\nobject shall have the value unconfigured(4).")
atportZoneConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,1,3,4,2,6,)).subtype(namedValues=namedval.NamedValues(("conflictOrientedSeed", 1), ("garnered", 2), ("guessed", 3), ("unconfigured", 4), ("conflictAverseSeed", 5), ("softSeed", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportZoneConfig.setDescription("The status of the zone information for this port.\nIf this port is not a native AppleTalk port, this\nobject shall have the value unconfigured(4).")
atportZoneDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 10), ATName()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportZoneDefault.setDescription("The name of the default zone for this port.  If\nthis port only has one zone, that zone is\nrepresented here. If this port is not a native\nAppleTalk port, this object shall contain an octet\nstring of zero length.\n\nWhen this value is changed in a router, the router\nmust send a zipNotify packet on the associated\nnetwork.")
atportIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 11), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportIfIndex.setDescription("The physical interface associated with this\nAppleTalk port.  The interface identified by a\nparticular value of this index is the same interface\nas identified by the same value of ifIndex.")
atportNetFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 12), DdpNodeAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportNetFrom.setDescription("When atportNetConfig is set to garnered(2), this\nvariable contains the DDP address of an entity from\nwhich the AppleTalk network number was garnered.\nWhen atportNetConfig is set to\nconflictOrientedSeed(1), conflictAverseSeed(5),\nor softSeed(6), this variable contains the DDP\naddress of an entity which confirmed or supplied our\nAppleTalk network number, for example by replying to\na ZIP GetNetInfo request.\n\nIf atportNetConfig is set to guessed(3) or\nunconfigured(4), or if the entity has not received\nany network number confirmation, this variable\nshould be set to three octets of zero.")
atportZoneFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 13), DdpNodeAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportZoneFrom.setDescription("When atportZoneConfig is set to garnered(2), this\nvariable contains the DDP address of an entity from\nwhich the AppleTalk zone list was garnered.\n\nWhen atportZoneConfig is set to\nconflictOrientedSeed(1), conflictAverseSeed(5), or\nsoftSeed(6), this variable contains the DDP address\nof an entity which confirmed or supplied our\nAppleTalk zone information, for example by replying\nto a ZIP GetNetInfo request or a ZIP Query.\n\nIf atportZoneConfig is set to guessed(3) or\nunconfigured(4), or if the entity has not received\nany zone confirmation, this variable should be set\nto three octets of zero.")
atportInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportInPkts.setDescription("The number of packets received by this entity on\nthis port.")
atportOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportOutPkts.setDescription("The number of packets transmitted by this entity on\nthis port.")
atportHome = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("home", 1), ("notHome", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportHome.setDescription("An indication of whether or not the entity is\nhomed on this port, that is to say, a port on which\nthe entity could perform NBP registrations for\nservices that it chooses to advertise.")
atportCurrentZone = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 17), ATName()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportCurrentZone.setDescription("The current zone for the port.  In general, this is\nthe zone name in which services on this port will\nbe registered.  If this port is not a native\nAppleTalk port, this object shall contain an octet\nstring of zero length.  Note that modifications to\nthis object do not affect the nbpTable.")
atportConflictPhysAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 1, 1, 18), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atportConflictPhysAddr.setDescription("The link-layer address of a device which caused\nthis entity to set atportStatus to\noffDueToConflict(6). If this address is not\navailable, or if the entity has not set atportStatus\nto offDueToConflict, this object shall be a zero\nlength OCTET STRING.")
atportZoneTable = MibTable((1, 3, 6, 1, 2, 1, 13, 3, 2))
if mibBuilder.loadTexts: atportZoneTable.setDescription("The table of zone information for non-default\nzones on ports.")
atportZoneEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 3, 2, 1)).setIndexNames((0, "APPLETALK-MIB", "atportZonePort"), (0, "APPLETALK-MIB", "atportZoneName"))
if mibBuilder.loadTexts: atportZoneEntry.setDescription("An entry of zone information for a port.\n\nAs an example, an instance of the atportZoneStatus\nobject might be named\natportZoneStatus.2.8.84.119.105.108.105.103.104.116")
atportZonePort = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 2, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: atportZonePort.setDescription("An integer representing the port to which this zone\nbelongs. The port identified by a particular value\nof this object is the same port as identified by the\nsame value of atportIndex.")
atportZoneName = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 2, 1, 2), ATName().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: atportZoneName.setDescription("A zone name configured for the AppleTalk port\nreferred to in the corresponding entry of\natportZonePort.\n\nWhen this value is changed in a router, the router\nmust send a zipNotify packet on the associated\nnetwork.")
atportZoneStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 3, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportZoneStatus.setDescription("The status of this zone entry.\n\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in\nthe atportZoneTable.  That is, it effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant\natportZoneStatus object.")
ddp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 4))
ddpOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpOutRequests.setDescription("The total number of DDP datagrams which were\nsupplied to DDP by local DDP clients in requests for\ntransmission.  Note that this counter does not\ninclude any datagrams counted in ddpForwRequests.")
ddpOutShorts = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpOutShorts.setDescription("The total number of short DDP datagrams which were\ntransmitted from this entity.")
ddpOutLongs = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpOutLongs.setDescription("The total number of long DDP datagrams which were\ntransmitted from this entity.")
ddpInReceives = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpInReceives.setDescription("The total number of input datagrams received by\nDDP, including those received in error.")
ddpForwRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwRequests.setDescription("The number of input datagrams for which this entity\nwas not their final DDP destination, as a result of\nwhich an attempt was made to find a route to forward\nthem to that final destination.")
ddpInLocalDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpInLocalDatagrams.setDescription("The total number of input DDP datagrams for which\nthis\nentity was their final DDP destination.")
ddpNoProtocolHandlers = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpNoProtocolHandlers.setDescription("The total number of DDP datagrams addressed to this\nentity that were addressed to an upper layer protocol\nfor which no protocol handler existed.")
ddpOutNoRoutes = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpOutNoRoutes.setDescription("The total number of DDP datagrams dropped because a\nroute could not be found to their final destination.")
ddpTooShortErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpTooShortErrors.setDescription("The total number of input DDP datagrams dropped\nbecause the received data length was less than the\ndata length specified in the DDP header or the\nreceived data length was less than the length of the\nexpected DDP header.")
ddpTooLongErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpTooLongErrors.setDescription("The total number of input DDP datagrams dropped\nbecause they exceeded the maximum DDP datagram\nsize.")
ddpBroadcastErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpBroadcastErrors.setDescription("The total number of input DDP datagrams dropped\nbecause this entity was not their final destination\nand they were addressed to the link level broadcast.")
ddpShortDDPErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpShortDDPErrors.setDescription("The total number of input DDP datagrams dropped\nbecause this entity was not their final destination\nand their type was short DDP.")
ddpHopCountErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpHopCountErrors.setDescription("The total number of input DDP datagrams dropped\nbecause this entity was not their final destination\nand their hop count would exceed 15.")
ddpChecksumErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpChecksumErrors.setDescription("The total number of input DDP datagrams for which\nthis DDP entity was their final destination, and\nwhich were dropped because of a checksum error.")
ddpListenerTable = MibTable((1, 3, 6, 1, 2, 1, 13, 4, 15))
if mibBuilder.loadTexts: ddpListenerTable.setDescription("The ddpListenerTable stores information for each\nDDP socket that has a listener.")
ddpListenerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 4, 15, 1)).setIndexNames((0, "APPLETALK-MIB", "ddpListenerAddress"))
if mibBuilder.loadTexts: ddpListenerEntry.setDescription("This ddpListenerEntry contains information about a\nparticular socket that has a socket listener.\n\nAs an example, an instance of the ddpListenerStatus\nobject might be named ddpListenerStatus.0.80.220.1")
ddpListenerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 15, 1, 1), DdpSocketAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ddpListenerAddress.setDescription("The DDP address that this socket listener is bound\nto.  If this socket listener isn't bound to a\nparticular address, for instance if it is intended\nfor all interfaces, this object shall have the value\nof three octets of zero followed by one octet of\nsocket number. The socket number must not equal\nzero.")
ddpListenerInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 15, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpListenerInPkts.setDescription("The number of packets received for this listener.")
ddpListenerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 15, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ddpListenerStatus.setDescription("The status of this socket listener.\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in the\nddpListenerTable.  That is, it effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant\nddpListenerStatus object.")
ddpForwardingTable = MibTable((1, 3, 6, 1, 2, 1, 13, 4, 16))
if mibBuilder.loadTexts: ddpForwardingTable.setDescription("A table of forwarding entries for DDP.  This table\ncontains a route for each AppleTalk network currently\nknown to the entity.")
ddpForwardingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 4, 16, 1)).setIndexNames((0, "APPLETALK-MIB", "ddpForwardingNetEnd"))
if mibBuilder.loadTexts: ddpForwardingEntry.setDescription("A forwarding entry for a particular AppleTalk\nnetwork.\n\nAs an example, an instance of the ddpForwardingPort\nobject might be named ddpForwardingPort.0.90")
ddpForwardingNetEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 1), ATNetworkNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ddpForwardingNetEnd.setDescription("The last network number in the network range\nmatched by this forwarding entry.  This will not be\nzero even if this corresponds to a non-extended\nnet.")
ddpForwardingNetStart = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 2), ATNetworkNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingNetStart.setDescription("The first network number in the network range\nmatched by this forwarding entry.")
ddpForwardingNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingNextHop.setDescription("The next hop in the route to this entry's\ndestination network.  The format of this address can\nbe determined by examinating the atportType\ncorresponding to this entry.")
ddpForwardingProto = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 4), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingProto.setDescription("The routing mechanism by which this route was\nlearned.")
ddpForwardingModifiedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingModifiedTime.setDescription("The value of sysUpTime at the time of the last\nmodification to this entry.  The initial value of\nddpForwardingModified time shall be the value of\nsysUpTime at the time the entry is created.")
ddpForwardingUseCounts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingUseCounts.setDescription("The number of times this entry has been used to\nroute a packet to the destination network.  Note\nthat this counter is not cleared when the\ncorresponding ddpForwardingNextHop variable\nchanges.")
ddpForwardingPort = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 4, 16, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingPort.setDescription("The AppleTalk port through which\nddpForwardingNextHop is reached.  The interface\nidentified by a particular value of this variable is\nthe same interface as identified by the same value\nof atportIndex.")
ddpForwProtoOids = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 4, 17))
rtmpRoutingProto = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 4, 17, 1))
kipRoutingProto = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 4, 17, 2))
ddpForwardingTableOverflows = MibScalar((1, 3, 6, 1, 2, 1, 13, 4, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ddpForwardingTableOverflows.setDescription("The number of times the entity attempted to add an\nentry to the forwarding table but failed due to\noverflow.")
rtmp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 5))
rtmpTable = MibTable((1, 3, 6, 1, 2, 1, 13, 5, 1))
if mibBuilder.loadTexts: rtmpTable.setDescription("A list of Routing Table Maintenance Protocol\nentries for this entity.")
rtmpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 5, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "rtmpRangeStart"))
if mibBuilder.loadTexts: rtmpEntry.setDescription("The route entry to a particular network range.\n\nAs an example, an instance of the rtmpPort object\nmight be named rtmpPort.0.80")
rtmpRangeStart = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 1), ATNetworkNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpRangeStart.setDescription("The first DDP network address in the network range\nto which this routing entry pertains.  This is a two\noctet DDP network address in network byte order.")
rtmpRangeEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 2), ATNetworkNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpRangeEnd.setDescription("The last DDP network address in the network range\nto which this routing entry pertains.  This is a two\noctet DDP network address in network byte order.  If\nthe network to which this routing entry pertains is\na non-extended network, the value for rtmpRangeEnd\nshall be two octets of zero.")
rtmpNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpNextHop.setDescription("The next internet router in the route to this\nentry's destination network.  The format of this\naddress can be determined by examinating the\natportType corresponding to this entry.")
rtmpType = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("appletalk", 2), ("serialPPP", 3), ("serialNonstandard", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpType.setDescription("The type of network over which this route points.")
rtmpPort = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpPort.setDescription("The AppleTalk port over which this route points.\nThe interface identified by a particular value of\nthis variable is the same interface as identified by\nthe same value of atportIndex.")
rtmpHops = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpHops.setDescription("The number of hops required to reach the\ndestination network to which this routing entry\npertains.")
rtmpState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 5, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,5,3,2,)).subtype(namedValues=namedval.NamedValues(("good", 1), ("suspect", 2), ("badZero", 3), ("badOne", 4), ("invalid", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rtmpState.setDescription("The status of the information contained in this\nroute entry.\n\nSetting this object to the value invalid(5) has the\neffect of invalidating the corresponding entry in\nthe rtmpTable.  That is, it  effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant rtmpState\nobject.")
rtmpInDataPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpInDataPkts.setDescription("A count of the number of good RTMP data packets\nreceived by this entity.")
rtmpOutDataPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpOutDataPkts.setDescription("A count of the number of RTMP packets sent by this\nentity.")
rtmpInRequestPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpInRequestPkts.setDescription("A count of the number of good RTMP Request packets\nreceived by this entity.")
rtmpNextIREqualChanges = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpNextIREqualChanges.setDescription("A count of the number of times RTMP changes the\nNext Internet Router in a routing entry because the\nhop count advertised in a routing tuple was equal to\nthe current hop count for a particular network.")
rtmpNextIRLessChanges = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpNextIRLessChanges.setDescription("A count of the number of times RTMP changes the\nNext Internet Router in a routing entry because the\nhop count advertised in a routing tuple was less\nthan the current hop count for a particular network.")
rtmpRouteDeletes = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpRouteDeletes.setDescription("A count of the number of times RTMP deletes a route\nbecause it was aged out of the table.  This can help\nto detect routing problems.")
rtmpRoutingTableOverflows = MibScalar((1, 3, 6, 1, 2, 1, 13, 5, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpRoutingTableOverflows.setDescription("The number of times RTMP attempted to add a route\nto the RTMP table but failed due to lack of space.")
kip = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 6))
kipTable = MibTable((1, 3, 6, 1, 2, 1, 13, 6, 1))
if mibBuilder.loadTexts: kipTable.setDescription("The table of routing information for KIP networks.")
kipEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 6, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "kipNetStart"))
if mibBuilder.loadTexts: kipEntry.setDescription("An entry in the routing table for KIP networks.\n\nAs an example, an instance of the kipCore object\nmight be named kipCore.0.80")
kipNetStart = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 1), ATNetworkNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: kipNetStart.setDescription("The first AppleTalk network address in the range\nfor this routing entry.  This address is a two octet\nDDP network address in network byte order.")
kipNetEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 2), ATNetworkNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipNetEnd.setDescription("The last AppleTalk network address in the range for\nthis routing entry.  This address is a two octet DDP\nnetwork address in network byte order.  If the\nnetwork to which this AppleTalk port is connected is\na non-extended network, the value for kipNetEnd\nshall be two octets of zero.")
kipNextHop = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 3), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipNextHop.setDescription("The IP address of the next hop in the route to this\nentry's destination network.")
kipHopCount = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 4), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipHopCount.setDescription("The number of hops required to reach the destination\nnetwork to which this entry pertains.")
kipBCastAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 5), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipBCastAddr.setDescription("The form of the IP address used to broadcast on this\nnetwork.")
kipCore = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("core", 1), ("notcore", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipCore.setDescription("The status of kipNextHop as a core gateway.")
kipType = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,5,2,1,)).subtype(namedValues=namedval.NamedValues(("kipRouter", 1), ("net", 2), ("host", 3), ("other", 4), ("async", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipType.setDescription("The type of the entity that this route points to.")
kipState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("configured", 1), ("learned", 2), ("invalid", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipState.setDescription("The state of this network entry.\n\nSetting this object to the value invalid(3) has the\neffect of invalidating the corresponding entry in the\nkipTable.  That is, it  effectively disassociates the\nmapping identified with said entry.  It is an\nimplementation-specific matter as to whether the agent\nremoves an invalidated entry from the table.\nAccordingly, management stations must be prepared to\nreceive from agents tabular information corresponding\nto entries not currently in use.  Proper\ninterpretation of such entries requires examination\nof the relevant kipState object.")
kipShare = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("shared", 1), ("private", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: kipShare.setDescription("If the information in this entry is propagated to\nother routers as part of the AA routing protocol,\nthe value of this variable is equal to shared(1).\nOtherwise its value is private(2).")
kipFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 6, 1, 1, 10), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: kipFrom.setDescription("The IP address from which the routing entry was\nlearned via the AA protocol.  If this entry was not\ncreated via the AA protocol, it should contain IP\naddress 0.0.0.0.")
zipRouter = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 7))
zipTable = MibTable((1, 3, 6, 1, 2, 1, 13, 7, 1))
if mibBuilder.loadTexts: zipTable.setDescription("The table of zone information for reachable\nAppleTalk networks.")
zipEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 7, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "zipZoneNetStart"), (0, "APPLETALK-MIB", "zipZoneIndex"))
if mibBuilder.loadTexts: zipEntry.setDescription("An entry of zone information for a particular zone\nand network combination.\n\nAs an example, an instance of the zipZoneState object\nmight be named zipZoneState.0.80.4")
zipZoneName = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 1), ATName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneName.setDescription("The zone name of this entry.  This is stored in\nMac ASCII format.  If the full zone list for the\nentry is not known, the value for zipZoneName shall\nbe a zero length octet string.")
zipZoneIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneIndex.setDescription("An integer that is unique to the zipZoneName that\nis present in this entry.  For any given zone name,\nevery zipEntry that has an equal zone name will have\nthe same zipZoneIndex.  When a zone name is\ndiscovered which is not currently in the table, it\nwill be assigned an index greater than any\npreviously assigned index.")
zipZoneNetStart = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 3), ATNetworkNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneNetStart.setDescription("The network that starts the range for this entry.\nThis address is a two octet DDP network address in\nnetwork byte order.")
zipZoneNetEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 4), ATNetworkNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneNetEnd.setDescription("The network that ends the range for this entry.\nThis address is a two octet DDP network address in\nnetwork byte order.  If the network to which this\nzip entry pertains is a non-extended network, the\nvalue for zipZoneNetEnd shall be two octets of\nzero.")
zipZoneState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: zipZoneState.setDescription("The state of this zip entry.\n\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in\nthe zipTable.  That is, it  effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant zipZoneState\nobject.")
zipZoneFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 6), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneFrom.setDescription("The address from which this zone name to network\nnumber mapping was learned.  The format of this\naddress can be determined by examining the\natportType corresponding to this entry.  When this\nmapping is learned from the entity itself, this\nobject shall have the value of three\noctets of zero.")
zipZonePort = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZonePort.setDescription("The AppleTalk port through which this zone name to\nnetwork number mapping was learned.  The interface\nidentified by a particular value of this variable is\nthe same interface as identified by the same value\nof atportIndex.")
zipInZipQueries = MibScalar((1, 3, 6, 1, 2, 1, 13, 7, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInZipQueries.setDescription("The number of ZIP Queries received by this entity.")
zipInZipReplies = MibScalar((1, 3, 6, 1, 2, 1, 13, 7, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInZipReplies.setDescription("The number of ZIP Replies received by this entity.")
zipInZipExtendedReplies = MibScalar((1, 3, 6, 1, 2, 1, 13, 7, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInZipExtendedReplies.setDescription("The number of ZIP Extended Replies received by this\nentity.")
zipZoneConflictErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 7, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneConflictErrors.setDescription("The number of times a conflict has been detected\nbetween this entity's zone information and another\nentity's zone information.")
zipInObsoletes = MibScalar((1, 3, 6, 1, 2, 1, 13, 7, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInObsoletes.setDescription("The number of ZIP Takedown or ZIP Bringup packets\nreceived by this entity.  Note that as the ZIP\nTakedown and ZIP Bringup packets have been\nobsoleted, the receipt of one of these packets\nindicates that a node sent it in error.")
zipRouterNetInfoTable = MibTable((1, 3, 6, 1, 2, 1, 13, 7, 7))
if mibBuilder.loadTexts: zipRouterNetInfoTable.setDescription("The table of Net Info packets received by each port\non this entity.")
zipRouterNetInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 7, 7, 1)).setIndexNames((0, "APPLETALK-MIB", "atportIndex"))
if mibBuilder.loadTexts: zipRouterNetInfoEntry.setDescription("The description of the Net Info packets received on\na particular port on this entity.  One such entry\nshall exist for each atport on this router entity.\n\nAs an example, an instance of the zipInGetNetInfos\nobject might be named zipInGetNetInfos.2")
zipInGetNetInfos = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 7, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInGetNetInfos.setDescription("The number of ZIP GetNetInfo packets received on\nthis port by this entity.")
zipOutGetNetInfoReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 7, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipOutGetNetInfoReplies.setDescription("The number of ZIP GetNetInfo Reply packets sent out\nthis port by this entity.")
zipZoneOutInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 7, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneOutInvalids.setDescription("The number of times this entity has sent a ZIP\nGetNetInfo Reply with the zone invalid bit set in\nresponse to a GetNetInfo Request with an invalid\nzone name.")
zipAddressInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 7, 7, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipAddressInvalids.setDescription("The number of times this entity had to broadcast a\nZIP GetNetInfo Reply because the GetNetInfo Request\nhad an invalid address.")
nbp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 8))
nbpTable = MibTable((1, 3, 6, 1, 2, 1, 13, 8, 1))
if mibBuilder.loadTexts: nbpTable.setDescription("The table of NBP services registered on this entity.")
nbpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 8, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "nbpIndex"))
if mibBuilder.loadTexts: nbpEntry.setDescription("The description of an NBP service registered on this\nentity.\n\nAs an example, an instance of the nbpZone object\nmight be named nbpZone.2")
nbpIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 1), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: nbpIndex.setDescription("The index of this NBP entry.  This index is unique\nwith respect to the indexes of all other NBP entries,\nand shall remain constant throughout the lifetime\nof this object.")
nbpObject = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 2), ATName().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: nbpObject.setDescription("The name of the service described by this entity.\nWhen this variable is changed, the entity should\nperform an NBP registration using the new nbpObject.")
nbpType = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 3), ATName().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: nbpType.setDescription("The type of the service described by this entity.\nWhen this variable is changed, the entity should\nperform an NBP registration using the new nbpType.")
nbpZone = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 4), ATName()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: nbpZone.setDescription("The zone the service described by this entity is\nregistered in.  This must be the actual zone name,\nwithout any wildcard characters.  When this variable\nis changed, the entity should perform an NBP\nregistration using the new nbpZone.")
nbpState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("registering", 2), ("registrationFailed", 3), ("invalid", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: nbpState.setDescription("The state of this NBP entry.\nWhen the registration for an entry in the nbpTable\nfails, it is an implementation-specific matter as to\nhow long the entry will remain in the\nregistrationFailed(3) state before moving to the\ninvalid(4) state.  Note that the entry may pass\nimmediately from the registrationFailed state to\nthe invalid state.\n\nSetting this object to the value invalid(4) has the\neffect of invalidating the corresponding entry in the\nnbpTable.  That is, it  effectively disassociates the\nmapping identified with said entry.  It is an\nimplementation-specific matter as to whether the agent\nremoves an invalidated entry from the table.\nAccordingly, management stations must be prepared to\nreceive from agents tabular information corresponding\nto entries not currently in use.  Proper\ninterpretation of such entries requires examination\nof the relevant nbpState object.")
nbpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 6), DdpSocketAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: nbpAddress.setDescription("The DDP network, node, and socket number of this\nentity. If this is unspecified, for instance if the\nregistration is on all ports of a multiport device,\nthis object shall have the value of three octets of\nzero, followed by one octet of socket number.")
nbpEnumerator = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 8, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpEnumerator.setDescription("The enumerator assigned to this entity.")
nbpInLookUpRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpInLookUpRequests.setDescription("The number of NBP LookUp Requests received.")
nbpInLookUpReplies = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpInLookUpReplies.setDescription("The number of NBP LookUp Replies received.")
nbpInBroadcastRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpInBroadcastRequests.setDescription("The number of NBP Broadcast Requests received.")
nbpInForwardRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpInForwardRequests.setDescription("The number of NBP Forward Requests received.")
nbpOutLookUpReplies = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpOutLookUpReplies.setDescription("The number of NBP LookUp Replies sent.")
nbpRegistrationFailures = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpRegistrationFailures.setDescription("The number of times this node experienced a failure\nin attempting to register an NBP entity.")
nbpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 8, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nbpInErrors.setDescription("The number of NBP packets received by this entity\nthat were rejected for any error.")
atecho = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 9))
atechoRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 9, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atechoRequests.setDescription("The number of AppleTalk Echo requests received.")
atechoReplies = MibScalar((1, 3, 6, 1, 2, 1, 13, 9, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atechoReplies.setDescription("The number of AppleTalk Echo replies sent.")
atechoOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 13, 9, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atechoOutRequests.setDescription("The count of AppleTalk Echo requests sent.")
atechoInReplies = MibScalar((1, 3, 6, 1, 2, 1, 13, 9, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atechoInReplies.setDescription("The count of AppleTalk Echo replies received.")
atp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 10))
atpInPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 10, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atpInPkts.setDescription("The number of ATP packets received by this entity.")
atpOutPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 10, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atpOutPkts.setDescription("The number of ATP packets sent by this entity.")
atpTRequestRetransmissions = MibScalar((1, 3, 6, 1, 2, 1, 13, 10, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atpTRequestRetransmissions.setDescription("The number of times that a timeout occurred and a\nTransaction Request packet needed to be\nretransmitted by this host.")
atpTResponseRetransmissions = MibScalar((1, 3, 6, 1, 2, 1, 13, 10, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atpTResponseRetransmissions.setDescription("The number of times a timeout was detected and a\nTransaction Response packet needed to be\nretransmitted by this host.")
atpReleaseTimerExpiredCounts = MibScalar((1, 3, 6, 1, 2, 1, 13, 10, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atpReleaseTimerExpiredCounts.setDescription("The number of times the release timer expired, as a\nresult of which a Request Control Block had to be\ndeleted.")
atpRetryCountExceededs = MibScalar((1, 3, 6, 1, 2, 1, 13, 10, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: atpRetryCountExceededs.setDescription("The number of times the retry count was exceeded,\nand an error was returned to the client of ATP.")
atpListenerTable = MibTable((1, 3, 6, 1, 2, 1, 13, 10, 7))
if mibBuilder.loadTexts: atpListenerTable.setDescription("The atpListenerTable stores information for each ATP\nsocket that has a listener.")
atpListenerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 10, 7, 1)).setIndexNames((0, "APPLETALK-MIB", "atpListenerAddress"))
if mibBuilder.loadTexts: atpListenerEntry.setDescription("This atpListenerEntry contains information about a\nparticular socket that has a socket listener.\n\nAs an example, an instance of the atpListenerStatus\nobject might be named atpListenerStatus.0.80.220.3")
atpListenerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 10, 7, 1, 1), DdpSocketAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: atpListenerAddress.setDescription("The DDP address that this socket listener is bound\nto. If this socket listener isn't bound to a\nparticular address, for instance if it is intended\nfor all interfaces, this object shall have the value\nof three octets of zero followed by one octet of\nsocket number.")
atpListenerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 10, 7, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atpListenerStatus.setDescription("The status of this socket.\n\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in\nthe atpListenerTable.  That is, it effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant\natpListenerStatus object.")
pap = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 11))
papInOpenConns = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papInOpenConns.setDescription("The number of PAP Open Connection requests received\nby this entity.")
papOutOpenConns = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papOutOpenConns.setDescription("The number of PAP Open Connection requests sent by\nthis entity.")
papInDatas = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papInDatas.setDescription("The number of PAP Data messages received by\nthis entity.")
papOutDatas = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papOutDatas.setDescription("The number of PAP Data messages sent by\nthis entity.")
papInCloseConns = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papInCloseConns.setDescription("The number of PAP Close Connection requests\nreceived by this entity.")
papOutCloseConns = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papOutCloseConns.setDescription("The number of PAP Close Connection requests sent by\nthis entity.")
papTickleTimeoutCloses = MibScalar((1, 3, 6, 1, 2, 1, 13, 11, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papTickleTimeoutCloses.setDescription("The number of times the PAP entity on this node\nclosed a connection because it didn't receive a\nTickle message before its timer expired.")
papServerTable = MibTable((1, 3, 6, 1, 2, 1, 13, 11, 8))
if mibBuilder.loadTexts: papServerTable.setDescription("A list of servers on this entity that are\naccessible through the Printer Access Protocol.")
papServerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 11, 8, 1)).setIndexNames((0, "APPLETALK-MIB", "papServerIndex"))
if mibBuilder.loadTexts: papServerEntry.setDescription("A set of information about a particular PAP server's\nconfiguration and performance.\n\nAs an example, an instance of the papServerStatus\nobject might be named papServerStatus.1")
papServerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: papServerIndex.setDescription("An unique value for each Printer Access Protocol\nServer.")
papServerListeningSocket = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 2), DdpSocketAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: papServerListeningSocket.setDescription("The Server Listening Socket that this PAP server is\nlistening on.")
papServerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerStatus.setDescription("The status string of this server.  This is the\nmessage as it would appear in a PAP Status Reply\nfrom this server.")
papServerCompletedJobs = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerCompletedJobs.setDescription("The number of jobs that have been accepted and\nsuccessfully executed by this server.")
papServerBusyJobs = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerBusyJobs.setDescription("The number of GetNextJob calls that have accepted\nand are currently executing a job.")
papServerFreeJobs = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerFreeJobs.setDescription("The minimum number of GetNextJob calls that are\ncurrently waiting for a job.")
papServerAuthenticationFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerAuthenticationFailures.setDescription("The number of times this PAP server rejected a job\nbecause the job was not correctly authenticated.")
papServerAccountingFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerAccountingFailures.setDescription("The number of times this PAP server rejected a job\nbecause the job did not fit some accounting rule,\nsuch as exceeding a quota.")
papServerGeneralFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerGeneralFailures.setDescription("The number of times this PAP server rejected a job\nfor some reason other than authentication or\naccounting failures.")
papServerState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: papServerState.setDescription("The state of this PAP Server entry.\n\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in\nthe papServerTable.  That is, it  effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant papServerState\nobject.")
papServerLastStatusMsg = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 11, 8, 1, 11), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: papServerLastStatusMsg.setDescription("The last status message that was transmitted by\nthis server.")
asp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 12))
aspInputTransactions = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspInputTransactions.setDescription("The number of ASP requests and replies received by\nthis entity.  Note that this is not necessarily the\nnumber of packets containing ASP transactions.")
aspOutputTransactions = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspOutputTransactions.setDescription("The number of ASP requests and replies sent by this\nentity.  Note that this is not necessarily the number\nof packets containing ASP transactions.")
aspInOpenSessions = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspInOpenSessions.setDescription("The number of ASP Open Session requests and replies\nreceived by this entity.")
aspOutOpenSessions = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspOutOpenSessions.setDescription("The number of ASP Open Session requests and replies\nsent by this entity.")
aspInCloseSessions = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspInCloseSessions.setDescription("The number of ASP Close Session requests and replies\nreceived by this entity.")
aspOutCloseSessions = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspOutCloseSessions.setDescription("The number of ASP Close Session requests and replies\nsent by this entity.")
aspNoMoreSessionsErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspNoMoreSessionsErrors.setDescription("The number of times an error condition was returned\nbecause this server implementation could not support\nanother session.")
aspTickleTimeOutCloses = MibScalar((1, 3, 6, 1, 2, 1, 13, 12, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspTickleTimeOutCloses.setDescription("The number of times the ASP entity on this node\nclosed a connection because it didn't receive any\nmessages from the remote end before its timer\nexpired.")
aspConnTable = MibTable((1, 3, 6, 1, 2, 1, 13, 12, 9))
if mibBuilder.loadTexts: aspConnTable.setDescription("A list of ASP connections on this entity.")
aspConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 12, 9, 1)).setIndexNames((0, "APPLETALK-MIB", "aspConnLocalAddress"), (0, "APPLETALK-MIB", "aspConnRemoteAddress"), (0, "APPLETALK-MIB", "aspConnID"))
if mibBuilder.loadTexts: aspConnEntry.setDescription("A set of information describing an ASP connection.\n\nAs an example, an instance of the aspConnState object\nmight be named\naspConnState.0.80.220.135.0.80.239.119.12")
aspConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 12, 9, 1, 1), DdpSocketAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: aspConnLocalAddress.setDescription("The local address of this ASP connection.")
aspConnRemoteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 12, 9, 1, 2), DdpSocketAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: aspConnRemoteAddress.setDescription("The remote address of this ASP connection.  If\nthis entry is in the listening mode, this object\nshall have a value of four octets of zero.")
aspConnID = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 12, 9, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: aspConnID.setDescription("The remote Connection ID of this ASP connection.  If\nthis entry is in the listening mode, this object\nshall have a value of zero.")
aspConnLastReqNum = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 12, 9, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspConnLastReqNum.setDescription("The last request number on this ASP connection.  If\nthis entry is in the listening mode, this object\nshall have a value of zero.")
aspConnServerEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 12, 9, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("sss", 1), ("wss", 2), ("sls", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: aspConnServerEnd.setDescription("Specifies what mode the local session end is in.")
aspConnState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 12, 9, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("open", 1), ("closed", 2), ("invalid", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: aspConnState.setDescription("The state of this ASP connection.\nSetting this object to the value invalid(3) has the\neffect of invalidating the corresponding entry in the\naspConnTable.  That is, it  effectively disassociates\nthe mapping identified with said entry.  It is an\nimplementation-specific matter as to whether the agent\nremoves an invalidated entry from the table.\nAccordingly, management stations must be prepared to\nreceive from agents tabular information corresponding\nto entries not currently in use.  Proper\ninterpretation of such entries requires examination\nof the relevant aspConnState object.")
adsp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 13))
adspInPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspInPkts.setDescription("The number of ADSP packets received by this entity.")
adspOutPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspOutPkts.setDescription("The number of ADSP packets sent by this entity.")
adspInOctets = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspInOctets.setDescription("The number of data octets contained in ADSP packets\nreceived by this entity.  Note that this does not\ninclude EOM bits.")
adspOutOctets = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspOutOctets.setDescription("The number of data octets contained in ADSP packets\nsent by this entity.  Note that this does not include\nEOM bits.")
adspInDataPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspInDataPkts.setDescription("The number of ADSP data packets this entity has\nreceived.")
adspOutDataPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspOutDataPkts.setDescription("The number of ADSP data packets this entity has\nsent.")
adspTimeoutErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspTimeoutErrors.setDescription("The number of times the ADSP on this entity detected\nan expired connection timer.")
adspTimeoutCloseErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 13, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspTimeoutCloseErrors.setDescription("The number of times the ADSP on this entity closed a\nconnection because of too many timeouts.")
adspConnTable = MibTable((1, 3, 6, 1, 2, 1, 13, 13, 9))
if mibBuilder.loadTexts: adspConnTable.setDescription("A list of ADSP connections on this entity.")
adspConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 13, 9, 1)).setIndexNames((0, "APPLETALK-MIB", "adspConnLocalAddress"), (0, "APPLETALK-MIB", "adspConnRemoteAddress"), (0, "APPLETALK-MIB", "adspConnLocalConnID"))
if mibBuilder.loadTexts: adspConnEntry.setDescription("A set of information describing an ADSP connection.\nAs an example, an instance of the adspConnState object\nmight be named\nadspConnState.0.80.220.7.0.80.239.142.31231")
adspConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 13, 9, 1, 1), DdpSocketAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adspConnLocalAddress.setDescription("The local DDP address of this ADSP connection.")
adspConnLocalConnID = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 13, 9, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adspConnLocalConnID.setDescription("The local Connection ID of this ADSP connection.  If\nthis entry specifies an ADSP listener, this value\nshall be zero.")
adspConnRemoteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 13, 9, 1, 3), DdpSocketAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adspConnRemoteAddress.setDescription("The remote DDP address of this ADSP connection.  If\nthis entry specifies an ADSP listener, this value\nshall be zero.")
adspConnRemoteConnID = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 13, 9, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adspConnRemoteConnID.setDescription("The remote Connection ID of this ADSP connection.\nIf this entry specifies an ADSP listener, this value\nshall be zero.")
adspConnState = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 13, 9, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,6,5,2,1,)).subtype(namedValues=namedval.NamedValues(("open", 1), ("localHalfOpen", 2), ("remoteHalfOpen", 3), ("listening", 4), ("closed", 5), ("invalid", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: adspConnState.setDescription("The state of this ADSP connection.  The state is\nopen if both ends are established.  If only one end\nis established, then the state is half-open.  If\nneither end is established, then the state is\nclosed.  If an ADSP server is listening on a socket\nand is not yet connected, its state is set to\nlistening, and the adspConnRemoteAddress,\nadspConnRemoteSocket, adspConnRemoteConnID, and\nadspConnRemoteWindowSize are all set to zero.\n\nSetting this object to the value invalid(6) has the\neffect of invalidating the corresponding entry in\nthe adspConnTable.  That is, it  effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examination of the relevant adspConnState\nobject.")
atportptop = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14))
atportPtoPTable = MibTable((1, 3, 6, 1, 2, 1, 13, 14, 1))
if mibBuilder.loadTexts: atportPtoPTable.setDescription("A list of AppleTalk point-to-point connections for\nthis entity.")
atportPtoPEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 14, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "atportPtoPIndex"))
if mibBuilder.loadTexts: atportPtoPEntry.setDescription("The description of one of the AppleTalk\npoint-to-point connections on this entity.\n\nAs an example, an instance of the\natportPtoPRemoteAddress object might be named\natportPtoPRemoteAddress.2")
atportPtoPIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 14, 1, 1, 1), Integer32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: atportPtoPIndex.setDescription("A unique value for each AppleTalk point-to-point\nconnection.  Its value is between 1 and the total\nnumber of AppleTalk point-to-point connections.  The\nvalue for each connection must remain constant at\nleast from the re-initialization of the entity's\nnetwork management system to the next\nre-initialization.")
atportPtoPProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 14, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportPtoPProtocol.setDescription("The protocol type used over the point-to-point\nconnection.")
atportPtoPRemoteName = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 14, 1, 1, 3), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportPtoPRemoteName.setDescription("A text string containing the network node name of the\nentity at the other end of the point-to-point link.\nIf the name is unknown or undefined, then this\nstring is zero length.")
atportPtoPRemoteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 14, 1, 1, 4), OctetString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportPtoPRemoteAddress.setDescription("The network address of the entity at the other end\nof the point-to-point link in network byte order.\nThe format of this address can be determined\nby examinating the atportType corresponding to this\nentry.  If the address is unknown or undefined, then\nthis string is zero length.")
atportPtoPPortIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 14, 1, 1, 5), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportPtoPPortIndex.setDescription("The AppleTalk port associated with this\npoint-to-point connection.  The interface identified\nby a particular value of this index is the same\ninterface as identified by the same value of\natportIndex.")
atportPtoPStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 14, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("valid", 1), ("invalid", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: atportPtoPStatus.setDescription("The status of this entry in the atportPtoPTable.\n\nSetting this object to the value invalid(2) has the\neffect of invalidating the corresponding entry in\nthe atportPtoPTable.  That is, it  effectively\ndisassociates the mapping identified with said\nentry.  It is an implementation-specific matter as\nto whether the agent removes an invalidated entry\nfrom the table. Accordingly, management stations\nmust be prepared to receive from agents tabular\ninformation corresponding to entries not currently\nin use.  Proper interpretation of such entries\nrequires examinationr of the relevant\natportPtoPStatus object.")
atportPtoPProtoOids = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2))
pToPProtoOther = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 1))
pToPProtoAurp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 2))
pToPProtoCaymanUdp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 3))
pToPProtoAtkvmsDecnetIV = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 4))
pToPProtoLiaisonUdp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 5))
pToPProtoIpx = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 6))
pToPProtoShivaIp = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 14, 2, 7))
rtmpStub = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 16))
rtmpOutRequestPkts = MibScalar((1, 3, 6, 1, 2, 1, 13, 16, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpOutRequestPkts.setDescription("A count of the number of RTMP Request packets sent\nby this entity.")
rtmpInVersionMismatches = MibScalar((1, 3, 6, 1, 2, 1, 13, 16, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpInVersionMismatches.setDescription("A count of the number of RTMP packets received by\nthis entity that were rejected due to a version\nmismatch.")
rtmpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 16, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rtmpInErrors.setDescription("A count of the number of RTMP packets received by\nthis entity that were rejected for an error other\nthan version mismatch.")
zipEndNode = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 17))
zipNetInfoTable = MibTable((1, 3, 6, 1, 2, 1, 13, 17, 1))
if mibBuilder.loadTexts: zipNetInfoTable.setDescription("The table of Net Info packets received by each port\non this entity.")
zipNetInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 17, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "atportIndex"))
if mibBuilder.loadTexts: zipNetInfoEntry.setDescription("The description of the Net Info packets received on\na particular port on this entity.  One such entry\nshall exist for each atport on this entity.\n\nAs an example, an instance of the zipOutGetNetInfos\nobject might be named zipOutGetNetInfos.2")
zipOutGetNetInfos = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 17, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipOutGetNetInfos.setDescription("The number of ZIP GetNetInfo packets sent out this\nport by this entity.")
zipInGetNetInfoReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 17, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInGetNetInfoReplies.setDescription("The number of ZIP GetNetInfo Reply packets received\non this port by this entity.")
zipZoneInInvalids = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 17, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipZoneInInvalids.setDescription("The number of times this entity has received a ZIP\nGetNetInfo Reply with the zone invalid bit set\nbecause the corresponding GetNetInfo Request had an\ninvalid zone name.")
zipInErrors = MibScalar((1, 3, 6, 1, 2, 1, 13, 17, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: zipInErrors.setDescription("The number of ZIP packets received by this entity\nthat were rejected for any error.")
perPort = MibIdentifier((1, 3, 6, 1, 2, 1, 13, 18))
perPortTable = MibTable((1, 3, 6, 1, 2, 1, 13, 18, 1))
if mibBuilder.loadTexts: perPortTable.setDescription("The table of per-port statistics for this entity.")
perPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 13, 18, 1, 1)).setIndexNames((0, "APPLETALK-MIB", "atportIndex"))
if mibBuilder.loadTexts: perPortEntry.setDescription("The statistics available for a particular port on\nthis entity.\n\nAs an example, an instance of the perPortAarpInProbes\nobject might be named perPortAarpInProbes.2")
perPortAarpInProbes = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortAarpInProbes.setDescription("The total number of AARP Probe packets received\nby this entity on this port.")
perPortAarpOutProbes = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortAarpOutProbes.setDescription("The total number of AARP Probe packets sent by\nthis entity on this port.")
perPortAarpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortAarpInReqs.setDescription("The total number of AARP Request packets received\nby this entity on this port.")
perPortAarpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortAarpOutReqs.setDescription("The total number of AARP Request packets sent by\nthis entity on this port.")
perPortAarpInRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortAarpInRsps.setDescription("The total number of AARP Response packets received\nby this entity on this port.")
perPortAarpOutRsps = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortAarpOutRsps.setDescription("The total number of AARP Response packets sent by\nthis entity on this port.")
perPortDdpInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpInReceives.setDescription("The total number of input datagrams received by DDP\non this port, including those received in error.")
perPortDdpInLocalDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpInLocalDatagrams.setDescription("The total number of input DDP datagrams on this\nport for which this entity was their final DDP\ndestination.")
perPortDdpNoProtocolHandlers = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpNoProtocolHandlers.setDescription("The total number of DDP datagrams addressed to this\nentity on this port that were addressed to an upper\nlayer protocol for which no protocol handler\nexisted.")
perPortDdpTooShortErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpTooShortErrors.setDescription("The total number of input DDP datagrams on this\nport dropped because the received data length was\nless than the data length specified in the DDP\nheader or the received data length was less than the\nlength of the expected DDP header.")
perPortDdpTooLongErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpTooLongErrors.setDescription("The total number of input DDP datagrams on this\nport dropped because they exceeded the maximum DDP\ndatagram size.")
perPortDdpChecksumErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpChecksumErrors.setDescription("The total number of input DDP datagrams on this\nport for which this DDP entity was their final\ndestination, and which were dropped because of a\nchecksum error.")
perPortDdpForwRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortDdpForwRequests.setDescription("The number of input datagrams on this port for\nwhich this entity was not their final DDP\ndestination, as a result of which an attempt was\nmade to find a route to forward them to that final\ndestination.")
perPortRtmpInDataPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortRtmpInDataPkts.setDescription("A count of the number of good RTMP data packets\nreceived by this entity on this port.")
perPortRtmpOutDataPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortRtmpOutDataPkts.setDescription("A count of the number of RTMP packets sent by this\nentity on this port.")
perPortRtmpInRequestPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortRtmpInRequestPkts.setDescription("A count of the number of good RTMP Request packets\nreceived by this entity on this port.")
perPortRtmpRouteDeletes = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortRtmpRouteDeletes.setDescription("A count of the number of times RTMP deletes a route\non this port because it was aged out of the table.")
perPortZipInZipQueries = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortZipInZipQueries.setDescription("The number of ZIP Queries received by this entity\non this port.")
perPortZipInZipReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortZipInZipReplies.setDescription("The number of ZIP Replies received by this entity\non this port.")
perPortZipInZipExtendedReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortZipInZipExtendedReplies.setDescription("The number of ZIP Extended Replies received by this\nentity on this port.")
perPortZipZoneConflictErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortZipZoneConflictErrors.setDescription("The number of times a conflict has been detected on\nthis port between this entity's zone information and\nanother entity's zone information.")
perPortZipInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortZipInErrors.setDescription("The number of ZIP packets received by this entity\non this port that were rejected for any error.")
perPortNbpInLookUpRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpInLookUpRequests.setDescription("The number of NBP LookUp Requests received on this\nport.")
perPortNbpInLookUpReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpInLookUpReplies.setDescription("The number of NBP LookUp Replies received on this\nport.")
perPortNbpInBroadcastRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpInBroadcastRequests.setDescription("The number of NBP Broadcast Requests received on\nthis port.")
perPortNbpInForwardRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpInForwardRequests.setDescription("The number of NBP Forward Requests received on this\nport.")
perPortNbpOutLookUpReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpOutLookUpReplies.setDescription("The number of NBP LookUp Replies sent on this port.")
perPortNbpRegistrationFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpRegistrationFailures.setDescription("The number of times this node experienced a failure\nin attempting to register an NBP entity on this\nport.")
perPortNbpInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortNbpInErrors.setDescription("The number of NBP packets received by this entity\non this port that were rejected for any error.")
perPortEchoRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortEchoRequests.setDescription("The number of AppleTalk Echo requests received on\nthis port.")
perPortEchoReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 13, 18, 1, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: perPortEchoReplies.setDescription("The count of AppleTalk Echo replies received on\nthis port.")

# Augmentions

# Exports

# Types
mibBuilder.exportSymbols("APPLETALK-MIB", ATName=ATName, ATNetworkNumber=ATNetworkNumber, DdpNodeAddress=DdpNodeAddress, DdpSocketAddress=DdpSocketAddress)

# Objects
mibBuilder.exportSymbols("APPLETALK-MIB", appletalk=appletalk, llap=llap, llapTable=llapTable, llapEntry=llapEntry, llapIfIndex=llapIfIndex, llapInPkts=llapInPkts, llapOutPkts=llapOutPkts, llapInNoHandlers=llapInNoHandlers, llapInLengthErrors=llapInLengthErrors, llapInErrors=llapInErrors, llapCollisions=llapCollisions, llapDefers=llapDefers, llapNoDataErrors=llapNoDataErrors, llapRandomCTSErrors=llapRandomCTSErrors, llapFCSErrors=llapFCSErrors, aarp=aarp, aarpTable=aarpTable, aarpEntry=aarpEntry, aarpIfIndex=aarpIfIndex, aarpPhysAddress=aarpPhysAddress, aarpNetAddress=aarpNetAddress, aarpStatus=aarpStatus, aarpLookups=aarpLookups, aarpHits=aarpHits, atport=atport, atportTable=atportTable, atportEntry=atportEntry, atportIndex=atportIndex, atportDescr=atportDescr, atportType=atportType, atportNetStart=atportNetStart, atportNetEnd=atportNetEnd, atportNetAddress=atportNetAddress, atportStatus=atportStatus, atportNetConfig=atportNetConfig, atportZoneConfig=atportZoneConfig, atportZoneDefault=atportZoneDefault, atportIfIndex=atportIfIndex, atportNetFrom=atportNetFrom, atportZoneFrom=atportZoneFrom, atportInPkts=atportInPkts, atportOutPkts=atportOutPkts, atportHome=atportHome, atportCurrentZone=atportCurrentZone, atportConflictPhysAddr=atportConflictPhysAddr, atportZoneTable=atportZoneTable, atportZoneEntry=atportZoneEntry, atportZonePort=atportZonePort, atportZoneName=atportZoneName, atportZoneStatus=atportZoneStatus, ddp=ddp, ddpOutRequests=ddpOutRequests, ddpOutShorts=ddpOutShorts, ddpOutLongs=ddpOutLongs, ddpInReceives=ddpInReceives, ddpForwRequests=ddpForwRequests, ddpInLocalDatagrams=ddpInLocalDatagrams, ddpNoProtocolHandlers=ddpNoProtocolHandlers, ddpOutNoRoutes=ddpOutNoRoutes, ddpTooShortErrors=ddpTooShortErrors, ddpTooLongErrors=ddpTooLongErrors, ddpBroadcastErrors=ddpBroadcastErrors, ddpShortDDPErrors=ddpShortDDPErrors, ddpHopCountErrors=ddpHopCountErrors, ddpChecksumErrors=ddpChecksumErrors, ddpListenerTable=ddpListenerTable, ddpListenerEntry=ddpListenerEntry, ddpListenerAddress=ddpListenerAddress, ddpListenerInPkts=ddpListenerInPkts, ddpListenerStatus=ddpListenerStatus, ddpForwardingTable=ddpForwardingTable, ddpForwardingEntry=ddpForwardingEntry, ddpForwardingNetEnd=ddpForwardingNetEnd, ddpForwardingNetStart=ddpForwardingNetStart, ddpForwardingNextHop=ddpForwardingNextHop, ddpForwardingProto=ddpForwardingProto, ddpForwardingModifiedTime=ddpForwardingModifiedTime, ddpForwardingUseCounts=ddpForwardingUseCounts, ddpForwardingPort=ddpForwardingPort, ddpForwProtoOids=ddpForwProtoOids, rtmpRoutingProto=rtmpRoutingProto, kipRoutingProto=kipRoutingProto, ddpForwardingTableOverflows=ddpForwardingTableOverflows, rtmp=rtmp, rtmpTable=rtmpTable, rtmpEntry=rtmpEntry, rtmpRangeStart=rtmpRangeStart, rtmpRangeEnd=rtmpRangeEnd, rtmpNextHop=rtmpNextHop, rtmpType=rtmpType, rtmpPort=rtmpPort, rtmpHops=rtmpHops, rtmpState=rtmpState, rtmpInDataPkts=rtmpInDataPkts, rtmpOutDataPkts=rtmpOutDataPkts, rtmpInRequestPkts=rtmpInRequestPkts, rtmpNextIREqualChanges=rtmpNextIREqualChanges, rtmpNextIRLessChanges=rtmpNextIRLessChanges, rtmpRouteDeletes=rtmpRouteDeletes, rtmpRoutingTableOverflows=rtmpRoutingTableOverflows, kip=kip, kipTable=kipTable, kipEntry=kipEntry, kipNetStart=kipNetStart, kipNetEnd=kipNetEnd, kipNextHop=kipNextHop, kipHopCount=kipHopCount, kipBCastAddr=kipBCastAddr, kipCore=kipCore, kipType=kipType, kipState=kipState, kipShare=kipShare, kipFrom=kipFrom, zipRouter=zipRouter, zipTable=zipTable, zipEntry=zipEntry, zipZoneName=zipZoneName, zipZoneIndex=zipZoneIndex, zipZoneNetStart=zipZoneNetStart, zipZoneNetEnd=zipZoneNetEnd, zipZoneState=zipZoneState, zipZoneFrom=zipZoneFrom, zipZonePort=zipZonePort, zipInZipQueries=zipInZipQueries, zipInZipReplies=zipInZipReplies, zipInZipExtendedReplies=zipInZipExtendedReplies)
mibBuilder.exportSymbols("APPLETALK-MIB", zipZoneConflictErrors=zipZoneConflictErrors, zipInObsoletes=zipInObsoletes, zipRouterNetInfoTable=zipRouterNetInfoTable, zipRouterNetInfoEntry=zipRouterNetInfoEntry, zipInGetNetInfos=zipInGetNetInfos, zipOutGetNetInfoReplies=zipOutGetNetInfoReplies, zipZoneOutInvalids=zipZoneOutInvalids, zipAddressInvalids=zipAddressInvalids, nbp=nbp, nbpTable=nbpTable, nbpEntry=nbpEntry, nbpIndex=nbpIndex, nbpObject=nbpObject, nbpType=nbpType, nbpZone=nbpZone, nbpState=nbpState, nbpAddress=nbpAddress, nbpEnumerator=nbpEnumerator, nbpInLookUpRequests=nbpInLookUpRequests, nbpInLookUpReplies=nbpInLookUpReplies, nbpInBroadcastRequests=nbpInBroadcastRequests, nbpInForwardRequests=nbpInForwardRequests, nbpOutLookUpReplies=nbpOutLookUpReplies, nbpRegistrationFailures=nbpRegistrationFailures, nbpInErrors=nbpInErrors, atecho=atecho, atechoRequests=atechoRequests, atechoReplies=atechoReplies, atechoOutRequests=atechoOutRequests, atechoInReplies=atechoInReplies, atp=atp, atpInPkts=atpInPkts, atpOutPkts=atpOutPkts, atpTRequestRetransmissions=atpTRequestRetransmissions, atpTResponseRetransmissions=atpTResponseRetransmissions, atpReleaseTimerExpiredCounts=atpReleaseTimerExpiredCounts, atpRetryCountExceededs=atpRetryCountExceededs, atpListenerTable=atpListenerTable, atpListenerEntry=atpListenerEntry, atpListenerAddress=atpListenerAddress, atpListenerStatus=atpListenerStatus, pap=pap, papInOpenConns=papInOpenConns, papOutOpenConns=papOutOpenConns, papInDatas=papInDatas, papOutDatas=papOutDatas, papInCloseConns=papInCloseConns, papOutCloseConns=papOutCloseConns, papTickleTimeoutCloses=papTickleTimeoutCloses, papServerTable=papServerTable, papServerEntry=papServerEntry, papServerIndex=papServerIndex, papServerListeningSocket=papServerListeningSocket, papServerStatus=papServerStatus, papServerCompletedJobs=papServerCompletedJobs, papServerBusyJobs=papServerBusyJobs, papServerFreeJobs=papServerFreeJobs, papServerAuthenticationFailures=papServerAuthenticationFailures, papServerAccountingFailures=papServerAccountingFailures, papServerGeneralFailures=papServerGeneralFailures, papServerState=papServerState, papServerLastStatusMsg=papServerLastStatusMsg, asp=asp, aspInputTransactions=aspInputTransactions, aspOutputTransactions=aspOutputTransactions, aspInOpenSessions=aspInOpenSessions, aspOutOpenSessions=aspOutOpenSessions, aspInCloseSessions=aspInCloseSessions, aspOutCloseSessions=aspOutCloseSessions, aspNoMoreSessionsErrors=aspNoMoreSessionsErrors, aspTickleTimeOutCloses=aspTickleTimeOutCloses, aspConnTable=aspConnTable, aspConnEntry=aspConnEntry, aspConnLocalAddress=aspConnLocalAddress, aspConnRemoteAddress=aspConnRemoteAddress, aspConnID=aspConnID, aspConnLastReqNum=aspConnLastReqNum, aspConnServerEnd=aspConnServerEnd, aspConnState=aspConnState, adsp=adsp, adspInPkts=adspInPkts, adspOutPkts=adspOutPkts, adspInOctets=adspInOctets, adspOutOctets=adspOutOctets, adspInDataPkts=adspInDataPkts, adspOutDataPkts=adspOutDataPkts, adspTimeoutErrors=adspTimeoutErrors, adspTimeoutCloseErrors=adspTimeoutCloseErrors, adspConnTable=adspConnTable, adspConnEntry=adspConnEntry, adspConnLocalAddress=adspConnLocalAddress, adspConnLocalConnID=adspConnLocalConnID, adspConnRemoteAddress=adspConnRemoteAddress, adspConnRemoteConnID=adspConnRemoteConnID, adspConnState=adspConnState, atportptop=atportptop, atportPtoPTable=atportPtoPTable, atportPtoPEntry=atportPtoPEntry, atportPtoPIndex=atportPtoPIndex, atportPtoPProtocol=atportPtoPProtocol, atportPtoPRemoteName=atportPtoPRemoteName, atportPtoPRemoteAddress=atportPtoPRemoteAddress, atportPtoPPortIndex=atportPtoPPortIndex, atportPtoPStatus=atportPtoPStatus, atportPtoPProtoOids=atportPtoPProtoOids, pToPProtoOther=pToPProtoOther, pToPProtoAurp=pToPProtoAurp, pToPProtoCaymanUdp=pToPProtoCaymanUdp, pToPProtoAtkvmsDecnetIV=pToPProtoAtkvmsDecnetIV, pToPProtoLiaisonUdp=pToPProtoLiaisonUdp, pToPProtoIpx=pToPProtoIpx, pToPProtoShivaIp=pToPProtoShivaIp, rtmpStub=rtmpStub, rtmpOutRequestPkts=rtmpOutRequestPkts, rtmpInVersionMismatches=rtmpInVersionMismatches, rtmpInErrors=rtmpInErrors, zipEndNode=zipEndNode, zipNetInfoTable=zipNetInfoTable, zipNetInfoEntry=zipNetInfoEntry, zipOutGetNetInfos=zipOutGetNetInfos, zipInGetNetInfoReplies=zipInGetNetInfoReplies, zipZoneInInvalids=zipZoneInInvalids, zipInErrors=zipInErrors, perPort=perPort, perPortTable=perPortTable, perPortEntry=perPortEntry, perPortAarpInProbes=perPortAarpInProbes)
mibBuilder.exportSymbols("APPLETALK-MIB", perPortAarpOutProbes=perPortAarpOutProbes, perPortAarpInReqs=perPortAarpInReqs, perPortAarpOutReqs=perPortAarpOutReqs, perPortAarpInRsps=perPortAarpInRsps, perPortAarpOutRsps=perPortAarpOutRsps, perPortDdpInReceives=perPortDdpInReceives, perPortDdpInLocalDatagrams=perPortDdpInLocalDatagrams, perPortDdpNoProtocolHandlers=perPortDdpNoProtocolHandlers, perPortDdpTooShortErrors=perPortDdpTooShortErrors, perPortDdpTooLongErrors=perPortDdpTooLongErrors, perPortDdpChecksumErrors=perPortDdpChecksumErrors, perPortDdpForwRequests=perPortDdpForwRequests, perPortRtmpInDataPkts=perPortRtmpInDataPkts, perPortRtmpOutDataPkts=perPortRtmpOutDataPkts, perPortRtmpInRequestPkts=perPortRtmpInRequestPkts, perPortRtmpRouteDeletes=perPortRtmpRouteDeletes, perPortZipInZipQueries=perPortZipInZipQueries, perPortZipInZipReplies=perPortZipInZipReplies, perPortZipInZipExtendedReplies=perPortZipInZipExtendedReplies, perPortZipZoneConflictErrors=perPortZipZoneConflictErrors, perPortZipInErrors=perPortZipInErrors, perPortNbpInLookUpRequests=perPortNbpInLookUpRequests, perPortNbpInLookUpReplies=perPortNbpInLookUpReplies, perPortNbpInBroadcastRequests=perPortNbpInBroadcastRequests, perPortNbpInForwardRequests=perPortNbpInForwardRequests, perPortNbpOutLookUpReplies=perPortNbpOutLookUpReplies, perPortNbpRegistrationFailures=perPortNbpRegistrationFailures, perPortNbpInErrors=perPortNbpInErrors, perPortEchoRequests=perPortEchoRequests, perPortEchoReplies=perPortEchoReplies)

