# PySNMP SMI module. Autogenerated from smidump -f python APPLICATION-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:07 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, zeroDotZero, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2", "zeroDotZero")
( DateAndTime, TDomain, TextualConvention, TestAndIncr, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "TDomain", "TextualConvention", "TestAndIncr", "TimeStamp", "TruthValue")
( LongUtf8String, sysApplElmtRunIndex, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "LongUtf8String", "sysApplElmtRunIndex")

# Types

class ApplTAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,255)
    
class Unsigned64TC(Counter64):
    pass


# Objects

applicationMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 62)).setRevisions(("1998-11-17 18:15",))
if mibBuilder.loadTexts: applicationMib.setOrganization("Application MIB Working Group")
if mibBuilder.loadTexts: applicationMib.setContactInfo("http://www.ietf.org/html.charters/applmib-charter.html\n\nRandy Presuhn\nBMC Software, Inc.\n965 Stewart Drive\nSunnyvale, CA 94086\nUSA\n\nTelephone: +1 408 616-3100\nFacsimile: +1 408 616-3101\nEMail: randy_presuhn@bmc.com")
if mibBuilder.loadTexts: applicationMib.setDescription("This MIB defines objects representing generic aspects of\napplications that are of interest to management but typically\nrequire instrumentation within managed application elements.")
applicationMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 1))
applServiceGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 1, 1))
applSrvNameToSrvInstTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 1, 1))
if mibBuilder.loadTexts: applSrvNameToSrvInstTable.setDescription("The service name to service instance table uses\nservice name as its primary key, and service instance\nidentifier as its secondary key.  It facilitates the\nidentification and lookup of the instances of a given\nservice in a system.")
applSrvNameToSrvInstEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 1, 1, 1)).setIndexNames((0, "APPLICATION-MIB", "applSrvName"), (0, "APPLICATION-MIB", "applSrvIndex"))
if mibBuilder.loadTexts: applSrvNameToSrvInstEntry.setDescription("An applSrvNameToSrvInstEntry identifies an instance of\na given service.  The allocation and reservation\nof unique values for applSrvIndex is an administrative\nissue.\n\nAn applSrvNameToSrvInstEntry exists for the lifetime of\nthat instance of that service; the index values may not\nchange during that lifetime.  ")
applSrvInstQual = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 1, 1, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applSrvInstQual.setDescription("The value of applSrcInstQual provides additional\ninformation about this particular instance of this\nservice.\n\nAlthough not used for indexing purposes, the value of\nthis attribute should be sufficiently unique to be\nhelpful to an administrator in distinguishing among\nservice instances.  ")
applSrvInstToSrvNameTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 1, 2))
if mibBuilder.loadTexts: applSrvInstToSrvNameTable.setDescription("The service instance to service name table uses\nservice instance identifier as its primary key, and\nservice name as its secondary key.  Given a service\ninstance identifier, it facilitates the lookup of the\nname of the service being provided.")
applSrvInstToSrvNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 1, 2, 1)).setIndexNames((0, "APPLICATION-MIB", "applSrvIndex"), (0, "APPLICATION-MIB", "applSrvName"))
if mibBuilder.loadTexts: applSrvInstToSrvNameEntry.setDescription("An applSrvInstToSrvNameEntry maps a service instance\nidentifier back to a service name.")
applSrvName = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 1, 2, 1, 1), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applSrvName.setDescription("The human-readable name of a service.  Where\nappropriate, as in the case where a service can be\nidentified in terms of a single protocol, the strings\nshould be established names such as those assigned by\nIANA and found in STD 2 [13], or defined by some other\nauthority.  In some cases private conventions apply\nand the string should in these cases be consistent\nwith these non-standard conventions.   An applicability\nstatement may specify the service name(s) to be used.")
applSrvInstToRunApplElmtTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 1, 3))
if mibBuilder.loadTexts: applSrvInstToRunApplElmtTable.setDescription("The service instance to running application element\ntable uses the service instance identifier as its primary\nkey, and the running application element index as its\nsecondary key.  This facilitates the identification\nof the set of running application elements providing a\ngiven instance of a service.")
applSrvInstToRunApplElmtEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 1, 3, 1)).setIndexNames((0, "APPLICATION-MIB", "applSrvIndex"), (0, "SYSAPPL-MIB", "sysApplElmtRunIndex"))
if mibBuilder.loadTexts: applSrvInstToRunApplElmtEntry.setDescription("An applSrvInstToRunApplElmtEntry identifies a running\napplication element providing an instance of a service.\nNote that there may be multiple running application\nelements involved in the provision of an instance of\na service.")
applSrvIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: applSrvIndex.setDescription("An applSrvIndex is the system-unique identifier of\nan instance of a service.  The value is unique not only\nacross all instances of a given service, but also across\nall services in a system.\n\nRe-use of values for this index should be avoided.\nNo two service instances in a given system shall\nconcurrently have the same value for this index.\n\nThe value zero is excluded from the set of permitted\nvalues for this index.  This allows other tables to\npotentially represent things which cannot be associated\nwith a specific service instance.")
applRunApplElmtToSrvInstTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 1, 4))
if mibBuilder.loadTexts: applRunApplElmtToSrvInstTable.setDescription("The running application element to service instance\ntable uses the running application element index as\nits primary key and the service instance identifier as\nits secondary key.  It identifies the set of services\nprovided by a given running application element.")
applRunApplElmtToSrvInstEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 1, 4, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunIndex"), (0, "APPLICATION-MIB", "applSrvInstance"))
if mibBuilder.loadTexts: applRunApplElmtToSrvInstEntry.setDescription("An applRunApplElmtToSrvInstEntry serves to identify an\ninstance of a service being provided by a given running\napplication element.  Note that a particular running\napplication element may provide multiple services.")
applSrvInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 1, 4, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: applSrvInstance.setDescription("An applSrvInstance is the system-unique identifier of an\ninstance of a service.  The value is unique not only\nacross all instances of a given service, but also across\nall services.\n\nRe-use of values for this index should be avoided.\nNo two service instances in a given system shall\nconcurrently have the same value for this index.\nThe value zero is excluded from the set of permitted\nvalues for this index.  This allows other tables to\npotentially represent things which cannot be associated\nwith a specific service instance.\n\nThis attribute is semantically identical to\napplSrvIndex.")
applChannelGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 1, 2))
applOpenChannelTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 2, 1))
if mibBuilder.loadTexts: applOpenChannelTable.setDescription("The applOpenChannelTable reports information on open\nchannels for running application elements\nand for service instances.  This table is\nindexed by applElmtOrSvc, applElmtOrSvcId, and\napplOpenChannelIndex. This effectively groups all\nentries for a given running application element\nor service instance together.  ApplChannelIndex uniquely\nidentifies an open channel (and, consequently, a file\nor connection) within the context of a particular\nrunning application element or service instance.\n\nSome of the information in this table is available\nthrough both sixty-four and thirty-two bit counters.\nThe sixty-four bit counters are not accessible in\nprotocols that do not support this data type.")
applOpenChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applOpenChannelIndex"))
if mibBuilder.loadTexts: applOpenChannelEntry.setDescription("An applOpenChannelEntry indicates that a channel has been\nopened by this running application element or service\ninstance and is still open.  Note that if a file has been\nopened multiple times, even by the same process, it will\nhave multiple channel entries.")
applElmtOrSvc = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("service", 1), ("element", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applElmtOrSvc.setDescription("The applElmtOrSvc attribute serves as an index for tables\nthat can hold information both for individual running\napplication elements as well as for service instances.\n\nIf the value is service(1), the row contains information\ngathered at the level of a service.\n\nIf the value is element(2), the row contains information\nfor an individual running application element.")
applElmtOrSvcId = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applElmtOrSvcId.setDescription("The applElmtOrSvcId attribute is used as an index in\nconjunction with the applElmtOrSvc attribute.\n\nWhen the value of applElmtOrSvc is service(1), this\nattribute's value corresponds to that of applSrvIndex,\nwhen the value of applElmtOrSvc is element(2), this\nattribute's value corresponds to sysApplElmtRunIndex.")
applOpenChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 3), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applOpenChannelIndex.setDescription("This attribute serves to uniquely identify this open\nconnection in the context of the running application\nelement or service instance.  Where suitable, the\napplication's native descriptor number should be used.")
applOpenChannelOpenTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelOpenTime.setDescription("This attribute records the value of sysUpTime.0\nwhen this channel was opened and this entry was added to\nthis table.  This attribute serves as a discontinuity\nindicator for the counter attributes in this entry\nand for any corresponding entries in the\napplOpenConnectionTable, applOpenFileTable, and the\napplTransactionStreamTable.")
applOpenChannelReadRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelReadRequests.setDescription("This attribute reports the number of read requests\nfor this channel.  All read requests for this channel\nby this entity, regardless of completion status, are\nincluded in this count.\n\nRead requests are counted in terms of system calls,\nrather than API calls.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelReadRequestsLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelReadRequestsLow.setDescription("This attribute reports the low thirty-two bits of\napplOpenChannelReadRequests.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelReadFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelReadFailures.setDescription("This attribute reports the number of failed read\nrequests.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelBytesRead = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelBytesRead.setDescription("This attribute reports the number of bytes read from\nthis channel.  Only bytes successfully read are included\nin this count.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelBytesReadLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelBytesReadLow.setDescription("This attribute corresponds to the low thirty-two bits\nof applOpenChannelBytesRead.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelLastReadTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 10), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelLastReadTime.setDescription("This attribute reports the time of the most recent read\nrequest made by this entity, regardless of completion\nstatus, for this open channel.\n\nIf no read requests have been made the value of this\nattribute shall be '0000000000000000'H ")
applOpenChannelWriteRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 11), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelWriteRequests.setDescription("This attribute reports the number of write requests for\nthis channel made by this entity.  All write requests\nfor this channel, regardless of completion status, are\nincluded in this count.\n\nWrite requests are counted in terms of system calls,\nrather than API calls.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelWriteRequestsLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelWriteRequestsLow.setDescription("This attribute corresponds to the low thirty-two bits\nof applOpenChannelWriteRequests.\n\nDiscontinuities in this counter can be detected\nby monitoring the applOpenChannelOpenTime value for\nthis entry.")
applOpenChannelWriteFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelWriteFailures.setDescription("This attribute reports the number of failed write\nrequests.\n\nDiscontinuities in this counter can be detected\nby monitoring the applOpenChannelOpenTime value for\nthis entry.")
applOpenChannelBytesWritten = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 14), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelBytesWritten.setDescription("This attribute reports the number of bytes written to\nthis channel.  Only bytes successfully written (without\nerrors reported by the system to the API in use by the\napplication) are included in this count.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelBytesWrittenLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelBytesWrittenLow.setDescription("This attribute corresponds to the low thirty-two bits\nof applOpenChannelBytesWritten.\n\nDiscontinuities in this counter can be detected by\nmonitoring the applOpenChannelOpenTime value for this\nentry.")
applOpenChannelLastWriteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 1, 1, 16), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenChannelLastWriteTime.setDescription("This attribute reports the time of the most recent write\nrequest made by this running application element or\nservice instance, regardless of completion status, for\nthis open channel.\nIf no write requests have been made, the value\nof this attribute shall be '0000000000000000'H ")
applOpenFileTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 2, 2))
if mibBuilder.loadTexts: applOpenFileTable.setDescription("The applOpenFileTable reports information on open files\nfor service instances or application elements.  This\ntable is indexed by applElmtOrSvc and applElmtOrSvcId,\neffectively grouping all entries for a given running\nservice instance or application element together, and\nby applOpenChannelIndex, uniquely identifying an open\nchannel (and, consequently, a file) within the context\nof a particular service instance or application element.\n\nElements in this table correspond to elements in the\napplOpenChannelTable that represent files.  For rows in\nthe applOpenChannelTable that do not represent files,\ncorresponding rows in this table will not exist.")
applOpenFileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 2, 2, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applOpenChannelIndex"))
if mibBuilder.loadTexts: applOpenFileEntry.setDescription("An applOpenFileEntry indicates that a file has been\nopened by this running application element and is\nstill open.  Note that if a file has been opened\nmultiple times, even by the same process, it will have\nmultiple entries.")
applOpenFileName = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 2, 1, 1), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenFileName.setDescription("This attribute reports the name of this open file.\nWherever practical, a fully qualified path name should\nbe reported.\n\nThe values 'stdin', 'stdout', and 'stderr' are reserved\nin accordance with common usage when the fully qualified\npath name cannot be determined.")
applOpenFileSizeHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 2, 1, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenFileSizeHigh.setDescription("This file's current size in 2^32 byte blocks.\n\nFor example, for a file with a total size of 4,294,967,296\nbytes, this attribute would have a value of 1; for a file\nwith a total size of 4,294,967,295 bytes this attribute's\nvalue would be 0.")
applOpenFileSizeLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 2, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenFileSizeLow.setDescription("This file's current size modulo 2^32 bytes.\n\nFor example, for a file with a total size of\n4,294,967,296 bytes this attribute would have a value\nof 0; for a file with a total size of 4,294,967,295\nbytes this attribute's value would be 4,294,967,295.")
applOpenFileMode = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("read", 1), ("write", 2), ("readWrite", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenFileMode.setDescription("This attribute reports the current mode of this file from\nthe perspective of this running application element.\n\nThese values have the following meanings:\n\n    read(1) - file opened for reading only\n    write(2) - file opened for writing only\n    readWrite(3) - file opened for read and write.\n\nThese values correspond to the POSIX/ANSI C library\nfunction fopen() 'type' parameter, using the following\nmappings:\n\n    r -> read(1)\n    w -> write(2)\n    a -> write(2)\n    + -> readWrite(3)")
applOpenConnectionTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 2, 3))
if mibBuilder.loadTexts: applOpenConnectionTable.setDescription("The applOpenConnectionTable provides information about\nopen and listening connections from the perspective\nof a running application element or service instance.\nEntries in this table are indexed by applElmtOrSvc,\napplElmtOrSvcID, and by applOpenChannelIndex, which\nserves to uniquely identify each connection in the\ncontext of a service instance or running application\nelement.\n\nFor each row in this table, a corresponding row will\nexist in the applOpenChannel table.  For rows in the\napplOpenChannelTable which do not represent open or\nlistening connections, no corresponding rows will exist\nin this table.")
applOpenConnectionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applOpenChannelIndex"))
if mibBuilder.loadTexts: applOpenConnectionEntry.setDescription("An applOpenConnectionEntry indicates that a running\napplication element or service instance has an open\nconnection.  The entry has information describing that\nconnection.\n\nIn the case of a TCP transport, the element\napplOpenConnectionNearEndAddr and that row's\napplOpenConnectionFarEndAddr would correspond\nto a tcpConnEntry.  For a UDP transport, a\nsimilar relationship exists with respect to\na udpEntry.")
applOpenConnectionTransport = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1, 1), TDomain().clone('0.0')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenConnectionTransport.setDescription("The applOpenConnectionTransport attribute identifies the\ntransport protocol in use for this connection.  If it is\nnot practical to determine the underlying transport, this\nattribute's value shall have a value of {0 0}.")
applOpenConnectionNearEndAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1, 2), ApplTAddress().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenConnectionNearEndAddr.setDescription("The applOpenConnectionNearEndAddr attribute reports the\ntransport address and port information for the near end\nof this connection.\n\nIf the value is not known, the value has a  length\nof zero.")
applOpenConnectionNearEndpoint = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1, 3), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenConnectionNearEndpoint.setDescription("The applOpenConnectionNearEndpoint attribute reports the\nfully-qualified domain name and port information for the\nnear end of this connection.\n\nThe format of this attribute for TCP and UDP-based\nprotocols is the fully-qualified domain name immediately\nfollowed by a colon which is immediately followed by\nthe decimal representation of the port number.\n\nIf the value is not known, the value has a  length\nof zero.")
applOpenConnectionFarEndAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1, 4), ApplTAddress().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenConnectionFarEndAddr.setDescription("The applOpenConnectionFarEndAddr attribute reports the\ntransport address and port information for the far end\nof this connection.\n\nIf not known, as in the case of a connectionless\ntransport, the value of this attribute shall be a\nzero-length string.")
applOpenConnectionFarEndpoint = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1, 5), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenConnectionFarEndpoint.setDescription("The applOpenConnectionFarEndpoint attribute reports\nthe fully-qualified domain name and port information\nfor the far end of this connection.\n\nThe format of this attribute for TCP and UDP-based\nprotocols is the fully-qualified domain name immediately\nfollowed by a colon which is immediately followed by\nthe decimal representation of the port number.\n\nIf not known, as in the case of a connectionless\ntransport, the value of this attribute shall be a\nzero-length string.")
applOpenConnectionApplication = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 3, 1, 6), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applOpenConnectionApplication.setDescription("The applOpenConnectionApplication attribute identifies\nthe application layer protocol in use.  If not known,\nthe value of this attribute shall be a zero-length\nstring.\n\nWhen possible, protocol names should be those used in\nthe 'ASSIGNED NUMBERS' [13].  For example, an SMTP mail\nserver would use 'SMTP'.")
applTransactionStreamTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 2, 4))
if mibBuilder.loadTexts: applTransactionStreamTable.setDescription("The applTransactionStreamTable contains common\ninformation for transaction statistic accumulation.")
applTransactionStreamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applOpenChannelIndex"))
if mibBuilder.loadTexts: applTransactionStreamEntry.setDescription("An applTransactionStreamEntry contains information for\na single transaction stream.  A transaction stream\ncan be a network connection, file, or other source\nof transactions.")
applTransactStreamDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 1), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamDescr.setDescription("The applTransactStreamDescr attribute provides a\nhuman-readable description of this transaction stream.\nIf no descriptive information is available, this\nattribute's value shall be a zero-length string.")
applTransactStreamUnitOfWork = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 2), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamUnitOfWork.setDescription("The applTransactStreamUnitOfWork attribute provides a\nhuman-readable definition of what the unit of work is\nfor this transaction stream.\n\nIf no descriptive information is available, this\nattribute's value shall be a zero-length string.")
applTransactStreamInvokes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamInvokes.setDescription("Cumulative count of requests / invocations issued.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamInvokesLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamInvokesLow.setDescription("This counter corresponds to the low thirty-two\nbits of applTransactStreamInvokes.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamInvCumTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamInvCumTimes.setDescription("The applTransactStreamInvCumTimes attribute reports the\ncumulative sum of the lengths of the intervals measured\nbetween the transmission of requests and the receipt of\n(the first of) the corresponding response(s).\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamInvRspTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamInvRspTimes.setDescription("The applTransactStreamInvRspTimes attribute reports the\ncumulative sum of the lengths of the intervals measured\nbetween the receipt of the first and last of multiple\nresponses to a request.\n\nFor transaction streams which do not permit multiple\nresponses to a single request, this attribute will be\nconstant.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamPerforms = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamPerforms.setDescription("Cumulative count of transactions performed.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamPerformsLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamPerformsLow.setDescription("This counter reports the low thirty-two bits of\napplTransactStreamPerforms.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamPrfCumTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamPrfCumTimes.setDescription("The applTransactStreamPrfCumTimes attribute reports the\ncumulative sum of the interval lengths measured between\nreceipt of requests and the transmission of the\ncorresponding responses.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactStreamPrfRspTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactStreamPrfRspTimes.setDescription("For each transaction performed, the elapsed time between\nwhen the first response is enqueued and when the last\nresponse is enqueued is added to this cumulative sum.\n\nFor single-response protocols, the value of\napplTransactStreamPrfRspTimes will be constant.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactFlowTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 2, 5))
if mibBuilder.loadTexts: applTransactFlowTable.setDescription("The applTransactFlowTable contains entries, organized by\napplication instance or running application element,\ndirection of flow, and type (request/response) for each\nopen transaction stream.\n\nThe simple model of a transaction used here looks like\nthis:\n\n    invoker  |   Request     | performer\n             | - - - - - - > |\n             |               |\n             |   Response    |\n             | < - - - - - - |\n             |               |\n\nSince in some protocols it is possible for an entity\nto take on both the invoker and performer roles,\ninformation here is accumulated for transmitted and\nreceived requests, as well as for transmitted and\nreceived responses.  Counts are maintained for both\ntransactions and bytes transferred.")
applTransactFlowEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applOpenChannelIndex"), (0, "APPLICATION-MIB", "applTransactFlowDirection"), (0, "APPLICATION-MIB", "applTransactFlowReqRsp"))
if mibBuilder.loadTexts: applTransactFlowEntry.setDescription("An applTransactFlowEntry reports transaction throughput\ninformation for requests or response in a particular\ndirection (transmit / receive) for a transaction stream.\n\nEntries in this table correspond to those in the\napplTransactionStreamTable with identical values for the\napplElmtOrSvc, applElmtOrSvcId, and applOpenChannelIndex.\n\nFor all counter objects in one of these entries,\nthe corresponding (same value for applElmtOrSvc,\napplElmtOrSvcId, and applOpenChannelIndex)\napplOpenChannelOpenTime object serves as a discontinuity\nindicator.  ")
applTransactFlowDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("transmit", 1), ("receive", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applTransactFlowDirection.setDescription("The applTransactFlowDirection index serves to identify\nan entry as containing information pertaining to the\ntransmit (1) or receive (2) flow of a transaction\nstream.")
applTransactFlowReqRsp = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("request", 1), ("response", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applTransactFlowReqRsp.setDescription("The value of the applTransactFlowReqRsp index indicates\nwhether this entry contains information on requests\n(1), or responses (2).")
applTransactFlowTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactFlowTrans.setDescription("The applTransactFlowTrans attribute reports the number\nof request/response transactions (as indicated by\nthe applTransactFlowReqRsp index) received/generated\n(as indicated by the applTransactFlowDirection index)\nthat this service instance or running application\nelement has processed for this transaction stream.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactFlowTransLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactFlowTransLow.setDescription("This attribute corresponds to the low thirty-two\nbits of applTransactFlowTrans.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactFlowBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactFlowBytes.setDescription("The applTransactFlowBytes attribute reports the number\nof request/response (as indicated by the\napplTransactFlowReqRsp index) bytes received/generated\n(as indicated by the applTransactFlowDirection index)\nhandled by this application element or service instance\non this transaction stream.\n\nAll application layer bytes are included in this count,\nincluding any application layer wrappers, headers, or\nother overhead.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactFlowBytesLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactFlowBytesLow.setDescription("This attribute corresponds to the low thirty-two\nbits of applTransactFlowBytes.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactFlowTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 5, 1, 7), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactFlowTime.setDescription("The applTransactFlowTime attribute records the time of\nthe processing (receipt or transmission as indicated\nby the applTransactFlowDirection index) by this\nrunning application element or service instance of\nthe most recent request/response (as indicated by\nthe applTransactFlowReqRsp index) on this transaction\nstream.\n\nIf no requests/responses been received/transmitted by\nthis entity over this transaction stream, the value\nof this attribute shall be '0000000000000000'H ")
applTransactKindTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 2, 6))
if mibBuilder.loadTexts: applTransactKindTable.setDescription("The applTransactKindTable provides transaction statistics\nbroken down by kinds of transaction.  The definition of\nthe kinds of transactions is specific to the application\nprotocol in use, and may be documented in the form of an\napplicability statement.  ")
applTransactKindEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applOpenChannelIndex"), (0, "APPLICATION-MIB", "applTransactFlowDirection"), (0, "APPLICATION-MIB", "applTransactFlowReqRsp"), (0, "APPLICATION-MIB", "applTransactKind"))
if mibBuilder.loadTexts: applTransactKindEntry.setDescription("An applTransactKindEntry reports information for a\nspecific service instance or running application\nelement's use of a specific transaction stream in\na particular direction in requests or responses\n(as indicated by the applTransactFlowReqRsp index)\nbroken down by transaction kind, as indicated by the\napplTransactKind index.\n\nDiscontinuities in any of the counters in an entry can\nbe detected by monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactKind = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applTransactKind.setDescription("The applTransactKind index is the human-readable\nidentifier for a particular transaction kind within\nthe context of an application protocol.  The values\nto be used for a particular protocol may be identified\nin an applicability statement.")
applTransactKindTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactKindTrans.setDescription("The applTransactKindTrans attribute reports the number\nof request/response (as indicated by the\napplTransactFlowReqRsp index) transactions\nreceived/generated (as indicated by the\napplTransactFlowDirection index) handled by this\napplication instance or application element on this\ntransaction stream for this transaction kind.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactKindTransLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactKindTransLow.setDescription("The applTransactKindTransLow attribute reports\nthe low thirty-two bits of applTransactKindTrans.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactKindBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactKindBytes.setDescription("The applTransactKindBytes attribute reports the number\nof request/response (as indicated by the\napplTransactFlowReqRsp index) bytes received/generated\n(as indicated by the applTransactFlowDirection index)\nhandled by this application element on this transaction\nstream for this transaction kind.\n\nAll application layer bytes are included in this count,\nincluding any application layer wrappers, headers, or\nother overhead.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactKindBytesLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactKindBytesLow.setDescription("The applTransactKindBytesLow attribute corresponds\nto the low thirty-two bits of applTransactKindBytes.\n\nDiscontinuities in this counter can be detected\nby monitoring the corresponding instance of\napplOpenChannelOpenTime.")
applTransactKindTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 2, 6, 1, 6), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applTransactKindTime.setDescription("The applTransactKindTime attribute records the time of\nthe processing (receipt or transmission as indicated\nby the applTransactFlowDirection index) by this\nrunning application element or service instance of\nthe most recent request/response (as indicated by\nthe applTransactFlowReqRsp index) of this kind of\ntransaction on this transaction stream.\n\nIf no requests/responses of this kind been\nreceived/transmitted by this running application element\nor service instance over this transaction stream, the\nvalue of this attribute shall be '0000000000000000'H ")
applPastChannelGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 1, 3))
applPastChannelControlTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 1))
if mibBuilder.loadTexts: applPastChannelControlTable.setDescription("The applPastChannelControlTable controls the\naccumulation of history information about channels\nfrom the perspective of service instances and running\napplication elements.  Entries in this table are indexed\nby applElmtOrSvc and applElmtOrSvcId, giving control\nof channel history accumulation at the level of each\nservice instance and running application element.")
applPastChannelControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 1, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"))
if mibBuilder.loadTexts: applPastChannelControlEntry.setDescription("An applPastChannelControlEntry provides the ability\nto control the retention of channel history information\nby service instances and running application elements.")
applPastChannelControlCollect = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("frozen", 2), ("disabled", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: applPastChannelControlCollect.setDescription("When the value of applPastChannelControlCollect is\n'enabled', each time the corresponding running\napplication element or service instance closes\nan open channel a new entry will be added to the\napplPastChannelTable.\n\nWhen the value of applPastChannelControlCollect\nis 'frozen', no new entries are added to the\napplPastChannelTable for this running application\nelement or service instance, and old entries are not\naged out.\n\nWhen the value of applPastChannelControlCollect\nis 'disabled', all entries are removed from\napplPastChannelTable for this running application or\nservice instance, and no new entries are added.")
applPastChannelControlMaxRows = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 1, 1, 2), Unsigned32().clone(500)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: applPastChannelControlMaxRows.setDescription("The maximum number of entries allowed in the\napplPastChannelTable for this running application element\nor service instance.  Once the number of rows for this\nrunning application element or service instance in the\napplPastChannelTable reaches this value, when new\nentries are to be added the management subsystem will\nmake room for them by removing the oldest entries.\nEntries will be removed on the basis of oldest\napplPastChannelCloseTime value first.")
applPastChannelControlTimeLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 1, 1, 3), Unsigned32().clone(7200)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: applPastChannelControlTimeLimit.setDescription("The maximum time in seconds which an entry for this\nrunning application element or service instance\nmay exist in the applPastChannelTable before it\nis removed.  Any entry that is older than this value\nwill be removed (aged out) from the table, unless the\napplPastChannelControlCollect is set to 'frozen'.\n\nNote that an entry may be aged out prior to reaching\nthis time limit if it is the oldest entry in the table\nand must be removed to make space for a new entry so\nas to not exceed applPastChannelControlMaxRows, or if the\napplPastChannelControlCollect is set to 'disabled'.")
applPastChannelControlRemItems = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelControlRemItems.setDescription("The applPastChannelControlRemItems attribute reports the\nnumber of applPastChannelControlTable entries for this\nrunning application element or service instance that\nwere deleted in order to make room for new history\nentries.\n\nThis count does NOT include entries deleted for the\nfollowing reasons:\n    - the corresponding applPastChannelControlCollect\n      attribute has been set to 'disabled'\n\n    - the entry has been in the table longer that the\n      time limit indicated by the corresponding\n      applPastChannelControlTimeLimit.")
applPastChannelTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 2))
if mibBuilder.loadTexts: applPastChannelTable.setDescription("The applPastChannelTable provides history information\nabout channels from the perspective of running\napplication elements and service instances.\nEntries in this table are indexed by applElmtOrSvc,\napplElmtOrSvcId, and by applPastChannelIndex, which\nserves to uniquely identify each former channel in the\ncontext of a running application element or service\ninstance.\n\nNote that the value of applPastChannelIndex is\nindependent of the value applOpenChannelIndex had when\nthis channel was open.\n\nEntries for closed channels for a given running\napplication element or service instance can\nbe added to this table only if its entry in the\napplPastChannelControlTable has the value 'enabled'\nfor the attribute applPastChannelControlCollect.\n\nEntries for closed channels are removed under the\nfollowing circumstances:\n\n    - the running application element or service\n      instance no longer exists\n\n    - the corresponding applPastChannelControlCollect\n      attribute has been set to 'disabled'\n\n    - the entry has been in the table longer that the\n      time limit indicated by the corresponding\n      applPastChannelControlTimeLimit and the value of\n      applPastChannelControlCollect is not 'frozen'\n\n    - this is the oldest entry for the running\n      application element or service instance in\n      question and the addition of a new element would\n      otherwise cause applPastChannelControlMaxRows to\n      be exceeded for this running application element\n      or service instance.\n\n    - a value of applPastChannelIndex has been re-used.\n      Note that under normal circumstances, this is\n      unlikely.\n\nRemoval/replacement of an entry under the\nlast two conditions causes the corresponding\napplPastChannelControlRemItems to be incremented.")
applPastChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applPastChannelIndex"))
if mibBuilder.loadTexts: applPastChannelEntry.setDescription("An applPastChannelEntry indicates that a running\napplication element or service instance once had an open\nchannel, which is now closed.  The entry has information\ndescribing that channel.")
applPastChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applPastChannelIndex.setDescription("This attribute serves to uniquely identify this closed\nchannel in the context of the running application\nelement or service instance.  This attribute has no\nother semantics.\n\nNote that the value of applPastChannelIndex is\nindependent of the value applOpenChannelIndex had when\nthis channel was active.\n\nIn issuing this index value, the implementation must\navoid re-issuing an index value which has already been\nassigned to an entry which has not yet been deleted due\nto age or space considerations.\n\nThe value zero is excluded from the set of permitted\nvalues for this index in order to permit other tables to\npossibly represent information that cannot be associated\nwith a specific entry in this table.  ")
applPastChannelOpenTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelOpenTime.setDescription("This attribute records the time when this channel was\noriginally opened.  Note that this information is quite\ndifferent from applOpenChannelOpenTime, which is used\nfor the detection of counter discontinuities.")
applPastChannelCloseTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelCloseTime.setDescription("This attribute records the time when this channel\nwas closed.")
applPastChannelReadRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 4), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelReadRequests.setDescription("This attribute records the number of read requests for\nthis channel made by this running application element or\nservice instance.  All read requests for this channel by\nthis running application element or service instance,\nregardless of completion status, are included in this\ncount.  Read requests are counted in terms of system\ncalls, rather than API calls.")
applPastChannelReadReqsLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelReadReqsLow.setDescription("This attribute corresponds to the low thirty-two bits\nof applPastChannelReadRequests.")
applPastChannelReadFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelReadFailures.setDescription("This attribute reports the number of failed read\nrequests.")
applPastChannelBytesRead = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 7), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelBytesRead.setDescription("This attribute reports the number of bytes read from this\nchannel by this running application element or service\ninstance.  Only bytes successfully read are included in\nthis count. ")
applPastChannelBytesReadLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelBytesReadLow.setDescription("This attribute corresponds to the low thirty-two bits\nof applPastChannelBytesRead.")
applPastChannelLastReadTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 9), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelLastReadTime.setDescription("This attribute reports the time of the most recent read\nrequest made by this running application element or\nservice instance regardless of completion status, for\nthis former channel.\n\nIf no read requests have been made , the value of this\nattribute shall be '0000000000000000'H ")
applPastChannelWriteRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 10), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelWriteRequests.setDescription("The applPastChannelWriteRequests attribute reports\nthe number of write requests, regardless of completion\nstatus, made by this running application element or\nservice instance for this former channel.\n\nWrite requests are counted in terms of system calls,\nrather than API calls.")
applPastChannelWriteReqsLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelWriteReqsLow.setDescription("This attribute corresponds to the low thirty-two\nbits of applPastChannelWriteRequests.")
applPastChannelWriteFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelWriteFailures.setDescription("This attribute reports the number of failed write\nrequests.")
applPastChannelBytesWritten = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 13), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelBytesWritten.setDescription("This attribute reports the number of bytes written to\nthis former channel by this running application element\nor service instance.  Only bytes successfully written\n(no errors reported by the API in use by the application)\nare included in this count.")
applPastChannelBytesWritLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 14), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelBytesWritLow.setDescription("This attribute corresponds to the low thirty-two bits of\napplPastChannelBytesWritten.")
applPastChannelLastWriteTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 2, 1, 15), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastChannelLastWriteTime.setDescription("The applPastChannelLastWriteTime attribute reports\nthe time of the most recent write request made by\nthis running application element or service instance,\nregardless of completion status, for this former\nchannel.\n\nIf no write requests have been made the value of this\nattribute shall be '0000000000000000'H ")
applPastFileTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 3))
if mibBuilder.loadTexts: applPastFileTable.setDescription("The applPastFileTable supplements the\napplPastChannelTable for entries corresponding to\nchannels which were files.  The indexing structure is\nidentical to applPastChannelTable.  An entry exists in\nthe applPastFileTable only if there is a corresponding\n(same index values) entry in the applPastChannelTable\nand if the channel was a file.\n\nEntries for closed files are removed when the\ncorresponding entries are removed from the\napplPastChannelTable.")
applPastFileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 3, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applPastChannelIndex"))
if mibBuilder.loadTexts: applPastFileEntry.setDescription("An applPastFileEntry provides additional, file-specific\ninformation to complement the corresponding\napplPastChannelEntry for a channel which was a file.")
applPastFileName = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 3, 1, 1), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastFileName.setDescription("This attribute records the last known value of\napplOpenFileName before the channel was closed.")
applPastFileSizeHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 3, 1, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastFileSizeHigh.setDescription("This attribute records the value of applOpenFileSizeHigh\nat the time this channel was closed.\n\nFor example, for a file with a total size of\n4,294,967,296 bytes, this attribute would have a value\nof 1; for a file with a total size of 4,294,967,295\nbytes this attribute's value would be 0.")
applPastFileSizeLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 3, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastFileSizeLow.setDescription("This attribute records the value of applOpenFileSizeLow\nat the time this channel was closed.\n\nFor example, for a file with a total size of\n4,294,967,296 bytes this attribute would have a value\nof 0; for a file with a total size of 4,294,967,295\nbytes this attribute's value would be 4,294,967,295.")
applPastFileMode = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("read", 1), ("write", 2), ("readWrite", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastFileMode.setDescription("This attribute records the value of applOpenFileMode\nat the time this channel was closed.  ")
applPastConTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 4))
if mibBuilder.loadTexts: applPastConTable.setDescription("The applPastConTable supplements the applPastChannelTable\nfor entries corresponding to channels which were\nconnections.  The indexing structure is identical\nto applPastChannelTable.  An entry exists in the\napplPastConTable only if there is a corresponding\n(same index values) entry in the applPastChannelTable\nand if the channel was a connection.\n\nEntries for closed connections are removed when\nthe corresponding entries are removed from the\napplPastChannelTable.")
applPastConEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applPastChannelIndex"))
if mibBuilder.loadTexts: applPastConEntry.setDescription("An applPastConEntry provides additional,\nconnection-specific information to complement the\ncorresponding applPastChannelEntry for a channel which\nwas a connection.")
applPastConTransport = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1, 1), TDomain().clone('0.0')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastConTransport.setDescription("The applPastConTransport attribute identifies the\ntransport protocol that was in use for this former\nconnection.  If the transport protocol could not be\ndetermined, the value { 0 0 } shall be used.")
applPastConNearEndAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1, 2), ApplTAddress().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastConNearEndAddr.setDescription("The applPastConNearEndAddr attribute reports the\ntransport address and port information for the near\nend of this former connection.\n\nIf the information could not be determined, the value\nshall be a zero-length string.")
applPastConNearEndpoint = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1, 3), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastConNearEndpoint.setDescription("The applPastConNearEndpoint attribute reports the\nfully-qualified domain name and port information for the\nnear end of this former connection.\n\nThe format of this attribute for TCP and UDP-based\nprotocols is the fully-qualified domain name immediately\nfollowed by a colon which is immediately followed by\nthe decimal representation of the port number.\n\nIf the information could not be determined, the value\nshall be a zero-length string.")
applPastConFarEndAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1, 4), ApplTAddress().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastConFarEndAddr.setDescription("The applPastConFarEnd attribute reports the transport\naddress and port information for the far end of this\nformer connection.\n\nIf not known, as in the case of a connectionless\ntransport, the value of this attribute shall be a\nzero-length string.")
applPastConFarEndpoint = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1, 5), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastConFarEndpoint.setDescription("The applPastConFarEndpoint attribute reports the\ntransport address and port information for the far\nend of this former connection.\n\nThe format of this attribute for TCP and UDP-based\nprotocols is the fully-qualified domain name immediately\nfollowed by a colon which is immediately followed by\nthe decimal representation of the port number.\n\nIf not known, as in the case of a connectionless\ntransport, the value of this attribute shall be a\nzero-length string.")
applPastConApplication = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 4, 1, 6), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastConApplication.setDescription("The applPastConApplication attribute identifies the\napplication layer protocol that was in use.  Where\npossible, the values defined in [13] shall be used.\nIf not known, the value of this attribute shall be a\nzero-length string.")
applPastTransStreamTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 5))
if mibBuilder.loadTexts: applPastTransStreamTable.setDescription("The applPastTransStreamTable contains common\ninformation for historical transaction statistics.")
applPastTransStreamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applPastChannelIndex"))
if mibBuilder.loadTexts: applPastTransStreamEntry.setDescription("An applPastTransStreamEntry contains information for\na single former transaction stream.  A transaction\nstream could have been a network connection, file, or\nother source of transactions.")
applPastTransStreamDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 1), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamDescr.setDescription("The applPastTransStreamDescr attribute provides a\nhuman-readable description of this transaction stream.\n\nIf no descriptive information is available, this\nattribute's value shall be a zero-length string.")
applPastTransStreamUnitOfWork = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 2), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamUnitOfWork.setDescription("The applPastTransStreamUnitOfWork attribute provides a\nhuman-readable definition of what the unit of work is\nfor this transaction stream.\n\nIf no descriptive information is available, this\nattribute's value shall be a zero-length string.")
applPastTransStreamInvokes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 3), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamInvokes.setDescription("Cumulative count of requests / invocations issued\nfor this transaction stream when it was active.")
applPastTransStreamInvokesLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamInvokesLow.setDescription("This object corresponds to the low thirty-two\nbits of applPastTransStreamInvokes.")
applPastTransStreamInvCumTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamInvCumTimes.setDescription("The applPastTransStreamInvCumTimes attribute reports the\ncumulative sum of the lengths of the intervals times\nmeasured between the transmission of requests and the\nreceipt of (the first of) the corresponding response(s).")
applPastTransStreamInvRspTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamInvRspTimes.setDescription("The applPastTransStreamInvRspTimes attribute reports the\ncumulative sum of the lengths of the intervals measured\nbetween the receipt of the first and last of multiple\nresponses to a request.\n\nFor transaction streams which do not permit multiple\nresponses to a single request, this attribute will be\nzero.")
applPastTransStreamPerforms = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 7), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamPerforms.setDescription("Total number of transactions performed.")
applPastTransStreamPerformsLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamPerformsLow.setDescription("This objecy reports the low thirty-two bits of\napplPastTransStreamPerforms.")
applPastTransStreamPrfCumTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamPrfCumTimes.setDescription("The applPastTransStreamPrfCumTimes attribute reports the\ncumulative sum of the lengths of the intervals measured\nbetween receipt of requests and the transmission of the\ncorresponding responses.")
applPastTransStreamPrfRspTimes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 5, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransStreamPrfRspTimes.setDescription("For each transaction performed, the elapsed time between\nwhen the first response is enqueued and when the last\nresponse is enqueued is added to this cumulative sum.\n\nFor single-response protocols, the value of\napplPastTransStreamPrfRspTimes will be zero.")
applPastTransFlowTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 6))
if mibBuilder.loadTexts: applPastTransFlowTable.setDescription("The applPastTransFlowTable contains entries, organized by\napplication instance or running application element,\ndirection of flow, and type (request/response) for each\nformer transaction stream.\n\nThe simple model of a transaction used here looks like\nthis:\n\n    invoker  |   Request     | performer\n             | - - - - - - > |\n             |               |\n             |   Response    |\n             | < - - - - - - |\n             |               |\n\nSince in some protocols it is possible for an entity\nto take on both the invoker and performer roles,\ninformation here is accumulated for transmitted and\nreceived requests, as well as for transmitted and\nreceived responses.  Counts are maintained for both\ntransactions and bytes transferred.")
applPastTransFlowEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applPastChannelIndex"), (0, "APPLICATION-MIB", "applPastTransFlowDirection"), (0, "APPLICATION-MIB", "applPastTransFlowReqRsp"))
if mibBuilder.loadTexts: applPastTransFlowEntry.setDescription("An applPastTransFlowEntry records transaction throughput\ninformation for requests or response in a particular\ndirection (transmit / receive) for a transaction stream.\n\nEntries in this table correspond to those in the\napplPastTransStreamTable with identical values\nfor the applElmtOrSvc, applElmtOrSvcId, and the\napplPastChannelIndex.")
applPastTransFlowDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("transmit", 1), ("receive", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applPastTransFlowDirection.setDescription("The applPastTransFlowDirection index serves\nto identify an entry as containing information\npertaining to the transmit (1) or receive (2) flow\nof a past transaction stream.  This index corresponds\nto applTransactFlowDirection.")
applPastTransFlowReqRsp = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("request", 1), ("response", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applPastTransFlowReqRsp.setDescription("The value of the applPastTransFlowReqRsp index indicates\nwhether this entry contains information on requests\n(1), or responses (2).  This index corresponds to\napplTransactFlowReqRsp.")
applPastTransFlowTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 3), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransFlowTrans.setDescription("The applPastTransFlowTrans attribute reports the number\nof request/response (as indicated by the\napplPastTransFlowReqRsp index) transactions\nreceived/generated (as indicated by the\napplPastTransFlowDirection index) handled on this\ntransaction stream.")
applPastTransFlowTransLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransFlowTransLow.setDescription("This attribute corresponds to the low thirty-two\nbits of applPastTransFlowTrans.")
applPastTransFlowBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 5), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransFlowBytes.setDescription("The applPastTransFlowBytes attribute reports the number\nof request/response (as indicated by the\napplPastTransFlowReqRsp index) bytes received/generated\n(as indicated by the applPastTransFlowDirection index)\nhandled on this transaction stream.\n\nAll application layer bytes are included in this count,\nincluding any application layer wrappers, headers, or\nother overhead.")
applPastTransFlowBytesLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransFlowBytesLow.setDescription("This attribute corresponds to the low thirty-two\nbits of applPastTransFlowBytes.")
applPastTransFlowTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 6, 1, 7), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransFlowTime.setDescription("The applPastTransFlowTime attribute records the time of\nthe processing (receipt or transmission as\nindicated by the applPastTransFlowDirection index)\nof the last request/response (as indicated by the\napplPastTransFlowReqRsp index) on this transaction\nstream.\n\nIf no requests/responses been received/transmitted by\nthis entity over this transaction stream, the value\nof this attribute shall be '0000000000000000'H ")
applPastTransKindTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 3, 7))
if mibBuilder.loadTexts: applPastTransKindTable.setDescription("The applPastTransKindTable provides transaction\nstatistics broken down by kinds of transaction.\nThe definition of the kinds of transactions is\nspecific to the application protocol in use, and may be\ndocumented in the form of an applicability statement.  ")
applPastTransKindEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1)).setIndexNames((0, "APPLICATION-MIB", "applElmtOrSvc"), (0, "APPLICATION-MIB", "applElmtOrSvcId"), (0, "APPLICATION-MIB", "applPastChannelIndex"), (0, "APPLICATION-MIB", "applPastTransFlowDirection"), (0, "APPLICATION-MIB", "applPastTransFlowReqRsp"), (0, "APPLICATION-MIB", "applPastTransKind"))
if mibBuilder.loadTexts: applPastTransKindEntry.setDescription("An applPastTransKindEntry reports historical data for a\nspecific service instance or running application\nelement's use of a specific transaction stream in\na particular direction in requests or responses\n(as indicated by the applPastTransFlowReqRsp index)\nbroken down by transaction kind, as indicated by the\napplPastTransKind index.")
applPastTransKind = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: applPastTransKind.setDescription("The applPastTransKind index is the human-readable\nidentifier for a particular transaction kind within\nthe context of an application protocol.  The values\nto be used for a particular protocol may be identified\nin an applicability statement.  This index corresponds\nto applTransactKind.")
applPastTransKindTrans = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1, 2), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransKindTrans.setDescription("For this transaction stream, this attribute records\nthe total number of transactions of the type\nidentified by the indexes.  The type is characterized\naccording to the receive/transmit direction\n(applPastTransFlowDirecton), whether it was a request\nor a response (applPastTransFlowReqRsp), and the\nprotocol-specific transaction kind (applPastTransKind).\nstream for this transaction kind.")
applPastTransKindTransLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransKindTransLow.setDescription("The applPastTransKindTransLow attribute reports\nthe low thirty-two bits of applPastTransKindTrans.")
applPastTransKindBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1, 4), Unsigned64TC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransKindBytes.setDescription("For this transaction stream and transaction kind, the\napplPastTransKindBytes attribute reports the number\nof bytes received or generated (as indicated by\nthe applPastTransFlowDirection index) in requests or\nresponses (as indicated by the applPastTransFlowReqRsp\nindex).\n\nAll application layer bytes are included in this count,\nincluding any application layer wrappers, headers, or\nother overhead.")
applPastTransKindBytesLow = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransKindBytesLow.setDescription("The applPastTransKindBytesLow attribute corresponds\nto the low thirty-two bits of applPastTransKindBytes.")
applPastTransKindTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 3, 7, 1, 6), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applPastTransKindTime.setDescription("The applPastTransKindTime attribute records the time of\nthe processing (receipt or transmission as\nindicated by the applPastTransFlowDirection index)\nof the last request/response (as indicated by the\napplPastTransFlowReqRsp index) of this kind of\ntransaction on this transaction stream.\n\nIf no requests/responses of this kind were\nreceived/transmitted over this transaction stream, the\nvalue of this attribute shall be '0000000000000000'H ")
applElmtRunControlGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 1, 4))
applElmtRunStatusTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 4, 1))
if mibBuilder.loadTexts: applElmtRunStatusTable.setDescription("This table provides information on running application\nelements, complementing information available in the\ncorrespondingly indexed sysApplElmtRunTable [31].")
applElmtRunStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunIndex"))
if mibBuilder.loadTexts: applElmtRunStatusEntry.setDescription("An applElmtRunStatusEntry contains information to support\nthe control and monitoring of a single running application\nelement.")
applElmtRunStatusSuspended = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applElmtRunStatusSuspended.setDescription("The applElmtRunStatusSuspended attribute reports\nwhether processing by this running application element\nhas been suspended, whether by management request or by\nother means.")
applElmtRunStatusHeapUsage = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1, 2), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applElmtRunStatusHeapUsage.setDescription("The applElmtRunStatusHeapUsage reports the current\napproximate heap usage by this running application\nelement.")
applElmtRunStatusOpenConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applElmtRunStatusOpenConnections.setDescription("The applElmtRunStatusOpenConnections attribute reports\nthe current number of open connections in use by this\nrunning application element.")
applElmtRunStatusOpenFiles = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: applElmtRunStatusOpenFiles.setDescription("The applElmtRunStatusOpenFiles attribute reports the\ncurrent number of open files in use by this running\napplication element.")
applElmtRunStatusLastErrorMsg = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1, 5), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applElmtRunStatusLastErrorMsg.setDescription("The applElmtRunStatusLastErrorMessage attribute reports\nthe most recent error message (typically written to\nstderr or a system error logging facility) from this\nrunning application element.  If no such message has yet\nbeen generated, the value of this attribute shall be a\nzero-length string.")
applElmtRunStatusLastErrorTime = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 1, 1, 6), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: applElmtRunStatusLastErrorTime.setDescription("The applElmtRunStatusLastErrorTime attribute reports the\ntime of the most recent error message in\napplElmtRunStatusLastErrorMsg.\n\nIf no such message has yet been generated, the value\nof this attribute shall be '0000000000000000'H ")
applElmtRunControlTable = MibTable((1, 3, 6, 1, 2, 1, 62, 1, 4, 2))
if mibBuilder.loadTexts: applElmtRunControlTable.setDescription("This table provides the ability to control application\nelements, complementing information available in the\ncorrespondingly indexed sysApplElmtRunTable [31].")
applElmtRunControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 62, 1, 4, 2, 1)).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunIndex"))
if mibBuilder.loadTexts: applElmtRunControlEntry.setDescription("An applElmtRunControlEntry contains information to\nsupport the control of a single running application\nelement.")
applElmtRunControlSuspend = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 2, 1, 1), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: applElmtRunControlSuspend.setDescription("Setting this variable to 'true' requests the suspension\nof processing by this running application element.\nSetting this variable to 'false' requests that processing\nbe resumed.  The effect, if any, will be reported by the\napplElmtRunStatusSuspended attribute.")
applElmtRunControlReconfigure = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 2, 1, 2), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: applElmtRunControlReconfigure.setDescription("Changing the value of this variable requests that the\nrunning application element re-load its configuration\n(like SIGHUP for many UNIX-based daemons).\n\nNote that completion of a SET on this object only implies\nthat configuration reload was initiated, not necessarily\nthat the reload has been completed.")
applElmtRunControlTerminate = MibTableColumn((1, 3, 6, 1, 2, 1, 62, 1, 4, 2, 1, 3), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: applElmtRunControlTerminate.setDescription("Setting the value of applElmtRunControlTerminate to\n'true' requests that the running application element\nterminate processing and exit in an orderly manner.\nThis is a 'polite' shutdown request.\n\nWhen read, this object's value will be 'false' except\nwhen orderly termination is in progress.\n\nNote that completion of a SET on this object only implies\nthat termination was initiated, not necessarily that the\ntermination has been completed.")
applicationMibConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 2))
applicationMibGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 62, 2, 1))

# Augmentions

# Groups

applicationMonitorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 1)).setObjects(("APPLICATION-MIB", "applOpenConnectionFarEndAddr"), ("APPLICATION-MIB", "applOpenConnectionApplication"), ("APPLICATION-MIB", "applOpenFileName"), ("APPLICATION-MIB", "applOpenChannelLastReadTime"), ("APPLICATION-MIB", "applOpenConnectionTransport"), ("APPLICATION-MIB", "applSrvName"), ("APPLICATION-MIB", "applOpenChannelLastWriteTime"), ("APPLICATION-MIB", "applOpenFileSizeLow"), ("APPLICATION-MIB", "applOpenChannelWriteRequestsLow"), ("APPLICATION-MIB", "applSrvIndex"), ("APPLICATION-MIB", "applOpenChannelReadFailures"), ("APPLICATION-MIB", "applSrvInstance"), ("APPLICATION-MIB", "applOpenChannelWriteFailures"), ("APPLICATION-MIB", "applOpenConnectionNearEndAddr"), ("APPLICATION-MIB", "applOpenConnectionFarEndpoint"), ("APPLICATION-MIB", "applOpenChannelBytesReadLow"), ("APPLICATION-MIB", "applOpenFileMode"), ("APPLICATION-MIB", "applOpenChannelBytesWrittenLow"), ("APPLICATION-MIB", "applOpenChannelOpenTime"), ("APPLICATION-MIB", "applOpenChannelReadRequestsLow"), ("APPLICATION-MIB", "applOpenConnectionNearEndpoint"), ("APPLICATION-MIB", "applSrvInstQual"), ("APPLICATION-MIB", "applOpenFileSizeHigh"), )
if mibBuilder.loadTexts: applicationMonitorGroup.setDescription("This group represents the basic capabilities of this MIB.")
applicationFastMonitorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 2)).setObjects(("APPLICATION-MIB", "applOpenChannelBytesWritten"), ("APPLICATION-MIB", "applOpenChannelWriteRequests"), ("APPLICATION-MIB", "applOpenChannelReadRequests"), ("APPLICATION-MIB", "applOpenChannelBytesRead"), )
if mibBuilder.loadTexts: applicationFastMonitorGroup.setDescription("This group comprises 64-bit counters mandatory in\nhigh-throughput environments, where 32-bit counters\ncould wrap in less than an hour.")
applicationTransactGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 3)).setObjects(("APPLICATION-MIB", "applTransactStreamInvCumTimes"), ("APPLICATION-MIB", "applTransactStreamPrfCumTimes"), ("APPLICATION-MIB", "applTransactFlowTransLow"), ("APPLICATION-MIB", "applTransactStreamInvRspTimes"), ("APPLICATION-MIB", "applTransactStreamDescr"), ("APPLICATION-MIB", "applTransactStreamPerformsLow"), ("APPLICATION-MIB", "applTransactStreamUnitOfWork"), ("APPLICATION-MIB", "applTransactKindTime"), ("APPLICATION-MIB", "applTransactKindBytesLow"), ("APPLICATION-MIB", "applTransactStreamInvokesLow"), ("APPLICATION-MIB", "applTransactFlowTime"), ("APPLICATION-MIB", "applTransactFlowBytesLow"), ("APPLICATION-MIB", "applTransactStreamPrfRspTimes"), ("APPLICATION-MIB", "applTransactKindTransLow"), )
if mibBuilder.loadTexts: applicationTransactGroup.setDescription("This group comprises objects appropriate from monitoring\ntransaction-structured flows.")
applicationFastTransactGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 4)).setObjects(("APPLICATION-MIB", "applTransactFlowTrans"), ("APPLICATION-MIB", "applTransactFlowBytes"), ("APPLICATION-MIB", "applTransactStreamPerforms"), ("APPLICATION-MIB", "applTransactKindBytes"), ("APPLICATION-MIB", "applTransactKindTrans"), ("APPLICATION-MIB", "applTransactStreamInvokes"), )
if mibBuilder.loadTexts: applicationFastTransactGroup.setDescription("This group comprises 64-bit transaction counters required in\nhigh-throughput environments, where 32-bit counters could\nwrap in less than an hour.")
applicationHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 5)).setObjects(("APPLICATION-MIB", "applPastConNearEndpoint"), ("APPLICATION-MIB", "applPastConFarEndpoint"), ("APPLICATION-MIB", "applPastChannelLastReadTime"), ("APPLICATION-MIB", "applPastChannelBytesWritLow"), ("APPLICATION-MIB", "applPastConFarEndAddr"), ("APPLICATION-MIB", "applPastConTransport"), ("APPLICATION-MIB", "applPastChannelControlCollect"), ("APPLICATION-MIB", "applPastConApplication"), ("APPLICATION-MIB", "applPastChannelLastWriteTime"), ("APPLICATION-MIB", "applPastChannelCloseTime"), ("APPLICATION-MIB", "applPastFileMode"), ("APPLICATION-MIB", "applPastFileSizeLow"), ("APPLICATION-MIB", "applPastChannelControlMaxRows"), ("APPLICATION-MIB", "applPastChannelOpenTime"), ("APPLICATION-MIB", "applPastChannelBytesReadLow"), ("APPLICATION-MIB", "applPastChannelReadReqsLow"), ("APPLICATION-MIB", "applPastFileSizeHigh"), ("APPLICATION-MIB", "applPastConNearEndAddr"), ("APPLICATION-MIB", "applPastChannelReadFailures"), ("APPLICATION-MIB", "applPastFileName"), ("APPLICATION-MIB", "applPastChannelWriteFailures"), ("APPLICATION-MIB", "applPastChannelControlRemItems"), ("APPLICATION-MIB", "applPastChannelControlTimeLimit"), ("APPLICATION-MIB", "applPastChannelWriteReqsLow"), )
if mibBuilder.loadTexts: applicationHistoryGroup.setDescription("This group models basic historical data.")
applicationFastHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 6)).setObjects(("APPLICATION-MIB", "applPastChannelReadRequests"), ("APPLICATION-MIB", "applPastChannelWriteRequests"), ("APPLICATION-MIB", "applPastChannelBytesWritten"), ("APPLICATION-MIB", "applPastChannelBytesRead"), )
if mibBuilder.loadTexts: applicationFastHistoryGroup.setDescription("This group comprises additional 64-bit objects required\nfor recording historical data in high-volume environments,\nwhere a 32-bit integer would be insufficient.")
applicationTransHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 7)).setObjects(("APPLICATION-MIB", "applPastTransFlowTime"), ("APPLICATION-MIB", "applPastTransStreamPrfRspTimes"), ("APPLICATION-MIB", "applPastTransFlowTransLow"), ("APPLICATION-MIB", "applPastTransStreamInvokesLow"), ("APPLICATION-MIB", "applPastTransStreamDescr"), ("APPLICATION-MIB", "applPastTransStreamUnitOfWork"), ("APPLICATION-MIB", "applPastTransKindTransLow"), ("APPLICATION-MIB", "applPastTransStreamPrfCumTimes"), ("APPLICATION-MIB", "applPastTransKindTime"), ("APPLICATION-MIB", "applPastTransStreamPerformsLow"), ("APPLICATION-MIB", "applPastTransKindBytesLow"), ("APPLICATION-MIB", "applPastTransStreamInvCumTimes"), ("APPLICATION-MIB", "applPastTransStreamInvRspTimes"), ("APPLICATION-MIB", "applPastTransFlowBytesLow"), )
if mibBuilder.loadTexts: applicationTransHistoryGroup.setDescription("This group represents historical data for transaction-\nstructured information streams.")
applicationFastTransHistoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 8)).setObjects(("APPLICATION-MIB", "applPastTransStreamInvokes"), ("APPLICATION-MIB", "applPastTransFlowBytes"), ("APPLICATION-MIB", "applPastTransStreamPerforms"), ("APPLICATION-MIB", "applPastTransKindTrans"), ("APPLICATION-MIB", "applPastTransKindBytes"), ("APPLICATION-MIB", "applPastTransFlowTrans"), )
if mibBuilder.loadTexts: applicationFastTransHistoryGroup.setDescription("This group contains 64-bit objects required for historical\nrecords on high-volume transaction-structured streams,\nwhere 32-bit integers would be insufficient.")
applicationRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 62, 2, 1, 9)).setObjects(("APPLICATION-MIB", "applElmtRunStatusSuspended"), ("APPLICATION-MIB", "applElmtRunControlTerminate"), ("APPLICATION-MIB", "applElmtRunStatusOpenFiles"), ("APPLICATION-MIB", "applElmtRunControlSuspend"), ("APPLICATION-MIB", "applElmtRunStatusLastErrorTime"), ("APPLICATION-MIB", "applElmtRunStatusLastErrorMsg"), ("APPLICATION-MIB", "applElmtRunControlReconfigure"), ("APPLICATION-MIB", "applElmtRunStatusHeapUsage"), ("APPLICATION-MIB", "applElmtRunStatusOpenConnections"), )
if mibBuilder.loadTexts: applicationRunGroup.setDescription("This group represents extensions to the system application\nMIB.")

# Compliances

applicationMibCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 62, 2, 2)).setObjects(("APPLICATION-MIB", "applicationFastHistoryGroup"), ("APPLICATION-MIB", "applicationFastTransHistoryGroup"), ("APPLICATION-MIB", "applicationHistoryGroup"), ("APPLICATION-MIB", "applicationTransHistoryGroup"), ("APPLICATION-MIB", "applicationMonitorGroup"), ("APPLICATION-MIB", "applicationFastMonitorGroup"), ("APPLICATION-MIB", "applicationRunGroup"), ("APPLICATION-MIB", "applicationFastTransactGroup"), ("APPLICATION-MIB", "applicationTransactGroup"), )
if mibBuilder.loadTexts: applicationMibCompliance.setDescription("The compliance statement for the application MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("APPLICATION-MIB", PYSNMP_MODULE_ID=applicationMib)

# Types
mibBuilder.exportSymbols("APPLICATION-MIB", ApplTAddress=ApplTAddress, Unsigned64TC=Unsigned64TC)

# Objects
mibBuilder.exportSymbols("APPLICATION-MIB", applicationMib=applicationMib, applicationMibObjects=applicationMibObjects, applServiceGroup=applServiceGroup, applSrvNameToSrvInstTable=applSrvNameToSrvInstTable, applSrvNameToSrvInstEntry=applSrvNameToSrvInstEntry, applSrvInstQual=applSrvInstQual, applSrvInstToSrvNameTable=applSrvInstToSrvNameTable, applSrvInstToSrvNameEntry=applSrvInstToSrvNameEntry, applSrvName=applSrvName, applSrvInstToRunApplElmtTable=applSrvInstToRunApplElmtTable, applSrvInstToRunApplElmtEntry=applSrvInstToRunApplElmtEntry, applSrvIndex=applSrvIndex, applRunApplElmtToSrvInstTable=applRunApplElmtToSrvInstTable, applRunApplElmtToSrvInstEntry=applRunApplElmtToSrvInstEntry, applSrvInstance=applSrvInstance, applChannelGroup=applChannelGroup, applOpenChannelTable=applOpenChannelTable, applOpenChannelEntry=applOpenChannelEntry, applElmtOrSvc=applElmtOrSvc, applElmtOrSvcId=applElmtOrSvcId, applOpenChannelIndex=applOpenChannelIndex, applOpenChannelOpenTime=applOpenChannelOpenTime, applOpenChannelReadRequests=applOpenChannelReadRequests, applOpenChannelReadRequestsLow=applOpenChannelReadRequestsLow, applOpenChannelReadFailures=applOpenChannelReadFailures, applOpenChannelBytesRead=applOpenChannelBytesRead, applOpenChannelBytesReadLow=applOpenChannelBytesReadLow, applOpenChannelLastReadTime=applOpenChannelLastReadTime, applOpenChannelWriteRequests=applOpenChannelWriteRequests, applOpenChannelWriteRequestsLow=applOpenChannelWriteRequestsLow, applOpenChannelWriteFailures=applOpenChannelWriteFailures, applOpenChannelBytesWritten=applOpenChannelBytesWritten, applOpenChannelBytesWrittenLow=applOpenChannelBytesWrittenLow, applOpenChannelLastWriteTime=applOpenChannelLastWriteTime, applOpenFileTable=applOpenFileTable, applOpenFileEntry=applOpenFileEntry, applOpenFileName=applOpenFileName, applOpenFileSizeHigh=applOpenFileSizeHigh, applOpenFileSizeLow=applOpenFileSizeLow, applOpenFileMode=applOpenFileMode, applOpenConnectionTable=applOpenConnectionTable, applOpenConnectionEntry=applOpenConnectionEntry, applOpenConnectionTransport=applOpenConnectionTransport, applOpenConnectionNearEndAddr=applOpenConnectionNearEndAddr, applOpenConnectionNearEndpoint=applOpenConnectionNearEndpoint, applOpenConnectionFarEndAddr=applOpenConnectionFarEndAddr, applOpenConnectionFarEndpoint=applOpenConnectionFarEndpoint, applOpenConnectionApplication=applOpenConnectionApplication, applTransactionStreamTable=applTransactionStreamTable, applTransactionStreamEntry=applTransactionStreamEntry, applTransactStreamDescr=applTransactStreamDescr, applTransactStreamUnitOfWork=applTransactStreamUnitOfWork, applTransactStreamInvokes=applTransactStreamInvokes, applTransactStreamInvokesLow=applTransactStreamInvokesLow, applTransactStreamInvCumTimes=applTransactStreamInvCumTimes, applTransactStreamInvRspTimes=applTransactStreamInvRspTimes, applTransactStreamPerforms=applTransactStreamPerforms, applTransactStreamPerformsLow=applTransactStreamPerformsLow, applTransactStreamPrfCumTimes=applTransactStreamPrfCumTimes, applTransactStreamPrfRspTimes=applTransactStreamPrfRspTimes, applTransactFlowTable=applTransactFlowTable, applTransactFlowEntry=applTransactFlowEntry, applTransactFlowDirection=applTransactFlowDirection, applTransactFlowReqRsp=applTransactFlowReqRsp, applTransactFlowTrans=applTransactFlowTrans, applTransactFlowTransLow=applTransactFlowTransLow, applTransactFlowBytes=applTransactFlowBytes, applTransactFlowBytesLow=applTransactFlowBytesLow, applTransactFlowTime=applTransactFlowTime, applTransactKindTable=applTransactKindTable, applTransactKindEntry=applTransactKindEntry, applTransactKind=applTransactKind, applTransactKindTrans=applTransactKindTrans, applTransactKindTransLow=applTransactKindTransLow, applTransactKindBytes=applTransactKindBytes, applTransactKindBytesLow=applTransactKindBytesLow, applTransactKindTime=applTransactKindTime, applPastChannelGroup=applPastChannelGroup, applPastChannelControlTable=applPastChannelControlTable, applPastChannelControlEntry=applPastChannelControlEntry, applPastChannelControlCollect=applPastChannelControlCollect, applPastChannelControlMaxRows=applPastChannelControlMaxRows, applPastChannelControlTimeLimit=applPastChannelControlTimeLimit, applPastChannelControlRemItems=applPastChannelControlRemItems, applPastChannelTable=applPastChannelTable, applPastChannelEntry=applPastChannelEntry, applPastChannelIndex=applPastChannelIndex, applPastChannelOpenTime=applPastChannelOpenTime, applPastChannelCloseTime=applPastChannelCloseTime, applPastChannelReadRequests=applPastChannelReadRequests, applPastChannelReadReqsLow=applPastChannelReadReqsLow, applPastChannelReadFailures=applPastChannelReadFailures, applPastChannelBytesRead=applPastChannelBytesRead, applPastChannelBytesReadLow=applPastChannelBytesReadLow, applPastChannelLastReadTime=applPastChannelLastReadTime, applPastChannelWriteRequests=applPastChannelWriteRequests, applPastChannelWriteReqsLow=applPastChannelWriteReqsLow, applPastChannelWriteFailures=applPastChannelWriteFailures, applPastChannelBytesWritten=applPastChannelBytesWritten, applPastChannelBytesWritLow=applPastChannelBytesWritLow, applPastChannelLastWriteTime=applPastChannelLastWriteTime, applPastFileTable=applPastFileTable, applPastFileEntry=applPastFileEntry, applPastFileName=applPastFileName, applPastFileSizeHigh=applPastFileSizeHigh, applPastFileSizeLow=applPastFileSizeLow, applPastFileMode=applPastFileMode, applPastConTable=applPastConTable, applPastConEntry=applPastConEntry, applPastConTransport=applPastConTransport, applPastConNearEndAddr=applPastConNearEndAddr, applPastConNearEndpoint=applPastConNearEndpoint, applPastConFarEndAddr=applPastConFarEndAddr, applPastConFarEndpoint=applPastConFarEndpoint, applPastConApplication=applPastConApplication, applPastTransStreamTable=applPastTransStreamTable, applPastTransStreamEntry=applPastTransStreamEntry, applPastTransStreamDescr=applPastTransStreamDescr, applPastTransStreamUnitOfWork=applPastTransStreamUnitOfWork, applPastTransStreamInvokes=applPastTransStreamInvokes, applPastTransStreamInvokesLow=applPastTransStreamInvokesLow, applPastTransStreamInvCumTimes=applPastTransStreamInvCumTimes, applPastTransStreamInvRspTimes=applPastTransStreamInvRspTimes, applPastTransStreamPerforms=applPastTransStreamPerforms, applPastTransStreamPerformsLow=applPastTransStreamPerformsLow, applPastTransStreamPrfCumTimes=applPastTransStreamPrfCumTimes)
mibBuilder.exportSymbols("APPLICATION-MIB", applPastTransStreamPrfRspTimes=applPastTransStreamPrfRspTimes, applPastTransFlowTable=applPastTransFlowTable, applPastTransFlowEntry=applPastTransFlowEntry, applPastTransFlowDirection=applPastTransFlowDirection, applPastTransFlowReqRsp=applPastTransFlowReqRsp, applPastTransFlowTrans=applPastTransFlowTrans, applPastTransFlowTransLow=applPastTransFlowTransLow, applPastTransFlowBytes=applPastTransFlowBytes, applPastTransFlowBytesLow=applPastTransFlowBytesLow, applPastTransFlowTime=applPastTransFlowTime, applPastTransKindTable=applPastTransKindTable, applPastTransKindEntry=applPastTransKindEntry, applPastTransKind=applPastTransKind, applPastTransKindTrans=applPastTransKindTrans, applPastTransKindTransLow=applPastTransKindTransLow, applPastTransKindBytes=applPastTransKindBytes, applPastTransKindBytesLow=applPastTransKindBytesLow, applPastTransKindTime=applPastTransKindTime, applElmtRunControlGroup=applElmtRunControlGroup, applElmtRunStatusTable=applElmtRunStatusTable, applElmtRunStatusEntry=applElmtRunStatusEntry, applElmtRunStatusSuspended=applElmtRunStatusSuspended, applElmtRunStatusHeapUsage=applElmtRunStatusHeapUsage, applElmtRunStatusOpenConnections=applElmtRunStatusOpenConnections, applElmtRunStatusOpenFiles=applElmtRunStatusOpenFiles, applElmtRunStatusLastErrorMsg=applElmtRunStatusLastErrorMsg, applElmtRunStatusLastErrorTime=applElmtRunStatusLastErrorTime, applElmtRunControlTable=applElmtRunControlTable, applElmtRunControlEntry=applElmtRunControlEntry, applElmtRunControlSuspend=applElmtRunControlSuspend, applElmtRunControlReconfigure=applElmtRunControlReconfigure, applElmtRunControlTerminate=applElmtRunControlTerminate, applicationMibConformance=applicationMibConformance, applicationMibGroups=applicationMibGroups)

# Groups
mibBuilder.exportSymbols("APPLICATION-MIB", applicationMonitorGroup=applicationMonitorGroup, applicationFastMonitorGroup=applicationFastMonitorGroup, applicationTransactGroup=applicationTransactGroup, applicationFastTransactGroup=applicationFastTransactGroup, applicationHistoryGroup=applicationHistoryGroup, applicationFastHistoryGroup=applicationFastHistoryGroup, applicationTransHistoryGroup=applicationTransHistoryGroup, applicationFastTransHistoryGroup=applicationFastTransHistoryGroup, applicationRunGroup=applicationRunGroup)

# Compliances
mibBuilder.exportSymbols("APPLICATION-MIB", applicationMibCompliance=applicationMibCompliance)
