# PySNMP SMI module. Autogenerated from smidump -f python APS-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:09 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( RowStatus, StorageType, TextualConvention, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TimeStamp")

# Types

class ApsControlCommand(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,1,)
    namedValues = namedval.NamedValues(("noCmd", 1), ("lockoutWorkingChannel", 2), ("clearLockoutWorkingChannel", 3), )
    
class ApsK1K2(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(2,2)
    fixedLength = 2
    
class ApsSwitchCommand(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(6,7,3,5,1,2,4,8,)
    namedValues = namedval.NamedValues(("noCmd", 1), ("clear", 2), ("lockoutOfProtection", 3), ("forcedSwitchWorkToProtect", 4), ("forcedSwitchProtectToWork", 5), ("manualSwitchWorkToProtect", 6), ("manualSwitchProtectToWork", 7), ("exercise", 8), )
    

# Objects

apsMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 49)).setRevisions(("2003-02-28 00:00",))
if mibBuilder.loadTexts: apsMIB.setOrganization("IETF AToMMIB Working Group")
if mibBuilder.loadTexts: apsMIB.setContactInfo("       Jim Kuhfeld\nPostal: RedBack Networks. Inc.\n300 Holger Way\nSan Jose, CA 95134-1362\nTel: +1 408 750 5465\nEmail: jkuhfeld@redback.com\n\nJeff Johnson\nPostal: RedBack Networks. Inc.\n300 Holger Way\nSan Jose, CA 95134-1362\nTel: +1 408 750 5460\nEmail: jeff@redback.com\n\nMichael Thatcher\nPostal: RedBack Networks. Inc.\n300 Holger Way\nSan Jose, CA 95134-1362\nTel: +1 408 750 5449\nEmail: thatcher@redback.com")
if mibBuilder.loadTexts: apsMIB.setDescription("This management information module supports the configuration\nand management of SONET linear APS groups. The definitions and\ndescriptions used in this MIB have been derived from\nSynchronous Optical Network (SONET) Transport Systems:\nCommon Generic Criteria, GR-253-CORE Issue 3, September 2000,\nsection 5.3. The MIB is also consistent with the Multiplex\nSection Protection (MSP) protocol as specified in ITU-T\nRecommendation G.783, Characteristics of synchronous digital\nhierarchy (SDH) equipment function blocks, Annex A and B.\n\nCopyright (C) The Internet Society (2003).  This version of\nthis MIB module is part of RFC 3498; see the RFC itself for\nfull legal notices.")
apsMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 1))
apsConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 1, 1))
apsConfigGroups = MibScalar((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsConfigGroups.setDescription("The count of APS groups. This count includes all rows in\napsConfigTable, regardless of the value of apsConfigRowStatus.")
apsConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2))
if mibBuilder.loadTexts: apsConfigTable.setDescription("This table lists the APS groups that have been configured\non the system.")
apsConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1)).setIndexNames((1, "APS-MIB", "apsConfigName"))
if mibBuilder.loadTexts: apsConfigEntry.setDescription("A conceptual row in the apsConfigTable.")
apsConfigName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apsConfigName.setDescription("A textual name for the APS group.")
apsConfigRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigRowStatus.setDescription("The status of this APS group entry.\n\nAn entry may not exist in the active state unless all\nobjects in the entry have an appropriate value. Also,\nall associated apsChanConfigEntry rows must represent\na set of consecutive channel numbers beginning with\n0 or 1, depending on the selected architecture.\n\nWhen set to notInService changes may be made to apsConfigMode,\napsConfigRevert, apsConfigDirection, apsConfigExtraTraffic,\napsConfigSdBerThreshold, apsConfigSfBerThreshold,\nand apsConfigWaitToRestore. Also, associated apsChanConfigTable\nobjects may be added, deleted and modified.")
apsConfigMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,2,3,)).subtype(namedValues=namedval.NamedValues(("onePlusOne", 1), ("oneToN", 2), ("onePlusOneCompatible", 3), ("onePlusOneOptimized", 4), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigMode.setDescription("The architecture of the APS group.\n\nonePlusOne\n\nThe 1+1 architecture permanently bridges the working\nline to the protection line.\n\noneToN\n\nThe 1:n architecture allows one protection channel to\nprotect up to n working channels. When a fault is detected\non one of the n working channels that channel is bridged\nover the protection channel.\n\nonePlusOneCompatible\n\n\n\n\n\n\nThis refers to 1 + 1 bidirectional switching compatible with\n1:n bidirectional switching as specified in ITU-T\nRecommendation G.783 (04/97) section A.3.4.1. Since this\nmode necessitates bidirectional switching, apsConfigDirection\nmust be set to bidirectional whenever onePlusOneCompatible\nis set.\n\nonePlusOneOptimized\n\nThis refers to 1 + 1 bidirectional switching optimized\nfor a network using predominantly 1 + 1 bidirectional\nswitching as specified in ITU-T Recommendation G.783 (04/97)\nsection B.1. Since this mode necessitates bidirectional\nswitching, apsConfigDirection must be set to bidirectional\nwhenever onePlusOneOptimized is set.\n\nThis object may not be modified if the associated\napsConfigRowStatus object is equal to active(1).")
apsConfigRevert = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("nonrevertive", 1), ("revertive", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigRevert.setDescription("The revertive mode of the APS group.\n\nnonrevertive\n\nTraffic remains on the protection line until another switch\nrequest is received.\n\nrevertive\n\nWhen the condition that caused a switch to the protection\nline has been cleared the signal is switched back to the\nworking line. Since switching is revertive with the 1:n\narchitecture, apsConfigRevert must be set to revertive if\napsConfigMode is set to oneToN.\n\nSwitching may optionally be revertive with the 1+1 architecture.\n\nThis object may not be modified if the associated\napsConfigRowStatus object is equal to active(1). ")
apsConfigDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("unidirectional", 1), ("bidirectional", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigDirection.setDescription("The directional mode of the APS group.\n\nunidirectional\n\nThe unidirectional mode provides protection in one direction.\n\nbidirectional\n\nThe bidirectional mode provides protection in both\ndirections.\n\nThis object may not be modified if the associated\napsConfigRowStatus object is equal to active(1). ")
apsConfigExtraTraffic = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigExtraTraffic.setDescription("This object enables or disables the transfer of extra traffic\non the protection channel in a 1:n architecture. This object\nmust be set to disabled if the architecture is 1+1. It may be\nnecessary to disable this in order to interwork with other SONET\nnetwork elements that don't support extra traffic.\n\nThis object may not be modified if the associated\napsConfigRowStatus object is equal to active(1). ")
apsConfigSdBerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 9)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigSdBerThreshold.setDescription("The Signal Degrade Bit Error Rate.\n\nThe negated value of this number is used as the exponent of\n10 for computing the threshold value for the Bit Error Rate\n(BER). For example, a value of 5 indicates a BER threshold of\n10^-5.\n\n\n\nThis object may be modified if the associated\napsConfigRowStatus object is equal to active(1).")
apsConfigSfBerThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(3, 5)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigSfBerThreshold.setDescription("The Signal Failure Bit Error Rate.\n\nThe negated value of this number is used as the exponent of\n10 for computing the threshold value for the Bit Error Rate\n(BER). For example, a value of 5 indicates a BER threshold of\n10^-5.\n\nThis object may be modified if the associated\napsConfigRowStatus object is equal to active(1).")
apsConfigWaitToRestore = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 720)).clone(300)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigWaitToRestore.setDescription("The Wait To Restore period in seconds.\n\nAfter clearing of a condition that necessitated an\nautomatic switch, the wait to restore period must elapse\nbefore reverting. This is intended to avoid rapid switch\noscillations.\n\nGR-253-CORE specifies a Wait To Restore range of 5 to 12\nminutes. G.783 defines a 5 to 12 minute Wait To Restore\nrange in section 5.4.1.1.3, but also allows for a shorter\nWTR period in  Table 2-1,\nWaitToRestore value (MI_WTRtime: 0..(5)..12 minutes).\n\nThis object may not be modified if the associated\napsConfigRowStatus object is equal to active(1).")
apsConfigCreationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 10), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsConfigCreationTime.setDescription("The value of sysUpTime at the time the row was\ncreated")
apsConfigStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 1, 2, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsConfigStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent' need not\nallow write-access to any columnar objects in the row.")
apsStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 49, 1, 2))
if mibBuilder.loadTexts: apsStatusTable.setDescription("This table provides status information about APS groups\nthat have been configured on the system.")
apsStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1))
if mibBuilder.loadTexts: apsStatusEntry.setDescription("A conceptual row in the apsStatusTable.")
apsStatusK1K2Rcv = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 1), ApsK1K2()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusK1K2Rcv.setDescription("The current value of the K1 and K2 bytes received on the\nprotection channel.")
apsStatusK1K2Trans = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 2), ApsK1K2()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusK1K2Trans.setDescription("The current value of the K1 and K2 bytes transmitted on the\nprotection channel.")
apsStatusCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 3), Bits().subtype(namedValues=namedval.NamedValues(("modeMismatch", 0), ("channelMismatch", 1), ("psbf", 2), ("feplf", 3), ("extraTraffic", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusCurrent.setDescription("The current status of the APS group.\n\nmodeMismatch\n\nModes other than 1+1 unidirectional monitor protection line\nK2 bit 5, which indicates the architecture and K2 bits\n6-8, which indicate if the mode is unidirectional or\nbidirectional. A conflict between the current local mode\nand the received K2 mode information constitutes a\nmode mismatch.\n\n\n\n\nchannelMismatch\n\nThis bit indicates a  mismatch between the transmitted K1\nchannel and the received K2 channel has been detected.\n\npsbf\n\nThis bit indicates a Protection Switch Byte Failure (PSBF) is\nin effect. This condition occurs when either an inconsistent\nAPS byte or an invalid code is detected. An inconsistent APS\nbyte occurs when no three consecutive K1 bytes of the last 12\nsuccessive frames are identical, starting with the last frame\ncontaining a previously consistent byte. An invalid code occurs\nwhen the incoming K1 byte contains an unused code or a code\nirrelevant for the specific switching operation (e.g., Reverse\nRequest while no switching request is outstanding) in three\nconsecutive frames. An invalid code also occurs when the\nincoming K1 byte contains an invalid channel number in three\nconsecutive frames.\n\nfeplf\n\nModes other than 1+1 unidirectional monitor the K1 byte\nfor Far-End Protection-Line failures. A Far-End\nProtection-Line defect is declared based on receiving\nSF on the protection line.\n\nextraTraffic\n\nThis bit indicates whether extra traffic is currently being\naccepted on the protection line. ")
apsStatusModeMismatches = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusModeMismatches.setDescription("A count of Mode Mismatch conditions.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsStatusDiscontinuityTime.")
apsStatusChannelMismatches = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusChannelMismatches.setDescription("A count of Channel Mismatch conditions.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsStatusDiscontinuityTime.")
apsStatusPSBFs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusPSBFs.setDescription("A count of Protection Switch Byte Failure conditions.\nThis condition occurs when either an inconsistent APS\nbyte or an invalid code is detected. An inconsistent APS\nbyte occurs when no three consecutive K1 bytes of the last\n12 successive frames are identical, starting with the last\nframe containing a previously consistent byte. An invalid\ncode occurs when the incoming K1 byte contains an unused\ncode or a code irrelevant for the specific switching\noperation (e.g., Reverse Request while no switching request\nis outstanding) in three consecutive frames. An invalid code\nalso occurs when the incoming K1 byte contains an invalid\nchannel number in three consecutive frames.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsStatusDiscontinuityTime.")
apsStatusFEPLFs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusFEPLFs.setDescription("A count of Far-End Protection-Line Failure conditions.\nThis condition is declared based on receiving SF on\nthe protection line in the K1 byte.\n\n\n\n\n\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsStatusDiscontinuityTime.")
apsStatusSwitchedChannel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusSwitchedChannel.setDescription("This field is set to the number of the channel that is\ncurrently switched to protection. The value 0 indicates no\nchannel is switched to protection. The values 1-14 indicate\nthat working channel is switched to protection.")
apsStatusDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 2, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsStatusDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\nany one or more of this APS group's counters suffered a\ndiscontinuity.  The relevant counters are the specific\ninstances associated with this APS group of any Counter32\nobject contained in apsStatusTable. If no such\ndiscontinuities have occurred since the last re-initialization\nof the local management subsystem, then this object contains\na zero value.")
apsMap = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 1, 3))
apsChanLTEs = MibScalar((1, 3, 6, 1, 2, 1, 10, 49, 1, 3, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanLTEs.setDescription("The count of SONET LTE interfaces on the system.\nEach interface that is included has an ifType value of\nsonet(39).")
apsMapTable = MibTable((1, 3, 6, 1, 2, 1, 10, 49, 1, 3, 2))
if mibBuilder.loadTexts: apsMapTable.setDescription("This table lists the SONET LTE interfaces on the system.\nEach interface that is listed has an ifType value of\nsonet(39).")
apsMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 49, 1, 3, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: apsMapEntry.setDescription("A conceptual row in the apsMapTable.")
apsMapGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 3, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsMapGroupName.setDescription("A textual name for the APS group which this channel is\nincluded in. If the channel is not part of an APS group\nthis value is set to a string of size 0.\n\nWhen an instance of apsChanConfigIfIndex is set equal to an\ninstance of ifIndex that has an ifType value of sonet(39),\napsMapGroupName is set equal to the corresponding value of\napsChanConfigGroupName.\n\nIf an instance of ifIndex that has an ifType value of\nsonet(39) ceases to be equal to an instance of\napsChanConfigIfIndex, either because of a change in the value\nof apsChanConfigIfIndex, or because of row deletion in the\nApsChanConfigTable, apsMapGroupName is set to a string of\nsize 0.")
apsMapChanNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 3, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 14))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsMapChanNumber.setDescription("This field is set to a unique channel number within an APS\ngroup.  The value 0 indicates the null channel. The values\n1-14 define a working channel. If the SONET LTE is not part\nof an APS group this value is set to -1.\n\nWhen an instance of apsChanConfigIfIndex is set equal to an\ninstance of ifIndex that has an  ifType value of sonet(39),\napsMapChanNumber is set equal to the corresponding value of\napsChanConfigNumber.\n\nIf an instance of ifIndex that has an  ifType value of\nsonet(39) ceases to be equal to an instance of\napsChanConfigIfIndex, either because of a change in the\nvalue of apsChanConfigIfIndex, or because of row deletion\nin the ApsChanConfigTable, apsMapChanNumber is set to -1.")
apsChanConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 49, 1, 4))
if mibBuilder.loadTexts: apsChanConfigTable.setDescription("This table lists the APS channels that have been configured\nin APS groups.")
apsChanConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1)).setIndexNames((0, "APS-MIB", "apsChanConfigGroupName"), (0, "APS-MIB", "apsChanConfigNumber"))
if mibBuilder.loadTexts: apsChanConfigEntry.setDescription("A conceptual row in the apsChanConfigTable.")
apsChanConfigGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apsChanConfigGroupName.setDescription("A textual name for the APS group which this channel is\nincluded in.")
apsChanConfigNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 14))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: apsChanConfigNumber.setDescription("This field is set to a unique channel number within an APS\ngroup.  The value 0 indicates the null channel.  The values\n1-14 define a working channel.\n\nThis field must be assigned a unique number within the group.")
apsChanConfigRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsChanConfigRowStatus.setDescription("The status of this APS channel entry.\n\nAn entry may not exist in the active state unless all\nobjects in the entry have an appropriate value.\n\nA row in the apsChanConfigTable may not be created,\ndeleted, set to notInService or otherwise modified\nif the apsChanConfigGroupName value is equal to an\napsConfigName value and the associated apsConfigRowStatus\nobject is equal to active. However, if the apsConfigRowStatus\nobject is equal to notInService, a row may be created, deleted\nor modified. In other words, a channel may not be added,\ndeleted or modified if the group is active.\n\n\n\nA row may be created with an apsChanConfigGroupName value\nthat is not equal to any existing instance of apsConfigName.\nThis action is the initial step in adding a SONET LTE to a\nnew APS group.\n\nIf this object is set to destroy, the associated instance\nof apsMapGroupName will be set to a string of size 0 and\nthe apsMapChanNumber will be set to -1. The channel status\nentry will also be deleted by this action.\n\napsChanConfigNumber must be set to a unique channel number\nwithin the APS group. The value 0 indicates the null channel.\nThe values 1-14 define a working channel. When an attempt is\nmade to set the  corresponding apsConfigRowStatus field to\nactive the apsChanConfigNumber values of all entries with equal\napsChanConfigGroupName fields must represent a set of\nconsecutive integer values beginning with 0 or 1, depending on\nthe architecture of the group, and ending with n, where n is\ngreater than or equal to 1 and less than or equal to 14.\nOtherwise, the error inconsistentValue is returned to the\napsConfigRowStatus set attempt.")
apsChanConfigIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1, 4), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsChanConfigIfIndex.setDescription("The Interface Index assigned to a SONET LTE. This is an\ninterface with ifType sonet(39). The value of this object\nmust be unique among all instances of apsChanConfigIfIndex.\nIn other words, a particular SONET LTE can only be configured\nin one APS group.\n\nThis object cannot be set if the apsChanConfigGroupName\ninstance associated with this row is equal to an instance of\napsConfigName and the corresponding apsConfigRowStatus object\nis set to active.  In other words this value cannot be changed\nif the APS group is active. However, this value may be changed\nif the apsConfigRowStatus value is equal to notInService.")
apsChanConfigPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("low", 1), ("high", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsChanConfigPriority.setDescription("The priority of the channel.\n\n\n\nThis field determines whether high or low priority\nSD and SF codes are used in K1 requests.\n\nThis field is only applicable if the channel is to be included\nin a group using the 1:n architecture. It is not applicable if\nthe channel is to be included in a group using the 1+1\narchitecture, and is ignored in that case.\n\nThis object cannot be set if the apsChanConfigGroupName\ninstance associated with this row is equal to an instance of\napsConfigName and the corresponding apsConfigRowStatus object\nis set to active.  In other words this value cannot be changed\nif the APS group is active.  However, this value may be changed\nif the apsConfigRowStatus value is equal to notInService.")
apsChanConfigStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 4, 1, 6), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: apsChanConfigStorageType.setDescription("The storage type for this conceptual row.\nConceptual rows having the value 'permanent' need not\nallow write-access to any columnar objects in the row.")
apsCommandTable = MibTable((1, 3, 6, 1, 2, 1, 10, 49, 1, 5))
if mibBuilder.loadTexts: apsCommandTable.setDescription("This table allows commands to be sent to configured APS\ngroups.")
apsCommandEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 49, 1, 5, 1)).setIndexNames((0, "APS-MIB", "apsChanConfigGroupName"), (0, "APS-MIB", "apsChanConfigNumber"))
if mibBuilder.loadTexts: apsCommandEntry.setDescription("A conceptual row in the apsCommandTable. This row exists only\nif the associated apsConfigEntry is active.")
apsCommandSwitch = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 5, 1, 1), ApsSwitchCommand()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apsCommandSwitch.setDescription("Allows the initiation of an APS switch command on the\nAPS group and channel specified by the index values.\n\nWhen read this object returns the last command written\nor noCmd if no command has been written to this\nchannel since initialization. The return of the last command\nwritten does not imply that this command is currently in\neffect.  This request may have been preempted by a higher\npriority local or remote request. In order to determine the\ncurrent state of the APS group it is necessary to read\nthe objects apsStatusK1K2Rcv and apsStatusK1K2Trans.\n\nThe value lockoutOfProtection should only be applied to the\nprotection line channel since that switch command prevents any\nof the working channels from switching to the protection line.\nFollowing the same logic, forcedSwitchProtectToWork and\nmanualSwitchProtectToWork should only be applied to the\nprotection line channel.\n\nforcedSwitchWorkToProtect and manualSwitchWorkToProtect\nshould only be applied to a working channel.")
apsCommandControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 5, 1, 2), ApsControlCommand()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apsCommandControl.setDescription("Allows the initiation of an APS control command on the\nAPS group and channel specified by the index values.\n\n\n\n\n\n\nWhen read this object returns the last command written or\nnoCmd if no command has been written to this channel since\ninitialization.\n\nThis object does not apply to the protection line.")
apsChanStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 49, 1, 6))
if mibBuilder.loadTexts: apsChanStatusTable.setDescription("This table contains status information for all SONET LTE\ninterfaces that are included in APS groups.")
apsChanStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1))
if mibBuilder.loadTexts: apsChanStatusEntry.setDescription("A conceptual row in the apsChanStatusTable.")
apsChanStatusCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("lockedOut", 0), ("sd", 1), ("sf", 2), ("switched", 3), ("wtr", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusCurrent.setDescription("Indicates the current state of the port.\n\nlockedOut\n\nThis bit, when applied to a working channel, indicates that\nthe channel is prevented from switching to the protection\nline.  When applied to the null channel, this bit indicates\nthat no working channel may switch to the protection line.\n\nsd\n\nA signal degrade condition is in effect.\n\nsf\n\nA signal failure condition is in effect.\n\nswitched\n\nThe switched bit is applied to a working channel if that\nchannel is currently switched to the protection line.\n\nwtr\n\nA Wait-to-Restore state is in effect.")
apsChanStatusSignalDegrades = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusSignalDegrades.setDescription("A count of Signal Degrade conditions. This condition\noccurs when the line Bit Error Rate exceeds the currently\nconfigured value of the relevant instance of\napsConfigSdBerThreshold.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsChanStatusDiscontinuityTime.")
apsChanStatusSignalFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusSignalFailures.setDescription("A count of Signal Failure conditions that have been\ndetected on the incoming signal. This condition occurs\nwhen a loss of signal, loss of frame, AIS-L or a Line\nbit error rate exceeding the currently configured value of\nthe relevant instance of apsConfigSfBerThreshold.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsChanStatusDiscontinuityTime.")
apsChanStatusSwitchovers = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusSwitchovers.setDescription("When queried with index value apsChanConfigNumber other than\n0, this object will return the number of times this channel\nhas switched to the protection line.\n\nWhen queried with index value apsChanConfigNumber set to 0,\nwhich is the protection line, this object will return the\nnumber of times that any working channel has been switched\nback to the working line from this protection line.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsChanStatusDiscontinuityTime.")
apsChanStatusLastSwitchover = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusLastSwitchover.setDescription("When queried with index value apsChanConfigNumber other than\n0, this object will return the value of sysUpTime when this\nchannel last completed a switch to the protection line. If\n\n\n\n\nthis channel has never switched to the protection line, the\nvalue 0 will be returned.\n\nWhen queried with index value apsChanConfigNumber set to 0,\nwhich is the protection line, this object will return the\nvalue of sysUpTime the last time that a working channel was\nswitched back to the working line from this protection line.\nIf no working channel has ever switched back to the working\nline from this protection line, the value 0 will be returned.")
apsChanStatusSwitchoverSeconds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusSwitchoverSeconds.setDescription("The cumulative Protection Switching Duration (PSD) time in\nseconds. For a working channel, this is the cumulative number\nof seconds that service was carried on the protection line.\nFor the protection line, this is the cumulative number of\nseconds that the protection line has been used to carry any\nworking channel traffic. This information is only valid if\nrevertive switching is enabled. The value 0 will be returned\notherwise.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\napsChanStatusDiscontinuityTime. For example, if the value\nof an instance of apsChanStatusSwitchoverSeconds changes\nfrom a non-zero value to zero due to revertive switching\nbeing disabled, it is expected that the corresponding\nvalue of apsChanStatusDiscontinuityTime will be updated\nto reflect the time of the configuration change.")
apsChanStatusDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 49, 1, 6, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: apsChanStatusDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\nany one or more of this channel's counters suffered a\ndiscontinuity.  The relevant counters are the specific\ninstances associated with this channel of any Counter32\nobject contained in apsChanStatusTable. If no such\n\n\n\ndiscontinuities have occurred since the last re-initialization\nof the local management subsystem, then this object contains\na zero value.")
apsNotificationEnable = MibScalar((1, 3, 6, 1, 2, 1, 10, 49, 1, 7), Bits().subtype(namedValues=namedval.NamedValues(("switchover", 0), ("modeMismatch", 1), ("channelMismatch", 2), ("psbf", 3), ("feplf", 4), )).clone(())).setMaxAccess("readwrite")
if mibBuilder.loadTexts: apsNotificationEnable.setDescription("Provides the ability to enable and disable notifications\ndefined in this MIB.\n\nswitchover\n\nIndicates  apsEventSwitchover notifications\nshould be generated.\n\nmodeMismatch\n\nIndicates  apsEventModeMismatch notifications\nshould be generated.\n\nchannelMismatch\n\nIndicates  apsEventChannelMismatch notifications\nshould be generated.\n\npsbf\n\nIndicates  apsEventPSBF notifications\nshould be generated.\n\nfeplf\n\nIndicates  apsEventFEPLF notifications\nshould be generated. ")
apsMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 2))
apsNotificationsPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 2, 0))
apsMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 3))
apsGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 3, 1))
apsCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 49, 3, 2))

# Augmentions
apsChanConfigEntry.registerAugmentions(("APS-MIB", "apsChanStatusEntry"))
apsChanStatusEntry.setIndexNames(*apsChanConfigEntry.getIndexNames())
apsConfigEntry.registerAugmentions(("APS-MIB", "apsStatusEntry"))
apsStatusEntry.setIndexNames(*apsConfigEntry.getIndexNames())

# Notifications

apsEventSwitchover = NotificationType((1, 3, 6, 1, 2, 1, 10, 49, 2, 0, 1)).setObjects(("APS-MIB", "apsChanStatusCurrent"), ("APS-MIB", "apsChanStatusSwitchovers"), )
if mibBuilder.loadTexts: apsEventSwitchover.setDescription("An apsEventSwitchover notification is sent when the\nvalue of an instance of apsChanStatusSwitchovers increments.")
apsEventModeMismatch = NotificationType((1, 3, 6, 1, 2, 1, 10, 49, 2, 0, 2)).setObjects(("APS-MIB", "apsStatusModeMismatches"), ("APS-MIB", "apsStatusCurrent"), )
if mibBuilder.loadTexts: apsEventModeMismatch.setDescription("An apsEventModeMismatch notification is sent when the\nvalue of an instance of apsStatusModeMismatches increments.")
apsEventChannelMismatch = NotificationType((1, 3, 6, 1, 2, 1, 10, 49, 2, 0, 3)).setObjects(("APS-MIB", "apsStatusCurrent"), ("APS-MIB", "apsStatusChannelMismatches"), )
if mibBuilder.loadTexts: apsEventChannelMismatch.setDescription("An apsEventChannelMismatch notification is sent when the\nvalue of an instance of apsStatusChannelMismatches increments.")
apsEventPSBF = NotificationType((1, 3, 6, 1, 2, 1, 10, 49, 2, 0, 4)).setObjects(("APS-MIB", "apsStatusPSBFs"), ("APS-MIB", "apsStatusCurrent"), )
if mibBuilder.loadTexts: apsEventPSBF.setDescription("An apsEventPSBF notification is sent when the\nvalue of an instance of apsStatusPSBFs increments.")
apsEventFEPLF = NotificationType((1, 3, 6, 1, 2, 1, 10, 49, 2, 0, 5)).setObjects(("APS-MIB", "apsStatusFEPLFs"), ("APS-MIB", "apsStatusCurrent"), )
if mibBuilder.loadTexts: apsEventFEPLF.setDescription("An apsEventFEPLFs notification is sent when the\nvalue of an instance of apsStatusFEPLFs increments.")

# Groups

apsConfigGeneral = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 1)).setObjects(("APS-MIB", "apsConfigRowStatus"), ("APS-MIB", "apsConfigDirection"), ("APS-MIB", "apsConfigSdBerThreshold"), ("APS-MIB", "apsNotificationEnable"), ("APS-MIB", "apsConfigMode"), ("APS-MIB", "apsConfigSfBerThreshold"), ("APS-MIB", "apsConfigStorageType"), ("APS-MIB", "apsConfigExtraTraffic"), ("APS-MIB", "apsConfigRevert"), ("APS-MIB", "apsConfigCreationTime"), )
if mibBuilder.loadTexts: apsConfigGeneral.setDescription("A collection of apsConfigTable objects providing configuration\ninformation applicable to all linear APS groups.")
apsConfigWtr = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 2)).setObjects(("APS-MIB", "apsConfigWaitToRestore"), )
if mibBuilder.loadTexts: apsConfigWtr.setDescription("The apsConfigTable object that provides information which is\napplicable to groups supporting a configurable WTR period.")
apsCommandOnePlusOne = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 3)).setObjects(("APS-MIB", "apsCommandSwitch"), )
if mibBuilder.loadTexts: apsCommandOnePlusOne.setDescription("The  apsCommandTable object which is applicable to groups\nimplementing the linear APS 1+1 architecture. Also, set\noperations must be supported.")
apsCommandOneToN = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 4)).setObjects(("APS-MIB", "apsCommandControl"), ("APS-MIB", "apsCommandSwitch"), )
if mibBuilder.loadTexts: apsCommandOneToN.setDescription("A collection of apsCommandTable objects which are applicable to\ngroups implementing the linear APS 1:n architecture. Also, set\noperations must be supported.")
apsStatusGeneral = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 5)).setObjects(("APS-MIB", "apsStatusK1K2Rcv"), ("APS-MIB", "apsStatusFEPLFs"), ("APS-MIB", "apsStatusModeMismatches"), ("APS-MIB", "apsStatusDiscontinuityTime"), ("APS-MIB", "apsStatusCurrent"), ("APS-MIB", "apsStatusPSBFs"), ("APS-MIB", "apsStatusChannelMismatches"), ("APS-MIB", "apsStatusSwitchedChannel"), ("APS-MIB", "apsStatusK1K2Trans"), )
if mibBuilder.loadTexts: apsStatusGeneral.setDescription("A collection of apsStatusTable objects providing status\ninformation applicable to all linear APS groups.")
apsChanGeneral = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 6)).setObjects(("APS-MIB", "apsChanStatusCurrent"), ("APS-MIB", "apsChanStatusLastSwitchover"), ("APS-MIB", "apsChanStatusSignalDegrades"), ("APS-MIB", "apsChanConfigIfIndex"), ("APS-MIB", "apsChanConfigRowStatus"), ("APS-MIB", "apsChanStatusSwitchovers"), ("APS-MIB", "apsChanStatusSignalFailures"), ("APS-MIB", "apsChanStatusSwitchoverSeconds"), ("APS-MIB", "apsChanConfigStorageType"), ("APS-MIB", "apsChanStatusDiscontinuityTime"), )
if mibBuilder.loadTexts: apsChanGeneral.setDescription("A collection of channel objects providing information\napplicable to all linear APS channels.")
apsChanOneToN = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 7)).setObjects(("APS-MIB", "apsChanConfigPriority"), )
if mibBuilder.loadTexts: apsChanOneToN.setDescription("The apsChanConfigTable object that provides information which\nis only applicable to groups implementing the linear APS 1:n\narchitecture.")
apsTotalsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 8)).setObjects(("APS-MIB", "apsChanLTEs"), ("APS-MIB", "apsConfigGroups"), )
if mibBuilder.loadTexts: apsTotalsGroup.setDescription("A collection of objects providing optional counts of configured\nAPS groups and SONET LTE interfaces.")
apsMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 9)).setObjects(("APS-MIB", "apsMapChanNumber"), ("APS-MIB", "apsMapGroupName"), )
if mibBuilder.loadTexts: apsMapGroup.setDescription("A collection of apsMapTable objects providing a mapping\nfrom sonet(39) InterfaceIndex to group name and channel\nnumber for assigned APS channels and a list of unassigned\nsonet(39) interfaces.")
apsEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 49, 3, 1, 10)).setObjects(("APS-MIB", "apsEventFEPLF"), ("APS-MIB", "apsEventSwitchover"), ("APS-MIB", "apsEventModeMismatch"), ("APS-MIB", "apsEventChannelMismatch"), ("APS-MIB", "apsEventPSBF"), )
if mibBuilder.loadTexts: apsEventGroup.setDescription("A collection of SONET linear APS notifications.")

# Compliances

apsFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 49, 3, 2, 1)).setObjects(("APS-MIB", "apsConfigGeneral"), ("APS-MIB", "apsChanOneToN"), ("APS-MIB", "apsCommandOneToN"), ("APS-MIB", "apsConfigWtr"), ("APS-MIB", "apsStatusGeneral"), ("APS-MIB", "apsCommandOnePlusOne"), ("APS-MIB", "apsChanGeneral"), ("APS-MIB", "apsMapGroup"), ("APS-MIB", "apsTotalsGroup"), ("APS-MIB", "apsEventGroup"), )
if mibBuilder.loadTexts: apsFullCompliance.setDescription("When this MIB is implemented with support for read-create, then\nsuch an implementation can claim read/write compliance. Linear\nAPS groups can then be both monitored and configured with this\nMIB.\n\nNote that An agent is not required to process SNMP Set Requests\nthat affect multiple control objects within this MIB. This is\nintended to simplify the processing of Set Requests for the\nvarious control tables by eliminating the possibility that a\nsingle Set PDU will contain multiple varbinds which are in\nconflict. ")
apsReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 49, 3, 2, 2)).setObjects(("APS-MIB", "apsConfigGeneral"), ("APS-MIB", "apsChanOneToN"), ("APS-MIB", "apsCommandOneToN"), ("APS-MIB", "apsConfigWtr"), ("APS-MIB", "apsStatusGeneral"), ("APS-MIB", "apsCommandOnePlusOne"), ("APS-MIB", "apsChanGeneral"), ("APS-MIB", "apsMapGroup"), ("APS-MIB", "apsTotalsGroup"), ("APS-MIB", "apsEventGroup"), )
if mibBuilder.loadTexts: apsReadOnlyCompliance.setDescription("When this MIB is implemented without support for read-create\n(i.e. in read-only mode), then that implementation can claim\nread-only compliance. In that case, linear APS groups can be\nmonitored but cannot be configured with this MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("APS-MIB", PYSNMP_MODULE_ID=apsMIB)

# Types
mibBuilder.exportSymbols("APS-MIB", ApsControlCommand=ApsControlCommand, ApsK1K2=ApsK1K2, ApsSwitchCommand=ApsSwitchCommand)

# Objects
mibBuilder.exportSymbols("APS-MIB", apsMIB=apsMIB, apsMIBObjects=apsMIBObjects, apsConfig=apsConfig, apsConfigGroups=apsConfigGroups, apsConfigTable=apsConfigTable, apsConfigEntry=apsConfigEntry, apsConfigName=apsConfigName, apsConfigRowStatus=apsConfigRowStatus, apsConfigMode=apsConfigMode, apsConfigRevert=apsConfigRevert, apsConfigDirection=apsConfigDirection, apsConfigExtraTraffic=apsConfigExtraTraffic, apsConfigSdBerThreshold=apsConfigSdBerThreshold, apsConfigSfBerThreshold=apsConfigSfBerThreshold, apsConfigWaitToRestore=apsConfigWaitToRestore, apsConfigCreationTime=apsConfigCreationTime, apsConfigStorageType=apsConfigStorageType, apsStatusTable=apsStatusTable, apsStatusEntry=apsStatusEntry, apsStatusK1K2Rcv=apsStatusK1K2Rcv, apsStatusK1K2Trans=apsStatusK1K2Trans, apsStatusCurrent=apsStatusCurrent, apsStatusModeMismatches=apsStatusModeMismatches, apsStatusChannelMismatches=apsStatusChannelMismatches, apsStatusPSBFs=apsStatusPSBFs, apsStatusFEPLFs=apsStatusFEPLFs, apsStatusSwitchedChannel=apsStatusSwitchedChannel, apsStatusDiscontinuityTime=apsStatusDiscontinuityTime, apsMap=apsMap, apsChanLTEs=apsChanLTEs, apsMapTable=apsMapTable, apsMapEntry=apsMapEntry, apsMapGroupName=apsMapGroupName, apsMapChanNumber=apsMapChanNumber, apsChanConfigTable=apsChanConfigTable, apsChanConfigEntry=apsChanConfigEntry, apsChanConfigGroupName=apsChanConfigGroupName, apsChanConfigNumber=apsChanConfigNumber, apsChanConfigRowStatus=apsChanConfigRowStatus, apsChanConfigIfIndex=apsChanConfigIfIndex, apsChanConfigPriority=apsChanConfigPriority, apsChanConfigStorageType=apsChanConfigStorageType, apsCommandTable=apsCommandTable, apsCommandEntry=apsCommandEntry, apsCommandSwitch=apsCommandSwitch, apsCommandControl=apsCommandControl, apsChanStatusTable=apsChanStatusTable, apsChanStatusEntry=apsChanStatusEntry, apsChanStatusCurrent=apsChanStatusCurrent, apsChanStatusSignalDegrades=apsChanStatusSignalDegrades, apsChanStatusSignalFailures=apsChanStatusSignalFailures, apsChanStatusSwitchovers=apsChanStatusSwitchovers, apsChanStatusLastSwitchover=apsChanStatusLastSwitchover, apsChanStatusSwitchoverSeconds=apsChanStatusSwitchoverSeconds, apsChanStatusDiscontinuityTime=apsChanStatusDiscontinuityTime, apsNotificationEnable=apsNotificationEnable, apsMIBNotifications=apsMIBNotifications, apsNotificationsPrefix=apsNotificationsPrefix, apsMIBConformance=apsMIBConformance, apsGroups=apsGroups, apsCompliances=apsCompliances)

# Notifications
mibBuilder.exportSymbols("APS-MIB", apsEventSwitchover=apsEventSwitchover, apsEventModeMismatch=apsEventModeMismatch, apsEventChannelMismatch=apsEventChannelMismatch, apsEventPSBF=apsEventPSBF, apsEventFEPLF=apsEventFEPLF)

# Groups
mibBuilder.exportSymbols("APS-MIB", apsConfigGeneral=apsConfigGeneral, apsConfigWtr=apsConfigWtr, apsCommandOnePlusOne=apsCommandOnePlusOne, apsCommandOneToN=apsCommandOneToN, apsStatusGeneral=apsStatusGeneral, apsChanGeneral=apsChanGeneral, apsChanOneToN=apsChanOneToN, apsTotalsGroup=apsTotalsGroup, apsMapGroup=apsMapGroup, apsEventGroup=apsEventGroup)

# Compliances
mibBuilder.exportSymbols("APS-MIB", apsFullCompliance=apsFullCompliance, apsReadOnlyCompliance=apsReadOnlyCompliance)
