# PySNMP SMI module. Autogenerated from smidump -f python DOT3-OAM-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:22 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( CounterBasedGauge64, ) = mibBuilder.importSymbols("HCNUM-TC", "CounterBasedGauge64")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( MacAddress, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "MacAddress", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class EightOTwoOui(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(3,3)
    fixedLength = 3
    

# Objects

dot3OamMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 158)).setRevisions(("2007-06-14 00:00",))
if mibBuilder.loadTexts: dot3OamMIB.setOrganization("IETF Ethernet Interfaces and Hub MIB Working Group")
if mibBuilder.loadTexts: dot3OamMIB.setContactInfo("WG Charter:\nhttp://www.ietf.org/html.charters/hubmib-charter.html\nMailing lists:\nGeneral Discussion: hubmib@ietf.org\nTo Subscribe: hubmib-requests@ietf.org\nIn Body: subscribe your_email_address\nChair: Bert Wijnen\nAlcatel-Lucent\nEmail: bwijnen at alcatel-lucent dot com\nEditor: Matt Squire\nHatteras Networks\nE-mail: msquire at hatterasnetworks dot com")
if mibBuilder.loadTexts: dot3OamMIB.setDescription("The MIB module for managing the new Ethernet OAM features\nintroduced by the Ethernet in the First Mile taskforce (IEEE\n802.3ah).  The functionality presented here is based on IEEE\n802.3ah [802.3ah], released in October, 2004.  [802.3ah] was\nprepared as an addendum to the standing version of IEEE 802.3\n[802.3-2002].  Since then, [802.3ah] has been\nmerged into the base IEEE 802.3 specification in [802.3-2005].\n\nIn particular, this MIB focuses on the new OAM functions\nintroduced in Clause 57 of [802.3ah].  The OAM functionality\nof Clause 57 is controlled by new management attributes\nintroduced in Clause 30 of [802.3ah].  The OAM functions are\nnot specific to any particular Ethernet physical layer, and\ncan be generically applied to any Ethernet interface of\n[802.3-2002].\n\nAn Ethernet OAM protocol data unit is a valid Ethernet frame\nwith a destination MAC address equal to the reserved MAC\naddress for Slow Protocols (See 43B of [802.3ah]), a\nlengthOrType field equal to the reserved type for Slow\nProtocols, and a Slow Protocols subtype equal to that of the\nsubtype reserved for Ethernet OAM.  OAMPDU is used throughout\nthis document as an abbreviation for Ethernet OAM protocol\ndata unit.\n\nThe following reference is used throughout this MIB module:\n\n\n\n\n  [802.3ah] refers to:\n    IEEE Std 802.3ah-2004: 'Draft amendment to -\n    Information technology - Telecommunications and\n    information exchange between systems - Local and\n    metropolitan area networks - Specific requirements - Part\n    3: Carrier sense multiple access with collision detection\n    (CSMA/CD) access method and physical layer specifications\n    - Media Access Control Parameters, Physical Layers and\n    Management Parameters for subscriber access networks',\n    October 2004.\n\n  [802.3-2002] refers to:\n    IEEE Std 802.3-2002:\n    'Information technology - Telecommunications and\n    information exchange between systems - Local and\n    metropolitan area networks - Specific requirements - Part\n    3: Carrier sense multiple access with collision detection\n    (CSMA/CD) access method and physical layer specifications\n    - Media Access Control Parameters, Physical Layers and\n    Management Parameters for subscriber access networks',\n    March 2002.\n\n  [802.3-2005] refers to:\n    IEEE Std 802.3-2005:\n    'Information technology - Telecommunications and\n    information exchange between systems - Local and\n    metropolitan area networks - Specific requirements - Part\n    3: Carrier sense multiple access with collision detection\n    (CSMA/CD) access method and physical layer specifications\n    - Media Access Control Parameters, Physical Layers and\n    Management Parameters for subscriber access networks',\n    December 2005.\n\n  [802-2001] refers to:\n    'IEEE Standard for LAN/MAN (Local Area\n    Network/Metropolitan Area Network): Overview and\n    Architecture', IEEE 802, June 2001.\n\nCopyright (c) The IETF Trust (2007).  This version of\nthis MIB module is part of RFC 4878; See the RFC itself for\nfull legal notices. ")
dot3OamNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 158, 0))
dot3OamObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 158, 1))
dot3OamTable = MibTable((1, 3, 6, 1, 2, 1, 158, 1, 1))
if mibBuilder.loadTexts: dot3OamTable.setDescription("This table contains the primary controls and status for the\nOAM capabilities of an Ethernet-like interface.  There will be\none row in this table for each Ethernet-like interface in the\nsystem that supports the OAM functions defined in [802.3ah].")
dot3OamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 158, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OamEntry.setDescription("An entry in the table that contains information on the\nEthernet OAM function for a single Ethernet like interface.\nEntries in the table are created automatically for each\ninterface supporting Ethernet OAM.  The status of the row\nentry can be determined from dot3OamOperStatus.\n\nA dot3OamEntry is indexed in the dot3OamTable by the ifIndex\nobject of the Interfaces MIB.")
dot3OamAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamAdminState.setDescription("This object is used to provision the default administrative\nOAM mode for this interface.  This object represents the\ndesired state of OAM for this interface.\n\nThe dot3OamAdminState always starts in the disabled(2) state\nuntil an explicit management action or configuration\ninformation retained by the system causes a transition to the\nenabled(1) state.  When enabled(1), Ethernet OAM will attempt\nto operate over this interface.")
dot3OamOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(10,5,1,7,3,4,8,6,9,2,)).subtype(namedValues=namedval.NamedValues(("disabled", 1), ("nonOperHalfDuplex", 10), ("linkFault", 2), ("passiveWait", 3), ("activeSendLocal", 4), ("sendLocalAndRemote", 5), ("sendLocalAndRemoteOk", 6), ("oamPeeringLocallyRejected", 7), ("oamPeeringRemotelyRejected", 8), ("operational", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamOperStatus.setDescription("At initialization and failure conditions, two OAM entities on\n\n\n\nthe same full-duplex Ethernet link begin a discovery phase to\ndetermine what OAM capabilities may be used on that link.  The\nprogress of this initialization is controlled by the OA\nsublayer.\n\nThis value is always disabled(1) if OAM is disabled on this\ninterface via the dot3OamAdminState.\n\nIf the link has detected a fault and is transmitting OAMPDUs\nwith a link fault indication, the value is linkFault(2).\nAlso, if the interface is not operational (ifOperStatus is\nnot up(1)), linkFault(2) is returned.  Note that the object\nifOperStatus may not be up(1) as a result of link failure or\nadministrative action (ifAdminState being down(2) or\ntesting(3)).\n\nThe passiveWait(3) state is returned only by OAM entities in\npassive mode (dot3OamMode) and reflects the state in which the\nOAM entity is waiting to see if the peer device is OA\ncapable.  The activeSendLocal(4) value is used by active mode\ndevices (dot3OamMode) and reflects the OAM entity actively\ntrying to discover whether the peer has OAM capability but has\nnot yet made that determination.\n\nThe state sendLocalAndRemote(5) reflects that the local OA\nentity has discovered the peer but has not yet accepted or\nrejected the configuration of the peer.  The local device can,\nfor whatever reason, decide that the peer device is\nunacceptable and decline OAM peering.  If the local OAM entity\nrejects the peer OAM entity, the state becomes\noamPeeringLocallyRejected(7).  If the OAM peering is allowed\nby the local device, the state moves to\nsendLocalAndRemoteOk(6).  Note that both the\nsendLocalAndRemote(5) and oamPeeringLocallyRejected(7) states\nfall within the state SEND_LOCAL_REMOTE of the Discovery state\ndiagram [802.3ah, Figure 57-5], with the difference being\nwhether the local OAM client has actively rejected the peering\nor has just not indicated any decision yet.  Whether a peering\ndecision has been made is indicated via the local flags field\nin the OAMPDU (reflected in the aOAMLocalFlagsField of\n30.3.6.1.10).\n\nIf the remote OAM entity rejects the peering, the state\nbecomes oamPeeringRemotelyRejected(8).  Note that both the\nsendLocalAndRemoteOk(6) and oamPeeringRemotelyRejected(8)\nstates fall within the state SEND_LOCAL_REMOTE_OK of the\nDiscovery state diagram [802.3ah, Figure 57-5], with the\ndifference being whether the remote OAM client has rejected\n\n\n\nthe peering or has just not yet decided.  This is indicated\nvia the remote flags field in the OAMPDU (reflected in the\naOAMRemoteFlagsField of 30.3.6.1.11).\n\nWhen the local OAM entity learns that both it and the remote\nOAM entity have accepted the peering, the state moves to\noperational(9) corresponding to the SEND_ANY state of the\nDiscovery state diagram [802.3ah, Figure 57-5].\n\nSince Ethernet OAM functions are not designed to work\ncompletely over half-duplex interfaces, the value\nnonOperHalfDuplex(10) is returned whenever Ethernet OAM is\nenabled (dot3OamAdminState is enabled(1)), but the interface\nis in half-duplex operation.")
dot3OamMode = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("passive", 1), ("active", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamMode.setDescription("This object configures the mode of OAM operation for this\nEthernet-like interface.  OAM on Ethernet interfaces may be in\n'active' mode or 'passive' mode.  These two modes differ in\nthat active mode provides additional capabilities to initiate\nmonitoring activities with the remote OAM peer entity, while\npassive mode generally waits for the peer to initiate OA\nactions with it.  As an example, an active OAM entity can put\nthe remote OAM entity in a loopback state, where a passive OA\nentity cannot.\n\nThe default value of dot3OamMode is dependent on the type of\nsystem on which this Ethernet-like interface resides.  The\ndefault value should be 'active(2)' unless it is known that\nthis system should take on a subservient role to the other\ndevice connected over this interface.\n\nChanging this value results in incrementing the configuration\nrevision field of locally generated OAMPDUs (30.3.6.1.12) and\npotentially re-doing the OAM discovery process if the\ndot3OamOperStatus was already operational(9).")
dot3OamMaxOamPduSize = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(64, 1518))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamMaxOamPduSize.setDescription("The largest OAMPDU that the OAM entity supports.  OA\nentities exchange maximum OAMPDU sizes and negotiate to use\nthe smaller of the two maximum OAMPDU sizes between the peers.\nThis value is determined by the local implementation.")
dot3OamConfigRevision = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamConfigRevision.setDescription("The configuration revision of the OAM entity as reflected in\nthe latest OAMPDU sent by the OAM entity.  The config revision\nis used by OAM entities to indicate that configuration changes\nhave occurred, which might require the peer OAM entity to\nre-evaluate whether OAM peering is allowed.")
dot3OamFunctionsSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 1, 1, 6), Bits().subtype(namedValues=namedval.NamedValues(("unidirectionalSupport", 0), ("loopbackSupport", 1), ("eventSupport", 2), ("variableSupport", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamFunctionsSupported.setDescription("The OAM functions supported on this Ethernet-like interface.\nOAM consists of separate functional sets beyond the basic\ndiscovery process that is always required.  These functional\ngroups can be supported independently by any implementation.\nThese values are communicated to the peer via the local\nconfiguration field of Information OAMPDUs.\n\nSetting 'unidirectionalSupport(0)' indicates that the OA\n\n\n\nentity supports the transmission of OAMPDUs on links that are\noperating in unidirectional mode (traffic flowing in one\ndirection only).  Setting 'loopbackSupport(1)' indicates that\nthe OAM entity can initiate and respond to loopback commands.\nSetting 'eventSupport(2)' indicates that the OAM entity can\nsend and receive Event Notification OAMPDUs.  Setting\n'variableSupport(3)' indicates that the OAM entity can send\nand receive Variable Request and Response OAMPDUs.")
dot3OamPeerTable = MibTable((1, 3, 6, 1, 2, 1, 158, 1, 2))
if mibBuilder.loadTexts: dot3OamPeerTable.setDescription("This table contains information about the OAM peer for a\nparticular Ethernet-like interface.  OAM entities communicate\nwith a single OAM peer entity on Ethernet links on which OA\nis enabled and operating properly.  There is one entry in this\ntable for each entry in the dot3OamTable for which information\non the peer OAM entity is available.")
dot3OamPeerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 158, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OamPeerEntry.setDescription("An entry in the table containing information on the peer OA\nentity for a single Ethernet-like interface.\n\nNote that there is at most one OAM peer for each Ethernet-like\ninterface.  Entries are automatically created when information\nabout the OAM peer entity becomes available, and automatically\ndeleted when the OAM peer entity is no longer in\ncommunication.  Peer information is not available when\ndot3OamOperStatus is disabled(1), linkFault(2),\npassiveWait(3), activeSendLocal(4), or nonOperHalfDuplex(10).")
dot3OamPeerMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerMacAddress.setDescription("The MAC address of the peer OAM entity.  The MAC address is\nderived from the most recently received OAMPDU.")
dot3OamPeerVendorOui = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 2), EightOTwoOui()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerVendorOui.setDescription("The OUI of the OAM peer as reflected in the latest\nInformation OAMPDU received with a Local Information TLV.  The\nOUI can be used to identify the vendor of the remote OA\nentity.  This value is initialized to three octets of zero\nbefore any Local Information TLV is received.")
dot3OamPeerVendorInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerVendorInfo.setDescription("The Vendor Info of the OAM peer as reflected in the latest\nInformation OAMPDU received with a Local Information TLV.\nThe semantics of the Vendor Information field is proprietary\nand specific to the vendor (identified by the\ndot3OamPeerVendorOui).  This information could, for example,\n\n\n\nbe used to identify a specific product or product family.\nThis value is initialized to zero before any Local\nInformation TLV is received.")
dot3OamPeerMode = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("passive", 1), ("active", 2), ("unknown", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerMode.setDescription("The mode of the OAM peer as reflected in the latest\nInformation OAMPDU received with a Local Information TLV.  The\nmode of the peer can be determined from the Configuration\nfield in the Local Information TLV of the last Information\nOAMPDU received from the peer.  The value is unknown(3)\nwhenever no Local Information TLV has been received.  The\nvalues of active(2) and passive(1) are returned when a Local\nInformation TLV has been received indicating that the peer is\nin active or passive mode, respectively.")
dot3OamPeerMaxOamPduSize = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(64,1518),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerMaxOamPduSize.setDescription("The maximum size of OAMPDU supported by the peer as reflected\nin the latest Information OAMPDU received with a Local\nInformation TLV.  Ethernet OAM on this interface must not use\nOAMPDUs that exceed this size.  The maximum OAMPDU size can be\ndetermined from the PDU Configuration field of the Local\nInformation TLV of the last Information OAMPDU received from\nthe peer.  A value of zero is returned if no Local Information\nTLV has been received.  Otherwise, the value of the OAM peer's\nmaximum OAMPDU size is returned in this value.")
dot3OamPeerConfigRevision = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerConfigRevision.setDescription("The configuration revision of the OAM peer as reflected in\nthe latest OAMPDU.  This attribute is changed by the peer\nwhenever it has a local configuration change for Ethernet OA\non this interface.  The configuration revision can be\ndetermined from the Revision field of the Local Information\nTLV of the most recently received Information OAMPDU with\na Local Information TLV.  A value of zero is returned if\nno Local Information TLV has been received.")
dot3OamPeerFunctionsSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 2, 1, 7), Bits().subtype(namedValues=namedval.NamedValues(("unidirectionalSupport", 0), ("loopbackSupport", 1), ("eventSupport", 2), ("variableSupport", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamPeerFunctionsSupported.setDescription("The OAM functions supported on this Ethernet-like interface.\nOAM consists of separate functionality sets above the basic\ndiscovery process.  This value indicates the capabilities of\nthe peer OAM entity with respect to these functions.  This\nvalue is initialized so all bits are clear.\n\nIf unidirectionalSupport(0) is set, then the peer OAM entity\nsupports sending OAM frames on Ethernet interfaces when the\nreceive path is known to be inoperable.  If\nloopbackSupport(1) is set, then the peer OAM entity can send\nand receive OAM loopback commands.  If eventSupport(2) is set,\nthen the peer OAM entity can send and receive event OAMPDUs to\nsignal various error conditions.  If variableSupport(3) is\nset, then the peer OAM entity can send and receive variable\nrequests to monitor the attribute value as described in Clause\n57 of [802.3ah].\n\nThe capabilities of the OAM peer can be determined from the\nconfiguration field of the Local Information TLV of the most\nrecently received Information OAMPDU with a Local Information\nTLV.  All zeros are returned if no Local Information TLV has\n\n\n\nyet been received.")
dot3OamLoopbackTable = MibTable((1, 3, 6, 1, 2, 1, 158, 1, 3))
if mibBuilder.loadTexts: dot3OamLoopbackTable.setDescription("This table contains controls for the loopback state of the\nlocal link as well as indicates the status of the loopback\nfunction.  There is one entry in this table for each entry in\ndot3OamTable that supports loopback functionality (where\ndot3OamFunctionsSupported includes the loopbackSupport bit\nset).\n\nLoopback can be used to place the remote OAM entity in a state\nwhere every received frame (except OAMPDUs) is echoed back\nover the same interface on which they were received.  In this\nstate, at the remote entity, 'normal' traffic is disabled as\nonly the looped back frames are transmitted on the interface.\nLoopback is thus an intrusive operation that prohibits normal\ndata flow and should be used accordingly.")
dot3OamLoopbackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 158, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OamLoopbackEntry.setDescription("An entry in the table, containing information on the loopback\nstatus for a single Ethernet-like interface.  Entries in the\ntable are automatically created whenever the local OAM entity\nsupports loopback capabilities.  The loopback status on the\ninterface can be determined from the dot3OamLoopbackStatus\nobject.")
dot3OamLoopbackStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 3, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,4,6,5,)).subtype(namedValues=namedval.NamedValues(("noLoopback", 1), ("initiatingLoopback", 2), ("remoteLoopback", 3), ("terminatingLoopback", 4), ("localLoopback", 5), ("unknown", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamLoopbackStatus.setDescription("The loopback status of the OAM entity.  This status is\ndetermined by a combination of the local parser and\nmultiplexer states, the remote parser and multiplexer states,\nas well as by the actions of the local OAM client.  When\noperating in normal mode with no loopback in progress, the\nstatus reads noLoopback(1).\n\nThe values initiatingLoopback(2) and terminatingLoopback(4)\ncan be read or written.  The other values can only be read -\nthey can never be written.  Writing initiatingLoopback causes\nthe local OAM entity to start the loopback process with its\npeer.  This value can only be written when the status is\nnoLoopback(1).  Writing the value initiatingLoopback(2) in any\nother state has no effect.  When in remoteLoopback(3), writing\nterminatingLoopback(4) causes the local OAM entity to initiate\nthe termination of the loopback state.  Writing\nterminatingLoopack(4) in any other state has no effect.\n\nIf the OAM client initiates a loopback and has sent a\nLoopback OAMPDU and is waiting for a response, where the local\nparser and multiplexer states are DISCARD (see [802.3ah,\n57.2.11.1]), the status is 'initiatingLoopback'.  In this\ncase, the local OAM entity has yet to receive any\nacknowledgment that the remote OAM entity has received its\nloopback command request.\n\n\n\n\nIf the local OAM client knows that the remote OAM entity is in\nloopback mode (via the remote state information as described\nin [802.3ah, 57.2.11.1, 30.3.6.1.15]), the status is\nremoteLoopback(3).  If the local OAM client is in the process\nof terminating the remote loopback [802.3ah, 57.2.11.3,\n30.3.6.1.14] with its local multiplexer and parser states in\nDISCARD, the status is terminatingLoopback(4).  If the remote\nOAM client has put the local OAM entity in loopback mode as\nindicated by its local parser state, the status is\nlocalLoopback(5).\n\nThe unknown(6) status indicates that the parser and\nmultiplexer combination is unexpected.  This status may be\nreturned if the OAM loopback is in a transition state but\nshould not persist.\n\nThe values of this attribute correspond to the following\nvalues of the local and remote parser and multiplexer states.\n\n  value            LclPrsr   LclMux    RmtPrsr   RmtMux\n  noLoopback         FWD       FWD       FWD       FWD\n  initLoopback     DISCARD   DISCARD     FWD       FWD\n  rmtLoopback      DISCARD     FWD      LPBK    DISCARD\n  tmtngLoopback    DISCARD   DISCARD    LPBK    DISCARD\n  lclLoopback        LPBK    DISCARD   DISCARD     FWD\n  unknown            ***   any other combination   ***")
dot3OamLoopbackIgnoreRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("ignore", 1), ("process", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamLoopbackIgnoreRx.setDescription("Since OAM loopback is a disruptive operation (user traffic\ndoes not pass), this attribute provides a mechanism to provide\ncontrols over whether received OAM loopback commands are\nprocessed or ignored.  When the value is ignore(1), received\nloopback commands are ignored.  When the value is process(2),\nOAM loopback commands are processed.  The default value is to\nignore loopback commands (ignore(1)).")
dot3OamStatsTable = MibTable((1, 3, 6, 1, 2, 1, 158, 1, 4))
if mibBuilder.loadTexts: dot3OamStatsTable.setDescription("This table contains statistics for the OAM function on a\nparticular Ethernet-like interface.  There is an entry in the\ntable for every entry in the dot3OamTable.\n\nThe counters in this table are defined as 32-bit entries to\nmatch the counter size as defined in [802.3ah].  Given that\nthe OA protocol is a slow protocol, the counters increment at\na slow rate.")
dot3OamStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 158, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OamStatsEntry.setDescription("An entry in the table containing statistics information on\nthe Ethernet OAM function for a single Ethernet-like\ninterface.  Entries are automatically created for every entry\nin the dot3OamTable.  Counters are maintained across\ntransitions in dot3OamOperStatus.")
dot3OamInformationTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamInformationTx.setDescription("A count of the number of Information OAMPDUs transmitted on\nthis interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.  ")
dot3OamInformationRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamInformationRx.setDescription("A count of the number of Information OAMPDUs received on this\ninterface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamUniqueEventNotificationTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamUniqueEventNotificationTx.setDescription("A count of the number of unique Event OAMPDUs transmitted on\nthis interface.  Event Notifications may be sent in duplicate\nto increase the probability of successfully being received,\n\n\n\ngiven the possibility that a frame may be lost in transit.\nDuplicate Event Notification transmissions are counted by\ndot3OamDuplicateEventNotificationTx.\n\nA unique Event Notification OAMPDU is indicated as an Event\nNotification OAMPDU with a Sequence Number field that is\ndistinct from the previously transmitted Event Notification\nOAMPDU Sequence Number.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamUniqueEventNotificationRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamUniqueEventNotificationRx.setDescription("A count of the number of unique Event OAMPDUs received on\nthis interface.  Event Notification OAMPDUs may be sent in\nduplicate to increase the probability of successfully being\nreceived, given the possibility that a frame may be lost in\ntransit.  Duplicate Event Notification receptions are counted\nby dot3OamDuplicateEventNotificationRx.\n\nA unique Event Notification OAMPDU is indicated as an Event\nNotification OAMPDU with a Sequence Number field that is\ndistinct from the previously received Event Notification\nOAMPDU Sequence Number.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamDuplicateEventNotificationTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamDuplicateEventNotificationTx.setDescription("A count of the number of duplicate Event OAMPDUs transmitted\n\n\n\non this interface.  Event Notification OAMPDUs may be sent in\nduplicate to increase the probability of successfully being\nreceived, given the possibility that a frame may be lost in\ntransit.\n\nA duplicate Event Notification OAMPDU is indicated as an Event\nNotification OAMPDU with a Sequence Number field that is\nidentical to the previously transmitted Event Notification\nOAMPDU Sequence Number.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamDuplicateEventNotificationRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamDuplicateEventNotificationRx.setDescription("A count of the number of duplicate Event OAMPDUs received on\nthis interface.  Event Notification OAMPDUs may be sent in\nduplicate to increase the probability of successfully being\nreceived, given the possibility that a frame may be lost in\ntransit.\n\nA duplicate Event Notification OAMPDU is indicated as an Event\nNotification OAMPDU with a Sequence Number field that is\nidentical to the previously received Event Notification OAMPDU\nSequence Number.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamLoopbackControlTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamLoopbackControlTx.setDescription("A count of the number of Loopback Control OAMPDUs transmitted\n\n\n\non this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamLoopbackControlRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamLoopbackControlRx.setDescription("A count of the number of Loopback Control OAMPDUs received\non this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamVariableRequestTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamVariableRequestTx.setDescription("A count of the number of Variable Request OAMPDUs transmitted\non this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamVariableRequestRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamVariableRequestRx.setDescription("A count of the number of Variable Request OAMPDUs received on\n\n\n\nthis interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamVariableResponseTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamVariableResponseTx.setDescription("A count of the number of Variable Response OAMPDUs\ntransmitted on this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamVariableResponseRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamVariableResponseRx.setDescription("A count of the number of Variable Response OAMPDUs received\non this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamOrgSpecificTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamOrgSpecificTx.setDescription("A count of the number of Organization Specific OAMPDUs\n\n\n\ntransmitted on this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamOrgSpecificRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamOrgSpecificRx.setDescription("A count of the number of Organization Specific OAMPDUs\nreceived on this interface.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamUnsupportedCodesTx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamUnsupportedCodesTx.setDescription("A count of the number of OAMPDUs transmitted on this\ninterface with an unsupported op-code.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamUnsupportedCodesRx = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamUnsupportedCodesRx.setDescription("A count of the number of OAMPDUs received on this interface\n\n\n\nwith an unsupported op-code.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamFramesLostDueToOam = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 4, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamFramesLostDueToOam.setDescription("A count of the number of frames that were dropped by the OA\nmultiplexer.  Since the OAM multiplexer has multiple inputs\nand a single output, there may be cases where frames are\ndropped due to transmit resource contention.  This counter is\nincremented whenever a frame is dropped by the OAM layer.\nNote that any Ethernet frame, not just OAMPDUs, may be dropped\nby the OAM layer.  This can occur when an OAMPDU takes\nprecedence over a 'normal' frame resulting in the 'normal'\nframe being dropped.\n\nWhen this counter is incremented, no other counters in this\nMIB are incremented.\n\nDiscontinuities of this counter can occur at re-initialization\nof the management system, and at other times as indicated by\nthe value of the ifCounterDiscontinuityTime.")
dot3OamEventConfigTable = MibTable((1, 3, 6, 1, 2, 1, 158, 1, 5))
if mibBuilder.loadTexts: dot3OamEventConfigTable.setDescription("Ethernet OAM includes the ability to generate and receive\nEvent Notification OAMPDUs to indicate various link problems.\nThis table contains the mechanisms to enable Event\n\n\n\nNotifications and configure the thresholds to generate the\nstandard Ethernet OAM events.  There is one entry in the table\nfor every entry in dot3OamTable that supports OAM events\n(where dot3OamFunctionsSupported includes the eventSupport\nbit set).  The values in the table are maintained across\nchanges to dot3OamOperStatus.\n\nThe standard threshold crossing events are:\n  - Errored Symbol Period Event.  Generated when the number of\n    symbol errors exceeds a threshold within a given window\n    defined by a number of symbols (for example, 1,000 symbols\n    out of 1,000,000 had errors).\n  - Errored Frame Period Event.  Generated when the number of\n    frame errors exceeds a threshold within a given window\n    defined by a number of frames (for example, 10 frames out\n    of 1000 had errors).\n  - Errored Frame Event.  Generated when the number of frame\n    errors exceeds a threshold within a given window defined\n    by a period of time (for example, 10 frames in 1 second\n    had errors).\n  - Errored Frame Seconds Summary Event.  Generated when the\n    number of errored frame seconds exceeds a threshold within\n    a given time period (for example, 10 errored frame seconds\n    within the last 100 seconds).  An errored frame second is\n    defined as a 1 second interval which had >0 frame errors.\nThere are other events (dying gasp, critical events) that are\nnot threshold crossing events but which can be\nenabled/disabled via this table.")
dot3OamEventConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 158, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dot3OamEventConfigEntry.setDescription("Entries are automatically created and deleted from this\ntable, and exist whenever the OAM entity supports Ethernet OA\nevents (as indicated by the eventSupport bit in\ndot3OamFunctionsSuppported).  Values in the table are\nmaintained across changes to the value of dot3OamOperStatus.\n\nEvent configuration controls when the local management entity\nsends Event Notification OAMPDUs to its OAM peer, and when\ncertain event flags are set or cleared in OAMPDUs.")
dot3OamErrSymPeriodWindowHi = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 1), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrSymPeriodWindowHi.setDescription("The two objects dot3OamErrSymPeriodWindowHi and\ndot3OamErrSymPeriodLo together form an unsigned 64-bit\ninteger representing the number of symbols over which this\nthreshold event is defined.  This is defined as\ndot3OamErrSymPeriodWindow = ((2^32)*dot3OamErrSymPeriodWindowHi)\n                                + dot3OamErrSymPeriodWindowLo\n\nIf dot3OamErrSymPeriodThreshold symbol errors occur within a\nwindow of dot3OamErrSymPeriodWindow symbols, an Event\nNotification OAMPDU should be generated with an Errored Symbol\nPeriod Event TLV indicating that the threshold has been\ncrossed in this window.\n\nThe default value for dot3OamErrSymPeriodWindow is the number\nof symbols in one second for the underlying physical layer.")
dot3OamErrSymPeriodWindowLo = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 2), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrSymPeriodWindowLo.setDescription("The two objects dot3OamErrSymPeriodWindowHi and\ndot3OamErrSymPeriodWindowLo together form an unsigned 64-bit\ninteger representing the number of symbols over which this\nthreshold event is defined.  This is defined as\n\ndot3OamErrSymPeriodWindow = ((2^32)*dot3OamErrSymPeriodWindowHi)\n                                + dot3OamErrSymPeriodWindowLo\n\nIf dot3OamErrSymPeriodThreshold symbol errors occur within a\nwindow of dot3OamErrSymPeriodWindow symbols, an Event\nNotification OAMPDU should be generated with an Errored Symbol\nPeriod Event TLV indicating that the threshold has been\ncrossed in this window.\n\nThe default value for dot3OamErrSymPeriodWindow is the number\nof symbols in one second for the underlying physical layer.")
dot3OamErrSymPeriodThresholdHi = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 3), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrSymPeriodThresholdHi.setDescription("The two objects dot3OamErrSymPeriodThresholdHi and\ndot3OamErrSymPeriodThresholdLo together form an unsigned\n64-bit integer representing the number of symbol errors that\nmust occur within a given window to cause this event.\n\nThis is defined as\n\n  dot3OamErrSymPeriodThreshold =\n                    ((2^32) * dot3OamErrSymPeriodThresholdHi)\n                            + dot3OamErrSymPeriodThresholdLo\n\nIf dot3OamErrSymPeriodThreshold symbol errors occur within a\nwindow of dot3OamErrSymPeriodWindow symbols, an Event\nNotification OAMPDU should be generated with an Errored Symbol\nPeriod Event TLV indicating that the threshold has been\ncrossed in this window.\n\nThe default value for dot3OamErrSymPeriodThreshold is one\nsymbol errors.  If the threshold value is zero, then an Event\n\n\n\nNotification OAMPDU is sent periodically (at the end of every\nwindow).  This can be used as an asynchronous notification to\nthe peer OAM entity of the statistics related to this\nthreshold crossing alarm.")
dot3OamErrSymPeriodThresholdLo = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 4), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrSymPeriodThresholdLo.setDescription("The two objects dot3OamErrSymPeriodThresholdHi and\ndot3OamErrSymPeriodThresholdLo together form an unsigned\n64-bit integer representing the number of symbol errors that\nmust occur within a given window to cause this event.\n\nThis is defined as\n\n  dot3OamErrSymPeriodThreshold =\n                    ((2^32) * dot3OamErrSymPeriodThresholdHi)\n                            + dot3OamErrSymPeriodThresholdLo\n\nIf dot3OamErrSymPeriodThreshold symbol errors occur within a\nwindow of dot3OamErrSymPeriodWindow symbols, an Event\nNotification OAMPDU should be generated with an Errored Symbol\nPeriod Event TLV indicating that the threshold has been\ncrossed in this window.\n\nThe default value for dot3OamErrSymPeriodThreshold is one\nsymbol error.  If the threshold value is zero, then an Event\nNotification OAMPDU is sent periodically (at the end of every\nwindow).  This can be used as an asynchronous notification to\nthe peer OAM entity of the statistics related to this\nthreshold crossing alarm.")
dot3OamErrSymPeriodEvNotifEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrSymPeriodEvNotifEnable.setDescription("If true, the OAM entity should send an Event Notification\nOAMPDU when an Errored Symbol Period Event occurs.\n\n\n\n\nBy default, this object should have the value true for\nEthernet-like interfaces that support OAM.  If the OAM layer\ndoes not support Event Notifications (as indicated via the\ndot3OamFunctionsSupported attribute), this value is ignored.")
dot3OamErrFramePeriodWindow = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 6), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFramePeriodWindow.setDescription("The number of frames over which the threshold is defined.\nThe default value of the window is the number of minimum size\nEthernet frames that can be received over the physical layer\nin one second.\n\nIf dot3OamErrFramePeriodThreshold frame errors occur within a\nwindow of dot3OamErrFramePeriodWindow frames, an Event\nNotification OAMPDU should be generated with an Errored Frame\nPeriod Event TLV indicating that the threshold has been\ncrossed in this window.")
dot3OamErrFramePeriodThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 7), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFramePeriodThreshold.setDescription("The number of frame errors that must occur for this event to\nbe triggered.  The default value is one frame error.  If the\nthreshold value is zero, then an Event Notification OAMPDU is\nsent periodically (at the end of every window).  This can be\nused as an asynchronous notification to the peer OAM entity of\nthe statistics related to this threshold crossing alarm.\n\nIf dot3OamErrFramePeriodThreshold frame errors occur within a\nwindow of dot3OamErrFramePeriodWindow frames, an Event\nNotification OAMPDU should be generated with an Errored Frame\nPeriod Event TLV indicating that the threshold has been\ncrossed in this window.")
dot3OamErrFramePeriodEvNotifEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFramePeriodEvNotifEnable.setDescription("If true, the OAM entity should send an Event Notification\nOAMPDU when an Errored Frame Period Event occurs.\n\nBy default, this object should have the value true for\nEthernet-like interfaces that support OAM.  If the OAM layer\ndoes not support Event Notifications (as indicated via the\ndot3OamFunctionsSupported attribute), this value is ignored.")
dot3OamErrFrameWindow = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 9), Unsigned32().clone(10)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFrameWindow.setDescription("The amount of time (in 100ms increments) over which the\nthreshold is defined.  The default value is 10 (1 second).\n\nIf dot3OamErrFrameThreshold frame errors occur within a window\nof dot3OamErrFrameWindow seconds (measured in tenths of\nseconds), an Event Notification OAMPDU should be generated\nwith an Errored Frame Event TLV indicating that the threshold\nhas been crossed in this window.")
dot3OamErrFrameThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 10), Unsigned32().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFrameThreshold.setDescription("The number of frame errors that must occur for this event to\nbe triggered.  The default value is one frame error.  If the\nthreshold value is zero, then an Event Notification OAMPDU is\nsent periodically (at the end of every window).  This can be\nused as an asynchronous notification to the peer OAM entity of\nthe statistics related to this threshold crossing alarm.\n\n\n\n\nIf dot3OamErrFrameThreshold frame errors occur within a window\nof dot3OamErrFrameWindow (in tenths of seconds), an Event\nNotification OAMPDU should be generated with an Errored Frame\nEvent TLV indicating the threshold has been crossed in this\nwindow.")
dot3OamErrFrameEvNotifEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 11), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFrameEvNotifEnable.setDescription("If true, the OAM entity should send an Event Notification\nOAMPDU when an Errored Frame Event occurs.\n\nBy default, this object should have the value true for\nEthernet-like interfaces that support OAM.  If the OAM layer\ndoes not support Event Notifications (as indicated via the\ndot3OamFunctionsSupported attribute), this value is ignored.")
dot3OamErrFrameSecsSummaryWindow = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(100, 9000)).clone(100)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFrameSecsSummaryWindow.setDescription("The amount of time (in 100 ms intervals) over which the\nthreshold is defined.  The default value is 100 (10 seconds).\n\nIf dot3OamErrFrameSecsSummaryThreshold frame errors occur\nwithin a window of dot3OamErrFrameSecsSummaryWindow (in tenths\nof seconds), an Event Notification OAMPDU should be generated\nwith an Errored Frame Seconds Summary Event TLV indicating\nthat the threshold has been crossed in this window.")
dot3OamErrFrameSecsSummaryThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 900)).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFrameSecsSummaryThreshold.setDescription("The number of errored frame seconds that must occur for this\nevent to be triggered.  The default value is one errored frame\nsecond.  If the threshold value is zero, then an Event\nNotification OAMPDU is sent periodically (at the end of every\nwindow).  This can be used as an asynchronous notification to\nthe peer OAM entity of the statistics related to this\nthreshold crossing alarm.\n\nIf dot3OamErrFrameSecsSummaryThreshold frame errors occur\nwithin a window of dot3OamErrFrameSecsSummaryWindow (in tenths\nof seconds), an Event Notification OAMPDU should be generated\nwith an Errored Frame Seconds Summary Event TLV indicating\nthat the threshold has been crossed in this window.")
dot3OamErrFrameSecsEvNotifEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 14), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamErrFrameSecsEvNotifEnable.setDescription("If true, the local OAM entity should send an Event\nNotification OAMPDU when an Errored Frame Seconds Event\noccurs.\n\nBy default, this object should have the value true for\nEthernet-like interfaces that support OAM.  If the OAM layer\ndoes not support Event Notifications (as indicated via the\ndot3OamFunctionsSupported attribute), this value is ignored.")
dot3OamDyingGaspEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 15), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamDyingGaspEnable.setDescription("If true, the local OAM entity should attempt to indicate a\ndying gasp via the OAMPDU flags field to its peer OAM entity\nwhen a dying gasp event occurs.  The exact definition of a\ndying gasp event is implementation dependent.  If the system\n\n\n\ndoes not support dying gasp capability, setting this object\nhas no effect, and reading the object should always result in\n'false'.\n\nBy default, this object should have the value true for\nEthernet-like interfaces that support OAM.  If the OAM layer\ndoes not support Event Notifications (as indicated via the\ndot3OamFunctionsSupported attribute), this value is ignored.")
dot3OamCriticalEventEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 5, 1, 16), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot3OamCriticalEventEnable.setDescription("If true, the local OAM entity should attempt to indicate a\ncritical event via the OAMPDU flags to its peer OAM entity\nwhen a critical event occurs.  The exact definition of a\ncritical event is implementation dependent.  If the system\ndoes not support critical event capability, setting this\nobject has no effect, and reading the object should always\nresult in 'false'.\n\nBy default, this object should have the value true for\nEthernet-like interfaces that support OAM.  If the OAM layer\ndoes not support Event Notifications (as indicated via the\ndot3OamFunctionsSupported attribute), this value is ignored.")
dot3OamEventLogTable = MibTable((1, 3, 6, 1, 2, 1, 158, 1, 6))
if mibBuilder.loadTexts: dot3OamEventLogTable.setDescription("This table records a history of the events that have occurred\nat the Ethernet OAM level.  These events can include locally\ndetected events, which may result in locally generated\nOAMPDUs, and remotely detected events, which are detected by\nthe OAM peer entity and signaled to the local entity via\n\n\n\nEthernet OAM.  Ethernet OAM events can be signaled by Event\nNotification OAMPDUs or by the flags field in any OAMPDU.\n\nThis table contains both threshold crossing events and\nnon-threshold crossing events.  The parameters for the\nthreshold window, threshold value, and actual value\n(dot3OamEventLogWindowXX, dot3OamEventLogThresholdXX,\ndot3OamEventLogValue) are only applicable to threshold\ncrossing events, and are returned as all F's (2^32 - 1) for\nnon-threshold crossing events.\n\nEntries in the table are automatically created when such\nevents are detected.  The size of the table is implementation\ndependent.  When the table reaches its maximum size, older\nentries are automatically deleted to make room for newer\nentries.")
dot3OamEventLogEntry = MibTableRow((1, 3, 6, 1, 2, 1, 158, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOT3-OAM-MIB", "dot3OamEventLogIndex"))
if mibBuilder.loadTexts: dot3OamEventLogEntry.setDescription("An entry in the dot3OamEventLogTable.  Entries are\nautomatically created whenever Ethernet OAM events occur at\nthe local OAM entity, and when Event Notification OAMPDUs are\nreceived at the local OAM entity (indicating that events have\noccurred at the peer OAM entity).  The size of the table is\nimplementation dependent, but when the table becomes full,\nolder events are automatically deleted to make room for newer\nevents.  The table index dot3OamEventLogIndex increments for\neach new entry, and when the maximum value is reached, the\nvalue restarts at zero.")
dot3OamEventLogIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot3OamEventLogIndex.setDescription("An arbitrary integer for identifying individual events\nwithin the event log.  ")
dot3OamEventLogTimestamp = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogTimestamp.setDescription("The value of sysUpTime at the time of the logged event.  For\nlocally generated events, the time of the event can be\naccurately retrieved from sysUpTime.  For remotely generated\nevents, the time of the event is indicated by the reception of\nthe Event Notification OAMPDU indicating that the event\noccurred on the peer.  A system may attempt to adjust the\ntimestamp value to more accurately reflect the time of the\nevent at the peer OAM entity by using other information, such\nas that found in the timestamp found of the Event Notification\nTLVs, which provides an indication of the relative time\nbetween events at the peer entity.  ")
dot3OamEventLogOui = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 3), EightOTwoOui()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogOui.setDescription("The OUI of the entity defining the object type.  All IEEE\n802.3 defined events (as appearing in [802.3ah] except for the\nOrganizationally Unique Event TLVs) use the IEEE 802.3 OUI of\n0x0180C2.  Organizations defining their own Event Notification\nTLVs include their OUI in the Event Notification TLV that\ngets reflected here.  ")
dot3OamEventLogType = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogType.setDescription("The type of event that generated this entry in the event log.\nWhen the OUI is the IEEE 802.3 OUI of 0x0180C2, the following\nevent types are defined:\n    erroredSymbolEvent(1),\n    erroredFramePeriodEvent(2),\n    erroredFrameEvent(3),\n    erroredFrameSecondsEvent(4),\n    linkFault(256),\n    dyingGaspEvent(257),\n    criticalLinkEvent(258)\nThe first four are considered threshold crossing events, as\nthey are generated when a metric exceeds a given value within\na specified window.  The other three are not threshold\ncrossing events.\n\nWhen the OUI is not 71874 (0x0180C2 in hex), then some other\norganization has defined the event space.  If event subtyping\nis known to the implementation, it may be reflected here.\nOtherwise, this value should return all F's (2^32 - 1).")
dot3OamEventLogLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("local", 1), ("remote", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogLocation.setDescription("Whether this event occurred locally (local(1)), or was\nreceived from the OAM peer via Ethernet OAM (remote(2)).")
dot3OamEventLogWindowHi = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogWindowHi.setDescription("If the event represents a threshold crossing event, the two\nobjects dot3OamEventWindowHi and dot3OamEventWindowLo, form\nan unsigned 64-bit integer yielding the window over which the\nvalue was measured for the threshold crossing event (for\nexample, 5, when 11 occurrences happened in 5 seconds while\nthe threshold was 10).  The two objects are combined as:\n\n\n\n\ndot3OamEventLogWindow = ((2^32) * dot3OamEventLogWindowHi)\n                                + dot3OamEventLogWindowLo\n\nOtherwise, this value is returned as all F's (2^32 - 1) and\nadds no useful information.")
dot3OamEventLogWindowLo = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogWindowLo.setDescription("If the event represents a threshold crossing event, the two\nobjects dot3OamEventWindowHi and dot3OamEventWindowLo form an\nunsigned 64-bit integer yielding the window over which the\nvalue was measured for the threshold crossing event (for\nexample, 5, when 11 occurrences happened in 5 seconds while\nthe threshold was 10).  The two objects are combined as:\n\ndot3OamEventLogWindow = ((2^32) * dot3OamEventLogWindowHi)\n                                + dot3OamEventLogWindowLo\n\nOtherwise, this value is returned as all F's (2^32 - 1) and\nadds no useful information.")
dot3OamEventLogThresholdHi = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogThresholdHi.setDescription("If the event represents a threshold crossing event, the two\nobjects dot3OamEventThresholdHi and dot3OamEventThresholdLo\nform an unsigned 64-bit integer yielding the value that was\ncrossed for the threshold crossing event (for example, 10,\nwhen 11 occurrences happened in 5 seconds while the threshold\nwas 10).  The two objects are combined as:\n\ndot3OamEventLogThreshold = ((2^32) * dot3OamEventLogThresholdHi)\n                                 + dot3OamEventLogThresholdLo\n\nOtherwise, this value is returned as all F's (2^32 -1) and\nadds no useful information.")
dot3OamEventLogThresholdLo = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogThresholdLo.setDescription("If the event represents a threshold crossing event, the two\nobjects dot3OamEventThresholdHi and dot3OamEventThresholdLo\nform an unsigned 64-bit integer yielding the value that was\ncrossed for the threshold crossing event (for example, 10,\nwhen 11 occurrences happened in 5 seconds while the threshold\nwas 10).  The two objects are combined as:\n\ndot3OamEventLogThreshold = ((2^32) * dot3OamEventLogThresholdHi)\n                                 + dot3OamEventLogThresholdLo\n\nOtherwise, this value is returned as all F's (2^32 - 1) and\nadds no useful information.")
dot3OamEventLogValue = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 10), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogValue.setDescription("If the event represents a threshold crossing event, this\nvalue indicates the value of the parameter within the given\nwindow that generated this event (for example, 11, when 11\noccurrences happened in 5 seconds while the threshold was 10).\n\nOtherwise, this value is returned as all F's\n(2^64 - 1) and adds no useful information.")
dot3OamEventLogRunningTotal = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 11), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogRunningTotal.setDescription("Each Event Notification TLV contains a running total of the\nnumber of times an event has occurred, as well as the number\nof times an Event Notification for the event has been\n\n\n\ntransmitted.  For non-threshold crossing events, the number of\nevents (dot3OamLogRunningTotal) and the number of resultant\nEvent Notifications (dot3OamLogEventTotal) should be\nidentical.\n\nFor threshold crossing events, since multiple occurrences may\nbe required to cross the threshold, these values are likely\ndifferent.  This value represents the total number of times\nthis event has happened since the last reset (for example,\n3253, when 3253 symbol errors have occurred since the last\nreset, which has resulted in 51 symbol error threshold\ncrossing events since the last reset).")
dot3OamEventLogEventTotal = MibTableColumn((1, 3, 6, 1, 2, 1, 158, 1, 6, 1, 12), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot3OamEventLogEventTotal.setDescription("Each Event Notification TLV contains a running total of the\nnumber of times an event has occurred, as well as the number\nof times an Event Notification for the event has been\ntransmitted.  For non-threshold crossing events, the number of\nevents (dot3OamLogRunningTotal) and the number of resultant\nEvent Notifications (dot3OamLogEventTotal) should be\nidentical.\n\nFor threshold crossing events, since multiple occurrences may\nbe required to cross the threshold, these values are likely\ndifferent.  This value represents the total number of times\none or more of these occurrences have resulted in an Event\nNotification (for example, 51 when 3253 symbol errors have\noccurred since the last reset, which has resulted in 51 symbol\nerror threshold crossing events since the last reset).")
dot3OamConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 158, 2))
dot3OamGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 158, 2, 1))
dot3OamCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 158, 2, 2))

# Augmentions

# Notifications

dot3OamThresholdEvent = NotificationType((1, 3, 6, 1, 2, 1, 158, 0, 1)).setObjects(("DOT3-OAM-MIB", "dot3OamEventLogValue"), ("DOT3-OAM-MIB", "dot3OamEventLogWindowLo"), ("DOT3-OAM-MIB", "dot3OamEventLogWindowHi"), ("DOT3-OAM-MIB", "dot3OamEventLogOui"), ("DOT3-OAM-MIB", "dot3OamEventLogRunningTotal"), ("DOT3-OAM-MIB", "dot3OamEventLogType"), ("DOT3-OAM-MIB", "dot3OamEventLogLocation"), ("DOT3-OAM-MIB", "dot3OamEventLogThresholdLo"), ("DOT3-OAM-MIB", "dot3OamEventLogThresholdHi"), ("DOT3-OAM-MIB", "dot3OamEventLogEventTotal"), ("DOT3-OAM-MIB", "dot3OamEventLogTimestamp"), )
if mibBuilder.loadTexts: dot3OamThresholdEvent.setDescription("A dot3OamThresholdEvent notification is sent when a local or\nremote threshold crossing event is detected.  A local\nthreshold crossing event is detected by the local entity,\nwhile a remote threshold crossing event is detected by the\nreception of an Ethernet OAM Event Notification OAMPDU\nthat indicates a threshold event.\n\nThis notification should not be sent more than once per\nsecond.\n\nThe OAM entity can be derived from extracting the ifIndex from\nthe variable bindings.  The objects in the notification\ncorrespond to the values in a row instance in the\ndot3OamEventLogTable.\n\nThe management entity should periodically check\ndot3OamEventLogTable to detect any missed events.")
dot3OamNonThresholdEvent = NotificationType((1, 3, 6, 1, 2, 1, 158, 0, 2)).setObjects(("DOT3-OAM-MIB", "dot3OamEventLogType"), ("DOT3-OAM-MIB", "dot3OamEventLogLocation"), ("DOT3-OAM-MIB", "dot3OamEventLogEventTotal"), ("DOT3-OAM-MIB", "dot3OamEventLogTimestamp"), ("DOT3-OAM-MIB", "dot3OamEventLogOui"), )
if mibBuilder.loadTexts: dot3OamNonThresholdEvent.setDescription("A dot3OamNonThresholdEvent notification is sent when a local\nor remote non-threshold crossing event is detected.  A local\nevent is detected by the local entity, while a remote event is\ndetected by the reception of an Ethernet OAM Event\nNotification OAMPDU that indicates a non-threshold crossing\nevent.\n\nThis notification should not be sent more than once per\n\n\n\nsecond.\n\nThe OAM entity can be derived from extracting the ifIndex from\nthe variable bindings.  The objects in the notification\ncorrespond to the values in a row instance of the\ndot3OamEventLogTable.\n\nThe management entity should periodically check\ndot3OamEventLogTable to detect any missed events.")

# Groups

dot3OamControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 1)).setObjects(("DOT3-OAM-MIB", "dot3OamAdminState"), ("DOT3-OAM-MIB", "dot3OamMode"), ("DOT3-OAM-MIB", "dot3OamConfigRevision"), ("DOT3-OAM-MIB", "dot3OamFunctionsSupported"), ("DOT3-OAM-MIB", "dot3OamOperStatus"), ("DOT3-OAM-MIB", "dot3OamMaxOamPduSize"), )
if mibBuilder.loadTexts: dot3OamControlGroup.setDescription("A collection of objects providing the abilities,\nconfiguration, and status of an Ethernet OAM entity.  ")
dot3OamPeerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 2)).setObjects(("DOT3-OAM-MIB", "dot3OamPeerMaxOamPduSize"), ("DOT3-OAM-MIB", "dot3OamPeerMacAddress"), ("DOT3-OAM-MIB", "dot3OamPeerVendorInfo"), ("DOT3-OAM-MIB", "dot3OamPeerFunctionsSupported"), ("DOT3-OAM-MIB", "dot3OamPeerMode"), ("DOT3-OAM-MIB", "dot3OamPeerConfigRevision"), ("DOT3-OAM-MIB", "dot3OamPeerVendorOui"), )
if mibBuilder.loadTexts: dot3OamPeerGroup.setDescription("A collection of objects providing the abilities,\nconfiguration, and status of a peer Ethernet OAM entity.  ")
dot3OamStatsBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 3)).setObjects(("DOT3-OAM-MIB", "dot3OamDuplicateEventNotificationTx"), ("DOT3-OAM-MIB", "dot3OamUniqueEventNotificationRx"), ("DOT3-OAM-MIB", "dot3OamDuplicateEventNotificationRx"), ("DOT3-OAM-MIB", "dot3OamOrgSpecificTx"), ("DOT3-OAM-MIB", "dot3OamVariableResponseRx"), ("DOT3-OAM-MIB", "dot3OamVariableRequestTx"), ("DOT3-OAM-MIB", "dot3OamVariableResponseTx"), ("DOT3-OAM-MIB", "dot3OamInformationRx"), ("DOT3-OAM-MIB", "dot3OamFramesLostDueToOam"), ("DOT3-OAM-MIB", "dot3OamOrgSpecificRx"), ("DOT3-OAM-MIB", "dot3OamUniqueEventNotificationTx"), ("DOT3-OAM-MIB", "dot3OamUnsupportedCodesTx"), ("DOT3-OAM-MIB", "dot3OamLoopbackControlTx"), ("DOT3-OAM-MIB", "dot3OamInformationTx"), ("DOT3-OAM-MIB", "dot3OamVariableRequestRx"), ("DOT3-OAM-MIB", "dot3OamUnsupportedCodesRx"), ("DOT3-OAM-MIB", "dot3OamLoopbackControlRx"), )
if mibBuilder.loadTexts: dot3OamStatsBaseGroup.setDescription("A collection of objects providing the statistics for the\nnumber of various transmit and receive events for OAM on an\nEthernet-like interface.  Note that all of these counters must\nbe supported even if the related function (as described in\ndot3OamFunctionsSupported) is not supported.  ")
dot3OamLoopbackGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 4)).setObjects(("DOT3-OAM-MIB", "dot3OamLoopbackStatus"), ("DOT3-OAM-MIB", "dot3OamLoopbackIgnoreRx"), )
if mibBuilder.loadTexts: dot3OamLoopbackGroup.setDescription("A collection of objects for controlling the OAM remote\n\n\n\nloopback function.  ")
dot3OamErrSymbolPeriodEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 5)).setObjects(("DOT3-OAM-MIB", "dot3OamErrSymPeriodThresholdLo"), ("DOT3-OAM-MIB", "dot3OamErrSymPeriodEvNotifEnable"), ("DOT3-OAM-MIB", "dot3OamErrSymPeriodWindowLo"), ("DOT3-OAM-MIB", "dot3OamErrSymPeriodThresholdHi"), ("DOT3-OAM-MIB", "dot3OamErrSymPeriodWindowHi"), )
if mibBuilder.loadTexts: dot3OamErrSymbolPeriodEventGroup.setDescription("A collection of objects for configuring the thresholds for an\nErrored Symbol Period Event.\n\nEach [802.3ah] defined Event Notification TLV has its own\nconformance group because each event can be implemented\nindependently of any other.  ")
dot3OamErrFramePeriodEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 6)).setObjects(("DOT3-OAM-MIB", "dot3OamErrFramePeriodWindow"), ("DOT3-OAM-MIB", "dot3OamErrFramePeriodEvNotifEnable"), ("DOT3-OAM-MIB", "dot3OamErrFramePeriodThreshold"), )
if mibBuilder.loadTexts: dot3OamErrFramePeriodEventGroup.setDescription("A collection of objects for configuring the thresholds for an\nErrored Frame Period Event.\n\nEach [802.3ah] defined Event Notification TLV has its own\nconformance group because each event can be implemented\nindependently of any other.  ")
dot3OamErrFrameEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 7)).setObjects(("DOT3-OAM-MIB", "dot3OamErrFrameThreshold"), ("DOT3-OAM-MIB", "dot3OamErrFrameEvNotifEnable"), ("DOT3-OAM-MIB", "dot3OamErrFrameWindow"), )
if mibBuilder.loadTexts: dot3OamErrFrameEventGroup.setDescription("A collection of objects for configuring the thresholds for an\nErrored Frame Event.\n\nEach [802.3ah] defined Event Notification TLV has its own\nconformance group because each event can be implemented\nindependently of any other.  ")
dot3OamErrFrameSecsSummaryEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 8)).setObjects(("DOT3-OAM-MIB", "dot3OamErrFrameSecsSummaryWindow"), ("DOT3-OAM-MIB", "dot3OamErrFrameSecsEvNotifEnable"), ("DOT3-OAM-MIB", "dot3OamErrFrameSecsSummaryThreshold"), )
if mibBuilder.loadTexts: dot3OamErrFrameSecsSummaryEventGroup.setDescription("A collection of objects for configuring the thresholds for an\nErrored Frame Seconds Summary Event.\n\nEach [802.3ah] defined Event Notification TLV has its own\nconformance group because each event can be implemented\nindependently of any other.  ")
dot3OamFlagEventGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 9)).setObjects(("DOT3-OAM-MIB", "dot3OamCriticalEventEnable"), ("DOT3-OAM-MIB", "dot3OamDyingGaspEnable"), )
if mibBuilder.loadTexts: dot3OamFlagEventGroup.setDescription("A collection of objects for configuring the sending OAMPDUs\nwith the critical event flag or dying gasp flag enabled.  ")
dot3OamEventLogGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 10)).setObjects(("DOT3-OAM-MIB", "dot3OamEventLogValue"), ("DOT3-OAM-MIB", "dot3OamEventLogWindowLo"), ("DOT3-OAM-MIB", "dot3OamEventLogWindowHi"), ("DOT3-OAM-MIB", "dot3OamEventLogOui"), ("DOT3-OAM-MIB", "dot3OamEventLogRunningTotal"), ("DOT3-OAM-MIB", "dot3OamEventLogType"), ("DOT3-OAM-MIB", "dot3OamEventLogLocation"), ("DOT3-OAM-MIB", "dot3OamEventLogThresholdLo"), ("DOT3-OAM-MIB", "dot3OamEventLogThresholdHi"), ("DOT3-OAM-MIB", "dot3OamEventLogEventTotal"), ("DOT3-OAM-MIB", "dot3OamEventLogTimestamp"), )
if mibBuilder.loadTexts: dot3OamEventLogGroup.setDescription("A collection of objects for configuring the thresholds for an\nErrored Frame Seconds Summary Event and maintaining the event\ninformation.  ")
dot3OamNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 158, 2, 1, 11)).setObjects(("DOT3-OAM-MIB", "dot3OamNonThresholdEvent"), ("DOT3-OAM-MIB", "dot3OamThresholdEvent"), )
if mibBuilder.loadTexts: dot3OamNotificationGroup.setDescription("A collection of notifications used by Ethernet OAM to signal\nto a management entity that local or remote events have\noccurred on a specified Ethernet link. ")

# Compliances

dot3OamCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 158, 2, 2, 1)).setObjects(("DOT3-OAM-MIB", "dot3OamErrFrameEventGroup"), ("DOT3-OAM-MIB", "dot3OamControlGroup"), ("DOT3-OAM-MIB", "dot3OamFlagEventGroup"), ("DOT3-OAM-MIB", "dot3OamPeerGroup"), ("DOT3-OAM-MIB", "dot3OamStatsBaseGroup"), ("DOT3-OAM-MIB", "dot3OamErrFramePeriodEventGroup"), ("DOT3-OAM-MIB", "dot3OamEventLogGroup"), ("DOT3-OAM-MIB", "dot3OamErrSymbolPeriodEventGroup"), ("DOT3-OAM-MIB", "dot3OamNotificationGroup"), ("DOT3-OAM-MIB", "dot3OamErrFrameSecsSummaryEventGroup"), ("DOT3-OAM-MIB", "dot3OamLoopbackGroup"), )
if mibBuilder.loadTexts: dot3OamCompliance.setDescription("The compliance statement for managed entities\nsupporting OAM on Ethernet-like interfaces.")

# Exports

# Module identity
mibBuilder.exportSymbols("DOT3-OAM-MIB", PYSNMP_MODULE_ID=dot3OamMIB)

# Types
mibBuilder.exportSymbols("DOT3-OAM-MIB", EightOTwoOui=EightOTwoOui)

# Objects
mibBuilder.exportSymbols("DOT3-OAM-MIB", dot3OamMIB=dot3OamMIB, dot3OamNotifications=dot3OamNotifications, dot3OamObjects=dot3OamObjects, dot3OamTable=dot3OamTable, dot3OamEntry=dot3OamEntry, dot3OamAdminState=dot3OamAdminState, dot3OamOperStatus=dot3OamOperStatus, dot3OamMode=dot3OamMode, dot3OamMaxOamPduSize=dot3OamMaxOamPduSize, dot3OamConfigRevision=dot3OamConfigRevision, dot3OamFunctionsSupported=dot3OamFunctionsSupported, dot3OamPeerTable=dot3OamPeerTable, dot3OamPeerEntry=dot3OamPeerEntry, dot3OamPeerMacAddress=dot3OamPeerMacAddress, dot3OamPeerVendorOui=dot3OamPeerVendorOui, dot3OamPeerVendorInfo=dot3OamPeerVendorInfo, dot3OamPeerMode=dot3OamPeerMode, dot3OamPeerMaxOamPduSize=dot3OamPeerMaxOamPduSize, dot3OamPeerConfigRevision=dot3OamPeerConfigRevision, dot3OamPeerFunctionsSupported=dot3OamPeerFunctionsSupported, dot3OamLoopbackTable=dot3OamLoopbackTable, dot3OamLoopbackEntry=dot3OamLoopbackEntry, dot3OamLoopbackStatus=dot3OamLoopbackStatus, dot3OamLoopbackIgnoreRx=dot3OamLoopbackIgnoreRx, dot3OamStatsTable=dot3OamStatsTable, dot3OamStatsEntry=dot3OamStatsEntry, dot3OamInformationTx=dot3OamInformationTx, dot3OamInformationRx=dot3OamInformationRx, dot3OamUniqueEventNotificationTx=dot3OamUniqueEventNotificationTx, dot3OamUniqueEventNotificationRx=dot3OamUniqueEventNotificationRx, dot3OamDuplicateEventNotificationTx=dot3OamDuplicateEventNotificationTx, dot3OamDuplicateEventNotificationRx=dot3OamDuplicateEventNotificationRx, dot3OamLoopbackControlTx=dot3OamLoopbackControlTx, dot3OamLoopbackControlRx=dot3OamLoopbackControlRx, dot3OamVariableRequestTx=dot3OamVariableRequestTx, dot3OamVariableRequestRx=dot3OamVariableRequestRx, dot3OamVariableResponseTx=dot3OamVariableResponseTx, dot3OamVariableResponseRx=dot3OamVariableResponseRx, dot3OamOrgSpecificTx=dot3OamOrgSpecificTx, dot3OamOrgSpecificRx=dot3OamOrgSpecificRx, dot3OamUnsupportedCodesTx=dot3OamUnsupportedCodesTx, dot3OamUnsupportedCodesRx=dot3OamUnsupportedCodesRx, dot3OamFramesLostDueToOam=dot3OamFramesLostDueToOam, dot3OamEventConfigTable=dot3OamEventConfigTable, dot3OamEventConfigEntry=dot3OamEventConfigEntry, dot3OamErrSymPeriodWindowHi=dot3OamErrSymPeriodWindowHi, dot3OamErrSymPeriodWindowLo=dot3OamErrSymPeriodWindowLo, dot3OamErrSymPeriodThresholdHi=dot3OamErrSymPeriodThresholdHi, dot3OamErrSymPeriodThresholdLo=dot3OamErrSymPeriodThresholdLo, dot3OamErrSymPeriodEvNotifEnable=dot3OamErrSymPeriodEvNotifEnable, dot3OamErrFramePeriodWindow=dot3OamErrFramePeriodWindow, dot3OamErrFramePeriodThreshold=dot3OamErrFramePeriodThreshold, dot3OamErrFramePeriodEvNotifEnable=dot3OamErrFramePeriodEvNotifEnable, dot3OamErrFrameWindow=dot3OamErrFrameWindow, dot3OamErrFrameThreshold=dot3OamErrFrameThreshold, dot3OamErrFrameEvNotifEnable=dot3OamErrFrameEvNotifEnable, dot3OamErrFrameSecsSummaryWindow=dot3OamErrFrameSecsSummaryWindow, dot3OamErrFrameSecsSummaryThreshold=dot3OamErrFrameSecsSummaryThreshold, dot3OamErrFrameSecsEvNotifEnable=dot3OamErrFrameSecsEvNotifEnable, dot3OamDyingGaspEnable=dot3OamDyingGaspEnable, dot3OamCriticalEventEnable=dot3OamCriticalEventEnable, dot3OamEventLogTable=dot3OamEventLogTable, dot3OamEventLogEntry=dot3OamEventLogEntry, dot3OamEventLogIndex=dot3OamEventLogIndex, dot3OamEventLogTimestamp=dot3OamEventLogTimestamp, dot3OamEventLogOui=dot3OamEventLogOui, dot3OamEventLogType=dot3OamEventLogType, dot3OamEventLogLocation=dot3OamEventLogLocation, dot3OamEventLogWindowHi=dot3OamEventLogWindowHi, dot3OamEventLogWindowLo=dot3OamEventLogWindowLo, dot3OamEventLogThresholdHi=dot3OamEventLogThresholdHi, dot3OamEventLogThresholdLo=dot3OamEventLogThresholdLo, dot3OamEventLogValue=dot3OamEventLogValue, dot3OamEventLogRunningTotal=dot3OamEventLogRunningTotal, dot3OamEventLogEventTotal=dot3OamEventLogEventTotal, dot3OamConformance=dot3OamConformance, dot3OamGroups=dot3OamGroups, dot3OamCompliances=dot3OamCompliances)

# Notifications
mibBuilder.exportSymbols("DOT3-OAM-MIB", dot3OamThresholdEvent=dot3OamThresholdEvent, dot3OamNonThresholdEvent=dot3OamNonThresholdEvent)

# Groups
mibBuilder.exportSymbols("DOT3-OAM-MIB", dot3OamControlGroup=dot3OamControlGroup, dot3OamPeerGroup=dot3OamPeerGroup, dot3OamStatsBaseGroup=dot3OamStatsBaseGroup, dot3OamLoopbackGroup=dot3OamLoopbackGroup, dot3OamErrSymbolPeriodEventGroup=dot3OamErrSymbolPeriodEventGroup, dot3OamErrFramePeriodEventGroup=dot3OamErrFramePeriodEventGroup, dot3OamErrFrameEventGroup=dot3OamErrFrameEventGroup, dot3OamErrFrameSecsSummaryEventGroup=dot3OamErrFrameSecsSummaryEventGroup, dot3OamFlagEventGroup=dot3OamFlagEventGroup, dot3OamEventLogGroup=dot3OamEventLogGroup, dot3OamNotificationGroup=dot3OamNotificationGroup)

# Compliances
mibBuilder.exportSymbols("DOT3-OAM-MIB", dot3OamCompliance=dot3OamCompliance)
