# PySNMP SMI module. Autogenerated from smidump -f python EFM-CU-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:24 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ifIndex, ifSpeed, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex", "ifSpeed")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( PhysAddress, RowStatus, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "PhysAddress", "RowStatus", "TextualConvention", "TruthValue")

# Types

class EfmProfileIndex(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(1,255)
    
class EfmProfileIndexList(TextualConvention, OctetString):
    displayHint = "1d:"
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,6)
    
class EfmProfileIndexOrZero(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+constraint.ValueRangeConstraint(0,255)
    
class EfmTruthValueOrUnknown(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(2,0,1,)
    namedValues = namedval.NamedValues(("unknown", 0), ("true", 1), ("false", 2), )
    

# Objects

efmCuMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 167)).setRevisions(("2007-11-14 00:00",))
if mibBuilder.loadTexts: efmCuMIB.setOrganization("IETF Ethernet Interfaces and Hub MIB Working Group")
if mibBuilder.loadTexts: efmCuMIB.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/OLD/hubmib-charter.html\n\n\n\nMailing Lists:\nGeneral Discussion: hubmib@ietf.org\nTo Subscribe: hubmib-request@ietf.org\nIn Body: subscribe your_email_address\n\nChair:  Bert Wijnen\nPostal: Alcatel-Lucent\n      Schagen 33\n      3461 GL Linschoten\n      Netherlands\nPhone: +31-348-407-775\nEMail: bwijnen@alcatel-lucent.com\n\nEditor: Edward Beili\nPostal: Actelis Networks Inc.\n      25 Bazel St., P.O.B. 10173\n      Petach-Tikva 10173\n      Israel\nPhone: +972-3-924-3491\nEmail: edward.beili@actelis.com")
if mibBuilder.loadTexts: efmCuMIB.setDescription("The objects in this MIB module are used to manage\nthe Ethernet in the First Mile (EFM) Copper (EFMCu) Interfaces\n2BASE-TL and 10PASS-TS, defined in IEEE Std. 802.3ah-2004,\nwhich is now a part of IEEE Std. 802.3-2005.\n\nThe following references are used throughout this MIB module:\n\n[802.3ah] refers to:\n  IEEE Std 802.3ah-2004: 'IEEE Standard for Information\n  technology - Telecommunications and information exchange\n  between systems - Local and metropolitan area networks -\n  Specific requirements -\n  Part 3: Carrier Sense Multiple Access with Collision\n  Detection (CSMA/CD) Access Method and Physical Layer\n  Specifications -\n  Amendment: Media Access Control Parameters, Physical\n  Layers and Management Parameters for Subscriber Access\n  Networks', 07 September 2004.\n\nOf particular interest are Clause 61, 'Physical Coding\nSublayer (PCS) and common specifications, type 10PASS-TS and\ntype 2BASE-TL', Clause 30, 'Management', Clause 45,\n'Management Data Input/Output (MDIO) Interface', Annex 62A,\n'PMD profiles for 10PASS-TS' and Annex 63A, 'PMD profiles for\n2BASE-TL'.\n\n\n\n\n[G.991.2] refers to:\n  ITU-T Recommendation G.991.2: 'Single-pair High-speed Digital\n  Subscriber Line (SHDSL) transceivers', December 2003.\n\n[ANFP] refers to:\n  NICC Document ND1602:2005/08: 'Specification of the Access\n  Network Frequency Plan (ANFP) applicable to transmission\n  systems used on the BT Access Network,' August 2005.\n\nThe following normative documents are quoted by the DESCRIPTION\nclauses in this MIB module:\n\n[G.993.1] refers to:\n  ITU-T Recommendation G.993.1: 'Very High speed Digital\n  Subscriber Line transceivers', June 2004.\n\n[T1.424] refers to:\n  ANSI T1.424-2004: 'Interface Between Networks and Customer\n  Installation Very-high-bit-rate Digital Subscriber Lines\n  (VDSL) Metallic Interface (DMT Based)', June 2004.\n\n[TS 101 270-1] refers to:\n  ETSI TS 101 270-1: 'Transmission and Multiplexing (TM);\n  Access transmission systems on metallic access cables;\n  Very high speed Digital Subscriber Line (VDSL); Part 1:\n  Functional requirements', October 2005.\n\nNaming Conventions:\n  Atn   - Attenuation\n  CO    - Central Office\n  CPE   - Customer Premises Equipment\n  EFM   - Ethernet in the First Mile\n  EFMCu - EFM Copper\n  MDIO  - Management Data Input/Output\n  Mgn   - Margin\n  PAF   - PME Aggregation Function\n  PBO   - Power Back-Off\n  PCS   - Physical Coding Sublayer\n  PMD   - Physical Medium Dependent\n  PME   - Physical Medium Entity\n  PSD   - Power Spectral Density\n  SNR   - Signal to Noise Ratio\n  TCPAM - Trellis Coded Pulse Amplitude Modulation\n\nCopyright (C) The IETF Trust (2007).  This version\nof this MIB module is part of RFC 5066;  see the RFC\nitself for full legal notices.")
efmCuObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1))
efmCuPort = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1, 1))
efmCuPortNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1, 1, 0))
efmCuPortConfTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 1, 1))
if mibBuilder.loadTexts: efmCuPortConfTable.setDescription("Table for Configuration of EFMCu 2BASE-TL/10PASS-TS (PCS)\nPorts.  Entries in this table MUST be maintained in a\npersistent manner.")
efmCuPortConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPortConfEntry.setDescription("An entry in the EFMCu Port Configuration table.\nEach entry represents an EFMCu port indexed by the ifIndex.\nNote that an EFMCu PCS port runs on top of a single\nor multiple PME port(s), which are also indexed by ifIndex.")
efmCuPAFAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPAFAdminState.setDescription("Administrative (desired) state of the PAF of the EFMCu port\n(PCS).\nWhen 'disabled', PME aggregation will not be performed by the\nPCS.  No more than a single PME can be assigned to this PCS in\nthis case.\nWhen 'enabled', PAF will be performed by the PCS when the link\nis Up, even on a single attached PME, if PAF is supported.\n\nPCS ports incapable of supporting PAF SHALL return a value of\n'disabled'.  Attempts to 'enable' such ports SHALL be\nrejected.\n\nA PAF 'enabled' port with multiple PMEs assigned cannot be\n'disabled'.  Attempts to 'disable' such port SHALL be\nrejected, until at most one PME is left assigned.\n\nChanging PAFAdminState is a traffic-disruptive operation and\nas such SHALL be done when the link is Down.  Attempts to\nchange this object SHALL be rejected if the link is Up or\nInitializing.\n\nThis object maps to the Clause 30 attribute aPAFAdminState.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then this\nobject maps to the PAF enable bit in the 10P/2B PCS control\nregister.\n\nThis object MUST be maintained in a persistent manner.")
efmCuPAFDiscoveryCode = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 2), PhysAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(6,6),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPAFDiscoveryCode.setDescription("PAF Discovery Code of the EFMCu port (PCS).\nA unique 6-octet code used by the Discovery function,\nwhen PAF is supported.\nPCS ports incapable of supporting PAF SHALL return a\nzero-length octet string on an attempt to read this object.\nAn attempt to write to this object SHALL be rejected for such\nports.\nThis object MUST be instantiated for the -O subtype PCS before\nwriting operations on the efmCuPAFRemoteDiscoveryCode\n(Set_if_Clear and Clear_if_Same) are performed by PMEs\nassociated with the PCS.\nThe initial value of this object for -R subtype ports after\nreset is all zeroes.  For -R subtype ports, the value of this\nobject cannot be changed directly.  This value may be changed\nas a result of writing operation on the\nefmCuPAFRemoteDiscoveryCode object of remote PME of -O\nsubtype, connected to one of the local PMEs associated with\nthe PCS.\n\nDiscovery MUST be performed when the link is Down.\nAttempts to change this object MUST be rejected (in case of\nSNMP with the error inconsistentValue), if the link is Up or\nInitializing.\n\nThe PAF Discovery Code maps to the local Discovery code\nvariable in PAF (note that it does not have a corresponding\nClause 45 register).")
efmCuAdminProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 3), EfmProfileIndexList().clone(hexValue='01')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuAdminProfile.setDescription("Desired configuration profile(s), common for all PMEs in the\nEFMCu port.  This object is a list of pointers to entries in\neither efmCuPme2BProfileTable or\nefmCuPme10PProfileTable, depending on the current\noperating SubType of the EFMCu port as indicated by\nefmCuPortSide.\n\n\n\nThe value of this object is a list of up to 6 indices of\nprofiles.  If this list consists of a single profile index,\nthen all PMEs assigned to this EFMCu port SHALL be configured\naccording to the profile referenced by that index, unless it\nis overwritten by a corresponding non-zero\nefmCuPmeAdminProfile instance, which takes precedence over\nefmCuAdminProfile.\nA list consisting of more than one index allows each PME\nin the port to be configured according to any profile\nspecified in the list.\nBy default, this object has a value of 0x01, referencing the\n1st entry in efmCuPme2BProfileTable or\nefmCuPme10PProfileTable.\n\nThis object is writable and readable for the -O subtype\n(2BaseTL-O or 10PassTS-O) EFMCu ports.  It is irrelevant for\nthe -R  subtype (2BaseTL-R or 10PassTS-R) ports -- a\nzero-length octet string SHALL be returned on an attempt to\nread this object and an attempt to change this object MUST be\nrejected in this case.\n\nNote that the current operational profile value is available\nvia the efmCuPmeOperProfile object.\n\nAny modification of this object MUST be performed when the\nlink is Down.  Attempts to change this object MUST be\nrejected, if the link is Up or Initializing.\nAttempts to set this object to a list with a member value that\nis not the value of the index for an active entry in the\ncorresponding profile table MUST be rejected.\n\nThis object maps to the Clause 30 attribute aProfileSelect.\n\nThis object MUST be maintained in a persistent manner.")
efmCuTargetDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(1,100000),constraint.ValueRangeConstraint(999999,999999),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuTargetDataRate.setDescription("Desired EFMCu port 'net' (as seen across MII) Data Rate in\nKbps, to be achieved during initialization, under spectral\nrestrictions placed on each PME via efmCuAdminProfile or\n\n\n\nefmCuPmeAdminProfile, with the desired SNR margin specified by\nefmCuTargetSnrMgn.\nIn case of PAF, this object represents a sum of individual PME\ndata rates, modified to compensate for fragmentation and\n64/65-octet encapsulation overhead (e.g., target data rate of\n10 Mbps SHALL allow lossless transmission of a full-duplex\n10 Mbps Ethernet frame stream with minimal inter-frame gap).\n\nThe value is limited above by 100 Mbps as this is the max\nburst rate across MII for EFMCu ports.\n\nThe value between 1 and 100000 indicates that the total data\nrate (ifSpeed) of the EFMCu port after initialization SHALL be\nequal to the target data rate or less, if the target data rate\ncannot be achieved under spectral restrictions specified by\nefmCuAdminProfile/efmCuPmeAdminProfile and with the desired\nSNR margin.  In case the copper environment allows a higher\ntotal data rate to be achieved than that specified by the\ntarget, the excess capability SHALL be either converted to\nadditional SNR margin or reclaimed by minimizing transmit\npower as controlled by efmCuAdaptiveSpectra.\n\nThe value of 999999 means that the target data rate is not\nfixed and SHALL be set to the maximum attainable rate during\ninitialization (Best Effort), under specified spectral\nrestrictions and with the desired SNR margin.\n\nThis object is read-write for the -O subtype EFMCu ports\n(2BaseTL-O/10PassTS-O) and not available for the -R subtypes.\n\nChanging of the Target Data Rate MUST be performed when the\nlink is Down.  Attempts to change this object MUST be rejected\n(in case of SNMP with the error inconsistentValue), if the\nlink is Up or Initializing.\n\nNote that the current Data Rate of the EFMCu port is\nrepresented by the ifSpeed object of IF-MIB.\n\nThis object MUST be maintained in a persistent manner.")
efmCuTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 21))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuTargetSnrMgn.setDescription("Desired EFMCu port SNR margin to be achieved on all PMEs\n\n\n\nassigned to the port, during initialization. (The SNR margin\nis the difference between the desired SNR and the actual SNR).\n\nNote that 802.3ah recommends using a default target SNR margin\nof 5 dB for 2BASE-TL ports and 6 dB for 10PASS-TS ports in\norder to achieve a mean Bit Error Rate (BER) of 10^-7 at the\nPMA service interface.\n\nThis object is read-write for the -O subtype EFMCu ports\n(2BaseTL-O/10PassTS-O) and not available for the -R subtypes.\n\nChanging of the target SNR margin MUST be performed when the\nlink is Down.  Attempts to change this object MUST be rejected\n(in case of SNMP with the error inconsistentValue), if the\nlink is Up or Initializing.\n\nNote that the current SNR margin of the PMEs comprising the\nEFMCu port is represented by efmCuPmeSnrMgn.\n\nThis object MUST be maintained in a persistent manner.")
efmCuAdaptiveSpectra = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuAdaptiveSpectra.setDescription("Indicates how to utilize excess capacity when the copper\nenvironment allows a higher total data rate to be achieved\nthan that specified by the efmCuTargetDataRate.\n\nA value of true(1) indicates that the excess capability SHALL\nbe reclaimed by minimizing transmit power, e.g., using higher\nconstellations and Power Back-Off, in order to reduce\ninterference to other copper pairs in the binder and the\nadverse impact to link/system performance.\n\nA value of false(2) indicates that the excess capability SHALL\nbe converted to additional SNR margin and spread evenly across\nall active PMEs assigned to the (PCS) port, to increase link\nrobustness.\n\nThis object is read-write for the -O subtype EFMCu ports\n(2BaseTL-O/10PassTS-O) and not available for the -R subtypes.\n\nChanging of this object MUST be performed when the link is\n\n\n\nDown.  Attempts to change this object MUST be rejected (in\ncase of SNMP with the error inconsistentValue), if the link\nis Up or Initializing.\n\nThis object MUST be maintained in a persistent manner.")
efmCuThreshLowRate = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 100000))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuThreshLowRate.setDescription("This object configures the EFMCu port low-rate crossing alarm\nthreshold.  When the current value of ifSpeed for this port\nreaches/drops below or exceeds this threshold, an\nefmCuLowRateCrossing notification MAY be generated if enabled\nby efmCuLowRateCrossingEnable.\n\nThis object is read-write for the -O subtype EFMCu ports\n(2BaseTL-O/10PassTS-O) and not available for the -R subtypes.\n\nThis object MUST be maintained in a persistent manner.")
efmCuLowRateCrossingEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 1, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuLowRateCrossingEnable.setDescription("Indicates whether efmCuLowRateCrossing notifications should\nbe generated for this interface.\n\nA value of true(1) indicates that efmCuLowRateCrossing\nnotification is enabled.  A value of false(2) indicates that\nthe notification is disabled.\n\nThis object is read-write for the -O subtype EFMCu ports\n(2BaseTL-O/10PassTS-O) and not available for the -R subtypes.\n\nThis object MUST be maintained in a persistent manner.")
efmCuPortCapabilityTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 1, 2))
if mibBuilder.loadTexts: efmCuPortCapabilityTable.setDescription("Table for Capabilities of EFMCu 2BASE-TL/10PASS-TS (PCS)\nPorts.  Entries in this table MUST be maintained in a\npersistent manner")
efmCuPortCapabilityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPortCapabilityEntry.setDescription("An entry in the EFMCu Port Capability table.\nEach entry represents an EFMCu port indexed by the ifIndex.\nNote that an EFMCu PCS port runs on top of a single\nor multiple PME port(s), which are also indexed by ifIndex.")
efmCuPAFSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 2, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFSupported.setDescription("PME Aggregation Function (PAF) capability of the EFMCu port\n(PCS).\nThis object has a value of true(1) when the PCS can perform\nPME aggregation on the available PMEs.\nPorts incapable of PAF SHALL return a value of false(2).\n\nThis object maps to the Clause 30 attribute aPAFSupported.\n\nIf a Clause 45 MDIO Interface to the PCS is present,\nthen this object maps to the PAF available bit in the\n10P/2B capability register.")
efmCuPeerPAFSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 2, 1, 2), EfmTruthValueOrUnknown()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPeerPAFSupported.setDescription("PME Aggregation Function (PAF) capability of the EFMCu port\n(PCS) link partner.\nThis object has a value of true(1) when the remote PCS can\nperform PME aggregation on its available PMEs.\nPorts whose peers are incapable of PAF SHALL return a value\nof false(2).\nPorts whose peers cannot be reached because of the link\nstate SHALL return a value of unknown(0).\n\nThis object maps to the Clause 30 attribute\naRemotePAFSupported.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the Remote PAF supported bit in the\n10P/2B capability register.")
efmCuPAFCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFCapacity.setDescription("Number of PMEs that can be aggregated by the local PAF.\nThe number of PMEs currently assigned to a particular\nEFMCu port (efmCuNumPMEs) is never greater than\nefmCuPAFCapacity.\n\nThis object maps to the Clause 30 attribute\naLocalPAFCapacity.")
efmCuPeerPAFCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 2, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPeerPAFCapacity.setDescription("Number of PMEs that can be aggregated by the PAF of the peer\nPHY (PCS port).\nA value of 0 is returned when peer PAF capacity is unknown\n(peer cannot be reached).\n\n\n\n\nThis object maps to the Clause 30 attribute\naRemotePAFCapacity.")
efmCuPortStatusTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 1, 3))
if mibBuilder.loadTexts: efmCuPortStatusTable.setDescription("This table provides overall status information of EFMCu\n2BASE-TL/10PASS-TS ports, complementing the generic status\ninformation from the ifTable of IF-MIB and ifMauTable of\nMAU-MIB.  Additional status information about connected PMEs\nis available from the efmCuPmeStatusTable.\n\nThis table contains live data from the equipment.  As such,\nit is NOT persistent.")
efmCuPortStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPortStatusEntry.setDescription("An entry in the EFMCu Port Status table.\nEach entry represents an EFMCu port indexed by the ifIndex.\nNote that an EFMCu PCS port runs on top of a single\nor multiple PME port(s), which are also indexed by ifIndex.")
efmCuFltStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("noPeer", 0), ("peerPowerLoss", 1), ("pmeSubTypeMismatch", 2), ("lowRate", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuFltStatus.setDescription("EFMCu (PCS) port Fault Status.  This is a bitmap of possible\nconditions.  The various bit positions are:\n  noPeer              - the peer PHY cannot be reached (e.g.,\n                        no PMEs attached, all PMEs are Down,\n                        etc.). More info is available in\n                        efmCuPmeFltStatus.\n  peerPowerLoss       - the peer PHY has indicated impending\n                        unit failure due to loss of local\n                        power ('Dying Gasp').\n  pmeSubTypeMismatch  - local PMEs in the aggregation group\n                        are not of the same subtype, e.g.,\n                        some PMEs in the local device are -O\n                        while others are -R subtype.\n  lowRate             - ifSpeed of the port reached or dropped\n                        below efmCuThreshLowRate.\n\nThis object is intended to supplement the ifOperStatus object\nin IF-MIB and ifMauMediaAvailable in MAU-MIB.\n\nAdditional information is available via the efmCuPmeFltStatus\nobject for each PME in the aggregation group (single PME if\nPAF is disabled).")
efmCuPortSide = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("subscriber", 1), ("office", 2), ("unknown", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPortSide.setDescription("EFM port mode of operation (subtype).\nThe value of 'subscriber' indicates that the port is\n\n\n\ndesignated as '-R' subtype (all PMEs assigned to this port are\nof subtype '-R').\nThe value of the 'office' indicates that the port is\ndesignated as '-O' subtype (all PMEs assigned to this port are\nof subtype '-O').\nThe value of 'unknown' indicates that the port has no assigned\nPMEs yet or that the assigned PMEs are not of the same side\n(subTypePMEMismatch).\n\nThis object partially maps to the Clause 30 attribute\naPhyEnd.")
efmCuNumPMEs = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuNumPMEs.setDescription("The number of PMEs that is currently aggregated by the local\nPAF (assigned to the EFMCu port using the ifStackTable).\nThis number is never greater than efmCuPAFCapacity.\n\nThis object SHALL be automatically incremented or decremented\nwhen a PME is added or deleted to/from the EFMCu port using\nthe ifStackTable.")
efmCuPAFInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInErrors.setDescription("The number of fragments that have been received across the\ngamma interface with RxErr asserted and discarded.\nThis read-only counter is inactive (not incremented) when the\nPAF is unsupported or disabled.  Upon disabling the PAF, the\ncounter retains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF RX error register.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\n\n\n\ndefined in IF-MIB.")
efmCuPAFInSmallFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInSmallFragments.setDescription("The number of fragments smaller than minFragmentSize\n(64 bytes) that have been received across the gamma interface\nand discarded.\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF small fragments register.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPAFInLargeFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInLargeFragments.setDescription("The number of fragments larger than maxFragmentSize\n(512 bytes) that have been received across the gamma interface\nand discarded.\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF large fragments register.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPAFInBadFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInBadFragments.setDescription("The number of fragments that do not fit into the sequence\nexpected by the frame assembly function and that have been\nreceived across the gamma interface and discarded (the\nframe buffer is flushed to the next valid frame start).\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF bad fragments register.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPAFInLostFragments = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInLostFragments.setDescription("The number of gaps in the sequence of fragments that have\nbeen received across the gamma interface (the frame buffer is\nflushed to the next valid frame start, when fragment/fragments\nexpected by the frame assembly function is/are not received).\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF lost fragment register.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPAFInLostStarts = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInLostStarts.setDescription("The number of missing StartOfPacket indicators expected by\nthe frame assembly function.\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF lost start of fragment\nregister.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPAFInLostEnds = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInLostEnds.setDescription("The number of missing EndOfPacket indicators expected by the\nframe assembly function.\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF lost start of fragment\nregister.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPAFInOverflows = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 1, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPAFInOverflows.setDescription("The number of fragments, received across the gamma interface\nand discarded, which would have caused the frame assembly\nbuffer to overflow.\nThis read-only counter is inactive when the PAF is\nunsupported or disabled.  Upon disabling the PAF, the counter\nretains its previous value.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then\nthis object maps to the 10P/2B PAF overflow register.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPme = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1, 2))
efmCuPmeNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1, 2, 0))
efmCuPmeConfTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 1))
if mibBuilder.loadTexts: efmCuPmeConfTable.setDescription("Table for Configuration of common aspects for EFMCu\n2BASE-TL/10PASS-TS PME ports (modems).  Configuration of\naspects specific to 2BASE-TL or 10PASS-TS PME types is\nrepresented in efmCuPme2BConfTable and efmCuPme10PConfTable,\nrespectively.\n\nEntries in this table MUST be maintained in a persistent\nmanner.")
efmCuPmeConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPmeConfEntry.setDescription("An entry in the EFMCu PME Configuration table.\nEach entry represents common aspects of an EFMCu PME port\nindexed by the ifIndex.  Note that an EFMCu PME port can be\nstacked below a single PCS port, also indexed by ifIndex,\npossibly together with other PME ports if PAF is enabled.")
efmCuPmeAdminSubType = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,2,4,1,6,3,7,)).subtype(namedValues=namedval.NamedValues(("ieee2BaseTLO", 1), ("ieee2BaseTLR", 2), ("ieee10PassTSO", 3), ("ieee10PassTSR", 4), ("ieee2BaseTLor10PassTSR", 5), ("ieee2BaseTLor10PassTSO", 6), ("ieee10PassTSor2BaseTLO", 7), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeAdminSubType.setDescription("Administrative (desired) subtype of the PME.\nPossible values are:\n  ieee2BaseTLO           - PME SHALL operate as 2BaseTL-O\n  ieee2BaseTLR           - PME SHALL operate as 2BaseTL-R\n  ieee10PassTSO          - PME SHALL operate as 10PassTS-O\n  ieee10PassTSR          - PME SHALL operate as 10PassTS-R\n  ieee2BaseTLor10PassTSR - PME SHALL operate as 2BaseTL-R or\n                           10PassTS-R.  The actual value will\n                           be set by the -O link partner\n                           during initialization (handshake).\n  ieee2BaseTLor10PassTSO - PME SHALL operate as 2BaseTL-O\n                           (preferred) or 10PassTS-O.  The\n                           actual value will be set during\n                           initialization depending on the -R\n                           link partner capability (i.e., if\n                           -R is incapable of the preferred\n                           2BaseTL mode, 10PassTS will be\n                           used).\n  ieee10PassTSor2BaseTLO - PME SHALL operate as 10PassTS-O\n\n\n\n                           (preferred) or 2BaseTL-O.  The\n                           actual value will be set during\n                           initialization depending on the -R\n                           link partner capability (i.e., if\n                           -R is incapable of the preferred\n                           10PassTS mode, 2BaseTL will be\n                           used).\n\nChanging efmCuPmeAdminSubType is a traffic-disruptive\noperation and as such SHALL be done when the link is Down.\nAttempts to change this object SHALL be rejected if the link\nis Up or Initializing.\nAttempts to change this object to an unsupported subtype\n(see efmCuPmeSubTypesSupported) SHALL be rejected.\n\nThe current operational subtype is indicated by the\nefmCuPmeOperSubType variable.\n\nIf a Clause 45 MDIO Interface to the PMA/PMD is present, then\nthis object combines values of the Port subtype select bits\nand the PMA/PMD type selection bits in the 10P/2B PMA/PMD\ncontrol register.")
efmCuPmeAdminProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 2), EfmProfileIndexOrZero().clone('0')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeAdminProfile.setDescription("Desired PME configuration profile.  This object is a pointer\nto an entry in either the efmCuPme2BProfileTable or the\nefmCuPme10PProfileTable, depending on the current operating\nSubType of the PME.  The value of this object is the index of\nthe referenced profile.\nThe value of zero (default) indicates that the PME is\nconfigured via the efmCuAdminProfile object for the PCS port\nto which this PME is assigned.  That is, the profile\nreferenced by efmCuPmeAdminProfile takes precedence\nover the profile(s) referenced by efmCuAdminProfile.\n\nThis object is writable and readable for the CO subtype PMEs\n(2BaseTL-O or 10PassTS-O). It is irrelevant for the CPE\nsubtype (2BaseTL-R or 10PassTS-R) -- a zero value SHALL be\nreturned on an attempt to read this object and any attempt\nto change this object MUST be rejected in this case.\n\n\n\n\nNote that the current operational profile value is available\nvia efmCuPmeOperProfile object.\n\nAny modification of this object MUST be performed when the\nlink is Down.  Attempts to change this object MUST be\nrejected, if the link is Up or Initializing.\n\nAttempts to set this object to a value that is not the value\nof the index for an active entry in the corresponding profile\ntable MUST be rejected.\n\nThis object maps to the Clause 30 attribute aProfileSelect.\n\nThis object MUST be maintained in a persistent manner.")
efmCuPAFRemoteDiscoveryCode = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 3), PhysAddress().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(0,0),constraint.ValueSizeConstraint(6,6),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPAFRemoteDiscoveryCode.setDescription("PAF Remote Discovery Code of the PME port at the CO.\nThe 6-octet Discovery Code of the peer PCS connected via\nthe PME.\nReading this object results in a Discovery Get operation.\nSetting this object to all zeroes results in a Discovery\nClear_if_Same operation (the value of efmCuPAFDiscoveryCode\nat the peer PCS SHALL be the same as efmCuPAFDiscoveryCode of\nthe local PCS associated with the PME for the operation to\nsucceed).\nWriting a non-zero value to this object results in a\nDiscovery Set_if_Clear operation.\nA zero-length octet string SHALL be returned on an attempt to\nread this object when PAF aggregation is not enabled.\n\nThis object is irrelevant in CPE port (-R) subtypes: in this\ncase, a zero-length octet string SHALL be returned on an\nattempt to read this object; writing to this object SHALL\nbe rejected.\n\nDiscovery MUST be performed when the link is Down.\nAttempts to change this object MUST be rejected (in case of\nSNMP with the error inconsistentValue), if the link is Up or\nInitializing.\n\n\n\n\nIf a Clause 45 MDIO Interface to the PMA/PMD is present, then\nthis object is a function of 10P/2B aggregation discovery\ncontrol register, Discovery operation result bits in 10P/2B\naggregation and discovery status register and\n10P/2B aggregation discovery code register.")
efmCuPmeThreshLineAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeThreshLineAtn.setDescription("Desired Line Attenuation threshold for the 2B/10P PME.\nThis object configures the line attenuation alarm threshold.\nWhen the current value of Line Attenuation reaches or\nexceeds this threshold, an efmCuPmeLineAtnCrossing\nnotification MAY be generated, if enabled by\nefmCuPmeLineAtnCrossingEnable.\n\nThis object is writable for the CO subtype PMEs (-O).\nIt is read-only for the CPE subtype (-R).\n\nChanging of the Line Attenuation threshold MUST be performed\nwhen the link is Down.  Attempts to change this object MUST be\nrejected (in case of SNMP with the error inconsistentValue),\nif the link is Up or Initializing.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject maps to the loop attenuation threshold bits in\nthe 2B PMD line quality thresholds register.")
efmCuPmeThreshSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-127, 128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeThreshSnrMgn.setDescription("Desired SNR margin threshold for the 2B/10P PME.\nThis object configures the SNR margin alarm threshold.\nWhen the current value of SNR margin reaches or exceeds this\nthreshold, an efmCuPmeSnrMgnCrossing notification MAY be\ngenerated, if enabled by efmCuPmeSnrMgnCrossingEnable.\n\n\n\nThis object is writable for the CO subtype PMEs\n(2BaseTL-O/10PassTS-O).  It is read-only for the CPE subtype\n(2BaseTL-R/10PassTS-R).\n\nChanging of the SNR margin threshold MUST be performed when\nthe link is Down.  Attempts to change this object MUST be\nrejected (in case of SNMP with the error inconsistentValue),\nif the link is Up or Initializing.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject maps to the SNR margin threshold bits in the 2B PMD\nline quality thresholds register.")
efmCuPmeLineAtnCrossingEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 6), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeLineAtnCrossingEnable.setDescription("Indicates whether efmCuPmeLineAtnCrossing notifications\nshould be generated for this interface.\n\nA value of true(1) indicates that efmCuPmeLineAtnCrossing\nnotification is enabled.  A value of false(2) indicates that\nthe notification is disabled.")
efmCuPmeSnrMgnCrossingEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 7), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeSnrMgnCrossingEnable.setDescription("Indicates whether efmCuPmeSnrMgnCrossing notifications\nshould be generated for this interface.\n\nA value of true(1) indicates that efmCuPmeSnrMgnCrossing\nnotification is enabled.  A value of false(2) indicates that\nthe notification is disabled.")
efmCuPmeDeviceFaultEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeDeviceFaultEnable.setDescription("Indicates whether efmCuPmeDeviceFault notifications\n\n\n\nshould be generated for this interface.\n\nA value of true(1) indicates that efmCuPmeDeviceFault\nnotification is enabled.  A value of false(2) indicates that\nthe notification is disabled.")
efmCuPmeConfigInitFailEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 9), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeConfigInitFailEnable.setDescription("Indicates whether efmCuPmeConfigInitFailure notifications\nshould be generated for this interface.\n\nA value of true(1) indicates that efmCuPmeConfigInitFailure\nnotification is enabled.  A value of false(2) indicates that\nthe notification is disabled.")
efmCuPmeProtocolInitFailEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 1, 1, 10), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: efmCuPmeProtocolInitFailEnable.setDescription("Indicates whether efmCuPmeProtocolInitFailure notifications\nshould be generated for this interface.\n\nA value of true(1) indicates that efmCuPmeProtocolInitFailure\nnotification is enabled.  A value of false(2) indicates that\nthe notification is disabled.")
efmCuPmeCapabilityTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 2))
if mibBuilder.loadTexts: efmCuPmeCapabilityTable.setDescription("Table for the configuration of common aspects for EFMCu\n2BASE-TL/10PASS-TS PME ports (modems).  The configuration of\naspects specific to 2BASE-TL or 10PASS-TS PME types is\nrepresented in the efmCuPme2BConfTable and the\nefmCuPme10PConfTable, respectively.\n\nEntries in this table MUST be maintained in a persistent\nmanner.")
efmCuPmeCapabilityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPmeCapabilityEntry.setDescription("An entry in the EFMCu PME Capability table.\nEach entry represents common aspects of an EFMCu PME port\nindexed by the ifIndex.  Note that an EFMCu PME port can be\nstacked below a single PCS port, also indexed by ifIndex,\npossibly together with other PME ports if PAF is enabled.")
efmCuPmeSubTypesSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 2, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("ieee2BaseTLO", 0), ("ieee2BaseTLR", 1), ("ieee10PassTSO", 2), ("ieee10PassTSR", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeSubTypesSupported.setDescription("PME supported subtypes.  This is a bitmap of possible\nsubtypes.  The various bit positions are:\n  ieee2BaseTLO    - PME is capable of operating as 2BaseTL-O\n  ieee2BaseTLR    - PME is capable of operating as 2BaseTL-R\n  ieee10PassTSO   - PME is capable of operating as 10PassTS-O\n  ieee10PassTSR   - PME is capable of operating as 10PassTS-R\n\nThe desired mode of operation is determined by\nefmCuPmeAdminSubType, while efmCuPmeOperSubType reflects the\ncurrent operating mode.\n\nIf a Clause 45 MDIO Interface to the PCS is present, then this\nobject combines the 10PASS-TS capable and 2BASE-TL capable\nbits in the 10P/2B PMA/PMD speed ability register and the\nCO supported and CPE supported bits in the 10P/2B PMA/PMD\nstatus register.")
efmCuPmeStatusTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 3))
if mibBuilder.loadTexts: efmCuPmeStatusTable.setDescription("This table provides common status information of EFMCu\n2BASE-TL/10PASS-TS PME ports.  Status information specific\nto 10PASS-TS PME is represented in efmCuPme10PStatusTable.\n\nThis table contains live data from the equipment.  As such,\nit is NOT persistent.")
efmCuPmeStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPmeStatusEntry.setDescription("An entry in the EFMCu PME Status table.\nEach entry represents common aspects of an EFMCu PME port\nindexed by the ifIndex.  Note that an EFMCu PME port can be\nstacked below a single PCS port, also indexed by ifIndex,\npossibly together with other PME ports if PAF is enabled.")
efmCuPmeOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,4,1,)).subtype(namedValues=namedval.NamedValues(("up", 1), ("downNotReady", 2), ("downReady", 3), ("init", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeOperStatus.setDescription("Current PME link Operational Status.  Possible values are:\nup(1)           - The link is Up and ready to pass\n                  64/65-octet encoded frames or fragments.\ndownNotReady(2) - The link is Down and the PME does not\n                  detect Handshake tones from its peer.\n                  This value may indicate a possible\n                  problem with the peer PME.\ndownReady(3)    - The link is Down and the PME detects\n                  Handshake tones from its peer.\ninit(4)         - The link is Initializing, as a result of\n                  ifAdminStatus being set to 'up' for a\n                  particular PME or a PCS to which the PME\n                  is connected.\n\nThis object is intended to supplement the Down(2) state of\nifOperStatus.\n\nThis object partially maps to the Clause 30 attribute\naPMEStatus.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject partially maps to PMA/PMD link status bits in 10P/2B\nPMA/PMD status register.")
efmCuPmeFltStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 2), Bits().subtype(namedValues=namedval.NamedValues(("lossOfFraming", 0), ("snrMgnDefect", 1), ("lineAtnDefect", 2), ("deviceFault", 3), ("configInitFailure", 4), ("protocolInitFailure", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeFltStatus.setDescription("Current/Last PME link Fault Status.  This is a bitmap of\npossible conditions.  The various bit positions are:\n\n  lossOfFraming       - Loss of Framing for 10P or\n                        Loss of Sync word for 2B PMD or\n                        Loss of 64/65-octet framing.\n\n\n\n  snrMgnDefect        - SNR margin dropped below the\n                        threshold.\n  lineAtnDefect       - Line Attenuation exceeds the\n                        threshold.\n  deviceFault         - Indicates a vendor-dependent\n                        diagnostic or self-test fault\n                        has been detected.\n  configInitFailure   - Configuration initialization failure,\n                        due to inability of the PME link to\n                        support the configuration profile,\n                        requested during initialization.\n  protocolInitFailure - Protocol initialization failure, due\n                        to an incompatible protocol used by\n                        the peer PME during init (that could\n                        happen if a peer PMD is a regular\n                        G.SDHSL/VDSL modem instead of a\n                        2BASE-TL/10PASS-TS PME).\n\nThis object is intended to supplement ifOperStatus in IF-MIB.\n\nThis object holds information about the last fault.\nefmCuPmeFltStatus is cleared by the device restart.\nIn addition, lossOfFraming, configInitFailure, and\nprotocolInitFailure are cleared by PME init;\ndeviceFault is cleared by successful diagnostics/test;\nsnrMgnDefect and lineAtnDefect are cleared by SNR margin\nand Line attenuation, respectively, returning to norm and by\nPME init.\n\nThis object partially maps to the Clause 30 attribute\naPMEStatus.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject consolidates information from various PMA/PMD\nregisters, namely: Fault bit in PMA/PMD status 1 register,\n10P/2B PMA/PMD link loss register,\n10P outgoing indicator bits status register,\n10P incoming indicator bits status register,\n2B state defects register.")
efmCuPmeOperSubType = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,4,)).subtype(namedValues=namedval.NamedValues(("ieee2BaseTLO", 1), ("ieee2BaseTLR", 2), ("ieee10PassTSO", 3), ("ieee10PassTSR", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeOperSubType.setDescription("Current operational subtype of the PME.\nPossible values are:\n  ieee2BaseTLO           - PME operates as 2BaseTL-O\n  ieee2BaseTLR           - PME operates as 2BaseTL-R\n  ieee10PassTSO          - PME operates as 10PassTS-O\n  ieee10PassTSR          - PME operates as 10PassTS-R\n\nThe desired operational subtype of the PME can be configured\nvia the efmCuPmeAdminSubType variable.\n\nIf a Clause 45 MDIO Interface to the PMA/PMD is present, then\nthis object combines values of the Port subtype select\nbits, the PMA/PMD type selection bits in the 10P/2B\nPMA/PMD control register, and the PMA/PMD link status bits in\nthe 10P/2B PMA/PMD status register.")
efmCuPmeOperProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 4), EfmProfileIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeOperProfile.setDescription("PME current operating profile.  This object is a pointer to\nan entry in either the efmCuPme2BProfileTable or the\nefmCuPme10PProfileTable, depending on the current operating\nSubType of the PME as indicated by efmCuPmeOperSubType.\nNote that a profile entry to which efmCuPmeOperProfile is\npointing can be created automatically to reflect achieved\nparameters in adaptive (not fixed) initialization,\ni.e., values of efmCuPmeOperProfile and efmCuAdminProfile or\nefmCuPmeAdminProfile may differ.\nThe value of zero indicates that the PME is Down or\nInitializing.\n\nThis object partially maps to the aOperatingProfile attribute\nin Clause 30.")
efmCuPmeSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-127,128),constraint.ValueRangeConstraint(65535,65535),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeSnrMgn.setDescription("The current Signal to Noise Ratio (SNR) margin with respect\nto the received signal as perceived by the local PME.\nThe value of 65535 is returned when the PME is Down or\nInitializing.\n\nThis object maps to the aPMESNRMgn attribute in Clause 30.\n\nIf a Clause 45 MDIO Interface is present, then this\nobject maps to the 10P/2B RX SNR margin register.")
efmCuPmePeerSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-127,128),constraint.ValueRangeConstraint(65535,65535),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmePeerSnrMgn.setDescription("The current SNR margin in dB with respect to the received\nsignal, as perceived by the remote (link partner) PME.\nThe value of 65535 is returned when the PME is Down or\nInitializing.\n\nThis object is irrelevant for the -R PME subtypes.  The value\nof 65535 SHALL be returned in this case.\n\nIf a Clause 45 MDIO Interface is present, then this\nobject maps to the 10P/2B link partner RX SNR margin\nregister.")
efmCuPmeLineAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 7), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-127,128),constraint.ValueRangeConstraint(65535,65535),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeLineAtn.setDescription("The current Line Attenuation in dB as perceived by the local\nPME.\n\n\n\nThe value of 65535 is returned when the PME is Down or\nInitializing.\n\nIf a Clause 45 MDIO Interface is present, then this\nobject maps to the Line Attenuation register.")
efmCuPmePeerLineAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 8), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(-127,128),constraint.ValueRangeConstraint(65535,65535),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmePeerLineAtn.setDescription("The current Line Attenuation in dB as perceived by the remote\n(link partner) PME.\nThe value of 65535 is returned when the PME is Down or\nInitializing.\n\nThis object is irrelevant for the -R PME subtypes.  The value\nof 65535 SHALL be returned in this case.\n\nIf a Clause 45 MDIO Interface is present, then this\nobject maps to the 20P/2B link partner Line Attenuation\nregister.")
efmCuPmeEquivalentLength = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,8192),constraint.ValueRangeConstraint(65535,65535),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeEquivalentLength.setDescription("An estimate of the equivalent loop's physical length in\nmeters, as perceived by the PME after the link is established.\nAn equivalent loop is a hypothetical 26AWG (0.4mm) loop with a\nperfect square root attenuation characteristic, without any\nbridged taps.\nThe value of 65535 is returned if the link is Down or\nInitializing or the PME is unable to estimate the equivalent\nlength.\n\nFor a 10BASE-TL PME, if a Clause 45 MDIO Interface to the PME\nis present, then this object maps to the 10P Electrical Length\nregister.")
efmCuPmeTCCodingErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeTCCodingErrors.setDescription("The number of 64/65-octet encapsulation errors.  This counter\nis incremented for each 64/65-octet encapsulation error\ndetected by the 64/65-octet receive function.\n\nThis object maps to aTCCodingViolations attribute in\nClause 30.\n\nIf a Clause 45 MDIO Interface to the PME TC is present, then\nthis object maps to the TC coding violations register\n(see 45.2.6.12).\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPmeTCCrcErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPmeTCCrcErrors.setDescription("The number of TC-CRC errors.  This counter is incremented for\neach TC-CRC error detected by the 64/65-octet receive function\n(see 61.3.3.3 and Figure 61-19).\n\nThis object maps to aTCCRCErrors attribute in\nClause 30.\n\nIf a Clause 45 MDIO Interface to the PME TC is present, then\nthis object maps to the TC CRC error register\n(see 45.2.6.11).\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPme2B = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1, 2, 5))
efmCuPme2BProfileTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2))
if mibBuilder.loadTexts: efmCuPme2BProfileTable.setDescription("This table supports definitions of administrative and\noperating profiles for 2BASE-TL PMEs.\nThe first 14 entries in this table SHALL always be defined as\nfollows (see 802.3ah Annex 63A):\n-------+-------+-------+-----+------+-------------+-----------\nProfile MinRate MaxRate Power Region Constellation Comment\n index  (Kbps)  (Kbps)  (dBm)\n-------+-------+-------+-----+------+-------------+-----------\n   1     5696    5696    13.5    1   32-TCPAM      default\n   2     3072    3072    13.5    1   32-TCPAM\n   3     2048    2048    13.5    1   16-TCPAM\n   4     1024    1024    13.5    1   16-TCPAM\n   5      704     704    13.5    1   16-TCPAM\n   6      512     512    13.5    1   16-TCPAM\n   7     5696    5696    14.5    2   32-TCPAM\n   8     3072    3072    14.5    2   32-TCPAM\n   9     2048    2048    14.5    2   16-TCPAM\n  10     1024    1024    13.5    2   16-TCPAM\n  11      704     704    13.5    2   16-TCPAM\n  12      512     512    13.5    2   16-TCPAM\n  13      192    5696       0    1   0             best effort\n  14      192    5696       0    2   0             best effort\n-------+-------+-------+-----+------+-------------+-----------\n\nThese default entries SHALL be created during agent\ninitialization and MUST NOT be deleted.\n\nEntries following the first 14 can be dynamically created and\ndeleted to provide custom administrative (configuration)\nprofiles and automatic operating profiles.\n\nThis table MUST be maintained in a persistent manner.")
efmCuPme2BProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1)).setIndexNames((0, "EFM-CU-MIB", "efmCuPme2BProfileIndex"))
if mibBuilder.loadTexts: efmCuPme2BProfileEntry.setDescription("Each entry corresponds to a single 2BASE-TL PME profile.\nEach profile contains a set of parameters, used either for\nconfiguration or representation of a 2BASE-TL PME.\nIn case a particular profile is referenced via the\nefmCuPmeAdminProfile object (or efmCuAdminProfile if\nefmCuPmeAdminProfile is zero), it represents the desired\nparameters for the 2BaseTL-O PME initialization.\nIf a profile is referenced via an efmCuPmeOperProfile object,\nit represents the current operating parameters of an\noperational PME.\n\nProfiles may be created/deleted using the row creation/\ndeletion mechanism via efmCuPme2BProfileRowStatus.  If an\nactive entry is referenced, the entry MUST remain 'active'\nuntil all references are removed.\nDefault entries MUST NOT be removed.")
efmCuPme2BProfileIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 1), EfmProfileIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: efmCuPme2BProfileIndex.setDescription("2BASE-TL PME profile index.\nThis object is the unique index associated with this profile.\nEntries in this table are referenced via efmCuAdminProfile or\nefmCuPmeAdminProfile objects.")
efmCuPme2BProfileDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BProfileDescr.setDescription("A textual string containing information about a 2BASE-TL PME\nprofile.  The string may include information about the data\nrate and spectral limitations of this particular profile.")
efmCuPme2BRegion = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("region1", 1), ("region2", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BRegion.setDescription("Regional settings for a 2BASE-TL PME, as specified in the\nrelevant Regional Annex of [G.991.2].\nRegional settings specify the Power Spectral Density (PSD)\nmask and the Power Back-Off (PBO) values, and place\nlimitations on the max allowed data rate, power, and\nconstellation.\n\nPossible values for this object are:\n  region1      - Annexes A and F (e.g., North America)\n  region2      - Annexes B and G (e.g., Europe)\n\nAnnex A/B specify regional settings for data rates 192-2304\nKbps using 16-TCPAM encoding.\nAnnex F/G specify regional settings for rates 2320-3840 Kbps\nusing 16-TCPAM encoding and 768-5696 Kbps using 32-TCPAM\nencoding.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject partially maps to the Region bits in the 2B general\nparameter register.")
efmCuPme2BsMode = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 4), EfmProfileIndexOrZero().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BsMode.setDescription("Desired custom Spectral Mode for a 2BASE-TL PME.  This object\n\n\n\nis a pointer to an entry in efmCuPme2BsModeTable and a block\nof entries in efmCuPme2BRateReachTable, which together define\n(country-specific) reach-dependent rate limitations in\naddition to those defined by efmCuPme2BRegion.\n\nThe value of this object is the index of the referenced\nspectral mode.\nThe value of zero (default) indicates that no specific\nspectral mode is applicable.\n\nAttempts to set this object to a value that is not the value\nof the index for an active entry in the corresponding spectral\nmode table MUST be rejected.")
efmCuPme2BMinDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 5), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(192, 5696))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BMinDataRate.setDescription("Minimum Data Rate for the 2BASE-TL PME.\nThis object can take values of (n x 64)Kbps,\nwhere n=3..60 for 16-TCPAM and n=12..89 for 32-TCPAM encoding.\n\nThe data rate of the 2BASE-TL PME is considered 'fixed' when\nthe value of this object equals that of efmCuPme2BMaxDataRate.\nIf efmCuPme2BMinDataRate is less than efmCuPme2BMaxDataRate in\nthe administrative profile, the data rate is considered\n'adaptive', and SHALL be set to the maximum attainable rate\nnot exceeding efmCuPme2BMaxDataRate, under the spectral\nlimitations placed by the efmCuPme2BRegion and\nefmCuPme2BsMode.\n\nNote that the current operational data rate of the PME is\nrepresented by the ifSpeed object of IF-MIB.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject maps to the Min Data Rate1 bits in the 2B PMD\nparameters register.\n\nThis object MUST be maintained in a persistent manner.")
efmCuPme2BMaxDataRate = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 6), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(192, 5696))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BMaxDataRate.setDescription("Maximum Data Rate for the 2BASE-TL PME.\nThis object can take values of (n x 64)Kbps,\nwhere n=3..60 for 16-TCPAM and n=12..89 for 32-TCPAM encoding.\n\nThe data rate of the 2BASE-TL PME is considered 'fixed' when\nthe value of this object equals that of efmCuPme2BMinDataRate.\nIf efmCuPme2BMinDataRate is less than efmCuPme2BMaxDataRate in\nthe administrative profile, the data rate is considered\n'adaptive', and SHALL be set to the maximum attainable rate\nnot exceeding efmCuPme2BMaxDataRate, under the spectral\nlimitations placed by the efmCuPme2BRegion and\nefmCuPme2BsMode.\n\nNote that the current operational data rate of the PME is\nrepresented by the ifSpeed object of IF-MIB.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject maps to the Max Data Rate1 bits in the 2B PMD\nparameters register.\n\nThis object MUST be maintained in a persistent manner.")
efmCuPme2BPower = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(10,42),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BPower.setDescription("Signal Transmit Power.  Multiple of 0.5 dBm.\nThe value of 0 in the administrative profile means that the\nsignal transmit power is not fixed and SHALL be set to\nmaximize the attainable rate, under the spectral limitations\nplaced by the efmCuPme2BRegion and efmCuPme2BsMode.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject maps to the Power1 bits in the 2B PMD parameters\nregister.")
efmCuPme2BConstellation = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(0,2,1,)).subtype(namedValues=namedval.NamedValues(("adaptive", 0), ("tcpam16", 1), ("tcpam32", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BConstellation.setDescription("TCPAM Constellation of the 2BASE-TL PME.\nThe possible values are:\n  adaptive(0)    - either 16- or 32-TCPAM\n  tcpam16(1)     - 16-TCPAM\n  tcpam32(2)     - 32-TCPAM\n\nThe value of adaptive(0) in the administrative profile means\nthat the constellation is not fixed and SHALL be set to\nmaximize the attainable rate, under the spectral limitations\nplaced by the efmCuPme2BRegion and efmCuPme2BsMode.\n\nIf a Clause 45 MDIO Interface to the PME is present, then this\nobject maps to the Constellation1 bits in the 2B general\nparameter register.")
efmCuPme2BProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 2, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BProfileRowStatus.setDescription("This object controls the creation, modification, or deletion\nof the associated entry in the efmCuPme2BProfileTable per the\nsemantics of RowStatus.\n\nIf an 'active' entry is referenced via efmCuAdminProfile or\nefmCuPmeAdminProfile instance(s), the entry MUST remain\n'active'.\n\nAn 'active' entry SHALL NOT be modified.  In order to modify\nan existing entry, it MUST be taken out of service (by setting\nthis object to 'notInService'), modified, and set 'active'\nagain.")
efmCuPme2BsModeTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 3))
if mibBuilder.loadTexts: efmCuPme2BsModeTable.setDescription("This table, together with efmCu2BReachRateTable, supports\ndefinition of administrative custom spectral modes for\n2BASE-TL PMEs, describing spectral limitations in addition to\nthose specified by efmCuPme2BRegion.\n\nIn some countries, spectral regulations (e.g., UK ANFP) limit\nthe length of the loops for certain data rates.  This table\nallows these country-specific limitations to be specified.\n\nEntries in this table referenced by the efmCuPme2BsMode\nMUST NOT be deleted until all the active references are\nremoved.\n\nThis table MUST be maintained in a persistent manner.")
efmCuPme2BsModeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 3, 1)).setIndexNames((0, "EFM-CU-MIB", "efmCuPme2BsModeIndex"))
if mibBuilder.loadTexts: efmCuPme2BsModeEntry.setDescription("Each entry specifies a spectral mode description and its\nindex, which is used to reference corresponding entries in the\nefmCu2BReachRateTable.\n\nEntries may be created/deleted using the row creation/\ndeletion mechanism via efmCuPme2BsModeRowStatus.")
efmCuPme2BsModeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 3, 1, 1), EfmProfileIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: efmCuPme2BsModeIndex.setDescription("2BASE-TL PME Spectral Mode index.\nThis object is the unique index associated with this spectral\nmode.\nEntries in this table are referenced via the efmCuPme2BsMode\nobject.")
efmCuPme2BsModeDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 3, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BsModeDescr.setDescription("A textual string containing information about a 2BASE-TL PME\nspectral mode.  The string may include information about\ncorresponding (country-specific) spectral regulations\nand rate/reach limitations of this particular spectral mode.")
efmCuPme2BsModeRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BsModeRowStatus.setDescription("This object controls creation, modification, or deletion of\nthe associated entry in efmCuPme2BsModeTable per the semantics\nof RowStatus.\n\nIf an 'active' entry is referenced via efmCuPme2BsMode\ninstance(s), the entry MUST remain 'active'.\n\nAn 'active' entry SHALL NOT be modified.  In order to modify\nan existing entry, it MUST be taken out of service (by setting\nthis object to 'notInService'), modified, and set 'active'\nagain.")
efmCuPme2BReachRateTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4))
if mibBuilder.loadTexts: efmCuPme2BReachRateTable.setDescription("This table supports the definition of administrative custom\nspectral modes for 2BASE-TL PMEs, providing spectral\nlimitations in addition to those specified by\nefmCuPme2BRegion.\n\n\n\n\nThe spectral regulations in some countries (e.g., UK ANFP)\nlimit the length of the loops for certain data rates.\nThis table allows these country-specific limitations to be\nspecified.\n\nBelow is an example of this table for [ANFP]:\n----------+-------+-------\nEquivalent MaxRate MaxRate\n  Length    PAM16   PAM32\n    (m)     (Kbps)  (Kbps)\n----------+-------+-------\n    975      2304    5696\n   1125      2304    5504\n   1275      2304    5120\n   1350      2304    4864\n   1425      2304    4544\n   1500      2304    4288\n   1575      2304    3968\n   1650      2304    3776\n   1725      2304    3520\n   1800      2304    3264\n   1875      2304    3072\n   1950      2048    2688\n   2100      1792    2368\n   2250      1536       0\n   2400      1408       0\n   2550      1280       0\n   2775      1152       0\n   2925      1152       0\n   3150      1088       0\n   3375      1024       0\n----------+-------+-------\n\nEntries in this table referenced by an efmCuPme2BsMode\ninstance MUST NOT be deleted.\n\nThis table MUST be maintained in a persistent manner.")
efmCuPme2BReachRateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4, 1)).setIndexNames((0, "EFM-CU-MIB", "efmCuPme2BsModeIndex"), (0, "EFM-CU-MIB", "efmCuPme2BReachRateIndex"))
if mibBuilder.loadTexts: efmCuPme2BReachRateEntry.setDescription("Each entry specifies maximum 2BASE-TL PME data rates\nallowed for a certain equivalent loop length, when using\n\n\n\n16-TCPAM or 32-TCPAM encoding.\n\nWhen a 2BASE-TL PME is initialized, its data rate MUST NOT\nexceed one of the following limitations:\n- the value of efmCuPme2BMaxDataRate\n- maximum data rate allowed by efmCuPme2BRegion and\n  efmCuPme2BPower\n- maximum data rate for a given encoding specified in the\n  efmCuPme2BsModeEntry, corresponding to the equivalent loop\n  length, estimated by the PME\n\nIt is RECOMMENDED that the efmCuPme2BEquivalentLength values\nare assigned in increasing order, starting from the minimum\nvalue.\n\nEntries may be created/deleted using the row creation/\ndeletion mechanism via efmCuPme2ReachRateRowStatus.")
efmCuPme2BReachRateIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4, 1, 1), EfmProfileIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: efmCuPme2BReachRateIndex.setDescription("2BASE-TL custom spectral mode Reach-Rate table index.\nThis object is the unique index associated with each entry.")
efmCuPme2BEquivalentLength = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 8192))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BEquivalentLength.setDescription("Maximum allowed equivalent loop's physical length in meters\nfor the specified data rates.\nAn equivalent loop is a hypothetical 26AWG (0.4mm) loop with a\nperfect square root attenuation characteristic, without any\n\n\n\nbridged taps.")
efmCuPme2BMaxDataRatePam16 = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(192,5696),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BMaxDataRatePam16.setDescription("Maximum data rate for a 2BASE-TL PME at the specified\nequivalent loop's length using TC-PAM16 encoding.\nThe value of zero means that TC-PAM16 encoding should not be\nused at this distance.")
efmCuPme2BMaxDataRatePam32 = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4, 1, 4), Unsigned32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(192,5696),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BMaxDataRatePam32.setDescription("Maximum data rate for a 2BASE-TL PME at the specified\nequivalent loop's length using TC-PAM32 encoding.\nThe value of zero means that TC-PAM32 encoding should not be\nused at this distance.")
efmCuPme2BReachRateRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 5, 4, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme2BReachRateRowStatus.setDescription("This object controls the creation, modification, or deletion\nof the associated entry in the efmCuPme2BReachRateTable per\nthe semantics of RowStatus.\n\nIf an 'active' entry is referenced via efmCuPme2BsMode\ninstance(s), the entry MUST remain 'active'.\n\nAn 'active' entry SHALL NOT be modified.  In order to modify\nan existing entry, it MUST be taken out of service (by setting\nthis object to 'notInService'), modified, and set 'active'\nagain.")
efmCuPme10P = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 1, 2, 6))
efmCuPme10PProfileTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1))
if mibBuilder.loadTexts: efmCuPme10PProfileTable.setDescription("This table supports definitions of configuration profiles for\n10PASS-TS PMEs.\nThe first 22 entries in this table SHALL always be defined as\nfollows (see 802.3ah Annex 62B.3, table 62B-1):\n-------+--------+----+---------+-----+-----+---------------\nProfile Bandplan UPBO BandNotch DRate URate Comment\n Index  PSDMask#  p#    p#        p#    p#\n-------+--------+----+---------+-----+-----+---------------\n   1      1      3    2,6,10,11    20    20 default profile\n   2     13      5    0            20    20\n   3      1      1    0            20    20\n   4     16      0    0           100   100\n   5     16      0    0            70    50\n   6      6      0    0            50    10\n   7     17      0    0            30    30\n   8      8      0    0            30     5\n   9      4      0    0            25    25\n  10      4      0    0            15    15\n  11     23      0    0            10    10\n  12     23      0    0             5     5\n  13     16      0    2,5,9,11    100   100\n  14     16      0    2,5,9,11     70    50\n  15      6      0    2,6,10,11    50    10\n  16     17      0    2,5,9,11     30    30\n  17      8      0    2,6,10,11    30     5\n  18      4      0    2,6,10,11    25    25\n  19      4      0    2,6,10,11    15    15\n  20     23      0    2,5,9,11     10    10\n  21     23      0    2,5,9,11      5     5\n  22     30      0    0           200    50\n-------+--------+----+---------+-----+-----+---------------\n\nThese default entries SHALL be created during agent\ninitialization and MUST NOT be deleted.\n\nEntries following the first 22 can be dynamically created and\ndeleted to provide custom administrative (configuration)\nprofiles and automatic operating profiles.\n\nThis table MUST be maintained in a persistent manner.")
efmCuPme10PProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1)).setIndexNames((0, "EFM-CU-MIB", "efmCuPme10PProfileIndex"))
if mibBuilder.loadTexts: efmCuPme10PProfileEntry.setDescription("Each entry corresponds to a single 10PASS-TS PME profile.\n\nEach profile contains a set of parameters, used either for\nconfiguration or representation of a 10PASS-TS PME.\nIn case a particular profile is referenced via the\nefmCuPmeAdminProfile object (or efmCuAdminProfile if\nefmCuPmeAdminProfile is zero), it represents the desired\nparameters for the 10PassTS-O PME initialization.\nIf a profile is referenced via an efmCuPmeOperProfile object,\nit represents the current operating parameters of the PME.\n\nProfiles may be created/deleted using the row creation/\ndeletion mechanism via efmCuPme10PProfileRowStatus.  If an\n'active' entry is referenced, the entry MUST remain 'active'\nuntil all references are removed.\nDefault entries MUST NOT be removed.")
efmCuPme10PProfileIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 1), EfmProfileIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: efmCuPme10PProfileIndex.setDescription("10PASS-TS PME profile index.\nThis object is the unique index associated with this profile.\nEntries in this table are referenced via efmCuAdminProfile or\nefmCuPmeAdminProfile.")
efmCuPme10PProfileDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 2), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PProfileDescr.setDescription("A textual string containing information about a 10PASS-TS PME\nprofile.  The string may include information about data rate\nand spectral limitations of this particular profile.")
efmCuPme10PBandplanPSDMskProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(28,29,24,25,26,27,20,21,22,23,9,8,5,4,7,6,1,3,2,30,15,14,17,16,11,10,13,12,19,18,)).subtype(namedValues=namedval.NamedValues(("profile1", 1), ("profile10", 10), ("profile11", 11), ("profile12", 12), ("profile13", 13), ("profile14", 14), ("profile15", 15), ("profile16", 16), ("profile17", 17), ("profile18", 18), ("profile19", 19), ("profile2", 2), ("profile20", 20), ("profile21", 21), ("profile22", 22), ("profile23", 23), ("profile24", 24), ("profile25", 25), ("profile26", 26), ("profile27", 27), ("profile28", 28), ("profile29", 29), ("profile3", 3), ("profile30", 30), ("profile4", 4), ("profile5", 5), ("profile6", 6), ("profile7", 7), ("profile8", 8), ("profile9", 9), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PBandplanPSDMskProfile.setDescription("The 10PASS-TS PME Bandplan and PSD Mask Profile, as specified\nin 802.3ah Annex 62A, table 62A-1.  Possible values are:\n--------------+------------------------+------------+--------\nProfile Name    PSD Mask                  Bands      G.993.1\n                                        0/1/2/3/4/5  Bandplan\n--------------+------------------------+------------+--------\nprofile1(1)    T1.424 FTTCab.M1         x/D/U/D/U    A\nprofile2(2)    T1.424 FTTEx.M1          x/D/U/D/U    A\nprofile3(3)    T1.424 FTTCab.M2         x/D/U/D/U    A\nprofile4(4)    T1.424 FTTEx.M2          x/D/U/D/U    A\nprofile5(5)    T1.424 FTTCab.M1         D/D/U/D/U    A\nprofile6(6)    T1.424 FTTEx.M1          D/D/U/D/U    A\nprofile7(7)    T1.424 FTTCab.M2         D/D/U/D/U    A\nprofile8(8)    T1.424 FTTEx.M2          D/D/U/D/U    A\nprofile9(9)    T1.424 FTTCab.M1         U/D/U/D/x    A\nprofile10(10)  T1.424 FTTEx.M1          U/D/U/D/x    A\nprofile11(11)  T1.424 FTTCab.M2         U/D/U/D/x    A\nprofile12(12)  T1.424 FTTEx.M2          U/D/U/D/x    A\nprofile13(13)  TS 101 270-1 Pcab.M1.A   x/D/U/D/U    B\nprofile14(14)  TS 101 270-1 Pcab.M1.B   x/D/U/D/U    B\nprofile15(15)  TS 101 270-1 Pex.P1.M1   x/D/U/D/U    B\nprofile16(16)  TS 101 270-1 Pex.P2.M1   x/D/U/D/U    B\nprofile17(17)  TS 101 270-1 Pcab.M2     x/D/U/D/U    B\nprofile18(18)  TS 101 270-1 Pex.P1.M2   x/D/U/D/U    B\nprofile19(19)  TS 101 270-1 Pex.P2.M2   x/D/U/D/U    B\nprofile20(20)  TS 101 270-1 Pcab.M1.A   U/D/U/D/x    B\nprofile21(21)  TS 101 270-1 Pcab.M1.B   U/D/U/D/x    B\nprofile22(22)  TS 101 270-1 Pex.P1.M1   U/D/U/D/x    B\nprofile23(23)  TS 101 270-1 Pex.P2.M1   U/D/U/D/x    B\nprofile24(24)  TS 101 270-1 Pcab.M2     U/D/U/D/x    B\nprofile25(25)  TS 101 270-1 Pex.P1.M2   U/D/U/D/x    B\nprofile26(26)  TS 101 270-1 Pex.P2.M2   U/D/U/D/x    B\nprofile27(27)  G.993.1 F.1.2.1          x/D/U/D/U    Annex F\nprofile28(28)  G.993.1 F.1.2.2          x/D/U/D/U    Annex F\nprofile29(29)  G.993.1 F.1.2.3          x/D/U/D/U    Annex F\nprofile30(30)  T1.424 FTTCab.M1 (ext.)  x/D/U/D/U/D  Annex A\n--------------+------------------------+------------+--------")
efmCuPme10PUPBOReferenceProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(9,8,5,4,7,6,1,0,3,2,)).subtype(namedValues=namedval.NamedValues(("profile0", 0), ("profile1", 1), ("profile2", 2), ("profile3", 3), ("profile4", 4), ("profile5", 5), ("profile6", 6), ("profile7", 7), ("profile8", 8), ("profile9", 9), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PUPBOReferenceProfile.setDescription("The 10PASS-TS PME Upstream Power Back-Off (UPBO) Reference\nPSD Profile, as specified in 802.3 Annex 62A, table 62A-3.\nPossible values are:\n------------+-----------------------------\nProfile Name   Reference PSD\n------------+-----------------------------\nprofile0(0)  no profile\nprofile1(1)  T1.424        Noise A    M1\nprofile2(2)  T1.424        Noise A    M2\nprofile3(3)  T1.424        Noise F    M1\nprofile4(4)  T1.424        Noise F    M2\nprofile5(5)  TS 101 270-1  Noise A&B\nprofile6(6)  TS 101 270-1  Noise C\nprofile7(7)  TS 101 270-1  Noise D\nprofile8(8)  TS 101 270-1  Noise E\nprofile9(9)  TS 101 270-1  Noise F\n------------+-----------------------------")
efmCuPme10PBandNotchProfiles = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 5), Bits().subtype(namedValues=namedval.NamedValues(("profile0", 0), ("profile1", 1), ("profile10", 10), ("profile11", 11), ("profile2", 2), ("profile3", 3), ("profile4", 4), ("profile5", 5), ("profile6", 6), ("profile7", 7), ("profile8", 8), ("profile9", 9), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PBandNotchProfiles.setDescription("The 10PASS-TS PME Egress Control Band Notch Profile bitmap,\nas specified in 802.3 Annex 62A, table 62A-4.  Possible values\nare:\n--------------+--------+------+------------+------+------\nProfile Name   G.991.3  T1.424 TS 101 270-1 StartF EndF\n               table    table  table        (MHz)  (MHz)\n--------------+--------+------+------------+------+------\nprofile0(0)    no profile\nprofile1(1)    F-5 #01  -      -            1.810  1.825\nprofile2(2)    6-2      15-1   17           1.810  2.000\nprofile3(3)    F-5 #02  -      -            1.907  1.912\nprofile4(4)    F-5 #03  -      -            3.500  3.575\nprofile5(5)    6-2      -      17           3.500  3.800\nprofile6(6)    -        15-1   -            3.500  4.000\nprofile7(7)    F-5 #04  -      -            3.747  3.754\nprofile8(8)    F-5 #05  -      -            3.791  3.805\nprofile9(9)    6-2      -      17           7.000  7.100\nprofile10(10)  F-5 #06  15-1   -            7.000  7.300\nprofile11(11)  6-2      15-1   1            10.100 10.150\n--------------+--------+------+------------+------+------\n\nAny combination of profiles can be specified by ORing\nindividual profiles, for example, a value of 0x2230 selects\nprofiles 2, 6, 10, and 11.")
efmCuPme10PPayloadDRateProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(25,30,20,15,10,50,70,5,100,140,200,)).subtype(namedValues=namedval.NamedValues(("profile10", 10), ("profile100", 100), ("profile140", 140), ("profile15", 15), ("profile20", 20), ("profile200", 200), ("profile25", 25), ("profile30", 30), ("profile5", 5), ("profile50", 50), ("profile70", 70), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PPayloadDRateProfile.setDescription("The 10PASS-TS PME Downstream Payload Rate Profile, as\n\n\n\nspecified in 802.3 Annex 62A.  Possible values are:\n  profile5(5)      - 2.5 Mbps\n  profile10(10)    - 5 Mbps\n  profile15(15)    - 7.5 Mbps\n  profile20(20)    - 10 Mbps\n  profile25(25)    - 12.5 Mbps\n  profile30(30)    - 15 Mbps\n  profile50(50)    - 25 Mbps\n  profile70(70)    - 35 Mbps\n  profile100(100)  - 50 Mbps\n  profile140(140)  - 70 Mbps\n  profile200(200)  - 100 Mbps\n\nEach value represents a target for the PME's Downstream\nPayload Bitrate as seen at the MII.  If the payload rate of\nthe selected profile cannot be achieved based on the loop\nenvironment, bandplan, and PSD mask, the PME initialization\nSHALL fail.")
efmCuPme10PPayloadURateProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(15,10,100,5,25,30,20,50,70,)).subtype(namedValues=namedval.NamedValues(("profile10", 10), ("profile100", 100), ("profile15", 15), ("profile20", 20), ("profile25", 25), ("profile30", 30), ("profile5", 5), ("profile50", 50), ("profile70", 70), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PPayloadURateProfile.setDescription("The 10PASS-TS PME Upstream Payload Rate Profile, as specified\nin 802.3 Annex 62A.  Possible values are:\n profile5(5)       - 2.5 Mbps\n profile10(10)     - 5 Mbps\n profile15(15)     - 7.5 Mbps\n profile20(20)     - 10 Mbps\n profile25(25)     - 12.5 Mbps\n profile30(30)     - 15 Mbps\n profile50(50)     - 25 Mbps\n profile70(70)     - 35 Mbps\n profile100(100)   - 50 Mbps\n\n\n\nEach value represents a target for the PME's Upstream Payload\nBitrate as seen at the MII.  If the payload rate of the\nselected profile cannot be achieved based on the loop\nenvironment, bandplan, and PSD mask, the PME initialization\nSHALL fail.")
efmCuPme10PProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 1, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: efmCuPme10PProfileRowStatus.setDescription("This object controls creation, modification, or deletion of\nthe associated entry in efmCuPme10PProfileTable per the\nsemantics of RowStatus.\n\nIf an active entry is referenced via efmCuAdminProfile or\nefmCuPmeAdminProfile, the entry MUST remain 'active' until\nall references are removed.\n\nAn 'active' entry SHALL NOT be modified.  In order to modify\nan existing entry, it MUST be taken out of service (by setting\nthis object to 'notInService'), modified, and set 'active'\nagain.")
efmCuPme10PStatusTable = MibTable((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 2))
if mibBuilder.loadTexts: efmCuPme10PStatusTable.setDescription("This table provides status information of EFMCu 10PASS-TS\nPMEs (modems).\n\nThis table contains live data from the equipment.  As such,\nit is NOT persistent.")
efmCuPme10PStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: efmCuPme10PStatusEntry.setDescription("An entry in the EFMCu 10PASS-TS PME Status table.")
efmCuPme10PFECCorrectedBlocks = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPme10PFECCorrectedBlocks.setDescription("The number of received and corrected Forward Error Correction\n(FEC) codewords in this 10PASS-TS PME.\n\nThis object maps to the aPMEFECCorrectedBlocks attribute in\nClause 30.\n\nIf a Clause 45 MDIO Interface to the PMA/PMD is present,\nthen this object maps to the 10P FEC correctable errors\nregister.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuPme10PFECUncorrectedBlocks = MibTableColumn((1, 3, 6, 1, 2, 1, 167, 1, 2, 6, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: efmCuPme10PFECUncorrectedBlocks.setDescription("The number of received uncorrectable FEC codewords in this\n10PASS-TS PME.\n\nThis object maps to the aPMEFECUncorrectableBlocks attribute\nin Clause 30.\n\nIf a Clause 45 MDIO Interface to the PMA/PMD is present,\nthen this object maps to the 10P FEC uncorrectable errors\nregister.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other times\n\n\n\nas indicated by the value of ifCounterDiscontinuityTime,\ndefined in IF-MIB.")
efmCuConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 2))
efmCuGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 2, 1))
efmCuCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 167, 2, 2))

# Augmentions

# Notifications

efmCuLowRateCrossing = NotificationType((1, 3, 6, 1, 2, 1, 167, 1, 1, 0, 1)).setObjects(("IF-MIB", "ifSpeed"), ("EFM-CU-MIB", "efmCuThreshLowRate"), )
if mibBuilder.loadTexts: efmCuLowRateCrossing.setDescription("This notification indicates that the EFMCu port's data rate\nhas reached/dropped below or exceeded the low rate threshold,\nspecified by efmCuThreshLowRate.\n\nThis notification MAY be sent for the -O subtype ports\n(2BaseTL-O/10PassTS-O) while the port is Up, on the crossing\nevent in both directions: from normal (rate is above the\nthreshold) to low (rate equals the threshold or below it) and\n\n\n\nfrom low to normal.  This notification is not applicable to\nthe -R subtypes.\n\nIt is RECOMMENDED that a small debouncing period of 2.5 sec,\nbetween the detection of the condition and the notification,\nis implemented to prevent simultaneous LinkUp/LinkDown and\nefmCuLowRateCrossing notifications to be sent.\n\nThe adaptive nature of the EFMCu technology allows the port to\nadapt itself to the changes in the copper environment, e.g.,\nan impulse noise, alien crosstalk, or a micro-interruption may\ntemporarily drop one or more PMEs in the aggregation group,\ncausing a rate degradation of the aggregated EFMCu link.\nThe dropped PMEs would then try to re-initialize, possibly at\na lower rate than before, adjusting the rate to provide\nrequired target SNR margin.\n\nGeneration of this notification is controlled by the\nefmCuLowRateCrossingEnable object.")
efmCuPmeLineAtnCrossing = NotificationType((1, 3, 6, 1, 2, 1, 167, 1, 2, 0, 1)).setObjects(("EFM-CU-MIB", "efmCuPmeLineAtn"), ("EFM-CU-MIB", "efmCuPmeThreshLineAtn"), )
if mibBuilder.loadTexts: efmCuPmeLineAtnCrossing.setDescription("This notification indicates that the loop attenuation\nthreshold (as per the efmCuPmeThreshLineAtn\nvalue) has been reached/exceeded for the 2BASE-TL/10PASS-TS\nPME.  This notification MAY be sent on the crossing event in\nboth directions: from normal to exceeded and from exceeded\nto normal.\n\nIt is RECOMMENDED that a small debouncing period of 2.5 sec,\nbetween the detection of the condition and the notification,\nis implemented to prevent intermittent notifications from\nbeing sent.\n\nGeneration of this notification is controlled by the\nefmCuPmeLineAtnCrossingEnable object.")
efmCuPmeSnrMgnCrossing = NotificationType((1, 3, 6, 1, 2, 1, 167, 1, 2, 0, 2)).setObjects(("EFM-CU-MIB", "efmCuPmeSnrMgn"), ("EFM-CU-MIB", "efmCuPmeThreshSnrMgn"), )
if mibBuilder.loadTexts: efmCuPmeSnrMgnCrossing.setDescription("This notification indicates that the SNR margin threshold\n(as per the efmCuPmeThreshSnrMgn value) has been\nreached/exceeded for the 2BASE-TL/10PASS-TS PME.\nThis notification MAY be sent on the crossing event in\nboth directions: from normal to exceeded and from exceeded\nto normal.\n\nIt is RECOMMENDED that a small debouncing period of 2.5 sec,\nbetween the detection of the condition and the notification,\nis implemented to prevent intermittent notifications from\nbeing sent.\n\nGeneration of this notification is controlled by the\nefmCuPmeSnrMgnCrossingEnable object.")
efmCuPmeDeviceFault = NotificationType((1, 3, 6, 1, 2, 1, 167, 1, 2, 0, 3)).setObjects(("EFM-CU-MIB", "efmCuPmeFltStatus"), )
if mibBuilder.loadTexts: efmCuPmeDeviceFault.setDescription("This notification indicates that a fault in the PME has been\ndetected by a vendor-specific diagnostic or a self-test.\n\nGeneration of this notification is controlled by the\nefmCuPmeDeviceFaultEnable object.")
efmCuPmeConfigInitFailure = NotificationType((1, 3, 6, 1, 2, 1, 167, 1, 2, 0, 4)).setObjects(("EFM-CU-MIB", "efmCuPmeAdminProfile"), ("EFM-CU-MIB", "efmCuPmeFltStatus"), ("EFM-CU-MIB", "efmCuAdminProfile"), )
if mibBuilder.loadTexts: efmCuPmeConfigInitFailure.setDescription("This notification indicates that PME initialization has\nfailed, due to inability of the PME link to achieve the\n\n\n\nrequested configuration profile.\n\nGeneration of this notification is controlled by the\nefmCuPmeConfigInitFailEnable object.")
efmCuPmeProtocolInitFailure = NotificationType((1, 3, 6, 1, 2, 1, 167, 1, 2, 0, 5)).setObjects(("EFM-CU-MIB", "efmCuPmeFltStatus"), ("EFM-CU-MIB", "efmCuPmeOperSubType"), )
if mibBuilder.loadTexts: efmCuPmeProtocolInitFailure.setDescription("This notification indicates that the peer PME was using\nan incompatible protocol during initialization.\n\nGeneration of this notification is controlled by the\nefmCuPmeProtocolInitFailEnable object.")

# Groups

efmCuBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 1)).setObjects(("EFM-CU-MIB", "efmCuTargetDataRate"), ("EFM-CU-MIB", "efmCuFltStatus"), ("EFM-CU-MIB", "efmCuAdminProfile"), ("EFM-CU-MIB", "efmCuPAFSupported"), ("EFM-CU-MIB", "efmCuPortSide"), ("EFM-CU-MIB", "efmCuTargetSnrMgn"), ("EFM-CU-MIB", "efmCuAdaptiveSpectra"), )
if mibBuilder.loadTexts: efmCuBasicGroup.setDescription("A collection of objects representing management information\ncommon for all types of EFMCu ports.")
efmCuPAFGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 2)).setObjects(("EFM-CU-MIB", "efmCuPAFCapacity"), ("EFM-CU-MIB", "efmCuNumPMEs"), ("EFM-CU-MIB", "efmCuPAFDiscoveryCode"), ("EFM-CU-MIB", "efmCuPAFRemoteDiscoveryCode"), ("EFM-CU-MIB", "efmCuPeerPAFCapacity"), ("EFM-CU-MIB", "efmCuPeerPAFSupported"), ("EFM-CU-MIB", "efmCuPAFAdminState"), )
if mibBuilder.loadTexts: efmCuPAFGroup.setDescription("A collection of objects supporting OPTIONAL PME\nAggregation Function (PAF) and PAF discovery in EFMCu ports.")
efmCuPAFErrorsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 3)).setObjects(("EFM-CU-MIB", "efmCuPAFInBadFragments"), ("EFM-CU-MIB", "efmCuPAFInOverflows"), ("EFM-CU-MIB", "efmCuPAFInLostStarts"), ("EFM-CU-MIB", "efmCuPAFInLargeFragments"), ("EFM-CU-MIB", "efmCuPAFInLostEnds"), ("EFM-CU-MIB", "efmCuPAFInSmallFragments"), ("EFM-CU-MIB", "efmCuPAFInLostFragments"), ("EFM-CU-MIB", "efmCuPAFInErrors"), )
if mibBuilder.loadTexts: efmCuPAFErrorsGroup.setDescription("A collection of objects supporting OPTIONAL error counters\nof PAF on EFMCu ports.")
efmCuPmeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 4)).setObjects(("EFM-CU-MIB", "efmCuPmeAdminProfile"), ("EFM-CU-MIB", "efmCuPmeOperProfile"), ("EFM-CU-MIB", "efmCuPAFRemoteDiscoveryCode"), ("EFM-CU-MIB", "efmCuPmeThreshSnrMgn"), ("EFM-CU-MIB", "efmCuPmeFltStatus"), ("EFM-CU-MIB", "efmCuPmeOperSubType"), ("EFM-CU-MIB", "efmCuPmeTCCodingErrors"), ("EFM-CU-MIB", "efmCuPmeEquivalentLength"), ("EFM-CU-MIB", "efmCuPmeAdminSubType"), ("EFM-CU-MIB", "efmCuPmePeerLineAtn"), ("EFM-CU-MIB", "efmCuPmeTCCrcErrors"), ("EFM-CU-MIB", "efmCuPmeSubTypesSupported"), ("EFM-CU-MIB", "efmCuPmeSnrMgn"), ("EFM-CU-MIB", "efmCuPmeLineAtn"), ("EFM-CU-MIB", "efmCuPmePeerSnrMgn"), ("EFM-CU-MIB", "efmCuPmeOperStatus"), ("EFM-CU-MIB", "efmCuPmeThreshLineAtn"), )
if mibBuilder.loadTexts: efmCuPmeGroup.setDescription("A collection of objects providing information about\na 2BASE-TL/10PASS-TS PME.")
efmCuAlarmConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 5)).setObjects(("EFM-CU-MIB", "efmCuPmeProtocolInitFailEnable"), ("EFM-CU-MIB", "efmCuPmeSnrMgnCrossingEnable"), ("EFM-CU-MIB", "efmCuPmeDeviceFaultEnable"), ("EFM-CU-MIB", "efmCuPmeThreshSnrMgn"), ("EFM-CU-MIB", "efmCuPmeLineAtnCrossingEnable"), ("EFM-CU-MIB", "efmCuThreshLowRate"), ("EFM-CU-MIB", "efmCuLowRateCrossingEnable"), ("EFM-CU-MIB", "efmCuPmeThreshLineAtn"), ("EFM-CU-MIB", "efmCuPmeConfigInitFailEnable"), )
if mibBuilder.loadTexts: efmCuAlarmConfGroup.setDescription("A collection of objects supporting configuration of alarm\nthresholds and notifications in EFMCu ports.")
efmCuNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 6)).setObjects(("EFM-CU-MIB", "efmCuPmeProtocolInitFailure"), ("EFM-CU-MIB", "efmCuPmeLineAtnCrossing"), ("EFM-CU-MIB", "efmCuPmeDeviceFault"), ("EFM-CU-MIB", "efmCuPmeConfigInitFailure"), ("EFM-CU-MIB", "efmCuLowRateCrossing"), ("EFM-CU-MIB", "efmCuPmeSnrMgnCrossing"), )
if mibBuilder.loadTexts: efmCuNotificationGroup.setDescription("This group supports notifications of significant conditions\nassociated with EFMCu ports.")
efmCuPme2BProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 7)).setObjects(("EFM-CU-MIB", "efmCuPme2BPower"), ("EFM-CU-MIB", "efmCuPme2BEquivalentLength"), ("EFM-CU-MIB", "efmCuPme2BReachRateRowStatus"), ("EFM-CU-MIB", "efmCuPme2BProfileDescr"), ("EFM-CU-MIB", "efmCuPme2BProfileRowStatus"), ("EFM-CU-MIB", "efmCuPme2BMaxDataRatePam16"), ("EFM-CU-MIB", "efmCuPme2BMaxDataRate"), ("EFM-CU-MIB", "efmCuPme2BsModeDescr"), ("EFM-CU-MIB", "efmCuPme2BMinDataRate"), ("EFM-CU-MIB", "efmCuPme2BsMode"), ("EFM-CU-MIB", "efmCuPme2BsModeRowStatus"), ("EFM-CU-MIB", "efmCuPme2BConstellation"), ("EFM-CU-MIB", "efmCuPme2BRegion"), ("EFM-CU-MIB", "efmCuPme2BMaxDataRatePam32"), )
if mibBuilder.loadTexts: efmCuPme2BProfileGroup.setDescription("A collection of objects that constitute a configuration\n\n\n\nprofile for configuration of 2BASE-TL ports.")
efmCuPme10PProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 8)).setObjects(("EFM-CU-MIB", "efmCuPme10PProfileDescr"), ("EFM-CU-MIB", "efmCuPme10PBandNotchProfiles"), ("EFM-CU-MIB", "efmCuPme10PPayloadURateProfile"), ("EFM-CU-MIB", "efmCuPme10PBandplanPSDMskProfile"), ("EFM-CU-MIB", "efmCuPme10PProfileRowStatus"), ("EFM-CU-MIB", "efmCuPme10PUPBOReferenceProfile"), ("EFM-CU-MIB", "efmCuPme10PPayloadDRateProfile"), )
if mibBuilder.loadTexts: efmCuPme10PProfileGroup.setDescription("A collection of objects that constitute a configuration\nprofile for configuration of 10PASS-TS ports.")
efmCuPme10PStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 167, 2, 1, 9)).setObjects(("EFM-CU-MIB", "efmCuPme10PFECUncorrectedBlocks"), ("EFM-CU-MIB", "efmCuPme10PFECCorrectedBlocks"), )
if mibBuilder.loadTexts: efmCuPme10PStatusGroup.setDescription("A collection of objects providing status information\nspecific to 10PASS-TS PMEs.")

# Compliances

efmCuCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 167, 2, 2, 1)).setObjects(("EFM-CU-MIB", "efmCuPme10PStatusGroup"), ("EFM-CU-MIB", "efmCuPme10PProfileGroup"), ("EFM-CU-MIB", "efmCuBasicGroup"), ("EFM-CU-MIB", "efmCuPmeGroup"), ("EFM-CU-MIB", "efmCuPme2BProfileGroup"), ("EFM-CU-MIB", "efmCuAlarmConfGroup"), ("EFM-CU-MIB", "efmCuPAFErrorsGroup"), ("EFM-CU-MIB", "efmCuPAFGroup"), ("EFM-CU-MIB", "efmCuNotificationGroup"), )
if mibBuilder.loadTexts: efmCuCompliance.setDescription("The compliance statement for 2BASE-TL/10PASS-TS interfaces.\nCompliance with the following external compliance statements\nis REQUIRED:\n\nMIB Module             Compliance Statement\n----------             --------------------\nIF-MIB                 ifCompliance3\nEtherLike-MIB          dot3Compliance2\nMAU-MIB                mauModIfCompl3\n\nCompliance with the following external compliance statements\nis OPTIONAL for implementations supporting PME Aggregation\nFunction (PAF) with flexible cross-connect between the PCS\n\n\n\nand PME ports:\n\nMIB Module             Compliance Statement\n----------             --------------------\nIF-INVERTED-STACK-MIB  ifInvCompliance\nIF-CAP-STACK-MIB       ifCapStackCompliance")

# Exports

# Module identity
mibBuilder.exportSymbols("EFM-CU-MIB", PYSNMP_MODULE_ID=efmCuMIB)

# Types
mibBuilder.exportSymbols("EFM-CU-MIB", EfmProfileIndex=EfmProfileIndex, EfmProfileIndexList=EfmProfileIndexList, EfmProfileIndexOrZero=EfmProfileIndexOrZero, EfmTruthValueOrUnknown=EfmTruthValueOrUnknown)

# Objects
mibBuilder.exportSymbols("EFM-CU-MIB", efmCuMIB=efmCuMIB, efmCuObjects=efmCuObjects, efmCuPort=efmCuPort, efmCuPortNotifications=efmCuPortNotifications, efmCuPortConfTable=efmCuPortConfTable, efmCuPortConfEntry=efmCuPortConfEntry, efmCuPAFAdminState=efmCuPAFAdminState, efmCuPAFDiscoveryCode=efmCuPAFDiscoveryCode, efmCuAdminProfile=efmCuAdminProfile, efmCuTargetDataRate=efmCuTargetDataRate, efmCuTargetSnrMgn=efmCuTargetSnrMgn, efmCuAdaptiveSpectra=efmCuAdaptiveSpectra, efmCuThreshLowRate=efmCuThreshLowRate, efmCuLowRateCrossingEnable=efmCuLowRateCrossingEnable, efmCuPortCapabilityTable=efmCuPortCapabilityTable, efmCuPortCapabilityEntry=efmCuPortCapabilityEntry, efmCuPAFSupported=efmCuPAFSupported, efmCuPeerPAFSupported=efmCuPeerPAFSupported, efmCuPAFCapacity=efmCuPAFCapacity, efmCuPeerPAFCapacity=efmCuPeerPAFCapacity, efmCuPortStatusTable=efmCuPortStatusTable, efmCuPortStatusEntry=efmCuPortStatusEntry, efmCuFltStatus=efmCuFltStatus, efmCuPortSide=efmCuPortSide, efmCuNumPMEs=efmCuNumPMEs, efmCuPAFInErrors=efmCuPAFInErrors, efmCuPAFInSmallFragments=efmCuPAFInSmallFragments, efmCuPAFInLargeFragments=efmCuPAFInLargeFragments, efmCuPAFInBadFragments=efmCuPAFInBadFragments, efmCuPAFInLostFragments=efmCuPAFInLostFragments, efmCuPAFInLostStarts=efmCuPAFInLostStarts, efmCuPAFInLostEnds=efmCuPAFInLostEnds, efmCuPAFInOverflows=efmCuPAFInOverflows, efmCuPme=efmCuPme, efmCuPmeNotifications=efmCuPmeNotifications, efmCuPmeConfTable=efmCuPmeConfTable, efmCuPmeConfEntry=efmCuPmeConfEntry, efmCuPmeAdminSubType=efmCuPmeAdminSubType, efmCuPmeAdminProfile=efmCuPmeAdminProfile, efmCuPAFRemoteDiscoveryCode=efmCuPAFRemoteDiscoveryCode, efmCuPmeThreshLineAtn=efmCuPmeThreshLineAtn, efmCuPmeThreshSnrMgn=efmCuPmeThreshSnrMgn, efmCuPmeLineAtnCrossingEnable=efmCuPmeLineAtnCrossingEnable, efmCuPmeSnrMgnCrossingEnable=efmCuPmeSnrMgnCrossingEnable, efmCuPmeDeviceFaultEnable=efmCuPmeDeviceFaultEnable, efmCuPmeConfigInitFailEnable=efmCuPmeConfigInitFailEnable, efmCuPmeProtocolInitFailEnable=efmCuPmeProtocolInitFailEnable, efmCuPmeCapabilityTable=efmCuPmeCapabilityTable, efmCuPmeCapabilityEntry=efmCuPmeCapabilityEntry, efmCuPmeSubTypesSupported=efmCuPmeSubTypesSupported, efmCuPmeStatusTable=efmCuPmeStatusTable, efmCuPmeStatusEntry=efmCuPmeStatusEntry, efmCuPmeOperStatus=efmCuPmeOperStatus, efmCuPmeFltStatus=efmCuPmeFltStatus, efmCuPmeOperSubType=efmCuPmeOperSubType, efmCuPmeOperProfile=efmCuPmeOperProfile, efmCuPmeSnrMgn=efmCuPmeSnrMgn, efmCuPmePeerSnrMgn=efmCuPmePeerSnrMgn, efmCuPmeLineAtn=efmCuPmeLineAtn, efmCuPmePeerLineAtn=efmCuPmePeerLineAtn, efmCuPmeEquivalentLength=efmCuPmeEquivalentLength, efmCuPmeTCCodingErrors=efmCuPmeTCCodingErrors, efmCuPmeTCCrcErrors=efmCuPmeTCCrcErrors, efmCuPme2B=efmCuPme2B, efmCuPme2BProfileTable=efmCuPme2BProfileTable, efmCuPme2BProfileEntry=efmCuPme2BProfileEntry, efmCuPme2BProfileIndex=efmCuPme2BProfileIndex, efmCuPme2BProfileDescr=efmCuPme2BProfileDescr, efmCuPme2BRegion=efmCuPme2BRegion, efmCuPme2BsMode=efmCuPme2BsMode, efmCuPme2BMinDataRate=efmCuPme2BMinDataRate, efmCuPme2BMaxDataRate=efmCuPme2BMaxDataRate, efmCuPme2BPower=efmCuPme2BPower, efmCuPme2BConstellation=efmCuPme2BConstellation, efmCuPme2BProfileRowStatus=efmCuPme2BProfileRowStatus, efmCuPme2BsModeTable=efmCuPme2BsModeTable, efmCuPme2BsModeEntry=efmCuPme2BsModeEntry, efmCuPme2BsModeIndex=efmCuPme2BsModeIndex, efmCuPme2BsModeDescr=efmCuPme2BsModeDescr, efmCuPme2BsModeRowStatus=efmCuPme2BsModeRowStatus, efmCuPme2BReachRateTable=efmCuPme2BReachRateTable, efmCuPme2BReachRateEntry=efmCuPme2BReachRateEntry, efmCuPme2BReachRateIndex=efmCuPme2BReachRateIndex, efmCuPme2BEquivalentLength=efmCuPme2BEquivalentLength, efmCuPme2BMaxDataRatePam16=efmCuPme2BMaxDataRatePam16, efmCuPme2BMaxDataRatePam32=efmCuPme2BMaxDataRatePam32, efmCuPme2BReachRateRowStatus=efmCuPme2BReachRateRowStatus, efmCuPme10P=efmCuPme10P, efmCuPme10PProfileTable=efmCuPme10PProfileTable, efmCuPme10PProfileEntry=efmCuPme10PProfileEntry, efmCuPme10PProfileIndex=efmCuPme10PProfileIndex, efmCuPme10PProfileDescr=efmCuPme10PProfileDescr, efmCuPme10PBandplanPSDMskProfile=efmCuPme10PBandplanPSDMskProfile, efmCuPme10PUPBOReferenceProfile=efmCuPme10PUPBOReferenceProfile, efmCuPme10PBandNotchProfiles=efmCuPme10PBandNotchProfiles, efmCuPme10PPayloadDRateProfile=efmCuPme10PPayloadDRateProfile, efmCuPme10PPayloadURateProfile=efmCuPme10PPayloadURateProfile, efmCuPme10PProfileRowStatus=efmCuPme10PProfileRowStatus, efmCuPme10PStatusTable=efmCuPme10PStatusTable, efmCuPme10PStatusEntry=efmCuPme10PStatusEntry, efmCuPme10PFECCorrectedBlocks=efmCuPme10PFECCorrectedBlocks, efmCuPme10PFECUncorrectedBlocks=efmCuPme10PFECUncorrectedBlocks, efmCuConformance=efmCuConformance, efmCuGroups=efmCuGroups, efmCuCompliances=efmCuCompliances)

# Notifications
mibBuilder.exportSymbols("EFM-CU-MIB", efmCuLowRateCrossing=efmCuLowRateCrossing, efmCuPmeLineAtnCrossing=efmCuPmeLineAtnCrossing, efmCuPmeSnrMgnCrossing=efmCuPmeSnrMgnCrossing, efmCuPmeDeviceFault=efmCuPmeDeviceFault, efmCuPmeConfigInitFailure=efmCuPmeConfigInitFailure, efmCuPmeProtocolInitFailure=efmCuPmeProtocolInitFailure)

# Groups
mibBuilder.exportSymbols("EFM-CU-MIB", efmCuBasicGroup=efmCuBasicGroup, efmCuPAFGroup=efmCuPAFGroup, efmCuPAFErrorsGroup=efmCuPAFErrorsGroup, efmCuPmeGroup=efmCuPmeGroup, efmCuAlarmConfGroup=efmCuAlarmConfGroup, efmCuNotificationGroup=efmCuNotificationGroup, efmCuPme2BProfileGroup=efmCuPme2BProfileGroup, efmCuPme10PProfileGroup=efmCuPme10PProfileGroup, efmCuPme10PStatusGroup=efmCuPme10PStatusGroup)

# Compliances
mibBuilder.exportSymbols("EFM-CU-MIB", efmCuCompliance=efmCuCompliance)
