# PySNMP SMI module. Autogenerated from smidump -f python FRAME-RELAY-DTE-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:29 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( transmission, ) = mibBuilder.importSymbols("RFC1213-MIB", "transmission")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( RowStatus, TextualConvention, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp")

# Types

class DLCI(Integer32):
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,8388607)
    

# Objects

frameRelayDTE = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 32)).setRevisions(("1997-05-01 02:29","1992-04-01 00:00",))
if mibBuilder.loadTexts: frameRelayDTE.setOrganization("IETF IPLPDN Working Group")
if mibBuilder.loadTexts: frameRelayDTE.setContactInfo("       Caralyn Brown\nPostal: Cadia Networks, Inc.\n        1 Corporate Drive\n        Andover, Massachusetts  01810\nTel:    +1 508 689 2400 x133\nE-Mail: cbrown@cadia.com\n\n        Fred Baker\nPostal: Cisco Systems\n        519 Lado Drive\n        Santa Barbara, California 93111\nTel:    +1 408 526 425\nE-Mail: fred@cisco.com")
if mibBuilder.loadTexts: frameRelayDTE.setDescription("The MIB module to describe the use of a Frame Relay\ninterface by a DTE.")
frameRelayTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 32, 0))
frDlcmiTable = MibTable((1, 3, 6, 1, 2, 1, 10, 32, 1))
if mibBuilder.loadTexts: frDlcmiTable.setDescription("The Parameters for the Data Link Connection Management\nInterface for the frame relay service on this\ninterface.")
frDlcmiEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 32, 1, 1)).setIndexNames((0, "FRAME-RELAY-DTE-MIB", "frDlcmiIfIndex"))
if mibBuilder.loadTexts: frDlcmiEntry.setDescription("The Parameters for a particular Data Link Connection\nManagement Interface.")
frDlcmiIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frDlcmiIfIndex.setDescription("The ifIndex value of the corresponding ifEntry.")
frDlcmiState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,6,2,4,3,1,)).subtype(namedValues=namedval.NamedValues(("noLmiConfigured", 1), ("lmiRev1", 2), ("ansiT1617D", 3), ("ansiT1617B", 4), ("itut933A", 5), ("ansiT1617D1994", 6), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiState.setDescription("This variable states which Data Link Connection\nManagement scheme is active (and by implication, what\nDLCI it uses) on the Frame Relay interface.")
frDlcmiAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("q921", 1), ("q922March90", 2), ("q922November90", 3), ("q922", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiAddress.setDescription("This variable states which address format is in use on\nthe Frame Relay interface.")
frDlcmiAddressLen = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,4,)).subtype(namedValues=namedval.NamedValues(("twoOctets", 2), ("threeOctets", 3), ("fourOctets", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiAddressLen.setDescription("This variable states the address length in octets.  In\nthe case of Q922 format, the length indicates the\nentire length of the address including the control\nportion.")
frDlcmiPollingInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 30)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiPollingInterval.setDescription("This is the number of seconds between successive\nstatus enquiry messages.")
frDlcmiFullEnquiryInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 255)).clone(6)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiFullEnquiryInterval.setDescription("Number of status enquiry intervals that pass before\nissuance of a full status enquiry message.")
frDlcmiErrorThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiErrorThreshold.setDescription("This is the maximum number of unanswered Status\nEnquiries the equipment shall accept before declaring\nthe interface down.")
frDlcmiMonitoredEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10)).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiMonitoredEvents.setDescription("This is the number of status polling intervals over\nwhich the error threshold is counted.  For example, if\nwithin 'MonitoredEvents' number of events the station\nreceives 'ErrorThreshold' number of errors, the\ninterface is marked as down.")
frDlcmiMaxSupportedVCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 9), DLCI()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiMaxSupportedVCs.setDescription("The maximum number of Virtual Circuits allowed for\nthis interface.  Usually dictated by the Frame Relay\nnetwork.\n\nIn response to a SET, if a value less than zero or\nhigher than the agent's maximal capability is\nconfigured, the agent should respond badValue")
frDlcmiMulticast = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("nonBroadcast", 1), ("broadcast", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiMulticast.setDescription("This indicates whether the Frame Relay interface is\nusing a multicast service.")
frDlcmiStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("running", 1), ("fault", 2), ("initializing", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frDlcmiStatus.setDescription("This indicates the status of the Frame Relay interface\nas determined by the performance of the dlcmi.  If no\ndlcmi is running, the Frame Relay interface will stay\nin the running state indefinitely.")
frDlcmiRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 1, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frDlcmiRowStatus.setDescription("SNMP Version 2 Row Status Variable.  Writable objects\nin the table may be written in any RowStatus state.")
frCircuitTable = MibTable((1, 3, 6, 1, 2, 1, 10, 32, 2))
if mibBuilder.loadTexts: frCircuitTable.setDescription("A table containing information about specific Data\nLink Connections (DLC) or virtual circuits.")
frCircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 32, 2, 1)).setIndexNames((0, "FRAME-RELAY-DTE-MIB", "frCircuitIfIndex"), (0, "FRAME-RELAY-DTE-MIB", "frCircuitDlci"))
if mibBuilder.loadTexts: frCircuitEntry.setDescription("The information regarding a single Data Link\nConnection.  Discontinuities in the counters contained\nin this table are indicated by the value in\nfrCircuitCreationTime.")
frCircuitIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitIfIndex.setDescription("The ifIndex Value of the ifEntry this virtual circuit\nis layered onto.")
frCircuitDlci = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 2), DLCI()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitDlci.setDescription("The Data Link Connection Identifier for this virtual\ncircuit.")
frCircuitState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("invalid", 1), ("active", 2), ("inactive", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitState.setDescription("Indicates whether the particular virtual circuit is\noperational.  In the absence of a Data Link Connection\nManagement Interface, virtual circuit entries (rows)\nmay be created by setting virtual circuit state to\n'active', or deleted by changing Circuit state to\n'invalid'.\n\nWhether or not the row actually disappears is left to\nthe implementation, so this object may actually read as\n'invalid' for some arbitrary length of time.  It is\nalso legal to set the state of a virtual circuit to\n'inactive' to temporarily disable a given circuit.\n\nThe use of 'invalid' is deprecated in this SNMP Version\n2 MIB, in favor of frCircuitRowStatus.")
frCircuitReceivedFECNs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitReceivedFECNs.setDescription("Number of frames received from the network indicating\nforward congestion since the virtual circuit was\ncreated.  This occurs when the remote DTE sets the FECN\nflag, or when a switch in the network enqueues the\nframe to a trunk whose transmission queue is\ncongested.")
frCircuitReceivedBECNs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitReceivedBECNs.setDescription("Number of frames received from the network indicating\nbackward congestion since the virtual circuit was\ncreated.  This occurs when the remote DTE sets the BECN\nflag, or when a switch in the network receives the\nframe from a trunk whose transmission queue is\ncongested.")
frCircuitSentFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitSentFrames.setDescription("The number of frames sent from this virtual circuit\nsince it was created.")
frCircuitSentOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitSentOctets.setDescription("The number of octets sent from this virtual circuit\nsince it was created.  Octets counted are the full\nframe relay header and the payload, but do not include\nthe flag characters or CRC.")
frCircuitReceivedFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitReceivedFrames.setDescription("Number of frames received over this virtual circuit\nsince it was created.")
frCircuitReceivedOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitReceivedOctets.setDescription("Number of octets received over this virtual circuit\nsince it was created.  Octets counted include the full\nframe relay header, but do not include the flag\ncharacters or the CRC.")
frCircuitCreationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 10), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitCreationTime.setDescription("The value of sysUpTime when the virtual circuit was\ncreated, whether by the Data Link Connection Management\nInterface or by a SetRequest.")
frCircuitLastTimeChange = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitLastTimeChange.setDescription("The value of sysUpTime when last there was a change in\nthe virtual circuit state")
frCircuitCommittedBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitCommittedBurst.setDescription("This variable indicates the maximum amount of data, in\nbits, that the network agrees to transfer under normal\nconditions, during the measurement interval.")
frCircuitExcessBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitExcessBurst.setDescription("This variable indicates the maximum amount of\nuncommitted data bits that the network will attempt to\ndeliver over the measurement interval.\n\nBy default, if not configured when creating the entry,\nthe Excess Information Burst Size is set to the value\nof ifSpeed.")
frCircuitThroughput = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitThroughput.setDescription("Throughput is the average number of 'Frame Relay\nInformation Field' bits transferred per second across a\nuser network interface in one direction, measured over\nthe measurement interval.\n\nIf the configured committed burst rate and throughput\nare both non-zero, the measurement interval, T, is\n    T=frCircuitCommittedBurst/frCircuitThroughput.\n\nIf the configured committed burst rate and throughput\nare both zero, the measurement interval, T, is\n           T=frCircuitExcessBurst/ifSpeed.")
frCircuitMulticast = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 15), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("unicast", 1), ("oneWay", 2), ("twoWay", 3), ("nWay", 4), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitMulticast.setDescription("This indicates whether this VC is used as a unicast VC\n(i.e. not multicast) or the type of multicast service\nsubscribed to")
frCircuitType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 16), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("static", 1), ("dynamic", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitType.setDescription("Indication of whether the VC was manually created\n(static), or dynamically created (dynamic) via the data\nlink control management interface.")
frCircuitDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitDiscards.setDescription("The number of inbound frames dropped because of format\nerrors, or because the VC is inactive.")
frCircuitReceivedDEs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitReceivedDEs.setDescription("Number of frames received from the network indicating\nthat they were eligible for discard since the virtual\ncircuit was created.  This occurs when the remote DTE\nsets the DE flag, or when in remote DTE's switch\ndetects that the frame was received as Excess Burst\ndata.")
frCircuitSentDEs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frCircuitSentDEs.setDescription("Number of frames sent to the network indicating that\nthey were eligible for discard since the virtual\ncircuit was created.   This occurs when the local DTE\nsets the DE flag, indicating that during Network\ncongestion situations those frames should be discarded\nin preference of other frames sent without the DE bit\nset.")
frCircuitLogicalIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 20), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitLogicalIfIndex.setDescription("Normally the same value as frDlcmiIfIndex, but\ndifferent when an implementation associates a virtual\nifEntry with a DLC or set of DLCs in order to associate\nhigher layer objects such as the ipAddrEntry with a\nsubset of the virtual circuits on a Frame Relay\ninterface. The type of such ifEntries is defined by the\nhigher layer object; for example, if PPP/Frame Relay is\nimplemented, the ifType of this ifEntry would be PPP.\nIf it is not so defined, as would be the case with an\nipAddrEntry, it should be of type Other.")
frCircuitRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 2, 1, 21), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: frCircuitRowStatus.setDescription("This object is used to create a new row or modify or\ndestroy an existing row in the manner described in the\ndefinition of the RowStatus textual convention.\nWritable objects in the table may be written in any\nRowStatus state.")
frErrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 32, 3))
if mibBuilder.loadTexts: frErrTable.setDescription("A table containing information about Errors on the\nFrame Relay interface.  Discontinuities in the counters\ncontained in this table are the same as apply to the\nifEntry associated with the Interface.")
frErrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 32, 3, 1)).setIndexNames((0, "FRAME-RELAY-DTE-MIB", "frErrIfIndex"))
if mibBuilder.loadTexts: frErrEntry.setDescription("The error information for a single frame relay\ninterface.")
frErrIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 3, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frErrIfIndex.setDescription("The ifIndex Value of the corresponding ifEntry.")
frErrType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(9,7,3,6,1,4,10,2,5,8,)).subtype(namedValues=namedval.NamedValues(("unknownError", 1), ("noErrorSinceReset", 10), ("receiveShort", 2), ("receiveLong", 3), ("illegalAddress", 4), ("unknownAddress", 5), ("dlcmiProtoErr", 6), ("dlcmiUnknownIE", 7), ("dlcmiSequenceErr", 8), ("dlcmiUnknownRpt", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frErrType.setDescription("The type of error that was last seen  on  this interface:\n\nreceiveShort: frame was not long enough to allow\ndemultiplexing - the address field was incomplete,\nor for virtual circuits using Multiprotocol over\nFrame Relay, the protocol identifier was missing\nor incomplete.\n\nreceiveLong: frame exceeded maximum length configured for this\n     interface.\n\nillegalAddress: address field did not match configured format.\n\nunknownAddress: frame received on a virtual circuit which was not\n        active or administratively disabled.\n\ndlcmiProtoErr: unspecified error occurred when attempting to\n       interpret link maintenance frame.\n\ndlcmiUnknownIE: link maintenance frame contained an Information\n        Element type which is not valid for the\n        configured link maintenance protocol.\n\ndlcmiSequenceErr: link maintenance frame contained a sequence\n          number other than the expected value.\n\ndlcmiUnknownRpt: link maintenance frame contained a Report Type\n         Information Element whose value was not valid\n         for the configured link maintenance protocol.\n\nnoErrorSinceReset: no errors have been detected since the last\n           cold start or warm start.")
frErrData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 3, 1, 3), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 1600))).setMaxAccess("readonly")
if mibBuilder.loadTexts: frErrData.setDescription("An octet string containing as much of the error packet\nas possible.  As a minimum, it must contain the Q.922\nAddress or as much as was delivered.  It is desirable\nto include all header and demultiplexing information.")
frErrTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 3, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frErrTime.setDescription("The value of sysUpTime at which the error was\ndetected.")
frErrFaults = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frErrFaults.setDescription("The number of times the interface has gone down since\nit was initialized.")
frErrFaultTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 32, 3, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: frErrFaultTime.setDescription("The value of sysUpTime at the time when the interface\nwas taken down due to excessive errors.  Excessive\nerrors is defined as the time when a DLCMI exceeds the\nfrDlcmiErrorThreshold number of errors within\nfrDlcmiMonitoredEvents. See FrDlcmiEntry for further\ndetails.")
frameRelayTrapControl = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 32, 4))
frTrapState = MibScalar((1, 3, 6, 1, 2, 1, 10, 32, 4, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frTrapState.setDescription("This variable indicates whether the system produces\nthe frDLCIStatusChange trap.")
frTrapMaxRate = MibScalar((1, 3, 6, 1, 2, 1, 10, 32, 4, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600000)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: frTrapMaxRate.setDescription("This variable indicates the number of milliseconds\nthat must elapse between trap emissions.  If events\noccur more rapidly, the impementation may simply fail\nto trap, or may queue traps until an appropriate time.")
frConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 32, 6))
frGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 32, 6, 1))
frCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 32, 6, 2))

# Augmentions

# Notifications

frDLCIStatusChange = NotificationType((1, 3, 6, 1, 2, 1, 10, 32, 0, 1)).setObjects(("FRAME-RELAY-DTE-MIB", "frCircuitState"), )
if mibBuilder.loadTexts: frDLCIStatusChange.setDescription("This trap indicates that the indicated Virtual Circuit\nhas changed state.  It has either been created or\ninvalidated, or has toggled between the active and\ninactive states.  If, however, the reason for the state\nchange is due to the DLCMI going down, per-DLCI traps\nshould not be generated.")

# Groups

frPortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 1)).setObjects(("FRAME-RELAY-DTE-MIB", "frDlcmiMonitoredEvents"), ("FRAME-RELAY-DTE-MIB", "frDlcmiState"), ("FRAME-RELAY-DTE-MIB", "frDlcmiMulticast"), ("FRAME-RELAY-DTE-MIB", "frDlcmiStatus"), ("FRAME-RELAY-DTE-MIB", "frDlcmiAddressLen"), ("FRAME-RELAY-DTE-MIB", "frDlcmiMaxSupportedVCs"), ("FRAME-RELAY-DTE-MIB", "frDlcmiPollingInterval"), ("FRAME-RELAY-DTE-MIB", "frDlcmiFullEnquiryInterval"), ("FRAME-RELAY-DTE-MIB", "frDlcmiIfIndex"), ("FRAME-RELAY-DTE-MIB", "frDlcmiErrorThreshold"), ("FRAME-RELAY-DTE-MIB", "frDlcmiAddress"), ("FRAME-RELAY-DTE-MIB", "frDlcmiRowStatus"), )
if mibBuilder.loadTexts: frPortGroup.setDescription("The objects necessary to control the Link Management\nInterface for a Frame Relay Interface as well as\nmaintain the error statistics on this interface.")
frCircuitGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 2)).setObjects(("FRAME-RELAY-DTE-MIB", "frCircuitDiscards"), ("FRAME-RELAY-DTE-MIB", "frCircuitState"), ("FRAME-RELAY-DTE-MIB", "frCircuitMulticast"), ("FRAME-RELAY-DTE-MIB", "frCircuitLogicalIfIndex"), ("FRAME-RELAY-DTE-MIB", "frCircuitSentDEs"), ("FRAME-RELAY-DTE-MIB", "frCircuitThroughput"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedBECNs"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedOctets"), ("FRAME-RELAY-DTE-MIB", "frCircuitDlci"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedFECNs"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedFrames"), ("FRAME-RELAY-DTE-MIB", "frCircuitSentOctets"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedDEs"), ("FRAME-RELAY-DTE-MIB", "frCircuitCommittedBurst"), ("FRAME-RELAY-DTE-MIB", "frCircuitCreationTime"), ("FRAME-RELAY-DTE-MIB", "frCircuitSentFrames"), ("FRAME-RELAY-DTE-MIB", "frCircuitRowStatus"), ("FRAME-RELAY-DTE-MIB", "frCircuitType"), ("FRAME-RELAY-DTE-MIB", "frCircuitExcessBurst"), ("FRAME-RELAY-DTE-MIB", "frCircuitIfIndex"), ("FRAME-RELAY-DTE-MIB", "frCircuitLastTimeChange"), )
if mibBuilder.loadTexts: frCircuitGroup.setDescription("The objects necessary to control the Virtual Circuits\nlayered onto a Frame Relay Interface.")
frTrapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 3)).setObjects(("FRAME-RELAY-DTE-MIB", "frTrapMaxRate"), ("FRAME-RELAY-DTE-MIB", "frTrapState"), )
if mibBuilder.loadTexts: frTrapGroup.setDescription("The objects necessary to control a Frame Relay\nInterface's notification messages.")
frErrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 4)).setObjects(("FRAME-RELAY-DTE-MIB", "frErrTime"), ("FRAME-RELAY-DTE-MIB", "frErrFaultTime"), ("FRAME-RELAY-DTE-MIB", "frErrFaults"), ("FRAME-RELAY-DTE-MIB", "frErrType"), ("FRAME-RELAY-DTE-MIB", "frErrData"), ("FRAME-RELAY-DTE-MIB", "frErrIfIndex"), )
if mibBuilder.loadTexts: frErrGroup.setDescription("Objects designed to assist in debugging Frame Relay\nInterfaces.")
frNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 5)).setObjects(("FRAME-RELAY-DTE-MIB", "frDLCIStatusChange"), )
if mibBuilder.loadTexts: frNotificationGroup.setDescription("Traps which may be used to enhance event driven\nmanagement of the interface.")
frPortGroup0 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 6)).setObjects(("FRAME-RELAY-DTE-MIB", "frDlcmiAddress"), ("FRAME-RELAY-DTE-MIB", "frDlcmiPollingInterval"), ("FRAME-RELAY-DTE-MIB", "frDlcmiFullEnquiryInterval"), ("FRAME-RELAY-DTE-MIB", "frDlcmiIfIndex"), ("FRAME-RELAY-DTE-MIB", "frDlcmiMaxSupportedVCs"), ("FRAME-RELAY-DTE-MIB", "frDlcmiMulticast"), ("FRAME-RELAY-DTE-MIB", "frDlcmiErrorThreshold"), ("FRAME-RELAY-DTE-MIB", "frDlcmiState"), ("FRAME-RELAY-DTE-MIB", "frDlcmiAddressLen"), ("FRAME-RELAY-DTE-MIB", "frDlcmiMonitoredEvents"), )
if mibBuilder.loadTexts: frPortGroup0.setDescription("The objects necessary to control the Link Management\nInterface for a Frame Relay Interface as well as\nmaintain the error statistics on this interface from\nRFC 1315.")
frCircuitGroup0 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 7)).setObjects(("FRAME-RELAY-DTE-MIB", "frCircuitState"), ("FRAME-RELAY-DTE-MIB", "frCircuitThroughput"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedBECNs"), ("FRAME-RELAY-DTE-MIB", "frCircuitDlci"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedFECNs"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedFrames"), ("FRAME-RELAY-DTE-MIB", "frCircuitCreationTime"), ("FRAME-RELAY-DTE-MIB", "frCircuitIfIndex"), ("FRAME-RELAY-DTE-MIB", "frCircuitReceivedOctets"), ("FRAME-RELAY-DTE-MIB", "frCircuitExcessBurst"), ("FRAME-RELAY-DTE-MIB", "frCircuitSentOctets"), ("FRAME-RELAY-DTE-MIB", "frCircuitCommittedBurst"), ("FRAME-RELAY-DTE-MIB", "frCircuitSentFrames"), ("FRAME-RELAY-DTE-MIB", "frCircuitLastTimeChange"), )
if mibBuilder.loadTexts: frCircuitGroup0.setDescription("The objects necessary to control the Virtual Circuits\nlayered onto a Frame Relay Interface from RFC 1315.")
frErrGroup0 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 8)).setObjects(("FRAME-RELAY-DTE-MIB", "frErrType"), ("FRAME-RELAY-DTE-MIB", "frErrTime"), ("FRAME-RELAY-DTE-MIB", "frErrIfIndex"), ("FRAME-RELAY-DTE-MIB", "frErrData"), )
if mibBuilder.loadTexts: frErrGroup0.setDescription("Objects designed to assist in debugging Frame Relay\nInterfaces from RFC 1315.")
frTrapGroup0 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 32, 6, 1, 9)).setObjects(("FRAME-RELAY-DTE-MIB", "frTrapState"), )
if mibBuilder.loadTexts: frTrapGroup0.setDescription("The objects necessary to control a Frame Relay\nInterface's notification messages from RFC 1315.")

# Compliances

frCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 32, 6, 2, 1)).setObjects(("FRAME-RELAY-DTE-MIB", "frCircuitGroup"), ("FRAME-RELAY-DTE-MIB", "frErrGroup"), ("FRAME-RELAY-DTE-MIB", "frNotificationGroup"), ("FRAME-RELAY-DTE-MIB", "frPortGroup"), ("FRAME-RELAY-DTE-MIB", "frTrapGroup"), )
if mibBuilder.loadTexts: frCompliance.setDescription("The compliance statement ")
frCompliance0 = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 32, 6, 2, 2)).setObjects(("FRAME-RELAY-DTE-MIB", "frNotificationGroup"), ("FRAME-RELAY-DTE-MIB", "frTrapGroup0"), ("FRAME-RELAY-DTE-MIB", "frCircuitGroup0"), ("FRAME-RELAY-DTE-MIB", "frPortGroup0"), ("FRAME-RELAY-DTE-MIB", "frErrGroup0"), )
if mibBuilder.loadTexts: frCompliance0.setDescription("The compliance statement for objects and the trap\ndefined in RFC 1315.")

# Exports

# Module identity
mibBuilder.exportSymbols("FRAME-RELAY-DTE-MIB", PYSNMP_MODULE_ID=frameRelayDTE)

# Types
mibBuilder.exportSymbols("FRAME-RELAY-DTE-MIB", DLCI=DLCI)

# Objects
mibBuilder.exportSymbols("FRAME-RELAY-DTE-MIB", frameRelayDTE=frameRelayDTE, frameRelayTraps=frameRelayTraps, frDlcmiTable=frDlcmiTable, frDlcmiEntry=frDlcmiEntry, frDlcmiIfIndex=frDlcmiIfIndex, frDlcmiState=frDlcmiState, frDlcmiAddress=frDlcmiAddress, frDlcmiAddressLen=frDlcmiAddressLen, frDlcmiPollingInterval=frDlcmiPollingInterval, frDlcmiFullEnquiryInterval=frDlcmiFullEnquiryInterval, frDlcmiErrorThreshold=frDlcmiErrorThreshold, frDlcmiMonitoredEvents=frDlcmiMonitoredEvents, frDlcmiMaxSupportedVCs=frDlcmiMaxSupportedVCs, frDlcmiMulticast=frDlcmiMulticast, frDlcmiStatus=frDlcmiStatus, frDlcmiRowStatus=frDlcmiRowStatus, frCircuitTable=frCircuitTable, frCircuitEntry=frCircuitEntry, frCircuitIfIndex=frCircuitIfIndex, frCircuitDlci=frCircuitDlci, frCircuitState=frCircuitState, frCircuitReceivedFECNs=frCircuitReceivedFECNs, frCircuitReceivedBECNs=frCircuitReceivedBECNs, frCircuitSentFrames=frCircuitSentFrames, frCircuitSentOctets=frCircuitSentOctets, frCircuitReceivedFrames=frCircuitReceivedFrames, frCircuitReceivedOctets=frCircuitReceivedOctets, frCircuitCreationTime=frCircuitCreationTime, frCircuitLastTimeChange=frCircuitLastTimeChange, frCircuitCommittedBurst=frCircuitCommittedBurst, frCircuitExcessBurst=frCircuitExcessBurst, frCircuitThroughput=frCircuitThroughput, frCircuitMulticast=frCircuitMulticast, frCircuitType=frCircuitType, frCircuitDiscards=frCircuitDiscards, frCircuitReceivedDEs=frCircuitReceivedDEs, frCircuitSentDEs=frCircuitSentDEs, frCircuitLogicalIfIndex=frCircuitLogicalIfIndex, frCircuitRowStatus=frCircuitRowStatus, frErrTable=frErrTable, frErrEntry=frErrEntry, frErrIfIndex=frErrIfIndex, frErrType=frErrType, frErrData=frErrData, frErrTime=frErrTime, frErrFaults=frErrFaults, frErrFaultTime=frErrFaultTime, frameRelayTrapControl=frameRelayTrapControl, frTrapState=frTrapState, frTrapMaxRate=frTrapMaxRate, frConformance=frConformance, frGroups=frGroups, frCompliances=frCompliances)

# Notifications
mibBuilder.exportSymbols("FRAME-RELAY-DTE-MIB", frDLCIStatusChange=frDLCIStatusChange)

# Groups
mibBuilder.exportSymbols("FRAME-RELAY-DTE-MIB", frPortGroup=frPortGroup, frCircuitGroup=frCircuitGroup, frTrapGroup=frTrapGroup, frErrGroup=frErrGroup, frNotificationGroup=frNotificationGroup, frPortGroup0=frPortGroup0, frCircuitGroup0=frCircuitGroup0, frErrGroup0=frErrGroup0, frTrapGroup0=frTrapGroup0)

# Compliances
mibBuilder.exportSymbols("FRAME-RELAY-DTE-MIB", frCompliance=frCompliance, frCompliance0=frCompliance0)
