# PySNMP SMI module. Autogenerated from smidump -f python IPATM-IPMC-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:41 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( AtmAddr, ) = mibBuilder.importSymbols("ATM-TC-MIB", "AtmAddr")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( ipAdEntAddr, ) = mibBuilder.importSymbols("RFC1213-MIB", "ipAdEntAddr")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, snmpModules, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "snmpModules")
( RowStatus, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TruthValue")

# Objects

marsMIB = ModuleIdentity((1, 3, 6, 1, 6, 3, 17)).setRevisions(("1998-04-15 01:45",))
if mibBuilder.loadTexts: marsMIB.setOrganization("Internetworking Over NBMA (ion) Working Group")
if mibBuilder.loadTexts: marsMIB.setContactInfo("        Chris Chung\nPostal: SAIC\n        1710 Goodridge Drive\n        Mail Stop 1-4-7\n        McLean, VA 22102\nTel:    +1 703 448 6485\nFax:    +1 703 356 2160\nE-mail: cchung@tieo.saic.com\n\nEditor: Maria Greene\nPostal: Independent Contractor\nE-mail: maria@xedia.com")
if mibBuilder.loadTexts: marsMIB.setDescription("This module defines a portion of the managed information\nbase (MIB) for managing classical IP multicast address\nresolution server (MARS) and related entities as\ndescribed in the RFC2022.  This MIB is meant to be\nused in conjunction with the ATM-MIB (RFC1695),\nMIB-II (RFC1213), and optionally the IF-MIB (RFC1573).")
marsTrapInfo = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 0))
marsClientObjects = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 1))
marsClientTable = MibTable((1, 3, 6, 1, 6, 3, 17, 1, 1))
if mibBuilder.loadTexts: marsClientTable.setDescription("The objects defined in this table are used for\nthe management of MARS clients, ATM attached\nendpoints.")
marsClientEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 1, 1, 1)).setIndexNames((0, "RFC1213-MIB", "ipAdEntAddr"), (0, "IPATM-IPMC-MIB", "marsClientIndex"))
if mibBuilder.loadTexts: marsClientEntry.setDescription("Each entry contains a MARS client and its associated\nattributes.  An entry in the marsClientTable has\na corresponding entry in the ipAddrTable defined in\nRFC1213. Association between the ipAddrTable and\nthe marsClientTable is made through the index,\nipAdEntAddr.")
marsClientIndex = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientIndex.setDescription("The auxiliary variable used to identify instances of\nthe columnar objects in the MARS MarsClientTable.")
marsClientAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 2), AtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientAddr.setDescription("The ATM address associated with the ATM Client.")
marsClientDefaultMarsAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 3), AtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientDefaultMarsAddr.setDescription("The default MARS ATM address which is needed to\nsetup the initial signalling path between a MARS\nclient and its associated MARS.")
marsClientHsn = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientHsn.setDescription("The cluster membership own 32 bit Host Sequence\nNumber.  When a new cluster member starts up, it is\ninitialized to zero.  When the cluster member sends\nthe MARS_JOIN to register, the HSN will be correctly\nset to the current cluster sequence number (CSN) when\nthe Client receives the copy of its MARS_JOIN from\nthe MARS.  It is is used to track the MARS sequence\nnumber.")
marsClientRegistration = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,2,3,1,5,)).subtype(namedValues=namedval.NamedValues(("notRegistered", 1), ("registering", 2), ("registered", 3), ("reRegisteringFault", 4), ("reRegisteringRedirMap", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientRegistration.setDescription("An indication with regards to the registration\nstatus of this client. The registration codes\nof 'notRegistered (1)', 'registered (2)', and\nregistered (3) are self-explanatory. The\n'reRegisteringFault (4)' indicates the client is\nin the process of re-registering with a MARS due\nto some fault conditions.  The 'reRegisteringRedMap\n(5)' status code shows that client is re-registering\nbecause it has received a MARS_REDIRECT_MAP message\nand was told to register with a different MARS from\nthe current MARS.")
marsClientCmi = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientCmi.setDescription("16 bit Cluster member identifier (CMI) assigned by the\nMARS which uniquely identifies each endpoint attached\nto the cluster.  The value becomes valid after the\n'marsClientRegistration' is set to the value\nof 'registered (1)'.")
marsClientDefaultMtu = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientDefaultMtu.setDescription("The default maximum transmission unit (MTU) used for\nthis cluster.  Note that the actual size used for a\nVC between two members of the cluster may be negotiated\nduring connection setup and may be different than this\nvalue.  Default value = 9180 bytes.")
marsClientFailureTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientFailureTimer.setDescription("A timer used to flag the failure of last MARS_MULTI\nto arrive.  Default value = 10 seconds (recommended).")
marsClientRetranDelayTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientRetranDelayTimer.setDescription("The delay timer for sending out new MARS_REQUEST\nfor the group after the client learned that there\nis no other group in the cluster.  The timer must\nbe set between 5 and 10 seconds inclusive.")
marsClientRdmMulReqAddRetrTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientRdmMulReqAddRetrTimer.setDescription("The initial random L_MULTI_RQ/ADD retransmit timer\nwhich can be set between 5 and 10 seconds inclusive.")
marsClientRdmVcRevalidateTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientRdmVcRevalidateTimer.setDescription("The random time to set VC_revalidate flag.  The\ntimer value ranges between 1 and 10 seconds\ninclusive.")
marsClientJoinLeaveRetrInterval = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 2147483647)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientJoinLeaveRetrInterval.setDescription("MARS_JOIN/LEAVE retransmit interval. The minimum\nand recommended values are 5 and 10 seconds,\nrespectively.")
marsClientJoinLeaveRetrLimit = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 5))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientJoinLeaveRetrLimit.setDescription("MARS_JOIN/LEAVE retransmit limit. The maximum\nvalue is 5.")
marsClientRegWithMarsRdmTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientRegWithMarsRdmTimer.setDescription("Random time to register with MARS.")
marsClientForceWaitTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientForceWaitTimer.setDescription("Force wait if MARS re-registration is looping.\nThe minimum value is 1 minute.")
marsClientLmtToMissRedirMapTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientLmtToMissRedirMapTimer.setDescription("Timer limit for client to miss MARS_REDIRECT_MAPS.")
marsClientIdleTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 17), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientIdleTimer.setDescription("The configurable inactivity timer associated with a\nclient. When a VC is created at this client, it gets\nthe idle timer value from this configurable timer.\nThe minimum suggested value is 1 minute and the\nrecommended default value is 20 minutes.")
marsClientRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 1, 1, 18), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nA row cannot be made 'active' until instances of\nall corresponding columns in the row of this table\nare appropriately configured and until the agent\nhas also created a corresponding row in the\nmarsClientStatTable.\n\nWhen this object has a value of 'active', the\nfollowing columnar objects can not be modified:\n\n  marsClientDefaultMarsAddr,\n  marsClientHsn,\n  marsClientRegstration,\n  marsClientCmi,\n  marsClientDefaultMtu\n\nwhile other objects in this conceptual row can be\nmodified irrespective of the value of this object.\n\nDeletion of this row is allowed regardless of\nwhether or not a row in any associated tables\n(i.e., marsClientVcTable) still exists or is in\nuse. Once this row is deleted, it is recommended\nthat the agent or the SNMP management station\n(if possible) through the set command deletes\nany stale rows that are associated with this\nrow.")
marsClientMcGrpTable = MibTable((1, 3, 6, 1, 6, 3, 17, 1, 2))
if mibBuilder.loadTexts: marsClientMcGrpTable.setDescription("This table contains a list of IP multicast group address\nblocks associated with a MARS client.  Entries in this\ntable are used by the client that needs to receive or\ntransmit packets from/to the specified range of\nmulticast addresses.\nEach row can be created or deleted via configuration.")
marsClientMcGrpEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 1, 2, 1)).setIndexNames((0, "RFC1213-MIB", "ipAdEntAddr"), (0, "IPATM-IPMC-MIB", "marsClientIndex"), (0, "IPATM-IPMC-MIB", "marsClientMcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsClientMcMaxGrpAddr"))
if mibBuilder.loadTexts: marsClientMcGrpEntry.setDescription("Each entry represents a consecutive block of multicast\ngroup addresses.")
marsClientMcMinGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 2, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientMcMinGrpAddr.setDescription("Minimum multicast group address - the min and max\nmulticast forms multi-group block.  If the MinGrpAddr\nand MaxGrpAddr are the same, it indicates that this\nblock contains a single group address.")
marsClientMcMaxGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 2, 1, 2), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientMcMaxGrpAddr.setDescription("Maximum multicast group address - the min and max\nmulticast forms a multi-group block.  If the MinGrpAddr\nand MaxGrpAddr are the same, it indicates that this\nblock contains a single group address.")
marsClientMcGrpRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientMcGrpRowStatus.setDescription("The object is used to create or delete a row in this\ntable.\n\nSince other objects in this row are not-accessible\n'index-objects', the value of this object has no\neffect on whether those objects in this conceptual\nrow can be modified.")
marsClientBackupMarsTable = MibTable((1, 3, 6, 1, 6, 3, 17, 1, 3))
if mibBuilder.loadTexts: marsClientBackupMarsTable.setDescription("This table contains a list of backup MARS addresses that\na client can connect to in case of failure for connecting\nto the primary server. The list of addresses is in\ndescending order of preference. It should be noted that\nthe backup list provided by the MARS to the client via\nthe MARS_REDIRECT_MAP message has a higher preference than\naddresses that are manually configured into the client.\nWhen such a list is received from the MARS, this information\nshould be inserted at the top of the list.\nEach row can be created or deleted via configuration.")
marsClientBackupMarsEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 1, 3, 1)).setIndexNames((0, "RFC1213-MIB", "ipAdEntAddr"), (0, "IPATM-IPMC-MIB", "marsClientIndex"), (0, "IPATM-IPMC-MIB", "marsClientBackupMarsPriority"), (0, "IPATM-IPMC-MIB", "marsClientBackupMarsAddr"))
if mibBuilder.loadTexts: marsClientBackupMarsEntry.setDescription("Each entry represents an ATM address of a backup MARS.")
marsClientBackupMarsPriority = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientBackupMarsPriority.setDescription("The priority associated with a backup MARS. A lower\npriority value inidcates a higher preference.")
marsClientBackupMarsAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 3, 1, 2), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientBackupMarsAddr.setDescription("The ATM address associated with a backup MARS.")
marsClientBackupMarsRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientBackupMarsRowStatus.setDescription("The object is used to create or delete a row in this\ntable.\n\nSince other objects in this row are not-accessible\n'index-objects', the value of this object has no effect\non whether those objects in this conceptual row can be\nmodified.")
marsClientVcTable = MibTable((1, 3, 6, 1, 6, 3, 17, 1, 4))
if mibBuilder.loadTexts: marsClientVcTable.setDescription("This table contains information about open virtual\ncircuits (VCs) that a client has.  For point to point\ncircuit, each entry represents a single VC connection\nbetween this client ATM address to another party ATM\naddress.  In the case of point to multipoint connection\nwhere a single source address is associated with\nmultiple destinations, several entries are used to\nrepresent the relationship.  An example of point to\nmulti-point VC represented in a table is shown below.\n\n       Client    VPI/VCI    Grp Addr1/Addr2    Part Addr\n         1         0,1          g1,g2             p1\n         1         0,1          g1,g2             p2\n         1         0,1          g1,g2             p3\n\nNote:  This table assumes the IP multicast address\n       groups (min, max) defined in each entry are\n       always consecutive.  In the case of that a\n       client receives a JOIN/LEAVE with\n       mars$flag.punched set, each pair of the IP\n       groups will first be broken into several\n       pairs of consecutive IP groups before each\n       entry row corresponding to a pair of IP group\n       is created.")
marsClientVcEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 1, 4, 1)).setIndexNames((0, "RFC1213-MIB", "ipAdEntAddr"), (0, "IPATM-IPMC-MIB", "marsClientIndex"), (0, "IPATM-IPMC-MIB", "marsClientVcVpi"), (0, "IPATM-IPMC-MIB", "marsClientVcVci"), (0, "IPATM-IPMC-MIB", "marsClientVcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsClientVcMaxGrpAddr"), (0, "IPATM-IPMC-MIB", "marsClientVcPartyAddr"))
if mibBuilder.loadTexts: marsClientVcEntry.setDescription("The objects contained in the entry are VC related\nattributes such as VC signalling type, control VC\ntype, idle timer, negotiated MTU size, etc.")
marsClientVcVpi = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4095))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientVcVpi.setDescription("The value of virtual path identifier (VPI). Since\na VPI can be numbered 0, this sub-index can take\na value of 0.")
marsClientVcVci = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientVcVci.setDescription("The value of virtual circuit identifier (VCI). Since\na VCI can be numbered 0, this sub-index can take\na value of 0.")
marsClientVcMinGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 3), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientVcMinGrpAddr.setDescription("Minimum IP multicast group address - the min and\nmax multicast forms a multi-group consecutive\nblock which is associated with a table entry.\nif the MinGrpAddr and MaxGrpAddr are the same, it\nindicates that the size of multi-group block is 1,\na single IP group.")
marsClientVcMaxGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 4), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientVcMaxGrpAddr.setDescription("Maximum IP multicast group address - the min and\nmax multicast forms a multi-group consecutive\nblock which is associated with a table entry.\nif the MinGrpAddr and MaxGrpAddr are the same, it\nindicates that the size of multi-group block is 1,\na single IP group.")
marsClientVcPartyAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 5), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsClientVcPartyAddr.setDescription("An ATM party address in which this VC is linked.\nThe party type is identified by the\nmarsClientVcPartyAddrType.")
marsClientVcPartyAddrType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("called", 1), ("calling", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcPartyAddrType.setDescription("The party type is associated with the party address.\nThe 'called (1)' indicates that the party address is\na destination address which implies that VC is\noriginated from this client.  The 'calling (2)'\nindicates the VC was initiated externally to this\nclient. In this case, the party address is the\nsource address.")
marsClientVcType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("pvc", 1), ("svc", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcType.setDescription("Circuit Connection type: permanent virtual circuit or\nswitched virtual circuit.")
marsClientVcCtrlType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("pointToPointVC", 1), ("clusterControlVC", 2), ("pointToMultiPointVC", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcCtrlType.setDescription("Control VC type used to specify a particular connection.\npointToPointVC (1):\n  used by the ATM Clients for the registration and\n  queries.  This VC or the initial signalling path\n  is set up from the source Client to a MARS. It is\n  bi-directional.\nclusterControlVC (2):\n  used by a MARS to issue asynchronous updates to an\n  ATM Client.  This VC is established from the MARS\n  to the ATM Client.\npointToMultiPointVC (3):\n  used by the client to transfer multicast data\n  packets from layer 3.  This VC is established\n  from the source ATM Client to a destination ATM\n  endpoint which can be a multicast group member\n  or an MCS.  The destination endpoint was obtained\n  from the MARS.")
marsClientVcIdleTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcIdleTimer.setDescription("The idle timer associated with this VC.  The minimum\nsuggested value is 1 minute and the recommended\ndefault value is 20 minutes.")
marsClientVcRevalidate = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 10), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcRevalidate.setDescription("A flag associated with an open and active multipoint\nVC.  It is checked every time a packet is queued for\ntransmission on that VC. The object has the value of\ntrue (1) if revalidate is required and the value\nfalse (2) otherwise.")
marsClientVcEncapsType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("llcSnap", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcEncapsType.setDescription("The encapsulation type used when communicating over\nthis VC.")
marsClientVcNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcNegotiatedMtu.setDescription("The negotiated MTU when communicating over this VC.")
marsClientVcRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 4, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsClientVcRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nA row cannot be made 'active' until instances of\nall corresponding columns in the row of this table\nare appropriately configured.\n\nWhile objects: marsClientVcIdleTimer and\nmarsClientVcRevalidate in this conceptual\nrow can be modified irrespective of the value\nof this object, all other objects in the row can\nnot be modified when this object has a value\nof 'active'.\n\nIt is possible for an SNMP management station\nto set the row to 'notInService' and modify\nthe entry and then set it back to 'active'\n\nwith the following exception. That is, rows\nfor which the corresponding instance of\nmarsClientVcType has a value of 'svc' can not\nbe modified or deleted.")
marsClientStatTable = MibTable((1, 3, 6, 1, 6, 3, 17, 1, 5))
if mibBuilder.loadTexts: marsClientStatTable.setDescription("The table contains statistics collected at MARS\nclients.")
marsClientStatEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 1, 5, 1)).setIndexNames((0, "RFC1213-MIB", "ipAdEntAddr"), (0, "IPATM-IPMC-MIB", "marsClientIndex"))
if mibBuilder.loadTexts: marsClientStatEntry.setDescription("Each entry contains statistics collected at one MARS\nclient.")
marsClientStatTxReqMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatTxReqMsgs.setDescription("Total number of MARS_REQUEST messages transmitted\nfrom a client.")
marsClientStatTxJoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatTxJoinMsgs.setDescription("Total number of MARS_JOIN messages transmitted from\na client.")
marsClientStatTxLeaveMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatTxLeaveMsgs.setDescription("Total number of MARS_LEAVE messages transmitted from\na client.")
marsClientStatTxGrpLstReqMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatTxGrpLstReqMsgs.setDescription("Total number of MARS_GROUPLIST_REQUEST messages\ntransmitted from a client.")
marsClientStatRxJoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatRxJoinMsgs.setDescription("Total number of MARS_JOIN messages received by\na client.")
marsClientStatRxLeaveMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatRxLeaveMsgs.setDescription("Total number of MARS_LEAVE messages received by\na client.")
marsClientStatRxMultiMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatRxMultiMsgs.setDescription("Total number of MARS_MULTI messages received by\na client.")
marsClientStatRxNakMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatRxNakMsgs.setDescription("Total number of MARS_NAK messages received by\na client.")
marsClientStatRxMigrateMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatRxMigrateMsgs.setDescription("Total number of MARS_MIGRATE messages received by\na client.")
marsClientStatRxGrpLstRplyMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatRxGrpLstRplyMsgs.setDescription("Total number of MARS_GROUPLIST_REPLY messages\nreceived by a client.")
marsClientStatFailMultiMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 1, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsClientStatFailMultiMsgs.setDescription("Total number of timeouts occurred indicating\nfailure of the last MARS_MULTI to arrive.")
marsObjects = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 2))
marsTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 1))
if mibBuilder.loadTexts: marsTable.setDescription("The objects defined in this table are used for the\nmanagement of MARS servers.")
marsEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 1, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"))
if mibBuilder.loadTexts: marsEntry.setDescription("Each entry contains a MARS and its associated\nattributes.")
marsIndex = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsIndex.setDescription("The auxiliary variable used to identify instances of\nthe columnar objects in the MARS table.")
marsIfIndex = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsIfIndex.setDescription("The ifIndex of the interface that the MARS is\nassociated with.")
marsAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 3), AtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsAddr.setDescription("The ATM address associated with the MARS.")
marsLocal = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 4), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsLocal.setDescription("A flag associated with a MARS entry.  The object has\nthe value of true (1) if the MARS whose interface\nis local to the machine that implements this MIB;\notherwise the object has the value of false (2).")
marsServStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("inactive", 2), ("faulted", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsServStatus.setDescription("The current status of MARS.")
marsServType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("primary", 1), ("backup", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsServType.setDescription("Types of MARS servers: primary or backup.")
marsServPriority = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsServPriority.setDescription("Priority associated with a backup MARS server.\nA backup MARS server with lower priority value\nindicates a higher preference than other backup\nMARS servers to be used as the MARS server when\nthe primary server fails.")
marsRedirMapMsgTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsRedirMapMsgTimer.setDescription("Periodic interval on which a multi-part\nMARS_REDIRECT_MAP is sent from this MARS.")
marsCsn = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 9), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsCsn.setDescription("Current cluster sequence number (CSN) which is global\nwithin the context of a given protocol.  The CSN is\nincremented by the MARS on every transmission of a\nmessage on ClusterControlVC.  A cluster member uses\nthe CSN to track the message loss on ClusterControlVC\nor to monitor a membership change.")
marsSsn = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 10), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsSsn.setDescription("Current server sequence number (SSN) which is global\nwithin the context of a given protocol.  The SSN is\nincremented by the MARS on every transmission of a\nmessage on ServerControlVC.  A MCS uses the SSN to\ntrack the message loss on ServerControlVC or to\nmonitor a membership change.")
marsRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 1, 1, 11), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nA row cannot be made 'active' until instances of\nall corresponding columns in the row of this table\nare appropriately configured and until the agent\nhas also created a corresponding row in the\nmarsStatTable.\n\nWhen this object has a value of 'active', the\nfollowing columnar objects can not be modified:\n\n  marsAddr,\n  marsAddrLocal,\n  marsServStatus,\n  marsServType,\n  marsCsn,\n  marsSsn\n\nwhile other objects in this conceptual row can be\nmodified irrespective of the value of this object.\n\nDeletion of this row is allowed regardless of\nwhether or not a row in any associated tables\n(i.e., marsVcTable) still exists or is in use.\nOnce this row is deleted, it is recommended that\nthe agent or the SNMP management station (if\npossible) through the set command deletes any\nstale rows that are associated with this row.")
marsMcGrpTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 2))
if mibBuilder.loadTexts: marsMcGrpTable.setDescription("This table contains a list of IP multicast address\nblocks associated with a MARS.  Entries in this table\nare used by the MARS host map table and the server map\ntable.  They should be created prior to being referenced\nas indices by those tables.\nEach row can be created or deleted via configuration.")
marsMcGrpEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 2, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"), (0, "IPATM-IPMC-MIB", "marsMcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsMcMaxGrpAddr"))
if mibBuilder.loadTexts: marsMcGrpEntry.setDescription("Each entry represents a consecutive block of multicast\ngroup addresses.")
marsMcMinGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 2, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcMinGrpAddr.setDescription("Minimum multicast group address - the min and max\nmulticast forms multi-group block.  If the MinGrpAddr\nand MaxGrpAddr are the same, it indicates that this\nblock contains a single group address.")
marsMcMaxGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 2, 1, 2), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcMaxGrpAddr.setDescription("Maximum multicast group address - the min and max\nmulticast forms a multi-group block.  If The\nMinGrpAddr and MaxGrpAddr are the same, it indicates\nthat this block contains a single group address.")
marsMcGrpAddrUsage = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("hostMap", 1), ("serverMap", 2), ("hostServerMap", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcGrpAddrUsage.setDescription("Usage of the multicast address block.  The hostMap (1)\nindicates that the address block is only used in the\nMARS host map table. The serverMap (2) indicates\nthat the address block is only used in the MARS\nserver map table.  The hostServerMap (3) indicates\nthat the address block is used in both the host map\nand the server map tables.")
marsMcGrpRxLayer3GrpSets = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcGrpRxLayer3GrpSets.setDescription("Number of MARS_JOIN messages received with\nmars$flags.layer3grp flag set.")
marsMcGrpRxLayer3GrpResets = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcGrpRxLayer3GrpResets.setDescription("Number of MARS_JOIN messages received with\nmars$flags.layer3grp flag reset.")
marsMcGrpRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 2, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcGrpRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nThe value of this object has no effect on whether\nother objects in this conceptual row can be modified.")
marsHostMapTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 3))
if mibBuilder.loadTexts: marsHostMapTable.setDescription("This table caches mappings between IP multicast\naddress to a list of ATM addresses that are\nconfigured or dynamically learned from the MARS.\nThis address resolution is used for the host map.\nIt supports the mapping of a block of multicast\ngroup addresses to a cluster member address.  In\nthe case where a group block is associated with\nmultiple cluster members, several entries are\nused to representing the relationship.")
marsHostMapEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 3, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"), (0, "IPATM-IPMC-MIB", "marsMcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsMcMaxGrpAddr"), (0, "IPATM-IPMC-MIB", "marsHostMapAtmAddr"))
if mibBuilder.loadTexts: marsHostMapEntry.setDescription("Each entry row contains attributes associated with\nthe mapping between a multicast group block and an\nATM address.")
marsHostMapAtmAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 3, 1, 1), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsHostMapAtmAddr.setDescription("The mapped cluster member ATM address.")
marsHostMapRowType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 3, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("static", 1), ("dynamic", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsHostMapRowType.setDescription("Method in which this entry row is created. The\nstatic (1) indicates that this row is created\nthrough configuration.  The dynamic (2) indicates\nthat the row is created as the result of group\naddress updates received at this MARS.")
marsHostMapRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsHostMapRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nThis object must not be set to 'active' until\ninstances of all corresponding columns in the\nrow of this table are appropriately configured.\n\nIt is possible for an SNMP management station\nto set the row to 'notInService' and modify\nthe entry and then set it back to 'active'\nwith the following exception. That is, rows\nfor which the corresponding instance of\nmarsHostMapRowType has a value of 'dynamic'\ncan not be modified or deleted.")
marsServerMapTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 4))
if mibBuilder.loadTexts: marsServerMapTable.setDescription("This table caches mappings between IP multicast\naddress to a list of MCS ATM addresses that are\nconfigured or dynamically learned from the MARS.\nThis address resolution is used for the server map.\nIt supports the mapping of a block of multicast\ngroup addresses to a MCS address.  In the case\nwhere a group block is associated with multiple\nMCSs, several entries are used to representing the\nrelationship.")
marsServerMapEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 4, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"), (0, "IPATM-IPMC-MIB", "marsMcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsMcMaxGrpAddr"), (0, "IPATM-IPMC-MIB", "marsServerMapAtmAddr"))
if mibBuilder.loadTexts: marsServerMapEntry.setDescription("Each entry row contains attributes associated with\nthe mapping between a multicast group block and an\nMCS address.")
marsServerMapAtmAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 4, 1, 1), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsServerMapAtmAddr.setDescription("The mapped MCS ATM address.")
marsServerMapRowType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 4, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("static", 1), ("dynamic", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsServerMapRowType.setDescription("Method in which this entry row is created. The\n'static (1)' indicates that this row is created\nthrough configuration.  The 'dynamic (2)' indicates\nthat the row is created as the result of group\naddress updates received at this MARS.")
marsServerMapRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 4, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsServerMapRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nThis object must not be set to 'active' until\ninstances of all corresponding columns in the\nrow of this table are appropriately configured.\n\nIt is possible for an SNMP management station\nto set the row to 'notInService' and modify\nthe entry and then set it back to 'active'\nwith the following exception. That is, rows\nfor which the corresponding instance of\nmarsServerMapRowType has a value of 'dynamic'\ncan not be modified or deleted.")
marsVcTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 5))
if mibBuilder.loadTexts: marsVcTable.setDescription("This table contains information about open virtual circuits\n(VCs) that a MARS has.  For point to point circuit, each\nentry represents a single VC connection between this MARS\nATM address to another party's ATM address.  In the case of\npoint to multipoint connection where a ControlVc is attached\nwith multiple leaf nodes, several entries are used  to\nrepresent the relationship.  An example of point to\nmulti-point VC represented in a table is shown below.\n\n     MARS     VPI/VCI    MARS Addr     Party Addr\n       1         0,1         m1            p1\n       1         0,1         m1            p2\n       1         0,1         m1            p3")
marsVcEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 5, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"), (0, "IPATM-IPMC-MIB", "marsVcVpi"), (0, "IPATM-IPMC-MIB", "marsVcVci"), (0, "IPATM-IPMC-MIB", "marsVcPartyAddr"))
if mibBuilder.loadTexts: marsVcEntry.setDescription("The objects contained in the entry are VC related attributes\nsuch as VC signalling type, control VC type, idle timer,\nnegotiated MTU size, etc.")
marsVcVpi = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4095))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsVcVpi.setDescription("The value of virtual path identifier (VPI). Since\na VPI can be numbered 0, this sub-index can take\na value of 0.")
marsVcVci = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsVcVci.setDescription("The value of virtual circuit identifier (VCI).\nSince a VCI can be numbered 0, this sub-index\ncan take a value of 0.")
marsVcPartyAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 5), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsVcPartyAddr.setDescription("An ATM party address in which this VC is linked. The\nparty type is identified by the marsVcPartyAddrType.")
marsVcPartyAddrType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("called", 1), ("calling", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcPartyAddrType.setDescription("The party type is associated with the party address.  The\n'called (1)' indicates that the party address is a\ndestination address which implies that VC is originated\nfrom this MARS. The 'calling (2)' indicates the VC was\ninitiated externally to this MARS.  The party address is\nthe source address.")
marsVcType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("pvc", 1), ("svc", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcType.setDescription("Circuit Connection type: permanent virtual circuit or\nswitched virtual circuit.")
marsVcCtrlType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("pointToPointVC", 1), ("clusterControlVC", 2), ("serverControlVC", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcCtrlType.setDescription("Control VC type used to specify a particular connection.\npointToPointVC (1):\n  used by the ATM endpoints (clients) or the MCS for\n  registration and queries.  This VC is set up from\n  a MARS client and MCS to this MARS.  It is a\n  bi-directional VC.\nclusterControlVC (2):\n  used by MARS to issue asynchronous updates to ATM\n  an ATM client.  This VC is established from the\n  MARs to the ATM client.\nserverControlVC (3):\n  used by MARS to issue asynchronous update to ATM\n  multicast servers.  This type of VC exists when at\n  least a MCS is being used.")
marsVcIdleTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcIdleTimer.setDescription("The idle timer associated with this VC.  The minimum\nsuggested value is 1 minute and the recommended default\nvalue is 20 minutes.")
marsVcCmi = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcCmi.setDescription("Cluster member identifier (CMI) which uniquely identifies\neach endpoint attached to the cluster.  This variable\napplies to each 'leaf node' of an outgoing control VC.")
marsVcEncapsType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("llcSnap", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcEncapsType.setDescription("The encapsulation type used when communicating over\nthis VC.")
marsVcNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcNegotiatedMtu.setDescription("The negotiated MTU when communicating over this VC.")
marsVcRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 5, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsVcRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nA row cannot be made 'active' until instances of\nall corresponding columns in the row of this table\nare appropriately configured.\n\nWhile the marsVcIdleTimer in this conceptual\nrow can be modified irrespective of the value\nof this object, all other objects in the row can\nnot be modified when this object has a value\nof 'active'.\n\nIt is possible for an SNMP management station\nto set the row to 'notInService' and modify\nthe entry and then set it back to 'active'\nwith the following exception. That is, rows\nfor which the corresponding instance of\nmarsVcType has a value of 'svc' can not be\nmodified or deleted.")
marsRegClientTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 6))
if mibBuilder.loadTexts: marsRegClientTable.setDescription("This table contains ATM identities of all the currently\nregistered cluster members at a MARS.  Each entry represents\none set of ATM identities associated with one cluster member\nor the MARS client.")
marsRegClientEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 6, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"), (0, "IPATM-IPMC-MIB", "marsRegClientCmi"))
if mibBuilder.loadTexts: marsRegClientEntry.setDescription("Each entry row contains attributes associated with one\nregister cluster member.")
marsRegClientCmi = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 6, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsRegClientCmi.setDescription("This cluster member identifier is used as an auxiliary index\nfor the entry in this table.")
marsRegClientAtmAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 6, 1, 2), AtmAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsRegClientAtmAddr.setDescription("The registered client's ATM address.")
marsRegMcsTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 7))
if mibBuilder.loadTexts: marsRegMcsTable.setDescription("This table contains ATM identities of all the currently\nregistered MCSs at a MARS. Each entry represents one set\nof ATM identities associated with one MCS.")
marsRegMcsEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 7, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"), (0, "IPATM-IPMC-MIB", "marsRegMcsAtmAddr"))
if mibBuilder.loadTexts: marsRegMcsEntry.setDescription("Each entry row contains attributes associated with one\nregistered MCS.")
marsRegMcsAtmAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 7, 1, 1), AtmAddr()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsRegMcsAtmAddr.setDescription("The registered MCS's ATM address.")
marsStatTable = MibTable((1, 3, 6, 1, 6, 3, 17, 2, 8))
if mibBuilder.loadTexts: marsStatTable.setDescription("The table contains statistics collected at MARS.")
marsStatEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 2, 8, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsIndex"), (0, "IPATM-IPMC-MIB", "marsIfIndex"))
if mibBuilder.loadTexts: marsStatEntry.setDescription("Each entry contains statistics collected at one MARS.")
marsStatTxMultiMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxMultiMsgs.setDescription("Total number of MARS_MULTI transmitted by this MARS.")
marsStatTxGrpLstRplyMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxGrpLstRplyMsgs.setDescription("Total number of MARS_GROUPLIST_REPLY messages transmitted\nby this MARS.")
marsStatTxRedirectMapMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxRedirectMapMsgs.setDescription("Total number of MARS_REDIRECT_MAP messages transmitted by\nthis MARS.")
marsStatTxMigrateMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxMigrateMsgs.setDescription("Total number of MARS_MIGRATE messages transmitted by\nthis MARS.")
marsStatTxNakMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxNakMsgs.setDescription("Total number of MARS_NAK messages transmitted by this MARS.")
marsStatTxJoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxJoinMsgs.setDescription("Total number of MARS_JOIN messages transmitted by this\nMARS.")
marsStatTxLeaveMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxLeaveMsgs.setDescription("Total number of MARS_LEAVE messages transmitted by this\nMARS.")
marsStatTxSjoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxSjoinMsgs.setDescription("Total number of MARS_SJOIN messages transmitted by this\nMARS.")
marsStatTxSleaveMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxSleaveMsgs.setDescription("Total number of MARS_SLEAVE messages transmitted by this\nMARS.")
marsStatTxMservMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxMservMsgs.setDescription("Total number of MARS_MSERV messages transmitted by this\nMARS.")
marsStatTxUnservMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatTxUnservMsgs.setDescription("Total number of MARS_UNSERV messages transmitted by this\nMARS.")
marsStatRxReqMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxReqMsgs.setDescription("Total number of MARS_REQUEST messages received by this\nMARS.")
marsStatRxGrpLstReqMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxGrpLstReqMsgs.setDescription("Total number of MARS_GROUPLIST_REQUEST messages received\nby this MARS.")
marsStatRxJoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxJoinMsgs.setDescription("Total number of MARS_JOINS messages received by this MARS.")
marsStatRxLeaveMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxLeaveMsgs.setDescription("Total number of MARS_LEAVES messages received by this MARS.")
marsStatRxMservMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxMservMsgs.setDescription("Total number of MARS_MSERV messages received by this MARS.")
marsStatRxUnservMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxUnservMsgs.setDescription("Total number of MARS_UNSERV messages received by this MARS.")
marsStatRxBlkJoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRxBlkJoinMsgs.setDescription("Total number of block joins messages received by this MARS.")
marsStatRegMemGroups = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRegMemGroups.setDescription("Total number of IP multicast groups with 1 or more joined\ncluster members.")
marsStatRegMcsGroups = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 2, 8, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsStatRegMcsGroups.setDescription("Total number of IP multicast groups with 1 or more joined\nMCSs.")
marsMcsObjects = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 3))
marsMcsTable = MibTable((1, 3, 6, 1, 6, 3, 17, 3, 1))
if mibBuilder.loadTexts: marsMcsTable.setDescription("The objects defined in this table are used for\nthe management of a multicast server (MCS).")
marsMcsEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 3, 1, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsMcsIndex"), (0, "IPATM-IPMC-MIB", "marsMcsIfIndex"))
if mibBuilder.loadTexts: marsMcsEntry.setDescription("Each entry contains a MCS and its associated\nattributes.")
marsMcsIndex = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsIndex.setDescription("The auxiliary variable used to identify instances\nof the columnar objects in the MCS table.")
marsMcsIfIndex = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsIfIndex.setDescription("The ifIndex of the interface that the MCS is\nassociated with.")
marsMcsAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 3), AtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsAddr.setDescription("The ATM address associated with the MCS.")
marsMcsDefaultMarsAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 4), AtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsDefaultMarsAddr.setDescription("The default MARS ATM address which is needed to\nsetup the initial signalling path between a MCS\nand its associated MARS.")
marsMcsRegistration = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,2,3,1,5,)).subtype(namedValues=namedval.NamedValues(("notRegistered", 1), ("registering", 2), ("registered", 3), ("reRegisteringFault", 4), ("reRegisteringRedirMap", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRegistration.setDescription("An indication with regards to the registration\nSTATUS of this MCS. The registration codes of\n'notRegistered (1)', 'registered (2)', and\nregistered (3) are self-explanatory. The\n'reRegisteringFault (4)' indicates the MCS is\nin the process of re-registering with a MARS due\nto some fault conditions.  The 'reRegisteringRedMap\n(5)' status code shows that MCS is re-registering\nbecause it has received a MARS_REDIRECT_MAP message\nand was told to register with a shift MARS.")
marsMcsSsn = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 6), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsSsn.setDescription("The MCS own 32 bit Server Sequence Number.  It\nis used to track the Mars sequence number.")
marsMcsDefaultMtu = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsDefaultMtu.setDescription("The default maximum transmission unit (MTU) used\nfor this cluster.  Note that the actual size used\nfor a VC between two members of the cluster may be\nnegotiated during connection setup and may be\ndifferent than this value.\nDefault value = 9180 bytes.")
marsMcsFailureTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsFailureTimer.setDescription("A timer used to flag the failure of last MARS_MULTI\nto arrive.  Default value = 10 seconds (recommended).")
marsMcsRetranDelayTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRetranDelayTimer.setDescription("The delay timer for sending out new MARS_REQUEST\nfor the group after the MCS learned that there\nis no other group in the cluster.  The timer must\nbe set between 5 and 10 seconds inclusive.")
marsMcsRdmMulReqAddRetrTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRdmMulReqAddRetrTimer.setDescription("The initial random L_MULTI_RQ/ADD retransmit timer\nwhich can be set between 5 and 10 seconds inclusive.")
marsMcsRdmVcRevalidateTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRdmVcRevalidateTimer.setDescription("The random time to set VC_revalidate flag.  The\ntimer value ranges between 1 and 10 seconds\n   inclusive.")
marsMcsRegisterRetrInterval = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(5, 2147483647)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRegisterRetrInterval.setDescription("MARS_MSERV/UNSERV retransmit interval. The minimum\nand recommended values are 5 and 10 seconds,\nrespectively.")
marsMcsRegisterRetrLimit = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 5))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRegisterRetrLimit.setDescription("MARS_MSERV/UNSERV retransmit limit. The maximum value\nis 5.")
marsMcsRegWithMarsRdmTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 10))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRegWithMarsRdmTimer.setDescription("Random time for a MCS to register with a MARS.")
marsMcsForceWaitTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 15), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsForceWaitTimer.setDescription("Force wait if MARS re-registration is looping.\nThe minimum value is 1 minute.")
marsMcsLmtToMissRedirMapTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 16), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsLmtToMissRedirMapTimer.setDescription("Timer limit for MCS to miss MARS_REDIRECT_MAPS.")
marsMcsIdleTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 17), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsIdleTimer.setDescription("The configurable inactivity timer associated with a\nMCS. When a VC is created at this MCS, it gets\nthe idle timer value from this configurable timer.\nThe minimum suggested value is 1 minute and the\nrecommended default value is 20 minutes.")
marsMcsRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 1, 1, 18), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\n\nA row cannot be made 'active' until instances of\nall corresponding columns in the row of this table\nare appropriately configured and until the agent\nhas also created a corresponding row in the\nmarsMcsStatTable.\n\nWhen this object has a value of 'active', the\nfollowing columnar objects can not be modified:\n\n  marsMcsDefaultMarsAddr,\n  marsMcsSsn,\n  marsMcsRegstration,\n  marsMcsDefaultMtu\n\nwhile other objects in this conceptual row can be\nmodified irrespective of the value of this object.\nDeletion of this row is allowed regardless of\nwhether or not a row in any associated tables\n(i.e., marsMcsVcTable) still exists or is in\nuse. Once this row is deleted, it is recommended\nthat the agent or the SNMP management station\n(if possible) through the set command deletes\nany stale rows that are associated with this\nrow.")
marsMcsMcGrpTable = MibTable((1, 3, 6, 1, 6, 3, 17, 3, 2))
if mibBuilder.loadTexts: marsMcsMcGrpTable.setDescription("This table contains a list of IP multicast group address\nblocks associated by a MARS MCS.  The MCS uses the\ninformation contained in list to advertise its multicast\ngroup service to the MARS.\nEach row can be created or deleted via configuration.")
marsMcsMcGrpEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 3, 2, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsMcsIndex"), (0, "IPATM-IPMC-MIB", "marsMcsIfIndex"), (0, "IPATM-IPMC-MIB", "marsMcsMcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsMcsMcMaxGrpAddr"))
if mibBuilder.loadTexts: marsMcsMcGrpEntry.setDescription("Each entry represents a consecutive block of multicast\ngroup addresses.")
marsMcsMcMinGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 2, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsMcMinGrpAddr.setDescription("Minimum multicast group address - the min and max\nmulticast forms multi-group block.  If the MinGrpAddr\nand MaxGrpAddr are the same, it indicates that this\nblock contains a single group address.   Since the\nblock joins are no allowed by a MCS as implied in\nthe RFC2022, the MinGrpAddr and MaxGrpAddress should\nbe set to the same value at this time when an entry\nrow is created.")
marsMcsMcMaxGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 2, 1, 2), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsMcMaxGrpAddr.setDescription("Maximum multicast group address - the min and max\nmulticast forms a multi-group block.  If the\nMinGrpAddr and MaxGrpAddr are the same, it indicates\nthat this block contains a single group address.\nSince the block joins are no allowed by a MCS as\nimplied in the RFC2022, the MinGrpAddr and\nMaxGrpAddress should be set to the same value at\nthis time when an entry row is created.")
marsMcsMcGrpRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsMcGrpRowStatus.setDescription("The object is used to create or delete a row in this\ntable.\n\nSince other objects in this row are not-accessible\n'index-objects', the value of this object has no\neffect on whether those objects in this conceptual\nrow can be modified.")
marsMcsBackupMarsTable = MibTable((1, 3, 6, 1, 6, 3, 17, 3, 3))
if mibBuilder.loadTexts: marsMcsBackupMarsTable.setDescription("This table contains a list of backup MARS addresses that\na MCS can make contact to in case of failure for\nconnecting to the primary server. The list of addresses\nis in descending order of preference. It should be noted\nthat the backup list provided by the MARS to the MCS\nvia the MARS_REDIRECT_MAP message has a higher preference\nthan addresses that are manually configured into the MCS.\nWhen such a list is received from the MARS, this information\nshould be inserted at the top of the list.\nEach row can be created or deleted via configuration.")
marsMcsBackupMarsEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 3, 3, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsMcsIndex"), (0, "IPATM-IPMC-MIB", "marsMcsIfIndex"), (0, "IPATM-IPMC-MIB", "marsMcsBackupMarsPriority"), (0, "IPATM-IPMC-MIB", "marsMcsBackupMarsAddr"))
if mibBuilder.loadTexts: marsMcsBackupMarsEntry.setDescription("Each entry represents an ATM address of a backup MARS.")
marsMcsBackupMarsPriority = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsBackupMarsPriority.setDescription("The priority associated with a backup MARS. A lower\npriority value inidcates a higher preference.")
marsMcsBackupMarsAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 3, 1, 2), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsBackupMarsAddr.setDescription("The ATM address associated with a backup MARS.")
marsMcsBackupMarsRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsBackupMarsRowStatus.setDescription("The object is used to create or delete a row in this\ntable.\n\nSince other objects in this row are not-accessible\n'index-objects', the value of this object has no\neffect on whether those objects in this conceptual\nrow can be modified.")
marsMcsVcTable = MibTable((1, 3, 6, 1, 6, 3, 17, 3, 4))
if mibBuilder.loadTexts: marsMcsVcTable.setDescription("This table contains information about open virtual\ncircuits (VCs) that a MCS has.  For point to\npoint circuit, each entry represents a single VC\nconnection between this MCS ATM address to another\nparty ATM address.  In the case of point to\nmultipoint connection where a single source address\nis associated with multiple destinations, several\nentries are used to represent the relationship.  An\nexample of point to multi-point VC represented in a\ntable is shown below.\n\n   MCS      VPI/VCI    Grp Addr1/Addr2    Part Addr\n    1         0,1          g1,g2             p1\n    1         0,1          g1,g2             p2\n    1         0,1          g1,g2             p3")
marsMcsVcEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 3, 4, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsMcsIndex"), (0, "IPATM-IPMC-MIB", "marsMcsIfIndex"), (0, "IPATM-IPMC-MIB", "marsMcsVcVpi"), (0, "IPATM-IPMC-MIB", "marsMcsVcVci"), (0, "IPATM-IPMC-MIB", "marsMcsVcMinGrpAddr"), (0, "IPATM-IPMC-MIB", "marsMcsVcMaxGrpAddr"), (0, "IPATM-IPMC-MIB", "marsMcsVcPartyAddr"))
if mibBuilder.loadTexts: marsMcsVcEntry.setDescription("The objects contained in the entry are VC related\nattributes such as VC signalling type, control VC\ntype, idle timer, negotiated MTU size, etc.")
marsMcsVcVpi = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4095))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsVcVpi.setDescription("The value of virtual path identifier (VPI). Since\na VPI can be numbered 0, this sub-index can take\na value of 0.")
marsMcsVcVci = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsVcVci.setDescription("The value of virtual circuit identifier (VCI). Since\na VCI can be numbered 0, this sub-index can take\na value of 0.")
marsMcsVcMinGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 3), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsVcMinGrpAddr.setDescription("Minimum IP multicast group address - the min and\nmax multicast forms a multi-group block which is\nassociated with a VC.  If the MinGrpAddr and\nMaxGrpAddr are the same, it indicates that the\nsize of multi-group block is 1, a single IP group.")
marsMcsVcMaxGrpAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 4), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsVcMaxGrpAddr.setDescription("Maximum IP multicast group address - the min\nand max multicast forms a multi-group block\nwhich is associated with a VC. If the MinGrpAddr\nand MaxGrpAddr are the same, it indicates that the\nsize of multi-group block is 1, a single IP group.")
marsMcsVcPartyAddr = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 5), AtmAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: marsMcsVcPartyAddr.setDescription("An ATM party address in which this VC is linked.\nThe party type is identified by the\nmarsMcsVcPartyAddrType.")
marsMcsVcPartyAddrType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("called", 1), ("calling", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcPartyAddrType.setDescription("The party type is associated with the party address.\nThe called (1) indicates that the party address is\na destination address which implies that VC is\noriginated from this MCS.  The calling (2) indicates\nthe VC was initiated externally to this MCS.  In this\ncase, the party address is the source address.")
marsMcsVcType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("pvc", 1), ("svc", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcType.setDescription("Circuit Connection type: permanent virtual circuit or\nswitched virtual circuit.")
marsMcsVcCtrlType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("pointToPointVC", 1), ("serverControlVC", 2), ("pointToMultiPointVC", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcCtrlType.setDescription("Control VC type used to specify a particular connection.\npointToPointVC (1):\n  used by the ATM Clients for the registration and\n  queries.  This VC or the initial signalling path is\n  set up from the source MCS to a MARS. It is\n  bi-directional.\nserverControlVC (2):\n  used by a MARS to issue asynchronous updates to an\n  ATM Client.  This VC is established from the MARS\n  to the MCS.\npointToMultiPointVC (3):\n  used by the client to transfer multicast data\n  packets from layer 3.  This VC is established from\n  this VC to a cluster member.")
marsMcsVcIdleTimer = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647)).clone(20)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcIdleTimer.setDescription("The idle timer associated with this VC. The minimum\nsuggested value is 1 minute and the recommended\ndefault value is 20 minutes.")
marsMcsVcRevalidate = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 10), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcRevalidate.setDescription("A flag associated with an open and active multipoint\nVC. It is checked every time a packet is queued for\ntransmission on that VC. The object has the value of\ntrue (1) if revalidate is required and the value\nfalse (2) otherwise.")
marsMcsVcEncapsType = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("llcSnap", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcEncapsType.setDescription("The encapsulation type used when communicating over\nthis VC.")
marsMcsVcNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 12), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcNegotiatedMtu.setDescription("The negotiated MTU when communicating over this VC.")
marsMcsVcRowStatus = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 4, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: marsMcsVcRowStatus.setDescription("The object is used to create, delete or modify a\nrow in this table.\nA row cannot be made 'active' until instances of\nall corresponding columns in the row of this table\nare appropriately configured.\n\nWhile objects: marsMcsVcIdleTimer and\nmarsMcsVcRevalidate in this conceptual row can\nbe modified irrespective of the value of this\nobject, all other objects in the row can not be\nmodified when this object has a value of 'active'.\n\nIt is possible for an SNMP management station\nto set the row to 'notInService' and modify\nthe entry and then set it back to 'active'\nwith the following exception. That is, rows\nfor which the corresponding instance of\nmarsMcsVcType has a value of 'svc' can not\nbe modified or deleted.")
marsMcsStatTable = MibTable((1, 3, 6, 1, 6, 3, 17, 3, 5))
if mibBuilder.loadTexts: marsMcsStatTable.setDescription("The table contains statistics collected at MARS MCSs.")
marsMcsStatEntry = MibTableRow((1, 3, 6, 1, 6, 3, 17, 3, 5, 1)).setIndexNames((0, "IPATM-IPMC-MIB", "marsMcsIndex"), (0, "IPATM-IPMC-MIB", "marsMcsIfIndex"))
if mibBuilder.loadTexts: marsMcsStatEntry.setDescription("Each entry contains statistics collected at one\nMARS MCS.")
marsMcsStatTxReqMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatTxReqMsgs.setDescription("Total number of MARS_REQUEST messages transmitted\nfrom this MCS.")
marsMcsStatTxMservMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatTxMservMsgs.setDescription("Total number of MARS_MSERV messages transmitted from\nthis MCS.")
marsMcsStatTxUnservMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatTxUnservMsgs.setDescription("Total number of MARS_UNSERV messages transmitted from\nthis MCS.")
marsMcsStatRxMultiMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatRxMultiMsgs.setDescription("Total number of MARS_MULTI messages received by\nthis MCS.")
marsMcsStatRxSjoinMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatRxSjoinMsgs.setDescription("Total number of MARS_SJOIN messages received by\nthis MCS.")
marsMcsStatRxSleaveMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatRxSleaveMsgs.setDescription("Total number of MARS_SLEAVE messages received\nby this MCS.")
marsMcsStatRxNakMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatRxNakMsgs.setDescription("Total number of MARS_NAK messages received\nby this MCS.")
marsMcsStatRxMigrateMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatRxMigrateMsgs.setDescription("Total number of MARS_MIGRATE messages received\nby this MCS.")
marsMcsStatFailMultiMsgs = MibTableColumn((1, 3, 6, 1, 6, 3, 17, 3, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: marsMcsStatFailMultiMsgs.setDescription("Total number of timeouts occurred indicating\nfailure of the last MARS_MULTI to arrive.")
marsConformance = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4))
marsClientConformance = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 1))
marsClientCompliances = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 1, 1))
marsClientGroups = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 1, 2))
marsServerConformance = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 2))
marsServerCompliances = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 2, 1))
marsServerGroups = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 2, 2))
marsMcsConformance = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 3))
marsMcsCompliances = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 3, 1))
marsMcsGroups = MibIdentifier((1, 3, 6, 1, 6, 3, 17, 4, 3, 2))

# Augmentions

# Notifications

marsFaultTrap = NotificationType((1, 3, 6, 1, 6, 3, 17, 0, 1)).setObjects(("IPATM-IPMC-MIB", "marsAddr"), ("IPATM-IPMC-MIB", "marsServStatus"), )
if mibBuilder.loadTexts: marsFaultTrap.setDescription("This trap/inform is sent to the manager whenever\nthere is a fault condition occurred on a MARS.")

# Groups

marsClientGroup = ObjectGroup((1, 3, 6, 1, 6, 3, 17, 4, 1, 2, 1)).setObjects(("IPATM-IPMC-MIB", "marsClientRegWithMarsRdmTimer"), ("IPATM-IPMC-MIB", "marsClientRdmMulReqAddRetrTimer"), ("IPATM-IPMC-MIB", "marsClientIdleTimer"), ("IPATM-IPMC-MIB", "marsClientStatTxLeaveMsgs"), ("IPATM-IPMC-MIB", "marsClientDefaultMtu"), ("IPATM-IPMC-MIB", "marsClientMcGrpRowStatus"), ("IPATM-IPMC-MIB", "marsClientStatTxGrpLstReqMsgs"), ("IPATM-IPMC-MIB", "marsClientStatFailMultiMsgs"), ("IPATM-IPMC-MIB", "marsClientJoinLeaveRetrInterval"), ("IPATM-IPMC-MIB", "marsClientRegistration"), ("IPATM-IPMC-MIB", "marsClientStatRxJoinMsgs"), ("IPATM-IPMC-MIB", "marsClientStatTxReqMsgs"), ("IPATM-IPMC-MIB", "marsClientVcRowStatus"), ("IPATM-IPMC-MIB", "marsClientRowStatus"), ("IPATM-IPMC-MIB", "marsClientAddr"), ("IPATM-IPMC-MIB", "marsClientStatRxLeaveMsgs"), ("IPATM-IPMC-MIB", "marsClientVcCtrlType"), ("IPATM-IPMC-MIB", "marsClientVcPartyAddrType"), ("IPATM-IPMC-MIB", "marsClientLmtToMissRedirMapTimer"), ("IPATM-IPMC-MIB", "marsClientRetranDelayTimer"), ("IPATM-IPMC-MIB", "marsClientRdmVcRevalidateTimer"), ("IPATM-IPMC-MIB", "marsClientVcEncapsType"), ("IPATM-IPMC-MIB", "marsClientDefaultMarsAddr"), ("IPATM-IPMC-MIB", "marsClientHsn"), ("IPATM-IPMC-MIB", "marsClientStatRxNakMsgs"), ("IPATM-IPMC-MIB", "marsClientJoinLeaveRetrLimit"), ("IPATM-IPMC-MIB", "marsClientVcRevalidate"), ("IPATM-IPMC-MIB", "marsClientFailureTimer"), ("IPATM-IPMC-MIB", "marsClientCmi"), ("IPATM-IPMC-MIB", "marsClientForceWaitTimer"), ("IPATM-IPMC-MIB", "marsClientVcNegotiatedMtu"), ("IPATM-IPMC-MIB", "marsClientBackupMarsRowStatus"), ("IPATM-IPMC-MIB", "marsClientVcIdleTimer"), ("IPATM-IPMC-MIB", "marsClientStatTxJoinMsgs"), ("IPATM-IPMC-MIB", "marsClientVcType"), ("IPATM-IPMC-MIB", "marsClientStatRxMigrateMsgs"), ("IPATM-IPMC-MIB", "marsClientStatRxMultiMsgs"), ("IPATM-IPMC-MIB", "marsClientStatRxGrpLstRplyMsgs"), )
if mibBuilder.loadTexts: marsClientGroup.setDescription("A collection of objects to be implemented in a MIB\nfor the management of MARS clients.")
marsServerGroup = ObjectGroup((1, 3, 6, 1, 6, 3, 17, 4, 2, 2, 1)).setObjects(("IPATM-IPMC-MIB", "marsStatTxSleaveMsgs"), ("IPATM-IPMC-MIB", "marsVcNegotiatedMtu"), ("IPATM-IPMC-MIB", "marsCsn"), ("IPATM-IPMC-MIB", "marsMcGrpRxLayer3GrpResets"), ("IPATM-IPMC-MIB", "marsStatTxJoinMsgs"), ("IPATM-IPMC-MIB", "marsStatRegMemGroups"), ("IPATM-IPMC-MIB", "marsVcPartyAddrType"), ("IPATM-IPMC-MIB", "marsStatRxGrpLstReqMsgs"), ("IPATM-IPMC-MIB", "marsServType"), ("IPATM-IPMC-MIB", "marsMcGrpAddrUsage"), ("IPATM-IPMC-MIB", "marsServPriority"), ("IPATM-IPMC-MIB", "marsStatTxSjoinMsgs"), ("IPATM-IPMC-MIB", "marsVcIdleTimer"), ("IPATM-IPMC-MIB", "marsStatRxMservMsgs"), ("IPATM-IPMC-MIB", "marsStatRxUnservMsgs"), ("IPATM-IPMC-MIB", "marsStatTxGrpLstRplyMsgs"), ("IPATM-IPMC-MIB", "marsStatRxBlkJoinMsgs"), ("IPATM-IPMC-MIB", "marsStatTxUnservMsgs"), ("IPATM-IPMC-MIB", "marsSsn"), ("IPATM-IPMC-MIB", "marsServStatus"), ("IPATM-IPMC-MIB", "marsVcCtrlType"), ("IPATM-IPMC-MIB", "marsStatTxMservMsgs"), ("IPATM-IPMC-MIB", "marsVcType"), ("IPATM-IPMC-MIB", "marsStatRxJoinMsgs"), ("IPATM-IPMC-MIB", "marsStatRxReqMsgs"), ("IPATM-IPMC-MIB", "marsStatTxNakMsgs"), ("IPATM-IPMC-MIB", "marsRegClientAtmAddr"), ("IPATM-IPMC-MIB", "marsServerMapRowType"), ("IPATM-IPMC-MIB", "marsVcCmi"), ("IPATM-IPMC-MIB", "marsStatRxLeaveMsgs"), ("IPATM-IPMC-MIB", "marsHostMapRowType"), ("IPATM-IPMC-MIB", "marsVcEncapsType"), ("IPATM-IPMC-MIB", "marsHostMapRowStatus"), ("IPATM-IPMC-MIB", "marsStatTxLeaveMsgs"), ("IPATM-IPMC-MIB", "marsStatTxRedirectMapMsgs"), ("IPATM-IPMC-MIB", "marsStatTxMultiMsgs"), ("IPATM-IPMC-MIB", "marsStatRegMcsGroups"), ("IPATM-IPMC-MIB", "marsRowStatus"), ("IPATM-IPMC-MIB", "marsAddr"), ("IPATM-IPMC-MIB", "marsStatTxMigrateMsgs"), ("IPATM-IPMC-MIB", "marsMcGrpRxLayer3GrpSets"), ("IPATM-IPMC-MIB", "marsVcRowStatus"), ("IPATM-IPMC-MIB", "marsLocal"), ("IPATM-IPMC-MIB", "marsRegMcsAtmAddr"), ("IPATM-IPMC-MIB", "marsRedirMapMsgTimer"), ("IPATM-IPMC-MIB", "marsServerMapRowStatus"), ("IPATM-IPMC-MIB", "marsMcGrpRowStatus"), )
if mibBuilder.loadTexts: marsServerGroup.setDescription("A collection of objects to be implemented in a MIB\nfor the management of MARS servers.")
marsServerEventGroup = ObjectGroup((1, 3, 6, 1, 6, 3, 17, 4, 2, 2, 2)).setObjects(("IPATM-IPMC-MIB", "marsFaultTrap"), )
if mibBuilder.loadTexts: marsServerEventGroup.setDescription("A collection of events that can be generated from\na MARS server.")
marsMcsGroup = ObjectGroup((1, 3, 6, 1, 6, 3, 17, 4, 3, 2, 1)).setObjects(("IPATM-IPMC-MIB", "marsMcsVcRevalidate"), ("IPATM-IPMC-MIB", "marsMcsRegistration"), ("IPATM-IPMC-MIB", "marsMcsVcNegotiatedMtu"), ("IPATM-IPMC-MIB", "marsMcsRdmMulReqAddRetrTimer"), ("IPATM-IPMC-MIB", "marsMcsSsn"), ("IPATM-IPMC-MIB", "marsMcsVcType"), ("IPATM-IPMC-MIB", "marsMcsStatFailMultiMsgs"), ("IPATM-IPMC-MIB", "marsMcsRegisterRetrInterval"), ("IPATM-IPMC-MIB", "marsMcsStatRxMigrateMsgs"), ("IPATM-IPMC-MIB", "marsMcsDefaultMarsAddr"), ("IPATM-IPMC-MIB", "marsMcsStatRxSjoinMsgs"), ("IPATM-IPMC-MIB", "marsMcsRowStatus"), ("IPATM-IPMC-MIB", "marsMcsDefaultMtu"), ("IPATM-IPMC-MIB", "marsMcsStatRxSleaveMsgs"), ("IPATM-IPMC-MIB", "marsMcsStatTxUnservMsgs"), ("IPATM-IPMC-MIB", "marsMcsMcGrpRowStatus"), ("IPATM-IPMC-MIB", "marsMcsVcPartyAddrType"), ("IPATM-IPMC-MIB", "marsMcsFailureTimer"), ("IPATM-IPMC-MIB", "marsMcsStatRxNakMsgs"), ("IPATM-IPMC-MIB", "marsMcsStatTxMservMsgs"), ("IPATM-IPMC-MIB", "marsMcsRegisterRetrLimit"), ("IPATM-IPMC-MIB", "marsMcsLmtToMissRedirMapTimer"), ("IPATM-IPMC-MIB", "marsMcsVcIdleTimer"), ("IPATM-IPMC-MIB", "marsMcsVcRowStatus"), ("IPATM-IPMC-MIB", "marsMcsIdleTimer"), ("IPATM-IPMC-MIB", "marsMcsVcCtrlType"), ("IPATM-IPMC-MIB", "marsMcsVcEncapsType"), ("IPATM-IPMC-MIB", "marsMcsRdmVcRevalidateTimer"), ("IPATM-IPMC-MIB", "marsMcsStatRxMultiMsgs"), ("IPATM-IPMC-MIB", "marsMcsAddr"), ("IPATM-IPMC-MIB", "marsMcsRetranDelayTimer"), ("IPATM-IPMC-MIB", "marsMcsForceWaitTimer"), ("IPATM-IPMC-MIB", "marsMcsBackupMarsRowStatus"), ("IPATM-IPMC-MIB", "marsMcsStatTxReqMsgs"), ("IPATM-IPMC-MIB", "marsMcsRegWithMarsRdmTimer"), )
if mibBuilder.loadTexts: marsMcsGroup.setDescription("A collection of objects to be implemented in a MIB\nfor the management of MARS multicast servers (MCS).")

# Compliances

marsClientCompliance = ModuleCompliance((1, 3, 6, 1, 6, 3, 17, 4, 1, 1, 1)).setObjects(("IPATM-IPMC-MIB", "marsClientGroup"), )
if mibBuilder.loadTexts: marsClientCompliance.setDescription("The compliance statement for entities that are required\nfor the management of MARS clients.")
marsServerCompliance = ModuleCompliance((1, 3, 6, 1, 6, 3, 17, 4, 2, 1, 1)).setObjects(("IPATM-IPMC-MIB", "marsServerEventGroup"), ("IPATM-IPMC-MIB", "marsServerGroup"), )
if mibBuilder.loadTexts: marsServerCompliance.setDescription("The compliance statement for entities that are required\nfor the management of MARS servers.")
marsMcsCompliance = ModuleCompliance((1, 3, 6, 1, 6, 3, 17, 4, 3, 1, 1)).setObjects(("IPATM-IPMC-MIB", "marsMcsGroup"), )
if mibBuilder.loadTexts: marsMcsCompliance.setDescription("The compliance statement for entities that are required\nfor the management of MARS multicast servers (MCS).")

# Exports

# Module identity
mibBuilder.exportSymbols("IPATM-IPMC-MIB", PYSNMP_MODULE_ID=marsMIB)

# Objects
mibBuilder.exportSymbols("IPATM-IPMC-MIB", marsMIB=marsMIB, marsTrapInfo=marsTrapInfo, marsClientObjects=marsClientObjects, marsClientTable=marsClientTable, marsClientEntry=marsClientEntry, marsClientIndex=marsClientIndex, marsClientAddr=marsClientAddr, marsClientDefaultMarsAddr=marsClientDefaultMarsAddr, marsClientHsn=marsClientHsn, marsClientRegistration=marsClientRegistration, marsClientCmi=marsClientCmi, marsClientDefaultMtu=marsClientDefaultMtu, marsClientFailureTimer=marsClientFailureTimer, marsClientRetranDelayTimer=marsClientRetranDelayTimer, marsClientRdmMulReqAddRetrTimer=marsClientRdmMulReqAddRetrTimer, marsClientRdmVcRevalidateTimer=marsClientRdmVcRevalidateTimer, marsClientJoinLeaveRetrInterval=marsClientJoinLeaveRetrInterval, marsClientJoinLeaveRetrLimit=marsClientJoinLeaveRetrLimit, marsClientRegWithMarsRdmTimer=marsClientRegWithMarsRdmTimer, marsClientForceWaitTimer=marsClientForceWaitTimer, marsClientLmtToMissRedirMapTimer=marsClientLmtToMissRedirMapTimer, marsClientIdleTimer=marsClientIdleTimer, marsClientRowStatus=marsClientRowStatus, marsClientMcGrpTable=marsClientMcGrpTable, marsClientMcGrpEntry=marsClientMcGrpEntry, marsClientMcMinGrpAddr=marsClientMcMinGrpAddr, marsClientMcMaxGrpAddr=marsClientMcMaxGrpAddr, marsClientMcGrpRowStatus=marsClientMcGrpRowStatus, marsClientBackupMarsTable=marsClientBackupMarsTable, marsClientBackupMarsEntry=marsClientBackupMarsEntry, marsClientBackupMarsPriority=marsClientBackupMarsPriority, marsClientBackupMarsAddr=marsClientBackupMarsAddr, marsClientBackupMarsRowStatus=marsClientBackupMarsRowStatus, marsClientVcTable=marsClientVcTable, marsClientVcEntry=marsClientVcEntry, marsClientVcVpi=marsClientVcVpi, marsClientVcVci=marsClientVcVci, marsClientVcMinGrpAddr=marsClientVcMinGrpAddr, marsClientVcMaxGrpAddr=marsClientVcMaxGrpAddr, marsClientVcPartyAddr=marsClientVcPartyAddr, marsClientVcPartyAddrType=marsClientVcPartyAddrType, marsClientVcType=marsClientVcType, marsClientVcCtrlType=marsClientVcCtrlType, marsClientVcIdleTimer=marsClientVcIdleTimer, marsClientVcRevalidate=marsClientVcRevalidate, marsClientVcEncapsType=marsClientVcEncapsType, marsClientVcNegotiatedMtu=marsClientVcNegotiatedMtu, marsClientVcRowStatus=marsClientVcRowStatus, marsClientStatTable=marsClientStatTable, marsClientStatEntry=marsClientStatEntry, marsClientStatTxReqMsgs=marsClientStatTxReqMsgs, marsClientStatTxJoinMsgs=marsClientStatTxJoinMsgs, marsClientStatTxLeaveMsgs=marsClientStatTxLeaveMsgs, marsClientStatTxGrpLstReqMsgs=marsClientStatTxGrpLstReqMsgs, marsClientStatRxJoinMsgs=marsClientStatRxJoinMsgs, marsClientStatRxLeaveMsgs=marsClientStatRxLeaveMsgs, marsClientStatRxMultiMsgs=marsClientStatRxMultiMsgs, marsClientStatRxNakMsgs=marsClientStatRxNakMsgs, marsClientStatRxMigrateMsgs=marsClientStatRxMigrateMsgs, marsClientStatRxGrpLstRplyMsgs=marsClientStatRxGrpLstRplyMsgs, marsClientStatFailMultiMsgs=marsClientStatFailMultiMsgs, marsObjects=marsObjects, marsTable=marsTable, marsEntry=marsEntry, marsIndex=marsIndex, marsIfIndex=marsIfIndex, marsAddr=marsAddr, marsLocal=marsLocal, marsServStatus=marsServStatus, marsServType=marsServType, marsServPriority=marsServPriority, marsRedirMapMsgTimer=marsRedirMapMsgTimer, marsCsn=marsCsn, marsSsn=marsSsn, marsRowStatus=marsRowStatus, marsMcGrpTable=marsMcGrpTable, marsMcGrpEntry=marsMcGrpEntry, marsMcMinGrpAddr=marsMcMinGrpAddr, marsMcMaxGrpAddr=marsMcMaxGrpAddr, marsMcGrpAddrUsage=marsMcGrpAddrUsage, marsMcGrpRxLayer3GrpSets=marsMcGrpRxLayer3GrpSets, marsMcGrpRxLayer3GrpResets=marsMcGrpRxLayer3GrpResets, marsMcGrpRowStatus=marsMcGrpRowStatus, marsHostMapTable=marsHostMapTable, marsHostMapEntry=marsHostMapEntry, marsHostMapAtmAddr=marsHostMapAtmAddr, marsHostMapRowType=marsHostMapRowType, marsHostMapRowStatus=marsHostMapRowStatus, marsServerMapTable=marsServerMapTable, marsServerMapEntry=marsServerMapEntry, marsServerMapAtmAddr=marsServerMapAtmAddr, marsServerMapRowType=marsServerMapRowType, marsServerMapRowStatus=marsServerMapRowStatus, marsVcTable=marsVcTable, marsVcEntry=marsVcEntry, marsVcVpi=marsVcVpi, marsVcVci=marsVcVci, marsVcPartyAddr=marsVcPartyAddr, marsVcPartyAddrType=marsVcPartyAddrType, marsVcType=marsVcType, marsVcCtrlType=marsVcCtrlType, marsVcIdleTimer=marsVcIdleTimer, marsVcCmi=marsVcCmi, marsVcEncapsType=marsVcEncapsType, marsVcNegotiatedMtu=marsVcNegotiatedMtu, marsVcRowStatus=marsVcRowStatus, marsRegClientTable=marsRegClientTable, marsRegClientEntry=marsRegClientEntry, marsRegClientCmi=marsRegClientCmi, marsRegClientAtmAddr=marsRegClientAtmAddr, marsRegMcsTable=marsRegMcsTable, marsRegMcsEntry=marsRegMcsEntry, marsRegMcsAtmAddr=marsRegMcsAtmAddr, marsStatTable=marsStatTable, marsStatEntry=marsStatEntry, marsStatTxMultiMsgs=marsStatTxMultiMsgs, marsStatTxGrpLstRplyMsgs=marsStatTxGrpLstRplyMsgs, marsStatTxRedirectMapMsgs=marsStatTxRedirectMapMsgs, marsStatTxMigrateMsgs=marsStatTxMigrateMsgs, marsStatTxNakMsgs=marsStatTxNakMsgs, marsStatTxJoinMsgs=marsStatTxJoinMsgs, marsStatTxLeaveMsgs=marsStatTxLeaveMsgs, marsStatTxSjoinMsgs=marsStatTxSjoinMsgs, marsStatTxSleaveMsgs=marsStatTxSleaveMsgs, marsStatTxMservMsgs=marsStatTxMservMsgs, marsStatTxUnservMsgs=marsStatTxUnservMsgs)
mibBuilder.exportSymbols("IPATM-IPMC-MIB", marsStatRxReqMsgs=marsStatRxReqMsgs, marsStatRxGrpLstReqMsgs=marsStatRxGrpLstReqMsgs, marsStatRxJoinMsgs=marsStatRxJoinMsgs, marsStatRxLeaveMsgs=marsStatRxLeaveMsgs, marsStatRxMservMsgs=marsStatRxMservMsgs, marsStatRxUnservMsgs=marsStatRxUnservMsgs, marsStatRxBlkJoinMsgs=marsStatRxBlkJoinMsgs, marsStatRegMemGroups=marsStatRegMemGroups, marsStatRegMcsGroups=marsStatRegMcsGroups, marsMcsObjects=marsMcsObjects, marsMcsTable=marsMcsTable, marsMcsEntry=marsMcsEntry, marsMcsIndex=marsMcsIndex, marsMcsIfIndex=marsMcsIfIndex, marsMcsAddr=marsMcsAddr, marsMcsDefaultMarsAddr=marsMcsDefaultMarsAddr, marsMcsRegistration=marsMcsRegistration, marsMcsSsn=marsMcsSsn, marsMcsDefaultMtu=marsMcsDefaultMtu, marsMcsFailureTimer=marsMcsFailureTimer, marsMcsRetranDelayTimer=marsMcsRetranDelayTimer, marsMcsRdmMulReqAddRetrTimer=marsMcsRdmMulReqAddRetrTimer, marsMcsRdmVcRevalidateTimer=marsMcsRdmVcRevalidateTimer, marsMcsRegisterRetrInterval=marsMcsRegisterRetrInterval, marsMcsRegisterRetrLimit=marsMcsRegisterRetrLimit, marsMcsRegWithMarsRdmTimer=marsMcsRegWithMarsRdmTimer, marsMcsForceWaitTimer=marsMcsForceWaitTimer, marsMcsLmtToMissRedirMapTimer=marsMcsLmtToMissRedirMapTimer, marsMcsIdleTimer=marsMcsIdleTimer, marsMcsRowStatus=marsMcsRowStatus, marsMcsMcGrpTable=marsMcsMcGrpTable, marsMcsMcGrpEntry=marsMcsMcGrpEntry, marsMcsMcMinGrpAddr=marsMcsMcMinGrpAddr, marsMcsMcMaxGrpAddr=marsMcsMcMaxGrpAddr, marsMcsMcGrpRowStatus=marsMcsMcGrpRowStatus, marsMcsBackupMarsTable=marsMcsBackupMarsTable, marsMcsBackupMarsEntry=marsMcsBackupMarsEntry, marsMcsBackupMarsPriority=marsMcsBackupMarsPriority, marsMcsBackupMarsAddr=marsMcsBackupMarsAddr, marsMcsBackupMarsRowStatus=marsMcsBackupMarsRowStatus, marsMcsVcTable=marsMcsVcTable, marsMcsVcEntry=marsMcsVcEntry, marsMcsVcVpi=marsMcsVcVpi, marsMcsVcVci=marsMcsVcVci, marsMcsVcMinGrpAddr=marsMcsVcMinGrpAddr, marsMcsVcMaxGrpAddr=marsMcsVcMaxGrpAddr, marsMcsVcPartyAddr=marsMcsVcPartyAddr, marsMcsVcPartyAddrType=marsMcsVcPartyAddrType, marsMcsVcType=marsMcsVcType, marsMcsVcCtrlType=marsMcsVcCtrlType, marsMcsVcIdleTimer=marsMcsVcIdleTimer, marsMcsVcRevalidate=marsMcsVcRevalidate, marsMcsVcEncapsType=marsMcsVcEncapsType, marsMcsVcNegotiatedMtu=marsMcsVcNegotiatedMtu, marsMcsVcRowStatus=marsMcsVcRowStatus, marsMcsStatTable=marsMcsStatTable, marsMcsStatEntry=marsMcsStatEntry, marsMcsStatTxReqMsgs=marsMcsStatTxReqMsgs, marsMcsStatTxMservMsgs=marsMcsStatTxMservMsgs, marsMcsStatTxUnservMsgs=marsMcsStatTxUnservMsgs, marsMcsStatRxMultiMsgs=marsMcsStatRxMultiMsgs, marsMcsStatRxSjoinMsgs=marsMcsStatRxSjoinMsgs, marsMcsStatRxSleaveMsgs=marsMcsStatRxSleaveMsgs, marsMcsStatRxNakMsgs=marsMcsStatRxNakMsgs, marsMcsStatRxMigrateMsgs=marsMcsStatRxMigrateMsgs, marsMcsStatFailMultiMsgs=marsMcsStatFailMultiMsgs, marsConformance=marsConformance, marsClientConformance=marsClientConformance, marsClientCompliances=marsClientCompliances, marsClientGroups=marsClientGroups, marsServerConformance=marsServerConformance, marsServerCompliances=marsServerCompliances, marsServerGroups=marsServerGroups, marsMcsConformance=marsMcsConformance, marsMcsCompliances=marsMcsCompliances, marsMcsGroups=marsMcsGroups)

# Notifications
mibBuilder.exportSymbols("IPATM-IPMC-MIB", marsFaultTrap=marsFaultTrap)

# Groups
mibBuilder.exportSymbols("IPATM-IPMC-MIB", marsClientGroup=marsClientGroup, marsServerGroup=marsServerGroup, marsServerEventGroup=marsServerEventGroup, marsMcsGroup=marsMcsGroup)

# Compliances
mibBuilder.exportSymbols("IPATM-IPMC-MIB", marsClientCompliance=marsClientCompliance, marsServerCompliance=marsServerCompliance, marsMcsCompliance=marsMcsCompliance)
