# PySNMP SMI module. Autogenerated from smidump -f python IPMCAST-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:42 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( CounterBasedGauge64, ) = mibBuilder.importSymbols("HCNUM-TC", "CounterBasedGauge64")
( IANAipMRouteProtocol, IANAipRouteProtocol, ) = mibBuilder.importSymbols("IANA-RTPROTO-MIB", "IANAipMRouteProtocol", "IANAipRouteProtocol")
( InterfaceIndex, InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "InterfaceIndexOrZero")
( InetAddress, InetAddressPrefixLength, InetAddressType, InetVersion, InetZoneIndex, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressPrefixLength", "InetAddressType", "InetVersion", "InetZoneIndex")
( LangTag, ) = mibBuilder.importSymbols("LANGTAG-TC-MIB", "LangTag")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter64, Gauge32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter64", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TimeStamp", "TruthValue")

# Objects

ipMcastMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 168)).setRevisions(("2007-11-09 00:00",))
if mibBuilder.loadTexts: ipMcastMIB.setOrganization("IETF MBONE Deployment (MBONED) Working Group")
if mibBuilder.loadTexts: ipMcastMIB.setContactInfo("David McWalter\nData Connection Limited\n\n\n\n100 Church Street\nEnfield, EN2 6BQ\nUK\n\nPhone: +44 208 366 1177\nEMail: dmcw@dataconnection.com\n\nDave Thaler\nMicrosoft Corporation\nOne Microsoft Way\nRedmond, WA 98052-6399\nUS\n\nPhone: +1 425 703 8835\nEMail: dthaler@dthaler.microsoft.com\n\nAndrew Kessler\nCisco Systems\n425 E. Tasman Drive\nSan Jose, CA 95134\nUS\n\nPhone: +1 408 526 5139\nEMail: kessler@cisco.com")
if mibBuilder.loadTexts: ipMcastMIB.setDescription("The MIB module for management of IP Multicast, including\nmulticast routing, data forwarding, and data reception.\n\nCopyright (C) The IETF Trust (2007).  This version of this\nMIB module is part of RFC 5132; see the RFC itself for full\nlegal notices.")
ipMcast = MibIdentifier((1, 3, 6, 1, 2, 1, 168, 1))
ipMcastEnabled = MibScalar((1, 3, 6, 1, 2, 1, 168, 1, 1), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipMcastEnabled.setDescription("The enabled status of IP Multicast function on this\nsystem.\n\nThe storage type of this object is determined by\nipMcastDeviceConfigStorageType.")
ipMcastRouteEntryCount = MibScalar((1, 3, 6, 1, 2, 1, 168, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteEntryCount.setDescription("The number of rows in the ipMcastRouteTable.  This can be\nused to check for multicast routing activity, and to monitor\nthe multicast routing table size.")
ipMcastInterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 3))
if mibBuilder.loadTexts: ipMcastInterfaceTable.setDescription("The (conceptual) table used to manage the multicast\nprotocol active on an interface.")
ipMcastInterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 3, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastInterfaceIPVersion"), (0, "IPMCAST-MIB", "ipMcastInterfaceIfIndex"))
if mibBuilder.loadTexts: ipMcastInterfaceEntry.setDescription("An entry (conceptual row) containing the multicast protocol\ninformation for a particular interface.\n\nPer-interface multicast forwarding statistics are also\navailable in ipIfStatsTable.")
ipMcastInterfaceIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 3, 1, 1), InetVersion()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastInterfaceIPVersion.setDescription("The IP version of this row.")
ipMcastInterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 3, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastInterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipMcastInterfaceTtl = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 3, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 256)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipMcastInterfaceTtl.setDescription("The datagram Time to Live (TTL) threshold for the\ninterface.  Any IP multicast datagrams with a TTL (IPv4) or\nHop Limit (IPv6) less than this threshold will not be\nforwarded out the interface.  The default value of 0 means\nall multicast packets are forwarded out the interface.  A\nvalue of 256 means that no multicast packets are forwarded\nout the interface.")
ipMcastInterfaceRateLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 3, 1, 4), Unsigned32().clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipMcastInterfaceRateLimit.setDescription("The rate-limit, in kilobits per second, of forwarded\nmulticast traffic on the interface.  A rate-limit of 0\nindicates that no rate limiting is done.")
ipMcastInterfaceStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 3, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipMcastInterfaceStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
ipMcastSsmRangeTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 4))
if mibBuilder.loadTexts: ipMcastSsmRangeTable.setDescription("This table is used to create and manage the range(s) of\ngroup addresses to which SSM semantics should be applied.")
ipMcastSsmRangeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 4, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastSsmRangeAddressType"), (0, "IPMCAST-MIB", "ipMcastSsmRangeAddress"), (0, "IPMCAST-MIB", "ipMcastSsmRangePrefixLength"))
if mibBuilder.loadTexts: ipMcastSsmRangeEntry.setDescription("An entry (conceptual row) containing a range of group\naddresses to which SSM semantics should be applied.\n\nObject Identifiers (OIDs) are limited to 128\nsub-identifiers, but this limit is not enforced by the\nsyntax of this entry.  In practice, this does not present\na problem, because IP address types allowed by conformance\nstatements do not exceed this limit.")
ipMcastSsmRangeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 4, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastSsmRangeAddressType.setDescription("The address type of the multicast group prefix.")
ipMcastSsmRangeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 4, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastSsmRangeAddress.setDescription("The multicast group address which, when combined with\nipMcastSsmRangePrefixLength, gives the group prefix for this\nSSM range.  The InetAddressType is given by\nipMcastSsmRangeAddressType.\n\nThis address object is only significant up to\nipMcastSsmRangePrefixLength bits.  The remaining address\nbits are set to zero.  This is especially important for this\nindex field, which is part of the index of this entry.  Any\nnon-zero bits would signify an entirely different entry.\n\nFor IPv6 SSM address ranges, only ranges prefixed by\nFF3x::/16 are permitted, where 'x' is a valid IPv6 RFC 4291\nmulticast address scope.  The syntax of the address range is\ngiven by RFC 3306, Sections 4 and 7.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nSSM range entry applies only within the given zone.  Zone\nindex zero is not valid in this table.\n\nIf non-global scope SSM range entries are present, then\nconsistent ipMcastBoundaryTable entries are required on\nrouters at the zone boundary.")
ipMcastSsmRangePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 4, 1, 3), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastSsmRangePrefixLength.setDescription("The length in bits of the mask which, when combined with\n\n\n\nipMcastSsmRangeAddress, gives the group prefix for this SSM\nrange.\n\nThe InetAddressType is given by ipMcastSsmRangeAddressType.\nFor values 'ipv4' and 'ipv4z', this object must be in the\nrange 4..32.  For values 'ipv6' and 'ipv6z', this object\nmust be in the range 8..128.")
ipMcastSsmRangeRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 4, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastSsmRangeRowStatus.setDescription("The status of this row, by which rows in this table can\nbe created and destroyed.\n\nThis status object can be set to active(1) without setting\nany other columnar objects in this entry.\n\nAll writeable objects in this entry can be modified when the\nstatus of this entry is active(1).")
ipMcastSsmRangeStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 4, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastSsmRangeStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
ipMcastRouteTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 5))
if mibBuilder.loadTexts: ipMcastRouteTable.setDescription("The (conceptual) table containing multicast routing\ninformation for IP datagrams sent by particular sources\n\n\n\nto the IP multicast groups known to this router.")
ipMcastRouteEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 5, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastRouteGroupAddressType"), (0, "IPMCAST-MIB", "ipMcastRouteGroup"), (0, "IPMCAST-MIB", "ipMcastRouteGroupPrefixLength"), (0, "IPMCAST-MIB", "ipMcastRouteSourceAddressType"), (0, "IPMCAST-MIB", "ipMcastRouteSource"), (0, "IPMCAST-MIB", "ipMcastRouteSourcePrefixLength"))
if mibBuilder.loadTexts: ipMcastRouteEntry.setDescription("An entry (conceptual row) containing the multicast routing\ninformation for IP datagrams from a particular source and\naddressed to a particular IP multicast group address.\n\nOIDs are limited to 128 sub-identifiers, but this limit\nis not enforced by the syntax of this entry.  In practice,\nthis does not present a problem, because IP address types\nallowed by conformance statements do not exceed this limit.")
ipMcastRouteGroupAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteGroupAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastRouteGroup.  Legal values correspond to\nthe subset of address families for which multicast\nforwarding is supported.")
ipMcastRouteGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteGroup.setDescription("The IP multicast group address which, when combined with\nthe corresponding value specified in\nipMcastRouteGroupPrefixLength, identifies the groups for\nwhich this entry contains multicast routing information.\n\nThis address object is only significant up to\nipMcastRouteGroupPrefixLength bits.  The remaining address\nbits are set to zero.  This is especially important for this\nindex field, which is part of the index of this entry.  Any\nnon-zero bits would signify an entirely different entry.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nforwarding state applies only within the given zone.  Zone\nindex zero is not valid in this table.")
ipMcastRouteGroupPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 3), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteGroupPrefixLength.setDescription("The length in bits of the mask which, when combined with\nthe corresponding value of ipMcastRouteGroup, identifies the\ngroups for which this entry contains multicast routing\ninformation.\n\nThe InetAddressType is given by\n\n\n\nipMcastRouteGroupAddressType.  For values 'ipv4' and\n'ipv4z', this object must be in the range 4..32.  For values\n'ipv6' and 'ipv6z', this object must be in the range\n8..128.")
ipMcastRouteSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 4), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteSourceAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastRouteSource.\n\nA value of unknown(0) indicates a non-source-specific entry,\ncorresponding to all sources in the group.  Otherwise, the\nvalue MUST be the same as the value of\nipMcastRouteGroupType.")
ipMcastRouteSource = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 5), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteSource.setDescription("The network address which, when combined with the\ncorresponding value of ipMcastRouteSourcePrefixLength,\nidentifies the sources for which this entry contains\nmulticast routing information.\n\nThis address object is only significant up to\nipMcastRouteSourcePrefixLength bits.  The remaining address\nbits are set to zero.  This is especially important for this\nindex field, which is part of the index of this entry.  Any\nnon-zero bits would signify an entirely different entry.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nsource address applies only within the given zone.  Zone\nindex zero is not valid in this table.")
ipMcastRouteSourcePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 6), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteSourcePrefixLength.setDescription("The length in bits of the mask which, when combined with\nthe corresponding value of ipMcastRouteSource, identifies\nthe sources for which this entry contains multicast routing\ninformation.\n\nThe InetAddressType is given by\nipMcastRouteSourceAddressType.  For the value 'unknown',\nthis object must be zero.  For values 'ipv4' and 'ipv4z',\nthis object must be in the range 4..32.  For values 'ipv6'\nand 'ipv6z', this object must be in the range 8..128.")
ipMcastRouteUpstreamNeighborType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 7), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteUpstreamNeighborType.setDescription("A value indicating the address family of the address\ncontained in ipMcastRouteUpstreamNeighbor.\n\nAn address type of unknown(0) indicates that the upstream\nneighbor is unknown, for example in BIDIR-PIM.")
ipMcastRouteUpstreamNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 8), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteUpstreamNeighbor.setDescription("The address of the upstream neighbor (for example, RPF\nneighbor) from which IP datagrams from these sources to\nthis multicast address are received.")
ipMcastRouteInIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 9), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteInIfIndex.setDescription("The value of ifIndex for the interface on which IP\ndatagrams sent by these sources to this multicast address\nare received.  A value of 0 indicates that datagrams are not\nsubject to an incoming interface check, but may be accepted\non multiple interfaces (for example, in BIDIR-PIM).")
ipMcastRouteTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 10), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteTimeStamp.setDescription("The value of sysUpTime at which the multicast routing\ninformation represented by this entry was learned by the\nrouter.\n\nIf this information was present at the most recent re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
ipMcastRouteExpiryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 11), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteExpiryTime.setDescription("The minimum amount of time remaining before this entry will\nbe aged out.  The value 0 indicates that the entry is not\nsubject to aging.  If ipMcastRouteNextHopState is pruned(1),\nthis object represents the remaining time until the prune\nexpires.  If this timer expires, state reverts to\nforwarding(2).  Otherwise, this object represents the time\nuntil this entry is removed from the table.")
ipMcastRouteProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 12), IANAipMRouteProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteProtocol.setDescription("The multicast routing protocol via which this multicast\nforwarding entry was learned.")
ipMcastRouteRtProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 13), IANAipRouteProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteRtProtocol.setDescription("The routing mechanism via which the route used to find the\nupstream or parent interface for this multicast forwarding\nentry was learned.")
ipMcastRouteRtAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 14), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteRtAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastRouteRtAddress.")
ipMcastRouteRtAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 15), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteRtAddress.setDescription("The address portion of the route used to find the upstream\nor parent interface for this multicast forwarding entry.\n\nThis address object is only significant up to\nipMcastRouteRtPrefixLength bits.  The remaining address bits\nare set to zero.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nforwarding state applies only within the given zone.  Zone\nindex zero is not valid in this table.")
ipMcastRouteRtPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 16), InetAddressPrefixLength()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteRtPrefixLength.setDescription("The length in bits of the mask associated with the route\nused to find the upstream or parent interface for this\nmulticast forwarding entry.\n\nThe InetAddressType is given by ipMcastRouteRtAddressType.\nFor values 'ipv4' and 'ipv4z', this object must be in the\nrange 4..32.  For values 'ipv6' and 'ipv6z', this object\nmust be in the range 8..128.")
ipMcastRouteRtType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 17), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("unicast", 1), ("multicast", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteRtType.setDescription("The reason the given route was placed in the (logical)\nmulticast Routing Information Base (RIB).  A value of\nunicast means that the route would normally be placed only\nin the unicast RIB, but was placed in the multicast RIB\ndue (instead or in addition) to local configuration, such as\nwhen running PIM over RIP.  A value of multicast means that\nthe route was explicitly added to the multicast RIB by the\nrouting protocol, such as the Distance Vector Multicast\nRouting Protocol (DVMRP) or Multiprotocol BGP.")
ipMcastRouteOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 18), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteOctets.setDescription("The number of octets contained in IP datagrams that were\nreceived from these sources and addressed to this multicast\ngroup address, and which were forwarded by this router.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteTimeStamp.")
ipMcastRoutePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRoutePkts.setDescription("The number of packets routed using this multicast route\nentry.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteTimeStamp.")
ipMcastRouteTtlDropOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 20), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteTtlDropOctets.setDescription("The number of octets contained in IP datagrams that this\nrouter has received from these sources and addressed to this\nmulticast group address, which were dropped because the TTL\n(IPv4) or Hop Limit (IPv6) was decremented to zero, or to a\nvalue less than ipMcastInterfaceTtl for all next hops.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteTimeStamp.")
ipMcastRouteTtlDropPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteTtlDropPackets.setDescription("The number of packets that this router has received from\nthese sources and addressed to this multicast group address,\nwhich were dropped because the TTL (IPv4) or Hop Limit\n(IPv6) was decremented to zero, or to a value less than\nipMcastInterfaceTtl for all next hops.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteTimeStamp.")
ipMcastRouteDifferentInIfOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 22), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteDifferentInIfOctets.setDescription("The number of octets contained in IP datagrams that this\nrouter has received from these sources and addressed to this\nmulticast group address, which were dropped because they\nwere received on an unexpected interface.\n\nFor RPF checking protocols (such as PIM-SM), these packets\narrived on interfaces other than ipMcastRouteInIfIndex, and\nwere dropped because of this failed RPF check.  (RPF paths\nare 'Reverse Path Forwarding' paths; the unicast routes to\nthe expected origin of multicast data flows).\n\n\n\n\nOther protocols may drop packets on an incoming interface\ncheck for different reasons (for example, BIDIR-PIM performs\na DF check on receipt of packets).  All packets dropped as a\nresult of an incoming interface check are counted here.\n\nIf this counter increases rapidly, this indicates a problem.\nA significant quantity of multicast data is arriving at this\nrouter on unexpected interfaces, and is not being forwarded.\n\nFor guidance, if the rate of increase of this counter\nexceeds 1% of the rate of increase of ipMcastRouteOctets,\nthen there are multicast routing problems that require\ninvestigation.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteTimeStamp.")
ipMcastRouteDifferentInIfPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 23), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteDifferentInIfPackets.setDescription("The number of packets which this router has received from\nthese sources and addressed to this multicast group address,\nwhich were dropped because they were received on an\nunexpected interface.\n\nFor RPF checking protocols (such as PIM-SM), these packets\narrived on interfaces other than ipMcastRouteInIfIndex, and\nwere dropped because of this failed RPF check.  (RPF paths\nare 'Reverse Path Forwarding' path; the unicast routes to\nthe expected origin of multicast data flows).\n\nOther protocols may drop packets on an incoming interface\ncheck for different reasons (for example, BIDIR-PIM performs\na DF check on receipt of packets).  All packets dropped as a\nresult of an incoming interface check are counted here.\n\nIf this counter increases rapidly, this indicates a problem.\nA significant quantity of multicast data is arriving at this\nrouter on unexpected interfaces, and is not being forwarded.\n\nFor guidance, if the rate of increase of this counter\n\n\n\nexceeds 1% of the rate of increase of ipMcastRoutePkts, then\nthere are multicast routing problems that require\ninvestigation.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteTimeStamp.")
ipMcastRouteBps = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 5, 1, 24), CounterBasedGauge64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteBps.setDescription("Bits per second forwarded by this router using this\nmulticast routing entry.\n\nThis value is a sample; it is the number of bits forwarded\nduring the last whole 1 second sampling period.  The value\nduring the current 1 second sampling period is not made\navailable until the period is completed.\n\nThe quantity being sampled is the same as that measured by\nipMcastRouteOctets.  The units and the sampling method are\ndifferent.")
ipMcastRouteNextHopTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 6))
if mibBuilder.loadTexts: ipMcastRouteNextHopTable.setDescription("The (conceptual) table containing information on the\nnext-hops on outgoing interfaces for routing IP multicast\ndatagrams.  Each entry is one of a list of next-hops on\noutgoing interfaces for particular sources sending to a\nparticular multicast group address.")
ipMcastRouteNextHopEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 6, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastRouteNextHopGroupAddressType"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopGroup"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopGroupPrefixLength"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopSourceAddressType"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopSource"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopSourcePrefixLength"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopIfIndex"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopAddressType"), (0, "IPMCAST-MIB", "ipMcastRouteNextHopAddress"))
if mibBuilder.loadTexts: ipMcastRouteNextHopEntry.setDescription("An entry (conceptual row) in the list of next-hops on\noutgoing interfaces to which IP multicast datagrams from\nparticular sources to an IP multicast group address are\nrouted.\n\nOIDs are limited to 128 sub-identifiers, but this limit\nis not enforced by the syntax of this entry.  In practice,\nthis does not present a problem, because IP address types\nallowed by conformance statements do not exceed this limit.")
ipMcastRouteNextHopGroupAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopGroupAddressType.setDescription("A value indicating the address family of the address\n\n\n\ncontained in ipMcastRouteNextHopGroup.  Legal values\ncorrespond to the subset of address families for which\nmulticast forwarding is supported.")
ipMcastRouteNextHopGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopGroup.setDescription("The IP multicast group address which, when combined with\nthe corresponding value specified in\nipMcastRouteNextHopGroupPrefixLength, identifies the groups\nfor which this entry contains multicast forwarding\ninformation.\n\nThis address object is only significant up to\nipMcastRouteNextHopGroupPrefixLength bits.  The remaining\naddress bits are set to zero.  This is especially important\nfor this index field, which is part of the index of this\nentry.  Any non-zero bits would signify an entirely\ndifferent entry.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nforwarding state applies only within the given zone.  Zone\nindex zero is not valid in this table.")
ipMcastRouteNextHopGroupPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 3), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopGroupPrefixLength.setDescription("The length in bits of the mask which, when combined with\nthe corresponding value of ipMcastRouteGroup, identifies the\ngroups for which this entry contains multicast routing\ninformation.\n\nThe InetAddressType is given by\nipMcastRouteNextHopGroupAddressType.  For values 'ipv4' and\n'ipv4z', this object must be in the range 4..32.  For values\n'ipv6' and 'ipv6z', this object must be in the range\n8..128.")
ipMcastRouteNextHopSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 4), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopSourceAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastRouteNextHopSource.\n\nA value of unknown(0) indicates a non-source-specific entry,\ncorresponding to all sources in the group.  Otherwise, the\nvalue MUST be the same as the value of\nipMcastRouteNextHopGroupType.")
ipMcastRouteNextHopSource = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 5), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopSource.setDescription("The network address which, when combined with the\ncorresponding value of the mask specified in\nipMcastRouteNextHopSourcePrefixLength, identifies the\nsources for which this entry specifies a next-hop on an\noutgoing interface.\n\nThis address object is only significant up to\nipMcastRouteNextHopSourcePrefixLength bits.  The remaining\naddress bits are set to zero.  This is especially important\nfor this index field, which is part of the index of this\nentry.  Any non-zero bits would signify an entirely\ndifferent entry.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nsource address applies only within the given zone.  Zone\nindex zero is not valid in this table.")
ipMcastRouteNextHopSourcePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 6), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopSourcePrefixLength.setDescription("The length in bits of the mask which, when combined with\nthe corresponding value specified in\nipMcastRouteNextHopSource, identifies the sources for which\nthis entry specifies a next-hop on an outgoing interface.\n\n\n\n\nThe InetAddressType is given by\nipMcastRouteNextHopSourceAddressType.  For the value\n'unknown', this object must be zero.  For values 'ipv4' and\n'ipv4z', this object must be in the range 4..32.  For values\n'ipv6' and 'ipv6z', this object must be in the range\n8..128.")
ipMcastRouteNextHopIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 7), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopIfIndex.setDescription("The ifIndex value of the interface for the outgoing\ninterface for this next-hop.")
ipMcastRouteNextHopAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 8), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastRouteNextHopAddress.")
ipMcastRouteNextHopAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 9), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastRouteNextHopAddress.setDescription("The address of the next-hop specific to this entry.  For\nmost interfaces, this is identical to\nipMcastRouteNextHopGroup.  Non-Broadcast Multi-Access\n(NBMA) interfaces, however, may\nhave multiple next-hop addresses out a single outgoing\ninterface.")
ipMcastRouteNextHopState = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("pruned", 1), ("forwarding", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopState.setDescription("An indication of whether the outgoing interface and next-\nhop represented by this entry is currently being used to\nforward IP datagrams.  The value 'forwarding' indicates it\nis currently being used; the value 'pruned' indicates it is\n\n\n\nnot.")
ipMcastRouteNextHopTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopTimeStamp.setDescription("The value of sysUpTime at which the multicast routing\ninformation represented by this entry was learned by the\nrouter.\n\nIf this information was present at the most recent re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
ipMcastRouteNextHopExpiryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 12), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopExpiryTime.setDescription("The minimum amount of time remaining before this entry will\nbe aged out.  If ipMcastRouteNextHopState is pruned(1), the\nremaining time until the prune expires and the state reverts\nto forwarding(2).  Otherwise, the remaining time until this\nentry is removed from the table.  The time remaining may be\ncopied from ipMcastRouteExpiryTime if the protocol in use\nfor this entry does not specify next-hop timers.  The value\n0 indicates that the entry is not subject to aging.")
ipMcastRouteNextHopClosestMemberHops = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 13), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopClosestMemberHops.setDescription("The minimum number of hops between this router and any\nmember of this IP multicast group reached via this next-hop\non this outgoing interface.  Any IP multicast datagrams for\nthe group that have a TTL (IPv4) or Hop Count (IPv6) less\nthan this number of hops will not be forwarded to this\nnext-hop.\n\nA value of 0 means all multicast datagrams are forwarded out\nthe interface.  A value of 256 means that no multicast\ndatagrams are forwarded out the interface.\n\n\n\n\nThis is an optimization applied by multicast routing\nprotocols that explicitly track hop counts to downstream\nlisteners.  Multicast protocols that are not aware of hop\ncounts to downstream listeners set this object to 0.")
ipMcastRouteNextHopProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 14), IANAipMRouteProtocol()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopProtocol.setDescription("The routing mechanism via which this next-hop was learned.")
ipMcastRouteNextHopOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 15), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopOctets.setDescription("The number of octets of multicast packets that have been\nforwarded using this route.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteNextHopTimeStamp.")
ipMcastRouteNextHopPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 6, 1, 16), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastRouteNextHopPkts.setDescription("The number of packets which have been forwarded using this\nroute.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of routes being\nremoved and replaced, which can be detected by observing\nthe value of ipMcastRouteNextHopTimeStamp.")
ipMcastBoundaryTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 7))
if mibBuilder.loadTexts: ipMcastBoundaryTable.setDescription("The (conceptual) table listing the system's multicast scope\nzone boundaries.")
ipMcastBoundaryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 7, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastBoundaryIfIndex"), (0, "IPMCAST-MIB", "ipMcastBoundaryAddressType"), (0, "IPMCAST-MIB", "ipMcastBoundaryAddress"), (0, "IPMCAST-MIB", "ipMcastBoundaryAddressPrefixLength"))
if mibBuilder.loadTexts: ipMcastBoundaryEntry.setDescription("An entry (conceptual row) describing one of this device's\nmulticast scope zone boundaries.\n\nOIDs are limited to 128 sub-identifiers, but this limit\nis not enforced by the syntax of this entry.  In practice,\nthis does not present a problem, because IP address types\nallowed by conformance statements do not exceed this limit.")
ipMcastBoundaryIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastBoundaryIfIndex.setDescription("The IfIndex value for the interface to which this boundary\napplies.  Packets with a destination address in the\n\n\n\nassociated address/mask range will not be forwarded over\nthis interface.\n\nFor IPv4, zone boundaries cut through links.  Therefore,\nthis is an external interface.  This may be either a\nphysical or virtual interface (tunnel, encapsulation, and\nso forth.)\n\nFor IPv6, zone boundaries cut through nodes.  Therefore,\nthis is a virtual interface within the node.  This is not\nan external interface, either real or virtual.  Packets\ncrossing this interface neither arrive at nor leave the\nnode, but only move between zones within the node.")
ipMcastBoundaryAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 2), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastBoundaryAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastBoundaryAddress.  Legal values\ncorrespond to the subset of address families for which\nmulticast forwarding is supported.")
ipMcastBoundaryAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 3), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastBoundaryAddress.setDescription("The group address which, when combined with the\ncorresponding value of ipMcastBoundaryAddressPrefixLength,\nidentifies the group range for which the scoped boundary\nexists.  Scoped IPv4 multicast address ranges must be\nprefixed by 239.0.0.0/8.  Scoped IPv6 multicast address\nranges are FF0x::/16, where x is a valid RFC 4291 multicast\nscope.\n\nAn IPv6 address prefixed by FF1x::/16 is a non-permanently-\nassigned address.  An IPv6 address prefixed by FF3x::/16 is\na unicast-prefix-based multicast addresses.  A zone boundary\nfor FF0x::/16 implies an identical boundary for these other\nprefixes.  No separate FF1x::/16 or FF3x::/16 entries exist\nin this table.\n\nThis address object is only significant up to\n\n\n\nipMcastBoundaryAddressPrefixLength bits.  The remaining\naddress bits are set to zero.  This is especially important\nfor this index field, which is part of the index of this\nentry.  Any non-zero bits would signify an entirely\ndifferent entry.")
ipMcastBoundaryAddressPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 4), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastBoundaryAddressPrefixLength.setDescription("The length in bits of the mask which when, combined with\nthe corresponding value of ipMcastBoundaryAddress,\nidentifies the group range for which the scoped boundary\nexists.\n\nThe InetAddressType is given by ipMcastBoundaryAddressType.\nFor values 'ipv4' and 'ipv4z', this object must be in the\nrange 4..32.  For values 'ipv6' and 'ipv6z', this object\nmust be set to 16.")
ipMcastBoundaryTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastBoundaryTimeStamp.setDescription("The value of sysUpTime at which the multicast boundary\ninformation represented by this entry was learned by the\nrouter.\n\nIf this information was present at the most recent re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
ipMcastBoundaryDroppedMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastBoundaryDroppedMcastOctets.setDescription("The number of octets of multicast packets that have been\ndropped as a result of this zone boundary configuration.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of boundary\n\n\n\nconfiguration being removed and replaced, which can be\ndetected by observing the value of\nipMcastBoundaryTimeStamp.")
ipMcastBoundaryDroppedMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastBoundaryDroppedMcastPkts.setDescription("The number of multicast packets that have been dropped as a\nresult of this zone boundary configuration.\n\nDiscontinuities in this monotonically increasing value\noccur at re-initialization of the management system.\nDiscontinuities can also occur as a result of boundary\nconfiguration being removed and replaced, which can be\ndetected by observing the value of\nipMcastBoundaryTimeStamp.")
ipMcastBoundaryStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastBoundaryStatus.setDescription("The status of this row, by which rows in this table can\nbe created and destroyed.\n\nThis status object can be set to active(1) without setting\nany other columnar objects in this entry.\n\nAll writeable objects in this entry can be modified when the\nstatus of this entry is active(1).")
ipMcastBoundaryStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 7, 1, 9), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastBoundaryStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
ipMcastScopeNameTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 8))
if mibBuilder.loadTexts: ipMcastScopeNameTable.setDescription("The (conceptual) table listing multicast scope names.")
ipMcastScopeNameEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 8, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastScopeNameAddressType"), (0, "IPMCAST-MIB", "ipMcastScopeNameAddress"), (0, "IPMCAST-MIB", "ipMcastScopeNameAddressPrefixLength"), (0, "IPMCAST-MIB", "ipMcastScopeNameLanguage"))
if mibBuilder.loadTexts: ipMcastScopeNameEntry.setDescription("An entry (conceptual row) that names a multicast address\nscope.\n\nOIDs are limited to 128 sub-identifiers, but this limit\nis not enforced by the syntax of this entry.  In practice,\nthis does not present a problem, because IP address types\nallowed by conformance statements do not exceed this limit.")
ipMcastScopeNameAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastScopeNameAddressType.setDescription("A value indicating the address family of the address\n\n\n\ncontained in ipMcastScopeNameAddress.  Legal values\ncorrespond to the subset of address families for which\nmulticast forwarding is supported.")
ipMcastScopeNameAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastScopeNameAddress.setDescription("The group address which, when combined with the\ncorresponding value of ipMcastScopeNameAddressPrefixLength,\nidentifies the group range associated with the multicast\nscope.  Scoped IPv4 multicast address ranges must be\nprefixed by 239.0.0.0/8.  Scoped IPv6 multicast address\nranges are FF0x::/16, where x is a valid RFC 4291 multicast\nscope.\n\nAn IPv6 address prefixed by FF1x::/16 is a non-permanently-\nassigned address.  An IPv6 address prefixed by FF3x::/16 is\na unicast-prefix-based multicast addresses.  A scope\nFF0x::/16 implies an identical scope name for these other\nprefixes.  No separate FF1x::/16 or FF3x::/16 entries exist\nin this table.\n\nThis address object is only significant up to\nipMcastScopeNameAddressPrefixLength bits.  The remaining\naddress bits are set to zero.  This is especially important\nfor this index field, which is part of the index of this\nentry.  Any non-zero bits would signify an entirely\ndifferent entry.")
ipMcastScopeNameAddressPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 3), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastScopeNameAddressPrefixLength.setDescription("The length in bits of the mask which, when combined with\nthe corresponding value of ipMcastScopeNameAddress,\nidentifies the group range associated with the multicast\nscope.\n\nThe InetAddressType is given by ipMcastScopeNameAddressType.\nFor values 'ipv4' and 'ipv4z', this object must be in the\nrange 4..32.  For values 'ipv6' and 'ipv6z', this object\nmust be set to 16.")
ipMcastScopeNameLanguage = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 4), LangTag()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastScopeNameLanguage.setDescription("Language tag associated with the scope name.")
ipMcastScopeNameString = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 5), SnmpAdminString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastScopeNameString.setDescription("The textual name associated with the multicast scope.  The\nvalue of this object should be suitable for displaying to\nend-users, such as when allocating a multicast address in\nthis scope.\n\nWhen no name is specified, the default value of this object\nfor IPv4 should be the string 239.x.x.x/y with x and y\nreplaced with decimal values to describe the address and\nmask length associated with the scope.\n\nWhen no name is specified, the default value of this object\nfor IPv6 should be the string FF0x::/16, with x replaced by\nthe hexadecimal value for the RFC 4291 multicast scope.\n\nAn IPv6 address prefixed by FF1x::/16 is a non-permanently-\nassigned address.  An IPv6 address prefixed by FF3x::/16 is\na unicast-prefix-based multicast addresses.  A scope\nFF0x::/16 implies an identical scope name for these other\nprefixes.  No separate FF1x::/16 or FF3x::/16 entries exist\nin this table.")
ipMcastScopeNameDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastScopeNameDefault.setDescription("If true, indicates a preference that the name in the\nfollowing language should be used by applications if no name\nis available in a desired language.")
ipMcastScopeNameStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastScopeNameStatus.setDescription("The status of this row, by which rows in this table can\nbe created and destroyed.  Before the row can be activated,\nthe object ipMcastScopeNameString must be set to a valid\nvalue.  All writeable objects in this entry can be modified\nwhen the status is active(1).")
ipMcastScopeNameStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 8, 1, 8), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipMcastScopeNameStorageType.setDescription("The storage type for this row.  Rows having the value\n'permanent' need not allow write-access to any columnar\nobjects in the row.")
ipMcastLocalListenerTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 9))
if mibBuilder.loadTexts: ipMcastLocalListenerTable.setDescription("The (conceptual) table listing local applications or\nservices that have joined multicast groups as listeners.\n\nEntries exist for all addresses in the multicast range for\nall applications and services as they are classified on this\ndevice.")
ipMcastLocalListenerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 9, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastLocalListenerGroupAddressType"), (0, "IPMCAST-MIB", "ipMcastLocalListenerGroupAddress"), (0, "IPMCAST-MIB", "ipMcastLocalListenerSourceAddressType"), (0, "IPMCAST-MIB", "ipMcastLocalListenerSourceAddress"), (0, "IPMCAST-MIB", "ipMcastLocalListenerSourcePrefixLength"), (0, "IPMCAST-MIB", "ipMcastLocalListenerIfIndex"), (0, "IPMCAST-MIB", "ipMcastLocalListenerRunIndex"))
if mibBuilder.loadTexts: ipMcastLocalListenerEntry.setDescription("An entry (conceptual row) identifying a local application\nor service that has joined a multicast group as a listener.\n\n\n\n\nOIDs are limited to 128 sub-identifiers, but this limit\nis not enforced by the syntax of this entry.  In practice,\nthis does not present a problem, because IP address types\nallowed by conformance statements do not exceed this limit.")
ipMcastLocalListenerGroupAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastLocalListenerGroupAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastLocalListenerGroupAddress.  Legal values\ncorrespond to the subset of address families for which\nmulticast is supported.")
ipMcastLocalListenerGroupAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastLocalListenerGroupAddress.setDescription("The IP multicast group for which this entry specifies\nlocally joined applications or services.")
ipMcastLocalListenerSourceAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 3), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastLocalListenerSourceAddressType.setDescription("A value indicating the address family of the address\ncontained in ipMcastLocalListenerSource.\n\nA value of unknown(0) indicates a non-source-specific entry,\ncorresponding to all sources in the group.  Otherwise, the\nvalue MUST be the same as the value of\nipMcastLocalListenerGroupAddressType.")
ipMcastLocalListenerSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 4), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastLocalListenerSourceAddress.setDescription("The network address which, when combined with the\ncorresponding value of the mask specified in\nipMcastLocalListenerSourcePrefixLength, identifies the\nsources for which this entry specifies a local listener.\n\nThis address object is only significant up to\nipMcastLocalListenerSourcePrefixLength bits.  The remaining\naddress bits are set to zero.  This is especially important\nfor this index field, which is part of the index of this\nentry.  Any non-zero bits would signify an entirely\ndifferent entry.\n\nFor addresses of type ipv4z or ipv6z, the appended zone\nindex is significant even though it lies beyond the prefix\nlength.  The use of these address types indicate that this\nlistener address applies only within the given zone.  Zone\nindex zero is not valid in this table.")
ipMcastLocalListenerSourcePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 5), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastLocalListenerSourcePrefixLength.setDescription("The length in bits of the mask which, when combined with\nthe corresponding value specified in\nipMcastLocalListenerSource, identifies the sources for which\nthis entry specifies a local listener.\n\nThe InetAddressType is given by\nipMcastLocalListenerSourceAddressType.  For the value\n'unknown', this object must be zero.  For values 'ipv4' and\n'ipv4z', this object must be in the range 4..32.  For values\n'ipv6' and 'ipv6z', this object must be in the range\n\n\n\n8..128.")
ipMcastLocalListenerIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 6), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastLocalListenerIfIndex.setDescription("The IfIndex value of the interface for which this entry\nspecifies a local listener.")
ipMcastLocalListenerRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 9, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastLocalListenerRunIndex.setDescription("A unique value corresponding to a piece of software running\non this router or host system.  Where possible, this should\nbe the system's native, unique identification number.\n\nThis identifier is platform-specific.  It may correspond to\na process ID or application instance number.\n\nA value of zero indicates that the application instance(s)\ncannot be identified.  A value of zero indicates that one or\nmore unidentified applications have joined the specified\nmulticast groups (for the specified sources) as listeners.")
ipMcastZoneTable = MibTable((1, 3, 6, 1, 2, 1, 168, 1, 10))
if mibBuilder.loadTexts: ipMcastZoneTable.setDescription("The (conceptual) table listing scope zones on this device.")
ipMcastZoneEntry = MibTableRow((1, 3, 6, 1, 2, 1, 168, 1, 10, 1)).setIndexNames((0, "IPMCAST-MIB", "ipMcastZoneIndex"))
if mibBuilder.loadTexts: ipMcastZoneEntry.setDescription("An entry (conceptual row) describing a scope zone on this\ndevice.")
ipMcastZoneIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 10, 1, 1), InetZoneIndex().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipMcastZoneIndex.setDescription("This zone index uniquely identifies a zone on a device.\n\nEach zone is for a given scope.  Scope-level information in\nthis table is for the unique scope that corresponds to this\nzone.\n\nZero is a special value used to request the default zone for\na given scope.  Zero is not a valid value for this object.\n\nTo test whether ipMcastZoneIndex is the default zone for\nthis scope, test whether ipMcastZoneIndex is equal to\nipMcastZoneScopeDefaultZoneIndex.")
ipMcastZoneScopeDefaultZoneIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 10, 1, 2), InetZoneIndex().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastZoneScopeDefaultZoneIndex.setDescription("The default zone index for this scope.  This is the zone\nthat this device will use if the default (zero) zone is\nrequested for this scope.\n\nZero is not a valid value for this object.")
ipMcastZoneScopeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 10, 1, 3), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastZoneScopeAddressType.setDescription("The IP address type for which this scope zone exists.")
ipMcastZoneScopeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 10, 1, 4), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastZoneScopeAddress.setDescription("The multicast group address which, when combined with\nipMcastZoneScopeAddressPrefixLength, gives the multicast\naddress range for this scope.  The InetAddressType is given\nby ipMcastZoneScopeAddressType.\n\nScoped IPv4 multicast address ranges are prefixed by\n239.0.0.0/8.  Scoped IPv6 multicast address ranges are\nFF0x::/16, where x is a valid RFC 4291 multicast scope.\n\nAn IPv6 address prefixed by FF1x::/16 is a non-permanently-\nassigned address.  An IPv6 address prefixed by FF3x::/16 is\na unicast-prefix-based multicast addresses.  A scope\nFF0x::/16 implies an identical scope for these other\nprefixes.  No separate FF1x::/16 or FF3x::/16 entries exist\nin this table.\n\nThis address object is only significant up to\nipMcastZoneScopeAddressPrefixLength bits.  The remaining\naddress bits are set to zero.")
ipMcastZoneScopeAddressPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 168, 1, 10, 1, 5), InetAddressPrefixLength()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipMcastZoneScopeAddressPrefixLength.setDescription("The length in bits of the mask which, when combined\nwith ipMcastZoneScopeAddress, gives the multicast address\nprefix for this scope.\n\nThe InetAddressType is given by ipMcastZoneScopeAddressType.\nFor values 'ipv4' and 'ipv4z', this object must be in the\nrange 4..32.  For values 'ipv6' and 'ipv6z', this object\nmust be set to 16.")
ipMcastDeviceConfigStorageType = MibScalar((1, 3, 6, 1, 2, 1, 168, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipMcastDeviceConfigStorageType.setDescription("The storage type used for the global IP multicast\nconfiguration of this device, comprised of the objects\nlisted below.  If this storage type takes the value\n'permanent', write-access to the listed objects need not be\nallowed.\n\nThe objects described by this storage type are:\nipMcastEnabled.")
ipMcastMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 168, 2))
ipMcastMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 168, 2, 1))
ipMcastMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 168, 2, 2))

# Augmentions

# Groups

ipMcastMIBBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 1)).setObjects(("IPMCAST-MIB", "ipMcastDeviceConfigStorageType"), ("IPMCAST-MIB", "ipMcastEnabled"), ("IPMCAST-MIB", "ipMcastRouteEntryCount"), )
if mibBuilder.loadTexts: ipMcastMIBBasicGroup.setDescription("A collection of objects to support basic management of IP\nMulticast protocols.")
ipMcastMIBSsmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 2)).setObjects(("IPMCAST-MIB", "ipMcastSsmRangeRowStatus"), ("IPMCAST-MIB", "ipMcastSsmRangeStorageType"), )
if mibBuilder.loadTexts: ipMcastMIBSsmGroup.setDescription("A collection of objects to support management of Source-\nSpecific Multicast routing.")
ipMcastMIBRouteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 3)).setObjects(("IPMCAST-MIB", "ipMcastRouteUpstreamNeighborType"), ("IPMCAST-MIB", "ipMcastRouteNextHopState"), ("IPMCAST-MIB", "ipMcastRouteInIfIndex"), ("IPMCAST-MIB", "ipMcastRouteNextHopExpiryTime"), ("IPMCAST-MIB", "ipMcastRouteNextHopTimeStamp"), ("IPMCAST-MIB", "ipMcastRouteExpiryTime"), ("IPMCAST-MIB", "ipMcastInterfaceStorageType"), ("IPMCAST-MIB", "ipMcastRouteTimeStamp"), ("IPMCAST-MIB", "ipMcastInterfaceRateLimit"), ("IPMCAST-MIB", "ipMcastInterfaceTtl"), ("IPMCAST-MIB", "ipMcastRouteUpstreamNeighbor"), )
if mibBuilder.loadTexts: ipMcastMIBRouteGroup.setDescription("A collection of objects to support basic management of IP\nMulticast routing.")
ipMcastMIBRouteDiagnosticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 4)).setObjects(("IPMCAST-MIB", "ipMcastRouteTtlDropPackets"), ("IPMCAST-MIB", "ipMcastRouteDifferentInIfPackets"), ("IPMCAST-MIB", "ipMcastRoutePkts"), )
if mibBuilder.loadTexts: ipMcastMIBRouteDiagnosticsGroup.setDescription("A collection of routing diagnostic packet counters.")
ipMcastMIBPktsOutGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 5)).setObjects(("IPMCAST-MIB", "ipMcastRouteNextHopTimeStamp"), ("IPMCAST-MIB", "ipMcastRouteNextHopPkts"), )
if mibBuilder.loadTexts: ipMcastMIBPktsOutGroup.setDescription("A collection of objects to support management of packet\ncounters for each outgoing interface entry of a route.")
ipMcastMIBHopCountGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 6)).setObjects(("IPMCAST-MIB", "ipMcastRouteNextHopClosestMemberHops"), )
if mibBuilder.loadTexts: ipMcastMIBHopCountGroup.setDescription("A collection of objects to support management of the use of\nhop counts in IP Multicast routing.")
ipMcastMIBRouteOctetsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 7)).setObjects(("IPMCAST-MIB", "ipMcastRouteOctets"), ("IPMCAST-MIB", "ipMcastRouteDifferentInIfOctets"), ("IPMCAST-MIB", "ipMcastRouteTimeStamp"), ("IPMCAST-MIB", "ipMcastRouteNextHopOctets"), ("IPMCAST-MIB", "ipMcastRouteNextHopTimeStamp"), ("IPMCAST-MIB", "ipMcastRouteTtlDropOctets"), )
if mibBuilder.loadTexts: ipMcastMIBRouteOctetsGroup.setDescription("A collection of objects to support management of octet\ncounters for each forwarding entry.")
ipMcastMIBRouteBpsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 8)).setObjects(("IPMCAST-MIB", "ipMcastRouteBps"), )
if mibBuilder.loadTexts: ipMcastMIBRouteBpsGroup.setDescription("A collection of objects to support sampling of data rate\nin bits per second for each forwarding entry.")
ipMcastMIBRouteProtoGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 9)).setObjects(("IPMCAST-MIB", "ipMcastRouteRtProtocol"), ("IPMCAST-MIB", "ipMcastRouteRtAddress"), ("IPMCAST-MIB", "ipMcastRouteRtPrefixLength"), ("IPMCAST-MIB", "ipMcastRouteProtocol"), ("IPMCAST-MIB", "ipMcastRouteRtType"), ("IPMCAST-MIB", "ipMcastRouteNextHopProtocol"), ("IPMCAST-MIB", "ipMcastRouteRtAddressType"), )
if mibBuilder.loadTexts: ipMcastMIBRouteProtoGroup.setDescription("A collection of objects providing information on the\nrelationship between multicast routing information and the\nIP Forwarding Table.")
ipMcastMIBLocalListenerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 10)).setObjects(("IPMCAST-MIB", "ipMcastLocalListenerRunIndex"), )
if mibBuilder.loadTexts: ipMcastMIBLocalListenerGroup.setDescription("A collection of objects to support management of local\nlisteners on hosts or routers.")
ipMcastMIBBoundaryIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 11)).setObjects(("IPMCAST-MIB", "ipMcastBoundaryStorageType"), ("IPMCAST-MIB", "ipMcastBoundaryTimeStamp"), ("IPMCAST-MIB", "ipMcastBoundaryDroppedMcastOctets"), ("IPMCAST-MIB", "ipMcastZoneScopeDefaultZoneIndex"), ("IPMCAST-MIB", "ipMcastBoundaryStatus"), ("IPMCAST-MIB", "ipMcastZoneScopeAddress"), ("IPMCAST-MIB", "ipMcastZoneScopeAddressType"), ("IPMCAST-MIB", "ipMcastBoundaryDroppedMcastPkts"), ("IPMCAST-MIB", "ipMcastZoneScopeAddressPrefixLength"), )
if mibBuilder.loadTexts: ipMcastMIBBoundaryIfGroup.setDescription("A collection of objects to support management of multicast\nscope zone boundaries.")
ipMcastMIBScopeNameGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 168, 2, 2, 12)).setObjects(("IPMCAST-MIB", "ipMcastScopeNameDefault"), ("IPMCAST-MIB", "ipMcastScopeNameStatus"), ("IPMCAST-MIB", "ipMcastScopeNameStorageType"), ("IPMCAST-MIB", "ipMcastScopeNameString"), )
if mibBuilder.loadTexts: ipMcastMIBScopeNameGroup.setDescription("A collection of objects to support management of multicast\naddress scope names.")

# Compliances

ipMcastMIBComplianceHost = ModuleCompliance((1, 3, 6, 1, 2, 1, 168, 2, 1, 1)).setObjects(("IPMCAST-MIB", "ipMcastMIBBasicGroup"), ("IPMCAST-MIB", "ipMcastMIBScopeNameGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteDiagnosticsGroup"), ("IPMCAST-MIB", "ipMcastMIBSsmGroup"), ("IPMCAST-MIB", "ipMcastMIBBoundaryIfGroup"), ("IPMCAST-MIB", "ipMcastMIBLocalListenerGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteGroup"), )
if mibBuilder.loadTexts: ipMcastMIBComplianceHost.setDescription("The compliance statement for hosts supporting IPMCAST-MIB.\n\nSupport for either InetAddressType ipv4 or ipv6 is\nmandatory; support for both InetAddressTypes ipv4 and ipv6\nis optional.  Support for types ipv4z and ipv6z is\noptional.\n\n-- OBJECT     ipMcastLocalListenerGroupAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastLocalListenerGroupAddress\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastLocalListenerSourceAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastLocalListenerSourceAddress\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.")
ipMcastMIBComplianceRouter = ModuleCompliance((1, 3, 6, 1, 2, 1, 168, 2, 1, 2)).setObjects(("IPMCAST-MIB", "ipMcastMIBRouteProtoGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteOctetsGroup"), ("IPMCAST-MIB", "ipMcastMIBPktsOutGroup"), ("IPMCAST-MIB", "ipMcastMIBLocalListenerGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteBpsGroup"), ("IPMCAST-MIB", "ipMcastMIBBasicGroup"), ("IPMCAST-MIB", "ipMcastMIBScopeNameGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteDiagnosticsGroup"), ("IPMCAST-MIB", "ipMcastMIBHopCountGroup"), ("IPMCAST-MIB", "ipMcastMIBSsmGroup"), ("IPMCAST-MIB", "ipMcastMIBBoundaryIfGroup"), )
if mibBuilder.loadTexts: ipMcastMIBComplianceRouter.setDescription("The compliance statement for routers supporting\nIPMCAST-MIB.\n\nSupport for either InetAddressType ipv4 or ipv6 is\nmandatory; support for both InetAddressTypes ipv4 and ipv6\nis optional.  Support for types ipv4z and ipv6z is\noptional.\n\n-- OBJECT     ipMcastSsmRangeAddressType\n-- SYNTAX     InetAddressType {ipv4(1), ipv6(2), ipv4z(3),\n--                             ipv6z(4)}\n\n\n\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastSsmRangeAddress\n-- SYNTAX     InetAddress (SIZE (4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteGroupAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteGroup\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteSourceAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteSource\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteNextHopGroupAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteNextHopGroup\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteNextHopSourceAddressType\n\n\n\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                              ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteNextHopSource\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteNextHopAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteNextHopAddress\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.")
ipMcastMIBComplianceBorderRouter = ModuleCompliance((1, 3, 6, 1, 2, 1, 168, 2, 1, 3)).setObjects(("IPMCAST-MIB", "ipMcastMIBRouteProtoGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteOctetsGroup"), ("IPMCAST-MIB", "ipMcastMIBPktsOutGroup"), ("IPMCAST-MIB", "ipMcastMIBLocalListenerGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteBpsGroup"), ("IPMCAST-MIB", "ipMcastMIBBasicGroup"), ("IPMCAST-MIB", "ipMcastMIBScopeNameGroup"), ("IPMCAST-MIB", "ipMcastMIBRouteDiagnosticsGroup"), ("IPMCAST-MIB", "ipMcastMIBHopCountGroup"), ("IPMCAST-MIB", "ipMcastMIBSsmGroup"), ("IPMCAST-MIB", "ipMcastMIBBoundaryIfGroup"), )
if mibBuilder.loadTexts: ipMcastMIBComplianceBorderRouter.setDescription("The compliance statement for routers on scope\nboundaries supporting IPMCAST-MIB.\n\nSupport for either InetAddressType ipv4z or ipv6z is\nmandatory; support for both InetAddressTypes ipv4z and\nipv6z is optional.\n\n-- OBJECT     ipMcastSsmRangeAddressType\n-- SYNTAX     InetAddressType {ipv4(1), ipv6(2), ipv4z(3),\n--                             ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastSsmRangeAddress\n-- SYNTAX     InetAddress (SIZE (4|8|16|20))\n\n\n\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteGroupAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 or ipv6.\n--\n-- OBJECT     ipMcastRouteGroup\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteSourceAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteSource\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteNextHopGroupAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteNextHopGroup\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteNextHopSourceAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n\n\n\n--\n-- OBJECT     ipMcastRouteNextHopSource\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteNextHopAddressType\n-- SYNTAX     InetAddressType {unknown(0), ipv4(1), ipv6(2),\n--                             ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastRouteNextHopAddress\n-- SYNTAX     InetAddress (SIZE (0|4|8|16|20))\n-- DESCRIPTION\n--     This compliance requires support for unknown and\n--     either ipv4 and ipv4z or ipv6 and ipv6z.\n--\n-- OBJECT     ipMcastBoundaryAddressType\n-- SYNTAX     InetAddressType {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastBoundaryAddress\n-- SYNTAX     InetAddress (SIZE (4|16)\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastScopeNameAddressType\n-- SYNTAX     InetAddressType {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.\n--\n-- OBJECT     ipMcastScopeNameAddress\n-- SYNTAX     InetAddress (SIZE (4|16)\n-- DESCRIPTION\n--     This compliance requires support for ipv4 or ipv6.")

# Exports

# Module identity
mibBuilder.exportSymbols("IPMCAST-MIB", PYSNMP_MODULE_ID=ipMcastMIB)

# Objects
mibBuilder.exportSymbols("IPMCAST-MIB", ipMcastMIB=ipMcastMIB, ipMcast=ipMcast, ipMcastEnabled=ipMcastEnabled, ipMcastRouteEntryCount=ipMcastRouteEntryCount, ipMcastInterfaceTable=ipMcastInterfaceTable, ipMcastInterfaceEntry=ipMcastInterfaceEntry, ipMcastInterfaceIPVersion=ipMcastInterfaceIPVersion, ipMcastInterfaceIfIndex=ipMcastInterfaceIfIndex, ipMcastInterfaceTtl=ipMcastInterfaceTtl, ipMcastInterfaceRateLimit=ipMcastInterfaceRateLimit, ipMcastInterfaceStorageType=ipMcastInterfaceStorageType, ipMcastSsmRangeTable=ipMcastSsmRangeTable, ipMcastSsmRangeEntry=ipMcastSsmRangeEntry, ipMcastSsmRangeAddressType=ipMcastSsmRangeAddressType, ipMcastSsmRangeAddress=ipMcastSsmRangeAddress, ipMcastSsmRangePrefixLength=ipMcastSsmRangePrefixLength, ipMcastSsmRangeRowStatus=ipMcastSsmRangeRowStatus, ipMcastSsmRangeStorageType=ipMcastSsmRangeStorageType, ipMcastRouteTable=ipMcastRouteTable, ipMcastRouteEntry=ipMcastRouteEntry, ipMcastRouteGroupAddressType=ipMcastRouteGroupAddressType, ipMcastRouteGroup=ipMcastRouteGroup, ipMcastRouteGroupPrefixLength=ipMcastRouteGroupPrefixLength, ipMcastRouteSourceAddressType=ipMcastRouteSourceAddressType, ipMcastRouteSource=ipMcastRouteSource, ipMcastRouteSourcePrefixLength=ipMcastRouteSourcePrefixLength, ipMcastRouteUpstreamNeighborType=ipMcastRouteUpstreamNeighborType, ipMcastRouteUpstreamNeighbor=ipMcastRouteUpstreamNeighbor, ipMcastRouteInIfIndex=ipMcastRouteInIfIndex, ipMcastRouteTimeStamp=ipMcastRouteTimeStamp, ipMcastRouteExpiryTime=ipMcastRouteExpiryTime, ipMcastRouteProtocol=ipMcastRouteProtocol, ipMcastRouteRtProtocol=ipMcastRouteRtProtocol, ipMcastRouteRtAddressType=ipMcastRouteRtAddressType, ipMcastRouteRtAddress=ipMcastRouteRtAddress, ipMcastRouteRtPrefixLength=ipMcastRouteRtPrefixLength, ipMcastRouteRtType=ipMcastRouteRtType, ipMcastRouteOctets=ipMcastRouteOctets, ipMcastRoutePkts=ipMcastRoutePkts, ipMcastRouteTtlDropOctets=ipMcastRouteTtlDropOctets, ipMcastRouteTtlDropPackets=ipMcastRouteTtlDropPackets, ipMcastRouteDifferentInIfOctets=ipMcastRouteDifferentInIfOctets, ipMcastRouteDifferentInIfPackets=ipMcastRouteDifferentInIfPackets, ipMcastRouteBps=ipMcastRouteBps, ipMcastRouteNextHopTable=ipMcastRouteNextHopTable, ipMcastRouteNextHopEntry=ipMcastRouteNextHopEntry, ipMcastRouteNextHopGroupAddressType=ipMcastRouteNextHopGroupAddressType, ipMcastRouteNextHopGroup=ipMcastRouteNextHopGroup, ipMcastRouteNextHopGroupPrefixLength=ipMcastRouteNextHopGroupPrefixLength, ipMcastRouteNextHopSourceAddressType=ipMcastRouteNextHopSourceAddressType, ipMcastRouteNextHopSource=ipMcastRouteNextHopSource, ipMcastRouteNextHopSourcePrefixLength=ipMcastRouteNextHopSourcePrefixLength, ipMcastRouteNextHopIfIndex=ipMcastRouteNextHopIfIndex, ipMcastRouteNextHopAddressType=ipMcastRouteNextHopAddressType, ipMcastRouteNextHopAddress=ipMcastRouteNextHopAddress, ipMcastRouteNextHopState=ipMcastRouteNextHopState, ipMcastRouteNextHopTimeStamp=ipMcastRouteNextHopTimeStamp, ipMcastRouteNextHopExpiryTime=ipMcastRouteNextHopExpiryTime, ipMcastRouteNextHopClosestMemberHops=ipMcastRouteNextHopClosestMemberHops, ipMcastRouteNextHopProtocol=ipMcastRouteNextHopProtocol, ipMcastRouteNextHopOctets=ipMcastRouteNextHopOctets, ipMcastRouteNextHopPkts=ipMcastRouteNextHopPkts, ipMcastBoundaryTable=ipMcastBoundaryTable, ipMcastBoundaryEntry=ipMcastBoundaryEntry, ipMcastBoundaryIfIndex=ipMcastBoundaryIfIndex, ipMcastBoundaryAddressType=ipMcastBoundaryAddressType, ipMcastBoundaryAddress=ipMcastBoundaryAddress, ipMcastBoundaryAddressPrefixLength=ipMcastBoundaryAddressPrefixLength, ipMcastBoundaryTimeStamp=ipMcastBoundaryTimeStamp, ipMcastBoundaryDroppedMcastOctets=ipMcastBoundaryDroppedMcastOctets, ipMcastBoundaryDroppedMcastPkts=ipMcastBoundaryDroppedMcastPkts, ipMcastBoundaryStatus=ipMcastBoundaryStatus, ipMcastBoundaryStorageType=ipMcastBoundaryStorageType, ipMcastScopeNameTable=ipMcastScopeNameTable, ipMcastScopeNameEntry=ipMcastScopeNameEntry, ipMcastScopeNameAddressType=ipMcastScopeNameAddressType, ipMcastScopeNameAddress=ipMcastScopeNameAddress, ipMcastScopeNameAddressPrefixLength=ipMcastScopeNameAddressPrefixLength, ipMcastScopeNameLanguage=ipMcastScopeNameLanguage, ipMcastScopeNameString=ipMcastScopeNameString, ipMcastScopeNameDefault=ipMcastScopeNameDefault, ipMcastScopeNameStatus=ipMcastScopeNameStatus, ipMcastScopeNameStorageType=ipMcastScopeNameStorageType, ipMcastLocalListenerTable=ipMcastLocalListenerTable, ipMcastLocalListenerEntry=ipMcastLocalListenerEntry, ipMcastLocalListenerGroupAddressType=ipMcastLocalListenerGroupAddressType, ipMcastLocalListenerGroupAddress=ipMcastLocalListenerGroupAddress, ipMcastLocalListenerSourceAddressType=ipMcastLocalListenerSourceAddressType, ipMcastLocalListenerSourceAddress=ipMcastLocalListenerSourceAddress, ipMcastLocalListenerSourcePrefixLength=ipMcastLocalListenerSourcePrefixLength, ipMcastLocalListenerIfIndex=ipMcastLocalListenerIfIndex, ipMcastLocalListenerRunIndex=ipMcastLocalListenerRunIndex, ipMcastZoneTable=ipMcastZoneTable, ipMcastZoneEntry=ipMcastZoneEntry, ipMcastZoneIndex=ipMcastZoneIndex, ipMcastZoneScopeDefaultZoneIndex=ipMcastZoneScopeDefaultZoneIndex, ipMcastZoneScopeAddressType=ipMcastZoneScopeAddressType, ipMcastZoneScopeAddress=ipMcastZoneScopeAddress, ipMcastZoneScopeAddressPrefixLength=ipMcastZoneScopeAddressPrefixLength, ipMcastDeviceConfigStorageType=ipMcastDeviceConfigStorageType, ipMcastMIBConformance=ipMcastMIBConformance, ipMcastMIBCompliances=ipMcastMIBCompliances, ipMcastMIBGroups=ipMcastMIBGroups)

# Groups
mibBuilder.exportSymbols("IPMCAST-MIB", ipMcastMIBBasicGroup=ipMcastMIBBasicGroup, ipMcastMIBSsmGroup=ipMcastMIBSsmGroup, ipMcastMIBRouteGroup=ipMcastMIBRouteGroup, ipMcastMIBRouteDiagnosticsGroup=ipMcastMIBRouteDiagnosticsGroup, ipMcastMIBPktsOutGroup=ipMcastMIBPktsOutGroup, ipMcastMIBHopCountGroup=ipMcastMIBHopCountGroup, ipMcastMIBRouteOctetsGroup=ipMcastMIBRouteOctetsGroup, ipMcastMIBRouteBpsGroup=ipMcastMIBRouteBpsGroup, ipMcastMIBRouteProtoGroup=ipMcastMIBRouteProtoGroup, ipMcastMIBLocalListenerGroup=ipMcastMIBLocalListenerGroup, ipMcastMIBBoundaryIfGroup=ipMcastMIBBoundaryIfGroup, ipMcastMIBScopeNameGroup=ipMcastMIBScopeNameGroup)

# Compliances
mibBuilder.exportSymbols("IPMCAST-MIB", ipMcastMIBComplianceHost=ipMcastMIBComplianceHost, ipMcastMIBComplianceRouter=ipMcastMIBComplianceRouter, ipMcastMIBComplianceBorderRouter=ipMcastMIBComplianceBorderRouter)
