# PySNMP SMI module. Autogenerated from smidump -f python L2TP-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:48 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "transmission")
( RowStatus, StorageType, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TruthValue")

# Types

class L2tpMilliSeconds(TextualConvention, Integer32):
    displayHint = "d-3"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,2147483646)
    

# Objects

l2tp = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 95)).setRevisions(("2002-08-23 00:00",))
if mibBuilder.loadTexts: l2tp.setOrganization("IETF L2TP Working Group")
if mibBuilder.loadTexts: l2tp.setContactInfo("Evan Caves\nPostal: Occam Networks\n        77 Robin Hill Road\n        Santa Barbara, CA, 93117\nTel:    +1 805692 2900\nEmail:  evan@occamnetworks.com\n\nPat R. Calhoun\n\n\n\nPostal: Black Storm Networks\n        110 Nortech Parkway\n        San Jose, CA, 95143\nTel:    +1 408 941-0500\nEmail:  pcalhoun@bstormnetworks.com\n\nRoss Wheeler\nPostal: DoubleWide Software, Inc.\n        2953 Bunker Hill Lane\n        Suite 101\n        Santa Clara, CA 95054\nTel:    +1 6509260599\nEmail:  ross@doublewidesoft.com\n\nLayer Two Tunneling Protocol Extensions WG\nWorking Group Area:    Internet\nWorking Group Name:    l2tpext\nGeneral Discussion:    l2tp@l2tp.net")
if mibBuilder.loadTexts: l2tp.setDescription("The MIB module that describes managed objects of\ngeneral use by the Layer Two Transport Protocol.")
l2tpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 0))
l2tpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 1))
l2tpScalar = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 1, 1))
l2tpConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 1))
l2tpAdminState = MibScalar((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpAdminState.setDescription("This object defines the administrative state of\nthe L2TP protocol. Setting this object to\n'disabled' causes all tunnels to be immediately\ndisconnected and no further tunnels to be either\ninitiated or accepted. The value of this object\nmust be maintained in non-volatile memory.")
l2tpDrainTunnels = MibScalar((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 1, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpDrainTunnels.setDescription("Setting this object to 'true' will prevent any new\ntunnels and/or sessions to be either initiated or\naccepted but does NOT disconnect any active\ntunnels/sessions. Setting this object to true(1)\ncauses all domains and their respective tunnels\nto transition to the draining state. Note that\nwhen this occurs the 'xxxDraining' status objects\nof the domains and their tunnels should reflect\nthat they are 'draining'. Setting this object has\nno affect on the domains or their tunnels\n'xxxDrainTunnels' configuration objects. To cancel\na drain this object should be set to false(2).\nThe object l2tpDrainingTunnels reflects\nthe current L2TP draining state. The value of\nthis object must be maintained in non-volatile\nmemory.")
l2tpStats = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 2))
l2tpProtocolVersions = MibScalar((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 2, 1), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpProtocolVersions.setDescription("Vector of supported L2TP protocol version and\nrevision numbers. Supported versions are identified\nvia a two octet pairing where the first octet indicates\nthe version and the second octet contains the revision.")
l2tpVendorName = MibScalar((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 2, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpVendorName.setDescription("This object identifies the Vendor name of the L2TP\nprotocol stack.")
l2tpFirmwareRev = MibScalar((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 2, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpFirmwareRev.setDescription("This object defines the firmware revision for the\nL2TP protocol stack.")
l2tpDrainingTunnels = MibScalar((1, 3, 6, 1, 2, 1, 10, 95, 1, 1, 2, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDrainingTunnels.setDescription("This object indicates if the local L2TP is draining\noff sessions from all tunnels.")
l2tpDomainConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 2))
if mibBuilder.loadTexts: l2tpDomainConfigTable.setDescription("The L2TP Domain configuration table. This table\ncontains objects that can be used to configure\nthe operational characteristics of a tunnel\ndomain. There is a 1-1 correspondence between\nconceptual rows of this table and conceptual\nrows of the l2tpDomainStatsTable.")
l2tpDomainConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1)).setIndexNames((0, "L2TP-MIB", "l2tpDomainConfigId"))
if mibBuilder.loadTexts: l2tpDomainConfigEntry.setDescription("An L2TP Domain configuration entry. An entry in this\ntable may correspond to a single endpoint or a group\nof tunnel endpoints.")
l2tpDomainConfigId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 80))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpDomainConfigId.setDescription("The identifier, usually in the form of a Domain\nName (full or partial), describing a single tunnel\nendpoint or a domain of tunnel endpoints. This is\ntypically used as a 'handle' to identify the\ntunnel configuration requirements for both incoming\nand outgoing tunnel connection attempts. Both the\nLAC and  LNS could use information provided in the\nHost Name AVP attribute however the tunnel initiator\ncould use other means not specified to identify\nthe domain's tunnel configuration requirements.\nFor example; three rows in this table have\nl2tpDomainConfigId values of 'lac1.isp.com',\n\n\n\n'isp.com' and 'com'. A tunnel endpoint then identifies\nitself as 'lac1.isp.com' which would match the\n'lac1.isp.com' entry in this table. A second tunnel\nendpoint then identifies itself as 'lac2.isp.com'.\nThis endpoint is then associated with the 'isp.com'\nentry of this table.")
l2tpDomainConfigAdminState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigAdminState.setDescription("This object defines the administrative state of this\ntunnel domain. Setting this object to disabled(2)\ncauses all tunnels to be immediately disconnected\nand no further tunnels to be either initiated or\naccepted. Note that all columnar objects corresponding\nto this conceptual row cannot be modified when\nthe administrative state is enabled EXCEPT those\nobjects which specifically state otherwise.")
l2tpDomainConfigDrainTunnels = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 3), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigDrainTunnels.setDescription("Setting this object to 'true' will prevent any new\ntunnels and/or sessions from being either initiated\nor accepted but does NOT disconnect any active\ntunnels/sessions for this tunnel domain. Setting\nthis object to true(1) causes all tunnels within\nthis domain to transition to the draining state.\nNote that when this occurs the\nl2tpTunnelStatsDrainingTunnel status objects of\nall of this domain's tunnels should reflect that\nthey are 'draining'. Setting this object has no\neffect on this domain's associated tunnels\nl2tpTunnelConfigDrainTunnel configuration objects.\nTo cancel a drain this object should be set to\nfalse(2).  Setting this object to false(2) when\nthe L2TP object l2tpDrainTunnels is true(1) has\nno affect, all domains and their tunnels will\n\n\n\ncontinue to drain.")
l2tpDomainConfigAuth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("simple", 2), ("challenge", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigAuth.setDescription("This object describes how tunnel peers belonging\nto this domain are to be authenticated. The value\nsimple(2) indicates that peers are authenticated\nsimply by their host name as described in the Host\nName AVP.  The value challenge(3) indicates that\nall peers are challenged to prove their identification.\nThis mechanism is described in the L2TP protocol.")
l2tpDomainConfigSecret = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 5), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigSecret.setDescription("This object is used to configure the shared secret\nused during the tunnel authentication phase of\ntunnel establishment. This object MUST be accessible\nonly via requests using both authentication and\nprivacy. The agent MUST report an empty string in\nresponse to get, get-next and get-bulk requests.")
l2tpDomainConfigTunnelSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("other", 2), ("ipSec", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigTunnelSecurity.setDescription("This object defines whether this tunnel domain\nrequires that all tunnels are to be secured. The\n\n\n\nvalue of ipsec(3) indicates that all tunnel packets,\ncontrol and session, have IP Security headers. The\ntype of IP Security headers (AH, ESP etc) and how\nthey are further described is outside the scope of\nthis document.")
l2tpDomainConfigTunnelHelloInt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600)).clone(60)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigTunnelHelloInt.setDescription("This object defines the interval in which Hello\n(or keep-alive) packets are to be sent by local\npeers belonging to this tunnel domain. The value\nzero effectively disables the sending of Hello\npackets. This object may be modified when the\nadministrative state is enabled for this conceptual\nrow.")
l2tpDomainConfigTunnelIdleTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 86400)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigTunnelIdleTO.setDescription("This object defines the period of time that an\nestablished tunnel belonging to this tunnel\ndomain with no active sessions will wait before\ndisconnecting the tunnel. A value of zero indicates\nthat the tunnel will disconnect immediately after the\nlast session disconnects. A value of -1 leaves the\ntunnel up indefinitely. This object may be modified\nwhen the administrative state is enabled for this\nconceptual row.")
l2tpDomainConfigControlRWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigControlRWS.setDescription("This object defines the control channel receive\n\n\n\nwindow size for tunnels belonging to this domain. It\nspecifies the maximum number of packets the tunnel\npeer belonging to this domain can send without waiting\nfor an acknowledgement from this peer.")
l2tpDomainConfigControlMaxRetx = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32)).clone(5)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigControlMaxRetx.setDescription("This object defines the maximum number of retransmissions\nwhich the L2TP stack will attempt for tunnels belonging\nto this domain before assuming that the peer is no\nlonger responding.")
l2tpDomainConfigControlMaxRetxTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 11), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 32)).clone(16)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigControlMaxRetxTO.setDescription("This object defines the maximum retransmission timeout\ninterval which the L2TP stack will wait for tunnels\nbelonging to this domain before retransmitting a\ncontrol packet that has not been acknowledged.")
l2tpDomainConfigPayloadSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("onDemand", 1), ("never", 2), ("always", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigPayloadSeq.setDescription("This object determines whether or not session payload\npackets will be requested to be sent with sequence\nnumbers from tunnel peers belonging to this domain.\nThe value onDemand(1) allows the L2TP implementation\nto initiate payload sequencing when necessary based\non local information (e.g: during LCP/NCP negotiations\nor for CCP). The value never(2) indicates that L2TP\n\n\n\nwill never initiate sequencing but will do sequencing\nif asked. The value always(3) indicates that L2TP\nwill send the Sequencing Required AVP during session\nestablishment.")
l2tpDomainConfigReassemblyTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 13), L2tpMilliSeconds().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigReassemblyTO.setDescription("This object defines the number of milliseconds that\nlocal peers of this tunnel domain will wait before\nprocessing payload packets that were received out of\nsequence (which are waiting for the packet(s) to put\nthem in sequence).  A low value increases the chance\nof delayed packets to be discarded (which MAY cause\nthe PPP decompression engine to reset) while a high\nvalue may cause more queuing and possibly degrade\nthroughput if packets are truly lost. The default\nvalue for this object is zero which will result in\nall delayed packets being lost.")
l2tpDomainConfigProxyPPPAuth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 14), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigProxyPPPAuth.setDescription("This object is used to configure the sending\nor acceptance of the PPP Proxy Authentication\nAVP's on the LAC or LNS.")
l2tpDomainConfigStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 15), StorageType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigStorageType.setDescription("The storage type for this conceptual row.\n\nConceptual rows having the value 'permanent' must\nallow write-access at a minimum to:\n\n- l2tpDomainConfigAdminState and\n\n\n\n  l2tpDomainConfigDrainTunnels at all times\n- l2tpDomainConfigSecret if l2tpDomainConfigAuth\n  has been configured as 'challenge'\n\nIt is an implementation issue to decide if a SET for\na readOnly or permanent row is accepted at all. In some\ncontexts this may make sense, in others it may not. If\na SET for a readOnly or permanent row is not accepted\nat all, then a 'wrongValue' error must be returned.")
l2tpDomainConfigStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 2, 1, 16), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpDomainConfigStatus.setDescription("The status of this Domain entry. Columnar objects\ncorresponding to this conceptual row may be modified\naccording to their description clauses when this\nRowStatus object is 'active'.")
l2tpDomainStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 3))
if mibBuilder.loadTexts: l2tpDomainStatsTable.setDescription("The L2TP Domain Status and Statistics table. This\ntable contains objects that can be used to describe\nthe current status and statistics of a tunnel domain.\nThere is a 1-1 correspondence between conceptual\nrows of this table and conceptual rows of the\nl2tpDomainConfigTable.")
l2tpDomainStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1))
if mibBuilder.loadTexts: l2tpDomainStatsEntry.setDescription("An L2TP Domain Stats entry. An entry in this table\nmay correspond to a single endpoint or a group of\ntunnel endpoints.")
l2tpDomainStatsTotalTunnels = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsTotalTunnels.setDescription("This object returns the total number of tunnels\nthat have successfully reached the established\nstate for this tunnel domain.")
l2tpDomainStatsFailedTunnels = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsFailedTunnels.setDescription("This object returns the number of tunnels that\nfailed (eg: connection timeout, unsupported\nor malformed AVP's etc) to reach the established\nstate for this tunnel domain.")
l2tpDomainStatsFailedAuths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsFailedAuths.setDescription("This object returns the number of failed tunnel\nconnection attempts for this domain because the\ntunnel peer failed authentication.")
l2tpDomainStatsActiveTunnels = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsActiveTunnels.setDescription("This object returns the number of tunnels that\nare currently active for this domain.")
l2tpDomainStatsTotalSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsTotalSessions.setDescription("This object returns the total number of sessions\nthat have successfully reached the established\nstate for this tunnel domain.")
l2tpDomainStatsFailedSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsFailedSessions.setDescription("This object returns the number of sessions that\nfailed (eg: connection timeout, unsupported\nor malformed AVP's etc) to reach the established\nstate for this tunnel domain.")
l2tpDomainStatsActiveSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsActiveSessions.setDescription("This object returns the number of sessions that\nare currently active for this domain.")
l2tpDomainStatsDrainingTunnels = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsDrainingTunnels.setDescription("This object indicates if this domain is draining\noff sessions from all tunnels.")
l2tpDomainStatsControlRxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlRxOctets.setDescription("This object returns the number of control channel\noctets received for this tunnel domain.")
l2tpDomainStatsControlRxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlRxPkts.setDescription("This object returns the number of control packets\nreceived for this tunnel domain.")
l2tpDomainStatsControlTxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlTxOctets.setDescription("This object returns the number of control channel\noctets that were transmitted to tunnel endpoints\nfor this domain.")
l2tpDomainStatsControlTxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlTxPkts.setDescription("This object returns the number of control packets\nthat were transmitted to tunnel endpoints for\nthis domain.")
l2tpDomainStatsPayloadRxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadRxOctets.setDescription("This object returns the number of payload channel\noctets that were received for this tunnel domain.")
l2tpDomainStatsPayloadRxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadRxPkts.setDescription("This object returns the number of payload packets\nthat were received for this tunnel domain.")
l2tpDomainStatsPayloadRxDiscs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadRxDiscs.setDescription("This object returns the number of received payload\npackets that were discarded by this tunnel domain.")
l2tpDomainStatsPayloadTxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadTxOctets.setDescription("This object returns the number of payload channel\noctets that were transmitted to tunnel peers\nwithin this tunnel domain.")
l2tpDomainStatsPayloadTxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadTxPkts.setDescription("This object returns the number of payload packets\nthat were transmitted to tunnel peers within\nthis tunnel domain.")
l2tpDomainStatsControlHCRxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 18), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlHCRxOctets.setDescription("This object is a 64-bit version of\nl2tpDomainStatsControlRxOctets.")
l2tpDomainStatsControlHCRxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlHCRxPkts.setDescription("This object is a 64-bit version of\nl2tpDomainStatsControlRxPkts.")
l2tpDomainStatsControlHCTxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 20), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlHCTxOctets.setDescription("This object is a 64-bit version of\nl2tpDomainStatsControlTxOctets.")
l2tpDomainStatsControlHCTxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsControlHCTxPkts.setDescription("This object is a 64-bit version of\nl2tpDomainStatsControlTxPkts.")
l2tpDomainStatsPayloadHCRxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 22), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadHCRxOctets.setDescription("This object is a 64-bit version of\nl2tpDomainStatsPayloadRxOctets.")
l2tpDomainStatsPayloadHCRxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 23), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadHCRxPkts.setDescription("This object is a 64-bit version of\nl2tpDomainStatsPayloadRxPkts.")
l2tpDomainStatsPayloadHCRxDiscs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadHCRxDiscs.setDescription("This object is a 64-bit version of\nl2tpDomainStatsPayloadRxDiscs.")
l2tpDomainStatsPayloadHCTxOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 25), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadHCTxOctets.setDescription("This object is a 64-bit version of\nl2tpDomainStatsPayloadTxOctets.")
l2tpDomainStatsPayloadHCTxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 3, 1, 26), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpDomainStatsPayloadHCTxPkts.setDescription("This object is a 64-bit version of\nl2tpDomainStatsPayloadTxPkts.")
l2tpTunnelConfigTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 4))
if mibBuilder.loadTexts: l2tpTunnelConfigTable.setDescription("The L2TP tunnel configuration table. This\ntable contains objects that can be used to\n(re)configure the operational characteristics\nof a single L2TP tunnel. There is a 1-1\ncorrespondence between conceptual rows of\nthis table and conceptual rows of the\nl2tpTunnelStatsTable. Entries in this table\nhave the same persistency characteristics as\nthat of the tunnelConfigTable.")
l2tpTunnelConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1)).setIndexNames((0, "L2TP-MIB", "l2tpTunnelConfigIfIndex"))
if mibBuilder.loadTexts: l2tpTunnelConfigEntry.setDescription("A L2TP tunnel interface configuration entry.\nEntries in this table come and go as a result\nof protocol interactions or on management\noperations. The latter occurs when a row is\ninstantiated in the tunnelConfigTable row\nand the encapsulation method is 'l2tp'.")
l2tpTunnelConfigIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpTunnelConfigIfIndex.setDescription("This value for this object is equal to the value\nof ifIndex of the Interfaces MIB for tunnel\ninterfaces of type L2TP.")
l2tpTunnelConfigDomainId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 2), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 80))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigDomainId.setDescription("The tunnel domain that this tunnel belongs\nto. A LNS tunnel endpoint will typically inherit\nthis value from the endpoint domain table. A\nLAC may be provided with this information during\ntunnel setup. When a zero length string is returned\nthis tunnel does not belong belong to any particular\ndomain.")
l2tpTunnelConfigAuth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("simple", 2), ("challenge", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigAuth.setDescription("This object describes how L2TP tunnel peers are\nto be authenticated. The value 'simple' indicates\nthat peers are authenticated simply by their host\nname as described in the Host Name AVP. The value\n'challenge' indicates that all peers are challenged\nto prove their identification. This mechanism is\ndescribed in the L2TP protocol. This object cannot\nbe modified when the tunnel is in a connecting or\nconnected state.")
l2tpTunnelConfigSecret = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 4), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigSecret.setDescription("This object is used to configure the shared secret\nused during the tunnel authentication phase of\n\n\n\ntunnel establishment. This object cannot be modified\nwhen the tunnel is in a connecting or connected\nstate. This object MUST be accessible only via\nrequests using both authentication and privacy.\nThe agent MUST report an empty string in response\nto get, get-next and get-bulk requests.")
l2tpTunnelConfigSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("other", 2), ("ipsec", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigSecurity.setDescription("This object defines whether this tunnel is to be\nsecured. The value of 'ipSec' indicates that all\ntunnel packets, control and session, have IP\nSecurity headers. The type of IP Security headers\n(AH, ESP etc) and how they are further described\nis outside the scope of this document. This object\ncannot be modified when the tunnel is in a connecting\nor connected state.")
l2tpTunnelConfigHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 3600)).clone(60)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigHelloInterval.setDescription("This object defines the interval in which Hello\n(or keep-alive) packets are to be sent to the\ntunnel peer.  The value zero effectively disables\nthe sending of Hello packets. Modifications to this\nobject have immediate effect.")
l2tpTunnelConfigIdleTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(-1, 86400)).clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigIdleTimeout.setDescription("This object defines the period of time that an\nestablished tunnel with no sessions will wait\nbefore disconnecting the tunnel. A value of\nzero indicates that the tunnel will disconnect\nimmediately after the last session disconnects.\nA value of -1 leaves the tunnel up indefinitely.\nModifications to this object have immediate\neffect.")
l2tpTunnelConfigControlRWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535)).clone(4)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigControlRWS.setDescription("This object defines the control channel receive\nwindow size. It specifies the maximum number of\npackets the tunnel peer can send without waiting\nfor an acknowledgement from this peer. This object\ncannot be modified when the tunnel is in a con-\nnecting or connected state.")
l2tpTunnelConfigControlMaxRetx = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 32)).clone(5)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigControlMaxRetx.setDescription("This object defines the number of retransmissions\nwhich the tunnel will attempt before assuming that\nthe peer is no longer responding. A value of zero\nindicates that this peer will not attempt to\nretransmit an unacknowledged control packet.\nModifications to this object have immediate\neffect.")
l2tpTunnelConfigControlMaxRetxTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 32)).clone(16)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigControlMaxRetxTO.setDescription("This object defines the maximum retransmission timeout\ninterval which the tunnel will wait before retrans-\n\n\n\nmitting a control packet that has not been acknowledged.\nModifications to this object have immediate effect.")
l2tpTunnelConfigPayloadSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("onDemand", 1), ("never", 2), ("always", 3), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigPayloadSeq.setDescription("This object determines whether or not session payload\npackets will be requested to be sent with sequence\nnumbers from tunnel peers belonging to this domain.\nThe value onDemand(1) allows the L2TP implementation\nto initiate payload sequencing when necessary based\non local information (e.g: during LCP/NCP negotiations\nor for CCP). The value never(2) indicates that L2TP\nwill never initiate sequencing but will do sequencing\nif asked. The value always(3) indicates that L2TP\nwill send the Sequencing Required AVP during session\nestablishment. Modifications to this object have\nimmediate effect.")
l2tpTunnelConfigReassemblyTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 12), L2tpMilliSeconds().clone('0')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigReassemblyTO.setDescription("This object defines the number of milliseconds that\nthis tunnel will wait before processing payload packets\nthat were received out of sequence (which are waiting\nfor the packet(s) to put them in sequence).  A low value\nincreases the chance of delayed packets to be discarded\n(which MAY cause the PPP decompression engine to\nreset) while a high value may cause more queuing and\npossibly degrade throughput if packets are truly lost.\nThe default value for this object is zero which will\nresult in all delayed packets being lost. Modifications\nto this object have immediate effect.")
l2tpTunnelConfigTransport = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,5,1,4,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("none", 2), ("udpIp", 3), ("frameRelay", 4), ("atm", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigTransport.setDescription("This object defines the underlying transport media\nthat is in use for this tunnel entry. Different tunnel\ntransports may define MIB extensions to the L2TP tunnel\ntable to realize the transport layer. For example if the\nvalue of this object is 'udpIp' then the value of ifIndex\nfor this table may be used to determine state from the\nl2tpUdpStatsTable. This object cannot be modified when\nthe tunnel is in a connecting or connected state.")
l2tpTunnelConfigDrainTunnel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 14), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigDrainTunnel.setDescription("Setting this object to 'true' will prevent any new\nsession from being either initiated or accepted but\ndoes NOT disconnect any active sessions for this\ntunnel. Note that when this occurs the\nl2tpTunnelStatsDrainingTunnel status object of\nthis tunnel should reflect that it is 'draining'.\nTo cancel a drain this object should be set to\nfalse(2).  Setting this object to false(2) when\nthe L2TP objects l2tpDrainTunnels or\nl2tpDomainConfigDrainTunnels is true(1) has\nno affect, this tunnels will continue to drain.")
l2tpTunnelConfigProxyPPPAuth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 4, 1, 15), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: l2tpTunnelConfigProxyPPPAuth.setDescription("This object is used to configure the sending\nor acceptance of the session PPP Proxy\nAuthentication AVP's on the LAC or LNS.")
l2tpTunnelStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 5))
if mibBuilder.loadTexts: l2tpTunnelStatsTable.setDescription("The L2TP tunnel status and statistics table. This\ntable contains objects that can be used to describe\nthe current status and statistics of a single L2TP\ntunnel. There is a 1-1 correspondence between\nconceptual rows of this table and conceptual rows of\nthe l2tpTunnelConfigTable.")
l2tpTunnelStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1))
if mibBuilder.loadTexts: l2tpTunnelStatsEntry.setDescription("An L2TP tunnel interface stats entry.")
l2tpTunnelStatsLocalTID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsLocalTID.setDescription("This object contains the local tunnel Identifier.")
l2tpTunnelStatsRemoteTID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRemoteTID.setDescription("This object contains the remote tunnel Identifier.")
l2tpTunnelStatsState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,4,1,)).subtype(namedValues=namedval.NamedValues(("tunnelIdle", 1), ("tunnelConnecting", 2), ("tunnelEstablished", 3), ("tunnelDisconnecting", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsState.setDescription("This field contains the current state of the\ncontrol tunnel.")
l2tpTunnelStatsInitiated = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("locally", 1), ("remotely", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsInitiated.setDescription("This object indicates whether the tunnel was\ninitiated locally or by the remote tunnel peer.")
l2tpTunnelStatsRemoteHostName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRemoteHostName.setDescription("This object contains the host name as discovered\n\n\n\nduring the tunnel establishment phase (via the Host\nName AVP) of the L2TP peer. If the tunnel is idle\nthis object should maintain its value from the last\ntime it was connected.")
l2tpTunnelStatsRemoteVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 6), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRemoteVendorName.setDescription("This object identifies the vendor name of the peer's\nL2TP implementation. If the tunnel is idle this\nobject should maintain its value from the last time\nit was connected.")
l2tpTunnelStatsRemoteFirmwareRev = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRemoteFirmwareRev.setDescription("This object contains the tunnel peer's firmware\nrevision number. If the tunnel is idle this object\nshould maintain its value from the last time it\nwas connected.")
l2tpTunnelStatsRemoteProtocolVer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 8), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRemoteProtocolVer.setDescription("This object describes the protocol version and\nrevision of the tunnel peers implementation. The\nfirst octet contains the protocol version. The\nsecond octet contains the protocol revision.")
l2tpTunnelStatsInitialRemoteRWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsInitialRemoteRWS.setDescription("This object contains the initial remote peer's\nreceive window size as indicated by the tunnel peer\n(in the RWS AVP) during the tunnel establishment\nphase. If the tunnel is idle this object should\n\n\n\nmaintain its value from the last time it was\nconnected.")
l2tpTunnelStatsBearerCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,4,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("digital", 2), ("analog", 3), ("digitalAnalog", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsBearerCaps.setDescription("This object describes the Bearer Capabilities of\nthe tunnel peer. If the tunnel is idle this object\nshould maintain its value from the last time it was\nconnected.")
l2tpTunnelStatsFramingCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,4,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("sync", 2), ("async", 3), ("syncAsync", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsFramingCaps.setDescription("This object describes the Framing Capabilities of\nthe tunnel peer. If the tunnel is idle this object\nshould maintain its value from the last time it was\nconnected.")
l2tpTunnelStatsControlRxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlRxPkts.setDescription("This object contains the number of control packets\nreceived on the tunnel.")
l2tpTunnelStatsControlRxZLB = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlRxZLB.setDescription("This object returns a count of the number of Zero\nLength Body control packet acknowledgement packets\nthat were received.")
l2tpTunnelStatsControlOutOfSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlOutOfSeq.setDescription("This object returns a count of the number of\ncontrol packets that were not received in the\ncorrect order (as per the sequence number)\non this tunnel including out of window\npackets.")
l2tpTunnelStatsControlOutOfWin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlOutOfWin.setDescription("This object contains the number of control\npackets that were received outside of the\noffered receive window. It is implementation\nspecific as to whether these packets are queued\nor discarded.")
l2tpTunnelStatsControlTxPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlTxPkts.setDescription("This object contains the number of control\npackets that were transmitted to the tunnel\npeer.")
l2tpTunnelStatsControlTxZLB = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlTxZLB.setDescription("This object contains the number of Zero Length\nBody control packets transmitted to the tunnel\n\n\n\npeer.")
l2tpTunnelStatsControlAckTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsControlAckTO.setDescription("This object returns a count of the number of\ncontrol packet timeouts due to the lack of a\ntimely acknowledgement from the tunnel peer.")
l2tpTunnelStatsCurrentRemoteRWS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 19), Gauge32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsCurrentRemoteRWS.setDescription("This object contains the current remote receive\nwindow size as determined by the local flow\ncontrol mechanism employed.")
l2tpTunnelStatsTxSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 20), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsTxSeq.setDescription("This object contains the next send sequence number\nfor the control channel.")
l2tpTunnelStatsTxSeqAck = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 21), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsTxSeqAck.setDescription("This object contains the send sequence number that\nthe tunnel peer has acknowledged for the control\nchannel. The flow control state can be determined\nby subtracting the l2tpTunnelStatsTxSeq from\nl2tpTunnelStatsTxSeqAck and comparing this value\nto l2tpTunnelStatsCurrentRemoteRWS (taking into\nconsideration sequence number wraps).")
l2tpTunnelStatsRxSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 22), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRxSeq.setDescription("This object contains the next receive sequence\nnumber expected to be received on this control\nchannel.")
l2tpTunnelStatsRxSeqAck = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 23), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsRxSeqAck.setDescription("This object contains the last receive sequence\nnumber that was acknowledged back to the tunnel\npeer for the control channel.")
l2tpTunnelStatsTotalSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsTotalSessions.setDescription("This object contains the total number of sessions\nthat this tunnel has successfully connected through\nto its tunnel peer since this tunnel was created.")
l2tpTunnelStatsFailedSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsFailedSessions.setDescription("This object contains the total number of sessions\nthat were initiated but failed to reach the\nestablished phase.")
l2tpTunnelStatsActiveSessions = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 26), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsActiveSessions.setDescription("This object contains the total number of sessions\nin the established state for this tunnel.")
l2tpTunnelStatsLastResultCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 27), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsLastResultCode.setDescription("This object contains the last value of the result\ncode as described in the Result Code AVP which\ncaused the tunnel to disconnect.")
l2tpTunnelStatsLastErrorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 28), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsLastErrorCode.setDescription("This object contains the last value of the error\ncode as described in the Result Code AVP which\ncaused the tunnel to disconnect.")
l2tpTunnelStatsLastErrorMessage = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 29), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsLastErrorMessage.setDescription("This object contains the last value of the optional\nmessage as described in the Result Code AVP which\ncaused the tunnel to disconnect.")
l2tpTunnelStatsDrainingTunnel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 5, 1, 30), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelStatsDrainingTunnel.setDescription("This object indicates if this tunnel is draining\noff sessions. This object will return false(2) when\nthe tunnel is not draining sessions or after the\nlast session has disconnected when the tunnel is in\nthe draining state.")
l2tpSessionStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 7))
if mibBuilder.loadTexts: l2tpSessionStatsTable.setDescription("The L2TP session status and statistics table. This\ntable contains the objects that can be used to\ndescribe the current status and statistics of a\nsingle L2TP tunneled session.")
l2tpSessionStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1)).setIndexNames((0, "L2TP-MIB", "l2tpSessionStatsTunnelIfIndex"), (0, "L2TP-MIB", "l2tpSessionStatsLocalSID"))
if mibBuilder.loadTexts: l2tpSessionStatsEntry.setDescription("An L2TP session interface stats entry.")
l2tpSessionStatsTunnelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpSessionStatsTunnelIfIndex.setDescription("This object identifies the session's associated\nL2TP tunnel ifIndex value.")
l2tpSessionStatsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsIfIndex.setDescription("This object identifies the ifIndex value of the\ninterface from which PPP packets are being tunneled.\nFor example this could be a DS0 ifIndex on a\nLAC or it would be the PPP ifIndex on the LNS.")
l2tpSessionStatsLocalSID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpSessionStatsLocalSID.setDescription("This object contains the local assigned session\nidentifier for this session.")
l2tpSessionStatsRemoteSID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsRemoteSID.setDescription("This object contains the remote assigned session\nidentifier for this session. When a session is\nstarting this value may be zero until the remote\ntunnel endpoint has responded.")
l2tpSessionStatsUserName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsUserName.setDescription("This object identifies the peer session name on\nthis interface. This is typically the login name\nof the remote user. If the user name is unknown to\nthe local tunnel peer then this object will contain\na null string.")
l2tpSessionStatsState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,4,2,3,)).subtype(namedValues=namedval.NamedValues(("sessionIdle", 1), ("sessionConnecting", 2), ("sessionEstablished", 3), ("sessionDisconnecting", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsState.setDescription("This object contains the current state of the\nsession.")
l2tpSessionStatsCallType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,1,3,2,)).subtype(namedValues=namedval.NamedValues(("lacIncoming", 1), ("lnsIncoming", 2), ("lacOutgoing", 3), ("lnsOutgoing", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsCallType.setDescription("This object indicates the type of call and the\nrole this tunnel peer is providing for this\nsession. For example, lacIncoming(1) indicates\nthat this tunnel peer is acting as a LAC and\ngenerated a Incoming-Call-Request to the tunnel\npeer (the LNS). Note that tunnel peers can be\nboth LAC and LNS simultaneously.")
l2tpSessionStatsCallSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsCallSerialNumber.setDescription("This object contains the serial number that has\nbeen assigned to this  session.")
l2tpSessionStatsTxConnectSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsTxConnectSpeed.setDescription("This object returns the last known transmit\nbaud rate for this session.")
l2tpSessionStatsRxConnectSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsRxConnectSpeed.setDescription("This object returns the last known receive\nbaud rate for this session established.")
l2tpSessionStatsCallBearerType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 11), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,3,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("digital", 2), ("analog", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsCallBearerType.setDescription("This object describes the bearer type of this\nsession.")
l2tpSessionStatsFramingType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,2,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("sync", 2), ("async", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsFramingType.setDescription("This object describes the framing type of this\nsession.")
l2tpSessionStatsPhysChanId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsPhysChanId.setDescription("This object contains the physical channel\nidentifier for the session.")
l2tpSessionStatsDNIS = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 14), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsDNIS.setDescription("This object identifies the Dialed Number\nInformation String that the LAC obtained from\nthe network for the session. If no DNIS was\nprovided then a null string will be returned.")
l2tpSessionStatsCLID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 15), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsCLID.setDescription("This object identifies the Calling Line ID\nthat the LAC obtained from the network for\nthe session. If no CLID was provided then a\nnull string will be returned.")
l2tpSessionStatsSubAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 16), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsSubAddress.setDescription("This object identifies the Sub Address that\nthe LAC obtained from the network for the\nsession. If no Sub Address was provided then\na null string will be returned.")
l2tpSessionStatsPrivateGroupID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 17), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsPrivateGroupID.setDescription("This object identifies the Private Group\nIdentifier used for this tunneled session.\nIf no Private Group Identifier was provided\nthen a null string will be returned.")
l2tpSessionStatsProxyLcp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 18), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsProxyLcp.setDescription("Indicates whether the LAC performed proxy LCP\nfor this session.")
l2tpSessionStatsAuthMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 19), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(7,3,1,8,4,2,5,6,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("text", 2), ("pppChap", 3), ("pppPap", 4), ("pppEap", 5), ("pppMsChapV1", 6), ("pppMsChapV2", 7), ("other", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsAuthMethod.setDescription("This object contains the proxy authentication\nmethod employed by the LAC for the session. If\nl2tpSessionProxyLcp is false(2) this object\nshould not be interpreted.")
l2tpSessionStatsSequencingState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 20), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,1,4,2,)).subtype(namedValues=namedval.NamedValues(("none", 1), ("remote", 2), ("local", 3), ("both", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsSequencingState.setDescription("This object defines which tunnel peers have\nrequested payload sequencing. The value of\nboth(4) indicates that both peers have requested\npayload sequencing.")
l2tpSessionStatsOutSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsOutSequence.setDescription("This object returns the total number of packets\nreceived for this session which were received out\nof sequence.")
l2tpSessionStatsReassemblyTO = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsReassemblyTO.setDescription("This object returns the number of reassembly\ntimeouts that have occurred for this session.")
l2tpSessionStatsTxSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 23), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsTxSeq.setDescription("This object contains the next send sequence number\nfor for this session.")
l2tpSessionStatsRxSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 7, 1, 24), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionStatsRxSeq.setDescription("This object contains the next receive sequence\nnumber expected to be received on this session.")
l2tpTunnelMapTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 8))
if mibBuilder.loadTexts: l2tpTunnelMapTable.setDescription("The L2TP Tunnel index mapping table. This table\nis intended to assist management applications\nto quickly determine what the ifIndex value is\nfor a given local tunnel identifier.")
l2tpTunnelMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 8, 1)).setIndexNames((0, "L2TP-MIB", "l2tpTunnelMapLocalTID"))
if mibBuilder.loadTexts: l2tpTunnelMapEntry.setDescription("An L2TP tunnel index map entry.")
l2tpTunnelMapLocalTID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 8, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpTunnelMapLocalTID.setDescription("This object contains the local tunnel Identifier.")
l2tpTunnelMapIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 8, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpTunnelMapIfIndex.setDescription("This value for this object is equal to the value\nof ifIndex of the Interfaces MIB for tunnel\ninterfaces of type L2TP.")
l2tpSessionMapTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 1, 9))
if mibBuilder.loadTexts: l2tpSessionMapTable.setDescription("The L2TP Session index mapping table. This table\nis intended to assist management applications\nto map interfaces to a tunnel and session\nidentifier.")
l2tpSessionMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 1, 9, 1)).setIndexNames((0, "L2TP-MIB", "l2tpSessionMapIfIndex"))
if mibBuilder.loadTexts: l2tpSessionMapEntry.setDescription("An L2TP Session index map entry.")
l2tpSessionMapIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 9, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpSessionMapIfIndex.setDescription("This object identifies the ifIndex value of the\ninterface which is receiving or sending its packets\nover an L2TP tunnel. For example this could be a DS0\nifIndex on a LAC or a PPP ifIndex on the LNS.")
l2tpSessionMapTunnelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 9, 1, 2), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpSessionMapTunnelIfIndex.setDescription("This object identifies the sessions associated\nL2TP tunnel ifIndex value. When this object is\nset it provides a binding between a particular\ninterface identified by l2tpSessionMapIfIndex\nto a particular tunnel.")
l2tpSessionMapLocalSID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 9, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpSessionMapLocalSID.setDescription("This object contains the local assigned session\nidentifier for this session.")
l2tpSessionMapStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 1, 9, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: l2tpSessionMapStatus.setDescription("The status of this session map entry.")
l2tpTransports = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 3))
l2tpTransportIpUdp = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 3, 1))
l2tpIpUdpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 1))
l2tpUdpStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 1, 2))
if mibBuilder.loadTexts: l2tpUdpStatsTable.setDescription("The L2TP UDP/IP transport stats table. This table\ncontains objects that can be used to describe the\ncurrent status and statistics of the UDP/IP L2TP\ntunnel transport.")
l2tpUdpStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 1, 2, 1)).setIndexNames((0, "L2TP-MIB", "l2tpUdpStatsIfIndex"))
if mibBuilder.loadTexts: l2tpUdpStatsEntry.setDescription("An L2TP UDP/IP transport stats entry.")
l2tpUdpStatsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 1, 2, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: l2tpUdpStatsIfIndex.setDescription("This value for this object is equal to the\nvalue of ifIndex of the Interfaces MIB for\ntunnel interfaces of type L2TP and which have\na L2TP transport of UDP/IP.")
l2tpUdpStatsPeerPort = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpUdpStatsPeerPort.setDescription("This object reflects the peer's UDP port number\nused for this tunnel. When not known a value of\nzero should be returned.")
l2tpUdpStatsLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: l2tpUdpStatsLocalPort.setDescription("This object reflects the local UDP port number\nthat this tunnel is bound to.")
l2tpIpUdpTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 3, 1, 2))
l2tpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 4))
l2tpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 4, 1))
l2tpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 95, 4, 2))

# Augmentions
l2tpDomainConfigEntry.registerAugmentions(("L2TP-MIB", "l2tpDomainStatsEntry"))
l2tpDomainStatsEntry.setIndexNames(*l2tpDomainConfigEntry.getIndexNames())
l2tpTunnelConfigEntry.registerAugmentions(("L2TP-MIB", "l2tpTunnelStatsEntry"))
l2tpTunnelStatsEntry.setIndexNames(*l2tpTunnelConfigEntry.getIndexNames())

# Notifications

l2tpTunnelAuthFailure = NotificationType((1, 3, 6, 1, 2, 1, 10, 95, 0, 1)).setObjects(("L2TP-MIB", "l2tpTunnelStatsInitiated"), ("L2TP-MIB", "l2tpTunnelStatsRemoteHostName"), )
if mibBuilder.loadTexts: l2tpTunnelAuthFailure.setDescription("A l2tpTunnelAuthFailure trap signifies that an\nattempt to establish a tunnel to a remote peer\nhas failed authentication.")

# Groups

l2tpConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 1)).setObjects(("L2TP-MIB", "l2tpTunnelConfigDrainTunnel"), ("L2TP-MIB", "l2tpTunnelConfigHelloInterval"), ("L2TP-MIB", "l2tpTunnelConfigControlMaxRetxTO"), ("L2TP-MIB", "l2tpTunnelConfigPayloadSeq"), ("L2TP-MIB", "l2tpTunnelConfigControlMaxRetx"), ("L2TP-MIB", "l2tpTunnelConfigDomainId"), ("L2TP-MIB", "l2tpTunnelConfigProxyPPPAuth"), ("L2TP-MIB", "l2tpDrainTunnels"), ("L2TP-MIB", "l2tpTunnelConfigTransport"), ("L2TP-MIB", "l2tpAdminState"), ("L2TP-MIB", "l2tpTunnelConfigIdleTimeout"), ("L2TP-MIB", "l2tpTunnelConfigReassemblyTO"), ("L2TP-MIB", "l2tpTunnelConfigControlRWS"), )
if mibBuilder.loadTexts: l2tpConfigGroup.setDescription("A collection of objects providing configuration\ninformation of the L2TP protocol, tunnels and\nsessions.")
l2tpStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 2)).setObjects(("L2TP-MIB", "l2tpTunnelStatsLastResultCode"), ("L2TP-MIB", "l2tpTunnelStatsActiveSessions"), ("L2TP-MIB", "l2tpTunnelStatsRxSeqAck"), ("L2TP-MIB", "l2tpSessionStatsTxConnectSpeed"), ("L2TP-MIB", "l2tpTunnelStatsCurrentRemoteRWS"), ("L2TP-MIB", "l2tpSessionStatsProxyLcp"), ("L2TP-MIB", "l2tpTunnelStatsControlRxPkts"), ("L2TP-MIB", "l2tpTunnelStatsRxSeq"), ("L2TP-MIB", "l2tpTunnelStatsTxSeq"), ("L2TP-MIB", "l2tpTunnelStatsLocalTID"), ("L2TP-MIB", "l2tpSessionStatsState"), ("L2TP-MIB", "l2tpSessionStatsCallSerialNumber"), ("L2TP-MIB", "l2tpSessionStatsRxConnectSpeed"), ("L2TP-MIB", "l2tpDrainingTunnels"), ("L2TP-MIB", "l2tpFirmwareRev"), ("L2TP-MIB", "l2tpSessionStatsTxSeq"), ("L2TP-MIB", "l2tpSessionStatsFramingType"), ("L2TP-MIB", "l2tpTunnelStatsControlAckTO"), ("L2TP-MIB", "l2tpTunnelStatsBearerCaps"), ("L2TP-MIB", "l2tpTunnelStatsTxSeqAck"), ("L2TP-MIB", "l2tpTunnelStatsControlTxPkts"), ("L2TP-MIB", "l2tpSessionStatsAuthMethod"), ("L2TP-MIB", "l2tpTunnelStatsLastErrorCode"), ("L2TP-MIB", "l2tpSessionStatsOutSequence"), ("L2TP-MIB", "l2tpSessionStatsCallBearerType"), ("L2TP-MIB", "l2tpSessionStatsUserName"), ("L2TP-MIB", "l2tpSessionStatsRxSeq"), ("L2TP-MIB", "l2tpSessionStatsSequencingState"), ("L2TP-MIB", "l2tpTunnelStatsInitiated"), ("L2TP-MIB", "l2tpTunnelStatsDrainingTunnel"), ("L2TP-MIB", "l2tpSessionStatsPhysChanId"), ("L2TP-MIB", "l2tpTunnelStatsFailedSessions"), ("L2TP-MIB", "l2tpTunnelStatsRemoteFirmwareRev"), ("L2TP-MIB", "l2tpTunnelStatsRemoteProtocolVer"), ("L2TP-MIB", "l2tpTunnelStatsRemoteHostName"), ("L2TP-MIB", "l2tpTunnelStatsState"), ("L2TP-MIB", "l2tpSessionStatsRemoteSID"), ("L2TP-MIB", "l2tpSessionStatsCLID"), ("L2TP-MIB", "l2tpProtocolVersions"), ("L2TP-MIB", "l2tpSessionStatsCallType"), ("L2TP-MIB", "l2tpSessionStatsIfIndex"), ("L2TP-MIB", "l2tpSessionStatsReassemblyTO"), ("L2TP-MIB", "l2tpTunnelStatsInitialRemoteRWS"), ("L2TP-MIB", "l2tpTunnelStatsControlRxZLB"), ("L2TP-MIB", "l2tpTunnelStatsFramingCaps"), ("L2TP-MIB", "l2tpSessionStatsPrivateGroupID"), ("L2TP-MIB", "l2tpTunnelStatsRemoteTID"), ("L2TP-MIB", "l2tpTunnelStatsLastErrorMessage"), ("L2TP-MIB", "l2tpTunnelStatsRemoteVendorName"), ("L2TP-MIB", "l2tpTunnelStatsControlTxZLB"), ("L2TP-MIB", "l2tpTunnelStatsControlOutOfWin"), ("L2TP-MIB", "l2tpVendorName"), ("L2TP-MIB", "l2tpTunnelStatsControlOutOfSeq"), ("L2TP-MIB", "l2tpSessionStatsDNIS"), ("L2TP-MIB", "l2tpTunnelStatsTotalSessions"), ("L2TP-MIB", "l2tpSessionStatsSubAddress"), )
if mibBuilder.loadTexts: l2tpStatsGroup.setDescription("A collection of objects providing status and\nstatistics of the L2TP protocol, tunnels and\nsessions.")
l2tpIpUdpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 3)).setObjects(("L2TP-MIB", "l2tpUdpStatsPeerPort"), ("L2TP-MIB", "l2tpUdpStatsLocalPort"), )
if mibBuilder.loadTexts: l2tpIpUdpGroup.setDescription("A collection of objects providing status and\nstatistics of the L2TP UDP/IP transport layer.")
l2tpDomainGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 4)).setObjects(("L2TP-MIB", "l2tpDomainStatsDrainingTunnels"), ("L2TP-MIB", "l2tpDomainConfigProxyPPPAuth"), ("L2TP-MIB", "l2tpDomainStatsActiveSessions"), ("L2TP-MIB", "l2tpDomainStatsPayloadRxDiscs"), ("L2TP-MIB", "l2tpDomainStatsActiveTunnels"), ("L2TP-MIB", "l2tpDomainStatsTotalSessions"), ("L2TP-MIB", "l2tpDomainConfigTunnelIdleTO"), ("L2TP-MIB", "l2tpDomainStatsControlRxPkts"), ("L2TP-MIB", "l2tpDomainConfigControlRWS"), ("L2TP-MIB", "l2tpDomainStatsPayloadTxPkts"), ("L2TP-MIB", "l2tpDomainStatsControlTxOctets"), ("L2TP-MIB", "l2tpDomainConfigAdminState"), ("L2TP-MIB", "l2tpDomainStatsPayloadRxOctets"), ("L2TP-MIB", "l2tpDomainConfigPayloadSeq"), ("L2TP-MIB", "l2tpDomainConfigTunnelHelloInt"), ("L2TP-MIB", "l2tpDomainConfigStorageType"), ("L2TP-MIB", "l2tpDomainConfigReassemblyTO"), ("L2TP-MIB", "l2tpDomainStatsPayloadTxOctets"), ("L2TP-MIB", "l2tpDomainStatsControlTxPkts"), ("L2TP-MIB", "l2tpDomainStatsControlRxOctets"), ("L2TP-MIB", "l2tpDomainConfigControlMaxRetxTO"), ("L2TP-MIB", "l2tpDomainConfigDrainTunnels"), ("L2TP-MIB", "l2tpDomainConfigStatus"), ("L2TP-MIB", "l2tpDomainStatsFailedAuths"), ("L2TP-MIB", "l2tpDomainStatsPayloadRxPkts"), ("L2TP-MIB", "l2tpDomainConfigControlMaxRetx"), ("L2TP-MIB", "l2tpDomainStatsTotalTunnels"), ("L2TP-MIB", "l2tpDomainStatsFailedSessions"), ("L2TP-MIB", "l2tpDomainStatsFailedTunnels"), )
if mibBuilder.loadTexts: l2tpDomainGroup.setDescription("A collection of objects providing configuration,\nstatus and statistics of L2TP tunnel domains.")
l2tpMappingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 5)).setObjects(("L2TP-MIB", "l2tpSessionMapStatus"), ("L2TP-MIB", "l2tpTunnelMapIfIndex"), ("L2TP-MIB", "l2tpSessionMapLocalSID"), ("L2TP-MIB", "l2tpSessionMapTunnelIfIndex"), )
if mibBuilder.loadTexts: l2tpMappingGroup.setDescription("A collection of objects providing index mapping.")
l2tpSecurityGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 6)).setObjects(("L2TP-MIB", "l2tpDomainConfigAuth"), ("L2TP-MIB", "l2tpTunnelConfigSecret"), ("L2TP-MIB", "l2tpTunnelConfigAuth"), ("L2TP-MIB", "l2tpDomainConfigSecret"), ("L2TP-MIB", "l2tpTunnelConfigSecurity"), ("L2TP-MIB", "l2tpDomainConfigTunnelSecurity"), )
if mibBuilder.loadTexts: l2tpSecurityGroup.setDescription("A collection of objects providing L2TP security\nconfiguration.")
l2tpTrapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 7)).setObjects(("L2TP-MIB", "l2tpTunnelAuthFailure"), )
if mibBuilder.loadTexts: l2tpTrapGroup.setDescription("A collection of L2TP trap events as specified\nin NOTIFICATION-TYPE constructs.")
l2tpHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 95, 4, 1, 8)).setObjects(("L2TP-MIB", "l2tpDomainStatsControlHCTxOctets"), ("L2TP-MIB", "l2tpDomainStatsPayloadHCRxOctets"), ("L2TP-MIB", "l2tpDomainStatsControlHCRxOctets"), ("L2TP-MIB", "l2tpDomainStatsControlHCRxPkts"), ("L2TP-MIB", "l2tpDomainStatsPayloadHCTxPkts"), ("L2TP-MIB", "l2tpDomainStatsPayloadHCTxOctets"), ("L2TP-MIB", "l2tpDomainStatsPayloadHCRxDiscs"), ("L2TP-MIB", "l2tpDomainStatsControlHCTxPkts"), ("L2TP-MIB", "l2tpDomainStatsPayloadHCRxPkts"), )
if mibBuilder.loadTexts: l2tpHCPacketGroup.setDescription("A collection of objects providing High Capacity\n64-bit counter objects.")

# Compliances

l2tpMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 95, 4, 2, 1)).setObjects(("L2TP-MIB", "l2tpDomainGroup"), ("L2TP-MIB", "l2tpStatsGroup"), ("L2TP-MIB", "l2tpIpUdpGroup"), ("L2TP-MIB", "l2tpSecurityGroup"), ("L2TP-MIB", "l2tpTrapGroup"), ("L2TP-MIB", "l2tpHCPacketGroup"), ("L2TP-MIB", "l2tpConfigGroup"), ("L2TP-MIB", "l2tpMappingGroup"), )
if mibBuilder.loadTexts: l2tpMIBFullCompliance.setDescription("When this MIB is implemented with support for\nread-create and read-write, then such an\n\n\n\nimplementation can claim full compliance. Such\nan implementation can then be both monitored\nand configured with this MIB.")
l2tpMIBReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 95, 4, 2, 2)).setObjects(("L2TP-MIB", "l2tpDomainGroup"), ("L2TP-MIB", "l2tpStatsGroup"), ("L2TP-MIB", "l2tpIpUdpGroup"), ("L2TP-MIB", "l2tpSecurityGroup"), ("L2TP-MIB", "l2tpTrapGroup"), ("L2TP-MIB", "l2tpHCPacketGroup"), ("L2TP-MIB", "l2tpConfigGroup"), ("L2TP-MIB", "l2tpMappingGroup"), )
if mibBuilder.loadTexts: l2tpMIBReadOnlyCompliance.setDescription("When this MIB is implemented without support for\nread-create and read-write (i.e. in read-only mode),\nthen such an implementation can claim read-only\ncompliance. Such an implementation can then be\nmonitored but can not be configured with this MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("L2TP-MIB", PYSNMP_MODULE_ID=l2tp)

# Types
mibBuilder.exportSymbols("L2TP-MIB", L2tpMilliSeconds=L2tpMilliSeconds)

# Objects
mibBuilder.exportSymbols("L2TP-MIB", l2tp=l2tp, l2tpNotifications=l2tpNotifications, l2tpObjects=l2tpObjects, l2tpScalar=l2tpScalar, l2tpConfig=l2tpConfig, l2tpAdminState=l2tpAdminState, l2tpDrainTunnels=l2tpDrainTunnels, l2tpStats=l2tpStats, l2tpProtocolVersions=l2tpProtocolVersions, l2tpVendorName=l2tpVendorName, l2tpFirmwareRev=l2tpFirmwareRev, l2tpDrainingTunnels=l2tpDrainingTunnels, l2tpDomainConfigTable=l2tpDomainConfigTable, l2tpDomainConfigEntry=l2tpDomainConfigEntry, l2tpDomainConfigId=l2tpDomainConfigId, l2tpDomainConfigAdminState=l2tpDomainConfigAdminState, l2tpDomainConfigDrainTunnels=l2tpDomainConfigDrainTunnels, l2tpDomainConfigAuth=l2tpDomainConfigAuth, l2tpDomainConfigSecret=l2tpDomainConfigSecret, l2tpDomainConfigTunnelSecurity=l2tpDomainConfigTunnelSecurity, l2tpDomainConfigTunnelHelloInt=l2tpDomainConfigTunnelHelloInt, l2tpDomainConfigTunnelIdleTO=l2tpDomainConfigTunnelIdleTO, l2tpDomainConfigControlRWS=l2tpDomainConfigControlRWS, l2tpDomainConfigControlMaxRetx=l2tpDomainConfigControlMaxRetx, l2tpDomainConfigControlMaxRetxTO=l2tpDomainConfigControlMaxRetxTO, l2tpDomainConfigPayloadSeq=l2tpDomainConfigPayloadSeq, l2tpDomainConfigReassemblyTO=l2tpDomainConfigReassemblyTO, l2tpDomainConfigProxyPPPAuth=l2tpDomainConfigProxyPPPAuth, l2tpDomainConfigStorageType=l2tpDomainConfigStorageType, l2tpDomainConfigStatus=l2tpDomainConfigStatus, l2tpDomainStatsTable=l2tpDomainStatsTable, l2tpDomainStatsEntry=l2tpDomainStatsEntry, l2tpDomainStatsTotalTunnels=l2tpDomainStatsTotalTunnels, l2tpDomainStatsFailedTunnels=l2tpDomainStatsFailedTunnels, l2tpDomainStatsFailedAuths=l2tpDomainStatsFailedAuths, l2tpDomainStatsActiveTunnels=l2tpDomainStatsActiveTunnels, l2tpDomainStatsTotalSessions=l2tpDomainStatsTotalSessions, l2tpDomainStatsFailedSessions=l2tpDomainStatsFailedSessions, l2tpDomainStatsActiveSessions=l2tpDomainStatsActiveSessions, l2tpDomainStatsDrainingTunnels=l2tpDomainStatsDrainingTunnels, l2tpDomainStatsControlRxOctets=l2tpDomainStatsControlRxOctets, l2tpDomainStatsControlRxPkts=l2tpDomainStatsControlRxPkts, l2tpDomainStatsControlTxOctets=l2tpDomainStatsControlTxOctets, l2tpDomainStatsControlTxPkts=l2tpDomainStatsControlTxPkts, l2tpDomainStatsPayloadRxOctets=l2tpDomainStatsPayloadRxOctets, l2tpDomainStatsPayloadRxPkts=l2tpDomainStatsPayloadRxPkts, l2tpDomainStatsPayloadRxDiscs=l2tpDomainStatsPayloadRxDiscs, l2tpDomainStatsPayloadTxOctets=l2tpDomainStatsPayloadTxOctets, l2tpDomainStatsPayloadTxPkts=l2tpDomainStatsPayloadTxPkts, l2tpDomainStatsControlHCRxOctets=l2tpDomainStatsControlHCRxOctets, l2tpDomainStatsControlHCRxPkts=l2tpDomainStatsControlHCRxPkts, l2tpDomainStatsControlHCTxOctets=l2tpDomainStatsControlHCTxOctets, l2tpDomainStatsControlHCTxPkts=l2tpDomainStatsControlHCTxPkts, l2tpDomainStatsPayloadHCRxOctets=l2tpDomainStatsPayloadHCRxOctets, l2tpDomainStatsPayloadHCRxPkts=l2tpDomainStatsPayloadHCRxPkts, l2tpDomainStatsPayloadHCRxDiscs=l2tpDomainStatsPayloadHCRxDiscs, l2tpDomainStatsPayloadHCTxOctets=l2tpDomainStatsPayloadHCTxOctets, l2tpDomainStatsPayloadHCTxPkts=l2tpDomainStatsPayloadHCTxPkts, l2tpTunnelConfigTable=l2tpTunnelConfigTable, l2tpTunnelConfigEntry=l2tpTunnelConfigEntry, l2tpTunnelConfigIfIndex=l2tpTunnelConfigIfIndex, l2tpTunnelConfigDomainId=l2tpTunnelConfigDomainId, l2tpTunnelConfigAuth=l2tpTunnelConfigAuth, l2tpTunnelConfigSecret=l2tpTunnelConfigSecret, l2tpTunnelConfigSecurity=l2tpTunnelConfigSecurity, l2tpTunnelConfigHelloInterval=l2tpTunnelConfigHelloInterval, l2tpTunnelConfigIdleTimeout=l2tpTunnelConfigIdleTimeout, l2tpTunnelConfigControlRWS=l2tpTunnelConfigControlRWS, l2tpTunnelConfigControlMaxRetx=l2tpTunnelConfigControlMaxRetx, l2tpTunnelConfigControlMaxRetxTO=l2tpTunnelConfigControlMaxRetxTO, l2tpTunnelConfigPayloadSeq=l2tpTunnelConfigPayloadSeq, l2tpTunnelConfigReassemblyTO=l2tpTunnelConfigReassemblyTO, l2tpTunnelConfigTransport=l2tpTunnelConfigTransport, l2tpTunnelConfigDrainTunnel=l2tpTunnelConfigDrainTunnel, l2tpTunnelConfigProxyPPPAuth=l2tpTunnelConfigProxyPPPAuth, l2tpTunnelStatsTable=l2tpTunnelStatsTable, l2tpTunnelStatsEntry=l2tpTunnelStatsEntry, l2tpTunnelStatsLocalTID=l2tpTunnelStatsLocalTID, l2tpTunnelStatsRemoteTID=l2tpTunnelStatsRemoteTID, l2tpTunnelStatsState=l2tpTunnelStatsState, l2tpTunnelStatsInitiated=l2tpTunnelStatsInitiated, l2tpTunnelStatsRemoteHostName=l2tpTunnelStatsRemoteHostName, l2tpTunnelStatsRemoteVendorName=l2tpTunnelStatsRemoteVendorName, l2tpTunnelStatsRemoteFirmwareRev=l2tpTunnelStatsRemoteFirmwareRev, l2tpTunnelStatsRemoteProtocolVer=l2tpTunnelStatsRemoteProtocolVer, l2tpTunnelStatsInitialRemoteRWS=l2tpTunnelStatsInitialRemoteRWS, l2tpTunnelStatsBearerCaps=l2tpTunnelStatsBearerCaps, l2tpTunnelStatsFramingCaps=l2tpTunnelStatsFramingCaps, l2tpTunnelStatsControlRxPkts=l2tpTunnelStatsControlRxPkts, l2tpTunnelStatsControlRxZLB=l2tpTunnelStatsControlRxZLB, l2tpTunnelStatsControlOutOfSeq=l2tpTunnelStatsControlOutOfSeq, l2tpTunnelStatsControlOutOfWin=l2tpTunnelStatsControlOutOfWin, l2tpTunnelStatsControlTxPkts=l2tpTunnelStatsControlTxPkts, l2tpTunnelStatsControlTxZLB=l2tpTunnelStatsControlTxZLB, l2tpTunnelStatsControlAckTO=l2tpTunnelStatsControlAckTO, l2tpTunnelStatsCurrentRemoteRWS=l2tpTunnelStatsCurrentRemoteRWS, l2tpTunnelStatsTxSeq=l2tpTunnelStatsTxSeq, l2tpTunnelStatsTxSeqAck=l2tpTunnelStatsTxSeqAck, l2tpTunnelStatsRxSeq=l2tpTunnelStatsRxSeq, l2tpTunnelStatsRxSeqAck=l2tpTunnelStatsRxSeqAck, l2tpTunnelStatsTotalSessions=l2tpTunnelStatsTotalSessions, l2tpTunnelStatsFailedSessions=l2tpTunnelStatsFailedSessions, l2tpTunnelStatsActiveSessions=l2tpTunnelStatsActiveSessions, l2tpTunnelStatsLastResultCode=l2tpTunnelStatsLastResultCode, l2tpTunnelStatsLastErrorCode=l2tpTunnelStatsLastErrorCode, l2tpTunnelStatsLastErrorMessage=l2tpTunnelStatsLastErrorMessage, l2tpTunnelStatsDrainingTunnel=l2tpTunnelStatsDrainingTunnel, l2tpSessionStatsTable=l2tpSessionStatsTable, l2tpSessionStatsEntry=l2tpSessionStatsEntry, l2tpSessionStatsTunnelIfIndex=l2tpSessionStatsTunnelIfIndex, l2tpSessionStatsIfIndex=l2tpSessionStatsIfIndex, l2tpSessionStatsLocalSID=l2tpSessionStatsLocalSID, l2tpSessionStatsRemoteSID=l2tpSessionStatsRemoteSID, l2tpSessionStatsUserName=l2tpSessionStatsUserName, l2tpSessionStatsState=l2tpSessionStatsState, l2tpSessionStatsCallType=l2tpSessionStatsCallType, l2tpSessionStatsCallSerialNumber=l2tpSessionStatsCallSerialNumber, l2tpSessionStatsTxConnectSpeed=l2tpSessionStatsTxConnectSpeed, l2tpSessionStatsRxConnectSpeed=l2tpSessionStatsRxConnectSpeed, l2tpSessionStatsCallBearerType=l2tpSessionStatsCallBearerType, l2tpSessionStatsFramingType=l2tpSessionStatsFramingType, l2tpSessionStatsPhysChanId=l2tpSessionStatsPhysChanId, l2tpSessionStatsDNIS=l2tpSessionStatsDNIS, l2tpSessionStatsCLID=l2tpSessionStatsCLID, l2tpSessionStatsSubAddress=l2tpSessionStatsSubAddress, l2tpSessionStatsPrivateGroupID=l2tpSessionStatsPrivateGroupID)
mibBuilder.exportSymbols("L2TP-MIB", l2tpSessionStatsProxyLcp=l2tpSessionStatsProxyLcp, l2tpSessionStatsAuthMethod=l2tpSessionStatsAuthMethod, l2tpSessionStatsSequencingState=l2tpSessionStatsSequencingState, l2tpSessionStatsOutSequence=l2tpSessionStatsOutSequence, l2tpSessionStatsReassemblyTO=l2tpSessionStatsReassemblyTO, l2tpSessionStatsTxSeq=l2tpSessionStatsTxSeq, l2tpSessionStatsRxSeq=l2tpSessionStatsRxSeq, l2tpTunnelMapTable=l2tpTunnelMapTable, l2tpTunnelMapEntry=l2tpTunnelMapEntry, l2tpTunnelMapLocalTID=l2tpTunnelMapLocalTID, l2tpTunnelMapIfIndex=l2tpTunnelMapIfIndex, l2tpSessionMapTable=l2tpSessionMapTable, l2tpSessionMapEntry=l2tpSessionMapEntry, l2tpSessionMapIfIndex=l2tpSessionMapIfIndex, l2tpSessionMapTunnelIfIndex=l2tpSessionMapTunnelIfIndex, l2tpSessionMapLocalSID=l2tpSessionMapLocalSID, l2tpSessionMapStatus=l2tpSessionMapStatus, l2tpTransports=l2tpTransports, l2tpTransportIpUdp=l2tpTransportIpUdp, l2tpIpUdpObjects=l2tpIpUdpObjects, l2tpUdpStatsTable=l2tpUdpStatsTable, l2tpUdpStatsEntry=l2tpUdpStatsEntry, l2tpUdpStatsIfIndex=l2tpUdpStatsIfIndex, l2tpUdpStatsPeerPort=l2tpUdpStatsPeerPort, l2tpUdpStatsLocalPort=l2tpUdpStatsLocalPort, l2tpIpUdpTraps=l2tpIpUdpTraps, l2tpConformance=l2tpConformance, l2tpGroups=l2tpGroups, l2tpCompliances=l2tpCompliances)

# Notifications
mibBuilder.exportSymbols("L2TP-MIB", l2tpTunnelAuthFailure=l2tpTunnelAuthFailure)

# Groups
mibBuilder.exportSymbols("L2TP-MIB", l2tpConfigGroup=l2tpConfigGroup, l2tpStatsGroup=l2tpStatsGroup, l2tpIpUdpGroup=l2tpIpUdpGroup, l2tpDomainGroup=l2tpDomainGroup, l2tpMappingGroup=l2tpMappingGroup, l2tpSecurityGroup=l2tpSecurityGroup, l2tpTrapGroup=l2tpTrapGroup, l2tpHCPacketGroup=l2tpHCPacketGroup)

# Compliances
mibBuilder.exportSymbols("L2TP-MIB", l2tpMIBFullCompliance=l2tpMIBFullCompliance, l2tpMIBReadOnlyCompliance=l2tpMIBReadOnlyCompliance)
