# PySNMP SMI module. Autogenerated from smidump -f python MAU-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:49 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( IANAifJackType, IANAifMauAutoNegCapBits, IANAifMauMediaAvailable, IANAifMauTypeListBits, ) = mibBuilder.importSymbols("IANA-MAU-MIB", "IANAifJackType", "IANAifMauAutoNegCapBits", "IANAifMauMediaAvailable", "IANAifMauTypeListBits")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2")
( AutonomousType, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "TextualConvention", "TruthValue")

# Types

class JackType(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(9,11,3,7,8,12,4,2,1,13,6,5,10,14,)
    namedValues = namedval.NamedValues(("other", 1), ("fiberST", 10), ("telco", 11), ("mtrj", 12), ("hssdc", 13), ("fiberLC", 14), ("rj45", 2), ("rj45S", 3), ("db9", 4), ("bnc", 5), ("fAUI", 6), ("mAUI", 7), ("fiberSC", 8), ("fiberMIC", 9), )
    

# Objects

snmpDot3MauMgt = MibIdentifier((1, 3, 6, 1, 2, 1, 26))
snmpDot3MauTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 0))
dot3RpMauBasicGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 1))
rpMauTable = MibTable((1, 3, 6, 1, 2, 1, 26, 1, 1))
if mibBuilder.loadTexts: rpMauTable.setDescription("Table of descriptive and status information\nabout the MAU(s) attached to the ports of a\nrepeater.")
rpMauEntry = MibTableRow((1, 3, 6, 1, 2, 1, 26, 1, 1, 1)).setIndexNames((0, "MAU-MIB", "rpMauGroupIndex"), (0, "MAU-MIB", "rpMauPortIndex"), (0, "MAU-MIB", "rpMauIndex"))
if mibBuilder.loadTexts: rpMauEntry.setDescription("An entry in the table, containing information\nabout a single MAU.")
rpMauGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauGroupIndex.setDescription("This variable uniquely identifies the group\ncontaining the port to which the MAU described\nby this entry is connected.\n\nNote:  In practice, a group will generally be\na field-replaceable unit (i.e., module, card,\nor board) that can fit in the physical system\nenclosure, and the group number will correspond\nto a number marked on the physical enclosure.\n\nThe group denoted by a particular value of this\nobject is the same as the group denoted by the\nsame value of rptrGroupIndex.")
rpMauPortIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauPortIndex.setDescription("This variable uniquely identifies the repeater\nport within group rpMauGroupIndex to which the\nMAU described by this entry is connected.")
rpMauIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauIndex.setDescription("This variable uniquely identifies the MAU\ndescribed by this entry from among other\nMAUs connected to the same port\n(rpMauPortIndex).")
rpMauType = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 4), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauType.setDescription("This object identifies the MAU type.  Values for\nstandard IEEE 802.3 MAU types are defined in the\nIANA maintained IANA-MAU-MIB module, as\nOBJECT-IDENTITIES of dot3MauType.\nIf the MAU type is unknown, the object identifier\nzeroDotZero is returned.")
rpMauStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,4,2,3,1,5,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("unknown", 2), ("operational", 3), ("standby", 4), ("shutdown", 5), ("reset", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rpMauStatus.setDescription("The current state of the MAU.  This object MAY\nbe implemented as a read-only object by those\nagents and MAUs that do not implement software\ncontrol of the MAU state.  Some agents may not\nsupport setting the value of this object to some\nof the enumerated values.\n\nThe value other(1) is returned if the MAU is in\na state other than one of the states 2 through\n6.\n\n\n\nThe value unknown(2) is returned when the MAU's\ntrue state is unknown; for example, when it is\nbeing initialized.\n\nA MAU in the operational(3) state is fully\nfunctional; it operates, and passes signals to its\nattached DTE or repeater port in accordance to\nits specification.\n\nA MAU in standby(4) state forces DI and CI to\nidle, and the media transmitter to idle or fault,\nif supported.  Standby(4) mode only applies to\nlink type MAUs.  The state of\nrpMauMediaAvailable is unaffected.\n\nA MAU in shutdown(5) state assumes the same\ncondition on DI, CI, and the media transmitter,\nas though it were powered down or not connected.\nThe MAU MAY return other(1) value for the\nrpMauJabberState and rpMauMediaAvailable objects\nwhen it is in this state.  For an AUI, this\nstate will remove power from the AUI.\n\nSetting this variable to the value reset(6)\nresets the MAU in the same manner as a\npower-off, power-on cycle of at least one-half\nsecond would.  The agent is not required to\nreturn the value reset(6).\n\nSetting this variable to the value\noperational(3), standby(4), or shutdown(5)\ncauses the MAU to assume the respective state,\nexcept that setting a mixing-type MAU or an AUI\nto standby(4) will cause the MAU to enter the\nshutdown state.")
rpMauMediaAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 6), IANAifMauMediaAvailable()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauMediaAvailable.setDescription("This object identifies Media Available state of\nthe MAU, complementary to the rpMauStatus.  Values\nfor the standard IEEE 802.3 Media Available states\nare defined in the IANA maintained IANA-MAU-MIB\n\n\n\nmodule, as IANAifMauMediaAvailable TC.")
rpMauMediaAvailableStateExits = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauMediaAvailableStateExits.setDescription("A count of the number of times that\nrpMauMediaAvailable for this MAU instance leaves\nthe state available(3).\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of rptrMonitorPortLastChange.")
rpMauJabberState = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("unknown", 2), ("noJabber", 3), ("jabbering", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauJabberState.setDescription("The value other(1) is returned if the jabber\nstate is not 2, 3, or 4.  The agent MUST always\nreturn other(1) for MAU type dot3MauTypeAUI.\n\nThe value unknown(2) is returned when the MAU's\ntrue state is unknown; for example, when it is\nbeing initialized.\n\nIf the MAU is not jabbering the agent returns\nnoJabber(3).  This is the 'normal' state.\n\nIf the MAU is in jabber state the agent returns\nthe jabbering(4) value.")
rpMauJabberingStateEnters = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauJabberingStateEnters.setDescription("A count of the number of times that\nmauJabberState for this MAU instance enters the\nstate jabbering(4).  For MAUs of type\ndot3MauTypeAUI, dot3MauType100BaseT4,\ndot3MauType100BaseTX, dot3MauType100BaseFX, and\nall 1000Mbps types, this counter will always\nindicate zero.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of rptrMonitorPortLastChange.")
rpMauFalseCarriers = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpMauFalseCarriers.setDescription("A count of the number of false carrier events\nduring IDLE in 100BASE-X links.  This counter\ndoes not increment at the symbol rate.  It can\nincrement after a valid carrier completion at a\nmaximum rate of once per 100 ms until the next\ncarrier event.\n\nThis counter increments only for MAUs of type\ndot3MauType100BaseT4, dot3MauType100BaseTX,\ndot3MauType100BaseFX, and all 1000Mbps types.\n\nFor all other MAU types, this counter will\nalways indicate zero.\n\nThe approximate minimum time for rollover of\nthis counter is 7.4 hours.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of rptrMonitorPortLastChange.")
rpJackTable = MibTable((1, 3, 6, 1, 2, 1, 26, 1, 2))
if mibBuilder.loadTexts: rpJackTable.setDescription("Information about the external jacks attached\nto MAUs attached to the ports of a repeater.")
rpJackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 26, 1, 2, 1)).setIndexNames((0, "MAU-MIB", "rpMauGroupIndex"), (0, "MAU-MIB", "rpMauPortIndex"), (0, "MAU-MIB", "rpMauIndex"), (0, "MAU-MIB", "rpJackIndex"))
if mibBuilder.loadTexts: rpJackEntry.setDescription("An entry in the table, containing information\nabout a particular jack.")
rpJackIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rpJackIndex.setDescription("This variable uniquely identifies the jack\ndescribed by this entry from among other jacks\nattached to the same MAU (rpMauIndex).")
rpJackType = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 2), IANAifJackType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rpJackType.setDescription("The jack connector type, as it appears on the\noutside of the system.")
dot3IfMauBasicGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 2))
ifMauTable = MibTable((1, 3, 6, 1, 2, 1, 26, 2, 1))
if mibBuilder.loadTexts: ifMauTable.setDescription("Table of descriptive and status information\nabout MAU(s) attached to an interface.")
ifMauEntry = MibTableRow((1, 3, 6, 1, 2, 1, 26, 2, 1, 1)).setIndexNames((0, "MAU-MIB", "ifMauIfIndex"), (0, "MAU-MIB", "ifMauIndex"))
if mibBuilder.loadTexts: ifMauEntry.setDescription("An entry in the table, containing information\nabout a single MAU.")
ifMauIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauIfIndex.setDescription("This variable uniquely identifies the interface\nto which the MAU described by this entry is\nconnected.")
ifMauIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauIndex.setDescription("This variable uniquely identifies the MAU\ndescribed by this entry from among other MAUs\nconnected to the same interface (ifMauIfIndex).")
ifMauType = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauType.setDescription("This object identifies the MAU type.  Values for\nstandard IEEE 802.3 MAU types are defined in the\nIANA maintained IANA-MAU-MIB module, as\nOBJECT-IDENTITIES of dot3MauType.\nIf the MAU type is unknown, the object identifier\nzeroDotZero is returned.\n\nThis object represents the operational type of\nthe MAU, as determined by either 1) the result\nof the auto-negotiation function or 2) if\nauto-negotiation is not enabled or is not\nimplemented for this MAU, by the value of the\nobject ifMauDefaultType.  In case 2), a set to\nthe object ifMauDefaultType will force the MAU\ninto the new operating mode.")
ifMauStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,4,2,3,1,5,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("unknown", 2), ("operational", 3), ("standby", 4), ("shutdown", 5), ("reset", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauStatus.setDescription("The current state of the MAU.  This object MAY\nbe implemented as a read-only object by those\nagents and MAUs that do not implement software\ncontrol of the MAU state.  Some agents may not\n\n\n\nsupport setting the value of this object to some\nof the enumerated values.\n\nThe value other(1) is returned if the MAU is in\na state other than one of the states 2 through\n6.\n\nThe value unknown(2) is returned when the MAU's\ntrue state is unknown; for example, when it is\nbeing initialized.\n\nA MAU in the operational(3) state is fully\nfunctional; it operates, and passes signals to its\nattached DTE or repeater port in accordance to\nits specification.\n\nA MAU in standby(4) state forces DI and CI to\nidle and the media transmitter to idle or fault,\nif supported.  Standby(4) mode only applies to\nlink type MAUs.  The state of\nifMauMediaAvailable is unaffected.\n\nA MAU in shutdown(5) state assumes the same\ncondition on DI, CI, and the media transmitter,\nas though it were powered down or not connected.\nThe MAU MAY return other(1) value for the\nifMauJabberState and ifMauMediaAvailable objects\nwhen it is in this state.  For an AUI, this\nstate will remove power from the AUI.\n\nSetting this variable to the value reset(6)\nresets the MAU in the same manner as a\npower-off, power-on cycle of at least one-half\nsecond would.  The agent is not required to\nreturn the value reset(6).\n\nSetting this variable to the value\noperational(3), standby(4), or shutdown(5)\ncauses the MAU to assume the respective state,\nexcept that setting a mixing-type MAU or an AUI\nto standby(4) will cause the MAU to enter the\nshutdown state.")
ifMauMediaAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 5), IANAifMauMediaAvailable()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauMediaAvailable.setDescription("This object identifies Media Available state of\nthe MAU, complementary to the ifMauStatus.  Values\nfor the standard IEEE 802.3 Media Available states\nare defined in the IANA maintained IANA-MAU-MIB\nmodule, as IANAifMauMediaAvailable TC.")
ifMauMediaAvailableStateExits = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauMediaAvailableStateExits.setDescription("A count of the number of times that\nifMauMediaAvailable for this MAU instance leaves\nthe state available(3).\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of ifCounterDiscontinuityTime.")
ifMauJabberState = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("unknown", 2), ("noJabber", 3), ("jabbering", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauJabberState.setDescription("The value other(1) is returned if the jabber\nstate is not 2, 3, or 4.  The agent MUST always\nreturn other(1) for MAU type dot3MauTypeAUI.\n\nThe value unknown(2) is returned when the MAU's\ntrue state is unknown; for example, when it is\nbeing initialized.\n\nIf the MAU is not jabbering the agent returns\nnoJabber(3).  This is the 'normal' state.\n\nIf the MAU is in jabber state the agent returns\n\n\n\nthe jabbering(4) value.")
ifMauJabberingStateEnters = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauJabberingStateEnters.setDescription("A count of the number of times that\nmauJabberState for this MAU instance enters the\nstate jabbering(4).  This counter will always\nindicate zero for MAUs of type dot3MauTypeAUI\nand those of speeds above 10Mbps.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of ifCounterDiscontinuityTime.")
ifMauFalseCarriers = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauFalseCarriers.setDescription("A count of the number of false carrier events\nduring IDLE in 100BASE-X and 1000BASE-X links.\n\nFor all other MAU types, this counter will\nalways indicate zero.  This counter does not\nincrement at the symbol rate.\n\nIt can increment after a valid carrier\ncompletion at a maximum rate of once per 100 ms\nfor 100BASE-X and once per 10us for 1000BASE-X\nuntil the next CarrierEvent.\n\nThis counter can roll over very quickly.  A\nmanagement station is advised to poll the\nifMauHCFalseCarriers instead of this counter in\norder to avoid loss of information.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of ifCounterDiscontinuityTime.")
ifMauTypeList = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 10), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauTypeList.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis object has been deprecated in favour of\nifMauTypeListBits.\n\nA value that uniquely identifies the set of\npossible IEEE 802.3 types that the MAU could be.\nThe value is a sum that initially takes the\nvalue zero.  Then, for each type capability of\nthis MAU, 2 raised to the power noted below is\nadded to the sum.  For example, a MAU that has\nthe capability to be only 10BASE-T would have a\nvalue of 512 (2**9).  In contrast, a MAU that\nsupports both 10Base-T (full duplex) and\n100BASE-TX (full duplex) would have a value of\n((2**11) + (2**16)), or 67584.\n\nThe powers of 2 assigned to the capabilities are\nthese:\n\nPower  Capability\n  0      other or unknown\n  1      AUI\n  2      10BASE-5\n  3      FOIRL\n  4      10BASE-2\n  5      10BASE-T duplex mode unknown\n  6      10BASE-FP\n  7      10BASE-FB\n  8      10BASE-FL duplex mode unknown\n  9      10BROAD36\n 10      10BASE-T  half duplex mode\n 11      10BASE-T  full duplex mode\n 12      10BASE-FL half duplex mode\n 13      10BASE-FL full duplex mode\n 14      100BASE-T4\n 15      100BASE-TX half duplex mode\n 16      100BASE-TX full duplex mode\n 17      100BASE-FX half duplex mode\n 18      100BASE-FX full duplex mode\n 19      100BASE-T2 half duplex mode\n\n\n\n 20      100BASE-T2 full duplex mode\n\nIf auto-negotiation is present on this MAU, this\nobject will map to ifMauAutoNegCapability.")
ifMauDefaultType = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 11), AutonomousType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauDefaultType.setDescription("This object identifies the default\nadministrative baseband MAU type to be used in\nconjunction with the operational MAU type\ndenoted by ifMauType.\n\nThe set of possible values for this object is\nthe same as the set defined for the ifMauType\nobject.\n\nThis object represents the\nadministratively-configured type of the MAU.  If\nauto-negotiation is not enabled or is not\nimplemented for this MAU, the value of this\nobject determines the operational type of the\nMAU.  In this case, a set to this object will\nforce the MAU into the specified operating mode.\n\nIf auto-negotiation is implemented and enabled\nfor this MAU, the operational type of the MAU\nis determined by auto-negotiation, and the value\nof this object denotes the type to which the MAU\nwill automatically revert if/when\nauto-negotiation is later disabled.\n\nNOTE TO IMPLEMENTORS:  It may be necessary to\nprovide for underlying hardware implementations\nwhich do not follow the exact behavior specified\nabove.  In particular, when\nifMauAutoNegAdminStatus transitions from enabled\nto disabled, the agent implementation MUST\nensure that the operational type of the MAU (as\nreported by ifMauType) correctly transitions to\nthe value specified by this object, rather than\ncontinuing to operate at the value earlier\ndetermined by the auto-negotiation function.")
ifMauAutoNegSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegSupported.setDescription("This object indicates whether or not\nauto-negotiation is supported on this MAU.")
ifMauTypeListBits = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 13), IANAifMauTypeListBits()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauTypeListBits.setDescription("A value that uniquely identifies the set of\npossible IEEE 802.3 types that the MAU could be.\nIf auto-negotiation is present on this MAU, this\nobject will map to ifMauAutoNegCapabilityBits.\n\nNote that this MAU may be capable of operating\nas a MAU type that is beyond the scope of this\nMIB.  This is indicated by returning the\nbit value bOther in addition to any bit values\nfor standard capabilities that are listed in the\nIANAifMauTypeListBits TC.")
ifMauHCFalseCarriers = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 14), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauHCFalseCarriers.setDescription("A count of the number of false carrier events\nduring IDLE in 100BASE-X and 1000BASE-X links.\n\nFor all other MAU types, this counter will\nalways indicate zero.  This counter does not\nincrement at the symbol rate.\n\nThis counter is a 64-bit version of\nifMauFalseCarriers.  Since the 32-bit version of\nthis counter can roll over very quickly,\nmanagement stations are advised to poll the\n64-bit version instead, in order to avoid loss\nof information.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem and at other times, as indicated by the\nvalue of ifCounterDiscontinuityTime.")
ifJackTable = MibTable((1, 3, 6, 1, 2, 1, 26, 2, 2))
if mibBuilder.loadTexts: ifJackTable.setDescription("Information about the external jacks attached\nto MAUs attached to an interface.")
ifJackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 26, 2, 2, 1)).setIndexNames((0, "MAU-MIB", "ifMauIfIndex"), (0, "MAU-MIB", "ifMauIndex"), (0, "MAU-MIB", "ifJackIndex"))
if mibBuilder.loadTexts: ifJackEntry.setDescription("An entry in the table, containing information\nabout a particular jack.")
ifJackIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ifJackIndex.setDescription("This variable uniquely identifies the jack\ndescribed by this entry from among other jacks\nattached to the same MAU.")
ifJackType = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 2), IANAifJackType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifJackType.setDescription("The jack connector type, as it appears on the\noutside of the system.")
dot3BroadMauBasicGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 3))
broadMauBasicTable = MibTable((1, 3, 6, 1, 2, 1, 26, 3, 1))
if mibBuilder.loadTexts: broadMauBasicTable.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis entire table has been deprecated.  There\nhave been no reported implementations of this\ntable, and it is unlikely that there ever will\nbe.  IEEE recommends that broadband MAU types\nshould not be used for new installations.\n\nTable of descriptive and status information\n\n\n\nabout the broadband MAUs connected to\ninterfaces.")
broadMauBasicEntry = MibTableRow((1, 3, 6, 1, 2, 1, 26, 3, 1, 1)).setIndexNames((0, "MAU-MIB", "broadMauIfIndex"), (0, "MAU-MIB", "broadMauIndex"))
if mibBuilder.loadTexts: broadMauBasicEntry.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nAn entry in the table, containing information\nabout a single broadband MAU.")
broadMauIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: broadMauIfIndex.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis variable uniquely identifies the interface\nto which the MAU described by this entry is\nconnected.")
broadMauIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: broadMauIndex.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis variable uniquely identifies the MAU\nconnected to interface broadMauIfIndex that is\n\n\n\ndescribed by this entry.")
broadMauXmtRcvSplitType = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("single", 2), ("dual", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: broadMauXmtRcvSplitType.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis object indicates the type of frequency\nmultiplexing/cabling system used to separate the\ntransmit and receive paths for the 10BROAD36\nMAU.\n\nThe value other(1) is returned if the split type\nis not either single or dual.\n\nThe value single(2) indicates a single cable\nsystem.  The value dual(3) indicates a dual\ncable system, offset normally zero.")
broadMauXmtCarrierFreq = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: broadMauXmtCarrierFreq.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis variable indicates the transmit carrier\nfrequency of the 10BROAD36 MAU in MHz/4; that\nis, in units of 250 kHz.")
broadMauTranslationFreq = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: broadMauTranslationFreq.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis variable indicates the translation offset\n\n\n\nfrequency of the 10BROAD36 MAU in MHz/4; that\nis, in units of 250 kHz.")
dot3IfMauAutoNegGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 5))
ifMauAutoNegTable = MibTable((1, 3, 6, 1, 2, 1, 26, 5, 1))
if mibBuilder.loadTexts: ifMauAutoNegTable.setDescription("Configuration and status objects for the\nauto-negotiation function of MAUs attached to\ninterfaces.\n\nThe ifMauAutoNegTable applies to systems in\nwhich auto-negotiation is supported on one or\nmore MAUs attached to interfaces.  Note that if\nauto-negotiation is present and enabled, the\nifMauType object reflects the result of the\nauto-negotiation function.")
ifMauAutoNegEntry = MibTableRow((1, 3, 6, 1, 2, 1, 26, 5, 1, 1)).setIndexNames((0, "MAU-MIB", "ifMauIfIndex"), (0, "MAU-MIB", "ifMauIndex"))
if mibBuilder.loadTexts: ifMauAutoNegEntry.setDescription("An entry in the table, containing configuration\nand status information for the auto-negotiation\nfunction of a particular MAU.")
ifMauAutoNegAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauAutoNegAdminStatus.setDescription("Setting this object to enabled(1) will cause\nthe interface that has the auto-negotiation\nsignaling ability to be enabled.\n\nIf the value of this object is disabled(2) then\nthe interface will act as it would if it had no\nauto-negotiation signaling.  Under these\nconditions, an IEEE 802.3 MAU will immediately\nbe forced to the state indicated by the value of\nthe object ifMauDefaultType.\n\nNOTE TO IMPLEMENTORS:  When\nifMauAutoNegAdminStatus transitions from enabled\nto disabled, the agent implementation MUST\nensure that the operational type of the MAU (as\nreported by ifMauType) correctly transitions to\nthe value specified by the ifMauDefaultType\nobject, rather than continuing to operate at the\nvalue earlier determined by the auto-negotiation\nfunction.")
ifMauAutoNegRemoteSignaling = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("detected", 1), ("notdetected", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegRemoteSignaling.setDescription("A value indicating whether the remote end of\nthe link is using auto-negotiation signaling.  It\ntakes the value detected(1) if and only if,\nduring the previous link negotiation, FLP Bursts\nwere received.")
ifMauAutoNegConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,4,1,5,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("configuring", 2), ("complete", 3), ("disabled", 4), ("parallelDetectFail", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegConfig.setDescription("A value indicating the current status of the\nauto-negotiation process.  The enumeration\nparallelDetectFail(5) maps to a failure in\nparallel detection as defined in 28.2.3.1 of\n[IEEE802.3].")
ifMauAutoNegCapability = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegCapability.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis object has been deprecated in favour of\nifMauAutoNegCapabilityBits.\n\nA value that uniquely identifies the set of\ncapabilities of the local auto-negotiation\nentity.  The value is a sum that initially\ntakes the value zero.  Then, for each capability\nof this interface, 2 raised to the power noted\nbelow is added to the sum.  For example, an\ninterface that has the capability to support\nonly 100Base-TX half duplex would have a value\nof 32768 (2**15).  In contrast, an interface\nthat supports both 100Base-TX half duplex and\n100Base-TX full duplex would have a value of\n98304 ((2**15) + (2**16)).\n\nThe powers of 2 assigned to the capabilities are\nthese:\n\nPower   Capability\n  0       other or unknown\n (1-9)    (reserved)\n 10       10BASE-T  half duplex mode\n 11       10BASE-T  full duplex mode\n 12       (reserved)\n\n\n\n 13       (reserved)\n 14       100BASE-T4\n 15       100BASE-TX half duplex mode\n 16       100BASE-TX full duplex mode\n 17       (reserved)\n 18       (reserved)\n 19      100BASE-T2 half duplex mode\n 20      100BASE-T2 full duplex mode\n\nNote that interfaces that support this MIB may\nhave capabilities that extend beyond the scope\nof this MIB.")
ifMauAutoNegCapAdvertised = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 6), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauAutoNegCapAdvertised.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis object has been deprecated in favour of\nifMauAutoNegCapAdvertisedBits.\n\nA value that uniquely identifies the set of\ncapabilities advertised by the local\nauto-negotiation entity. Refer to\nifMauAutoNegCapability for a description of the\npossible values of this object.\n\nCapabilities in this object that are not\navailable in ifMauAutoNegCapability cannot be\nenabled.")
ifMauAutoNegCapReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegCapReceived.setDescription("********* THIS OBJECT IS DEPRECATED **********\n\nThis object has been deprecated in favour of\nifMauAutoNegCapReceivedBits.\n\nA value that uniquely identifies the set of\n\n\n\ncapabilities received from the remote\nauto-negotiation entity. Refer to\nifMauAutoNegCapability for a description of the\npossible values of this object.\n\nNote that interfaces that support this MIB may\nbe attached to remote auto-negotiation entities\nthat have capabilities beyond the scope of this\nMIB.")
ifMauAutoNegRestart = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 8), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("restart", 1), ("norestart", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauAutoNegRestart.setDescription("If the value of this object is set to\nrestart(1) then this will force auto-negotiation\nto begin link renegotiation.  If auto-negotiation\nsignaling is disabled, a write to this object\nhas no effect.\nSetting the value of this object to norestart(2)\nhas no effect.")
ifMauAutoNegCapabilityBits = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 9), IANAifMauAutoNegCapBits()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegCapabilityBits.setDescription("A value that uniquely identifies the set of\ncapabilities of the local auto-negotiation\nentity.  Note that interfaces that support this\nMIB may have capabilities that extend beyond the\nscope of this MIB.\n\nNote that the local auto-negotiation entity may\nsupport some capabilities beyond the scope of\nthis MIB.  This is indicated by returning the\nbit value bOther in addition to any bit values\nfor standard capabilities that are listed in the\nIANAifMauAutoNegCapBits TC.")
ifMauAutoNegCapAdvertisedBits = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 10), IANAifMauAutoNegCapBits()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauAutoNegCapAdvertisedBits.setDescription("A value that uniquely identifies the set of\ncapabilities advertised by the local\nauto-negotiation entity.\n\nCapabilities in this object that are not\navailable in ifMauAutoNegCapabilityBits cannot\nbe enabled.\n\nNote that the local auto-negotiation entity may\nadvertise some capabilities beyond the scope of\nthis MIB.  This is indicated by returning the\nbit value bOther in addition to any bit values\nfor standard capabilities that are listed in the\nIANAifMauAutoNegCapBits TC.")
ifMauAutoNegCapReceivedBits = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 11), IANAifMauAutoNegCapBits()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegCapReceivedBits.setDescription("A value that uniquely identifies the set of\ncapabilities received from the remote\nauto-negotiation entity.\nNote that interfaces that support this MIB may\nbe attached to remote auto-negotiation entities\nthat have capabilities beyond the scope of this\nMIB.  This is indicated by returning the bit\nvalue bOther in addition to any bit values for\nstandard capabilities that are listed in the\nIANAifMauAutoNegCapBits TC.")
ifMauAutoNegRemoteFaultAdvertised = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,1,2,)).subtype(namedValues=namedval.NamedValues(("noError", 1), ("offline", 2), ("linkFailure", 3), ("autoNegError", 4), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifMauAutoNegRemoteFaultAdvertised.setDescription("A value that identifies any local fault\nindications that this MAU has detected and will\nadvertise at the next auto-negotiation\ninteraction for 1000Mbps MAUs.")
ifMauAutoNegRemoteFaultReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,1,2,)).subtype(namedValues=namedval.NamedValues(("noError", 1), ("offline", 2), ("linkFailure", 3), ("autoNegError", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMauAutoNegRemoteFaultReceived.setDescription("A value that identifies any fault indications\nreceived from the far end of a link by the\nlocal auto-negotiation entity for 1000Mbps\nMAUs.")
mauMod = ModuleIdentity((1, 3, 6, 1, 2, 1, 26, 6)).setRevisions(("2007-04-21 00:00","2003-09-19 00:00","1999-08-24 04:00","1997-10-31 00:00","1993-09-30 00:00",))
if mibBuilder.loadTexts: mauMod.setOrganization("IETF Ethernet Interfaces and Hub MIB Working Group")
if mibBuilder.loadTexts: mauMod.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/hubmib-charter.html\n\nMailing Lists:\nGeneral Discussion: hubmib@ietf.org\nTo Subscribe: hubmib-request@ietf.org\nIn Body: subscribe your_email_address\n\n\n\nChair: Bert Wijnen\nPostal: Alcatel-Lucent\n      Schagen 33\n      3461 GL Linschoten\n      Netherlands\nPhone: +31-348-407-775\nEMail: bwijnen@alcatel-lucent.com\n\nEditor: Edward Beili\nPostal: Actelis Networks Inc.\n      25 Bazel St., P.O.B. 10173\n      Petach-Tikva 10173\n      Israel\n Tel: +972-3-924-3491\nEMail: edward.beili@actelis.com")
if mibBuilder.loadTexts: mauMod.setDescription("Management information for 802.3 MAUs.\n\nThe following reference is used throughout this MIB module:\n\n[IEEE802.3] refers to:\n   IEEE Std 802.3, 2005 Edition: 'IEEE Standard for Information\n   technology - Telecommunications and information exchange\n   between systems - Local and metropolitan area networks -\n   Specific requirements - Part 3: Carrier sense multiple\n   access with collision detection (CSMA/CD) access method and\n   physical layer specifications'.\n\n   Of particular interest is Clause 30, 'Management'.\n\nCopyright (C) The IETF Trust (2007).\nThis version of this MIB module is part of RFC 4836;\nsee the RFC itself for full legal notices.")
mauModConf = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 6, 1))
mauModCompls = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 6, 1, 1))
mauModObjGrps = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 6, 1, 2))
mauModNotGrps = MibIdentifier((1, 3, 6, 1, 2, 1, 26, 6, 1, 3))

# Augmentions

# Notifications

rpMauJabberTrap = NotificationType((1, 3, 6, 1, 2, 1, 26, 0, 1)).setObjects(("MAU-MIB", "rpMauJabberState"), )
if mibBuilder.loadTexts: rpMauJabberTrap.setDescription("This trap is sent whenever a managed repeater\nMAU enters the jabber state.\n\nThe agent MUST throttle the generation of\nconsecutive rpMauJabberTraps so that there is at\nleast a five-second gap between them.")
ifMauJabberTrap = NotificationType((1, 3, 6, 1, 2, 1, 26, 0, 2)).setObjects(("MAU-MIB", "ifMauJabberState"), )
if mibBuilder.loadTexts: ifMauJabberTrap.setDescription("This trap is sent whenever a managed interface\nMAU enters the jabber state.\n\nThe agent MUST throttle the generation of\nconsecutive ifMauJabberTraps so that there is at\nleast a five-second gap between them.")

# Groups

mauRpGrpBasic = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 1)).setObjects(("MAU-MIB", "rpMauType"), ("MAU-MIB", "rpMauJabberingStateEnters"), ("MAU-MIB", "rpMauJabberState"), ("MAU-MIB", "rpMauMediaAvailableStateExits"), ("MAU-MIB", "rpMauGroupIndex"), ("MAU-MIB", "rpMauPortIndex"), ("MAU-MIB", "rpMauIndex"), ("MAU-MIB", "rpMauMediaAvailable"), ("MAU-MIB", "rpMauStatus"), )
if mibBuilder.loadTexts: mauRpGrpBasic.setDescription("Basic conformance group for MAUs attached to\nrepeater ports.  This group is also the\nconformance specification for RFC 1515\nimplementations.")
mauRpGrp100Mbs = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 2)).setObjects(("MAU-MIB", "rpMauFalseCarriers"), )
if mibBuilder.loadTexts: mauRpGrp100Mbs.setDescription("Conformance group for MAUs attached to\nrepeater ports with 100 Mb/s or greater\ncapability.")
mauRpGrpJack = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 3)).setObjects(("MAU-MIB", "rpJackType"), )
if mibBuilder.loadTexts: mauRpGrpJack.setDescription("Conformance group for MAUs attached to\nrepeater ports with managed jacks.")
mauIfGrpBasic = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 4)).setObjects(("MAU-MIB", "ifMauJabberingStateEnters"), ("MAU-MIB", "ifMauStatus"), ("MAU-MIB", "ifMauIndex"), ("MAU-MIB", "ifMauMediaAvailable"), ("MAU-MIB", "ifMauType"), ("MAU-MIB", "ifMauIfIndex"), ("MAU-MIB", "ifMauJabberState"), ("MAU-MIB", "ifMauMediaAvailableStateExits"), )
if mibBuilder.loadTexts: mauIfGrpBasic.setDescription("Basic conformance group for MAUs attached to\ninterfaces.  This group also provides a\nconformance specification for RFC 1515\nimplementations.")
mauIfGrp100Mbs = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 5)).setObjects(("MAU-MIB", "ifMauFalseCarriers"), ("MAU-MIB", "ifMauAutoNegSupported"), ("MAU-MIB", "ifMauTypeList"), ("MAU-MIB", "ifMauDefaultType"), )
if mibBuilder.loadTexts: mauIfGrp100Mbs.setDescription("********* THIS GROUP IS DEPRECATED **********\n\nConformance group for MAUs attached to\ninterfaces with 100 Mb/s capability.\n\nThis object group has been deprecated in favor\nof mauIfGrpHighCapacity.")
mauIfGrpJack = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 6)).setObjects(("MAU-MIB", "ifJackType"), )
if mibBuilder.loadTexts: mauIfGrpJack.setDescription("Conformance group for MAUs attached to\ninterfaces with managed jacks.")
mauIfGrpAutoNeg = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 7)).setObjects(("MAU-MIB", "ifMauAutoNegRestart"), ("MAU-MIB", "ifMauAutoNegCapReceived"), ("MAU-MIB", "ifMauAutoNegCapAdvertised"), ("MAU-MIB", "ifMauAutoNegConfig"), ("MAU-MIB", "ifMauAutoNegRemoteSignaling"), ("MAU-MIB", "ifMauAutoNegCapability"), ("MAU-MIB", "ifMauAutoNegAdminStatus"), )
if mibBuilder.loadTexts: mauIfGrpAutoNeg.setDescription("********* THIS GROUP IS DEPRECATED **********\n\nConformance group for MAUs attached to\ninterfaces with managed auto-negotiation.\n\nThis object group has been deprecated in favor\nof mauIfGrpAutoNeg2.")
mauBroadBasic = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 8)).setObjects(("MAU-MIB", "broadMauIndex"), ("MAU-MIB", "broadMauTranslationFreq"), ("MAU-MIB", "broadMauXmtCarrierFreq"), ("MAU-MIB", "broadMauIfIndex"), ("MAU-MIB", "broadMauXmtRcvSplitType"), )
if mibBuilder.loadTexts: mauBroadBasic.setDescription("********* THIS GROUP IS DEPRECATED **********\nConformance group for broadband MAUs attached\nto interfaces.\n\nThis object group is deprecated.  There have\nbeen no reported implementations of this group,\nand it was felt to be unlikely that there will\nbe any future implementations.")
mauIfGrpHighCapacity = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 9)).setObjects(("MAU-MIB", "ifMauFalseCarriers"), ("MAU-MIB", "ifMauTypeListBits"), ("MAU-MIB", "ifMauAutoNegSupported"), ("MAU-MIB", "ifMauDefaultType"), )
if mibBuilder.loadTexts: mauIfGrpHighCapacity.setDescription("Conformance group for MAUs attached to\ninterfaces with 100 Mb/s or greater capability.")
mauIfGrpAutoNeg2 = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 10)).setObjects(("MAU-MIB", "ifMauAutoNegRestart"), ("MAU-MIB", "ifMauAutoNegCapReceivedBits"), ("MAU-MIB", "ifMauAutoNegCapabilityBits"), ("MAU-MIB", "ifMauAutoNegRemoteSignaling"), ("MAU-MIB", "ifMauAutoNegCapAdvertisedBits"), ("MAU-MIB", "ifMauAutoNegConfig"), ("MAU-MIB", "ifMauAutoNegAdminStatus"), )
if mibBuilder.loadTexts: mauIfGrpAutoNeg2.setDescription("Conformance group for MAUs attached to\ninterfaces with managed auto-negotiation.")
mauIfGrpAutoNeg1000Mbps = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 11)).setObjects(("MAU-MIB", "ifMauAutoNegRemoteFaultAdvertised"), ("MAU-MIB", "ifMauAutoNegRemoteFaultReceived"), )
if mibBuilder.loadTexts: mauIfGrpAutoNeg1000Mbps.setDescription("Conformance group for 1000Mbps MAUs attached to\ninterfaces with managed auto-negotiation.")
mauIfGrpHCStats = ObjectGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 2, 12)).setObjects(("MAU-MIB", "ifMauHCFalseCarriers"), )
if mibBuilder.loadTexts: mauIfGrpHCStats.setDescription("Conformance for high capacity statistics for\nMAUs attached to interfaces.")
rpMauNotifications = NotificationGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 3, 1)).setObjects(("MAU-MIB", "rpMauJabberTrap"), )
if mibBuilder.loadTexts: rpMauNotifications.setDescription("Notifications for repeater MAUs.")
ifMauNotifications = NotificationGroup((1, 3, 6, 1, 2, 1, 26, 6, 1, 3, 2)).setObjects(("MAU-MIB", "ifMauJabberTrap"), )
if mibBuilder.loadTexts: ifMauNotifications.setDescription("Notifications for interface MAUs.")

# Compliances

mauModRpCompl = ModuleCompliance((1, 3, 6, 1, 2, 1, 26, 6, 1, 1, 1)).setObjects(("MAU-MIB", "rpMauNotifications"), ("MAU-MIB", "mauRpGrpJack"), ("MAU-MIB", "mauRpGrpBasic"), ("MAU-MIB", "mauRpGrp100Mbs"), )
if mibBuilder.loadTexts: mauModRpCompl.setDescription("******** THIS COMPLIANCE IS DEPRECATED ********\nCompliance for MAUs attached to repeater\nports.\n\nThis compliance is deprecated and replaced by\nmauModRpCompl2, which corrects an oversight by\nallowing rpMauStatus to be implemented\nread-only.")
mauModIfCompl = ModuleCompliance((1, 3, 6, 1, 2, 1, 26, 6, 1, 1, 2)).setObjects(("MAU-MIB", "ifMauNotifications"), ("MAU-MIB", "mauIfGrpJack"), ("MAU-MIB", "mauIfGrp100Mbs"), ("MAU-MIB", "mauIfGrpBasic"), ("MAU-MIB", "mauBroadBasic"), ("MAU-MIB", "mauIfGrpAutoNeg"), )
if mibBuilder.loadTexts: mauModIfCompl.setDescription("******** THIS COMPLIANCE IS DEPRECATED ********\n\nCompliance for MAUs attached to interfaces.\nThis compliance is deprecated and replaced by\nmauModIfCompl2.")
mauModIfCompl2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 26, 6, 1, 1, 3)).setObjects(("MAU-MIB", "ifMauNotifications"), ("MAU-MIB", "mauIfGrpJack"), ("MAU-MIB", "mauIfGrpAutoNeg1000Mbps"), ("MAU-MIB", "mauIfGrpBasic"), ("MAU-MIB", "mauIfGrpHighCapacity"), ("MAU-MIB", "mauIfGrpAutoNeg2"), )
if mibBuilder.loadTexts: mauModIfCompl2.setDescription("******** THIS COMPLIANCE IS DEPRECATED ********\n\nCompliance for MAUs attached to interfaces.\n\nThis compliance is deprecated and replaced by\nmauModIfCompl3.")
mauModRpCompl2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 26, 6, 1, 1, 4)).setObjects(("MAU-MIB", "rpMauNotifications"), ("MAU-MIB", "mauRpGrpJack"), ("MAU-MIB", "mauRpGrpBasic"), ("MAU-MIB", "mauRpGrp100Mbs"), )
if mibBuilder.loadTexts: mauModRpCompl2.setDescription("Compliance for MAUs attached to repeater\nports.\n\nNote that compliance with this compliance\nstatement requires compliance with the\nsnmpRptrModCompl MODULE-COMPLIANCE statement of\nthe SNMP-REPEATER-MIB (RFC 2108).")
mauModIfCompl3 = ModuleCompliance((1, 3, 6, 1, 2, 1, 26, 6, 1, 1, 5)).setObjects(("MAU-MIB", "ifMauNotifications"), ("MAU-MIB", "mauIfGrpJack"), ("MAU-MIB", "mauIfGrpAutoNeg1000Mbps"), ("MAU-MIB", "mauIfGrpBasic"), ("MAU-MIB", "mauIfGrpHighCapacity"), ("MAU-MIB", "mauIfGrpHCStats"), ("MAU-MIB", "mauIfGrpAutoNeg2"), )
if mibBuilder.loadTexts: mauModIfCompl3.setDescription("Compliance for MAUs attached to interfaces.\n\nNote that compliance with this compliance\nstatement requires compliance with the\nifCompliance3 MODULE-COMPLIANCE statement of the\nIF-MIB (RFC 2863) and the dot3Compliance2\nMODULE-COMPLIANCE statement of the\nEtherLike-MIB (RFC3635).")

# Exports

# Module identity
mibBuilder.exportSymbols("MAU-MIB", PYSNMP_MODULE_ID=mauMod)

# Types
mibBuilder.exportSymbols("MAU-MIB", JackType=JackType)

# Objects
mibBuilder.exportSymbols("MAU-MIB", snmpDot3MauMgt=snmpDot3MauMgt, snmpDot3MauTraps=snmpDot3MauTraps, dot3RpMauBasicGroup=dot3RpMauBasicGroup, rpMauTable=rpMauTable, rpMauEntry=rpMauEntry, rpMauGroupIndex=rpMauGroupIndex, rpMauPortIndex=rpMauPortIndex, rpMauIndex=rpMauIndex, rpMauType=rpMauType, rpMauStatus=rpMauStatus, rpMauMediaAvailable=rpMauMediaAvailable, rpMauMediaAvailableStateExits=rpMauMediaAvailableStateExits, rpMauJabberState=rpMauJabberState, rpMauJabberingStateEnters=rpMauJabberingStateEnters, rpMauFalseCarriers=rpMauFalseCarriers, rpJackTable=rpJackTable, rpJackEntry=rpJackEntry, rpJackIndex=rpJackIndex, rpJackType=rpJackType, dot3IfMauBasicGroup=dot3IfMauBasicGroup, ifMauTable=ifMauTable, ifMauEntry=ifMauEntry, ifMauIfIndex=ifMauIfIndex, ifMauIndex=ifMauIndex, ifMauType=ifMauType, ifMauStatus=ifMauStatus, ifMauMediaAvailable=ifMauMediaAvailable, ifMauMediaAvailableStateExits=ifMauMediaAvailableStateExits, ifMauJabberState=ifMauJabberState, ifMauJabberingStateEnters=ifMauJabberingStateEnters, ifMauFalseCarriers=ifMauFalseCarriers, ifMauTypeList=ifMauTypeList, ifMauDefaultType=ifMauDefaultType, ifMauAutoNegSupported=ifMauAutoNegSupported, ifMauTypeListBits=ifMauTypeListBits, ifMauHCFalseCarriers=ifMauHCFalseCarriers, ifJackTable=ifJackTable, ifJackEntry=ifJackEntry, ifJackIndex=ifJackIndex, ifJackType=ifJackType, dot3BroadMauBasicGroup=dot3BroadMauBasicGroup, broadMauBasicTable=broadMauBasicTable, broadMauBasicEntry=broadMauBasicEntry, broadMauIfIndex=broadMauIfIndex, broadMauIndex=broadMauIndex, broadMauXmtRcvSplitType=broadMauXmtRcvSplitType, broadMauXmtCarrierFreq=broadMauXmtCarrierFreq, broadMauTranslationFreq=broadMauTranslationFreq, dot3IfMauAutoNegGroup=dot3IfMauAutoNegGroup, ifMauAutoNegTable=ifMauAutoNegTable, ifMauAutoNegEntry=ifMauAutoNegEntry, ifMauAutoNegAdminStatus=ifMauAutoNegAdminStatus, ifMauAutoNegRemoteSignaling=ifMauAutoNegRemoteSignaling, ifMauAutoNegConfig=ifMauAutoNegConfig, ifMauAutoNegCapability=ifMauAutoNegCapability, ifMauAutoNegCapAdvertised=ifMauAutoNegCapAdvertised, ifMauAutoNegCapReceived=ifMauAutoNegCapReceived, ifMauAutoNegRestart=ifMauAutoNegRestart, ifMauAutoNegCapabilityBits=ifMauAutoNegCapabilityBits, ifMauAutoNegCapAdvertisedBits=ifMauAutoNegCapAdvertisedBits, ifMauAutoNegCapReceivedBits=ifMauAutoNegCapReceivedBits, ifMauAutoNegRemoteFaultAdvertised=ifMauAutoNegRemoteFaultAdvertised, ifMauAutoNegRemoteFaultReceived=ifMauAutoNegRemoteFaultReceived, mauMod=mauMod, mauModConf=mauModConf, mauModCompls=mauModCompls, mauModObjGrps=mauModObjGrps, mauModNotGrps=mauModNotGrps)

# Notifications
mibBuilder.exportSymbols("MAU-MIB", rpMauJabberTrap=rpMauJabberTrap, ifMauJabberTrap=ifMauJabberTrap)

# Groups
mibBuilder.exportSymbols("MAU-MIB", mauRpGrpBasic=mauRpGrpBasic, mauRpGrp100Mbs=mauRpGrp100Mbs, mauRpGrpJack=mauRpGrpJack, mauIfGrpBasic=mauIfGrpBasic, mauIfGrp100Mbs=mauIfGrp100Mbs, mauIfGrpJack=mauIfGrpJack, mauIfGrpAutoNeg=mauIfGrpAutoNeg, mauBroadBasic=mauBroadBasic, mauIfGrpHighCapacity=mauIfGrpHighCapacity, mauIfGrpAutoNeg2=mauIfGrpAutoNeg2, mauIfGrpAutoNeg1000Mbps=mauIfGrpAutoNeg1000Mbps, mauIfGrpHCStats=mauIfGrpHCStats, rpMauNotifications=rpMauNotifications, ifMauNotifications=ifMauNotifications)

# Compliances
mibBuilder.exportSymbols("MAU-MIB", mauModRpCompl=mauModRpCompl, mauModIfCompl=mauModIfCompl, mauModIfCompl2=mauModIfCompl2, mauModRpCompl2=mauModRpCompl2, mauModIfCompl3=mauModIfCompl3)
