# PySNMP SMI module. Autogenerated from smidump -f python MIDCOM-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:49 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddress, InetAddressPrefixLength, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressPrefixLength", "InetAddressType", "InetPortNumber")
( NatBindIdOrZero, ) = mibBuilder.importSymbols("NAT-MIB", "NatBindIdOrZero")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TruthValue")

# Types

class MidcomNatBindMode(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(3,2,1,)
    namedValues = namedval.NamedValues(("addressBind", 1), ("addressPortBind", 2), ("none", 3), )
    
class MidcomNatSessionIdOrZero(TextualConvention, Unsigned32):
    displayHint = "d"
    

# Objects

midcomMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 171)).setRevisions(("2007-08-09 10:11",))
if mibBuilder.loadTexts: midcomMIB.setOrganization("IETF Middlebox Communication Working Group")
if mibBuilder.loadTexts: midcomMIB.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/midcom-charter.html\n\nMailing Lists:\nGeneral Discussion: midcom@ietf.org\nTo Subscribe: midcom-request@ietf.org\nIn Body: subscribe your_email_address\n\nCo-editor:\nJuergen Quittek\nNEC Europe Ltd.\nKurfuersten-Anlage 36\n69115 Heidelberg\nGermany\nTel: +49 6221 4342-115\nEmail: quittek@nw.neclab.eu\n\nCo-editor:\nMartin Stiemerling\nNEC Europe Ltd.\nKurfuersten-Anlage 36\n69115 Heidelberg\nGermany\nTel: +49 6221 4342-113\nEmail: stiemerling@nw.neclab.eu\n\nCo-editor:\nPyda Srisuresh\nKazeon Systems, Inc.\n1161 San Antonio Rd.\nMountain View, CA 94043\nU.S.A.\nTel: +1 408 836-4773\nEmail: srisuresh@yahoo.com")
if mibBuilder.loadTexts: midcomMIB.setDescription("This MIB module defines a set of basic objects for\nconfiguring middleboxes, such as firewalls and network\n\n\n\naddress translators, in order to enable communication\nacross these devices.\n\nManaged objects defined in this MIB module are structured\nin three kinds of objects:\n  - transaction objects required according to the MIDCOM\n    protocol requirements defined in RFC 3304 and according\n    to the MIDCOM protocol semantics defined in RFC 3989,\n  - configuration objects that can be used for retrieving or\n    setting parameters of the implementation of transaction\n    objects,\n  - optional monitoring objects that provide information\n    about used resource and statistics\n\nThe transaction objects are organized in two subtrees:\n  - objects modeling MIDCOM policy rules in the\n    midcomRuleTable\n  - objects modeling MIDCOM policy rule groups in the\n    midcomGroupTable\n\nNote that typically, configuration objects are not intended\nto be written by MIDCOM clients.  In general, write access\nto these objects needs to be restricted more strictly than\nwrite access to objects in the transaction subtrees.\n\nCopyright (C) The Internet Society (2008).  This version\nof this MIB module is part of RFC 5190;  see the RFC\nitself for full legal notices.")
midcomNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 0))
midcomObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1))
midcomTransaction = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 1))
midcomRuleTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 1, 3))
if mibBuilder.loadTexts: midcomRuleTable.setDescription("This table lists policy rules.\n\nIt is indexed by the midcomRuleOwner, the\nmidcomGroupIndex, and the midcomRuleIndex.\nThis implies that a rule is a member of exactly\none group and that group membership cannot\nbe changed.\n\nEntries can be deleted by writing to\nmidcomGroupLifetime or midcomRuleLifetime\nand potentially also to midcomRuleStorageTime.")
midcomRuleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1)).setIndexNames((0, "MIDCOM-MIB", "midcomRuleOwner"), (0, "MIDCOM-MIB", "midcomGroupIndex"), (0, "MIDCOM-MIB", "midcomRuleIndex"))
if mibBuilder.loadTexts: midcomRuleEntry.setDescription("An entry describing a particular MIDCOM policy rule.")
midcomRuleOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: midcomRuleOwner.setDescription("The manager who owns this row in the midcomRuleTable.\n\nThis object SHOULD uniquely identify an authenticated\nMIDCOM client.  This object is part of the table index to\nallow for the use of the SNMPv3 View-based Access Control\nModel (VACM, RFC 3415).")
midcomRuleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: midcomRuleIndex.setDescription("The value of this object must be unique in\ncombination with the values of the objects\nmidcomRuleOwner and midcomGroupIndex in this row.")
midcomRuleAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,3,)).subtype(namedValues=namedval.NamedValues(("reserve", 1), ("enable", 2), ("notSet", 3), )).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleAdminStatus.setDescription("The value of this object indicates the desired status of\nthe policy rule.  See the definition of midcomRuleOperStatus\nfor a description of the values.\n\nWhen a midcomRuleEntry is created without explicitly setting\nthis object, its value will be notSet(3).\n\nHowever, a SET request can only set this object to either\nreserve(1) or enable(2).  Attempts to set this object to\nnotSet(3) will always fail with an 'inconsistentValue'\nerror.  Note that this error code is SNMP specific.  If the\nMIB module is used with other protocols than SNMP, errors\nwith similar semantics specific to those protocols should\nbe returned.\n\nWhen the midcomRuleAdminStatus object is set, then the\nMIDCOM-MIB implementation will try to read the respective\nrelevant objects of the entry and try to achieve the\ncorresponding midcomRuleOperStatus.\n\nSetting midcomRuleAdminStatus to value reserve(1) when\nobject midcomRuleOperStatus has a value of reserved(7)\ndoes not have any effect on the policy rule.\nSetting midcomRuleAdminStatus to value enable(2) when\nobject midcomRuleOperStatus has a value of enabled(8)\ndoes not have any effect on the policy rule.\n\nDepending on whether the midcomRuleAdminStatus is set to\nreserve(1) or enable(2), several objects must be set in\nadvance.  They serve as parameters of the policy rule to be\nestablished.\n\n\n\n\nWhen object midcomRuleAdminStatus is set to reserve(1),\nthen the following objects in the same entry are of\nrelevance:\n    - midcomRuleInterface\n    - midcomRuleTransportProtocol\n    - midcomRulePortRange\n    - midcomRuleInternalIpVersion\n    - midcomRuleExternalIpVersion\n    - midcomRuleInternalIpAddr\n    - midcomRuleInternalIpPrefixLength\n    - midcomRuleInternalPort\n    - midcomRuleLifetime\n\nMIDCOM-MIB implementation may also consider the value\nof object midcomRuleMaxIdleTime when establishing\na reserve rule.\n\nWhen object midcomRuleAdminStatus is set to enable(2),\nthen the following objects in the same entry are of\nrelevance:\n    - midcomRuleInterface\n    - midcomRuleFlowDirection\n    - midcomRuleMaxIdleTime\n    - midcomRuleTransportProtocol\n    - midcomRulePortRange\n    - midcomRuleInternalIpVersion\n    - midcomRuleExternalIpVersion\n    - midcomRuleInternalIpAddr\n    - midcomRuleInternalIpPrefixLength\n    - midcomRuleInternalPort\n    - midcomRuleExternalIpAddr\n    - midcomRuleExternalIpPrefixLength\n    - midcomRuleExternalPort\n    - midcomRuleLifetime\n\nWhen retrieved, the object returns the last set value.\nIf no value has been set, it returns the default value\nnotSet(3).")
midcomRuleOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,6,8,5,7,12,11,9,4,2,10,1,)).subtype(namedValues=namedval.NamedValues(("newEntry", 1), ("terminatedOnRequest", 10), ("terminated", 11), ("genericError", 12), ("setting", 2), ("checkingRequest", 3), ("incorrectRequest", 4), ("processingRequest", 5), ("requestRejected", 6), ("reserved", 7), ("enabled", 8), ("timedOut", 9), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleOperStatus.setDescription("The actual status of the policy rule.  The\nmidcomRuleOperStatus object may have the following values:\n\n- newEntry(1) indicates that the entry in the\n  midcomRuleTable was created, but not modified yet.\n  Such an entry needs to be filled with values specifying\n  a request first.\n\n- setting(2) indicates that the entry has been already\n  modified after generating it, but no request was made\n  yet.\n\n- checkingRequest(3) indicates that midcomRuleAdminStatus\n  has recently been set and that the MIDCOM-MIB\n  implementation is currently checking the parameters of\n  the request.  This is a transient state.  The value of\n  this object will change to either incorrectRequest(4)\n  or processingRequest(5) without any external\n  interaction.  A MIDCOM-MIB implementation MAY return\n  this value while checking request parameters.\n\n- incorrectRequest(4) indicates that checking a request\n  resulted in detecting an incorrect value in one of the\n  objects containing request parameters.  The failure\n  reason is indicated by the value of midcomRuleError.\n\n- processingRequest(5) indicates that\n  midcomRuleAdminStatus has recently been set and that\n  the MIDCOM-MIB implementation is currently processing\n  the request and trying to configure the middlebox\n  accordingly.  This is a transient state.  The value of\n  this object will change to either requestRejected(6),\n  reserved(7), or enabled(8) without any external\n  interaction.  A MIDCOM-MIB implementation MAY return\n  this value while processing a request.\n\n- requestRejected(6) indicates that a request to establish\n\n\n\n  a policy rule specified by the entry was rejected.  The\n  reason for rejection is indicated by the value of\n  midcomRuleError.\n\n- reserved(7) indicates that the entry describes an\n  established policy reserve rule.\n  These values of MidcomRuleEntry are meaningful\n  for a reserved policy rule:\n      - midcomRuleMaxIdleTime\n      - midcomRuleInterface\n      - midcomRuleTransportProtocol\n      - midcomRulePortRange\n      - midcomRuleInternalIpVersion\n      - midcomRuleExternalIpVersion\n      - midcomRuleInternalIpAddr\n      - midcomRuleInternalIpPrefixLength\n      - midcomRuleInternalPort\n      - midcomRuleOutsideIpAddr\n      - midcomRuleOutsidePort\n      - midcomRuleLifetime\n\n- enabled(8) indicates that the entry describes an\n  established policy enable rule.\n  These values of MidcomRuleEntry are meaningful\n  for an enabled policy rule:\n\n      - midcomRuleFlowDirection\n      - midcomRuleInterface\n      - midcomRuleMaxIdleTime\n      - midcomRuleTransportProtocol\n      - midcomRulePortRange\n      - midcomRuleInternalIpVersion\n      - midcomRuleExternalIpVersion\n      - midcomRuleInternalIpAddr\n      - midcomRuleInternalIpPrefixLength\n      - midcomRuleInternalPort\n      - midcomRuleExternalIpAddr\n      - midcomRuleExternalIpPrefixLength\n      - midcomRuleExternalPort\n      - midcomRuleInsideIpAddr\n      - midcomRuleInsidePort\n      - midcomRuleOutsideIpAddr\n      - midcomRuleOutsidePort\n      - midcomRuleLifetime\n\n- timedOut(9) indicates that the lifetime of a previously\n  established policy rule has expired and that the policy\n  rule is terminated for this reason.\n\n\n\n- terminatedOnRequest(10) indicates that a previously\n  established policy rule was terminated by an SNMP\n  manager setting the midcomRuleLifetime to 0 or\n  setting midcomGroupLifetime to 0.\n\n- terminated(11) indicates that a previously established\n  policy rule was terminated by the MIDCOM-MIB\n  implementation for a reason other than lifetime\n  expiration or an explicit request from a MIDCOM client.\n\n- genericError(12) indicates that the policy rule\n  specified by the entry is not established due to\n  an error condition not listed above.\n\nThe states timedOut(9), terminatedOnRequest(10), and\nterminated(11) are referred to as termination states.\n\nThe states incorrectRequest(4), requestRejected(6),\nand genericError(12) are referred to as error states.\n\nThe checkingRequest(3) and processingRequest(5)\nstates are transient states, which will lead to either\none of the error states or the reserved(7) state or the\nenabled(8) state.  MIDCOM-MIB implementations MAY return\nthese values when checking or processing requests.")
midcomRuleStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 6), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleStorageType.setDescription("When retrieved, this object returns the storage\ntype of the policy rule.  Writing to this object can\nchange the storage type of the particular row from\nvolatile(2) to nonVolatile(3) or vice versa.\n\nAttempts to set this object to permanent will always\nfail with an 'inconsistentValue' error.  Note that this\nerror code is SNMP specific.  If the MIB module is used\nwith other protocols than SNMP, errors with similar\nsemantics specific to those protocols should be\nreturned.\n\nIf midcomRuleStorageType has the value permanent(4),\nthen all objects in this row whose MAX-ACCESS value\nis read-create must be read-only.")
midcomRuleStorageTime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 7), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleStorageTime.setDescription("The value of this object specifies how long this row\ncan exist in the midcomRuleTable after the\nmidcomRuleOperStatus switched to a termination state or\nto an error state.  This object returns the remaining\ntime that the row may exist before it is aged out.\n\nAfter expiration or termination of the context, the value\nof this object ticks backwards.  The entry in the\nmidcomRuleTable is destroyed when the value reaches 0.\n\nThe value of this object may be set in order to increase\nor reduce the remaining time that the row may exist.\nSetting the value to 0 will destroy this entry as soon as\nthe midcomRuleOperStatus switched to a termination state\nor to an error state.\n\nNote that there is no guarantee that the row is stored as\nlong as this object indicates.  At any time, the MIDCOM-\nMIB implementation may decide to remove a row describing\na terminated policy rule before the storage time of the\ncorresponding row in the midcomRuleTable reaches the\nvalue of 0.  In this case, the information stored in this\nrow is not available anymore.\n\nIf object midcomRuleStorageType indicates that the policy\nrule has the storage type permanent(4), then this object has\na constant value of 4294967295.")
midcomRuleError = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 8), SnmpAdminString().clone('')).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleError.setDescription("This object contains a descriptive error message if\nthe transition into the operational status reserved(7)\nor enabled(8) failed.  Implementations must reset the\nerror message to a zero-length string when a new\n\n\n\nattempt to change the policy rule status to reserved(7)\nor enabled(8) is started.\n\nRECOMMENDED values to be returned in particular cases\ninclude\n  - 'lack of IP addresses'\n  - 'lack of port numbers'\n  - 'lack of resources'\n  - 'specified NAT interface does not exist'\n  - 'specified NAT interface does not support NAT'\n  - 'conflict with already existing policy rule'\n  - 'no internal IP wildcarding allowed'\n  - 'no external IP wildcarding allowed'\n\nThe semantics of these error messages and the corresponding\nbehavior of the MIDCOM-MIB implementation are specified\nin sections 2.3.9 and 2.3.10 of RFC 3989.")
midcomRuleInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 9), InterfaceIndexOrZero().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInterface.setDescription("This object indicates the IP interface for which\nenforcement of a policy rule is requested or performed,\nrespectively.\n\nThe interface is identified by its index in the ifTable\n(see IF-MIB in RFC 2863).  If the object has a value of 0,\nthen no particular interface is indicated.\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to request its preference\nconcerning the interface at which it requests NAT service.\nThe default value of 0 indicates that the manager does not\nhave a preferred interface or does not have sufficient\ntopology information for specifying one.  Writing to this\nobject in any state other than newEntry(1) or setting(2)\nwill always fail with an 'inconsistentValue' error.\n\n\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object indicates\nthe interface at which NAT service for this rule is\nperformed.  If NAT service is not required for enforcing\nthe policy rule, then the value of this object is 0.  Also,\nif the MIDCOM-MIB implementation cannot indicate an\ninterface, because it does not have this information or\nbecause NAT service is not offered at a particular single\ninterface, then the value of the object is 0.\n\nNote that the index of a particular interface in the\nifTable may change after a re-initialization of the\nmiddlebox, for example, after adding another interface to\nit.  In such a case, the value of this object may change,\nbut the interface referred to by the MIDCOM-MIB MUST still\nbe the same.  If, after a re-initialization of the\nmiddlebox, the interface referred to before\nre-initialization cannot be uniquely mapped anymore to a\nparticular entry in the ifTable, then the value of object\nmidcomRuleOperStatus of the same entry MUST be changed to\nterminated(11).\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleFlowDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("inbound", 1), ("outbound", 2), ("biDirectional", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleFlowDirection.setDescription("This parameter specifies the direction of enabled\ncommunication, either inbound(1), outbound(2), or\nbiDirectional(3).\n\nThe semantics of this object depends on the protocol\nthe rule relates to.  If the rule is independent of\n\n\n\nthe transport protocol (midcomRuleTransportProtocol\nhas a value of 0) or if the transport protocol is UDP,\nthen the value of midcomRuleFlowDirection indicates\nthe direction of packets traversing the middlebox.\n\nIn this case, value inbound(1) indicates that packets\nare traversing from outside to inside, value outbound(2)\nindicates that packets are traversing from inside to\noutside.  For both values, inbound(1) and outbound(2)\npackets can traverse the middlebox only unidirectional.\nA bidirectional flow is indicated by value\nbiDirectional(3).\n\nIf the transport protocol is TCP, the packet flow is\nalways bidirectional, but the value of\nmidcomRuleFlowDirection indicates that:\n\n  - inbound(1): bidirectional TCP packet flow.\n    First packet, with TCP SYN flag set, must arrive\n    at an outside interface of the middlebox.\n\n  - outbound(2): bidirectional TCP packet flow.\n    First packet, with TCP SYN flag set, must arrive\n    at an inside interface of the middlebox.\n\n  - biDirectional(3): bidirectional TCP packet flow.\n    First packet, with TCP SYN flag set, may arrive\n    at an inside or an outside interface of the middlebox.\n\nThis object is used as input to a request for\nestablishing a policy enable rule as well as for\nindicating the properties of an established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue of either newEntry(1), setting(2), or reserved(7),\nthen this object can be written by a manager in order to\nspecify a requested direction to be enabled by a policy\nrule.  Writing to this object in any state other than\nnewEntry(1), setting(2), or reserved(7) will always fail\nwith an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue enabled(8), then this object indicates the enabled\n\n\n\nflow direction.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleMaxIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 11), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleMaxIdleTime.setDescription("Maximum idle time of the policy rule in seconds.\n\nIf no packet to which the policy rule applies passes the\nmiddlebox for the specified midcomRuleMaxIdleTime, then\nthe policy rule enters the termination state timedOut(9).\n\nA value of 0 indicates that the policy does not require\nan individual idle time and that instead, a default idle\ntime chosen by the middlebox is used.\n\nA value of 4294967295 ( = 2^32 - 1 ) indicates that the\npolicy does not time out if it is idle.\n\nThis object is used as input to a request for\nestablishing a policy enable rule as well as for\nindicating the properties of an established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue of either newEntry(1), setting(2), or reserved(7),\nthen this object can be written by a manager in order to\nspecify a maximum idle time for the policy rule to be\nrequested.  Writing to this object in any state others\nthan newEntry(1), setting(2), or reserved(7) will always\nfail with an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue enabled(8), then this object indicates the maximum\nidle time of the policy rule.  Note that even if a maximum\nidle time greater than zero was requested, the middlebox\n\n\n\nmay not be able to support maximum idle times and set the\nvalue of this object to zero when entering state\nenabled(8).\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleTransportProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleTransportProtocol.setDescription("The transport protocol.\n\nValid values for midcomRuleTransportProtocol\nother than zero are defined at:\nhttp://www.iana.org/assignments/protocol-numbers\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue of either newEntry(1) or setting(2), then this\nobject can be written by a manager in order to specify a\nrequested transport protocol.  If translation of an IP\naddress only is requested, then this object must have the\ndefault value 0.  Writing to this object in any state\nother than newEntry(1) or setting(2) will always fail\nwith an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object\nindicates which transport protocol is enforced by this\npolicy rule.  A value of 0 indicates a rule acting on IP\naddresses only.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRulePortRange = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 13), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("single", 1), ("pair", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRulePortRange.setDescription("The range of port numbers.\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.  It is relevant to the\noperation of the MIDCOM-MIB implementation only if the\nvalue of object midcomTransportProtocol in the same entry\nhas a value other than 0.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to specify the requested\nsize of the port range.  With single(1) just a single\nport number is requested, with pair(2) a consecutive pair\nof port numbers is requested with the lower number being\neven.  Requesting a consecutive pair of port numbers may\nbe used by RTP [RFC3550] and may even be required to\nsupport older RTP applications.\n\nWriting to this object in any state other than\nnewEntry(1), setting(2) or reserved(7) will always fail\nwith an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue of either reserved(7) or enabled(8), then this\nobject will have the value that it had before the\ntransition to this state.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleInternalIpVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 14), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalIpVersion.setDescription("IP version of the internal address (A0) and the inside\naddress (A1).  Allowed values are ipv4(1), ipv6(2),\nipv4z(3), and ipv6z(4).\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to specify the IP version\nrequired at the inside of the middlebox.  Writing to this\nobject in any state other than newEntry(1) or setting(2)\nwill always fail with an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object\nindicates the internal/inside IP version.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleExternalIpVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 15), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalIpVersion.setDescription("IP version of the external address (A3) and the outside\naddress (A2).  Allowed values are ipv4(1) and ipv6(2).\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\n\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to specify the IP version\nrequired at the outside of the middlebox.  Writing to\nthis object in any state other than newEntry(1) or\nsetting(2) will always fail with an 'inconsistentValue'\nerror.\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object\nindicates the external/outside IP version.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7) or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleInternalIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 16), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalIpAddr.setDescription("The internal IP address (A0).\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to specify the internal IP\naddress for which a reserve policy rule or a enable policy\nrule is requested to be established.  Writing to this\nobject in any state other than newEntry(1) or setting(2)\nwill always fail with an 'inconsistentValue' error.\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object will\nhave the value which it had before the transition to this\n\n\n\nstate.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7) or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleInternalIpPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 17), InetAddressPrefixLength().clone('128')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalIpPrefixLength.setDescription("The prefix length of the internal IP address used for\nwildcarding.  A value of 0 indicates a full wildcard;\nin this case, the value of midcomRuleInternalIpAddr is\nirrelevant.  If midcomRuleInternalIpVersion has a value\nof ipv4(1), then a value > 31 indicates no wildcarding\nat all.  If midcomRuleInternalIpVersion has a value\nof ipv4(2), then a value > 127 indicates no wildcarding\nat all.  A MIDCOM-MIB implementation that does not\nsupport IP address wildcarding MUST implement this object\nas read-only with a value of 128.  A MIDCOM that does\nnot support wildcarding based on prefix length MAY\nrestrict allowed values for this object to 0 and 128.\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to specify the prefix length\nof the internal IP address for which a reserve policy rule\nor an enable policy rule is requested to be established.\nWriting to this object in any state other than newEntry(1)\nor setting(2) will always fail with an 'inconsistentValue'\nerror.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object will\nhave the value which it had before the transition to this\nstate.\n\n\n\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleInternalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 18), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalPort.setDescription("The internal port number.  A value of 0 is a wildcard.\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.  It is relevant to the\noperation of the MIDCOM-MIB implementation only if the\nvalue of object midcomTransportProtocol in the same entry\nhas a value other than 0.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1) or setting(2), then this object can be\nwritten by a manager in order to specify the internal port\nnumber for which a reserve policy rule or an enable policy\nrule is requested to be established.  Writing to this\nobject in any state other than newEntry(1) or setting(2)\nwill always fail with an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue reserved(7) or enabled(8), then this object will\nhave the value that it had before the transition to this\nstate.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleExternalIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 19), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalIpAddr.setDescription("The external IP address (A3).\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1), setting(2), or reserved(7), then this\nobject can be written by a manager in order to specify the\nexternal IP address for which an enable policy rule is\nrequested to be established.  Writing to this object in\nany state other than newEntry(1), setting(2), or reserved(7)\nwill always fail with an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue enabled(8), then this object will have the value\nthat it had before the transition to this state.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleExternalIpPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 20), InetAddressPrefixLength().clone('128')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalIpPrefixLength.setDescription("The prefix length of the external IP address used for\nwildcarding.  A value of 0 indicates a full wildcard;\nin this case, the value of midcomRuleExternalIpAddr is\nirrelevant.  If midcomRuleExternalIpVersion has a value\nof ipv4(1), then a value > 31 indicates no wildcarding\nat all.  If midcomRuleExternalIpVersion has a value\nof ipv4(2), then a value > 127 indicates no wildcarding\nat all.  A MIDCOM-MIB implementation that does not\nsupport IP address wildcarding MUST implement this object\nas read-only with a value of 128.  A MIDCOM that does\nnot support wildcarding based on prefix length MAY\nrestrict allowed values for this object to 0 and 128.\n\nThis object is used as input to a request for establishing\n\n\n\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1), setting(2), or reserved(7), then this\nobject can be written by a manager in order to specify the\nprefix length of the external IP address for which an\nenable policy rule is requested to be established.\nWriting to this object in any state other than\nnewEntry(1), setting(2), or reserved(7) will always fail\nwith an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue enabled(8), then this object will have the value\nthat it had before the transition to this state.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleExternalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 21), InetPortNumber().clone('0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalPort.setDescription("The external port number.  A value of 0 is a wildcard.\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.  It is relevant to the\noperation of the MIDCOM-MIB implementation only if the\nvalue of object midcomTransportProtocol in the same entry\nhas a value other than 0.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue newEntry(1), setting(2) or reserved(7), then this\nobject can be written by a manager in order to specify the\nexternal port number for which an enable policy rule is\nrequested to be established.  Writing to this object in\nany state other than newEntry(1), setting(2) or reserved(7)\nwill always fail with an 'inconsistentValue' error.\n\n\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has the\nvalue enabled(8), then this object will have the value\nwhich it had before the transition to this state.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7) or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleInsideIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 22), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleInsideIpAddr.setDescription("The inside IP address at the middlebox (A1).\n\nThe value of this object is relevant only if\nobject midcomRuleOperStatus of the same entry has\na value of either reserved(7) or enabled(8).")
midcomRuleInsidePort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 23), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleInsidePort.setDescription("The inside port number at the middlebox.\nA value of 0 is a wildcard.\n\nThe value of this object is relevant only if\nobject midcomRuleOperStatus of the same entry has\na value of either reserved(7) or enabled(8).")
midcomRuleOutsideIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 24), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleOutsideIpAddr.setDescription("The outside IP address at the middlebox (A2).\n\nThe value of this object is relevant only if\n\n\n\nobject midcomRuleOperStatus of the same entry has\na value of either reserved(7) or enabled(8).")
midcomRuleOutsidePort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 25), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleOutsidePort.setDescription("The outside port number at the middlebox.\nA value of 0 is a wildcard.\n\nThe value of this object is relevant only if\nobject midcomRuleOperStatus of the same entry has\na value of either reserved(7) or enabled(8).")
midcomRuleLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 26), Unsigned32().clone(180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleLifetime.setDescription("The remaining lifetime in seconds of this policy rule.\n\nLifetime of a policy rule starts when object\nmidcomRuleOperStatus in the same entry enters either\nstate reserved(7) or state enabled(8).\n\nThis object is used as input to a request for establishing\na policy rule as well as for indicating the properties of\nan established policy rule.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue of either newEntry(1) or setting(2), then this\nobject can be written by a manager in order to specify\nthe requested lifetime of a policy rule to be established.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue of either reserved(7) or enabled(8), then this\nobject indicates the (continuously decreasing) remaining\nlifetime of the established policy rule.  Note that when\nentering state reserved(7) or enabled(8), the MIDCOM-MIB\nimplementation can choose a lifetime shorter than the one\nrequested.\n\nUnlike other parameters of the policy rule, this parameter\ncan still be written in state reserved(7) and enabled(8).\n\n\n\nWriting to this object is processed by the MIDCOM-MIB\nimplementation by choosing a lifetime value that is\ngreater than 0 and less than or equal to the minimum of\nthe requested value and the value specified by object\nmidcomConfigMaxLifetime:\n\n 0 <= lt_granted <= MINIMUM(lt_requested, lt_maximum)\n\nwhere:\n   - lt_granted is the actually granted lifetime by the\n     MIDCOM-MIB implementation\n   - lt_requested is the requested lifetime of the MIDCOM\n     client\n   - lt_maximum is the value of object\n     midcomConfigMaxLifetime\n\nSNMP SET requests to this object may be rejected or the\nvalue of the object after an accepted SET operation may be\nless than the value that was contained in the SNMP SET\nrequest.\n\nSuccessfully writing a value of 0 terminates the policy\nrule.  Note that after a policy rule is terminated, still\nthe entry will exist as long as indicated by the value of\nmidcomRuleStorageTime.\n\nWriting to this object in any state other than\nnewEntry(1), setting(2), reserved(7), or enabled(7)\nwill always fail with an 'inconsistentValue' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nIf object midcomRuleOperStatus of the same entry has a\nvalue other than newEntry(1), setting(2), reserved(7), or\nenabled(8), then the value of this object is irrelevant.")
midcomRuleRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 27), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleRowStatus.setDescription("A control that allows entries to be added and removed from\nthis table.\n\n\n\nEntries can also be removed from this table by setting\nobjects midcomRuleLifetime and midcomRuleStorageTime of\nan entry to 0.\n\nAttempts to set a row notInService(2) where the value\nof the midcomRuleStorageType object is permanent(4) or\nreadOnly(5) will result in an 'notWritable' error.\n\nNote that this error code is SNMP specific.  If the MIB\nmodule is used with other protocols than SNMP, errors with\nsimilar semantics specific to those protocols should be\nreturned.\n\nThe value of this object has no effect on whether other\nobjects in this conceptual row can be modified.")
midcomGroupTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 1, 4))
if mibBuilder.loadTexts: midcomGroupTable.setDescription("This table lists all current policy rule groups.\n\nEntries in this table are created or removed\nimplicitly when entries in the midcomRuleTable are\ncreated or removed, respectively.  A group entry\nin this table only exists as long as there are\nmember rules of this group in the midcomRuleTable.\n\nThe table serves for listing the existing groups and\ntheir remaining lifetimes and for changing lifetimes\nof groups and implicitly of all group members.\nGroups and all their member policy rules can only be\ndeleted by deleting all member policies in the\nmidcomRuleTable.\n\nSetting midcomGroupLifetime will result in setting\nthe lifetime of all policy members to the same value.")
midcomGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 1, 4, 1)).setIndexNames((0, "MIDCOM-MIB", "midcomRuleOwner"), (0, "MIDCOM-MIB", "midcomGroupIndex"))
if mibBuilder.loadTexts: midcomGroupEntry.setDescription("An entry describing properties of a particular\nMIDCOM policy rule group.")
midcomGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 4, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: midcomGroupIndex.setDescription("The index of this group for the midcomRuleOwner.\nA group is identified by the combination of\nmidcomRuleOwner and midcomGroupIndex.\n\nThe value of this index must be unique per\nmidcomRuleOwner.")
midcomGroupLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 4, 1, 3), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomGroupLifetime.setDescription("When retrieved, this object delivers the maximum\nlifetime in seconds of all member rules of this group,\ni.e., of all rows in the midcomRuleTable that have the\nsame values for midcomRuleOwner and midcomGroupIndex.\n\nSuccessfully writing to this object modifies the\nlifetime of all member policies.  Successfully\nwriting a value of 0 terminates all member policies\nand implicitly deletes the group as soon as all member\nentries are removed from the midcomRuleTable.\n\nNote that after a group's lifetime is expired or is\nset to 0, still the corresponding entry in the\nmidcomGroupTable will exist as long as terminated\nmember policy rules are stored as entries in the\n\n\n\nmidcomRuleTable.\n\nWriting to this object is processed by the MIDCOM-MIB\nimplementation by choosing a lifetime value that is\ngreater than 0 and less than or equal to the minimum of\nthe requested value and the value specified by object\nmidcomConfigMaxLifetime:\n\n 0 <= lt_granted <= MINIMUM(lt_requested, lt_maximum)\n\nwhere:\n   - lt_granted is the actually granted lifetime by the\n     MIDCOM-MIB implementation\n   - lt_requested is the requested lifetime of the MIDCOM\n     client\n   - lt_maximum is the value of object\n     midcomConfigMaxLifetime\n\nSNMP SET requests to this object may be rejected or the\nvalue of the object after an accepted SET operation may be\nless than the value that was contained in the SNMP SET\nrequest.")
midcomConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 2))
midcomConfigMaxLifetime = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 2, 1), Unsigned32()).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: midcomConfigMaxLifetime.setDescription("When retrieved, this object returns the maximum lifetime,\nin seconds, that this middlebox allows policy rules to\nhave.")
midcomConfigPersistentRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 2, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigPersistentRules.setDescription("When retrieved, this object returns true(1) if the\nMIDCOM-MIB implementation can store policy rules\npersistently.  Otherwise, it returns false(2).\n\nA value of true(1) indicates that there may be\nentries in the midcomRuleTable with object\nmidcomRuleStorageType set to value nonVolatile(3).")
midcomConfigIfTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 2, 3))
if mibBuilder.loadTexts: midcomConfigIfTable.setDescription("This table indicates capabilities of the MIDCOM-MIB\nimplementation per IP interface.\n\nThe table is indexed by the object midcomConfigIfIndex.\n\nFor indexing a single interface, this object contains\nthe value of the ifIndex object that is associated\nwith the interface.  If an entry with\nmidcomConfigIfIndex = 0 occurs, then bits set in\nobjects of this entry apply to all interfaces for which\nthere is no entry in this table with the interface's\nindex.")
midcomConfigIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1)).setIndexNames((0, "MIDCOM-MIB", "midcomConfigIfIndex"))
if mibBuilder.loadTexts: midcomConfigIfEntry.setDescription("An entry describing the capabilities of a middlebox\nwith respect to the indexed IP interface.")
midcomConfigIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1, 1), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: midcomConfigIfIndex.setDescription("The index of an entry in the midcomConfigIfTable.\n\nFor values different from zero, this object\nidentifies an IP interface by containing the same\nvalue as the ifIndex object associated with the\ninterface.\n\nNote that the index of a particular interface in the\nifTable may change after a re-initialization of the\nmiddlebox, for example, after adding another interface to\nit.  In such a case, the value of this object may change,\nbut the interface referred to by the MIDCOM-MIB MUST still\nbe the same.  If, after a re-initialization of the\nmiddlebox, the interface referred to before\nre-initialization cannot be uniquely mapped anymore to a\nparticular entry in the ifTable, then the value of object\nmidcomConfigIfEnabled of the same entry MUST be changed to\nfalse(2).\n\nIf the object has a value of 0, then values\nspecified by further objects of the same entry\napply to all interfaces for which there is no\nexplicit entry in the midcomConfigIfTable.")
midcomConfigIfBits = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1, 2), Bits().subtype(namedValues=namedval.NamedValues(("ipv4", 0), ("ipv6", 1), ("addressWildcards", 2), ("portWildcards", 3), ("firewall", 4), ("nat", 5), ("portTranslation", 6), ("protocolTranslation", 7), ("twiceNat", 8), ("inside", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomConfigIfBits.setDescription("When retrieved, this object returns a set of bits\nindicating the capabilities (or configuration) of\nthe middlebox with respect to the referenced IP interface.\nIf the index equals 0, then all set bits apply to all\ninterfaces.\n\nIf the ipv4(0) bit is set, then the middlebox supports\nIPv4 at the indexed IP interface.\n\nIf the ipv6(1) bit is set, then the middlebox supports\nIPv6 at the indexed IP interface.\n\nIf the addressWildcards(2) bit is set, then the\nmiddlebox supports IP address wildcarding at the indexed\nIP interface.\n\nIf the portWildcards(3) bit is set, then the\nmiddlebox supports port wildcarding at the indexed\nIP interface.\n\nIf the firewall(4) bit is set, then the middlebox offers\nfirewall functionality at the indexed interface.\n\nIf the nat(5) bit is set, then the middlebox offers\nnetwork address translation service at the indexed\ninterface.\n\nIf the portTranslation(6) bit is set, then the middlebox\noffers port translation service at the indexed interface.\nThis bit is only relevant if nat(5) is set.\n\nIf the protocolTranslation(7) bit is set, then the\nmiddlebox offers protocol translation service between\nIPv4 and IPv6 at the indexed interface.  This bit is only\nrelevant if nat(5) is set.\n\nIf the twiceNat(8) bit is set, then the middlebox offers\ntwice network address translation service at the indexed\ninterface.  This bit is only relevant if nat(5) is set.\n\nIf the inside(9) bit is set, then the indexed interface is\n\n\n\nan inside interface with respect to NAT functionality.\nOtherwise, it is an outside interface.  This bit is only\nrelevant if nat(5) is set.  An SNMP agent supporting both\nthe MIDCOM-MIB module and the NAT-MIB module SHOULD ensure\nthat the value of this object is consistent with the values\nof corresponding objects in the NAT-MIB module.")
midcomConfigIfEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1, 3), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigIfEnabled.setDescription("The value of this object indicates the availability of\nthe middlebox service described by midcomConfigIfBits\nat the indexed IP interface.\n\nBy writing to this object, the MIDCOM support for the\nentire IP interface can be switched on or off.  Setting\nthis object to false(2) immediately stops middlebox\nsupport at the indexed IP interface.  This implies that\nall policy rules that use NAT or firewall resources at\nthe indexed IP interface are terminated immediately.\nIn this case, the MIDCOM agent MUST send\nmidcomUnsolicitedRuleEvent to all MIDCOM clients that\nhave access to one of the terminated rules.")
midcomConfigFirewallTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 2, 4))
if mibBuilder.loadTexts: midcomConfigFirewallTable.setDescription("This table lists the firewall configuration per IP interface.\n\nIt can be used for configuring how policy rules created by\nMIDCOM clients are realized as firewall rules of a firewall\nimplementation.  Particularly, the priority used for MIDCOM\npolicy rules can be configured.  For a single firewall\nimplementation at a particular IP interface, all MIDCOM\npolicy rules are realized as firewall rules with the same\n\n\n\npriority.  Also, a firewall rule group name can be\nconfigured.\n\nThe table is indexed by the object midcomConfigFirewallIndex.\nFor indexing a single interface, this object contains the\nvalue of the ifIndex object that is associated with the\ninterface.  If an entry with midcomConfigFirewallIndex = 0\noccurs, then bits set in objects of this entry apply to all\ninterfaces for which there is no entry in this table for the\ninterface's index.")
midcomConfigFirewallEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1)).setIndexNames((0, "MIDCOM-MIB", "midcomConfigFirewallIndex"))
if mibBuilder.loadTexts: midcomConfigFirewallEntry.setDescription("An entry describing a particular set of\nfirewall resources.")
midcomConfigFirewallIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1, 1), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: midcomConfigFirewallIndex.setDescription("The index of an entry in the midcomConfigFirewallTable.\n\nFor values different from 0, this object identifies an\nIP interface by containing the same value as the ifIndex\nobject associated with the interface.\n\nNote that the index of a particular interface in the\nifTable may change after a re-initialization of the\nmiddlebox, for example, after adding another interface to\nit.  In such a case, the value of this object may change,\nbut the interface referred to by the MIDCOM-MIB MUST still\nbe the same.  If, after a re-initialization of the\nmiddlebox, the interface referred to before\nre-initialization cannot be uniquely mapped anymore to a\nparticular entry in the ifTable, then the entry in the\n\n\n\nmidcomConfigFirewallTable MUST be deleted.\n\nIf the object has a value of 0, then values specified by\nfurther objects of the same entry apply to all interfaces\nfor which there is no explicit entry in the\nmidcomConfigFirewallTable.")
midcomConfigFirewallGroupId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1, 2), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigFirewallGroupId.setDescription("The firewall rule group to which all firewall rules are\nassigned that the MIDCOM server creates for the interface\nindicated by object midcomConfigFirewallIndex.  If the\nvalue of object midcomConfigFirewallIndex is 0, then all\nfirewall rules of the MIDCOM server that are created for\ninterfaces with no specific entry in the\nmidcomConfigFirewallTable are assigned to the firewall\nrule group indicated by the value of this object.")
midcomConfigFirewallPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1, 3), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigFirewallPriority.setDescription("The priority assigned to all firewall rules that the\nMIDCOM server creates for the interface indicated by\nobject midcomConfigFirewallIndex.  If the value of object\nmidcomConfigFirewallIndex is 0, then this priority is\nassigned to all firewall rules of the MIDCOM server that\nare created for interfaces for which there is no specific\nentry in the midcomConfigFirewallTable.")
midcomMonitoring = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 3))
midcomResourceTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 3, 1))
if mibBuilder.loadTexts: midcomResourceTable.setDescription("This table lists all used middlebox resources per\nMIDCOM policy rule.\n\nThe midcomResourceTable augments the\n\n\n\nmidcomRuleTable.")
midcomResourceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1))
if mibBuilder.loadTexts: midcomResourceEntry.setDescription("An entry describing a particular set of middlebox\nresources.")
midcomRscNatInternalAddrBindMode = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 4), MidcomNatBindMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInternalAddrBindMode.setDescription("An indication of whether this policy rule uses an address\nNAT bind or an address-port NAT bind for binding the\ninternal address.\n\nIf the MIDCOM-MIB module is operated together with\nthe NAT-MIB module (RFC 4008) then object\nmidcomRscNatInternalAddrBindMode contains the same\nvalue as the corresponding object\nnatSessionPrivateSrcEPBindMode of the NAT-MIB module.")
midcomRscNatInternalAddrBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 5), NatBindIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInternalAddrBindId.setDescription("This object references to the allocated internal NAT\nbind that is used by this policy rule.  A NAT bind\ndescribes the mapping of internal addresses to\noutside addresses.  MIDCOM-MIB implementations can\n\n\n\nread this object to learn the corresponding NAT bind\nresource for this particular policy rule.\n\nIf the MIDCOM-MIB module is operated together with\nthe NAT-MIB module (RFC 4008) then object\nmidcomRscNatInternalAddrBindId contains the same\nvalue as the corresponding object\nnatSessionPrivateSrcEPBindId of the NAT-MIB module.")
midcomRscNatInsideAddrBindMode = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 6), MidcomNatBindMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInsideAddrBindMode.setDescription("An indication of whether this policy rule uses an address\nNAT bind or an address-port NAT bind for binding the\nexternal address.\n\nIf the MIDCOM-MIB module is operated together with\nthe NAT-MIB module (RFC 4008), then object\nmidcomRscNatInsideAddrBindMode contains the same\nvalue as the corresponding object\nnatSessionPrivateDstEPBindMode of the NAT-MIB module.")
midcomRscNatInsideAddrBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 7), NatBindIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInsideAddrBindId.setDescription("This object refers to the allocated external NAT\nbind that is used by this policy rule.  A NAT bind\ndescribes the mapping of external addresses to\ninside addresses.  MIDCOM-MIB implementations can\nread this object to learn the corresponding NAT bind\nresource for this particular policy rule.\n\nIf the MIDCOM-MIB module is operated together with the\nNAT-MIB module (RFC 4008), then object\nmidcomRscNatInsideAddrBindId contains the same\nvalue as the corresponding object\nnatSessionPrivateDstEPBindId of the NAT-MIB module.")
midcomRscNatSessionId1 = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 8), MidcomNatSessionIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatSessionId1.setDescription("This object refers to the first allocated NAT session for\nthis policy rule.  MIDCOM-MIB implementations can read this\nobject to learn whether or not a NAT session for a\nparticular policy rule is used.  A value of 0 means that no\nNAT session is allocated for this policy rule.  A value\nother than 0 refers to the NAT session.")
midcomRscNatSessionId2 = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 9), MidcomNatSessionIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatSessionId2.setDescription("This object refers to the second allocated NAT session for\nthis policy rule.  MIDCOM-MIB implementations can read this\nobject to learn whether or not a NAT session for a\nparticular policy rule is used.  A value of 0 means that no\nNAT session is allocated for this policy rule.  A value\nother than 0 refers to the NAT session.")
midcomRscFirewallRuleId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscFirewallRuleId.setDescription("This object refers to the allocated firewall\nrule in the firewall engine for this policy rule.\nMIDCOM-MIB implementations can read this value to\nlearn whether a firewall rule for this particular\npolicy rule is used or not.  A value of 0 means that\nno firewall rule is allocated for this policy rule.\nA value other than 0 refers to the firewall rule\nnumber within the firewall engine.")
midcomStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 3, 2))
midcomCurrentOwners = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentOwners.setDescription("The number of different values for midcomRuleOwner\nfor all current entries in the midcomRuleTable.")
midcomTotalRejectedRuleEntries = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalRejectedRuleEntries.setDescription("The total number of failed attempts to create an entry\nin the midcomRuleTable.")
midcomCurrentRulesIncomplete = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentRulesIncomplete.setDescription("The current number of policy rules that are incomplete.\n\nPolicy rules are loaded via row entries in the\nmidcomRuleTable.  This object counts policy rules that are\nloaded but not fully specified, i.e., they are in state\nnewEntry(1) or setting(2).")
midcomTotalIncorrectReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalIncorrectReserveRules.setDescription("The total number of policy reserve rules that failed\nparameter check and entered state incorrectRequest(4).")
midcomTotalRejectedReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalRejectedReserveRules.setDescription("The total number of policy reserve rules that failed\nwhile being processed and entered state requestRejected(6).")
midcomCurrentActiveReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentActiveReserveRules.setDescription("The number of currently active policy reserve rules.")
midcomTotalExpiredReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalExpiredReserveRules.setDescription("The total number of expired policy reserve rules\n(entered termination state timedOut(9)).")
midcomTotalTerminatedOnRqReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedOnRqReserveRules.setDescription("The total number of policy reserve rules that were\nterminated on request (entered termination state\nterminatedOnRequest(10)).")
midcomTotalTerminatedReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedReserveRules.setDescription("The total number of policy reserve rules that were\nterminated, but not on request (entered termination state\nterminated(11)).")
midcomTotalIncorrectEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalIncorrectEnableRules.setDescription("The total number of policy enable rules that failed\nparameter check and entered state incorrectRequest(4).")
midcomTotalRejectedEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalRejectedEnableRules.setDescription("The total number of policy enable rules that failed\nwhile being processed and entered state requestRejected(6).")
midcomCurrentActiveEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentActiveEnableRules.setDescription("The number of currently active policy enable rules.")
midcomTotalExpiredEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalExpiredEnableRules.setDescription("The total number of expired policy enable rules\n(entered termination state timedOut(9)).")
midcomTotalTerminatedOnRqEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedOnRqEnableRules.setDescription("The total number of policy enable rules that were\nterminated on request (entered termination state\nterminatedOnRequest(10)).")
midcomTotalTerminatedEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedEnableRules.setDescription("The total number of policy enable rules that were\nterminated, but not on request (entered termination state\nterminated(11)).")
midcomConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 2))
midcomCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 2, 1))
midcomGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 2, 2))

# Augmentions
midcomRuleEntry.registerAugmentions(("MIDCOM-MIB", "midcomResourceEntry"))
midcomResourceEntry.setIndexNames(*midcomRuleEntry.getIndexNames())

# Notifications

midcomUnsolicitedRuleEvent = NotificationType((1, 3, 6, 1, 2, 1, 171, 0, 1)).setObjects(("MIDCOM-MIB", "midcomRuleLifetime"), ("MIDCOM-MIB", "midcomRuleOperStatus"), )
if mibBuilder.loadTexts: midcomUnsolicitedRuleEvent.setDescription("This notification is generated whenever the value of\nmidcomRuleOperStatus enters any error state or any\ntermination state without an explicit trigger by a\nMIDCOM client.")
midcomSolicitedRuleEvent = NotificationType((1, 3, 6, 1, 2, 1, 171, 0, 2)).setObjects(("MIDCOM-MIB", "midcomRuleLifetime"), ("MIDCOM-MIB", "midcomRuleOperStatus"), )
if mibBuilder.loadTexts: midcomSolicitedRuleEvent.setDescription("This notification is generated whenever the value\nof midcomRuleOperStatus enters one of the states\n{reserved, enabled, any error state, any termination state}\nas a result of a MIDCOM agent writing successfully to\nobject midcomRuleAdminStatus.\n\nIn addition, it is generated when the lifetime of\na rule was changed by successfully writing to object\nmidcomRuleLifetime.")
midcomSolicitedGroupEvent = NotificationType((1, 3, 6, 1, 2, 1, 171, 0, 3)).setObjects(("MIDCOM-MIB", "midcomGroupLifetime"), )
if mibBuilder.loadTexts: midcomSolicitedGroupEvent.setDescription("This notification is generated for indicating that the\nlifetime of all member rules of the group was changed by\nsuccessfully writing to object midcomGroupLifetime.\n\nNote that this notification is only sent if the lifetime\nof a group was changed by successfully writing to object\nmidcomGroupLifetime.  No notification is sent\n  - if a group's lifetime is changed by writing to object\n    midcomRuleLifetime of any of its member policies,\n  - if a group's lifetime expires (in this case,\n    notifications are sent for all member policies), or\n  - if the group is terminated by terminating the last\n    of its member policies without writing to object\n    midcomGroupLifetime.")

# Groups

midcomRuleGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 1)).setObjects(("MIDCOM-MIB", "midcomRuleLifetime"), ("MIDCOM-MIB", "midcomRuleRowStatus"), ("MIDCOM-MIB", "midcomRuleStorageTime"), ("MIDCOM-MIB", "midcomRuleOutsideIpAddr"), ("MIDCOM-MIB", "midcomRulePortRange"), ("MIDCOM-MIB", "midcomRuleInterface"), ("MIDCOM-MIB", "midcomRuleMaxIdleTime"), ("MIDCOM-MIB", "midcomRuleExternalPort"), ("MIDCOM-MIB", "midcomRuleInternalIpAddr"), ("MIDCOM-MIB", "midcomRuleInternalIpPrefixLength"), ("MIDCOM-MIB", "midcomRuleExternalIpVersion"), ("MIDCOM-MIB", "midcomRuleOperStatus"), ("MIDCOM-MIB", "midcomRuleFlowDirection"), ("MIDCOM-MIB", "midcomRuleInsideIpAddr"), ("MIDCOM-MIB", "midcomRuleStorageType"), ("MIDCOM-MIB", "midcomGroupLifetime"), ("MIDCOM-MIB", "midcomRuleAdminStatus"), ("MIDCOM-MIB", "midcomRuleError"), ("MIDCOM-MIB", "midcomRuleExternalIpPrefixLength"), ("MIDCOM-MIB", "midcomRuleTransportProtocol"), ("MIDCOM-MIB", "midcomRuleInsidePort"), ("MIDCOM-MIB", "midcomRuleInternalPort"), ("MIDCOM-MIB", "midcomRuleInternalIpVersion"), ("MIDCOM-MIB", "midcomRuleExternalIpAddr"), ("MIDCOM-MIB", "midcomRuleOutsidePort"), )
if mibBuilder.loadTexts: midcomRuleGroup.setDescription("A collection of objects providing information about\npolicy rules and policy rule groups.")
midcomCapabilitiesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 2)).setObjects(("MIDCOM-MIB", "midcomConfigIfEnabled"), ("MIDCOM-MIB", "midcomConfigPersistentRules"), ("MIDCOM-MIB", "midcomConfigIfBits"), ("MIDCOM-MIB", "midcomConfigMaxLifetime"), )
if mibBuilder.loadTexts: midcomCapabilitiesGroup.setDescription("A collection of objects providing information about\nthe capabilities of a middlebox.")
midcomConfigFirewallGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 3)).setObjects(("MIDCOM-MIB", "midcomConfigFirewallGroupId"), ("MIDCOM-MIB", "midcomConfigFirewallPriority"), )
if mibBuilder.loadTexts: midcomConfigFirewallGroup.setDescription("A collection of objects providing information about\nthe firewall rule group and firewall rule priority to\nbe used by firewalls loaded through MIDCOM.")
midcomResourceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 4)).setObjects(("MIDCOM-MIB", "midcomRscNatInternalAddrBindMode"), ("MIDCOM-MIB", "midcomRscNatInsideAddrBindMode"), ("MIDCOM-MIB", "midcomRscNatInsideAddrBindId"), ("MIDCOM-MIB", "midcomRscNatSessionId2"), ("MIDCOM-MIB", "midcomRscNatSessionId1"), ("MIDCOM-MIB", "midcomRscFirewallRuleId"), ("MIDCOM-MIB", "midcomRscNatInternalAddrBindId"), )
if mibBuilder.loadTexts: midcomResourceGroup.setDescription("A collection of objects providing information about\nthe used NAT and firewall resources.")
midcomStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 5)).setObjects(("MIDCOM-MIB", "midcomTotalRejectedRuleEntries"), ("MIDCOM-MIB", "midcomTotalTerminatedEnableRules"), ("MIDCOM-MIB", "midcomTotalTerminatedReserveRules"), ("MIDCOM-MIB", "midcomTotalTerminatedOnRqEnableRules"), ("MIDCOM-MIB", "midcomCurrentRulesIncomplete"), ("MIDCOM-MIB", "midcomTotalExpiredEnableRules"), ("MIDCOM-MIB", "midcomTotalIncorrectEnableRules"), ("MIDCOM-MIB", "midcomCurrentOwners"), ("MIDCOM-MIB", "midcomTotalExpiredReserveRules"), ("MIDCOM-MIB", "midcomTotalRejectedReserveRules"), ("MIDCOM-MIB", "midcomCurrentActiveEnableRules"), ("MIDCOM-MIB", "midcomTotalIncorrectReserveRules"), ("MIDCOM-MIB", "midcomCurrentActiveReserveRules"), ("MIDCOM-MIB", "midcomTotalRejectedEnableRules"), ("MIDCOM-MIB", "midcomTotalTerminatedOnRqReserveRules"), )
if mibBuilder.loadTexts: midcomStatisticsGroup.setDescription("A collection of objects providing statistical\ninformation about the MIDCOM server.")
midcomNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 6)).setObjects(("MIDCOM-MIB", "midcomUnsolicitedRuleEvent"), ("MIDCOM-MIB", "midcomSolicitedGroupEvent"), ("MIDCOM-MIB", "midcomSolicitedRuleEvent"), )
if mibBuilder.loadTexts: midcomNotificationsGroup.setDescription("The notifications emitted by the midcomMIB.")

# Compliances

midcomCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 171, 2, 1, 1)).setObjects(("MIDCOM-MIB", "midcomRuleGroup"), ("MIDCOM-MIB", "midcomResourceGroup"), ("MIDCOM-MIB", "midcomNotificationsGroup"), ("MIDCOM-MIB", "midcomStatisticsGroup"), ("MIDCOM-MIB", "midcomConfigFirewallGroup"), ("MIDCOM-MIB", "midcomCapabilitiesGroup"), )
if mibBuilder.loadTexts: midcomCompliance.setDescription("The compliance statement for implementations of the\nMIDCOM-MIB module.\n\nNote that compliance with this compliance\nstatement requires compliance with the\nifCompliance3 MODULE-COMPLIANCE statement of the\nIF-MIB [RFC2863].")

# Exports

# Module identity
mibBuilder.exportSymbols("MIDCOM-MIB", PYSNMP_MODULE_ID=midcomMIB)

# Types
mibBuilder.exportSymbols("MIDCOM-MIB", MidcomNatBindMode=MidcomNatBindMode, MidcomNatSessionIdOrZero=MidcomNatSessionIdOrZero)

# Objects
mibBuilder.exportSymbols("MIDCOM-MIB", midcomMIB=midcomMIB, midcomNotifications=midcomNotifications, midcomObjects=midcomObjects, midcomTransaction=midcomTransaction, midcomRuleTable=midcomRuleTable, midcomRuleEntry=midcomRuleEntry, midcomRuleOwner=midcomRuleOwner, midcomRuleIndex=midcomRuleIndex, midcomRuleAdminStatus=midcomRuleAdminStatus, midcomRuleOperStatus=midcomRuleOperStatus, midcomRuleStorageType=midcomRuleStorageType, midcomRuleStorageTime=midcomRuleStorageTime, midcomRuleError=midcomRuleError, midcomRuleInterface=midcomRuleInterface, midcomRuleFlowDirection=midcomRuleFlowDirection, midcomRuleMaxIdleTime=midcomRuleMaxIdleTime, midcomRuleTransportProtocol=midcomRuleTransportProtocol, midcomRulePortRange=midcomRulePortRange, midcomRuleInternalIpVersion=midcomRuleInternalIpVersion, midcomRuleExternalIpVersion=midcomRuleExternalIpVersion, midcomRuleInternalIpAddr=midcomRuleInternalIpAddr, midcomRuleInternalIpPrefixLength=midcomRuleInternalIpPrefixLength, midcomRuleInternalPort=midcomRuleInternalPort, midcomRuleExternalIpAddr=midcomRuleExternalIpAddr, midcomRuleExternalIpPrefixLength=midcomRuleExternalIpPrefixLength, midcomRuleExternalPort=midcomRuleExternalPort, midcomRuleInsideIpAddr=midcomRuleInsideIpAddr, midcomRuleInsidePort=midcomRuleInsidePort, midcomRuleOutsideIpAddr=midcomRuleOutsideIpAddr, midcomRuleOutsidePort=midcomRuleOutsidePort, midcomRuleLifetime=midcomRuleLifetime, midcomRuleRowStatus=midcomRuleRowStatus, midcomGroupTable=midcomGroupTable, midcomGroupEntry=midcomGroupEntry, midcomGroupIndex=midcomGroupIndex, midcomGroupLifetime=midcomGroupLifetime, midcomConfig=midcomConfig, midcomConfigMaxLifetime=midcomConfigMaxLifetime, midcomConfigPersistentRules=midcomConfigPersistentRules, midcomConfigIfTable=midcomConfigIfTable, midcomConfigIfEntry=midcomConfigIfEntry, midcomConfigIfIndex=midcomConfigIfIndex, midcomConfigIfBits=midcomConfigIfBits, midcomConfigIfEnabled=midcomConfigIfEnabled, midcomConfigFirewallTable=midcomConfigFirewallTable, midcomConfigFirewallEntry=midcomConfigFirewallEntry, midcomConfigFirewallIndex=midcomConfigFirewallIndex, midcomConfigFirewallGroupId=midcomConfigFirewallGroupId, midcomConfigFirewallPriority=midcomConfigFirewallPriority, midcomMonitoring=midcomMonitoring, midcomResourceTable=midcomResourceTable, midcomResourceEntry=midcomResourceEntry, midcomRscNatInternalAddrBindMode=midcomRscNatInternalAddrBindMode, midcomRscNatInternalAddrBindId=midcomRscNatInternalAddrBindId, midcomRscNatInsideAddrBindMode=midcomRscNatInsideAddrBindMode, midcomRscNatInsideAddrBindId=midcomRscNatInsideAddrBindId, midcomRscNatSessionId1=midcomRscNatSessionId1, midcomRscNatSessionId2=midcomRscNatSessionId2, midcomRscFirewallRuleId=midcomRscFirewallRuleId, midcomStatistics=midcomStatistics, midcomCurrentOwners=midcomCurrentOwners, midcomTotalRejectedRuleEntries=midcomTotalRejectedRuleEntries, midcomCurrentRulesIncomplete=midcomCurrentRulesIncomplete, midcomTotalIncorrectReserveRules=midcomTotalIncorrectReserveRules, midcomTotalRejectedReserveRules=midcomTotalRejectedReserveRules, midcomCurrentActiveReserveRules=midcomCurrentActiveReserveRules, midcomTotalExpiredReserveRules=midcomTotalExpiredReserveRules, midcomTotalTerminatedOnRqReserveRules=midcomTotalTerminatedOnRqReserveRules, midcomTotalTerminatedReserveRules=midcomTotalTerminatedReserveRules, midcomTotalIncorrectEnableRules=midcomTotalIncorrectEnableRules, midcomTotalRejectedEnableRules=midcomTotalRejectedEnableRules, midcomCurrentActiveEnableRules=midcomCurrentActiveEnableRules, midcomTotalExpiredEnableRules=midcomTotalExpiredEnableRules, midcomTotalTerminatedOnRqEnableRules=midcomTotalTerminatedOnRqEnableRules, midcomTotalTerminatedEnableRules=midcomTotalTerminatedEnableRules, midcomConformance=midcomConformance, midcomCompliances=midcomCompliances, midcomGroups=midcomGroups)

# Notifications
mibBuilder.exportSymbols("MIDCOM-MIB", midcomUnsolicitedRuleEvent=midcomUnsolicitedRuleEvent, midcomSolicitedRuleEvent=midcomSolicitedRuleEvent, midcomSolicitedGroupEvent=midcomSolicitedGroupEvent)

# Groups
mibBuilder.exportSymbols("MIDCOM-MIB", midcomRuleGroup=midcomRuleGroup, midcomCapabilitiesGroup=midcomCapabilitiesGroup, midcomConfigFirewallGroup=midcomConfigFirewallGroup, midcomResourceGroup=midcomResourceGroup, midcomStatisticsGroup=midcomStatisticsGroup, midcomNotificationsGroup=midcomNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("MIDCOM-MIB", midcomCompliance=midcomCompliance)
