# PySNMP SMI module. Autogenerated from smidump -f python MIP-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:50 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class RegistrationFlags(Bits):
    namedValues = namedval.NamedValues(("vjCompression", 0), ("gre", 1), ("minEnc", 2), ("decapsulationbyMN", 3), ("broadcastDatagram", 4), ("simultaneousBindings", 5), )
    

# Objects

mipMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 44)).setRevisions(("1996-06-04 00:00",))
if mibBuilder.loadTexts: mipMIB.setOrganization("IETF Mobile IP Working Group")
if mibBuilder.loadTexts: mipMIB.setContactInfo("       David Cong\nPostal: Motorola\n        1301 E. Algonquin Rd.\n        Schaumburg, IL 60196\nPhone:  +1-847-576-1357\nEmail:  cong@comm.mot.com")
if mibBuilder.loadTexts: mipMIB.setDescription("The MIB Module for the Mobile IP.")
mipMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1))
mipSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 1))
mipEntities = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("mobileNode", 0), ("foreignAgent", 1), ("homeAgent", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipEntities.setDescription("This object describes which Mobile IP entities are\nsupported by this managed entity. The entity may\nsupport more than one Mobile IP entities. For example,\nthe entity supports both Foreign Agent (FA) and Home\nAgent (HA). Therefore, bit 1 and bit 2 are set to 1\nfor this object.")
mipEnable = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mipEnable.setDescription("Indicates whether the Mobile IP protocol should be\nenabled for the managed entity. If it is disabled, the\nentity should disable both agent discovery and\nregistration functions.")
mipEncapsulationSupported = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 1, 3), Bits().subtype(namedValues=namedval.NamedValues(("ipInIp", 0), ("gre", 1), ("minEnc", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipEncapsulationSupported.setDescription("Encapsulation methods supported by the Mobile IP\nentity. The entity may support multiple encapsulation\nmethods or none of them:\n    ipInIp(0), -- IP Encapsulation within IP\n    gre(1),    -- Generic Routing Encapsulation,\n               -- refers to RFC1701\n    minEnc(2), -- Minimal Encapsulation within IP.")
mipSecurity = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 2))
mipSecAssocTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 2, 1))
if mibBuilder.loadTexts: mipSecAssocTable.setDescription("A table containing Mobility Security Associations.")
mipSecAssocEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1)).setIndexNames((0, "MIP-MIB", "mipSecPeerAddress"), (0, "MIP-MIB", "mipSecSPI"))
if mibBuilder.loadTexts: mipSecAssocEntry.setDescription("One particular Mobility Security Association.")
mipSecPeerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mipSecPeerAddress.setDescription("The IP address of the peer entity with which this\nnode shares the mobility security association.")
mipSecSPI = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mipSecSPI.setDescription("The SPI is the 4-byte opaque index within the\nMobility Security Association which selects the\nspecific security parameters to be used to\nauthenticate the peer, i.e. the rest of the variables\nin this MipSecAssocEntry.")
mipSecAlgorithmType = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("md5", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mipSecAlgorithmType.setDescription("Type of security algorithm.")
mipSecAlgorithmMode = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("prefixSuffix", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mipSecAlgorithmMode.setDescription("Security mode used by this algorithm.")
mipSecKey = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1, 5), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(16, 16)).setFixedLength(16)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mipSecKey.setDescription("The shared secret key for the security\nassociations. Reading this object will always return\nzero length value.")
mipSecReplayMethod = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 1, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("timestamps", 2), ("nonces", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mipSecReplayMethod.setDescription("The replay-protection method supported for this SPI\nwithin this Mobility Security Association.")
mipSecTotalViolations = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecTotalViolations.setDescription("Total number of security violations in the entity")
mipSecViolationTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 2, 3))
if mibBuilder.loadTexts: mipSecViolationTable.setDescription("A table containing information about security\nviolations.")
mipSecViolationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1)).setIndexNames((0, "MIP-MIB", "mipSecViolatorAddress"))
if mibBuilder.loadTexts: mipSecViolationEntry.setDescription("Information about one particular security violation.")
mipSecViolatorAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 1), IpAddress()).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: mipSecViolatorAddress.setDescription("Violator's IP address. The violator is not necessary\nin the mipSecAssocTable.")
mipSecViolationCounter = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecViolationCounter.setDescription("Total number of security violations for this peer.")
mipSecRecentViolationSPI = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecRecentViolationSPI.setDescription("SPI of the most recent security violation for this\npeer. If the security violation is due to an\nidentification mismatch, then this is the SPI from the\nMobile-Home Authentication Extension.  If the security\nviolation is due to an invalid authenticator, then\nthis is the SPI from the offending authentication\nextension.  In all other cases, it should be set to\nzero.")
mipSecRecentViolationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 4), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecRecentViolationTime.setDescription("Time of the most recent security violation for this\npeer.")
mipSecRecentViolationIDLow = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecRecentViolationIDLow.setDescription("Low-order 32 bits of identification used in request or\nreply of the most recent security violation for this\npeer.")
mipSecRecentViolationIDHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecRecentViolationIDHigh.setDescription("High-order 32 bits of identification used in request\nor reply of the most recent security violation for\nthis peer.")
mipSecRecentViolationReason = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 2, 3, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,6,3,2,1,4,)).subtype(namedValues=namedval.NamedValues(("noMobilitySecurityAssociation", 1), ("badAuthenticator", 2), ("badIdentifier", 3), ("badSPI", 4), ("missingSecurityExtension", 5), ("other", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mipSecRecentViolationReason.setDescription("Reason for the most recent security violation for\nthis peer.")
mipMN = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 3))
mnSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 3, 1))
mnState = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,2,4,1,3,)).subtype(namedValues=namedval.NamedValues(("home", 1), ("registered", 2), ("pending", 3), ("isolated", 4), ("unknown", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnState.setDescription("Indicates mobile node's state of Mobile IP:\nhome,\n    -- MN is connected to home network.\nregistered,\n    -- MN has registered on foreign network\npending,\n    -- MN has sent registration request and is\n       waiting for the reply\nisolated,\n    -- MN is isolated from network\nunknown\n    -- MN can not determine its state.")
mnHomeAddress = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnHomeAddress.setDescription("An IP address that is assigned for an extended period\nof time to the mobile node. It remains unchanged\nregardless of the mobile node's current point of\nattachment.")
mnHATable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 3))
if mibBuilder.loadTexts: mnHATable.setDescription("A table containing all of the mobile node's potential\nhome agents.")
mnHAEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 3, 1)).setIndexNames((0, "MIP-MIB", "mnHAAddress"))
if mibBuilder.loadTexts: mnHAEntry.setDescription("Information for a particular Home Agent.")
mnHAAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 3, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mnHAAddress.setDescription("IP address of mobile node's Home Agent.")
mnCurrentHA = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 3, 1, 2), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnCurrentHA.setDescription("Whether this home agent is the current home agent for\nthe mobile node. If it is true, the mobile node is\nregistered with that home agent.")
mnHAStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 1, 3, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: mnHAStatus.setDescription("The row status for this home agent entry. If the\nstatus is set to 'createAndGo' or 'active', then the\nmobile node can use mnHAAddress as a valid candidate\nfor a home agent. If the status is set to 'destroy',\nthen the mobile node should delete this row, and\nderegister from that home agent.")
mnDiscovery = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 3, 2))
mnFATable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 1))
if mibBuilder.loadTexts: mnFATable.setDescription("A table containing all foreign agents that the mobile\nnode knows about and their corresponding COA (care-of\naddress). This COA is an address of a foreign agent\nwith which the mobile node is registered. The table is\nupdated when advertisements are received by the mobile\nnode. If an advertisement expires, its entry(s) should\nbe deleted from the table. One foreign agent can\nprovide more than one COA in its advertisements.")
mnFAEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 1, 1)).setIndexNames((0, "MIP-MIB", "mnFAAddress"), (0, "MIP-MIB", "mnCOA"))
if mibBuilder.loadTexts: mnFAEntry.setDescription("One pair of foreign agent IP address and COA for that\nforeign agent.")
mnFAAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 1, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnFAAddress.setDescription("Foreign agent's IP address.")
mnCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 1, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnCOA.setDescription("A care-of address being offered by this foreign agent\nor a co-located care-of address which the mobile node\nhas associated with one of its own network\ninterfaces.")
mnRecentAdvReceived = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2))
mnAdvSourceAddress = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvSourceAddress.setDescription("The source IP address of the most recently received\nAgent Advertisement. This address could be the address\nof a home agent or a foreign agent.")
mnAdvSequence = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvSequence.setDescription("The sequence number of the most recently received\nadvertisement. The sequence number ranges from 0 to\n0xffff. After the sequence number attains the value\n0xffff, it will roll over to 256.")
mnAdvFlags = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2, 3), Bits().subtype(namedValues=namedval.NamedValues(("vjCompression", 0), ("gre", 1), ("minEnc", 2), ("foreignAgent", 3), ("homeAgent", 4), ("busy", 5), ("regRequired", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvFlags.setDescription("The flags are contained in the 7th byte in the\nextension of the most recently received mobility agent\nadvertisement:\n    vjCompression\n        -- Agent supports Van Jacobson compression\n    gre\n        -- Agent offers Generice Routing Encapsulation\n    minEnc,\n        -- Agent offers Minimal Encapsulation\n    foreignAgent,\n        -- Agent is a Foreign Agent\n    homeAgent,\n        -- Agent is a Home Agent\n    busy,\n        -- Foreign Agent is busy\n    regRequired,\n        -- FA registration is required.")
mnAdvMaxRegLifetime = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: mnAdvMaxRegLifetime.setDescription("The longest lifetime in seconds that the agent is\nwilling to accept in any registration request.")
mnAdvMaxAdvLifetime = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: mnAdvMaxAdvLifetime.setDescription("The maximum length of time that the Advertisement is\nconsidered valid in the absence of further\nAdvertisements.")
mnAdvTimeReceived = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 2, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvTimeReceived.setDescription("The time at which the most recently received\nadvertisement was received.")
mnSolicitationsSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnSolicitationsSent.setDescription("Total number of Solicitation sent by the mobile\nnode.")
mnAdvertisementsReceived = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvertisementsReceived.setDescription("Total number of advertisements received by the mobile\nnode.")
mnAdvsDroppedInvalidExtension = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvsDroppedInvalidExtension.setDescription("Total number of advertisements dropped by the mobile\nnode due to both poorly formed extensions and\nunrecognized extensions with extension number in the\nrange 0-127.")
mnAdvsIgnoredUnknownExtension = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAdvsIgnoredUnknownExtension.setDescription("Total number of unrecognized extensions in the range\n128-255 that were ignored by the mobile node.")
mnMoveFromHAToFA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnMoveFromHAToFA.setDescription("Number of times that the mobile node has decided to\nmove from its home network to a foreign network.")
mnMoveFromFAToFA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnMoveFromFAToFA.setDescription("Number of times that the mobile node has decided to\nmove from one foreign network to another foreign\nnetwork.")
mnMoveFromFAToHA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnMoveFromFAToHA.setDescription("Number of times that the mobile node has decided to\nmove from a foreign network to its home network.")
mnGratuitousARPsSend = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnGratuitousARPsSend.setDescription("Total number of Gratuitous ARPs sent by mobile node\nin order to clear out any stale ARP entries in the ARP\ncaches of nodes on the home network.")
mnAgentRebootsDectected = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 2, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnAgentRebootsDectected.setDescription("Total number of agent reboots detected by the mobile\nnode through sequence number of the advertisement.")
mnRegistration = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 3, 3))
mnRegistrationTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1))
if mibBuilder.loadTexts: mnRegistrationTable.setDescription("A table containing information about the mobile\nnode's attempted registration(s).  The mobile node\nupdates this table based upon Registration Requests\nsent and Registration Replies received in response to\nthese requests.  Certain variables within this table\nare also updated if when Registration Requests are\nretransmitted.")
mnRegistrationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1)).setIndexNames((0, "MIP-MIB", "mnRegAgentAddress"), (0, "MIP-MIB", "mnRegCOA"))
if mibBuilder.loadTexts: mnRegistrationEntry.setDescription("Information about one registration attempt.")
mnRegAgentAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegAgentAddress.setDescription("IP address of the agent as used in the destination\nIP address of the Registration Request.  The agent\nmay be a home agent or a foreign agent.")
mnRegCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegCOA.setDescription("Care-of address for the registration.")
mnRegFlags = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 3), RegistrationFlags()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegFlags.setDescription("Registration flags sent by the mobile node. It is the\nsecond byte in the Mobile IP Registratation Request\nmessage.")
mnRegIDLow = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegIDLow.setDescription("Low-order 32 bits of the Identification used in that\nregistration by the mobile node.")
mnRegIDHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegIDHigh.setDescription("High-order 32 bits of the Identification used in that\nregistration by the mobile node.")
mnRegTimeRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegTimeRequested.setDescription("If the registration is pending, then this is the\nlifetime requested by the mobile node (in seconds).\nIf the registration has been accepted, then this is\nthe lifetime actually granted by the home agent in the\nreply.")
mnRegTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegTimeRemaining.setDescription("The number of seconds remaining until this\nregistration expires.  It has the same initial value\nas mnRegTimeRequested and is only valid if\nmnRegIsAccepted is TRUE.")
mnRegTimeSent = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegTimeSent.setDescription("The time when the last (re-)transmission occured.")
mnRegIsAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegIsAccepted.setDescription("true(1) if the mobile node has received a\nRegistration Reply indicating that service has been\naccepted; false(2) otherwise.  false(2) implies that\nthe registration is still pending.")
mnCOAIsLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnCOAIsLocal.setDescription("Whether the COA is local to (dynamically acquired by)\nthe mobile node or not.  If it is false(2), the COA is\nan address of the foreign agent.")
mnRegRequestsSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRequestsSent.setDescription("Total number of registration requests sent by the\nmobile node. This does not include deregistrations\n(those with Lifetime equal to zero).")
mnDeRegRequestsSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnDeRegRequestsSent.setDescription("Total number of deregistration requests sent by the\nmobile node (those with Lifetime equal to zero).")
mnRegRepliesRecieved = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRepliesRecieved.setDescription("Total number of registration replies received by the\nmobile node in which the Lifetime is greater than\nzero.")
mnDeRegRepliesRecieved = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnDeRegRepliesRecieved.setDescription("Total number of (de)registration replies received by\nthe mobile node in which the Lifetime is equal to\nzero.")
mnRepliesInvalidHomeAddress = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesInvalidHomeAddress.setDescription("Total number of replies with invalid home address for\nthe mobile node.")
mnRepliesUnknownHA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesUnknownHA.setDescription("Total number of replies with unknown home agents\n(not in home agent table).")
mnRepliesUnknownFA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesUnknownFA.setDescription("Total number of replies with unknown foreign agents if\nreplies relayed through foreign agent.")
mnRepliesInvalidID = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesInvalidID.setDescription("Total number of replies with invalid Identification\nfields.")
mnRepliesDroppedInvalidExtension = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesDroppedInvalidExtension.setDescription("Total number of Registration Replies dropped by the\nmobile node due to both poorly formed extensions and\nunrecognized extensions with extension number in the\nrange 0-127.")
mnRepliesIgnoredUnknownExtension = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesIgnoredUnknownExtension.setDescription("Total number of Registration Replies that contained\none or more unrecognized extensions in the range\n128-255 that were ignored by the mobile node.")
mnRepliesHAAuthenticationFailure = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesHAAuthenticationFailure.setDescription("Total number of replies without a valid Home Agent to\nMobile Node authenticator.")
mnRepliesFAAuthenticationFailure = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRepliesFAAuthenticationFailure.setDescription("Total number of replies without a valid Foreign Agent\nto Mobile Node authenticator.")
mnRegRequestsAccepted = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRequestsAccepted.setDescription("Total number of registration requests accepted by the\nmobile node's home agent (Code 0 and Code 1).")
mnRegRequestsDeniedByHA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRequestsDeniedByHA.setDescription("Total number of registration requests denied by\nmobile node's home agent (Sum of Code 128 through\nCode 191).")
mnRegRequestsDeniedByFA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRequestsDeniedByFA.setDescription("Total number of registration requests denied by the\nforeign agent (Sum of Codes 64 through Code 127).")
mnRegRequestsDeniedByHADueToID = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRequestsDeniedByHADueToID.setDescription("Total number of Registration Request denied by home\nagent due to identification mismatch.")
mnRegRequestsWithDirectedBroadcast = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 3, 3, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mnRegRequestsWithDirectedBroadcast.setDescription("Total number of Registration Requests sent by mobile\nnode with a directed broadcast address in the home\nagent field.")
mipMA = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 4))
maAdvertisement = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 4, 2))
maAdvConfigTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1))
if mibBuilder.loadTexts: maAdvConfigTable.setDescription("A table containing configurable advertisement\nparameters for all advertisement interfaces in\nthe mobility agent.")
maAdvConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1)).setIndexNames((0, "MIP-MIB", "maInterfaceAddress"))
if mibBuilder.loadTexts: maAdvConfigEntry.setDescription("Advertisement parameters for one advertisement\ninterface.")
maInterfaceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: maInterfaceAddress.setDescription("IP address for advertisement interface.")
maAdvMaxRegLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvMaxRegLifetime.setDescription("The longest lifetime in seconds that mobility agent\nis willing to accept in any Registration Request.")
maAdvPrefixLengthInclusion = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 3), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvPrefixLengthInclusion.setDescription("Whether the advertisement should include the Prefix-\nLengths Extension. If it is true, all advertisements\nsent over this interface should include the\nPrefix-Lengths Extension.")
maAdvAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 4), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvAddress.setDescription("The IP destination address to be used for\nadvertisements sent from the interface. The only\npermissible values are the all-systems multicast\naddress (224.0.0.1) or the limited-broadcast address\n(255.255.255.255).")
maAdvMaxInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 1800))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvMaxInterval.setDescription("The maximum time in seconds between successive\ntransmissions of Agent Advertisements from this\ninterface.")
maAdvMinInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 6), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(3, 1800))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvMinInterval.setDescription("The minimum time in seconds between successive\ntransmissions of Agent Advertisements from this\ninterface.")
maAdvMaxAdvLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(4, 9000))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvMaxAdvLifetime.setDescription("The time (in seconds) to be placed in the Lifetime\nfield of the RFC 1256-portion of the Agent\nAdvertisements sent over this interface.")
maAdvResponseSolicitationOnly = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 8), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvResponseSolicitationOnly.setDescription("The flag indicates whether the advertisement from\nthat interface should be sent only in response to an\nAgent Solicitation message.")
maAdvStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 1, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: maAdvStatus.setDescription("The row status for the agent advertisement table. If\nthis column status is 'active', the manager should not\nchange any column in the row.")
maAdvertisementsSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: maAdvertisementsSent.setDescription("Total number of advertisements sent by the mobility\nagent.")
maAdvsSentForSolicitation = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: maAdvsSentForSolicitation.setDescription("Total number of advertisements sent by mobility agent\nin response to mobile node solicitations.")
maSolicitationsReceived = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 4, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: maSolicitationsReceived.setDescription("Total number of solicitations received by the\nmobility agent.")
mipFA = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 5))
faSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 5, 1))
faCOATable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 5, 1, 1))
if mibBuilder.loadTexts: faCOATable.setDescription("A table containing all of the care-of addresses\n(COAs) supported by the foreign agent. New entries can\nbe added to the table. The order of entries in the\nfaCOATAble is also the order in which the COAs are\nlisted in the Agent Advertisement.")
faCOAEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 5, 1, 1, 1)).setIndexNames((0, "MIP-MIB", "faSupportedCOA"))
if mibBuilder.loadTexts: faCOAEntry.setDescription("Entry of COA")
faSupportedCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 1, 1, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: faSupportedCOA.setDescription("Care-of-address supported by this foreign agent.")
faCOAStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 1, 1, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: faCOAStatus.setDescription("The row status for COA entry.")
faAdvertisement = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 5, 2))
faIsBusy = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 2, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faIsBusy.setDescription("Whether or not the foreign agent is too busy to\naccept additional registrations. If true(1), the agent\nis busy and any Agent advertisements sent from this\nagent should have the 'B' bit set to 1.")
faRegistrationRequired = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 2, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: faRegistrationRequired.setDescription("Whether or not this foreign agent requires\nregistration even from those mobile nodes that have\nacquired their own, colocated care-of address.  If\ntrue(1), registration is required and any Agent\nAdvertisements sent from this agent should have the\n'R' bit set to 1.")
faRegistration = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 5, 3))
faVisitorTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1))
if mibBuilder.loadTexts: faVisitorTable.setDescription("A table containing the foreign agent's visitor list.\nThe foreign agent updates this table in response to\nregistration events from mobile nodes.")
faVisitorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1)).setIndexNames((0, "MIP-MIB", "faVisitorIPAddress"))
if mibBuilder.loadTexts: faVisitorEntry.setDescription("Information for one visitor.")
faVisitorIPAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorIPAddress.setDescription("Source IP address of visitor's Registration Request.")
faVisitorHomeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorHomeAddress.setDescription("Home (IP) address of visiting mobile node.")
faVisitorHomeAgentAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorHomeAgentAddress.setDescription("Home agent IP address for that visiting mobile node.")
faVisitorTimeGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorTimeGranted.setDescription("The lifetime in seconds granted to the mobile node\nfor this registration.  Only valid if\nfaVisitorRegIsAccepted is true(1).")
faVisitorTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorTimeRemaining.setDescription("The number of seconds remaining until the\nregistration is expired. It has the same initial value\nas faVisitorTimeGranted, and is counted down by the\nforeign agent.")
faVisitorRegFlags = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 6), RegistrationFlags()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorRegFlags.setDescription("Registration flags sent by mobile node.")
faVisitorRegIDLow = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorRegIDLow.setDescription("Low 32 bits of Identification used in that\nregistration by the mobile node.")
faVisitorRegIDHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorRegIDHigh.setDescription("High 32 bits of Identification used in that\nregistration by the mobile node.")
faVisitorRegIsAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 1, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVisitorRegIsAccepted.setDescription("Whether the registration has been accepted or not. If\nit is false(2), this registration is still pending for\nreply.")
faRegRequestsReceived = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faRegRequestsReceived.setDescription("Total number of valid Registration Requests\nreceived.")
faRegRequestsRelayed = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faRegRequestsRelayed.setDescription("Total number of Registration Requests relayed to home\nagent by foreign agent.")
faReasonUnspecified = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faReasonUnspecified.setDescription("Total number of Registration Requests denied by\nforeign agent -- reason unspecified (Code 64).")
faAdmProhibited = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faAdmProhibited.setDescription("Total number of Registration Requests denied by\nforeign agent -- administratively prohibited (Code\n65).")
faInsufficientResource = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faInsufficientResource.setDescription("Total number of Registration Requests denied by\nforeign agent -- insufficient resources (Code 66).")
faMNAuthenticationFailure = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faMNAuthenticationFailure.setDescription("Total number of Registration Requests denied by\nforeign agent -- mobile node failed authentication\n(Code 67).")
faRegLifetimeTooLong = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faRegLifetimeTooLong.setDescription("Total number of Registration Requests denied by\nforeign agent -- requested lifetime too long (Code\n69).")
faPoorlyFormedRequests = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faPoorlyFormedRequests.setDescription("Total number of Registration Requests denied by\nforeign agent -- poorly formed request (Code 70).")
faEncapsulationUnavailable = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faEncapsulationUnavailable.setDescription("Total number of Registration Requests denied by\nforeign agent -- requested encapsulation unavailable\n(Code 72).")
faVJCompressionUnavailable = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faVJCompressionUnavailable.setDescription("Total number of Registration Requests denied by\nforeign agent -- requested Van Jacobson header\ncompression unavailable (Code 73).")
faHAUnreachable = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faHAUnreachable.setDescription("Total number of Registration Requests denied by\nforeign agent -- home agent unreachable (Codes\n80-95).")
faRegRepliesRecieved = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faRegRepliesRecieved.setDescription("Total number of well-formed Registration Replies\nreceived by foreign agent.")
faRegRepliesRelayed = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faRegRepliesRelayed.setDescription("Total number of valid Registration Replies relayed to\nthe mobile node by foreign agent.")
faHAAuthenticationFailure = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faHAAuthenticationFailure.setDescription("Total number of Registration Replies denied by\nforeign agent -- home agent failed authentication\n(Code 68).")
faPoorlyFormedReplies = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 5, 3, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: faPoorlyFormedReplies.setDescription("Total number of Registration Replies denied by\nforeign agent -- poorly formed reply (Code 71).")
mipHA = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 6))
haRegistration = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 1, 6, 3))
haMobilityBindingTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1))
if mibBuilder.loadTexts: haMobilityBindingTable.setDescription("A table containing the home agent's mobility binding\nlist.  The home agent updates this table in response\nto registration events from mobile nodes.")
haMobilityBindingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1)).setIndexNames((0, "MIP-MIB", "haMobilityBindingMN"), (0, "MIP-MIB", "haMobilityBindingCOA"))
if mibBuilder.loadTexts: haMobilityBindingEntry.setDescription("An entry on the mobility binding list.")
haMobilityBindingMN = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingMN.setDescription("Mobile node's home (IP) address.")
haMobilityBindingCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingCOA.setDescription("Mobile node's care-of-address. One mobile node can\nhave multiple bindings with different\ncare-of-addresses.")
haMobilityBindingSourceAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingSourceAddress.setDescription("IP source address of the Registration Request as\nreceived by the home agent.  Will be either a mobile\nnode's co-located care-of address or an address of the\nforeign agent.")
haMobilityBindingRegFlags = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 4), RegistrationFlags()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingRegFlags.setDescription("Registration flags sent by mobile node.")
haMobilityBindingRegIDLow = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingRegIDLow.setDescription("Low 32 bits of Identification used in that binding by\nthe mobile node.")
haMobilityBindingRegIDHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingRegIDHigh.setDescription("High 32 bits of Identification used in that binding by\nthe mobile node.")
haMobilityBindingTimeGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingTimeGranted.setDescription("The lifetime in seconds granted to the mobile node\nfor this registration.")
haMobilityBindingTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 1, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMobilityBindingTimeRemaining.setDescription("The number of seconds remaining until the\nregistration is expired. It has the same initial value\nas haMobilityBindingTimeGranted, and is counted down\nby the home agent.")
haCounterTable = MibTable((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2))
if mibBuilder.loadTexts: haCounterTable.setDescription("A table containing registration statistics for all\nmobile nodes authorized to use this home agent.")
haCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1)).setIndexNames((0, "MIP-MIB", "haMobilityBindingMN"))
if mibBuilder.loadTexts: haCounterEntry.setDescription("Registration statistics for one mobile node.")
haServiceRequestsAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haServiceRequestsAccepted.setDescription("Total number of service requests for the mobile node\naccepted by the home agent (Code 0 + Code 1).")
haServiceRequestsDenied = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haServiceRequestsDenied.setDescription("Total number of service requests for the mobile node\ndenied by the home agent (sum of all registrations\ndenied with Code 128 through Code 159).")
haOverallServiceTime = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haOverallServiceTime.setDescription("Overall service time (in seconds) that has\naccumulated for the mobile node since the home agent\nlast rebooted.")
haRecentServiceAcceptedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haRecentServiceAcceptedTime.setDescription("The time at which the most recent Registration\nRequest was accepted by the home agent for this mobile\nnode.")
haRecentServiceDeniedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haRecentServiceDeniedTime.setDescription("The time at which the most recent Registration\nRequest was denied by the home agent for this mobile\nnode.")
haRecentServiceDeniedCode = MibTableColumn((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 2, 1, 7), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(128,136,134,133,131,129,132,130,135,)).subtype(namedValues=namedval.NamedValues(("reasonUnspecified", 128), ("admProhibited", 129), ("insufficientResource", 130), ("mnAuthenticationFailure", 131), ("faAuthenticationFailure", 132), ("idMismatch", 133), ("poorlyFormedRequest", 134), ("tooManyBindings", 135), ("unknownHA", 136), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: haRecentServiceDeniedCode.setDescription("The Code indicating the reason why the most recent\nRegistration Request for this mobile node was rejected\nby the home agent.")
haRegistrationAccepted = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haRegistrationAccepted.setDescription("Total number of Registration Requests accepted by\nhome agent (Code 0).")
haMultiBindingUnsupported = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMultiBindingUnsupported.setDescription("Total number of Registration Requests accepted by\nhome agent -- simultaneous mobility bindings\nunsupported (Code 1).")
haReasonUnspecified = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haReasonUnspecified.setDescription("Total number of Registration Requests denied by home\nagent -- reason unspecified (Code 128).")
haAdmProhibited = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haAdmProhibited.setDescription("Total number of Registration Requests denied by home\nagent -- administratively prohibited (Code 129).")
haInsufficientResource = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haInsufficientResource.setDescription("Total number of Registration Requests denied by home\nagent -- insufficient resources (Code 130).")
haMNAuthenticationFailure = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haMNAuthenticationFailure.setDescription("Total number of Registration Requests denied by home\nagent -- mobile node failed authentication (Code\n131).")
haFAAuthenticationFailure = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haFAAuthenticationFailure.setDescription("Total number of Registration Requests denied by home\nagent -- foreign agent failed authentication (Code\n132).")
haIDMismatch = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haIDMismatch.setDescription("Total number of Registration Requests denied by home\nagent -- Identification mismatch (Code 133).")
haPoorlyFormedRequest = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haPoorlyFormedRequest.setDescription("Total number of Registration Requests denied by home\nagent -- poorly formed request (Code 134).")
haTooManyBindings = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haTooManyBindings.setDescription("Total number of Registration Requests denied by home\nagent -- too many simultaneous mobility bindings (Code\n135).")
haUnknownHA = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haUnknownHA.setDescription("Total number of Registration Requests denied by home\nagent -- unknown home agent address (Code 136).")
haGratuitiousARPsSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haGratuitiousARPsSent.setDescription("Total number of gratuition ARPs sent by the home\nagent on behalf of mobile nodes.")
haProxyARPsSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haProxyARPsSent.setDescription("Total number of proxy ARPs sent by the home agent on\nbehalf of mobile nodes.")
haRegRequestsReceived = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haRegRequestsReceived.setDescription("Total number of Registration Requests received by\nhome agent.")
haDeRegRequestsReceived = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haDeRegRequestsReceived.setDescription("Total number of Registration Requests received by the\nhome agent with a Lifetime of zero (requests to\nderegister).")
haRegRepliesSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haRegRepliesSent.setDescription("Total number of Registration Replies sent by the home\nagent.")
haDeRegRepliesSent = MibScalar((1, 3, 6, 1, 2, 1, 44, 1, 6, 3, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: haDeRegRepliesSent.setDescription("Total number of Registration Replies sent by the home\nagent in response to requests to deregister.")
mipMIBNotificationPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 2))
mipMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 2, 0))
mipMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 3))
mipGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 3, 1))
mipCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 44, 3, 2))

# Augmentions

# Notifications

mipAuthFailure = NotificationType((1, 3, 6, 1, 2, 1, 44, 2, 0, 1)).setObjects(("MIP-MIB", "mipSecRecentViolationIDLow"), ("MIP-MIB", "mipSecRecentViolationReason"), ("MIP-MIB", "mipSecViolatorAddress"), ("MIP-MIB", "mipSecRecentViolationSPI"), ("MIP-MIB", "mipSecRecentViolationIDHigh"), )
if mibBuilder.loadTexts: mipAuthFailure.setDescription("The mipAuthFailure indicates that the Mobile IP\nentity has an authentication failure when it validates\nthe mobile Registration Request or Reply.\nImplementation of this trap is optional.")

# Groups

mipSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 1)).setObjects(("MIP-MIB", "mipEntities"), ("MIP-MIB", "mipEncapsulationSupported"), ("MIP-MIB", "mipEnable"), )
if mibBuilder.loadTexts: mipSystemGroup.setDescription("A collection of objects providing the basic Mobile IP\nentity's management information.")
mipSecAssociationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 2)).setObjects(("MIP-MIB", "mipSecReplayMethod"), ("MIP-MIB", "mipSecKey"), ("MIP-MIB", "mipSecAlgorithmMode"), ("MIP-MIB", "mipSecAlgorithmType"), )
if mibBuilder.loadTexts: mipSecAssociationGroup.setDescription("A collection of objects providing the management\ninformation for security associations of Mobile IP\nentities.")
mipSecViolationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 3)).setObjects(("MIP-MIB", "mipSecRecentViolationSPI"), ("MIP-MIB", "mipSecRecentViolationIDLow"), ("MIP-MIB", "mipSecTotalViolations"), ("MIP-MIB", "mipSecRecentViolationReason"), ("MIP-MIB", "mipSecRecentViolationTime"), ("MIP-MIB", "mipSecViolationCounter"), ("MIP-MIB", "mipSecRecentViolationIDHigh"), )
if mibBuilder.loadTexts: mipSecViolationGroup.setDescription("A collection of objects providing the management\ninformation for security violation logging of Mobile\nIP entities.")
mnSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 4)).setObjects(("MIP-MIB", "mnState"), ("MIP-MIB", "mnHAStatus"), ("MIP-MIB", "mnHomeAddress"), ("MIP-MIB", "mnCurrentHA"), )
if mibBuilder.loadTexts: mnSystemGroup.setDescription("A collection of objects providing the basic\nmanagement information for mobile nodes.")
mnDiscoveryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 5)).setObjects(("MIP-MIB", "mnMoveFromFAToHA"), ("MIP-MIB", "mnAdvTimeReceived"), ("MIP-MIB", "mnSolicitationsSent"), ("MIP-MIB", "mnAdvSequence"), ("MIP-MIB", "mnAdvSourceAddress"), ("MIP-MIB", "mnAgentRebootsDectected"), ("MIP-MIB", "mnGratuitousARPsSend"), ("MIP-MIB", "mnCOA"), ("MIP-MIB", "mnAdvertisementsReceived"), ("MIP-MIB", "mnAdvFlags"), ("MIP-MIB", "mnFAAddress"), ("MIP-MIB", "mnAdvsDroppedInvalidExtension"), ("MIP-MIB", "mnMoveFromFAToFA"), ("MIP-MIB", "mnMoveFromHAToFA"), ("MIP-MIB", "mnAdvsIgnoredUnknownExtension"), ("MIP-MIB", "mnAdvMaxRegLifetime"), ("MIP-MIB", "mnAdvMaxAdvLifetime"), )
if mibBuilder.loadTexts: mnDiscoveryGroup.setDescription("A collection of objects providing management\ninformation for the Agent Discovery function within a\nmobile node.")
mnRegistrationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 6)).setObjects(("MIP-MIB", "mnRepliesInvalidID"), ("MIP-MIB", "mnRegRequestsDeniedByHA"), ("MIP-MIB", "mnRegIDLow"), ("MIP-MIB", "mnRegRequestsSent"), ("MIP-MIB", "mnRegCOA"), ("MIP-MIB", "mnRegRequestsWithDirectedBroadcast"), ("MIP-MIB", "mnRegIDHigh"), ("MIP-MIB", "mnRegTimeRemaining"), ("MIP-MIB", "mnRegRequestsAccepted"), ("MIP-MIB", "mnRegAgentAddress"), ("MIP-MIB", "mnRepliesIgnoredUnknownExtension"), ("MIP-MIB", "mnRepliesInvalidHomeAddress"), ("MIP-MIB", "mnRepliesHAAuthenticationFailure"), ("MIP-MIB", "mnRegRepliesRecieved"), ("MIP-MIB", "mnRegIsAccepted"), ("MIP-MIB", "mnDeRegRequestsSent"), ("MIP-MIB", "mnRegRequestsDeniedByFA"), ("MIP-MIB", "mnCOAIsLocal"), ("MIP-MIB", "mnRepliesUnknownHA"), ("MIP-MIB", "mnRegFlags"), ("MIP-MIB", "mnRepliesFAAuthenticationFailure"), ("MIP-MIB", "mnDeRegRepliesRecieved"), ("MIP-MIB", "mnRepliesUnknownFA"), ("MIP-MIB", "mnRegRequestsDeniedByHADueToID"), ("MIP-MIB", "mnRegTimeSent"), ("MIP-MIB", "mnRepliesDroppedInvalidExtension"), ("MIP-MIB", "mnRegTimeRequested"), )
if mibBuilder.loadTexts: mnRegistrationGroup.setDescription("A collection of objects providing management\ninformation for the registration function within a\nmobile node.")
maAdvertisementGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 7)).setObjects(("MIP-MIB", "maAdvPrefixLengthInclusion"), ("MIP-MIB", "maAdvMaxInterval"), ("MIP-MIB", "maSolicitationsReceived"), ("MIP-MIB", "maAdvMinInterval"), ("MIP-MIB", "maAdvMaxAdvLifetime"), ("MIP-MIB", "maAdvsSentForSolicitation"), ("MIP-MIB", "maAdvMaxRegLifetime"), ("MIP-MIB", "maAdvertisementsSent"), ("MIP-MIB", "maAdvResponseSolicitationOnly"), ("MIP-MIB", "maAdvAddress"), ("MIP-MIB", "maAdvStatus"), )
if mibBuilder.loadTexts: maAdvertisementGroup.setDescription("A collection of objects providing management\ninformation for the Agent Advertisement function\nwithin mobility agents.")
faSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 8)).setObjects(("MIP-MIB", "faCOAStatus"), )
if mibBuilder.loadTexts: faSystemGroup.setDescription("A collection of objects providing the basic\nmanagement information for foreign agents.")
faAdvertisementGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 9)).setObjects(("MIP-MIB", "faRegistrationRequired"), ("MIP-MIB", "faIsBusy"), )
if mibBuilder.loadTexts: faAdvertisementGroup.setDescription("A collection of objects providing supplemental\nmanagement information for the Agent Advertisement\nfunction within a foreign agent.")
faRegistrationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 10)).setObjects(("MIP-MIB", "faVisitorRegIsAccepted"), ("MIP-MIB", "faPoorlyFormedReplies"), ("MIP-MIB", "faVisitorHomeAgentAddress"), ("MIP-MIB", "faPoorlyFormedRequests"), ("MIP-MIB", "faVisitorTimeRemaining"), ("MIP-MIB", "faVisitorRegIDLow"), ("MIP-MIB", "faHAAuthenticationFailure"), ("MIP-MIB", "faInsufficientResource"), ("MIP-MIB", "faRegRequestsReceived"), ("MIP-MIB", "faVisitorRegFlags"), ("MIP-MIB", "faVisitorRegIDHigh"), ("MIP-MIB", "faReasonUnspecified"), ("MIP-MIB", "faRegRepliesRecieved"), ("MIP-MIB", "faVJCompressionUnavailable"), ("MIP-MIB", "faVisitorTimeGranted"), ("MIP-MIB", "faRegRepliesRelayed"), ("MIP-MIB", "faHAUnreachable"), ("MIP-MIB", "faMNAuthenticationFailure"), ("MIP-MIB", "faAdmProhibited"), ("MIP-MIB", "faVisitorIPAddress"), ("MIP-MIB", "faVisitorHomeAddress"), ("MIP-MIB", "faRegRequestsRelayed"), ("MIP-MIB", "faEncapsulationUnavailable"), ("MIP-MIB", "faRegLifetimeTooLong"), )
if mibBuilder.loadTexts: faRegistrationGroup.setDescription("A collection of objects providing management\ninformation for the registration function within a\nforeign agent.")
haRegistrationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 11)).setObjects(("MIP-MIB", "haMobilityBindingSourceAddress"), ("MIP-MIB", "haMultiBindingUnsupported"), ("MIP-MIB", "haDeRegRequestsReceived"), ("MIP-MIB", "haMobilityBindingTimeGranted"), ("MIP-MIB", "haFAAuthenticationFailure"), ("MIP-MIB", "haPoorlyFormedRequest"), ("MIP-MIB", "haMobilityBindingRegIDHigh"), ("MIP-MIB", "haUnknownHA"), ("MIP-MIB", "haDeRegRepliesSent"), ("MIP-MIB", "haMobilityBindingCOA"), ("MIP-MIB", "haMobilityBindingMN"), ("MIP-MIB", "haMobilityBindingTimeRemaining"), ("MIP-MIB", "haRegRequestsReceived"), ("MIP-MIB", "haRegistrationAccepted"), ("MIP-MIB", "haTooManyBindings"), ("MIP-MIB", "haMobilityBindingRegIDLow"), ("MIP-MIB", "haInsufficientResource"), ("MIP-MIB", "haProxyARPsSent"), ("MIP-MIB", "haReasonUnspecified"), ("MIP-MIB", "haIDMismatch"), ("MIP-MIB", "haAdmProhibited"), ("MIP-MIB", "haMNAuthenticationFailure"), ("MIP-MIB", "haGratuitiousARPsSent"), ("MIP-MIB", "haRegRepliesSent"), ("MIP-MIB", "haMobilityBindingRegFlags"), )
if mibBuilder.loadTexts: haRegistrationGroup.setDescription("A collection of objects providing management\ninformation for the registration function within a\nhome agent.")
haRegNodeCountersGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 12)).setObjects(("MIP-MIB", "haServiceRequestsDenied"), ("MIP-MIB", "haRecentServiceAcceptedTime"), ("MIP-MIB", "haOverallServiceTime"), ("MIP-MIB", "haRecentServiceDeniedTime"), ("MIP-MIB", "haRecentServiceDeniedCode"), ("MIP-MIB", "haServiceRequestsAccepted"), )
if mibBuilder.loadTexts: haRegNodeCountersGroup.setDescription("A collection of objects providing management\ninformation for counters related to the registration\nfunction within a home agent.")
mipSecNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 44, 3, 1, 13)).setObjects(("MIP-MIB", "mipAuthFailure"), )
if mibBuilder.loadTexts: mipSecNotificationsGroup.setDescription("The notification related to security violations.")

# Compliances

mipCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 44, 3, 2, 1)).setObjects(("MIP-MIB", "haRegistrationGroup"), ("MIP-MIB", "faSystemGroup"), ("MIP-MIB", "mipSecNotificationsGroup"), ("MIP-MIB", "mipSecAssociationGroup"), ("MIP-MIB", "mipSystemGroup"), ("MIP-MIB", "haRegNodeCountersGroup"), ("MIP-MIB", "mnDiscoveryGroup"), ("MIP-MIB", "mnRegistrationGroup"), ("MIP-MIB", "faAdvertisementGroup"), ("MIP-MIB", "faRegistrationGroup"), ("MIP-MIB", "mnSystemGroup"), ("MIP-MIB", "maAdvertisementGroup"), ("MIP-MIB", "mipSecViolationGroup"), )
if mibBuilder.loadTexts: mipCompliance.setDescription("The compliance statement for SNMPv2 entities which\nimplement the Mobile IP MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("MIP-MIB", PYSNMP_MODULE_ID=mipMIB)

# Types
mibBuilder.exportSymbols("MIP-MIB", RegistrationFlags=RegistrationFlags)

# Objects
mibBuilder.exportSymbols("MIP-MIB", mipMIB=mipMIB, mipMIBObjects=mipMIBObjects, mipSystem=mipSystem, mipEntities=mipEntities, mipEnable=mipEnable, mipEncapsulationSupported=mipEncapsulationSupported, mipSecurity=mipSecurity, mipSecAssocTable=mipSecAssocTable, mipSecAssocEntry=mipSecAssocEntry, mipSecPeerAddress=mipSecPeerAddress, mipSecSPI=mipSecSPI, mipSecAlgorithmType=mipSecAlgorithmType, mipSecAlgorithmMode=mipSecAlgorithmMode, mipSecKey=mipSecKey, mipSecReplayMethod=mipSecReplayMethod, mipSecTotalViolations=mipSecTotalViolations, mipSecViolationTable=mipSecViolationTable, mipSecViolationEntry=mipSecViolationEntry, mipSecViolatorAddress=mipSecViolatorAddress, mipSecViolationCounter=mipSecViolationCounter, mipSecRecentViolationSPI=mipSecRecentViolationSPI, mipSecRecentViolationTime=mipSecRecentViolationTime, mipSecRecentViolationIDLow=mipSecRecentViolationIDLow, mipSecRecentViolationIDHigh=mipSecRecentViolationIDHigh, mipSecRecentViolationReason=mipSecRecentViolationReason, mipMN=mipMN, mnSystem=mnSystem, mnState=mnState, mnHomeAddress=mnHomeAddress, mnHATable=mnHATable, mnHAEntry=mnHAEntry, mnHAAddress=mnHAAddress, mnCurrentHA=mnCurrentHA, mnHAStatus=mnHAStatus, mnDiscovery=mnDiscovery, mnFATable=mnFATable, mnFAEntry=mnFAEntry, mnFAAddress=mnFAAddress, mnCOA=mnCOA, mnRecentAdvReceived=mnRecentAdvReceived, mnAdvSourceAddress=mnAdvSourceAddress, mnAdvSequence=mnAdvSequence, mnAdvFlags=mnAdvFlags, mnAdvMaxRegLifetime=mnAdvMaxRegLifetime, mnAdvMaxAdvLifetime=mnAdvMaxAdvLifetime, mnAdvTimeReceived=mnAdvTimeReceived, mnSolicitationsSent=mnSolicitationsSent, mnAdvertisementsReceived=mnAdvertisementsReceived, mnAdvsDroppedInvalidExtension=mnAdvsDroppedInvalidExtension, mnAdvsIgnoredUnknownExtension=mnAdvsIgnoredUnknownExtension, mnMoveFromHAToFA=mnMoveFromHAToFA, mnMoveFromFAToFA=mnMoveFromFAToFA, mnMoveFromFAToHA=mnMoveFromFAToHA, mnGratuitousARPsSend=mnGratuitousARPsSend, mnAgentRebootsDectected=mnAgentRebootsDectected, mnRegistration=mnRegistration, mnRegistrationTable=mnRegistrationTable, mnRegistrationEntry=mnRegistrationEntry, mnRegAgentAddress=mnRegAgentAddress, mnRegCOA=mnRegCOA, mnRegFlags=mnRegFlags, mnRegIDLow=mnRegIDLow, mnRegIDHigh=mnRegIDHigh, mnRegTimeRequested=mnRegTimeRequested, mnRegTimeRemaining=mnRegTimeRemaining, mnRegTimeSent=mnRegTimeSent, mnRegIsAccepted=mnRegIsAccepted, mnCOAIsLocal=mnCOAIsLocal, mnRegRequestsSent=mnRegRequestsSent, mnDeRegRequestsSent=mnDeRegRequestsSent, mnRegRepliesRecieved=mnRegRepliesRecieved, mnDeRegRepliesRecieved=mnDeRegRepliesRecieved, mnRepliesInvalidHomeAddress=mnRepliesInvalidHomeAddress, mnRepliesUnknownHA=mnRepliesUnknownHA, mnRepliesUnknownFA=mnRepliesUnknownFA, mnRepliesInvalidID=mnRepliesInvalidID, mnRepliesDroppedInvalidExtension=mnRepliesDroppedInvalidExtension, mnRepliesIgnoredUnknownExtension=mnRepliesIgnoredUnknownExtension, mnRepliesHAAuthenticationFailure=mnRepliesHAAuthenticationFailure, mnRepliesFAAuthenticationFailure=mnRepliesFAAuthenticationFailure, mnRegRequestsAccepted=mnRegRequestsAccepted, mnRegRequestsDeniedByHA=mnRegRequestsDeniedByHA, mnRegRequestsDeniedByFA=mnRegRequestsDeniedByFA, mnRegRequestsDeniedByHADueToID=mnRegRequestsDeniedByHADueToID, mnRegRequestsWithDirectedBroadcast=mnRegRequestsWithDirectedBroadcast, mipMA=mipMA, maAdvertisement=maAdvertisement, maAdvConfigTable=maAdvConfigTable, maAdvConfigEntry=maAdvConfigEntry, maInterfaceAddress=maInterfaceAddress, maAdvMaxRegLifetime=maAdvMaxRegLifetime, maAdvPrefixLengthInclusion=maAdvPrefixLengthInclusion, maAdvAddress=maAdvAddress, maAdvMaxInterval=maAdvMaxInterval, maAdvMinInterval=maAdvMinInterval, maAdvMaxAdvLifetime=maAdvMaxAdvLifetime, maAdvResponseSolicitationOnly=maAdvResponseSolicitationOnly, maAdvStatus=maAdvStatus, maAdvertisementsSent=maAdvertisementsSent, maAdvsSentForSolicitation=maAdvsSentForSolicitation, maSolicitationsReceived=maSolicitationsReceived, mipFA=mipFA, faSystem=faSystem, faCOATable=faCOATable, faCOAEntry=faCOAEntry, faSupportedCOA=faSupportedCOA, faCOAStatus=faCOAStatus, faAdvertisement=faAdvertisement, faIsBusy=faIsBusy, faRegistrationRequired=faRegistrationRequired, faRegistration=faRegistration, faVisitorTable=faVisitorTable, faVisitorEntry=faVisitorEntry, faVisitorIPAddress=faVisitorIPAddress, faVisitorHomeAddress=faVisitorHomeAddress, faVisitorHomeAgentAddress=faVisitorHomeAgentAddress, faVisitorTimeGranted=faVisitorTimeGranted, faVisitorTimeRemaining=faVisitorTimeRemaining, faVisitorRegFlags=faVisitorRegFlags, faVisitorRegIDLow=faVisitorRegIDLow, faVisitorRegIDHigh=faVisitorRegIDHigh, faVisitorRegIsAccepted=faVisitorRegIsAccepted, faRegRequestsReceived=faRegRequestsReceived, faRegRequestsRelayed=faRegRequestsRelayed, faReasonUnspecified=faReasonUnspecified, faAdmProhibited=faAdmProhibited)
mibBuilder.exportSymbols("MIP-MIB", faInsufficientResource=faInsufficientResource, faMNAuthenticationFailure=faMNAuthenticationFailure, faRegLifetimeTooLong=faRegLifetimeTooLong, faPoorlyFormedRequests=faPoorlyFormedRequests, faEncapsulationUnavailable=faEncapsulationUnavailable, faVJCompressionUnavailable=faVJCompressionUnavailable, faHAUnreachable=faHAUnreachable, faRegRepliesRecieved=faRegRepliesRecieved, faRegRepliesRelayed=faRegRepliesRelayed, faHAAuthenticationFailure=faHAAuthenticationFailure, faPoorlyFormedReplies=faPoorlyFormedReplies, mipHA=mipHA, haRegistration=haRegistration, haMobilityBindingTable=haMobilityBindingTable, haMobilityBindingEntry=haMobilityBindingEntry, haMobilityBindingMN=haMobilityBindingMN, haMobilityBindingCOA=haMobilityBindingCOA, haMobilityBindingSourceAddress=haMobilityBindingSourceAddress, haMobilityBindingRegFlags=haMobilityBindingRegFlags, haMobilityBindingRegIDLow=haMobilityBindingRegIDLow, haMobilityBindingRegIDHigh=haMobilityBindingRegIDHigh, haMobilityBindingTimeGranted=haMobilityBindingTimeGranted, haMobilityBindingTimeRemaining=haMobilityBindingTimeRemaining, haCounterTable=haCounterTable, haCounterEntry=haCounterEntry, haServiceRequestsAccepted=haServiceRequestsAccepted, haServiceRequestsDenied=haServiceRequestsDenied, haOverallServiceTime=haOverallServiceTime, haRecentServiceAcceptedTime=haRecentServiceAcceptedTime, haRecentServiceDeniedTime=haRecentServiceDeniedTime, haRecentServiceDeniedCode=haRecentServiceDeniedCode, haRegistrationAccepted=haRegistrationAccepted, haMultiBindingUnsupported=haMultiBindingUnsupported, haReasonUnspecified=haReasonUnspecified, haAdmProhibited=haAdmProhibited, haInsufficientResource=haInsufficientResource, haMNAuthenticationFailure=haMNAuthenticationFailure, haFAAuthenticationFailure=haFAAuthenticationFailure, haIDMismatch=haIDMismatch, haPoorlyFormedRequest=haPoorlyFormedRequest, haTooManyBindings=haTooManyBindings, haUnknownHA=haUnknownHA, haGratuitiousARPsSent=haGratuitiousARPsSent, haProxyARPsSent=haProxyARPsSent, haRegRequestsReceived=haRegRequestsReceived, haDeRegRequestsReceived=haDeRegRequestsReceived, haRegRepliesSent=haRegRepliesSent, haDeRegRepliesSent=haDeRegRepliesSent, mipMIBNotificationPrefix=mipMIBNotificationPrefix, mipMIBNotifications=mipMIBNotifications, mipMIBConformance=mipMIBConformance, mipGroups=mipGroups, mipCompliances=mipCompliances)

# Notifications
mibBuilder.exportSymbols("MIP-MIB", mipAuthFailure=mipAuthFailure)

# Groups
mibBuilder.exportSymbols("MIP-MIB", mipSystemGroup=mipSystemGroup, mipSecAssociationGroup=mipSecAssociationGroup, mipSecViolationGroup=mipSecViolationGroup, mnSystemGroup=mnSystemGroup, mnDiscoveryGroup=mnDiscoveryGroup, mnRegistrationGroup=mnRegistrationGroup, maAdvertisementGroup=maAdvertisementGroup, faSystemGroup=faSystemGroup, faAdvertisementGroup=faAdvertisementGroup, faRegistrationGroup=faRegistrationGroup, haRegistrationGroup=haRegistrationGroup, haRegNodeCountersGroup=haRegNodeCountersGroup, mipSecNotificationsGroup=mipSecNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("MIP-MIB", mipCompliance=mipCompliance)
