# PySNMP SMI module. Autogenerated from smidump -f python MOBILEIPV6-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:50 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InetAddress, InetAddressType, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType")
( ipv6InterfaceIfIndex, ) = mibBuilder.importSymbols("IP-MIB", "ipv6InterfaceIfIndex")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Counter64, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class Mip6BURequestRejectionCode(Integer):
    subtypeSpec = Integer.subtypeSpec+constraint.SingleValueConstraint(1,4,3,10,11,5,12,9,7,2,6,8,)
    namedValues = namedval.NamedValues(("reasonUnspecified", 1), ("expiredCareofNonceIndex", 10), ("expiredNonces", 11), ("registrationTypeChangeDisallowed", 12), ("admProhibited", 2), ("insufficientResource", 3), ("homeRegistrationNotSupported", 4), ("notHomeSubnet", 5), ("notHomeAgentForThisMobileNode", 6), ("duplicateAddressDetectionFailed", 7), ("sequenceNumberOutOfWindow", 8), ("expiredHomeNonceIndex", 9), )
    

# Objects

mip6MIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 133)).setRevisions(("2006-02-01 00:00",))
if mibBuilder.loadTexts: mip6MIB.setOrganization("IETF mip6 Working Group")
if mibBuilder.loadTexts: mip6MIB.setContactInfo("                      Glenn Mansfield Keeni\nPostal: Cyber Solutions Inc.\n        6-6-3, Minami Yoshinari\n        Aoba-ku, Sendai, Japan 989-3204.\n   Tel: +81-22-303-4012\n   Fax: +81-22-303-4015\nE-mail: glenn@cysols.com\n\n        Kenichi Nagami\nPostal: INTEC NetCore Inc.\n        1-3-3, Shin-suna\n        Koto-ku, Tokyo, 135-0075\n        Japan\n\n   Tel: +81-3-5665-5069\nE-mail: nagami@inetcore.com\n\n        Kazuhide Koide\nPostal: Tohoku University\n        2-1-1, Katahira\n        Aoba-ku, Sendai, 980-8577\n        Japan\n\n   Tel: +81-22-217-5454\nE-mail: koide@shiratori.riec.tohoku.ac.jp\n\n\n\n        Sri Gundavelli\nPostal: Cisco Systems\n        170 W.Tasman Drive,\n        San Jose, CA 95134\n        USA\n\n   Tel: +1-408-527-6109\nE-mail: sgundave@cisco.com\n\nSupport Group E-mail: mip6@ietf.org")
if mibBuilder.loadTexts: mip6MIB.setDescription("The MIB module for monitoring Mobile-IPv6\nentities.\n\nCopyright (C) The Internet Society 2006.  This\nversion of this MIB module is part of RFC 4295;\nsee the RFC itself for full legal notices.")
mip6Notifications = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 0))
mip6Objects = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1))
mip6Core = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 1))
mip6System = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 1, 1))
mip6Capabilities = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 1, 1), Bits().subtype(namedValues=namedval.NamedValues(("mobileNode", 0), ("homeAgent", 1), ("correspondentNode", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6Capabilities.setDescription("This object indicates the Mobile IPv6 functions that\nare supported by this managed entity.  Multiple\nMobile IPv6 functions may be supported by a single\nentity.")
mip6Status = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6Status.setDescription("This object indicates whether the Mobile IPv6\nfunction is enabled for the managed entity.  If it\nis enabled, the agent discovery and registration\nfunctions will be operational.\nChanging the status from enabled(1) to disabled(2)\nwill terminate the agent discovery and registration\nfunctions.  On the other hand, changing the status\nfrom disabled(2) to enabled(1) will start the agent\ndiscovery and registration functions.\n\nThe value of this object SHOULD remain unchanged\nacross reboots of the managed entity.")
mip6Bindings = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 1, 2))
mip6BindingCacheTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1))
if mibBuilder.loadTexts: mip6BindingCacheTable.setDescription("This table models the Binding Cache on the\nmanaged entity.  The cache is maintained by home\nagents and correspondent nodes.  It contains\nboth correspondent registration entries and home\nregistration entries.\n\nEntries in this table are not required to survive\na reboot of the managed entity.")
mip6BindingCacheEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6BindingHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6BindingHomeAddress"))
if mibBuilder.loadTexts: mip6BindingCacheEntry.setDescription("This entry represents a conceptual row in the\nbinding cache table.  It represents a single Binding\nUpdate.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6BindingHomeAddress\nexceeds 113, then OIDs of column\ninstances in this row will have more than 128\nsub-identifiers and cannot be accessed using\nSNMPv1, SNMPv2c, or SNMPv3.")
mip6BindingHomeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6BindingHomeAddressType.setDescription("The InetAddressType of the mip6BindingHomeAddress\nthat follows.")
mip6BindingHomeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6BindingHomeAddress.setDescription("The home address of the mobile node corresponding\nto the Binding Cache entry.  This field is used as\nthe key for searching the mobile node's current\ncare-of address in the Binding Cache.\n\nThe type of the address represented by this object\nis specified by the corresponding\nmip6BindingHomeAddressType object.")
mip6BindingCOAType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 3), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingCOAType.setDescription("The InetAddressType of the mip6BindingCOA that\nfollows.")
mip6BindingCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 4), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingCOA.setDescription("The care-of address of the mobile node indicated by\nthe home address field (mip6BindingHomeAddress) in\nthis Binding Cache entry.\n\nThe type of the address represented by this object\nis specified by the corresponding mip6BindingCOAType\nobject.")
mip6BindingTimeRegistered = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingTimeRegistered.setDescription("The timestamp when this Binding Cache entry was\ncreated.")
mip6BindingTimeGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingTimeGranted.setDescription("The lifetime in seconds granted to the mobile node\nfor this registration.")
mip6BindingTimeRemaining = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingTimeRemaining.setDescription("The lifetime in seconds remaining for this\nregistration.")
mip6BindingHomeRegn = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHomeRegn.setDescription("This object indicates whether or not this Binding\nCache entry is a home registration entry (applicable\nonly on nodes that support home agent\nfunctionality).")
mip6BindingMaxSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 9), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingMaxSeq.setDescription("The maximum value of the Sequence Number field\nreceived in previous Binding Updates for this home\naddress (mip6BindingHomeAddress).")
mip6BindingUsageTS = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 10), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingUsageTS.setDescription("The timestamp when this entry was last looked up.")
mip6BindingUsageCount = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingUsageCount.setDescription("The number of times this entry was looked up.")
mip6BindingAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 1, 1, 12), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("inactive", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6BindingAdminStatus.setDescription("This is an administrative object used to control\nthe status of a binding cache entry.  By default\nthe value will be 'active'(1).\nA value of 'inactive'(2) will indicate that the\nvalidity of the entry is suspended.  It does not\nexist in the binding cache for all practical\npurposes.\nThe state can be changed from 'active' to\n'inactive' by operator intervention.\nCausing the state to change to 'inactive' results\nin the entry being deleted from the cache.\nAttempts to change the status from 'inactive'\nto 'active' will be rejected.")
mip6BindingHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2))
if mibBuilder.loadTexts: mip6BindingHistoryTable.setDescription("A table containing a record of the bindings.")
mip6BindingHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6BindingHstHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6BindingHstHomeAddress"), (0, "MOBILEIPV6-MIB", "mip6BindingHstIndex"))
if mibBuilder.loadTexts: mip6BindingHistoryEntry.setDescription("The record of a binding.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6BindingHstHomeAddress\nexceeds 112, then OIDs of column\ninstances in this row will have more than 128\nsub-identifiers and cannot be accessed using\nSNMPv1, SNMPv2c, or SNMPv3.")
mip6BindingHstHomeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6BindingHstHomeAddressType.setDescription("The InetAddressType of the\nmip6BindingHstHomeAddress that follows.")
mip6BindingHstHomeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6BindingHstHomeAddress.setDescription("Mobile node's home address.\n\nThe type of the address represented by this object\nis specified by the corresponding\nmip6BindingHstHomeAddressType object.")
mip6BindingHstIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6BindingHstIndex.setDescription("The index to uniquely identify this record along\nwith the mobile node's HomeAddress type and\nHomeAddress.  It should be monotonically increasing.\nIt may wrap after reaching its max value.")
mip6BindingHstCOAType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstCOAType.setDescription("The InetAddressType of the mip6BindingHstCOA that\nfollows.")
mip6BindingHstCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstCOA.setDescription("Mobile node's care-of address.  One mobile node can\nhave multiple bindings with different\ncare-of addresses.\nThe type of the address represented by this object\nis specified by the corresponding\nmip6BindingHstCOAType object.")
mip6BindingHstTimeRegistered = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstTimeRegistered.setDescription("The timestamp when this Binding Cache entry was\ncreated.")
mip6BindingHstTimeExpired = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 7), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstTimeExpired.setDescription("The timestamp when this Binding Cache entry expired.")
mip6BindingHstHomeRegn = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstHomeRegn.setDescription("This object indicates whether or not this Binding\nCache entry is a home registration entry (applicable\nonly on nodes that support home agent\nfunctionality).")
mip6BindingHstUsageTS = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstUsageTS.setDescription("The timestamp when this entry was last looked up.")
mip6BindingHstUsageCount = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 2, 2, 1, 10), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6BindingHstUsageCount.setDescription("The number of times this entry was looked up.")
mip6Stats = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 1, 3))
mip6TotalTraffic = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1))
mip6InOctets = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6InOctets.setDescription("The total number of octets in the MIPv6 datagrams\nreceived by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header, the Home Address\noption in the Destination Option extension header\n(Next Header value = 60), or the type 2 Routing\nHeader.  It will also include the IPv6 datagrams that\nare reverse tunneled to a home agent from a mobile\nnode's home address.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HCInOctets = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCInOctets.setDescription("The total number of octets in the MIPv6 datagrams\nreceived by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header, the Home Address\noption in the Destination Option extension header\n(Next Header value = 60), or the type 2 Routing\nHeader.  It will also include the IPv6 datagrams that\nare reverse tunneled to a home agent from a mobile\nnode's home address.\nThis object is a 64-bit version of mip6InOctets.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6InPkts = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6InPkts.setDescription("The number of MIPv6 datagrams received by the MIPv6\nentity.  This will include datagrams with the\nMobility Header, the Home Address option in the\nDestination Option extension header (Next Header\nvalue = 60), or the type 2 Routing Header.\nIt will also include the IPv6 datagrams that are\nreverse tunneled to a home agent from a mobile\nnode's home address.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HCInPkts = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCInPkts.setDescription("The number of MIPv6 datagrams received by the MIPv6\nentity.  This will include datagrams with the\nMobility Header, the Home Address option in the\nDestination Option extension header (Next Header\nvalue = 60), or the type 2 Routing Header.  It will\nalso include the IPv6 datagrams that are reverse\ntunneled to a home agent from a mobile node's home\naddress.\nThis object is a 64-bit version of mip6InPkts.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6OutOctets = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6OutOctets.setDescription("The total number of octets in the MIPv6 datagrams\nsent by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header, the Home Address\noption in the Destination Option extension header\n(Next Header value = 60), or the type 2 Routing\nHeader.  It will also include the IPv6 datagrams that\nare reverse tunneled to a home agent from a mobile\nnode's home address.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HCOutOctets = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCOutOctets.setDescription("The total number of octets in the MIPv6 datagrams\nsent by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header, the Home Address\noption in the Destination Option extension header\n(Next Header value = 60), or the type 2 Routing\nHeader.  It will also include the IPv6 datagrams that\nare reverse tunneled to a home agent from a mobile\nnode's home address.\nThis object is a 64-bit version of mip6OutOctets.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6OutPkts = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6OutPkts.setDescription("The number of MIPv6 datagrams sent by the MIPv6\nentity.  This will include the datagrams with\nMobility Header, the Home Address option in the\nDestination Option extension header (Next Header\nvalue = 60), or the type 2 Routing Header.  It will\nalso include the IPv6 datagrams that are reverse\ntunneled to a home agent from a mobile node's home\naddress.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HCOutPkts = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCOutPkts.setDescription("The number of MIPv6 datagrams sent by the MIPv6\nentity.  This will include datagrams with the\nMobility Header, the Home Address option in the\nDestination Option extension header (Next Header\nvalue = 60), or the type 2 Routing Header.  It will\nalso include the IPv6 datagrams that are reverse\ntunneled to a home agent from a mobile node's home\naddress.\nThis object is a 64-bit version of mip6OutPkts.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CounterDiscontinuityTime = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CounterDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of this MIPv6 entities\nglobal counters, viz., counters with OID prefix\n'mip6TotalTraffic' or 'mip6CnGlobalStats' or\n'mip6HaGlobalStats' suffered a discontinuity.\nIf no such discontinuities have occurred since the\nlast re-initialization of the local management\nsubsystem, then this object will have a zero value.")
mip6NodeTrafficTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2))
if mibBuilder.loadTexts: mip6NodeTrafficTable.setDescription("A table containing MIPv6 traffic counters per mobile\nnode.")
mip6NodeTrafficEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6BindingHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6BindingHomeAddress"))
if mibBuilder.loadTexts: mip6NodeTrafficEntry.setDescription("The MIPv6 traffic statistics for a mobile node.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6BindingHomeAddress\nexceeds 113, then OIDs of column\ninstances in this row will have more than 128\nsub-identifiers and cannot be accessed using\nSNMPv1, SNMPv2c, or SNMPv3.")
mip6NodeInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6NodeInOctets.setDescription("The total number of octets in the MIPv6 datagrams\nreceived from the mobile node by the MIPv6 entity.\nThis will include datagrams with the Mobility\nHeader or the Home Address option in the Destination\nOption extension header (Next Header value = 60).\nIt will also include the IPv6 datagrams that are\nreverse tunneled to a home agent from the mobile\nnode's home address.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6HCNodeInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCNodeInOctets.setDescription("The total number of octets in the MIPv6 datagrams\nreceived from the mobile node by the MIPv6 entity.\nThis will include datagrams with the Mobility\nHeader or the Home Address option in the Destination\nOption extension header (Next Header value = 60).\nIt will also include the IPv6 datagrams that are\nreverse tunneled to a home agent from the mobile\nnode's home address.\nThis object is a 64-bit version of mip6NodeInOctets.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6NodeInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6NodeInPkts.setDescription("The number of MIPv6 datagrams received from the\nmobile node by the MIPv6 entity.  This will include\nthe datagrams with the Mobility Header or\nthe Home Address option in the Destination\nOption extension header (Next Header value = 60).\nIt will also include the IPv6 datagrams that are\nreverse tunneled to a home agent from the mobile\nnode's home address.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6HCNodeInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCNodeInPkts.setDescription("The number of MIPv6 datagrams received from the\nmobile node by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header or the Home\nAddress option in the Destination Option extension\nheader (Next Header value = 60).  It will also\ninclude the IPv6 datagrams that are reverse tunneled\nto a home agent from the mobile node's home address.\nThis object is a 64-bit version of mip6NodeInPkts.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6NodeOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6NodeOutOctets.setDescription("The total number of octets in the MIPv6 datagrams\nsent to the mobile node by the MIPv6 entity.  This\nwill include datagrams with the Mobility Header\nor the type 2 Routing Header.  It will also include\nthe IPv6 datagrams that are tunneled by a home agent\nto the mobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6HCNodeOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCNodeOutOctets.setDescription("The total number of octets in the MIPv6 datagrams\nsent to the mobile node by the MIPv6 entity.  This\nwill include datagrams with the Mobility Header\nor the type 2 Routing Header.  It will also include\nthe IPv6 datagrams that are tunneled by a home agent\nto the mobile node.\nThis object is a 64-bit version of mip6NodeOutOctets.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6NodeOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6NodeOutPkts.setDescription("The number of MIPv6 datagrams sent to the mobile\nnode by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header or the type 2\nRouting Header.  It will also include the IPv6\ndatagrams that are tunneled by a home agent to the\nmobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6HCNodeOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HCNodeOutPkts.setDescription("The number of MIPv6 datagrams sent to the mobile\nnode by the MIPv6 entity.  This will include\ndatagrams with the Mobility Header or the type 2\nRouting Header.  It will also include the IPv6\ndatagrams that are tunneled by a home agent to the\nmobile node.\nThis object is a 64-bit version of mip6NodeOutOctets.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6NodeCtrDiscontinuityTime.")
mip6NodeCtrDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 1, 3, 2, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6NodeCtrDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of the counters in this row\nsuffered a discontinuity.  The relevant counters are\nthe specific instances of any Counter32 or Counter64\nobjects in this row.\nIf no such discontinuities have occurred since the\nlast re-initialization of the local management\nsubsystem, then this object contains a zero value.")
mip6Mn = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 2))
mip6MnSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 2, 1))
mip6MnHomeAddressTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 2, 1, 1))
if mibBuilder.loadTexts: mip6MnHomeAddressTable.setDescription("A table containing registration status for all the\nhome addresses pertaining to the mobile node.")
mip6MnHomeAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 2, 1, 1, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6MnHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6MnHomeAddress"))
if mibBuilder.loadTexts: mip6MnHomeAddressEntry.setDescription("The registration status for a home address.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6MnHomeAddress\nexceeds 113, then OIDs of column instances in\nthis row will have more than 128 sub-identifiers and\ncannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
mip6MnHomeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 1, 1, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6MnHomeAddressType.setDescription("The InetAddressType of the mip6MnHomeAddress that\nfollows.")
mip6MnHomeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 1, 1, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6MnHomeAddress.setDescription("A unicast routable address assigned to the mobile\nnode.  This is used as the 'permanent address' of the\nmobile node in the sense that it remains unchanged\nregardless of the mobile node's current point of\nattachment.  If mobile node doesn't have a home\naddress assigned yet, then this object will take the\ndefault 'unspecified' value ::0.\n\nThe type of the address represented by this object\nis specified by the corresponding\nmip6MnHomeAddressType object.")
mip6MnHomeAddressState = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 1, 1, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,5,2,4,)).subtype(namedValues=namedval.NamedValues(("unknown", 1), ("home", 2), ("registered", 3), ("pending", 4), ("isolated", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnHomeAddressState.setDescription("This object indicates the state of the mobile node:\nunknown     -- The state of the mobile node\n               cannot be determined.\nhome        -- mobile node is on the home network.\nregistered  -- mobile node is on a foreign network\n               and is registered with the home\n               agent.\npending     -- mobile node has sent registration\n               request to the home agent and is\n               waiting for the reply.\nisolated    -- mobile node is isolated from network,\n               i.e., it is not in its home network,\n               it is not registered, and no\n               registration ack is pending.")
mip6MnConf = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 2, 2))
mip6MnDiscoveryRequests = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnDiscoveryRequests.setDescription("Total number of ICMP Dynamic Home Agent Address\nDiscovery Requests sent by the mobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnDiscoveryReplies = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnDiscoveryReplies.setDescription("Total number of ICMP Dynamic Home Agent Address\nDiscovery Replies received by the mobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnDiscoveryTimeouts = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnDiscoveryTimeouts.setDescription("Total number of ICMP Dynamic Home Agent Address\nDiscovery Requests that timed out.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnPrefixSolicitationsSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnPrefixSolicitationsSent.setDescription("Total number of ICMP Mobile Prefix Solicitations\nsent by the mobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnPrefixAdvsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnPrefixAdvsRecd.setDescription("Total number of ICMP Mobile Prefix Advertisements\nreceived by the mobile node.  This will include the\nICMP Mobile Prefix Advertisements that failed the\nvalidity checks.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnPrefixAdvsIgnored = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnPrefixAdvsIgnored.setDescription("Total number of Mobile Prefix Advertisements\ndiscarded by the validity check.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnMovedToFN = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnMovedToFN.setDescription("Number of times the mobile node has detected\nmovement to a foreign network from another\nforeign network or from the home network, has\nreconstructed its care-of address and has initiated\nthe care-of address registration process.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnMovedToHN = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnMovedToHN.setDescription("Number of times the mobile node has detected\nmovement from a foreign network to its home\nnetwork.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnRegistration = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 2, 3))
mip6MnBLTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1))
if mibBuilder.loadTexts: mip6MnBLTable.setDescription("This table corresponds to the Binding Update List\n(BL) that is maintained by the mobile node.  The list\nholds an item for every binding that the mobile node\nhas established or is trying to establish.  Both\ncorrespondent and home registrations are included in\nthis table.  Entries from the table are deleted as\nthe lifetime of the binding expires.")
mip6MnBLEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6MnHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6MnHomeAddress"), (0, "MOBILEIPV6-MIB", "mip6MnBLNodeAddressType"), (0, "MOBILEIPV6-MIB", "mip6MnBLNodeAddress"))
if mibBuilder.loadTexts: mip6MnBLEntry.setDescription("Information about a Binding Update sent by the\nmobile node either to its home agent or to one of\nits correspondent nodes.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6MnHomeAddress and\nmip6MnBLNodeAddress exceeds 111, then OIDs of column\ninstances in this row will have more than 128\nsub-identifiers and cannot be accessed using\nSNMPv1, SNMPv2c, or SNMPv3.")
mip6MnBLNodeAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6MnBLNodeAddressType.setDescription("The InetAddressType of the mip6MnBLNodeAddress\nthat follows.")
mip6MnBLNodeAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6MnBLNodeAddress.setDescription("The address of the agent as used in the destination\naddress of the Binding Update.  The agent\nmay be a home agent or a correspondent node.\n\nThe type of the address represented by this object\nis specified by the corresponding\nmip6MnBLNodeAddressType object.")
mip6MnBLCOAType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 3), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLCOAType.setDescription("The InetAddressType of the mip6MnBLCOA that follows.")
mip6MnBLCOA = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 4), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLCOA.setDescription("Care-of address that the mobile node intends to\nregister in the Binding Update request.\n\nThe type of the address represented by this object\nis specified by the corresponding mip6MnBLCOAType\nobject.")
mip6MnBLLifeTimeRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLLifeTimeRequested.setDescription("The lifetime requested by the mobile node (in\nseconds) in the Binding Update.")
mip6MnBLLifeTimeGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLLifeTimeGranted.setDescription("The lifetime granted to the mobile node for this\nbinding.  This field will be inaccessible if the\nBinding Update request has not been accepted.\nThe lifetime remaining (lR) can be calculated using\nthe current time (cT), mip6MnBLAcceptedTime (aT) and\nmip6MnBLLifeTimeGranted (lG) as follows:\n        lR  = lG - (cT - aT).\nWhen lR is zero, this entry will be deleted from the\nBinding Update List and consequently from this\ntable.")
mip6MnBLMaxSeq = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65536))).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLMaxSeq.setDescription("The maximum value of the Sequence Number field sent\nin previous Binding Updates to this destination.")
mip6MnBLTimeSent = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 8), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLTimeSent.setDescription("The time when the last (re-)transmission occurred.")
mip6MnBLAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLAccepted.setDescription("true(1) if the mobile node has received a\nbinding acknowledgment indicating that service has\nbeen accepted (status code 0 or 1); false(2)\notherwise.  false(2) implies that the registration\nis still pending.")
mip6MnBLAcceptedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 10), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLAcceptedTime.setDescription("The time at which the mobile node receives a binding\nacknowledgment indicating that Binding Update has\nbeen accepted (status code 0 or 1);\nThis object will be inaccessible if the Binding\nUpdate request is still pending.")
mip6MnBLRetransmissions = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLRetransmissions.setDescription("The number of Binding Update retransmissions.")
mip6MnBLDontSendBUFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 1, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBLDontSendBUFlag.setDescription("true(1) indicates that future binding updates\nwill not be sent to mip6MnBLNodeAddress.\nfalse(2) implies that binding updates will be\nsent to mip6MnBLNodeAddress.\nThe mobile node sets this flag in the when it\nreceives an ICMP Parameter Problem, Code 1,\nerror message in response to a return\nroutability message or Binding Update sent to\nmip6MnBLNodeAddress.")
mip6MnRegnCounters = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2))
mip6MnMobilityMessagesSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnMobilityMessagesSent.setDescription("The total number of mobility messages, i.e., IPv6\ndatagrams with Mobility Header, sent by the mobile\nnode.  There are 3 types of mobility messages, viz.,\nHome Test Init, Care-of Test Init, and Binding\nUpdates, that are sent by mobile nodes.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnMobilityMessagesRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnMobilityMessagesRecd.setDescription("The total number of mobility messages, i.e., IPv6\ndatagrams with Mobility Header, received by the\nmobile node.  There are 5 types of mobility\nmessages, viz., Home Test, Care-of Test, Binding\nAcknowledgment, Binding Refresh Request, and Binding\nError, that are sent to mobile nodes.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnBUsToHA = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBUsToHA.setDescription("Total number of Binding Updates sent to the mobile\nnode's home agent(s).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnBUAcksFromHA = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBUAcksFromHA.setDescription("Total number of valid binding acknowledgments\nreceived from the mobile node's home agent(s).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnBUsToCN = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBUsToCN.setDescription("Total number of Binding Updates sent to\ncorrespondent nodes by the mobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnBUAcksFromCN = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBUAcksFromCN.setDescription("Total number of valid Binding Update acks\nreceived from all the correspondent nodes.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnBindingErrorsFromCN = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBindingErrorsFromCN.setDescription("Total number of Binding Error messages received\nby mobile node from CN.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnICMPErrorsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnICMPErrorsRecd.setDescription("Total number of ICMP Error messages of type ICMP\nParameter Problem, Code 1 or Code 2, received by\nthe mobile node from a correspondent node in\nresponse to a return routability procedure, a\nBinding Update, or a packet with the Home Address\noption.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6MnBRRequestsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 2, 3, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6MnBRRequestsRecd.setDescription("The total number of Binding Refresh requests\nreceived by the mobile node from correspondent\nnodes.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6Cn = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 3))
mip6CnSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 3, 1))
mip6CnStats = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 3, 2))
mip6CnGlobalStats = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1))
mip6CnHomeTestInitsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnHomeTestInitsRecd.setDescription("Total number of Home Test Init messages received.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnHomeTestsSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnHomeTestsSent.setDescription("Total number of Home Test messages sent.  If a Home\nTest Init message is found to be valid, a Home Test\nmessage will be generated and sent.  Otherwise the\nHome Test message is silently discarded.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnCareOfTestInitsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnCareOfTestInitsRecd.setDescription("Total number of Care-of Test Init messages received.")
mip6CnCareOfTestsSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnCareOfTestsSent.setDescription("Total number of Care-of Test messages sent.  If a\nCare-of Test Init message is found to be valid, a\nCare-of Test message will be generated and sent.\nOtherwise the Care-of Test message is silently\ndiscarded.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnBUsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBUsRecd.setDescription("Total number of Binding Updates received by the\ncorrespondent node from mobile nodes.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnBUAcksSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBUAcksSent.setDescription("Total number of acknowledgments sent by the\ncorrespondent node for the Binding Updates received.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnBRsSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBRsSent.setDescription("Total number of Binding Refresh Request messages\nsent by the correspondent node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnBindingErrors = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBindingErrors.setDescription("Total number of Binding Error messages sent by the\ncorrespondent node to the mobile node.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnBUsAccepted = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBUsAccepted.setDescription("Total number of Binding Updates accepted by the\ncorrespondent node.  If a Binding Acknowledgment\nmessage is sent for the Binding Update request,\nthe Status code field in the message will have\na value less than 128.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnBUsRejected = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBUsRejected.setDescription("Total number of Binding Update requests rejected\nby the correspondent node.  If a Binding\nAcknowledgment message has been sent for the Binding\nUpdate request, the Status code field in the\nmessage will have a value greater than or equal to\n128.  Otherwise the Binding Update request will be\nsilently discarded.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnReasonUnspecified = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnReasonUnspecified.setDescription("Total number of Binding Update requests rejected by\nthe correspondent node with status code in the\nBinding Acknowledgment message indicating 'reason\nunspecified' (Code 128).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnInsufficientResource = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnInsufficientResource.setDescription("Total number of Binding Update requests rejected by\nthe correspondent node with status code in the\nBinding Acknowledgment message indicating\n'insufficient resources' (Code 130).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnHomeRegnNotSupported = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnHomeRegnNotSupported.setDescription("Total number of Binding Update requests rejected by\ncorrespondent node with status code in the Binding\nAcknowledgment message indicating 'home registration\nnot supported' (Code 131).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnSeqNumberOutOfWindow = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnSeqNumberOutOfWindow.setDescription("Total number of Binding Updates rejected by\ncorrespondent node with status code in the Binding\nAcknowledgment message indicating 'sequence number\nout of window' (Code 135).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnExpiredHomeNonceIndex = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnExpiredHomeNonceIndex.setDescription("The total number of Binding Updates rejected by\ncorrespondent node with status code in the Binding\nAcknowledgment message indicating 'expired home\nnonce index' (Code 136).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnExpiredCareOfNonceIndex = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnExpiredCareOfNonceIndex.setDescription("The total number of Binding Updates rejected by\ncorrespondent node with status code in the Binding\nAcknowledgment message indicating 'expired\ncare-of nonce index' (Code 137).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnExpiredNonce = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnExpiredNonce.setDescription("The total number of Binding Updates rejected by\ncorrespondent node with status code in the Binding\nAcknowledgment message indicating 'expired nonces'\n(Code 138), i.e., the correspondent node no longer\nrecognizes the Home Nonce Index value and the\nCare-of Nonce Index value.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnRegTypeChangeDisallowed = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnRegTypeChangeDisallowed.setDescription("The total number of Binding Updates rejected by\ncorrespondent node with status code in the Binding\nAcknowledgment message indicating 'registration\ntype change disallowed' (Code 139), i.e., a binding\nalready exists for the given home address and the\nhome registration flag has a different value than\nthe Home Registration (H) bit in the Binding Update.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6CnCounterTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2))
if mibBuilder.loadTexts: mip6CnCounterTable.setDescription("A table containing each mobile .")
mip6CnCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6BindingHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6BindingHomeAddress"))
if mibBuilder.loadTexts: mip6CnCounterEntry.setDescription("The set of correspondent node counters for a mobile\nnode.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6BindingHomeAddress\nexceeds 113, then OIDs of column instances in\nthis row will have more than 128 sub-identifiers and\ncannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
mip6CnBURequestsAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBURequestsAccepted.setDescription("Total number of Binding Update requests from the\nmobile node accepted by the correspondent node.\nIf Binding Acknowledgment messages are sent, then\nthe status code in the message will have a value\nless than 128.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CnCtrDiscontinuityTime.")
mip6CnBURequestsRejected = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBURequestsRejected.setDescription("Total number of Binding Update requests from the\nmobile node that have been rejected by the\ncorrespondent node.  This includes the Binding Update\nrequests for which a Binding Acknowledgment message\nhas been sent with status code value greater than or\nequal to 128 and the Binding Acknowledgment requests\nthat have been silently discarded.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CnCtrDiscontinuityTime.")
mip6CnBCEntryCreationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBCEntryCreationTime.setDescription("The time when the current Binding Cache entry was\ncreated for the mobile node.")
mip6CnBUAcceptedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBUAcceptedTime.setDescription("The time at which the last Binding Update was\naccepted by the correspondent node and the\ncorresponding Binding Cache entry was updated.")
mip6CnBURejectionTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBURejectionTime.setDescription("The time at which the last Binding Update message\nwas rejected by the correspondent node.\nIf there have been no rejections, then this object\nwill be inaccessible.")
mip6CnBURejectionCode = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 6), Mip6BURequestRejectionCode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnBURejectionCode.setDescription("If a Binding Acknowledgment is sent to the mobile\nnode, this is the status code (> 128) that is\nreturned in the Binding Acknowledgment.\nIn case a Binding Acknowledgment is not sent to\nthe mobile node, then this will be the value\nof the Status code that corresponds to the reason\nof the rejection.  If there have been no\nrejections, then this object will be inaccessible.")
mip6CnCtrDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 3, 2, 2, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6CnCtrDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of counters in this row,\nviz., instances of 'mip6CnBURequestsAccepted' and\n'mip6CnBURequestsRejected', suffered a discontinuity.\nIf no such discontinuities have occurred since the\nlast re-initialization of the local management\nsubsystem, then this object will have a zero value.")
mip6Ha = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 4))
mip6HaAdvertisement = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 4, 1))
mip6HaAdvsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaAdvsRecd.setDescription("Total number of valid Router Advertisements\nreceived with the Home Agent (H) bit set, on\nall the links on which it is serving as a Home\nAgent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaAdvsSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaAdvsSent.setDescription("Total number of unsolicited multicast Router\nAdvertisements sent with the Home Agent (H) bit set,\non all the links on which the router is serving as\na Home Agent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaConfTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3))
if mibBuilder.loadTexts: mip6HaConfTable.setDescription("A table containing configurable advertisement\nparameters for all interfaces on which the\nhome agent service is advertised.\nIt is RECOMMENDED that the last written values\nof the objects in the conceptual rows of this\n\n\n\ntable will remain unchanged across reboots of\nthe managed entity provided that the interfaces\nhave not been renumbered after the reboot.")
mip6HaConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3, 1)).setIndexNames((0, "IP-MIB", "ipv6InterfaceIfIndex"))
if mibBuilder.loadTexts: mip6HaConfEntry.setDescription("Advertisement parameters for an interface.\nThe instances of the columnar objects in this entry\npertain to the interface that is uniquely identified\nby the ipv6InterfaceIfIndex of the interface.  The\nsame ipv6InterfaceIfIndex object is used to uniquely\nidentify instances of the columnar objects of this\nconceptual row.")
mip6HaAdvPreference = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65536))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6HaAdvPreference.setDescription("The preference value for the home agent to\nbe used in the Router Advertisements.  Higher\nvalue denotes greater preference.")
mip6HaAdvLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6HaAdvLifetime.setDescription("The lifetime value for the home agent to be\nused in the Router Advertisements.")
mip6HaPrefixAdv = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6HaPrefixAdv.setDescription("Indicates whether the home agent should support\nsending of the ICMP Mobile Prefix Advertisements.\nIf it is disabled(2), the home agent will not\nsend ICMP Mobile Prefix Advertisements to the\nmobile nodes.\nThe state can be changed from enabled(1) to\ndisabled(2) and vice versa by operator\nintervention.\nCausing the state to change from enabled(1) to\ndisabled(2) will result in the home agent\ndisabling the Prefix advertisement function.\nOn the other hand, changing the status from\ndisabled(2) to enabled(1) will start the prefix\nadvertisement function.")
mip6HaPrefixSolicitation = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6HaPrefixSolicitation.setDescription("Indicates whether the home agent should respond\nto ICMP Mobile Prefix Solicitation messages it\nreceives from the mobile nodes.  By default, the\nvalue will be set to enabled(1).  If it is\ndisabled(2), the home agent will not respond to\nany ICMP Mobile Prefix Solicitation messages.\nThe state can be changed from enabled(1) to\ndisabled(2), by operator intervention.  Causing\nthe state to change from enabled(1) to\ndisabled(2) will result in the home agent not\nresponding to any ICMP Mobile Prefix\nSolicitation messages it receives from the\nmobile nodes.")
mip6HaMCastCtlMsgSupport = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 3, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: mip6HaMCastCtlMsgSupport.setDescription("Indicates whether the home agent should enable\nsupport for the processing of the multicast\ngroup membership control messages it receives\nfrom the mobile nodes.  By default, the value\nwill be set to enabled(1).  If it is\ndisabled(2), the home agent will not process\nany multicast group control messages it receives\nfrom the mobile nodes.\nThe state can be changed from enabled(1) to\ndisabled(2), by operator intervention.  Causing\nthe state to change from enabled(1) to\ndisabled(2) will result in the home agent\ndisabling the processing of the multicast group\ncontrol messages it received from the mobile\nnodes.")
mip6HaListTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4))
if mibBuilder.loadTexts: mip6HaListTable.setDescription("This table models the Home Agents List that contains\nthe list of all routers that are acting as home\nagents on each of the interfaces on which the home\nagent service is offered by this router.")
mip6HaListEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4, 1)).setIndexNames((0, "IP-MIB", "ipv6InterfaceIfIndex"), (0, "MOBILEIPV6-MIB", "mip6HaLinkLocalAddressType"), (0, "MOBILEIPV6-MIB", "mip6HaLinkLocalAddress"))
if mibBuilder.loadTexts: mip6HaListEntry.setDescription("Information about a router that is offering home\nagent service.\nThe instances of the columnar objects in this entry\npertain to an interface for a particular value of\nmip6HaLinkLocalAddressType and\nmip6HaLinkLocalAddress.  The interface is uniquely\nidentified by its ipv6InterfaceIfIndex.  The same\nipv6InterfaceIfIndex object is used in conjunction\nwith the mip6HaLinkLocalAddressType and\nmip6HaLinkLocalAddress to uniquely identify\ninstances of the columnar objects of this row.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6HaLinkLocalAddress\nexceeds 112, then OIDs of column instances in\nthis row will have more than 128 sub-identifiers and\ncannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
mip6HaLinkLocalAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6HaLinkLocalAddressType.setDescription("The address type for the link-local address\nof the home agent that follows.")
mip6HaLinkLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6HaLinkLocalAddress.setDescription("The link local address of the home agent.\n\nThe type of the address represented by this object\nis specified by the corresponding\nmip6HaLinkLocalAddressType object.")
mip6HaPreference = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaPreference.setDescription("The preference value of this home agent.\nHigher values indicate a more preferable home\nagent.  The preference value is obtained from\nthe preference field of the received Router\nAdvertisement.")
mip6HaRecvLifeTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaRecvLifeTime.setDescription("The lifetime for this home agent.")
mip6HaRecvTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 4, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaRecvTimeStamp.setDescription("The time when the home agent advertisement was\nreceived.")
mip6HaGlAddrTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 5))
if mibBuilder.loadTexts: mip6HaGlAddrTable.setDescription("This table contains the global addresses of the home\nagents in the Home Agents List.")
mip6HaGlAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 5, 1)).setIndexNames((0, "IP-MIB", "ipv6InterfaceIfIndex"), (0, "MOBILEIPV6-MIB", "mip6HaLinkLocalAddressType"), (0, "MOBILEIPV6-MIB", "mip6HaLinkLocalAddress"), (0, "MOBILEIPV6-MIB", "mip6HaGaAddrSeqNo"))
if mibBuilder.loadTexts: mip6HaGlAddrEntry.setDescription("A global address for a home agent in the Home Agents\nList.\nThe instances of the columnar objects in this entry\npertain to an interface for a particular value of\nmip6HaLinkLocalAddressType, mip6HaLinkLocalAddress\nand mip6HaGaAddrSeqNo.\nThe mip6HaGaAddrSeqNo object is used to distinguish\nbetween multiple instances of the home agent global\naddresses on the same interface for the same set of\nmip6HaLinkLocalAddressType, mip6HaLinkLocalAddress,\nvalues.\nThere is no upper-bound on the maximum number of\nglobal addresses on an interface but, for practical\npurposes, the upper-bound of the value\nmip6HaGaAddrSeqNo is set to 1024.\nThe interface is uniquely identified by its\nipv6InterfaceIfIndex.  The same ipv6InterfaceIfIndex\nobject is used in conjunction with the\nmip6HaLinkLocalAddressType, mip6HaLinkLocalAddress,\nand mip6HaGaAddrSeqNo to uniquely identify instances\nof the columnar objects of this row.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6HaLinkLocalAddress\nexceeds 111, then OIDs of column instances in\nthis row will have more than 128 sub-identifiers and\ncannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
mip6HaGaAddrSeqNo = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 5, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 1024))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: mip6HaGaAddrSeqNo.setDescription("The index that along with ipv6InterfaceIfIndex,\nmip6HaLinkLocalAddressType, and\nmip6HaLinkLocalAddress uniquely identifies this row.")
mip6HaGaGlobalAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 5, 1, 2), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaGaGlobalAddressType.setDescription("The address type for the global address of the\nhome agent that follows.")
mip6HaGaGlobalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 1, 5, 1, 3), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaGaGlobalAddress.setDescription("A global address of the home agent.\n\nThe type of the address represented by this object\nis specified by the corresponding\nmip6HaGaGlobalAddressType object.")
mip6HaStats = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 4, 2))
mip6HaGlobalStats = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1))
mip6HaHomeTestInitsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaHomeTestInitsRecd.setDescription("Total number of Home Test Init messages received by\nthe home agent.  This will include Home Test Init\nmessages that failed the validity checks.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaHomeTestsSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaHomeTestsSent.setDescription("Total number of Home Test messages sent by the\nhome agent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaBUsRecd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBUsRecd.setDescription("Total number of Binding Updates received by the\nhome agent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaBUAcksSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBUAcksSent.setDescription("Total number of Binding Acknowledgments sent\nby the home agent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaBRAdviceSent = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBRAdviceSent.setDescription("Total number of Binding Acknowledgments sent\nby the home agent with Binding Refresh Advice\nmobility option included.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaBUsAccepted = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBUsAccepted.setDescription("Total number of Binding Updates accepted by this HA.\nBinding Acknowledgment with status code of 0 or 1.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaPrefDiscoverReqd = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaPrefDiscoverReqd.setDescription("The total number of Binding Acknowledgments sent by\nthe home agent with status code indicating 'accepted\nbut prefix discovery necessary'  (Code 1).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaReasonUnspecified = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaReasonUnspecified.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'reason\nunspecified' (Code 128).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaAdmProhibited = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaAdmProhibited.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'administratively\nprohibited' (Code 129).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaInsufficientResource = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaInsufficientResource.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'insufficient\nresources' (Code 130).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaHomeRegnNotSupported = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaHomeRegnNotSupported.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'home\nregistration not supported' (Code 131).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaNotHomeSubnet = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaNotHomeSubnet.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'not home subnet'\n(Code 132).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaNotHomeAgentForThisMN = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaNotHomeAgentForThisMN.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'not home agent\nfor this mobile node' (Code 133).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaDupAddrDetectionFailed = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaDupAddrDetectionFailed.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'Duplicate\nAddress Detection failed' (Code 134).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaSeqNumberOutOfWindow = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaSeqNumberOutOfWindow.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'sequence number\nout of window' (Code 135).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaExpiredHomeNonceIndex = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaExpiredHomeNonceIndex.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'expired home\nnonce index' (Code 136).\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaRegTypeChangeDisallowed = MibScalar((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaRegTypeChangeDisallowed.setDescription("Total number of Binding Update requests rejected by\nthe home agent with status code in the Binding\nAcknowledgment message indicating 'registration\ntype change disallowed' (Code 139), i.e., a binding\nalready exists for the given home address and the\nhome registration flag has a different value than\nthe Home Registration (H) bit in the Binding Update.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6CounterDiscontinuityTime.")
mip6HaCounterTable = MibTable((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2))
if mibBuilder.loadTexts: mip6HaCounterTable.setDescription("A table containing registration statistics for all\nmobile nodes registered with the home agent.")
mip6HaCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1)).setIndexNames((0, "MOBILEIPV6-MIB", "mip6BindingHomeAddressType"), (0, "MOBILEIPV6-MIB", "mip6BindingHomeAddress"))
if mibBuilder.loadTexts: mip6HaCounterEntry.setDescription("Home agent registration statistics for a mobile\nnode.\n\nImplementors need to be aware that if the total\nnumber of octets in mip6BindingHomeAddress\nexceeds 113, then OIDs of column instances in\nthis row will have more than 128 sub-identifiers and\ncannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
mip6HaBURequestsAccepted = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBURequestsAccepted.setDescription("Total number of service requests for the mobile node\naccepted by the home agent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6HaCtrDiscontinuityTime.")
mip6HaBURequestsDenied = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBURequestsDenied.setDescription("Total number of service requests for the mobile node\nrejected by the home agent.\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nmip6HaCtrDiscontinuityTime.")
mip6HaBCEntryCreationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBCEntryCreationTime.setDescription("The time when the current Binding Cache entry was\ncreated for the mobile node.")
mip6HaBUAcceptedTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBUAcceptedTime.setDescription("The time at which the last Binding Update was\naccepted by the home agent for this mobile node.")
mip6HaBURejectionTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaBURejectionTime.setDescription("The time at which the last Binding Update was\nrejected by the home agent for this mobile node.\nIf there have been no rejections, then this object\nwill be inaccessible.")
mip6HaRecentBURejectionCode = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 6), Mip6BURequestRejectionCode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaRecentBURejectionCode.setDescription("If a Binding Acknowledgment is sent to the mobile\nnode, this is the status code (> 128) that is\nreturned in the Binding Acknowledgment.\nIn case a Binding Acknowledgment is not sent to the\nmobile node, then this will be the value of the\nstatus code that corresponds to the reason of the\nrejection.\nIf there have been no rejections, then this object\nwill be inaccessible.")
mip6HaCtrDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 133, 1, 4, 2, 2, 1, 7), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: mip6HaCtrDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one or more of counters in this row,\nviz., instances of 'mip6HaBURequestsAccepted' and\n'mip6HaBURequestsRejected', suffered a discontinuity.\nIf no such discontinuities have occurred since the\nlast re-initialization of the local management\nsubsystem, then this object will have a zero value.")
mip6Conformance = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 2))
mip6Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 2, 1))
mip6Compliances = MibIdentifier((1, 3, 6, 1, 2, 1, 133, 2, 2))

# Augmentions

# Notifications

mip6MnRegistered = NotificationType((1, 3, 6, 1, 2, 1, 133, 0, 1)).setObjects(("MOBILEIPV6-MIB", "mip6BindingCOAType"), ("MOBILEIPV6-MIB", "mip6BindingTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingCOA"), )
if mibBuilder.loadTexts: mip6MnRegistered.setDescription("This notification is sent by a home agent when\na mobile node registers with the home agent\nfor the first time.\nNotifications will not be sent for subsequent\nupdates and/or refreshes.\nThe MO instances in the notifications will be\nidentified by the mip6BindingHomeAddressType\nand mip6BindingHomeAddress for the mobile node\nin the mip6BindingCacheTable.")
mip6MnDeRegistered = NotificationType((1, 3, 6, 1, 2, 1, 133, 0, 2)).setObjects(("MOBILEIPV6-MIB", "mip6BindingCOAType"), ("MOBILEIPV6-MIB", "mip6BindingTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingCOA"), )
if mibBuilder.loadTexts: mip6MnDeRegistered.setDescription("This notification is sent by a home agent every\ntime a mobile node de-registers with the home\nagent by sending a Binding Update that requests\nthe home agent to delete a binding.\nThe MO instances in the notifications will be\nidentified by the mip6BindingHomeAddressType\nand mip6BindingHomeAddress for the mobile node\nin the mip6BindingCacheTable.")
mip6MnCOAChanged = NotificationType((1, 3, 6, 1, 2, 1, 133, 0, 3)).setObjects(("MOBILEIPV6-MIB", "mip6BindingCOAType"), ("MOBILEIPV6-MIB", "mip6BindingTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingCOA"), )
if mibBuilder.loadTexts: mip6MnCOAChanged.setDescription("This notification is sent by a home agent every\ntime a mobile node sends a Binding Update with\na new care-of address (for an existing Binding\nCache entry).\nNotifications will not be sent for subsequent\nupdates and/or refreshes for the same Care-of\naddress.\nThe registration of a new care-of address may\nindicate that the mobile node has moved or that\nthe primary care-of address of the mobile node\nhas become deprecated.\nThe MO instances in the notifications will be\nidentified by the mip6BindingHomeAddressType\nand mip6BindingHomeAddress for the mobile node\nin the mip6BindingCacheTable.")
mip6MnBindingExpiredAtHA = NotificationType((1, 3, 6, 1, 2, 1, 133, 0, 4)).setObjects(("MOBILEIPV6-MIB", "mip6BindingCOAType"), ("MOBILEIPV6-MIB", "mip6BindingTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingCOA"), )
if mibBuilder.loadTexts: mip6MnBindingExpiredAtHA.setDescription("This notification is sent by a home agent when a\nbinding for the mobile node at the home agent\nexpired (no timely Binding Updates were received).\nThe MO instances in the notifications will be\nidentified by the mip6BindingHomeAddressType\nand mip6BindingHomeAddress for the mobile node\nin the mip6BindingCacheTable.")
mip6MnBindingExpiredAtCN = NotificationType((1, 3, 6, 1, 2, 1, 133, 0, 5)).setObjects(("MOBILEIPV6-MIB", "mip6BindingCOAType"), ("MOBILEIPV6-MIB", "mip6BindingTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingCOA"), )
if mibBuilder.loadTexts: mip6MnBindingExpiredAtCN.setDescription("This notification is sent by a correspondent node\nwhen a binding for the mobile node at the\ncorrespondent node expired (no timely Binding\nUpdates were received).\nThe MO instances in the notifications will be\nidentified by the mip6BindingHomeAddressType\nand mip6BindingHomeAddress for the mobile node\nin the mip6BindingCacheTable.")

# Groups

mip6SystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 1)).setObjects(("MOBILEIPV6-MIB", "mip6Capabilities"), ("MOBILEIPV6-MIB", "mip6Status"), )
if mibBuilder.loadTexts: mip6SystemGroup.setDescription(" A collection of objects for basic MIPv6\nmonitoring.")
mip6BindingCacheGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 2)).setObjects(("MOBILEIPV6-MIB", "mip6BindingCOAType"), ("MOBILEIPV6-MIB", "mip6BindingUsageCount"), ("MOBILEIPV6-MIB", "mip6BindingTimeRemaining"), ("MOBILEIPV6-MIB", "mip6BindingUsageTS"), ("MOBILEIPV6-MIB", "mip6BindingAdminStatus"), ("MOBILEIPV6-MIB", "mip6BindingTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingTimeGranted"), ("MOBILEIPV6-MIB", "mip6BindingCOA"), ("MOBILEIPV6-MIB", "mip6BindingMaxSeq"), ("MOBILEIPV6-MIB", "mip6BindingHomeRegn"), )
if mibBuilder.loadTexts: mip6BindingCacheGroup.setDescription(" A collection of objects for monitoring the\nBinding Cache.")
mip6BindingHstGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 3)).setObjects(("MOBILEIPV6-MIB", "mip6BindingHstUsageTS"), ("MOBILEIPV6-MIB", "mip6BindingHstCOA"), ("MOBILEIPV6-MIB", "mip6BindingHstTimeExpired"), ("MOBILEIPV6-MIB", "mip6BindingHstCOAType"), ("MOBILEIPV6-MIB", "mip6BindingHstTimeRegistered"), ("MOBILEIPV6-MIB", "mip6BindingHstUsageCount"), ("MOBILEIPV6-MIB", "mip6BindingHstHomeRegn"), )
if mibBuilder.loadTexts: mip6BindingHstGroup.setDescription(" A collection of objects for monitoring the\nBinding History.  This can be used to monitor\nthe movement of the mobile node.")
mip6TotalTrafficGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 4)).setObjects(("MOBILEIPV6-MIB", "mip6InOctets"), ("MOBILEIPV6-MIB", "mip6InPkts"), ("MOBILEIPV6-MIB", "mip6OutPkts"), ("MOBILEIPV6-MIB", "mip6HCOutOctets"), ("MOBILEIPV6-MIB", "mip6OutOctets"), ("MOBILEIPV6-MIB", "mip6HCOutPkts"), ("MOBILEIPV6-MIB", "mip6CounterDiscontinuityTime"), ("MOBILEIPV6-MIB", "mip6HCInOctets"), ("MOBILEIPV6-MIB", "mip6HCInPkts"), )
if mibBuilder.loadTexts: mip6TotalTrafficGroup.setDescription(" A collection of objects for monitoring the\ntotal MIPv6 traffic.")
mip6NodeTrafficGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 5)).setObjects(("MOBILEIPV6-MIB", "mip6NodeOutOctets"), ("MOBILEIPV6-MIB", "mip6NodeInPkts"), ("MOBILEIPV6-MIB", "mip6NodeCtrDiscontinuityTime"), ("MOBILEIPV6-MIB", "mip6HCNodeInOctets"), ("MOBILEIPV6-MIB", "mip6NodeInOctets"), ("MOBILEIPV6-MIB", "mip6HCNodeInPkts"), ("MOBILEIPV6-MIB", "mip6NodeOutPkts"), ("MOBILEIPV6-MIB", "mip6HCNodeOutPkts"), ("MOBILEIPV6-MIB", "mip6HCNodeOutOctets"), )
if mibBuilder.loadTexts: mip6NodeTrafficGroup.setDescription(" A collection of objects for monitoring the\nMIPv6 traffic due to a mobile node.")
mip6MnSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 6)).setObjects(("MOBILEIPV6-MIB", "mip6MnHomeAddressState"), )
if mibBuilder.loadTexts: mip6MnSystemGroup.setDescription(" A collection of objects for basic monitoring\nof the mobile node.")
mip6MnConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 7)).setObjects(("MOBILEIPV6-MIB", "mip6MnDiscoveryRequests"), ("MOBILEIPV6-MIB", "mip6MnPrefixAdvsRecd"), ("MOBILEIPV6-MIB", "mip6MnDiscoveryTimeouts"), ("MOBILEIPV6-MIB", "mip6MnPrefixSolicitationsSent"), ("MOBILEIPV6-MIB", "mip6MnMovedToHN"), ("MOBILEIPV6-MIB", "mip6MnPrefixAdvsIgnored"), ("MOBILEIPV6-MIB", "mip6MnMovedToFN"), ("MOBILEIPV6-MIB", "mip6MnDiscoveryReplies"), )
if mibBuilder.loadTexts: mip6MnConfGroup.setDescription(" A collection of objects for monitoring\nthe advertisement-related info on the\nmobile node.")
mip6MnRegistrationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 8)).setObjects(("MOBILEIPV6-MIB", "mip6MnBLCOAType"), ("MOBILEIPV6-MIB", "mip6MnICMPErrorsRecd"), ("MOBILEIPV6-MIB", "mip6MnBindingErrorsFromCN"), ("MOBILEIPV6-MIB", "mip6MnBUsToCN"), ("MOBILEIPV6-MIB", "mip6MnBLCOA"), ("MOBILEIPV6-MIB", "mip6MnMobilityMessagesSent"), ("MOBILEIPV6-MIB", "mip6MnBLLifeTimeRequested"), ("MOBILEIPV6-MIB", "mip6MnBLAccepted"), ("MOBILEIPV6-MIB", "mip6MnMobilityMessagesRecd"), ("MOBILEIPV6-MIB", "mip6MnBLRetransmissions"), ("MOBILEIPV6-MIB", "mip6MnBLLifeTimeGranted"), ("MOBILEIPV6-MIB", "mip6MnBLTimeSent"), ("MOBILEIPV6-MIB", "mip6MnBLDontSendBUFlag"), ("MOBILEIPV6-MIB", "mip6MnBLMaxSeq"), ("MOBILEIPV6-MIB", "mip6MnBRRequestsRecd"), ("MOBILEIPV6-MIB", "mip6MnBUAcksFromHA"), ("MOBILEIPV6-MIB", "mip6MnBUAcksFromCN"), ("MOBILEIPV6-MIB", "mip6MnBUsToHA"), ("MOBILEIPV6-MIB", "mip6MnBLAcceptedTime"), )
if mibBuilder.loadTexts: mip6MnRegistrationGroup.setDescription(" A collection of objects for monitoring\nthe registration statistics for the mobile node.")
mip6CnStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 9)).setObjects(("MOBILEIPV6-MIB", "mip6CnCtrDiscontinuityTime"), ("MOBILEIPV6-MIB", "mip6CnBURejectionCode"), ("MOBILEIPV6-MIB", "mip6CnBURequestsRejected"), ("MOBILEIPV6-MIB", "mip6CnBCEntryCreationTime"), ("MOBILEIPV6-MIB", "mip6CnBURejectionTime"), ("MOBILEIPV6-MIB", "mip6CnBUAcceptedTime"), ("MOBILEIPV6-MIB", "mip6CnBURequestsAccepted"), )
if mibBuilder.loadTexts: mip6CnStatsGroup.setDescription(" A collection of objects for monitoring\nthe control messages and corresponding\nstatistics for each mobile node\ncommunicating with the correspondent\nnode.")
mip6HaSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 10)).setObjects(("MOBILEIPV6-MIB", "mip6HaAdvsRecd"), ("MOBILEIPV6-MIB", "mip6HaPrefixAdv"), ("MOBILEIPV6-MIB", "mip6HaPrefixSolicitation"), ("MOBILEIPV6-MIB", "mip6HaAdvLifetime"), ("MOBILEIPV6-MIB", "mip6HaMCastCtlMsgSupport"), ("MOBILEIPV6-MIB", "mip6HaAdvsSent"), ("MOBILEIPV6-MIB", "mip6HaAdvPreference"), )
if mibBuilder.loadTexts: mip6HaSystemGroup.setDescription(" A collection of objects for monitoring\nthe advertisement-related parameters and\nstatistics for the home agent.")
mip6HaListGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 11)).setObjects(("MOBILEIPV6-MIB", "mip6HaGaGlobalAddress"), ("MOBILEIPV6-MIB", "mip6HaPreference"), ("MOBILEIPV6-MIB", "mip6HaRecvTimeStamp"), ("MOBILEIPV6-MIB", "mip6HaGaGlobalAddressType"), ("MOBILEIPV6-MIB", "mip6HaRecvLifeTime"), )
if mibBuilder.loadTexts: mip6HaListGroup.setDescription(" A collection of objects for monitoring\nthe Home Agent List on the home agent.")
mip6HaStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 12)).setObjects(("MOBILEIPV6-MIB", "mip6HaBURejectionTime"), ("MOBILEIPV6-MIB", "mip6HaBURequestsAccepted"), ("MOBILEIPV6-MIB", "mip6HaRecentBURejectionCode"), ("MOBILEIPV6-MIB", "mip6HaBUAcceptedTime"), ("MOBILEIPV6-MIB", "mip6HaCtrDiscontinuityTime"), ("MOBILEIPV6-MIB", "mip6HaBURequestsDenied"), ("MOBILEIPV6-MIB", "mip6HaBCEntryCreationTime"), )
if mibBuilder.loadTexts: mip6HaStatsGroup.setDescription(" A collection of objects for monitoring\nregistration-related statistics on the home agent.")
mip6CnGlobalStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 13)).setObjects(("MOBILEIPV6-MIB", "mip6CnSeqNumberOutOfWindow"), ("MOBILEIPV6-MIB", "mip6CnCareOfTestInitsRecd"), ("MOBILEIPV6-MIB", "mip6CnBUsAccepted"), ("MOBILEIPV6-MIB", "mip6CnExpiredHomeNonceIndex"), ("MOBILEIPV6-MIB", "mip6CnReasonUnspecified"), ("MOBILEIPV6-MIB", "mip6CnHomeTestsSent"), ("MOBILEIPV6-MIB", "mip6CnBindingErrors"), ("MOBILEIPV6-MIB", "mip6CnHomeRegnNotSupported"), ("MOBILEIPV6-MIB", "mip6CnBUAcksSent"), ("MOBILEIPV6-MIB", "mip6CnRegTypeChangeDisallowed"), ("MOBILEIPV6-MIB", "mip6CnExpiredNonce"), ("MOBILEIPV6-MIB", "mip6CnBUsRejected"), ("MOBILEIPV6-MIB", "mip6CnInsufficientResource"), ("MOBILEIPV6-MIB", "mip6CnCareOfTestsSent"), ("MOBILEIPV6-MIB", "mip6CnExpiredCareOfNonceIndex"), ("MOBILEIPV6-MIB", "mip6CnHomeTestInitsRecd"), ("MOBILEIPV6-MIB", "mip6CnBUsRecd"), ("MOBILEIPV6-MIB", "mip6CnBRsSent"), )
if mibBuilder.loadTexts: mip6CnGlobalStatsGroup.setDescription(" A collection of objects for monitoring\nadvertisement and registration statistics on\na correspondent node.")
mip6HaGlobalStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 14)).setObjects(("MOBILEIPV6-MIB", "mip6HaBUsAccepted"), ("MOBILEIPV6-MIB", "mip6HaInsufficientResource"), ("MOBILEIPV6-MIB", "mip6HaHomeRegnNotSupported"), ("MOBILEIPV6-MIB", "mip6HaBRAdviceSent"), ("MOBILEIPV6-MIB", "mip6HaSeqNumberOutOfWindow"), ("MOBILEIPV6-MIB", "mip6HaPrefDiscoverReqd"), ("MOBILEIPV6-MIB", "mip6HaBUAcksSent"), ("MOBILEIPV6-MIB", "mip6HaDupAddrDetectionFailed"), ("MOBILEIPV6-MIB", "mip6HaRegTypeChangeDisallowed"), ("MOBILEIPV6-MIB", "mip6HaReasonUnspecified"), ("MOBILEIPV6-MIB", "mip6HaAdmProhibited"), ("MOBILEIPV6-MIB", "mip6HaNotHomeAgentForThisMN"), ("MOBILEIPV6-MIB", "mip6HaExpiredHomeNonceIndex"), ("MOBILEIPV6-MIB", "mip6HaHomeTestsSent"), ("MOBILEIPV6-MIB", "mip6HaBUsRecd"), ("MOBILEIPV6-MIB", "mip6HaHomeTestInitsRecd"), ("MOBILEIPV6-MIB", "mip6HaNotHomeSubnet"), )
if mibBuilder.loadTexts: mip6HaGlobalStatsGroup.setDescription(" A collection of objects for monitoring\nadvertisement and registration statistics on\na home agent.")
mip6BindingCacheCtlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 15)).setObjects(("MOBILEIPV6-MIB", "mip6BindingAdminStatus"), )
if mibBuilder.loadTexts: mip6BindingCacheCtlGroup.setDescription("A collection of objects for controlling the\nBinding Cache.")
mip6NotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 133, 2, 1, 16)).setObjects(("MOBILEIPV6-MIB", "mip6MnCOAChanged"), ("MOBILEIPV6-MIB", "mip6MnBindingExpiredAtHA"), ("MOBILEIPV6-MIB", "mip6MnDeRegistered"), ("MOBILEIPV6-MIB", "mip6MnRegistered"), ("MOBILEIPV6-MIB", "mip6MnBindingExpiredAtCN"), )
if mibBuilder.loadTexts: mip6NotificationGroup.setDescription("A collection of notifications from a home agent\nor correspondent node to the Manager about the\nstatus of a mobile node.")

# Compliances

mip6CoreCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 1)).setObjects(("MOBILEIPV6-MIB", "mip6SystemGroup"), )
if mibBuilder.loadTexts: mip6CoreCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB.")
mip6Compliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 2)).setObjects(("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), ("MOBILEIPV6-MIB", "mip6BindingCacheGroup"), ("MOBILEIPV6-MIB", "mip6SystemGroup"), )
if mibBuilder.loadTexts: mip6Compliance2.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and support\nmonitoring of the Binding Cache and the Total\nTraffic.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--")
mip6Compliance3 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 3)).setObjects(("MOBILEIPV6-MIB", "mip6NodeTrafficGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), ("MOBILEIPV6-MIB", "mip6BindingCacheGroup"), ("MOBILEIPV6-MIB", "mip6BindingHstGroup"), ("MOBILEIPV6-MIB", "mip6SystemGroup"), )
if mibBuilder.loadTexts: mip6Compliance3.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the Binding Cache,\nthe Binding History, the total traffic, and\nthe mobile node-wide traffic.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHstHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the\n--     mip6BindingHstHomeAddress object.\n--\n-- OBJECT      mip6BindingHstHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the\n--     mip6BindingHstHomeAddress object.\n--")
mip6CoreReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 4)).setObjects(("MOBILEIPV6-MIB", "mip6SystemGroup"), )
if mibBuilder.loadTexts: mip6CoreReadOnlyCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB without support\nfor read-write (i.e., in read-only mode).")
mip6ReadOnlyCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 5)).setObjects(("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), ("MOBILEIPV6-MIB", "mip6BindingCacheGroup"), ("MOBILEIPV6-MIB", "mip6SystemGroup"), )
if mibBuilder.loadTexts: mip6ReadOnlyCompliance2.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB without support\nfor read-write (i.e., in read-only mode) and\nsupport monitoring of the Binding Cache and Total\nTraffic.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--")
mip6ReadOnlyCompliance3 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 6)).setObjects(("MOBILEIPV6-MIB", "mip6NodeTrafficGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), ("MOBILEIPV6-MIB", "mip6BindingCacheGroup"), ("MOBILEIPV6-MIB", "mip6BindingHstGroup"), ("MOBILEIPV6-MIB", "mip6SystemGroup"), )
if mibBuilder.loadTexts: mip6ReadOnlyCompliance3.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB without support\nfor read-write (i.e., in read-only mode) and support\nmonitoring of the Binding Cache, the Binding History,\nthe total traffic, and the mobile node-wide traffic.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHstHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the\n--     mip6BindingHstHomeAddress object.\n--\n\n\n\n-- OBJECT      mip6BindingHstHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the\n--     mip6BindingHstHomeAddress object.\n--")
mip6MnCoreCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 7)).setObjects(("MOBILEIPV6-MIB", "mip6MnSystemGroup"), )
if mibBuilder.loadTexts: mip6MnCoreCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the basic mobile node\nfunctionality.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6MnHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6MnHomeAddress\n--     object.\n--\n-- OBJECT      mip6MnHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n\n\n\n--     ipv6 addresses for the mip6MnHomeAddress\n--     object.\n--")
mip6MnCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 8)).setObjects(("MOBILEIPV6-MIB", "mip6MnConfGroup"), ("MOBILEIPV6-MIB", "mip6MnRegistrationGroup"), ("MOBILEIPV6-MIB", "mip6MnSystemGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), )
if mibBuilder.loadTexts: mip6MnCompliance2.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the mobile node\nfunctionality specifically the Discovery- and\nRegistration-related statistics,\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6MnHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6MnHomeAddress\n--     object.\n--\n-- OBJECT      mip6MnHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6MnHomeAddress\n--     object.\n--\n-- OBJECT      mip6MnBLNodeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6MnBLNodeAddress\n--     object.\n--\n-- OBJECT      mip6MnBLNodeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6MnBLNodeAddress\n--     object.\n\n\n\n--")
mip6CnCoreCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 9)).setObjects(("MOBILEIPV6-MIB", "mip6CnGlobalStatsGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), )
if mibBuilder.loadTexts: mip6CnCoreCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the basic correspondent node\nfunctionality.")
mip6CnCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 10)).setObjects(("MOBILEIPV6-MIB", "mip6CnGlobalStatsGroup"), ("MOBILEIPV6-MIB", "mip6CnStatsGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), )
if mibBuilder.loadTexts: mip6CnCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the basic correspondent node\nfunctionality.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.")
mip6HaCoreCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 11)).setObjects(("MOBILEIPV6-MIB", "mip6HaSystemGroup"), )
if mibBuilder.loadTexts: mip6HaCoreCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the basic home agent\nfunctionality.")
mip6HaCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 12)).setObjects(("MOBILEIPV6-MIB", "mip6HaGlobalStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaListGroup"), ("MOBILEIPV6-MIB", "mip6HaStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaSystemGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), )
if mibBuilder.loadTexts: mip6HaCompliance2.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring of the home agent\nfunctionality specifically the Home Agent List\nand the home-agent-registration-related statistics,\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddressType\n\n\n\n-- SYNTAX      InetAddressType { ipv6z(4) }\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddress\n-- SYNTAX      InetAddress (SIZE(20))\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--")
mip6HaCompliance3 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 13)).setObjects(("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), ("MOBILEIPV6-MIB", "mip6HaStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaSystemGroup"), ("MOBILEIPV6-MIB", "mip6HaGlobalStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaListGroup"), ("MOBILEIPV6-MIB", "mip6BindingCacheCtlGroup"), )
if mibBuilder.loadTexts: mip6HaCompliance3.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport monitoring and control of the home agent\nfunctionality specifically the Home Agent List\nand the home-agent-registration-related statistics,\n\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n\n\n\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddressType\n-- SYNTAX      InetAddressType { ipv6z(4) }\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddress\n-- SYNTAX      InetAddress (SIZE(20))\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--")
mip6HaCoreReadOnlyCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 14)).setObjects(("MOBILEIPV6-MIB", "mip6HaSystemGroup"), )
if mibBuilder.loadTexts: mip6HaCoreReadOnlyCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB without support\nfor read-write (i.e., in read-only mode) and\nsupport monitoring of the basic home agent\nfunctionality.")
mip6HaReadOnlyCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 15)).setObjects(("MOBILEIPV6-MIB", "mip6HaGlobalStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaListGroup"), ("MOBILEIPV6-MIB", "mip6HaStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaSystemGroup"), ("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), )
if mibBuilder.loadTexts: mip6HaReadOnlyCompliance2.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB without support\nfor read-write (i.e., in read-only mode) and\nsupport monitoring of the home agent\nfunctionality specifically the Home Agent List\nand the home-agent-registration-related statistics.\n\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddressType\n-- SYNTAX      InetAddressType { ipv6z(4) }\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddress\n-- SYNTAX      InetAddress (SIZE(20))\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--")
mip6HaReadOnlyCompliance3 = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 16)).setObjects(("MOBILEIPV6-MIB", "mip6TotalTrafficGroup"), ("MOBILEIPV6-MIB", "mip6HaStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaSystemGroup"), ("MOBILEIPV6-MIB", "mip6HaGlobalStatsGroup"), ("MOBILEIPV6-MIB", "mip6HaListGroup"), ("MOBILEIPV6-MIB", "mip6BindingCacheCtlGroup"), )
if mibBuilder.loadTexts: mip6HaReadOnlyCompliance3.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB without support\nfor read-write (i.e., in read-only mode) and\nsupport monitoring and control of the home agent\nfunctionality specifically the Home Agent List\nand the home-agent-registration-related statistics,\n\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddressType\n-- SYNTAX      InetAddressType { ipv6z(4) }\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--\n-- OBJECT      mip6HaLinkLocalAddress\n-- SYNTAX      InetAddress (SIZE(20))\n-- DESCRIPTION\n--     This MIB module requires support for local\n--     ipv6 addresses for the mip6HaLinkLocalAddress\n--     object.\n--")
mip6NotificationCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 133, 2, 2, 17)).setObjects(("MOBILEIPV6-MIB", "mip6NotificationGroup"), )
if mibBuilder.loadTexts: mip6NotificationCompliance.setDescription("The compliance statement for SNMP entities\nthat implement the MOBILEIPV6-MIB and\nsupport Notification from home agent or\ncorrespondent node to management stations\nabout the mobile node status.\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which there are compliance requirements,\nexpressed in OBJECT clause form in this description:\n\n\n\n-- OBJECT      mip6BindingHomeAddressType\n-- SYNTAX      InetAddressType { ipv6(2) }\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.\n--\n-- OBJECT      mip6BindingHomeAddress\n-- SYNTAX      InetAddress (SIZE(16))\n-- DESCRIPTION\n--     This MIB module requires support for global\n--     ipv6 addresses for the mip6BindingHomeAddress\n--     object.")

# Exports

# Module identity
mibBuilder.exportSymbols("MOBILEIPV6-MIB", PYSNMP_MODULE_ID=mip6MIB)

# Types
mibBuilder.exportSymbols("MOBILEIPV6-MIB", Mip6BURequestRejectionCode=Mip6BURequestRejectionCode)

# Objects
mibBuilder.exportSymbols("MOBILEIPV6-MIB", mip6MIB=mip6MIB, mip6Notifications=mip6Notifications, mip6Objects=mip6Objects, mip6Core=mip6Core, mip6System=mip6System, mip6Capabilities=mip6Capabilities, mip6Status=mip6Status, mip6Bindings=mip6Bindings, mip6BindingCacheTable=mip6BindingCacheTable, mip6BindingCacheEntry=mip6BindingCacheEntry, mip6BindingHomeAddressType=mip6BindingHomeAddressType, mip6BindingHomeAddress=mip6BindingHomeAddress, mip6BindingCOAType=mip6BindingCOAType, mip6BindingCOA=mip6BindingCOA, mip6BindingTimeRegistered=mip6BindingTimeRegistered, mip6BindingTimeGranted=mip6BindingTimeGranted, mip6BindingTimeRemaining=mip6BindingTimeRemaining, mip6BindingHomeRegn=mip6BindingHomeRegn, mip6BindingMaxSeq=mip6BindingMaxSeq, mip6BindingUsageTS=mip6BindingUsageTS, mip6BindingUsageCount=mip6BindingUsageCount, mip6BindingAdminStatus=mip6BindingAdminStatus, mip6BindingHistoryTable=mip6BindingHistoryTable, mip6BindingHistoryEntry=mip6BindingHistoryEntry, mip6BindingHstHomeAddressType=mip6BindingHstHomeAddressType, mip6BindingHstHomeAddress=mip6BindingHstHomeAddress, mip6BindingHstIndex=mip6BindingHstIndex, mip6BindingHstCOAType=mip6BindingHstCOAType, mip6BindingHstCOA=mip6BindingHstCOA, mip6BindingHstTimeRegistered=mip6BindingHstTimeRegistered, mip6BindingHstTimeExpired=mip6BindingHstTimeExpired, mip6BindingHstHomeRegn=mip6BindingHstHomeRegn, mip6BindingHstUsageTS=mip6BindingHstUsageTS, mip6BindingHstUsageCount=mip6BindingHstUsageCount, mip6Stats=mip6Stats, mip6TotalTraffic=mip6TotalTraffic, mip6InOctets=mip6InOctets, mip6HCInOctets=mip6HCInOctets, mip6InPkts=mip6InPkts, mip6HCInPkts=mip6HCInPkts, mip6OutOctets=mip6OutOctets, mip6HCOutOctets=mip6HCOutOctets, mip6OutPkts=mip6OutPkts, mip6HCOutPkts=mip6HCOutPkts, mip6CounterDiscontinuityTime=mip6CounterDiscontinuityTime, mip6NodeTrafficTable=mip6NodeTrafficTable, mip6NodeTrafficEntry=mip6NodeTrafficEntry, mip6NodeInOctets=mip6NodeInOctets, mip6HCNodeInOctets=mip6HCNodeInOctets, mip6NodeInPkts=mip6NodeInPkts, mip6HCNodeInPkts=mip6HCNodeInPkts, mip6NodeOutOctets=mip6NodeOutOctets, mip6HCNodeOutOctets=mip6HCNodeOutOctets, mip6NodeOutPkts=mip6NodeOutPkts, mip6HCNodeOutPkts=mip6HCNodeOutPkts, mip6NodeCtrDiscontinuityTime=mip6NodeCtrDiscontinuityTime, mip6Mn=mip6Mn, mip6MnSystem=mip6MnSystem, mip6MnHomeAddressTable=mip6MnHomeAddressTable, mip6MnHomeAddressEntry=mip6MnHomeAddressEntry, mip6MnHomeAddressType=mip6MnHomeAddressType, mip6MnHomeAddress=mip6MnHomeAddress, mip6MnHomeAddressState=mip6MnHomeAddressState, mip6MnConf=mip6MnConf, mip6MnDiscoveryRequests=mip6MnDiscoveryRequests, mip6MnDiscoveryReplies=mip6MnDiscoveryReplies, mip6MnDiscoveryTimeouts=mip6MnDiscoveryTimeouts, mip6MnPrefixSolicitationsSent=mip6MnPrefixSolicitationsSent, mip6MnPrefixAdvsRecd=mip6MnPrefixAdvsRecd, mip6MnPrefixAdvsIgnored=mip6MnPrefixAdvsIgnored, mip6MnMovedToFN=mip6MnMovedToFN, mip6MnMovedToHN=mip6MnMovedToHN, mip6MnRegistration=mip6MnRegistration, mip6MnBLTable=mip6MnBLTable, mip6MnBLEntry=mip6MnBLEntry, mip6MnBLNodeAddressType=mip6MnBLNodeAddressType, mip6MnBLNodeAddress=mip6MnBLNodeAddress, mip6MnBLCOAType=mip6MnBLCOAType, mip6MnBLCOA=mip6MnBLCOA, mip6MnBLLifeTimeRequested=mip6MnBLLifeTimeRequested, mip6MnBLLifeTimeGranted=mip6MnBLLifeTimeGranted, mip6MnBLMaxSeq=mip6MnBLMaxSeq, mip6MnBLTimeSent=mip6MnBLTimeSent, mip6MnBLAccepted=mip6MnBLAccepted, mip6MnBLAcceptedTime=mip6MnBLAcceptedTime, mip6MnBLRetransmissions=mip6MnBLRetransmissions, mip6MnBLDontSendBUFlag=mip6MnBLDontSendBUFlag, mip6MnRegnCounters=mip6MnRegnCounters, mip6MnMobilityMessagesSent=mip6MnMobilityMessagesSent, mip6MnMobilityMessagesRecd=mip6MnMobilityMessagesRecd, mip6MnBUsToHA=mip6MnBUsToHA, mip6MnBUAcksFromHA=mip6MnBUAcksFromHA, mip6MnBUsToCN=mip6MnBUsToCN, mip6MnBUAcksFromCN=mip6MnBUAcksFromCN, mip6MnBindingErrorsFromCN=mip6MnBindingErrorsFromCN, mip6MnICMPErrorsRecd=mip6MnICMPErrorsRecd, mip6MnBRRequestsRecd=mip6MnBRRequestsRecd, mip6Cn=mip6Cn, mip6CnSystem=mip6CnSystem, mip6CnStats=mip6CnStats, mip6CnGlobalStats=mip6CnGlobalStats, mip6CnHomeTestInitsRecd=mip6CnHomeTestInitsRecd, mip6CnHomeTestsSent=mip6CnHomeTestsSent, mip6CnCareOfTestInitsRecd=mip6CnCareOfTestInitsRecd, mip6CnCareOfTestsSent=mip6CnCareOfTestsSent, mip6CnBUsRecd=mip6CnBUsRecd, mip6CnBUAcksSent=mip6CnBUAcksSent, mip6CnBRsSent=mip6CnBRsSent, mip6CnBindingErrors=mip6CnBindingErrors, mip6CnBUsAccepted=mip6CnBUsAccepted, mip6CnBUsRejected=mip6CnBUsRejected, mip6CnReasonUnspecified=mip6CnReasonUnspecified, mip6CnInsufficientResource=mip6CnInsufficientResource, mip6CnHomeRegnNotSupported=mip6CnHomeRegnNotSupported, mip6CnSeqNumberOutOfWindow=mip6CnSeqNumberOutOfWindow, mip6CnExpiredHomeNonceIndex=mip6CnExpiredHomeNonceIndex, mip6CnExpiredCareOfNonceIndex=mip6CnExpiredCareOfNonceIndex, mip6CnExpiredNonce=mip6CnExpiredNonce, mip6CnRegTypeChangeDisallowed=mip6CnRegTypeChangeDisallowed, mip6CnCounterTable=mip6CnCounterTable, mip6CnCounterEntry=mip6CnCounterEntry, mip6CnBURequestsAccepted=mip6CnBURequestsAccepted, mip6CnBURequestsRejected=mip6CnBURequestsRejected, mip6CnBCEntryCreationTime=mip6CnBCEntryCreationTime, mip6CnBUAcceptedTime=mip6CnBUAcceptedTime, mip6CnBURejectionTime=mip6CnBURejectionTime)
mibBuilder.exportSymbols("MOBILEIPV6-MIB", mip6CnBURejectionCode=mip6CnBURejectionCode, mip6CnCtrDiscontinuityTime=mip6CnCtrDiscontinuityTime, mip6Ha=mip6Ha, mip6HaAdvertisement=mip6HaAdvertisement, mip6HaAdvsRecd=mip6HaAdvsRecd, mip6HaAdvsSent=mip6HaAdvsSent, mip6HaConfTable=mip6HaConfTable, mip6HaConfEntry=mip6HaConfEntry, mip6HaAdvPreference=mip6HaAdvPreference, mip6HaAdvLifetime=mip6HaAdvLifetime, mip6HaPrefixAdv=mip6HaPrefixAdv, mip6HaPrefixSolicitation=mip6HaPrefixSolicitation, mip6HaMCastCtlMsgSupport=mip6HaMCastCtlMsgSupport, mip6HaListTable=mip6HaListTable, mip6HaListEntry=mip6HaListEntry, mip6HaLinkLocalAddressType=mip6HaLinkLocalAddressType, mip6HaLinkLocalAddress=mip6HaLinkLocalAddress, mip6HaPreference=mip6HaPreference, mip6HaRecvLifeTime=mip6HaRecvLifeTime, mip6HaRecvTimeStamp=mip6HaRecvTimeStamp, mip6HaGlAddrTable=mip6HaGlAddrTable, mip6HaGlAddrEntry=mip6HaGlAddrEntry, mip6HaGaAddrSeqNo=mip6HaGaAddrSeqNo, mip6HaGaGlobalAddressType=mip6HaGaGlobalAddressType, mip6HaGaGlobalAddress=mip6HaGaGlobalAddress, mip6HaStats=mip6HaStats, mip6HaGlobalStats=mip6HaGlobalStats, mip6HaHomeTestInitsRecd=mip6HaHomeTestInitsRecd, mip6HaHomeTestsSent=mip6HaHomeTestsSent, mip6HaBUsRecd=mip6HaBUsRecd, mip6HaBUAcksSent=mip6HaBUAcksSent, mip6HaBRAdviceSent=mip6HaBRAdviceSent, mip6HaBUsAccepted=mip6HaBUsAccepted, mip6HaPrefDiscoverReqd=mip6HaPrefDiscoverReqd, mip6HaReasonUnspecified=mip6HaReasonUnspecified, mip6HaAdmProhibited=mip6HaAdmProhibited, mip6HaInsufficientResource=mip6HaInsufficientResource, mip6HaHomeRegnNotSupported=mip6HaHomeRegnNotSupported, mip6HaNotHomeSubnet=mip6HaNotHomeSubnet, mip6HaNotHomeAgentForThisMN=mip6HaNotHomeAgentForThisMN, mip6HaDupAddrDetectionFailed=mip6HaDupAddrDetectionFailed, mip6HaSeqNumberOutOfWindow=mip6HaSeqNumberOutOfWindow, mip6HaExpiredHomeNonceIndex=mip6HaExpiredHomeNonceIndex, mip6HaRegTypeChangeDisallowed=mip6HaRegTypeChangeDisallowed, mip6HaCounterTable=mip6HaCounterTable, mip6HaCounterEntry=mip6HaCounterEntry, mip6HaBURequestsAccepted=mip6HaBURequestsAccepted, mip6HaBURequestsDenied=mip6HaBURequestsDenied, mip6HaBCEntryCreationTime=mip6HaBCEntryCreationTime, mip6HaBUAcceptedTime=mip6HaBUAcceptedTime, mip6HaBURejectionTime=mip6HaBURejectionTime, mip6HaRecentBURejectionCode=mip6HaRecentBURejectionCode, mip6HaCtrDiscontinuityTime=mip6HaCtrDiscontinuityTime, mip6Conformance=mip6Conformance, mip6Groups=mip6Groups, mip6Compliances=mip6Compliances)

# Notifications
mibBuilder.exportSymbols("MOBILEIPV6-MIB", mip6MnRegistered=mip6MnRegistered, mip6MnDeRegistered=mip6MnDeRegistered, mip6MnCOAChanged=mip6MnCOAChanged, mip6MnBindingExpiredAtHA=mip6MnBindingExpiredAtHA, mip6MnBindingExpiredAtCN=mip6MnBindingExpiredAtCN)

# Groups
mibBuilder.exportSymbols("MOBILEIPV6-MIB", mip6SystemGroup=mip6SystemGroup, mip6BindingCacheGroup=mip6BindingCacheGroup, mip6BindingHstGroup=mip6BindingHstGroup, mip6TotalTrafficGroup=mip6TotalTrafficGroup, mip6NodeTrafficGroup=mip6NodeTrafficGroup, mip6MnSystemGroup=mip6MnSystemGroup, mip6MnConfGroup=mip6MnConfGroup, mip6MnRegistrationGroup=mip6MnRegistrationGroup, mip6CnStatsGroup=mip6CnStatsGroup, mip6HaSystemGroup=mip6HaSystemGroup, mip6HaListGroup=mip6HaListGroup, mip6HaStatsGroup=mip6HaStatsGroup, mip6CnGlobalStatsGroup=mip6CnGlobalStatsGroup, mip6HaGlobalStatsGroup=mip6HaGlobalStatsGroup, mip6BindingCacheCtlGroup=mip6BindingCacheCtlGroup, mip6NotificationGroup=mip6NotificationGroup)

# Compliances
mibBuilder.exportSymbols("MOBILEIPV6-MIB", mip6CoreCompliance=mip6CoreCompliance, mip6Compliance2=mip6Compliance2, mip6Compliance3=mip6Compliance3, mip6CoreReadOnlyCompliance=mip6CoreReadOnlyCompliance, mip6ReadOnlyCompliance2=mip6ReadOnlyCompliance2, mip6ReadOnlyCompliance3=mip6ReadOnlyCompliance3, mip6MnCoreCompliance=mip6MnCoreCompliance, mip6MnCompliance2=mip6MnCompliance2, mip6CnCoreCompliance=mip6CnCoreCompliance, mip6CnCompliance=mip6CnCompliance, mip6HaCoreCompliance=mip6HaCoreCompliance, mip6HaCompliance2=mip6HaCompliance2, mip6HaCompliance3=mip6HaCompliance3, mip6HaCoreReadOnlyCompliance=mip6HaCoreReadOnlyCompliance, mip6HaReadOnlyCompliance2=mip6HaReadOnlyCompliance2, mip6HaReadOnlyCompliance3=mip6HaReadOnlyCompliance3, mip6NotificationCompliance=mip6NotificationCompliance)
