# PySNMP SMI module. Autogenerated from smidump -f python NHRP-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:15:56 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( AddressFamilyNumbers, ) = mibBuilder.importSymbols("IANA-ADDRESS-FAMILY-NUMBERS-MIB", "AddressFamilyNumbers")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class NhrpGenAddr(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(0,64)
    

# Objects

nhrpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 71)).setRevisions(("1999-08-26 00:00",))
if mibBuilder.loadTexts: nhrpMIB.setOrganization("Internetworking Over NBMA (ion) Working Group")
if mibBuilder.loadTexts: nhrpMIB.setContactInfo("Maria Greene (maria@xedia.com)\nContractor\n\nJoan Cucchiara (joan@ironbridgenetworks.com)\nIronBridge Networks\n\nJames V. Luciani (luciani@baynetworks.com)\nBay Networks")
if mibBuilder.loadTexts: nhrpMIB.setDescription("This MIB contains managed object definitions for the Next\nHop Resolution Procol, NHRP, as defined in RFC 2332 [17].")
nhrpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1))
nhrpGeneralObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1, 1))
nhrpNextIndex = MibScalar((1, 3, 6, 1, 2, 1, 71, 1, 1, 1), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpNextIndex.setDescription("This scalar is used for creating rows in the\nnhrpClientTable and the nhrpServerTable.\nThe value of this variable is a currently unused value\nfor nhrpClientIndex and nhrpServerIndex.\nThe value returned when reading this variable must be\nunique for the NHC's and NHS's indices associated with\nthis row. Subsequent attempts to read this variable\nmust return different values.\n\nNOTE:  this object exists in the General Group because\nit is to be used in establishing rows in the\nnhrpClientTable and the nhrpServerTable.  In other words,\nthe value retrieved from this object could become the\nvalue of nhrpClientIndex and nhprServerIndex.\n\nIn the situation of an agent re-initialization the value\nof this object must be saved in non-volatile storage.\n\nThis variable will return the special value 0 if no new\nrows can be created.")
nhrpCacheTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 1, 2))
if mibBuilder.loadTexts: nhrpCacheTable.setDescription("This table contains mappings between internetwork layer\naddresses and NBMA subnetwork layer addresses.")
nhrpCacheEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1)).setIndexNames((0, "NHRP-MIB", "nhrpCacheInternetworkAddrType"), (0, "NHRP-MIB", "nhrpCacheInternetworkAddr"), (0, "IF-MIB", "ifIndex"), (0, "NHRP-MIB", "nhrpCacheIndex"))
if mibBuilder.loadTexts: nhrpCacheEntry.setDescription("A cached mapping between an internetwork layer address\nand an NBMA address. Entries can be created by the\nnetwork administrator using the nhrpCacheRowStatus\ncolumn, or they may be added dynamically based on\nprotocol operation (including NHRP, SCSP, and others,\nsuch as ATMARP).\n\nWhen created based by NHRP protocol operations\nthis entry is largely based on contents contained in\nthe Client Information Entry (CIE).\nZero or more Client Information Entries (CIEs) may be\nincluded in the NHRP Packet. For a complete description\nof the CIE, refer to Section 5.2.0.1 of\nRFC 2332 [17].")
nhrpCacheInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 1), AddressFamilyNumbers()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpCacheInternetworkAddrType.setDescription("The internetwork layer address type of this Next Hop\nResolution Cache entry. The value of this object indicates\nhow to interpret the values of nhrpCacheInternetworkAddr\nand nhrpCacheNextHopInternetworkAddr.")
nhrpCacheInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 2), NhrpGenAddr()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpCacheInternetworkAddr.setDescription("The value of the internetwork address of the\ndestination.")
nhrpCacheIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpCacheIndex.setDescription("An identifier for this entry that has local\nsignificance within the scope of the General\nGroup.  This identifier is used here to\nuniquely identify this row, and also used\nin the 'nhrpPurgeTable' for the value of\nthe 'nhrpPurgeCacheIdentifier'.")
nhrpCachePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCachePrefixLength.setDescription("The number of bits that define the internetwork layer\nprefix associated with the nhrpCacheInternetworkAddr.")
nhrpCacheNextHopInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNextHopInternetworkAddr.setDescription("The value of the internetwork address of the next hop.")
nhrpCacheNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 6), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNbmaAddrType.setDescription("The NBMA address type. The value of this\nobject indicates how to interpret\nthe values of nhrpCacheNbmaAddr and\nnhrpCacheNbmaSubaddr.")
nhrpCacheNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 7), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNbmaAddr.setDescription("The value of the NBMA subnetwork address of the next\nhop.")
nhrpCacheNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 8), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNbmaSubaddr.setDescription("The value of the NBMA subaddress of the next hop. If\nthere is no subaddress concept for the NBMA address\nfamily, this value will be a zero-length OCTET STRING.")
nhrpCacheType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 9), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(6,1,8,5,2,3,4,7,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("register", 2), ("resolveAuthoritative", 3), ("resoveNonauthoritative", 4), ("transit", 5), ("administrativelyAdded", 6), ("atmarp", 7), ("scsp", 8), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheType.setDescription("An indication of how this cache entry\nwas created. The values are:\n\n'other(1)'                   The entry was added by some\n                             other means.\n\n'register(2)'                In a server, added based on a\n                             client registration.\n\n'resolveAuthoritative(3)'    In a client, added based on\n                             receiving an Authoritative\n                             NHRP Resolution Reply.\n'resolveNonauthoritative(4)' In a client, added based on\n                             receiving a Nonauthoritative\n                             NHRP Resolution Reply.\n\n'transit(5)'                 In a transit server, added by\n                             examining a forwarded NHRP\n                             packet.\n\n'administrativelyAdded(6)'   In a client or server,\n                             manually added by the\n                             administrator. The\n                             StorageType of this entry is\n                             reflected in\n                             'nhrpCacheStorageType'.\n\n'atmarp(7)'                  The entry was added due to an\n                             ATMARP.\n\n'scsp(8)'                    The entry was added due to\n                             SCSP.\n\n\nWhen the entry is under creation using the\nnhrpCacheRowStatus column, the only value that can be\nspecified by the administrator is 'administrativelyAdded'.\nAttempting to set any other value will cause an\n'inconsistentValue' error.\n\nThe value cannot be modified once the entry is active.")
nhrpCacheState = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,1,)).subtype(namedValues=namedval.NamedValues(("incomplete", 1), ("ackReply", 2), ("nakReply", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheState.setDescription("An indication of the state of this entry. The values are:\n\n'incomplete(1)' The client has sent a NHRP Resolution\n                Request but has not yet received the\n                NHRP Resolution Reply.\n'ackReply(2)'   For a client or server, this is a\n                cached valid mapping.\n\n'nakReply(3)'   For a client or server, this is a\n                cached NAK mapping.")
nhrpCacheHoldingTimeValid = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheHoldingTimeValid.setDescription("True(1) is returned if the value of\n'nhrpCacheType' is not\n'administrativelyAdded'.  Since the\nvalue of 'nhrpCacheType' was not\nconfigured by a user, the value of\n'nhrpCacheHoldingTime' is\nconsidered valid.  In other words, the value of\n'nhrpCacheHoldingTime' represents\nthe Holding Time for the cache Entry.\n\nIf 'nhrpCacheType has been configured by a\nuser, (i.e. the value of 'nhrpCacheType' is\n'administrativelyAdded') then false(2) will be returned.\nThis indicates that the value of\n'nhrpCacheHoldingTime' is undefined because this row\ncould possibly be backed up in nonvolatile storage.")
nhrpCacheHoldingTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheHoldingTime.setDescription("If the value of 'nhrpCacheHoldingTimeValid is\ntrue(1) then this object represents the number\nof seconds that the cache entry will remain in this\ntable.  When this value reaches 0 (zero) the row should\nbe deleted.\n\nIf the value of 'nhrpCacheHoldingTimeValid is\nfalse(2) then this object is undefined.")
nhrpCacheNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 13), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheNegotiatedMtu.setDescription("The maximum transmission unit (MTU) that was negotiated\nor registered for this entity. In other words, this is the\nactual MTU being used.")
nhrpCachePreference = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 14), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCachePreference.setDescription("An object which reflects the Preference value of the\nClient Information Entry (CIE).\n\nZero or more Client Information Entries (CIEs) may be\nincluded in the NHRP Packet.  One of the fields in the\nCIE is the Preference.  For a complete description of\nthe CIE, refer to Section 5.2.0.1 of  RFC 2332 [17].")
nhrpCacheStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 15), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheStorageType.setDescription("This value only has meaning when the 'nhrpCacheType'\nhas the value of 'administrativelyAdded'.\n\nWhen the row is created due to being\n'administrativelyAdded', this object reflects whether\nthis row is kept in volatile storage\nand lost upon reboot or if this row is backed up by\nnon-volatile or permanent storage.\n\nIf the value of 'nhrpCacheType' has a value which\nis not 'administrativelyAdded, then the value of this\nobject is 'other(1)'.")
nhrpCacheRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 16), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpPurgeReqTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 1, 3))
if mibBuilder.loadTexts: nhrpPurgeReqTable.setDescription("This table will track Purge Request Information.")
nhrpPurgeReqEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1)).setIndexNames((0, "NHRP-MIB", "nhrpPurgeIndex"))
if mibBuilder.loadTexts: nhrpPurgeReqEntry.setDescription("Information regarding a Purge Request.")
nhrpPurgeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpPurgeIndex.setDescription("An index for this entry that has local significance\nwithin the scope of this table.")
nhrpPurgeCacheIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 2), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeCacheIdentifier.setDescription("This object identifies which row in\n'nhrpCacheTable' is being purged.  This object\nshould have the same value as the 'nhrpCacheIndex'\nin the 'nhrpCacheTable'.")
nhrpPurgePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpPurgePrefixLength.setDescription("In the case of NHRP Purge Requests, this specifies the\nequivalence class of addresses which match the first\n'Prefix Length' bit positions of the Client Protocol\nAddress specified in the Client Information Entry (CIE).")
nhrpPurgeRequestID = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeRequestID.setDescription("The Request ID used in the purge request.")
nhrpPurgeReplyExpected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 5), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeReplyExpected.setDescription("An indication of whether this Purge Request has the\n'N' Bit cleared (off).")
nhrpPurgeRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpClientObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1, 2))
nhrpClientTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 1))
if mibBuilder.loadTexts: nhrpClientTable.setDescription("Information about NHRP clients (NHCs) managed by this\nagent.")
nhrpClientEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1)).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"))
if mibBuilder.loadTexts: nhrpClientEntry.setDescription("Information about a single NHC.")
nhrpClientIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpClientIndex.setDescription("An identifier for the NHRP client that is unique within\nthe scope of this agent.  The 'nhrpNextIndex' value\nshould be consulted (read), prior to creating a row in\nthis table, and the value returned from reading\n'nhrpNextIndex' should be used as this object's value.")
nhrpClientInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 2), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientInternetworkAddrType.setDescription("The type of the internetwork layer address of this\nclient. This object indicates how the value of\nnhrpClientInternetworkAddr is to be interpreted.")
nhrpClientInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 3), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientInternetworkAddr.setDescription("The value of the internetwork layer address of this\nclient.")
nhrpClientNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 4), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNbmaAddrType.setDescription("The type of the NBMA subnetwork address of this client.\nThis object indicates how the values of\nnhrpClientNbmaAddr and nhrpClientNbmaSubaddr are to be\ninterpreted.")
nhrpClientNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNbmaAddr.setDescription("The NBMA subnetwork address of this client.")
nhrpClientNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNbmaSubaddr.setDescription("The NBMA subaddress of this client. For NBMA address\nfamilies without a subaddress concept, this will be a\nzero-length OCTET STRING.")
nhrpClientInitialRequestTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 900)).clone(10)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientInitialRequestTimeout.setDescription("The number of seconds that the client will wait before\ntiming out an NHRP initial request.  This object only has\nmeaning for the initial timeout period.")
nhrpClientRegistrationRequestRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 8), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRegistrationRequestRetries.setDescription("The number of times the client will retry the\nregistration request before failure. A value of\n0 means don't retry. A value of 65535 means\nretry forever.")
nhrpClientResolutionRequestRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientResolutionRequestRetries.setDescription("The number of times the client will retry the resolution\nrequest before failure. A value of 0 means don't retry.\nA value of 65535 means retry forever.")
nhrpClientPurgeRequestRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 10), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientPurgeRequestRetries.setDescription("The number of times the client will retry a purge request\nbefore failure. A value of 0 means don't retry. A value of\n65535 means retry forever.")
nhrpClientDefaultMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 11), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientDefaultMtu.setDescription("The default maximum transmission unit (MTU) of the\nLIS/LAG which this client should use. This object\nwill be initialized by the agent to the default MTU\nof the LIS/LAG (which is 9180) unless a different MTU\nvalue is specified during creation of this Client.")
nhrpClientHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 12), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535)).clone(900)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientHoldTime.setDescription("The hold time the client will register.")
nhrpClientRequestID = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 13), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRequestID.setDescription("The Request ID used to register this client with its\nserver. According to Section 5.2.3 of the NHRP\nSpecification, RFC 2332 [17], the Request ID must\nbe kept in non-volatile storage, so that if an NHC\ncrashes and  re-initializes, it will use a different\nRequest ID during the registration process\nwhen reregistering with the same NHS.")
nhrpClientStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 14), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientStorageType.setDescription("This object defines whether this row is kept in\nvolatile storage and lost upon a Client crash or\nreboot situation, or if this row is backed up by\nnonvolatile or permanent storage.")
nhrpClientRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpClientRegistrationTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 2))
if mibBuilder.loadTexts: nhrpClientRegistrationTable.setDescription("A table of Registration Request Information that\nneeds to be maintained by the NHCs (clients).")
nhrpClientRegistrationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1)).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"), (0, "NHRP-MIB", "nhrpClientRegIndex"))
if mibBuilder.loadTexts: nhrpClientRegistrationEntry.setDescription("An NHC needs to maintain registration request information\nbetween the NHC and the NHS.  An entry in this table\nrepresents information for a single registration request.")
nhrpClientRegIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpClientRegIndex.setDescription("An identifier for this entry such that it\nidentifies a specific Registration Request from\nthe NHC represented by the nhrpClientIndex.")
nhrpClientRegUniqueness = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("requestUnique", 1), ("requestNotUnique", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRegUniqueness.setDescription("The Uniqueness indicator for this Registration Request.\nIf this object has the value of requestUnique(1), then\nthe Uniqueness bit is set in the the NHRP Registration\nRequest represented by this row.  The value cannot\nbe changed once the row is created.")
nhrpClientRegState = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,4,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("registering", 2), ("ackRegisterReply", 3), ("nakRegisterReply", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientRegState.setDescription("The registration state of this client. The values are:\n'other(1)'             The state of the registration\n                       request is not one of\n                       'registering',\n                       'ackRegisterReply' or\n                       'nakRegisterReply'.\n\n'registering(2)'        A registration request has\n                        been issued and a registration\n                        reply is expected.\n\n'ackRegisterReply(3)'   A positive registration reply\n                        has been received.\n\n'nakRegisterReply(4)'   The client has received a\n                        negative registration\n                        reply (NAK).")
nhrpClientRegRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRegRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpClientNhsTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 3))
if mibBuilder.loadTexts: nhrpClientNhsTable.setDescription("A table of NHSes that are available for use by this NHC\n(client). By default, the agent will add an entry to this\ntable that corresponds to the client's default router.")
nhrpClientNhsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1)).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"), (0, "NHRP-MIB", "nhrpClientNhsIndex"))
if mibBuilder.loadTexts: nhrpClientNhsEntry.setDescription("An NHS that may be used by an NHC.")
nhrpClientNhsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpClientNhsIndex.setDescription("An identifier for an NHS available to an NHC.")
nhrpClientNhsInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 2), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsInternetworkAddrType.setDescription("The type of the internetwork layer address of the\nNHRP server represented in this entry. This object\nindicates how the value of\nnhrpClientNhsInternetworkAddr is to be interpreted.")
nhrpClientNhsInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 3), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsInternetworkAddr.setDescription("The value of the destination internetwork layer\naddress of the NHRP server represented by this\nentry.  If this value is not known, this will be\na zero-length OCTET STRING.")
nhrpClientNhsNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 4), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsNbmaAddrType.setDescription("The type of the NBMA subnetwork address of the NHRP\nServer represented by this entry. This object indicates\nhow the values of nhrpClientNhsNbmaAddr and\nnhrpClientNhsNbmaSubaddr are to be interpreted.")
nhrpClientNhsNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsNbmaAddr.setDescription("The NBMA subnetwork address of the NHS. The type of\nthe address is indicated by the corresponding value of\nnhrpClientNhsNbmaAddrType.")
nhrpClientNhsNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsNbmaSubaddr.setDescription("The NBMA subaddress of the NHS. For NMBA address\nfamilies that do not have the concept of subaddress,\n     this will be a zero-length OCTET STRING.")
nhrpClientNhsInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientNhsInUse.setDescription("An indication of whether this NHS is in use by the NHC.")
nhrpClientNhsRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpClientStatTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 4))
if mibBuilder.loadTexts: nhrpClientStatTable.setDescription("This table contains statistics collected by NHRP\nclients.")
nhrpClientStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1)).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"))
if mibBuilder.loadTexts: nhrpClientStatEntry.setDescription("Statistics collected by a NHRP client.")
nhrpClientStatTxResolveReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxResolveReq.setDescription("The number of NHRP Resolution Requests transmitted\nby this client.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyAck.setDescription("The number of positively acknowledged NHRP Resolution\nReplies received by this client.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakProhibited.setDescription("The number of NAKed NHRP Resolution Replies received\nby this client that contained the code indicating\n'Administratively Prohibited'.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakInsufResources.setDescription("The number of NAKed NHRP Resolution Replies received\nby this client that contained the code indicating\n'Insufficient Resources'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakNoBinding = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakNoBinding.setDescription("The number of NAKed NHRP Resolution Replies received\nby this client that contained the code indicating\n'No Internetworking Layer Address to NBMA Address\nBinding Exists'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakNotUnique = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakNotUnique.setDescription("The number of NAKed NHRP Resolution Replies received\nby this client that contained the code indicating\n'Binding Exists But Is Not Unique'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatTxRegisterReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxRegisterReq.setDescription("The number of NHRP Registration Requests transmitted\nby this client.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxRegisterAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterAck.setDescription("The number of positively acknowledged NHRP Registration\nReplies received by this client.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxRegisterNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterNakProhibited.setDescription("The number of NAKed NHRP Registration Replies received\nby this client that contained the code indicating\n'Administratively Prohibited'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxRegisterNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterNakInsufResources.setDescription("The number of NAKed NHRP Registration Replies received\nby this client that contained the code indicating\n'Insufficient Resources'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxRegisterNakAlreadyReg = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterNakAlreadyReg.setDescription("The number of NAKed NHRP Registration Replies received\nby this client that contained the code indicating 'Unique\nInternetworking Layer Address Already Registered'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxPurgeReq.setDescription("The number of NHRP Purge Requests received by this\nclient.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatTxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxPurgeReq.setDescription("The number of NHRP Purge Requests transmitted by this\nclient.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxPurgeReply.setDescription("The number of NHRP Purge Replies received by this\nclient.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatTxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxPurgeReply.setDescription("The number of NHRP Purge Replies transmitted by this\nclient.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatTxErrorIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxErrorIndication.setDescription("The number of NHRP Error Indication packets transmitted\nby this client.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrUnrecognizedExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrUnrecognizedExtension.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code\n'Unrecognized Extension'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrLoopDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrLoopDetected.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'NHRP Loop Detected'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrProtoAddrUnreachable = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrProtoAddrUnreachable.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'Protocol Address\nUnreachable'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrProtoError = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrProtoError.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'Protocol Error'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrSduSizeExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrSduSizeExceeded.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'NHRP SDU Size\n\nExceeded'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrInvalidExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrInvalidExtension.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'Invalid Extension'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrAuthenticationFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrAuthenticationFailure.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'Authentication\nFailure'.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrHopCountExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrHopCountExceeded.setDescription("The number of NHRP Error Indication packets received\nby this client with the error code 'Hop Count Exceeded'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Client re-initialization and at\nother times as indicated by the value of\nnhrpClientStatDiscontinuityTime.")
nhrpClientStatDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 25), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\nwhich any one or more of this Client's counters\nsuffered a discontinuity.  If no such discontinuities\nhave occurred since the last re-initialization of the\nlocal management subsystem or the NHRP Client\nre-initialization associated with this entry, then\nthis object contains a zero value.")
nhrpServerObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1, 3))
nhrpServerTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 1))
if mibBuilder.loadTexts: nhrpServerTable.setDescription("This table contains information for a set of NHSes\nassociated with this agent.")
nhrpServerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1)).setIndexNames((0, "NHRP-MIB", "nhrpServerIndex"))
if mibBuilder.loadTexts: nhrpServerEntry.setDescription("Information about a single NHS.")
nhrpServerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpServerIndex.setDescription("An identifier for the server that is unique within the\nscope of this agent.")
nhrpServerInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 2), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerInternetworkAddrType.setDescription("The type of the internetwork layer address of this\nserver. This object is used to interpret the value of\nnhrpServerInternetworkAddr.")
nhrpServerInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 3), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerInternetworkAddr.setDescription("The value of the internetwork layer address of this\nserver.")
nhrpServerNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 4), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNbmaAddrType.setDescription("The type of the NBMA subnetwork address of this server.\nThis object is used to interpret the value of\nnhrpServerNbmaAddr.")
nhrpServerNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNbmaAddr.setDescription("The value of the NBMA subnetwork address of this\nserver.")
nhrpServerNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNbmaSubaddr.setDescription("The value of the NBMA subaddress of this server.\nFor NBMA address families without a subaddress\nconcept, this will be a zero-length OCTET STRING.")
nhrpServerStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 7), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerStorageType.setDescription("This object defines whether this row is kept in\nvolatile storage and lost upon a Server crash or\nreboot situation, or if this row is backed up by\nnonvolatile or permanent storage.")
nhrpServerRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpServerCacheTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 2))
if mibBuilder.loadTexts: nhrpServerCacheTable.setDescription("This table extends the nhrpCacheTable for\nNHSes.  If the nhrpCacheTable has a row added due to\nan NHS or based on information regarding an NHS then\na row is also added in this table.\n\nThe rows in this table will be created when rows in\nthe nhrpCacheTable are created.  However, there may\nbe rows created in the nhrpCacheTable which do not\nhave corresponding rows in this table.  For example,\nif the nhrpCacheTable has a row added due to a Next\nHop Client which is co-resident on the same device\nas the NHS, a row will not be added to this table.")
nhrpServerCacheEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 2, 1)).setIndexNames((0, "NHRP-MIB", "nhrpCacheInternetworkAddrType"), (0, "NHRP-MIB", "nhrpCacheInternetworkAddr"), (0, "IF-MIB", "ifIndex"), (0, "NHRP-MIB", "nhrpCacheIndex"))
if mibBuilder.loadTexts: nhrpServerCacheEntry.setDescription("Additional information kept by a NHS for a relevant\nNext Hop Resolution Cache entry.")
nhrpServerCacheAuthoritative = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 2, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerCacheAuthoritative.setDescription("An indication of whether this cache entry is\nauthoritative, which means the entry was added because\nof a direct registration request with this server or\nby Server Cache Synchronization Protocol (SCSP) from\nan authoritative source.")
nhrpServerCacheUniqueness = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 2, 1, 2), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerCacheUniqueness.setDescription("The Uniqueness indicator for this cache\nentry used in duplicate address detection. This value\ncannot be changed after the entry is active.")
nhrpServerNhcTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 3))
if mibBuilder.loadTexts: nhrpServerNhcTable.setDescription("A table of NHCs that are available for use by this NHS\n(Server).")
nhrpServerNhcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1)).setIndexNames((0, "NHRP-MIB", "nhrpServerIndex"), (0, "NHRP-MIB", "nhrpServerNhcIndex"))
if mibBuilder.loadTexts: nhrpServerNhcEntry.setDescription("An NHC that may be used by an NHS.")
nhrpServerNhcIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 1), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: nhrpServerNhcIndex.setDescription("An identifier for an NHC available to an NHS.")
nhrpServerNhcPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcPrefixLength.setDescription("The number of bits that define the internetwork\nlayer prefix associated with the\nnhrpServerNhcInternetworkAddr.")
nhrpServerNhcInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 3), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcInternetworkAddrType.setDescription("The type of the internetwork layer address of the\nNHRP Client represented in this entry. This object\nindicates how the value of nhrpServerNhcInternetworkAddr\nis to be interpreted.")
nhrpServerNhcInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 4), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcInternetworkAddr.setDescription("The value of the internetwork layer address of\nthe NHRP Client represented by this entry.  If this\nvalue is not known, this will be a zero-length\nOCTET STRING.")
nhrpServerNhcNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 5), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcNbmaAddrType.setDescription("The type of the NBMA subnetwork address of the NHRP\nClient represented by this entry. This object indicates\nhow the values of nhrpServerNhcNbmaAddr and\nnhrpServerNhcNbmaSubaddr are to be interpreted.")
nhrpServerNhcNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcNbmaAddr.setDescription("The NBMA subnetwork address of the NHC. The type of the\naddress is indicated by the corresponding value of\nnhrpServerNbmaAddrType.")
nhrpServerNhcNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 7), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcNbmaSubaddr.setDescription("The NBMA subaddress of the NHC. For NMBA address familes\nthat do not have the concept of subaddress, this will\nbe a zero-length OCTET STRING.")
nhrpServerNhcInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerNhcInUse.setDescription("An indication of whether this NHC is in use by the NHS.")
nhrpServerNhcRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcRowStatus.setDescription("An object that allows entries in this table to be\ncreated and deleted using the RowStatus convention.")
nhrpServerStatTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 4))
if mibBuilder.loadTexts: nhrpServerStatTable.setDescription("Statistics collected by Next Hop Servers.")
nhrpServerStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1)).setIndexNames((0, "NHRP-MIB", "nhrpServerIndex"))
if mibBuilder.loadTexts: nhrpServerStatEntry.setDescription("Statistics for a particular NHS. The statistics are\nbroken into received (Rx), transmitted (Tx)\nand forwarded (Fw).  Forwarded (Fw) would be done\nby a transit NHS.")
nhrpServerStatRxResolveReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxResolveReq.setDescription("The number of NHRP Resolution Requests received by this\nserver.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyAck.setDescription("The number of positively acknowledged NHRP\nResolution Replies transmitted by this server.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakProhibited.setDescription("The number of NAKed NHRP Resolution Replies\ntransmitted by this server with the code\n'Administratively Prohibited'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakInsufResources.setDescription("The number of NAKed NHRP Resolution Replies\ntransmitted by this server with the code\n'Insufficient Resources'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakNoBinding = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakNoBinding.setDescription("The number of NAKed NHRP Resolution Replies\ntransmitted by this server with the code\n'No Internetworking Layer Address to NBMA\nAddress Binding Exists'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakNotUnique = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakNotUnique.setDescription("The number of NAKed NHRP Resolution Replies\ntransmitted by this server with the code\n'Binding Exists But Is Not Unique'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxRegisterReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxRegisterReq.setDescription("The number of NHRP Registration Requests received\nby this server.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxRegisterAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterAck.setDescription("The number of positively acknowledged NHRP Registration\nReplies transmitted by this server.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxRegisterNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterNakProhibited.setDescription("The number of NAKed NHRP Registration Replies\ntransmitted by this server with the code\n'Administratively Prohibited'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxRegisterNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterNakInsufResources.setDescription("The number of NAKed NHRP Registration Replies\ntransmitted by this server with the code\n'Insufficient Resources'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxRegisterNakAlreadyReg = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterNakAlreadyReg.setDescription("The number of NAKed NHRP Registration Replies\ntransmitted by this server with the code\n'Unique Internetworking Layer Address Already\nRegistered'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxPurgeReq.setDescription("The number of NHRP Purge Requests received by\nthis server.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxPurgeReq.setDescription("The number of NHRP Purge Requests transmitted by this\nserver.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxPurgeReply.setDescription("The number of NHRP Purge Replies received by this\nserver.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxPurgeReply.setDescription("The number of NHRP Purge Replies transmitted by\nthis server.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrUnrecognizedExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrUnrecognizedExtension.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code\n\n'Unrecognized Extension'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrLoopDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrLoopDetected.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code 'NHRP Loop Detected'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrProtoAddrUnreachable = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrProtoAddrUnreachable.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code 'Protocol Address\nUnreachable'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrProtoError = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrProtoError.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code 'Protocol Error'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrSduSizeExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrSduSizeExceeded.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code 'NHRP SDU Size\nExceeded'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrInvalidExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrInvalidExtension.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code 'Invalid Extension'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrInvalidResReplyReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrInvalidResReplyReceived.setDescription("The number of NHRP Error Indication packets received\nby this server with the error code 'Invalid Resolution\nReply Received'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrAuthenticationFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrAuthenticationFailure.setDescription("The number of NHRP Error Indication packets\nreceived by this server with the error code\n'Authentication Failure'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrHopCountExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrHopCountExceeded.setDescription("The number of NHRP Error Indication packets\nreceived by this server with the error code\n'Hop Count Exceeded'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrUnrecognizedExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrUnrecognizedExtension.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error code\n'Unrecognized Extension'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrLoopDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrLoopDetected.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error code\n'NHRP Loop Detected'.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrProtoAddrUnreachable = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrProtoAddrUnreachable.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error code\n'Protocol Address Unreachable'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrProtoError = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrProtoError.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error\ncode 'Protocol Error'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrSduSizeExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrSduSizeExceeded.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error code\n'NHRP SDU Size Exceeded'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrInvalidExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrInvalidExtension.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error code\n\n'Invalid Extension'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrAuthenticationFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrAuthenticationFailure.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error code\n'Authentication Failure'.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrHopCountExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrHopCountExceeded.setDescription("The number of NHRP Error Indication packets\ntransmitted by this server with the error\ncode 'Hop Count Exceeded'.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwResolveReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwResolveReq.setDescription("The number of NHRP Resolution Requests\nforwarded by this server acting as a transit NHS.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwResolveReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwResolveReply.setDescription("The number of NHRP Resolution Replies forwarded\nby this server acting as a transit NHS.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwRegisterReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwRegisterReq.setDescription("The number of NHRP Registration Requests forwarded\nby this server acting as a transit NHS.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwRegisterReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwRegisterReply.setDescription("The number of NHRP Registration Replies forwarded\nby this server acting as a transit NHS.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 37), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwPurgeReq.setDescription("The number of NHRP Purge Requests forwarded\nby this server acting as a transit NHS.\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwPurgeReply.setDescription("The number of NHRP Purge Replies forwarded by this\nserver acting as a transit NHS.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatFwErrorIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 39), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwErrorIndication.setDescription("The number of NHRP Error Indication packets forwarded\nby this server acting as a transit NHS.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, at\nNHRP Server re-initialization and at\nother times as indicated by the value of\nnhrpServerStatDiscontinuityTime.")
nhrpServerStatDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 40), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\nwhich any one or more of this Server's counters\nsuffered a discontinuity.  If no such discontinuities\nhave occurred since the last re-initialization of the\nlocal management subsystem or the NHRP Server\nre-initialization associated with this entry, then\nthis object contains a zero value.")
nhrpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 2))
nhrpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 2, 1))
nhrpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 2, 2))

# Augmentions

# Groups

nhrpGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 71, 2, 2, 1)).setObjects(("NHRP-MIB", "nhrpCacheNegotiatedMtu"), ("NHRP-MIB", "nhrpPurgeCacheIdentifier"), ("NHRP-MIB", "nhrpPurgeReplyExpected"), ("NHRP-MIB", "nhrpCachePreference"), ("NHRP-MIB", "nhrpCachePrefixLength"), ("NHRP-MIB", "nhrpCacheNbmaAddrType"), ("NHRP-MIB", "nhrpPurgeRowStatus"), ("NHRP-MIB", "nhrpCacheState"), ("NHRP-MIB", "nhrpCacheNbmaAddr"), ("NHRP-MIB", "nhrpPurgeRequestID"), ("NHRP-MIB", "nhrpCacheNextHopInternetworkAddr"), ("NHRP-MIB", "nhrpCacheHoldingTime"), ("NHRP-MIB", "nhrpCacheStorageType"), ("NHRP-MIB", "nhrpCacheRowStatus"), ("NHRP-MIB", "nhrpCacheType"), ("NHRP-MIB", "nhrpPurgePrefixLength"), ("NHRP-MIB", "nhrpCacheHoldingTimeValid"), ("NHRP-MIB", "nhrpNextIndex"), ("NHRP-MIB", "nhrpCacheNbmaSubaddr"), )
if mibBuilder.loadTexts: nhrpGeneralGroup.setDescription("Objects that apply to both NHRP clients and NHRP\nservers.")
nhrpClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 71, 2, 2, 2)).setObjects(("NHRP-MIB", "nhrpClientStatRxRegisterNakProhibited"), ("NHRP-MIB", "nhrpClientStatRxErrUnrecognizedExtension"), ("NHRP-MIB", "nhrpClientStatTxRegisterReq"), ("NHRP-MIB", "nhrpClientRegistrationRequestRetries"), ("NHRP-MIB", "nhrpClientNbmaSubaddr"), ("NHRP-MIB", "nhrpClientStatRxRegisterAck"), ("NHRP-MIB", "nhrpClientStatTxPurgeReply"), ("NHRP-MIB", "nhrpClientRegState"), ("NHRP-MIB", "nhrpClientStatRxPurgeReq"), ("NHRP-MIB", "nhrpClientInitialRequestTimeout"), ("NHRP-MIB", "nhrpClientStatRxRegisterNakInsufResources"), ("NHRP-MIB", "nhrpClientDefaultMtu"), ("NHRP-MIB", "nhrpClientStatRxErrLoopDetected"), ("NHRP-MIB", "nhrpClientStatRxErrSduSizeExceeded"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakNoBinding"), ("NHRP-MIB", "nhrpClientStorageType"), ("NHRP-MIB", "nhrpClientNbmaAddrType"), ("NHRP-MIB", "nhrpClientRequestID"), ("NHRP-MIB", "nhrpClientStatTxErrorIndication"), ("NHRP-MIB", "nhrpClientNhsRowStatus"), ("NHRP-MIB", "nhrpClientHoldTime"), ("NHRP-MIB", "nhrpClientStatRxErrAuthenticationFailure"), ("NHRP-MIB", "nhrpClientNhsInUse"), ("NHRP-MIB", "nhrpClientStatRxErrInvalidExtension"), ("NHRP-MIB", "nhrpClientStatRxErrHopCountExceeded"), ("NHRP-MIB", "nhrpClientNhsNbmaAddrType"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakProhibited"), ("NHRP-MIB", "nhrpClientStatRxErrProtoAddrUnreachable"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakInsufResources"), ("NHRP-MIB", "nhrpClientStatRxRegisterNakAlreadyReg"), ("NHRP-MIB", "nhrpClientRegUniqueness"), ("NHRP-MIB", "nhrpClientRegRowStatus"), ("NHRP-MIB", "nhrpClientResolutionRequestRetries"), ("NHRP-MIB", "nhrpClientStatTxPurgeReq"), ("NHRP-MIB", "nhrpClientNhsNbmaSubaddr"), ("NHRP-MIB", "nhrpClientStatDiscontinuityTime"), ("NHRP-MIB", "nhrpClientNhsInternetworkAddr"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakNotUnique"), ("NHRP-MIB", "nhrpClientInternetworkAddrType"), ("NHRP-MIB", "nhrpClientPurgeRequestRetries"), ("NHRP-MIB", "nhrpClientStatRxPurgeReply"), ("NHRP-MIB", "nhrpClientStatRxErrProtoError"), ("NHRP-MIB", "nhrpClientInternetworkAddr"), ("NHRP-MIB", "nhrpClientNhsNbmaAddr"), ("NHRP-MIB", "nhrpClientNbmaAddr"), ("NHRP-MIB", "nhrpClientStatTxResolveReq"), ("NHRP-MIB", "nhrpClientNhsInternetworkAddrType"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyAck"), ("NHRP-MIB", "nhrpClientRowStatus"), )
if mibBuilder.loadTexts: nhrpClientGroup.setDescription("Objects that apply only to NHRP clients.")
nhrpServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 71, 2, 2, 3)).setObjects(("NHRP-MIB", "nhrpServerStatRxErrSduSizeExceeded"), ("NHRP-MIB", "nhrpServerNhcNbmaSubaddr"), ("NHRP-MIB", "nhrpServerStatFwPurgeReply"), ("NHRP-MIB", "nhrpServerCacheUniqueness"), ("NHRP-MIB", "nhrpServerNhcInternetworkAddr"), ("NHRP-MIB", "nhrpServerNbmaAddr"), ("NHRP-MIB", "nhrpServerStatFwRegisterReply"), ("NHRP-MIB", "nhrpServerNhcInternetworkAddrType"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakProhibited"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakNotUnique"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyAck"), ("NHRP-MIB", "nhrpServerStatTxRegisterNakProhibited"), ("NHRP-MIB", "nhrpServerStatRxErrProtoError"), ("NHRP-MIB", "nhrpServerStatTxPurgeReq"), ("NHRP-MIB", "nhrpServerStatRxErrUnrecognizedExtension"), ("NHRP-MIB", "nhrpServerNhcPrefixLength"), ("NHRP-MIB", "nhrpServerStatRxErrHopCountExceeded"), ("NHRP-MIB", "nhrpServerStatFwResolveReply"), ("NHRP-MIB", "nhrpServerStatTxPurgeReply"), ("NHRP-MIB", "nhrpServerStatRxErrLoopDetected"), ("NHRP-MIB", "nhrpServerNbmaAddrType"), ("NHRP-MIB", "nhrpServerStatFwErrorIndication"), ("NHRP-MIB", "nhrpServerNhcNbmaAddrType"), ("NHRP-MIB", "nhrpServerStatTxRegisterAck"), ("NHRP-MIB", "nhrpServerStatTxErrHopCountExceeded"), ("NHRP-MIB", "nhrpServerStorageType"), ("NHRP-MIB", "nhrpServerStatTxErrAuthenticationFailure"), ("NHRP-MIB", "nhrpServerStatTxErrProtoError"), ("NHRP-MIB", "nhrpServerStatRxErrInvalidExtension"), ("NHRP-MIB", "nhrpServerInternetworkAddrType"), ("NHRP-MIB", "nhrpServerNhcInUse"), ("NHRP-MIB", "nhrpServerInternetworkAddr"), ("NHRP-MIB", "nhrpServerNbmaSubaddr"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakInsufResources"), ("NHRP-MIB", "nhrpServerStatRxRegisterReq"), ("NHRP-MIB", "nhrpServerStatTxErrUnrecognizedExtension"), ("NHRP-MIB", "nhrpServerStatRxResolveReq"), ("NHRP-MIB", "nhrpServerStatTxErrProtoAddrUnreachable"), ("NHRP-MIB", "nhrpServerStatFwResolveReq"), ("NHRP-MIB", "nhrpServerCacheAuthoritative"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakNoBinding"), ("NHRP-MIB", "nhrpServerStatTxErrLoopDetected"), ("NHRP-MIB", "nhrpServerRowStatus"), ("NHRP-MIB", "nhrpServerStatTxErrInvalidExtension"), ("NHRP-MIB", "nhrpServerStatRxErrAuthenticationFailure"), ("NHRP-MIB", "nhrpServerStatRxPurgeReq"), ("NHRP-MIB", "nhrpServerStatRxPurgeReply"), ("NHRP-MIB", "nhrpServerStatDiscontinuityTime"), ("NHRP-MIB", "nhrpServerStatTxRegisterNakAlreadyReg"), ("NHRP-MIB", "nhrpServerNhcRowStatus"), ("NHRP-MIB", "nhrpServerNhcNbmaAddr"), ("NHRP-MIB", "nhrpServerStatRxErrProtoAddrUnreachable"), ("NHRP-MIB", "nhrpServerStatRxErrInvalidResReplyReceived"), ("NHRP-MIB", "nhrpServerStatFwRegisterReq"), ("NHRP-MIB", "nhrpServerStatFwPurgeReq"), ("NHRP-MIB", "nhrpServerStatTxRegisterNakInsufResources"), ("NHRP-MIB", "nhrpServerStatTxErrSduSizeExceeded"), )
if mibBuilder.loadTexts: nhrpServerGroup.setDescription("Objects that apply only to NHRP servers.")

# Compliances

nhrpModuleCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 71, 2, 1, 1)).setObjects(("NHRP-MIB", "nhrpClientGroup"), ("NHRP-MIB", "nhrpGeneralGroup"), ("NHRP-MIB", "nhrpServerGroup"), )
if mibBuilder.loadTexts: nhrpModuleCompliance.setDescription("The compliance statement for the NHRP MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("NHRP-MIB", PYSNMP_MODULE_ID=nhrpMIB)

# Types
mibBuilder.exportSymbols("NHRP-MIB", NhrpGenAddr=NhrpGenAddr)

# Objects
mibBuilder.exportSymbols("NHRP-MIB", nhrpMIB=nhrpMIB, nhrpObjects=nhrpObjects, nhrpGeneralObjects=nhrpGeneralObjects, nhrpNextIndex=nhrpNextIndex, nhrpCacheTable=nhrpCacheTable, nhrpCacheEntry=nhrpCacheEntry, nhrpCacheInternetworkAddrType=nhrpCacheInternetworkAddrType, nhrpCacheInternetworkAddr=nhrpCacheInternetworkAddr, nhrpCacheIndex=nhrpCacheIndex, nhrpCachePrefixLength=nhrpCachePrefixLength, nhrpCacheNextHopInternetworkAddr=nhrpCacheNextHopInternetworkAddr, nhrpCacheNbmaAddrType=nhrpCacheNbmaAddrType, nhrpCacheNbmaAddr=nhrpCacheNbmaAddr, nhrpCacheNbmaSubaddr=nhrpCacheNbmaSubaddr, nhrpCacheType=nhrpCacheType, nhrpCacheState=nhrpCacheState, nhrpCacheHoldingTimeValid=nhrpCacheHoldingTimeValid, nhrpCacheHoldingTime=nhrpCacheHoldingTime, nhrpCacheNegotiatedMtu=nhrpCacheNegotiatedMtu, nhrpCachePreference=nhrpCachePreference, nhrpCacheStorageType=nhrpCacheStorageType, nhrpCacheRowStatus=nhrpCacheRowStatus, nhrpPurgeReqTable=nhrpPurgeReqTable, nhrpPurgeReqEntry=nhrpPurgeReqEntry, nhrpPurgeIndex=nhrpPurgeIndex, nhrpPurgeCacheIdentifier=nhrpPurgeCacheIdentifier, nhrpPurgePrefixLength=nhrpPurgePrefixLength, nhrpPurgeRequestID=nhrpPurgeRequestID, nhrpPurgeReplyExpected=nhrpPurgeReplyExpected, nhrpPurgeRowStatus=nhrpPurgeRowStatus, nhrpClientObjects=nhrpClientObjects, nhrpClientTable=nhrpClientTable, nhrpClientEntry=nhrpClientEntry, nhrpClientIndex=nhrpClientIndex, nhrpClientInternetworkAddrType=nhrpClientInternetworkAddrType, nhrpClientInternetworkAddr=nhrpClientInternetworkAddr, nhrpClientNbmaAddrType=nhrpClientNbmaAddrType, nhrpClientNbmaAddr=nhrpClientNbmaAddr, nhrpClientNbmaSubaddr=nhrpClientNbmaSubaddr, nhrpClientInitialRequestTimeout=nhrpClientInitialRequestTimeout, nhrpClientRegistrationRequestRetries=nhrpClientRegistrationRequestRetries, nhrpClientResolutionRequestRetries=nhrpClientResolutionRequestRetries, nhrpClientPurgeRequestRetries=nhrpClientPurgeRequestRetries, nhrpClientDefaultMtu=nhrpClientDefaultMtu, nhrpClientHoldTime=nhrpClientHoldTime, nhrpClientRequestID=nhrpClientRequestID, nhrpClientStorageType=nhrpClientStorageType, nhrpClientRowStatus=nhrpClientRowStatus, nhrpClientRegistrationTable=nhrpClientRegistrationTable, nhrpClientRegistrationEntry=nhrpClientRegistrationEntry, nhrpClientRegIndex=nhrpClientRegIndex, nhrpClientRegUniqueness=nhrpClientRegUniqueness, nhrpClientRegState=nhrpClientRegState, nhrpClientRegRowStatus=nhrpClientRegRowStatus, nhrpClientNhsTable=nhrpClientNhsTable, nhrpClientNhsEntry=nhrpClientNhsEntry, nhrpClientNhsIndex=nhrpClientNhsIndex, nhrpClientNhsInternetworkAddrType=nhrpClientNhsInternetworkAddrType, nhrpClientNhsInternetworkAddr=nhrpClientNhsInternetworkAddr, nhrpClientNhsNbmaAddrType=nhrpClientNhsNbmaAddrType, nhrpClientNhsNbmaAddr=nhrpClientNhsNbmaAddr, nhrpClientNhsNbmaSubaddr=nhrpClientNhsNbmaSubaddr, nhrpClientNhsInUse=nhrpClientNhsInUse, nhrpClientNhsRowStatus=nhrpClientNhsRowStatus, nhrpClientStatTable=nhrpClientStatTable, nhrpClientStatEntry=nhrpClientStatEntry, nhrpClientStatTxResolveReq=nhrpClientStatTxResolveReq, nhrpClientStatRxResolveReplyAck=nhrpClientStatRxResolveReplyAck, nhrpClientStatRxResolveReplyNakProhibited=nhrpClientStatRxResolveReplyNakProhibited, nhrpClientStatRxResolveReplyNakInsufResources=nhrpClientStatRxResolveReplyNakInsufResources, nhrpClientStatRxResolveReplyNakNoBinding=nhrpClientStatRxResolveReplyNakNoBinding, nhrpClientStatRxResolveReplyNakNotUnique=nhrpClientStatRxResolveReplyNakNotUnique, nhrpClientStatTxRegisterReq=nhrpClientStatTxRegisterReq, nhrpClientStatRxRegisterAck=nhrpClientStatRxRegisterAck, nhrpClientStatRxRegisterNakProhibited=nhrpClientStatRxRegisterNakProhibited, nhrpClientStatRxRegisterNakInsufResources=nhrpClientStatRxRegisterNakInsufResources, nhrpClientStatRxRegisterNakAlreadyReg=nhrpClientStatRxRegisterNakAlreadyReg, nhrpClientStatRxPurgeReq=nhrpClientStatRxPurgeReq, nhrpClientStatTxPurgeReq=nhrpClientStatTxPurgeReq, nhrpClientStatRxPurgeReply=nhrpClientStatRxPurgeReply, nhrpClientStatTxPurgeReply=nhrpClientStatTxPurgeReply, nhrpClientStatTxErrorIndication=nhrpClientStatTxErrorIndication, nhrpClientStatRxErrUnrecognizedExtension=nhrpClientStatRxErrUnrecognizedExtension, nhrpClientStatRxErrLoopDetected=nhrpClientStatRxErrLoopDetected, nhrpClientStatRxErrProtoAddrUnreachable=nhrpClientStatRxErrProtoAddrUnreachable, nhrpClientStatRxErrProtoError=nhrpClientStatRxErrProtoError, nhrpClientStatRxErrSduSizeExceeded=nhrpClientStatRxErrSduSizeExceeded, nhrpClientStatRxErrInvalidExtension=nhrpClientStatRxErrInvalidExtension, nhrpClientStatRxErrAuthenticationFailure=nhrpClientStatRxErrAuthenticationFailure, nhrpClientStatRxErrHopCountExceeded=nhrpClientStatRxErrHopCountExceeded, nhrpClientStatDiscontinuityTime=nhrpClientStatDiscontinuityTime, nhrpServerObjects=nhrpServerObjects, nhrpServerTable=nhrpServerTable, nhrpServerEntry=nhrpServerEntry, nhrpServerIndex=nhrpServerIndex, nhrpServerInternetworkAddrType=nhrpServerInternetworkAddrType, nhrpServerInternetworkAddr=nhrpServerInternetworkAddr, nhrpServerNbmaAddrType=nhrpServerNbmaAddrType, nhrpServerNbmaAddr=nhrpServerNbmaAddr, nhrpServerNbmaSubaddr=nhrpServerNbmaSubaddr, nhrpServerStorageType=nhrpServerStorageType, nhrpServerRowStatus=nhrpServerRowStatus, nhrpServerCacheTable=nhrpServerCacheTable, nhrpServerCacheEntry=nhrpServerCacheEntry, nhrpServerCacheAuthoritative=nhrpServerCacheAuthoritative, nhrpServerCacheUniqueness=nhrpServerCacheUniqueness, nhrpServerNhcTable=nhrpServerNhcTable, nhrpServerNhcEntry=nhrpServerNhcEntry, nhrpServerNhcIndex=nhrpServerNhcIndex, nhrpServerNhcPrefixLength=nhrpServerNhcPrefixLength, nhrpServerNhcInternetworkAddrType=nhrpServerNhcInternetworkAddrType, nhrpServerNhcInternetworkAddr=nhrpServerNhcInternetworkAddr, nhrpServerNhcNbmaAddrType=nhrpServerNhcNbmaAddrType, nhrpServerNhcNbmaAddr=nhrpServerNhcNbmaAddr, nhrpServerNhcNbmaSubaddr=nhrpServerNhcNbmaSubaddr, nhrpServerNhcInUse=nhrpServerNhcInUse, nhrpServerNhcRowStatus=nhrpServerNhcRowStatus, nhrpServerStatTable=nhrpServerStatTable, nhrpServerStatEntry=nhrpServerStatEntry, nhrpServerStatRxResolveReq=nhrpServerStatRxResolveReq, nhrpServerStatTxResolveReplyAck=nhrpServerStatTxResolveReplyAck, nhrpServerStatTxResolveReplyNakProhibited=nhrpServerStatTxResolveReplyNakProhibited, nhrpServerStatTxResolveReplyNakInsufResources=nhrpServerStatTxResolveReplyNakInsufResources, nhrpServerStatTxResolveReplyNakNoBinding=nhrpServerStatTxResolveReplyNakNoBinding, nhrpServerStatTxResolveReplyNakNotUnique=nhrpServerStatTxResolveReplyNakNotUnique, nhrpServerStatRxRegisterReq=nhrpServerStatRxRegisterReq)
mibBuilder.exportSymbols("NHRP-MIB", nhrpServerStatTxRegisterAck=nhrpServerStatTxRegisterAck, nhrpServerStatTxRegisterNakProhibited=nhrpServerStatTxRegisterNakProhibited, nhrpServerStatTxRegisterNakInsufResources=nhrpServerStatTxRegisterNakInsufResources, nhrpServerStatTxRegisterNakAlreadyReg=nhrpServerStatTxRegisterNakAlreadyReg, nhrpServerStatRxPurgeReq=nhrpServerStatRxPurgeReq, nhrpServerStatTxPurgeReq=nhrpServerStatTxPurgeReq, nhrpServerStatRxPurgeReply=nhrpServerStatRxPurgeReply, nhrpServerStatTxPurgeReply=nhrpServerStatTxPurgeReply, nhrpServerStatRxErrUnrecognizedExtension=nhrpServerStatRxErrUnrecognizedExtension, nhrpServerStatRxErrLoopDetected=nhrpServerStatRxErrLoopDetected, nhrpServerStatRxErrProtoAddrUnreachable=nhrpServerStatRxErrProtoAddrUnreachable, nhrpServerStatRxErrProtoError=nhrpServerStatRxErrProtoError, nhrpServerStatRxErrSduSizeExceeded=nhrpServerStatRxErrSduSizeExceeded, nhrpServerStatRxErrInvalidExtension=nhrpServerStatRxErrInvalidExtension, nhrpServerStatRxErrInvalidResReplyReceived=nhrpServerStatRxErrInvalidResReplyReceived, nhrpServerStatRxErrAuthenticationFailure=nhrpServerStatRxErrAuthenticationFailure, nhrpServerStatRxErrHopCountExceeded=nhrpServerStatRxErrHopCountExceeded, nhrpServerStatTxErrUnrecognizedExtension=nhrpServerStatTxErrUnrecognizedExtension, nhrpServerStatTxErrLoopDetected=nhrpServerStatTxErrLoopDetected, nhrpServerStatTxErrProtoAddrUnreachable=nhrpServerStatTxErrProtoAddrUnreachable, nhrpServerStatTxErrProtoError=nhrpServerStatTxErrProtoError, nhrpServerStatTxErrSduSizeExceeded=nhrpServerStatTxErrSduSizeExceeded, nhrpServerStatTxErrInvalidExtension=nhrpServerStatTxErrInvalidExtension, nhrpServerStatTxErrAuthenticationFailure=nhrpServerStatTxErrAuthenticationFailure, nhrpServerStatTxErrHopCountExceeded=nhrpServerStatTxErrHopCountExceeded, nhrpServerStatFwResolveReq=nhrpServerStatFwResolveReq, nhrpServerStatFwResolveReply=nhrpServerStatFwResolveReply, nhrpServerStatFwRegisterReq=nhrpServerStatFwRegisterReq, nhrpServerStatFwRegisterReply=nhrpServerStatFwRegisterReply, nhrpServerStatFwPurgeReq=nhrpServerStatFwPurgeReq, nhrpServerStatFwPurgeReply=nhrpServerStatFwPurgeReply, nhrpServerStatFwErrorIndication=nhrpServerStatFwErrorIndication, nhrpServerStatDiscontinuityTime=nhrpServerStatDiscontinuityTime, nhrpConformance=nhrpConformance, nhrpCompliances=nhrpCompliances, nhrpGroups=nhrpGroups)

# Groups
mibBuilder.exportSymbols("NHRP-MIB", nhrpGeneralGroup=nhrpGeneralGroup, nhrpClientGroup=nhrpClientGroup, nhrpServerGroup=nhrpServerGroup)

# Compliances
mibBuilder.exportSymbols("NHRP-MIB", nhrpModuleCompliance=nhrpModuleCompliance)
