# PySNMP SMI module. Autogenerated from smidump -f python Q-BRIDGE-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:03 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( dot1dBasePort, dot1dBasePortEntry, dot1dBridge, ) = mibBuilder.importSymbols("BRIDGE-MIB", "dot1dBasePort", "dot1dBasePortEntry", "dot1dBridge")
( EnabledStatus, ) = mibBuilder.importSymbols("P-BRIDGE-MIB", "EnabledStatus")
( TimeFilter, ) = mibBuilder.importSymbols("RMON2-MIB", "TimeFilter")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32")
( MacAddress, RowStatus, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "MacAddress", "RowStatus", "TextualConvention", "TruthValue")

# Types

class PortList(OctetString):
    pass

class VlanId(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,4094)
    
class VlanIdOrAny(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(1,4095)
    
class VlanIdOrAnyOrNone(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,4095)
    
class VlanIdOrNone(TextualConvention, Integer32):
    displayHint = "d"
    subtypeSpec = Integer32.subtypeSpec+constraint.ValueRangeConstraint(0,4094)
    
class VlanIndex(TextualConvention, Unsigned32):
    displayHint = "d"
    

# Objects

qBridgeMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 17, 7)).setRevisions(("2006-01-09 00:00","1999-08-25 00:00",))
if mibBuilder.loadTexts: qBridgeMIB.setOrganization("IETF Bridge MIB Working Group")
if mibBuilder.loadTexts: qBridgeMIB.setContactInfo("Email:  Bridge-mib@ietf.org\nietfmibs@ops.ietf.org\n\nDavid Levi\nPostal: Nortel Networks\n4655 Great America Parkway\nSanta Clara, CA 95054\nUSA\nPhone:  +1 865 686 0432\nEmail:  dlevi@nortel.com\n\nDavid Harrington\nPostal: Effective Software\n50 Harding Rd.\nPortsmouth, NH 03801\nUSA\nPhone:  +1 603 436 8634\nEmail:  ietfdbh@comcast.net\n\n\n\nLes Bell\nPostal: Hemel Hempstead, Herts. HP2 7YU\nUK\nEmail: elbell@ntlworld.com\n\nAndrew Smith\nPostal: Beijing Harbour Networks\nJiuling Building\n21 North Xisanhuan Ave.\nBeijing, 100089\nPRC\nFax: +1 415 345 1827\nEmail: ah_smith@acm.org\n\nPaul Langille\nPostal: Newbridge Networks\n5 Corporate Drive\nAndover, MA 01810\nUSA\nPhone: +1 978 691 4665\nEmail: langille@newbridge.com\n\nAnil Rijhsinghani\nPostal: Accton Technology Corporation\n5 Mount Royal Ave\nMarlboro, MA 01752\nUSA\nPhone:\nEmail: anil@accton.com\n\nKeith McCloghrie\nPostal: Cisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA 95134-1706\nUSA\nPhone: +1 408 526 5260\nEmail: kzm@cisco.com")
if mibBuilder.loadTexts: qBridgeMIB.setDescription("The VLAN Bridge MIB module for managing Virtual Bridged\nLocal Area Networks, as defined by IEEE 802.1Q-2003,\nincluding Restricted Vlan Registration defined by\nIEEE 802.1u-2001 and Vlan Classification defined by\nIEEE 802.1v-2001.\n\nCopyright (C) The Internet Society (2006).  This version of\nthis MIB module is part of RFC 4363; See the RFC itself for\nfull legal notices.")
qBridgeMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1))
dot1qBase = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 1))
dot1qVlanVersionNumber = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,)).subtype(namedValues=namedval.NamedValues(("version1", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanVersionNumber.setDescription("The version number of IEEE 802.1Q that this device\nsupports.")
dot1qMaxVlanId = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 2), VlanId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qMaxVlanId.setDescription("The maximum IEEE 802.1Q VLAN-ID that this device\n\n\n\nsupports.")
dot1qMaxSupportedVlans = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qMaxSupportedVlans.setDescription("The maximum number of IEEE 802.1Q VLANs that this\ndevice supports.")
dot1qNumVlans = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qNumVlans.setDescription("The current number of IEEE 802.1Q VLANs that are\nconfigured in this device.")
dot1qGvrpStatus = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 1, 5), EnabledStatus().clone('enabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qGvrpStatus.setDescription("The administrative status requested by management for\nGVRP.  The value enabled(1) indicates that GVRP should\nbe enabled on this device, on all ports for which it has\nnot been specifically disabled.  When disabled(2), GVRP\nis disabled on all ports, and all GVRP packets will be\nforwarded transparently.  This object affects all GVRP\nApplicant and Registrar state machines.  A transition\nfrom disabled(2) to enabled(1) will cause a reset of all\nGVRP state machines on all ports.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qTp = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 2))
dot1qFdbTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1))
if mibBuilder.loadTexts: dot1qFdbTable.setDescription("A table that contains configuration and control\ninformation for each Filtering Database currently\noperating on this device.  Entries in this table appear\nautomatically when VLANs are assigned FDB IDs in the\ndot1qVlanCurrentTable.")
dot1qFdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qFdbId"))
if mibBuilder.loadTexts: dot1qFdbEntry.setDescription("Information about a specific Filtering Database.")
dot1qFdbId = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1, 1, 1), Unsigned32()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qFdbId.setDescription("The identity of this Filtering Database.")
dot1qFdbDynamicCount = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qFdbDynamicCount.setDescription("The current number of dynamic entries in this\nFiltering Database.")
dot1qTpFdbTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2))
if mibBuilder.loadTexts: dot1qTpFdbTable.setDescription("A table that contains information about unicast entries\nfor which the device has forwarding and/or filtering\ninformation.  This information is used by the\ntransparent bridging function in determining how to\npropagate a received frame.")
dot1qTpFdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qFdbId"), (0, "Q-BRIDGE-MIB", "dot1qTpFdbAddress"))
if mibBuilder.loadTexts: dot1qTpFdbEntry.setDescription("Information about a specific unicast MAC address for\nwhich the device has some forwarding and/or filtering\ninformation.")
dot1qTpFdbAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qTpFdbAddress.setDescription("A unicast MAC address for which the device has\nforwarding and/or filtering information.")
dot1qTpFdbPort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpFdbPort.setDescription("Either the value '0', or the port number of the port on\nwhich a frame having a source address equal to the value\nof the corresponding instance of dot1qTpFdbAddress has\nbeen seen.  A value of '0' indicates that the port\nnumber has not been learned but that the device does\nhave some forwarding/filtering information about this\naddress (e.g., in the dot1qStaticUnicastTable).\nImplementors are encouraged to assign the port value to\nthis object whenever it is learned, even for addresses\nfor which the corresponding value of dot1qTpFdbStatus is\nnot learned(3).")
dot1qTpFdbStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,2,1,5,3,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("invalid", 2), ("learned", 3), ("self", 4), ("mgmt", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpFdbStatus.setDescription("The status of this entry.  The meanings of the values\nare:\n    other(1) - none of the following.  This may include\n        the case where some other MIB object (not the\n        corresponding instance of dot1qTpFdbPort, nor an\n        entry in the dot1qStaticUnicastTable) is being\n        used to determine if and how frames addressed to\n        the value of the corresponding instance of\n        dot1qTpFdbAddress are being forwarded.\n    invalid(2) - this entry is no longer valid (e.g., it\n\n\n\n        was learned but has since aged out), but has not\n        yet been flushed from the table.\n    learned(3) - the value of the corresponding instance\n        of dot1qTpFdbPort was learned and is being used.\n    self(4) - the value of the corresponding instance of\n        dot1qTpFdbAddress represents one of the device's\n        addresses.  The corresponding instance of\n        dot1qTpFdbPort indicates which of the device's\n        ports has this address.\n    mgmt(5) - the value of the corresponding instance of\n        dot1qTpFdbAddress is also the value of an\n        existing instance of dot1qStaticAddress.")
dot1qTpGroupTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3))
if mibBuilder.loadTexts: dot1qTpGroupTable.setDescription("A table containing filtering information for VLANs\nconfigured into the bridge by (local or network)\nmanagement, or learned dynamically, specifying the set of\nports to which frames received on a VLAN for this FDB\nand containing a specific Group destination address are\nallowed to be forwarded.")
dot1qTpGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"), (0, "Q-BRIDGE-MIB", "dot1qTpGroupAddress"))
if mibBuilder.loadTexts: dot1qTpGroupEntry.setDescription("Filtering information configured into the bridge by\nmanagement, or learned dynamically, specifying the set of\nports to which frames received on a VLAN and containing\na specific Group destination address are allowed to be\nforwarded.  The subset of these ports learned dynamically\nis also provided.")
dot1qTpGroupAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qTpGroupAddress.setDescription("The destination Group MAC address in a frame to which\nthis entry's filtering information applies.")
dot1qTpGroupEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1, 2), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpGroupEgressPorts.setDescription("The complete set of ports, in this VLAN, to which\nframes destined for this Group MAC address are currently\nbeing explicitly forwarded.  This does not include ports\nfor which this address is only implicitly forwarded, in\nthe dot1qForwardAllPorts list.")
dot1qTpGroupLearnt = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 3, 1, 3), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpGroupLearnt.setDescription("The subset of ports in dot1qTpGroupEgressPorts that\nwere learned by GMRP or some other dynamic mechanism, in\nthis Filtering database.")
dot1qForwardAllTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4))
if mibBuilder.loadTexts: dot1qForwardAllTable.setDescription("A table containing forwarding information for each\n\n\n\nVLAN, specifying the set of ports to which forwarding of\nall multicasts applies, configured statically by\nmanagement or dynamically by GMRP.  An entry appears in\nthis table for all VLANs that are currently\ninstantiated.")
dot1qForwardAllEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qForwardAllEntry.setDescription("Forwarding information for a VLAN, specifying the set\nof ports to which all multicasts should be forwarded,\nconfigured statically by management or dynamically by\nGMRP.")
dot1qForwardAllPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1, 1), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qForwardAllPorts.setDescription("The complete set of ports in this VLAN to which all\nmulticast group-addressed frames are to be forwarded.\nThis includes ports for which this need has been\ndetermined dynamically by GMRP, or configured statically\nby management.")
dot1qForwardAllStaticPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1, 2), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardAllStaticPorts.setDescription("The set of ports configured by management in this VLAN\nto which all multicast group-addressed frames are to be\nforwarded.  Ports entered in this list will also appear\nin the complete set shown by dot1qForwardAllPorts.  This\nvalue will be restored after the device is reset.  This\nonly applies to ports that are members of the VLAN,\ndefined by dot1qVlanCurrentEgressPorts.  A port may not\nbe added in this set if it is already a member of the\nset of ports in dot1qForwardAllForbiddenPorts.  The\ndefault value is a string of ones of appropriate length,\nto indicate the standard behaviour of using basic\nfiltering services, i.e., forward all multicasts to all\nports.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qForwardAllForbiddenPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 4, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardAllForbiddenPorts.setDescription("The set of ports configured by management in this VLAN\nfor which the Service Requirement attribute Forward All\nMulticast Groups may not be dynamically registered by\nGMRP.  This value will be restored after the device is\nreset.  A port may not be added in this set if it is\nalready a member of the set of ports in\ndot1qForwardAllStaticPorts.  The default value is a\nstring of zeros of appropriate length.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qForwardUnregisteredTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5))
if mibBuilder.loadTexts: dot1qForwardUnregisteredTable.setDescription("A table containing forwarding information for each\nVLAN, specifying the set of ports to which forwarding of\nmulticast group-addressed frames for which no\nmore specific forwarding information applies.  This is\nconfigured statically by management and determined\ndynamically by GMRP.  An entry appears in this table for\nall VLANs that are currently instantiated.")
dot1qForwardUnregisteredEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qForwardUnregisteredEntry.setDescription("Forwarding information for a VLAN, specifying the set\nof ports to which all multicasts for which there is no\nmore specific forwarding information shall be forwarded.\nThis is configured statically by management or\ndynamically by GMRP.")
dot1qForwardUnregisteredPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1, 1), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qForwardUnregisteredPorts.setDescription("The complete set of ports in this VLAN to which\nmulticast group-addressed frames for which there is no\nmore specific forwarding information will be forwarded.\nThis includes ports for which this need has been\ndetermined dynamically by GMRP, or configured statically\nby management.")
dot1qForwardUnregisteredStaticPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1, 2), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardUnregisteredStaticPorts.setDescription("The set of ports configured by management, in this\nVLAN, to which multicast group-addressed frames for\nwhich there is no more specific forwarding information\n\n\n\nare to be forwarded.  Ports entered in this list will\nalso appear in the complete set shown by\ndot1qForwardUnregisteredPorts.  This value will be\nrestored after the device is reset.  A port may not be\nadded in this set if it is already a member of the set\nof ports in dot1qForwardUnregisteredForbiddenPorts.  The\ndefault value is a string of zeros of appropriate\nlength, although this has no effect with the default\nvalue of dot1qForwardAllStaticPorts.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qForwardUnregisteredForbiddenPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 2, 5, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qForwardUnregisteredForbiddenPorts.setDescription("The set of ports configured by management in this VLAN\nfor which the Service Requirement attribute Forward\nUnregistered Multicast Groups may not be dynamically\nregistered by GMRP.  This value will be restored after\nthe device is reset.  A port may not be added in this\nset if it is already a member of the set of ports in\ndot1qForwardUnregisteredStaticPorts.  The default value\nis a string of zeros of appropriate length.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qStatic = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 3))
dot1qStaticUnicastTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1))
if mibBuilder.loadTexts: dot1qStaticUnicastTable.setDescription("A table containing filtering information for Unicast\nMAC addresses for each Filtering Database, configured\ninto the device by (local or network) management\nspecifying the set of ports to which frames received\nfrom specific ports and containing specific unicast\ndestination addresses are allowed to be forwarded.  A\nvalue of zero in this table (as the port number from\n\n\n\nwhich frames with a specific destination address are\nreceived) is used to specify all ports for which there\nis no specific entry in this table for that particular\ndestination address.  Entries are valid for unicast\naddresses only.")
dot1qStaticUnicastEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qFdbId"), (0, "Q-BRIDGE-MIB", "dot1qStaticUnicastAddress"), (0, "Q-BRIDGE-MIB", "dot1qStaticUnicastReceivePort"))
if mibBuilder.loadTexts: dot1qStaticUnicastEntry.setDescription("Filtering information configured into the device by\n(local or network) management specifying the set of\nports to which frames received from a specific port and\ncontaining a specific unicast destination address are\nallowed to be forwarded.")
dot1qStaticUnicastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qStaticUnicastAddress.setDescription("The destination MAC address in a frame to which this\nentry's filtering information applies.  This object must\ntake the value of a unicast address.")
dot1qStaticUnicastReceivePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qStaticUnicastReceivePort.setDescription("Either the value '0' or the port number of the port\nfrom which a frame must be received in order for this\nentry's filtering information to apply.  A value of zero\nindicates that this entry applies on all ports of the\ndevice for which there is no other applicable entry.")
dot1qStaticUnicastAllowedToGoTo = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticUnicastAllowedToGoTo.setDescription("The set of ports for which a frame with a specific\nunicast address will be flooded in the event that it\nhas not been learned.  It also specifies the set of\nports on which a specific unicast address may be dynamically\nlearned.  The dot1qTpFdbTable will have an equivalent\nentry with a dot1qTpFdbPort value of '0' until this\naddress has been learned, at which point it will be updated\nwith the port the address has been seen on.  This only\napplies to ports that are members of the VLAN, defined\nby dot1qVlanCurrentEgressPorts.  The default value of\nthis object is a string of ones of appropriate length.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qStaticUnicastStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,5,1,4,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("invalid", 2), ("permanent", 3), ("deleteOnReset", 4), ("deleteOnTimeout", 5), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticUnicastStatus.setDescription("This object indicates the status of this entry.\nother(1) - this entry is currently in use, but\n\n\n\n    the conditions under which it will remain\n    so differ from the following values.\ninvalid(2) - writing this value to the object\n    removes the corresponding entry.\npermanent(3) - this entry is currently in use\n    and will remain so after the next reset of\n    the bridge.\ndeleteOnReset(4) - this entry is currently in\n    use and will remain so until the next\n    reset of the bridge.\ndeleteOnTimeout(5) - this entry is currently in\n    use and will remain so until it is aged out.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qStaticMulticastTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2))
if mibBuilder.loadTexts: dot1qStaticMulticastTable.setDescription("A table containing filtering information for Multicast\nand Broadcast MAC addresses for each VLAN, configured\ninto the device by (local or network) management\nspecifying the set of ports to which frames received\nfrom specific ports and containing specific Multicast\nand Broadcast destination addresses are allowed to be\nforwarded.  A value of zero in this table (as the port\nnumber from which frames with a specific destination\naddress are received) is used to specify all ports for\nwhich there is no specific entry in this table for that\nparticular destination address.  Entries are valid for\nMulticast and Broadcast addresses only.")
dot1qStaticMulticastEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"), (0, "Q-BRIDGE-MIB", "dot1qStaticMulticastAddress"), (0, "Q-BRIDGE-MIB", "dot1qStaticMulticastReceivePort"))
if mibBuilder.loadTexts: dot1qStaticMulticastEntry.setDescription("Filtering information configured into the device by\n(local or network) management specifying the set of\nports to which frames received from this specific port\n\n\n\nfor this VLAN and containing this Multicast or Broadcast\ndestination address are allowed to be forwarded.")
dot1qStaticMulticastAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 1), MacAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qStaticMulticastAddress.setDescription("The destination MAC address in a frame to which this\nentry's filtering information applies.  This object must\ntake the value of a Multicast or Broadcast address.")
dot1qStaticMulticastReceivePort = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qStaticMulticastReceivePort.setDescription("Either the value '0' or the port number of the port\nfrom which a frame must be received in order for this\nentry's filtering information to apply.  A value of zero\nindicates that this entry applies on all ports of the\ndevice for which there is no other applicable entry.")
dot1qStaticMulticastStaticEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 3), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticMulticastStaticEgressPorts.setDescription("The set of ports to which frames received from a\nspecific port and destined for a specific Multicast or\nBroadcast MAC address must be forwarded, regardless of\nany dynamic information, e.g., from GMRP.  A port may not\nbe added in this set if it is already a member of the\nset of ports in dot1qStaticMulticastForbiddenEgressPorts.\nThe default value of this object is a string of ones of\nappropriate length.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qStaticMulticastForbiddenEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 4), PortList()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticMulticastForbiddenEgressPorts.setDescription("The set of ports to which frames received from a\nspecific port and destined for a specific Multicast or\nBroadcast MAC address must not be forwarded, regardless\nof any dynamic information, e.g., from GMRP.  A port may\nnot be added in this set if it is already a member of the\nset of ports in dot1qStaticMulticastStaticEgressPorts.\nThe default value of this object is a string of zeros of\nappropriate length.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qStaticMulticastStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 3, 2, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,3,5,1,4,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("invalid", 2), ("permanent", 3), ("deleteOnReset", 4), ("deleteOnTimeout", 5), )).clone(3)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qStaticMulticastStatus.setDescription("This object indicates the status of this entry.\nother(1) - this entry is currently in use, but\n    the conditions under which it will remain\n    so differ from the following values.\n\n\n\ninvalid(2) - writing this value to the object\n    removes the corresponding entry.\npermanent(3) - this entry is currently in use\n    and will remain so after the next reset of\n    the bridge.\ndeleteOnReset(4) - this entry is currently in\n    use and will remain so until the next\n    reset of the bridge.\ndeleteOnTimeout(5) - this entry is currently in\n    use and will remain so until it is aged out.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qVlan = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 4))
dot1qVlanNumDeletes = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanNumDeletes.setDescription("The number of times a VLAN entry has been deleted from\nthe dot1qVlanCurrentTable (for any reason).  If an entry\nis deleted, then inserted, and then deleted, this\ncounter will be incremented by 2.")
dot1qVlanCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2))
if mibBuilder.loadTexts: dot1qVlanCurrentTable.setDescription("A table containing current configuration information\nfor each VLAN currently configured into the device by\n(local or network) management, or dynamically created\nas a result of GVRP requests received.")
dot1qVlanCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanTimeMark"), (0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qVlanCurrentEntry.setDescription("Information for a VLAN configured into the device by\n\n\n\n(local or network) management, or dynamically created\nas a result of GVRP requests received.")
dot1qVlanTimeMark = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 1), TimeFilter()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qVlanTimeMark.setDescription("A TimeFilter for this entry.  See the TimeFilter\ntextual convention to see how this works.")
dot1qVlanIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 2), VlanIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qVlanIndex.setDescription("The VLAN-ID or other identifier referring to this VLAN.")
dot1qVlanFdbId = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanFdbId.setDescription("The Filtering Database used by this VLAN.  This is one\nof the dot1qFdbId values in the dot1qFdbTable.  This\nvalue is allocated automatically by the device whenever\n\n\n\nthe VLAN is created: either dynamically by GVRP, or by\nmanagement, in dot1qVlanStaticTable.  Allocation of this\nvalue follows the learning constraints defined for this\nVLAN in dot1qLearningConstraintsTable.")
dot1qVlanCurrentEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 4), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanCurrentEgressPorts.setDescription("The set of ports that are transmitting traffic for\nthis VLAN as either tagged or untagged frames.")
dot1qVlanCurrentUntaggedPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 5), PortList()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanCurrentUntaggedPorts.setDescription("The set of ports that are transmitting traffic for\nthis VLAN as untagged frames.")
dot1qVlanStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 6), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("permanent", 2), ("dynamicGvrp", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanStatus.setDescription("This object indicates the status of this entry.\nother(1) - this entry is currently in use, but the\n    conditions under which it will remain so differ\n    from the following values.\npermanent(2) - this entry, corresponding to an entry\n    in dot1qVlanStaticTable, is currently in use and\n    will remain so after the next reset of the\n    device.  The port lists for this entry include\n    ports from the equivalent dot1qVlanStaticTable\n    entry and ports learned dynamically.\ndynamicGvrp(3) - this entry is currently in use\n\n\n\n    and will remain so until removed by GVRP.  There\n    is no static entry for this VLAN, and it will be\n    removed when the last port leaves the VLAN.")
dot1qVlanCreationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 2, 1, 7), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qVlanCreationTime.setDescription("The value of sysUpTime when this VLAN was created.")
dot1qVlanStaticTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3))
if mibBuilder.loadTexts: dot1qVlanStaticTable.setDescription("A table containing static configuration information for\neach VLAN configured into the device by (local or\nnetwork) management.  All entries are permanent and will\nbe restored after the device is reset.")
dot1qVlanStaticEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qVlanStaticEntry.setDescription("Static information for a VLAN configured into the\ndevice by (local or network) management.")
dot1qVlanStaticName = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 32))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticName.setDescription("An administratively assigned string, which may be used\nto identify the VLAN.")
dot1qVlanStaticEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 2), PortList()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticEgressPorts.setDescription("The set of ports that are permanently assigned to the\negress list for this VLAN by management.  Changes to a\nbit in this object affect the per-port, per-VLAN\nRegistrar control for Registration Fixed for the\nrelevant GVRP state machine on each port.  A port may\nnot be added in this set if it is already a member of\nthe set of ports in dot1qVlanForbiddenEgressPorts.  The\ndefault value of this object is a string of zeros of\nappropriate length, indicating not fixed.")
dot1qVlanForbiddenEgressPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 3), PortList()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanForbiddenEgressPorts.setDescription("The set of ports that are prohibited by management\nfrom being included in the egress list for this VLAN.\nChanges to this object that cause a port to be included\nor excluded affect the per-port, per-VLAN Registrar\ncontrol for Registration Forbidden for the relevant GVRP\nstate machine on each port.  A port may not be added in\nthis set if it is already a member of the set of ports\nin dot1qVlanStaticEgressPorts.  The default value of\nthis object is a string of zeros of appropriate length,\nexcluding all ports from the forbidden set.")
dot1qVlanStaticUntaggedPorts = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 4), PortList()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticUntaggedPorts.setDescription("The set of ports that should transmit egress packets\nfor this VLAN as untagged.  The default value of this\nobject for the default VLAN (dot1qVlanIndex = 1) is a string\nof appropriate length including all ports.  There is no\nspecified default for other VLANs.  If a device agent cannot\nsupport the set of ports being set, then it will reject the\nset operation with an error.  For example, a\nmanager might attempt to set more than one VLAN to be untagged\non egress where the device does not support this IEEE 802.1Q\noption.")
dot1qVlanStaticRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 3, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qVlanStaticRowStatus.setDescription("This object indicates the status of this entry.")
dot1qNextFreeLocalVlanIndex = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 4), Integer32().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueRangeConstraint(0,0),constraint.ValueRangeConstraint(4096,2147483647),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qNextFreeLocalVlanIndex.setDescription("The next available value for dot1qVlanIndex of a local\nVLAN entry in dot1qVlanStaticTable.  This will report\nvalues >=4096 if a new Local VLAN may be created or else\nthe value 0 if this is not possible.\n\nA row creation operation in this table for an entry with a local\nVlanIndex value may fail if the current value of this object\nis not used as the index.  Even if the value read is used,\nthere is no guarantee that it will still be the valid index\nwhen the create operation is attempted; another manager may\nhave already got in during the intervening time interval.\nIn this case, dot1qNextFreeLocalVlanIndex should be re-read\n\n\n\nand the creation re-tried with the new value.\n\nThis value will automatically change when the current value is\nused to create a new row.")
dot1qPortVlanTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5))
if mibBuilder.loadTexts: dot1qPortVlanTable.setDescription("A table containing per-port control and status\ninformation for VLAN configuration in the device.")
dot1qPortVlanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1))
if mibBuilder.loadTexts: dot1qPortVlanEntry.setDescription("Information controlling VLAN configuration for a port\non the device.  This is indexed by dot1dBasePort.")
dot1qPvid = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 1), VlanIndex().clone('1')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPvid.setDescription("The PVID, the VLAN-ID assigned to untagged frames or\nPriority-Tagged frames received on this port.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qPortAcceptableFrameTypes = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("admitAll", 1), ("admitOnlyVlanTagged", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortAcceptableFrameTypes.setDescription("When this is admitOnlyVlanTagged(2), the device will\ndiscard untagged frames or Priority-Tagged frames\nreceived on this port.  When admitAll(1), untagged\nframes or Priority-Tagged frames received on this port\nwill be accepted and assigned to a VID based on the\nPVID and VID Set for this port.\n\nThis control does not affect VLAN-independent Bridge\nProtocol Data Unit (BPDU) frames, such as GVRP and\nSpanning Tree Protocol (STP).  It does affect VLAN-\ndependent BPDU frames, such as GMRP.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qPortIngressFiltering = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 3), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortIngressFiltering.setDescription("When this is true(1), the device will discard incoming\nframes for VLANs that do not include this Port in its\n\n\n\nMember set.  When false(2), the port will accept all\nincoming frames.\n\nThis control does not affect VLAN-independent BPDU\nframes, such as GVRP and STP.  It does affect VLAN-\ndependent BPDU frames, such as GMRP.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qPortGvrpStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 4), EnabledStatus().clone('enabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortGvrpStatus.setDescription("The state of GVRP operation on this port.  The value\nenabled(1) indicates that GVRP is enabled on this port,\nas long as dot1qGvrpStatus is also enabled for this\ndevice.  When disabled(2) but dot1qGvrpStatus is still\nenabled for the device, GVRP is disabled on this port:\nany GVRP packets received will be silently discarded, and\nno GVRP registrations will be propagated from other\nports.  This object affects all GVRP Applicant and\nRegistrar state machines on this port.  A transition\nfrom disabled(2) to enabled(1) will cause a reset of all\nGVRP state machines on this port.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qPortGvrpFailedRegistrations = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qPortGvrpFailedRegistrations.setDescription("The total number of failed GVRP registrations, for any\nreason, on this port.")
dot1qPortGvrpLastPduOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 6), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qPortGvrpLastPduOrigin.setDescription("The Source MAC Address of the last GVRP message\nreceived on this port.")
dot1qPortRestrictedVlanRegistration = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 5, 1, 7), TruthValue().clone('false')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qPortRestrictedVlanRegistration.setDescription("The state of Restricted VLAN Registration on this port.\nIf the value of this control is true(1), then creation\nof a new dynamic VLAN entry is permitted only if there\nis a Static VLAN Registration Entry for the VLAN concerned,\nin which the Registrar Administrative Control value for\nthis port is Normal Registration.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qPortVlanStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6))
if mibBuilder.loadTexts: dot1qPortVlanStatisticsTable.setDescription("A table containing per-port, per-VLAN statistics for\ntraffic received.  Separate objects are provided for both the\nmost-significant and least-significant bits of statistics\ncounters for ports that are associated with this transparent\nbridge.  The most-significant bit objects are only required on\nhigh-capacity interfaces, as defined in the conformance clauses\nfor these objects.  This mechanism is provided as a way to read\n64-bit counters for agents that support only SNMPv1.\n\nNote that the reporting of most-significant and least-\nsignificant counter bits separately runs the risk of missing\nan overflow of the lower bits in the interval between sampling.\nThe manager must be aware of this possibility, even within the\nsame varbindlist, when interpreting the results of a request or\n\n\n\nasynchronous notification.")
dot1qPortVlanStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"), (0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qPortVlanStatisticsEntry.setDescription("Traffic statistics for a VLAN on an interface.")
dot1qTpVlanPortInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInFrames.setDescription("The number of valid frames received by this port from\nits segment that were classified as belonging to this\nVLAN.  Note that a frame received on this port is\ncounted by this object if and only if it is for a\nprotocol being processed by the local forwarding process\nfor this VLAN.  This object includes received bridge\nmanagement frames classified as belonging to this VLAN\n(e.g., GMRP, but not GVRP or STP.")
dot1qTpVlanPortOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortOutFrames.setDescription("The number of valid frames transmitted by this port to\nits segment from the local forwarding process for this\nVLAN.  This includes bridge management frames originated\nby this device that are classified as belonging to this\nVLAN (e.g., GMRP, but not GVRP or STP).")
dot1qTpVlanPortInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInDiscards.setDescription("The number of valid frames received by this port from\nits segment that were classified as belonging to this\nVLAN and that were discarded due to VLAN-related reasons.\nSpecifically, the IEEE 802.1Q counters for Discard\nInbound and Discard on Ingress Filtering.")
dot1qTpVlanPortInOverflowFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowFrames.setDescription("The number of times the associated\ndot1qTpVlanPortInFrames counter has overflowed.")
dot1qTpVlanPortOutOverflowFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortOutOverflowFrames.setDescription("The number of times the associated\ndot1qTpVlanPortOutFrames counter has overflowed.")
dot1qTpVlanPortInOverflowDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortInOverflowDiscards.setDescription("The number of times the associated\ndot1qTpVlanPortInDiscards counter has overflowed.")
dot1qPortVlanHCStatisticsTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7))
if mibBuilder.loadTexts: dot1qPortVlanHCStatisticsTable.setDescription("A table containing per-port, per-VLAN statistics for\ntraffic on high-capacity interfaces.")
dot1qPortVlanHCStatisticsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"), (0, "Q-BRIDGE-MIB", "dot1qVlanIndex"))
if mibBuilder.loadTexts: dot1qPortVlanHCStatisticsEntry.setDescription("Traffic statistics for a VLAN on a high-capacity\ninterface.")
dot1qTpVlanPortHCInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortHCInFrames.setDescription("The number of valid frames received by this port from\nits segment that were classified as belonging to this\nVLAN.  Note that a frame received on this port is\ncounted by this object if and only if it is for a\n\n\n\nprotocol being processed by the local forwarding process\nfor this VLAN.  This object includes received bridge\nmanagement frames classified as belonging to this VLAN\n(e.g., GMRP, but not GVRP or STP).")
dot1qTpVlanPortHCOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortHCOutFrames.setDescription("The number of valid frames transmitted by this port to\nits segment from the local forwarding process for this\nVLAN.  This includes bridge management frames originated\nby this device that are classified as belonging to this\nVLAN (e.g., GMRP, but not GVRP or STP).")
dot1qTpVlanPortHCInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 7, 1, 3), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dot1qTpVlanPortHCInDiscards.setDescription("The number of valid frames received by this port from\nits segment that were classified as belonging to this\nVLAN and that were discarded due to VLAN-related reasons.\nSpecifically, the IEEE 802.1Q counters for Discard\nInbound and Discard on Ingress Filtering.")
dot1qLearningConstraintsTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8))
if mibBuilder.loadTexts: dot1qLearningConstraintsTable.setDescription("A table containing learning constraints for sets of\nShared and Independent VLANs.")
dot1qLearningConstraintsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1qConstraintVlan"), (0, "Q-BRIDGE-MIB", "dot1qConstraintSet"))
if mibBuilder.loadTexts: dot1qLearningConstraintsEntry.setDescription("A learning constraint defined for a VLAN.")
dot1qConstraintVlan = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 1), VlanIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qConstraintVlan.setDescription("The index of the row in dot1qVlanCurrentTable for the\nVLAN constrained by this entry.")
dot1qConstraintSet = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1qConstraintSet.setDescription("The identity of the constraint set to which\ndot1qConstraintVlan belongs.  These values may be chosen\nby the management station.")
dot1qConstraintType = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("independent", 1), ("shared", 2), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qConstraintType.setDescription("The type of constraint this entry defines.\nindependent(1) - the VLAN, dot1qConstraintVlan,\n    uses a filtering database independent from all\n    other VLANs in the same set, defined by\n    dot1qConstraintSet.\nshared(2) - the VLAN, dot1qConstraintVlan, shares\n    the same filtering database as all other VLANs\n    in the same set, defined by dot1qConstraintSet.")
dot1qConstraintStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 8, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1qConstraintStatus.setDescription("The status of this entry.")
dot1qConstraintSetDefault = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 9), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qConstraintSetDefault.setDescription("The identity of the constraint set to which a VLAN\nbelongs, if there is not an explicit entry for that VLAN\nin dot1qLearningConstraintsTable.\n\nThe value of this object MUST be retained across\nreinitializations of the management system.")
dot1qConstraintTypeDefault = MibScalar((1, 3, 6, 1, 2, 1, 17, 7, 1, 4, 10), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("independent", 1), ("shared", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dot1qConstraintTypeDefault.setDescription("The type of constraint set to which a VLAN belongs, if\nthere is not an explicit entry for that VLAN in\ndot1qLearningConstraintsTable.  The types are as defined\nfor dot1qConstraintType.\n\nThe value of this object MUST be retained across\n\n\n\nreinitializations of the management system.")
dot1vProtocol = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 1, 5))
dot1vProtocolGroupTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 1))
if mibBuilder.loadTexts: dot1vProtocolGroupTable.setDescription("A table that contains mappings from Protocol\nTemplates to Protocol Group Identifiers used for\nPort-and-Protocol-based VLAN Classification.")
dot1vProtocolGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 1, 1)).setIndexNames((0, "Q-BRIDGE-MIB", "dot1vProtocolTemplateFrameType"), (0, "Q-BRIDGE-MIB", "dot1vProtocolTemplateProtocolValue"))
if mibBuilder.loadTexts: dot1vProtocolGroupEntry.setDescription("A mapping from a Protocol Template to a Protocol\nGroup Identifier.")
dot1vProtocolTemplateFrameType = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(4,3,2,5,1,)).subtype(namedValues=namedval.NamedValues(("ethernet", 1), ("rfc1042", 2), ("snap8021H", 3), ("snapOther", 4), ("llcOther", 5), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1vProtocolTemplateFrameType.setDescription("The data-link encapsulation format or the\n'detagged_frame_type' in a Protocol Template.")
dot1vProtocolTemplateProtocolValue = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 1, 1, 2), OctetString().subtype(subtypeSpec=constraint.ConstraintsUnion(constraint.ValueSizeConstraint(2,2),constraint.ValueSizeConstraint(5,5),))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1vProtocolTemplateProtocolValue.setDescription("The identification of the protocol above the data-link\nlayer in a Protocol Template.  Depending on the\nframe type, the octet string will have one of the\nfollowing values:\n\nFor 'ethernet', 'rfc1042' and 'snap8021H',\n    this is the 16-bit (2-octet) IEEE 802.3 Type Field.\nFor 'snapOther',\n    this is the 40-bit (5-octet) PID.\nFor 'llcOther',\n    this is the 2-octet IEEE 802.2 Link Service Access\n    Point (LSAP) pair: first octet for Destination Service\n    Access Point (DSAP) and second octet for Source Service\n    Access Point (SSAP).")
dot1vProtocolGroupId = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1vProtocolGroupId.setDescription("Represents a group of protocols that are associated\ntogether when assigning a VID to a frame.")
dot1vProtocolGroupRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 1, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1vProtocolGroupRowStatus.setDescription("This object indicates the status of this entry.")
dot1vProtocolPortTable = MibTable((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 2))
if mibBuilder.loadTexts: dot1vProtocolPortTable.setDescription("A table that contains VID sets used for\nPort-and-Protocol-based VLAN Classification.")
dot1vProtocolPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 2, 1)).setIndexNames((0, "BRIDGE-MIB", "dot1dBasePort"), (0, "Q-BRIDGE-MIB", "dot1vProtocolPortGroupId"))
if mibBuilder.loadTexts: dot1vProtocolPortEntry.setDescription("A VID set for a port.")
dot1vProtocolPortGroupId = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dot1vProtocolPortGroupId.setDescription("Designates a group of protocols in the Protocol\nGroup Database.")
dot1vProtocolPortGroupVid = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4094))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1vProtocolPortGroupVid.setDescription("The VID associated with a group of protocols for\neach port.")
dot1vProtocolPortRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 17, 7, 1, 5, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dot1vProtocolPortRowStatus.setDescription("This object indicates the status of this entry.")
qBridgeConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 2))
qBridgeGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 2, 1))
qBridgeCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 17, 7, 2, 2))

# Augmentions
dot1dBasePortEntry, = mibBuilder.importSymbols("BRIDGE-MIB", "dot1dBasePortEntry")
dot1dBasePortEntry.registerAugmentions(("Q-BRIDGE-MIB", "dot1qPortVlanEntry"))
dot1qPortVlanEntry.setIndexNames(*dot1dBasePortEntry.getIndexNames())

# Groups

qBridgeBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 1)).setObjects(("Q-BRIDGE-MIB", "dot1qNumVlans"), ("Q-BRIDGE-MIB", "dot1qVlanVersionNumber"), ("Q-BRIDGE-MIB", "dot1qGvrpStatus"), ("Q-BRIDGE-MIB", "dot1qMaxVlanId"), ("Q-BRIDGE-MIB", "dot1qMaxSupportedVlans"), )
if mibBuilder.loadTexts: qBridgeBaseGroup.setDescription("A collection of objects providing device-level control\nand status information for the Virtual LAN bridge\nservices.")
qBridgeFdbUnicastGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 2)).setObjects(("Q-BRIDGE-MIB", "dot1qFdbDynamicCount"), ("Q-BRIDGE-MIB", "dot1qTpFdbStatus"), ("Q-BRIDGE-MIB", "dot1qTpFdbPort"), )
if mibBuilder.loadTexts: qBridgeFdbUnicastGroup.setDescription("A collection of objects providing information about all\nunicast addresses, learned dynamically or statically\nconfigured by management, in each Filtering Database.")
qBridgeFdbMulticastGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 3)).setObjects(("Q-BRIDGE-MIB", "dot1qTpGroupEgressPorts"), ("Q-BRIDGE-MIB", "dot1qTpGroupLearnt"), )
if mibBuilder.loadTexts: qBridgeFdbMulticastGroup.setDescription("A collection of objects providing information about all\nmulticast addresses, learned dynamically or statically\nconfigured by management, in each Filtering Database.")
qBridgeServiceRequirementsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 4)).setObjects(("Q-BRIDGE-MIB", "dot1qForwardUnregisteredStaticPorts"), ("Q-BRIDGE-MIB", "dot1qForwardAllForbiddenPorts"), ("Q-BRIDGE-MIB", "dot1qForwardUnregisteredForbiddenPorts"), ("Q-BRIDGE-MIB", "dot1qForwardUnregisteredPorts"), ("Q-BRIDGE-MIB", "dot1qForwardAllStaticPorts"), ("Q-BRIDGE-MIB", "dot1qForwardAllPorts"), )
if mibBuilder.loadTexts: qBridgeServiceRequirementsGroup.setDescription("A collection of objects providing information about\nservice requirements, learned dynamically or statically\nconfigured by management, in each Filtering Database.")
qBridgeFdbStaticGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 5)).setObjects(("Q-BRIDGE-MIB", "dot1qStaticMulticastStatus"), ("Q-BRIDGE-MIB", "dot1qStaticUnicastStatus"), ("Q-BRIDGE-MIB", "dot1qStaticMulticastForbiddenEgressPorts"), ("Q-BRIDGE-MIB", "dot1qStaticUnicastAllowedToGoTo"), ("Q-BRIDGE-MIB", "dot1qStaticMulticastStaticEgressPorts"), )
if mibBuilder.loadTexts: qBridgeFdbStaticGroup.setDescription("A collection of objects providing information about\nunicast and multicast addresses statically configured by\nmanagement, in each Filtering Database or VLAN.")
qBridgeVlanGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 6)).setObjects(("Q-BRIDGE-MIB", "dot1qVlanNumDeletes"), ("Q-BRIDGE-MIB", "dot1qVlanStatus"), ("Q-BRIDGE-MIB", "dot1qVlanCurrentEgressPorts"), ("Q-BRIDGE-MIB", "dot1qVlanFdbId"), ("Q-BRIDGE-MIB", "dot1qVlanCreationTime"), ("Q-BRIDGE-MIB", "dot1qVlanCurrentUntaggedPorts"), )
if mibBuilder.loadTexts: qBridgeVlanGroup.setDescription("A collection of objects providing information about\nall VLANs currently configured on this device.")
qBridgeVlanStaticGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 7)).setObjects(("Q-BRIDGE-MIB", "dot1qVlanStaticName"), ("Q-BRIDGE-MIB", "dot1qNextFreeLocalVlanIndex"), ("Q-BRIDGE-MIB", "dot1qVlanForbiddenEgressPorts"), ("Q-BRIDGE-MIB", "dot1qVlanStaticUntaggedPorts"), ("Q-BRIDGE-MIB", "dot1qVlanStaticEgressPorts"), ("Q-BRIDGE-MIB", "dot1qVlanStaticRowStatus"), )
if mibBuilder.loadTexts: qBridgeVlanStaticGroup.setDescription("A collection of objects providing information about\nVLANs statically configured by management.")
qBridgePortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 8)).setObjects(("Q-BRIDGE-MIB", "dot1qPortAcceptableFrameTypes"), ("Q-BRIDGE-MIB", "dot1qPortGvrpStatus"), ("Q-BRIDGE-MIB", "dot1qPortIngressFiltering"), ("Q-BRIDGE-MIB", "dot1qPortGvrpLastPduOrigin"), ("Q-BRIDGE-MIB", "dot1qPvid"), ("Q-BRIDGE-MIB", "dot1qPortGvrpFailedRegistrations"), )
if mibBuilder.loadTexts: qBridgePortGroup.setDescription("A collection of objects providing port-level VLAN\ncontrol and status information for all ports.")
qBridgeVlanStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 9)).setObjects(("Q-BRIDGE-MIB", "dot1qTpVlanPortOutFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortInDiscards"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortInFrames"), )
if mibBuilder.loadTexts: qBridgeVlanStatisticsGroup.setDescription("A collection of objects providing per-port packet\nstatistics for all VLANs currently configured on this\ndevice.")
qBridgeVlanStatisticsOverflowGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 10)).setObjects(("Q-BRIDGE-MIB", "dot1qTpVlanPortOutOverflowFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortInOverflowDiscards"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortInOverflowFrames"), )
if mibBuilder.loadTexts: qBridgeVlanStatisticsOverflowGroup.setDescription("A collection of objects providing overflow counters for\nper-port packet statistics for all VLANs currently configured\non this device for high-capacity interfaces, defined as those\nthat have the value of the corresponding instance of\nifSpeed greater than 650,000,000 bits/second.")
qBridgeVlanHCStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 11)).setObjects(("Q-BRIDGE-MIB", "dot1qTpVlanPortHCInDiscards"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortHCInFrames"), ("Q-BRIDGE-MIB", "dot1qTpVlanPortHCOutFrames"), )
if mibBuilder.loadTexts: qBridgeVlanHCStatisticsGroup.setDescription("A collection of objects providing per-port packet\nstatistics for all VLANs currently configured on this\ndevice for high-capacity interfaces, defined as those\nthat have the value of the corresponding instance of\nifSpeed greater than 650,000,000 bits/second.")
qBridgeLearningConstraintsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 12)).setObjects(("Q-BRIDGE-MIB", "dot1qConstraintType"), ("Q-BRIDGE-MIB", "dot1qConstraintStatus"), )
if mibBuilder.loadTexts: qBridgeLearningConstraintsGroup.setDescription("A collection of objects defining the Filtering Database\nconstraints all VLANs have with each other.")
qBridgeLearningConstraintDefaultGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 13)).setObjects(("Q-BRIDGE-MIB", "dot1qConstraintSetDefault"), ("Q-BRIDGE-MIB", "dot1qConstraintTypeDefault"), )
if mibBuilder.loadTexts: qBridgeLearningConstraintDefaultGroup.setDescription("A collection of objects defining the default Filtering\nDatabase constraints for VLANs that have no specific\nconstraints defined.")
qBridgeClassificationDeviceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 14)).setObjects(("Q-BRIDGE-MIB", "dot1vProtocolGroupRowStatus"), ("Q-BRIDGE-MIB", "dot1vProtocolGroupId"), )
if mibBuilder.loadTexts: qBridgeClassificationDeviceGroup.setDescription("VLAN classification information for the bridge.")
qBridgeClassificationPortGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 15)).setObjects(("Q-BRIDGE-MIB", "dot1vProtocolPortGroupVid"), ("Q-BRIDGE-MIB", "dot1vProtocolPortRowStatus"), )
if mibBuilder.loadTexts: qBridgeClassificationPortGroup.setDescription("VLAN classification information for individual ports.")
qBridgePortGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 17, 7, 2, 1, 16)).setObjects(("Q-BRIDGE-MIB", "dot1qPortAcceptableFrameTypes"), ("Q-BRIDGE-MIB", "dot1qPortGvrpStatus"), ("Q-BRIDGE-MIB", "dot1qPortIngressFiltering"), ("Q-BRIDGE-MIB", "dot1qPortGvrpLastPduOrigin"), ("Q-BRIDGE-MIB", "dot1qPortRestrictedVlanRegistration"), ("Q-BRIDGE-MIB", "dot1qPvid"), ("Q-BRIDGE-MIB", "dot1qPortGvrpFailedRegistrations"), )
if mibBuilder.loadTexts: qBridgePortGroup2.setDescription("A collection of objects providing port-level VLAN\ncontrol and status information for all ports.")

# Compliances

qBridgeCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 7, 2, 2, 1)).setObjects(("Q-BRIDGE-MIB", "qBridgeFdbUnicastGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbStaticGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbMulticastGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStatisticsOverflowGroup"), ("Q-BRIDGE-MIB", "qBridgePortGroup"), ("Q-BRIDGE-MIB", "qBridgeBaseGroup"), ("Q-BRIDGE-MIB", "qBridgeServiceRequirementsGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStaticGroup"), ("Q-BRIDGE-MIB", "qBridgeLearningConstraintDefaultGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanGroup"), ("Q-BRIDGE-MIB", "qBridgeLearningConstraintsGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanHCStatisticsGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStatisticsGroup"), )
if mibBuilder.loadTexts: qBridgeCompliance.setDescription("The compliance statement for device support of Virtual\nLAN Bridge services.\n\nRFC2674 was silent about the expected persistence of the\nread-write objects in this MIB module.  Applications MUST\nNOT assume that the values of the read-write objects are\npersistent across reinitializations of the management\nsystem and MUST NOT assume that the values are not\npersistent across reinitializations of the management\nsystem.")
qBridgeCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 17, 7, 2, 2, 2)).setObjects(("Q-BRIDGE-MIB", "qBridgeFdbUnicastGroup"), ("Q-BRIDGE-MIB", "qBridgeClassificationPortGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbStaticGroup"), ("Q-BRIDGE-MIB", "qBridgeFdbMulticastGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStatisticsOverflowGroup"), ("Q-BRIDGE-MIB", "qBridgeClassificationDeviceGroup"), ("Q-BRIDGE-MIB", "qBridgeBaseGroup"), ("Q-BRIDGE-MIB", "qBridgeServiceRequirementsGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanStaticGroup"), ("Q-BRIDGE-MIB", "qBridgeLearningConstraintDefaultGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanGroup"), ("Q-BRIDGE-MIB", "qBridgeLearningConstraintsGroup"), ("Q-BRIDGE-MIB", "qBridgeVlanHCStatisticsGroup"), ("Q-BRIDGE-MIB", "qBridgePortGroup2"), ("Q-BRIDGE-MIB", "qBridgeVlanStatisticsGroup"), )
if mibBuilder.loadTexts: qBridgeCompliance2.setDescription("The compliance statement for device support of Virtual\nLAN Bridge services.\n\nThis document clarifies the persistence requirements for\nthe read-write objects in this MIB module.  All\nimplementations claiming compliance to qBridgeCompliance2\nMUST retain the values of those read-write objects that\nspecify this requirement.")

# Exports

# Module identity
mibBuilder.exportSymbols("Q-BRIDGE-MIB", PYSNMP_MODULE_ID=qBridgeMIB)

# Types
mibBuilder.exportSymbols("Q-BRIDGE-MIB", PortList=PortList, VlanId=VlanId, VlanIdOrAny=VlanIdOrAny, VlanIdOrAnyOrNone=VlanIdOrAnyOrNone, VlanIdOrNone=VlanIdOrNone, VlanIndex=VlanIndex)

# Objects
mibBuilder.exportSymbols("Q-BRIDGE-MIB", qBridgeMIB=qBridgeMIB, qBridgeMIBObjects=qBridgeMIBObjects, dot1qBase=dot1qBase, dot1qVlanVersionNumber=dot1qVlanVersionNumber, dot1qMaxVlanId=dot1qMaxVlanId, dot1qMaxSupportedVlans=dot1qMaxSupportedVlans, dot1qNumVlans=dot1qNumVlans, dot1qGvrpStatus=dot1qGvrpStatus, dot1qTp=dot1qTp, dot1qFdbTable=dot1qFdbTable, dot1qFdbEntry=dot1qFdbEntry, dot1qFdbId=dot1qFdbId, dot1qFdbDynamicCount=dot1qFdbDynamicCount, dot1qTpFdbTable=dot1qTpFdbTable, dot1qTpFdbEntry=dot1qTpFdbEntry, dot1qTpFdbAddress=dot1qTpFdbAddress, dot1qTpFdbPort=dot1qTpFdbPort, dot1qTpFdbStatus=dot1qTpFdbStatus, dot1qTpGroupTable=dot1qTpGroupTable, dot1qTpGroupEntry=dot1qTpGroupEntry, dot1qTpGroupAddress=dot1qTpGroupAddress, dot1qTpGroupEgressPorts=dot1qTpGroupEgressPorts, dot1qTpGroupLearnt=dot1qTpGroupLearnt, dot1qForwardAllTable=dot1qForwardAllTable, dot1qForwardAllEntry=dot1qForwardAllEntry, dot1qForwardAllPorts=dot1qForwardAllPorts, dot1qForwardAllStaticPorts=dot1qForwardAllStaticPorts, dot1qForwardAllForbiddenPorts=dot1qForwardAllForbiddenPorts, dot1qForwardUnregisteredTable=dot1qForwardUnregisteredTable, dot1qForwardUnregisteredEntry=dot1qForwardUnregisteredEntry, dot1qForwardUnregisteredPorts=dot1qForwardUnregisteredPorts, dot1qForwardUnregisteredStaticPorts=dot1qForwardUnregisteredStaticPorts, dot1qForwardUnregisteredForbiddenPorts=dot1qForwardUnregisteredForbiddenPorts, dot1qStatic=dot1qStatic, dot1qStaticUnicastTable=dot1qStaticUnicastTable, dot1qStaticUnicastEntry=dot1qStaticUnicastEntry, dot1qStaticUnicastAddress=dot1qStaticUnicastAddress, dot1qStaticUnicastReceivePort=dot1qStaticUnicastReceivePort, dot1qStaticUnicastAllowedToGoTo=dot1qStaticUnicastAllowedToGoTo, dot1qStaticUnicastStatus=dot1qStaticUnicastStatus, dot1qStaticMulticastTable=dot1qStaticMulticastTable, dot1qStaticMulticastEntry=dot1qStaticMulticastEntry, dot1qStaticMulticastAddress=dot1qStaticMulticastAddress, dot1qStaticMulticastReceivePort=dot1qStaticMulticastReceivePort, dot1qStaticMulticastStaticEgressPorts=dot1qStaticMulticastStaticEgressPorts, dot1qStaticMulticastForbiddenEgressPorts=dot1qStaticMulticastForbiddenEgressPorts, dot1qStaticMulticastStatus=dot1qStaticMulticastStatus, dot1qVlan=dot1qVlan, dot1qVlanNumDeletes=dot1qVlanNumDeletes, dot1qVlanCurrentTable=dot1qVlanCurrentTable, dot1qVlanCurrentEntry=dot1qVlanCurrentEntry, dot1qVlanTimeMark=dot1qVlanTimeMark, dot1qVlanIndex=dot1qVlanIndex, dot1qVlanFdbId=dot1qVlanFdbId, dot1qVlanCurrentEgressPorts=dot1qVlanCurrentEgressPorts, dot1qVlanCurrentUntaggedPorts=dot1qVlanCurrentUntaggedPorts, dot1qVlanStatus=dot1qVlanStatus, dot1qVlanCreationTime=dot1qVlanCreationTime, dot1qVlanStaticTable=dot1qVlanStaticTable, dot1qVlanStaticEntry=dot1qVlanStaticEntry, dot1qVlanStaticName=dot1qVlanStaticName, dot1qVlanStaticEgressPorts=dot1qVlanStaticEgressPorts, dot1qVlanForbiddenEgressPorts=dot1qVlanForbiddenEgressPorts, dot1qVlanStaticUntaggedPorts=dot1qVlanStaticUntaggedPorts, dot1qVlanStaticRowStatus=dot1qVlanStaticRowStatus, dot1qNextFreeLocalVlanIndex=dot1qNextFreeLocalVlanIndex, dot1qPortVlanTable=dot1qPortVlanTable, dot1qPortVlanEntry=dot1qPortVlanEntry, dot1qPvid=dot1qPvid, dot1qPortAcceptableFrameTypes=dot1qPortAcceptableFrameTypes, dot1qPortIngressFiltering=dot1qPortIngressFiltering, dot1qPortGvrpStatus=dot1qPortGvrpStatus, dot1qPortGvrpFailedRegistrations=dot1qPortGvrpFailedRegistrations, dot1qPortGvrpLastPduOrigin=dot1qPortGvrpLastPduOrigin, dot1qPortRestrictedVlanRegistration=dot1qPortRestrictedVlanRegistration, dot1qPortVlanStatisticsTable=dot1qPortVlanStatisticsTable, dot1qPortVlanStatisticsEntry=dot1qPortVlanStatisticsEntry, dot1qTpVlanPortInFrames=dot1qTpVlanPortInFrames, dot1qTpVlanPortOutFrames=dot1qTpVlanPortOutFrames, dot1qTpVlanPortInDiscards=dot1qTpVlanPortInDiscards, dot1qTpVlanPortInOverflowFrames=dot1qTpVlanPortInOverflowFrames, dot1qTpVlanPortOutOverflowFrames=dot1qTpVlanPortOutOverflowFrames, dot1qTpVlanPortInOverflowDiscards=dot1qTpVlanPortInOverflowDiscards, dot1qPortVlanHCStatisticsTable=dot1qPortVlanHCStatisticsTable, dot1qPortVlanHCStatisticsEntry=dot1qPortVlanHCStatisticsEntry, dot1qTpVlanPortHCInFrames=dot1qTpVlanPortHCInFrames, dot1qTpVlanPortHCOutFrames=dot1qTpVlanPortHCOutFrames, dot1qTpVlanPortHCInDiscards=dot1qTpVlanPortHCInDiscards, dot1qLearningConstraintsTable=dot1qLearningConstraintsTable, dot1qLearningConstraintsEntry=dot1qLearningConstraintsEntry, dot1qConstraintVlan=dot1qConstraintVlan, dot1qConstraintSet=dot1qConstraintSet, dot1qConstraintType=dot1qConstraintType, dot1qConstraintStatus=dot1qConstraintStatus, dot1qConstraintSetDefault=dot1qConstraintSetDefault, dot1qConstraintTypeDefault=dot1qConstraintTypeDefault, dot1vProtocol=dot1vProtocol, dot1vProtocolGroupTable=dot1vProtocolGroupTable, dot1vProtocolGroupEntry=dot1vProtocolGroupEntry, dot1vProtocolTemplateFrameType=dot1vProtocolTemplateFrameType, dot1vProtocolTemplateProtocolValue=dot1vProtocolTemplateProtocolValue, dot1vProtocolGroupId=dot1vProtocolGroupId, dot1vProtocolGroupRowStatus=dot1vProtocolGroupRowStatus, dot1vProtocolPortTable=dot1vProtocolPortTable, dot1vProtocolPortEntry=dot1vProtocolPortEntry, dot1vProtocolPortGroupId=dot1vProtocolPortGroupId, dot1vProtocolPortGroupVid=dot1vProtocolPortGroupVid, dot1vProtocolPortRowStatus=dot1vProtocolPortRowStatus, qBridgeConformance=qBridgeConformance, qBridgeGroups=qBridgeGroups, qBridgeCompliances=qBridgeCompliances)

# Groups
mibBuilder.exportSymbols("Q-BRIDGE-MIB", qBridgeBaseGroup=qBridgeBaseGroup, qBridgeFdbUnicastGroup=qBridgeFdbUnicastGroup, qBridgeFdbMulticastGroup=qBridgeFdbMulticastGroup, qBridgeServiceRequirementsGroup=qBridgeServiceRequirementsGroup, qBridgeFdbStaticGroup=qBridgeFdbStaticGroup, qBridgeVlanGroup=qBridgeVlanGroup, qBridgeVlanStaticGroup=qBridgeVlanStaticGroup, qBridgePortGroup=qBridgePortGroup, qBridgeVlanStatisticsGroup=qBridgeVlanStatisticsGroup, qBridgeVlanStatisticsOverflowGroup=qBridgeVlanStatisticsOverflowGroup, qBridgeVlanHCStatisticsGroup=qBridgeVlanHCStatisticsGroup, qBridgeLearningConstraintsGroup=qBridgeLearningConstraintsGroup, qBridgeLearningConstraintDefaultGroup=qBridgeLearningConstraintDefaultGroup, qBridgeClassificationDeviceGroup=qBridgeClassificationDeviceGroup, qBridgeClassificationPortGroup=qBridgeClassificationPortGroup, qBridgePortGroup2=qBridgePortGroup2)

# Compliances
mibBuilder.exportSymbols("Q-BRIDGE-MIB", qBridgeCompliance=qBridgeCompliance, qBridgeCompliance2=qBridgeCompliance2)
