# PySNMP SMI module. Autogenerated from smidump -f python RDBMS-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:05 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( hrSystem, ) = mibBuilder.importSymbols("HOST-RESOURCES-MIB", "hrSystem")
( applGroups, applIndex, ) = mibBuilder.importSymbols("NETWORK-SERVICES-MIB", "applGroups", "applIndex")
( mib_2, ) = mibBuilder.importSymbols("RFC1213-MIB", "mib-2")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks")
( AutonomousType, DateAndTime, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "AutonomousType", "DateAndTime", "DisplayString")

# Objects

rdbmsMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 39)).setRevisions(("1994-06-15 06:55",))
if mibBuilder.loadTexts: rdbmsMIB.setOrganization("IETF RDBMSMIB Working Group")
if mibBuilder.loadTexts: rdbmsMIB.setContactInfo("           David Brower\n\nPostal: The ASK Group, INGRES DBMS Development\n        1080 Marina Village Parkway\n        Alameda, CA  94501\n        US\n\n   Tel: +1 510 748 3418\n   Fax: +1 510 748 2770\n\nE-mail: daveb@ingres.com")
if mibBuilder.loadTexts: rdbmsMIB.setDescription("The MIB module to describe objects for generic relational\ndatabases.")
rdbmsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 39, 1))
rdbmsDbTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 1))
if mibBuilder.loadTexts: rdbmsDbTable.setDescription("The table of databases installed on a system.")
rdbmsDbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 1, 1)).setIndexNames((0, "RDBMS-MIB", "rdbmsDbIndex"))
if mibBuilder.loadTexts: rdbmsDbEntry.setDescription("An entry for a single database on the host.  Whether a\nparticular database is represented by a row in rdbmsDbTable\nmay be dependent on the activity level of that database,\naccording to the product's implementation.  An instance of\nrdbmsRelState having the value active, other, or restricted\nimplies that an entry, corresponding to that instance, will\nbe present.")
rdbmsDbIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsDbIndex.setDescription("A numeric index, unique among all the databases from all\nproducts on this host.  This value is a surrogate for the\nconceptually unique key, which is {PrivateMibOID,\ndatabasename}")
rdbmsDbPrivateMibOID = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 1, 1, 2), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbPrivateMibOID.setDescription("The authoritative identification for the private MIB for\nthis database, presumably based on the vendor, e.g., {\nenterprises 111 <optional subidentifiers>} for Oracle\ndatabases, {enterprises 757 <optional subidentifiers>} for\nIngres databases, { enterprises 897 <optional\nsubidentifiers>} for Sybase databases, etc.\n\nIf no OBJECT IDENTIFIER exists for the private MIB, attempts\nto access this object will return noSuchName (SNMPv1)\nor noSuchInstance (SNMPv2).")
rdbmsDbVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 1, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbVendorName.setDescription("The name of the vendor whose RDBMS manages this database,\nfor informational purposes.")
rdbmsDbName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 1, 1, 4), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbName.setDescription("The name of this database, in a product specific format.  The\nproduct may need to qualify the name in some way to resolve\nconflicts if it is possible for a database name to be\nduplicated on a host.  It might be necessary to construct a\nhierarchical name embedding the RDBMS instance/installation\non the host, and/or the owner of the database.  For instance,\n'/test-installation/database-owner/database-name'.")
rdbmsDbContact = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 1, 1, 5), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsDbContact.setDescription("The textual identification of the contact person for this\nmanaged database, together with information on how to contact\nthis person.\n\nNote: if there is no server associated with this database, an\nagent may need to keep this in other persistent storage,\ne.g., a configuration file.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsDbInfoTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 2))
if mibBuilder.loadTexts: rdbmsDbInfoTable.setDescription("The table of additional information about databases present\non the host.")
rdbmsDbInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 2, 1)).setIndexNames((0, "RDBMS-MIB", "rdbmsDbIndex"))
if mibBuilder.loadTexts: rdbmsDbInfoEntry.setDescription("Information that must be present if the database is actively\nopened.  If the database is not actively opened, then\nattempts to access corresponding instances in this table may\nresult in either noSuchName (SNMPv1) or noSuchInstance\n(SNMPv2).  'Actively opened' means at least one of the\nrdbmsRelState entries for this database in the rdbmsRelTable\nis active(2).")
rdbmsDbInfoProductName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 2, 1, 1), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbInfoProductName.setDescription("The textual product name of the server that created or last\nrestructured this database.  The format is product specific.")
rdbmsDbInfoVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 2, 1, 2), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbInfoVersion.setDescription("The version number of the server that created or last\nrestructured this database.  The format is product specific.")
rdbmsDbInfoSizeUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 2, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,5,1,2,4,)).subtype(namedValues=namedval.NamedValues(("bytes", 1), ("kbytes", 2), ("mbytes", 3), ("gbytes", 4), ("tbytes", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbInfoSizeUnits.setDescription("Identification of the units used to measure the size of this\ndatabase in rdbmsDbInfoSizeAllocated and rdbmsDbInfoSizeUsed.\nbytes(1) indicates individual bytes, kbytes(2) indicates\nunits of kilobytes, mbytes(3) indicates units of megabytes,\ngbytes(4) indicates units of gigabytes, and tbytes(5)\nindicates units of terabytes.  All are binary multiples -- 1K\n= 1024.  If writable, changes here are reflected in the get\nvalues of the associated objects.")
rdbmsDbInfoSizeAllocated = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsDbInfoSizeAllocated.setDescription("The estimated size of this database (in\nrdbmsDbInfoSizeUnits), which is the disk space that has been\nallocated to it and is no longer available to users on this\nhost.  rdbmsDbInfoSize does not necessarily indicate the\namount of space actually in use for database data.  Some\ndatabases may support extending allocated size, and others\nmay not.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsDbInfoSizeUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbInfoSizeUsed.setDescription("The estimated size of this database, in rdbmsDbInfoSizeUnits,\nwhich is actually in use for database data.")
rdbmsDbInfoLastBackup = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 2, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbInfoLastBackup.setDescription("The date and time that the latest complete or partial backup\nof the database was taken. If a database has never been\nbacked up, then attempts to access this object will\nresult in either noSuchName (SNMPv1) or noSuchInstance\n(SNMPv2).")
rdbmsDbParamTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 3))
if mibBuilder.loadTexts: rdbmsDbParamTable.setDescription("The table of configuration parameters for a database.\nEntries should be populated according to the following\nguidelines:\n(1) The value should be specified through administrative\n    (human) intervention.\n(2) It should be configured on a per-database basis.\n(3) One of the following is true:\n    (a) The parameter has a non-numeric value;\n    (b) The current value is numeric, but it only changes due\n        to human intervention;\n    (c) The current value is numeric and dynamic, but the\n        RDBMS does not track access/allocation failures\n        related to the parameter;\n    (d) The current value is numeric and dynamic, the\n        RDBMS tracks changes in access/allocation failures\n        related to the parameter, but the failure has no\n        significant impact on RDBMS performance or\n        availability.\n    (e) The current value is numeric and dynamic, the\n        RDBMS tracks changes in access/allocation failures\n        related to the parameter, the failure has\n        significant impact on RDBMS performance or\n        availability, and is shown in the\n        rdbmsDbLimitedResource table.")
rdbmsDbParamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 3, 1)).setIndexNames((0, "RDBMS-MIB", "rdbmsDbIndex"), (0, "RDBMS-MIB", "rdbmsDbParamName"), (0, "RDBMS-MIB", "rdbmsDbParamSubIndex"))
if mibBuilder.loadTexts: rdbmsDbParamEntry.setDescription("An entry for a single configuration parameter for a database.\nParameters with single values have a subindex value of one.\nIf the parameter is naturally considered to contain a\nvariable number of members of a class, e.g.  members of the\nDBA user group, or files which are part of the database, then\nit must be presented as a set of rows.  If, on the other\nhand, the parameter represents a set of choices from a class,\ne.g. the permissions on a file or the options chosen out of\nthe set of all options allowed, AND is guaranteed to always\nfit in the 255 character length of a DisplayString, then it\nmay be presented as a comma separated list with a subindex\nvalue of one.  Zero may not be used as a subindex value.\n\nIf the database is not actively opened, then attempts\nto access corresponding instances in this table may result in\neither noSuchName (SNMPv1) or noSuchInstance (SNMPv2).\n'Actively opened' means at least one of the\nrdbmsRelState entries for this database in the rdbmsRelTable\nis active(2).")
rdbmsDbParamName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 3, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 64))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsDbParamName.setDescription("The name of a configuration parameter for a database.  This\nname is product-specific.  The length is limited to 64\ncharacters to constrain the number of sub-identifiers needed\nfor instance identification (and to minimize network\ntraffic).")
rdbmsDbParamSubIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsDbParamSubIndex.setDescription("The subindex value for this parameter.  If the parameter is\nnaturally considered to contain a variable number of members\nof a class, e.g.  members of the DBA user group, or files\nwhich are part of the database, then it must be presented as\na set of rows.  If, on the other hand, the parameter\nrepresents a set of choices from a class, e.g. the\npermissions on a file or the options chosen out of the set of\nall options allowed, AND is guaranteed to always fit in the\n255 character length of a DisplayString, then it may be\npresented as a comma separated list with a subindex value of\none.  Zero may not be used as a value.")
rdbmsDbParamID = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 3, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbParamID.setDescription("The ID of the parameter which may be described in some other\nMIB (e.g., an enterprise-specific MIB module).  If there is\nno ID for this rdbmsDbParamName, attempts to access this\nobject will return noSuchName (SNMPv1) or noSuchInstance\n(SNMPv2).")
rdbmsDbParamCurrValue = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 3, 1, 4), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsDbParamCurrValue.setDescription("The value for a configuration parameter now in effect, the\nactual setting for the database.  While there may multiple\nvalues in the temporal domain of interest (for instance, the\nvalue to take effect at the next restart), this is the\ncurrent setting.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsDbParamComment = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 3, 1, 5), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsDbParamComment.setDescription("Annotation which describes the purpose of a configuration\nparameter or the reason for a particular parameter's\nsetting.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsDbLimitedResourceTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 4))
if mibBuilder.loadTexts: rdbmsDbLimitedResourceTable.setDescription("The table of limited resources that are kept per-database.")
rdbmsDbLimitedResourceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 4, 1)).setIndexNames((0, "RDBMS-MIB", "rdbmsDbIndex"), (0, "RDBMS-MIB", "rdbmsDbLimitedResourceName"))
if mibBuilder.loadTexts: rdbmsDbLimitedResourceEntry.setDescription("An entry for a single limited resource kept per-database.\nA limited resource has maximum use determined by a parameter\nthat might or might not be changeable at run time, or visible\nin the rdbmsDbParamTable. Examples would be the number of\navailable locks, or disk space on a partition.  Arrays of\nresources are supported through an integer sub index, which\nshould have the value of one for single-instance names.\n\nLimited resources that are shared across databases, are best\nput in the rdbmsSvrLimitedResourceTable instead of this one.\nIf the database is not actively opened, then attempts to\naccess corresponding instances in this table may result in\neither noSuchName (SNMPv1) or noSuchInstance (SNMPv2).\n'Actively opened' means at least one of the rdbmsRelState\nentries for this database in the rdbmsRelTable is active(2).")
rdbmsDbLimitedResourceName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 1), DisplayString()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceName.setDescription("The name of the resource, for instance 'global locks' or\n'locks for the FOO database', or 'data space on /dev/rdsk/5s0\nfor FOO'. The length is limited to 64 characters to constrain\nthe number of sub-identifiers needed for instance\nidentification (and to minimize network traffic).")
rdbmsDbLimitedResourceID = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceID.setDescription("The ID of the resource which may be described in some other\nMIB (e.g., an enterprise-specific MIB module).  If there is\nno ID for this rdbmsDbLimitedResourceName, attempts to access\nthis object will return noSuchName (SNMPv1) or noSuchInstance\n(SNMPv2).")
rdbmsDbLimitedResourceLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceLimit.setDescription("The maximum value the resource use may attain.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsDbLimitedResourceCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceCurrent.setDescription("The current value for the resource.")
rdbmsDbLimitedResourceHighwater = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceHighwater.setDescription("The maximum value of the resource seen since applUpTime\nwas reset for the earliest server which has the database\nactively opened.\n\nIf there are two servers with the database open, and the\noldest one dies, the proper way to invalidate the value is by\nresetting sysUpTime.")
rdbmsDbLimitedResourceFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceFailures.setDescription("The number of times the system wanted to exceed the limit of\nthe resource since applUpTime was reset for the earliest\nserver which has the database actively opened.\n\nIf there are two servers with the DB open, and the\noldest one dies, the proper way to invalidate the value is by\nresetting sysUpTime.")
rdbmsDbLimitedResourceDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 4, 1, 7), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsDbLimitedResourceDescription.setDescription("A description of the resource and the meaning of the integer\nunits used for Limit, Current, and Highwater.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsSrvTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 5))
if mibBuilder.loadTexts: rdbmsSrvTable.setDescription("The table of database servers running or installed\non a system.")
rdbmsSrvEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 5, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: rdbmsSrvEntry.setDescription("An entry for a single database server.  A server is an\nindependent entity that provides access to one or more\ndatabases.  Failure of one does not affect access to\ndatabases through any other servers.  There might be one or\nmore servers providing access to a database.  A server may be\na 'process' or collection of 'processes', as interpreted by\nthe product.")
rdbmsSrvPrivateMibOID = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 5, 1, 1), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvPrivateMibOID.setDescription("The authoritative identification for the private MIB for this\nserver, presumably based on the vendor, e.g., { enterprises\n111 <optional subidentifiers>} for Oracle servers, {\nenterprises 757 <optional subidentifiers>} for Ingres\nservers, { enterprises 897 <optional subidentifiers>} for\nSybase servers, etc.\n\nIf no OBJECT IDENTIFIER exists for the private MIB, attempts\nto access this object will return noSuchName (SNMPv1)\nor noSuchInstance (SNMPv2).")
rdbmsSrvVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 5, 1, 2), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvVendorName.setDescription("The name of the vendor whose RDBMS manages this database,\nfor informational purposes.")
rdbmsSrvProductName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 5, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvProductName.setDescription("The product name of this server.  This is normally the\nvendor's formal name for the product, in product specific\nformat.")
rdbmsSrvContact = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 5, 1, 4), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsSrvContact.setDescription("The textual identification of the contact person for this\nmanaged server, together with information on how to contact\nthis person.\n\nNote: if there is no active server associated with this\nobject, an agent may need to keep this in other persistent\nstorage, e.g., a configuration file.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsSrvInfoTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 6))
if mibBuilder.loadTexts: rdbmsSrvInfoTable.setDescription("The table of additional information about database servers.\n\nEntries in this table correspond to applications in the\nNETWORK-SERVICES-MIB applTable.  Some objects in that table are\napplication-specific.  When they are associated with an RDBMS\nserver in this table, the objects have the following\nmeanings.\n\napplName - The name of this server, i.e., the process or\ngroup of processes providing access to this database.  The\nexact format will be product and host specific.\n\napplVersion - The version number of this server, in product\nspecific format.\n\napplOperStatus - up(1) means operational and available for\ngeneral use.  down(2) means the server is not available for\nuse, but is known to the agent.  The other states have broad\nmeaning, and may need to be supplemented by the vendor\nprivate MIB.  Halted(3) implies an administrative state of\nunavailability.  Congested(4) implies a resource or or\nadministrative limit is prohibiting new inbound associations.\nThe 'available soon' description of restarting(5) may include\nan indeterminate amount of recovery.\n\napplLastChange is the time the agent noticed the most recent\nchange to applOperStatus.\n\napplInboundAssociation is the number of currently active\nlocal and remote conversations (usually SQL connects).\n\napplOutboundAssociations is not provided by this MIB.\n\napplAccumulatedInboundAssociations is the total number of\nlocal and remote conversations started since the server came\nup.\n\napplAccumulatedOutbound associations is not provided by this\nMIB.\n\napplLastInboundActivity is the time the most recent local or\nremote conversation was attempted or disconnected.\n\napplLastOutboundActivity is not provided by this MIB.\n\napplRejectedInboundAssociations is the number of local or\nremote conversations rejected by the server for\nadministrative reasons or because of resource limitations.\n\napplFailedOutboundAssociations is not provided by this MIB.")
rdbmsSrvInfoEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 6, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: rdbmsSrvInfoEntry.setDescription("Information that must be present for a single 'up' database\nserver, with visibility determined by the value of the\ncorresponding applOperStatus object.  If an instance of\napplOperStatus is not up(1), then attempts to access\ncorresponding instances in this table may result in either\nnoSuchName (SNMPv1) or noSuchInstance (SNMPv2) being returned\nby the agent.")
rdbmsSrvInfoStartupTime = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 1), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoStartupTime.setDescription("The date and time at which this server was last started.")
rdbmsSrvInfoFinishedTransactions = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoFinishedTransactions.setDescription("The number of transactions visible to this server that have\nbeen completed by either commit or abort.  Some database\noperations, such as read-only queries, may not result in the\ncreation of a transaction.")
rdbmsSrvInfoDiskReads = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoDiskReads.setDescription("The total number of reads of database files issued to the\noperating system by this server since startup.  Numbers are\nnot comparable between products.  What constitutes a\nreadand how it is accounted is product-specific.")
rdbmsSrvInfoLogicalReads = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoLogicalReads.setDescription("The total number of logical reads of database files made\ninternally by this server since startup.  The values of this\nobject and those of rdbmsSrvInfoDiskReads reveal the effect\nof caching on read operation. Numbers are not comparable\nbetween products, and may only be meaningful when aggregated\nacross all servers sharing a common cache.")
rdbmsSrvInfoDiskWrites = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoDiskWrites.setDescription("The total number of writes to database files issued to the\noperating system by this server since startup.  Numbers are\nnot comparable between products.")
rdbmsSrvInfoLogicalWrites = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoLogicalWrites.setDescription("The total number of times parts of the database files have\nbeen marked 'dirty' and in need of writing to the disk.  This\nvalue and rdbmsSrvInfoDiskWrites give some indication of the\neffect of 'write-behind' strategies in reducing the number of\ndisk writes compared to database operations.  Because the\nwrites may be done by servers other than those marking the\nparts of the database files dirty, these values may only be\nmeaningful when aggregated across all servers sharing a\ncommon cache.  Numbers are not comparable between products.")
rdbmsSrvInfoPageReads = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoPageReads.setDescription("The total number of pages in database files read by this\nserver since startup.  'Pages' are product specific units of\ndisk i/o operations.  This value, along with\nrdbmsSrvInfoDiskReads, reveals the effect of any grouping\nread-ahead that may be used to enhance performance of some\nqueries, such as scans.")
rdbmsSrvInfoPageWrites = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoPageWrites.setDescription("The total number of pages in database files written by this\nserver since startup.  Pages are product-specific units of\ndisk I/O.  This value, with rdbmsSrvInfoDiskWrites, shows the\neffect of write strategies that collapse logical writes of\ncontiguous pages into single calls to the operating system.")
rdbmsSrvInfoDiskOutOfSpaces = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoDiskOutOfSpaces.setDescription("The total number of times the server has been unable to\nobtain disk space that it wanted, since server startup.  This\nwould be inspected by an agent on receipt of an\nrdbmsOutOfSpace trap.")
rdbmsSrvInfoHandledRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoHandledRequests.setDescription("The total number of requests made to the server on inbound\nassociations.  The meaning of 'requests' is product specific,\nand is not comparable between products.\n\nThis is intended to encapsulate high level semantic\noperations between clients and servers, or between peers.\nFor instance, one request might correspond to a 'select' or\nan 'insert' statement.  It is not intended to capture disk\ni/o described in rdbmsSrvInfoDiskReads and\nrdbmsSrvInfoDiskWrites.")
rdbmsSrvInfoRequestRecvs = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoRequestRecvs.setDescription("The number of receive operations made processing any requests\non inbound associations. The meaning of operations is product\nspecific, and is not comparable between products.\n\nThis is intended to capture lower-level i/o operations than\nshown by HandledRequests, between clients and servers, or\nbetween peers.  For instance, it might roughly correspond to\nthe amount of data given with an 'insert' statement.  It is\nnot intended to capture disk i/o described in\nrdbmsSrvInfoDiskReads and rdbmsSrvInfoDiskWrites.")
rdbmsSrvInfoRequestSends = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoRequestSends.setDescription("The number of send operations made processing requests\nhandled on inbound associations.  The meaning of operations\nis product specific, and is not comparable between products.\nThis is intended to capture lower-level i/o operations than\nshown by HandledRequests, between between clients and\nservers, or between peers.  It might roughly correspond to\nthe number of rows returned by a 'select' statement.  It is\nnot intended to capture disk i/o described in DiskReads.")
rdbmsSrvInfoHighwaterInboundAssociations = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 13), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvInfoHighwaterInboundAssociations.setDescription("The greatest number of inbound associations that have been\nsimultaneously open to this server since startup.")
rdbmsSrvInfoMaxInboundAssociations = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 6, 1, 14), Gauge32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsSrvInfoMaxInboundAssociations.setDescription("The greatest number of inbound associations that can be\nsimultaneously open with this server.  If there is no limit,\nthen the value should be zero.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsSrvParamTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 7))
if mibBuilder.loadTexts: rdbmsSrvParamTable.setDescription("The table of configuration parameters for a server.  Entries\nshould be populated according to the following guidelines:\n(1) The value should be specified through administrative\n    (human) intervention.\n(2) It should be configured on a per-server or a more global\n    basis, with duplicate entries for each server sharing\n    use of the parameter.\n(3) One of the following is true:\n    (a) The parameter has a non-numeric value;\n    (b) The current value is numeric, but it only changes due\n        to human intervention;\n    (c) The current value is numeric and dynamic, but the\n        RDBMS does not track access/allocation failures\n        related to the parameter;\n    (d) The current value is numeric and dynamic, the\n        RDBMS tracks changes in access/allocation failures\n        related to the parameter, but the failure has no\n        significant impact on RDBMS performance or\n        availability.\n    (e) The current value is numeric and dynamic, the\n        RDBMS tracks changes in access/allocation failures\n        related to the parameter, the failure has\n        significant impact on RDBMS performance or\n        availability, and is shown in the\n        rdbmsSrvLimitedResource table.")
rdbmsSrvParamEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 7, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "RDBMS-MIB", "rdbmsSrvParamName"), (0, "RDBMS-MIB", "rdbmsSrvParamSubIndex"))
if mibBuilder.loadTexts: rdbmsSrvParamEntry.setDescription("An entry for a single configuration parameter for a server.\nParameters with single values have a subindex value of one.\nIf the parameter is naturally considered to contain a\nvariable number of members of a class, e.g.  members of the\nDBA user group, or tracepoints active in the server, then it\nmust be presented as a set of rows.  If, on the other hand,\nthe parameter represents a set of choices from a class,\ne.g. the permissions on a file or the options chosen out of\nthe set of all options allowed, AND is guaranteed to always\nfit in the 255 character length of a DisplayString, then it\nmay be presented as a comma separated list with a subindex\nvalue of one.  Zero may not be used as a subindex value.\n\nEntries for a server must be present if the value of the\ncorresponding applOperStatus object is up(1).  If an instance\nof applOperStatus is not up(1), then attempts to access\ncorresponding instances in this table may result in either\nnoSuchName (SNMPv1) or noSuchInstance (SNMPv2) being returned\nby the agent.")
rdbmsSrvParamName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 7, 1, 1), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(1, 64))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsSrvParamName.setDescription("The name of a configuration parameter for a server.  This\nname is product-specific. The length is limited to 64\ncharacters to constrain the number of sub-identifiers needed\nfor instance identification (and to minimize network\ntraffic).")
rdbmsSrvParamSubIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 7, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsSrvParamSubIndex.setDescription("The subindex value for this parameter.  If the parameter is\nnaturally considered to contain a variable number of members\nof a class, e.g.  members of the DBA user group, or files\nwhich are part of the database, then it must be presented as\na set of rows.  If, on the other hand, the parameter\nrepresents a set of choices from a class, e.g. the\npermissions on a file or the options chosen out of the set of\nall options allowed, AND is guaranteed to always fit in the\n255 character length of a DisplayString, then it may be\npresented as a comma separated list with a subindex value of\none.  Zero may not be used as a value.")
rdbmsSrvParamID = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 7, 1, 3), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvParamID.setDescription("The ID of the parameter which may be described in some\nother MIB.  If there is no ID for this rdbmsSrvParamName,\nattempts to access this object will return noSuchName\n(SNMPv1) or noSuchInstance (SNMPv2).")
rdbmsSrvParamCurrValue = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 7, 1, 4), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsSrvParamCurrValue.setDescription("The value for a configuration parameter now in effect, the\nactual setting for the server.  While there may multiple\nvalues in the temporal domain of interest (for instance, the\nvalue to take effect at the next restart), this is the\ncurrent setting.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsSrvParamComment = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 7, 1, 5), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsSrvParamComment.setDescription("Annotation which describes the purpose of a configuration\nparameter or the reason for a particular parameter's\nsetting.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsSrvLimitedResourceTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 8))
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceTable.setDescription("The table of limited resources relevant to a server.")
rdbmsSrvLimitedResourceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 8, 1)).setIndexNames((0, "NETWORK-SERVICES-MIB", "applIndex"), (0, "RDBMS-MIB", "rdbmsSrvLimitedResourceName"))
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceEntry.setDescription("An entry for a single limited resource kept by the server.\nA limited resource has maximum use determined by a parameter\nthat might or might not changeable at run time, or visible in\nthe rbmsSrvParamTable.  Examples would be the number of\navailable locks, or number of concurrent executions allowed\nin a server.  Arrays of resources are supported through an\ninteger subindex, which should have the value of one for\nsingle-instance names.\n\nLimited resources that are shared across servers or databases\nare best duplicated in this table across\nall servers accessing the resource.")
rdbmsSrvLimitedResourceName = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 1), DisplayString()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceName.setDescription("The name of the resource, for instance 'threads' or\n'semaphores', or 'buffer pages'")
rdbmsSrvLimitedResourceID = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceID.setDescription("The ID of the resource which may be described in some other\nMIB.  If there is no ID for this rdbmsSrvLimitedResourceName,\nattempts to access this object will return noSuchName\n(SNMPv1) or noSuchInstance (SNMPv2).")
rdbmsSrvLimitedResourceLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceLimit.setDescription("The maximum value the resource use may attain.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsSrvLimitedResourceCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 4), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceCurrent.setDescription("The current value for the resource.")
rdbmsSrvLimitedResourceHighwater = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 5), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceHighwater.setDescription("The maximum value of the resource seen since applUpTime\nwas reset.")
rdbmsSrvLimitedResourceFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceFailures.setDescription("The number of times the system wanted to exceed the limit of\nthe resource since applUpTime was reset.")
rdbmsSrvLimitedResourceDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 8, 1, 7), DisplayString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rdbmsSrvLimitedResourceDescription.setDescription("A description of the resource and the meaning of the integer\nunits used for Limit, Current, and Highwater.\n\nNote that a compliant agent does not need to\nallow write access to this object.")
rdbmsRelTable = MibTable((1, 3, 6, 1, 2, 1, 39, 1, 9))
if mibBuilder.loadTexts: rdbmsRelTable.setDescription("A table relating databases and servers present on a host.")
rdbmsRelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 39, 1, 9, 1)).setIndexNames((0, "RDBMS-MIB", "rdbmsDbIndex"), (0, "NETWORK-SERVICES-MIB", "applIndex"))
if mibBuilder.loadTexts: rdbmsRelEntry.setDescription("An entry relating a single database server to a single\ndatabase to which it may provide access.  The table is\nindexed first by the index of rdbmsDbTable, and then\nrdbmsSrvTable, so that all servers capable of providing\naccess to a given database may be found by SNMP traversal\noperations (get-next and get-bulk).  The makeup of this table\ndepends on the product's architecture, e.g. if it is one\nserver - many databases, then each server will appear n\ntimes, where n is the number of databases it may access, and\neach database will appear once.  If the architecture is one\ndatabase - many servers, then each server will appear once\nand each database will appear n times, where n is the number\nof servers that may be accessing it.")
rdbmsRelState = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 9, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,5,4,1,2,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("active", 2), ("available", 3), ("restricted", 4), ("unavailable", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsRelState.setDescription("The state of this server's access to this database.\nActive(2) means the server is actively using the database.\nAvailable(3) means the server could use the database if\nnecessary.  Restricted(4) means the database is in some\nadministratively determined state of less-than-complete\navailability.  Unavailable(5) means the database is not\navailable through this server.  Other(1) means the\ndatabase/server is in some other condition, possibly\ndescribed in the vendor private MIB.")
rdbmsRelActiveTime = MibTableColumn((1, 3, 6, 1, 2, 1, 39, 1, 9, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rdbmsRelActiveTime.setDescription("The time the database was made active by the server.  If an\ninstance of rdbmsRelState is not active(1), then attempts to\naccess the corresponding instance of this object may result\nin either noSuchName (SNMPv1) or noSuchInstance (SNMPv2)\nbeing returned by the agent.")
rdbmsWellKnownLimitedResources = MibIdentifier((1, 3, 6, 1, 2, 1, 39, 1, 10))
rdbmsLogSpace = ObjectIdentity((1, 3, 6, 1, 2, 1, 39, 1, 10, 1))
if mibBuilder.loadTexts: rdbmsLogSpace.setDescription("Storage allocated for redo and undo logs.")
rdbmsTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 39, 2))
rdbmsConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 39, 3))
rdbmsCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 39, 3, 1))
rdbmsGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 39, 3, 2))

# Augmentions

# Notifications

rdbmsStateChange = NotificationType((1, 3, 6, 1, 2, 1, 39, 2, 1)).setObjects(("RDBMS-MIB", "rdbmsRelState"), )
if mibBuilder.loadTexts: rdbmsStateChange.setDescription("An rdbmsStateChange trap signifies that one of the database\nserver/databases managed by this agent has changed its\nrdbmsRelState in a way that makes it less accessible for use.\nFor these purposes, both active(2) and available(3) are\nconsidered fully accessible.  The state sent with the trap is\nthe new, less accessible state.")
rdbmsOutOfSpace = NotificationType((1, 3, 6, 1, 2, 1, 39, 2, 2)).setObjects(("RDBMS-MIB", "rdbmsSrvInfoDiskOutOfSpaces"), )
if mibBuilder.loadTexts: rdbmsOutOfSpace.setDescription("An rdbmsOutOfSpace trap signifies that one of the database\nservers managed by this agent has been unable to allocate\nspace for one of the databases managed by this agent.  Care\nshould be taken to avoid flooding the network with these\ntraps.")

# Groups

rdbmsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 39, 3, 2, 1)).setObjects(("RDBMS-MIB", "rdbmsDbVendorName"), ("RDBMS-MIB", "rdbmsSrvParamComment"), ("RDBMS-MIB", "rdbmsSrvInfoPageWrites"), ("RDBMS-MIB", "rdbmsSrvInfoRequestRecvs"), ("RDBMS-MIB", "rdbmsDbLimitedResourceHighwater"), ("RDBMS-MIB", "rdbmsSrvInfoLogicalReads"), ("RDBMS-MIB", "rdbmsDbLimitedResourceLimit"), ("RDBMS-MIB", "rdbmsSrvInfoHighwaterInboundAssociations"), ("RDBMS-MIB", "rdbmsDbContact"), ("RDBMS-MIB", "rdbmsDbInfoSizeAllocated"), ("RDBMS-MIB", "rdbmsSrvContact"), ("RDBMS-MIB", "rdbmsDbParamCurrValue"), ("RDBMS-MIB", "rdbmsSrvInfoFinishedTransactions"), ("RDBMS-MIB", "rdbmsSrvInfoMaxInboundAssociations"), ("RDBMS-MIB", "rdbmsSrvLimitedResourceCurrent"), ("RDBMS-MIB", "rdbmsSrvLimitedResourceDescription"), ("RDBMS-MIB", "rdbmsDbLimitedResourceFailures"), ("RDBMS-MIB", "rdbmsDbInfoSizeUnits"), ("RDBMS-MIB", "rdbmsRelActiveTime"), ("RDBMS-MIB", "rdbmsDbInfoSizeUsed"), ("RDBMS-MIB", "rdbmsDbInfoVersion"), ("RDBMS-MIB", "rdbmsSrvInfoHandledRequests"), ("RDBMS-MIB", "rdbmsSrvInfoRequestSends"), ("RDBMS-MIB", "rdbmsSrvVendorName"), ("RDBMS-MIB", "rdbmsSrvInfoStartupTime"), ("RDBMS-MIB", "rdbmsSrvLimitedResourceHighwater"), ("RDBMS-MIB", "rdbmsSrvPrivateMibOID"), ("RDBMS-MIB", "rdbmsSrvParamCurrValue"), ("RDBMS-MIB", "rdbmsSrvLimitedResourceLimit"), ("RDBMS-MIB", "rdbmsDbInfoLastBackup"), ("RDBMS-MIB", "rdbmsDbInfoProductName"), ("RDBMS-MIB", "rdbmsDbName"), ("RDBMS-MIB", "rdbmsDbPrivateMibOID"), ("RDBMS-MIB", "rdbmsSrvInfoDiskWrites"), ("RDBMS-MIB", "rdbmsDbLimitedResourceDescription"), ("RDBMS-MIB", "rdbmsSrvLimitedResourceFailures"), ("RDBMS-MIB", "rdbmsSrvProductName"), ("RDBMS-MIB", "rdbmsDbParamComment"), ("RDBMS-MIB", "rdbmsSrvInfoPageReads"), ("RDBMS-MIB", "rdbmsDbLimitedResourceCurrent"), ("RDBMS-MIB", "rdbmsSrvInfoLogicalWrites"), ("RDBMS-MIB", "rdbmsRelState"), ("RDBMS-MIB", "rdbmsSrvInfoDiskReads"), )
if mibBuilder.loadTexts: rdbmsGroup.setDescription("A collection of objects providing basic instrumentation of an\nRDBMS entity.")

# Compliances

rdbmsCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 39, 3, 1, 1)).setObjects(("RDBMS-MIB", "rdbmsGroup"), ("HOST-RESOURCES-MIB", "hrSystem"), ("NETWORK-SERVICES-MIB", "applGroups"), )
if mibBuilder.loadTexts: rdbmsCompliance.setDescription("The compliance statement for SNMP entities which\nimplement the RDBMS MIB")

# Exports

# Module identity
mibBuilder.exportSymbols("RDBMS-MIB", PYSNMP_MODULE_ID=rdbmsMIB)

# Objects
mibBuilder.exportSymbols("RDBMS-MIB", rdbmsMIB=rdbmsMIB, rdbmsObjects=rdbmsObjects, rdbmsDbTable=rdbmsDbTable, rdbmsDbEntry=rdbmsDbEntry, rdbmsDbIndex=rdbmsDbIndex, rdbmsDbPrivateMibOID=rdbmsDbPrivateMibOID, rdbmsDbVendorName=rdbmsDbVendorName, rdbmsDbName=rdbmsDbName, rdbmsDbContact=rdbmsDbContact, rdbmsDbInfoTable=rdbmsDbInfoTable, rdbmsDbInfoEntry=rdbmsDbInfoEntry, rdbmsDbInfoProductName=rdbmsDbInfoProductName, rdbmsDbInfoVersion=rdbmsDbInfoVersion, rdbmsDbInfoSizeUnits=rdbmsDbInfoSizeUnits, rdbmsDbInfoSizeAllocated=rdbmsDbInfoSizeAllocated, rdbmsDbInfoSizeUsed=rdbmsDbInfoSizeUsed, rdbmsDbInfoLastBackup=rdbmsDbInfoLastBackup, rdbmsDbParamTable=rdbmsDbParamTable, rdbmsDbParamEntry=rdbmsDbParamEntry, rdbmsDbParamName=rdbmsDbParamName, rdbmsDbParamSubIndex=rdbmsDbParamSubIndex, rdbmsDbParamID=rdbmsDbParamID, rdbmsDbParamCurrValue=rdbmsDbParamCurrValue, rdbmsDbParamComment=rdbmsDbParamComment, rdbmsDbLimitedResourceTable=rdbmsDbLimitedResourceTable, rdbmsDbLimitedResourceEntry=rdbmsDbLimitedResourceEntry, rdbmsDbLimitedResourceName=rdbmsDbLimitedResourceName, rdbmsDbLimitedResourceID=rdbmsDbLimitedResourceID, rdbmsDbLimitedResourceLimit=rdbmsDbLimitedResourceLimit, rdbmsDbLimitedResourceCurrent=rdbmsDbLimitedResourceCurrent, rdbmsDbLimitedResourceHighwater=rdbmsDbLimitedResourceHighwater, rdbmsDbLimitedResourceFailures=rdbmsDbLimitedResourceFailures, rdbmsDbLimitedResourceDescription=rdbmsDbLimitedResourceDescription, rdbmsSrvTable=rdbmsSrvTable, rdbmsSrvEntry=rdbmsSrvEntry, rdbmsSrvPrivateMibOID=rdbmsSrvPrivateMibOID, rdbmsSrvVendorName=rdbmsSrvVendorName, rdbmsSrvProductName=rdbmsSrvProductName, rdbmsSrvContact=rdbmsSrvContact, rdbmsSrvInfoTable=rdbmsSrvInfoTable, rdbmsSrvInfoEntry=rdbmsSrvInfoEntry, rdbmsSrvInfoStartupTime=rdbmsSrvInfoStartupTime, rdbmsSrvInfoFinishedTransactions=rdbmsSrvInfoFinishedTransactions, rdbmsSrvInfoDiskReads=rdbmsSrvInfoDiskReads, rdbmsSrvInfoLogicalReads=rdbmsSrvInfoLogicalReads, rdbmsSrvInfoDiskWrites=rdbmsSrvInfoDiskWrites, rdbmsSrvInfoLogicalWrites=rdbmsSrvInfoLogicalWrites, rdbmsSrvInfoPageReads=rdbmsSrvInfoPageReads, rdbmsSrvInfoPageWrites=rdbmsSrvInfoPageWrites, rdbmsSrvInfoDiskOutOfSpaces=rdbmsSrvInfoDiskOutOfSpaces, rdbmsSrvInfoHandledRequests=rdbmsSrvInfoHandledRequests, rdbmsSrvInfoRequestRecvs=rdbmsSrvInfoRequestRecvs, rdbmsSrvInfoRequestSends=rdbmsSrvInfoRequestSends, rdbmsSrvInfoHighwaterInboundAssociations=rdbmsSrvInfoHighwaterInboundAssociations, rdbmsSrvInfoMaxInboundAssociations=rdbmsSrvInfoMaxInboundAssociations, rdbmsSrvParamTable=rdbmsSrvParamTable, rdbmsSrvParamEntry=rdbmsSrvParamEntry, rdbmsSrvParamName=rdbmsSrvParamName, rdbmsSrvParamSubIndex=rdbmsSrvParamSubIndex, rdbmsSrvParamID=rdbmsSrvParamID, rdbmsSrvParamCurrValue=rdbmsSrvParamCurrValue, rdbmsSrvParamComment=rdbmsSrvParamComment, rdbmsSrvLimitedResourceTable=rdbmsSrvLimitedResourceTable, rdbmsSrvLimitedResourceEntry=rdbmsSrvLimitedResourceEntry, rdbmsSrvLimitedResourceName=rdbmsSrvLimitedResourceName, rdbmsSrvLimitedResourceID=rdbmsSrvLimitedResourceID, rdbmsSrvLimitedResourceLimit=rdbmsSrvLimitedResourceLimit, rdbmsSrvLimitedResourceCurrent=rdbmsSrvLimitedResourceCurrent, rdbmsSrvLimitedResourceHighwater=rdbmsSrvLimitedResourceHighwater, rdbmsSrvLimitedResourceFailures=rdbmsSrvLimitedResourceFailures, rdbmsSrvLimitedResourceDescription=rdbmsSrvLimitedResourceDescription, rdbmsRelTable=rdbmsRelTable, rdbmsRelEntry=rdbmsRelEntry, rdbmsRelState=rdbmsRelState, rdbmsRelActiveTime=rdbmsRelActiveTime, rdbmsWellKnownLimitedResources=rdbmsWellKnownLimitedResources, rdbmsLogSpace=rdbmsLogSpace, rdbmsTraps=rdbmsTraps, rdbmsConformance=rdbmsConformance, rdbmsCompliances=rdbmsCompliances, rdbmsGroups=rdbmsGroups)

# Notifications
mibBuilder.exportSymbols("RDBMS-MIB", rdbmsStateChange=rdbmsStateChange, rdbmsOutOfSpace=rdbmsOutOfSpace)

# Groups
mibBuilder.exportSymbols("RDBMS-MIB", rdbmsGroup=rdbmsGroup)

# Compliances
mibBuilder.exportSymbols("RDBMS-MIB", rdbmsCompliance=rdbmsCompliance)
