# PySNMP SMI module. Autogenerated from smidump -f python SONET-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:14 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( PerfCurrentCount, PerfIntervalCount, ) = mibBuilder.importSymbols("PerfHist-TC-MIB", "PerfCurrentCount", "PerfIntervalCount")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")
( DisplayString, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TruthValue")

# Objects

sonetMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 39)).setRevisions(("2003-08-11 00:00","1998-10-19 00:00","1994-01-03 00:00",))
if mibBuilder.loadTexts: sonetMIB.setOrganization("IETF AToM MIB Working Group")
if mibBuilder.loadTexts: sonetMIB.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/atommib-charter.html\n\nMailing Lists:\nGeneral Discussion: atommib@research.telcordia.com\nTo Subscribe: atommib-request@research.telcordia.com\n\nKaj Tesink\nTelcordia Technologies\nTel: (732) 758-5254\nFax: (732) 758-2269\nE-mail: kaj@research.telcordia.com.")
if mibBuilder.loadTexts: sonetMIB.setDescription("The MIB module to describe SONET/SDH interface objects.\n\nCopyright (C) The Internet Society (2003).  This version\nof this MIB module is part of RFC 3592;  see the RFC\nitself for full legal notices.")
sonetObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 1))
sonetMedium = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 1, 1))
sonetMediumTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1))
if mibBuilder.loadTexts: sonetMediumTable.setDescription("The SONET/SDH Medium table.")
sonetMediumEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetMediumEntry.setDescription("An entry in the SONET/SDH Medium table.")
sonetMediumType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("sonet", 1), ("sdh", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetMediumType.setDescription("This variable identifies whether a SONET\nor a SDH signal is used across this interface.")
sonetMediumTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 900))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetMediumTimeElapsed.setDescription("The number of seconds, including partial seconds,\nthat have elapsed since the beginning of the current\nmeasurement period. If, for some reason, such as an\nadjustment in the system's time-of-day clock, the\ncurrent interval exceeds the maximum value, the\nagent will return the maximum value.")
sonetMediumValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetMediumValidIntervals.setDescription("The number of previous 15-minute intervals\nfor which data was collected.\nA SONET/SDH interface must be capable\nof supporting at least n intervals.\nThe minimum value of n is 4.\nThe default of n is 32.\nThe maximum value of n is 96.\nThe value will be <n> unless the measurement was\n(re-)started within the last (<n>*15) minutes, in which\ncase the value will be the number of complete 15\nminute intervals for which the agent has at least\nsome data. In certain cases (e.g., in the case\nwhere the agent is a proxy) it is possible that some\nintervals are unavailable.  In this case, this\ninterval is the maximum interval number for\nwhich data is available. ")
sonetMediumLineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,4,5,1,)).subtype(namedValues=namedval.NamedValues(("sonetMediumOther", 1), ("sonetMediumB3ZS", 2), ("sonetMediumCMI", 3), ("sonetMediumNRZ", 4), ("sonetMediumRZ", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetMediumLineCoding.setDescription("This variable describes the line coding for\nthis interface. The B3ZS and CMI are used for\nelectrical SONET/SDH signals (STS-1 and STS-3).\nThe Non-Return to Zero (NRZ) and the Return\nto Zero are used for optical SONET/SDH signals.")
sonetMediumLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 5), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,4,1,5,6,3,)).subtype(namedValues=namedval.NamedValues(("sonetOther", 1), ("sonetShortSingleMode", 2), ("sonetLongSingleMode", 3), ("sonetMultiMode", 4), ("sonetCoax", 5), ("sonetUTP", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetMediumLineType.setDescription("This variable describes the line type for\nthis interface. The line types are\nShort and Long Range\nSingle Mode fiber or Multi-Mode fiber interfaces,\nand coax and UTP for electrical interfaces.  The\nvalue sonetOther should be used when the Line Type is\nnot one of the listed values.")
sonetMediumCircuitIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 6), DisplayString().subtype(subtypeSpec=constraint.ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetMediumCircuitIdentifier.setDescription("This variable contains the transmission\nvendor's circuit identifier, for the\npurpose of facilitating troubleshooting.\nNote that the circuit identifier, if available,\nis also represented by ifPhysAddress.")
sonetMediumInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 7), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetMediumInvalidIntervals.setDescription("The number of intervals in the range from\n0 to sonetMediumValidIntervals for which no\ndata is available. This object will typically\nbe zero except in cases where the data for some\nintervals are not available (e.g., in proxy\nsituations).")
sonetMediumLoopbackConfig = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 1, 1, 8), Bits().subtype(namedValues=namedval.NamedValues(("sonetNoLoop", 0), ("sonetFacilityLoop", 1), ("sonetTerminalLoop", 2), ("sonetOtherLoop", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetMediumLoopbackConfig.setDescription("The current loopback state of the SONET/SDH interface.  The\nvalues mean:\n\n  sonetNoLoop\n     Not in the loopback state. A device that is not\n     capable of performing a loopback on this interface\n     shall always return this value.\n\n  sonetFacilityLoop\n     The received signal at this interface is looped back\n     out through the corresponding transmitter in the return\n     direction.\n\n  sonetTerminalLoop\n     The signal that is about to be transmitted is connected\n     to the associated incoming receiver.\n\n  sonetOtherLoop\n     Loopbacks that are not defined here.")
sonetSESthresholdSet = MibScalar((1, 3, 6, 1, 2, 1, 10, 39, 1, 1, 2), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,2,1,5,4,)).subtype(namedValues=namedval.NamedValues(("other", 1), ("bellcore1991", 2), ("ansi1993", 3), ("itu1995", 4), ("ansi1997", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetSESthresholdSet.setDescription("An enumerated integer indicating which\nrecognized set of SES thresholds that\nthe agent uses for determining severely\nerrored seconds and unavailable time.\n\nother(1)\n  None of the following.\n\nbellcore1991(2)\n  Bellcore TR-NWT-000253, 1991 [TR253], or\n  ANSI T1M1.3/93-005R2, 1993 [T1M1.3].\n  See also Appendix B.\n\nansi1993(3)\n  ANSI T1.231, 1993 [T1.231a], or\n  Bellcore GR-253-CORE, Issue 2, 1995 [GR253]\n\nitu1995(4)\n  ITU Recommendation G.826, 1995 [G.826]\n\nansi1997(5)\n  ANSI T1.231, 1997 [T1.231b]\n\nIf a manager changes the value of this\nobject then the SES statistics collected\nprior to this change must be invalidated.")
sonetSection = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 1, 2))
sonetSectionCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1))
if mibBuilder.loadTexts: sonetSectionCurrentTable.setDescription("The SONET/SDH Section Current table.")
sonetSectionCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetSectionCurrentEntry.setDescription("An entry in the SONET/SDH Section Current table.")
sonetSectionCurrentStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 6))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionCurrentStatus.setDescription("This variable indicates the\nstatus of the interface.\nThe sonetSectionCurrentStatus\nis a bit map represented\nas a sum, therefore,\nit can represent multiple defects\nsimultaneously.\nThe sonetSectionNoDefect should be\nset if and only if\nno other flag is set.\n\nThe various bit positions are:\n      1   sonetSectionNoDefect\n      2   sonetSectionLOS\n      4   sonetSectionLOF")
sonetSectionCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionCurrentESs.setDescription("The counter associated with the number of Errored\nSeconds encountered by a SONET/SDH\nSection in the current 15 minute interval.")
sonetSectionCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionCurrentSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH Section in the current 15\nminute interval.")
sonetSectionCurrentSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionCurrentSEFSs.setDescription("The counter associated with the number of\nSeverely Errored Framing Seconds\nencountered by a SONET/SDH Section in the current\n15 minute interval.")
sonetSectionCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 1, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionCurrentCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH Section in the current 15 minute interval.")
sonetSectionIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2))
if mibBuilder.loadTexts: sonetSectionIntervalTable.setDescription("The SONET/SDH Section Interval table.")
sonetSectionIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetSectionIntervalNumber"))
if mibBuilder.loadTexts: sonetSectionIntervalEntry.setDescription("An entry in the SONET/SDH Section Interval table.")
sonetSectionIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetSectionIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetSectionIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionIntervalESs.setDescription("The counter associated with the number of\nErrored Seconds encountered\nby a SONET/SDH Section in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetSectionIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionIntervalSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH Section in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetSectionIntervalSEFSs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionIntervalSEFSs.setDescription("The counter associated with the number of\nSeverely Errored Framing Seconds\nencountered by a SONET/SDH Section in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetSectionIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionIntervalCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH Section in a particular 15-minute interval\nin the past 24 hours.")
sonetSectionIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 2, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetSectionIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
sonetLine = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 1, 3))
sonetLineCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1))
if mibBuilder.loadTexts: sonetLineCurrentTable.setDescription("The SONET/SDH Line Current table.")
sonetLineCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetLineCurrentEntry.setDescription("An entry in the SONET/SDH Line Current table.")
sonetLineCurrentStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 6))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineCurrentStatus.setDescription("This variable indicates the\nstatus of the interface.\nThe sonetLineCurrentStatus\nis a bit map represented\nas a sum, therefore,\nit can represent multiple defects\nsimultaneously.\nThe sonetLineNoDefect should be\nset if and only if\nno other flag is set.\n\nThe various bit positions are:\n 1   sonetLineNoDefect\n 2   sonetLineAIS\n 4   sonetLineRDI")
sonetLineCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineCurrentESs.setDescription("The counter associated with the number of Errored\nSeconds encountered by a SONET/SDH\nLine in the current 15 minute interval.")
sonetLineCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineCurrentSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH Line in the current 15\nminute\ninterval.")
sonetLineCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineCurrentCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH Line in the current 15 minute interval.")
sonetLineCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 1, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineCurrentUASs.setDescription("The counter associated with the number of\nUnavailable Seconds\nencountered by a SONET/SDH Line in the current 15\nminute\ninterval.")
sonetLineIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2))
if mibBuilder.loadTexts: sonetLineIntervalTable.setDescription("The SONET/SDH Line Interval table.")
sonetLineIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetLineIntervalNumber"))
if mibBuilder.loadTexts: sonetLineIntervalEntry.setDescription("An entry in the SONET/SDH Line Interval table.")
sonetLineIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetLineIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetLineIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineIntervalESs.setDescription("The counter associated with the number of\nErrored Seconds encountered\nby a SONET/SDH Line in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetLineIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineIntervalSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH Line in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetLineIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineIntervalCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH Line in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetLineIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineIntervalUASs.setDescription("The counter associated with the\nnumber of Unavailable Seconds\nencountered by a SONET/SDH Line in\na particular 15-minute interval\nin the past 24 hours.")
sonetLineIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 3, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetLineIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
sonetFarEndLine = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 1, 4))
sonetFarEndLineCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 1))
if mibBuilder.loadTexts: sonetFarEndLineCurrentTable.setDescription("The SONET/SDH Far End Line Current table.")
sonetFarEndLineCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetFarEndLineCurrentEntry.setDescription("An entry in the SONET/SDH Far End Line Current table.")
sonetFarEndLineCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 1, 1, 1), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineCurrentESs.setDescription("The counter associated with the number of Far\nEnd Errored Seconds encountered by a SONET/SDH\ninterface in the current 15 minute interval.")
sonetFarEndLineCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 1, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineCurrentSESs.setDescription("The counter associated with the number of\nFar End Severely Errored Seconds\n\n\n\nencountered by a SONET/SDH Medium/Section/Line\ninterface in the current 15 minute\ninterval.")
sonetFarEndLineCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineCurrentCVs.setDescription("The counter associated with the number of\nFar End Coding Violations reported via\nthe far end block error count\nencountered by a\nSONET/SDH Medium/Section/Line\ninterface in the current 15 minute interval.")
sonetFarEndLineCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineCurrentUASs.setDescription("The counter associated with the number of\nFar End Unavailable Seconds\nencountered by a\nSONET/SDH Medium/Section/Line\ninterface in the current 15 minute interval.")
sonetFarEndLineIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2))
if mibBuilder.loadTexts: sonetFarEndLineIntervalTable.setDescription("The SONET/SDH Far End Line Interval table.")
sonetFarEndLineIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetFarEndLineIntervalNumber"))
if mibBuilder.loadTexts: sonetFarEndLineIntervalEntry.setDescription("An entry in the SONET/SDH Far\nEnd Line Interval table.")
sonetFarEndLineIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetFarEndLineIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetFarEndLineIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineIntervalESs.setDescription("The counter associated with the number of\nFar End Errored Seconds encountered\nby a SONET/SDH Line\ninterface in a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndLineIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineIntervalSESs.setDescription("The counter associated with the number of\nFar End Severely Errored Seconds\nencountered by a SONET/SDH Line\ninterface in a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndLineIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineIntervalCVs.setDescription("The counter associated with the number of\nFar End Coding Violations reported via\nthe far end block error count\nencountered by a\nSONET/SDH Line\ninterface in a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndLineIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineIntervalUASs.setDescription("The counter associated with the number of\nFar End Unavailable Seconds\nencountered by a\nSONET/SDH Line\ninterface in a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndLineIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 1, 4, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndLineIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
sonetObjectsPath = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 2))
sonetPath = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 2, 1))
sonetPathCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1))
if mibBuilder.loadTexts: sonetPathCurrentTable.setDescription("The SONET/SDH Path Current table.")
sonetPathCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetPathCurrentEntry.setDescription("An entry in the SONET/SDH Path Current table.")
sonetPathCurrentWidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,5,7,2,1,6,4,)).subtype(namedValues=namedval.NamedValues(("sts1", 1), ("sts3cSTM1", 2), ("sts12cSTM4", 3), ("sts24c", 4), ("sts48cSTM16", 5), ("sts192cSTM64", 6), ("sts768cSTM256", 7), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetPathCurrentWidth.setDescription("A value that indicates the type of the SONET/SDH\nPath.  For SONET, the assigned types are\nthe STS-Nc SPEs, where N = 1, 3, 12, 24, 48, 192 and 768.\nSTS-1 is equal to 51.84 Mbps.  For SDH, the assigned\ntypes are the STM-Nc VCs, where N = 1, 4, 16, 64 and 256.")
sonetPathCurrentStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 62))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathCurrentStatus.setDescription("This variable indicates the\nstatus of the interface.\nThe sonetPathCurrentStatus\nis a bit map represented\nas a sum, therefore,\nit can represent multiple defects\nsimultaneously.\nThe sonetPathNoDefect should be\nset if and only if\nno other flag is set.\n\nThe various bit positions are:\n   1   sonetPathNoDefect\n   2   sonetPathSTSLOP\n   4   sonetPathSTSAIS\n   8   sonetPathSTSRDI\n  16   sonetPathUnequipped\n  32   sonetPathSignalLabelMismatch")
sonetPathCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathCurrentESs.setDescription("The counter associated with the number of Errored\nSeconds encountered by a SONET/SDH\nPath in the current 15 minute interval.")
sonetPathCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathCurrentSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH Path in the current 15\nminute\ninterval.")
sonetPathCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathCurrentCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH Path in the current 15 minute interval.")
sonetPathCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 1, 1, 6), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathCurrentUASs.setDescription("The counter associated with the number of\nUnavailable Seconds\nencountered by a Path in the current\n15 minute interval.")
sonetPathIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2))
if mibBuilder.loadTexts: sonetPathIntervalTable.setDescription("The SONET/SDH Path Interval table.")
sonetPathIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetPathIntervalNumber"))
if mibBuilder.loadTexts: sonetPathIntervalEntry.setDescription("An entry in the SONET/SDH Path Interval table.")
sonetPathIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetPathIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetPathIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathIntervalESs.setDescription("The counter associated with the number of\nErrored Seconds encountered\nby a SONET/SDH Path in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetPathIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathIntervalSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH Path in\na particular 15-minute interval\nin the past 24 hours.")
sonetPathIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathIntervalCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH Path in a particular 15-minute interval\nin the past 24 hours.")
sonetPathIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathIntervalUASs.setDescription("The counter associated with the number of\nUnavailable Seconds\nencountered by a Path in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetPathIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 1, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetPathIntervalValidData.setDescription("This variable indicates if the data for this\n\n\n\ninterval is valid.")
sonetFarEndPath = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 2, 2))
sonetFarEndPathCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 1))
if mibBuilder.loadTexts: sonetFarEndPathCurrentTable.setDescription("The SONET/SDH Far End Path Current table.")
sonetFarEndPathCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetFarEndPathCurrentEntry.setDescription("An entry in the SONET/SDH Far End Path Current table.")
sonetFarEndPathCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 1, 1, 1), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathCurrentESs.setDescription("The counter associated with the number of Far\nEnd Errored Seconds encountered by a SONET/SDH\ninterface in the current 15 minute interval.")
sonetFarEndPathCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 1, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathCurrentSESs.setDescription("The counter associated with the number of\nFar End Severely Errored Seconds\nencountered by a SONET/SDH Path\ninterface in the current 15 minute\ninterval.")
sonetFarEndPathCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathCurrentCVs.setDescription("The counter associated with the number of\nFar End Coding Violations reported via\nthe far end block error count\nencountered by a\nSONET/SDH Path interface in\nthe current 15 minute interval.")
sonetFarEndPathCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathCurrentUASs.setDescription("The counter associated with the number of\nFar End Unavailable Seconds\nencountered by a\nSONET/SDH Path interface in\nthe current 15 minute interval.")
sonetFarEndPathIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2))
if mibBuilder.loadTexts: sonetFarEndPathIntervalTable.setDescription("The SONET/SDH Far End Path Interval table.")
sonetFarEndPathIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetFarEndPathIntervalNumber"))
if mibBuilder.loadTexts: sonetFarEndPathIntervalEntry.setDescription("An entry in the SONET/SDH Far\nEnd Path Interval table.")
sonetFarEndPathIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetFarEndPathIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\n\n\n\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetFarEndPathIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathIntervalESs.setDescription("The counter associated with the number of\nFar End Errored Seconds encountered\nby a SONET/SDH Path interface in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetFarEndPathIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathIntervalSESs.setDescription("The counter associated with the number of\nFar End Severely Errored Seconds\nencountered by a SONET/SDH Path interface\nin a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndPathIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathIntervalCVs.setDescription("The counter associated with the number of\nFar End Coding Violations reported via\nthe far end block error count\nencountered by a\nSONET/SDH Path interface\nin a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndPathIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathIntervalUASs.setDescription("The counter associated with the number of\nFar End Unavailable Seconds\nencountered by a\nSONET/SDH Path interface in\na particular 15-minute interval\nin the past 24 hours.")
sonetFarEndPathIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 2, 2, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndPathIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
sonetObjectsVT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 3))
sonetVT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 3, 1))
sonetVTCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1))
if mibBuilder.loadTexts: sonetVTCurrentTable.setDescription("The SONET/SDH VT Current table.")
sonetVTCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetVTCurrentEntry.setDescription("An entry in the SONET/SDH VT Current table.")
sonetVTCurrentWidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1, 1), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(5,2,1,4,3,)).subtype(namedValues=namedval.NamedValues(("vtWidth15VC11", 1), ("vtWidth2VC12", 2), ("vtWidth3", 3), ("vtWidth6VC2", 4), ("vtWidth6c", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sonetVTCurrentWidth.setDescription("A value that indicates the type of the SONET\nVT and SDH VC.  Assigned widths are\nVT1.5/VC11, VT2/VC12, VT3, VT6/VC2, and VT6c.")
sonetVTCurrentStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 126))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTCurrentStatus.setDescription("This variable indicates the\nstatus of the interface.\nThe sonetVTCurrentStatus\nis a bit map represented\nas a sum, therefore,\nit can represent multiple defects\nand failures\nsimultaneously.\nThe sonetVTNoDefect should be\nset if and only if\nno other flag is set.\n\nThe various bit positions are:\n   1   sonetVTNoDefect\n   2   sonetVTLOP\n   4   sonetVTPathAIS\n   8   sonetVTPathRDI\n  16   sonetVTPathRFI\n  32   sonetVTUnequipped\n  64   sonetVTSignalLabelMismatch")
sonetVTCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTCurrentESs.setDescription("The counter associated with the number of Errored\nSeconds encountered by a SONET/SDH\nVT in the current 15 minute interval.")
sonetVTCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTCurrentSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH VT in the current 15 minute\ninterval.")
sonetVTCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1, 5), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTCurrentCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH VT in the current 15 minute interval.")
sonetVTCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 1, 1, 6), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTCurrentUASs.setDescription("The counter associated with the number of\nUnavailable Seconds\nencountered by a VT in the current\n15 minute interval.")
sonetVTIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2))
if mibBuilder.loadTexts: sonetVTIntervalTable.setDescription("The SONET/SDH VT Interval table.")
sonetVTIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetVTIntervalNumber"))
if mibBuilder.loadTexts: sonetVTIntervalEntry.setDescription("An entry in the SONET/SDH VT Interval table.")
sonetVTIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetVTIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetVTIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTIntervalESs.setDescription("The counter associated with the number of\nErrored Seconds encountered\nby a SONET/SDH VT in a particular 15-minute interval\nin the past 24 hours.")
sonetVTIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTIntervalSESs.setDescription("The counter associated with the number of\nSeverely Errored Seconds\nencountered by a SONET/SDH VT\nin a particular 15-minute interval\n\n\n\nin the past 24 hours.")
sonetVTIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTIntervalCVs.setDescription("The counter associated with the number of Coding\nViolations encountered by a\nSONET/SDH VT in a particular 15-minute interval\nin the past 24 hours.")
sonetVTIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTIntervalUASs.setDescription("The counter associated with the number of\nUnavailable Seconds\nencountered by a VT in a particular 15-minute interval\nin the past 24 hours.")
sonetVTIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 1, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetVTIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
sonetFarEndVT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 3, 2))
sonetFarEndVTCurrentTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 1))
if mibBuilder.loadTexts: sonetFarEndVTCurrentTable.setDescription("The SONET/SDH Far End VT Current table.")
sonetFarEndVTCurrentEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: sonetFarEndVTCurrentEntry.setDescription("An entry in the SONET/SDH Far End VT Current table.")
sonetFarEndVTCurrentESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 1, 1, 1), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTCurrentESs.setDescription("The counter associated with the number of Far\nEnd Errored Seconds encountered by a SONET/SDH\ninterface in the current 15 minute interval.")
sonetFarEndVTCurrentSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 1, 1, 2), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTCurrentSESs.setDescription("The counter associated with the number of\nFar End Severely Errored Seconds\nencountered by a SONET/SDH VT interface\nin the current 15 minute\ninterval.")
sonetFarEndVTCurrentCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 1, 1, 3), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTCurrentCVs.setDescription("The counter associated with the number of\nFar End Coding Violations reported via\nthe far end block error count\nencountered by a\nSONET/SDH VT interface\nin the current 15 minute interval.")
sonetFarEndVTCurrentUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 1, 1, 4), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTCurrentUASs.setDescription("The counter associated with the number of\nFar End Unavailable Seconds\nencountered by a\nSONET/SDH VT interface\nin the current 15 minute interval.")
sonetFarEndVTIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2))
if mibBuilder.loadTexts: sonetFarEndVTIntervalTable.setDescription("The SONET/SDH Far End VT Interval table.")
sonetFarEndVTIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SONET-MIB", "sonetFarEndVTIntervalNumber"))
if mibBuilder.loadTexts: sonetFarEndVTIntervalEntry.setDescription("An entry in the SONET/SDH Far\nEnd VT Interval table.")
sonetFarEndVTIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: sonetFarEndVTIntervalNumber.setDescription("A number between 1 and 96, which identifies the\ninterval for which the set of statistics is available.\nThe interval identified by 1 is the most recently\ncompleted 15 minute interval,\nand the interval identified\nby N is the interval immediately preceding the\none identified\nby N-1.")
sonetFarEndVTIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTIntervalESs.setDescription("The counter associated with the number of\nFar End Errored Seconds encountered\nby a SONET/SDH VT interface\nin a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndVTIntervalSESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTIntervalSESs.setDescription("The counter associated with the number of\nFar End Severely Errored Seconds\nencountered by a SONET/SDH VT interface\nin a particular 15-minute interval\nin the past 24 hours.")
sonetFarEndVTIntervalCVs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTIntervalCVs.setDescription("The counter associated with the number of\nFar End Coding Violations reported via\nthe far end block error count\nencountered by a\nSONET/SDH VT interface in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetFarEndVTIntervalUASs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTIntervalUASs.setDescription("The counter associated with the number of\nFar End Unavailable Seconds\nencountered by a\nSONET/SDH VT interface in a\nparticular 15-minute interval\nin the past 24 hours.")
sonetFarEndVTIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 39, 3, 2, 2, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sonetFarEndVTIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
sonetConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 4))
sonetGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 4, 1))
sonetCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 39, 4, 2))

# Augmentions

# Groups

sonetMediumStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 1)).setObjects(("SONET-MIB", "sonetMediumTimeElapsed"), ("SONET-MIB", "sonetMediumValidIntervals"), ("SONET-MIB", "sonetMediumCircuitIdentifier"), ("SONET-MIB", "sonetMediumLineCoding"), ("SONET-MIB", "sonetMediumType"), ("SONET-MIB", "sonetMediumLineType"), )
if mibBuilder.loadTexts: sonetMediumStuff.setDescription("A collection of objects providing configuration\ninformation applicable to all SONET/SDH interfaces.")
sonetSectionStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 2)).setObjects(("SONET-MIB", "sonetSectionCurrentStatus"), ("SONET-MIB", "sonetSectionCurrentESs"), ("SONET-MIB", "sonetSectionCurrentSESs"), ("SONET-MIB", "sonetSectionIntervalCVs"), ("SONET-MIB", "sonetSectionIntervalESs"), ("SONET-MIB", "sonetSectionIntervalSESs"), ("SONET-MIB", "sonetSectionCurrentSEFSs"), ("SONET-MIB", "sonetSectionIntervalSEFSs"), ("SONET-MIB", "sonetSectionCurrentCVs"), )
if mibBuilder.loadTexts: sonetSectionStuff.setDescription("A collection of objects providing information\n\n\n\nspecific to SONET/SDH Section interfaces.")
sonetLineStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 3)).setObjects(("SONET-MIB", "sonetLineIntervalSESs"), ("SONET-MIB", "sonetLineIntervalCVs"), ("SONET-MIB", "sonetLineCurrentUASs"), ("SONET-MIB", "sonetLineCurrentCVs"), ("SONET-MIB", "sonetLineIntervalUASs"), ("SONET-MIB", "sonetLineCurrentStatus"), ("SONET-MIB", "sonetLineIntervalESs"), ("SONET-MIB", "sonetLineCurrentSESs"), ("SONET-MIB", "sonetLineCurrentESs"), )
if mibBuilder.loadTexts: sonetLineStuff.setDescription("A collection of objects providing information\nspecific to SONET/SDH Line interfaces.")
sonetFarEndLineStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 4)).setObjects(("SONET-MIB", "sonetFarEndLineCurrentUASs"), ("SONET-MIB", "sonetFarEndLineIntervalESs"), ("SONET-MIB", "sonetFarEndLineCurrentSESs"), ("SONET-MIB", "sonetFarEndLineIntervalSESs"), ("SONET-MIB", "sonetFarEndLineIntervalCVs"), ("SONET-MIB", "sonetFarEndLineCurrentCVs"), ("SONET-MIB", "sonetFarEndLineCurrentESs"), ("SONET-MIB", "sonetFarEndLineIntervalUASs"), )
if mibBuilder.loadTexts: sonetFarEndLineStuff.setDescription("A collection of objects providing information\nspecific to SONET/SDH Line interfaces,\nand maintaining Line Far End information.")
sonetPathStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 5)).setObjects(("SONET-MIB", "sonetPathIntervalSESs"), ("SONET-MIB", "sonetPathIntervalESs"), ("SONET-MIB", "sonetPathCurrentStatus"), ("SONET-MIB", "sonetPathCurrentCVs"), ("SONET-MIB", "sonetPathCurrentESs"), ("SONET-MIB", "sonetPathIntervalUASs"), ("SONET-MIB", "sonetPathCurrentSESs"), ("SONET-MIB", "sonetPathCurrentUASs"), ("SONET-MIB", "sonetPathCurrentWidth"), ("SONET-MIB", "sonetPathIntervalCVs"), )
if mibBuilder.loadTexts: sonetPathStuff.setDescription("A collection of objects providing information\nspecific to SONET/SDH Path interfaces.")
sonetFarEndPathStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 6)).setObjects(("SONET-MIB", "sonetFarEndPathIntervalUASs"), ("SONET-MIB", "sonetFarEndPathCurrentCVs"), ("SONET-MIB", "sonetFarEndPathIntervalESs"), ("SONET-MIB", "sonetFarEndPathCurrentSESs"), ("SONET-MIB", "sonetFarEndPathIntervalSESs"), ("SONET-MIB", "sonetFarEndPathCurrentUASs"), ("SONET-MIB", "sonetFarEndPathIntervalCVs"), ("SONET-MIB", "sonetFarEndPathCurrentESs"), )
if mibBuilder.loadTexts: sonetFarEndPathStuff.setDescription("A collection of objects providing information\nspecific to SONET/SDH Path interfaces,\nand maintaining Path Far End information.")
sonetVTStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 7)).setObjects(("SONET-MIB", "sonetVTIntervalUASs"), ("SONET-MIB", "sonetVTCurrentUASs"), ("SONET-MIB", "sonetVTCurrentCVs"), ("SONET-MIB", "sonetVTIntervalSESs"), ("SONET-MIB", "sonetVTCurrentStatus"), ("SONET-MIB", "sonetVTIntervalESs"), ("SONET-MIB", "sonetVTCurrentSESs"), ("SONET-MIB", "sonetVTIntervalCVs"), ("SONET-MIB", "sonetVTCurrentESs"), ("SONET-MIB", "sonetVTCurrentWidth"), )
if mibBuilder.loadTexts: sonetVTStuff.setDescription("A collection of objects providing information\nspecific to SONET/SDH VT interfaces.")
sonetFarEndVTStuff = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 8)).setObjects(("SONET-MIB", "sonetFarEndVTIntervalCVs"), ("SONET-MIB", "sonetFarEndVTIntervalSESs"), ("SONET-MIB", "sonetFarEndVTIntervalUASs"), ("SONET-MIB", "sonetFarEndVTCurrentESs"), ("SONET-MIB", "sonetFarEndVTIntervalESs"), ("SONET-MIB", "sonetFarEndVTCurrentSESs"), ("SONET-MIB", "sonetFarEndVTCurrentUASs"), ("SONET-MIB", "sonetFarEndVTCurrentCVs"), )
if mibBuilder.loadTexts: sonetFarEndVTStuff.setDescription("A collection of objects providing information\nspecific to SONET/SDH VT interfaces,\nand maintaining VT Far End information.")
sonetMediumStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 9)).setObjects(("SONET-MIB", "sonetMediumInvalidIntervals"), ("SONET-MIB", "sonetMediumTimeElapsed"), ("SONET-MIB", "sonetMediumLineCoding"), ("SONET-MIB", "sonetMediumCircuitIdentifier"), ("SONET-MIB", "sonetMediumValidIntervals"), ("SONET-MIB", "sonetSESthresholdSet"), ("SONET-MIB", "sonetMediumType"), ("SONET-MIB", "sonetMediumLoopbackConfig"), ("SONET-MIB", "sonetMediumLineType"), )
if mibBuilder.loadTexts: sonetMediumStuff2.setDescription("A collection of objects providing configuration\ninformation applicable to all SONET/SDH interfaces.")
sonetSectionStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 10)).setObjects(("SONET-MIB", "sonetSectionCurrentStatus"), ("SONET-MIB", "sonetSectionCurrentESs"), ("SONET-MIB", "sonetSectionCurrentSESs"), ("SONET-MIB", "sonetSectionIntervalCVs"), ("SONET-MIB", "sonetSectionIntervalESs"), ("SONET-MIB", "sonetSectionIntervalSESs"), ("SONET-MIB", "sonetSectionCurrentSEFSs"), ("SONET-MIB", "sonetSectionIntervalSEFSs"), ("SONET-MIB", "sonetSectionCurrentCVs"), ("SONET-MIB", "sonetSectionIntervalValidData"), )
if mibBuilder.loadTexts: sonetSectionStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH Section interfaces.")
sonetLineStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 11)).setObjects(("SONET-MIB", "sonetLineIntervalSESs"), ("SONET-MIB", "sonetLineIntervalCVs"), ("SONET-MIB", "sonetLineCurrentUASs"), ("SONET-MIB", "sonetLineCurrentCVs"), ("SONET-MIB", "sonetLineIntervalUASs"), ("SONET-MIB", "sonetLineCurrentStatus"), ("SONET-MIB", "sonetLineIntervalESs"), ("SONET-MIB", "sonetLineCurrentSESs"), ("SONET-MIB", "sonetLineCurrentESs"), ("SONET-MIB", "sonetLineIntervalValidData"), )
if mibBuilder.loadTexts: sonetLineStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH Line interfaces.")
sonetPathStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 12)).setObjects(("SONET-MIB", "sonetPathIntervalSESs"), ("SONET-MIB", "sonetPathCurrentStatus"), ("SONET-MIB", "sonetPathCurrentSESs"), ("SONET-MIB", "sonetPathCurrentUASs"), ("SONET-MIB", "sonetPathCurrentWidth"), ("SONET-MIB", "sonetPathIntervalESs"), ("SONET-MIB", "sonetPathIntervalCVs"), ("SONET-MIB", "sonetPathCurrentCVs"), ("SONET-MIB", "sonetPathIntervalValidData"), ("SONET-MIB", "sonetPathIntervalUASs"), ("SONET-MIB", "sonetPathCurrentESs"), )
if mibBuilder.loadTexts: sonetPathStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH Path interfaces.")
sonetVTStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 13)).setObjects(("SONET-MIB", "sonetVTCurrentCVs"), ("SONET-MIB", "sonetVTIntervalValidData"), ("SONET-MIB", "sonetVTIntervalCVs"), ("SONET-MIB", "sonetVTIntervalESs"), ("SONET-MIB", "sonetVTCurrentUASs"), ("SONET-MIB", "sonetVTCurrentStatus"), ("SONET-MIB", "sonetVTCurrentSESs"), ("SONET-MIB", "sonetVTCurrentWidth"), ("SONET-MIB", "sonetVTIntervalUASs"), ("SONET-MIB", "sonetVTIntervalSESs"), ("SONET-MIB", "sonetVTCurrentESs"), )
if mibBuilder.loadTexts: sonetVTStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH VT interfaces.")
sonetFarEndLineStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 14)).setObjects(("SONET-MIB", "sonetFarEndLineCurrentUASs"), ("SONET-MIB", "sonetFarEndLineIntervalESs"), ("SONET-MIB", "sonetFarEndLineCurrentSESs"), ("SONET-MIB", "sonetFarEndLineIntervalSESs"), ("SONET-MIB", "sonetFarEndLineIntervalCVs"), ("SONET-MIB", "sonetFarEndLineCurrentCVs"), ("SONET-MIB", "sonetFarEndLineIntervalValidData"), ("SONET-MIB", "sonetFarEndLineCurrentESs"), ("SONET-MIB", "sonetFarEndLineIntervalUASs"), )
if mibBuilder.loadTexts: sonetFarEndLineStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH Line interfaces,\nand maintaining Line Far End information.")
sonetFarEndPathStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 15)).setObjects(("SONET-MIB", "sonetFarEndPathIntervalUASs"), ("SONET-MIB", "sonetFarEndPathCurrentCVs"), ("SONET-MIB", "sonetFarEndPathIntervalValidData"), ("SONET-MIB", "sonetFarEndPathIntervalESs"), ("SONET-MIB", "sonetFarEndPathCurrentSESs"), ("SONET-MIB", "sonetFarEndPathIntervalSESs"), ("SONET-MIB", "sonetFarEndPathCurrentUASs"), ("SONET-MIB", "sonetFarEndPathIntervalCVs"), ("SONET-MIB", "sonetFarEndPathCurrentESs"), )
if mibBuilder.loadTexts: sonetFarEndPathStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH Path interfaces,\nand maintaining Path Far End information.")
sonetFarEndVTStuff2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 39, 4, 1, 16)).setObjects(("SONET-MIB", "sonetFarEndVTIntervalCVs"), ("SONET-MIB", "sonetFarEndVTIntervalSESs"), ("SONET-MIB", "sonetFarEndVTIntervalUASs"), ("SONET-MIB", "sonetFarEndVTIntervalValidData"), ("SONET-MIB", "sonetFarEndVTCurrentESs"), ("SONET-MIB", "sonetFarEndVTIntervalESs"), ("SONET-MIB", "sonetFarEndVTCurrentSESs"), ("SONET-MIB", "sonetFarEndVTCurrentUASs"), ("SONET-MIB", "sonetFarEndVTCurrentCVs"), )
if mibBuilder.loadTexts: sonetFarEndVTStuff2.setDescription("A collection of objects providing information\nspecific to SONET/SDH VT interfaces,\nand maintaining VT Far End information.")

# Compliances

sonetCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 39, 4, 2, 1)).setObjects(("SONET-MIB", "sonetFarEndVTStuff"), ("SONET-MIB", "sonetSectionStuff"), ("SONET-MIB", "sonetFarEndPathStuff"), ("SONET-MIB", "sonetPathStuff"), ("SONET-MIB", "sonetMediumStuff"), ("SONET-MIB", "sonetVTStuff"), ("SONET-MIB", "sonetLineStuff"), ("SONET-MIB", "sonetFarEndLineStuff"), )
if mibBuilder.loadTexts: sonetCompliance.setDescription("The compliance statement for SONET/SDH interfaces.")
sonetCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 39, 4, 2, 2)).setObjects(("SONET-MIB", "sonetVTStuff2"), ("SONET-MIB", "sonetFarEndPathStuff2"), ("SONET-MIB", "sonetLineStuff2"), ("SONET-MIB", "sonetFarEndLineStuff2"), ("SONET-MIB", "sonetSectionStuff2"), ("SONET-MIB", "sonetFarEndVTStuff2"), ("SONET-MIB", "sonetMediumStuff2"), ("SONET-MIB", "sonetPathStuff2"), )
if mibBuilder.loadTexts: sonetCompliance2.setDescription("The compliance statement for SONET/SDH interfaces.")

# Exports

# Module identity
mibBuilder.exportSymbols("SONET-MIB", PYSNMP_MODULE_ID=sonetMIB)

# Objects
mibBuilder.exportSymbols("SONET-MIB", sonetMIB=sonetMIB, sonetObjects=sonetObjects, sonetMedium=sonetMedium, sonetMediumTable=sonetMediumTable, sonetMediumEntry=sonetMediumEntry, sonetMediumType=sonetMediumType, sonetMediumTimeElapsed=sonetMediumTimeElapsed, sonetMediumValidIntervals=sonetMediumValidIntervals, sonetMediumLineCoding=sonetMediumLineCoding, sonetMediumLineType=sonetMediumLineType, sonetMediumCircuitIdentifier=sonetMediumCircuitIdentifier, sonetMediumInvalidIntervals=sonetMediumInvalidIntervals, sonetMediumLoopbackConfig=sonetMediumLoopbackConfig, sonetSESthresholdSet=sonetSESthresholdSet, sonetSection=sonetSection, sonetSectionCurrentTable=sonetSectionCurrentTable, sonetSectionCurrentEntry=sonetSectionCurrentEntry, sonetSectionCurrentStatus=sonetSectionCurrentStatus, sonetSectionCurrentESs=sonetSectionCurrentESs, sonetSectionCurrentSESs=sonetSectionCurrentSESs, sonetSectionCurrentSEFSs=sonetSectionCurrentSEFSs, sonetSectionCurrentCVs=sonetSectionCurrentCVs, sonetSectionIntervalTable=sonetSectionIntervalTable, sonetSectionIntervalEntry=sonetSectionIntervalEntry, sonetSectionIntervalNumber=sonetSectionIntervalNumber, sonetSectionIntervalESs=sonetSectionIntervalESs, sonetSectionIntervalSESs=sonetSectionIntervalSESs, sonetSectionIntervalSEFSs=sonetSectionIntervalSEFSs, sonetSectionIntervalCVs=sonetSectionIntervalCVs, sonetSectionIntervalValidData=sonetSectionIntervalValidData, sonetLine=sonetLine, sonetLineCurrentTable=sonetLineCurrentTable, sonetLineCurrentEntry=sonetLineCurrentEntry, sonetLineCurrentStatus=sonetLineCurrentStatus, sonetLineCurrentESs=sonetLineCurrentESs, sonetLineCurrentSESs=sonetLineCurrentSESs, sonetLineCurrentCVs=sonetLineCurrentCVs, sonetLineCurrentUASs=sonetLineCurrentUASs, sonetLineIntervalTable=sonetLineIntervalTable, sonetLineIntervalEntry=sonetLineIntervalEntry, sonetLineIntervalNumber=sonetLineIntervalNumber, sonetLineIntervalESs=sonetLineIntervalESs, sonetLineIntervalSESs=sonetLineIntervalSESs, sonetLineIntervalCVs=sonetLineIntervalCVs, sonetLineIntervalUASs=sonetLineIntervalUASs, sonetLineIntervalValidData=sonetLineIntervalValidData, sonetFarEndLine=sonetFarEndLine, sonetFarEndLineCurrentTable=sonetFarEndLineCurrentTable, sonetFarEndLineCurrentEntry=sonetFarEndLineCurrentEntry, sonetFarEndLineCurrentESs=sonetFarEndLineCurrentESs, sonetFarEndLineCurrentSESs=sonetFarEndLineCurrentSESs, sonetFarEndLineCurrentCVs=sonetFarEndLineCurrentCVs, sonetFarEndLineCurrentUASs=sonetFarEndLineCurrentUASs, sonetFarEndLineIntervalTable=sonetFarEndLineIntervalTable, sonetFarEndLineIntervalEntry=sonetFarEndLineIntervalEntry, sonetFarEndLineIntervalNumber=sonetFarEndLineIntervalNumber, sonetFarEndLineIntervalESs=sonetFarEndLineIntervalESs, sonetFarEndLineIntervalSESs=sonetFarEndLineIntervalSESs, sonetFarEndLineIntervalCVs=sonetFarEndLineIntervalCVs, sonetFarEndLineIntervalUASs=sonetFarEndLineIntervalUASs, sonetFarEndLineIntervalValidData=sonetFarEndLineIntervalValidData, sonetObjectsPath=sonetObjectsPath, sonetPath=sonetPath, sonetPathCurrentTable=sonetPathCurrentTable, sonetPathCurrentEntry=sonetPathCurrentEntry, sonetPathCurrentWidth=sonetPathCurrentWidth, sonetPathCurrentStatus=sonetPathCurrentStatus, sonetPathCurrentESs=sonetPathCurrentESs, sonetPathCurrentSESs=sonetPathCurrentSESs, sonetPathCurrentCVs=sonetPathCurrentCVs, sonetPathCurrentUASs=sonetPathCurrentUASs, sonetPathIntervalTable=sonetPathIntervalTable, sonetPathIntervalEntry=sonetPathIntervalEntry, sonetPathIntervalNumber=sonetPathIntervalNumber, sonetPathIntervalESs=sonetPathIntervalESs, sonetPathIntervalSESs=sonetPathIntervalSESs, sonetPathIntervalCVs=sonetPathIntervalCVs, sonetPathIntervalUASs=sonetPathIntervalUASs, sonetPathIntervalValidData=sonetPathIntervalValidData, sonetFarEndPath=sonetFarEndPath, sonetFarEndPathCurrentTable=sonetFarEndPathCurrentTable, sonetFarEndPathCurrentEntry=sonetFarEndPathCurrentEntry, sonetFarEndPathCurrentESs=sonetFarEndPathCurrentESs, sonetFarEndPathCurrentSESs=sonetFarEndPathCurrentSESs, sonetFarEndPathCurrentCVs=sonetFarEndPathCurrentCVs, sonetFarEndPathCurrentUASs=sonetFarEndPathCurrentUASs, sonetFarEndPathIntervalTable=sonetFarEndPathIntervalTable, sonetFarEndPathIntervalEntry=sonetFarEndPathIntervalEntry, sonetFarEndPathIntervalNumber=sonetFarEndPathIntervalNumber, sonetFarEndPathIntervalESs=sonetFarEndPathIntervalESs, sonetFarEndPathIntervalSESs=sonetFarEndPathIntervalSESs, sonetFarEndPathIntervalCVs=sonetFarEndPathIntervalCVs, sonetFarEndPathIntervalUASs=sonetFarEndPathIntervalUASs, sonetFarEndPathIntervalValidData=sonetFarEndPathIntervalValidData, sonetObjectsVT=sonetObjectsVT, sonetVT=sonetVT, sonetVTCurrentTable=sonetVTCurrentTable, sonetVTCurrentEntry=sonetVTCurrentEntry, sonetVTCurrentWidth=sonetVTCurrentWidth, sonetVTCurrentStatus=sonetVTCurrentStatus, sonetVTCurrentESs=sonetVTCurrentESs, sonetVTCurrentSESs=sonetVTCurrentSESs, sonetVTCurrentCVs=sonetVTCurrentCVs, sonetVTCurrentUASs=sonetVTCurrentUASs, sonetVTIntervalTable=sonetVTIntervalTable, sonetVTIntervalEntry=sonetVTIntervalEntry, sonetVTIntervalNumber=sonetVTIntervalNumber, sonetVTIntervalESs=sonetVTIntervalESs, sonetVTIntervalSESs=sonetVTIntervalSESs, sonetVTIntervalCVs=sonetVTIntervalCVs, sonetVTIntervalUASs=sonetVTIntervalUASs, sonetVTIntervalValidData=sonetVTIntervalValidData, sonetFarEndVT=sonetFarEndVT, sonetFarEndVTCurrentTable=sonetFarEndVTCurrentTable, sonetFarEndVTCurrentEntry=sonetFarEndVTCurrentEntry, sonetFarEndVTCurrentESs=sonetFarEndVTCurrentESs, sonetFarEndVTCurrentSESs=sonetFarEndVTCurrentSESs, sonetFarEndVTCurrentCVs=sonetFarEndVTCurrentCVs, sonetFarEndVTCurrentUASs=sonetFarEndVTCurrentUASs, sonetFarEndVTIntervalTable=sonetFarEndVTIntervalTable, sonetFarEndVTIntervalEntry=sonetFarEndVTIntervalEntry, sonetFarEndVTIntervalNumber=sonetFarEndVTIntervalNumber, sonetFarEndVTIntervalESs=sonetFarEndVTIntervalESs, sonetFarEndVTIntervalSESs=sonetFarEndVTIntervalSESs, sonetFarEndVTIntervalCVs=sonetFarEndVTIntervalCVs, sonetFarEndVTIntervalUASs=sonetFarEndVTIntervalUASs)
mibBuilder.exportSymbols("SONET-MIB", sonetFarEndVTIntervalValidData=sonetFarEndVTIntervalValidData, sonetConformance=sonetConformance, sonetGroups=sonetGroups, sonetCompliances=sonetCompliances)

# Groups
mibBuilder.exportSymbols("SONET-MIB", sonetMediumStuff=sonetMediumStuff, sonetSectionStuff=sonetSectionStuff, sonetLineStuff=sonetLineStuff, sonetFarEndLineStuff=sonetFarEndLineStuff, sonetPathStuff=sonetPathStuff, sonetFarEndPathStuff=sonetFarEndPathStuff, sonetVTStuff=sonetVTStuff, sonetFarEndVTStuff=sonetFarEndVTStuff, sonetMediumStuff2=sonetMediumStuff2, sonetSectionStuff2=sonetSectionStuff2, sonetLineStuff2=sonetLineStuff2, sonetPathStuff2=sonetPathStuff2, sonetVTStuff2=sonetVTStuff2, sonetFarEndLineStuff2=sonetFarEndLineStuff2, sonetFarEndPathStuff2=sonetFarEndPathStuff2, sonetFarEndVTStuff2=sonetFarEndVTStuff2)

# Compliances
mibBuilder.exportSymbols("SONET-MIB", sonetCompliance=sonetCompliance, sonetCompliance2=sonetCompliance2)
