# PySNMP SMI module. Autogenerated from smidump -f python TOKEN-RING-RMON-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:22 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( EntryStatus, OwnerString, history, rmon, statistics, ) = mibBuilder.importSymbols("RFC1271-MIB", "EntryStatus", "OwnerString", "history", "rmon", "statistics")
( Bits, Counter32, Integer32, Integer32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks")

# Types

class MacAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+constraint.ValueSizeConstraint(6,6)
    fixedLength = 6
    
class TimeInterval(Integer32):
    pass


# Objects

tokenRingMLStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 1, 2))
if mibBuilder.loadTexts: tokenRingMLStatsTable.setDescription("A list of Mac-Layer Token Ring statistics\nentries.")
tokenRingMLStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 1, 2, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "tokenRingMLStatsIndex"))
if mibBuilder.loadTexts: tokenRingMLStatsEntry.setDescription("A collection of Mac-Layer statistics kept for a\nparticular Token Ring interface.")
tokenRingMLStatsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsIndex.setDescription("The value of this object uniquely identifies this\ntokenRingMLStats entry.")
tokenRingMLStatsDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tokenRingMLStatsDataSource.setDescription("This object identifies the source of the data\nthat this tokenRingMLStats entry is configured to\nanalyze.  This source can be any tokenRing\ninterface on this device.  In order to identify a\nparticular interface, this object shall identify\nthe instance of the ifIndex object, defined in\nMIB-II [3], for the desired interface.  For\nexample, if an entry were to receive data from\ninterface #1, this object would be set to\nifIndex.1.\n\nThe statistics in this group reflect all error\nreports on the local network segment attached to\nthe identified interface.\n\nThis object may not be modified if the associated\ntokenRingMLStatsStatus object is equal to\nvalid(1).")
tokenRingMLStatsDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsDropEvents.setDescription("The total number of events in which packets were\ndropped by the probe due to lack of resources.\nNote that this number is not necessarily the\nnumber of packets dropped; it is just the number\nof times this condition has been detected.  This\nvalue is the same as the corresponding\ntokenRingPStatsDropEvents.")
tokenRingMLStatsMacOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsMacOctets.setDescription("The total number of octets of data in MAC packets\n(excluding those that were not good frames)\nreceived on the network (excluding framing bits\nbut including FCS octets).")
tokenRingMLStatsMacPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsMacPkts.setDescription("The total number of MAC packets (excluding\npackets that were not good frames) received.")
tokenRingMLStatsRingPurgeEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsRingPurgeEvents.setDescription("The total number of times that the ring enters\nthe ring purge state from normal ring state.  The\nring purge state that comes in response to the\nclaim token or beacon state is not counted.")
tokenRingMLStatsRingPurgePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsRingPurgePkts.setDescription("The total number of ring purge MAC packets\ndetected by probe.")
tokenRingMLStatsBeaconEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsBeaconEvents.setDescription("The total number of times that the ring enters a\nbeaconing state (beaconFrameStreamingState,\nbeaconBitStreamingState,\nbeaconSetRecoveryModeState, or\nbeaconRingSignalLossState) from a non-beaconing\nstate.  Note that a change of the source address\nof the beacon packet does not constitute a new\nbeacon event.")
tokenRingMLStatsBeaconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 9), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsBeaconTime.setDescription("The total amount of time that the ring has been\nin the beaconing state.")
tokenRingMLStatsBeaconPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsBeaconPkts.setDescription("The total number of beacon MAC packets detected\nby the probe.")
tokenRingMLStatsClaimTokenEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsClaimTokenEvents.setDescription("The total number of times that the ring enters\nthe claim token state from normal ring state or\nring purge state.  The claim token state that\ncomes in response to a beacon state is not\ncounted.")
tokenRingMLStatsClaimTokenPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsClaimTokenPkts.setDescription("The total number of claim token MAC packets\ndetected by the probe.")
tokenRingMLStatsNAUNChanges = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsNAUNChanges.setDescription("The total number of NAUN changes detected by the\nprobe.")
tokenRingMLStatsLineErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsLineErrors.setDescription("The total number of line errors reported in error\nreporting packets detected by the probe.")
tokenRingMLStatsInternalErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsInternalErrors.setDescription("The total number of adapter internal errors\nreported in error reporting packets detected by\nthe probe.")
tokenRingMLStatsBurstErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsBurstErrors.setDescription("The total number of burst errors reported in\nerror reporting packets detected by the probe.")
tokenRingMLStatsACErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsACErrors.setDescription("The total number of AC (Address Copied)  errors\nreported in error reporting packets detected by\nthe probe.")
tokenRingMLStatsAbortErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsAbortErrors.setDescription("The total number of abort delimiters reported in\nerror reporting packets detected by the probe.")
tokenRingMLStatsLostFrameErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsLostFrameErrors.setDescription("The total number of lost frame errors reported in\nerror reporting packets detected by the probe.")
tokenRingMLStatsCongestionErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsCongestionErrors.setDescription("The total number of receive congestion errors\nreported in error reporting packets detected by\nthe probe.")
tokenRingMLStatsFrameCopiedErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsFrameCopiedErrors.setDescription("The total number of frame copied errors reported\nin error reporting packets detected by the probe.")
tokenRingMLStatsFrequencyErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsFrequencyErrors.setDescription("The total number of frequency errors reported in\nerror reporting packets detected by the probe.")
tokenRingMLStatsTokenErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsTokenErrors.setDescription("The total number of token errors reported in\nerror reporting packets detected by the probe.")
tokenRingMLStatsSoftErrorReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsSoftErrorReports.setDescription("The total number of soft error report frames\ndetected by the probe.")
tokenRingMLStatsRingPollEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLStatsRingPollEvents.setDescription("The total number of ring poll events detected by\nthe probe (i.e. the number of ring polls initiated\nby the active monitor that were detected).")
tokenRingMLStatsOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 26), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tokenRingMLStatsOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
tokenRingMLStatsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 2, 1, 27), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tokenRingMLStatsStatus.setDescription("The status of this tokenRingMLStats entry.")
tokenRingPStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 1, 3))
if mibBuilder.loadTexts: tokenRingPStatsTable.setDescription("A list of promiscuous Token Ring statistics\nentries.")
tokenRingPStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 1, 3, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "tokenRingPStatsIndex"))
if mibBuilder.loadTexts: tokenRingPStatsEntry.setDescription("A collection of promiscuous statistics kept for\nnon-MAC packets on a particular Token Ring\ninterface.")
tokenRingPStatsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsIndex.setDescription("The value of this object uniquely identifies this\ntokenRingPStats entry.")
tokenRingPStatsDataSource = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 2), ObjectIdentifier()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tokenRingPStatsDataSource.setDescription("This object identifies the source of the data\nthat this tokenRingPStats entry is configured to\nanalyze.  This source can be any tokenRing\ninterface on this device.  In order to identify a\nparticular interface, this object shall identify\nthe instance of the ifIndex object, defined in\nMIB-II [3], for the desired interface.  For\nexample, if an entry were to receive data from\ninterface #1, this object would be set to\nifIndex.1.\n\nThe statistics in this group reflect all non-MAC\npackets on the local network segment attached to\nthe identified interface.\n\nThis object may not be modified if the associated\ntokenRingPStatsStatus object is equal to\nvalid(1).")
tokenRingPStatsDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDropEvents.setDescription("The total number of events in which packets were\ndropped by the probe due to lack of resources.\nNote that this number is not necessarily the\nnumber of packets dropped; it is just the number\nof times this condition has been detected.  This\nvalue is the same as the corresponding\ntokenRingMLStatsDropEvents")
tokenRingPStatsDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataOctets.setDescription("The total number of octets of data in good frames\nreceived on the network (excluding framing bits\nbut including FCS octets) in non-MAC packets.")
tokenRingPStatsDataPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts.setDescription("The total number of non-MAC packets in good\nframes.  received.")
tokenRingPStatsDataBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataBroadcastPkts.setDescription("The total number of good non-MAC frames received\nthat were directed to an LLC broadcast address\n(0xFFFFFFFFFFFF or 0xC000FFFFFFFF).")
tokenRingPStatsDataMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataMulticastPkts.setDescription("The total number of good non-MAC frames received\nthat were directed to a local or global multicast\nor functional address.  Note that this number does\nnot include packets directed to the broadcast\naddress.")
tokenRingPStatsDataPkts18to63Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts18to63Octets.setDescription("The total number of good non-MAC frames received\nthat were between 18 and 63 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts64to127Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts64to127Octets.setDescription("The total number of good non-MAC frames received\nthat were between 64 and 127 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts128to255Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts128to255Octets.setDescription("The total number of good non-MAC frames received\nthat were between 128 and 255 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts256to511Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts256to511Octets.setDescription("The total number of good non-MAC frames received\nthat were between 256 and 511 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts512to1023Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts512to1023Octets.setDescription("The total number of good non-MAC frames received\nthat were between 512 and 1023 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts1024to2047Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts1024to2047Octets.setDescription("The total number of good non-MAC frames received\nthat were between 1024 and 2047 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts2048to4095Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts2048to4095Octets.setDescription("The total number of good non-MAC frames received\nthat were between 2048 and 4095 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts4096to8191Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts4096to8191Octets.setDescription("The total number of good non-MAC frames received\nthat were between 4096 and 8191 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPkts8192to18000Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPkts8192to18000Octets.setDescription("The total number of good non-MAC frames received\nthat were between 8192 and 18000 octets in length\ninclusive, excluding framing bits but including\nFCS octets.")
tokenRingPStatsDataPktsGreaterThan18000Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPStatsDataPktsGreaterThan18000Octets.setDescription("The total number of good non-MAC frames received\nthat were greater than 18000 octets in length,\nexcluding framing bits but including FCS octets.")
tokenRingPStatsOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 18), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tokenRingPStatsOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
tokenRingPStatsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 1, 3, 1, 19), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tokenRingPStatsStatus.setDescription("The status of this tokenRingPStats entry.")
tokenRingMLHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 3))
if mibBuilder.loadTexts: tokenRingMLHistoryTable.setDescription("A list of Mac-Layer Token Ring statistics\nentries.")
tokenRingMLHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 3, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "tokenRingMLHistoryIndex"), (0, "TOKEN-RING-RMON-MIB", "tokenRingMLHistorySampleIndex"))
if mibBuilder.loadTexts: tokenRingMLHistoryEntry.setDescription("A collection of Mac-Layer statistics kept for a\nparticular Token Ring interface.")
tokenRingMLHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryIndex.setDescription("The history of which this entry is a part.  The\nhistory identified by a particular value of this\nindex is the same history as identified by the\nsame value of historyControlIndex.")
tokenRingMLHistorySampleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistorySampleIndex.setDescription("An index that uniquely identifies the particular\nMac-Layer sample this entry represents among all\nMac-Layer samples associated with the same\nhistoryControlEntry.  This index starts at 1 and\nincreases by one as each new sample is taken.")
tokenRingMLHistoryIntervalStart = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryIntervalStart.setDescription("The value of sysUpTime at the start of the\ninterval over which this sample was measured.  If\nthe probe keeps track of the time of day, it\nshould start the first sample of the history at a\ntime such that when the next hour of the day\nbegins, a sample is started at that instant.  Note\nthat following this rule may require the probe to\ndelay collecting the first sample of the history,\nas each sample must be of the same interval.  Also\nnote that the sample which is currently being\ncollected is not accessible in this table until\nthe end of its interval.")
tokenRingMLHistoryDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryDropEvents.setDescription("The total number of events in which packets were\ndropped by the probe due to lack of resources\nduring this sampling interval.  Note that this\nnumber is not necessarily the number of packets\ndropped, it is just the number of times this\ncondition has been detected.")
tokenRingMLHistoryMacOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryMacOctets.setDescription("The total number of octets of data in MAC packets\n(excluding those that were not good frames)\nreceived on the network during this sampling\ninterval (excluding framing bits but including FCS\noctets).")
tokenRingMLHistoryMacPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryMacPkts.setDescription("The total number of MAC packets (excluding those\nthat were not good frames) received during this\nsampling interval.")
tokenRingMLHistoryRingPurgeEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryRingPurgeEvents.setDescription("The total number of times that the ring entered\nthe ring purge state from normal ring state during\nthis sampling interval.  The ring purge state that\ncomes from the claim token or beacon state is not\ncounted.")
tokenRingMLHistoryRingPurgePkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryRingPurgePkts.setDescription("The total number of Ring Purge MAC packets\ndetected by the probe during this sampling\ninterval.")
tokenRingMLHistoryBeaconEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryBeaconEvents.setDescription("The total number of times that the ring enters a\nbeaconing state (beaconFrameStreamingState,\nbeaconBitStreamingState,\nbeaconSetRecoveryModeState, or\nbeaconRingSignalLossState) during this sampling\ninterval.  Note that a change of the source\naddress of the beacon packet does not constitute a\nnew beacon event.")
tokenRingMLHistoryBeaconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 10), TimeInterval()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryBeaconTime.setDescription("The amount of time that the ring has been in the\nbeaconing state during this sampling interval.")
tokenRingMLHistoryBeaconPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryBeaconPkts.setDescription("The total number of beacon MAC packets detected\nby the probe during this sampling interval.")
tokenRingMLHistoryClaimTokenEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryClaimTokenEvents.setDescription("The total number of times that the ring enters\nthe claim token state from normal ring state or\nring purge state during this sampling interval.\nThe claim token state that comes from the beacon\nstate is not counted.")
tokenRingMLHistoryClaimTokenPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryClaimTokenPkts.setDescription("The total number of claim token MAC packets\ndetected by the probe during this sampling\ninterval.")
tokenRingMLHistoryNAUNChanges = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryNAUNChanges.setDescription("The total number of NAUN changes detected by the\nprobe during this sampling interval.")
tokenRingMLHistoryLineErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryLineErrors.setDescription("The total number of line errors reported in error\nreporting packets detected by the probe during\nthis sampling interval.")
tokenRingMLHistoryInternalErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryInternalErrors.setDescription("The total number of adapter internal errors\nreported in error reporting packets detected by\nthe probe during this sampling interval.")
tokenRingMLHistoryBurstErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryBurstErrors.setDescription("The total number of burst errors reported in\nerror reporting packets detected by the probe\nduring this sampling interval.")
tokenRingMLHistoryACErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryACErrors.setDescription("The total number of AC (Address Copied) errors\nreported in error reporting packets detected by\nthe probe during this sampling interval.")
tokenRingMLHistoryAbortErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryAbortErrors.setDescription("The total number of abort delimiters reported in\nerror reporting packets detected by the probe\nduring this sampling interval.")
tokenRingMLHistoryLostFrameErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryLostFrameErrors.setDescription("The total number of lost frame errors reported in\nerror reporting packets detected by the probe\nduring this sampling interval.")
tokenRingMLHistoryCongestionErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryCongestionErrors.setDescription("The total number of receive congestion errors\nreported in error reporting packets detected by\nthe probe during this sampling interval.")
tokenRingMLHistoryFrameCopiedErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryFrameCopiedErrors.setDescription("The total number of frame copied errors reported\nin error reporting packets detected by the probe\nduring this sampling interval.")
tokenRingMLHistoryFrequencyErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryFrequencyErrors.setDescription("The total number of frequency errors reported in\nerror reporting packets detected by the probe\nduring this sampling interval.")
tokenRingMLHistoryTokenErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryTokenErrors.setDescription("The total number of token errors reported in\nerror reporting packets detected by the probe\nduring this sampling interval.")
tokenRingMLHistorySoftErrorReports = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistorySoftErrorReports.setDescription("The total number of soft error report frames\ndetected by the probe during this sampling\ninterval.")
tokenRingMLHistoryRingPollEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryRingPollEvents.setDescription("The total number of ring poll events detected by\nthe probe during this sampling interval.")
tokenRingMLHistoryActiveStations = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 3, 1, 27), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingMLHistoryActiveStations.setDescription("The maximum number of active stations on the ring\ndetected by the probe during this sampling\ninterval.")
tokenRingPHistoryTable = MibTable((1, 3, 6, 1, 2, 1, 16, 2, 4))
if mibBuilder.loadTexts: tokenRingPHistoryTable.setDescription("A list of promiscuous Token Ring statistics\nentries.")
tokenRingPHistoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 2, 4, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "tokenRingPHistoryIndex"), (0, "TOKEN-RING-RMON-MIB", "tokenRingPHistorySampleIndex"))
if mibBuilder.loadTexts: tokenRingPHistoryEntry.setDescription("A collection of promiscuous statistics kept for a\nparticular Token Ring interface.")
tokenRingPHistoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryIndex.setDescription("The history of which this entry is a part.  The\nhistory identified by a particular value of this\nindex is the same history as identified by the\nsame value of historyControlIndex.")
tokenRingPHistorySampleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistorySampleIndex.setDescription("An index that uniquely identifies the particular\nsample this entry represents among all samples\nassociated with the same historyControlEntry.\nThis index starts at 1 and increases by one as\neach new sample is taken.")
tokenRingPHistoryIntervalStart = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryIntervalStart.setDescription("The value of sysUpTime at the start of the\ninterval over which this sample was measured.  If\nthe probe keeps track of the time of day, it\nshould start the first sample of the history at a\ntime such that when the next hour of the day\nbegins, a sample is started at that instant.  Note\nthat following this rule may require the probe to\ndelay collecting the first sample of the history,\nas each sample must be of the same interval.  Also\nnote that the sample which is currently being\ncollected is not accessible in this table until\nthe end of its interval.")
tokenRingPHistoryDropEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDropEvents.setDescription("The total number of events in which packets were\ndropped by the probe due to lack of resources\nduring this sampling interval.  Note that this\nnumber is not necessarily the number of packets\ndropped, it is just the number of times this\ncondition has been detected.")
tokenRingPHistoryDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataOctets.setDescription("The total number of octets of data in good frames\nreceived on the network (excluding framing bits\nbut including FCS octets) in non-MAC packets\nduring this sampling interval.")
tokenRingPHistoryDataPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts.setDescription("The total number of good non-MAC frames received\nduring this sampling interval.")
tokenRingPHistoryDataBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataBroadcastPkts.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were directed\nto an LLC broadcast address (0xFFFFFFFFFFFF or\n0xC000FFFFFFFF).")
tokenRingPHistoryDataMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataMulticastPkts.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were directed\nto a local or global multicast or functional\naddress.  Note that this number does not include\npackets directed to the broadcast address.")
tokenRingPHistoryDataPkts18to63Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts18to63Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between 18\nand 63 octets in length inclusive, excluding\nframing bits but including FCS octets.")
tokenRingPHistoryDataPkts64to127Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts64to127Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between 64\nand 127 octets in length inclusive, excluding\nframing bits but including FCS octets.")
tokenRingPHistoryDataPkts128to255Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts128to255Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n128 and 255 octets in length inclusive, excluding\nframing bits but including FCS octets.")
tokenRingPHistoryDataPkts256to511Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts256to511Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n256 and 511 octets in length inclusive, excluding\nframing bits but including FCS octets.")
tokenRingPHistoryDataPkts512to1023Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts512to1023Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n512 and 1023 octets in length inclusive, excluding\nframing bits but including FCS octets.")
tokenRingPHistoryDataPkts1024to2047Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts1024to2047Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n1024 and 2047 octets in length inclusive,\nexcluding framing bits but including FCS octets.")
tokenRingPHistoryDataPkts2048to4095Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts2048to4095Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n2048 and 4095 octets in length inclusive,\nexcluding framing bits but including FCS octets.")
tokenRingPHistoryDataPkts4096to8191Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts4096to8191Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n4096 and 8191 octets in length inclusive,\nexcluding framing bits but including FCS octets.")
tokenRingPHistoryDataPkts8192to18000Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPkts8192to18000Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were between\n8192 and 18000 octets in length inclusive,\nexcluding framing bits but including FCS octets.")
tokenRingPHistoryDataPktsGreaterThan18000Octets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 2, 4, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tokenRingPHistoryDataPktsGreaterThan18000Octets.setDescription("The total number of good non-MAC frames received\nduring this sampling interval that were greater\nthan 18000 octets in length, excluding framing\nbits but including FCS octets.")
tokenRing = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 10))
ringStationControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 10, 1))
if mibBuilder.loadTexts: ringStationControlTable.setDescription("A list of ringStation table control entries.")
ringStationControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 10, 1, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "ringStationControlIfIndex"))
if mibBuilder.loadTexts: ringStationControlEntry.setDescription("A list of parameters that set up the discovery of\nstations on a particular interface and the\ncollection of statistics about these stations.")
ringStationControlIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 1), Integer32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device\nfrom which ringStation data is collected.  The\ninterface identified by a particular value of this\nobject is the same interface as identified by the\nsame value of the ifIndex object, defined in MIB-\nII [3].")
ringStationControlTableSize = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlTableSize.setDescription("The number of ringStationEntries in the\nringStationTable associated with this\nringStationControlEntry.")
ringStationControlActiveStations = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 3), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlActiveStations.setDescription("The number of active ringStationEntries in the\nringStationTable associated with this\nringStationControlEntry.")
ringStationControlRingState = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(3,5,2,7,4,6,1,)).subtype(namedValues=namedval.NamedValues(("normalOperation", 1), ("ringPurgeState", 2), ("claimTokenState", 3), ("beaconFrameStreamingState", 4), ("beaconBitStreamingState", 5), ("beaconRingSignalLossState", 6), ("beaconSetRecoveryModeState", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlRingState.setDescription("The current status of this ring.")
ringStationControlBeaconSender = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 5), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlBeaconSender.setDescription("The address of the sender of the last beacon\nframe received by the probe on this ring.  If no\nbeacon frames have been received, this object\nshall be equal to six octets of zero.")
ringStationControlBeaconNAUN = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 6), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlBeaconNAUN.setDescription("The address of the NAUN in the last beacon frame\nreceived by the probe on this ring.  If no beacon\nframes have been received, this object shall be\nequal to six octets of zero.")
ringStationControlActiveMonitor = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 7), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlActiveMonitor.setDescription("The address of the Active Monitor on this\nsegment.  If this address is unknown, this object\nshall be equal to six octets of zero.")
ringStationControlOrderChanges = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationControlOrderChanges.setDescription("The number of add and delete events in the\nringStationOrderTable optionally associated with\nthis ringStationControlEntry.")
ringStationControlOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 9), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ringStationControlOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
ringStationControlStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 1, 1, 10), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ringStationControlStatus.setDescription("The status of this ringStationControl entry.\n\nIf this object is not equal to valid(1), all\nassociated entries in the ringStationTable shall\nbe deleted by the agent.")
ringStationTable = MibTable((1, 3, 6, 1, 2, 1, 16, 10, 2))
if mibBuilder.loadTexts: ringStationTable.setDescription("A list of ring station entries.  An entry will\nexist for each station that is now or has\npreviously been detected as physically present on\nthis ring.")
ringStationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 10, 2, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "ringStationIfIndex"), (0, "TOKEN-RING-RMON-MIB", "ringStationMacAddress"))
if mibBuilder.loadTexts: ringStationEntry.setDescription("A collection of statistics for a particular\nstation that has been discovered on a ring\nmonitored by this device.")
ringStationIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device\non which this station was detected.  The interface\nidentified by a particular value of this object is\nthe same interface as identified by the same value\nof the ifIndex object, defined in MIB-II [3].")
ringStationMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationMacAddress.setDescription("The physical address of this station.")
ringStationLastNAUN = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 3), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationLastNAUN.setDescription("The physical address of last known NAUN of this\nstation.")
ringStationStationStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,3,2,)).subtype(namedValues=namedval.NamedValues(("active", 1), ("inactive", 2), ("forcedRemoval", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationStationStatus.setDescription("The status of this station on the ring.")
ringStationLastEnterTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationLastEnterTime.setDescription("The value of sysUpTime at the time this station\nlast entered the ring.  If the time is unknown,\nthis value shall be zero.")
ringStationLastExitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationLastExitTime.setDescription("The value of sysUpTime at the time the probe\ndetected that this station last exited the ring.\nIf the time is unknown, this value shall be zero.")
ringStationDuplicateAddresses = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationDuplicateAddresses.setDescription("The number of times this station experienced a\nduplicate address error.")
ringStationInLineErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationInLineErrors.setDescription("The total number of line errors reported by this\nstation in error reporting packets detected by the\nprobe.")
ringStationOutLineErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationOutLineErrors.setDescription("The total number of line errors reported in error\nreporting packets sent by the nearest active\ndownstream neighbor of this station and detected\nby the probe.")
ringStationInternalErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationInternalErrors.setDescription("The total number of adapter internal errors\nreported by this station in error reporting\npackets detected by the probe.")
ringStationInBurstErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationInBurstErrors.setDescription("The total number of burst errors reported by this\nstation in error reporting packets detected by the\nprobe.")
ringStationOutBurstErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationOutBurstErrors.setDescription("The total number of burst errors reported in\nerror reporting packets sent by the nearest active\ndownstream neighbor of this station and detected\nby the probe.")
ringStationACErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationACErrors.setDescription("The total number of AC (Address Copied) errors\nreported in error reporting packets sent by the\nnearest active downstream neighbor of this station\nand detected by the probe.")
ringStationAbortErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationAbortErrors.setDescription("The total number of abort delimiters reported by\nthis station in error reporting packets detected\nby the probe.")
ringStationLostFrameErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationLostFrameErrors.setDescription("The total number of lost frame errors reported by\nthis station in error reporting packets detected\nby the probe.")
ringStationCongestionErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationCongestionErrors.setDescription("The total number of receive congestion errors\nreported by this station in error reporting\npackets detected by the probe.")
ringStationFrameCopiedErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationFrameCopiedErrors.setDescription("The total number of frame copied errors reported\nby this station in error reporting packets\ndetected by the probe.")
ringStationFrequencyErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationFrequencyErrors.setDescription("The total number of frequency errors reported by\nthis station in error reporting packets detected\nby the probe.")
ringStationTokenErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationTokenErrors.setDescription("The total number of token errors reported by this\nstation in error reporting frames detected by the\nprobe.")
ringStationInBeaconErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationInBeaconErrors.setDescription("The total number of beacon frames sent by this\nstation and detected by the probe.")
ringStationOutBeaconErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationOutBeaconErrors.setDescription("The total number of beacon frames detected by the\nprobe that name this station as the NAUN.")
ringStationInsertions = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 2, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationInsertions.setDescription("The number of times the probe detected this\nstation inserting onto the ring.")
ringStationOrderTable = MibTable((1, 3, 6, 1, 2, 1, 16, 10, 3))
if mibBuilder.loadTexts: ringStationOrderTable.setDescription("A list of ring station entries for stations in\nthe ring poll, ordered by their ring-order.")
ringStationOrderEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 10, 3, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "ringStationOrderIfIndex"), (0, "TOKEN-RING-RMON-MIB", "ringStationOrderOrderIndex"))
if mibBuilder.loadTexts: ringStationOrderEntry.setDescription("A collection of statistics for a particular\nstation that is active on a ring monitored by this\ndevice.  This table will contain information for\nevery interface that has a\nringStationControlStatus equal to valid.")
ringStationOrderIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 3, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationOrderIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device\non which this station was detected.  The interface\nidentified by a particular value of this object is\nthe same interface as identified by the same value\nof the ifIndex object, defined in MIB-II [3].")
ringStationOrderOrderIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 3, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationOrderOrderIndex.setDescription("This index denotes the location of this station\nwith respect to other stations on the ring.  This\nindex is one more than the number of hops\ndownstream that this station is from the rmon\nprobe.  The rmon probe itself gets the value one.")
ringStationOrderMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 3, 1, 3), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationOrderMacAddress.setDescription("The physical address of this station.")
ringStationConfigControlTable = MibTable((1, 3, 6, 1, 2, 1, 16, 10, 4))
if mibBuilder.loadTexts: ringStationConfigControlTable.setDescription("A list of ring station configuration control\nentries.")
ringStationConfigControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 10, 4, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "ringStationConfigControlIfIndex"), (0, "TOKEN-RING-RMON-MIB", "ringStationConfigControlMacAddress"))
if mibBuilder.loadTexts: ringStationConfigControlEntry.setDescription("This entry controls active management of stations\nby the probe.  One entry exists in this table for\neach active station in the ringStationTable.")
ringStationConfigControlIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 4, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigControlIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device\non which this station was detected.  The interface\nidentified by a particular value of this object is\nthe same interface as identified by the same value\nof the ifIndex object, defined in MIB-II [3].")
ringStationConfigControlMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 4, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigControlMacAddress.setDescription("The physical address of this station.")
ringStationConfigControlRemove = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 4, 1, 3), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(2,1,)).subtype(namedValues=namedval.NamedValues(("stable", 1), ("removing", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ringStationConfigControlRemove.setDescription("Setting this object to `removing(2)' causes a\nRemove Station MAC frame to be sent.  The agent\nwill set this object to `stable(1)' after\nprocessing the request.")
ringStationConfigControlUpdateStats = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 4, 1, 4), Integer().subtype(subtypeSpec=constraint.SingleValueConstraint(1,2,)).subtype(namedValues=namedval.NamedValues(("stable", 1), ("updating", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ringStationConfigControlUpdateStats.setDescription("Setting this object to `updating(2)' causes the\nconfiguration information associate with this\nentry to be updated.  The agent will set this\nobject to `stable(1)' after processing the\nrequest.")
ringStationConfigTable = MibTable((1, 3, 6, 1, 2, 1, 16, 10, 5))
if mibBuilder.loadTexts: ringStationConfigTable.setDescription("A list of configuration entries for stations on a\nring monitored by this probe.")
ringStationConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 10, 5, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "ringStationConfigIfIndex"), (0, "TOKEN-RING-RMON-MIB", "ringStationConfigMacAddress"))
if mibBuilder.loadTexts: ringStationConfigEntry.setDescription("A collection of statistics for a particular\nstation that has been discovered on a ring\nmonitored by this probe.")
ringStationConfigIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device\non which this station was detected.  The interface\nidentified by a particular value of this object is\nthe same interface as identified by the same value\nof the ifIndex object, defined in MIB-II [3].")
ringStationConfigMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigMacAddress.setDescription("The physical address of this station.")
ringStationConfigUpdateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 3), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigUpdateTime.setDescription("The value of sysUpTime at the time this\nconfiguration information was last updated\n(completely).")
ringStationConfigLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 4), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigLocation.setDescription("The assigned physical location of this station.")
ringStationConfigMicrocode = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 5), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(10, 10)).setFixedLength(10)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigMicrocode.setDescription("The microcode EC level of this station.")
ringStationConfigGroupAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 6), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigGroupAddress.setDescription("The low-order 4 octets of the group address\nrecognized by this station.")
ringStationConfigFunctionalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 5, 1, 7), OctetString().subtype(subtypeSpec=constraint.ValueSizeConstraint(4, 4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ringStationConfigFunctionalAddress.setDescription("the functional addresses recognized by this\nstation.")
sourceRoutingStatsTable = MibTable((1, 3, 6, 1, 2, 1, 16, 10, 6))
if mibBuilder.loadTexts: sourceRoutingStatsTable.setDescription("A list of source routing statistics entries.")
sourceRoutingStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 10, 6, 1)).setIndexNames((0, "TOKEN-RING-RMON-MIB", "sourceRoutingStatsIfIndex"))
if mibBuilder.loadTexts: sourceRoutingStatsEntry.setDescription("A collection of source routing statistics kept\nfor a particular Token Ring interface.")
sourceRoutingStatsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsIfIndex.setDescription("The value of this object uniquely identifies the\ninterface on this remote network monitoring device\non which source routing statistics will be\ndetected.  The interface identified by a\nparticular value of this object is the same\ninterface as identified by the same value of the\nifIndex object, defined in MIB-II [3].")
sourceRoutingStatsRingNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 2), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsRingNumber.setDescription("The ring number of the ring monitored by this\nentry.  When any object in this entry is created,\nthe probe will attempt to discover the ring\nnumber.  Only after the ring number is discovered\nwill this object be created.  After creating an\nobject in this entry, the management station\nshould poll this object to detect when it is\ncreated.  Only after this object is created can\nthe management station set the\nsourceRoutingStatsStatus entry to valid(1).")
sourceRoutingStatsInFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsInFrames.setDescription("The count of frames sent into this ring from\nanother ring.")
sourceRoutingStatsOutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsOutFrames.setDescription("The count of frames sent from this ring to\nanother ring.")
sourceRoutingStatsThroughFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsThroughFrames.setDescription("The count of frames sent from another ring,\nthrough this ring, to another ring.")
sourceRoutingStatsAllRoutesBroadcastFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsAllRoutesBroadcastFrames.setDescription("The total number of good frames received that\nwere All Routes Broadcast.")
sourceRoutingStatsSingleRouteBroadcastFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsSingleRouteBroadcastFrames.setDescription("The total number of good frames received that\nwere Single Route Broadcast.")
sourceRoutingStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsInOctets.setDescription("The count of octets in good frames sent into this\nring from another ring.")
sourceRoutingStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsOutOctets.setDescription("The count of octets in good frames sent from this\nring to another ring.")
sourceRoutingStatsThroughOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsThroughOctets.setDescription("The count of octets in good frames sent another\nring, through this ring, to another ring.")
sourceRoutingStatsAllRoutesBroadcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsAllRoutesBroadcastOctets.setDescription("The total number of octets in good frames\nreceived that were All Routes Broadcast.")
sourceRoutingStatsSingleRoutesBroadcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsSingleRoutesBroadcastOctets.setDescription("The total number of octets in good frames\nreceived that were Single Route Broadcast.")
sourceRoutingStatsLocalLLCFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsLocalLLCFrames.setDescription("The total number of frames received who had no\nRIF field (or had a RIF field that only included\nthe local ring's number) and were not All Route\nBroadcast Frames.")
sourceRoutingStats1HopFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats1HopFrames.setDescription("The total number of frames received whose route\nhad 1 hop, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats2HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats2HopsFrames.setDescription("The total number of frames received whose route\nhad 2 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats3HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats3HopsFrames.setDescription("The total number of frames received whose route\nhad 3 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats4HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats4HopsFrames.setDescription("The total number of frames received whose route\nhad 4 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats5HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats5HopsFrames.setDescription("The total number of frames received whose route\nhad 5 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats6HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats6HopsFrames.setDescription("The total number of frames received whose route\nhad 6 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats7HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats7HopsFrames.setDescription("The total number of frames received whose route\nhad 7 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStats8HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStats8HopsFrames.setDescription("The total number of frames received whose route\nhad 8 hops, were not All Route Broadcast Frames,\nand whose source or destination were on this ring\n(i.e. frames that had a RIF field and had this\nring number in the first or last entry of the RIF\nfield).")
sourceRoutingStatsMoreThan8HopsFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sourceRoutingStatsMoreThan8HopsFrames.setDescription("The total number of frames received whose route\nhad more than 8 hops, were not All Route Broadcast\nFrames, and whose source or destination were on\nthis ring (i.e. frames that had a RIF field and\nhad this ring number in the first or last entry of\nthe RIF field).")
sourceRoutingStatsOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 23), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sourceRoutingStatsOwner.setDescription("The entity that configured this entry and is\ntherefore using the resources assigned to it.")
sourceRoutingStatsStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 10, 6, 1, 24), EntryStatus()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sourceRoutingStatsStatus.setDescription("The status of this sourceRoutingStats entry.")

# Augmentions

# Exports

# Types
mibBuilder.exportSymbols("TOKEN-RING-RMON-MIB", MacAddress=MacAddress, TimeInterval=TimeInterval)

# Objects
mibBuilder.exportSymbols("TOKEN-RING-RMON-MIB", tokenRingMLStatsTable=tokenRingMLStatsTable, tokenRingMLStatsEntry=tokenRingMLStatsEntry, tokenRingMLStatsIndex=tokenRingMLStatsIndex, tokenRingMLStatsDataSource=tokenRingMLStatsDataSource, tokenRingMLStatsDropEvents=tokenRingMLStatsDropEvents, tokenRingMLStatsMacOctets=tokenRingMLStatsMacOctets, tokenRingMLStatsMacPkts=tokenRingMLStatsMacPkts, tokenRingMLStatsRingPurgeEvents=tokenRingMLStatsRingPurgeEvents, tokenRingMLStatsRingPurgePkts=tokenRingMLStatsRingPurgePkts, tokenRingMLStatsBeaconEvents=tokenRingMLStatsBeaconEvents, tokenRingMLStatsBeaconTime=tokenRingMLStatsBeaconTime, tokenRingMLStatsBeaconPkts=tokenRingMLStatsBeaconPkts, tokenRingMLStatsClaimTokenEvents=tokenRingMLStatsClaimTokenEvents, tokenRingMLStatsClaimTokenPkts=tokenRingMLStatsClaimTokenPkts, tokenRingMLStatsNAUNChanges=tokenRingMLStatsNAUNChanges, tokenRingMLStatsLineErrors=tokenRingMLStatsLineErrors, tokenRingMLStatsInternalErrors=tokenRingMLStatsInternalErrors, tokenRingMLStatsBurstErrors=tokenRingMLStatsBurstErrors, tokenRingMLStatsACErrors=tokenRingMLStatsACErrors, tokenRingMLStatsAbortErrors=tokenRingMLStatsAbortErrors, tokenRingMLStatsLostFrameErrors=tokenRingMLStatsLostFrameErrors, tokenRingMLStatsCongestionErrors=tokenRingMLStatsCongestionErrors, tokenRingMLStatsFrameCopiedErrors=tokenRingMLStatsFrameCopiedErrors, tokenRingMLStatsFrequencyErrors=tokenRingMLStatsFrequencyErrors, tokenRingMLStatsTokenErrors=tokenRingMLStatsTokenErrors, tokenRingMLStatsSoftErrorReports=tokenRingMLStatsSoftErrorReports, tokenRingMLStatsRingPollEvents=tokenRingMLStatsRingPollEvents, tokenRingMLStatsOwner=tokenRingMLStatsOwner, tokenRingMLStatsStatus=tokenRingMLStatsStatus, tokenRingPStatsTable=tokenRingPStatsTable, tokenRingPStatsEntry=tokenRingPStatsEntry, tokenRingPStatsIndex=tokenRingPStatsIndex, tokenRingPStatsDataSource=tokenRingPStatsDataSource, tokenRingPStatsDropEvents=tokenRingPStatsDropEvents, tokenRingPStatsDataOctets=tokenRingPStatsDataOctets, tokenRingPStatsDataPkts=tokenRingPStatsDataPkts, tokenRingPStatsDataBroadcastPkts=tokenRingPStatsDataBroadcastPkts, tokenRingPStatsDataMulticastPkts=tokenRingPStatsDataMulticastPkts, tokenRingPStatsDataPkts18to63Octets=tokenRingPStatsDataPkts18to63Octets, tokenRingPStatsDataPkts64to127Octets=tokenRingPStatsDataPkts64to127Octets, tokenRingPStatsDataPkts128to255Octets=tokenRingPStatsDataPkts128to255Octets, tokenRingPStatsDataPkts256to511Octets=tokenRingPStatsDataPkts256to511Octets, tokenRingPStatsDataPkts512to1023Octets=tokenRingPStatsDataPkts512to1023Octets, tokenRingPStatsDataPkts1024to2047Octets=tokenRingPStatsDataPkts1024to2047Octets, tokenRingPStatsDataPkts2048to4095Octets=tokenRingPStatsDataPkts2048to4095Octets, tokenRingPStatsDataPkts4096to8191Octets=tokenRingPStatsDataPkts4096to8191Octets, tokenRingPStatsDataPkts8192to18000Octets=tokenRingPStatsDataPkts8192to18000Octets, tokenRingPStatsDataPktsGreaterThan18000Octets=tokenRingPStatsDataPktsGreaterThan18000Octets, tokenRingPStatsOwner=tokenRingPStatsOwner, tokenRingPStatsStatus=tokenRingPStatsStatus, tokenRingMLHistoryTable=tokenRingMLHistoryTable, tokenRingMLHistoryEntry=tokenRingMLHistoryEntry, tokenRingMLHistoryIndex=tokenRingMLHistoryIndex, tokenRingMLHistorySampleIndex=tokenRingMLHistorySampleIndex, tokenRingMLHistoryIntervalStart=tokenRingMLHistoryIntervalStart, tokenRingMLHistoryDropEvents=tokenRingMLHistoryDropEvents, tokenRingMLHistoryMacOctets=tokenRingMLHistoryMacOctets, tokenRingMLHistoryMacPkts=tokenRingMLHistoryMacPkts, tokenRingMLHistoryRingPurgeEvents=tokenRingMLHistoryRingPurgeEvents, tokenRingMLHistoryRingPurgePkts=tokenRingMLHistoryRingPurgePkts, tokenRingMLHistoryBeaconEvents=tokenRingMLHistoryBeaconEvents, tokenRingMLHistoryBeaconTime=tokenRingMLHistoryBeaconTime, tokenRingMLHistoryBeaconPkts=tokenRingMLHistoryBeaconPkts, tokenRingMLHistoryClaimTokenEvents=tokenRingMLHistoryClaimTokenEvents, tokenRingMLHistoryClaimTokenPkts=tokenRingMLHistoryClaimTokenPkts, tokenRingMLHistoryNAUNChanges=tokenRingMLHistoryNAUNChanges, tokenRingMLHistoryLineErrors=tokenRingMLHistoryLineErrors, tokenRingMLHistoryInternalErrors=tokenRingMLHistoryInternalErrors, tokenRingMLHistoryBurstErrors=tokenRingMLHistoryBurstErrors, tokenRingMLHistoryACErrors=tokenRingMLHistoryACErrors, tokenRingMLHistoryAbortErrors=tokenRingMLHistoryAbortErrors, tokenRingMLHistoryLostFrameErrors=tokenRingMLHistoryLostFrameErrors, tokenRingMLHistoryCongestionErrors=tokenRingMLHistoryCongestionErrors, tokenRingMLHistoryFrameCopiedErrors=tokenRingMLHistoryFrameCopiedErrors, tokenRingMLHistoryFrequencyErrors=tokenRingMLHistoryFrequencyErrors, tokenRingMLHistoryTokenErrors=tokenRingMLHistoryTokenErrors, tokenRingMLHistorySoftErrorReports=tokenRingMLHistorySoftErrorReports, tokenRingMLHistoryRingPollEvents=tokenRingMLHistoryRingPollEvents, tokenRingMLHistoryActiveStations=tokenRingMLHistoryActiveStations, tokenRingPHistoryTable=tokenRingPHistoryTable, tokenRingPHistoryEntry=tokenRingPHistoryEntry, tokenRingPHistoryIndex=tokenRingPHistoryIndex, tokenRingPHistorySampleIndex=tokenRingPHistorySampleIndex, tokenRingPHistoryIntervalStart=tokenRingPHistoryIntervalStart, tokenRingPHistoryDropEvents=tokenRingPHistoryDropEvents, tokenRingPHistoryDataOctets=tokenRingPHistoryDataOctets, tokenRingPHistoryDataPkts=tokenRingPHistoryDataPkts, tokenRingPHistoryDataBroadcastPkts=tokenRingPHistoryDataBroadcastPkts, tokenRingPHistoryDataMulticastPkts=tokenRingPHistoryDataMulticastPkts, tokenRingPHistoryDataPkts18to63Octets=tokenRingPHistoryDataPkts18to63Octets, tokenRingPHistoryDataPkts64to127Octets=tokenRingPHistoryDataPkts64to127Octets, tokenRingPHistoryDataPkts128to255Octets=tokenRingPHistoryDataPkts128to255Octets, tokenRingPHistoryDataPkts256to511Octets=tokenRingPHistoryDataPkts256to511Octets, tokenRingPHistoryDataPkts512to1023Octets=tokenRingPHistoryDataPkts512to1023Octets, tokenRingPHistoryDataPkts1024to2047Octets=tokenRingPHistoryDataPkts1024to2047Octets, tokenRingPHistoryDataPkts2048to4095Octets=tokenRingPHistoryDataPkts2048to4095Octets, tokenRingPHistoryDataPkts4096to8191Octets=tokenRingPHistoryDataPkts4096to8191Octets, tokenRingPHistoryDataPkts8192to18000Octets=tokenRingPHistoryDataPkts8192to18000Octets, tokenRingPHistoryDataPktsGreaterThan18000Octets=tokenRingPHistoryDataPktsGreaterThan18000Octets, tokenRing=tokenRing, ringStationControlTable=ringStationControlTable, ringStationControlEntry=ringStationControlEntry, ringStationControlIfIndex=ringStationControlIfIndex, ringStationControlTableSize=ringStationControlTableSize, ringStationControlActiveStations=ringStationControlActiveStations, ringStationControlRingState=ringStationControlRingState, ringStationControlBeaconSender=ringStationControlBeaconSender, ringStationControlBeaconNAUN=ringStationControlBeaconNAUN, ringStationControlActiveMonitor=ringStationControlActiveMonitor, ringStationControlOrderChanges=ringStationControlOrderChanges, ringStationControlOwner=ringStationControlOwner, ringStationControlStatus=ringStationControlStatus, ringStationTable=ringStationTable, ringStationEntry=ringStationEntry, ringStationIfIndex=ringStationIfIndex, ringStationMacAddress=ringStationMacAddress, ringStationLastNAUN=ringStationLastNAUN, ringStationStationStatus=ringStationStationStatus, ringStationLastEnterTime=ringStationLastEnterTime, ringStationLastExitTime=ringStationLastExitTime, ringStationDuplicateAddresses=ringStationDuplicateAddresses, ringStationInLineErrors=ringStationInLineErrors, ringStationOutLineErrors=ringStationOutLineErrors, ringStationInternalErrors=ringStationInternalErrors, ringStationInBurstErrors=ringStationInBurstErrors, ringStationOutBurstErrors=ringStationOutBurstErrors)
mibBuilder.exportSymbols("TOKEN-RING-RMON-MIB", ringStationACErrors=ringStationACErrors, ringStationAbortErrors=ringStationAbortErrors, ringStationLostFrameErrors=ringStationLostFrameErrors, ringStationCongestionErrors=ringStationCongestionErrors, ringStationFrameCopiedErrors=ringStationFrameCopiedErrors, ringStationFrequencyErrors=ringStationFrequencyErrors, ringStationTokenErrors=ringStationTokenErrors, ringStationInBeaconErrors=ringStationInBeaconErrors, ringStationOutBeaconErrors=ringStationOutBeaconErrors, ringStationInsertions=ringStationInsertions, ringStationOrderTable=ringStationOrderTable, ringStationOrderEntry=ringStationOrderEntry, ringStationOrderIfIndex=ringStationOrderIfIndex, ringStationOrderOrderIndex=ringStationOrderOrderIndex, ringStationOrderMacAddress=ringStationOrderMacAddress, ringStationConfigControlTable=ringStationConfigControlTable, ringStationConfigControlEntry=ringStationConfigControlEntry, ringStationConfigControlIfIndex=ringStationConfigControlIfIndex, ringStationConfigControlMacAddress=ringStationConfigControlMacAddress, ringStationConfigControlRemove=ringStationConfigControlRemove, ringStationConfigControlUpdateStats=ringStationConfigControlUpdateStats, ringStationConfigTable=ringStationConfigTable, ringStationConfigEntry=ringStationConfigEntry, ringStationConfigIfIndex=ringStationConfigIfIndex, ringStationConfigMacAddress=ringStationConfigMacAddress, ringStationConfigUpdateTime=ringStationConfigUpdateTime, ringStationConfigLocation=ringStationConfigLocation, ringStationConfigMicrocode=ringStationConfigMicrocode, ringStationConfigGroupAddress=ringStationConfigGroupAddress, ringStationConfigFunctionalAddress=ringStationConfigFunctionalAddress, sourceRoutingStatsTable=sourceRoutingStatsTable, sourceRoutingStatsEntry=sourceRoutingStatsEntry, sourceRoutingStatsIfIndex=sourceRoutingStatsIfIndex, sourceRoutingStatsRingNumber=sourceRoutingStatsRingNumber, sourceRoutingStatsInFrames=sourceRoutingStatsInFrames, sourceRoutingStatsOutFrames=sourceRoutingStatsOutFrames, sourceRoutingStatsThroughFrames=sourceRoutingStatsThroughFrames, sourceRoutingStatsAllRoutesBroadcastFrames=sourceRoutingStatsAllRoutesBroadcastFrames, sourceRoutingStatsSingleRouteBroadcastFrames=sourceRoutingStatsSingleRouteBroadcastFrames, sourceRoutingStatsInOctets=sourceRoutingStatsInOctets, sourceRoutingStatsOutOctets=sourceRoutingStatsOutOctets, sourceRoutingStatsThroughOctets=sourceRoutingStatsThroughOctets, sourceRoutingStatsAllRoutesBroadcastOctets=sourceRoutingStatsAllRoutesBroadcastOctets, sourceRoutingStatsSingleRoutesBroadcastOctets=sourceRoutingStatsSingleRoutesBroadcastOctets, sourceRoutingStatsLocalLLCFrames=sourceRoutingStatsLocalLLCFrames, sourceRoutingStats1HopFrames=sourceRoutingStats1HopFrames, sourceRoutingStats2HopsFrames=sourceRoutingStats2HopsFrames, sourceRoutingStats3HopsFrames=sourceRoutingStats3HopsFrames, sourceRoutingStats4HopsFrames=sourceRoutingStats4HopsFrames, sourceRoutingStats5HopsFrames=sourceRoutingStats5HopsFrames, sourceRoutingStats6HopsFrames=sourceRoutingStats6HopsFrames, sourceRoutingStats7HopsFrames=sourceRoutingStats7HopsFrames, sourceRoutingStats8HopsFrames=sourceRoutingStats8HopsFrames, sourceRoutingStatsMoreThan8HopsFrames=sourceRoutingStatsMoreThan8HopsFrames, sourceRoutingStatsOwner=sourceRoutingStatsOwner, sourceRoutingStatsStatus=sourceRoutingStatsStatus)

