# PySNMP SMI module. Autogenerated from smidump -f python UDPLITE-MIB
# by libsmi2pysnmp-0.1.1 at Sun Nov  6 01:16:23 2011,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imported just in case new ASN.1 types would be created
from pyasn1.type import constraint, namedval

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "TimeStamp")

# Objects

udpliteMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 170)).setRevisions(("2007-12-18 00:00",))
if mibBuilder.loadTexts: udpliteMIB.setOrganization("IETF TSV Working Group (TSVWG)")
if mibBuilder.loadTexts: udpliteMIB.setContactInfo("IETF TSV Working Group\nhttp://www.ietf.org/html.charters/tsvwg-charter.html\nMailing List: tsvwg@ietf.org\n\n\n\n\nGerrit Renker, Godred Fairhurst\nElectronics Research Group\nSchool of Engineering, University of Aberdeen\nFraser Noble Building, Aberdeen AB24 3UE, UK")
if mibBuilder.loadTexts: udpliteMIB.setDescription("The MIB module for managing UDP-Lite implementations.\nCopyright (C) The IETF Trust (2008).  This version of\nthis MIB module is part of RFC 5097; see the RFC\nitself for full legal notices.")
udplite = MibIdentifier((1, 3, 6, 1, 2, 1, 170, 1))
udpliteInDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 1), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInDatagrams.setDescription("The total number of UDP-Lite datagrams that were\ndelivered to UDP-Lite users.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteInPartialCov = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 2), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInPartialCov.setDescription("The total number of UDP-Lite datagrams that were\ndelivered to UDP-Lite users (applications) and whose\nchecksum coverage was strictly less than the datagram\nlength.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteNoPorts = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteNoPorts.setDescription("The total number of received UDP-Lite datagrams for\nwhich there was no listener at the destination port.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteInErrors = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInErrors.setDescription("The number of received UDP-Lite datagrams that could not\nbe delivered for reasons other than the lack of an\napplication at the destination port.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteInBadChecksum = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteInBadChecksum.setDescription("The number of received UDP-Lite datagrams whose checksum\ncould not be validated.  This includes illegal checksum\ncoverage values, as their use would lead to incorrect\nchecksums.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteOutDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteOutDatagrams.setDescription("The total number of UDP-Lite datagrams sent from this\nentity.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteOutPartialCov = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteOutPartialCov.setDescription("The total number of udpliteOutDatagrams whose\nchecksum coverage was strictly less than the\ndatagram length.\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteEndpointTable = MibTable((1, 3, 6, 1, 2, 1, 170, 1, 8))
if mibBuilder.loadTexts: udpliteEndpointTable.setDescription("A table containing information about this entity's\nUDP-Lite endpoints on which a local application is\ncurrently accepting or sending datagrams.\n\nThe address type in this table represents the address\ntype used for the communication, irrespective of the\nhigher-layer abstraction.  For example, an application\nusing IPv6 'sockets' to communicate via IPv4 between\n::ffff:10.0.0.1 and ::ffff:10.0.0.2 would use\nInetAddressType ipv4(1).\n\nLike the udpTable in RFC 4113, this table also allows\nthe representation of an application that completely\nspecifies both local and remote addresses and ports.  A\nlistening application is represented in three possible\nways:\n\n1) An application that is willing to accept both IPv4\n   and IPv6 datagrams is represented by a\n   udpliteEndpointLocalAddressType of unknown(0) and a\n   udpliteEndpointLocalAddress of ''h (a zero-length\n\n\n\n   octet-string).\n\n2) An application that is willing to accept only IPv4\n   or only IPv6 datagrams is represented by a\n   udpliteEndpointLocalAddressType of the appropriate\n   address type and a udpliteEndpointLocalAddress of\n   '0.0.0.0' or '::' respectively.\n\n3) An application that is listening for datagrams only\n   for a specific IP address but from any remote\n   system is represented by a\n   udpliteEndpointLocalAddressType of the appropriate\n   address type, with udpliteEndpointLocalAddress\n   specifying the local address.\n\nIn all cases where the remote address is a wildcard,\nthe udpliteEndpointRemoteAddressType is unknown(0),\nthe udpliteEndpointRemoteAddress is ''h (a zero-length\noctet-string), and the udpliteEndpointRemotePort is 0.\n\nIf the operating system is demultiplexing UDP-Lite\npackets by remote address/port, or if the application\nhas 'connected' the socket specifying a default remote\naddress/port, the udpliteEndpointRemote* values should\nbe used to reflect this.")
udpliteEndpointEntry = MibTableRow((1, 3, 6, 1, 2, 1, 170, 1, 8, 1)).setIndexNames((0, "UDPLITE-MIB", "udpliteEndpointLocalAddressType"), (0, "UDPLITE-MIB", "udpliteEndpointLocalAddress"), (0, "UDPLITE-MIB", "udpliteEndpointLocalPort"), (0, "UDPLITE-MIB", "udpliteEndpointRemoteAddressType"), (0, "UDPLITE-MIB", "udpliteEndpointRemoteAddress"), (0, "UDPLITE-MIB", "udpliteEndpointRemotePort"), (0, "UDPLITE-MIB", "udpliteEndpointInstance"))
if mibBuilder.loadTexts: udpliteEndpointEntry.setDescription("Information about a particular current UDP-Lite endpoint.\nImplementers need to pay attention to the sizes of\nudpliteEndpointLocalAddress/RemoteAddress, as Object\nIdentifiers (OIDs) of column instances in this table must\nhave no more than 128 sub-identifiers in order to remain\n accessible with SNMPv1, SNMPv2c, and SNMPv3.")
udpliteEndpointLocalAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointLocalAddressType.setDescription("The address type of udpliteEndpointLocalAddress.  Only\nIPv4, IPv4z, IPv6, and IPv6z addresses are expected, or\nunknown(0) if datagrams for all local IP addresses are\naccepted.")
udpliteEndpointLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointLocalAddress.setDescription("The local IP address for this UDP-Lite endpoint.\n\nThe value of this object can be represented in three\npossible ways, depending on the characteristics of the\nlistening application:\n\n1. For an application that is willing to accept both\n   IPv4 and IPv6 datagrams, the value of this object\n   must be ''h (a zero-length octet-string), with\n   the value of the corresponding instance of the\n   EndpointLocalAddressType object being unknown(0).\n\n2. For an application that is willing to accept only\n   IPv4 or only IPv6 datagrams, the value of this\n   object must be '0.0.0.0' or '::', respectively,\n   while the corresponding instance of the\n   EndpointLocalAddressType object represents the\n   appropriate address type.\n\n3. For an application that is listening for data\n\n\n\n   destined only to a specific IP address, the value\n   of this object is the specific IP address for\n   which this node is receiving packets, with the\n   corresponding instance of the\n   EndpointLocalAddressType object representing the\n   appropriate address type.\n\nAs this object is used in the index for the\nudpliteEndpointTable, implementors should be careful\nnot to create entries that would result in OIDs with\nmore than 128 sub-identifiers; this is because of SNMP\nand SMI limitations.")
udpliteEndpointLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 3), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointLocalPort.setDescription("The local port number for this UDP-Lite endpoint.")
udpliteEndpointRemoteAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 4), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointRemoteAddressType.setDescription("The address type of udpliteEndpointRemoteAddress.  Only\nIPv4, IPv4z, IPv6, and IPv6z addresses are expected, or\nunknown(0) if datagrams for all remote IP addresses are\naccepted.  Also, note that some combinations of\nudpliteEndpointLocalAdressType and\nudpliteEndpointRemoteAddressType are not supported.  In\nparticular, if the value of this object is not\nunknown(0), it is expected to always refer to the\nsame IP version as udpliteEndpointLocalAddressType.")
udpliteEndpointRemoteAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 5), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointRemoteAddress.setDescription("The remote IP address for this UDP-Lite endpoint.  If\ndatagrams from any remote system are to be accepted,\nthis value is ''h (a zero-length octet-string).\nOtherwise, it has the type described by\nudpliteEndpointRemoteAddressType and is the address of\n\n\n\nthe remote system from which datagrams are to be\naccepted (or to which all datagrams will be sent).\n\nAs this object is used in the index for the\nudpliteEndpointTable, implementors should be careful\nnot to create entries that would result in OIDs with\nmore than 128 sub-identifiers; this is because of SNMP\nand SMI limitations.")
udpliteEndpointRemotePort = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 6), InetPortNumber()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointRemotePort.setDescription("The remote port number for this UDP-Lite endpoint.  If\ndatagrams from any remote system are to be accepted,\nthis value is zero.")
udpliteEndpointInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 7), Unsigned32().subtype(subtypeSpec=constraint.ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: udpliteEndpointInstance.setDescription("The instance of this tuple.  This object is used to\ndistinguish among multiple processes 'connected' to\nthe same UDP-Lite endpoint.  For example, on a system\nimplementing the BSD sockets interface, this would be\nused to support the SO_REUSEADDR and SO_REUSEPORT\nsocket options.")
udpliteEndpointProcess = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteEndpointProcess.setDescription("A unique value corresponding to a piece of software\nrunning on this endpoint.\n\nIf this endpoint is associated with more than one piece\nof software, the agent should choose one of these.  As\nlong as the representative piece of software\nis running and still associated with the endpoint,\nsubsequent reads will consistently return the same\nvalue.  The implementation may use any algorithm\nsatisfying these constraints (e.g., choosing the entity\n\n\n\nwith the oldest start time).\n\nThis identifier is platform-specific.  Wherever possible,\nit should use the system's native, unique identification\nnumber as the value.\n\nIf the SYSAPPL-MIB module is available, the value should\nbe the same as sysApplElmtRunIndex.  If not available, an\nalternative should be used (e.g., the hrSWRunIndex of the\nHOST-RESOURCES-MIB module).\n\nIf it is not possible to uniquely identify the pieces of\nsoftware associated with this endpoint, then the value\nzero should be used.  (Note that zero is otherwise a\nvalid value for sysApplElmtRunIndex.)")
udpliteEndpointMinCoverage = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteEndpointMinCoverage.setDescription("The minimum checksum coverage expected by this endpoint.\nA value of 0 indicates that only fully covered datagrams\nare accepted.")
udpliteEndpointViolCoverage = MibTableColumn((1, 3, 6, 1, 2, 1, 170, 1, 8, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteEndpointViolCoverage.setDescription("The number of datagrams received by this endpoint whose\nchecksum coverage violated the minimum coverage threshold\nset for this connection (i.e., all valid datagrams whose\nchecksum coverage was strictly smaller than the minimum,\nas defined in RFC 3828).\nDiscontinuities in the value of this counter can occur\nat re-initialisation of the management system, and at\nother times as indicated by the value of\nudpliteStatsDiscontinuityTime.")
udpliteStatsDiscontinuityTime = MibScalar((1, 3, 6, 1, 2, 1, 170, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: udpliteStatsDiscontinuityTime.setDescription("The value of sysUpTime at the most recent occasion at\nwhich one or more of the UDP-Lite counters suffered a\ndiscontinuity.\nA value of zero indicates no such discontinuity has\noccurred since the last re-initialisation of the local\nmanagement subsystem.")
udpliteMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 170, 2))
udpliteMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 170, 2, 2))

# Augmentions

# Groups

udpliteBaseGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 1)).setObjects(("UDPLITE-MIB", "udpliteNoPorts"), ("UDPLITE-MIB", "udpliteStatsDiscontinuityTime"), ("UDPLITE-MIB", "udpliteInErrors"), ("UDPLITE-MIB", "udpliteInDatagrams"), ("UDPLITE-MIB", "udpliteOutDatagrams"), )
if mibBuilder.loadTexts: udpliteBaseGroup.setDescription("The group of objects providing for counters of\nbasic UDP-like statistics.")
udplitePartialCsumGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 2)).setObjects(("UDPLITE-MIB", "udpliteInBadChecksum"), ("UDPLITE-MIB", "udpliteInPartialCov"), ("UDPLITE-MIB", "udpliteOutPartialCov"), )
if mibBuilder.loadTexts: udplitePartialCsumGroup.setDescription("The group of objects providing for counters of\ntransport layer statistics exclusive to UDP-Lite.")
udpliteEndpointGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 3)).setObjects(("UDPLITE-MIB", "udpliteEndpointProcess"), ("UDPLITE-MIB", "udpliteEndpointMinCoverage"), )
if mibBuilder.loadTexts: udpliteEndpointGroup.setDescription("The group of objects providing for the IP version\nindependent management of UDP-Lite 'endpoints'.")
udpliteAppGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 170, 2, 2, 4)).setObjects(("UDPLITE-MIB", "udpliteEndpointViolCoverage"), )
if mibBuilder.loadTexts: udpliteAppGroup.setDescription("The group of objects that provide application-level\ninformation for the configuration management of\nUDP-Lite 'endpoints'.")

# Compliances

udpliteMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 170, 2, 1)).setObjects(("UDPLITE-MIB", "udpliteAppGroup"), ("UDPLITE-MIB", "udpliteEndpointGroup"), ("UDPLITE-MIB", "udplitePartialCsumGroup"), ("UDPLITE-MIB", "udpliteBaseGroup"), )
if mibBuilder.loadTexts: udpliteMIBCompliance.setDescription("The compliance statement for systems that implement\nUDP-Lite.\n\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2,\nbut for which we have the following compliance\nrequirements, expressed in OBJECT clause form in this\ndescription clause:\n\n-- OBJECT      udpliteEndpointLocalAddressType\n-- SYNTAX      InetAddressType { unknown(0), ipv4(1),\n--                               ipv6(2), ipv4z(3),\n--                               ipv6z(4) }\n-- DESCRIPTION\n--     Support for dns(16) is not required.\n-- OBJECT      udpliteEndpointLocalAddress\n-- SYNTAX      InetAddress (SIZE(0|4|8|16|20))\n-- DESCRIPTION\n--     Support is only required for zero-length\n--     octet-strings, and for scoped and unscoped\n--     IPv4 and IPv6 addresses.\n-- OBJECT      udpliteEndpointRemoteAddressType\n-- SYNTAX      InetAddressType { unknown(0), ipv4(1),\n--                               ipv6(2), ipv4z(3),\n--                               ipv6z(4) }\n-- DESCRIPTION\n--     Support for dns(16) is not required.\n-- OBJECT      udpliteEndpointRemoteAddress\n\n\n\n-- SYNTAX      InetAddress (SIZE(0|4|8|16|20))\n-- DESCRIPTION\n--     Support is only required for zero-length\n--     octet-strings, and for scoped and unscoped\n--     IPv4 and IPv6 addresses.")

# Exports

# Module identity
mibBuilder.exportSymbols("UDPLITE-MIB", PYSNMP_MODULE_ID=udpliteMIB)

# Objects
mibBuilder.exportSymbols("UDPLITE-MIB", udpliteMIB=udpliteMIB, udplite=udplite, udpliteInDatagrams=udpliteInDatagrams, udpliteInPartialCov=udpliteInPartialCov, udpliteNoPorts=udpliteNoPorts, udpliteInErrors=udpliteInErrors, udpliteInBadChecksum=udpliteInBadChecksum, udpliteOutDatagrams=udpliteOutDatagrams, udpliteOutPartialCov=udpliteOutPartialCov, udpliteEndpointTable=udpliteEndpointTable, udpliteEndpointEntry=udpliteEndpointEntry, udpliteEndpointLocalAddressType=udpliteEndpointLocalAddressType, udpliteEndpointLocalAddress=udpliteEndpointLocalAddress, udpliteEndpointLocalPort=udpliteEndpointLocalPort, udpliteEndpointRemoteAddressType=udpliteEndpointRemoteAddressType, udpliteEndpointRemoteAddress=udpliteEndpointRemoteAddress, udpliteEndpointRemotePort=udpliteEndpointRemotePort, udpliteEndpointInstance=udpliteEndpointInstance, udpliteEndpointProcess=udpliteEndpointProcess, udpliteEndpointMinCoverage=udpliteEndpointMinCoverage, udpliteEndpointViolCoverage=udpliteEndpointViolCoverage, udpliteStatsDiscontinuityTime=udpliteStatsDiscontinuityTime, udpliteMIBConformance=udpliteMIBConformance, udpliteMIBGroups=udpliteMIBGroups)

# Groups
mibBuilder.exportSymbols("UDPLITE-MIB", udpliteBaseGroup=udpliteBaseGroup, udplitePartialCsumGroup=udplitePartialCsumGroup, udpliteEndpointGroup=udpliteEndpointGroup, udpliteAppGroup=udpliteAppGroup)

# Compliances
mibBuilder.exportSymbols("UDPLITE-MIB", udpliteMIBCompliance=udpliteMIBCompliance)
