try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

config = {
    'name': 'pyspell',
    'version': '0.1.0',
    'author': 'Martin Thoma',
    'author_email': 'info@martin-thoma.de',
    'packages': ['pyspell'],
    'scripts': ['bin/pyspell'],
    # 'package_data': {'pyspell': ['templates/*', 'misc/*']},
    'url': 'https://github.com/MartinThoma/pyspell',
    'license': 'MIT',
    'description': 'Spell checker for different languages and data formats',
    'long_description': """This package should contain scripts to check
                           different data formats like Markdown, TeX and
                           plain text as well as the possibility to
                           check different languages. Tools to build
                           domain-specific language models should be contained
                           as well.""",
    'install_requires': [
        "argparse",
        # "theano",
        # "nose",
        # "natsort",
        # "PyYAML",
        # "matplotlib",
        # "shapely"
    ],
    'keywords': ['spell check', 'language'],
    'download_url': 'https://github.com/MartinThoma/pyspell',
    'classifiers': ['Development Status :: 1 - Planning',
                    'Environment :: Console',
                    'Intended Audience :: Developers',
                    'Intended Audience :: Science/Research',
                    'License :: OSI Approved :: MIT License',
                    'Natural Language :: English',
                    'Programming Language :: Python :: 2.7',
                    'Programming Language :: Python :: 3',
                    'Topic :: Scientific/Engineering :: Artificial Intelligence',
                    'Topic :: Software Development',
                    'Topic :: Utilities'],
    'zip_safe': False,
    'test_suite': 'nose.collector'
}

setup(**config)
